---
title: Contributor Guide
author: Cumulus Networks
weight: 1
cascade:
  siteSlug: contributor-guide
  product: Documentation Contributor Guide
---
Welcome to the Cumulus Networks documentation Contributor Guide!
All of the technical user documentation for [Cumulus Linux](/cumulus-linux/),
[Cumulus NetQ](/cumulus-netq/), [Cumulus VX](/cumulus-vx/) and our other products are now included in a public-facing [GitHub repository](https://github.com/CumulusNetworks/docs). This enables you to provide suggestions for improvements and new content using a GitHub workflow.

This guide explains how to set up a local environment in which to make your suggested changes and how to submit those changes for approval and inclusion in the documentation set.

## Get Started

The first step in providing feedback on the Cumulus Networks documentation is to decide what level of input you want to provide. For smaller issues, like misspellings or broken links, there are several easy options for notifying us. For larger or more complex input, like new topics or restructuring of existing content, it is more efficient to develop the new content locally and submit a pull request through GitHub.

Based on the feedback you want to give:

- Follow the instructions in [Give Simple Feedback](Give-Simple-Feedback) to submit smaller suggestions
- Start by configuring a local setup as described in [Make a Larger Contribution](Make-a-Larger-Contribution) to submit larger suggestions

In either case, please note the *Contributor Covenant Code of Conduct*.

## Contributor Covenant Code of Conduct

### Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to make participation in our documentation project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, sexual characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal
appearance, race, religion, or sexual identity and orientation.

### Our Standards

Examples of behavior that contribute to creating a positive environment
include:

- Using welcoming and inclusive language
- Being respectful of differing viewpoints and experiences
- Gracefully accepting constructive criticism
- Focusing on what is best for the community
- Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

- The use of sexualized language or imagery and unwelcome sexual attention or
  advances
- Trolling, insulting/derogatory comments, and personal or political attacks
- Public or private harassment
- Publishing others' private information, such as a physical or electronic
  address, without explicit permission
- Other conduct which could reasonably be considered inappropriate in a
  professional setting

### Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

### Scope

This Code of Conduct applies within all project spaces, and it also applies when an individual is representing the project or its community in public spaces. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.

### Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at [docs@cumulusnetworks.com](mailto:docs@cumulusnetworks.com). All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

### Attribution

This Code of Conduct is adapted from the [Contributor Covenant Code of Conduct](https://www.contributor-covenant.org), version 1.4, available at https://www.contributor-covenant.org/version/1/4/code-of-conduct.html.

For answers to common questions about this code of conduct, read the
[Contributor Covenant FAQ](https://www.contributor-covenant.org/faq).

## Documentation License

The Cumulus Networks user documentation is [licensed](/license/) under the Creative Commons [Attribution-NonCommercial-ShareAlike 4.0 International](http://github.com/idleberg/Creative-Commons-Markdown/blob/master/4.0/by-nc-sa.markdown) license.
