---
title: 802.1X Interfaces
author: Cumulus Networks
weight: 101
pageID: 8362512
---
The [IEEE 802.1X protocol](https://en.wikipedia.org/wiki/IEEE_802.1X)
provides a method of authenticating a client (called a *supplicant*)
over wired media. It also provides access for individual MAC addresses
on a switch (called the *authenticator*) after those MAC addresses have
been authenticated by an authentication server - typically a
[RADIUS](/cumulus-linux-36/System-Configuration/Authentication-Authorization-and-Accounting/RADIUS-AAA)
(Remote Authentication Dial In User Service, defined by
[RFC 2865](https://tools.ietf.org/html/rfc2865)) server.

A Cumulus Linux switch acts as an intermediary between the clients
connected to the wired ports and the authentication server, which is
reachable over the existing network. EAPOL (Extensible Authentication
Protocol (EAP) over LAN - EtherType value of 0x888E, defined by
[RFC 3748](https://tools.ietf.org/html/rfc3748)) operates on top of the
data link layer; the switch uses EAPOL to communicate with supplicants
connected to the switch ports.

Cumulus Linux implements 802.1X through the Debian `hostapd` package,
which has been modified to provide the PAE (port access entity).

{{% imgOld 0 %}}

## Supported Features and Limitations

  - This feature is supported on 1G Broadcom-based platforms only.
  - The protocol is supported on physical interfaces only
    (bridged/access only and routed interfaces) - such as swp1 or
    swp2s0; these interfaces cannot be part of a bond. However, 802.1X
    is **not** supported on eth0.
  - You can configure 802.1X interfaces for bridges in both 
    [VLAN-aware mode](/cumulus-linux-36/Layer-2/Ethernet-Bridging-VLANs/VLAN-aware-Bridge-Mode)
    and [traditional mode](/cumulus-linux-36/Layer-2/Ethernet-Bridging-VLANs/Traditional-Bridge-Mode)
    using the following features:
      - Parking VLAN
      - Dynamic VLAN
      - MAB (MAC-based authentication bypass)

  - MAB, parking VLAN and dynamic VLAN all require a bridge access port.
  - In traditional bridge mode, parking VLANs and dynamic VLANs both
    require the destination bridge to have a parking VLAN ID or dynamic
    VLAN ID tagged subinterface, respectively.
  - Enabling or disabling the 802.1X capability on ports results in
    `hostapd` reloading. However, existing authorized sessions do not
    get reset.
  - Changing any of the following RADIUS parameters restarts `hostapd`,
    which forces existing, authorized users to re-authenticate:
    
      - The RADIUS server IP address, shared secret, authentication port
        or accounting port
      - Parking VLAN ID
      - MAB activation delay
      - EAP reauthentication period
      - Removing all 802.1X interfaces
        
        {{%notice note%}}
        
Changing the interface dot1x, dot1x mab, or dot1x parking-vlan
        settings do not reset existing authorized user ports.
        
        {{%/notice%}}

  - Up to three RADIUS servers can be configured, for failover purposes.
    
    {{%notice note%}}
    
Do not use a Cumulus Linux switch as the RADIUS server.
    
    {{%/notice%}}

  - This has been tested with only a few `wpa_supplicant` (Debian),
    Windows 10 and Windows 7 supplicants.
  - RADIUS authentication is supported with FreeRADIUS and Cisco ACS.
  - Supports simple login/password, PEAP/MSCHAPv2 (Win7) and EAP-TLS
    (Debian).
  - There is no support for Mako template-based configurations.

## Installing the 802.1X Package

If you upgraded Cumulus Linux from a version earlier than 3.3.0 instead
of performing a full binary install, you need to install the `hostapd`
package on your switch:

    cumulus@switch:~$ sudo -E apt-get update
    cumulus@switch:~$ sudo -E apt-get install hostapd
    cumulus@switch:~$ sudo -E apt-get upgrade

## Configuring 802.1X Interfaces

[NCLU](/cumulus-linux-36/System-Configuration/Network-Command-Line-Utility-NCLU/)
handles all the configuration of 802.1X interfaces, updating `hostapd`
and other components so you don't have to manually modify configuration
files. All the interfaces share the same RADIUS server settings.

The 802.1X-specific settings are:

  - **accounting-port**: RADIUS accounting parameters, which defaults to
    *1813*.
  - **authentication-port**: RADIUS authentication port, which defaults
    to *1812*.
  - **server-ip**: RADIUS Server IPv4 or IPv6 address, which has no
    default, but is required.
  - **shared-secret**: RADIUS shared secret, which has no default, but
    is required.

### Configuring 802.1X Interfaces for a VLAN-aware Bridge

Make sure you configure the RADIUS server before the interfaces. 
[See below](#configuring-the-radius-server) for details.

1.  Create a simple interface bridge configuration on the switch and add
    the switch ports that are members of the bridge. You can use glob
    syntax to add a range of interfaces. The MAB and parking VLAN
    configurations require interfaces to be bridge access ports. The
    VLAN-aware bridge must be named *bridge* and there can be only one
    VLAN-aware bridge on a switch.
    
        cumulus@switch:~$ net add bridge bridge ports swp1-4

2.  Configure the settings for the 802.1X RADIUS server, including its
    IP address and shared secret:
    
        cumulus@switch:~$ net add dot1x radius server-ip 127.0.0.1
        cumulus@switch:~$ net add dot1x radius shared-secret testing123

3.  Enable 802.1X on interfaces, then review and commit the new
    configuration:
    
        cumulus@switch:~$ net add interface swp1-4 dot1x 
        cumulus@switch:~$ net pending
        cumulus@switch:~$ net commit

These commands create the following configuration snippet in the
`/etc/network/interfaces` file:

    cumulus@switch:~$ cat /etc/network/interfaces
     
    ...
     
    auto swp1
    iface swp1
        bridge-learning off
     
    auto swp2
    iface swp2
        bridge-learning off
     
    auto swp3
    iface swp3
        bridge-learning off
     
    auto swp4
    iface swp4
        bridge-learning off
    ...
     
    auto bridge
    iface bridge
        bridge-ports swp1 swp2 swp3 swp4
        bridge-vlan-aware yes

Verify the 802.1X configuration, showing the configuration and its
status:

    cumulus@switch:~$ net show configuration commands | grep dot1x
    dot1x radius server-ip 127.0.0.1
    dot1x radius authentication-port 1812
    dot1x radius accounting-port 1813
    dot1x radius shared-secret testing123
    interface swp2,swp3,swp1,swp4 dot1x
     
    cumulus@switch:~$ net show dot1x status
    IEEE802.1X Enabled Status: enabled
    IEEE802.1X Active Status: active

### Configuring 802.1X Interfaces for a Traditional Mode Bridge

{{%notice note%}}

NCLU and `hostapd` may change traditional mode configurations on the
`bridge-ports` line in `/etc/network/interface` by adding or deleting
special 802.1X traditional mode `bridge-ports` configuration stanzas in
`/etc/network/interfaces.d/`. It is important that the `source`
configuration command in `/etc/network/interfaces` include these special
configuration filenames. It should include at least `source
/etc/network/interfaces.d/*.intf` in order to not prevent these files
from being sourced during an `ifreload`.

{{%/notice%}}

1.  Create some uplink ports. The following example uses bonds:
    
        cumulus@switch:~$ net add bond bond1 bond slaves swp5-6
        cumulus@switch:~$ net add bond bond2 bond slaves swp7-8

2.  Create a traditional mode bridge configuration on the switch and add
    the switch ports that are members of the bridge. Traditional bridge
    cannot be named **** *bridge* as that name is reserved for the
    single VLAN-aware bridge on the switch. You can use glob syntax to
    add a range of interfaces.
    
        cumulus@switch:~$ net add bridge bridge1 ports swp1-4

3.  Create bridge associations with the parking VLAN ID and the dynamic
    VLAN IDs. In this example, *600* is used for the parking VLAN ID and
    700 is used for the dynamic VLAN ID:
    
        cumulus@switch:~$ net add bridge br-vlan600 ports bond1.600
        cumulus@switch:~$ net add bridge br-vlan700 ports bond2.700

4.  Configure the settings for the 802.1X RADIUS server, including its
    IP address and shared secret:
    
        net add dot1x radius server-ip 127.0.0.1
        net add dot1x radius shared-secret testing123 

5.  Enable 802.1X on interfaces, then review and commit the new
    configuration:
    
        cumulus@switch:~$ net add interface swp1-2 dot1x 
        cumulus@switch:~$ net pending
        cumulus@switch:~$ net commit

Verify the 802.1X configuration, showing the configuration and its
status:

    cumulus@switch:~$ net show dot1x status
     
     
    Hostapd IEEE 802.11 AP and IEEE 802.1X/WPA/WPA2/EAP Authenticator Daemon
    Attribute                Value
    -----------------------  ----------------
    Current Status           active (running)
    Reload Status            enabled
    Interfaces               swp1 swp2
    MAB Interfaces
    Parking VLAN Interfaces
    Dynamic VLAN Status      Disabled

    cumulus@switch:~$ net show dot1x interface summary
     
     
    Interface  MAC Address        Username  State       Authentication Type  MAB  VLAN
    ---------  -----------------  --------  ----------  -------------------  ---  ----
    swp1       00:02:00:00:00:01  host1     AUTHORIZED  MD5                  NO
    swp2       00:02:00:00:00:02  host2     AUTHORIZED  MD5                  NO

## Configuring the Linux Supplicants

A sample FreeRADIUS server configuration needs to contain the entries
for users *host1* and *host2* on swp1 and swp2 in order for them to be
placed in a VLAN.

    host1 Cleartext-Password := "host1password"
    host2 Cleartext-Password := "host2password"

Once configured, each supplicant needs the proper credentials:

    user@host1:~# cat /etc/wpa_supplicant.conf
     
     
    ctrl_interface=/var/run/wpa_supplicant
    ctrl_interface_group=0
    eapol_version=2
    ap_scan=0
    network={
            key_mgmt=IEEE8021X
            eap=TTLS MD5
            identity="host1"
            anonymous_identity="host1"
            password="host1password"
            phase1="auth=MD5"
            eapol_flags=0
    }

    user@host2:~# cat /etc/wpa_supplicant.conf
     
     
    ctrl_interface=/var/run/wpa_supplicant
    ctrl_interface_group=0
    eapol_version=2
    ap_scan=0
    network={
            key_mgmt=IEEE8021X
            eap=TTLS MD5
            identity="host2"
            anonymous_identity="host2"
            password="host2password"
            phase1="auth=MD5"
            eapol_flags=0
    }

### Verifying Connections from Linux Supplicants

To test that a supplicant (client) can communicate with the Cumulus Linux Authenticator switch, install the wpasupplicant package:
```
root@radius:~# apt-get update
root@radius:~# apt-get install wpasupplicant
```

And run the following command from the supplicant:

    root@host1:/home/cumulus# wpa_supplicant -c /etc/wpa_supplicant.conf -D wired -i swp1
    Successfully initialized wpa_supplicant
    swp1: Associated with 01:80:c2:00:00:03
    swp1: CTRL-EVENT-EAP-STARTED EAP authentication started
    swp1: CTRL-EVENT-EAP-PROPOSED-METHOD vendor=0 method=4
    swp1: CTRL-EVENT-EAP-METHOD EAP vendor 0 method 4 (MD5) selected
    swp1: CTRL-EVENT-EAP-SUCCESS EAP authentication completed successfully
    swp1: CTRL-EVENT-CONNECTED - Connection to 01:80:c2:00:00:03 compl

Or from another supplicant:

    root@host2:/home/cumulus# wpa_supplicant -c /etc/wpa_supplicant.conf -D wired -i swp1
    Successfully initialized wpa_supplicant
    swp1: Associated with 01:80:c2:00:00:03
    swp1: CTRL-EVENT-EAP-STARTED EAP authentication started
    swp1: CTRL-EVENT-EAP-PROPOSED-METHOD vendor=0 method=4
    swp1: CTRL-EVENT-EAP-METHOD EAP vendor 0 method 4 (MD5) selected
    swp1: CTRL-EVENT-EAP-SUCCESS EAP authentication completed successfully
    swp1: CTRL-EVENT-CONNECTED - Connection to 01:80:c2:00:00:03 comp

## Configuring Accounting and Authentication Ports

You can configure the accounting and authentication ports in Cumulus
Linux. The default values are *1813* for the accounting port and *1812*
for the authentication port.

You can also change the reauthentication period for Extensible
Authentication Protocol (EAP). The period defaults to *0* (no
re-authentication is performed by the switch).

To use different ports, do the following:

    cumulus@switch:~$ net add dot1x radius authentication-port 2812
    cumulus@switch:~$ net add dot1x radius accounting-port 2813
    cumulus@switch:~$ net add dot1x eap-reauth-period 86400
    cumulus@switch:~$ net pending
    cumulus@switch:~$ net commit

## Configuring MAC Authentication Bypass

MAC authentication bypass (MAB) enables bridge ports to allow devices to
bypass authentication based on their MAC address. This is useful for
devices that do not support PAE, such as printers or phones. You can
change the MAB activation delay from the default of 30 seconds, but the
delay must be between 5 and 30 seconds. After the delay limit is
reached, the port enters MAB mode.

When using a VLAN-aware bridge, the switch port must be part of bridge
named *bridge*.

{{%notice note%}}

MAB supports one authenticated MAC address per port only. After a source
MAC address is authenticated, the port exits MAB mode.

{{%/notice%}}

You must configure MAB on the RADIUS server.

To enable a bridge port for MAB and to change the MAB activation delay,
do the following on the RADIUS client (that is, the Cumulus Linux
switch):

    cumulus@switch:~$ net add dot1x mab-activation-delay 20
    cumulus@switch:~$ net add interface swp1 dot1x mab
    cumulus@switch:~$ net pending
    cumulus@switch:~$ net commit

Verify the configuration:

    cumulus@switch:~$ net show dot1x status
     
    Hostapd IEEE 802.11 AP and IEEE 802.1X/WPA/WPA2/EAP Authenticator Daemon
    Attribute                Value
    -----------------------  ----------------
    Current Status           active (running)
    Reload Status            enabled
    Interfaces               swp1 swp2
    MAB Interfaces           swp1
    Parking VLAN Interfaces
    Dynamic VLAN Status      Disabled

    cumulus@switch:~$ net show dot1x interface summary
     
    Interface  MAC Address        Username      State         Authentication Type  MAB  VLAN
    ---------  -----------------  ------------  ------------  -------------------  ---  ----
    swp1       00:02:00:00:00:08  000200000008  AUTHORIZED    unknown              YES

## Configuring a Parking VLAN

If a non-authorized supplicant tries to communicate with the switch, you
can route traffic from that device to a different VLAN and associate
that VLAN with one of the switch ports to which the supplicant is
attached.

For VLAN-aware bridges, the parking VLAN is assigned by manipulating the
PVID of the switch port. For traditional mode bridges, Cumulus Linux
identifies the bridge associated with the parking VLAN ID and moves the
switch port into that bridge. If an appropriate bridge is not found for
the move, then the port remains in an unauthenticated state where no
packets can be received or transmitted.

When using a VLAN-aware bridge, the switch port must be part of bridge
named *bridge*.

    cumulus@switch:~$ net add dot1x parking-vlan-id 777
    cumulus@switch:~$ net add interface swp1 dot1x parking-vlan
    cumulus@switch:~$ net pending
    cumulus@switch:~$ net commit

If the authentication for swp1 fails, the port is moved to the parking
VLAN:

    cumulus@switch:~$ net show dot1x interface swp1 details
     
    Interface  MAC Address        Attribute                     Value
    ---------  -----------------  ----------------------------  -----------------
    swp1       00:02:00:00:00:08  Status Flags                  [PARKED_VLAN]
                                  Username                      vlan60
                                  Authentication Type           MD5
                                  VLAN                          777
                                  Session Time (seconds)        24772
                                  EAPOL Frames RX               9
                                  EAPOL Frames TX               12
                                  EAPOL Start Frames RX         1
                                  EAPOL Logoff Frames RX        0
                                  EAPOL Response ID Frames RX   4
                                  EAPOL Response Frames RX      8
                                  EAPOL Request ID Frames TX    4
                                  EAPOL Request Frames TX       8
                                  EAPOL Invalid Frames RX       0
                                  EAPOL Length Error Frames Rx  0
                                  EAPOL Frame Version           2
                                  EAPOL Auth Last Frame Source  00:02:00:00:00:08
                                  EAPOL Auth Backend Responses  8
                                  RADIUS Auth Session ID        C2FED91A39D8D605

Verify the configuration:

    cumulus@switch:~$ net show dot1x interface summary
     
    Interface  MAC Address        Username      State         Authentication Type  MAB  VLAN
    ---------  -----------------  ------------  ------------  -------------------  ---  ----
    swp1       00:02:00:00:00:08  vlan60        PARKING VLAN  MD5                  NO   777

The following output shows a parking VLAN association failure. VLAN
association failure only occurs with traditional mode bridges when there
is no traditional bridge available with a parking VLAN ID-tagged
subinterface in it (notice the \[UNKNOWN\_BR\] status in the output):

    cumulus@switch:~$ net show dot1x interface swp3 details
     
    Interface  MAC Address        Attribute                     Value
    ---------  -----------------  ----------------------------  -------------------------
    swp1       00:02:00:00:00:08  Status Flags                  [PARKED_VLAN][UNKNOWN_BR]
                                  Username                      vlan60
                                  Authentication Type           MD5
                                  VLAN                          777
                                  Session Time (seconds)        24599
                                  EAPOL Frames RX               3
                                  EAPOL Frames TX               3
                                  EAPOL Start Frames RX         1
                                  EAPOL Logoff Frames RX        0
                                  EAPOL Response ID Frames RX   1
                                  EAPOL Response Frames RX      2
                                  EAPOL Request ID Frames TX    1
                                  EAPOL Request Frames TX       2
                                  EAPOL Invalid Frames RX       0
                                  EAPOL Length Error Frames Rx  0
                                  EAPOL Frame Version           2
                                  EAPOL Auth Last Frame Source  00:02:00:00:00:08
                                  EAPOL Auth Backend Responses  2
                                  RADIUS Auth Session ID        C2FED91A39D8D605 

## Configuring Dynamic VLAN Assignments

A common requirement for campus networks is to assign dynamic VLANs to
specific users in combination with IEEE 802.1x. After authenticating a
supplicant, the user is assigned a VLAN based on the RADIUS
configuration.

For VLAN-aware bridges, the dynamic VLAN is assigned by manipulating the
PVID of the switch port. For traditional mode bridges, Cumulus Linux
identifies the bridge associated with the dynamic VLAN ID and moves the
switch port into that bridge. If an appropriate bridge is not found for
the move, then the port remains in an unauthenticated state where no
packets can be received or transmitted.

To enable dynamic VLAN assignment globally, where VLAN attributes sent
from the RADIUS server are applied to the bridge, do the following:

    cumulus@switch:~$ net add dot1x dynamic-vlan
    cumulus@switch:~$ net pending
    cumulus@switch:~$ net commit

You can specify the `require` option in the command so that VLAN
attributes are required. If VLAN attributes do not exist in the access
response packet returned from the RADIUS server, the user is not
authorized and has no connectivity. If the RADIUS server returns VLAN
attributes but the user has an incorrect password, the user is placed in
the parking VLAN (if you have configured parking VLAN).

    cumulus@switch:~$ net add dot1x dynamic-vlan require
    cumulus@switch:~$ net pending
    cumulus@switch:~$ net commit

The following example shows a typical RADIUS configuration (shown for
FreeRADIUS, not typically configured or run on the Cumulus Linux device)
for a user with dynamic VLAN assignment:

    # # VLAN 100 Client Configuration for Freeradius RADIUS Server.
    # # This is not part of the CL configuration.
    vlan100client Cleartext-Password := "client1password"
         Service-Type = Framed-User,
         Tunnel-Type = VLAN,
         Tunnel-Medium-Type = "IEEE-802",
         Tunnel-Private-Group-ID = 100

Verify the configuration (notice the \[AUTHORIZED\] status in the
output):

    cumulus@switch:~$ net show dot1x interface swp1 details
     
    Interface  MAC Address        Attribute                     Value
    ---------  -----------------  ----------------------------  --------------------------
    swp1       00:02:00:00:00:08  Status Flags                  [DYNAMIC_VLAN][AUTHORIZED]
                                  Username                      host1
                                  Authentication Type           MD5
                                  VLAN                          888
                                  Session Time (seconds)        799
                                  EAPOL Frames RX               3
                                  EAPOL Frames TX               3
                                  EAPOL Start Frames RX         1
                                  EAPOL Logoff Frames RX        0
                                  EAPOL Response ID Frames RX   1
                                  EAPOL Response Frames RX      2
                                  EAPOL Request ID Frames TX    1
                                  EAPOL Request Frames TX       2
                                  EAPOL Invalid Frames RX       0
                                  EAPOL Length Error Frames Rx  0
                                  EAPOL Frame Version           2
                                  EAPOL Auth Last Frame Source  00:02:00:00:00:08
                                  EAPOL Auth Backend Responses  2
                                  RADIUS Auth Session ID        939B1A53B624FC56

    cumulus@switch:~$ net show dot1x interface summary
     
    Interface  MAC Address        Username      State         Authentication Type  MAB  VLAN
    ---------  -----------------  ------------  ------------  -------------------  ---  ----
    swp1       00:02:00:00:00:08  000200000008  AUTHORIZED    unknown              NO   888

The following output shows a dynamic VLAN association failure. VLAN
association failure only occurs with traditional mode bridges when there
is no traditional bridge available with a parking VLAN ID-tagged
subinterface in it (notice the \[UNKNOWN\_BR\] status in the output):

    cumulus@switch:~$ net show dot1x interface swp1 details
     
    Interface  MAC Address        Attribute                     Value
    ---------  -----------------  ----------------------------  --------------------------------------
    swp1       00:02:00:00:00:08  Status Flags                  [DYNAMIC_VLAN][AUTHORIZED][UNKNOWN_BR]
                                  Username                      host2
                                  Authentication Type           MD5
                                  VLAN                          888
                                  Session Time (seconds)        11
                                  EAPOL Frames RX               3
                                  EAPOL Frames TX               3
                                  EAPOL Start Frames RX         1
                                  EAPOL Logoff Frames RX        0
                                  EAPOL Response ID Frames RX   1
                                  EAPOL Response Frames RX      2
                                  EAPOL Request ID Frames TX    1
                                  EAPOL Request Frames TX       2
                                  EAPOL Invalid Frames RX       0
                                  EAPOL Length Error Frames Rx  0
                                  EAPOL Frame Version           2
                                  EAPOL Auth Last Frame Source  00:02:00:00:00:08
                                  EAPOL Auth Backend Responses  2
                                  RADIUS Auth Session ID        BDF731EF2B765B78

To disable dynamic VLAN assignment, where VLAN attributes sent from the
RADIUS server are ignored and users are authenticated based on existing
credentials:

    cumulus@switch:~$ net del dot1x dynamic-vlan
    cumulus@switch:~$ net pending
    cumulus@switch:~$ net commit

{{%notice note%}}

Enabling or disabling dynamic VLAN assignment restarts `hostapd`, which
forces existing, authorized users to re-authenticate.

{{%/notice%}}

## Troubleshooting

To check connectivity between two supplicants, ping one host from the
other:

    root@host1:/home/cumulus# ping 198.150.0.2
    PING 11.0.0.2 (11.0.0.2) 56(84) bytes of data.
    64 bytes from 11.0.0.2: icmp_seq=1 ttl=64 time=0.604 ms
    64 bytes from 11.0.0.2: icmp_seq=2 ttl=64 time=0.552 ms
    ^C
    --- 11.0.0.2 ping statistics ---
    2 packets transmitted, 2 received, 0% packet loss, time 1000ms
    rtt min/avg/max/mdev = 0.552/0.578/0

You can run `net show dot1x` with the following options for more data:

  - `json`: Prints the command output in JSON format.
  - `macs`: Displays MAC address information.
  - `port-details`: Shows counters from the IEEE8021-PAE-MIB for ports.
  - `radius-details`: Shows counters from the RADIUS-CLIENT MIB (RFC
    2618) for ports.
  - `status`: Displays the status of the daemon.

To check to see which MAC addresses have been authorized by RADIUS:

    cumulus@switch:~$ net show dot1x macs
    Interface       Attribute   Value
    -----------     -------------  -----------------
    swp1            MAC Addresses  00:02:00:00:00:01
    swp2            No Data
    swp3            No Data
    swp4            No Data

To check the port detail counters:

    cumulus@switch:~$ net show dot1x port-details 
     
    Interface    Attribute                                  Value
    -----------  ----------------------------------------   ---------
    swp1         Mac Addresses                              00:02:00:00:00:01
                 authMultiSessionId                         96703ADC82D77DF2
                 connected_time                             182
                 dot1xAuthEapolFramesRx                     3
                 dot1xAuthEapolFramesTx                     3
                 dot1xAuthEapolLogoffFramesRx               0
                 dot1xAuthEapolReqFramesTx                  2
                 dot1xAuthEapolReqIdFramesTx                1
                 dot1xAuthEapolRespFramesRx                 2
                 dot1xAuthEapolRespIdFramesRx               1
                 dot1xAuthEapolStartFramesRx                1
                 dot1xAuthInvalidEapolFramesRx              0
                 dot1xAuthLastEapolFrameSource              00:02:00:00:00:01
                 dot1xAuthLastEapolFrameVersion             2
                 dot1xAuthPaeState                          5
                 dot1xAuthQuietPeriod                       60
                 dot1xAuthReAuthEnabled                     FALSE
                 dot1xAuthReAuthPeriod                      0
                 dot1xAuthServerTimeout                     30
                 dot1xAuthSessionAuthenticMethod            1
                 dot1xAuthSessionId                         1B50FE8939FD9F5E
                 dot1xAuthSessionTerminateCause             999
                 dot1xAuthSessionTime                       182
                 dot1xAuthSessionUserName                   testing
                 dot1xPaePortProtocolVersion                2
                 last_eap_type_as                           4 (MD5)
                 last_eap_type_sta                          4 (MD5)                      

To check RADIUS counters:

    cumulus@switch:~$ net show dot1x radius-details swp1
     
    Interface    Attribute                                  Value
    -----------  ----------------------------------------   ---------
    swp1         radiusAccClientRequests                    1
                 radiusAccClientResponses                   1
                 radiusAccClientServerPortNumber            1813
                 radiusAccServerAddress                     127.0.0.1
                 radiusAuthClientAccessAccepts              1
                 radiusAuthClientAccessChallenges           1
                 radiusAuthClientAccessRejects              0
                 radiusAuthClientAccessRequests             0
                 radiusAuthClientServerPortNumber           1812
                 radiusAuthServerAddress                    127.0.0.1
                 radiusAuthServerIndex                      1
     
    ...

You can also check logging with journalctl:

    cumulus@switch-01:~$ sudo journalctl -f -u hostapd
    Apr 19 22:17:11 switch-01 hostapd[12462]: swp1: interface state UNINITIALIZED->ENABLED
    Apr 19 22:17:11 switch-01 hostapd[12462]: swp1: AP-ENABLED
    Apr 19 22:17:11 switch-01 hostapd[12462]: Reading rule file /etc/cumulus/acl/policy.d/00control_ps ...
    Apr 19 22:17:11 switch-01 hostapd[12462]: Processing rules in file /etc/cumulus/acl/policy.d/00...
    Apr 19 22:17:12 switch-01 hostapd[12462]: Reading rule file /etc/cumulus/acl/policy.d/100_dot1x...
    Apr 19 22:17:12 switch-01 hostapd[12462]: Processing rules in file /etc/cumulus/acl/policy.d/ ..
    Apr 19 22:17:12 switch-01 hostapd[12462]: Reading rule file /etc/cumulus/acl/policy.d/99control
    Apr 19 22:17:12 switch-01 hostapd[12462]: Processing rules in file /etc/cumulus/acl/policy.d/99
    Apr 19 22:17:12 switch-01 hostapd[12462]: Installing acl policy
    Apr 19 22:17:12 switch-01 hostapd[12462]: done. 

### Advanced Troubleshooting

More advanced troubleshooting can be accomplished with the following
commands.

You can increase the debug level in `hostapd` by copying over the
`hostapd` service file, then adding *-d*, *-dd* or *-ddd* to the
`ExecStart` line in the `hostapd.service` file:

    cumulus@switch:~$ cp  /lib/systemd/system/hostapd.service /etc/systemd/system/hostapd.service
    cumulus@switch:~$ sudo nano /etc/systemd/system/hostapd.service
    ...
     
    ExecStart=/usr/sbin/hostapd -ddd -c /etc/hostapd.conf
     
    ...

You can watch debugs with `journalctl` as supplicants attempt to
connect:

    cumulus@switch:~$ sudo journalctl -n 1000  -u hostapd      # see the last 1000 lines of hostapd debug logging
    cumulus@switch:~$ sudo journalctl -f -u hostapd            # continuous tail of the hostapd daemon debug logging

You can check ACL rules in
`/etc/cumulus/acl/policy.d/100_dot1x_swpX.rules` before and after a
supplicant attempts to authenticate:

    cumulus@switch:~$ sudo cl-acltool -L eb | grep swpXX
    cumulus@switch:~$ sudo cl-netstat | grep swpXX           # look at interface counters

You can check `tc` rules in `/var/lib/hostapd/acl/tc_swpX.rules` with:

    cumulus@switch:~$ sudo tc -s filter show dev swpXX parent 1:
    cumulus@switch:~$ sudo tc -s filter show dev swpXX parent ffff:

## Configuring the RADIUS Server

If you haven't done so already, you need to configure the RADIUS server
- preferably not on the Cumulus Linux switch - before configuring any
interfaces for 802.1X.

To add a popular and freely available RADIUS server called FreeRADIUS on
a Debian workstation, do the following:

    root@radius:~# apt-get update
    root@radius:~# apt-get install freeradius

Once installed and configured, the FreeRADIUS server can serve Cumulus
Linux running `hostapd` as a RADIUS client.

For more information, see the [FreeRADIUS documentation](http://freeradius.org/doc/).
