---
title: switchd Log Message Reference
author: Cumulus Networks
weight: 231
pageID: 8362124
pdfhidden: true
---
The following table lists the log messages generated by `switchd`,
organized by severity, then message text. These messages appear in
`/var/log/switchd.log`.

<table>
<colgroup>
<col style="width: 25%" />
<col style="width: 25%" />
<col style="width: 25%" />
<col style="width: 25%" />
</colgroup>
<thead>
<tr class="header">
<th><p>Severity</p></th>
<th><p>Message Text</p></th>
<th><p>Explanation</p></th>
<th><p>Recommended Action</p></th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>_port_group_config_values_get: hal_list_get failed on [str]</p></td>
<td><p>List create failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>_range_limits_get: start linux interface name buffer is NULL</p></td>
<td><p>Invalid parameter.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>_range_limits_get: end linux interface name buffer is NULL</p></td>
<td><p>Invalid parameter.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>_range_limits_get: [str]-[str] not recognized</p></td>
<td><p>Invalid port set configuration.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>_range_limits_get: port range [str] not recognized</p></td>
<td><p>Invalid port set configuration.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>_port_group_ports_set: hal_list_get failed on [str]</p></td>
<td><p>Port set list create failed.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>_port_group_name_list_get: hal_list_get failed on [str]</p></td>
<td><p>List create failed.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>_port_group_range_translate: _get_range_limits failed on [str]</p></td>
<td><p>Invalid port set configuration.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>_priority_group_config_get: hal_list_get failed on [str]</p></td>
<td><p>Configuration list create failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>hal_list_get: list string [str] contains more elements than the maximum allowed ([int])</p></td>
<td><p>List capacity exceeded.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>hal_sh_datapath_file_read: could not load config file [str]</p></td>
<td><p>Could not load the back end QoS configuration file.</p></td>
<td><p>Check backend QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Unable to reallocate [int] bytes of memory</p></td>
<td><p>Memory allocation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>No backends found.</p></td>
<td><p>No back ends found.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>License: email is longer than [int] characters</p></td>
<td><p>Email length exceeds maximum.</p></td>
<td><p>Modify email address.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>License: license data is longer than [int]</p></td>
<td><p>License data exceeds maximum.</p></td>
<td><p>Check license.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>License: Invalid format</p></td>
<td><p>Invalid license format.</p></td>
<td><p>Check license.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>No license file.</p></td>
<td><p>No license file found.</p></td>
<td><p>Check license file.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>The Cumulus Linux license appears to be invalid.<br />
This WILL NOT affect your system operations at the moment.<br />
Future versions will enforce fully valid licenses on the system.<br />
Please contact &lt;licensing@cumulusnetworks.com&gt; at your convenience so we can validate and assist you with this licensing issue.</p></td>
<td><p>Invalid license.</p></td>
<td><p>Check license.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>No license file.</p></td>
<td><p>No license file found.</p></td>
<td><p>Check license file.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Incomplete license.</p></td>
<td><p>Incomplete license.</p></td>
<td><p>Check license.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>License is expired!</p></td>
<td><p>License is expired.</p></td>
<td><p>Renew license.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>unable to get tap_name for port [uint]</p></td>
<td><p>Port config failed: no port name.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Voluntary restart by timestamp check requested</p></td>
<td><p>Voluntary switchd restart.</p></td>
<td><p>None.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't write ready file [str]</p></td>
<td><p>Could not mark switchd startup complete.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Could not open [str] to record error type</p></td>
<td><p>Could not report restart reason.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Error setting signal handlers.</p></td>
<td><p>Signal handler initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>No license to run switchd!</p></td>
<td><p>No switchd license is installed.</p></td>
<td><p>Install switchd license.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>daemon call failed with rv [int]</p></td>
<td><p>switchd could not be daemonized.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't write pid file [str]</p></td>
<td><p>Could not write out the process ID.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Switchd fs init failed.</p></td>
<td><p>Failed to initialize the switchd file system.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Switchd config failed.</p></td>
<td><p>Could not load the switchd configuration file.</p></td>
<td><p>Check switchd configuration file.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Netlink init failed.</p></td>
<td><p>Netlink initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>HAL init failed.</p></td>
<td><p>HAL initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>NIC init failed.</p></td>
<td><p>NC initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Port init failed.</p></td>
<td><p>Port initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Bridges init failed.</p></td>
<td><p>Bridges initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Bonds init failed.</p></td>
<td><p>Bonds initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Logical networks init failed.</p></td>
<td><p>Logical networks initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Interface list init failed.</p></td>
<td><p>Interface list initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Switchd fs mount failed.</p></td>
<td><p>Could not mount switchd file system.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to add route [str]</p></td>
<td><p>Failure in VRF route leak feature. This message notifies that a route entry could not be properly added to one of the software tables.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>MAC address [str] couldn't be added to or retrieved from hash</p></td>
<td><p>Relates to merging MAC tables. The message notifies that an entry expected in a MAC address software table is not found therein.</p></td>
<td><p>This should never be seen. File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to add route [str]</p></td>
<td><p>Add MPLS transit LSP to a software table failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>[str]: hal port list malloc failed</p></td>
<td><p>Memory exhausted.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to add [str] to [str]</p></td>
<td><p>"Failed to add &lt;port&gt; to &lt;multicast route&gt;". Issue happens when addition of the port to a software table fails.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to add hal mroute for [str]</p></td>
<td><p>Failed to add multicast route to a software table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to add [str] to [str]</p></td>
<td><p>"Failed to add &lt;port&gt; to &lt;multicast route&gt;". Issue happens when addition of the port to a software table fails.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to add grp [str] to mroute</p></td>
<td><p>A multicast route for a group could not be added to a software hash table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Maximum number of bonds exceeded, max is [int]</p></td>
<td><p>Maximum number of bonds exceeded.</p></td>
<td><p>Reduce the number of bonds on the switch.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Maximum number of slaves per bond exceeded, max is [int]</p></td>
<td><p>Maximum number of bond members per bond exceeded.</p></td>
<td><p>Reduce the number of bond members configured for a bond.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>rtnl slave state get failed for bond:[int] port: [int]</p></td>
<td><p>Could not get the bond member state from Netlink.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to add route [str]</p></td>
<td><p>Failed to add route to a software table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to add [str] to bridge [int]</p></td>
<td><p>Failed to add a port to the bridge.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to add [str] to grp [str]</p></td>
<td><p>Failed to add a port to the MDB group.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to add [str] to bridge [int]</p></td>
<td><p>Failed to add an MDB group to the bridge.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to add bridge [int] to mdb</p></td>
<td><p>Failed to add a given bridge to MDB.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to add port [str] in grp [str], bridge [int]</p></td>
<td><p>Failed to add a port to a group for the specific bridge.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to add [str] to bridge [int]</p></td>
<td><p>Failed to add a port to the bridge.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to add port [str] in grp [str]</p></td>
<td><p>Failed to add a port to the MDB group.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to add [str] to bridge [int]</p></td>
<td><p>Failed to add a port to the bridge.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to add bridge [str] to mdb</p></td>
<td><p>Failed to add a given bridge to MDB.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to add [str] to bridge [int]</p></td>
<td><p>Failed to add a port to the bridge.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>arptables: Memory allocation for rules failed,malloc: [str]</p></td>
<td><p>ACL out of memory resource.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to create kernel bridge</p></td>
<td><p>L2: Bridge hash table add failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Open of /dev/net/tun failed: [str]</p></td>
<td><p>Failed to create a net device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>TUNSETIFF failed: [str]</p></td>
<td><p>Failed to create a net device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>SIOCGIFHWADDR failed: [str]</p></td>
<td><p>Failed to create a net device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>SIOCSIFHWADDR failed: [str]</p></td>
<td><p>Failed to create a net device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>TUNSETPERSIST failed: [str]</p></td>
<td><p>Failed to create a net device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>TUNSETOFFLOAD failed: [str]</p></td>
<td><p>Failed to create a net device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't create tuntap ioctl socket.</p></td>
<td><p>Failed to create a net device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't get netdev flags.</p></td>
<td><p>Failed to create a net device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't Set netdev flags.</p></td>
<td><p>Failed to create a net device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>[str]: rtnl_link_alloc failed for family [int]</p></td>
<td><p>Failed to create filters.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>[str]: rtnl_neigh_alloc failed for family [int]</p></td>
<td><p>Failed to create filters.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to blacklist interface [int]</p></td>
<td><p>Failed to block interfaces.</p></td>
<td><p>Check block interfaces.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to blacklist interface [int]</p></td>
<td><p>Failed to block interfaces.</p></td>
<td><p>Check block interfaces.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to add [str], ifindex [int] to sw_intfs</p></td>
<td><p>Failed to create interfaces.</p></td>
<td><p>Recreate the interface.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to delete ifindex [int] from sw_intfs</p></td>
<td><p>Failed to create interfaces.</p></td>
<td><p>Recreate the interface.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>[str]: could not load interface config</p></td>
<td><p>Syncing database failed between kernel and switchd.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>bogus filesystem path: [str]</p></td>
<td><p>Failed to add a file in SFS (simple file system).</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Need file spec</p></td>
<td><p>Failed to add a file in SFS (simple file system).</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>can't replace existing directory with file: [str]</p></td>
<td><p>Failed to add a file in SFS (simple file system).</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>filesystem already initialized</p></td>
<td><p>Failed to initialize in SFS (simple file system).</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>filesystem hash table alloc failed</p></td>
<td><p>Failed to allocate hash table in SFS init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>filesystem mount failed</p></td>
<td><p>Failed to mount SFS in swtichd init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>filesystem new failed</p></td>
<td><p>Failed to mount SFS in swtichd init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>bogus filesystem path: [str]</p></td>
<td><p>Failed to delete filesystem in SFS.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>pthread_create failed: [str]</p></td>
<td><p>Failed to create a thread in NIC init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>pthread_detach failed: [str]</p></td>
<td><p>Failed to detach a thread in NIC init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>TX Ring allocation failed: [str]</p></td>
<td><p>Failed to alloc packt buffer in NIC init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't increase netlink rbuf size: [str]</p></td>
<td><p>Failed to init buffer size in Netlink socket.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't increase netlink wbuf size: [str]</p></td>
<td><p>Failed to init buffer size in Netlink socket.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't allocate netlink socket.</p></td>
<td><p>Failed to create a Netlink socket.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't connect netlink socket: [str]</p></td>
<td><p>Failed to create a Netlink socket.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>nl_resync_route failed for cache [int]: [str]</p></td>
<td><p>Failied to create a resync router function in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't set bufsize for manager netlink socket.</p></td>
<td><p>Failied to reinitialize buffer size in Netlink socket.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>invalid cache mngrinfo.</p></td>
<td><p>Failied to create a resync in Netlink idle callback.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>[str]: failed to close socket: [str]</p></td>
<td><p>Failed to configure FD in Netlink socket.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>[str]: nl_cache_mngr_data_ready failed: [str]</p></td>
<td><p>Failed to configure FD in Netlink socket.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't allocate netlink socket.</p></td>
<td><p>Failed to create a socket in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't allocate netlink socket.</p></td>
<td><p>Failed to create a socket in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't allocate manager netlink socket.</p></td>
<td><p>Failed to create a socket in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't create cache manager: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't set bufsize for manager netlink socket.</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add link cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add link cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add route cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add mdb cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't alloc neigh cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add mroute cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't alloc tcqdisc cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add tcqdisc cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't alloc tcclass cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add tcclass cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't alloc tccls cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add tccls cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't alloc tcact cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add tcact cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't alloc rule cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add rule cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't add neigh cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Couldn't alloc netconf cache: [str]</p></td>
<td><p>Failed to allocate a cache in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Couldn't initialize genl/port interface</p></td>
<td><p>Failed to initialize port interface in Netlink init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to create kernel bridge</p></td>
<td><p>Failed to allocate a hash entry in bridge sync.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Port msg [str] failure: err [int]</p></td>
<td><p>Failed to configure PORT FEC parameter.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Port msg [str] reply failure: err [int]</p></td>
<td><p>Failed to configure PORT FEC parameter.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed run recvmsg_default on port socket, err [int], [str]</p></td>
<td><p>Failed to initialize PORT receiving messages.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>vlan stats send failure: err [int]</p></td>
<td><p>Failed to configure status in VLAN.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>mroute hitbits send failure: err [int]</p></td>
<td><p>Failed to configure hit bit status in MCAST router.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Port send stats failure: err [int]</p></td>
<td><p>Failed to configure status in PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Port send settings failure: err [int]</p></td>
<td><p>Failed to configure settings in PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Port send carrier failure: err [int]</p></td>
<td><p>Failed to configure carrier in PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>ifindex [int] already registered for port ops</p></td>
<td><p>Failed to register interface options in PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>ifindex [int] not registered for port ops</p></td>
<td><p>Failed to unregister interface options in PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to allocate port hash table</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to allocate port socket</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to genl connect to port socket</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to allocate port sync socket</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to genl connect to port socket</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to set genl port sync socket to non-blocking</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to resolve port ops, err [int]</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to resolve port multicast group</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to register port ops, err [int]</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>Failed to add port group membership, err [int]</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>CRITICAL</p></td>
<td><p>Failed to modify port socket notify cb, err [int]</p></td>
<td><p>Failed to initialize PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>CRITICAL</p></td>
<td><p>[str]:[int]: [str][str]Assertion [str] failed</p></td>
<td><p>Failed to find the function name in switchd.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>priority group [int] headroom count [int] exceeds the maximum value [int]</p></td>
<td><p>Port headroom buffers exceed ASIC limit.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>shared buffer type [int] not recognized</p></td>
<td><p>Invalid buffer type.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>sx_api_cos_prio_to_ieeeprio_set failed: [str]</p></td>
<td><p>IEEE priority map configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>_hal_mlx_packet_2_switch: priority field [int] not supported</p></td>
<td><p>Packet priority field not supported for source.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>priority field [int] not supported</p></td>
<td><p>Packet priority field not supported for remark.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>cos list length [int] is longer than maximum value [int]</p></td>
<td><p>ECN/RED configuration: list is too long.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>hash params get failed: [str]</p></td>
<td><p>ASIC ECMP hash seed configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>hash params set failed: [str]</p></td>
<td><p>ASIC ECMP hash seed configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>hal_sh_datapath_pfc_set: PFC configuration not supported on the CPU port</p></td>
<td><p>CPU port does not support priority flow control.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>hal_sh_datapath_init: datapath init failed: rv [int]: [str]</p></td>
<td><p>Back end QoS initialization failed.</p></td>
<td><p>Check for detailed log messages.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>_priority_field_list_get: Packet priority field [str] not supported</p></td>
<td><p>Invalid packet priority field.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>_sfs_init: could not load traffic config file [str]</p></td>
<td><p>Traffic configuration file missing or is unreadable.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>_sfs_port_init: could not load traffic config file [str]</p></td>
<td><p>Traffic configuration file missing or is unreadable.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>_add_port_group: port group [str] exceeds max port group count [int]</p></td>
<td><p>Too many port groups configured.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>_add_port_group: memory allocation failed for port group [str]</p></td>
<td><p>Memory allocation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>_switch_priority_config: [str]</p></td>
<td><p>ASIC scheduler configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>_priority_map_config map function, hal port [int]: [str]</p></td>
<td><p>ASIC priority map configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>_priority_map_config enable function: [str]</p></td>
<td><p>ASIC priority map enable configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>_port_group_range_translate: invalid port list: range length is 0, id list is 0</p></td>
<td><p>Invalid port set configuration.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>_port_group_range_translate: failed: port list not created from range [str] to [str]</p></td>
<td><p>Invalid port set configuration.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>hal_datapath_init: priority field initialization expects 3 three priority fields, got [int]</p></td>
<td><p>Invalid inputs.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>hal_datapath_init: priority map direction initialization expects two priority map directions, got [int]</p></td>
<td><p>Invalid inputs.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>hal_datapath_init: DOS config failed: [str]</p></td>
<td><p>ASIC DoS config failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>_cutthrough_config: Cutthrough config failed on HAL port [int]: [str]</p></td>
<td><p>ASIC cut-through configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>_source_priority_map_init: packet priority map size [int] is larger than array length [int]</p></td>
<td><p>Configured priority map list is too large.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>_source_priority_map_populate: packet priority map entry index [int] is larger than array length [int]</p></td>
<td><p>Configured priority map list is too large.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>_remark_priority_map_init: packet priority map entry index [int] is larger than array length [int]</p></td>
<td><p>Configured priority map list is too large.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>_remark_priority_map_populate: packet priority map entry index [int] is larger than array length [int]</p></td>
<td><p>Configured priority map list is too large.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>_priority_map_get: field index [int] is out of bounds: [int] available field entries</p></td>
<td><p>Invalid packet priority field.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>_priority_map_get: cos ID [int] is out of bounds: [int] cos ID values</p></td>
<td><p>Invalid priority value.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>_priority_map_get: old syntax flag [int] should be less than [int]</p></td>
<td><p>Invalid configuration syntax.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>hal_list_get: strdup returned NULL</p></td>
<td><p>Memory allocation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>hal_port_pause_set: RX pause not allowed on port [int]</p></td>
<td><p>Invalid operation for the current port configuration.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>vlan_range_confi: incorrect format, revert to default</p></td>
<td><p>Invalid configuration.</p></td>
<td><p>Correct configured VLAN range.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vlan_range_confi: incorrect format, revert to default</p></td>
<td><p>Invalid configuration.</p></td>
<td><p>Correct configured VLAN range.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>vlan_range_confi: incorrect range, revert to default</p></td>
<td><p>Invalid configuration.</p></td>
<td><p>Correct configured VLAN range.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vlan_range_confi: minimum range is [int], revert to default</p></td>
<td><p>Invalid configuration.</p></td>
<td><p>Correct configured VLAN range.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>backend_enum_info_key unsupported type [uint]</p></td>
<td><p>Invalid backend type.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>hal_init [str] enum_fn [str]: dlerror [str]</p></td>
<td><p>No back end enum function found.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>hal_init failed to open [str]: [str]</p></td>
<td><p>Could not open the back end DLL.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>hal_init unsupported type [uint]</p></td>
<td><p>Invalid back end type.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>hal_init: backend function at offset [int] non populated: [address]</p></td>
<td><p>Back end function pointer is not set.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Unable to setup handling of SIGHUP for log rotation: [str]</p></td>
<td><p>Signal handler initiailzation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Couldn't delete pid file [str], [str]</p></td>
<td><p>Could not delete process ID file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to update VRF [str] to table id [uint]</p></td>
<td><p> </p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to add VRF [str] with table id [uint]</p></td>
<td><p> </p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to get VRF table id for index [int]</p></td>
<td><p>VRF table ID not found for the master link.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[int] hosts were ignored due to capacity.</p></td>
<td><p>Kernel neighbors did not fit in the hardware table.</p></td>
<td><p>Modify neighbor configuration.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[int] routes were ignored due to total capacity.</p></td>
<td><p>Kernel routes did not fit in the hardware table.</p></td>
<td><p>Modify route configuration.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[int] [str] routes were ignored due to capacity.</p></td>
<td><p>Kernel routes did not fit in the hardware table.</p></td>
<td><p>Modify route configuration.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Ignoring VRF [str]; table id 0 is reserved for default VRF</p></td>
<td><p>Invalid table ID for the VRF.</p></td>
<td><p>Modify VRF configuration.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to update VRF [str] to table id [uint]</p></td>
<td><p>Failed to update the VRF table ID.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to add VRF [str] with table id [uint]</p></td>
<td><p>Failed to add the VRF.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to set type to 'vrf' in link filter</p></td>
<td><p>Failed to update the Netlink cache link type.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Found [int] VRF entries after sync. cleaning up.</p></td>
<td><p>VRF entries remaining after sync operation.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Ignoring attempts to delete default route for table 0</p></td>
<td><p>Failed to remove the default route.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Master interface not found in nl cache for index [int]</p></td>
<td><p>Link object not found in Netlink cache.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Maximum number of VRFs already exist. Can not add VRF for table [uint]</p></td>
<td><p>More VRFs have been configured than the maximum number supported by the platform.</p></td>
<td><p>Reduce the number of configured VRFs.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to delete REPL route from Hash Table</p></td>
<td><p>Failure in VRF route leak feature. This message notifies that an entry could not be properly deleted from one of the software tables.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to add route [str]</p></td>
<td><p>Failure in VRF route leak feature. This message notifies that a route entry could not be properly added to one of the software tables.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Route [str] in HW, but not in HAL cache. Adding.</p></td>
<td><p>Happens when HAL resync is triggered. Route discovered in hardware but it is not in the software database.</p></td>
<td><p>No action is required as software auto-corrects.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>HW route [str] doesn't match HAL route [str]. Updating.</p></td>
<td><p>Happens when HAL resync is triggered. Route discovered in hardware but it is not matching the software database.</p></td>
<td><p>No action is required as software auto-corrects.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Route [str] in HAL cache, but not in HW. Deleting.</p></td>
<td><p>Happens when HAL resync is triggered. Route discovered in software but it is not seen in the hardware.</p></td>
<td><p>No action is required as software auto-corrects.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>No parent interface for [str]</p></td>
<td><p>The parent interface of an interface could not be derived. This is a software issue.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str]: sfs backing pointer is NULL</p></td>
<td><p>FUSE file pointer is NULL.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>port sample rate string not found</p></td>
<td><p>Port sampling rate is not set.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str]: hal port pointer is NULL for port sample string [str]</p></td>
<td><p>Port pointer is incorrect when port sampling is set.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>port sample rate string [str] not recognized</p></td>
<td><p>Port sampling rate is not configured properly.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>port sample interface [str] in port sample string '[str]' not recognized</p></td>
<td><p>Port sampling port-name is not configured properly.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>port sample rate value not recognized in string [str]</p></td>
<td><p>Port sampling value is not configured properly.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>port sample rate value [str] does not contain a valid integer</p></td>
<td><p>Port sampling value is not configured properly using integer values.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[int] mroutes were ignored due to total capacity.</p></td>
<td><p>Maximum number of multicast routes exceeded.</p></td>
<td><p>Reduce the number of multicast routres in the switch/fabric.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>local_ip format in fuse node is incorrect [str]</p></td>
<td><p>Local_IP value formatting in FUSE file is incorrect.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>local_ip fuse node read failed</p></td>
<td><p>Local_IP value formatting in FUSE file is invalid.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vxlan encap dscp action invalid</p></td>
<td><p>VXLAN encap DSCP action in FUSE file is invalid.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>vxlan encap dscp action [[str]] invalid</p></td>
<td><p>VXLAN encap DSCP action formatting in FUSE file is invalid.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vxlan decap dscp action invalid</p></td>
<td><p>VXLAN decap DSCP action in FUSE file is invalid.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>vxlan decap dscp action invalid</p></td>
<td><p>VXLAN decap DSCP action formatting in FUSE file is invalid.</p></td>
<td><p>Correct the configuration.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>sx_api_lag_hash_flow_params_set failed: [str]</p></td>
<td><p>Set hash flow parameters failed in the SDK.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>bond IDs exhausted</p></td>
<td><p>Maximum number of bonds exhausted.</p></td>
<td><p>Reduce the numbert of configured bonds.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>bond_id [uint] swid [uint] lag create failed: [str]</p></td>
<td><p>Setting a LAG port group failed in the SDK.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>bond_id [uint] lag_id 0x%x port state set failed: [str]</p></td>
<td><p>Port state could not be set to ADMIN_UP in the SDK.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>bond_id [uint] lag_id 0x%x ingr_filter set failed: [str]</p></td>
<td><p>Ingress filter set failed for specified bond_id and lag_id in the SDK.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>bond_id [uint] old lag_id 0x%x not cleaned up</p></td>
<td><p>Could not find the mapping of the bond_id with the old lag_id, hence cleanup was not successful.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>lag_id 0x%x swid [uint] failed: [str]</p></td>
<td><p>Removal of the LAG port group for the specified lag_id failed.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>cannot find bond slave port [uint]</p></td>
<td><p>During addition of a bond slave port to a bond, the slave port entry in the software tables could not be found.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ifp not found for bond_id [uint]</p></td>
<td><p>Software entry for a bond_id could not be found in the database.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] member [str] add failed: [str]</p></td>
<td><p>Adding a member to a LAG group failed in the SDK.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] member [str] delete failed: [str]</p></td>
<td><p>Deleting a member in a LAG group failed in the SDK.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>invalid port_storm_ctrl_type [uint]</p></td>
<td><p>Invalid Storm-Control-Type (invalid value) detected in the software. Internal error.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate bond if_key [str]</p></td>
<td><p>Existing duplicate bond key found in the software table.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>lag_id 0x%x with no corresponding bond id</p></td>
<td><p>bond_id could not be located for the given lag_id.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] collector set failed for [str]: [str]</p></td>
<td><p>Adding the specified port to the collector set for the bond failed.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] distributor set failed for [str]: [str]</p></td>
<td><p>Adding the specified port to the distributor set for the bond failed.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>cannot find base bond slave [str] for bond_id [int]</p></td>
<td><p>During update of a bond, the slave port entry in the software tables could not be found.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate bond interface [str]</p></td>
<td><p>Existing duplicate bond interface found in the software table.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate lag_id 0x%x</p></td>
<td><p>Existing duplicate lag_id found in the software table.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>info not found for bond_id [uint]</p></td>
<td><p>An expected entry could not be found for a given bond_id in a software table.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] unexpected duplicate member [str]</p></td>
<td><p>Duplicate entry for the specified interface found for a bond in a software table.</p></td>
<td><p> </p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>info not found for bond_id [uint]</p></td>
<td><p>An expected entry could not be found for a given bond_id in a software table.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>initialization failed: [str]</p></td>
<td><p>SDK API call for tunnel initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>logical network type [uint] key [uint] not found</p></td>
<td><p>Logical network of given type and key was not found in the software tables.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>logical network type [uint] key [uint] not found</p></td>
<td><p>Logical network of given type and key was not found in the software tables.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to create keys tunnel type [uint] and key [uint]</p></td>
<td><p>Failed to create logical network keys of given tunnel type and interface key in the software tables.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to update the decap key for gre entry tunnel_id:</p></td>
<td><p>Failed to update the GRE decap keys for the given tunnel.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to find the decap key for tunnel_id : (0x%x)</p></td>
<td><p>Failed to find the GRE decap keys for the given tunnel.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to update a decap entry tunnel_id : (0x%x)</p></td>
<td><p>Failed to update the GRE decap keys for the given tunnel.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate entry in gre_tunnel_key_ht</p></td>
<td><p>GRE tunnel key table has an existing duplicate entry.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate entry in gre_tunnel_id_ht</p></td>
<td><p>GRE tunnel ID table has an existing duplicate entry.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate entry in gre_olay_ulay_ht</p></td>
<td><p>GRE tunnel overlay/underlay table has an existing duplicate entry.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to create the hw decap key for gre entry tunnel_id:</p></td>
<td><p>Failed to create the GRE decap keys for the given tunnel.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to create a decap entry tunnel_id : (0x%x)</p></td>
<td><p>Failed to create a decap entry in the software table for the given tunnel_id.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate entry in gre_decap_ht tunnel_id</p></td>
<td><p>GRE decap table has an existing duplicate entry for the given tunnel.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to create</p></td>
<td><p>Failed to set up a tunnel between the given local and remote IP addresses.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unable to find overlay overlay info from overlay ifindex:</p></td>
<td><p>While removing a GRE tunnel, the overlay info could not be retrieved from the software tables for the given ifindex.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to create key for type [uint]</p></td>
<td><p>Failed to create the GRE keys for the given tunnel type.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to find gre entry</p></td>
<td><p>Failed to find a logical network entry for a tunnel in the software tables during tunnel removal.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to find gre entry</p></td>
<td><p>Failed to find a GRE decap entry for a tunnel during tunnel removal.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to open SX-API, error: [str]</p></td>
<td><p>SDK API open failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to set SDK VERBOSITY level, error: [str]</p></td>
<td><p>Failed to set SDK VERBOSITY level.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>num_devices [uint] is invalid</p></td>
<td><p>SDK found zero (asic) devices.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to initialize SDK ([str])</p></td>
<td><p>Failed to initialize SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>*** failed to configure the requested setup ***</p></td>
<td><p>The board configuration could not be enforced.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>more devices encountered than configured [uint]</p></td>
<td><p>More devices encountered than configured.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>duplicate device ID [uint]</p></td>
<td><p>Found an existing duplicate device when adding a new device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>invalid unit [uint] num_devices [uint]</p></td>
<td><p>Internal error: given unit number is out of range.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>invalid port [uint] num_ports [uint]</p></td>
<td><p>Internal error: given port number is out of range.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ERROR: Fail to extract data from XML file</p></td>
<td><p>The topology map could not be extracted from the XML file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Device ID already added</p></td>
<td><p>A device is already added to the topology database.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Device ID [uint] NOT found in the XML file</p></td>
<td><p>A device could not be found in the databse.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to add device [uint] to the SDK (sx_api_topo_device_set)</p></td>
<td><p>Failed to add a device to the topology database.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to allocate memory for tree tree_info array,</p></td>
<td><p>Memory exhausted.</p></td>
<td><p>Restart switchd, if possible. File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ERROR: Fail to add topo tree</p></td>
<td><p>Top tree could not be added.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to set topo device ready for device [uint]: [str]</p></td>
<td><p>Could not set DEVICE_READY in the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Unable to load file [str] (file not exists or corrupted )</p></td>
<td><p>The specified XML configuration file could not be loaded as it either does not exist or is possibly corrupted.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Unable to parse file (error #[int]: [str])</p></td>
<td><p>The specified XML configuration file could not be parsed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Expat error #[int] (line [int] , column [int]): [str]</p></td>
<td><p>A parsing error encountered when parsing the configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing number of devices</p></td>
<td><p>Error parsing the number of child devices in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error parsing device mac address</p></td>
<td><p>Error parsing the device MAC address in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing device MAC address</p></td>
<td><p>Error parsing the device MAC address in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error mac cannot be 00:00:00:00:00:00</p></td>
<td><p>Found a device MAC address of all zeores in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed running [str]</p></td>
<td><p>Specified system command failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error parsing dev_number</p></td>
<td><p>Error parsing the device number in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing device mac address</p></td>
<td><p>Error parsing the device MAC address in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error parsing device MAC address</p></td>
<td><p>Error parsing the device MAC address in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing number of physical ports value</p></td>
<td><p>Error parsing the number of PHY ports in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Invalid number of physical ports [uint]</p></td>
<td><p>Found zero or more than the allowed maximum port numbers in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing ports list section</p></td>
<td><p>Error parsing the port list section in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error parsing local port number</p></td>
<td><p>Error parsing the local port number in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing mapping mode</p></td>
<td><p>Error parsing the mapping mode in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error parsing label port</p></td>
<td><p>Error parsing the label port in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing width value</p></td>
<td><p>Error parsing the port width in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error parsing RX lanes value , local port: [[int]]</p></td>
<td><p>Error parsing the RX lanes value in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing lanes value , local port: [[int]]</p></td>
<td><p>Error parsing the lanes value in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error parsing lanes value, local port: [[int]]</p></td>
<td><p>Error parsing the lanes value in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing lane to module value, local port: [[int]]</p></td>
<td><p>Error parsing the lane to module mapping value in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error parsing lane to module value , local port: [[int]]</p></td>
<td><p>Error parsing the lane to module mapping value in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing port mode value</p></td>
<td><p>Error parsing the in the port mode value XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error parsing port speed value</p></td>
<td><p>Error parsing the in the port speed value XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error parsing swid value</p></td>
<td><p>Error parsing the swid value in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error parsing autoneg value</p></td>
<td><p>Error parsing the autoneg value in the XML configuration file.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Conflict detected in lid 0x%0x port [uint] dev_id [uint]</p></td>
<td><p>lid already detected in a software table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>port_device_set has failed for device [uint] ([str])</p></td>
<td><p>Could not set a port device to the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>topo_xml_device_add failed for device [uint] ([str])</p></td>
<td><p>A device could not be added to a topo_xml_device database.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>mode set dev [int] port 0x%x failed: [str]</p></td>
<td><p>Port mode could not be set to STACKING mode in the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>binding dev [int] port 0x%x to swid [int] failed: [str]</p></td>
<td><p>Binding the device and port to the swid failed in the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>port_init dev [int] port 0x%x failed: [str]</p></td>
<td><p>Specified device/port could not be initialized in the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>swid set failed: [str]</p></td>
<td><p>swid set failed in the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to set port 0x%x mapping: [str]</p></td>
<td><p>Port mapping failed for the specified port in the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to set port 0x%x mapping: [str]</p></td>
<td><p>Port mapping failed for the specified port in the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>invalid bridge_vlan [uint] for bridge_id [int]</p></td>
<td><p>The specified bridge_vlan is not valid for the given bridge_id.</p></td>
<td><p>File a ticket with Cumulus Support</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>vfid not set for vlan [uint]</p></td>
<td><p>VFID is not set for the specified VLAN.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>new group check failed for vlan [uint] mac [str]: [str]</p></td>
<td><p>The specified MAC address and VLAN already exist in a group.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>old port list get failed for vlan [uint] mac [str]: [str]</p></td>
<td><p>Could not find the existing port list for the given MAC address and VLAN.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>port delete failed for vlan [uint] mac [str]: [str]</p></td>
<td><p>Could not delete the existing port list for the given MAC address and VLAN.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>create failed for vlan [uint] mac [str]: [str]</p></td>
<td><p>Could not create a new multicast group for the given MAC address and VLAN.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>port add failed for vlan [uint] mac [str]: [str]</p></td>
<td><p>Could not add a port to the port list for the given MAC address and VLAN.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>invalid bridge_vlan [uint] for bridge_id [int]</p></td>
<td><p>The specified bridge_vlan is not valid for the given bridge_id.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vfid not set for vlan [uint]</p></td>
<td><p>The specified MAC address and VLAN already exist in a group.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>group delete failed for vlan [uint] mac [str]: [str]</p></td>
<td><p>Could not delete a multicast group for the given MAC address and VLAN.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>invalid bridge_vlan [uint] for bridge_id [int]</p></td>
<td><p>The specified bridge_vlan is not valid for the given bridge_id.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>vfid not set for vlan [uint]</p></td>
<td><p>VFID is not set for the specified VLAN.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>flood_mode_get failed for swid [int] vfid [int] [str]</p></td>
<td><p>Flood mode value could not be retrieved for the given swid/port/vfid.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unreg_mc_flood_ports fail for swid [int], vfid [int], [str]</p></td>
<td><p>Unregistered multicast flood ports setting for given swid/port/vfid failed in the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>mroute ports [int] exceeds [int]</p></td>
<td><p>A multicast route has a larger number of ports than the RIFs on the switch.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>no container id retrieved for [str]</p></td>
<td><p>Egress container could not be retrieved.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>route cmd [str] failed: [str]</p></td>
<td><p>Setting multicast route in the SDK failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>router table_id [uint] vrid [int] set failed: [str]</p></td>
<td><p>Setting a VRID for a router failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate key list size [uint]</p></td>
<td><p>Unexpected duplicate entry found in next-hop list.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate key type [str] min_mtu [uint] fid [uint]</p></td>
<td><p>Unexpected duplicate entry in container anchor.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate nh_list num_elems [uint]</p></td>
<td><p>Unexpcted duplicate next-hop list in container.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed for nh_list num_elems [uint]: [str]</p></td>
<td><p>Could not create a new container for the next-hop list in the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed for type [str] container_id [uint] num_elems [uint]: [str]</p></td>
<td><p>Could not free a container for the next-hop list in the SDK.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unsupported chip type [uint]</p></td>
<td><p>Chip type in table is not supported.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>invalid parse depth</p></td>
<td><p>VXLAN parsing depth setting is invalid.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate ln_type [uint] ln_key [uint]</p></td>
<td><p>Unexpected duplicate entry in logical VPN key table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate ID 0x%x</p></td>
<td><p>Unexpected duplicate entry in logical VPN ID table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unsupported ln_type [int] or ln_key [int]</p></td>
<td><p>Unsupported logical network type encountered.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate ln_type [uint] ln_key [uint]</p></td>
<td><p>Unexpected duplicate entry in logical network table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>lid 0x%x remote_ip [str] not found</p></td>
<td><p>Local ID to remote_ip mapping retrieval failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate key [uint]</p></td>
<td><p>Unexpected duplicate entry in the VPN map table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>invalid VPN or vlan [uint]</p></td>
<td><p>Invalid VPN/VLAN value provided for creating a VPM map entry.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate entry</p></td>
<td><p>Unexpected duplicate entry in VPN decap table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>invalid VPN</p></td>
<td><p>Invalid VPN value provided for creating a VPN decap entry.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate key [str] type [uint]</p></td>
<td><p>Unexpected duplicate entry in VPN next-hop table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>tunnel get failed: [str]</p></td>
<td><p>Tunnel attribute retrieval from the SDK failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>tunnel update failed: [str]</p></td>
<td><p>Tunnel attribute update in the SDK failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>creation failed: [str]</p></td>
<td><p>VXLAN tunnel creation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>tunnel_id 0x%x hash set failed: [str]</p></td>
<td><p>VXLAN UDP header src port control setting in SDK for enabling better entropy failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unsupported type [uint]</p></td>
<td><p>Unsupported tunnel type encountered.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate key for tunnel_id 0x%x</p></td>
<td><p>Unexpected duplicate entry in logical VPN tunnel key table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate ID for tunnel_id 0x%x</p></td>
<td><p>Unexpected duplicate entry in logical VPN ID table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate ln_type [uint] ln_key [uint]</p></td>
<td><p>Unexpected duplicate entry in logical network table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>update failed: [str]</p></td>
<td><p>VXLAN tunnel update failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unsupported type [uint]</p></td>
<td><p>Unsupported tunnel type encountered.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>tunnnel_id 0x%x failed: [str]</p></td>
<td><p>VXLAN tunnel destroy failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>tunnel_id 0x%x ttl [uint] failed: [str]</p></td>
<td><p>VXLAN tunnel TTL set failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed: [str]</p></td>
<td><p>VXLAN tunnel map set failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vfid not available for vlan [uint]</p></td>
<td><p>VFID is not set for the specified VLAN.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed: [str]</p></td>
<td><p>VXLAN tunnel map set failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed: [str]</p></td>
<td><p>Tunnel decap entry could not be set.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed: [str]</p></td>
<td><p>Tunnel decap entry could not be set.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] group_id [uint] vid [uint] failed: [str]</p></td>
<td><p>FDB flood set for a group failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>group_id [uint] vid [uint] failed: [str]</p></td>
<td><p>FDB flood set for a group failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>creation failed: [str]</p></td>
<td><p>VPN device addition to the SDK failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate entry</p></td>
<td><p>VPN port table has an existing duplicate entry.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vpn_port 0x%x failed: [str]</p></td>
<td><p>VPN device deletion from the SDK failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>tunnel encap dscp action PRESERVE is invalid</p></td>
<td><p>PRESERVE is not a valid action.</p></td>
<td><p>Check configuration.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>tunnel_id 0x%x cos set failed: [str]</p></td>
<td><p>COS set failed for a tunnel.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>tunnel decap dscp action SET is invalid</p></td>
<td><p>SET is not a valid DSCP action.</p></td>
<td><p>Check configuration.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>tunnel_id 0x%x cos set failed: [str]</p></td>
<td><p>COS set failed for a tunnel.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>tunnel id not found: ln_type [uint] ln_key [uint]</p></td>
<td><p>Specified tunnel ID was not found in the VPN table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Error opening socket for grat arp [str], ifi [int]: [str]</p></td>
<td><p>Gratuitous ARP socket could not be opened.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Error sending grat arp [str], ifi [int]: [str]</p></td>
<td><p>Gratuitous ARP socket could not be sent.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to update table id for port [int], interface [str]/[int]</p></td>
<td><p>table_id could not be updated for a port.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>interface not found at index [int]</p></td>
<td><p>Interface information for a given ifindex could not be found.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to open IPv4 socket [str]</p></td>
<td><p>IPv4 socket open failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to set SO_RCVBUF [str]</p></td>
<td><p>Socket option SO_RCVBUF set failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>No source MAC address ifindex [int], [str]</p></td>
<td><p>No source MAC address found for given ifiindex.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to open IPv6 socket [str]</p></td>
<td><p>IPv6 socket open failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to set SO_RCVBUF [str]</p></td>
<td><p>Socket option SO_RCVBUF set failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>No source MAC address ifindex [int], [str]</p></td>
<td><p>No source MAC address found for given ifiindex.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Adding ctx to hash table failed</p></td>
<td><p>Adding ctx to hash table failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Getting pktinj failed</p></td>
<td><p>Getting pktinj failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ERSPAN target is supported with the following field(s): --src-ip &lt;ipaddr&gt; --dst-ip &lt;ipaddr&gt;.</p></td>
<td><p>ACL unsupported ERSPAN target.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for UDP</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Specified Match [str] not supported</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Specified Target [str] not supported</p></td>
<td><p>ACL unsupported target.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for ARP</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for IP</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for IPv6</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Traffic class [hex] not supported for IP</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Range for ICMP Types i.e [hex]-[hex] not supported</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Range for ICMP codes i.e [hex]-[hex] not supported</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Invert flags not supported for mark_m</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>OR bitmask [hex] not supported for mark_m match</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for VLAN</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for ICMP</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vlanid match not supported for VLAN</p></td>
<td><p>ACL vlanid usupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>vlan prio match not supported for VLAN</p></td>
<td><p>ACL vlan prio unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>IP, IPv6, ARP options are not supported for LOG</p></td>
<td><p>ACL unsupported match for LOG action.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Interface [str] not supported for SPAN</p></td>
<td><p>ACL unsupported target.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>SPAN target is supported with the following</p></td>
<td><p>ACL unsupported SPAN target.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ERSPAN target is supported with the following</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for ICMPv6</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>target bitmask [hex] not supported for mark</p></td>
<td><p>ACL unsupported verdicts continue/return/etc.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Specified Match [str] not supported</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Specified watcher [str] not supported</p></td>
<td><p>ACL unsupported watcher action.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Specified target [str] not supported</p></td>
<td><p>ACL unsupported target action.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for Multiport</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for TOS</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for DSCP</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Inverse flags or Limit Interface or Source not supported for addrtype</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Dest addrtypes other than IPROUTER/LOCAL not supported</p></td>
<td><p>ACL unsupported match for addrtype.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>IP6 Fragment IDs not supported</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>IP6 Length/Reserved or Last or More fragment Fields not supported</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Greater/Lesser/Not equal to mode not supported for TTL field</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Greater/Lesser/Not equal mode not supported for HL field</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Inverse flags not supported for match mark</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>TCP SEQ, TCP Options or IP options, UID are not supported for LOG</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>TCP SEQ, TCP Options or IP options, UID are not supported for LOG</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Inverse flags or options not supported for TCP</p></td>
<td><p>ACL inverse match not supported.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Interface [str] not supported for SPAN</p></td>
<td><p>ACL unsupported target interface in SPAN rule.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>SPAN target is supported with the following " field(s): --dport swp&lt;n&gt;."</p></td>
<td><p>ACL unsupported SPAN target.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Interface [str] not supported for SPAN</p></td>
<td><p>ACL unsupported target interface.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>SPAN target is supported with the following field(s): --dport swp&lt;n&gt;.</p></td>
<td><p>ACL unsupported SPAN target.</p></td>
<td><p>See ACL user documentation.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>resource region [uint] destroy failed: [str]</p></td>
<td><p>ACL: Mellanox API for region destroy failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>resource region [uint] size [uint] create failed: [str]</p></td>
<td><p>ACL: Mellanox API for TCAM region create failed.</p></td>
<td><p>Check if there are too many rules/tables.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate key [str]</p></td>
<td><p>ACL: Internal interface cache has duplicate.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate user: [str] key_idx [val] offset [val]</p></td>
<td><p>ACL: Duplicate entry in interface rule hash.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>expected trap_id [uint] (actual [uint]) type [uint] (actual [val])</p></td>
<td><p>ACL: INPUT chain trap counter get ID invalid.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] [str] size [uint] creation failed: [str]</p></td>
<td><p>ACL: Mellanox API for TCAM region create failed.</p></td>
<td><p>Check if there are too many rules/tables.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] [str] size [uint] acl_id creation failed: [str]</p></td>
<td><p>ACL: Mellanox API for ACL ID create failed.</p></td>
<td><p>Check if there are too many rules/tables.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] [str] rules del @offset [val] num_rules [val] failed: [str]</p></td>
<td><p>ACL: Mellanox API for setting region to ACL ID failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] [str] size [uint] acl_id destroy failed: [str]</p></td>
<td><p>ACL: Mellanox API for unsetting region from ACL ID failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] [str] size [uint] destroy failed: [str]</p></td>
<td><p>ACL: Mellanox API for region destroy failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] [str] rules add @offset [val] num_rules [val] failed: [str]</p></td>
<td><p>ACL: Mellanox API for setting rule in a region failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] failed to allocate Mark value [val]</p></td>
<td><p>ACL: Mark value alloc failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] Mark values must be less than [val] when partial mask is in use</p></td>
<td><p>ACL: Masked mark use limitation.</p></td>
<td><p>Change mask match rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>PBR: Unsupported route type ecmp</p></td>
<td><p>PBR: Invalid ECMP route.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>PBR: Unsupported route type singe hop</p></td>
<td><p>PBR: Invalid non-ECMP route.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] action [str] is not supported</p></td>
<td><p>ACL: Unsupported action.</p></td>
<td><p>Remove rule with the action.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>PBR: couldn't set default forward action for rule</p></td>
<td><p>PBR: Default action accept couldn't be set for PBR rules.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] offset [uint] or key_idx [uint] exceeds rule list size [uint] or descriptor size [val]</p></td>
<td><p>ACL: Too may rules in a region.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] offset [uint] key_idx [uint] invalid key_id [uint]</p></td>
<td><p>ACL: Invalid src/dst port/intf in rule.</p></td>
<td><p>Remove the rule.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>acl group [str] creation failed: [str]</p></td>
<td><p>ACL: Mellanox API for ACL group create failed.</p></td>
<td><p>Check for too many ACL tables</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] key handle create failed: [str]</p></td>
<td><p>ACL: Mellanox API to create a key list handle failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] key attr query failed: [str]</p></td>
<td><p>ACL: Mellanox API to get key attributes failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] key handle delete failed: [str]</p></td>
<td><p>ACL: Mellanox API for key handle delete failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] [str] size [uint] offset too large</p></td>
<td><p>ACL: Rule offset in region larger than region size.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>region set failed: [str]</p></td>
<td><p>ACL: Mellanox API for TCAM region create failed.</p></td>
<td><p>Check if there are too many rules/tables.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>acl set failed: [str]</p></td>
<td><p>ACL: Mellanox API for ACL ID create failed.</p></td>
<td><p>Check if there are too many rules/tables.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>rules set failed: [str]</p></td>
<td><p>ACL: Mellanox API for rule set failed.</p></td>
<td><p>Check if there are too many rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] malloc failed</p></td>
<td><p>ACL: Memory resource allocation error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] too many keys in rule</p></td>
<td><p>ACL: Too many keys used in a rule.</p></td>
<td><p>Delete the rule.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] too many actions in rule"</p></td>
<td><p>ACL: Too many actions in rule.</p></td>
<td><p>Modify the rule.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] rule can match on a single output interface only</p></td>
<td><p>ACL: Rule match limitation.</p></td>
<td><p>Delete the rule.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] number of input interfaces ([uint]) cannot be less than number of output interfaces ([val])</p></td>
<td><p>ACL: Rule replication limitation.</p></td>
<td><p>Remove the rule.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] key classification missing for [val] input bridge interface(s)</p></td>
<td><p>ACL: Ingress/egress intf missing.</p></td>
<td><p>Check ACL rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] key classification missing for [val] input interface(s)</p></td>
<td><p>ACL: Ingress/egress port/bond missing.</p></td>
<td><p>Check ACL rules.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>analyzer set failed: [str]</p></td>
<td><p>ACL: Mellanox API for setting ERSPAN analyzer port failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>session [uint] [str] failed: [str]</p></td>
<td><p>ACL: Mellanox API for en/dis of SPAN session failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>session [uint] edit failed: [str]</p></td>
<td><p>ACL: Mellanox API for ERSPAN session modify failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>session [uint] [str] lid 0x%x add failed: [str]</p></td>
<td><p>ACL: Mellanox API to set SPAN mirror source failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>session [uint] [str] lid 0x%x delete failed: [str]</p></td>
<td><p>ACL: Mellanox API to unset SPAN mirror sources failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>span init failed: [str]</p></td>
<td><p>ACL: Mellanox API for SPAN engine initialization failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Unexpected duplicate session key</p></td>
<td><p>ACL: Duplicate SPAN session key.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>session create failed: [str]</p></td>
<td><p>ACL: Mellanox API for session create failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>out of SPAN/ERSPAN sessions</p></td>
<td><p>ACL: Too many SPAN/ERSPAN session targets.</p></td>
<td><p>Check and reduce SPAN sesions.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>session [uint] analyzer delete failed: [str]</p></td>
<td><p>ACL: Mellanox API for session delete failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>session [uint] destroy failed: [str]</p></td>
<td><p>ACL: Mellanox API for for session destroy failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Non flow-based SPAN does not support router interface</p></td>
<td><p>ACL: Non-flow based cannot SPAN from routed interface.</p></td>
<td><p>Remove these SPAN rules.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Non flow-based SPAN does not support sub-interface</p></td>
<td><p>ACL: Non-flow based cannot SPAN from routed sub-interface.</p></td>
<td><p>Remove these SPAN rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unsupported session_type [uint]</p></td>
<td><p>ACL: Mirror session has to be SPAN or ERSPAN.</p></td>
<td><p>Remove these rules.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>router interface ([str]) is not supported as SPAN dport</p></td>
<td><p>ACL: SPAN destination cannot be router interface.</p></td>
<td><p>Remove these rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unsupported chip type [uint]</p></td>
<td><p>ACL: Wrong plaform/chip type.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>policer creation failed: [str]</p></td>
<td><p>ACL: Mellanox internal API to allocate a policer resource failed.</p></td>
<td><p>Check number of ACL rules using policers.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate ID [val]</p></td>
<td><p>ACL: Duplicate policer ID allocated.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>policer [val] delete failed [str]</p></td>
<td><p>ACL: Mellnox internal API to delete policer resource failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>tricolor conversion failed pir [uint] cir [uint] cbs [val] ebs [val]</p></td>
<td><p>ACL: Converting tricolor policer rates to kbps failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>conversion failed mode [uint] rate [uint] burst [uint]</p></td>
<td><p>ACL: Converting color bind policer rates to kpbs failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>counter creation failed: [str]</p></td>
<td><p>ACL: Mellanox internal API for allocating a counter failed.</p></td>
<td><p>Check number of ACL rules.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>counter [uint] delete failed: [str]</p></td>
<td><p>ACL: Mellanox internal API for counter delete failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>counter [uint] failed: [str]</p></td>
<td><p>ACL: Mellanox internal API for counter read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>policer [val] counter failed: [str]</p></td>
<td><p>ACL: Mellanox internal API for for policer counter read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>invalid interface [str]</p></td>
<td><p>ACL: Invalid interface specified in ACL rule.</p></td>
<td><p>Check ACL rule set.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>bond id [uint] not fully established</p></td>
<td><p>ACL: Bond interface not fully up.</p></td>
<td><p>Check bond interface configuration on local/remote ends.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unsupported interface type: [str]</p></td>
<td><p>ACL: An ACL rule has an unsupported type of interface specified in match.</p></td>
<td><p>Check ACL rule set for interfaces specified.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>mixing PBS ports in different swids [uint] and [uint] is not allowed</p></td>
<td><p>ACL: SPAN using policy-based switching doesn't support target ports in different units.</p></td>
<td><p>Change SPAN rule configuration.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate PBS key with [uint] port(s)</p></td>
<td><p>ACL: Duplicate PBS key used for SPAN.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>create failed for PBS record with [uint] port(s): [str]</p></td>
<td><p>ACL: Mellanox internal API for PBS set failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>pbs_id [uint] delete failed: [str]</p></td>
<td><p>ACL: Mellanox internal API for PBS ID delete failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] failed for pbs_id [uint]: [str]</p></td>
<td><p>ACL: Mellanox internal API for PBS ID delete failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>group [str] set failed: [str]</p></td>
<td><p>ACL: Mellanox internal API that binds an ACL group to a hardware resource like port/VLAN failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>user tokens exhausted</p></td>
<td><p>ACL: Mellanox internal API for user token alloc failed.</p></td>
<td><p>Check number of ACL rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>hardware platform does not support user tokens</p></td>
<td><p>ACL: Mellanox plaform doesn't support user tokens.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate mark key [uint]</p></td>
<td><p>ACL: User token duplicate allocated.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>bind [str] set failed on port 0x%x: [str]</p></td>
<td><p>ACL: Mellanox internal API that binds an ACL group to a port failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>bind [str] unset failed on port 0x%x: [str]</p></td>
<td><p>ACL: Mellanox internal API that unbinds an ACL group from a port failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>bind [str] cmd [uint] failed on bond 0x%x: [str]</p></td>
<td><p>ACL: Mellanox internal API that un/binds an ACL group with a bond interface failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>bind [str] set failed on port 0x%x: [str]</p></td>
<td><p>ACL: Mellanox internal API that binds an ACL group to a bond member failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>bind [str] cmd [uint] failed on RIF 0x[uint]: [str]</p></td>
<td><p>ACL: Mellanox internal API that binds an ACL group to an L3 ingress interface failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>group set failed: [str]</p></td>
<td><p>ACL: Mellanox internal API that sets the group of an ACL failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>range creation failed: [str]</p></td>
<td><p>ACL: Mellanox internal API to allocate an L4 port range resource failed.</p></td>
<td><p>Check number of ranges being used in ACLs.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>range delete failed: [str]</p></td>
<td><p>ACL: Mellanox internal API to free an L4 port range resource failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] [str] size [uint] creation failed: [str]</p></td>
<td><p>ACL: Mellanox API for TCAM region create failed.</p></td>
<td><p>Check if there are too many rules/tables.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] [str] size [uint] acl_id creation failed: [str]</p></td>
<td><p>ACL: Mellanox API for ACL ID create failed.</p></td>
<td><p>Check if there are too many rules/tables.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] chain [str] region [str] [str] rules del @offset [val] num_rules [val] failed: [str]</p></td>
<td><p>ACL: Mellanox API for setting region to ACL ID failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] [str] chain [str] region [str] [str] rules del @offset [val] num_rules [val] failed: [str]</p></td>
<td><p>ACL: Mellanox API for setting region to ACL ID failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>table [str] [str] chain [str] region [str] [str] size [uint] acl_id destroy failed: [str]</p></td>
<td><p>ACL: Mellanox API for unsetting region from ACL ID failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] [str] chain [str] region [str] [str] size [uint] destroy failed: [str]</p></td>
<td><p>ACL: Mellanox API for region destroy failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>acl group [str] creation failed: [str]</p></td>
<td><p>ACL: Mellanox API for ACL group create failed.</p></td>
<td><p>Check for too many ACL tables.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>table [str] [str] chain [str] region [str] [str] size [uint] offset too large</p></td>
<td><p>ACL: Rule offset in region larger than region size.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>region set failed: [str]</p></td>
<td><p>ACL: Mellanox API for TCAM region create failed.</p></td>
<td><p>Check if there are too many rules/tables.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>acl set failed: [str]</p></td>
<td><p>ACL: Mellanox API for ACL ID create failed.</p></td>
<td><p>Check if there are too many rules/tables.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>rules set failed: [str]</p></td>
<td><p>ACL: Mellanox API for rule set failed.</p></td>
<td><p>Check if there are too many rules.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>iACL action cannot be satisfied with eACL key</p></td>
<td><p>ACL: Invalid dependency between ingress and egress ACLs.</p></td>
<td><p>Check ACL rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>eACL action cannot be satisfied with iACL key</p></td>
<td><p>ACL: Invalid dependency between ingress and egress ACLs.</p></td>
<td><p>Check ACL rules.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ACL can match one single output interface only</p></td>
<td><p>ACL: Don't support multiple out interface match.</p></td>
<td><p>Check ACL rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>expected trap_id [uint] (actual [uint]) type [uint] (actual [val])</p></td>
<td><p>ACL: INPUT chain trap counter get ID invalid.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] [str] API [str]: dlerror [str]</p></td>
<td><p>nftables unsupported.</p></td>
<td><p>Ignore this error message.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Memory allocation failed</p></td>
<td><p>ACL out of memory resource.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Rule with LOG must be followed by same rule with DROP</p></td>
<td><p>An ACL rule with a LOG action must be followed by same rule with a DROP action.</p></td>
<td><p>See ACL user documentaion for more info.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Rule with LOG must be followed by same rule with DROP</p></td>
<td><p>An ACL rule with a LOG action must be followed by same rule with a DROP action.</p></td>
<td><p>See ACL user documentaion for more info.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Rule with log watcher must be have DROP action</p></td>
<td><p>An ACL rule with a watcher action must be followed by same rule with a DROP action.</p></td>
<td><p>See ACL user documentaion for more info.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Rule with LOG must be followed by same rule with DROP</p></td>
<td><p>An ACL rule with a LOG action must be followed by same rule with a DROP action.</p></td>
<td><p>See ACL user documentaion for more info.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] not found in hal_bonds</p></td>
<td><p>ACL: Bond interface in rule not present.</p></td>
<td><p>Check bond configuration.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Inverse flags for SRC/DST IP, IN/OUT interface, TOS, Protocol not supported</p></td>
<td><p>ACL inverse match flags are not supported.</p></td>
<td><p>See ACL user documentaion.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Target Verdict :[str] not supported</p></td>
<td><p>ACL rule target verdict queue/stop/return/etc not supported.</p></td>
<td><p>See ACL user documentation for supported targets.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Fall through target not supported</p></td>
<td><p>ACL fall through action not supported.</p></td>
<td><p>See ACL documentation for supported actions.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Jump, target:[val] not supported</p></td>
<td><p>ACL jump action not supported.</p></td>
<td><p>See ACL documentation for supported actions.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Module, target:[str] not supported</p></td>
<td><p>Specified ACL action not supported.</p></td>
<td><p>See ACL documentation for supported actions.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>iptables: Invalid argument</p></td>
<td><p>iptables rules likely empty.</p></td>
<td><p>Check iptables rules list.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>iptables:Could not open raw IPv4,socket.</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>iptables:Error retrieving getsockopt SO_GET_INFO:</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>iptables: Memory allocation for counters failed for size</p></td>
<td><p>ACL out of memory resource.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>iptables: Error retrieving getsockopt SO_GET_ENTRIES:</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>iptables: Memory allocation for rules failed for size</p></td>
<td><p>ACL out of memory resource.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Inverse flags for SRC/DST IP, IN/OUT interface, TOS, Protocol not supported</p></td>
<td><p>ACL inverse match flags are not supported.</p></td>
<td><p>See ACL user documentaion.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Target Verdict :[str] not supported</p></td>
<td><p>ACL rule target verdict queue/stop/return/etc not supported.</p></td>
<td><p>See ACL user documentation for supported targets.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Fall through target not supported</p></td>
<td><p>ACL fall through action not supported.</p></td>
<td><p>See ACL documentation for supported actions.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Jump, target:[val] not supported</p></td>
<td><p>ACL jump action not supported.</p></td>
<td><p>See ACL documentation for supported actions.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Module, target:[str] not supported</p></td>
<td><p>Specified ACL action not supported.</p></td>
<td><p>See ACL documentation for supported actions.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>iptables: Invalid argument</p></td>
<td><p>iptables rules likely empty.</p></td>
<td><p>Check iptables rules list.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ip6tables:Could not open raw IPv6,socket.</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ip6tables:Error retrieving getsockopt SO_GET_INFO:</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ip6tables: Memory allocation for rules failed for size</p></td>
<td><p>ACL out of memory resource.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ip6tables: Error retrieving getsockopt SO_GET_ENTRIES:</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>iptables: Memory allocation for rules failed for size</p></td>
<td><p>ACL out of memory resource.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>arptables:Could not open raw IPv6 socket.</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>arptables:Error retrieving getsockopt SO_GET_INFO: [str]</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>arptables: Error retrieving getsockopt SO_GET_ENTRIES: [str]</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Inverse flags for SRC/DST MAC, IN/OUT/logical interface, Protocol not supported</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL documentation for supported matches.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>logical interface in:[str] out:[str] not supported</p></td>
<td><p>ACL unsupported match.</p></td>
<td><p>See ACL documentation for supported matches.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Protocol field: LENGTH not supported</p></td>
<td><p>ACL unsupported LENGTH field match for Ethernet packets.</p></td>
<td><p>See ACL documentation for supported matches.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Policy not supported</p></td>
<td><p>ACL unsupported ebtables action continue/return/etc.</p></td>
<td><p>See ACL documentation for supported actions.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Target verdict: [str] not supported</p></td>
<td><p>ACL unsupported ebtables verdict.</p></td>
<td><p>See ACL documentation for supported actions.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Fall through or Jump target not supported</p></td>
<td><p>ACL fall through/jump action not supported.</p></td>
<td><p>See ACL documentation for supported actions.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Target verdict: [str] not supported</p></td>
<td><p>ACL target verdict queue/stop/return/etc not supported.</p></td>
<td><p>See ACL user documentation for supported targets.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ebtables: Invalid argument</p></td>
<td><p>iptables rules likely empty or read from kernel failed.</p></td>
<td><p>Check ebtables rules list or file a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ebtables:Could not open raw IPv4,socket.</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ebtables:Error retrieving getsockopt SO_GET_INFO:</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ebtables: Memory allocation for rules failed for size</p></td>
<td><p>ACL out of memory resource.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ebtables: Error retrieving getsockopt SO_GET_ENTRIES:</p></td>
<td><p>Internal socket error.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>sfs_add: [str] failed</p></td>
<td><p>ACL: FUSE file system node creation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>MAX retries reached, stats sync acl failed - %d</p></td>
<td><p>ACL: Kernel updation of stats failed after retries.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>sync_acl hardware installation failed</p></td>
<td><p>Hardware offload of ACL rule set failed, typically due to TCAM resource exhaustion and/or unsupported rules.</p></td>
<td><p>Check the ACL rule set/number of rules/user documentation.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ACL: Restore of current table failed: sync_acl hardware installation failed</p></td>
<td><p>Hardware restore of previously installed ACL rule set failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>kernel tunnel not found for if_key [str]</p></td>
<td><p>L2: Failed to lookup a tunnel interface.</p></td>
<td><p>Check configuration.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] duplicate member [str] for bridge [int]</p></td>
<td><p>L2: Duplicate bridge in hash table.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>tc: u32 ip: unknown match: handle: [hex] index:[int] off:[int] offmask:[hex] val:[hex] mask: [hex]</p></td>
<td><p>TC rule harware offload unsupported.</p></td>
<td><p>Remove TC rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>tc: u32 ip: match parse failed: handle: [hex], index:[int], rv: [int]</p></td>
<td><p>TC rule harware offload unsupported.</p></td>
<td><p>Remove TC rule.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>TC: [str]</p></td>
<td><p>TC rule harware offload unsupported.</p></td>
<td><p>Remove TC rule.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>TC: sync_clss hardware installation failed</p></td>
<td><p>TC rule harware offload unsupported.</p></td>
<td><p>Remove TC rule.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>IPRULE: sync to h/w failed in non atomic mode. IPRULE rules deleted. Please retry</p></td>
<td><p>Failed to install ACL rules.</p></td>
<td><p>Remove ACL rules and reinstall ACL rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>IPRULE: event handler failed</p></td>
<td><p>Failed to install ACL rules.</p></td>
<td><p>Remove ACL rules and reinstall ACL rules.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>TC: sync to h/w failed in non atomic mode. TC rules deleted. Please retry</p></td>
<td><p>Failed to install ACL rules.</p></td>
<td><p>Remove ACL rules and reinstall ACL rules.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>TC: event handler failed</p></td>
<td><p>Syncing database failed between kernel and switchd.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>sigaction failed for signal [int], [str]</p></td>
<td><p>Failed to initialize signal handler.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Ignoring VRF [str]; table id 0 is reserved for default VRF</p></td>
<td><p>Failed to add a new entry in the ARP table.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Unable to setup handling of SIGHUP for log rotation: [str]</p></td>
<td><p>Failed to create a polling thread in NIC init.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>read error on fd errno [int]</p></td>
<td><p>Failed to attach a port in NIC.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] duplicate member [str] for bridge [int]</p></td>
<td><p>Failed to allocate a member in the kernel bridge.</p></td>
<td><p>Please check there are no duplicate bridge members.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str]: no context</p></td>
<td><p>Failed to append the CSV command in Prescriptive Topology Manager.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str]: Could not append key</p></td>
<td><p>Failed to append CSV command in Prescriptive Topology Manager</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str]: Could not append val</p></td>
<td><p>Failed to append CSV command in Prescriptive Topology Manager</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str]: Could not allocate csv</p></td>
<td><p>Failed to initialize the CSV command in Prescriptive Topology Manager.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str]: Could not allocate record</p></td>
<td><p>Failed to initialize the CSV command in Prescriptive Topology Manager.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str]: Could not allocate context</p></td>
<td><p>Failed to initialize the CSV command in Prescriptive Topology Manager.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str]: no context</p></td>
<td><p>Failed to complete the CSV command in Prescriptive Topology Manager.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str]: cannot serialize</p></td>
<td><p>Failed to complete the CSV command in Prescriptive Topology Manager.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>fatal recv error([str]), closing connection, rc [int]</p></td>
<td><p>Failed to complete the CSV command in Prescriptive Topology Manager.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Cannot allocate csv for msg</p></td>
<td><p>Failed to read the CSV command in Prescriptive Topology Manager.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str]: Could not allocate context</p></td>
<td><p>Failed to decode the CSV command in Prescriptive Topology Manager.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>STP mode_set failed for port [int]: [str]</p></td>
<td><p>Failed to set spanning tree mode in port [uint], error msg [str]. Forwarding behavior would be impacted by this failure.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to set port [int] vlan_ingress_filter enable</p></td>
<td><p>Failed to set VLAN ingress filter for port [uint], error msg [str].</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to set FDB polling interval swid [uint]: [str]</p></td>
<td><p>Failed to set FDB polling interval for Mellanox SDK switchd id [int], error msg [str]. Failure to do this impacts MAC address learning behavior.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to set FDB notify_params swid [uint]: [str]</p></td>
<td><p>Failed to set FDB MAC address learning notification in Mellanox SDK for switch id [uint], error msg [str]. This error impacts the capability of the switch to learn MAC address.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to create trap group [uint] trap id [uint] swid [uint] group_attr.prio : [int] error: [str]</p></td>
<td><p>Failed to create the TRAP groups in the Mellanox SDK. Traps groups are used for policing trap IDs, which are used to punt control packets to OS stack. This failure impacts packet forwarding.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to open host ifc group [uint] trap id [uint] swid [uint] error [str]</p></td>
<td><p>Failed to retrieve the file descriptor of the current open channel to the Mellanox SDK, for ifc group [uint] trap ID [uit] swid [uint], error msg [str]. The error is not recoverable.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to obtain group [uint] FD for polling</p></td>
<td><p>Failed to retrieve the FD for a trap group [id]. The error is not recoverable.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to define trap [uint] group [uint] swid [uint] error: [str]</p></td>
<td><p>Failed to set trap ID [uint], trap group [uint], switch ID [uint], for user defined trap, error msg [str] .</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to set trap [uint] group [uint] swid [uint] error: [str]</p></td>
<td><p>Failed to set trap ID [uint], trap group [uint], switch ID [uint], for user defined trap, error msg [str].</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to register trap [uint] swid [uint] error: [str]</p></td>
<td><p>Failed to register trap ID [uint] in switch ID [uint] in Mellanox SDK, error msg [str].</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>trap_id [uint] was not installed</p></td>
<td><p>Trap ID [uint] was not installed in the Mellanox SDK. This would impact packet forwarding from the switch ASIC to the control plane.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>trap_id [uint] was not installed</p></td>
<td><p>Trap ID [uint] was not installed in the Mellanox SDK. This would impact packet forwarding from the switch ASIC to the control plane.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>dflt_trap_parsing_depth get failed: [str]</p></td>
<td><p>Failed to retrieve the Mellanox Spectrum chip parsing depth from Mellanox SDK, error msg [str]. Possibly the parsing depth has not been set correctly. This would impact hardware packet forwarding.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>new_depth [uint] failed: [str]</p></td>
<td><p>Failed to set the packet parsing depth [uint] in Mellanox SDK, error msg [str]. This failure impacts hadrware packet forwarding.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to set trap [uint] group [uint] swid [uint] action [uint] error: [str]</p></td>
<td><p>Failed to set trap ID [uint], trap group [uint], switch ID [uint], trap action. Failure would lead to the respective control packet not reaching the CPU.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] failed to convert trap policer attributes</p></td>
<td><p>Failed to get the policer unit for policer group name [str]. Policer unit can be metered with unit of packets for bytes.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] failed to create policer: [str]</p></td>
<td><p>Failed to create policer for policer group [str], error msg [str]. Failure to set policer would impact packet forwarding from hadrware data path to CPU.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] sw_rate_limiter set failed: [str]</p></td>
<td><p>Failed to set the software rate limiter for policy group [str] in Mellanox SDK, error msg [str]. This failure could impact rate limiting for packets forwarded to CPU.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>group [str] failed to edit policer: [str]</p></td>
<td><p>Failed to modify policer for policer group [str], error msg [str]. Failure to set policer would impact packet forwarding from hadrware data path to CPU.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unknown trap group [uint]</p></td>
<td><p>A trap group ID [uint] unknown to the Mellanox SDK is being used to configure the Mellanox SDK policer. This is an internal configuration error.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>group [str] failed to bind policer %" PRIu64 ": [str]</p></td>
<td><p>Policer group [str] with policer ID [uint64] failed to bind in the Mellanox SDK, error msg [str]. This error would impact policing of packets being forwarded from hardware to CPU.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>group [str] failed to unbind policer %" PRIu64 ": [str]</p></td>
<td><p>Policer group [str] with policer ID [uint64] failed to unbind in the Mellanox SDK, error msg [str]. This error would impact policing of packets being forwarded from hardware to CPU.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unsupported type [uint]</p></td>
<td><p>Failed to create a trap counter type as the trap counter type [uint] does not match one of the well-defined ones in the Mellanox SDK. This is an internal configuration error.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unsupported type [uint]</p></td>
<td><p>Failed to create a trap counter type as the trap counter type [uint] does not match one of the well-defined ones in Mellanox SDK. This is an internal configuration error.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>type [uint] failed: [str]</p></td>
<td><p>Failed to retrieve the host IFC counter for the counter type [int] from the Mellanox SDK, error msg [str].</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unknown meter_type [uint]</p></td>
<td><p>Incorrect policer unit [uint] used to find out the policer group meter unit. Policer unit can be metered with unit of packets for bytes. This is an internal error.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unrecognized lid [hex]</p></td>
<td><p>Failed to retrieve the interface key from logical port id [uint].</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] unexpected duplicate key [uint]</p></td>
<td><p>Failed to add an interface [str] vport with internal VLAN ID [uint] in external VLAN vport hash table because of duplicate entry [uint].</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] int_vid [uint] ext_vid [uint]: [str]</p></td>
<td><p>Failed to create a virtual port from logical port, interface [str], internal vlan id [uint] and external vlan id[uint], error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Unexpected duplicate vport_lid [hex] for [str]</p></td>
<td><p>Failed to add vport logical interface id [uint], interface [str], in vlan vport hash table because of duplicate entry [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>delete failed for [str] int_vid [uint] ext_vid [uint]: [str]</p></td>
<td><p>Failed to delete a virtual port from logical port, interface [str], internal vlan id [uint] and external vlan id [uint], error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] vrid not found for table [uint]</p></td>
<td><p>virtual router id not found in virtual id table [id] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>delete failed for int_vid [uint] ext_vid [uint] vport_lid [hex] : [str]</p></td>
<td><p>Failed to delete a virtual port from logical port, internal vlan id [uint], virtual port logical if [uint] and external vlan id [uint], error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] vrid not found for table [uint]</p></td>
<td><p>virtual router id not found in virtual id table [id] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>port [int] ext_vlan [int] already exists</p></td>
<td><p>port [uint] and external vlan [uint] already exists in the e2i table</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] int_vlan [int] already assigned to [str]</p></td>
<td><p>interface [str] with internal vlan [uint] is already assigned to interface [str] in the e2i table. This is an internal configration error</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to get base bond for [str]</p></td>
<td><p>Failed to get the bond interface for interface [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to add to interface ht s[str]</p></td>
<td><p>Failed to add interface [str] to the ifp hash table because an entry already exists</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] old_int_vlan [int] inconsistent</p></td>
<td><p>interface [str] with vlan [uint] is inconsistent in the e2i table</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] new_int_vlan [int] already assigned to [str]</p></td>
<td><p>interface [str] with internal vlan [uint] is already assigned to interface [str] in the e2i table. This is an internal configration error</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>UC flood block [uint] failed for [str] vlan [uint]: [str]</p></td>
<td><p>unicast flood block [uint] failed for interface [str] for vlan id [uint], error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>learn mode [uint] failed for [str] vlan [uint]: [str]</p></td>
<td><p>learn mode [uint] failed for interface [str] and internal vlan [uint], error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>error processing bridge vlan information</p></td>
<td><p>error processing bridge vlan information</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>bond_mbrs_vlan_port_set failed for bond: [int]</p></td>
<td><p>failed to set vlan for bond members for bond id [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unsupported interface type: [uint]</p></td>
<td><p>unsupported interface type [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>cannot find STG for bridge_vlan [uint] vid [uint]</p></td>
<td><p>cannot find the spanning tree group for bridge vlan [uint] and vlan id [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>flood_mode_set failed for swid [int] vid [int]</p></td>
<td><p>Flood mode could not be set for unregistered multicast in swid [uint] vlan id [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>vlans set failed for [str]: [str]</p></td>
<td><p>setting of vlan failed for interface [str], error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>qinq mode set failed for [str]: [str]</p></td>
<td><p>failed to set qinq mode for interface [str], error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>qinq mode set failed for [str]: [str]</p></td>
<td><p>failed to set qinq mode for bond for interface [str], error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unsupported interface type: [uint]</p></td>
<td><p>unsupported interface type [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>bond id [uint] not fully created</p></td>
<td><p>bond id [uint] creation is not complete</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>cannot find bridge vlan for bridge: [int]</p></td>
<td><p>unable to find bridge vlan for the bridge id [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>cannot find bond vlan for bond</p></td>
<td><p>cannot find bond vlan for the bond</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>cannot allocate vlan for bond interface</p></td>
<td><p>Failed to allocate vlan for bond interface</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>cannot allocate vlan for sub-interface</p></td>
<td><p>Failed to allocate vlan for sub interface</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>gre tunnel decap entry creation failed : [str]</p></td>
<td><p>Failed to create decapsulation entry in mellanox SDK. Decapsulation of GRE packet woould not be operational, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>gre tunnel decap destroy failed : [str]</p></td>
<td><p>Failed to delete the GRE decapsulation entry in mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>gre tunnel curr decap entry delete failed : [str]</p></td>
<td><p>Failed to delete the GRE decapsulation entry in mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>gre tunnel new decap entry update failed : [str]</p></td>
<td><p>Failed to create decapsulation entry in mellanox SDK. Decapsulation of GRE packet woould not be operational, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to make logical gre key</p></td>
<td><p>Failed to form the logical GRE key from the interface information provided</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to make gre decap key</p></td>
<td><p>Failed to form the logical decap GRE key from the information provided</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to make overlay key from underlay key</p></td>
<td><p>Failed to create overlay gre key from underlay information</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unable to find gre entry for tunnel id ([hex]</p></td>
<td><p>Failed to find gre entry from tunnel id in the gre tunnel key hash table, using tunnel id [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>duplicate entry in overlay ht : ifindex ([int]</p></td>
<td><p>Unable to add a duplicate gre entry with ifindex [uint] in the gre overlay hash table. A duplicate config is being attempted</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to create overlay rif : ifindex : [int] tunnel type [uint] key [uint]</p></td>
<td><p>Unable to create an overlay router interface with ifindex [uint] , tunnel type [uint] and tunel key [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>gre tunnel creation failed: [str] :</p></td>
<td><p>Failed to create tunnel id for GRE in Mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>invalid argument</p></td>
<td><p>GRE update is being called with an invalid GRE information, no operation would be performed</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>gre tunnel ([hex]) update failed: [str] :</p></td>
<td><p>Failed to update tunnel id [hex] for GRE in Mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>gre tunnel destroy failed: [str]</p></td>
<td><p>Failed to delete tunnel id for GRE in Mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>loopback rif for ifindex ([int]) : [str]</p></td>
<td><p>Failed to add the loopback router interface, interface ifindex [uint] in Mellanox SDK, error [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ifindex ([int]) overlay rif ([int]) : [str]</p></td>
<td><p>Failed to delete the loopback router interface, interface ifindex [uint], overlay router interface [uint] in Mellanox SDK, error [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>cannot allocate bridge vlan for bridge id [int]</p></td>
<td><p>Failed to allocate bridge vlan for bridge id [uint]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>flood_mode_set failed for swid [int] vid [int]</p></td>
<td><p>Flood mode could not be set for unregistered multicast in swid [uint] vlan id [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>cannot allocate ln_vlan [uint] for bridge_id [int]</p></td>
<td><p>Failed to allocate vlan [uint] for bridge id [uint]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>flood_mode_set failed for swid [int] vid [int]</p></td>
<td><p>Flood mode could not be set for unregistered multicast in swid [uint] vlan id [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vlan [uint] not yet allocated</p></td>
<td><p>vlan [uint] does not exists for the bridge and is not allocated</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] bridge_id [uint] vlan [uint] port [hex] failed: [str]</p></td>
<td><p>failed to add a unicast mac address [str] on bridge id [uint] vlan [uint] port [uint]. This could be an internal error or could be because of configuration error</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] bridge_id [uint] vlan [uint] port [hex] failed: [str]</p></td>
<td><p>failed to delete a unicast mac address [str] on bridge id [uint] vlan [uint] port [uint]. This could be an internal error or could be because of configuration error</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>num_macs [uint] num_failed_macs [uint] delete failed: [str]</p></td>
<td><p>failed to delete a number [uint] of unicast mac address, error msg [str]. This could be an internal error or could be because of configuration error</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>num_macs [uint] learn set failed: [str]</p></td>
<td><p>failed to add [uint] unicast mac addressess, error msg [str]. This could be because of resource exhaustion</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>num_macs [uint] delete failed: [str]</p></td>
<td><p>failed to delete a number [uint] of unicast mac address, error message [str]. This could be an internal error or could be because of configuration error</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>age_time set failed [str] on swid [uint]</p></td>
<td><p>Failed to set fdb ageing time. This would cause the mac addresses in FDB not to age mac address</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>cannot find vlan for brmac [str] vfid [uint]</p></td>
<td><p>vlan [uint] does not exists for the bridge and so could not find the vlan for bridge mac address</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vfid not set for vlan [uint]</p></td>
<td><p>failed to return a translated vlan id for vlan [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>num_macs [uint] delete failed: [str]</p></td>
<td><p>failed to delete a number [uint] of unicast mac address, error msg [str]. This could be an internal error or could be because of configuration error</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>bridge_vlan [uint] expected swid [uint] but found [uint]</p></td>
<td><p>bridge vlan id [uint] expected switchd id [uint] for the vlan is [uint] switch id</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>num_macs [uint] delete failed: [str]</p></td>
<td><p>failed to delete a number [uint] of unicast mac address, error msg [str]. This could be an internal error or could be because of configuration error</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>bridge_vlan [uint] expected swid [uint] but found [uint]</p></td>
<td><p>bridge vlan id [uint] expected switchd id [uint] for the vlan is [uint] switch id</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>get failed: [str]</p></td>
<td><p>Failed to get fdb unicast mac address from Mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>num_macs [uint] delete failed: [str]</p></td>
<td><p>failed to delete a unicast mac address [str] on bridge id [uint] vlan [uint] port [uint]. This could be an internal error or could be because of configuration error</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>internal vlans exhausted</p></td>
<td><p>total number of internal vlan has exhausted. No morevlans could be addded</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>identity map failed for vlan [uint]: [str]</p></td>
<td><p>Failed to map the forwarding id to the vlan id [uint] in mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>learn mode_failed for vlan [uint]: [str]</p></td>
<td><p>failed to set the learning mode for vlan id [uint], error message [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to get members for vlan [uint]: [str]</p></td>
<td><p>Failed to get member port for vlan [uint], error message [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>vlan [uint] is not an L3 vlan</p></td>
<td><p>vlan [uint] entry is not representing a l3 interface</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unsupported interface type: [uint]</p></td>
<td><p>unsupported interface type [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[hex] int_vlan [uint] failed: [str]</p></td>
<td><p>failed to set the internal vlan [uint] for the logical port id [uint], error msg [str]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[hex] pvid [uint] failed: [str]</p></td>
<td><p>failed to set the logical interface [uint] to van id [uint], error msg [str]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[hex] int_vlan [uint] failed: [str]</p></td>
<td><p>failed to unset the internal vlan [uint] for the logical port id [uint], error msg [str]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[hex] revert pvid: [str]</p></td>
<td><p>failed to delete the logical interface [uint] to vlan id [uint], error msg [str]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unsupported interface type: [uint]</p></td>
<td><p>unsupported interface type [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unsupported interface type: [uint]</p></td>
<td><p>unsupported interface type [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed for lid [hex] int_vlan [uint] STG [uint]: [str]</p></td>
<td><p>Failed to set the spanning tree group for logical interface [uint], internal vlan [uint] spanning tree group [uint], error msg [%s]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unsupported if_type [uint]</p></td>
<td><p>unsupported interface type [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>port [str] not established</p></td>
<td><p>port interface [str] has not been established yet</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed for [str] lid [hex]: [str]</p></td>
<td><p>Failed to set the port, logical id [uint], interface [str], to accept the frame type, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>list allocation failed</p></td>
<td><p>failed to allocate memory for the ports</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>STGs exhausted</p></td>
<td><p>Total number of spanning tree group has exhausetd. please consult configuration manual</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>MSTP instance set failed for STG [int]: [str]</p></td>
<td><p>Failed to set the MSTP instance for the spanning tree group [uint] in mellanox SDK, error msg [str]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to delete STG [uint]: [str]</p></td>
<td><p>Failed to delete the MSTP instance for the spanning tree group [uint] in mellanox SDK, error msg [str]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to add vlan [int] to STG [int]: [str]</p></td>
<td><p>Failed to add vlan [uint] to spanning tree group [uint] in mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to remove vlan [int] from STG [int]: [str]</p></td>
<td><p>Failed to delete vlan [uint] to spanning tree group [uint] in mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>vlan [uint] not yet created</p></td>
<td><p>vlan [uint] does not exist and is not allocated</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>STG [int] not yet created</p></td>
<td><p>spanning tree group id [uint] is not created</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Duplicate vfid [uint]</p></td>
<td><p>Failed to add virtual forwarding id [uint] in hash table because of a duplicate entry</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>fdb_uc_mac_addr_get failed: [str]</p></td>
<td><p>Failed to get fdb unicast mac address from Mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to allocate mac_list</p></td>
<td><p>Failed to allocate mac address list</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>init set failed: [str]</p></td>
<td><p>Initilizition of router module in Mellanox SDK failed.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>hash params set failed: [str]</p></td>
<td><p>Initilizition of router ecmp hash module in Mellanox SDK failed.</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>router #[uint] set failed: [str]</p></td>
<td><p>Initilizition of virtual router id [uint] failed, because of error [str] in Mellanox SDK</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] failed cmd [str] vlan [uint] mac [str] fwd_state [str]: [str]</p></td>
<td><p>Routed interface description [str] failed to add/update/delete [str] with vlan [uint] mac [str] forwarding state [str]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] cmd [str] failed for vlan [uint] mac [str]: [str]</p></td>
<td><p>Routed interface description [str] failed to add/update/delete [str] with vlan [uint] mac [str] error [str]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed for intf [uint]: [str]</p></td>
<td><p>Failed to get retrieve router interface id [uint], errorstr [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed for vlan [uint] intf [uint]: [str]</p></td>
<td><p>Failed to delete interface for vlan [uint] interface id [uint] error [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>neigh delete all failed for intf [uint]: [str]</p></td>
<td><p>Deletion of all the neighbor entries for the interface id [uint] error [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>interface state set failed for l3_intf_id [uint]: [str]</p></td>
<td><p>Failed to set state for l3 interface id [uint] error [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>invalid router mac [str]</p></td>
<td><p>check for a unicast mac address [str] failed</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed for l3_intf_id [int] mac [str] vlan [uint]: [str]</p></td>
<td><p>Failed to add mac address [str] for interface id [uint] vlan [uint] error [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed for l3_intf_id [int] mac [str] vlan [uint]: [str]</p></td>
<td><p>Failed to delete mac address [str] for interface id [uint] vlan [uint] error [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Invalid table id: must be between [int] and [int]</p></td>
<td><p>An Invalid vrf id is being tried to program, vrf id should be in range of vrf id [uint] - [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>calloc failed to allocate a new ECMP entry</p></td>
<td><p>Failed to allocate a new entry for ECMP</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate SDK ecmp id [uint] (HAL ECMP id [int]</p></td>
<td><p>Failed to add an ECMP entry id [uint] in hash table because of duplicate ECMP ID [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unable to reconstruct original route [str]</p></td>
<td><p>Failed to construct a route [str] from a hardware entry to a hardware abstraction layer entry entry, for the purpose of updating the existing entry</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unable to obtain HW info for original route [str]</p></td>
<td><p>Failed to retrieve a route [str] from the hardware, for the purpose of updating the existing entry</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>activity get failed: [str]</p></td>
<td><p>Failed to check the neighbor activity information, error [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>route [str] not found in hal_routes</p></td>
<td><p>Failed to find the route [str] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate l3_intf_id [uint]</p></td>
<td><p>Found duplicate l3 interface id [uint] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate RIF param [uint]</p></td>
<td><p>Found duplicate l3 interface id [uint] parameters in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate l3_intf_id [uint] vlan [uint]</p></td>
<td><p>Found duplicate l3 interface id [uint] having vlan [uint] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed for vlan [uint] l3_intf_id [uint]: [str]</p></td>
<td><p>Failed to delete the router interface, vlan [uint] interface if [uint] in Mellanox SDK, error [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate entry</p></td>
<td><p>Failed to add the router interface because of duplicate entry</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>vlan not found for l3_intf_id [uint]</p></td>
<td><p>Failed retrieve l3 interface [uint] param</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] vlan [uint] does not exist for bridge_id [int]</p></td>
<td><p>vlan [uint] does not exists for the bridge id [uint]</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>[str] no bridge exists for bridge_id [int]</p></td>
<td><p>bridge id [uint] does not exists in the software database</p></td>
<td><p>Check The Cumulus Linux Configuration guide</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] cannot allocate vlan [uint] for bridge_id [int]</p></td>
<td><p>failed to allocate bridge id [uint] for vlan id [uint] in mellaox sdk</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>interface [str] not an svi</p></td>
<td><p>Interface [str] type is expected to be SVI, but it is not SVI</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] vrid not found for table [uint]</p></td>
<td><p>virtual router id not found in virtual id table [id] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>invalid interface: [str]</p></td>
<td><p>An interface check has found that the interface [str] is invalid</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>[str] vrid not found for table [uint]</p></td>
<td><p>virtual router id not found in virtual id table [id] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>neighbor set failed for netdev_rif [uint]: [str]</p></td>
<td><p>Setting up of a neighbor failed on the netdev router interface [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>neighbor delete failed: [str]</p></td>
<td><p>Deletion of the neighbor entry failed, error [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate:</p></td>
<td><p>Addition of the interface to the software table failed because of an already existing interface</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to get vrid for table [uint]</p></td>
<td><p>virtual router id not found in virtual id table [id] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to get vrid for table [uint]</p></td>
<td><p>virtual router id not found in virtual id table [id] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>route_op [uint] neighbor route must have a valid netdev:</p></td>
<td><p>route operation to add/del [uint] failed as the route does not have a valid next hop net device</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>cannot find vlan_if for next hop [str]</p></td>
<td><p>vlan interface [str] could not be found for the next hop, as the next hop programming is being done on a vlan interface</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>cannot find parent bond info</p></td>
<td><p>Failed to retrieve the master bond interface descriptor for port id [uint] and vlan id [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>no RIF found for [str]</p></td>
<td><p>Router interface [str] not found for neighbor</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected rif type [str]</p></td>
<td><p>A router interface type [str] found and it is an invalid type of router interface</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>neigh_get vrid [uint] failed: [str]</p></td>
<td><p>Failed to retrieve the neighbor from the virtual router id [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>failed to allocate neigh_entry_list</p></td>
<td><p>Failed to allocate memory for a list of neighbors</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>route cmd [str] failed for vrid [int]: [str]</p></td>
<td><p>Failed operation [str] on a unicast route on vrid [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>for [str]</p></td>
<td><p>Failed to set a unicast route [str] in mellanox SDK</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>route delete failed for [str]: [str]</p></td>
<td><p>Failed to delete route in route [str] in the Mellanox SDK, error msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate:</p></td>
<td><p>Found duplicate route in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unknown route type [uint]</p></td>
<td><p>Route inspected is an unknown route type [uint], unsupported by mellanox SDK</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ECMP SDK id [uint] not found</p></td>
<td><p>ECMP id [uint] for the route not found in the mellanox SDK</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to get vrid for table [uint]</p></td>
<td><p>virtual router id not found in virtual id table [id] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>too many next hops [int] for hal_route [str]</p></td>
<td><p>number of next hop [uint] exceeded the max limit for the route [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Cannot allocate an ECMP key</p></td>
<td><p>Failed to allocate an ECMP key to program a new route</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>Failed to get vrid for table [uint]</p></td>
<td><p>virtual router id not found in virtual id table [id] in software</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unknown route type [uint]</p></td>
<td><p>Route inspected is an unknown route type [uint], unsupported by mellanox SDK</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>route get failed for prefix_type [uint]: [str]</p></td>
<td><p>Failed to retrieve a unicast route from Mellanox SDK, error reason [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>Failed to get table_id for vrid [uint]</p></td>
<td><p>Failed to retrieve vritual router table id for virtual router id [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>sx_api_router_uc_route_get_all failed: [str]</p></td>
<td><p>Failed to retrieve a unicast route from Mellanox SDK, error reason [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>failed to allocate uc_route_entry_list</p></td>
<td><p>Failed to allocate a list for unicast route entries</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ECMP hal_route_to_hw_ecmp_key failed</p></td>
<td><p>Failed to retrieve a ecmp key for a route from mellanox SDK</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unable to find gre entry for tunnel</p></td>
<td><p>Failed to find a GRE tunnel entry</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unable to make logical gre key from if_key</p></td>
<td><p>Failed to create a logical GRE key from the interface key</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ECMP route contains one or more unresolvable nexthops</p></td>
<td><p>ECMP route has one or more unresolved next hop. So programming for the route is not performed</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ecmp: can't hold the ECMP entry</p></td>
<td><p>ECMP container NULL or invalid, so route entry programming would not be performed</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>onlink host route key setup failed</p></td>
<td><p>Failed to create onlink host route key</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>onlink host route creation failed</p></td>
<td><p>Failed to create onlink host route</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>sx_api_router_ecmp_clone_set failed on parent SDK ECMP ID [int]: [str]</p></td>
<td><p>Failed to clone ecmp route to the parent ecmp</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ecmp: empty ECMP container add failed: [str]</p></td>
<td><p>Failed to create a new and empty ecmp container with attriuts in mellanox SDK, status msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ecmp: ECMP [str] failed: [str] num_next_hops is [int]</p></td>
<td><p>Failed to (create/update) operation [str], an ecmp container, status msg [str], with number of nexthops [uint]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate ECMP key</p></td>
<td><p>Failed to add an ECMP key in ecmp key hash table, as a duplicate entry already exists</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate ECMP SDK id [uint]</p></td>
<td><p>Failed to add an ECMP id in ecmp id hash table, as a duplicate entry already exists</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ecmp_id [uint] delete failed: [str]</p></td>
<td><p>Failed to delete a ecmp entry, ecmp id [uint], status msg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>onlink host route key setup failed</p></td>
<td><p>Failed to create onlink host route key</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>ecmp pbr refcount: can't hold the ECMP sdkid: [int] entry</p></td>
<td><p>ecmp entry not found in the software while programming entries for PBR</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ecmp pbr refcount: can't put the ECMP sdkid: [int] entry</p></td>
<td><p>ecmp entry not found in the software while programming entries for PBR</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>SDK ecmp_id [uint] failed: [str]</p></td>
<td><p>Failed to set ecmp attributes with ecmp id [uint] in mellanox SDK, error mesg [str]</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate ECMP clone ID key</p></td>
<td><p>Failed to add an ECMP clone id in, clone id hash table, as a duplicate entry already exists</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>onlink host route not suppported on non-Spectrum backend</p></td>
<td><p>Onlink host route not supported on non-spectrum backend</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>onlink host route not suppported on non-Spectrum backend</p></td>
<td><p>Onlink host route not supported on non-spectrum backend</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>unexpected duplicate:</p></td>
<td><p>Failed to add an ECMP entry in hash table because a duplicate entry already exists</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>cannot find vlan_if for next hop [str]</p></td>
<td><p>vlan interface [str] could not be found for the next hop, as the next hop programming is being done on a vlan interface</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>invalid rif for [str]</p></td>
<td><p>An interface check found that routed interface [str] is invalid</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>hal_clag_set_port_egress_mask failed in backend[[int]] for</p></td>
<td><p>Failed to install egress mask on MLAG port.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>ERROR</p></td>
<td><p>hal_clag_set_ln_egress_mask failed in backend[[int]] for</p></td>
<td><p>Failed to install egress mask on VXLAN device.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>ERROR</p></td>
<td><p>ln_key [int] anycast_ip not set</p></td>
<td><p>MLAG anycast IP is not set.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_tc_prio_map_get hal port [int] returned [str]</p></td>
<td><p>ASIC egress queue map configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_tc_prio_map_set logical port 0x%x returned [str]</p></td>
<td><p>ASIC egress queue map configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>hal_mlx_priority_source_trust_get HAL port [int] logical port 0x%x returned [str]</p></td>
<td><p>ASIC priority source trust configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>hal_mlx_priority_source_trust_set HAL port [int] logical port 0x%x returned [str]</p></td>
<td><p>ASIC priority source trust configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>hal_mlx_rewrite_enable_get HAL port [int] logical port 0x%x returned [str]</p></td>
<td><p>ASIC priority rewrite enable configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>hal_mlx_rewrite_enable_set HAL port [int] logical port 0x%x returned [str]</p></td>
<td><p>ASIC priority rewrite enable configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_tc_mcaware_get hal port [int] returned [str]</p></td>
<td><p>ASIC MC buffer configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_tc_mcaware_set hal port [int] returned [str]</p></td>
<td><p>ASIC MC buffer configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_tc_prio_map_set hal port [int] returned [str]</p></td>
<td><p>ASIC egress queue map configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>buffer pool [int] size 0 is invalid: this pool was not created</p></td>
<td><p>Invalid buffer pool size.</p></td>
<td><p>Check back end QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Pool configuration mode [int] not recognized: defaulting to buffer units</p></td>
<td><p>Invalid parameter.</p></td>
<td><p>Check back end QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_shared_buff_pool_set for sw pool id [int] to size [int] (mode [int]) failed: [str],</p></td>
<td><p>ASIC buffer pool configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Hardware buffer pool index [int] too large (max is [int])</p></td>
<td><p>Too many buffer pools for ASIC limit.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_prio_buff_map_get failed for MLX port [int]: [str]</p></td>
<td><p>Priority group buffer map read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>switch priority [int] greater than max value [int]</p></td>
<td><p>Invalid switch priority.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_prio_buff_map_set failed for MLX port [int]: [str]</p></td>
<td><p>ASIC packet buffer configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>reserved buffer type [int] not recognized</p></td>
<td><p>Invalid buffer type.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>cos ID [int] larger than maximum switch priority value [int]</p></td>
<td><p>Invalid internal switch priority value.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>profile element index [int] too large for array size [int]: [int] map entries, priority field [int]</p></td>
<td><p>Priority profle index is too large for the array.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>[str] failed for MLX port 0x%x, buffer count [int]: [str]</p></td>
<td><p>ASIC packet buffer configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_shared_buff_pool_get failed, cannot get pool size or mode : [str]</p></td>
<td><p>ASIC buffer pool configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>pool [int] mode [int] not recognized</p></td>
<td><p>Invalid buffer pool mode.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>MLX logical port 0x%x: cos ID [int] larger than maximum switch priority value [int]</p></td>
<td><p>Invalid switch priority value.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>unlimited egress buffer for flow controlled switch priority [int]: unicast config may not match multicast config on some ports</p></td>
<td><p>Possible buffer configuration conflict.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_shared_buff_pool_get failed, cannot report pool configurations: [str]</p></td>
<td><p>ASIC buffer pool configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_pools_list_get, pool count == 0, failed: [str]</p></td>
<td><p>Buffer pool configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_pools_list_get, pool count == [uint] failed: [str]</p></td>
<td><p>Buffer pool configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_pool_buffer_list_get failed: [str]</p></td>
<td><p>Buffer pool configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_shared_buff_pool_get failed, cannot report pool configurations: [str]</p></td>
<td><p>ASIC packet buffer configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_pcpdei_to_prio_get port [int] (0x%x) returned [str]</p></td>
<td><p>ASIC L2 priority source map get operation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_buff_type_set failed for HAL port [int]/MLX port [int]: [str]</p></td>
<td><p>ASIC packet buffer configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_shared_buff_type_set failed for HAL port [int]/MLX port [int]: [str]</p></td>
<td><p>ASIC packet buffer configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_pcpdei_to_prio_set port [int] logical port 0x%x returned [str]</p></td>
<td><p>ASIC L2 priority source map set operation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_dscp_to_prio_get port [int] (0x%x) returned [str]</p></td>
<td><p>ASIC L3 priority source map get operation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_dscp_to_prio_set port [int] returned [str]</p></td>
<td><p>ASIC L3 priority source map set operation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_prio_to_pcpdei_rewrite_set hal port [int] element count [int]: returned [str]</p></td>
<td><p>ASIC L2 priority remark map set operation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>switch priority [int] color [int] pcp [int] deci [int]</p></td>
<td><p>failed L2 priority remark map.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_prio_to_dscp_rewrite_set hal port [int] logical_port [int] element count [int]: returned [str]</p></td>
<td><p>ASIC L3 priority remark map set operation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>switch priority [int] color [int] dscp [int]</p></td>
<td><p>failed L3 priority remark map.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_ets_element_get logical port 0x%x returned [str]</p></td>
<td><p>ASIC scheduler configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_ets_element_set (destroy) logical port 0x%x returned [str]</p></td>
<td><p>ASIC scheduler configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_ets_element_get hal port [int] returned [str]</p></td>
<td><p>ASIC scheduler configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_ets_element_set logical port 0x%x level [int] index [int] returned [str]</p></td>
<td><p>ASIC scheduler configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_ets_element_get hal port [int] returned [str]</p></td>
<td><p>ASIC scheduler configuration read failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_ets_element_set (destroy) hal port [int] returned [str]</p></td>
<td><p>ASIC scheduler configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_port_ets_element_set hal port [int] level [int] index [int] returned [str]</p></td>
<td><p>ASIC scheduler configuration write failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_port_pfc_enable_set hal port [int] returned [str]</p></td>
<td><p>ASIC priority flow control configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>switch priority [int] is not supported for MLX unit</p></td>
<td><p>Internal switch priority not supported.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_redecn_general_param_get returned [str]</p></td>
<td><p>ASIC ECN configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>hal_mlx_ecn_red_set HAL port [int] min_threshold_bytes [int] is less than minimum size, using [int] bytes</p></td>
<td><p>invalid parameter.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>hal_mlx_ecn_red_set HAL port [int] max_threshold_bytes [int] is greater than maximum size, using [int] bytes</p></td>
<td><p>invalid parameter.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_redecn_profile_set returned [str]</p></td>
<td><p>ASIC ECN configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_redecn_tc_enable_set returned [str]</p></td>
<td><p>ASIC ECN configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>sx_api_cos_redecn_profle_tc_bind_set for hal port [int] flow type [int] returned [str]</p></td>
<td><p>ASIC ECN configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>hal_sh_datapath_file_read: egress port MC buffer percent [perc] reduced to 100.0</p></td>
<td><p>Invalid egress port MC buffer value.</p></td>
<td><p>Check back end QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>priority group PG ID [int] is larger than the PG ID mask size [int]</p></td>
<td><p>Invalid priority group ID value configured.</p></td>
<td><p>Check back end QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>No priority group ID found for lossless traffic</p></td>
<td><p>No priority group ID found for lossless traffic.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_queue_info_set: port_q_count_get failed for hal port [int]</p></td>
<td><p>Could not find port queue limits.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>hal_sh_datapath_packet_buffer_set: [str]</p></td>
<td><p>Back end packet buffer config failed.</p></td>
<td><p>Check for detailed log messages.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>unable to set FEC parameters while autoneg is enabled</p></td>
<td><p>Invalid operation for the current port configuration.</p></td>
<td><p>Disable auto-negotiation on the port.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>ethtool settings nwords too large: [int]</p></td>
<td><p>Invalid parameter: using default.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_port_group_priority_map_get: arg is NULL</p></td>
<td><p>Invalid parameter.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_port_group_config_values_get: _port_group_find failed on [str] [str]</p></td>
<td><p>Port group not found or created.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_port_group_set_get: [str] port set not found</p></td>
<td><p>Port group port set not found.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_port_pause_config: config_port_pause failed: [str]</p></td>
<td><p>ASIC port pause configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_priority_flow_control_config: hal_port_pfc_set failed on hal port [int]: [str]</p></td>
<td><p>ASIC priority flow control configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_config_port_packet_buffers: [str]</p></td>
<td><p>ASIC packet buffer config failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_switch_priority_config: hal port [int]: [str]</p></td>
<td><p>_switch_priority_config: hal port [int]: [str]</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_config_port_packet_buffers: [str]</p></td>
<td><p>ASIC packet buffer config failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_priority_map_config: priority map direction [int] is larger then max value HAL_DATAPATH_PRIORITY_DIRECTION_MAX</p></td>
<td><p>Invalid parameter.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_priority_map_config: packet priority field [int] not supported</p></td>
<td><p>Invalid packet priority field(s).</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_hash_config: route_ecmp_max_paths_set failed: [str]</p></td>
<td><p>ASIC ECMP configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_hash_config: hash config failed: [str]</p></td>
<td><p>ASIC symmetric hash configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_hash_config: ecmp hash seed config faild: [str]</p></td>
<td><p>ASIC ECMP hash configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_hash_config: hash config failed: [str]</p></td>
<td><p>ASIC resilient hash configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_mpls_config: mpls enable config failed: [str]</p></td>
<td><p>ASIC MPLS configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_ecn_red_config: hal_datapath_ecn_red_set failed on hal port [int]: [str]</p></td>
<td><p>ASIC ECN/RED configuration failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_port_attribute_mark: flow control configuration conflict on hal port [int]:</p></td>
<td><p>Flow control configuration conflict.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>hal_datapath_forwarding_profile_get: forwarding table profile path was NULL</p></td>
<td><p>Memory allocation failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>hal_datapath_forwarding_profile_get: sfs_config_get failed for [str]</p></td>
<td><p>Missing forwarding table profile configuration.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>hal_datapath_init: packet priority source mapping configuration failed</p></td>
<td><p>Packet priority source map configuration failed.</p></td>
<td><p>Check for detailed log messages.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>hal_datapath_init: packet priority remark configuration failed</p></td>
<td><p>Packet priority remark map configuration failed.</p></td>
<td><p>Check for detailed log messages.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_config_value_read: sfs path is null</p></td>
<td><p>Invalid parameter.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_config_value_read: sfs_config_get [str] failed</p></td>
<td><p>Configuration parameter not found.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_config_value_read: sfs_config_get [str] returned NULL configuration</p></td>
<td><p>Configuration value not found.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_cos_show_node_create: sfs_add failed for CoS node</p></td>
<td><p>switchd fuse node create failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_priority_map_get: remark list has more than one packet priority value: configuring the first value</p></td>
<td><p>Ignoring surplus remark values.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>_priority_map_list_get: [str]</p></td>
<td><p>ASIC priority profile create failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>_switch_priority_config_values_get: scheduling algorithm [str] not recognized</p></td>
<td><p>Invalid scheduling algorithm.</p></td>
<td><p>Check QoS configuration file.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>hal_list_get: list type [int] is not supported</p></td>
<td><p>Invalid list type.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Couldn't read a random number [int] setting seed to [uint]</p></td>
<td><p>No ECMP hash seed found in file.</p></td>
<td><p>Check file or accept default random seed.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>Couldn't read a random number [int] setting seed1 to [uint]</p></td>
<td><p>No ECMP hash seed1 found in file.</p></td>
<td><p>Check file or accept default random seed.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Neighbor entry is not IPv4 or v6: [int]!</p></td>
<td><p>Netlink neighbor object has invalid family.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>Neighbor entry had unexpected flags [int]</p></td>
<td><p>Netlink neighbor object has unsupported flags.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>[str]: route table mode [int] not supported</p></td>
<td><p>Invalid route table ASIC mode.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>[str]: host table mode [int] not supported</p></td>
<td><p>Invalid neighbor table ASIC mode.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Route [[str]] is not IPv4 or v6 or MPLS, family: [int]</p></td>
<td><p>Netlink route object has invalid family.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>Route [[str]] has unexpected flags: [int]</p></td>
<td><p>Netlink route object has unsupported flags.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Route [[str]] has unexpected type: [int]</p></td>
<td><p>Netlink route object has unsupported type.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>Route [[str]] has unexpected tos: [int]</p></td>
<td><p>Netlink route object has unsupported TOS value.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Route [[str]] has non-NULL src.</p></td>
<td><p>Netlink route object has non-NULL source.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>Route [[str]] has non-zero iif: [int]</p></td>
<td><p>Netlink route object has non-NULL interface.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>[int] routes exceeded [int] ecmp NHs, and were truncated.</p></td>
<td><p>Routes exceeded per-route nexthop limit.</p></td>
<td><p>Modify route next-hop configuration.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>[int] routes reverted to non-ECMP due to NH table</p></td>
<td><p>Total number of nexthops did not fit in hardware table.</p></td>
<td><p>Modify route next-hop configuration.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>[str]: route table mode [int] not supported</p></td>
<td><p>Hardware route table is set to an incorrect mode.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>[str]: host table mode [int] not supported</p></td>
<td><p>Hardware host table is set to an incorrect mode.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>vpn_id 0x%x for ln_type [uint] ln_key [uint] tunnel_id 0x%x invalid local_ip [str]</p></td>
<td><p>Local IP for a tunnel is invalid.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>Error removing isolated port [int] from [int]. Error: [str]</p></td>
<td><p>Removing isolated VPN port from the SDK failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Error adding isolated port [int] to [int]. Error: [str]</p></td>
<td><p>Adding isolated VPN port to the SDK failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>Error removing isolated port [int] from [int].</p></td>
<td><p>Moving isolated VPN port from the SDK failed.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>[str]: failed to push port settings to hal. err = [int]</p></td>
<td><p>table_id could not be set for a port.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>[str] not found in grp [str], bridge [int]</p></td>
<td><p>A port not found in the given group for the specific bridge.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>grp [str] not found in bridge [int]</p></td>
<td><p>During deletion, an MDB group was not found for a specific bridge.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>lid 0x%x cannot be both SPAN source</p></td>
<td><p>ACL: SPAN source and target cannot be the same.</p></td>
<td><p>Remove the rule.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>CPU not supported as mirror port</p></td>
<td><p>ACL: Mirror target port cannot be CPU.</p></td>
<td><p>Remove these SPAN rules.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>table [str] [str] chain [str] L2 header field match not supported with IPv6 key</p></td>
<td><p>ACL: Specified match unsupported.</p></td>
<td><p>Remove the rule.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>table [str] [str] chain [str] IP TTL not supported with MAC+IPv4 key</p></td>
<td><p>ACL: Unsupported match.</p></td>
<td><p>Remove the rule.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>table [str] [str] chain [str] requires hardware IPv6 rule format but platform does not support MAC+IPv6 key combination</p></td>
<td><p>ACL: Unsupported match.</p></td>
<td><p>Remove the rule.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>table [str] [str] chain [str] requires hardware IPv4 rule but platform does not support IPv4 key with</p></td>
<td><p>ACL: Unsupported match.</p></td>
<td><p>Remove the rule.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>logical network type not supported</p></td>
<td><p>ACL: Unsupported interface type in internal VXLAN rules.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Detected excessive moves of mac address [str] on bridge [str], last seen on [str] and [str].</p></td>
<td><p>L2: Too many MAC moves seen.</p></td>
<td><p>Check network topology for loops or intrusion.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>Memory allocation failed</p></td>
<td><p>Memory exhausted.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Can't open configuration file [str]: [int]</p></td>
<td><p>Failed to read configuration file in SFS.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>tx failed with count [int], start %p</p></td>
<td><p>Failed to transfer packets in NIC.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>Detected excessive moves of mac address [str] on bridge [str],</p></td>
<td><p>Moved MAC addresses over threshold.</p></td>
<td><p> </p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>Unsupported command [str]</p></td>
<td><p>Wrong FEC command.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>genl_talk returned error for ifindex [int] ([str])</p></td>
<td><p>Failed to read cached settings in PORT.</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>new tag_state [str] mismatches with [str] for [str] int_vlan [uint]</p></td>
<td><p>The new configured tag state [str] mismatches with the old tag state [str] for the internal VLAN [id].</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>verbosity level for SDK module [uint] not present</p></td>
<td><p>incorrect verbosity level for the mellanox SDK module is being configured. This is an internal error</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>legacy SX2 nexthop route type [uint] not handled</p></td>
<td><p>for Legacy mellanox SX2 chip, next hop of route type [uint] not handled</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>hash_table_delete of clone parent from id_ht %p failed</p></td>
<td><p>Failed to delete an ECMP clone id in, clone id hash table, as a entry does not exists</p></td>
<td><p>File a ticket and contact Cumulus Support.</p></td>
</tr>
<tr class="even">
<td><p>WARNING</p></td>
<td><p>[str]: no parent for [str]</p></td>
<td><p>Missing parent interface</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
<tr class="odd">
<td><p>WARNING</p></td>
<td><p>[str]: no parent for [str]</p></td>
<td><p>Missing parent interface</p></td>
<td><p>File a ticket with Cumulus Support.</p></td>
</tr>
</tbody>
</table>
