---
title: Cumulus Linux 3.6 User Guide
author: Cumulus Networks
weight: -36
pageID: 8362022
subsection: true
cascade:
  product: Cumulus Linux
  version: "3.6"
  imgData: cumulus-linux-36
  siteSlug: cumulus-linux-36
  old: true
---

## Introducing Cumulus Linux

Cumulus Linux is the first full-featured Linux operating system for the networking industry. The [Debian Jessie](https://www.debian.org/releases/jessie/)-based, networking-focused distribution runs on hardware produced by a [broad partner ecosystem](http://cumulusnetworks.com/hcl/), ensuring unmatched customer choice regarding silicon, optics, cables, and systems.

This user guide provides in-depth documentation on the Cumulus Linux installation process, system configuration and management, network solutions, and monitoring and troubleshooting recommendations. In addition, the quick start guide provides an end-to-end setup process to get you started.

## What's New in this Release

For a list of the new features in this release, see {{<link url="Whats-New">}}. For bug fixes and known issues present in this release, refer to the {{<link url="Cumulus-Linux-3.6-Release-Notes" text="Cumulus Linux 3.6 Release Notes">}}.

## Open Source Contributions

To implement various Cumulus Linux features, Cumulus Networks has forked various software projects, like CFEngine, `Netdev` and some Puppet Labs packages. The forked code resides in the Cumulus Networks [GitHub repository](https://github.com/CumulusNetworks).

Cumulus Networks has also developed and released new applications as open source. The list of open source projects is on the [open source software](http://oss.cumulusnetworks.com/) page.

## Hardware Compatibility List

You can find the most up-to-date hardware compatibility list (HCL) [here](https://cumulusnetworks.com/hcl/). Use the HCL to confirm that your switch model is supported by Cumulus Networks. The HCL is updated regularly, listing products by port configuration, manufacturer, and SKU part number.

## Download the User Guide

You can download a PDF of the user guide for versions {{<exlink url="https://drive.google.com/file/d/1mEF27U26h-QaUwo88aAZev7cL6fZh0-n/view?usp=sharing" text="3.6.0">}}, {{<exlink url="https://drive.google.com/file/d/1j-bZo6hX7Q_xF2ik0tP-rUQU38vc01I_/view?usp=sharing" text="3.6.1">}} and {{<exlink url="https://drive.google.com/file/d/1NOlOo7csQ_UVCyPbgo9dkb7f_u_cfxQw/view?usp=sharing" text="3.6.2">}}.
