---
title: 802.1X Interfaces
author: NVIDIA
weight: 101
pageID: 8363046
---
The {{<exlink url="https://en.wikipedia.org/wiki/IEEE_802.1X" text="IEEE 802.1X protocol">}}
provides a method of authenticating a client (called a *supplicant*)
over wired media. It also provides access for individual MAC addresses
on a switch (called the *authenticator*) after those MAC addresses have
been authenticated by an authentication server - typically a
{{<link url="RADIUS-AAA" text="RADIUS">}}
(Remote Authentication Dial In User Service, defined by
{{<exlink url="https://tools.ietf.org/html/rfc2865" text="RFC 2865">}}) server.

A Cumulus Linux switch acts as an intermediary between the clients
connected to the wired ports and the authentication server, which is
reachable over the existing network. EAPOL (Extensible Authentication
Protocol (EAP) over LAN - EtherType value of 0x888E, defined by
{{<exlink url="https://tools.ietf.org/html/rfc3748" text="RFC 3748">}}) operates on top of the
data link layer; the switch uses EAPOL to communicate with supplicants
connected to the switch ports.

Cumulus Linux implements 802.1X through the Debian `hostapd` package,
which has been modified to provide the PAE (port access entity).

{{% imgOld 0 %}}

## Supported Features and Limitations

- 802.1X is supported on Broadcom-based switches (except the Hurricane2 switch). The Tomahawk, Tomahawk2, and Trident3 switch *must* be running in {{<link url="Netfilter-ACLs#nonatomic-update-mode-and-update-mode" text="nonatomic mode">}}.
- The protocol is supported on physical interfaces only (bridged/access only and routed interfaces) - such as swp1 or swp2s0; these interfaces cannot be part of a bond. However, 802.1X is **not** supported on eth0.
- Cumulus Linux 3.7.2 and later includes VRF support
- You can configure 802.1X interfaces for bridges in both {{<link url="VLAN-aware-Bridge-Mode" text="VLAN-aware mode">}} and {{<link url="Traditional-Bridge-Mode" text="traditional mode">}} using the following features:
  - Parking VLAN
  - Dynamic VLAN
  - MAB (MAC-based authentication bypass)
- MAB, parking VLAN and dynamic VLAN all require a bridge access port.
- In traditional bridge mode, parking VLANs and dynamic VLANs both require the destination bridge to have a parking VLAN ID or dynamic VLAN ID tagged subinterface, respectively.
- Enabling or disabling the 802.1X capability on ports results in `hostapd` reloading. However, existing authorized sessions do not get reset.
- Changing any of the following RADIUS parameters restarts `hostapd`, which forces existing, authorized users to re-authenticate:
  - The RADIUS server IP address, shared secret, authentication port or accounting port
  - Parking VLAN ID
  - MAB activation delay
  - EAP reauthentication period
  - Removing all 802.1X interfaces
  {{%notice note%}}

Changing the `interface dot1x`, `dot1x mab`, or `dot1x parking-vlan` settings do not reset existing authorized user ports.

  {{%/notice%}}
- You can configure up to three RADIUS servers for failover purposes.
- NVIDIA performed tests with only a few `wpa_supplicant` (Debian), Windows 10 and Windows 7 supplicants.
- RADIUS authentication is supported with FreeRADIUS and Cisco ACS.
- Supports simple login/password, PEAP/MSCHAPv2 (Win7) and EAP-TLS (Debian).
- 802.1X supports {{<exlink url="https://tools.ietf.org/html/rfc5281" text="RFC 5281">}} for EAP-TTLS, which provides more secure transport layer security.
- There is no support for Mako template-based configurations.
- Cumulus Linux 3.7.4 and later includes support for Multi Domain Authentication (MDA), where 802.1X is extended to allow authorization of multiple devices (a data and a voice device) on a single port and assign different VLANs to the devices based on authorization:
  - MDA is enabled by default; however, you need to assign a tagged VLAN for voice devices see {{<link url="#configure-8021x-interfaces-for-a-vlan-aware-bridge" text="Configure 802.1X Interfaces for a VLAN-aware Bridge">}}).
  - A maximum of four authorized devices (MAB + EAPOL) per port are supported.
  - The 802.1X enabled port must be a trunk port to allow tagged voice traffic from a phone; you cannot enable 802.1X on an access port.
  - Only one untagged VLAN and one tagged VLAN is supported on the 802.1X enabled ports
  - Multiple MAB (non voice) devices on a port are supported for VLAN-aware bridges only. Authorization of multiple MAB devices for different VLANs is not supported.
  - The MAB timer is not required (see {{<link url="#configure-mac-authentication-bypass" text="Configure MAC Authentication Bypass">}}).

## Install the 802.1X Package

If you upgraded Cumulus Linux from a version earlier than 3.3.0 instead
of performing a full disk install, you need to install the `hostapd`
package on your switch:

```
cumulus@switch:~$ sudo -E apt-get update
cumulus@switch:~$ sudo -E apt-get install hostapd
cumulus@switch:~$ sudo -E apt-get upgrade
```

## Configure the RADIUS Server

Before you configure any interfaces for 802.1X, configure the RADIUS
server.

{{%notice note%}}

Do not use a Cumulus Linux switch as the RADIUS server.

{{%/notice%}}

To add a popular and freely available RADIUS server called FreeRADIUS on
a Debian workstation, do the following:

```
root@radius:~# apt-get update
root@radius:~# apt-get install freeradius
```

When installed and configured, the FreeRADIUS server can serve Cumulus
Linux running `hostapd` as a RADIUS client.

For more information, see the {{<exlink url="http://freeradius.org/doc/" text="FreeRADIUS documentation">}}.

## Configure 802.1X Interfaces

{{<link url="Network-Command-Line-Utility-NCLU" text="NCLU">}}
handles all the configuration of 802.1X interfaces, updating `hostapd`
and other components so you do not have to manually modify configuration
files. All the interfaces share the same RADIUS server settings.

The 802.1X-specific settings are:

- **accounting-port**: RADIUS accounting parameters, which defaults to *1813*.
- **authentication-port**: RADIUS authentication port, which defaults
  to *1812*.
- **server-ip**: RADIUS Server IPv4 or IPv6 address, which has no
  default, but is required. In Cumulus Linux 3.7.2 and later, you can
  also specify a VRF.
- **shared-secret**: RADIUS shared secret, which has no default, but
  is required.

### Configure 802.1X Interfaces for a VLAN-aware Bridge

Make sure you configure the RADIUS server before you configure the 802.1X interfaces. See {{<link url="#configure-the-radius-server" text="Configure the RADIUS Server">}}, above for details.

1. Create a simple interface bridge configuration on the switch and add the switch ports that are members of the bridge. You can use glob syntax to add a range of interfaces. The MAB and parking VLAN configurations require interfaces to be bridge access ports. The VLAN-aware bridge must be named *bridge* and there can be only one VLAN-aware bridge on a switch.

       cumulus@switch:~$ net add bridge bridge ports swp1-4

2. Configure the settings for the 802.1X RADIUS server, including its IP address and shared secret:

       cumulus@switch:~$ net add dot1x radius server-ip 127.0.0.1
       cumulus@switch:~$ net add dot1x radius shared-secret testing123

   In Cumulus Linux 3.7.2 and later, you can specify a VRF for outgoing RADIUS accounting and authorization packets. The following example specifies a VRF called blue:

       cumulus@switch:~$ net add dot1x radius server-ip 127.0.0.1 vrf blue
       cumulus@switch:~$ net add dot1x radius shared-secret mysecret

3. Enable 802.1X on interfaces.

       cumulus@switch:~$ net add interface swp1-4 dot1x
       cumulus@switch:~$ net pending
       cumulus@switch:~$ net commit

   In Cumulus Linux 3.7.4 and later, to assign a tagged VLAN for voice devices and assign different VLANs to the devices based on authorization, run these commands:

       cumulus@switch:~$ net add interface swp1-4 dot1x voice-enable
       cumulus@switch:~$ net add interface swp1-4 dot1x voice-enable vlan 200
       cumulus@switch:~$ net pending
       cumulus@switch:~$ net commit

These commands create the following configuration snippet in the
`/etc/network/interfaces` file:

```
cumulus@switch:~$ cat /etc/network/interfaces   
...     
auto swp1
iface swp1
    bridge-learning off
     
auto swp2
iface swp2
    bridge-learning off
     
auto swp3
iface swp3
    bridge-learning off
     
auto swp4
iface swp4
    bridge-learning off
...     
auto bridge
iface bridge
    bridge-ports swp1 swp2 swp3 swp4
    bridge-vlan-aware yes
```

Verify the 802.1X configuration, showing the configuration and its
status:

```
cumulus@switch:~$ net show configuration commands | grep dot1x
dot1x radius server-ip 127.0.0.1
dot1x radius authentication-port 1812
dot1x radius accounting-port 1813
dot1x radius shared-secret testing123
interface swp2,swp3,swp1,swp4 dot1x
     
cumulus@switch:~$ net show dot1x status
IEEE802.1X Enabled Status: enabled
IEEE802.1X Active Status: active
```

### Configure 802.1X Interfaces for a Traditional Mode Bridge

{{%notice note%}}

NCLU and `hostapd` may change traditional mode configurations on the
`bridge-ports` line in `/etc/network/interface` by adding or deleting
special 802.1X traditional mode `bridge-ports` configuration stanzas in
`/etc/network/interfaces.d/`. It is important that the `source`
configuration command in `/etc/network/interfaces` include these special
configuration filenames. It should include at least `source
/etc/network/interfaces.d/*.intf` in order to not prevent these files
from being sourced during an `ifreload`.

{{%/notice%}}

1. Create some uplink ports. The following example uses bonds:

       cumulus@switch:~$ net add bond bond1 bond slaves swp5-6
       cumulus@switch:~$ net add bond bond2 bond slaves swp7-8

2. Create a traditional mode bridge configuration on the switch and add the switch ports that are members of the bridge. Traditional bridge cannot be named *bridge* as that name is reserved for the single VLAN-aware bridge on the switch. You can use glob syntax to add a range of interfaces.

       cumulus@switch:~$ net add bridge bridge1 ports swp1-4

3. Create bridge associations with the parking VLAN ID and the dynamic VLAN IDs. In this example, *600* is used for the parking VLAN ID and 700 is used for the dynamic VLAN ID:

       cumulus@switch:~$ net add bridge br-vlan600 ports bond1.600
       cumulus@switch:~$ net add bridge br-vlan700 ports bond2.700

4. Configure the settings for the 802.1X RADIUS server, including its IP address and shared secret:

       net add dot1x radius server-ip 127.0.0.1
       net add dot1x radius shared-secret testing123

   In Cumulus Linux 3.7.2 and later, you can specify a VRF for outgoing RADIUS accounting and authorization packets.The following example specifies a VRF called blue:

       cumulus@switch:~$ net add dot1x radius server-ip 127.0.0.1 vrf blue
       cumulus@switch:~$ net add dot1x radius shared-secret mysecret

5. Enable 802.1X on interfaces, then review and commit the new configuration.

       cumulus@switch:~$ net add interface swp1-2 dot1x
       cumulus@switch:~$ net pending
       cumulus@switch:~$ net commit

Verify the 802.1X configuration, showing the configuration and its status:

```
cumulus@switch:~$ net show dot1x status
     
Hostapd IEEE 802.11 AP and IEEE 802.1X/WPA/WPA2/EAP Authenticator Daemon
Attribute                Value
-----------------------  ----------------
Current Status           active (running)
Reload Status            enabled
Interfaces               swp1 swp2
MAB Interfaces
Parking VLAN Interfaces
Dynamic VLAN Status      Disabled

cumulus@switch:~$ net show dot1x interface summary
     
Interface  MAC Address        Username  State       Authentication Type  MAB  VLAN
---------  -----------------  --------  ----------  -------------------  ---  ----
swp1       00:02:00:00:00:01  host1     AUTHORIZED  MD5                  NO
swp2       00:02:00:00:00:02  host2     AUTHORIZED  MD5                  NO
```

## Configure the Linux Supplicants

A sample FreeRADIUS server configuration needs to contain the entries
for users *host1* and *host2* on swp1 and swp2 for them to be placed in
a VLAN.

```
host1 Cleartext-Password := "host1password"
host2 Cleartext-Password := "host2password"
```

After being configured, each supplicant needs the proper credentials:

```
user@host1:~# cat /etc/wpa_supplicant.conf
     
ctrl_interface=/var/run/wpa_supplicant
ctrl_interface_group=0
eapol_version=2
ap_scan=0
network={
        key_mgmt=IEEE8021X
        eap=TTLS MD5
        identity="host1"
        anonymous_identity="host1"
        password="host1password"
        phase1="auth=MD5"
        eapol_flags=0
}

user@host2:~# cat /etc/wpa_supplicant.conf
     
ctrl_interface=/var/run/wpa_supplicant
ctrl_interface_group=0
eapol_version=2
ap_scan=0
network={
        key_mgmt=IEEE8021X
        eap=TTLS MD5
        identity="host2"
        anonymous_identity="host2"
        password="host2password"
        phase1="auth=MD5"
        eapol_flags=0
}
```

To test that a supplicant (client) can communicate with the Cumulus
Linux Authenticator switch, install the wpasupplicant package:
```
root@radius:~# apt-get update
root@radius:~# apt-get install wpasupplicant
```

And run the following command from the supplicant:

```
root@host1:/home/cumulus# wpa_supplicant -c /etc/wpa_supplicant.conf -D wired -i swp1
Successfully initialized wpa_supplicant
swp1: Associated with 01:80:c2:00:00:03
swp1: CTRL-EVENT-EAP-STARTED EAP authentication started
swp1: CTRL-EVENT-EAP-PROPOSED-METHOD vendor=0 method=4
swp1: CTRL-EVENT-EAP-METHOD EAP vendor 0 method 4 (MD5) selected
swp1: CTRL-EVENT-EAP-SUCCESS EAP authentication completed successfully
swp1: CTRL-EVENT-CONNECTED - Connection to 01:80:c2:00:00:03 compl
```

Or from another supplicant:

```
root@host2:/home/cumulus# wpa_supplicant -c /etc/wpa_supplicant.conf -D wired -i swp1
Successfully initialized wpa_supplicant
swp1: Associated with 01:80:c2:00:00:03
swp1: CTRL-EVENT-EAP-STARTED EAP authentication started
swp1: CTRL-EVENT-EAP-PROPOSED-METHOD vendor=0 method=4
swp1: CTRL-EVENT-EAP-METHOD EAP vendor 0 method 4 (MD5) selected
swp1: CTRL-EVENT-EAP-SUCCESS EAP authentication completed successfully
swp1: CTRL-EVENT-CONNECTED - Connection to 01:80:c2:00:00:03 comp
```

## Configure Accounting and Authentication Ports

You can configure the accounting and authentication ports in Cumulus
Linux. The default values are *1813* for the accounting port and *1812*
for the authentication port.

You can also change the reauthentication period for Extensible
Authentication Protocol (EAP). The period defaults to *0* (no
re-authentication is performed by the switch).

```
cumulus@switch:~$ net add dot1x radius authentication-port 2812
cumulus@switch:~$ net add dot1x radius accounting-port 2813
cumulus@switch:~$ net add dot1x eap-reauth-period 86400
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

## Configure MAC Authentication Bypass

MAC authentication bypass (MAB) enables bridge ports to allow devices to
bypass authentication based on their MAC address. This is useful for
devices that do not support PAE, such as printers or phones.

{{%notice note%}}

  - In Cumulus Linux 3.7.3 and earlier, MAB supports one authenticated
    MAC address per port only. After a source MAC address is
    authenticated, the port exits MAB mode. Cumulus Linux 3.7.4 and
    later provides support for Multi Domain Authentication (MDA), where
    802.1X is extended to allow authorization of multiple devices on a
    single port and assign different VLANs to the devices based on
    authorization.
  - You must configure MAB on both the RADIUS server and the RADIUS
    client.
  - When using a VLAN-aware bridge, the switch port must be part of
    bridge named bridge.

{{%/notice%}}

To configure MAB in Cumulus Linux 3.7.3 and earlier, enable a bridge
port for MAB and change the MAB activation delay. You can change the MAB
activation delay from the default of 30 seconds, but the delay must be
between 5 and 30 seconds. After the delay limit is reached, the port
enters MAB mode.

```
cumulus@switch:~$ net add dot1x mab-activation-delay 20
cumulus@switch:~$ net add interface swp1 dot1x mab
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

To configure MAB In Cumulus Linux 3.7.4 and later, enable a bridge port
for MAB. The MAB activation delay is not used. For example:

```
cumulus@switch:~$ net add interface swp1 dot1x mab
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

To verify the configuration, run the `net show dot1x status` command:

```
cumulus@switch:~$ net show dot1x status
     
Hostapd IEEE 802.11 AP and IEEE 802.1X/WPA/WPA2/EAP Authenticator Daemon
Attribute                Value
-----------------------  ----------------
Current Status           active (running)
Reload Status            enabled
Interfaces               swp1 swp2
MAB Interfaces           swp1
Parking VLAN Interfaces
Dynamic VLAN Status      Disabled

cumulus@switch:~$ net show dot1x interface summary

Interface  MAC Address        Username      State         Authentication Type  MAB  VLAN
---------  -----------------  ------------  ------------  -------------------  ---  ----
swp1       00:02:00:00:00:08  000200000008  AUTHORIZED    unknown              YES
```

## Configure a Parking VLAN

If a non-authorized supplicant tries to communicate with the switch, you
can route traffic from that device to a different VLAN and associate
that VLAN with one of the switch ports to which the supplicant is
attached.

For VLAN-aware bridges, the parking VLAN is assigned by manipulating the
PVID of the switch port. For traditional mode bridges, Cumulus Linux
identifies the bridge associated with the parking VLAN ID and moves the
switch port into that bridge. If an appropriate bridge is not found for
the move, then the port remains in an unauthenticated state where no
packets can be received or transmitted.

When using a VLAN-aware bridge, the switch port must be part of bridge
named *bridge*.

```
cumulus@switch:~$ net add dot1x parking-vlan-id 777
cumulus@switch:~$ net add interface swp1 dot1x parking-vlan
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

If the authentication for swp1 fails, the port is moved to the parking
VLAN:

```
cumulus@switch:~$ net show dot1x interface swp1 details

Interface  MAC Address        Attribute                     Value
---------  -----------------  ----------------------------  -----------------
swp1       00:02:00:00:00:08  Status Flags                  [PARKED_VLAN]
                              Username                      vlan60
                              Authentication Type           MD5
                              VLAN                          777
                              Session Time (seconds)        24772
                              EAPOL Frames RX               9
                              EAPOL Frames TX               12
                              EAPOL Start Frames RX         1
                              EAPOL Logoff Frames RX        0
                              EAPOL Response ID Frames RX   4
                              EAPOL Response Frames RX      8
                              EAPOL Request ID Frames TX    4
                              EAPOL Request Frames TX       8
                              EAPOL Invalid Frames RX       0
                              EAPOL Length Error Frames Rx  0
                              EAPOL Frame Version           2
                              EAPOL Auth Last Frame Source  00:02:00:00:00:08
                              EAPOL Auth Backend Responses  8
                              RADIUS Auth Session ID        C2FED91A39D8D605
```

To verify the configuration, run the `net show dot1x interface summary` command:

```
cumulus@switch:~$ net show dot1x interface summary
     
Interface  MAC Address        Username      State         Authentication Type  MAB  VLAN
---------  -----------------  ------------  ------------  -------------------  ---  ----
swp1       00:02:00:00:00:08  vlan60        PARKING VLAN  MD5                  NO   777
```

The following output shows a parking VLAN association failure. VLAN
association failure only occurs with traditional mode bridges when there
is no traditional bridge available with a parking VLAN ID-tagged
subinterface in it (notice the \[UNKNOWN\_BR\] status in the output):

```
cumulus@switch:~$ net show dot1x interface swp3 details

Interface  MAC Address        Attribute                     Value
---------  -----------------  ----------------------------  -------------------------
swp1       00:02:00:00:00:08  Status Flags                  [PARKED_VLAN][UNKNOWN_BR]
                              Username                      vlan60
                              Authentication Type           MD5
                              VLAN                          777
                              Session Time (seconds)        24599
                              EAPOL Frames RX               3
                              EAPOL Frames TX               3
                              EAPOL Start Frames RX         1
                              EAPOL Logoff Frames RX        0
                              EAPOL Response ID Frames RX   1
                              EAPOL Response Frames RX      2
                              EAPOL Request ID Frames TX    1
                              EAPOL Request Frames TX       2
                              EAPOL Invalid Frames RX       0
                              EAPOL Length Error Frames Rx  0
                              EAPOL Frame Version           2
                              EAPOL Auth Last Frame Source  00:02:00:00:00:08
                              EAPOL Auth Backend Responses  2
                              RADIUS Auth Session ID        C2FED91A39D8D605
```

## Configure Dynamic VLAN Assignments

A common requirement for campus networks is to assign dynamic VLANs to
specific users in combination with IEEE 802.1x. After authenticating a
supplicant, the user is assigned a VLAN based on the RADIUS
configuration.

For VLAN-aware bridges, the dynamic VLAN is assigned by manipulating the
PVID of the switch port. For traditional mode bridges, Cumulus Linux
identifies the bridge associated with the dynamic VLAN ID and moves the
switch port into that bridge. If an appropriate bridge is not found for
the move, then the port remains in an unauthenticated state where no
packets can be received or transmitted.

To enable dynamic VLAN assignment globally, where VLAN attributes sent
from the RADIUS server are applied to the bridge, do the following:

```
cumulus@switch:~$ net add dot1x dynamic-vlan
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

You can specify the `require` option in the command so that VLAN
attributes are required. If VLAN attributes do not exist in the access
response packet returned from the RADIUS server, the user is not
authorized and has no connectivity. If the RADIUS server returns VLAN
attributes but the user has an incorrect password, the user is placed in
the parking VLAN (if you have configured parking VLAN).

```
cumulus@switch:~$ net add dot1x dynamic-vlan require
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

The following example shows a typical RADIUS configuration (shown for
FreeRADIUS, not typically configured or run on the Cumulus Linux device)
for a user with dynamic VLAN assignment:

```
# # VLAN 100 Client Configuration for Freeradius RADIUS Server.
# # This is not part of the CL configuration.
vlan100client Cleartext-Password := "client1password"
      Service-Type = Framed-User,
      Tunnel-Type = VLAN,
      Tunnel-Medium-Type = "IEEE-802",
      Tunnel-Private-Group-ID = 100
```

Verify the configuration (notice the \[AUTHORIZED\] status in the
output):

```
cumulus@switch:~$ net show dot1x interface swp1 details

Interface  MAC Address        Attribute                     Value
---------  -----------------  ----------------------------  --------------------------
swp1       00:02:00:00:00:08  Status Flags                  [DYNAMIC_VLAN][AUTHORIZED]
                              Username                      host1
                              Authentication Type           MD5
                              VLAN                          888
                              Session Time (seconds)        799
                              EAPOL Frames RX               3
                              EAPOL Frames TX               3
                              EAPOL Start Frames RX         1
                              EAPOL Logoff Frames RX        0
                              EAPOL Response ID Frames RX   1
                              EAPOL Response Frames RX      2
                              EAPOL Request ID Frames TX    1
                              EAPOL Request Frames TX       2
                              EAPOL Invalid Frames RX       0
                              EAPOL Length Error Frames Rx  0
                              EAPOL Frame Version           2
                              EAPOL Auth Last Frame Source  00:02:00:00:00:08
                              EAPOL Auth Backend Responses  2
                              RADIUS Auth Session ID        939B1A53B624FC56

cumulus@switch:~$ net show dot1x interface summary
     
Interface  MAC Address        Username      State         Authentication Type  MAB  VLAN
---------  -----------------  ------------  ------------  -------------------  ---  ----
swp1       00:02:00:00:00:08  000200000008  AUTHORIZED    unknown              NO   888
```

The following output shows a dynamic VLAN association failure. VLAN
association failure only occurs with traditional mode bridges when there
is no traditional bridge available with a parking VLAN ID-tagged
subinterface in it (notice the \[UNKNOWN\_BR\] status in the output):

```
cumulus@switch:~$ net show dot1x interface swp1 details

Interface  MAC Address        Attribute                     Value
---------  -----------------  ----------------------------  --------------------------------------
swp1       00:02:00:00:00:08  Status Flags                  [DYNAMIC_VLAN][AUTHORIZED][UNKNOWN_BR]
                              Username                      host2
                              Authentication Type           MD5
                              VLAN                          888
                              Session Time (seconds)        11
                              EAPOL Frames RX               3
                              EAPOL Frames TX               3
                              EAPOL Start Frames RX         1
                              EAPOL Logoff Frames RX        0
                              EAPOL Response ID Frames RX   1
                              EAPOL Response Frames RX      2
                              EAPOL Request ID Frames TX    1
                              EAPOL Request Frames TX       2
                              EAPOL Invalid Frames RX       0
                              EAPOL Length Error Frames Rx  0
                              EAPOL Frame Version           2
                              EAPOL Auth Last Frame Source  00:02:00:00:00:08
                              EAPOL Auth Backend Responses  2
                              RADIUS Auth Session ID        BDF731EF2B765B78
```

To disable dynamic VLAN assignment, where VLAN attributes sent from the
RADIUS server are ignored and users are authenticated based on existing
credentials:

```
cumulus@switch:~$ net del dot1x dynamic-vlan
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

{{%notice note%}}

Enabling or disabling dynamic VLAN assignment restarts `hostapd`, which
forces existing, authorized users to re-authenticate.

{{%/notice%}}

## Configure MAC Addresses per Port

In Cumulus Linux 3.7.4 and later, you can specify the maximum number of
authenticated MAC addresses allowed on a port with the `net add dot1x
max-number-stations <value>` command. You can specify any number between
0 and 255. The default value is 4.

```
cumulus@switch:~$ net add dot1x max-number-stations 10
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

## Configure EAP Requests from the Switch

Cumulus Linux 3.7.3 and later provides the `send-eap-request-id` option,
which you can use to trigger EAP packets to be sent from the host side
of a connection. For example, this option is required in a configuration
where a PC connected to a phone attempts to send EAP packets to the
switch via the phone but the PC does not receive a response from the
switch (the phone might not be ready to forward packets to the switch
after a reboot). Because the switch does not receive EAP packets, it
attempts to authorize the PC with MAB instead of waiting for the
packets. In this case, the PC might be placed into a parking VLAN to
isolate it. To remove the PC from the parking VLAN, the switch needs to
send an EAP request to the PC to trigger EAP.

To configure the switch send an EAP request, run these commands:

```
cumulus@switch:~$ net add dot1x send-eap-request-id
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

{{%notice note%}}

Only run this command if MAB is configured on an interface.

{{%/notice%}}

{{%notice note%}}

The PC might attempt 802.1X authorization through the bridged connection in the back of the phone before the phone completes MAB authorization. In this case, 802.1X authentication fails.

{{%/notice%}}

The `net del dot1x send-eap-request-id` command disables this feature.

## RADIUS Change of Authorization and Disconnect Requests

Extensions to the RADIUS protocol (RFC 5176) enable the Cumulus Linux
switch to act as a Dynamic Authorization Server (DAS) by listening for
Change of Authorization (CoA) requests from the RADIUS server (Dynamic
Authorization Client (DAC)) and taking action when needed, such as
bouncing a port or terminating a user session. The IEEE 802.1x server
(`hostapd`) running on Cumulus Linux has been adapted to handle these
additional, unsolicited RADIUS requests.

{{% imgOld 1 %}}

### Configure DAS

To configure DAS, provide the UDP port (3799 is the default port), the
IP address, and the secret key for the DAS client.

The following example commands set the UDP port to the default port, the
IP address of the DAS client to 10.0.2.228, and the secret key to
myclientsecret:

```
cumulus@switch:~$ net add dot1x radius das-port default
cumulus@switch:~$ net add dot1x radius das-client-ip 10.0.2.228 das-client-secret myclientsecret
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

In Cumulus Linux 3.7.2 and later, you can specify a VRF so that incoming
RADIUS disconnect and CoA commands are received and acknowledged on the
correct interface when VRF is configured. The following example
specifies VRF blue:

```
cumulus@switch:~$ net add dot1x radius das-port default
cumulus@switch:~$ net add dot1x radius das-client-ip 10.0.2.228 vrf blue das-client-secret mysecret123
cumulus@switch:~$ net commit
```

In Cumulus Linux 3.7.4 and later, you can configure up to four DAS
clients to be authorized to send CoA commands. For example:

```
cumulus@switch:~$ net add dot1x radius das-port default
cumulus@switch:~$ net add dot1x radius das-client-ip 10.20.250.53 das-client-secret mysecret1
cumulus@switch:~$ net add dot1x radius das-client-ip 10.0.1.7 das-client-secret mysecret2
cumulus@switch:~$ net add dot1x radius das-client-ip 10.20.250.99 das-client-secret mysecret3
cumulus@switch:~$ net add dot1x radius das-client-ip 10.10.0.0.2 das-client-secret mysecret4
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

You can disable DAS in Cumulus Linux at any time by running the
following commands:

```
cumulus@switch:~$ net del dot1x radius das-port
cumulus@switch:~$ net del dot1x radius das-client-ip
cumulus@switch:~$ net pending
cumulus@switch:~$ net commit
```

To see DAS configuration information, run the `net show configuration
dot1x` command. For example:

```
cumulus@switch:~$ net show configuration dot1x
...
dot1x
mab-activation-delay 5
eap-reauth-period 0
parking-vlan-id 100
dynamic-vlan
radius
client-source-ip 13.0.0.1
accounting-port 1813
das-client-ip 10.0.2.228
das-client-secret myclientsecret
authentication-port 1812
shared-secret testing123
server-ip 10.1.0.8
das-port 3799
```

### Terminate a User Session

From the DAC, users can create a disconnect message using the
`radclient` utility (included in the Debian `freeradius-utils` package)
on the RADIUS server or other authorized client. A disconnect message is
sent as an unsolicited RADIUS Disconnect-Request packet to the switch to
terminate a user session and discard all associated session context. The
Disconnect-Request packet is used when the RADIUS server wants to
disconnect the user after the session has been accepted by the RADIUS
Access-Accept packet.

This is an example of a disconnect message created using the radclient
utility:

```
$ echo "Acct-Session-Id=D91FE8E51802097" > disconnect-packet.txt
$ ## OPTIONAL ## echo "User-Name=somebody" >> disconnect-packet.txt
$ echo "Message-Authenticator=1" >> disconnect-packet.txt
$ echo "Event-Timestamp=1532974019" >> disconnect-packet.txt
# now send the packet with the radclient utility (from freeradius-utils deb package)
$ cat disconnect-packet.txt | radclient -x 10.0.0.1:3799 disconnect myclientsecret
```

To prevent unauthorized servers from disconnecting users, the
Disconnect-Request packet must include certain identification attributes
(described below). For a session to be disconnected, all parameters must
match their expected values at the switch. If the parameters do not
match, the switch discards the Disconnect-Request packet and sends a
Disconnect-NAK (negative acknowledgment message).

  - The `Message-Authenticator` attribute is required.
  - If the packet comes from a different source IP address than the one
    defined by `das-client-ip`, the session is not disconnected and the
    `hostapd` logs the debug message: `DAS: Drop message from unknown
    client.`
  - The `Event-Timestamp` attribute is required. If `Event-Timestamp` in
    the packet is outside the time window, a debug message is shown in
    the `hostapd` logs: `DAS: Unacceptable Event-Timestamp (1532978602;
    local time 1532979367) in packet from 10.10.0.21:45263 - drop`
  - If the `Acct-Session-Id` attribute is omitted, the `User-Name`
    attribute is used to find the session. If the `User-Name` attribute
    is omitted, the `Acct-Session-Id` attribute is used. If both the
    `User-Name` and the `Acct-Session-Id` attributes are supplied, they
    must match the username provided by the supplicant with the
    `Acct-Session-Id` provided. If neither are given or there is no
    match, a Disconnect-NAK message is returned to the RADIUS server
    with `Error-Cause "Session-Context-Not-Found"` and the following
    debug message is shown in the log:

```      
    RADIUS DAS: Acct-Session-Id match  
    RADIUS DAS: No matches remaining after User-Name check  
    hostapd_das_find_global_sta: checking ifname=swp2  
    RADIUS DAS: No matches remaining after Acct-Session-Id check  
    RADIUS DAS: No matching session found  
    DAS: Session not found for request from 10.10.0.1:58385  
    DAS: Reply to 10.10.0.1:58385
```

The following is an example of the Disconnect-Request packet received by
the switch:

```
RADIUS Protocol
Code: Disconnect-Request (40)
Packet identifier: 0x4f (79)
Length: 53
Authenticator: c0e1fa75fdf594a1cfaf35151a43c6a7
Attribute Value Pairs
AVP: t=Acct-Session-Id(44) l=17 val=D91FE8E51802097
AVP: t=User-Name(1) l=10 val=somebody
AVP: t=Message-Authenticator(80) l=18 val=38cb3b6896623b4b7d32f116fa976cdc
AVP: t=Event-Timestamp(55) l=6 val=1532974019
AVP: t=NAS-IP-Address(4) l=6 val=10.0.0.1
```

### Bounce a Port

You can create a CoA bounce-host-port message from the RADIUS server
using the `radclient` utility (included in the Debian `freeradius-utils`
package). The bounce port can cause a link flap on an authentication
port, which triggers DHCP renegotiation from one or more hosts connected
to the port.

The following is an example of a Cisco AVPair CoA bounce-host-port
message sent from the radclient utility:

```
$ echo "Acct-Session-Id=D91FE8E51802097" > bounce-packet.txt
$ ## OPTIONAL ## echo "User-Name=somebody" >> bounce-packet.txt
$ echo "Message-Authenticator=1" >> bounce-packet.txt
$ echo "Event-Timestamp=1532974019" >> bounce-packet.txt
$ echo "cisco-avpair='subscriber:command=bounce-host-port' " >> bounce-packet.txt
$ cat bounce-packet.txt | radclient -x 10.0.0.1:3799 coa myclientsecret
```

The message received by the switch is:

```
RADIUS Protocol
Code: CoA-Request (43)
Packet identifier: 0x3a (58)
Length: 96
Authenticator: 6480d710802329269d5cae6a59bcfb59
Attribute Value Pairs
AVP: t=Acct-Session-Id(44) l=17 val=D91FE8E51802097
Type: 44
Length: 17
Acct-Session-Id: D91FE8E51802097
AVP: t=User-Name(1) l=10 val=somebody
Type: 1
Length: 10
User-Name: somebody
AVP: t=NAS-IP-Address(4) l=6 val=10.0.0.1
Type: 4
Length: 6
NAS-IP-Address: 10.0.0.1
AVP: t=Vendor-Specific(26) l=43 vnd=ciscoSystems(9)
Type: 26
Length: 43
Vendor ID: ciscoSystems (9)
VSA: t=Cisco-AVPair(1) l=37 val=subscriber:command=bounce-host-port
Type: 1
Length: 37
Cisco-AVPair: subscriber:command=bounce-host-port
```

## Troubleshooting

To check connectivity between two supplicants, ping one host from the
other:

```
root@host1:/home/cumulus# ping 198.150.0.2
PING 11.0.0.2 (11.0.0.2) 56(84) bytes of data.
64 bytes from 11.0.0.2: icmp_seq=1 ttl=64 time=0.604 ms
64 bytes from 11.0.0.2: icmp_seq=2 ttl=64 time=0.552 ms
^C
--- 11.0.0.2 ping statistics ---
2 packets transmitted, 2 received, 0% packet loss, time 1000ms
rtt min/avg/max/mdev = 0.552/0.578/0
```

You can run `net show dot1x` with the following options for more data:

  - `json`: Prints the command output in JSON format.
  - `macs`: Displays MAC address information.
  - `port-details`: Shows counters from the IEEE8021-PAE-MIB for ports.
  - `radius-details`: Shows counters from the RADIUS-CLIENT MIB (RFC
    2618) for ports.
  - `status`: Displays the status of the daemon.

To check which MAC addresses are authorized by RADIUS:

```
cumulus@switch:~$ net show dot1x macs
Interface       Attribute      Value
-----------     -------------  -----------------
swp1            MAC Addresses  00:02:00:00:00:01
swp2            No Data
swp3            No Data
swp4            No Data
```

To check the port detail counters:

```
cumulus@switch:~$ net show dot1x port-details
     
Interface    Attribute                                  Value
-----------  ----------------------------------------   ---------
swp1         Mac Addresses                              00:02:00:00:00:01
              authMultiSessionId                         96703ADC82D77DF2
              connected_time                             182
              dot1xAuthEapolFramesRx                     3
              dot1xAuthEapolFramesTx                     3
              dot1xAuthEapolLogoffFramesRx               0
              dot1xAuthEapolReqFramesTx                  2
              dot1xAuthEapolReqIdFramesTx                1
              dot1xAuthEapolRespFramesRx                 2
              dot1xAuthEapolRespIdFramesRx               1
              dot1xAuthEapolStartFramesRx                1
              dot1xAuthInvalidEapolFramesRx              0
              dot1xAuthLastEapolFrameSource              00:02:00:00:00:01
              dot1xAuthLastEapolFrameVersion             2
              dot1xAuthPaeState                          5
              dot1xAuthQuietPeriod                       60
              dot1xAuthReAuthEnabled                     FALSE
              dot1xAuthReAuthPeriod                      0
              dot1xAuthServerTimeout                     30
              dot1xAuthSessionAuthenticMethod            1
              dot1xAuthSessionId                         1B50FE8939FD9F5E
              dot1xAuthSessionTerminateCause             999
              dot1xAuthSessionTime                       182
              dot1xAuthSessionUserName                   testing
              dot1xPaePortProtocolVersion                2
              last_eap_type_as                           4 (MD5)
              last_eap_type_sta                          4 (MD5)
```

To check RADIUS counters:

```
cumulus@switch:~$ net show dot1x radius-details swp1
     
Interface    Attribute                                  Value
-----------  ----------------------------------------   ---------
swp1         radiusAccClientRequests                    1
              radiusAccClientResponses                   1
              radiusAccClientServerPortNumber            1813
              radiusAccServerAddress                     127.0.0.1
              radiusAuthClientAccessAccepts              1
              radiusAuthClientAccessChallenges           1
              radiusAuthClientAccessRejects              0
              radiusAuthClientAccessRequests             0
              radiusAuthClientServerPortNumber           1812
              radiusAuthServerAddress                    127.0.0.1
              radiusAuthServerIndex                      1
    ...
```

You can also check logging with `journalctl`:

```
cumulus@switch-01:~$ sudo journalctl -f -u hostapd
Apr 19 22:17:11 switch-01 hostapd[12462]: swp1: interface state UNINITIALIZED->ENABLED
Apr 19 22:17:11 switch-01 hostapd[12462]: swp1: AP-ENABLED
Apr 19 22:17:11 switch-01 hostapd[12462]: Reading rule file /etc/cumulus/acl/policy.d/00control_ps ...
Apr 19 22:17:11 switch-01 hostapd[12462]: Processing rules in file /etc/cumulus/acl/policy.d/00...
Apr 19 22:17:12 switch-01 hostapd[12462]: Reading rule file /etc/cumulus/acl/policy.d/100_dot1x...
Apr 19 22:17:12 switch-01 hostapd[12462]: Processing rules in file /etc/cumulus/acl/policy.d/ ..
Apr 19 22:17:12 switch-01 hostapd[12462]: Reading rule file /etc/cumulus/acl/policy.d/99control
Apr 19 22:17:12 switch-01 hostapd[12462]: Processing rules in file /etc/cumulus/acl/policy.d/99
Apr 19 22:17:12 switch-01 hostapd[12462]: Installing acl policy
Apr 19 22:17:12 switch-01 hostapd[12462]: done.
```

To increase the debug level in `hostapd`, copy the `hostapd` service
file, then add *-d*, *-dd* or *-ddd* to the `ExecStart` line in the
`hostapd.service` file:

```
cumulus@switch:~$ cp  /lib/systemd/system/hostapd.service /etc/systemd/system/hostapd.service
cumulus@switch:~$ sudo nano /etc/systemd/system/hostapd.service
...
ExecStart=/usr/sbin/hostapd -ddd -c /etc/hostapd.conf
...
```

To watch debugs with `journalctl` as supplicants attempt to connect:

```
cumulus@switch:~$ sudo journalctl -n 1000  -u hostapd      # see the last 1000 lines of hostapd debug logging
cumulus@switch:~$ sudo journalctl -f -u hostapd            # continuous tail of the hostapd daemon debug logging
```

To check ACL rules in `/etc/cumulus/acl/policy.d/100_dot1x_swpX.rules`
before and after a supplicant attempts to authenticate:

```
cumulus@switch:~$ sudo cl-acltool -L eb | grep swpXX
cumulus@switch:~$ sudo cl-netstat | grep swpXX           # look at interface counters
```

To check `tc` rules in `/var/lib/hostapd/acl/tc_swpX.rules`:

```
cumulus@switch:~$ sudo tc -s filter show dev swpXX parent 1:
cumulus@switch:~$ sudo tc -s filter show dev swpXX parent ffff:
```

## Related Information

{{<exlink url="https://cumulusnetworks.com/blog/campus-design-feature-set-up-part-1/" text="Campus design feature set-up (6-part blog series)">}}
