---
title: FRRouting Log Message Reference
author: NVIDIA
weight: 237
pageID: 8362628
pdfhidden: true
---
The following table lists the HIGH severity ERROR log messages generated
by FRRouting. These messages appear in `/var/log/frr/frr.log`.

| Category | Severity | Message \# | Message Text                                                   | Explanation                                                                                                                                                                        | Recommended Action                                                                                                                                                                                        |
| -------- | -------- | ---------- | -------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Babel    | HIGH     | 16777217   | BABEL Memory Errors                                            | Babel has failed to allocate memory. The system is about to run out of memory.                                                                                                     | Find the process that is causing memory shortages and remediate that process. Restart FRR.                                                                                                                |
| Babel    | HIGH     | 16777218   | BABEL Packet Error                                             | Babel has detected a packet encode/decode problem.                                                                                                                                 | Collect the relevant log files and report the issue for troubleshooting.                                                                                                                                  |
| Babel    | HIGH     | 16777219   | BABEL Configuration Error                                      | Babel has detected a configuration error of some sort.                                                                                                                             | Ensure that the configuration is correct.                                                                                                                                                                 |
| Babel    | HIGH     | 16777220   | BABEL Route Error                                              | Babel has detected a routing error and is in an inconsistent state.                                                                                                                | Gather data to report the issue for troubleshooting. Restart FRR.                                                                                                                                         |
| BGP      | HIGH     | 33554433   | BGP attribute flag is incorrect                                | BGP attribute flag is set to the wrong value (Optional/Transitive/Partial).                                                                                                        | Determine the soure of the attribute and determine why the attribute flag has been set incorrectly.                                                                                                       |
| BGP      | HIGH     | 33554434   | BGP attribute length is incorrect                              | BGP attribute length is incorrect.                                                                                                                                                 | Determine the soure of the attribute and determine why the attribute length has been set incorrectly.                                                                                                     |
| BGP      | HIGH     | 33554435   | BGP attribute origin value invalid                             | BGP attribute origin value is invalid.                                                                                                                                             | Determine the soure of the attribute and determine why the origin attribute has been set incorrectly.                                                                                                     |
| BGP      | HIGH     | 33554436   | BGP as path is invalid                                         | BGP AS path has been malformed.                                                                                                                                                    | Determine the soure of the update and determine why the AS path has been set incorrectly.                                                                                                                 |
| BGP      | HIGH     | 33554437   | BGP as path first as is invalid                                | BGP update has invalid first AS in AS path.                                                                                                                                        | Determine the soure of the update and determine why the AS path first AS value has been set incorrectly.                                                                                                  |
| BGP      | HIGH     | 33554439   | BGP PMSI tunnel attribute type is invalid                      | BGP update has invalid type for PMSI tunnel.                                                                                                                                       | Determine the soure of the update and determine why the PMSI tunnel attribute type has been set incorrectly.                                                                                              |
| BGP      | HIGH     | 33554440   | BGP PMSI tunnel attribute length is invalid                    | BGP update has invalid length for PMSI tunnel.                                                                                                                                     | Determine the soure of the update and determine why the PMSI tunnel attribute length has been set incorrectly.                                                                                            |
| BGP      | HIGH     | 33554442   | BGP peergroup operated on in error                             | BGP operating on peer-group instead of peers included.                                                                                                                             | Ensure the configuration doesn't contain peer-groups contained within peer-groups.                                                                                                                        |
| BGP      | HIGH     | 33554443   | BGP failed to delete peer structure                            | BGP was unable to delete the peer structure when the address-family was removed.                                                                                                   | Determine if all expected peers are removed and restart FRR if not. This is most likely a bug.                                                                                                            |
| BGP      | HIGH     | 33554444   | BGP failed to get table chunk memory                           | BGP unable to get chunk memory for table manager.                                                                                                                                  | Ensure there is adequate memory on the device to support the table requirements.                                                                                                                          |
| BGP      | HIGH     | 33554445   | BGP received MACIP with invalid IP addr len                    | BGP received MACIP with invalid IP address length from Zebra.                                                                                                                      | Verify the MACIP entries inserted in Zebra are correct. This is most likely a bug.                                                                                                                        |
| BGP      | HIGH     | 33554446   | BGP received invalid label manager message                     | BGP received an invalid label manager message from the label manager.                                                                                                              | Label manager sent an invalid message to BGP for the wrong protocol instance. This is most likely a bug.                                                                                                  |
| BGP      | HIGH     | 33554447   | BGP unable to allocate memory for JSON output                  | BGP attempted to generate JSON output and was unable to allocate the memory required.                                                                                              | Ensure that the device has adequate memory to support the required functions.                                                                                                                             |
| BGP      | HIGH     | 33554448   | BGP update had attributes too long to send                     | BGP attempted to send an update but the attributes were too long to fit.                                                                                                           | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554449   | BGP update group creation failed                               | BGP attempted to create an update group but was unable to do so.                                                                                                                   | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554450   | BGP error creating update packet                               | BGP attempted to create an update packet but was unable to do so.                                                                                                                  | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554451   | BGP error receiving open packet                                | BGP received an open from a peer that was invalid.                                                                                                                                 | Determine the sending peer and correct its invalid open packet.                                                                                                                                           |
| BGP      | HIGH     | 33554452   | BGP error sending to peer                                      | BGP attempted to respond to open from a peer and failed.                                                                                                                           | BGP attempted to respond to an open and could not send the packet. Check the local IP address for the source.                                                                                             |
| BGP      | HIGH     | 33554453   | BGP error receiving from peer                                  | BGP received an update from a peer but the status was incorrect.                                                                                                                   | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554454   | BGP error receiving update packet                              | BGP received an invalid update packet.                                                                                                                                             | Determine the source of the update and resolve the invalid update being sent.                                                                                                                             |
| BGP      | HIGH     | 33554455   | BGP error due to capability not enabled                        | BGP attempted a function that did not have the capability enabled.                                                                                                                 | Enable the capability if this functionality is desired.                                                                                                                                                   |
| BGP      | HIGH     | 33554456   | BGP error receiving notify message                             | BGP unable to process the notification message.                                                                                                                                    | BGP notify received while in a stopped state. If the problem persists, report it for troubleshooting.                                                                                                     |
| BGP      | HIGH     | 33554457   | BGP error receiving keepalive packet                           | BGP unable to process a keepalive packet.                                                                                                                                          | BGP keepalive received while in a stopped state. If the problem persists, report it for troubleshooting.                                                                                                  |
| BGP      | HIGH     | 33554458   | BGP error receiving route refresh message                      | BGP unable to process route refresh message.                                                                                                                                       | BGP route refresh received while in a stopped state. If the problem persists, report it for troubleshooting.                                                                                              |
| BGP      | HIGH     | 33554459   | BGP error capability message                                   | BGP unable to process received capability.                                                                                                                                         | BGP capability message received while in a stopped state. If the problem persists, report it for troubleshooting.                                                                                         |
| BGP      | HIGH     | 33554460   | BGP error with nexthopo update                                 | BGP unable to process nexthop update.                                                                                                                                              | BGP received the nexthop update but the nexthop is not reachable in this BGP instance. Report the problem for troubleshooting.                                                                            |
| BGP      | HIGH     | 33554461   | Failure to apply label                                         | BGP attempted to attempted to apply a label but could not do so.                                                                                                                   | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554462   | Multipath specified is invalid                                 | BGP was started with an invalid ECMP/multipath value.                                                                                                                              | Correct the ECMP/multipath value supplied when starting the BGP daemon.                                                                                                                                   |
| BGP      | HIGH     | 33554463   | Failure to process a packet                                    | BGP attempted to process a received packet but could not do so.                                                                                                                    | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554464   | Failure to connect to peer                                     | BGP attempted to send open to a peer but couldn't connect.                                                                                                                         | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554465   | BGP FSM issue                                                  | BGP neighbor transition problem.                                                                                                                                                   | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554466   | BGP VNI creation issue                                         | BGP could not create a new VNI.                                                                                                                                                    | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554467   | BGP default instance missing                                   | BGP could not find default instance.                                                                                                                                               | Define a default instance of BGP since some feature requires its existence.                                                                                                                               |
| BGP      | HIGH     | 33554468   | BGP remote VTEP invalid                                        | BGP remote VTEP is invalid and cannot be used.                                                                                                                                     | Correct the remote VTEP configuration or resolve the source of the problem.                                                                                                                               |
| BGP      | HIGH     | 33554469   | BGP ES route error                                             | BGP ES route incorrect as it learned both local and remote routes.                                                                                                                 | Correct the configuration or address it so that same route is not learned both local and remote.                                                                                                          |
| BGP      | HIGH     | 33554470   | BGP EVPN route delete error                                    | BGP attempted to delete an EVPN route and failed.                                                                                                                                  | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554471   | BGP EVPN install/uninstall error                               | BGP attempted to install or uninstall an EVPN prefix and failed.                                                                                                                   | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554472   | BGP EVPN route received with invalid contents                  | BGP received an EVPN route with invalid contents.                                                                                                                                  | Determine the source of the EVPN route and resolve whatever is causing the invalid content.                                                                                                               |
| BGP      | HIGH     | 33554473   | BGP EVPN route create error                                    | BGP attempted to create an EVPN route and failed.                                                                                                                                  | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554474   | BGP EVPN ES entry create error                                 | BGP attempted to create an EVPN ES entry and failed.                                                                                                                               | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| BGP      | HIGH     | 33554475   | BGP config multi-instance issue                                | BGP configuration attempting multiple instances without enabling the feature.                                                                                                      | Correct the configuration so that BGP multiple-instance is enabled if desired.                                                                                                                            |
| BGP      | HIGH     | 33554476   | BGP AS configuration issue                                     | BGP configuration attempted for a different AS than is currently configured.                                                                                                       | Correct the configuration so that the correct BGP AS number is used.                                                                                                                                      |
| BGP      | HIGH     | 33554477   | BGP EVPN AS and process name mismatch                          | BGP configuration has AS and process name mismatch.                                                                                                                                | Correct the configuration so that the BGP AS number and instance name are consistent.                                                                                                                     |
| BGP      | HIGH     | 33554478   | BGP Flowspec packet processing error                           | The BGP flowspec subsystem has detected an error in the sending or receiving of a packet.                                                                                          | Gather log files from both sides of the peering relationship and report the issue for troubleshooting.                                                                                                    |
| BGP      | HIGH     | 33554479   | BGP Flowspec Installation/removal Error                        | The BGP flowspec subsystem has detected that there was a failure for installation/removal/modification of Flowspec from the dataplane.                                             | Gather log files from the router and report the issue for troubleshooting. Restart FRR.                                                                                                                   |
| EIGRP    | HIGH     | 50331649   | EIGRP Packet Error                                             | EIGRP has a packet that does not correctly decode or encode.                                                                                                                       | Gather log files from both sides of the neighbor relationship and report the issue for troubleshooting.                                                                                                   |
| EIGRP    | HIGH     | 50331650   | EIGRP Configuration Error                                      | EIGRP has detected a configuration error.                                                                                                                                          | Correct the configuration issue. If it still persists, report the issue for troubleshooting.                                                                                                              |
| General  | HIGH     | 100663297  | Failure to raise or lower privileges                           | FRR attempted to raise or lower its privileges and was unable to do so.                                                                                                            | Ensure that you are running FRR as the frr user and that the user has sufficient privileges to properly access root privileges.                                                                           |
| General  | HIGH     | 100663298  | VRF Failure on Start                                           | Upon startup, FRR failed to properly initialize and start up the VRF subsystem.                                                                                                    | Ensure that there is sufficient memory to start processes, then restart FRR.                                                                                                                              |
| General  | HIGH     | 100663299  | Socket Error                                                   | When attempting to access a socket, a system error occured and FRR was unable to properly complete the request.                                                                    | Ensure that there are sufficient system resources available and ensure that the frr user has sufficient permisions to work.                                                                               |
| General  | HIGH     | 100663303  | System Call Error                                              | FRR has detected an error from using a vital system call and has probably already exited.                                                                                          | Ensure permissions are correct for FRR users and groups. Additionally, check that sufficient system resources are available.                                                                              |
| General  | HIGH     | 100663304  | VTY Subsystem Error                                            | FRR has detected a problem with the specified configuration file.                                                                                                                  | Ensure the configuration file exists and has the correct permissions for operations. Additionally, ensure that all config lines are correct as well.                                                      |
| General  | HIGH     | 100663305  | SNMP Subsystem Error                                           | FRR has detected a problem with the SNMP library it uses. A callback from this subsystem has indicated some error.                                                                 | Examine the callback message and ensure SNMP is properly set up and working.                                                                                                                              |
| General  | HIGH     | 100663306  | Interface Subsystem Error                                      | FRR has detected a problem with interface data from the kernel as it deviates from what we would expect to happen via normal netlink messaging.                                    | Open an issue with all relevant log files and restart FRR.                                                                                                                                                |
| General  | HIGH     | 100663307  | NameSpace Subsystem Error                                      | FRR has detected a problem with namespace data from the kernel as it deviates from what we would expect to happen via normal kernel messaging.                                     | Open an issue with all relevant log files and restart FRR.                                                                                                                                                |
| General  | HIGH     | 4043309068 | A necessary work queue does not exist.                         | A necessary work queue does not exist.                                                                                                                                             | Notify a developer.                                                                                                                                                                                       |
| General  | HIGH     | 100663308  | Developmental Escape Error                                     | FRR has detected an issue where new development has not properly updated all code paths.                                                                                           | Open an issue with all relevant log files.                                                                                                                                                                |
| General  | HIGH     | 100663309  | ZMQ Subsystem Error                                            | FRR has detected an issue with the ZeroMQ subsystem and ZeroMQ is not working properly now.                                                                                        | Open an issue with all relevant log files and restart FRR.                                                                                                                                                |
| General  | HIGH     | 100663310  | Feature or system unavailable                                  | FRR was not compiled with support for a particular feature or it is not available on the current platform.                                                                         | Recompile FRR with the feature enabled or find out what platforms support the feature.                                                                                                                    |
| General  | HIGH     | 4043309071 | IRDP message length mismatch                                   | The length encoded in the IP TLV does not match the length of the packet received.                                                                                                 | Notify a developer.                                                                                                                                                                                       |
| General  | HIGH     | 4043309073 | Dataplane installation failure                                 | Installation of routes to the underlying dataplane failed.                                                                                                                         | Check all configuration parameters for correctness.                                                                                                                                                       |
| General  | HIGH     | 4043309075 | Netlink backend not available                                  | FRR was not compiled with support for Netlink. Any operations that require Netlink will fail.                                                                                      | Recompile FRR with Netlink or install a package that supports this feature.                                                                                                                               |
| General  | HIGH     | 4043309076 | Protocol Buffers backend not available                         | FRR was not compiled with support for protocol buffers. Any operations that require protobuf will fail.                                                                            | Recompile FRR with protobuf support or install a package that supports this feature.                                                                                                                      |
| General  | HIGH     | 4043309087 | Cannot set receive buffer size                                 | The socket receive buffer size could not be set in the kernel.                                                                                                                     | Ignore this error.                                                                                                                                                                                        |
| General  | HIGH     | 4043309089 | Receive buffer overrun                                         | The kernel's buffer for a socket has been overrun, rendering the socket invalid.                                                                                                   | Zebra will restart itself. Notify a developer if this issue shows up frequently.                                                                                                                          |
| General  | HIGH     | 4043309091 | Received unexpected response from kernel                       | Received unexpected response from the kernel via Netlink.                                                                                                                          | Notify a developer.                                                                                                                                                                                       |
| General  | HIGH     | 4043309094 | String could not be parsed as IP prefix                        | There was an attempt to parse a string as an IPv4 or IPv6 prefix, but the string could not be parsed and this operation failed.                                                    | Notify a developer.                                                                                                                                                                                       |
| General  | HIGH     | 268435457  | WATCHFRR Connection Error                                      | WATCHFRR has detected a connectivity issue with one of the FRR daemons.                                                                                                            | Ensure that FRR is still running. If it isn't, report the issue for troubleshooting.                                                                                                                      |
| ISIS     | HIGH     | 67108865   | ISIS Packet Error                                              | ISIS has detected an error with a packet from a peer.                                                                                                                              | Gather log information and report the issue for troubleshooting. Restart FRR.                                                                                                                             |
| ISIS     | HIGH     | 67108866   | ISIS Configuration Error                                       | ISIS has detected an error within the configuration for the router.                                                                                                                | Ensure configuration is correct.                                                                                                                                                                          |
| OSPF     | HIGH     | 134217729  | Failure to process a packet                                    | OSPF attempted to process a received packet but could not do so.                                                                                                                   | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| OSPF     | HIGH     | 134217730  | Failure to process Router LSA                                  | OSPF attempted to process a router LSA, but there was an advertising ID mismtach with the link ID.                                                                                 | Check the OSPF network configuration for any configuration issue. If the problem persists, report it for troubleshooting.                                                                                 |
| OSPF     | HIGH     | 134217731  | OSPF Domain Corruption                                         | OSPF attempted to process a router LSA, but there was an advertising ID mismtach with the link ID.                                                                                 | Check OSPF network database for a corrupted LSA. If the problem persists, shut down the OSPF domain and report the problem for troubleshooting.                                                           |
| OSPF     | HIGH     | 134217732  | OSPF Initialization failure                                    | OSPF failed to initialized the OSPF default instance.                                                                                                                              | Ensure there is adequate memory on the device. If the problem persists, report it for troubleshooting.                                                                                                    |
| OSPF     | HIGH     | 134217733  | OSPF SR Invalid DB                                             | OSPF segment routing database is invalid.                                                                                                                                          | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| OSPF     | HIGH     | 134217734  | OSPF SR hash node creation failed                              | OSPF segment routing node creation failed.                                                                                                                                         | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| OSPF     | HIGH     | 134217735  | OSPF SR Invalid lsa id                                         | OSPF segment routing invalid LSA ID.                                                                                                                                               | Restart the OSPF instance. If the problem persists, report it for troubleshooting.                                                                                                                        |
| OSPF     | HIGH     | 134217736  | OSPF SR Invalid Algorithm                                      | OSPF segment routing invalid algorithm.                                                                                                                                            | This is most likely a bug. If the problem persists, report it for troubleshooting.                                                                                                                        |
| PIM      | HIGH     | 184549377  | PIM MSDP Packet Error                                          | PIM has received a packet from a peer that does not correctly decode.                                                                                                              | Check the MSDP peer and ensure it is correctly working.                                                                                                                                                   |
| PIM      | HIGH     | 184549378  | PIM Configuration Error                                        | PIM has detected a configuration error.                                                                                                                                            | Ensure the configuration is correct and apply the correct configuration.                                                                                                                                  |
| RIP      | HIGH     | 201326593  | RIP Packet Error                                               | RIP has detected a packet encode/decode issue.                                                                                                                                     | Gather log files from both sides and open a Issue                                                                                                                                                         |
| Zebra    | HIGH     | 4043309057 | Error reading response from label manager                      | Zebra could not read the ZAPI header from the label manager.                                                                                                                       | Wait for the error to resolve on its own. If it does not resolve, restart Zebra.                                                                                                                          |
| Zebra    | HIGH     | 4043309058 | Label manager could not find ZAPI client                       | Zebra was unable to find a ZAPI client matching the given protocol and instance number.                                                                                            | Ensure that clients that use the label manager are properly configured and running.                                                                                                                       |
| Zebra    | HIGH     | 4043309059 | Zebra could not relay label manager response                   | Zebra found the client and instance to relay the label manager response or request, but was unable to do so, possibly because the connection was closed.                           | Ensure that clients that use the label manager are properly configured and running.                                                                                                                       |
| Zebra    | HIGH     | 100663300  | ZAPI Error                                                     | A version mismatch has been detected between Zebra and a client protocol.                                                                                                          | Two different versions of FRR have been installed and the install is not properly set up. Completely stop FRR, remove it from the system and reinstall. Typically, only developers should see this issue. |
| Zebra    | HIGH     | 4043309061 | Mismatch between ZAPI instance and encoded message instance    | While relaying a request to the external label manager, Zebra noticed that the instance number encoded in the message did not match the client instance number.                    | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 100663301  | ZAPI Error                                                     | The ZAPI subsystem has detected an encoding issue between Zebra and a client protocol.                                                                                             | Restart FRR.                                                                                                                                                                                              |
| Zebra    | HIGH     | 100663302  | ZAPI Error                                                     | The ZAPI subsystem has detected a socket error between Zebra and a client.                                                                                                         | Restart FRR.                                                                                                                                                                                              |
| Zebra    | HIGH     | 4043309064 | Zebra label manager used all available labels                  | Zebra is unable to assign additional label chunks because it has exhausted its assigned label range.                                                                               | Make the label range bigger and restart Zebra.                                                                                                                                                            |
| Zebra    | HIGH     | 4043309065 | Daemon mismatch when releasing label chunks                    | Zebra noticed a mismatch between a label chunk and a protocol daemon number or instance when releasing unused label chunks.                                                        | Ignore this error.                                                                                                                                                                                        |
| Zebra    | HIGH     | 4043309066 | Zebra did not free any label chunks                            | Zebra's chunk cleanup procedure ran but no label chunks were released.                                                                                                             | Ignore this error.                                                                                                                                                                                        |
| Zebra    | HIGH     | 4043309067 | Dataplane returned invalid status code                         | The underlying dataplane responded to a Zebra message or other interaction with an unrecognized unknown or invalid status code.                                                    | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309069 | Failed to add FEC for MPLS client                              | A client requested a label binding for a new FEC but Zebra was unable to add the FEC to its internal table.                                                                        | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309070 | Failed to remove FEC for MPLS client                           | Zebra was unable to find and remove an FEC in its internal table.                                                                                                                  | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309072 | Attempted to perform nexthop update for unknown address family | Zebra attempted to perform a nexthop update for unknown address family.                                                                                                            | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309074 | Zebra table lookup failed                                      | Zebra attempted to look up a table for a particular address family and a subsequent address family but didn't find anything.                                                       | If you entered a command to trigger this error, make sure you entered the arguments correctly. Check your configuration file for any potential errors. If these look correct, notify a developer.         |
| Zebra    | HIGH     | 4043309077 | Table manager used all available IDs                           | Zebra's table manager used up all IDs available to it and can't assign any more.                                                                                                   | Reconfigure Zebra with a larger range of table IDs.                                                                                                                                                       |
| Zebra    | HIGH     | 4043309078 | Daemon mismatch when releasing table chunks                    | Zebra noticed a mismatch between a table ID chunk and a protocol daemon number instance when releasing unused table chunks.                                                        | Ignore this error.                                                                                                                                                                                        |
| Zebra    | HIGH     | 4043309079 | Zebra did not free any table chunks                            | Zebra's table chunk cleanup procedure ran but no table chunks were released.                                                                                                       | Ignore this error.                                                                                                                                                                                        |
| Zebra    | HIGH     | 4043309080 | Address family specifier unrecognized                          | Zebra attempted to process information from somewhere that included an address family specifier but did not recognize the provided specifier.                                      | Ensure that your configuration is correct. If it is, notify a developer.                                                                                                                                  |
| Zebra    | HIGH     | 4043309081 | Incorrect protocol for table manager client                    | Zebra's table manager only accepts connections from daemons managing dynamic routing protocols, but received a connection attempt from a daemon that does not meet this criterion. | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309082 | Mismatch between message and client protocol and/or instance   | Zebra detected a mismatch between a client's protocol and/or instance numbers versus those stored in a message transiting its socket.                                              | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309083 | Label manager unable to assign label chunk                     | Zebra's label manager was unable to assign a label chunk to client.                                                                                                                | Ensure that Zebra has a sufficient label range available and that there is not a range collision.                                                                                                         |
| Zebra    | HIGH     | 4043309084 | Label request from unidentified client                         | Zebra's label manager received a label request from an unidentified client.                                                                                                        | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309085 | Table manager unable to assign table chunk                     | Zebra's table manager was unable to assign a table chunk to a client.                                                                                                              | Ensure that Zebra has sufficient table ID range available and that there is not a range collision.                                                                                                        |
| Zebra    | HIGH     | 4043309086 | Table request from unidentified client                         | Zebra's table manager received a table request from an unidentified client.                                                                                                        | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309088 | Unknown Netlink message type                                   | Zebra received a Netlink message with an unrecognized type field.                                                                                                                  | Verify that you are running the latest version of FRR to ensure kernel compatibility. If the problem persists, notify a developer.                                                                        |
| Zebra    | HIGH     | 4043309090 | Netlink message length mismatch                                | Zebra received a Netlink message with incorrect length fields.                                                                                                                     | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309092 | Bad sequence number in Netlink message                         | Zebra received a Netlink message with a bad sequence number.                                                                                                                       | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309093 | Multipath number was out of valid range                        | The multipath number specified to Zebra must be in the appropriate range.                                                                                                          | Provide a multipath number that is within its accepted range.                                                                                                                                             |
| Zebra    | HIGH     | 4043309095 | Failed to add MAC address to interface                         | Zebra attempted to assign a MAC address to a VXLAN interface but failed.                                                                                                           | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309096 | Failed to delete VNI                                           | Zebra attempted to delete a VNI entry and failed.                                                                                                                                  | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309097 | Adding remote VTEP failed                                      | Zebra attempted to add a remote VTEP and failed.                                                                                                                                   | Notify a developer.                                                                                                                                                                                       |
| Zebra    | HIGH     | 4043309098 | Adding VNI failed                                              | Zebra attempted to add a VNI hash to an interface and failed.                                                                                                                      | Notify a developer.                                                                                                                                                                                       |
