---
title: Cumulus Linux 3.7 Release Notes
author: NVIDIA
weight: -30
product: Cumulus Linux
version: "3.7"
toc: 1
type: rn
pdfhidden: True
---
<a href="/cumulus-linux-37/rn.xls"> {{<rn_icon alt="Download 3.7 Release Notes xls" >}}</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="/cumulus-linux-37/rn.xls">Download all 3.7 release notes as .xls</a>
## 3.7.14.2 Release Notes
### Open issues in 3.7.14.2

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-31420"></a> [CM-31420](#CM-31420) <a name="CM-31420"></a> <br /> | On a Cumulus Linux switch with high load averages, cl-support might end without creating a tar file  and leave a temporary directory in `/var/support` undeleted. Subsequent runs of cl-support do not clean up this directory. | 3.7.13-3.7.14.2 | |
| <a name="CM-28462"></a> [CM-28462](#CM-28462) <a name="CM-28462"></a> <br /> | On rare occasions, when you upgrade Cumulus Linux with the `apt-get upgrade` command, the upgrade fails and reports `No space left on device`. Checking the disk utilization shows that the disk is not full.<br/>To work around this issue, run the `apt-get upgrade` command again and reboot the device if prompted to complete the upgrade. | 3.7.10-3.7.14.2 | |
| <a name="CM-28080"></a> [CM-28080](#CM-28080) <a name="CM-28080"></a> <br /> | TACACS+ through ClearPass is not currently supported. Cumulus Linux sends authorization before authentication, but ClearPass does not accept an authorization before the user is authenticated. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2595889"></a> [2595889](#2595889) <a name="2595889"></a> <br />CM-31120 | In a traditional bridge configuration with <code>ip-forward off</code>, neighbors are synchronized to hardware with a <code>switchd</code> restart but are cleared when you flap the bridge interface. | 3.7.10-4.2.1 | 4.3.0|
| <a name="2595816"></a> [2595816](#2595816) <a name="2595816"></a> <br />CM-31222 | Tenant VRF BGP peers appear in the EVPN RMAC and nexthop tables, which causes the kernel RMAC to point at invalid IP address. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2589747"></a> [2589747](#2589747) <a name="2589747"></a> <br />CM-32226 | If <code>switchd</code> successfully signals <code>clagd</code> that it is going down, <code>clagd</code> stops responding to keepalive echo requests from the peer instead of sending a good bye to the peer over both the peerlink and the backup switch. Eventually, the keepalive timer expires and the secondary switch becomes the primary, and brings the bonds and VNIs back up. However, if <code>switchd</code> does not successfully signal it is going down, (in the event of a crash), the primary switch continues to respond to keepalives, and the bonds and VNIs are down on both peers.  | 3.7.12-4.2.1 | 4.3.0|
| <a name="2574294"></a> [2574294](#2574294) <a name="2574294"></a> <br /> | CVE-2021-3410: A buffer overflow issue in caca_resize function in libcaca/caca/canvas.c may lead to local execution of arbitrary code in the user context<br />Vulnerable: <= 0.99.beta19-2+deb8u1Fixed: 0.99.beta19-2+deb8u2 | 3.7.14-3.7.14.2 | |
| <a name="2566880"></a> [2566880](#2566880) <a name="2566880"></a> <br /> | CVE-2021-27803: A vulnerability was discovered in how p2p/p2p_pd.c in wpa_supplicant before 2.10 processes P2P (Wi-Fi Direct) provision discovery requests. It could result in denial of service or other impact (potentially execution of arbitrary code), for an attacker within radio range. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2562511"></a> [2562511](#2562511) <a name="2562511"></a> <br /> | <code>hostapd} does not fail over to secondary RADIUS servers for 802.1x authentication when the primary radius is reachable but not responding to Access-Requests<br />If the primary RADIUS server is having a problem servicing requests, you can remove it from the configuration temporarily to force requests to be sent to alternate servers. | 3.7.10-3.7.14.2 | |
| <a name="2562396"></a> [2562396](#2562396) <a name="2562396"></a> <br /> | CVE-2020-27824: Global buffer overflow on irreversible conversion when too many decomposition levels are specified.<br />CVE-2020-27841: Crafted input to be processed by the openjpeg encoder could cause an out-of-bounds read.<br />CVE-2020-27845: Crafted input can cause out-of-bounds-read.<br />Vulnerable: <= 2.1.0-2+deb8u11<br />Fixed: 2.1.0-2+deb8u12 | 3.7.14-3.7.14.2 | |
| <a name="2562301"></a> [2562301](#2562301) <a name="2562301"></a> <br /> | CVE-2021-26937: encoding.c in GNU Screen through 4.8.0 allows remote attackers to cause a denial of service (invalid write access and application crash) or possibly have unspecified other impact via a crafted UTF-8 character sequence.<br />Vulnerable: <= 4.2.1-3+deb8u1<br />Fixed: 4.2.1-3+deb8u2 | 3.7.14-3.7.14.2 | |
| <a name="2558184"></a> [2558184](#2558184) <a name="2558184"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2556816"></a> [2556816](#2556816) <a name="2556816"></a> <br />CM-33419 | When ARP suppression is enabled, RARP packets sometimes get dropped and are not flooded by the local VTEP. <br />To work around this issue, disable ARP suppression. | 3.7.14-3.7.14.2, 4.3.0 | |
| <a name="2556783"></a> [2556783](#2556783) <a name="2556783"></a> <br />CM-33398 | CVE-2021-0326: An issue has been found in wpa, a set of tools to support WPA and WPA2 (IEEE 802.11i). Missing validation of data can result in a buffer over-write, which might lead to a DoS of the wpa_supplicant process or potentially arbitrary code execution.<br />Vulnerable: <= 2.8.0-cl3.7.14u1, <= 2.8.0-cl4.2.1u1 | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2556780"></a> [2556780](#2556780) <a name="2556780"></a> <br />CM-33397 | CVE-2021-27212: A vulnerability in the Certificate List Exact Assertion validation was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of this flaw to cause a denial of service (slapd daemon crash) via specially crafted packets.<br />Vulnerable: <= 2.4.40+dfsg-1+deb8u9<br />Fixed: 2.4.40+dfsg-1+deb8u10 | 3.7.14-3.7.14.2 | |
| <a name="2556779"></a> [2556779](#2556779) <a name="2556779"></a> <br />CM-33396 | CVE-2020-8625: Buffer overflow attack in the bind9 DNS server caused by an issue in the GSSAPI (“Generic Security Services”) security policy negotiation.<br />Vulnerable: <= 9.9.5.dfsg-9+deb8u20<br />Fixed: 9.9.5.dfsg-9+deb8u21 | 3.7.14-3.7.14.2 | |
| <a name="2556764"></a> [2556764](#2556764) <a name="2556764"></a> <br />CM-33385 | In a configuration with both traditional and vlan-aware bridges, the VLAN membership check on a vlan-aware switch does not drop PVST BPBUs that come from a traditional bridge. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2556743"></a> [2556743](#2556743) <a name="2556743"></a> <br />CM-33370 | CVE-2019-20367: An issue has been found in libbsd, a library with utility functions from BSD systems. A non-NUL terminated symbol name in the string table might result in an out-of-bounds read.<br />Vulnerable: <= 0.7.0-2+deb8u1<br />Fixed: 0.7.0-2+deb8u2 | 3.7.14-3.7.14.2 | |
| <a name="2556742"></a> [2556742](#2556742) <a name="2556742"></a> <br />CM-33369 | The following vulnerabilities have been announced in the openssl package:<br />CVE-2021-23840: an issue where “Digital EnVeloPe” EVP-related calls could cause applications to behave incorrectly or even crash.<br />CVE-2021-23841: an issue in the X509 certificate parsing caused by the lack of error handling while ingesting the “issuer” field.<br />Vulnerable: <= 1.0.1t-1+deb8u13<br />Fixed: 1.0.1t-1+deb8u14 | 3.7.14-3.7.14.2 | |
| <a name="2556689"></a> [2556689](#2556689) <a name="2556689"></a> <br />CM-33333 | CVE-2020-15469 A MemoryRegionOps object may lack read/write callback methods, leading to a NULL pointer dereference.<br />CVE-2020-15859 QEMU has a use-after-free in hw/net/e1000e_core.c because a guest OS user can trigger an e1000e packet with the data’s address set to the e1000e’s MMIO address. <br />CVE-2020-25084 QEMU has a use-after-free in hw/usb/hcd-xhci.c because the usb_packet_map return value is not checked.<br />CVE-2020-28916 hw/net/e1000e_core.c has an infinite loop via an RX descriptor with a NULL buffer address.<br />CVE-2020-29130 slirp.c has a buffer over-read because it tries to read a certain amount of header data even if that exceeds the total packet length.<br />CVE-2020-29443 ide_atapi_cmd_reply_end in hw/ide/atapi.c allows out-of-bounds read access because a buffer index is not validated.<br />CVE-2021-20181 9pfs: ZDI-CAN-10904: QEMU Plan 9 file system TOCTOU privilege escalation vulnerability.<br />CVE-2021-20221 aarch64: GIC: out-of-bound heap buffer access via an interrupt ID field.<br />Vulnerable: <= 2.1+dfsg-12+deb8u18<br />Fixed: 2.1+dfsg-12+deb8u19 | 3.7.14-3.7.14.2 | |
| <a name="2556612"></a> [2556612](#2556612) <a name="2556612"></a> <br />CM-33311 | CVE-2021-27135: xterm through Patch #365 allows remote attackers to cause a denial of service (segmentation fault) or possibly have unspecified other impact via a crafted UTF-8 character sequence.<br />Vulnerable: 312-2<br />Fixed: 312-2+deb8u1. | 3.7.14-3.7.14.2 | |
| <a name="2556585"></a> [2556585](#2556585) <a name="2556585"></a> <br />CM-33295 | CVE-2021-26926: A heap buffer overflow vulnerability was discovered in JasPer, through jp2_dec.c in the jp2_decode() function.<br />CVE-2021-26927: A null pointer access was discovered in JasPer, through jp2_dec.c in the jp2_decode() function.<br />Vulnerable: <= 1.900.1-debian1-2.4+deb8u8<br />Fixed: 1.900.1-debian1-2.4+deb8u9 | 3.7.14-3.7.14.2 | |
| <a name="2556530"></a> [2556530](#2556530) <a name="2556530"></a> <br />CM-33272 | CVE-2020-0256: In LoadPartitionTable of gpt.cc, there is a possible out of bounds write due to a missing bounds check. This could lead to local escalation of privilege with no additional execution privileges needed.<br />CVE-2021-0308: In ReadLogicalParts of basicmbr.cc, there is a possible out of bounds write due to a missing bounds check. This could lead to local escalation of privilege with no<br />additional execution privileges needed.<br />Vulnerable: 0.8.10-2<br />Fixed: 0.8.10-2+deb8u1 | 3.7.14-3.7.14.2 | |
| <a name="2556525"></a> [2556525](#2556525) <a name="2556525"></a> <br />CM-33270 | CVE-2020-27351: Various memory and file descriptor leaks were discovered in the Python interface to the APT package management runtime library, which could result in denial of service.<br />Vulnerable: <= 0.9.3.13<br />Fixed: 0.9.3.14 | 3.7.14-3.7.14.2 | |
| <a name="2556504"></a> [2556504](#2556504) <a name="2556504"></a> <br />CM-33260 | CVE-2020-36221 CVE-2020-36222 CVE-2020-36223 CVE-2020-36224 CVE-2020-36225 CVE-2020-36226 CVE-2020-36227 CVE-2020-36228 CVE-2020-36229 CVE-2020-36230: Several vulnerabilities were discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of these flaws to cause a denial of service (slapd daemon crash, infinite loops) via specially crafted packets.<br />Vulnerable: <= 2.4.40+dfsg-1+deb8u8<br />Fixed: 2.4.40+dfsg-1+deb8u9 | 3.7.14-3.7.14.2 | |
| <a name="2556473"></a> [2556473](#2556473) <a name="2556473"></a> <br />CM-33246 | CVE-2021-3272: jp2_decode in jp2/jp2_dec.c in libjasper in JasPer has a heap-based buffer over-read when there is an invalid relationship between the number of channels and the number of image components.<br />Vulnerable: <= 1.900.1-debian1-2.4+deb8u6<br />Fixed: 1.900.1-debian1-2.4+deb8u7 | 3.7.14-3.7.14.2 | |
| <a name="2556364"></a> [2556364](#2556364) <a name="2556364"></a> <br />CM-33191 | CVE-2020-35512: An issue has been found in dbus, a simple interprocess messaging system. On a system having multiple usernames sharing the same UID a use-after-free might happen, that could result in a denial of service or undefined behaviour, possibly including incorrect authorization decisions.<br />Vulnerable: <= 1.8.22-0+deb8u3<br />Fixed: 1.8.22-0+deb8u4 | 3.7.14-3.7.14.2 | |
| <a name="2556218"></a> [2556218](#2556218) <a name="2556218"></a> <br />CM-33117 | The following vulnerability affects lldpd:<br />CVE-2020-27827: A packet that contains multiple instances of certain TLVs will cause lldpd to continually allocate memory and leak the old memory.  As an example, multiple instances of system name TLV will cause old values to be dropped by the decoding routine.<br />Fixed: 1.0.4-0-cl4.3.0u2 | 3.7.14-4.2.1 | 4.3.0|
| <a name="2556061"></a> [2556061](#2556061) <a name="2556061"></a> <br />CM-33032 | On Edgecore AS4610 switches, the historic CPU usage displayed in <code>/run/sysmonitor/history</code> is sometimes shown as a negative value.  | 3.7.12-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2556037"></a> [2556037](#2556037) <a name="2556037"></a> <br />CM-33012 | After you add an interface to the bridge, an OSPF session flap can occur.<br /><br /> | 3.7.9-4.2.0 | 4.2.1-4.3.0|
| <a name="2556031"></a> [2556031](#2556031) <a name="2556031"></a> <br />CM-33008 | Several security vulnerabilities were found in ImageMagick, a suite of image manipulation programs. An attacker could cause denial of service and execution of arbitrary code when a crafted image file is processed.<br />CVE-2020-19667 Stack-based buffer overflow and unconditional jump in ReadXPMImage in coders/xpm.c<br />CVE-2020-25665 The PALM image coder at coders/palm.c makes an improper call to AcquireQuantumMemory() in routine WritePALMImage() because it needs to be offset by 256. This can cause a out-of-bounds read later on in the routine. This could cause impact to reliability.<br />CVE-2020-25674 WriteOnePNGImage() from coders/png.c (the PNG coder) has a for loop with an improper exit condition that can allow an out-of-bounds READ via heap-buffer-overflow. This occurs because it is possible for the colormap to have less than 256 valid values but the loop condition will loop 256 times, attempting to pass invalid colormap data to the event logger.<br />CVE-2020-27560 ImageMagick allows Division by Zero in OptimizeLayerFrames in MagickCore/layer.c, which may cause a denial of service.<br />CVE-2020-27750 A flaw was found in MagickCore/colorspace-private.h and MagickCore/quantum.h. An attacker who submits a crafted file that is processedcould trigger undefined behavior in the form of values outside the range of type unsigned char and math division by zero. This would most likely lead to an impact to application availability, but could potentially cause other problems related to undefined behavior.<br />CVE-2020-27760 In GammaImage() of /MagickCore/enhance.c, depending on the gamma value, it’s possible to trigger a divide-by-zero condition when a crafted input file is processed by ImageMagick. This could lead to an impact to application availability.<br />CVE-2020-27763 A flaw was found in MagickCore/resize.c. An attacker who submits a crafted file that is processed by ImageMagick could trigger undefined behavior in the form of math division by zero. This would most likely lead to an impact to application availability, but could potentially cause other problems related to undefined behavior.<br />CVE-2020-27765 A flaw was found in MagickCore/segment.c. An attacker who submits a crafted file that is processed by ImageMagick could trigger undefined behavior in the form of math division by zero. This would most likely lead to an impact to application availability, but could potentially cause other problems related to undefined behavior.<br />CVE-2020-27773 A flaw was found in MagickCore/gem-private.h. An attacker who submits a crafted file that is processed by ImageMagick could trigger undefined behavior in the form of values outside the range of type unsigned char or division by zero. This would most likely lead to an impact to application availability, but could potentially cause other problems related to undefined behavior.<br />CVE-2020-29599 ImageMagick mishandles the -authenticate option, which allows setting a password for password-protected PDF files. The user-controlled password was not properly escaped/sanitized and it was therefore possible to inject additional shell commands via coders/pdf.c.<br />Vulnerable: <= 6.8.9.9-5+deb8u21<br />Fixed: 6.8.9.9-5+deb8u22 | 3.7.14-3.7.14.2 | |
| <a name="2556030"></a> [2556030](#2556030) <a name="2556030"></a> <br />CM-33007 | The following vulnerability was announced in the apt packages:<br />CVE-2020-27350: Missing input validation in the ar/tar implementations of APT, the high level package manager, could cause out-of-bounds reads or infinite loops, resulting in denial of service when processing malformed deb files. <br />Vulnerable: <= 1.0.9.8.6<br />Fixed: 1.0.9.8.7 | 3.7.14-3.7.14.2 | |
| <a name="2555691"></a> [2555691](#2555691) <a name="2555691"></a> <br />CM-32829 | The NET-SNMP-EXTEND-MIB, disabled in Cumulus Linux 4.2.1 and 3.7.14 to prevent security vulnerability CVE-2020-15862, is re-enabled read-only. | 3.7.14-4.2.1 | 4.3.0|
| <a name="2555654"></a> [2555654](#2555654) <a name="2555654"></a> <br />CM-32810 | The following vulnerability has been announced in the libflac8 package:<br />CVE-2020-0499: In FLAC__bitreader_read_rice_signed_block of bitreader.c, there is a possible out-of-bounds read due to a heap buffer overflow.  This could lead to remote information disclosure with no additional execution privileges needed. However, user interaction is needed for exploitation.<br />Vulnerable: 1.3.0-3<br />Fixed: 1.3.0-3+deb8u1 | 3.7.14-3.7.14.2 | |
| <a name="2555553"></a> [2555553](#2555553) <a name="2555553"></a> <br />CM-32757 | It was discovered that the clean_html() function of lxml, a Python library for HTML and XML processing, performed insufficient sanitisation for embedded Javascript code. This might lead to cross-site scripting or possibly the execution of arbitrary code.<br />Vulnerable: <= 3.4.0-1+deb8u2<br />Fixed: 3.4.0-1+deb8u3 | 3.7.14-3.7.14.2 | |
| <a name="2555528"></a> [2555528](#2555528) <a name="2555528"></a> <br />CM-32750 | In an EVPN Active/Active configuration, when one of the peers reboots and begins to refresh IP neighbor entries shared by the MLAG peer, some of these ARP messages might be dropped by the MLAG peer's ARP policer.<br />To work around this issue, increase the burst value of the ARP policers to 200 or higher. | 3.7.14-4.2.1 | 4.3.0|
| <a name="2555435"></a> [2555435](#2555435) <a name="2555435"></a> <br />CM-32689 | CVE-2018-19139: Fix memory leaks by registering jpc_unk_destroyparms.<br />CVE-2020-27828: Avoid maxrlvls more than upper bound to cause heap-buffer-overflow.<br />CVE-2018-19543 and CVE-2017-9782: There is a heap-based buffer over-read of size 8 in the function jp2_decode in libjasper/jp2/jp2_dec.c.<br />Vulnerable: <= 1.900.1-debian1-2.4+deb8u6<br />Fixed: 1.900.1-debian1-2.4+deb8u7 | 3.7.14-3.7.14.2 | |
| <a name="2555428"></a> [2555428](#2555428) <a name="2555428"></a> <br />CM-32683 | When you change the SVI <code>vlan-id</code> value in the <code>/etc/network/interfaces</code> file, then run <code>ifreload -a</code>, the 802.1Q ID for the SVI in the kernel does not change.<br />This operation is not supported in the kernel without recreating the SVI. To apply the change, run <code>ifdown</code>, then <code>ifup</code> for the SVI to recreate the interface. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2555401"></a> [2555401](#2555401) <a name="2555401"></a> <br />CM-32661 | On the Edgecore AS7312 switch, eth0 and swp use the same MAC address. | 3.7.14-4.2.1 | 4.3.0|
| <a name="2555205"></a> [2555205](#2555205) <a name="2555205"></a> <br />CM-32545 | If the FRR and MSTP processes go down, an SNMP TRAP is not generated even with the following configuration in the <code>/etc/snmp/snmpd.conf</code> file. <br /><pre><br />proc watchfrr<br />proc mstpd<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRRis down!!!” PrErrorFlag.5 != 0<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRR is up!!!” PrErrorFlag.5 = 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is down!!!!" prErrorFlag.3 != 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is up!!!!" prErrorFlag.3 = 0<br /></pre><br /> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2555196"></a> [2555196](#2555196) <a name="2555196"></a> <br />CM-32537 | CVE-2018-19787, CVE-2020-27783: The clean_html() function of lxml, a Python library for HTML and XML processing, performed insufficient sanitisation for embedded Javascript code. This could lead to cross-site scripting or possibly the execution of arbitrary code.<br />Vulnerable: <= 3.4.0-1+deb8u1<br />Fixed: 3.4.0-1+deb8u2 | 3.7.14-3.7.14.2 | |
| <a name="2555148"></a> [2555148](#2555148) <a name="2555148"></a> <br />CM-32516 | When using NCLU to add new BGP neighbors to existing configurations, the existence of address-family statements are ignored and the neighbors are added at the end of these lines. This might cause a problem if you try to activate these new neighbors in any of the existing address-family configurations.<br />To work around this issue, configure the new BGP neighbors with vtysh. | 3.7.14-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2555147"></a> [2555147](#2555147) <a name="2555147"></a> <br />CM-32515 | Some issues have been found in qemu, a fast processor emulator.<br />CVE-2020-25085 CVE-2020-25624 CVE-2020-25625 CVE-2020-25723 CVE-2020-27617: All issues are related to assertion failures, out-of-bounds access failures or bad handling of return codes.<br />Vulnerable: <= 2.1+dfsg-12+deb8u17<br />Fixed: 2.1+dfsg-12+deb8u18 | 3.7.14-3.7.14.2 | |
| <a name="2554992"></a> [2554992](#2554992) <a name="2554992"></a> <br />CM-32420 | When running traditional mode bridges at scale (for example, when you have more than 200 bridges and a large number of MAC addresses), MLAG bonds flap intermittently from dual to single connected, then back to dual connected, which causes a layer 2 loop and STP state changes.<br />To work around this issue, either shut down one side of the MLAG bond or prune out VLANS over the bond. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2554785"></a> [2554785](#2554785) <a name="2554785"></a> <br />CM-32275 | After you reboot a Broadcom switch, <code>switchd</code> might fail to restart and you see logs in <code>switchd.log</code> similar to the following:<br /><pre><br />...<br />Nov 12 12:20:05.063876 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.064310 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 0:system_init:<br />Nov 12 12:20:05.064428 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 system_init: Misc init failed: Operation timed out<br />Nov 12 12:20:05.064464 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.091995 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 LED: Loading 256 bytes into LED program memory<br />Nov 12 12:20:05.092029 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099547 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 PORT: Error: bcm ports not initialized<br />Nov 12 12:20:05.099579 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099646 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /var/lib/cumulus/rc.datapath_0: line 81 (error code -1): script terminated<br />Nov 12 12:20:05.099667 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099775 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /etc/bcm.d/rc.soc: line 70 (error code -1): script terminated<br />Nov 12 12:20:05.099798 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099871 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 ERROR loading rc script on unit 0<br />Nov 12 12:20:05.099892 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099943 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:299 CRIT loading of rc script failed, aborting!<br /></pre> | 3.7.11-4.2.1 | 4.3.0|
| <a name="2554719"></a> [2554719](#2554719) <a name="2554719"></a> <br />CM-32225 | A slow memory leak is observed (1% per 14 hours) in kmalloc-256.<br />To work around this issue, reboot the switch. | 3.7.12-3.7.14.2 | |
| <a name="2554709"></a> [2554709](#2554709) <a name="2554709"></a> <br />CM-32217 | The IP address specified in the <code>ip pim use-source</code> command configured on the loopback interface should be inherited by unnumbered interfaces during their Primary IP address selection process.  If <code>ip pim use-source</code> is configured on the loopback after an unnumbered interface has already selected their Primary IP address, the unnumbered interface does not update its Primary IP address to be the new use-source value until after there is a netlink update for that interface.<br />To work around this issue, configure <code>ip pim use-source</code> on each unnumbered interface directly or ensure <code>ip pim use-source</code> is applied to the loopback before other unnumbered interfaces are enabled for PIM. | 3.7.13-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2554617"></a> [2554617](#2554617) <a name="2554617"></a> <br />CM-32169 | OpenSSH is vulnerable to CVE-2020-14145, as described in https://www.fzi.de/fileadmin/user_upload/2020-06-26-FSA-2020-2.pdf.  <br />This is an information leak in algorithm negotiation that can allow man-in-the-middle attacks on initial connection attempts without a previously stored server host key on the client. If desired, mitigation using UpdateHostKeys and HostKeyAlgorithms is also given in that paper. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2554588"></a> [2554588](#2554588) <a name="2554588"></a> <br />CM-32149 | If you try reconfigure a DHCP server after you delete the switch configuration with the <code>net del all</code> command, the <code>dhcpd</code> service fails because a duplicate process is running.<br />To work around this issue, edit the <code>/usr/lib/python2.7/dist-packages/nclu/plugins/dhcp.py</code> file to change:<br /><pre><br />DHCPD_PID="-pf {0}" <br /></pre><br />to:<br /><pre><br />DHCPD_PID="-pf {1}"<br /></pre> | 3.7.13-4.2.1 | 4.3.0|
| <a name="2554369"></a> [2554369](#2554369) <a name="2554369"></a> <br />CM-32006 | Certain Dell S4048-ON switches show an incorrect vendor name and hang when you issue the <code>reboot</code> command.  | 3.7.12-4.2.1 | 4.3.0|
| <a name="2554329"></a> [2554329](#2554329) <a name="2554329"></a> <br />CM-31978 | On the Dell N3248PXE switch, fixed RJ45 interfaces with PoE neighbors can end up in _Paused_ mode after a <code>switchd</code> restart, which blocks traffic on that interface.  | 3.7.12-3.7.14.2 | |
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553748"></a> [2553748](#2553748) <a name="2553748"></a> <br />CM-31627 | On switches with the Spectrum ASIC, the IPv6 default route is present in the kernel but missing in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2553677"></a> [2553677](#2553677) <a name="2553677"></a> <br />CM-31605 | When you configure an SNMPv3 user with the <code>net-snmp-config</code> configuration command from the <code>libsnmp-dev</code> package, you get an error message similar to the one below:<br /><pre><br />cumulus&#64;switch:mgmt-vrf:~$ sudo net-snmp-config --create-snmpv3-user -a shaauthpass -x aesprivpass -A SHA -X AES userSHAwithAES<br />adding the following line to /var/lib/snmp/snmpd.conf:           <br />   createUser userSHAwithAES SHA "shaauthpass" AES "aesprivpass"       <br />adding the following line to /snmp/snmpd.conf:                           <br />   rwuser userSHAwithAES                                           <br />touch: cannot touch ‘/snmp/snmpd.conf’: No such file or directory<br />/usr/bin/net-snmp-create-v3-user: 144: /usr/bin/net-snmp-create-v3-user: cannot create /snmp/snmpd.conf: Directory nonexistent<br /></pre><br />To work around this issue, use the NCLU command to configure SNMPv3 user parameters; for example:<br /><pre><br />cumulus&#64;switch:mgmt-vrf:~$ net add snmp-server username user999 auth-md5 user999password encrypt-des user999encryption<br /></pre><br />Alternatively, directly edit the <code>/etc/snmp/snmpd.conf</code> file as described in the documentation. | 3.7.13-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553219"></a> [2553219](#2553219) <a name="2553219"></a> <br />CM-31407 | You cannot configure SNMPv3 trap-destinations in non-default VRFs with an authentication username that contains fewer than eight characters. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2553116"></a> [2553116](#2553116) <a name="2553116"></a> <br />CM-31357 | When you manually set the link speed or duplex mode with ethtool to an unsupported value, then run a TDR check against the interface, you encounter a <code>switchd</code> service heartbeat failure.<br />To work around this issue, reboot the switch to clear the condition. Avoid setting the interface speed or duplex mode directly with ethtool. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553063"></a> [2553063](#2553063) <a name="2553063"></a> <br />CM-31327 | After you manually edit the <code>/etc/resolv.conf</code> file to change or remove a VRF for a given DNS server, <code>ifreload</code> does not remove IP rules created for DNS servers in the VRF. <br />To work around this issue, run the <code>net add/del dns nameserver vrf <name></code> command to force the DNS configuration. | 3.7.13-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2553050"></a> [2553050](#2553050) <a name="2553050"></a> <br />CM-31322 | SNMP status might incorrectly reflect that a BGP neighbor is down due to an issue between <code>bgpd</code> and SNMP AgentX when the IP-FORWARD-MIB is also polled.<br />To work around this issue, avoid polling IP-FORWARD-MIB objects. | 3.7.12-3.7.14.2 | |
| <a name="2553015"></a> [2553015](#2553015) <a name="2553015"></a> <br />CM-31300 | If a neighbour contains a special character in PortID for LLDP, the <code>net show interface</code> command does not display the LLDP information or the command might fail. | 3.7.10-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2552939"></a> [2552939](#2552939) <a name="2552939"></a> <br />CM-31263 | RX_DRP on a bond interface increases without any data traffic while the slave port does not increase. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552870"></a> [2552870](#2552870) <a name="2552870"></a> <br />CM-31232 | On the  Dell N3048EP switch, the module information from SFP ports is not displayed in the <code>l1-show</code> command.<br />To work around this issue, use the <code>ethtool -m <interface></code> command. | 3.7.13-3.7.14.2 | |
| <a name="2552869"></a> [2552869](#2552869) <a name="2552869"></a> <br />CM-31231 | On the Dell N3048EP switch, the module information from SFP ports is not displayed in the <code>l1-show</code> command.<br />To work around this issue, use the <code>ethtool -m <interface></code> command. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2552742"></a> [2552742](#2552742) <a name="2552742"></a> <br />CM-31150 | On the Mellanox SN2410 switch, you see <code>switchd</code> core and <code>GBIN_MALLOC</code> errors.<br />To work around this issue, restart <code>switchd</code>. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552739"></a> [2552739](#2552739) <a name="2552739"></a> <br />CM-31148 | Counters for IPROUTER rules do not increase when traffic is forwarded to the CPU because there is no IP neighbor. | 3.7.2-3.7.14.2 | |
| <a name="2552632"></a> [2552632](#2552632) <a name="2552632"></a> <br />CM-31073 | When you set the <code>sysctl</code> settings <code>net.ipv6.conf.all.accept_ra_defrtr</code> (to prevent acceptance of IPv6 default route advertisements) and <code>net.ipv6.conf.default.accept_ra_defrtr</code> (set for newly created interfaces), if you create a new virtual interface, any pre-existing interface does not start accepting IPv6 default route avertisements again.<br />To work around this issue, when you create a new virtual interface, set <code>net.ipv6.conf.<interface>.accept_ra_defrtr</code> to 0 for all interfaces and run <code>sysctl -p --system</code>. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552610"></a> [2552610](#2552610) <a name="2552610"></a> <br />CM-31057 | The following vulnerability has been announced:<br />CVE-2019-11360: A buffer overflow in <code>iptables-restore</code> in netfilter iptables 1.8.2 allows an attacker to (at least) crash the program or potentially gain code execution via a specially crafted iptables-save file. This is related to <code>add_param_to_argv</code> in <code>xshared.c</code>. | 3.7.13-4.2.0 | 4.2.1-4.3.0|
| <a name="2552294"></a> [2552294](#2552294) <a name="2552294"></a> <br />CM-30879 | NCLU restarts FRR when removing a BGP VRF IPv4 aggregate-address command.<br />  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552266"></a> [2552266](#2552266) <a name="2552266"></a> <br />CM-30863 | OpenSSH scp is vulnerable to CVE-2020-15778, where clients that have authorized access to the SSH server can execute commands on the server by copying maliciously named files.<br />The two scenarios where an exploit may be useful to an attacker:<br />-The user is authorized to <code>scp</code> but not <code>ssh</code> (based on the <code>command</code> option in the <code>authorized_keys</code> file), so this vulnerability can allow executing a remote command on the target computer when not authorized to do so.<br />-An attacker plants a maliciously named file in a directory tree that someone later uses <code>scp -r</code> to copy over to the target computer.<br />Be aware that restricting users to <code>scp</code> by using the <code>command</code> option in the <code>authorized_keys</code> file is not effective in preventing those users from executing arbitrary commands on the server.<br />If you want to use <code>scp -r</code> to copy directory trees, avoid copying directory trees to which attackers may have added maliciously-named files. Archiving the directory tree with <code>tar</code>, <code>zip</code>, or a similar program, then copying the archive over to be extracted on the server avoids having to use <code>scp -r</code> altogether. In addition, OpenSSH provides <code>sftp</code>, which you can use instead of <code>scp</code> to copy files.<br />To disable scp completely, use <code>/bin/chmod 0 /usr/bin/scp</code> . | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552213"></a> [2552213](#2552213) <a name="2552213"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2551912"></a> [2551912](#2551912) <a name="2551912"></a> <br />CM-30580 | <code>ifupdown2</code> does not account for link status or link down configuration when running <code>dhclient</code>. For example, <code>ifupdown2</code> ignores <code>link-down yes</code> during <code>ifup/ifreload</code> and runs the DHCP module if <code>inet dhcp</code> is configured on the interface. <code>ifupdown2</code> also runs the DHCP module even when the physical link configured for DHCP is down. | 3.7.12-4.2.0 | 4.2.1-4.3.0|
| <a name="2551578"></a> [2551578](#2551578) <a name="2551578"></a> <br />CM-30422 | When you configure a bridge in the <code>/etc/network/interfaces</code> file, then try to reconfigure the bridge to be a VRF interface with the same name, <code>ifreload</code>/<code>ifup</code> commands fail with an <code>invalid table id</code> or <code>unable to get vrf table id</code> error. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2551565"></a> [2551565](#2551565) <a name="2551565"></a> <br />CM-30414 | If you toggle VRRP priority values between VRRP routers, then run a <code>switchd</code> restart, a few IPv6 VRRP instances might not converge. As a result, both the VRRP routers act as _master_ routers for the impacted IPv6 VRRP instances. IPv4 VRRP instances are not affected.<br />To work around this issue, remove, then add the VRRP configuration with NCLU commands or vtysh in FRR.<br /> | 3.7.13-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2551305"></a> [2551305](#2551305) <a name="2551305"></a> <br />CM-30296 | The <code>net show configuration</code> command provides the wrong <code>net add</code> command for ACL under the VLAN interface.<br /><br /> | 3.7.12-3.7.14.2, 4.1.0-4.3.0 | |
| <a name="2550974"></a> [2550974](#2550974) <a name="2550974"></a> <br />CM-30195 | On the Dell S3000 switch, after installing the Cumulus Linux 4.1.1 disk image without a license, the switch sends a link beat if a remote host port is configured. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550942"></a> [2550942](#2550942) <a name="2550942"></a> <br />CM-30178 | NCLU tab completion for <code>net show</code> displays the text <code>add help text</code> instead of <code>system Information</code> for the system option. | 3.7.11-4.2.0 | 4.2.1-4.3.0|
| <a name="2550796"></a> [2550796](#2550796) <a name="2550796"></a> <br />CM-30103 | On a Broadcom switch with the Trident2+ ASIC, ACL rules for VLANs are not applied after a reboot and the counters remain at zero.<br />To work around this issue, either do not set <code>acl.non_atomic_update_mode = TRUE</code> in the <code>/etc/cumulus/switchd.conf</code> file or run the <code>cl-acltool -i</code> command after the reboot to install the  ACLs. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2550793"></a> [2550793](#2550793) <a name="2550793"></a> <br />CM-30101 | The NCLU <code>net show bridge spanning-tree</code> command displays the aging timer incorrectly.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550601"></a> [2550601](#2550601) <a name="2550601"></a> <br />CM-29978 | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | 4.2.1-4.3.0, 4.3.0|
| <a name="2550466"></a> [2550466](#2550466) <a name="2550466"></a> <br />CM-29890 | Multiple paths to identical EVPN prefixes are either not displayed or not accepted into the l2vpn evpn table if they are received from a different AS. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550444"></a> [2550444](#2550444) <a name="2550444"></a> <br />CM-29872 | Tab completion for the <code>net show rollback description</code> command returns information about a snapshot instead of context help.<br />To work around this issue, run the <code>net show commit history</code> command to find descriptions instead of the <code>net show rollback description</code> command. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550443"></a> [2550443](#2550443) <a name="2550443"></a> <br />CM-29871 | The <code>net show rollback description <string></code> command returns an error even if the string matches a commit description.<br />To work around this issue, look for your string in the output of the <code>net show commit history</code> command (or grep for it there) instead. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550276"></a> [2550276](#2550276) <a name="2550276"></a> <br />CM-29779 | In LLDP, the <code>snmp</code> subagent loses all subsequent <code>lldpRemSysName</code> (1.0.8802.1.1.2.1.4.1.1.9) entries after an entry with a missing SysName is added.<br />All the information from <code>lldpctl</code> is correct. Only the entries after the entry that is missing a SysName in <code>lldpRemSysName</code> disappear from the <code>snmp</code> subagent. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2550243"></a> [2550243](#2550243) <a name="2550243"></a> <br />CM-29759 | When you use <code>nginx</code> and <code>restserver</code> in management VRF to provide a REST API for the switch, <code>nginx</code> starts but <code>restserver</code> fails to start.<br />To work around this issue, comment out the <code>Requires=</code> line in the <code>/lib/systemd/system/restserver.service</code>. For example:<br /><pre><br />#Requires=nginx.service restserver.socket<br /></pre> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550196"></a> [2550196](#2550196) <a name="2550196"></a> <br />CM-29740 | The <code>exim4</code> package available for optional installation on Cumulus Linux 3.x has the following vulnerability:<br />DLA-2213-1 / CVE-2020-12783: Exim through 4.93 has an out-of-bounds read in the SPA authenticator that could result in SPA/NTLM authentication bypass in auths/spa.c and auths/auth-spa.c.  The spa authentication driver is not enabled by default.<br />Vulnerable: <= 4.84.2-2+deb8u6<br />Fixed: 4.84.2-2+deb8u7 | 3.7.12-3.7.14.2 | |
| <a name="2550056"></a> [2550056](#2550056) <a name="2550056"></a> <br />CM-29652 | The ACCTON-DIAG option under the Cumulus Linux GRUB menu does not work. When you select this option, you see the following error:<br /><pre><br />error: invalid signature.<br />Press any key to continue...<br /></pre> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549925"></a> [2549925](#2549925) <a name="2549925"></a> <br />CM-29594 | When you run an Ansible script to replace the <code>/etc/network/interfaces</code> file, then run the <code>ifreload -a</code> command, you see errors similar to the following:<br /><pre><br />error: swp1s1.2: netlink: cannot set link swp1s1.2 up: operation failed with 'Network is down' (100)<br />warning: cmd '/bin/ip addr del 10.0.0.1/24 dev eth0' failed: returned 2 (RTNETLINK answers: Cannot assign requested address<br /></pre><br />To work around this issue,  run the <code>ifreload -a</code> command a second time. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549872"></a> [2549872](#2549872) <a name="2549872"></a> <br />CM-29562 | If you have an SVI with multiple VRR IP addresses and try to delete one of the VRR configurations, <code>net commit</code> or <code>ifreload -a</code> returns an error. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549859"></a> [2549859](#2549859) <a name="2549859"></a> <br />CM-29556 | The following vulnerability has been announced that affects ntp:<br />CVE-2020-11868: ntpd in ntp before 4.2.8p14 and 4.3.x before 4.3.100 allows an off-path attacker to block unauthenticated synchronization via a server mode packet with a spoofed source IP address, because transmissions are rescheduled even when a packet lacks a valid origin timestamp.<br />This affects: ntp-4.2.8p12 (possibly earlier) and ntp-4.2.8p13<br />The fix for https://bugs.ntp.org/3445 introduced a bug whereby a system that is running ntp-4.2.8p12 or p13 that only has one unauthenticated time source can be attacked in a way that causes the victim's next poll to its source to be delayed, for as long as the attack is maintained.<br />http://support.ntp.org/bin/view/Main/NtpBug3592 gives the following mitigations if it is not possible to upgrade to a version with the fix:<br />* Use authentication with symmetric peers.<br />* Have enough sources of time.  The default NTP configuration in Cumulus Linux has four time sources.<br /><br />Fixed: 4.2.8p12+dfsg-4+cl4u13 | 3.7.12-4.1.1 | 4.2.0-4.3.0|
| <a name="2549838"></a> [2549838](#2549838) <a name="2549838"></a> <br />CM-29546 | In vtysh, if you configure, then remove a layer 3 VNI for a VRF, the VNI is removed from zebra even if the VNI interface still exists in the kernel.<br />If you configure a layer 2 VNI as a layer 3 VNI by mistake, removing the layer 3 VNI binding removes it from zebra but EVPN-learned MACs and neighbors are not installed into the kernel.<br />To work around this issue, delete, then re-add the missing VNI. For example:<br /><pre><br />cumulus&#64;switch:~$ sudo ifdown vni10100<br />cumulus&#64;switch:~$ sudo ifup vni10100<br /></pre><br />If you flap the link with the <code>ip link set vni10100 down; ip link set vni10100 up</code> commands, zebra does not re-add the VNI. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2549782"></a> [2549782](#2549782) <a name="2549782"></a> <br />CM-29519 | The JSON format output of the <code>net show bgp l2vpn evpn summary</code> command shows the incorrect neighbour state.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549731"></a> [2549731](#2549731) <a name="2549731"></a> <br />CM-29492 | When you create SPAN or ERSPAN rules in ebtables, the action fails to install if it is not in lowercase. Make sure that the SPAN or ERSPAN action is all lowercase; for example:<br /><pre><br />&#91;ebtables&#93;<br />-A FORWARD --in-interface swp10 -j span --dport swp1<br /></pre> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549472"></a> [2549472](#2549472) <a name="2549472"></a> <br />CM-29367 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2549371"></a> [2549371](#2549371) <a name="2549371"></a> <br />CM-29309 | When Optimized Multicast Flooding (OMF) is enabled with the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/switchd.conf</code> file, the switch continues to flood IPv6 multicast traffic to all slave ports when there is no MLD join receive. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549226"></a> [2549226](#2549226) <a name="2549226"></a> <br />CM-29259 | You might see the following <code>gport</code> error messages in <code>switchd.log</code>:<br /><pre><br />2020-04-10T19:50:01.011224+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x800007a find failed<br />2020-04-10T19:50:01.011631+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x8000009 find failed<br /></pre><br />These messages are harmless and can be ignored. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548962"></a> [2548962](#2548962) <a name="2548962"></a> <br />CM-29165 | With FRR or OSPF, you might see an inconsistent link-state advertisement. For example, when you configure the OSPF default originate route as metric-type 1 with a specific metric, Cumulus Linux shows the default originate route as an external metric-type 2 route with the default metric in the database. This issue typically occurs when both IPv4 and IPv6 default routes exist in the routing table. | 3.7.12-4.1.1 | 4.2.0-4.3.0|
| <a name="2548930"></a> [2548930](#2548930) <a name="2548930"></a> <br />CM-29148 | On MLX switches that contain an OSPF IP unnumbered neighborship with a high scale of prefixes being learned, a link flap might cause the neighbor entry to not be programmed in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2548746"></a> [2548746](#2548746) <a name="2548746"></a> <br />CM-29068 | On the Broadcom switch with the Trident3 ASIC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548672"></a> [2548672](#2548672) <a name="2548672"></a> <br />CM-29043 | When a multipath route that contains an EVPN path exists together with an IPv4 BGP path in the VRF, the RMAC to VTEP binding is incorrect. This invalid entry occurs because Cumulus Linux treats IPv4 routes received over the eBGP IPv4 peering incorrectly in the VRF.<br />To work around this issue, remove the unnecessary eBGP IPv4 peering. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548657"></a> [2548657](#2548657) <a name="2548657"></a> <br />CM-29035 | When you upgrade Cumulus Linux on the EdgeCore AS7726-32X or AS7326-56X switch, you might see firmware errors similar to the following:<br /><pre><br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso5.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3.bin for module tg3<br /></pre><br />You can safely ignore these error messages. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548490"></a> [2548490](#2548490) <a name="2548490"></a> <br />CM-28944 | A change in a route map prefix list that should remove a route might not be reflected in the <code>ospf6</code> database or in peers, and the route might not be deleted. <br />To work around this issue, reenter the <code>redistribute <connected\|static> route-map <route-map-name></code> statement in the configuration. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548485"></a> [2548485](#2548485) <a name="2548485"></a> <br />CM-28940 | If you configure <code>aggregate-address <address> summary-only</code> before a component of the same aggregate is injected into the BGP table with the <code>network</code> or <code>redistribute</code> command, when you remove the <code>aggregate-address</code> configuration, the component stays suppressed; it is not advertised to peers. For example:<br />Existing configuration:<br /><pre><br />router bgp 1<br /> address-family ipv4 unicast<br />  aggregate-address 50.0.0.0/8 summary-only<br /> exit-address-family<br /></pre><br />If you add <code>network 50.0.0.1/32</code>, you see the following (expected) BGP table entries:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />*> 50.0.0.0         0.0.0.0                            32768 i<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />Removing <code>aggregate-address 50.0.0.0/8 summary-only</code> at this point results in the following (unexpected) BGP table entry:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />To work around this issue, remove, then re-add the component prefix routes. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548315"></a> [2548315](#2548315) <a name="2548315"></a> <br />CM-28816 | The following security advisory has been announced for bash: <br />CVE-2019-18276 Qualys scan QID 372268 setuid vulnerability<br />When bash or bash scripts are run setuid, bash is supposed to drop privileges, but does so incorrectly, so that an attacker with command access to the shell can use <code>enable -f</code> for runtime loading of a new builtin that calls <code>setuid()</code> to regain dropped privileges.<br />To work around this issue, do not make bash or bash scripts <code>setuid</code>. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548117"></a> [2548117](#2548117) <a name="2548117"></a> <br />CM-28659 | In OVSDB traditional bridge mode, adding or removing a VLAN binding causes a traffic forwarding outage for around 20 seconds or more on adjacent VLAN bindings. Cumulus Linux does not support _traditional_ bridge mode with VMware NSX. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548024"></a> [2548024](#2548024) <a name="2548024"></a> <br />CM-28596 | On the Dell Z9100 switch, 100G-SR4 modules might not link up reliably in certain ports. <br />swp1, 2, 3, 9, 10, 23, 24, 30, 31, and 32 might be affected<br />To work around this issue, move 100G SR4 modules to one of the ports not affected by this issue. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547942"></a> [2547942](#2547942) <a name="2547942"></a> <br />CM-28533 | On the Lenovo NE0152T switch, one power supply (PSU2) always show as ABSENT in smonctl. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547839"></a> [2547839](#2547839) <a name="2547839"></a> <br />CM-28465 | When you try to configure <code>link-down</code> on a parent interface of a subinterface configured in a VRF, you encounter an error. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547782"></a> [2547782](#2547782) <a name="2547782"></a> <br />CM-28441 | If a LLDP neighbor advertises a <code>PortDescr</code> that contains commas, <code>ptmctl -d</code> splits the string on the commas and misplaces its components in other columns. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547706"></a> [2547706](#2547706) <a name="2547706"></a> <br />CM-28397 | When you configure ganged ports in the <code>ports.conf</code> file, the change does not take effect after you restart <code>switchd</code>. <br />To work around this issue, reboot the switch. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2547659"></a> [2547659](#2547659) <a name="2547659"></a> <br />CM-28372 | On the EdgeCore AS7326-56X switch, the default fan speed, which is defined in the thermal specification, results in excessive fan noise. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547573"></a> [2547573](#2547573) <a name="2547573"></a> <br />CM-28322 | On Tomahawk switches, when the <code>vxlan_tnl_arp_punt_disable</code> option is set to FALSE, ARP packets are not forwarded to the CPU. | 3.7.9-4.0.1 | 4.1.0-4.3.0|
| <a name="2547443"></a> [2547443](#2547443) <a name="2547443"></a> <br />CM-28248 | On the Dell N3248PXE-ON switch, 25G SFP ports do not work in 10G mode. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547123"></a> [2547123](#2547123) <a name="2547123"></a> <br />CM-28078 | On the Broadcom switch with the Trident3 ASC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547120"></a> [2547120](#2547120) <a name="2547120"></a> <br />CM-28076 | After you hot swap a PSU, the <code>decode-syseeprom -t psuX</code> command shows the old PSU information (such as the serial number), until you run the <code>decode-syseeprom --init</code> command. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547100"></a> [2547100](#2547100) <a name="2547100"></a> <br />CM-28061 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546992"></a> [2546992](#2546992) <a name="2546992"></a> <br />CM-28004 | The wireshark packages (libwireshark5, libwireshark-data, wireshark, wireshark-common) available for optional installation on Cumulus Linux 3 are vulnerable to CVE-2018-12086: Buffer overflow in OPC UA applications allows remote attackers to trigger a stack overflow with carefully structured requests.  More information at https://www.wireshark.org/security/wnpa-sec-2018-50.html and https://security-tracker.debian.org/tracker/CVE-2018-12086 . | 3.7.11-3.7.14.2 | |
| <a name="2546991"></a> [2546991](#2546991) <a name="2546991"></a> <br />CM-28003 | The FRR service does not provide a way for automation to know if the configuration applied properly.<br />To work around this issue, execute the <code>vtysh -f <file></code> command in the automation file before starting the FRR service to validate the functional configuration and return an error code. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546989"></a> [2546989](#2546989) <a name="2546989"></a> <br />CM-28001 | The libxen packages are not installed on the switch by default, but are available in the repository for optional installation.<br /><br />Customers who optionally install the libxen packages should be aware of the following security advisory.<br /><br />Debian Security Advisory DSA-4602-1<br />CVE-2019-17349 CVE-2019-17350 CVE-2019-18420 CVE-2019-18421<br />CVE-2019-18422 CVE-2019-18423 CVE-2019-18424 CVE-2019-18425<br />CVE-2019-19577 CVE-2019-19578 CVE-2019-19579 CVE-2019-19580<br />CVE-2019-19581 CVE-2019-19582 CVE-2019-19583 CVE-2018-12207<br />CVE-2018-12126 CVE-2018-12127 CVE-2018-12130 CVE-2019-11091<br />CVE-2019-11135 CVE-2019-17348 CVE-2019-17347 CVE-2019-17346<br />CVE-2019-17345 CVE-2019-17344 CVE-2019-17343 CVE-2019-17342<br />CVE-2019-17341 CVE-2019-17340<br /><br />Multiple vulnerabilities have been discovered in the Xen hypervisor, which<br />could result in denial of service, guest-to-host privilege escalation or<br />information leaks.<br /><br />For more information, see https://security-tracker.debian.org/tracker/xen | 3.7.11-3.7.14.2 | |
| <a name="2546895"></a> [2546895](#2546895) <a name="2546895"></a> <br />CM-27957 | If you have configured a higher number of ports and VLANs (ports x VLANs) or the switch is a lower-powered (CPU) platform, the <code>switchd</code> service might fail to send a <code>systemd keepalive</code> within the watchdog timeout value (2 minutes by default) and you see an error similar to the following:<br /><pre><br />bq. systemd&#91;1&#93;: switchd.service watchdog timeout (limit 2min)!<br /></pre><br />To workaround this issue, either reduce the number of configured interfaces and, or VLANs, or increase the <code>systemd</code> timeout for <code>switchd.service</code>.<br />To increase the <code>systemd</code> timeout:<br /># Edit the <code>/etc/systemd/system/switchd.service.d/override.conf</code> file and increase the <code>WatchdogSec</code> parameter.<br /># Restart the <code>switchd</code> service with the <code>sudo systemctl restart switchd.service</code> command.<br /><code>systemd</code> will attempt to restart the <code>switchd</code> service automatically (after the watchdog timeout). If the restart fails multiple times in a short time period, run the <code>sudo systemctl reset-failed</code> command followed by the <code>sudo systemctl restart switchd</code> command.<br /> | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546848"></a> [2546848](#2546848) <a name="2546848"></a> <br />CM-27937 | Debian security advisory DSA-4213 for qemu lists a number of security vulnerabilities.<br />https://www.debian.org/security/2018/dsa-4213<br />One of the listed vulnerabilities is still present in the latest upstream version 2.1+dfsg-12+deb8u12 (the others have been fixed):<br />CVE-2017-15124 Daniel Berrange discovered that the integrated VNC server insufficiently restricted memory allocation, which could result in denial of service.<br />https://security-tracker.debian.org/tracker/CVE-2017-15124 | 3.7.11-3.7.14.2 | |
| <a name="2546542"></a> [2546542](#2546542) <a name="2546542"></a> <br />CM-27793 | A security vulnerability has been announced in the cyrus-sasl2 (libsasl2-2 and libsasl2-modules) package. The libraries are installed by default on Cumulus Linux.<br />CVE-2019-19906: Stephan Zeisberg reported an out-of-bounds write vulnerability in the _sasl_add_string() function in cyrus-sasl2, a library implementing the Simple Authentication and Security Layer. A remote attacker can take advantage of this issue to cause denial-of-service conditions for applications using the library.<br />Vulnerable: 2.1.27+dfsg-1<br />Fixed: 2.1.27+dfsg-1+deb10u1 | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2546385"></a> [2546385](#2546385) <a name="2546385"></a> <br />CM-27698 | SNMP ifLastChange reports link transitions when there are none. | 3.7.6-3.7.14.2 | |
| <a name="2546225"></a> [2546225](#2546225) <a name="2546225"></a> <br />CM-27627 | When you execute the following command on the Delta AG6248C switch, the switch reboots and then comes right back into Cumulus Linux without installing the new image. The install image is still in <code>/var/lib/cumulus/installer</code>, which causes issues with cl-support. <br /> <pre> <br /> sudo onie-install -fai http://<path to image> <br /> sudo reboot <br /> </pre> <br /> To work around this issue, use the <code>onie-select</code> command to access ONIE, and then use the <code>nos-install</code> command in ONIE to install a new binary image.  | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546203"></a> [2546203](#2546203) <a name="2546203"></a> <br />CM-27620 | When using QinQ with a traditional bridge, if you enable the LLDP dot1 TLV option, you see the following suboptimal behavior:<br />* Both the inner and outer VLAN information is sent as part of VLAN TLVs in the LLDP packet. <br />* If the outer VLAN ID is the same as the inner VLAN ID, only one VLAN TLV is sent with that VLAN ID in the LLDP packet. | 3.7.11-3.7.14.2 | |
| <a name="2546131"></a> [2546131](#2546131) <a name="2546131"></a> <br />CM-27581 | On the Delta AG-6248C PoE switch, when you run the <code>apt upgrade</code> command, the upgrade does not work. Cumulus Linux uses <code>uboot</code> directly instead of <code>grub</code> to boot the kernel. Uboot needs a special header to boot the kernel, which is not present. Without this header, when you use the <code>apt upgrade</code> command to upgrade Linux packages, <code>uboot</code> is unable to boot up the kernel. <br />To work around this issue, upgrade Cumulus Linux by installing the Cumulus Linux image. Run the <code>onie-select</code> command to go into ONIE, and then use the <code>nos-install</code> command in ONIE to install a new image.<br />This workaround only works when an out-of-band network is present. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546010"></a> [2546010](#2546010) <a name="2546010"></a> <br />CM-27530 | When <code>hal.bcm.per_vlan_router_mac_lookup</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file, inter-VLAN traffic is forwarded to the CPU when associated VNI interfaces exist. | 3.7.10-3.7.14.2 | |
| <a name="2545997"></a> [2545997](#2545997) <a name="2545997"></a> <br />CM-27522 | The NCLU command <code>net show interface</code> produces an error if bonds with no members exist.<br />To work around this issue, remove the empty Bond interfaces from the <code>/etc/network/interfaces</code> file and run <code>sudo ifreload -a</code>. | 3.7.10-3.7.14.2 | |
| <a name="2545566"></a> [2545566](#2545566) <a name="2545566"></a> <br />CM-27272 | The Dell Z9100-ON switch incorrectly reports many sensors as ABSENT. | 3.7.12-4.0.1 | 4.1.0-4.3.0|
| <a name="2545446"></a> [2545446](#2545446) <a name="2545446"></a> <br />CM-27192 | If you use NCLU commands to add a non-MLAG bond, then add an MLAG configuration, the <code>net commit</code> command fails. However, a subsequent <code>net commit</code> command succeeds. | 3.7.10-3.7.14.2 | |
| <a name="2545125"></a> [2545125](#2545125) <a name="2545125"></a> <br />CM-27018 | If you configure more than one VRR interface on an SVI interface, deleting one of the VRR addresses does not remove the interface/address.  | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544978"></a> [2544978](#2544978) <a name="2544978"></a> <br />CM-26921 | If you delete an undefined bond, then add a bond slave, the <code>net commit</code> command fails. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544968"></a> [2544968](#2544968) <a name="2544968"></a> <br />CM-26913 | FRR configuration commands for an SVI interface might have the <code>\n</code> misplaced in the output.  For example:<br /><pre><br />sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />should be:<br /><pre><br />sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />To work around this issue, configure the interface manually in the <code>/etc/frr/frr.conf</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544953"></a> [2544953](#2544953) <a name="2544953"></a> <br />CM-26905 | When you update the hostname of a switch with the NCLU <code>net add hostname <hostname></code> command, then run <code>net commit</code>, the <code>lldpd</code> service does not restart and other devices still see the old hostname.<br />To work around this issue, run the <code>sudo systemctl restart lldpd.service</code> command. | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544904"></a> [2544904](#2544904) <a name="2544904"></a> <br />CM-26875 | After you delete an IPv6 numbered BGP peer group neighbor, Cumulus Linux might continue to send route advertisements.<br />To work around this issue, restart FRR after removing the IPv6 numbered configuration. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544556"></a> [2544556](#2544556) <a name="2544556"></a> <br />CM-26655 | If you reconfigure an NTP server with NCLU using different trailing options after the IP address (such as <code>iburst</code>), an invalid configuration is added to the <code>/etc/ntp.conf</code> file. For example:<br /><pre><br />net add time ntp server 1.2.3.4 iburst<br />net commit<br />net add time ntp server 1.2.3.4<br />net commit<br /></pre><br />If you need to alter existing server configurations, first remove the server, commit, then re-add the server with any trailing options. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544463"></a> [2544463](#2544463) <a name="2544463"></a> <br />CM-26599 | Auto-negotiation does not work with the QSFP28 cables and a remote system operating at 10G. Attempting to enable auto-negotiation with <code>ethtool -s swp<#> autoneg on</code> returns <code>Operation not supported</code>.<br />To work around this issue, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544456"></a> [2544456](#2544456) <a name="2544456"></a> <br />CM-26595 | The NCLU <code>net show lldp</code> command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544235"></a> [2544235](#2544235) <a name="2544235"></a> <br />CM-26463 | The following CVEs affect the linux kernel package:<br />CVE-2019-14821 CVE-2019-14835 CVE-2019-15117 CVE-2019-15118 CVE-2019-15902<br />Several vulnerabilities have been discovered in the Linux kernel that<br />may lead to a privilege escalation, denial of service or information<br />leaks.<br />For the detailed security status of linux,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/linux | 3.7.10-3.7.14.2 | |
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544113"></a> [2544113](#2544113) <a name="2544113"></a> <br />CM-26412 | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address changing between the MLAG bond and the peer link.<br />To work around this issue, disable MAC learning on QinQ VLANs by adding <code>bridge-learning off</code> to the VLAN stanza in the <code>etc/network/interfaces</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543900"></a> [2543900](#2543900) <a name="2543900"></a> <br />CM-26288 | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543841"></a> [2543841](#2543841) <a name="2543841"></a> <br />CM-26256 | The <code>net show evpn vni detail json</code> command includes an extra empty dictionary at the end of the output. <br /> | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | 4.3.0|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543270"></a> [2543270](#2543270) <a name="2543270"></a> <br />CM-25923 | The default route injected through OSPF when you configure <code>default-information originate always</code> is unreliable and might age out unexpectedly.<br />To work around this issue, rely on a different source of default route other than injection with <code>default-information originate</code>. | 3.7.8-4.1.1 | 4.2.0-4.3.0|
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542979"></a> [2542979](#2542979) <a name="2542979"></a> <br />CM-25766 | On the Dell-N3048EP-ON switch, when you run the <code>sudo -E apt upgrade</code> command, the upgrade does not work.  | 3.7.7-4.1.1 | 4.2.0-4.3.0|
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542310"></a> [2542310](#2542310) <a name="2542310"></a> <br />CM-25404 | <code>hsflow</code> disregards the setting for <code>agent.cidr</code> in the <code>/etc/hsflowd.conf</code> file and selects an IPv6 agent address. The source IP address of the hsflowd packet is IPv4, but the agent address in the <code>hsflow</code> payload shows IPv6. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541165"></a> [2541165](#2541165) <a name="2541165"></a> <br />CM-24878 | On the Dell N3048EP-ON switch, UPOE is supported only on ports 1 thru 12. (UPOE uses all four pairs of standard Ethernet cabling whereas PoE delivers power over two twisted pairs.) When you plug a UPOE device in a port higher than port 12, <code>poectl</code> reports that <code>four_pair_mode_enabled</code> is true. However, this configuration is not supported on the port so <code>poectl</code> should report that <code>four_pair_mode_enabled</code> is false. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540950"></a> [2540950](#2540950) <a name="2540950"></a> <br />CM-24751 | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switch, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status.<br />  | 3.7.3-4.1.1 | 4.2.0-4.3.0|
| <a name="2540885"></a> [2540885](#2540885) <a name="2540885"></a> <br />CM-24703 | The Dell N3048EP-ON switch does not support 1G Base-T modules in the SFP ports. | 3.7.7-3.7.14.2 | |
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538875"></a> [2538875](#2538875) <a name="2538875"></a> <br />CM-23696 | IPv6 multicast traffic destined to an unregistered multicast group is flooded to all ports in a bridge despite the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/swichd.conf</code> file. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538302"></a> [2538302](#2538302) <a name="2538302"></a> <br />CM-23422 | <code>portwd</code> allows an error to change the module type based on the error. For example, a bad write to a module might cause the module type to flap, which causes the link itself to flap. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538256"></a> [2538256](#2538256) <a name="2538256"></a> <br />CM-23397 | On the Broadcom switch, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets. <br />  | 3.7.2-4.0.1 | 4.1.0-4.3.0|
| <a name="2537823"></a> [2537823](#2537823) <a name="2537823"></a> <br />CM-23125 | The OpenSSL package on Cumulus Linux 3.x has a vulnerability similar to CVE-2018-0734. (The OpenSSL DSA signature algorithm has been shown to be vulnerable to a timing side channel attack. An attacker could use variations in the signing algorithm to recover the private key).  According to Debian upstream, this version "is not vulnerable &#91;to CVE-2018-0734 exactly&#93;. Nevertheless, there is a bug fix that futher reduces the amount of leaked timing information. It got no CVE on its own and introduced this vulnerability."<br />Vulnerable on CL3: 1.0.1t-1+deb8u12 | 3.7.11-3.7.14.2 | |
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537544"></a> [2537544](#2537544) <a name="2537544"></a> <br />CM-23021 | When you run the <code>mstpctl</code> command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of <code>mstpctl</code>; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | 4.3.0|
| <a name="2537514"></a> [2537514](#2537514) <a name="2537514"></a> <br />CM-23004 | The local fallback account authenticates using the local password when the RADIUS or TACACS service is up. The expected behavior is for this to fail and only succeed when the RADIUS OR TACACS server fails to respond. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537378"></a> [2537378](#2537378) <a name="2537378"></a> <br />CM-22937 | NCLU SNMPv3 user configuration (add, delete, modify) does not complete. Changes are made to the <code>/etc/snmp/snmpd.conf</code> file but the SNMPv3 user cache file <code>/var/lib/snmp/snmpd.conf</code> fails to update correctly and the configuration does not reflect in operation. <br />To work around this issue, stop <code>snmpd</code>, remove the cache file, then restart <code>snmpd</code>. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537188"></a> [2537188](#2537188) <a name="2537188"></a> <br />CM-22849 | When an event in the network, such as a <code>switchd</code> or networking service restart, leads to an OVSDB server high availability transition, an <code>ovs-vtepd</code> core might occur. <br />This core generation has no effect on the functionality of high availability when the active OVSDB server is back in the network. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2537061"></a> [2537061](#2537061) <a name="2537061"></a> <br />CM-22794 | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent. <br /> | 3.7.1-4.0.1 | 4.1.0-4.3.0|
| <a name="2536608"></a> [2536608](#2536608) <a name="2536608"></a> <br />CM-22583 | Single tagged ARP requests received on a QinQ-over-VXLAN access port are dropped if ARP suppression is enabled on an unrelated VNI. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on protocol sockets.<br />When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a <code>switchd</code> restart. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535965"></a> [2535965](#2535965) <a name="2535965"></a> <br />CM-22020 | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br />To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2534394"></a> [2534394](#2534394) <a name="2534394"></a> <br />CM-20480 | The python-crypto package, which is not installed by default on Cumulus Linux, but is present in the repository to be installed, has the following security vulnerability in the version available for Cumulus Linux 3.x:<br />CVE-2018-6594: lib/Crypto/PublicKey/ElGamal.py in PyCrypto through 2.6.1 generates weak ElGamal key parameters, which allows attackers to obtain sensitive information by reading ciphertext data (i.e., it does not have semantic security in face of a ciphertext-only attack). The Decisional Diffie-Hellman (DDH) assumption does not hold for PyCrypto's ElGamal implementation.<br />More information at https://security-tracker.debian.org/tracker/CVE-2018-6594 . | 3.7.9-3.7.14.2 | |
| <a name="2533691"></a> [2533691](#2533691) <a name="2533691"></a> <br />CM-19788 | If you configure a VLAN under a VLAN-aware bridge and create a subinterface of the same VLAN on one of the bridge ports, the bridge and interface compete for the same VLAN and if the interface is flapped, it stops working. Correcting the configuration and running the <code>ifreload</code> command does not resolve the conflict. <br />To work around this issue, correct the bridge VIDs and restart <code>switchd</code> or delete the subinterface.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2532017"></a> [2532017](#2532017) <a name="2532017"></a> <br />CM-18192 | In FRR, <code>bgp_snmp</code> does not show all BGP peers when peer groups used. | 3.7.11-4.0.1 | 4.1.0-4.3.0|

### Fixed Issues in 3.7.14.2
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="CM-30832"></a> [CM-30832](#CM-30832) <a name="CM-30832"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with `Unable to read from device/fan1_input/pwm1` syslog messages. | 3.7.11-3.7.14, 4.1.1-4.2.1 | |
| <a name="2556288"></a> [2556288](#2556288) <a name="2556288"></a> <br />CM-33165 | CVE-2021-3156: A serious heap-based buffer overflow has been discovered in sudo that is exploitable by any local user. It has been given the name Baron Samedit by its discoverer. The bug can be leveraged to elevate privileges to root, even if the user is not listed in the sudoers file. User authentication is not required to exploit the bug.<br />Vulnerable: <= 1.8.10p4-cl3.7.14u1<br />Fixed: 1.8.10p4-cl3.7.15u1<br />Note: security scanners may not recognize 1.8.10p4-cl3.7.15u1 as fixed and therefore incorrectly list it as vulnerable. | 3.7.14 | |
| <a name="2556012"></a> [2556012](#2556012) <a name="2556012"></a> <br />CM-32994 | On Broadcom switches, after repeated VLAN or VXLAN configuration changes, <code>switchd</code> memory might not free up appropriately, which can lead to a crash.  | 3.7.14, 4.0.0-4.2.1 | |
| <a name="2555628"></a> [2555628](#2555628) <a name="2555628"></a> <br />CM-32797 | The following vulnerabilities have been announced in curl:<br />CVE-2020-8284: Vulnerability to malicious FTP server with PASV response with different IP address.<br />CVE-2020-8285: Wildcard matching is vulnerable to denial of service by running out of stack space.<br />Vulnerable: <= 7.38.0-4+deb8u18<br />Fixed: 7.38.0-4+deb8u19 | 3.7.14 | |
| <a name="2555508"></a> [2555508](#2555508) <a name="2555508"></a> <br />CM-32734 | CVE-2018-0734: A minor timing side channel attack was found in the OpenSSL DSA<br />signature algorithm. The fix for that introduced a more severe regression that could also be exploited as a timing side channel attack. This update fixes both the original problem and the subsequent issue.<br />CVE-2020-1971: A flaw in the GENERAL_NAME_cmp() function could cause a NULL dereference, resulting in denial of service.<br />Vulnerable: <= 1.0.1t-1+deb8u12<br />Fixed: 1.0.1t-1+deb8u13 | 3.7.14 | |
| <a name="2555494"></a> [2555494](#2555494) <a name="2555494"></a> <br />CM-32728 | On Broadcom switches, when WARN level <code>switchd</code> log messages are generated, <code>switchd</code> might crash resulting in a core file generated on the system. | 3.7.14 | |
| <a name="2555315"></a> [2555315](#2555315) <a name="2555315"></a> <br />CM-32609 | CVE-2020-25709, CVE-2020-25710: Vulnerabilities in the certificate list syntax verification and in the handling of CSN normalization were discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of these flaws to cause a denial of service (slapd daemon crash) via specially crafted packets.<br />Vulnerable: <= 2.4.40+dfsg-1+deb8u7<br />Fixed: 2.4.40+dfsg-1+deb8u8 | 3.7.14 | |
| <a name="2555178"></a> [2555178](#2555178) <a name="2555178"></a> <br />CM-32529 | On Mellanox switches, the ASIC temperature sensor reading reports zeros. As a result, the fan speed is higher than normal. <br />You can see the temperature reading in the output of the <code>sensors</code> command. | 3.7.14 | |
| <a name="2552214"></a> [2552214](#2552214) <a name="2552214"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14, 4.1.1-4.3.0 | |

## 3.7.14 Release Notes
### Open issues in 3.7.14

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-31420"></a> [CM-31420](#CM-31420) <a name="CM-31420"></a> <br /> | On a Cumulus Linux switch with high load averages, cl-support might end without creating a tar file  and leave a temporary directory in `/var/support` undeleted. Subsequent runs of cl-support do not clean up this directory. | 3.7.13-3.7.14.2 | |
| <a name="CM-30832"></a> [CM-30832](#CM-30832) <a name="CM-30832"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with `Unable to read from device/fan1_input/pwm1` syslog messages. | 3.7.11-3.7.14, 4.1.1-4.2.1 | 3.7.14.2, 4.3.0|
| <a name="CM-28462"></a> [CM-28462](#CM-28462) <a name="CM-28462"></a> <br /> | On rare occasions, when you upgrade Cumulus Linux with the `apt-get upgrade` command, the upgrade fails and reports `No space left on device`. Checking the disk utilization shows that the disk is not full.<br/>To work around this issue, run the `apt-get upgrade` command again and reboot the device if prompted to complete the upgrade. | 3.7.10-3.7.14.2 | |
| <a name="CM-28080"></a> [CM-28080](#CM-28080) <a name="CM-28080"></a> <br /> | TACACS+ through ClearPass is not currently supported. Cumulus Linux sends authorization before authentication, but ClearPass does not accept an authorization before the user is authenticated. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2595889"></a> [2595889](#2595889) <a name="2595889"></a> <br />CM-31120 | In a traditional bridge configuration with <code>ip-forward off</code>, neighbors are synchronized to hardware with a <code>switchd</code> restart but are cleared when you flap the bridge interface. | 3.7.10-4.2.1 | 4.3.0|
| <a name="2595816"></a> [2595816](#2595816) <a name="2595816"></a> <br />CM-31222 | Tenant VRF BGP peers appear in the EVPN RMAC and nexthop tables, which causes the kernel RMAC to point at invalid IP address. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2589747"></a> [2589747](#2589747) <a name="2589747"></a> <br />CM-32226 | If <code>switchd</code> successfully signals <code>clagd</code> that it is going down, <code>clagd</code> stops responding to keepalive echo requests from the peer instead of sending a good bye to the peer over both the peerlink and the backup switch. Eventually, the keepalive timer expires and the secondary switch becomes the primary, and brings the bonds and VNIs back up. However, if <code>switchd</code> does not successfully signal it is going down, (in the event of a crash), the primary switch continues to respond to keepalives, and the bonds and VNIs are down on both peers.  | 3.7.12-4.2.1 | 4.3.0|
| <a name="2574294"></a> [2574294](#2574294) <a name="2574294"></a> <br /> | CVE-2021-3410: A buffer overflow issue in caca_resize function in libcaca/caca/canvas.c may lead to local execution of arbitrary code in the user context<br />Vulnerable: <= 0.99.beta19-2+deb8u1Fixed: 0.99.beta19-2+deb8u2 | 3.7.14-3.7.14.2 | |
| <a name="2566880"></a> [2566880](#2566880) <a name="2566880"></a> <br /> | CVE-2021-27803: A vulnerability was discovered in how p2p/p2p_pd.c in wpa_supplicant before 2.10 processes P2P (Wi-Fi Direct) provision discovery requests. It could result in denial of service or other impact (potentially execution of arbitrary code), for an attacker within radio range. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2562511"></a> [2562511](#2562511) <a name="2562511"></a> <br /> | <code>hostapd} does not fail over to secondary RADIUS servers for 802.1x authentication when the primary radius is reachable but not responding to Access-Requests<br />If the primary RADIUS server is having a problem servicing requests, you can remove it from the configuration temporarily to force requests to be sent to alternate servers. | 3.7.10-3.7.14.2 | |
| <a name="2562396"></a> [2562396](#2562396) <a name="2562396"></a> <br /> | CVE-2020-27824: Global buffer overflow on irreversible conversion when too many decomposition levels are specified.<br />CVE-2020-27841: Crafted input to be processed by the openjpeg encoder could cause an out-of-bounds read.<br />CVE-2020-27845: Crafted input can cause out-of-bounds-read.<br />Vulnerable: <= 2.1.0-2+deb8u11<br />Fixed: 2.1.0-2+deb8u12 | 3.7.14-3.7.14.2 | |
| <a name="2562301"></a> [2562301](#2562301) <a name="2562301"></a> <br /> | CVE-2021-26937: encoding.c in GNU Screen through 4.8.0 allows remote attackers to cause a denial of service (invalid write access and application crash) or possibly have unspecified other impact via a crafted UTF-8 character sequence.<br />Vulnerable: <= 4.2.1-3+deb8u1<br />Fixed: 4.2.1-3+deb8u2 | 3.7.14-3.7.14.2 | |
| <a name="2558184"></a> [2558184](#2558184) <a name="2558184"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2556816"></a> [2556816](#2556816) <a name="2556816"></a> <br />CM-33419 | When ARP suppression is enabled, RARP packets sometimes get dropped and are not flooded by the local VTEP. <br />To work around this issue, disable ARP suppression. | 3.7.14-3.7.14.2, 4.3.0 | |
| <a name="2556783"></a> [2556783](#2556783) <a name="2556783"></a> <br />CM-33398 | CVE-2021-0326: An issue has been found in wpa, a set of tools to support WPA and WPA2 (IEEE 802.11i). Missing validation of data can result in a buffer over-write, which might lead to a DoS of the wpa_supplicant process or potentially arbitrary code execution.<br />Vulnerable: <= 2.8.0-cl3.7.14u1, <= 2.8.0-cl4.2.1u1 | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2556780"></a> [2556780](#2556780) <a name="2556780"></a> <br />CM-33397 | CVE-2021-27212: A vulnerability in the Certificate List Exact Assertion validation was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of this flaw to cause a denial of service (slapd daemon crash) via specially crafted packets.<br />Vulnerable: <= 2.4.40+dfsg-1+deb8u9<br />Fixed: 2.4.40+dfsg-1+deb8u10 | 3.7.14-3.7.14.2 | |
| <a name="2556779"></a> [2556779](#2556779) <a name="2556779"></a> <br />CM-33396 | CVE-2020-8625: Buffer overflow attack in the bind9 DNS server caused by an issue in the GSSAPI (“Generic Security Services”) security policy negotiation.<br />Vulnerable: <= 9.9.5.dfsg-9+deb8u20<br />Fixed: 9.9.5.dfsg-9+deb8u21 | 3.7.14-3.7.14.2 | |
| <a name="2556764"></a> [2556764](#2556764) <a name="2556764"></a> <br />CM-33385 | In a configuration with both traditional and vlan-aware bridges, the VLAN membership check on a vlan-aware switch does not drop PVST BPBUs that come from a traditional bridge. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2556743"></a> [2556743](#2556743) <a name="2556743"></a> <br />CM-33370 | CVE-2019-20367: An issue has been found in libbsd, a library with utility functions from BSD systems. A non-NUL terminated symbol name in the string table might result in an out-of-bounds read.<br />Vulnerable: <= 0.7.0-2+deb8u1<br />Fixed: 0.7.0-2+deb8u2 | 3.7.14-3.7.14.2 | |
| <a name="2556742"></a> [2556742](#2556742) <a name="2556742"></a> <br />CM-33369 | The following vulnerabilities have been announced in the openssl package:<br />CVE-2021-23840: an issue where “Digital EnVeloPe” EVP-related calls could cause applications to behave incorrectly or even crash.<br />CVE-2021-23841: an issue in the X509 certificate parsing caused by the lack of error handling while ingesting the “issuer” field.<br />Vulnerable: <= 1.0.1t-1+deb8u13<br />Fixed: 1.0.1t-1+deb8u14 | 3.7.14-3.7.14.2 | |
| <a name="2556689"></a> [2556689](#2556689) <a name="2556689"></a> <br />CM-33333 | CVE-2020-15469 A MemoryRegionOps object may lack read/write callback methods, leading to a NULL pointer dereference.<br />CVE-2020-15859 QEMU has a use-after-free in hw/net/e1000e_core.c because a guest OS user can trigger an e1000e packet with the data’s address set to the e1000e’s MMIO address. <br />CVE-2020-25084 QEMU has a use-after-free in hw/usb/hcd-xhci.c because the usb_packet_map return value is not checked.<br />CVE-2020-28916 hw/net/e1000e_core.c has an infinite loop via an RX descriptor with a NULL buffer address.<br />CVE-2020-29130 slirp.c has a buffer over-read because it tries to read a certain amount of header data even if that exceeds the total packet length.<br />CVE-2020-29443 ide_atapi_cmd_reply_end in hw/ide/atapi.c allows out-of-bounds read access because a buffer index is not validated.<br />CVE-2021-20181 9pfs: ZDI-CAN-10904: QEMU Plan 9 file system TOCTOU privilege escalation vulnerability.<br />CVE-2021-20221 aarch64: GIC: out-of-bound heap buffer access via an interrupt ID field.<br />Vulnerable: <= 2.1+dfsg-12+deb8u18<br />Fixed: 2.1+dfsg-12+deb8u19 | 3.7.14-3.7.14.2 | |
| <a name="2556612"></a> [2556612](#2556612) <a name="2556612"></a> <br />CM-33311 | CVE-2021-27135: xterm through Patch #365 allows remote attackers to cause a denial of service (segmentation fault) or possibly have unspecified other impact via a crafted UTF-8 character sequence.<br />Vulnerable: 312-2<br />Fixed: 312-2+deb8u1. | 3.7.14-3.7.14.2 | |
| <a name="2556585"></a> [2556585](#2556585) <a name="2556585"></a> <br />CM-33295 | CVE-2021-26926: A heap buffer overflow vulnerability was discovered in JasPer, through jp2_dec.c in the jp2_decode() function.<br />CVE-2021-26927: A null pointer access was discovered in JasPer, through jp2_dec.c in the jp2_decode() function.<br />Vulnerable: <= 1.900.1-debian1-2.4+deb8u8<br />Fixed: 1.900.1-debian1-2.4+deb8u9 | 3.7.14-3.7.14.2 | |
| <a name="2556530"></a> [2556530](#2556530) <a name="2556530"></a> <br />CM-33272 | CVE-2020-0256: In LoadPartitionTable of gpt.cc, there is a possible out of bounds write due to a missing bounds check. This could lead to local escalation of privilege with no additional execution privileges needed.<br />CVE-2021-0308: In ReadLogicalParts of basicmbr.cc, there is a possible out of bounds write due to a missing bounds check. This could lead to local escalation of privilege with no<br />additional execution privileges needed.<br />Vulnerable: 0.8.10-2<br />Fixed: 0.8.10-2+deb8u1 | 3.7.14-3.7.14.2 | |
| <a name="2556525"></a> [2556525](#2556525) <a name="2556525"></a> <br />CM-33270 | CVE-2020-27351: Various memory and file descriptor leaks were discovered in the Python interface to the APT package management runtime library, which could result in denial of service.<br />Vulnerable: <= 0.9.3.13<br />Fixed: 0.9.3.14 | 3.7.14-3.7.14.2 | |
| <a name="2556504"></a> [2556504](#2556504) <a name="2556504"></a> <br />CM-33260 | CVE-2020-36221 CVE-2020-36222 CVE-2020-36223 CVE-2020-36224 CVE-2020-36225 CVE-2020-36226 CVE-2020-36227 CVE-2020-36228 CVE-2020-36229 CVE-2020-36230: Several vulnerabilities were discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of these flaws to cause a denial of service (slapd daemon crash, infinite loops) via specially crafted packets.<br />Vulnerable: <= 2.4.40+dfsg-1+deb8u8<br />Fixed: 2.4.40+dfsg-1+deb8u9 | 3.7.14-3.7.14.2 | |
| <a name="2556473"></a> [2556473](#2556473) <a name="2556473"></a> <br />CM-33246 | CVE-2021-3272: jp2_decode in jp2/jp2_dec.c in libjasper in JasPer has a heap-based buffer over-read when there is an invalid relationship between the number of channels and the number of image components.<br />Vulnerable: <= 1.900.1-debian1-2.4+deb8u6<br />Fixed: 1.900.1-debian1-2.4+deb8u7 | 3.7.14-3.7.14.2 | |
| <a name="2556364"></a> [2556364](#2556364) <a name="2556364"></a> <br />CM-33191 | CVE-2020-35512: An issue has been found in dbus, a simple interprocess messaging system. On a system having multiple usernames sharing the same UID a use-after-free might happen, that could result in a denial of service or undefined behaviour, possibly including incorrect authorization decisions.<br />Vulnerable: <= 1.8.22-0+deb8u3<br />Fixed: 1.8.22-0+deb8u4 | 3.7.14-3.7.14.2 | |
| <a name="2556288"></a> [2556288](#2556288) <a name="2556288"></a> <br />CM-33165 | CVE-2021-3156: A serious heap-based buffer overflow has been discovered in sudo that is exploitable by any local user. It has been given the name Baron Samedit by its discoverer. The bug can be leveraged to elevate privileges to root, even if the user is not listed in the sudoers file. User authentication is not required to exploit the bug.<br />Vulnerable: <= 1.8.10p4-cl3.7.14u1<br />Fixed: 1.8.10p4-cl3.7.15u1<br />Note: security scanners may not recognize 1.8.10p4-cl3.7.15u1 as fixed and therefore incorrectly list it as vulnerable. | 3.7.14 | 3.7.14.2|
| <a name="2556218"></a> [2556218](#2556218) <a name="2556218"></a> <br />CM-33117 | The following vulnerability affects lldpd:<br />CVE-2020-27827: A packet that contains multiple instances of certain TLVs will cause lldpd to continually allocate memory and leak the old memory.  As an example, multiple instances of system name TLV will cause old values to be dropped by the decoding routine.<br />Fixed: 1.0.4-0-cl4.3.0u2 | 3.7.14-4.2.1 | 4.3.0|
| <a name="2556061"></a> [2556061](#2556061) <a name="2556061"></a> <br />CM-33032 | On Edgecore AS4610 switches, the historic CPU usage displayed in <code>/run/sysmonitor/history</code> is sometimes shown as a negative value.  | 3.7.12-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2556037"></a> [2556037](#2556037) <a name="2556037"></a> <br />CM-33012 | After you add an interface to the bridge, an OSPF session flap can occur.<br /><br /> | 3.7.9-4.2.0 | 4.2.1-4.3.0|
| <a name="2556031"></a> [2556031](#2556031) <a name="2556031"></a> <br />CM-33008 | Several security vulnerabilities were found in ImageMagick, a suite of image manipulation programs. An attacker could cause denial of service and execution of arbitrary code when a crafted image file is processed.<br />CVE-2020-19667 Stack-based buffer overflow and unconditional jump in ReadXPMImage in coders/xpm.c<br />CVE-2020-25665 The PALM image coder at coders/palm.c makes an improper call to AcquireQuantumMemory() in routine WritePALMImage() because it needs to be offset by 256. This can cause a out-of-bounds read later on in the routine. This could cause impact to reliability.<br />CVE-2020-25674 WriteOnePNGImage() from coders/png.c (the PNG coder) has a for loop with an improper exit condition that can allow an out-of-bounds READ via heap-buffer-overflow. This occurs because it is possible for the colormap to have less than 256 valid values but the loop condition will loop 256 times, attempting to pass invalid colormap data to the event logger.<br />CVE-2020-27560 ImageMagick allows Division by Zero in OptimizeLayerFrames in MagickCore/layer.c, which may cause a denial of service.<br />CVE-2020-27750 A flaw was found in MagickCore/colorspace-private.h and MagickCore/quantum.h. An attacker who submits a crafted file that is processedcould trigger undefined behavior in the form of values outside the range of type unsigned char and math division by zero. This would most likely lead to an impact to application availability, but could potentially cause other problems related to undefined behavior.<br />CVE-2020-27760 In GammaImage() of /MagickCore/enhance.c, depending on the gamma value, it’s possible to trigger a divide-by-zero condition when a crafted input file is processed by ImageMagick. This could lead to an impact to application availability.<br />CVE-2020-27763 A flaw was found in MagickCore/resize.c. An attacker who submits a crafted file that is processed by ImageMagick could trigger undefined behavior in the form of math division by zero. This would most likely lead to an impact to application availability, but could potentially cause other problems related to undefined behavior.<br />CVE-2020-27765 A flaw was found in MagickCore/segment.c. An attacker who submits a crafted file that is processed by ImageMagick could trigger undefined behavior in the form of math division by zero. This would most likely lead to an impact to application availability, but could potentially cause other problems related to undefined behavior.<br />CVE-2020-27773 A flaw was found in MagickCore/gem-private.h. An attacker who submits a crafted file that is processed by ImageMagick could trigger undefined behavior in the form of values outside the range of type unsigned char or division by zero. This would most likely lead to an impact to application availability, but could potentially cause other problems related to undefined behavior.<br />CVE-2020-29599 ImageMagick mishandles the -authenticate option, which allows setting a password for password-protected PDF files. The user-controlled password was not properly escaped/sanitized and it was therefore possible to inject additional shell commands via coders/pdf.c.<br />Vulnerable: <= 6.8.9.9-5+deb8u21<br />Fixed: 6.8.9.9-5+deb8u22 | 3.7.14-3.7.14.2 | |
| <a name="2556030"></a> [2556030](#2556030) <a name="2556030"></a> <br />CM-33007 | The following vulnerability was announced in the apt packages:<br />CVE-2020-27350: Missing input validation in the ar/tar implementations of APT, the high level package manager, could cause out-of-bounds reads or infinite loops, resulting in denial of service when processing malformed deb files. <br />Vulnerable: <= 1.0.9.8.6<br />Fixed: 1.0.9.8.7 | 3.7.14-3.7.14.2 | |
| <a name="2556012"></a> [2556012](#2556012) <a name="2556012"></a> <br />CM-32994 | On Broadcom switches, after repeated VLAN or VXLAN configuration changes, <code>switchd</code> memory might not free up appropriately, which can lead to a crash.  | 3.7.14, 4.0.0-4.2.1 | 3.7.14.2, 4.3.0|
| <a name="2555691"></a> [2555691](#2555691) <a name="2555691"></a> <br />CM-32829 | The NET-SNMP-EXTEND-MIB, disabled in Cumulus Linux 4.2.1 and 3.7.14 to prevent security vulnerability CVE-2020-15862, is re-enabled read-only. | 3.7.14-4.2.1 | 4.3.0|
| <a name="2555654"></a> [2555654](#2555654) <a name="2555654"></a> <br />CM-32810 | The following vulnerability has been announced in the libflac8 package:<br />CVE-2020-0499: In FLAC__bitreader_read_rice_signed_block of bitreader.c, there is a possible out-of-bounds read due to a heap buffer overflow.  This could lead to remote information disclosure with no additional execution privileges needed. However, user interaction is needed for exploitation.<br />Vulnerable: 1.3.0-3<br />Fixed: 1.3.0-3+deb8u1 | 3.7.14-3.7.14.2 | |
| <a name="2555628"></a> [2555628](#2555628) <a name="2555628"></a> <br />CM-32797 | The following vulnerabilities have been announced in curl:<br />CVE-2020-8284: Vulnerability to malicious FTP server with PASV response with different IP address.<br />CVE-2020-8285: Wildcard matching is vulnerable to denial of service by running out of stack space.<br />Vulnerable: <= 7.38.0-4+deb8u18<br />Fixed: 7.38.0-4+deb8u19 | 3.7.14 | 3.7.14.2|
| <a name="2555553"></a> [2555553](#2555553) <a name="2555553"></a> <br />CM-32757 | It was discovered that the clean_html() function of lxml, a Python library for HTML and XML processing, performed insufficient sanitisation for embedded Javascript code. This might lead to cross-site scripting or possibly the execution of arbitrary code.<br />Vulnerable: <= 3.4.0-1+deb8u2<br />Fixed: 3.4.0-1+deb8u3 | 3.7.14-3.7.14.2 | |
| <a name="2555528"></a> [2555528](#2555528) <a name="2555528"></a> <br />CM-32750 | In an EVPN Active/Active configuration, when one of the peers reboots and begins to refresh IP neighbor entries shared by the MLAG peer, some of these ARP messages might be dropped by the MLAG peer's ARP policer.<br />To work around this issue, increase the burst value of the ARP policers to 200 or higher. | 3.7.14-4.2.1 | 4.3.0|
| <a name="2555508"></a> [2555508](#2555508) <a name="2555508"></a> <br />CM-32734 | CVE-2018-0734: A minor timing side channel attack was found in the OpenSSL DSA<br />signature algorithm. The fix for that introduced a more severe regression that could also be exploited as a timing side channel attack. This update fixes both the original problem and the subsequent issue.<br />CVE-2020-1971: A flaw in the GENERAL_NAME_cmp() function could cause a NULL dereference, resulting in denial of service.<br />Vulnerable: <= 1.0.1t-1+deb8u12<br />Fixed: 1.0.1t-1+deb8u13 | 3.7.14 | 3.7.14.2|
| <a name="2555494"></a> [2555494](#2555494) <a name="2555494"></a> <br />CM-32728 | On Broadcom switches, when WARN level <code>switchd</code> log messages are generated, <code>switchd</code> might crash resulting in a core file generated on the system. | 3.7.14 | 3.7.14.2, 4.3.0|
| <a name="2555435"></a> [2555435](#2555435) <a name="2555435"></a> <br />CM-32689 | CVE-2018-19139: Fix memory leaks by registering jpc_unk_destroyparms.<br />CVE-2020-27828: Avoid maxrlvls more than upper bound to cause heap-buffer-overflow.<br />CVE-2018-19543 and CVE-2017-9782: There is a heap-based buffer over-read of size 8 in the function jp2_decode in libjasper/jp2/jp2_dec.c.<br />Vulnerable: <= 1.900.1-debian1-2.4+deb8u6<br />Fixed: 1.900.1-debian1-2.4+deb8u7 | 3.7.14-3.7.14.2 | |
| <a name="2555428"></a> [2555428](#2555428) <a name="2555428"></a> <br />CM-32683 | When you change the SVI <code>vlan-id</code> value in the <code>/etc/network/interfaces</code> file, then run <code>ifreload -a</code>, the 802.1Q ID for the SVI in the kernel does not change.<br />This operation is not supported in the kernel without recreating the SVI. To apply the change, run <code>ifdown</code>, then <code>ifup</code> for the SVI to recreate the interface. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2555401"></a> [2555401](#2555401) <a name="2555401"></a> <br />CM-32661 | On the Edgecore AS7312 switch, eth0 and swp use the same MAC address. | 3.7.14-4.2.1 | 4.3.0|
| <a name="2555315"></a> [2555315](#2555315) <a name="2555315"></a> <br />CM-32609 | CVE-2020-25709, CVE-2020-25710: Vulnerabilities in the certificate list syntax verification and in the handling of CSN normalization were discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of these flaws to cause a denial of service (slapd daemon crash) via specially crafted packets.<br />Vulnerable: <= 2.4.40+dfsg-1+deb8u7<br />Fixed: 2.4.40+dfsg-1+deb8u8 | 3.7.14 | 3.7.14.2|
| <a name="2555278"></a> [2555278](#2555278) <a name="2555278"></a> <br />CM-32597 | When you change the anycast address for the MLAG pair (clagd-vxlan-anycast-ip), high peak traffic occurs on the peer link interface of all MLAG switches. | 3.7.13-3.7.14 | 4.0.0-4.3.0|
| <a name="2555205"></a> [2555205](#2555205) <a name="2555205"></a> <br />CM-32545 | If the FRR and MSTP processes go down, an SNMP TRAP is not generated even with the following configuration in the <code>/etc/snmp/snmpd.conf</code> file. <br /><pre><br />proc watchfrr<br />proc mstpd<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRRis down!!!” PrErrorFlag.5 != 0<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRR is up!!!” PrErrorFlag.5 = 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is down!!!!" prErrorFlag.3 != 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is up!!!!" prErrorFlag.3 = 0<br /></pre><br /> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2555196"></a> [2555196](#2555196) <a name="2555196"></a> <br />CM-32537 | CVE-2018-19787, CVE-2020-27783: The clean_html() function of lxml, a Python library for HTML and XML processing, performed insufficient sanitisation for embedded Javascript code. This could lead to cross-site scripting or possibly the execution of arbitrary code.<br />Vulnerable: <= 3.4.0-1+deb8u1<br />Fixed: 3.4.0-1+deb8u2 | 3.7.14-3.7.14.2 | |
| <a name="2555178"></a> [2555178](#2555178) <a name="2555178"></a> <br />CM-32529 | On Mellanox switches, the ASIC temperature sensor reading reports zeros. As a result, the fan speed is higher than normal. <br />You can see the temperature reading in the output of the <code>sensors</code> command. | 3.7.14 | 3.7.14.2|
| <a name="2555148"></a> [2555148](#2555148) <a name="2555148"></a> <br />CM-32516 | When using NCLU to add new BGP neighbors to existing configurations, the existence of address-family statements are ignored and the neighbors are added at the end of these lines. This might cause a problem if you try to activate these new neighbors in any of the existing address-family configurations.<br />To work around this issue, configure the new BGP neighbors with vtysh. | 3.7.14-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2555147"></a> [2555147](#2555147) <a name="2555147"></a> <br />CM-32515 | Some issues have been found in qemu, a fast processor emulator.<br />CVE-2020-25085 CVE-2020-25624 CVE-2020-25625 CVE-2020-25723 CVE-2020-27617: All issues are related to assertion failures, out-of-bounds access failures or bad handling of return codes.<br />Vulnerable: <= 2.1+dfsg-12+deb8u17<br />Fixed: 2.1+dfsg-12+deb8u18 | 3.7.14-3.7.14.2 | |
| <a name="2554992"></a> [2554992](#2554992) <a name="2554992"></a> <br />CM-32420 | When running traditional mode bridges at scale (for example, when you have more than 200 bridges and a large number of MAC addresses), MLAG bonds flap intermittently from dual to single connected, then back to dual connected, which causes a layer 2 loop and STP state changes.<br />To work around this issue, either shut down one side of the MLAG bond or prune out VLANS over the bond. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2554785"></a> [2554785](#2554785) <a name="2554785"></a> <br />CM-32275 | After you reboot a Broadcom switch, <code>switchd</code> might fail to restart and you see logs in <code>switchd.log</code> similar to the following:<br /><pre><br />...<br />Nov 12 12:20:05.063876 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.064310 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 0:system_init:<br />Nov 12 12:20:05.064428 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 system_init: Misc init failed: Operation timed out<br />Nov 12 12:20:05.064464 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.091995 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 LED: Loading 256 bytes into LED program memory<br />Nov 12 12:20:05.092029 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099547 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 PORT: Error: bcm ports not initialized<br />Nov 12 12:20:05.099579 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099646 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /var/lib/cumulus/rc.datapath_0: line 81 (error code -1): script terminated<br />Nov 12 12:20:05.099667 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099775 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /etc/bcm.d/rc.soc: line 70 (error code -1): script terminated<br />Nov 12 12:20:05.099798 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099871 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 ERROR loading rc script on unit 0<br />Nov 12 12:20:05.099892 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099943 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:299 CRIT loading of rc script failed, aborting!<br /></pre> | 3.7.11-4.2.1 | 4.3.0|
| <a name="2554719"></a> [2554719](#2554719) <a name="2554719"></a> <br />CM-32225 | A slow memory leak is observed (1% per 14 hours) in kmalloc-256.<br />To work around this issue, reboot the switch. | 3.7.12-3.7.14.2 | |
| <a name="2554709"></a> [2554709](#2554709) <a name="2554709"></a> <br />CM-32217 | The IP address specified in the <code>ip pim use-source</code> command configured on the loopback interface should be inherited by unnumbered interfaces during their Primary IP address selection process.  If <code>ip pim use-source</code> is configured on the loopback after an unnumbered interface has already selected their Primary IP address, the unnumbered interface does not update its Primary IP address to be the new use-source value until after there is a netlink update for that interface.<br />To work around this issue, configure <code>ip pim use-source</code> on each unnumbered interface directly or ensure <code>ip pim use-source</code> is applied to the loopback before other unnumbered interfaces are enabled for PIM. | 3.7.13-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2554617"></a> [2554617](#2554617) <a name="2554617"></a> <br />CM-32169 | OpenSSH is vulnerable to CVE-2020-14145, as described in https://www.fzi.de/fileadmin/user_upload/2020-06-26-FSA-2020-2.pdf.  <br />This is an information leak in algorithm negotiation that can allow man-in-the-middle attacks on initial connection attempts without a previously stored server host key on the client. If desired, mitigation using UpdateHostKeys and HostKeyAlgorithms is also given in that paper. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2554588"></a> [2554588](#2554588) <a name="2554588"></a> <br />CM-32149 | If you try reconfigure a DHCP server after you delete the switch configuration with the <code>net del all</code> command, the <code>dhcpd</code> service fails because a duplicate process is running.<br />To work around this issue, edit the <code>/usr/lib/python2.7/dist-packages/nclu/plugins/dhcp.py</code> file to change:<br /><pre><br />DHCPD_PID="-pf {0}" <br /></pre><br />to:<br /><pre><br />DHCPD_PID="-pf {1}"<br /></pre> | 3.7.13-4.2.1 | 4.3.0|
| <a name="2554369"></a> [2554369](#2554369) <a name="2554369"></a> <br />CM-32006 | Certain Dell S4048-ON switches show an incorrect vendor name and hang when you issue the <code>reboot</code> command.  | 3.7.12-4.2.1 | 4.3.0|
| <a name="2554329"></a> [2554329](#2554329) <a name="2554329"></a> <br />CM-31978 | On the Dell N3248PXE switch, fixed RJ45 interfaces with PoE neighbors can end up in _Paused_ mode after a <code>switchd</code> restart, which blocks traffic on that interface.  | 3.7.12-3.7.14.2 | |
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553748"></a> [2553748](#2553748) <a name="2553748"></a> <br />CM-31627 | On switches with the Spectrum ASIC, the IPv6 default route is present in the kernel but missing in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2553677"></a> [2553677](#2553677) <a name="2553677"></a> <br />CM-31605 | When you configure an SNMPv3 user with the <code>net-snmp-config</code> configuration command from the <code>libsnmp-dev</code> package, you get an error message similar to the one below:<br /><pre><br />cumulus&#64;switch:mgmt-vrf:~$ sudo net-snmp-config --create-snmpv3-user -a shaauthpass -x aesprivpass -A SHA -X AES userSHAwithAES<br />adding the following line to /var/lib/snmp/snmpd.conf:           <br />   createUser userSHAwithAES SHA "shaauthpass" AES "aesprivpass"       <br />adding the following line to /snmp/snmpd.conf:                           <br />   rwuser userSHAwithAES                                           <br />touch: cannot touch ‘/snmp/snmpd.conf’: No such file or directory<br />/usr/bin/net-snmp-create-v3-user: 144: /usr/bin/net-snmp-create-v3-user: cannot create /snmp/snmpd.conf: Directory nonexistent<br /></pre><br />To work around this issue, use the NCLU command to configure SNMPv3 user parameters; for example:<br /><pre><br />cumulus&#64;switch:mgmt-vrf:~$ net add snmp-server username user999 auth-md5 user999password encrypt-des user999encryption<br /></pre><br />Alternatively, directly edit the <code>/etc/snmp/snmpd.conf</code> file as described in the documentation. | 3.7.13-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553219"></a> [2553219](#2553219) <a name="2553219"></a> <br />CM-31407 | You cannot configure SNMPv3 trap-destinations in non-default VRFs with an authentication username that contains fewer than eight characters. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2553116"></a> [2553116](#2553116) <a name="2553116"></a> <br />CM-31357 | When you manually set the link speed or duplex mode with ethtool to an unsupported value, then run a TDR check against the interface, you encounter a <code>switchd</code> service heartbeat failure.<br />To work around this issue, reboot the switch to clear the condition. Avoid setting the interface speed or duplex mode directly with ethtool. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553063"></a> [2553063](#2553063) <a name="2553063"></a> <br />CM-31327 | After you manually edit the <code>/etc/resolv.conf</code> file to change or remove a VRF for a given DNS server, <code>ifreload</code> does not remove IP rules created for DNS servers in the VRF. <br />To work around this issue, run the <code>net add/del dns nameserver vrf <name></code> command to force the DNS configuration. | 3.7.13-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2553050"></a> [2553050](#2553050) <a name="2553050"></a> <br />CM-31322 | SNMP status might incorrectly reflect that a BGP neighbor is down due to an issue between <code>bgpd</code> and SNMP AgentX when the IP-FORWARD-MIB is also polled.<br />To work around this issue, avoid polling IP-FORWARD-MIB objects. | 3.7.12-3.7.14.2 | |
| <a name="2553015"></a> [2553015](#2553015) <a name="2553015"></a> <br />CM-31300 | If a neighbour contains a special character in PortID for LLDP, the <code>net show interface</code> command does not display the LLDP information or the command might fail. | 3.7.10-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2552939"></a> [2552939](#2552939) <a name="2552939"></a> <br />CM-31263 | RX_DRP on a bond interface increases without any data traffic while the slave port does not increase. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552870"></a> [2552870](#2552870) <a name="2552870"></a> <br />CM-31232 | On the  Dell N3048EP switch, the module information from SFP ports is not displayed in the <code>l1-show</code> command.<br />To work around this issue, use the <code>ethtool -m <interface></code> command. | 3.7.13-3.7.14.2 | |
| <a name="2552869"></a> [2552869](#2552869) <a name="2552869"></a> <br />CM-31231 | On the Dell N3048EP switch, the module information from SFP ports is not displayed in the <code>l1-show</code> command.<br />To work around this issue, use the <code>ethtool -m <interface></code> command. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2552742"></a> [2552742](#2552742) <a name="2552742"></a> <br />CM-31150 | On the Mellanox SN2410 switch, you see <code>switchd</code> core and <code>GBIN_MALLOC</code> errors.<br />To work around this issue, restart <code>switchd</code>. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552739"></a> [2552739](#2552739) <a name="2552739"></a> <br />CM-31148 | Counters for IPROUTER rules do not increase when traffic is forwarded to the CPU because there is no IP neighbor. | 3.7.2-3.7.14.2 | |
| <a name="2552632"></a> [2552632](#2552632) <a name="2552632"></a> <br />CM-31073 | When you set the <code>sysctl</code> settings <code>net.ipv6.conf.all.accept_ra_defrtr</code> (to prevent acceptance of IPv6 default route advertisements) and <code>net.ipv6.conf.default.accept_ra_defrtr</code> (set for newly created interfaces), if you create a new virtual interface, any pre-existing interface does not start accepting IPv6 default route avertisements again.<br />To work around this issue, when you create a new virtual interface, set <code>net.ipv6.conf.<interface>.accept_ra_defrtr</code> to 0 for all interfaces and run <code>sysctl -p --system</code>. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552610"></a> [2552610](#2552610) <a name="2552610"></a> <br />CM-31057 | The following vulnerability has been announced:<br />CVE-2019-11360: A buffer overflow in <code>iptables-restore</code> in netfilter iptables 1.8.2 allows an attacker to (at least) crash the program or potentially gain code execution via a specially crafted iptables-save file. This is related to <code>add_param_to_argv</code> in <code>xshared.c</code>. | 3.7.13-4.2.0 | 4.2.1-4.3.0|
| <a name="2552294"></a> [2552294](#2552294) <a name="2552294"></a> <br />CM-30879 | NCLU restarts FRR when removing a BGP VRF IPv4 aggregate-address command.<br />  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552266"></a> [2552266](#2552266) <a name="2552266"></a> <br />CM-30863 | OpenSSH scp is vulnerable to CVE-2020-15778, where clients that have authorized access to the SSH server can execute commands on the server by copying maliciously named files.<br />The two scenarios where an exploit may be useful to an attacker:<br />-The user is authorized to <code>scp</code> but not <code>ssh</code> (based on the <code>command</code> option in the <code>authorized_keys</code> file), so this vulnerability can allow executing a remote command on the target computer when not authorized to do so.<br />-An attacker plants a maliciously named file in a directory tree that someone later uses <code>scp -r</code> to copy over to the target computer.<br />Be aware that restricting users to <code>scp</code> by using the <code>command</code> option in the <code>authorized_keys</code> file is not effective in preventing those users from executing arbitrary commands on the server.<br />If you want to use <code>scp -r</code> to copy directory trees, avoid copying directory trees to which attackers may have added maliciously-named files. Archiving the directory tree with <code>tar</code>, <code>zip</code>, or a similar program, then copying the archive over to be extracted on the server avoids having to use <code>scp -r</code> altogether. In addition, OpenSSH provides <code>sftp</code>, which you can use instead of <code>scp</code> to copy files.<br />To disable scp completely, use <code>/bin/chmod 0 /usr/bin/scp</code> . | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552214"></a> [2552214](#2552214) <a name="2552214"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14, 4.1.1-4.3.0 | 3.7.14.2|
| <a name="2552213"></a> [2552213](#2552213) <a name="2552213"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2551912"></a> [2551912](#2551912) <a name="2551912"></a> <br />CM-30580 | <code>ifupdown2</code> does not account for link status or link down configuration when running <code>dhclient</code>. For example, <code>ifupdown2</code> ignores <code>link-down yes</code> during <code>ifup/ifreload</code> and runs the DHCP module if <code>inet dhcp</code> is configured on the interface. <code>ifupdown2</code> also runs the DHCP module even when the physical link configured for DHCP is down. | 3.7.12-4.2.0 | 4.2.1-4.3.0|
| <a name="2551578"></a> [2551578](#2551578) <a name="2551578"></a> <br />CM-30422 | When you configure a bridge in the <code>/etc/network/interfaces</code> file, then try to reconfigure the bridge to be a VRF interface with the same name, <code>ifreload</code>/<code>ifup</code> commands fail with an <code>invalid table id</code> or <code>unable to get vrf table id</code> error. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2551565"></a> [2551565](#2551565) <a name="2551565"></a> <br />CM-30414 | If you toggle VRRP priority values between VRRP routers, then run a <code>switchd</code> restart, a few IPv6 VRRP instances might not converge. As a result, both the VRRP routers act as _master_ routers for the impacted IPv6 VRRP instances. IPv4 VRRP instances are not affected.<br />To work around this issue, remove, then add the VRRP configuration with NCLU commands or vtysh in FRR.<br /> | 3.7.13-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2551305"></a> [2551305](#2551305) <a name="2551305"></a> <br />CM-30296 | The <code>net show configuration</code> command provides the wrong <code>net add</code> command for ACL under the VLAN interface.<br /><br /> | 3.7.12-3.7.14.2, 4.1.0-4.3.0 | |
| <a name="2551288"></a> [2551288](#2551288) <a name="2551288"></a> <br />CM-30286 | When you remove BFD configuration by editing the <code>/etc/frr/frr.conf</code> file and restarting FRR, you see a traceback.<br />To work around this issue, either use NCLU or vtysh commands to remove the BFD configuration, or restart FRR with the new <code>/etc/frr/frr.conf</code> file. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2550974"></a> [2550974](#2550974) <a name="2550974"></a> <br />CM-30195 | On the Dell S3000 switch, after installing the Cumulus Linux 4.1.1 disk image without a license, the switch sends a link beat if a remote host port is configured. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550942"></a> [2550942](#2550942) <a name="2550942"></a> <br />CM-30178 | NCLU tab completion for <code>net show</code> displays the text <code>add help text</code> instead of <code>system Information</code> for the system option. | 3.7.11-4.2.0 | 4.2.1-4.3.0|
| <a name="2550796"></a> [2550796](#2550796) <a name="2550796"></a> <br />CM-30103 | On a Broadcom switch with the Trident2+ ASIC, ACL rules for VLANs are not applied after a reboot and the counters remain at zero.<br />To work around this issue, either do not set <code>acl.non_atomic_update_mode = TRUE</code> in the <code>/etc/cumulus/switchd.conf</code> file or run the <code>cl-acltool -i</code> command after the reboot to install the  ACLs. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2550793"></a> [2550793](#2550793) <a name="2550793"></a> <br />CM-30101 | The NCLU <code>net show bridge spanning-tree</code> command displays the aging timer incorrectly.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550601"></a> [2550601](#2550601) <a name="2550601"></a> <br />CM-29978 | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | 4.2.1-4.3.0, 4.3.0|
| <a name="2550466"></a> [2550466](#2550466) <a name="2550466"></a> <br />CM-29890 | Multiple paths to identical EVPN prefixes are either not displayed or not accepted into the l2vpn evpn table if they are received from a different AS. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550444"></a> [2550444](#2550444) <a name="2550444"></a> <br />CM-29872 | Tab completion for the <code>net show rollback description</code> command returns information about a snapshot instead of context help.<br />To work around this issue, run the <code>net show commit history</code> command to find descriptions instead of the <code>net show rollback description</code> command. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550443"></a> [2550443](#2550443) <a name="2550443"></a> <br />CM-29871 | The <code>net show rollback description <string></code> command returns an error even if the string matches a commit description.<br />To work around this issue, look for your string in the output of the <code>net show commit history</code> command (or grep for it there) instead. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550276"></a> [2550276](#2550276) <a name="2550276"></a> <br />CM-29779 | In LLDP, the <code>snmp</code> subagent loses all subsequent <code>lldpRemSysName</code> (1.0.8802.1.1.2.1.4.1.1.9) entries after an entry with a missing SysName is added.<br />All the information from <code>lldpctl</code> is correct. Only the entries after the entry that is missing a SysName in <code>lldpRemSysName</code> disappear from the <code>snmp</code> subagent. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2550243"></a> [2550243](#2550243) <a name="2550243"></a> <br />CM-29759 | When you use <code>nginx</code> and <code>restserver</code> in management VRF to provide a REST API for the switch, <code>nginx</code> starts but <code>restserver</code> fails to start.<br />To work around this issue, comment out the <code>Requires=</code> line in the <code>/lib/systemd/system/restserver.service</code>. For example:<br /><pre><br />#Requires=nginx.service restserver.socket<br /></pre> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550196"></a> [2550196](#2550196) <a name="2550196"></a> <br />CM-29740 | The <code>exim4</code> package available for optional installation on Cumulus Linux 3.x has the following vulnerability:<br />DLA-2213-1 / CVE-2020-12783: Exim through 4.93 has an out-of-bounds read in the SPA authenticator that could result in SPA/NTLM authentication bypass in auths/spa.c and auths/auth-spa.c.  The spa authentication driver is not enabled by default.<br />Vulnerable: <= 4.84.2-2+deb8u6<br />Fixed: 4.84.2-2+deb8u7 | 3.7.12-3.7.14.2 | |
| <a name="2550056"></a> [2550056](#2550056) <a name="2550056"></a> <br />CM-29652 | The ACCTON-DIAG option under the Cumulus Linux GRUB menu does not work. When you select this option, you see the following error:<br /><pre><br />error: invalid signature.<br />Press any key to continue...<br /></pre> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549925"></a> [2549925](#2549925) <a name="2549925"></a> <br />CM-29594 | When you run an Ansible script to replace the <code>/etc/network/interfaces</code> file, then run the <code>ifreload -a</code> command, you see errors similar to the following:<br /><pre><br />error: swp1s1.2: netlink: cannot set link swp1s1.2 up: operation failed with 'Network is down' (100)<br />warning: cmd '/bin/ip addr del 10.0.0.1/24 dev eth0' failed: returned 2 (RTNETLINK answers: Cannot assign requested address<br /></pre><br />To work around this issue,  run the <code>ifreload -a</code> command a second time. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549872"></a> [2549872](#2549872) <a name="2549872"></a> <br />CM-29562 | If you have an SVI with multiple VRR IP addresses and try to delete one of the VRR configurations, <code>net commit</code> or <code>ifreload -a</code> returns an error. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549859"></a> [2549859](#2549859) <a name="2549859"></a> <br />CM-29556 | The following vulnerability has been announced that affects ntp:<br />CVE-2020-11868: ntpd in ntp before 4.2.8p14 and 4.3.x before 4.3.100 allows an off-path attacker to block unauthenticated synchronization via a server mode packet with a spoofed source IP address, because transmissions are rescheduled even when a packet lacks a valid origin timestamp.<br />This affects: ntp-4.2.8p12 (possibly earlier) and ntp-4.2.8p13<br />The fix for https://bugs.ntp.org/3445 introduced a bug whereby a system that is running ntp-4.2.8p12 or p13 that only has one unauthenticated time source can be attacked in a way that causes the victim's next poll to its source to be delayed, for as long as the attack is maintained.<br />http://support.ntp.org/bin/view/Main/NtpBug3592 gives the following mitigations if it is not possible to upgrade to a version with the fix:<br />* Use authentication with symmetric peers.<br />* Have enough sources of time.  The default NTP configuration in Cumulus Linux has four time sources.<br /><br />Fixed: 4.2.8p12+dfsg-4+cl4u13 | 3.7.12-4.1.1 | 4.2.0-4.3.0|
| <a name="2549838"></a> [2549838](#2549838) <a name="2549838"></a> <br />CM-29546 | In vtysh, if you configure, then remove a layer 3 VNI for a VRF, the VNI is removed from zebra even if the VNI interface still exists in the kernel.<br />If you configure a layer 2 VNI as a layer 3 VNI by mistake, removing the layer 3 VNI binding removes it from zebra but EVPN-learned MACs and neighbors are not installed into the kernel.<br />To work around this issue, delete, then re-add the missing VNI. For example:<br /><pre><br />cumulus&#64;switch:~$ sudo ifdown vni10100<br />cumulus&#64;switch:~$ sudo ifup vni10100<br /></pre><br />If you flap the link with the <code>ip link set vni10100 down; ip link set vni10100 up</code> commands, zebra does not re-add the VNI. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2549782"></a> [2549782](#2549782) <a name="2549782"></a> <br />CM-29519 | The JSON format output of the <code>net show bgp l2vpn evpn summary</code> command shows the incorrect neighbour state.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549731"></a> [2549731](#2549731) <a name="2549731"></a> <br />CM-29492 | When you create SPAN or ERSPAN rules in ebtables, the action fails to install if it is not in lowercase. Make sure that the SPAN or ERSPAN action is all lowercase; for example:<br /><pre><br />&#91;ebtables&#93;<br />-A FORWARD --in-interface swp10 -j span --dport swp1<br /></pre> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549472"></a> [2549472](#2549472) <a name="2549472"></a> <br />CM-29367 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2549371"></a> [2549371](#2549371) <a name="2549371"></a> <br />CM-29309 | When Optimized Multicast Flooding (OMF) is enabled with the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/switchd.conf</code> file, the switch continues to flood IPv6 multicast traffic to all slave ports when there is no MLD join receive. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549226"></a> [2549226](#2549226) <a name="2549226"></a> <br />CM-29259 | You might see the following <code>gport</code> error messages in <code>switchd.log</code>:<br /><pre><br />2020-04-10T19:50:01.011224+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x800007a find failed<br />2020-04-10T19:50:01.011631+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x8000009 find failed<br /></pre><br />These messages are harmless and can be ignored. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548962"></a> [2548962](#2548962) <a name="2548962"></a> <br />CM-29165 | With FRR or OSPF, you might see an inconsistent link-state advertisement. For example, when you configure the OSPF default originate route as metric-type 1 with a specific metric, Cumulus Linux shows the default originate route as an external metric-type 2 route with the default metric in the database. This issue typically occurs when both IPv4 and IPv6 default routes exist in the routing table. | 3.7.12-4.1.1 | 4.2.0-4.3.0|
| <a name="2548930"></a> [2548930](#2548930) <a name="2548930"></a> <br />CM-29148 | On MLX switches that contain an OSPF IP unnumbered neighborship with a high scale of prefixes being learned, a link flap might cause the neighbor entry to not be programmed in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2548746"></a> [2548746](#2548746) <a name="2548746"></a> <br />CM-29068 | On the Broadcom switch with the Trident3 ASIC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548672"></a> [2548672](#2548672) <a name="2548672"></a> <br />CM-29043 | When a multipath route that contains an EVPN path exists together with an IPv4 BGP path in the VRF, the RMAC to VTEP binding is incorrect. This invalid entry occurs because Cumulus Linux treats IPv4 routes received over the eBGP IPv4 peering incorrectly in the VRF.<br />To work around this issue, remove the unnecessary eBGP IPv4 peering. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548657"></a> [2548657](#2548657) <a name="2548657"></a> <br />CM-29035 | When you upgrade Cumulus Linux on the EdgeCore AS7726-32X or AS7326-56X switch, you might see firmware errors similar to the following:<br /><pre><br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso5.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3.bin for module tg3<br /></pre><br />You can safely ignore these error messages. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548490"></a> [2548490](#2548490) <a name="2548490"></a> <br />CM-28944 | A change in a route map prefix list that should remove a route might not be reflected in the <code>ospf6</code> database or in peers, and the route might not be deleted. <br />To work around this issue, reenter the <code>redistribute <connected\|static> route-map <route-map-name></code> statement in the configuration. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548485"></a> [2548485](#2548485) <a name="2548485"></a> <br />CM-28940 | If you configure <code>aggregate-address <address> summary-only</code> before a component of the same aggregate is injected into the BGP table with the <code>network</code> or <code>redistribute</code> command, when you remove the <code>aggregate-address</code> configuration, the component stays suppressed; it is not advertised to peers. For example:<br />Existing configuration:<br /><pre><br />router bgp 1<br /> address-family ipv4 unicast<br />  aggregate-address 50.0.0.0/8 summary-only<br /> exit-address-family<br /></pre><br />If you add <code>network 50.0.0.1/32</code>, you see the following (expected) BGP table entries:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />*> 50.0.0.0         0.0.0.0                            32768 i<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />Removing <code>aggregate-address 50.0.0.0/8 summary-only</code> at this point results in the following (unexpected) BGP table entry:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />To work around this issue, remove, then re-add the component prefix routes. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548315"></a> [2548315](#2548315) <a name="2548315"></a> <br />CM-28816 | The following security advisory has been announced for bash: <br />CVE-2019-18276 Qualys scan QID 372268 setuid vulnerability<br />When bash or bash scripts are run setuid, bash is supposed to drop privileges, but does so incorrectly, so that an attacker with command access to the shell can use <code>enable -f</code> for runtime loading of a new builtin that calls <code>setuid()</code> to regain dropped privileges.<br />To work around this issue, do not make bash or bash scripts <code>setuid</code>. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548117"></a> [2548117](#2548117) <a name="2548117"></a> <br />CM-28659 | In OVSDB traditional bridge mode, adding or removing a VLAN binding causes a traffic forwarding outage for around 20 seconds or more on adjacent VLAN bindings. Cumulus Linux does not support _traditional_ bridge mode with VMware NSX. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548024"></a> [2548024](#2548024) <a name="2548024"></a> <br />CM-28596 | On the Dell Z9100 switch, 100G-SR4 modules might not link up reliably in certain ports. <br />swp1, 2, 3, 9, 10, 23, 24, 30, 31, and 32 might be affected<br />To work around this issue, move 100G SR4 modules to one of the ports not affected by this issue. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547942"></a> [2547942](#2547942) <a name="2547942"></a> <br />CM-28533 | On the Lenovo NE0152T switch, one power supply (PSU2) always show as ABSENT in smonctl. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547839"></a> [2547839](#2547839) <a name="2547839"></a> <br />CM-28465 | When you try to configure <code>link-down</code> on a parent interface of a subinterface configured in a VRF, you encounter an error. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547782"></a> [2547782](#2547782) <a name="2547782"></a> <br />CM-28441 | If a LLDP neighbor advertises a <code>PortDescr</code> that contains commas, <code>ptmctl -d</code> splits the string on the commas and misplaces its components in other columns. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547706"></a> [2547706](#2547706) <a name="2547706"></a> <br />CM-28397 | When you configure ganged ports in the <code>ports.conf</code> file, the change does not take effect after you restart <code>switchd</code>. <br />To work around this issue, reboot the switch. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2547659"></a> [2547659](#2547659) <a name="2547659"></a> <br />CM-28372 | On the EdgeCore AS7326-56X switch, the default fan speed, which is defined in the thermal specification, results in excessive fan noise. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547573"></a> [2547573](#2547573) <a name="2547573"></a> <br />CM-28322 | On Tomahawk switches, when the <code>vxlan_tnl_arp_punt_disable</code> option is set to FALSE, ARP packets are not forwarded to the CPU. | 3.7.9-4.0.1 | 4.1.0-4.3.0|
| <a name="2547443"></a> [2547443](#2547443) <a name="2547443"></a> <br />CM-28248 | On the Dell N3248PXE-ON switch, 25G SFP ports do not work in 10G mode. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547381"></a> [2547381](#2547381) <a name="2547381"></a> <br />CM-28212 | The <code>hsflowd</code> service sends an undefined header protocol 0 in the sampled flow sample to the collector, which is not recognized by the sFlow tool. You see errors similar to the following:<br /><pre><br />Dec 20 08:43:27 netflow-nms sfcapd&#91;3991&#93;: SFLOW: readFlowSample_header() undefined headerProtocol = 0<br /></pre><br /> | 3.7.11-3.7.14 | 4.0.0-4.3.0|
| <a name="2547123"></a> [2547123](#2547123) <a name="2547123"></a> <br />CM-28078 | On the Broadcom switch with the Trident3 ASC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547120"></a> [2547120](#2547120) <a name="2547120"></a> <br />CM-28076 | After you hot swap a PSU, the <code>decode-syseeprom -t psuX</code> command shows the old PSU information (such as the serial number), until you run the <code>decode-syseeprom --init</code> command. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547100"></a> [2547100](#2547100) <a name="2547100"></a> <br />CM-28061 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546992"></a> [2546992](#2546992) <a name="2546992"></a> <br />CM-28004 | The wireshark packages (libwireshark5, libwireshark-data, wireshark, wireshark-common) available for optional installation on Cumulus Linux 3 are vulnerable to CVE-2018-12086: Buffer overflow in OPC UA applications allows remote attackers to trigger a stack overflow with carefully structured requests.  More information at https://www.wireshark.org/security/wnpa-sec-2018-50.html and https://security-tracker.debian.org/tracker/CVE-2018-12086 . | 3.7.11-3.7.14.2 | |
| <a name="2546991"></a> [2546991](#2546991) <a name="2546991"></a> <br />CM-28003 | The FRR service does not provide a way for automation to know if the configuration applied properly.<br />To work around this issue, execute the <code>vtysh -f <file></code> command in the automation file before starting the FRR service to validate the functional configuration and return an error code. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546989"></a> [2546989](#2546989) <a name="2546989"></a> <br />CM-28001 | The libxen packages are not installed on the switch by default, but are available in the repository for optional installation.<br /><br />Customers who optionally install the libxen packages should be aware of the following security advisory.<br /><br />Debian Security Advisory DSA-4602-1<br />CVE-2019-17349 CVE-2019-17350 CVE-2019-18420 CVE-2019-18421<br />CVE-2019-18422 CVE-2019-18423 CVE-2019-18424 CVE-2019-18425<br />CVE-2019-19577 CVE-2019-19578 CVE-2019-19579 CVE-2019-19580<br />CVE-2019-19581 CVE-2019-19582 CVE-2019-19583 CVE-2018-12207<br />CVE-2018-12126 CVE-2018-12127 CVE-2018-12130 CVE-2019-11091<br />CVE-2019-11135 CVE-2019-17348 CVE-2019-17347 CVE-2019-17346<br />CVE-2019-17345 CVE-2019-17344 CVE-2019-17343 CVE-2019-17342<br />CVE-2019-17341 CVE-2019-17340<br /><br />Multiple vulnerabilities have been discovered in the Xen hypervisor, which<br />could result in denial of service, guest-to-host privilege escalation or<br />information leaks.<br /><br />For more information, see https://security-tracker.debian.org/tracker/xen | 3.7.11-3.7.14.2 | |
| <a name="2546895"></a> [2546895](#2546895) <a name="2546895"></a> <br />CM-27957 | If you have configured a higher number of ports and VLANs (ports x VLANs) or the switch is a lower-powered (CPU) platform, the <code>switchd</code> service might fail to send a <code>systemd keepalive</code> within the watchdog timeout value (2 minutes by default) and you see an error similar to the following:<br /><pre><br />bq. systemd&#91;1&#93;: switchd.service watchdog timeout (limit 2min)!<br /></pre><br />To workaround this issue, either reduce the number of configured interfaces and, or VLANs, or increase the <code>systemd</code> timeout for <code>switchd.service</code>.<br />To increase the <code>systemd</code> timeout:<br /># Edit the <code>/etc/systemd/system/switchd.service.d/override.conf</code> file and increase the <code>WatchdogSec</code> parameter.<br /># Restart the <code>switchd</code> service with the <code>sudo systemctl restart switchd.service</code> command.<br /><code>systemd</code> will attempt to restart the <code>switchd</code> service automatically (after the watchdog timeout). If the restart fails multiple times in a short time period, run the <code>sudo systemctl reset-failed</code> command followed by the <code>sudo systemctl restart switchd</code> command.<br /> | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546848"></a> [2546848](#2546848) <a name="2546848"></a> <br />CM-27937 | Debian security advisory DSA-4213 for qemu lists a number of security vulnerabilities.<br />https://www.debian.org/security/2018/dsa-4213<br />One of the listed vulnerabilities is still present in the latest upstream version 2.1+dfsg-12+deb8u12 (the others have been fixed):<br />CVE-2017-15124 Daniel Berrange discovered that the integrated VNC server insufficiently restricted memory allocation, which could result in denial of service.<br />https://security-tracker.debian.org/tracker/CVE-2017-15124 | 3.7.11-3.7.14.2 | |
| <a name="2546542"></a> [2546542](#2546542) <a name="2546542"></a> <br />CM-27793 | A security vulnerability has been announced in the cyrus-sasl2 (libsasl2-2 and libsasl2-modules) package. The libraries are installed by default on Cumulus Linux.<br />CVE-2019-19906: Stephan Zeisberg reported an out-of-bounds write vulnerability in the _sasl_add_string() function in cyrus-sasl2, a library implementing the Simple Authentication and Security Layer. A remote attacker can take advantage of this issue to cause denial-of-service conditions for applications using the library.<br />Vulnerable: 2.1.27+dfsg-1<br />Fixed: 2.1.27+dfsg-1+deb10u1 | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2546385"></a> [2546385](#2546385) <a name="2546385"></a> <br />CM-27698 | SNMP ifLastChange reports link transitions when there are none. | 3.7.6-3.7.14.2 | |
| <a name="2546225"></a> [2546225](#2546225) <a name="2546225"></a> <br />CM-27627 | When you execute the following command on the Delta AG6248C switch, the switch reboots and then comes right back into Cumulus Linux without installing the new image. The install image is still in <code>/var/lib/cumulus/installer</code>, which causes issues with cl-support. <br /> <pre> <br /> sudo onie-install -fai http://<path to image> <br /> sudo reboot <br /> </pre> <br /> To work around this issue, use the <code>onie-select</code> command to access ONIE, and then use the <code>nos-install</code> command in ONIE to install a new binary image.  | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546203"></a> [2546203](#2546203) <a name="2546203"></a> <br />CM-27620 | When using QinQ with a traditional bridge, if you enable the LLDP dot1 TLV option, you see the following suboptimal behavior:<br />* Both the inner and outer VLAN information is sent as part of VLAN TLVs in the LLDP packet. <br />* If the outer VLAN ID is the same as the inner VLAN ID, only one VLAN TLV is sent with that VLAN ID in the LLDP packet. | 3.7.11-3.7.14.2 | |
| <a name="2546131"></a> [2546131](#2546131) <a name="2546131"></a> <br />CM-27581 | On the Delta AG-6248C PoE switch, when you run the <code>apt upgrade</code> command, the upgrade does not work. Cumulus Linux uses <code>uboot</code> directly instead of <code>grub</code> to boot the kernel. Uboot needs a special header to boot the kernel, which is not present. Without this header, when you use the <code>apt upgrade</code> command to upgrade Linux packages, <code>uboot</code> is unable to boot up the kernel. <br />To work around this issue, upgrade Cumulus Linux by installing the Cumulus Linux image. Run the <code>onie-select</code> command to go into ONIE, and then use the <code>nos-install</code> command in ONIE to install a new image.<br />This workaround only works when an out-of-band network is present. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546010"></a> [2546010](#2546010) <a name="2546010"></a> <br />CM-27530 | When <code>hal.bcm.per_vlan_router_mac_lookup</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file, inter-VLAN traffic is forwarded to the CPU when associated VNI interfaces exist. | 3.7.10-3.7.14.2 | |
| <a name="2545997"></a> [2545997](#2545997) <a name="2545997"></a> <br />CM-27522 | The NCLU command <code>net show interface</code> produces an error if bonds with no members exist.<br />To work around this issue, remove the empty Bond interfaces from the <code>/etc/network/interfaces</code> file and run <code>sudo ifreload -a</code>. | 3.7.10-3.7.14.2 | |
| <a name="2545566"></a> [2545566](#2545566) <a name="2545566"></a> <br />CM-27272 | The Dell Z9100-ON switch incorrectly reports many sensors as ABSENT. | 3.7.12-4.0.1 | 4.1.0-4.3.0|
| <a name="2545446"></a> [2545446](#2545446) <a name="2545446"></a> <br />CM-27192 | If you use NCLU commands to add a non-MLAG bond, then add an MLAG configuration, the <code>net commit</code> command fails. However, a subsequent <code>net commit</code> command succeeds. | 3.7.10-3.7.14.2 | |
| <a name="2545125"></a> [2545125](#2545125) <a name="2545125"></a> <br />CM-27018 | If you configure more than one VRR interface on an SVI interface, deleting one of the VRR addresses does not remove the interface/address.  | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544978"></a> [2544978](#2544978) <a name="2544978"></a> <br />CM-26921 | If you delete an undefined bond, then add a bond slave, the <code>net commit</code> command fails. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544968"></a> [2544968](#2544968) <a name="2544968"></a> <br />CM-26913 | FRR configuration commands for an SVI interface might have the <code>\n</code> misplaced in the output.  For example:<br /><pre><br />sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />should be:<br /><pre><br />sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />To work around this issue, configure the interface manually in the <code>/etc/frr/frr.conf</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544953"></a> [2544953](#2544953) <a name="2544953"></a> <br />CM-26905 | When you update the hostname of a switch with the NCLU <code>net add hostname <hostname></code> command, then run <code>net commit</code>, the <code>lldpd</code> service does not restart and other devices still see the old hostname.<br />To work around this issue, run the <code>sudo systemctl restart lldpd.service</code> command. | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544904"></a> [2544904](#2544904) <a name="2544904"></a> <br />CM-26875 | After you delete an IPv6 numbered BGP peer group neighbor, Cumulus Linux might continue to send route advertisements.<br />To work around this issue, restart FRR after removing the IPv6 numbered configuration. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544556"></a> [2544556](#2544556) <a name="2544556"></a> <br />CM-26655 | If you reconfigure an NTP server with NCLU using different trailing options after the IP address (such as <code>iburst</code>), an invalid configuration is added to the <code>/etc/ntp.conf</code> file. For example:<br /><pre><br />net add time ntp server 1.2.3.4 iburst<br />net commit<br />net add time ntp server 1.2.3.4<br />net commit<br /></pre><br />If you need to alter existing server configurations, first remove the server, commit, then re-add the server with any trailing options. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544463"></a> [2544463](#2544463) <a name="2544463"></a> <br />CM-26599 | Auto-negotiation does not work with the QSFP28 cables and a remote system operating at 10G. Attempting to enable auto-negotiation with <code>ethtool -s swp<#> autoneg on</code> returns <code>Operation not supported</code>.<br />To work around this issue, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544456"></a> [2544456](#2544456) <a name="2544456"></a> <br />CM-26595 | The NCLU <code>net show lldp</code> command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544235"></a> [2544235](#2544235) <a name="2544235"></a> <br />CM-26463 | The following CVEs affect the linux kernel package:<br />CVE-2019-14821 CVE-2019-14835 CVE-2019-15117 CVE-2019-15118 CVE-2019-15902<br />Several vulnerabilities have been discovered in the Linux kernel that<br />may lead to a privilege escalation, denial of service or information<br />leaks.<br />For the detailed security status of linux,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/linux | 3.7.10-3.7.14.2 | |
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544113"></a> [2544113](#2544113) <a name="2544113"></a> <br />CM-26412 | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address changing between the MLAG bond and the peer link.<br />To work around this issue, disable MAC learning on QinQ VLANs by adding <code>bridge-learning off</code> to the VLAN stanza in the <code>etc/network/interfaces</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543900"></a> [2543900](#2543900) <a name="2543900"></a> <br />CM-26288 | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543841"></a> [2543841](#2543841) <a name="2543841"></a> <br />CM-26256 | The <code>net show evpn vni detail json</code> command includes an extra empty dictionary at the end of the output. <br /> | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543800"></a> [2543800](#2543800) <a name="2543800"></a> <br />CM-26230 | When <code>local-tunnelip</code> is an SVI, the static VXLAN tunnel does not work; the next hop router receives the packet but drops it as it does not know where to forward the packet. The static VXLAN tunnel does works if <code>local-tunnelip</code> is a loopback or a physical layer 3 interface. <br /> | 3.7.8-3.7.14 | 4.0.0-4.3.0|
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | 4.3.0|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543627"></a> [2543627](#2543627) <a name="2543627"></a> <br />CM-26126 | Tomahawk 40G DACs cannot disable auto-negotiation. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543270"></a> [2543270](#2543270) <a name="2543270"></a> <br />CM-25923 | The default route injected through OSPF when you configure <code>default-information originate always</code> is unreliable and might age out unexpectedly.<br />To work around this issue, rely on a different source of default route other than injection with <code>default-information originate</code>. | 3.7.8-4.1.1 | 4.2.0-4.3.0|
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543058"></a> [2543058](#2543058) <a name="2543058"></a> <br />CM-25798 | The IP neighbor entry for a link-local next hop is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces.<br />To work around this issue, flap the peering to the peer router (which might be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543052"></a> [2543052](#2543052) <a name="2543052"></a> <br />CM-25796 | Received EVPN type-5 and type-2 MACIP routes are not installed in the kernel (and hardware) routing tables for the associated VRF, which causes traffic to be blackholed. The failure to install the default route causes complete reachability failure for the particular tenant on the affected racks. The routes that are not installed are seen as "inactive" in the routing subsystem (FRR) VRF routing table. This problem is rare and can occur only in EVPN configurations that have user-configured route targets (RTs) for tenant VRFs, and only following a restart of FRR.<br />To work around this issue, either restart the FRR service on the affected switch with the <code>sudo systemctl restart frr.service</code> command or bounce the layer 3 SVI for the affected VRF; for example:<br /><pre><br />ifdown vlan123 ; sleep 2 ; ifup vlan123<br /></pre><br />You can run the <code>net show vrf vni</code> command to print a mapping of VRF : L3-VNI : L3-SVI. | 3.7.5-3.7.14 | 4.0.0-4.3.0|
| <a name="2543044"></a> [2543044](#2543044) <a name="2543044"></a> <br />CM-25794 | Under certain conditions, EVPN next hops might not be removed when the contributing peer goes down or might not be populated when the BGP session to the contributing peer comes up.<br />You can prevent EVPN next hops from not being removed when the contributing peer goes down by specifying static MAC addresses on all layer 3 VNIs. There is no workaround for preventing EVPN next hops from not being populated when the BGP session to the contributing peer comes up. | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2542979"></a> [2542979](#2542979) <a name="2542979"></a> <br />CM-25766 | On the Dell-N3048EP-ON switch, when you run the <code>sudo -E apt upgrade</code> command, the upgrade does not work.  | 3.7.7-4.1.1 | 4.2.0-4.3.0|
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542310"></a> [2542310](#2542310) <a name="2542310"></a> <br />CM-25404 | <code>hsflow</code> disregards the setting for <code>agent.cidr</code> in the <code>/etc/hsflowd.conf</code> file and selects an IPv6 agent address. The source IP address of the hsflowd packet is IPv4, but the agent address in the <code>hsflow</code> payload shows IPv6. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541165"></a> [2541165](#2541165) <a name="2541165"></a> <br />CM-24878 | On the Dell N3048EP-ON switch, UPOE is supported only on ports 1 thru 12. (UPOE uses all four pairs of standard Ethernet cabling whereas PoE delivers power over two twisted pairs.) When you plug a UPOE device in a port higher than port 12, <code>poectl</code> reports that <code>four_pair_mode_enabled</code> is true. However, this configuration is not supported on the port so <code>poectl</code> should report that <code>four_pair_mode_enabled</code> is false. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540950"></a> [2540950](#2540950) <a name="2540950"></a> <br />CM-24751 | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switch, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status.<br />  | 3.7.3-4.1.1 | 4.2.0-4.3.0|
| <a name="2540885"></a> [2540885](#2540885) <a name="2540885"></a> <br />CM-24703 | The Dell N3048EP-ON switch does not support 1G Base-T modules in the SFP ports. | 3.7.7-3.7.14.2 | |
| <a name="2540863"></a> [2540863](#2540863) <a name="2540863"></a> <br />CM-24686 | On the EdgeCore AS5812-54X switch, the PSU2 Fan1 fluctuates between OK and LOW. When the fan speed is reported as LOW, the RPM is shown as a negative number. <br /> | 3.7.3-3.7.14 | 4.0.0-4.3.0|
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539081"></a> [2539081](#2539081) <a name="2539081"></a> <br />CM-23792 | When you delete post-up and pre-down IP peer entries from the <code>etc/network/interfaces</code> file, then run the <code>ifreload</code> command, the IP addresses are not removed and the route remains in the route table. <br />To work around this issue, either delete the IP addresses without the /32 mask component or flush the IP addresses for the interface with the <code>ip addr flush dev <interface></code> command. <br /> | 3.7.0-3.7.14 | 4.0.0-4.3.0|
| <a name="2538875"></a> [2538875](#2538875) <a name="2538875"></a> <br />CM-23696 | IPv6 multicast traffic destined to an unregistered multicast group is flooded to all ports in a bridge despite the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/swichd.conf</code> file. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538302"></a> [2538302](#2538302) <a name="2538302"></a> <br />CM-23422 | <code>portwd</code> allows an error to change the module type based on the error. For example, a bad write to a module might cause the module type to flap, which causes the link itself to flap. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538256"></a> [2538256](#2538256) <a name="2538256"></a> <br />CM-23397 | On the Broadcom switch, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets. <br />  | 3.7.2-4.0.1 | 4.1.0-4.3.0|
| <a name="2537823"></a> [2537823](#2537823) <a name="2537823"></a> <br />CM-23125 | The OpenSSL package on Cumulus Linux 3.x has a vulnerability similar to CVE-2018-0734. (The OpenSSL DSA signature algorithm has been shown to be vulnerable to a timing side channel attack. An attacker could use variations in the signing algorithm to recover the private key).  According to Debian upstream, this version "is not vulnerable &#91;to CVE-2018-0734 exactly&#93;. Nevertheless, there is a bug fix that futher reduces the amount of leaked timing information. It got no CVE on its own and introduced this vulnerability."<br />Vulnerable on CL3: 1.0.1t-1+deb8u12 | 3.7.11-3.7.14.2 | |
| <a name="2537820"></a> [2537820](#2537820) <a name="2537820"></a> <br />CM-23123 | When you enable FEC (RS or BaseR) on an interface, removing the configuration from that interface does not revert the FEC status to off/none. <br /> | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537544"></a> [2537544](#2537544) <a name="2537544"></a> <br />CM-23021 | When you run the <code>mstpctl</code> command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of <code>mstpctl</code>; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | 4.3.0|
| <a name="2537514"></a> [2537514](#2537514) <a name="2537514"></a> <br />CM-23004 | The local fallback account authenticates using the local password when the RADIUS or TACACS service is up. The expected behavior is for this to fail and only succeed when the RADIUS OR TACACS server fails to respond. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537378"></a> [2537378](#2537378) <a name="2537378"></a> <br />CM-22937 | NCLU SNMPv3 user configuration (add, delete, modify) does not complete. Changes are made to the <code>/etc/snmp/snmpd.conf</code> file but the SNMPv3 user cache file <code>/var/lib/snmp/snmpd.conf</code> fails to update correctly and the configuration does not reflect in operation. <br />To work around this issue, stop <code>snmpd</code>, remove the cache file, then restart <code>snmpd</code>. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537188"></a> [2537188](#2537188) <a name="2537188"></a> <br />CM-22849 | When an event in the network, such as a <code>switchd</code> or networking service restart, leads to an OVSDB server high availability transition, an <code>ovs-vtepd</code> core might occur. <br />This core generation has no effect on the functionality of high availability when the active OVSDB server is back in the network. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2537104"></a> [2537104](#2537104) <a name="2537104"></a> <br />CM-22808 | When you try to stop <code>hsflowd</code> on the Trident II+ switch with the <code>systemctl stop hsflowd</code> command, the process hangs until you stop it with <code>SIGKILL</code>. <br /> | 3.7.1-3.7.14 | 4.0.0-4.3.0|
| <a name="2537061"></a> [2537061](#2537061) <a name="2537061"></a> <br />CM-22794 | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent. <br /> | 3.7.1-4.0.1 | 4.1.0-4.3.0|
| <a name="2536608"></a> [2536608](#2536608) <a name="2536608"></a> <br />CM-22583 | Single tagged ARP requests received on a QinQ-over-VXLAN access port are dropped if ARP suppression is enabled on an unrelated VNI. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on protocol sockets.<br />When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a <code>switchd</code> restart. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535965"></a> [2535965](#2535965) <a name="2535965"></a> <br />CM-22020 | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br />To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2534394"></a> [2534394](#2534394) <a name="2534394"></a> <br />CM-20480 | The python-crypto package, which is not installed by default on Cumulus Linux, but is present in the repository to be installed, has the following security vulnerability in the version available for Cumulus Linux 3.x:<br />CVE-2018-6594: lib/Crypto/PublicKey/ElGamal.py in PyCrypto through 2.6.1 generates weak ElGamal key parameters, which allows attackers to obtain sensitive information by reading ciphertext data (i.e., it does not have semantic security in face of a ciphertext-only attack). The Decisional Diffie-Hellman (DDH) assumption does not hold for PyCrypto's ElGamal implementation.<br />More information at https://security-tracker.debian.org/tracker/CVE-2018-6594 . | 3.7.9-3.7.14.2 | |
| <a name="2533691"></a> [2533691](#2533691) <a name="2533691"></a> <br />CM-19788 | If you configure a VLAN under a VLAN-aware bridge and create a subinterface of the same VLAN on one of the bridge ports, the bridge and interface compete for the same VLAN and if the interface is flapped, it stops working. Correcting the configuration and running the <code>ifreload</code> command does not resolve the conflict. <br />To work around this issue, correct the bridge VIDs and restart <code>switchd</code> or delete the subinterface.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2532017"></a> [2532017](#2532017) <a name="2532017"></a> <br />CM-18192 | In FRR, <code>bgp_snmp</code> does not show all BGP peers when peer groups used. | 3.7.11-4.0.1 | 4.1.0-4.3.0|

### Fixed Issues in 3.7.14
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="2554706"></a> [2554706](#2554706) <a name="2554706"></a> <br />CM-32214 | CVE-2020-8037: The ppp de-capsulator in tcpdump 4.9.3 can be convinced to allocate a large amount of memory.  The buffer should be big enough to hold the captured data, but it doesn’t need to be big enough to hold the entire on-the-network packet, if we haven’t captured all of it.<br />Vulnerable: <= 4.9.3-1~deb8u1<br />Fixed: 4.9.3-1~deb8u2 | 3.7.13 | |
| <a name="2554687"></a> [2554687](#2554687) <a name="2554687"></a> <br />CM-32205 | CVE-2020-28196: There is a denial of service vulnerability in the MIT Kerberos network authentication system, krb5. The lack of a limit in the “ASN.1” decoder could lead to infinite recursion and allow an attacker to overrun the stack and cause the process to crash.<br />Vulnerable: <= 1.12.1+dfsg-19+deb8u5<br />Fixed: 1.12.1+dfsg-19+deb8u6 | 3.7.13 | |
| <a name="2554609"></a> [2554609](#2554609) <a name="2554609"></a> <br />CM-32164 | CVE-2020-25692: A vulnerability in the handling of normalization with modrdn was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can use this flaw to cause a denial of service (slapd daemon crash) via a specially crafted packet.<br />The slapd package is not present in the image or repository, although the OpenLDAP libraries are present.<br />Vulnerable: <= 2.4.40+dfsg-1+deb8u6<br />Fixed: 2.4.40+dfsg-1+deb8u7 | 3.7.13 | |
| <a name="2554454"></a> [2554454](#2554454) <a name="2554454"></a> <br />CM-32057 | The following vulnerability has been announced in the freetype / libfreetype6 packages:<br />CVE-2020-15999: heap-based buffer overflow vulnerability in the handling of embedded PNG bitmaps in FreeType. Opening malformed fonts may result in denial of service or the execution of arbitrary code.<br />Vulnerable: <= 2.5.2-3+deb8u4<br />Fixed: 2.5.2-3+deb8u5 | 3.7.13 | |
| <a name="2554376"></a> [2554376](#2554376) <a name="2554376"></a> <br />CM-32011 | The following vulnerabilities have been announced in poppler (libpoppler46 and libpoppler-qt4-4):<br />CVE-2019-10018: Floating point exception in the function PostScriptFunction::exec at<br />Function.cc<br />CVE-2019-14494: There is a divide-by-zero error in the function<br />SplashOutputDev::tilingPatternFill at SplashOutputDev.cc.<br />Vulnerable: <= 0.26.5-2+deb8u13<br />Fixed: 0.26.5-2+deb8u14 | 3.7.13 | |
| <a name="2554375"></a> [2554375](#2554375) <a name="2554375"></a> <br />CM-32010 | CVE-2020-27153: There was a double-free vulnerability in BlueZ, a suite of Bluetooth tools, utilities and daemons. A remote attacker could potentially cause a denial of service or code execution during service discovery, due to a redundant disconnect management (MGMT) event.<br />Vulnerable: <= 5.43-2+deb9u2~deb8u1<br />Fixed: 5.43-2+deb9u2~deb8u2 | 3.7.13 | |
| <a name="2554332"></a> [2554332](#2554332) <a name="2554332"></a> <br />CM-31981 | In an EVPN active/active environment, when one of the peers reboots and begins to refresh IP neighbor entries shared by the MLAG peer, some of the ARP messages might be dropped by the ARP policer of the MLAG peer.<br />To work around this issue, increase the burst value of the ARP policers to 200 or higher. |  | |
| <a name="2554232"></a> [2554232](#2554232) <a name="2554232"></a> <br />CM-31929 | VXLAN encapsulated traffic is not routed to the next hop because the destination VTEP IP address is mis-programmed on the switch, which decapsulates the traffic unexpectedly. <br />To work around this issue, restart <code>switchd</code>. | 3.7.12-3.7.13 | |
| <a name="2554130"></a> [2554130](#2554130) <a name="2554130"></a> <br />CM-31863 | CVE-2020-14355: Multiple buffer overflow vulnerabilities were found in the QUIC image decoding process of the SPICE remote display system, before spice-0.14.2-1.<br />Both the SPICE client (spice-gtk) and server are affected by these flaws. These flaws allow a malicious client or server to send specially crafted messages that, when processed by the QUIC image compression algorithm, result in a process crash or potential code execution.<br />Vulnerable: <= 0.12.5-1+deb8u7<br />Fixed: 0.12.5-1+deb8u8 | 3.7.13 | |
| <a name="2553877"></a> [2553877](#2553877) <a name="2553877"></a> <br />CM-31696 | The following vulnerability has been announced in libproxy:<br />CVE-2020-26154: A possible buffer overflow vulnerability in libproxy when a server serving a PAC file sends more than 102400 bytes without a Content-Length present.<br />Vulnerable: <= 0.4.11-4+deb8u1<br />Fixed: 0.4.11-4+deb8u2 | 3.7.13 | |
| <a name="2553876"></a> [2553876](#2553876) <a name="2553876"></a> <br />CM-31695 | The following vulnerability has been announced in the ruby2.1 packages:<br />CVE-2020-25613: WEBrick (bundled along with ruby2.1) was too tolerant against an invalid Transfer-Encoding header. This may lead to inconsistent interpretation between WEBrick and some HTTP proxy servers, which may allow the attacker to “smuggle” a request.<br />Vulnerable: <= 2.1.5-2+deb8u10<br />Fixed: 2.1.5-2+deb8u11. | 3.7.13 | |
| <a name="2553847"></a> [2553847](#2553847) <a name="2553847"></a> <br />CM-31674 | The following vulnerabilities have been announced in the python3.4 packages:<br />CVE-2019-20907: Avoid infinite loop with crafted tar file by improving header validation.<br />CVE-2020-26116: Avoid injection of HTTP headers via the HTTP method without rejecting newline characters.<br />Vulnerable: <= 3.4.2-1+deb8u8<br />Fixed: 3.4.2-1+deb8u9 | 3.7.13 | |
| <a name="2553846"></a> [2553846](#2553846) <a name="2553846"></a> <br />CM-31673 | CVE-2016-7949, CVE-2016-7950: The libxrender library has issues in the way various X client libraries handle the responses they receive from servers. Insufficient validation of data from the X server could cause out of boundary memory writes in the libXrender library potentially allowing the user to escalate their privileges.<br />Vulnerable: 0.9.8-1 |  | |
| <a name="2553763"></a> [2553763](#2553763) <a name="2553763"></a> <br />CM-31631 | Several vulnerabilities were discovered in the Perl5 Database Interface (DBI). An attacker could trigger a denial-of-service (DoS), information disclosure and possibly execute arbitrary code.<br />CVE-2013-7490: Using many arguments to methods for Callbacks may lead to memory corruption.<br />CVE-2014-10401: DBD::File drivers can open files from folders other than those specifically passed via the f_dir attribute.<br />CVE-2019-20919: The hv_fetch() documentation requires checking for NULL and the code does that. But, shortly thereafter, it calls SvOK(profile), causing a NULL pointer dereference.<br />CVE-2020-14392: An untrusted pointer dereference flaw was found in Perl-DBI. A local attacker who is able to manipulate calls to dbd_db_login6_sv() could cause memory corruption, affecting the service’s availability.<br />CVE-2020-14393: A buffer overflow on via an overlong DBD class name in dbih_setup_handle function may lead to data be written past the intended limit.<br />Vulnerable: 1.631-3<br />Fixed: 1.631-3+deb8u1 | 3.7.13 | |
| <a name="2553738"></a> [2553738](#2553738) <a name="2553738"></a> <br />CM-31622 | The following vulnerability has been announced in curl:<br />CVE-2020-8231: In rare circumstances, when using the multi API of curl in combination with CURLOPT_CONNECT_ONLY, the wrong connection might be used when transfering data later.<br />Vulnerable: <= 7.38.0-4+deb8u17<br />Fixed: 7.38.0-4+deb8u18 | 3.7.13 | |
| <a name="2553732"></a> [2553732](#2553732) <a name="2553732"></a> <br />CM-31618 | A ping via a dual-connected bond fails, and the audio stream is not routed or encapsulated through the layer 3 VNI. | 3.7.12-3.7.13, 4.0.0-4.2.1 | |
| <a name="2553588"></a> [2553588](#2553588) <a name="2553588"></a> <br />CM-31565 | Multicast traffic on a VPN is sent to remote VTEPs that are not part of the VPN and the remote VTEPs receive multicast traffic encapsulated in a VXLAN ID that doesn't exist.<br />To work around this issue, disable IGMP snooping on the switch. | 3.7.12-3.7.13, 4.0.0-4.2.1 | |
| <a name="2553530"></a> [2553530](#2553530) <a name="2553530"></a> <br />CM-31545 | In an MLAG configuration with a layer 3 VNI, when you bounce the peer link, all layer 2 VNIs listed under the layer 3 VNI are duplicated. <br />To work around this issue, restart FRR with the <code>sudo systemctl restart frr.service</code> command.<br /><br /> | 3.7.10-3.7.13, 4.1.1-4.2.1 | |
| <a name="2553450"></a> [2553450](#2553450) <a name="2553450"></a> <br />CM-31504 | On the the Dell N3248-PXE switch, when you insert two PSUs at different times, the newly inserted PSU is detected as OK but the fan and temp sensors are ABSENT.<br />To work around this issue, remove power to both PSUs at the same time, then reinsert power simultaneously. | 3.7.12-3.7.13, 4.2.1 | |
| <a name="2553375"></a> [2553375](#2553375) <a name="2553375"></a> <br />CM-31475 | The following vulnerabilities have been announced in QEMU packages:<br />CVE-2019-20382: Memory leak in zrle_compress_data in ui/vnc-enc-zrle.c during a VNC disconnect operation because libz is misused, resulting in a situation where memory allocated in deflateInit2 is not freed in deflateEnd.<br />CVE-2020-13253: sd_wp_addr in hw/sd/sd.c uses an unvalidated address, which leads to an out-of-bounds read during sdhci_write() operations. A guest OS user can crash the QEMU process.<br />CVE-2020-13754: hw/pci/msix.c allows guest OS users to trigger an out-of-bounds access via a crafted address in an msi-x mmio operation.<br />CVE-2020-14364: An out-of-bounds read/write access flaw was found in the USB emulator. This issue occurs while processing USB packets from a guest when USBDevice ‘setup_len’ exceeds its ‘data_buf&#91;4096&#93;’ in the do_token_in, do_token_out routines. This flaw allows a guest user to crash the QEMU process, resulting in a denial of service, or the potential execution of arbitrary code with the privileges of the QEMU process on the host.<br />CVE-2020-16092: An assertion failure can occur in the network packet processing. This issue affects the vmxnet3 network devices. A malicious guest user/process could use this flaw to abort the QEMU process on the host, resulting in a denial of service condition in net_tx_pkt_add_raw_fragment in hw/net/net_tx_pkt.c.<br />Vulnerable: <= 2.1+dfsg-12+deb8u16<br />Fixed: 2.1+dfsg-12+deb8u17 | 3.7.13 | |
| <a name="2553310"></a> [2553310](#2553310) <a name="2553310"></a> <br />CM-31454 | The following vulnerability has been announced in <code>libproxy</code>:<br />CVE-2020-25219: There was a denial of service attack in libproxy, a library to make applications HTTP proxy aware. A remote server could cause an infinite stack recursion.<br />Vulnerable: <= 0.4.11-4<br />Fixed: 0.4.11-4+deb8u1 | 3.7.13 | |
| <a name="2553309"></a> [2553309](#2553309) <a name="2553309"></a> <br />CM-31453 | The following vulnerability has been announced in python-pip:<br />CVE-2019-20916: When an URL was given in an install command, as a Content-Disposition HTTP header was permitted to have ../ components in its filename, arbitrary local files (eg. /root/.ssh/authorized_keys) could be overidden.<br />Vulnerable: <= 1.5.6-5<br />Fixed: 1.5.6-5+deb8u1 | 3.7.13 | |
| <a name="2553229"></a> [2553229](#2553229) <a name="2553229"></a> <br />CM-31412 | On the Dell N3248PXE switch, RJ45 fixed copper ports that auto-negotiate with a 100M or 10M neighbor incorrectly negotiate a half-duplex link that generates errors. Half duplex modes are not supported on this platform. | 3.7.12-3.7.13, 4.2.1 | |
| <a name="2553190"></a> [2553190](#2553190) <a name="2553190"></a> <br />CM-31390 | The following vulnerabilities have been announced in libxml2:<br />CVE-2017-8872: Global buffer-overflow in the htmlParseTryOrFinish function.<br />CVE-2019-20388: A memory leak was found in the xmlSchemaValidateStream function of libxml2. Applications that use this library may be vulnerable to memory not being<br />freed leading to a denial of service.<br />CVE-2020-24977: Out-of-bounds read restricted to xmllint --htmlout.<br />CVE-2020-7595: Infinite loop in xmlStringLenDecodeEntities can cause a denial of service.<br />Vulnerable: <= 2.9.1+dfsg1-5+deb8u8<br />Fixed: 2.9.1+dfsg1-5+deb8u9 | 3.7.13 | |
| <a name="2553150"></a> [2553150](#2553150) <a name="2553150"></a> <br />CM-31377 | The following vulnerabilities have been announced in libjpeg-turbo:<br />CVE-2020-13790: Heap-based buffer over-read via a PPM input file.<br />CVE-2020-14152: Improper handling of max_memory_to_use setting can lead to excessive memory consumption.<br />Vulnerable: <= 1.3.1-12+deb8u2<br />Fixed: 1.3.1-12+deb8u3 | 3.7.13 | |
| <a name="2553049"></a> [2553049](#2553049) <a name="2553049"></a> <br />CM-31321 | The following vulnerability has been announced in the libx11 libraries:<br />CVE-2020-14363: Integer overflow in the init_om function of libX11, the X11 client-side library, which could lead to a double free.<br />Vulnerable: <= 1.6.2-3+deb8u3<br />Fixed: 1.6.2-3+deb8u4 | 3.7.13 | |
| <a name="2553001"></a> [2553001](#2553001) <a name="2553001"></a> <br />CM-31294 | When the following conditions exist, <code>clagd</code> might fail to establish a TCP control session across the subinterface (such as, peerlink.4094): <br />* <code>clagd</code> uses an IPv6 link-local address (LLA) to establish the TCP connection (the <code>clagd-peer-ip linklocal</code> command configures an IPv6 LLA connection)<br /><br />* Subsequent VLAN changes are made to VLAN sub-interfaces or adding or removing SVIs<br /><br />This issue occurs because the hardware stores one entry per VRF to represent the IPv6 LLA. The hardware entry for the LLA is removed when another interface is changed because the software interfaces are represented by a single entity in hardware. As a result, packets destined to the local IPv6 LLA address are received on the port but do not get forwarded to CPU for further processing.<br /><br />To workaround this issue, use IPv4 addresses under <code>peerlink.4094</code> and configure <code>clagd</code> to peer on IPv4 addresses. | 3.7.12-3.7.13 | |
| <a name="2552954"></a> [2552954](#2552954) <a name="2552954"></a> <br />CM-31274 | The following vulnerability has been announced in the <code>apache2</code> package:<br />CVE-2020-11985: apache2 was vulnerable to IP address spoofing when proxying using mod_remoteip and mod_rewrite.<br />For configurations using proxying with mod_remoteip and certain mod_rewrite rules, an attacker could spoof their IP address for logging and PHP scripts.<br />Vulnerable: <= 2.4.10-10+deb8u16<br />Fixed: 2.4.10-10+deb8u17 | 3.7.13 | |
| <a name="2552953"></a> [2552953](#2552953) <a name="2552953"></a> <br />CM-31273 | The following vulnerability has been announced in the bind9 packages:<br />CVE-2020-8622: Crafted responses to TSIG-signed requests could lead to an assertion failure, causing named, a Domain Name Server, to exit. This could be done by malicious server operators or guessing attackers.<br />Vulnerable: <= 9.9.5.dfsg-9+deb8u19<br />Fixed: 9.9.5.dfsg-9+deb8u20 | 3.7.13 | |
| <a name="2552952"></a> [2552952](#2552952) <a name="2552952"></a> <br />CM-31272 | The following vulnerability has been announced in the nss / libnss3 packages:<br />CVE-2020-12403: The ChaCha20 symmetric key cipher algorithm did not correctly enforce the tag length which may have led to an out-of-bounds read and a lack of confidentiality.<br />Vulnerable: <= 3.26-1+debu8u12<br />Fixed: 3.26-1+debu8u13 | 3.7.13 | |
| <a name="2552925"></a> [2552925](#2552925) <a name="2552925"></a> <br />CM-31257 | On the EdgeCore AS-6712-32X, AS5812-54X and AS5812-54T switch models, the temp sensors (DIMM temp sensor) show ABSENT. The amber diagnostic light on the front of the switch might also be turned on due to this issue.<br />These messages and the light are cosmetic issues only and do not otherwise impact the function of the switch. | 3.7.12-3.7.13 | |
| <a name="2552881"></a> [2552881](#2552881) <a name="2552881"></a> <br />CM-31238 | IPv6 TCP or UDP connections (sourcing from an ephemeral port in the range 34048 to 35071) are not forwarded if the switch has more than one layer 2 VNI defined. The traffic might be locally switched on the bridge and dropped. <br />To work around this issue, disable ARP/ND suppression to remove the internal ACL rule that affects the ports. | 3.7.13, 4.2.1 | |
| <a name="2552860"></a> [2552860](#2552860) <a name="2552860"></a> <br />CM-31226 | Mellanox switches with the Spectrum ASIC fail to read PSU Fan/Temp sensors and report them as Absent. The following messages are observed in syslog:<br /><pre><br />2020-08-21T07:17:39.068160+00:00 cumulus : /usr/sbin/smond : : PSU1Temp1(PSU1 Temp Sensor): state changed from UNKNOWN to ABSENT<br />2020-08-21T07:17:39.068911+00:00 cumulus : /usr/sbin/smond : : PSU2Temp1(PSU2 Temp Sensor): state changed from UNKNOWN to ABSENT<br /></pre> | 3.7.13 | |
| <a name="2552840"></a> [2552840](#2552840) <a name="2552840"></a> <br />CM-31210 | CVE-2020-14350: In PostgreSQL 9.4, an uncontrolled search path could allow users to run arbitrary SQL functions with elevated priviledges when a superuser runs certain 'CREATE EXTENSION’ statements.<br />Vulnerable: <= 9.4.26-0+deb8u2<br />Fixed: 9.4.26-0+deb8u3 | 3.7.13 | |
| <a name="2552756"></a> [2552756](#2552756) <a name="2552756"></a> <br />CM-31158 | An issue has been found in python2.7, an interactive high-level object-oriented language.<br />CVE-2019-20907: Opening a crafted tar file could result in an infinite loop due to missing header validation.<br />Vulnerable: <= 2.7.9-2-ds1+deb8u5<br />Fixed: 2.7.9-2-ds1+deb8u6 | 3.7.13 | |
| <a name="2552715"></a> [2552715](#2552715) <a name="2552715"></a> <br />CM-31130 | The following vulnerabilities have been announced in the <code>ghostscript</code> package, which is available for optional installation. These vulnerabilities can allow an attacker to elevate privileges or cause a denial of service with crafted PS/EPS/PDF files:<br />CVE-2020-16287 CVE-2020-16288 CVE-2020-16289 CVE-2020-16290 CVE-2020-16291 CVE-2020-16292 CVE-2020-16293 CVE-2020-16294 CVE-2020-16295 CVE-2020-16296 CVE-2020-16297 CVE-2020-16298 CVE-2020-16299 CVE-2020-16300 CVE-2020-16301 CVE-2020-16302 CVE-2020-16303 CVE-2020-16304 CVE-2020-16305 CVE-2020-16306 CVE-2020-16307 CVE-2020-16308 CVE-2020-16309 CVE-2020-16310 CVE-2020-17538<br />Vulnerable: <= 9.26a~dfsg-0+deb8u6<br />Fixed: 9.26a~dfsg-0+deb8u7 | 3.7.13 | |
| <a name="2552714"></a> [2552714](#2552714) <a name="2552714"></a> <br />CM-31129 | The following vulnerability has been announced:<br />CVE-2020-17507: A vulnerability was discovered in qt4-x11, the cross-platform C++ application framework, which is available in the repository for optional installation. A specially-crafted XBM image file could have caused a buffer overread.<br />Vulnerable: <= 4.8.6+git64-g5dc8b2b+dfsg-3+deb8u2<br />Fixed: 4.8.6+git64-g5dc8b2b+dfsg-3+deb8u3 | 3.7.13 | |
| <a name="2552647"></a> [2552647](#2552647) <a name="2552647"></a> <br />CM-31086 | When you add a member to a bond that has a subinterface configured (such as peerlink.4094), the new member is assigned only the VLAN of the subinterface for forwarding.<br />To work around this issue, bounce the bond or shutdown the new interface and use the remaining members over the bond. | 3.7.10-3.7.13, 4.2.0 | |
| <a name="2552608"></a> [2552608](#2552608) <a name="2552608"></a> <br />CM-31055 | The following vulnerability has been announced:<br />CVE-2019-20892: net-snmp before 5.8.1.pre1 has a double free in usm_free_usmStateReference in snmplib/snmpusm.c via an SNMPv3 GetBulk request. <br />Fixed:  5.8.0-cl4.2.1u1,  5.8.0-cl3.7.14u1 | 3.7.13, 4.0.0-4.2.0 | |
| <a name="2552528"></a> [2552528](#2552528) <a name="2552528"></a> <br />CM-31028 | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | |
| <a name="2552506"></a> [2552506](#2552506) <a name="2552506"></a> <br />CM-31016 | Changing the order of the bridge ports might cause the bridge MAC address to change, which flaps the bridge and its ports.<br />To work around this issue, manually set the MAC address of the bridge interface by adding <code>hwaddress <mac-address></code> to the bridge stanza in the <code>/etc/network/interfaces</code> file. | 3.7.11-3.7.13, 4.0.0-4.2.0 | |
| <a name="2552442"></a> [2552442](#2552442) <a name="2552442"></a> <br />CM-30978 | The following vulnerability has been announced in pillow:<br />CVE-2020-10177: Pillow before 7.1.0 has multiple out-of-bounds reads in libImaging/FliDecode.c.<br />The python-pil packages are not installed by default, but are available for optional installation.<br />Vulnerable: <= 2.6.1-2+deb8u4<br />Fixed: 2.6.1-2+deb8u5 | 3.7.13 | |
| <a name="2552352"></a> [2552352](#2552352) <a name="2552352"></a> <br />CM-30914 | The following security vulnerabilities have been announced in the nss / libnss3 packages:<br />CVE-2020-6829: Side channel attack on ECDSA signature generation<br />CVE-2020-12400: P-384 and P-521 implementation uses a side-channel vulnerable modular inversion function<br />CVE-2020-12401: ECDSA timing attack mitigation bypass<br />Vulnerable: <= 3.26-1+debu8u11<br />Fixed: 3.26-1+debu8u12 | 3.7.0-3.7.13 | |
| <a name="2552351"></a> [2552351](#2552351) <a name="2552351"></a> <br />CM-30913 | The following vulnerability has been announced in the libx11 packages:<br />CVE-2020-14344: The X Input Method (XIM) client implementation in libX11 has some integer overflows and signed/unsigned comparison issues that can lead to heap corruption when handling malformed messages from an input method.<br />Vulnerable: <= 1.6.2-3+deb8u2<br />Fixed: 1.6.2-3+deb8u3 | 3.7.0-3.7.13 | |
| <a name="2552318"></a> [2552318](#2552318) <a name="2552318"></a> <br />CM-30895 | Various security vulnerabilities have been fixed in <code>imagemagick</code>, which is available in the repository for optional installation.  The list of CVEs is:<br />CVE-2017-12805 CVE-2017-17681 CVE-2017-18252 CVE-2018-7443 CVE-2018-8804 CVE-2018-8960 CVE-2018-9133 CVE-2018-10177 CVE-2018-18024 CVE-2018-20467 CVE-2019-10131 CVE-2019-11472 CVE-2019-12977 CVE-2019-12978 CVE-2019-12979 CVE-2019-13300 CVE-2019-13307 CVE-2019-13454<br />Vulnerable: <= 6.8.9.9-5+deb8u19<br />Fixed: 6.8.9.9-5+deb8u20 | 3.7.13 | |
| <a name="2552302"></a> [2552302](#2552302) <a name="2552302"></a> <br />CM-30885 | On a Mellanox switch with the Spectrum ASIC, you see LPC I2C driver errors similar to the following during boot:<br /><pre><br />Jul 30 23:49:41.651453 mlx-switch systemd&#91;1&#93;: Started udev Kernel Device Manager.<br />Jul 30 23:49:41.654978 mlx-switch systemd&#91;1&#93;: Starting LSB: Set preliminary keymap...<br />Jul 30 23:49:41.668214 mlx-switch kernel: LPCI2C ERR: Invalid flag 0x4 in msg 0<br />Jul 30 23:49:41.668265 mlx-switch kernel: LPCI2C ERR: Incorrect message<br />...<br /></pre> | 3.7.13 | |
| <a name="2552298"></a> [2552298](#2552298) <a name="2552298"></a> <br />CM-30882 | The following vulnerability has been announced in net-snmp:<br />CVE-2020-15862: A privilege escalation involving the NET-SNMP-EXTEND-MIB support (which is enabled by default at compile-time).<br />The fixed versions disable NET-SNMP-EXTEND-MIB support.<br /><br />Vulnerable: <= 5.8.0-cl3u11, <= 5.8.0-cl4u4<br />Fixed: 5.8.0-cl3.7.14u3, 5.8.0-cl4.2.1u1 | 3.7.13, 4.0.0-4.2.0 | |
| <a name="2552250"></a> [2552250](#2552250) <a name="2552250"></a> <br />CM-30858 | A vulnerability was found in <code>curl</code>, a command line tool for transferring data with URL syntax.  <code>curl</code> is installed by default on Cumulus Linux.<br />CVE-2020-8177: When using when using -J (–remote-header-name) and -i (–include) in the same command line, a malicious server could force curl to overwrite the contents of local files with incoming HTTP headers.<br />Vulnerable: <= 7.38.0-4+deb8u16<br />Fixed: 7.38.0-4+deb8u17 |  | |
| <a name="2552249"></a> [2552249](#2552249) <a name="2552249"></a> <br />CM-30857 | An issue has been found in luajit, a just in time compiler for Lua.<br /><br />CVE-2020-15890: An out-of-bounds read could happen because __gc handler frame traversal is mishandled.<br /><br />Vulnerable: 2.0.3+dfsg-3<br />Fixed: 2.0.3+dfsg-3+deb8u1 |  | |
| <a name="2552236"></a> [2552236](#2552236) <a name="2552236"></a> <br />CM-30845 | The following vulnerabilities were reported against <code>qemu</code>, which is available in the repository for optional installation:<br />CVE-2020-13659: address_space_map in exec.c in QEMU 4.2.0 can trigger a NULL pointer dereference related to BounceBuffer.<br />CVE-2020-15863: stack-based overflow in xgmac_enet_send() in hw/net/xgmac.c.<br />Vulnerable: <= 2.1+dfsg-12+deb8u15<br />Fixed: 2.1+dfsg-12+deb8u16 | 3.7.12-3.7.13 | |
| <a name="2552206"></a> [2552206](#2552206) <a name="2552206"></a> <br />CM-30827 | If the MAC address of an SVI changes, <code>clagd</code> does not update its permanent neighbor entry for the local interface, and it does not report the change to its MLAG peer. This leaves the MLAG peer in a state where its permanent neighbor for the MLAG peer's SVI IP address continues to use the old MAC address, which causes routed traffic over this SVI to be dropped.<br />To work around this issue, ifdown/ifup the SVI when a MAC address changes. | 3.7.12-3.7.13, 4.0.0-4.2.0 | |
| <a name="2551748"></a> [2551748](#2551748) <a name="2551748"></a> <br />CM-30514 | In OVSDB high availability mode, deleting > 200 VLAN bindings might cause <code>ovs-vtepd</code> to crash.  Limit the deletion to 200 or fewer VLAN bindings. | 3.7.12-3.7.13, 4.0.0-4.2.1 | |
| <a name="2551732"></a> [2551732](#2551732) <a name="2551732"></a> <br />CM-30504 | When the OVSDB VTEP scale increases, the CPU utilization increases and eventually the switch (<code>ptmd</code>) fails to respond to the BFD, causing the BFD session to go down. As a result OVSDB cannot read the BFD socket status and outputs a warning in the <code>ovs-vtepd</code> debugs: <code>PTM socket error: Bad file descriptor</code>. | 3.7.12-3.7.13, 4.0.0-4.2.0 | |
| <a name="2551729"></a> [2551729](#2551729) <a name="2551729"></a> <br />CM-30503 | In OVSDB high availability mode, if you create, then delete a binding, the FDB entry is not replaced and you see an error. | 3.7.12-3.7.13, 4.0.0-4.2.0 | |
| <a name="2551715"></a> [2551715](#2551715) <a name="2551715"></a> <br />CM-30498 | There is a change to the default OVSDB bootstrapping process, where the script created now defaults to VLAN-aware bridge mode. If you want to use traditional bride mode, you need to force it by editing the <code>ovs-vtep-ctl</code> script generated by the bootstrap process. | 3.7.12-3.7.13, 4.0.0-4.2.0 | |
| <a name="2551693"></a> [2551693](#2551693) <a name="2551693"></a> <br />CM-30486 | A host migrated to an 802.1X MAB port within the same broadcast domain fails to have the correct FDB entry installed if a dynamic FDB entry for that MAC address exists from previous connectivity in the broadcast domain.<br />To work around this issue, manually delete the dynamic FDB entry that is associated with the uplink trunk port. | 3.7.12-3.7.13, 4.1.1-4.2.0 | |
| <a name="2551675"></a> [2551675](#2551675) <a name="2551675"></a> <br />CM-30479 | When you restart <code>clagd</code>, the edge port setting on the peer link changes. | 3.7.2-3.7.13, 4.0.0-4.2.0 | |
| <a name="2551651"></a> [2551651](#2551651) <a name="2551651"></a> <br />CM-30464 | The <code>net show dot1x interface summary</code> command output shows a MAC address with all zeros associated with a port. | 3.7.12-3.7.13, 4.0.0-4.2.0 | |
| <a name="2550873"></a> [2550873](#2550873) <a name="2550873"></a> <br />CM-30141 | In an MLAG configuration with static VXLAN, static tunnels become unreachable. | 3.7.13, 4.1.1-4.2.0 | |
| <a name="2550606"></a> [2550606](#2550606) <a name="2550606"></a> <br />CM-29982 | A VRRP role change over the EVPN network causes excessive BGP updates and connectivity issues to VIP for about one minute. | 4.1.1-4.2.0 | |
| <a name="2550375"></a> [2550375](#2550375) <a name="2550375"></a> <br />CM-29838 | CPU utilization may increase when clag-managed bond interfaces are operationally/LACP down but the physical carrier remains up on the bond member switchports. This condition occurs when clag bond redirection is enabled and bond members remain up while the parent bond does not negotiate LACP.<br /><br />This issue is resolved in Cumulus Linux 3.7.14. | 3.7.9-3.7.13, 4.0.0-4.2.1 | |
| <a name="2550350"></a> [2550350](#2550350) <a name="2550350"></a> <br />CM-29830 | Unicast traffic from downlink hosts is flooded to multiple remote VTEPs, which might also cause high HwIfOutQDrops/TX_DRP on the uplink ports.<br />To work around this issue, restart <code>switchd</code>. | 3.7.10-3.7.13, 4.0.0-4.1.1 | |
| <a name="2549794"></a> [2549794](#2549794) <a name="2549794"></a> <br />CM-29525 | The <code>asic-monitor.service</code> fails when you configure <code>/etc/cumulus/datapath/monitor.conf</code> with <code>monitor.histogram_pg.collect.port_group_list  = &#91;all_packet_pg&#93;</code> and there is traffic passing through the buffer. When the service fails, you see the following traceback in <code>journalctl</code>:<br /><pre><br />asic-monitor&#91;7389&#93;: asic-monitor-module INFO: 2020-05-01 18:28:12.548734: Egress queue(s) greater than 500 bytes in monitor port group histogram_pg<br />asic-monitor&#91;7389&#93;: asic-monitor ERROR: ASIC monitor exception: sx_api_port_counter_tc_get failed: Parameter Error<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 139, in <module><br />asic-monitor&#91;7389&#93;: main(sys.argv&#91;1:&#93;)<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 126, in main<br />asic-monitor&#91;7389&#93;: traceback.print_stack()<br />asic-monitor&#91;7389&#93;: Traceback (most recent call last):<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 117, in main<br />asic-monitor&#91;7389&#93;: monitor.run()<br />asic-monitor&#91;7389&#93;: File "/usr/lib/python2.7/dist-packages/cumulus/asic_monitor.py", line 158, in run<br />...<br /></pre> | 3.7.11-3.7.13, 4.1.1-4.2.0 | |
| <a name="2548475"></a> [2548475](#2548475) <a name="2548475"></a> <br />CM-28932 | After you add a new VNI and a layer 3 SVI to a set of leafs, certain leafs might not be able to communicate on the layer 3 VNI. <br />To work around this issue, reboot the leaf switch or restart <code>switchd</code>. | 3.7.6-3.7.13 | |
| <a name="2548152"></a> [2548152](#2548152) <a name="2548152"></a> <br />CM-28682 | On the Mellanox Spectrum switch in an EVPN symmetric configuration with MLAG, simultaneously shutting down the layer 3 interfaces that serve as uplinks to the VXLAN fabric might result in traffic loss of up to 15 seconds. | 4.1.0-4.1.1 | |
| <a name="2547799"></a> [2547799](#2547799) <a name="2547799"></a> <br />CM-28451 | An error similar to the following shows in syslog for Mellanox switches:<br /><pre><br />2020-02-12T19:59:22.208012+08:00 leaf01 sx_sdk: RM_TABLE: No resources available to add 1 entries to KVD hash Table HW resource<br />2020-02-12T19:59:22.208124+08:00 leaf01 sx_sdk: PORT: __port_vport_fid_set err = (No More Resources)<br /></pre><br />To work around this issue, reboot the switch. | 3.7.11-3.7.13, 4.0.0-4.0.1 | |
| <a name="2547784"></a> [2547784](#2547784) <a name="2547784"></a> <br />CM-28442 | PTM mis-detects incorrect hostnames of LLDP neighbors and does not fail them as expected. Instead they end up in an N/A cabling status. | 3.7.11-3.7.13, 4.0.0-4.1.1 | |
| <a name="2547397"></a> [2547397](#2547397) <a name="2547397"></a> <br />CM-28219 | The following vulnerability affects sudo, which is installed by default on Cumulus Linux.  It is potentially exploitable on Cumulus Linux if pwfeedback (which is NOT enabled by default) is enabled in the /etc/sudoers file.<br />CVE-2019-18634: In Sudo before 1.8.26, if pwfeedback is enabled in /etc/sudoers, users can trigger a stack-based buffer overflow in the privileged sudo process. The attacker needs to deliver a long string to the stdin of getln() in tgetpass.c.<br />For more information, refer to:<br />https://security-tracker.debian.org/tracker/source-package/sudo<br />https://security-tracker.debian.org/tracker/CVE-2019-18634<br />https://www.sudo.ws/alerts/pwfeedback.html<br />Vulnerable: <= 1.8.10p4-cl3u6<br />Fixed: 1.8.10p4-cl3.7.14u1 | 3.7.13 | |
| <a name="2547341"></a> [2547341](#2547341) <a name="2547341"></a> <br />CM-28189 | When <code>host-resources</code> and <code>ucd-snmp-mib</code> are polled, you see permission denied messages similar to the following:<br /><pre><br />Jan 30 19:22:53 switch123 snmpd&#91;23172&#93;: Cannot statfs /sys/kernel/debug/tracing: Permission denied<br /></pre> | 3.7.13, 4.0.0-4.1.1 | |
| <a name="2547246"></a> [2547246](#2547246) <a name="2547246"></a> <br />CM-28136 | The MLAG switch pair has VLANs defined that are not used on MLAG bonds. These VLANs still synchronize MAC addresses across to the peer switch. This results in log messages that indicate a MAC address is installed and the VLAN is not defined; for example:<br /><pre><br />RTM_NEWNEIGH with unconfigured vlan XXXX on port peerlink<br /></pre> | 3.7.10-3.7.13, 4.0.0-4.1.1 | |
| <a name="2546577"></a> [2546577](#2546577) <a name="2546577"></a> <br />CM-27814 | A traditional bridge with QinQ and a VNI does not work for tagged traffic. | 3.7.10-3.7.13, 4.0.0-4.0.1 | |
| <a name="2545934"></a> [2545934](#2545934) <a name="2545934"></a> <br />CM-27489 | Mellanox switches might experience higher CPU usage from the <code>sx_sdk</code> service or when BFD is in use.<br />To work around this issue, disable BFD to alleviate some of the CPU load. | 3.7.13, 4.0.0-4.1.1 | |
| <a name="2545699"></a> [2545699](#2545699) <a name="2545699"></a> <br />CM-27354 | On the Celestica Pebble switch, if you use IPv6 routes with mask /65 to /127,  the <code>switchd</code> log fills with errors. | 3.7.10-3.7.13 | |
| <a name="2545537"></a> [2545537](#2545537) <a name="2545537"></a> <br />CM-27254 | On the Mellanox switch with the Spectrum and Spectrum-2 ASIC, IPv6 egress ACLs are not supported on subinterfaces. | 4.0.0-4.1.1 | |
| <a name="2545404"></a> [2545404](#2545404) <a name="2545404"></a> <br />CM-27173 | On the Trident3 switch, unicast ARP packets received on a VNI and forwarded to the CPU are not policed. | 3.7.10-3.7.13, 4.0.0-4.0.1 | |
| <a name="2535707"></a> [2535707](#2535707) <a name="2535707"></a> <br />CM-21769 | On the Mellanox switch, GRE tunneling does not work if the tunnel source is configured on an SVI interface. If  the tunnel source is configured on a physical switch port, then tunneling works as expected. | 4.0.0-4.1.1 | |
| <a name="2534978"></a> [2534978](#2534978) <a name="2534978"></a> <br />CM-21055 | On the Mellanox switch, the destination MAC address of ERSPAN GRE packets is set to all zeros; therefore, the first transit switch might drop packets. | 4.0.0-4.2.1 | |
| <a name="2529322"></a> [2529322](#2529322) <a name="2529322"></a> <br />CM-15601 | On a Mellanox switch in an MLAG configuration, routed packets that arrive on one switch to be forwarded to a destination MAC across the peer link are dropped due to MLAG loop prevention. This affects both routed unicast and multicast packets.<br /><br />To work around this issue, modify the routing design or policy such that routes do not have a next hop of an MLAG peer switch that traverses the MLAG peer link.  |  | |

## 3.7.13 Release Notes
### Open issues in 3.7.13

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-31420"></a> [CM-31420](#CM-31420) <a name="CM-31420"></a> <br /> | On a Cumulus Linux switch with high load averages, cl-support might end without creating a tar file  and leave a temporary directory in `/var/support` undeleted. Subsequent runs of cl-support do not clean up this directory. | 3.7.13-3.7.14.2 | |
| <a name="CM-30832"></a> [CM-30832](#CM-30832) <a name="CM-30832"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with `Unable to read from device/fan1_input/pwm1` syslog messages. | 3.7.11-3.7.14, 4.1.1-4.2.1 | 3.7.14.2, 4.3.0|
| <a name="CM-28462"></a> [CM-28462](#CM-28462) <a name="CM-28462"></a> <br /> | On rare occasions, when you upgrade Cumulus Linux with the `apt-get upgrade` command, the upgrade fails and reports `No space left on device`. Checking the disk utilization shows that the disk is not full.<br/>To work around this issue, run the `apt-get upgrade` command again and reboot the device if prompted to complete the upgrade. | 3.7.10-3.7.14.2 | |
| <a name="CM-28080"></a> [CM-28080](#CM-28080) <a name="CM-28080"></a> <br /> | TACACS+ through ClearPass is not currently supported. Cumulus Linux sends authorization before authentication, but ClearPass does not accept an authorization before the user is authenticated. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2595889"></a> [2595889](#2595889) <a name="2595889"></a> <br />CM-31120 | In a traditional bridge configuration with <code>ip-forward off</code>, neighbors are synchronized to hardware with a <code>switchd</code> restart but are cleared when you flap the bridge interface. | 3.7.10-4.2.1 | 4.3.0|
| <a name="2595816"></a> [2595816](#2595816) <a name="2595816"></a> <br />CM-31222 | Tenant VRF BGP peers appear in the EVPN RMAC and nexthop tables, which causes the kernel RMAC to point at invalid IP address. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2589747"></a> [2589747](#2589747) <a name="2589747"></a> <br />CM-32226 | If <code>switchd</code> successfully signals <code>clagd</code> that it is going down, <code>clagd</code> stops responding to keepalive echo requests from the peer instead of sending a good bye to the peer over both the peerlink and the backup switch. Eventually, the keepalive timer expires and the secondary switch becomes the primary, and brings the bonds and VNIs back up. However, if <code>switchd</code> does not successfully signal it is going down, (in the event of a crash), the primary switch continues to respond to keepalives, and the bonds and VNIs are down on both peers.  | 3.7.12-4.2.1 | 4.3.0|
| <a name="2562511"></a> [2562511](#2562511) <a name="2562511"></a> <br /> | <code>hostapd} does not fail over to secondary RADIUS servers for 802.1x authentication when the primary radius is reachable but not responding to Access-Requests<br />If the primary RADIUS server is having a problem servicing requests, you can remove it from the configuration temporarily to force requests to be sent to alternate servers. | 3.7.10-3.7.14.2 | |
| <a name="2558184"></a> [2558184](#2558184) <a name="2558184"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2556061"></a> [2556061](#2556061) <a name="2556061"></a> <br />CM-33032 | On Edgecore AS4610 switches, the historic CPU usage displayed in <code>/run/sysmonitor/history</code> is sometimes shown as a negative value.  | 3.7.12-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2556037"></a> [2556037](#2556037) <a name="2556037"></a> <br />CM-33012 | After you add an interface to the bridge, an OSPF session flap can occur.<br /><br /> | 3.7.9-4.2.0 | 4.2.1-4.3.0|
| <a name="2555428"></a> [2555428](#2555428) <a name="2555428"></a> <br />CM-32683 | When you change the SVI <code>vlan-id</code> value in the <code>/etc/network/interfaces</code> file, then run <code>ifreload -a</code>, the 802.1Q ID for the SVI in the kernel does not change.<br />This operation is not supported in the kernel without recreating the SVI. To apply the change, run <code>ifdown</code>, then <code>ifup</code> for the SVI to recreate the interface. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2555278"></a> [2555278](#2555278) <a name="2555278"></a> <br />CM-32597 | When you change the anycast address for the MLAG pair (clagd-vxlan-anycast-ip), high peak traffic occurs on the peer link interface of all MLAG switches. | 3.7.13-3.7.14 | 4.0.0-4.3.0|
| <a name="2555205"></a> [2555205](#2555205) <a name="2555205"></a> <br />CM-32545 | If the FRR and MSTP processes go down, an SNMP TRAP is not generated even with the following configuration in the <code>/etc/snmp/snmpd.conf</code> file. <br /><pre><br />proc watchfrr<br />proc mstpd<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRRis down!!!” PrErrorFlag.5 != 0<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRR is up!!!” PrErrorFlag.5 = 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is down!!!!" prErrorFlag.3 != 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is up!!!!" prErrorFlag.3 = 0<br /></pre><br /> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2554992"></a> [2554992](#2554992) <a name="2554992"></a> <br />CM-32420 | When running traditional mode bridges at scale (for example, when you have more than 200 bridges and a large number of MAC addresses), MLAG bonds flap intermittently from dual to single connected, then back to dual connected, which causes a layer 2 loop and STP state changes.<br />To work around this issue, either shut down one side of the MLAG bond or prune out VLANS over the bond. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2554785"></a> [2554785](#2554785) <a name="2554785"></a> <br />CM-32275 | After you reboot a Broadcom switch, <code>switchd</code> might fail to restart and you see logs in <code>switchd.log</code> similar to the following:<br /><pre><br />...<br />Nov 12 12:20:05.063876 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.064310 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 0:system_init:<br />Nov 12 12:20:05.064428 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 system_init: Misc init failed: Operation timed out<br />Nov 12 12:20:05.064464 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.091995 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 LED: Loading 256 bytes into LED program memory<br />Nov 12 12:20:05.092029 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099547 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 PORT: Error: bcm ports not initialized<br />Nov 12 12:20:05.099579 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099646 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /var/lib/cumulus/rc.datapath_0: line 81 (error code -1): script terminated<br />Nov 12 12:20:05.099667 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099775 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /etc/bcm.d/rc.soc: line 70 (error code -1): script terminated<br />Nov 12 12:20:05.099798 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099871 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 ERROR loading rc script on unit 0<br />Nov 12 12:20:05.099892 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099943 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:299 CRIT loading of rc script failed, aborting!<br /></pre> | 3.7.11-4.2.1 | 4.3.0|
| <a name="2554719"></a> [2554719](#2554719) <a name="2554719"></a> <br />CM-32225 | A slow memory leak is observed (1% per 14 hours) in kmalloc-256.<br />To work around this issue, reboot the switch. | 3.7.12-3.7.14.2 | |
| <a name="2554709"></a> [2554709](#2554709) <a name="2554709"></a> <br />CM-32217 | The IP address specified in the <code>ip pim use-source</code> command configured on the loopback interface should be inherited by unnumbered interfaces during their Primary IP address selection process.  If <code>ip pim use-source</code> is configured on the loopback after an unnumbered interface has already selected their Primary IP address, the unnumbered interface does not update its Primary IP address to be the new use-source value until after there is a netlink update for that interface.<br />To work around this issue, configure <code>ip pim use-source</code> on each unnumbered interface directly or ensure <code>ip pim use-source</code> is applied to the loopback before other unnumbered interfaces are enabled for PIM. | 3.7.13-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2554706"></a> [2554706](#2554706) <a name="2554706"></a> <br />CM-32214 | CVE-2020-8037: The ppp de-capsulator in tcpdump 4.9.3 can be convinced to allocate a large amount of memory.  The buffer should be big enough to hold the captured data, but it doesn’t need to be big enough to hold the entire on-the-network packet, if we haven’t captured all of it.<br />Vulnerable: <= 4.9.3-1~deb8u1<br />Fixed: 4.9.3-1~deb8u2 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2554687"></a> [2554687](#2554687) <a name="2554687"></a> <br />CM-32205 | CVE-2020-28196: There is a denial of service vulnerability in the MIT Kerberos network authentication system, krb5. The lack of a limit in the “ASN.1” decoder could lead to infinite recursion and allow an attacker to overrun the stack and cause the process to crash.<br />Vulnerable: <= 1.12.1+dfsg-19+deb8u5<br />Fixed: 1.12.1+dfsg-19+deb8u6 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2554609"></a> [2554609](#2554609) <a name="2554609"></a> <br />CM-32164 | CVE-2020-25692: A vulnerability in the handling of normalization with modrdn was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can use this flaw to cause a denial of service (slapd daemon crash) via a specially crafted packet.<br />The slapd package is not present in the image or repository, although the OpenLDAP libraries are present.<br />Vulnerable: <= 2.4.40+dfsg-1+deb8u6<br />Fixed: 2.4.40+dfsg-1+deb8u7 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2554588"></a> [2554588](#2554588) <a name="2554588"></a> <br />CM-32149 | If you try reconfigure a DHCP server after you delete the switch configuration with the <code>net del all</code> command, the <code>dhcpd</code> service fails because a duplicate process is running.<br />To work around this issue, edit the <code>/usr/lib/python2.7/dist-packages/nclu/plugins/dhcp.py</code> file to change:<br /><pre><br />DHCPD_PID="-pf {0}" <br /></pre><br />to:<br /><pre><br />DHCPD_PID="-pf {1}"<br /></pre> | 3.7.13-4.2.1 | 4.3.0|
| <a name="2554454"></a> [2554454](#2554454) <a name="2554454"></a> <br />CM-32057 | The following vulnerability has been announced in the freetype / libfreetype6 packages:<br />CVE-2020-15999: heap-based buffer overflow vulnerability in the handling of embedded PNG bitmaps in FreeType. Opening malformed fonts may result in denial of service or the execution of arbitrary code.<br />Vulnerable: <= 2.5.2-3+deb8u4<br />Fixed: 2.5.2-3+deb8u5 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2554376"></a> [2554376](#2554376) <a name="2554376"></a> <br />CM-32011 | The following vulnerabilities have been announced in poppler (libpoppler46 and libpoppler-qt4-4):<br />CVE-2019-10018: Floating point exception in the function PostScriptFunction::exec at<br />Function.cc<br />CVE-2019-14494: There is a divide-by-zero error in the function<br />SplashOutputDev::tilingPatternFill at SplashOutputDev.cc.<br />Vulnerable: <= 0.26.5-2+deb8u13<br />Fixed: 0.26.5-2+deb8u14 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2554375"></a> [2554375](#2554375) <a name="2554375"></a> <br />CM-32010 | CVE-2020-27153: There was a double-free vulnerability in BlueZ, a suite of Bluetooth tools, utilities and daemons. A remote attacker could potentially cause a denial of service or code execution during service discovery, due to a redundant disconnect management (MGMT) event.<br />Vulnerable: <= 5.43-2+deb9u2~deb8u1<br />Fixed: 5.43-2+deb9u2~deb8u2 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2554369"></a> [2554369](#2554369) <a name="2554369"></a> <br />CM-32006 | Certain Dell S4048-ON switches show an incorrect vendor name and hang when you issue the <code>reboot</code> command.  | 3.7.12-4.2.1 | 4.3.0|
| <a name="2554329"></a> [2554329](#2554329) <a name="2554329"></a> <br />CM-31978 | On the Dell N3248PXE switch, fixed RJ45 interfaces with PoE neighbors can end up in _Paused_ mode after a <code>switchd</code> restart, which blocks traffic on that interface.  | 3.7.12-3.7.14.2 | |
| <a name="2554232"></a> [2554232](#2554232) <a name="2554232"></a> <br />CM-31929 | VXLAN encapsulated traffic is not routed to the next hop because the destination VTEP IP address is mis-programmed on the switch, which decapsulates the traffic unexpectedly. <br />To work around this issue, restart <code>switchd</code>. | 3.7.12-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2554130"></a> [2554130](#2554130) <a name="2554130"></a> <br />CM-31863 | CVE-2020-14355: Multiple buffer overflow vulnerabilities were found in the QUIC image decoding process of the SPICE remote display system, before spice-0.14.2-1.<br />Both the SPICE client (spice-gtk) and server are affected by these flaws. These flaws allow a malicious client or server to send specially crafted messages that, when processed by the QUIC image compression algorithm, result in a process crash or potential code execution.<br />Vulnerable: <= 0.12.5-1+deb8u7<br />Fixed: 0.12.5-1+deb8u8 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553877"></a> [2553877](#2553877) <a name="2553877"></a> <br />CM-31696 | The following vulnerability has been announced in libproxy:<br />CVE-2020-26154: A possible buffer overflow vulnerability in libproxy when a server serving a PAC file sends more than 102400 bytes without a Content-Length present.<br />Vulnerable: <= 0.4.11-4+deb8u1<br />Fixed: 0.4.11-4+deb8u2 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553876"></a> [2553876](#2553876) <a name="2553876"></a> <br />CM-31695 | The following vulnerability has been announced in the ruby2.1 packages:<br />CVE-2020-25613: WEBrick (bundled along with ruby2.1) was too tolerant against an invalid Transfer-Encoding header. This may lead to inconsistent interpretation between WEBrick and some HTTP proxy servers, which may allow the attacker to “smuggle” a request.<br />Vulnerable: <= 2.1.5-2+deb8u10<br />Fixed: 2.1.5-2+deb8u11. | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553847"></a> [2553847](#2553847) <a name="2553847"></a> <br />CM-31674 | The following vulnerabilities have been announced in the python3.4 packages:<br />CVE-2019-20907: Avoid infinite loop with crafted tar file by improving header validation.<br />CVE-2020-26116: Avoid injection of HTTP headers via the HTTP method without rejecting newline characters.<br />Vulnerable: <= 3.4.2-1+deb8u8<br />Fixed: 3.4.2-1+deb8u9 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553763"></a> [2553763](#2553763) <a name="2553763"></a> <br />CM-31631 | Several vulnerabilities were discovered in the Perl5 Database Interface (DBI). An attacker could trigger a denial-of-service (DoS), information disclosure and possibly execute arbitrary code.<br />CVE-2013-7490: Using many arguments to methods for Callbacks may lead to memory corruption.<br />CVE-2014-10401: DBD::File drivers can open files from folders other than those specifically passed via the f_dir attribute.<br />CVE-2019-20919: The hv_fetch() documentation requires checking for NULL and the code does that. But, shortly thereafter, it calls SvOK(profile), causing a NULL pointer dereference.<br />CVE-2020-14392: An untrusted pointer dereference flaw was found in Perl-DBI. A local attacker who is able to manipulate calls to dbd_db_login6_sv() could cause memory corruption, affecting the service’s availability.<br />CVE-2020-14393: A buffer overflow on via an overlong DBD class name in dbih_setup_handle function may lead to data be written past the intended limit.<br />Vulnerable: 1.631-3<br />Fixed: 1.631-3+deb8u1 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553748"></a> [2553748](#2553748) <a name="2553748"></a> <br />CM-31627 | On switches with the Spectrum ASIC, the IPv6 default route is present in the kernel but missing in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2553738"></a> [2553738](#2553738) <a name="2553738"></a> <br />CM-31622 | The following vulnerability has been announced in curl:<br />CVE-2020-8231: In rare circumstances, when using the multi API of curl in combination with CURLOPT_CONNECT_ONLY, the wrong connection might be used when transfering data later.<br />Vulnerable: <= 7.38.0-4+deb8u17<br />Fixed: 7.38.0-4+deb8u18 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553732"></a> [2553732](#2553732) <a name="2553732"></a> <br />CM-31618 | A ping via a dual-connected bond fails, and the audio stream is not routed or encapsulated through the layer 3 VNI. | 3.7.12-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2553677"></a> [2553677](#2553677) <a name="2553677"></a> <br />CM-31605 | When you configure an SNMPv3 user with the <code>net-snmp-config</code> configuration command from the <code>libsnmp-dev</code> package, you get an error message similar to the one below:<br /><pre><br />cumulus&#64;switch:mgmt-vrf:~$ sudo net-snmp-config --create-snmpv3-user -a shaauthpass -x aesprivpass -A SHA -X AES userSHAwithAES<br />adding the following line to /var/lib/snmp/snmpd.conf:           <br />   createUser userSHAwithAES SHA "shaauthpass" AES "aesprivpass"       <br />adding the following line to /snmp/snmpd.conf:                           <br />   rwuser userSHAwithAES                                           <br />touch: cannot touch ‘/snmp/snmpd.conf’: No such file or directory<br />/usr/bin/net-snmp-create-v3-user: 144: /usr/bin/net-snmp-create-v3-user: cannot create /snmp/snmpd.conf: Directory nonexistent<br /></pre><br />To work around this issue, use the NCLU command to configure SNMPv3 user parameters; for example:<br /><pre><br />cumulus&#64;switch:mgmt-vrf:~$ net add snmp-server username user999 auth-md5 user999password encrypt-des user999encryption<br /></pre><br />Alternatively, directly edit the <code>/etc/snmp/snmpd.conf</code> file as described in the documentation. | 3.7.13-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553588"></a> [2553588](#2553588) <a name="2553588"></a> <br />CM-31565 | Multicast traffic on a VPN is sent to remote VTEPs that are not part of the VPN and the remote VTEPs receive multicast traffic encapsulated in a VXLAN ID that doesn't exist.<br />To work around this issue, disable IGMP snooping on the switch. | 3.7.12-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2553530"></a> [2553530](#2553530) <a name="2553530"></a> <br />CM-31545 | In an MLAG configuration with a layer 3 VNI, when you bounce the peer link, all layer 2 VNIs listed under the layer 3 VNI are duplicated. <br />To work around this issue, restart FRR with the <code>sudo systemctl restart frr.service</code> command.<br /><br /> | 3.7.10-3.7.13, 4.1.1-4.2.1 | 3.7.14, 4.3.0|
| <a name="2553450"></a> [2553450](#2553450) <a name="2553450"></a> <br />CM-31504 | On the the Dell N3248-PXE switch, when you insert two PSUs at different times, the newly inserted PSU is detected as OK but the fan and temp sensors are ABSENT.<br />To work around this issue, remove power to both PSUs at the same time, then reinsert power simultaneously. | 3.7.12-3.7.13, 4.2.1 | 3.7.14, 4.3.0|
| <a name="2553375"></a> [2553375](#2553375) <a name="2553375"></a> <br />CM-31475 | The following vulnerabilities have been announced in QEMU packages:<br />CVE-2019-20382: Memory leak in zrle_compress_data in ui/vnc-enc-zrle.c during a VNC disconnect operation because libz is misused, resulting in a situation where memory allocated in deflateInit2 is not freed in deflateEnd.<br />CVE-2020-13253: sd_wp_addr in hw/sd/sd.c uses an unvalidated address, which leads to an out-of-bounds read during sdhci_write() operations. A guest OS user can crash the QEMU process.<br />CVE-2020-13754: hw/pci/msix.c allows guest OS users to trigger an out-of-bounds access via a crafted address in an msi-x mmio operation.<br />CVE-2020-14364: An out-of-bounds read/write access flaw was found in the USB emulator. This issue occurs while processing USB packets from a guest when USBDevice ‘setup_len’ exceeds its ‘data_buf&#91;4096&#93;’ in the do_token_in, do_token_out routines. This flaw allows a guest user to crash the QEMU process, resulting in a denial of service, or the potential execution of arbitrary code with the privileges of the QEMU process on the host.<br />CVE-2020-16092: An assertion failure can occur in the network packet processing. This issue affects the vmxnet3 network devices. A malicious guest user/process could use this flaw to abort the QEMU process on the host, resulting in a denial of service condition in net_tx_pkt_add_raw_fragment in hw/net/net_tx_pkt.c.<br />Vulnerable: <= 2.1+dfsg-12+deb8u16<br />Fixed: 2.1+dfsg-12+deb8u17 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553310"></a> [2553310](#2553310) <a name="2553310"></a> <br />CM-31454 | The following vulnerability has been announced in <code>libproxy</code>:<br />CVE-2020-25219: There was a denial of service attack in libproxy, a library to make applications HTTP proxy aware. A remote server could cause an infinite stack recursion.<br />Vulnerable: <= 0.4.11-4<br />Fixed: 0.4.11-4+deb8u1 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553309"></a> [2553309](#2553309) <a name="2553309"></a> <br />CM-31453 | The following vulnerability has been announced in python-pip:<br />CVE-2019-20916: When an URL was given in an install command, as a Content-Disposition HTTP header was permitted to have ../ components in its filename, arbitrary local files (eg. /root/.ssh/authorized_keys) could be overidden.<br />Vulnerable: <= 1.5.6-5<br />Fixed: 1.5.6-5+deb8u1 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553229"></a> [2553229](#2553229) <a name="2553229"></a> <br />CM-31412 | On the Dell N3248PXE switch, RJ45 fixed copper ports that auto-negotiate with a 100M or 10M neighbor incorrectly negotiate a half-duplex link that generates errors. Half duplex modes are not supported on this platform. | 3.7.12-3.7.13, 4.2.1 | 3.7.14, 4.3.0|
| <a name="2553219"></a> [2553219](#2553219) <a name="2553219"></a> <br />CM-31407 | You cannot configure SNMPv3 trap-destinations in non-default VRFs with an authentication username that contains fewer than eight characters. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2553190"></a> [2553190](#2553190) <a name="2553190"></a> <br />CM-31390 | The following vulnerabilities have been announced in libxml2:<br />CVE-2017-8872: Global buffer-overflow in the htmlParseTryOrFinish function.<br />CVE-2019-20388: A memory leak was found in the xmlSchemaValidateStream function of libxml2. Applications that use this library may be vulnerable to memory not being<br />freed leading to a denial of service.<br />CVE-2020-24977: Out-of-bounds read restricted to xmllint --htmlout.<br />CVE-2020-7595: Infinite loop in xmlStringLenDecodeEntities can cause a denial of service.<br />Vulnerable: <= 2.9.1+dfsg1-5+deb8u8<br />Fixed: 2.9.1+dfsg1-5+deb8u9 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553150"></a> [2553150](#2553150) <a name="2553150"></a> <br />CM-31377 | The following vulnerabilities have been announced in libjpeg-turbo:<br />CVE-2020-13790: Heap-based buffer over-read via a PPM input file.<br />CVE-2020-14152: Improper handling of max_memory_to_use setting can lead to excessive memory consumption.<br />Vulnerable: <= 1.3.1-12+deb8u2<br />Fixed: 1.3.1-12+deb8u3 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553116"></a> [2553116](#2553116) <a name="2553116"></a> <br />CM-31357 | When you manually set the link speed or duplex mode with ethtool to an unsupported value, then run a TDR check against the interface, you encounter a <code>switchd</code> service heartbeat failure.<br />To work around this issue, reboot the switch to clear the condition. Avoid setting the interface speed or duplex mode directly with ethtool. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553063"></a> [2553063](#2553063) <a name="2553063"></a> <br />CM-31327 | After you manually edit the <code>/etc/resolv.conf</code> file to change or remove a VRF for a given DNS server, <code>ifreload</code> does not remove IP rules created for DNS servers in the VRF. <br />To work around this issue, run the <code>net add/del dns nameserver vrf <name></code> command to force the DNS configuration. | 3.7.13-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2553050"></a> [2553050](#2553050) <a name="2553050"></a> <br />CM-31322 | SNMP status might incorrectly reflect that a BGP neighbor is down due to an issue between <code>bgpd</code> and SNMP AgentX when the IP-FORWARD-MIB is also polled.<br />To work around this issue, avoid polling IP-FORWARD-MIB objects. | 3.7.12-3.7.14.2 | |
| <a name="2553049"></a> [2553049](#2553049) <a name="2553049"></a> <br />CM-31321 | The following vulnerability has been announced in the libx11 libraries:<br />CVE-2020-14363: Integer overflow in the init_om function of libX11, the X11 client-side library, which could lead to a double free.<br />Vulnerable: <= 1.6.2-3+deb8u3<br />Fixed: 1.6.2-3+deb8u4 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553015"></a> [2553015](#2553015) <a name="2553015"></a> <br />CM-31300 | If a neighbour contains a special character in PortID for LLDP, the <code>net show interface</code> command does not display the LLDP information or the command might fail. | 3.7.10-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2553001"></a> [2553001](#2553001) <a name="2553001"></a> <br />CM-31294 | When the following conditions exist, <code>clagd</code> might fail to establish a TCP control session across the subinterface (such as, peerlink.4094): <br />* <code>clagd</code> uses an IPv6 link-local address (LLA) to establish the TCP connection (the <code>clagd-peer-ip linklocal</code> command configures an IPv6 LLA connection)<br /><br />* Subsequent VLAN changes are made to VLAN sub-interfaces or adding or removing SVIs<br /><br />This issue occurs because the hardware stores one entry per VRF to represent the IPv6 LLA. The hardware entry for the LLA is removed when another interface is changed because the software interfaces are represented by a single entity in hardware. As a result, packets destined to the local IPv6 LLA address are received on the port but do not get forwarded to CPU for further processing.<br /><br />To workaround this issue, use IPv4 addresses under <code>peerlink.4094</code> and configure <code>clagd</code> to peer on IPv4 addresses. | 3.7.12-3.7.13 | 3.7.14-3.7.14.2, 4.2.0-4.3.0|
| <a name="2552954"></a> [2552954](#2552954) <a name="2552954"></a> <br />CM-31274 | The following vulnerability has been announced in the <code>apache2</code> package:<br />CVE-2020-11985: apache2 was vulnerable to IP address spoofing when proxying using mod_remoteip and mod_rewrite.<br />For configurations using proxying with mod_remoteip and certain mod_rewrite rules, an attacker could spoof their IP address for logging and PHP scripts.<br />Vulnerable: <= 2.4.10-10+deb8u16<br />Fixed: 2.4.10-10+deb8u17 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552953"></a> [2552953](#2552953) <a name="2552953"></a> <br />CM-31273 | The following vulnerability has been announced in the bind9 packages:<br />CVE-2020-8622: Crafted responses to TSIG-signed requests could lead to an assertion failure, causing named, a Domain Name Server, to exit. This could be done by malicious server operators or guessing attackers.<br />Vulnerable: <= 9.9.5.dfsg-9+deb8u19<br />Fixed: 9.9.5.dfsg-9+deb8u20 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552952"></a> [2552952](#2552952) <a name="2552952"></a> <br />CM-31272 | The following vulnerability has been announced in the nss / libnss3 packages:<br />CVE-2020-12403: The ChaCha20 symmetric key cipher algorithm did not correctly enforce the tag length which may have led to an out-of-bounds read and a lack of confidentiality.<br />Vulnerable: <= 3.26-1+debu8u12<br />Fixed: 3.26-1+debu8u13 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552939"></a> [2552939](#2552939) <a name="2552939"></a> <br />CM-31263 | RX_DRP on a bond interface increases without any data traffic while the slave port does not increase. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552925"></a> [2552925](#2552925) <a name="2552925"></a> <br />CM-31257 | On the EdgeCore AS-6712-32X, AS5812-54X and AS5812-54T switch models, the temp sensors (DIMM temp sensor) show ABSENT. The amber diagnostic light on the front of the switch might also be turned on due to this issue.<br />These messages and the light are cosmetic issues only and do not otherwise impact the function of the switch. | 3.7.12-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552881"></a> [2552881](#2552881) <a name="2552881"></a> <br />CM-31238 | IPv6 TCP or UDP connections (sourcing from an ephemeral port in the range 34048 to 35071) are not forwarded if the switch has more than one layer 2 VNI defined. The traffic might be locally switched on the bridge and dropped. <br />To work around this issue, disable ARP/ND suppression to remove the internal ACL rule that affects the ports. | 3.7.13, 4.2.1 | 3.7.14, 4.3.0|
| <a name="2552870"></a> [2552870](#2552870) <a name="2552870"></a> <br />CM-31232 | On the  Dell N3048EP switch, the module information from SFP ports is not displayed in the <code>l1-show</code> command.<br />To work around this issue, use the <code>ethtool -m <interface></code> command. | 3.7.13-3.7.14.2 | |
| <a name="2552869"></a> [2552869](#2552869) <a name="2552869"></a> <br />CM-31231 | On the Dell N3048EP switch, the module information from SFP ports is not displayed in the <code>l1-show</code> command.<br />To work around this issue, use the <code>ethtool -m <interface></code> command. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2552860"></a> [2552860](#2552860) <a name="2552860"></a> <br />CM-31226 | Mellanox switches with the Spectrum ASIC fail to read PSU Fan/Temp sensors and report them as Absent. The following messages are observed in syslog:<br /><pre><br />2020-08-21T07:17:39.068160+00:00 cumulus : /usr/sbin/smond : : PSU1Temp1(PSU1 Temp Sensor): state changed from UNKNOWN to ABSENT<br />2020-08-21T07:17:39.068911+00:00 cumulus : /usr/sbin/smond : : PSU2Temp1(PSU2 Temp Sensor): state changed from UNKNOWN to ABSENT<br /></pre> | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552840"></a> [2552840](#2552840) <a name="2552840"></a> <br />CM-31210 | CVE-2020-14350: In PostgreSQL 9.4, an uncontrolled search path could allow users to run arbitrary SQL functions with elevated priviledges when a superuser runs certain 'CREATE EXTENSION’ statements.<br />Vulnerable: <= 9.4.26-0+deb8u2<br />Fixed: 9.4.26-0+deb8u3 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552756"></a> [2552756](#2552756) <a name="2552756"></a> <br />CM-31158 | An issue has been found in python2.7, an interactive high-level object-oriented language.<br />CVE-2019-20907: Opening a crafted tar file could result in an infinite loop due to missing header validation.<br />Vulnerable: <= 2.7.9-2-ds1+deb8u5<br />Fixed: 2.7.9-2-ds1+deb8u6 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552742"></a> [2552742](#2552742) <a name="2552742"></a> <br />CM-31150 | On the Mellanox SN2410 switch, you see <code>switchd</code> core and <code>GBIN_MALLOC</code> errors.<br />To work around this issue, restart <code>switchd</code>. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552739"></a> [2552739](#2552739) <a name="2552739"></a> <br />CM-31148 | Counters for IPROUTER rules do not increase when traffic is forwarded to the CPU because there is no IP neighbor. | 3.7.2-3.7.14.2 | |
| <a name="2552715"></a> [2552715](#2552715) <a name="2552715"></a> <br />CM-31130 | The following vulnerabilities have been announced in the <code>ghostscript</code> package, which is available for optional installation. These vulnerabilities can allow an attacker to elevate privileges or cause a denial of service with crafted PS/EPS/PDF files:<br />CVE-2020-16287 CVE-2020-16288 CVE-2020-16289 CVE-2020-16290 CVE-2020-16291 CVE-2020-16292 CVE-2020-16293 CVE-2020-16294 CVE-2020-16295 CVE-2020-16296 CVE-2020-16297 CVE-2020-16298 CVE-2020-16299 CVE-2020-16300 CVE-2020-16301 CVE-2020-16302 CVE-2020-16303 CVE-2020-16304 CVE-2020-16305 CVE-2020-16306 CVE-2020-16307 CVE-2020-16308 CVE-2020-16309 CVE-2020-16310 CVE-2020-17538<br />Vulnerable: <= 9.26a~dfsg-0+deb8u6<br />Fixed: 9.26a~dfsg-0+deb8u7 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552714"></a> [2552714](#2552714) <a name="2552714"></a> <br />CM-31129 | The following vulnerability has been announced:<br />CVE-2020-17507: A vulnerability was discovered in qt4-x11, the cross-platform C++ application framework, which is available in the repository for optional installation. A specially-crafted XBM image file could have caused a buffer overread.<br />Vulnerable: <= 4.8.6+git64-g5dc8b2b+dfsg-3+deb8u2<br />Fixed: 4.8.6+git64-g5dc8b2b+dfsg-3+deb8u3 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552647"></a> [2552647](#2552647) <a name="2552647"></a> <br />CM-31086 | When you add a member to a bond that has a subinterface configured (such as peerlink.4094), the new member is assigned only the VLAN of the subinterface for forwarding.<br />To work around this issue, bounce the bond or shutdown the new interface and use the remaining members over the bond. | 3.7.10-3.7.13, 4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552632"></a> [2552632](#2552632) <a name="2552632"></a> <br />CM-31073 | When you set the <code>sysctl</code> settings <code>net.ipv6.conf.all.accept_ra_defrtr</code> (to prevent acceptance of IPv6 default route advertisements) and <code>net.ipv6.conf.default.accept_ra_defrtr</code> (set for newly created interfaces), if you create a new virtual interface, any pre-existing interface does not start accepting IPv6 default route avertisements again.<br />To work around this issue, when you create a new virtual interface, set <code>net.ipv6.conf.<interface>.accept_ra_defrtr</code> to 0 for all interfaces and run <code>sysctl -p --system</code>. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552610"></a> [2552610](#2552610) <a name="2552610"></a> <br />CM-31057 | The following vulnerability has been announced:<br />CVE-2019-11360: A buffer overflow in <code>iptables-restore</code> in netfilter iptables 1.8.2 allows an attacker to (at least) crash the program or potentially gain code execution via a specially crafted iptables-save file. This is related to <code>add_param_to_argv</code> in <code>xshared.c</code>. | 3.7.13-4.2.0 | 4.2.1-4.3.0|
| <a name="2552608"></a> [2552608](#2552608) <a name="2552608"></a> <br />CM-31055 | The following vulnerability has been announced:<br />CVE-2019-20892: net-snmp before 5.8.1.pre1 has a double free in usm_free_usmStateReference in snmplib/snmpusm.c via an SNMPv3 GetBulk request. <br />Fixed:  5.8.0-cl4.2.1u1,  5.8.0-cl3.7.14u1 | 3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552528"></a> [2552528](#2552528) <a name="2552528"></a> <br />CM-31028 | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2552506"></a> [2552506](#2552506) <a name="2552506"></a> <br />CM-31016 | Changing the order of the bridge ports might cause the bridge MAC address to change, which flaps the bridge and its ports.<br />To work around this issue, manually set the MAC address of the bridge interface by adding <code>hwaddress <mac-address></code> to the bridge stanza in the <code>/etc/network/interfaces</code> file. | 3.7.11-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552442"></a> [2552442](#2552442) <a name="2552442"></a> <br />CM-30978 | The following vulnerability has been announced in pillow:<br />CVE-2020-10177: Pillow before 7.1.0 has multiple out-of-bounds reads in libImaging/FliDecode.c.<br />The python-pil packages are not installed by default, but are available for optional installation.<br />Vulnerable: <= 2.6.1-2+deb8u4<br />Fixed: 2.6.1-2+deb8u5 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552352"></a> [2552352](#2552352) <a name="2552352"></a> <br />CM-30914 | The following security vulnerabilities have been announced in the nss / libnss3 packages:<br />CVE-2020-6829: Side channel attack on ECDSA signature generation<br />CVE-2020-12400: P-384 and P-521 implementation uses a side-channel vulnerable modular inversion function<br />CVE-2020-12401: ECDSA timing attack mitigation bypass<br />Vulnerable: <= 3.26-1+debu8u11<br />Fixed: 3.26-1+debu8u12 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552351"></a> [2552351](#2552351) <a name="2552351"></a> <br />CM-30913 | The following vulnerability has been announced in the libx11 packages:<br />CVE-2020-14344: The X Input Method (XIM) client implementation in libX11 has some integer overflows and signed/unsigned comparison issues that can lead to heap corruption when handling malformed messages from an input method.<br />Vulnerable: <= 1.6.2-3+deb8u2<br />Fixed: 1.6.2-3+deb8u3 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552318"></a> [2552318](#2552318) <a name="2552318"></a> <br />CM-30895 | Various security vulnerabilities have been fixed in <code>imagemagick</code>, which is available in the repository for optional installation.  The list of CVEs is:<br />CVE-2017-12805 CVE-2017-17681 CVE-2017-18252 CVE-2018-7443 CVE-2018-8804 CVE-2018-8960 CVE-2018-9133 CVE-2018-10177 CVE-2018-18024 CVE-2018-20467 CVE-2019-10131 CVE-2019-11472 CVE-2019-12977 CVE-2019-12978 CVE-2019-12979 CVE-2019-13300 CVE-2019-13307 CVE-2019-13454<br />Vulnerable: <= 6.8.9.9-5+deb8u19<br />Fixed: 6.8.9.9-5+deb8u20 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552302"></a> [2552302](#2552302) <a name="2552302"></a> <br />CM-30885 | On a Mellanox switch with the Spectrum ASIC, you see LPC I2C driver errors similar to the following during boot:<br /><pre><br />Jul 30 23:49:41.651453 mlx-switch systemd&#91;1&#93;: Started udev Kernel Device Manager.<br />Jul 30 23:49:41.654978 mlx-switch systemd&#91;1&#93;: Starting LSB: Set preliminary keymap...<br />Jul 30 23:49:41.668214 mlx-switch kernel: LPCI2C ERR: Invalid flag 0x4 in msg 0<br />Jul 30 23:49:41.668265 mlx-switch kernel: LPCI2C ERR: Incorrect message<br />...<br /></pre> | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552298"></a> [2552298](#2552298) <a name="2552298"></a> <br />CM-30882 | The following vulnerability has been announced in net-snmp:<br />CVE-2020-15862: A privilege escalation involving the NET-SNMP-EXTEND-MIB support (which is enabled by default at compile-time).<br />The fixed versions disable NET-SNMP-EXTEND-MIB support.<br /><br />Vulnerable: <= 5.8.0-cl3u11, <= 5.8.0-cl4u4<br />Fixed: 5.8.0-cl3.7.14u3, 5.8.0-cl4.2.1u1 | 3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552294"></a> [2552294](#2552294) <a name="2552294"></a> <br />CM-30879 | NCLU restarts FRR when removing a BGP VRF IPv4 aggregate-address command.<br />  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552236"></a> [2552236](#2552236) <a name="2552236"></a> <br />CM-30845 | The following vulnerabilities were reported against <code>qemu</code>, which is available in the repository for optional installation:<br />CVE-2020-13659: address_space_map in exec.c in QEMU 4.2.0 can trigger a NULL pointer dereference related to BounceBuffer.<br />CVE-2020-15863: stack-based overflow in xgmac_enet_send() in hw/net/xgmac.c.<br />Vulnerable: <= 2.1+dfsg-12+deb8u15<br />Fixed: 2.1+dfsg-12+deb8u16 | 3.7.12-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552214"></a> [2552214](#2552214) <a name="2552214"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14, 4.1.1-4.3.0 | 3.7.14.2|
| <a name="2552213"></a> [2552213](#2552213) <a name="2552213"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2552206"></a> [2552206](#2552206) <a name="2552206"></a> <br />CM-30827 | If the MAC address of an SVI changes, <code>clagd</code> does not update its permanent neighbor entry for the local interface, and it does not report the change to its MLAG peer. This leaves the MLAG peer in a state where its permanent neighbor for the MLAG peer's SVI IP address continues to use the old MAC address, which causes routed traffic over this SVI to be dropped.<br />To work around this issue, ifdown/ifup the SVI when a MAC address changes. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551912"></a> [2551912](#2551912) <a name="2551912"></a> <br />CM-30580 | <code>ifupdown2</code> does not account for link status or link down configuration when running <code>dhclient</code>. For example, <code>ifupdown2</code> ignores <code>link-down yes</code> during <code>ifup/ifreload</code> and runs the DHCP module if <code>inet dhcp</code> is configured on the interface. <code>ifupdown2</code> also runs the DHCP module even when the physical link configured for DHCP is down. | 3.7.12-4.2.0 | 4.2.1-4.3.0|
| <a name="2551748"></a> [2551748](#2551748) <a name="2551748"></a> <br />CM-30514 | In OVSDB high availability mode, deleting > 200 VLAN bindings might cause <code>ovs-vtepd</code> to crash.  Limit the deletion to 200 or fewer VLAN bindings. | 3.7.12-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2551732"></a> [2551732](#2551732) <a name="2551732"></a> <br />CM-30504 | When the OVSDB VTEP scale increases, the CPU utilization increases and eventually the switch (<code>ptmd</code>) fails to respond to the BFD, causing the BFD session to go down. As a result OVSDB cannot read the BFD socket status and outputs a warning in the <code>ovs-vtepd</code> debugs: <code>PTM socket error: Bad file descriptor</code>. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551729"></a> [2551729](#2551729) <a name="2551729"></a> <br />CM-30503 | In OVSDB high availability mode, if you create, then delete a binding, the FDB entry is not replaced and you see an error. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551715"></a> [2551715](#2551715) <a name="2551715"></a> <br />CM-30498 | There is a change to the default OVSDB bootstrapping process, where the script created now defaults to VLAN-aware bridge mode. If you want to use traditional bride mode, you need to force it by editing the <code>ovs-vtep-ctl</code> script generated by the bootstrap process. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551693"></a> [2551693](#2551693) <a name="2551693"></a> <br />CM-30486 | A host migrated to an 802.1X MAB port within the same broadcast domain fails to have the correct FDB entry installed if a dynamic FDB entry for that MAC address exists from previous connectivity in the broadcast domain.<br />To work around this issue, manually delete the dynamic FDB entry that is associated with the uplink trunk port. | 3.7.12-3.7.13, 4.1.1-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551675"></a> [2551675](#2551675) <a name="2551675"></a> <br />CM-30479 | When you restart <code>clagd</code>, the edge port setting on the peer link changes. | 3.7.2-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551651"></a> [2551651](#2551651) <a name="2551651"></a> <br />CM-30464 | The <code>net show dot1x interface summary</code> command output shows a MAC address with all zeros associated with a port. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551578"></a> [2551578](#2551578) <a name="2551578"></a> <br />CM-30422 | When you configure a bridge in the <code>/etc/network/interfaces</code> file, then try to reconfigure the bridge to be a VRF interface with the same name, <code>ifreload</code>/<code>ifup</code> commands fail with an <code>invalid table id</code> or <code>unable to get vrf table id</code> error. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2551565"></a> [2551565](#2551565) <a name="2551565"></a> <br />CM-30414 | If you toggle VRRP priority values between VRRP routers, then run a <code>switchd</code> restart, a few IPv6 VRRP instances might not converge. As a result, both the VRRP routers act as _master_ routers for the impacted IPv6 VRRP instances. IPv4 VRRP instances are not affected.<br />To work around this issue, remove, then add the VRRP configuration with NCLU commands or vtysh in FRR.<br /> | 3.7.13-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2551305"></a> [2551305](#2551305) <a name="2551305"></a> <br />CM-30296 | The <code>net show configuration</code> command provides the wrong <code>net add</code> command for ACL under the VLAN interface.<br /><br /> | 3.7.12-3.7.14.2, 4.1.0-4.3.0 | |
| <a name="2551288"></a> [2551288](#2551288) <a name="2551288"></a> <br />CM-30286 | When you remove BFD configuration by editing the <code>/etc/frr/frr.conf</code> file and restarting FRR, you see a traceback.<br />To work around this issue, either use NCLU or vtysh commands to remove the BFD configuration, or restart FRR with the new <code>/etc/frr/frr.conf</code> file. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2550974"></a> [2550974](#2550974) <a name="2550974"></a> <br />CM-30195 | On the Dell S3000 switch, after installing the Cumulus Linux 4.1.1 disk image without a license, the switch sends a link beat if a remote host port is configured. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550942"></a> [2550942](#2550942) <a name="2550942"></a> <br />CM-30178 | NCLU tab completion for <code>net show</code> displays the text <code>add help text</code> instead of <code>system Information</code> for the system option. | 3.7.11-4.2.0 | 4.2.1-4.3.0|
| <a name="2550873"></a> [2550873](#2550873) <a name="2550873"></a> <br />CM-30141 | In an MLAG configuration with static VXLAN, static tunnels become unreachable. | 3.7.13, 4.1.1-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2550796"></a> [2550796](#2550796) <a name="2550796"></a> <br />CM-30103 | On a Broadcom switch with the Trident2+ ASIC, ACL rules for VLANs are not applied after a reboot and the counters remain at zero.<br />To work around this issue, either do not set <code>acl.non_atomic_update_mode = TRUE</code> in the <code>/etc/cumulus/switchd.conf</code> file or run the <code>cl-acltool -i</code> command after the reboot to install the  ACLs. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2550793"></a> [2550793](#2550793) <a name="2550793"></a> <br />CM-30101 | The NCLU <code>net show bridge spanning-tree</code> command displays the aging timer incorrectly.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550601"></a> [2550601](#2550601) <a name="2550601"></a> <br />CM-29978 | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | 4.2.1-4.3.0, 4.3.0|
| <a name="2550466"></a> [2550466](#2550466) <a name="2550466"></a> <br />CM-29890 | Multiple paths to identical EVPN prefixes are either not displayed or not accepted into the l2vpn evpn table if they are received from a different AS. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550444"></a> [2550444](#2550444) <a name="2550444"></a> <br />CM-29872 | Tab completion for the <code>net show rollback description</code> command returns information about a snapshot instead of context help.<br />To work around this issue, run the <code>net show commit history</code> command to find descriptions instead of the <code>net show rollback description</code> command. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550443"></a> [2550443](#2550443) <a name="2550443"></a> <br />CM-29871 | The <code>net show rollback description <string></code> command returns an error even if the string matches a commit description.<br />To work around this issue, look for your string in the output of the <code>net show commit history</code> command (or grep for it there) instead. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550375"></a> [2550375](#2550375) <a name="2550375"></a> <br />CM-29838 | CPU utilization may increase when clag-managed bond interfaces are operationally/LACP down but the physical carrier remains up on the bond member switchports. This condition occurs when clag bond redirection is enabled and bond members remain up while the parent bond does not negotiate LACP.<br /><br />This issue is resolved in Cumulus Linux 3.7.14. | 3.7.9-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2550350"></a> [2550350](#2550350) <a name="2550350"></a> <br />CM-29830 | Unicast traffic from downlink hosts is flooded to multiple remote VTEPs, which might also cause high HwIfOutQDrops/TX_DRP on the uplink ports.<br />To work around this issue, restart <code>switchd</code>. | 3.7.10-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2550276"></a> [2550276](#2550276) <a name="2550276"></a> <br />CM-29779 | In LLDP, the <code>snmp</code> subagent loses all subsequent <code>lldpRemSysName</code> (1.0.8802.1.1.2.1.4.1.1.9) entries after an entry with a missing SysName is added.<br />All the information from <code>lldpctl</code> is correct. Only the entries after the entry that is missing a SysName in <code>lldpRemSysName</code> disappear from the <code>snmp</code> subagent. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2550243"></a> [2550243](#2550243) <a name="2550243"></a> <br />CM-29759 | When you use <code>nginx</code> and <code>restserver</code> in management VRF to provide a REST API for the switch, <code>nginx</code> starts but <code>restserver</code> fails to start.<br />To work around this issue, comment out the <code>Requires=</code> line in the <code>/lib/systemd/system/restserver.service</code>. For example:<br /><pre><br />#Requires=nginx.service restserver.socket<br /></pre> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550196"></a> [2550196](#2550196) <a name="2550196"></a> <br />CM-29740 | The <code>exim4</code> package available for optional installation on Cumulus Linux 3.x has the following vulnerability:<br />DLA-2213-1 / CVE-2020-12783: Exim through 4.93 has an out-of-bounds read in the SPA authenticator that could result in SPA/NTLM authentication bypass in auths/spa.c and auths/auth-spa.c.  The spa authentication driver is not enabled by default.<br />Vulnerable: <= 4.84.2-2+deb8u6<br />Fixed: 4.84.2-2+deb8u7 | 3.7.12-3.7.14.2 | |
| <a name="2550056"></a> [2550056](#2550056) <a name="2550056"></a> <br />CM-29652 | The ACCTON-DIAG option under the Cumulus Linux GRUB menu does not work. When you select this option, you see the following error:<br /><pre><br />error: invalid signature.<br />Press any key to continue...<br /></pre> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549925"></a> [2549925](#2549925) <a name="2549925"></a> <br />CM-29594 | When you run an Ansible script to replace the <code>/etc/network/interfaces</code> file, then run the <code>ifreload -a</code> command, you see errors similar to the following:<br /><pre><br />error: swp1s1.2: netlink: cannot set link swp1s1.2 up: operation failed with 'Network is down' (100)<br />warning: cmd '/bin/ip addr del 10.0.0.1/24 dev eth0' failed: returned 2 (RTNETLINK answers: Cannot assign requested address<br /></pre><br />To work around this issue,  run the <code>ifreload -a</code> command a second time. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549872"></a> [2549872](#2549872) <a name="2549872"></a> <br />CM-29562 | If you have an SVI with multiple VRR IP addresses and try to delete one of the VRR configurations, <code>net commit</code> or <code>ifreload -a</code> returns an error. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549859"></a> [2549859](#2549859) <a name="2549859"></a> <br />CM-29556 | The following vulnerability has been announced that affects ntp:<br />CVE-2020-11868: ntpd in ntp before 4.2.8p14 and 4.3.x before 4.3.100 allows an off-path attacker to block unauthenticated synchronization via a server mode packet with a spoofed source IP address, because transmissions are rescheduled even when a packet lacks a valid origin timestamp.<br />This affects: ntp-4.2.8p12 (possibly earlier) and ntp-4.2.8p13<br />The fix for https://bugs.ntp.org/3445 introduced a bug whereby a system that is running ntp-4.2.8p12 or p13 that only has one unauthenticated time source can be attacked in a way that causes the victim's next poll to its source to be delayed, for as long as the attack is maintained.<br />http://support.ntp.org/bin/view/Main/NtpBug3592 gives the following mitigations if it is not possible to upgrade to a version with the fix:<br />* Use authentication with symmetric peers.<br />* Have enough sources of time.  The default NTP configuration in Cumulus Linux has four time sources.<br /><br />Fixed: 4.2.8p12+dfsg-4+cl4u13 | 3.7.12-4.1.1 | 4.2.0-4.3.0|
| <a name="2549838"></a> [2549838](#2549838) <a name="2549838"></a> <br />CM-29546 | In vtysh, if you configure, then remove a layer 3 VNI for a VRF, the VNI is removed from zebra even if the VNI interface still exists in the kernel.<br />If you configure a layer 2 VNI as a layer 3 VNI by mistake, removing the layer 3 VNI binding removes it from zebra but EVPN-learned MACs and neighbors are not installed into the kernel.<br />To work around this issue, delete, then re-add the missing VNI. For example:<br /><pre><br />cumulus&#64;switch:~$ sudo ifdown vni10100<br />cumulus&#64;switch:~$ sudo ifup vni10100<br /></pre><br />If you flap the link with the <code>ip link set vni10100 down; ip link set vni10100 up</code> commands, zebra does not re-add the VNI. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2549794"></a> [2549794](#2549794) <a name="2549794"></a> <br />CM-29525 | The <code>asic-monitor.service</code> fails when you configure <code>/etc/cumulus/datapath/monitor.conf</code> with <code>monitor.histogram_pg.collect.port_group_list  = &#91;all_packet_pg&#93;</code> and there is traffic passing through the buffer. When the service fails, you see the following traceback in <code>journalctl</code>:<br /><pre><br />asic-monitor&#91;7389&#93;: asic-monitor-module INFO: 2020-05-01 18:28:12.548734: Egress queue(s) greater than 500 bytes in monitor port group histogram_pg<br />asic-monitor&#91;7389&#93;: asic-monitor ERROR: ASIC monitor exception: sx_api_port_counter_tc_get failed: Parameter Error<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 139, in <module><br />asic-monitor&#91;7389&#93;: main(sys.argv&#91;1:&#93;)<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 126, in main<br />asic-monitor&#91;7389&#93;: traceback.print_stack()<br />asic-monitor&#91;7389&#93;: Traceback (most recent call last):<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 117, in main<br />asic-monitor&#91;7389&#93;: monitor.run()<br />asic-monitor&#91;7389&#93;: File "/usr/lib/python2.7/dist-packages/cumulus/asic_monitor.py", line 158, in run<br />...<br /></pre> | 3.7.11-3.7.13, 4.1.1-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2549782"></a> [2549782](#2549782) <a name="2549782"></a> <br />CM-29519 | The JSON format output of the <code>net show bgp l2vpn evpn summary</code> command shows the incorrect neighbour state.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549731"></a> [2549731](#2549731) <a name="2549731"></a> <br />CM-29492 | When you create SPAN or ERSPAN rules in ebtables, the action fails to install if it is not in lowercase. Make sure that the SPAN or ERSPAN action is all lowercase; for example:<br /><pre><br />&#91;ebtables&#93;<br />-A FORWARD --in-interface swp10 -j span --dport swp1<br /></pre> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549472"></a> [2549472](#2549472) <a name="2549472"></a> <br />CM-29367 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2549371"></a> [2549371](#2549371) <a name="2549371"></a> <br />CM-29309 | When Optimized Multicast Flooding (OMF) is enabled with the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/switchd.conf</code> file, the switch continues to flood IPv6 multicast traffic to all slave ports when there is no MLD join receive. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549226"></a> [2549226](#2549226) <a name="2549226"></a> <br />CM-29259 | You might see the following <code>gport</code> error messages in <code>switchd.log</code>:<br /><pre><br />2020-04-10T19:50:01.011224+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x800007a find failed<br />2020-04-10T19:50:01.011631+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x8000009 find failed<br /></pre><br />These messages are harmless and can be ignored. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548962"></a> [2548962](#2548962) <a name="2548962"></a> <br />CM-29165 | With FRR or OSPF, you might see an inconsistent link-state advertisement. For example, when you configure the OSPF default originate route as metric-type 1 with a specific metric, Cumulus Linux shows the default originate route as an external metric-type 2 route with the default metric in the database. This issue typically occurs when both IPv4 and IPv6 default routes exist in the routing table. | 3.7.12-4.1.1 | 4.2.0-4.3.0|
| <a name="2548930"></a> [2548930](#2548930) <a name="2548930"></a> <br />CM-29148 | On MLX switches that contain an OSPF IP unnumbered neighborship with a high scale of prefixes being learned, a link flap might cause the neighbor entry to not be programmed in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2548746"></a> [2548746](#2548746) <a name="2548746"></a> <br />CM-29068 | On the Broadcom switch with the Trident3 ASIC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548672"></a> [2548672](#2548672) <a name="2548672"></a> <br />CM-29043 | When a multipath route that contains an EVPN path exists together with an IPv4 BGP path in the VRF, the RMAC to VTEP binding is incorrect. This invalid entry occurs because Cumulus Linux treats IPv4 routes received over the eBGP IPv4 peering incorrectly in the VRF.<br />To work around this issue, remove the unnecessary eBGP IPv4 peering. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548657"></a> [2548657](#2548657) <a name="2548657"></a> <br />CM-29035 | When you upgrade Cumulus Linux on the EdgeCore AS7726-32X or AS7326-56X switch, you might see firmware errors similar to the following:<br /><pre><br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso5.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3.bin for module tg3<br /></pre><br />You can safely ignore these error messages. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548490"></a> [2548490](#2548490) <a name="2548490"></a> <br />CM-28944 | A change in a route map prefix list that should remove a route might not be reflected in the <code>ospf6</code> database or in peers, and the route might not be deleted. <br />To work around this issue, reenter the <code>redistribute <connected\|static> route-map <route-map-name></code> statement in the configuration. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548485"></a> [2548485](#2548485) <a name="2548485"></a> <br />CM-28940 | If you configure <code>aggregate-address <address> summary-only</code> before a component of the same aggregate is injected into the BGP table with the <code>network</code> or <code>redistribute</code> command, when you remove the <code>aggregate-address</code> configuration, the component stays suppressed; it is not advertised to peers. For example:<br />Existing configuration:<br /><pre><br />router bgp 1<br /> address-family ipv4 unicast<br />  aggregate-address 50.0.0.0/8 summary-only<br /> exit-address-family<br /></pre><br />If you add <code>network 50.0.0.1/32</code>, you see the following (expected) BGP table entries:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />*> 50.0.0.0         0.0.0.0                            32768 i<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />Removing <code>aggregate-address 50.0.0.0/8 summary-only</code> at this point results in the following (unexpected) BGP table entry:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />To work around this issue, remove, then re-add the component prefix routes. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548475"></a> [2548475](#2548475) <a name="2548475"></a> <br />CM-28932 | After you add a new VNI and a layer 3 SVI to a set of leafs, certain leafs might not be able to communicate on the layer 3 VNI. <br />To work around this issue, reboot the leaf switch or restart <code>switchd</code>. | 3.7.6-3.7.13 | 3.7.14-3.7.14.2, 4.0.0-4.3.0|
| <a name="2548315"></a> [2548315](#2548315) <a name="2548315"></a> <br />CM-28816 | The following security advisory has been announced for bash: <br />CVE-2019-18276 Qualys scan QID 372268 setuid vulnerability<br />When bash or bash scripts are run setuid, bash is supposed to drop privileges, but does so incorrectly, so that an attacker with command access to the shell can use <code>enable -f</code> for runtime loading of a new builtin that calls <code>setuid()</code> to regain dropped privileges.<br />To work around this issue, do not make bash or bash scripts <code>setuid</code>. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548117"></a> [2548117](#2548117) <a name="2548117"></a> <br />CM-28659 | In OVSDB traditional bridge mode, adding or removing a VLAN binding causes a traffic forwarding outage for around 20 seconds or more on adjacent VLAN bindings. Cumulus Linux does not support _traditional_ bridge mode with VMware NSX. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548024"></a> [2548024](#2548024) <a name="2548024"></a> <br />CM-28596 | On the Dell Z9100 switch, 100G-SR4 modules might not link up reliably in certain ports. <br />swp1, 2, 3, 9, 10, 23, 24, 30, 31, and 32 might be affected<br />To work around this issue, move 100G SR4 modules to one of the ports not affected by this issue. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547942"></a> [2547942](#2547942) <a name="2547942"></a> <br />CM-28533 | On the Lenovo NE0152T switch, one power supply (PSU2) always show as ABSENT in smonctl. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547839"></a> [2547839](#2547839) <a name="2547839"></a> <br />CM-28465 | When you try to configure <code>link-down</code> on a parent interface of a subinterface configured in a VRF, you encounter an error. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547799"></a> [2547799](#2547799) <a name="2547799"></a> <br />CM-28451 | An error similar to the following shows in syslog for Mellanox switches:<br /><pre><br />2020-02-12T19:59:22.208012+08:00 leaf01 sx_sdk: RM_TABLE: No resources available to add 1 entries to KVD hash Table HW resource<br />2020-02-12T19:59:22.208124+08:00 leaf01 sx_sdk: PORT: __port_vport_fid_set err = (No More Resources)<br /></pre><br />To work around this issue, reboot the switch. | 3.7.11-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2547784"></a> [2547784](#2547784) <a name="2547784"></a> <br />CM-28442 | PTM mis-detects incorrect hostnames of LLDP neighbors and does not fail them as expected. Instead they end up in an N/A cabling status. | 3.7.11-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547782"></a> [2547782](#2547782) <a name="2547782"></a> <br />CM-28441 | If a LLDP neighbor advertises a <code>PortDescr</code> that contains commas, <code>ptmctl -d</code> splits the string on the commas and misplaces its components in other columns. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547706"></a> [2547706](#2547706) <a name="2547706"></a> <br />CM-28397 | When you configure ganged ports in the <code>ports.conf</code> file, the change does not take effect after you restart <code>switchd</code>. <br />To work around this issue, reboot the switch. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2547659"></a> [2547659](#2547659) <a name="2547659"></a> <br />CM-28372 | On the EdgeCore AS7326-56X switch, the default fan speed, which is defined in the thermal specification, results in excessive fan noise. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547573"></a> [2547573](#2547573) <a name="2547573"></a> <br />CM-28322 | On Tomahawk switches, when the <code>vxlan_tnl_arp_punt_disable</code> option is set to FALSE, ARP packets are not forwarded to the CPU. | 3.7.9-4.0.1 | 4.1.0-4.3.0|
| <a name="2547443"></a> [2547443](#2547443) <a name="2547443"></a> <br />CM-28248 | On the Dell N3248PXE-ON switch, 25G SFP ports do not work in 10G mode. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547397"></a> [2547397](#2547397) <a name="2547397"></a> <br />CM-28219 | The following vulnerability affects sudo, which is installed by default on Cumulus Linux.  It is potentially exploitable on Cumulus Linux if pwfeedback (which is NOT enabled by default) is enabled in the /etc/sudoers file.<br />CVE-2019-18634: In Sudo before 1.8.26, if pwfeedback is enabled in /etc/sudoers, users can trigger a stack-based buffer overflow in the privileged sudo process. The attacker needs to deliver a long string to the stdin of getln() in tgetpass.c.<br />For more information, refer to:<br />https://security-tracker.debian.org/tracker/source-package/sudo<br />https://security-tracker.debian.org/tracker/CVE-2019-18634<br />https://www.sudo.ws/alerts/pwfeedback.html<br />Vulnerable: <= 1.8.10p4-cl3u6<br />Fixed: 1.8.10p4-cl3.7.14u1 | 3.7.13 | 3.7.14-3.7.14.2|
| <a name="2547381"></a> [2547381](#2547381) <a name="2547381"></a> <br />CM-28212 | The <code>hsflowd</code> service sends an undefined header protocol 0 in the sampled flow sample to the collector, which is not recognized by the sFlow tool. You see errors similar to the following:<br /><pre><br />Dec 20 08:43:27 netflow-nms sfcapd&#91;3991&#93;: SFLOW: readFlowSample_header() undefined headerProtocol = 0<br /></pre><br /> | 3.7.11-3.7.14 | 4.0.0-4.3.0|
| <a name="2547341"></a> [2547341](#2547341) <a name="2547341"></a> <br />CM-28189 | When <code>host-resources</code> and <code>ucd-snmp-mib</code> are polled, you see permission denied messages similar to the following:<br /><pre><br />Jan 30 19:22:53 switch123 snmpd&#91;23172&#93;: Cannot statfs /sys/kernel/debug/tracing: Permission denied<br /></pre> | 3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547246"></a> [2547246](#2547246) <a name="2547246"></a> <br />CM-28136 | The MLAG switch pair has VLANs defined that are not used on MLAG bonds. These VLANs still synchronize MAC addresses across to the peer switch. This results in log messages that indicate a MAC address is installed and the VLAN is not defined; for example:<br /><pre><br />RTM_NEWNEIGH with unconfigured vlan XXXX on port peerlink<br /></pre> | 3.7.10-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547123"></a> [2547123](#2547123) <a name="2547123"></a> <br />CM-28078 | On the Broadcom switch with the Trident3 ASC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547120"></a> [2547120](#2547120) <a name="2547120"></a> <br />CM-28076 | After you hot swap a PSU, the <code>decode-syseeprom -t psuX</code> command shows the old PSU information (such as the serial number), until you run the <code>decode-syseeprom --init</code> command. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547100"></a> [2547100](#2547100) <a name="2547100"></a> <br />CM-28061 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546992"></a> [2546992](#2546992) <a name="2546992"></a> <br />CM-28004 | The wireshark packages (libwireshark5, libwireshark-data, wireshark, wireshark-common) available for optional installation on Cumulus Linux 3 are vulnerable to CVE-2018-12086: Buffer overflow in OPC UA applications allows remote attackers to trigger a stack overflow with carefully structured requests.  More information at https://www.wireshark.org/security/wnpa-sec-2018-50.html and https://security-tracker.debian.org/tracker/CVE-2018-12086 . | 3.7.11-3.7.14.2 | |
| <a name="2546991"></a> [2546991](#2546991) <a name="2546991"></a> <br />CM-28003 | The FRR service does not provide a way for automation to know if the configuration applied properly.<br />To work around this issue, execute the <code>vtysh -f <file></code> command in the automation file before starting the FRR service to validate the functional configuration and return an error code. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546989"></a> [2546989](#2546989) <a name="2546989"></a> <br />CM-28001 | The libxen packages are not installed on the switch by default, but are available in the repository for optional installation.<br /><br />Customers who optionally install the libxen packages should be aware of the following security advisory.<br /><br />Debian Security Advisory DSA-4602-1<br />CVE-2019-17349 CVE-2019-17350 CVE-2019-18420 CVE-2019-18421<br />CVE-2019-18422 CVE-2019-18423 CVE-2019-18424 CVE-2019-18425<br />CVE-2019-19577 CVE-2019-19578 CVE-2019-19579 CVE-2019-19580<br />CVE-2019-19581 CVE-2019-19582 CVE-2019-19583 CVE-2018-12207<br />CVE-2018-12126 CVE-2018-12127 CVE-2018-12130 CVE-2019-11091<br />CVE-2019-11135 CVE-2019-17348 CVE-2019-17347 CVE-2019-17346<br />CVE-2019-17345 CVE-2019-17344 CVE-2019-17343 CVE-2019-17342<br />CVE-2019-17341 CVE-2019-17340<br /><br />Multiple vulnerabilities have been discovered in the Xen hypervisor, which<br />could result in denial of service, guest-to-host privilege escalation or<br />information leaks.<br /><br />For more information, see https://security-tracker.debian.org/tracker/xen | 3.7.11-3.7.14.2 | |
| <a name="2546895"></a> [2546895](#2546895) <a name="2546895"></a> <br />CM-27957 | If you have configured a higher number of ports and VLANs (ports x VLANs) or the switch is a lower-powered (CPU) platform, the <code>switchd</code> service might fail to send a <code>systemd keepalive</code> within the watchdog timeout value (2 minutes by default) and you see an error similar to the following:<br /><pre><br />bq. systemd&#91;1&#93;: switchd.service watchdog timeout (limit 2min)!<br /></pre><br />To workaround this issue, either reduce the number of configured interfaces and, or VLANs, or increase the <code>systemd</code> timeout for <code>switchd.service</code>.<br />To increase the <code>systemd</code> timeout:<br /># Edit the <code>/etc/systemd/system/switchd.service.d/override.conf</code> file and increase the <code>WatchdogSec</code> parameter.<br /># Restart the <code>switchd</code> service with the <code>sudo systemctl restart switchd.service</code> command.<br /><code>systemd</code> will attempt to restart the <code>switchd</code> service automatically (after the watchdog timeout). If the restart fails multiple times in a short time period, run the <code>sudo systemctl reset-failed</code> command followed by the <code>sudo systemctl restart switchd</code> command.<br /> | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546848"></a> [2546848](#2546848) <a name="2546848"></a> <br />CM-27937 | Debian security advisory DSA-4213 for qemu lists a number of security vulnerabilities.<br />https://www.debian.org/security/2018/dsa-4213<br />One of the listed vulnerabilities is still present in the latest upstream version 2.1+dfsg-12+deb8u12 (the others have been fixed):<br />CVE-2017-15124 Daniel Berrange discovered that the integrated VNC server insufficiently restricted memory allocation, which could result in denial of service.<br />https://security-tracker.debian.org/tracker/CVE-2017-15124 | 3.7.11-3.7.14.2 | |
| <a name="2546577"></a> [2546577](#2546577) <a name="2546577"></a> <br />CM-27814 | A traditional bridge with QinQ and a VNI does not work for tagged traffic. | 3.7.10-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2546542"></a> [2546542](#2546542) <a name="2546542"></a> <br />CM-27793 | A security vulnerability has been announced in the cyrus-sasl2 (libsasl2-2 and libsasl2-modules) package. The libraries are installed by default on Cumulus Linux.<br />CVE-2019-19906: Stephan Zeisberg reported an out-of-bounds write vulnerability in the _sasl_add_string() function in cyrus-sasl2, a library implementing the Simple Authentication and Security Layer. A remote attacker can take advantage of this issue to cause denial-of-service conditions for applications using the library.<br />Vulnerable: 2.1.27+dfsg-1<br />Fixed: 2.1.27+dfsg-1+deb10u1 | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2546385"></a> [2546385](#2546385) <a name="2546385"></a> <br />CM-27698 | SNMP ifLastChange reports link transitions when there are none. | 3.7.6-3.7.14.2 | |
| <a name="2546225"></a> [2546225](#2546225) <a name="2546225"></a> <br />CM-27627 | When you execute the following command on the Delta AG6248C switch, the switch reboots and then comes right back into Cumulus Linux without installing the new image. The install image is still in <code>/var/lib/cumulus/installer</code>, which causes issues with cl-support. <br /> <pre> <br /> sudo onie-install -fai http://<path to image> <br /> sudo reboot <br /> </pre> <br /> To work around this issue, use the <code>onie-select</code> command to access ONIE, and then use the <code>nos-install</code> command in ONIE to install a new binary image.  | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546203"></a> [2546203](#2546203) <a name="2546203"></a> <br />CM-27620 | When using QinQ with a traditional bridge, if you enable the LLDP dot1 TLV option, you see the following suboptimal behavior:<br />* Both the inner and outer VLAN information is sent as part of VLAN TLVs in the LLDP packet. <br />* If the outer VLAN ID is the same as the inner VLAN ID, only one VLAN TLV is sent with that VLAN ID in the LLDP packet. | 3.7.11-3.7.14.2 | |
| <a name="2546131"></a> [2546131](#2546131) <a name="2546131"></a> <br />CM-27581 | On the Delta AG-6248C PoE switch, when you run the <code>apt upgrade</code> command, the upgrade does not work. Cumulus Linux uses <code>uboot</code> directly instead of <code>grub</code> to boot the kernel. Uboot needs a special header to boot the kernel, which is not present. Without this header, when you use the <code>apt upgrade</code> command to upgrade Linux packages, <code>uboot</code> is unable to boot up the kernel. <br />To work around this issue, upgrade Cumulus Linux by installing the Cumulus Linux image. Run the <code>onie-select</code> command to go into ONIE, and then use the <code>nos-install</code> command in ONIE to install a new image.<br />This workaround only works when an out-of-band network is present. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546010"></a> [2546010](#2546010) <a name="2546010"></a> <br />CM-27530 | When <code>hal.bcm.per_vlan_router_mac_lookup</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file, inter-VLAN traffic is forwarded to the CPU when associated VNI interfaces exist. | 3.7.10-3.7.14.2 | |
| <a name="2545997"></a> [2545997](#2545997) <a name="2545997"></a> <br />CM-27522 | The NCLU command <code>net show interface</code> produces an error if bonds with no members exist.<br />To work around this issue, remove the empty Bond interfaces from the <code>/etc/network/interfaces</code> file and run <code>sudo ifreload -a</code>. | 3.7.10-3.7.14.2 | |
| <a name="2545934"></a> [2545934](#2545934) <a name="2545934"></a> <br />CM-27489 | Mellanox switches might experience higher CPU usage from the <code>sx_sdk</code> service or when BFD is in use.<br />To work around this issue, disable BFD to alleviate some of the CPU load. | 3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2545699"></a> [2545699](#2545699) <a name="2545699"></a> <br />CM-27354 | On the Celestica Pebble switch, if you use IPv6 routes with mask /65 to /127,  the <code>switchd</code> log fills with errors. | 3.7.10-3.7.13 | 3.7.14-3.7.14.2, 4.1.0-4.3.0|
| <a name="2545566"></a> [2545566](#2545566) <a name="2545566"></a> <br />CM-27272 | The Dell Z9100-ON switch incorrectly reports many sensors as ABSENT. | 3.7.12-4.0.1 | 4.1.0-4.3.0|
| <a name="2545446"></a> [2545446](#2545446) <a name="2545446"></a> <br />CM-27192 | If you use NCLU commands to add a non-MLAG bond, then add an MLAG configuration, the <code>net commit</code> command fails. However, a subsequent <code>net commit</code> command succeeds. | 3.7.10-3.7.14.2 | |
| <a name="2545404"></a> [2545404](#2545404) <a name="2545404"></a> <br />CM-27173 | On the Trident3 switch, unicast ARP packets received on a VNI and forwarded to the CPU are not policed. | 3.7.10-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2545125"></a> [2545125](#2545125) <a name="2545125"></a> <br />CM-27018 | If you configure more than one VRR interface on an SVI interface, deleting one of the VRR addresses does not remove the interface/address.  | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544978"></a> [2544978](#2544978) <a name="2544978"></a> <br />CM-26921 | If you delete an undefined bond, then add a bond slave, the <code>net commit</code> command fails. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544968"></a> [2544968](#2544968) <a name="2544968"></a> <br />CM-26913 | FRR configuration commands for an SVI interface might have the <code>\n</code> misplaced in the output.  For example:<br /><pre><br />sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />should be:<br /><pre><br />sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />To work around this issue, configure the interface manually in the <code>/etc/frr/frr.conf</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544953"></a> [2544953](#2544953) <a name="2544953"></a> <br />CM-26905 | When you update the hostname of a switch with the NCLU <code>net add hostname <hostname></code> command, then run <code>net commit</code>, the <code>lldpd</code> service does not restart and other devices still see the old hostname.<br />To work around this issue, run the <code>sudo systemctl restart lldpd.service</code> command. | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544904"></a> [2544904](#2544904) <a name="2544904"></a> <br />CM-26875 | After you delete an IPv6 numbered BGP peer group neighbor, Cumulus Linux might continue to send route advertisements.<br />To work around this issue, restart FRR after removing the IPv6 numbered configuration. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544556"></a> [2544556](#2544556) <a name="2544556"></a> <br />CM-26655 | If you reconfigure an NTP server with NCLU using different trailing options after the IP address (such as <code>iburst</code>), an invalid configuration is added to the <code>/etc/ntp.conf</code> file. For example:<br /><pre><br />net add time ntp server 1.2.3.4 iburst<br />net commit<br />net add time ntp server 1.2.3.4<br />net commit<br /></pre><br />If you need to alter existing server configurations, first remove the server, commit, then re-add the server with any trailing options. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544463"></a> [2544463](#2544463) <a name="2544463"></a> <br />CM-26599 | Auto-negotiation does not work with the QSFP28 cables and a remote system operating at 10G. Attempting to enable auto-negotiation with <code>ethtool -s swp<#> autoneg on</code> returns <code>Operation not supported</code>.<br />To work around this issue, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544456"></a> [2544456](#2544456) <a name="2544456"></a> <br />CM-26595 | The NCLU <code>net show lldp</code> command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544235"></a> [2544235](#2544235) <a name="2544235"></a> <br />CM-26463 | The following CVEs affect the linux kernel package:<br />CVE-2019-14821 CVE-2019-14835 CVE-2019-15117 CVE-2019-15118 CVE-2019-15902<br />Several vulnerabilities have been discovered in the Linux kernel that<br />may lead to a privilege escalation, denial of service or information<br />leaks.<br />For the detailed security status of linux,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/linux | 3.7.10-3.7.14.2 | |
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544113"></a> [2544113](#2544113) <a name="2544113"></a> <br />CM-26412 | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address changing between the MLAG bond and the peer link.<br />To work around this issue, disable MAC learning on QinQ VLANs by adding <code>bridge-learning off</code> to the VLAN stanza in the <code>etc/network/interfaces</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543900"></a> [2543900](#2543900) <a name="2543900"></a> <br />CM-26288 | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543841"></a> [2543841](#2543841) <a name="2543841"></a> <br />CM-26256 | The <code>net show evpn vni detail json</code> command includes an extra empty dictionary at the end of the output. <br /> | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543800"></a> [2543800](#2543800) <a name="2543800"></a> <br />CM-26230 | When <code>local-tunnelip</code> is an SVI, the static VXLAN tunnel does not work; the next hop router receives the packet but drops it as it does not know where to forward the packet. The static VXLAN tunnel does works if <code>local-tunnelip</code> is a loopback or a physical layer 3 interface. <br /> | 3.7.8-3.7.14 | 4.0.0-4.3.0|
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | 4.3.0|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543627"></a> [2543627](#2543627) <a name="2543627"></a> <br />CM-26126 | Tomahawk 40G DACs cannot disable auto-negotiation. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543270"></a> [2543270](#2543270) <a name="2543270"></a> <br />CM-25923 | The default route injected through OSPF when you configure <code>default-information originate always</code> is unreliable and might age out unexpectedly.<br />To work around this issue, rely on a different source of default route other than injection with <code>default-information originate</code>. | 3.7.8-4.1.1 | 4.2.0-4.3.0|
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543058"></a> [2543058](#2543058) <a name="2543058"></a> <br />CM-25798 | The IP neighbor entry for a link-local next hop is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces.<br />To work around this issue, flap the peering to the peer router (which might be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543052"></a> [2543052](#2543052) <a name="2543052"></a> <br />CM-25796 | Received EVPN type-5 and type-2 MACIP routes are not installed in the kernel (and hardware) routing tables for the associated VRF, which causes traffic to be blackholed. The failure to install the default route causes complete reachability failure for the particular tenant on the affected racks. The routes that are not installed are seen as "inactive" in the routing subsystem (FRR) VRF routing table. This problem is rare and can occur only in EVPN configurations that have user-configured route targets (RTs) for tenant VRFs, and only following a restart of FRR.<br />To work around this issue, either restart the FRR service on the affected switch with the <code>sudo systemctl restart frr.service</code> command or bounce the layer 3 SVI for the affected VRF; for example:<br /><pre><br />ifdown vlan123 ; sleep 2 ; ifup vlan123<br /></pre><br />You can run the <code>net show vrf vni</code> command to print a mapping of VRF : L3-VNI : L3-SVI. | 3.7.5-3.7.14 | 4.0.0-4.3.0|
| <a name="2543044"></a> [2543044](#2543044) <a name="2543044"></a> <br />CM-25794 | Under certain conditions, EVPN next hops might not be removed when the contributing peer goes down or might not be populated when the BGP session to the contributing peer comes up.<br />You can prevent EVPN next hops from not being removed when the contributing peer goes down by specifying static MAC addresses on all layer 3 VNIs. There is no workaround for preventing EVPN next hops from not being populated when the BGP session to the contributing peer comes up. | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2542979"></a> [2542979](#2542979) <a name="2542979"></a> <br />CM-25766 | On the Dell-N3048EP-ON switch, when you run the <code>sudo -E apt upgrade</code> command, the upgrade does not work.  | 3.7.7-4.1.1 | 4.2.0-4.3.0|
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542310"></a> [2542310](#2542310) <a name="2542310"></a> <br />CM-25404 | <code>hsflow</code> disregards the setting for <code>agent.cidr</code> in the <code>/etc/hsflowd.conf</code> file and selects an IPv6 agent address. The source IP address of the hsflowd packet is IPv4, but the agent address in the <code>hsflow</code> payload shows IPv6. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541165"></a> [2541165](#2541165) <a name="2541165"></a> <br />CM-24878 | On the Dell N3048EP-ON switch, UPOE is supported only on ports 1 thru 12. (UPOE uses all four pairs of standard Ethernet cabling whereas PoE delivers power over two twisted pairs.) When you plug a UPOE device in a port higher than port 12, <code>poectl</code> reports that <code>four_pair_mode_enabled</code> is true. However, this configuration is not supported on the port so <code>poectl</code> should report that <code>four_pair_mode_enabled</code> is false. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540950"></a> [2540950](#2540950) <a name="2540950"></a> <br />CM-24751 | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switch, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status.<br />  | 3.7.3-4.1.1 | 4.2.0-4.3.0|
| <a name="2540885"></a> [2540885](#2540885) <a name="2540885"></a> <br />CM-24703 | The Dell N3048EP-ON switch does not support 1G Base-T modules in the SFP ports. | 3.7.7-3.7.14.2 | |
| <a name="2540863"></a> [2540863](#2540863) <a name="2540863"></a> <br />CM-24686 | On the EdgeCore AS5812-54X switch, the PSU2 Fan1 fluctuates between OK and LOW. When the fan speed is reported as LOW, the RPM is shown as a negative number. <br /> | 3.7.3-3.7.14 | 4.0.0-4.3.0|
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539081"></a> [2539081](#2539081) <a name="2539081"></a> <br />CM-23792 | When you delete post-up and pre-down IP peer entries from the <code>etc/network/interfaces</code> file, then run the <code>ifreload</code> command, the IP addresses are not removed and the route remains in the route table. <br />To work around this issue, either delete the IP addresses without the /32 mask component or flush the IP addresses for the interface with the <code>ip addr flush dev <interface></code> command. <br /> | 3.7.0-3.7.14 | 4.0.0-4.3.0|
| <a name="2538875"></a> [2538875](#2538875) <a name="2538875"></a> <br />CM-23696 | IPv6 multicast traffic destined to an unregistered multicast group is flooded to all ports in a bridge despite the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/swichd.conf</code> file. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538302"></a> [2538302](#2538302) <a name="2538302"></a> <br />CM-23422 | <code>portwd</code> allows an error to change the module type based on the error. For example, a bad write to a module might cause the module type to flap, which causes the link itself to flap. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538256"></a> [2538256](#2538256) <a name="2538256"></a> <br />CM-23397 | On the Broadcom switch, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets. <br />  | 3.7.2-4.0.1 | 4.1.0-4.3.0|
| <a name="2537823"></a> [2537823](#2537823) <a name="2537823"></a> <br />CM-23125 | The OpenSSL package on Cumulus Linux 3.x has a vulnerability similar to CVE-2018-0734. (The OpenSSL DSA signature algorithm has been shown to be vulnerable to a timing side channel attack. An attacker could use variations in the signing algorithm to recover the private key).  According to Debian upstream, this version "is not vulnerable &#91;to CVE-2018-0734 exactly&#93;. Nevertheless, there is a bug fix that futher reduces the amount of leaked timing information. It got no CVE on its own and introduced this vulnerability."<br />Vulnerable on CL3: 1.0.1t-1+deb8u12 | 3.7.11-3.7.14.2 | |
| <a name="2537820"></a> [2537820](#2537820) <a name="2537820"></a> <br />CM-23123 | When you enable FEC (RS or BaseR) on an interface, removing the configuration from that interface does not revert the FEC status to off/none. <br /> | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537544"></a> [2537544](#2537544) <a name="2537544"></a> <br />CM-23021 | When you run the <code>mstpctl</code> command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of <code>mstpctl</code>; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | 4.3.0|
| <a name="2537514"></a> [2537514](#2537514) <a name="2537514"></a> <br />CM-23004 | The local fallback account authenticates using the local password when the RADIUS or TACACS service is up. The expected behavior is for this to fail and only succeed when the RADIUS OR TACACS server fails to respond. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537378"></a> [2537378](#2537378) <a name="2537378"></a> <br />CM-22937 | NCLU SNMPv3 user configuration (add, delete, modify) does not complete. Changes are made to the <code>/etc/snmp/snmpd.conf</code> file but the SNMPv3 user cache file <code>/var/lib/snmp/snmpd.conf</code> fails to update correctly and the configuration does not reflect in operation. <br />To work around this issue, stop <code>snmpd</code>, remove the cache file, then restart <code>snmpd</code>. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537188"></a> [2537188](#2537188) <a name="2537188"></a> <br />CM-22849 | When an event in the network, such as a <code>switchd</code> or networking service restart, leads to an OVSDB server high availability transition, an <code>ovs-vtepd</code> core might occur. <br />This core generation has no effect on the functionality of high availability when the active OVSDB server is back in the network. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2537104"></a> [2537104](#2537104) <a name="2537104"></a> <br />CM-22808 | When you try to stop <code>hsflowd</code> on the Trident II+ switch with the <code>systemctl stop hsflowd</code> command, the process hangs until you stop it with <code>SIGKILL</code>. <br /> | 3.7.1-3.7.14 | 4.0.0-4.3.0|
| <a name="2537061"></a> [2537061](#2537061) <a name="2537061"></a> <br />CM-22794 | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent. <br /> | 3.7.1-4.0.1 | 4.1.0-4.3.0|
| <a name="2536608"></a> [2536608](#2536608) <a name="2536608"></a> <br />CM-22583 | Single tagged ARP requests received on a QinQ-over-VXLAN access port are dropped if ARP suppression is enabled on an unrelated VNI. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on protocol sockets.<br />When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a <code>switchd</code> restart. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535965"></a> [2535965](#2535965) <a name="2535965"></a> <br />CM-22020 | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br />To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2534394"></a> [2534394](#2534394) <a name="2534394"></a> <br />CM-20480 | The python-crypto package, which is not installed by default on Cumulus Linux, but is present in the repository to be installed, has the following security vulnerability in the version available for Cumulus Linux 3.x:<br />CVE-2018-6594: lib/Crypto/PublicKey/ElGamal.py in PyCrypto through 2.6.1 generates weak ElGamal key parameters, which allows attackers to obtain sensitive information by reading ciphertext data (i.e., it does not have semantic security in face of a ciphertext-only attack). The Decisional Diffie-Hellman (DDH) assumption does not hold for PyCrypto's ElGamal implementation.<br />More information at https://security-tracker.debian.org/tracker/CVE-2018-6594 . | 3.7.9-3.7.14.2 | |
| <a name="2533691"></a> [2533691](#2533691) <a name="2533691"></a> <br />CM-19788 | If you configure a VLAN under a VLAN-aware bridge and create a subinterface of the same VLAN on one of the bridge ports, the bridge and interface compete for the same VLAN and if the interface is flapped, it stops working. Correcting the configuration and running the <code>ifreload</code> command does not resolve the conflict. <br />To work around this issue, correct the bridge VIDs and restart <code>switchd</code> or delete the subinterface.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2532017"></a> [2532017](#2532017) <a name="2532017"></a> <br />CM-18192 | In FRR, <code>bgp_snmp</code> does not show all BGP peers when peer groups used. | 3.7.11-4.0.1 | 4.1.0-4.3.0|

### Fixed Issues in 3.7.13
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="2552187"></a> [2552187](#2552187) <a name="2552187"></a> <br />CM-30818 | The following vulnerabilities have been announced in <code>librsvg</code>, which is available in the repository for optional installation:<br />CVE-2016-6163: The rsvg_pattern_fix_fallback function in rsvg-paint_server.c in librsvg2 2.40.2 allows remote attackers to cause a denial of service (out-of-bounds read) via a crafted svg file.<br />CVE-2019-20446: In xml.rs in GNOME librsvg before 2.46.2, a crafted SVG file with nested patterns can cause denial of service when passed to the library for processing. The attacker constructs pattern elements so that the number of final rendered objects grows exponentially.<br />Vulnerable: <= 2.40.5-1+deb8u2<br />Fixed: 2.40.5-1+deb8u3 | 3.7.12 | |
| <a name="2551916"></a> [2551916](#2551916) <a name="2551916"></a> <br />CM-30582 | The following vulnerability has been announced in glib-networking, which is not installed by default, but is available in the repository for optional installation.<br />CVE-2020-13645: In GNOME glib-networking through 2.64.2, the implementation of GTlsClientConnection skips hostname verification of the server's TLS certificate if the application fails to specify the expected server identity. This is in contrast to its intended documented behavior, to fail the certificate verification. <br />Vulnerable: 2.42.0-2<br />Fixed: 2.42.0-2+deb8u1 | 3.7.12 | |
| <a name="2551915"></a> [2551915](#2551915) <a name="2551915"></a> <br />CM-30581 | The following vulnerabilities have been announced in NGINX, which is installed by default on Cumulus Linux (however, the default nginx configuration is not vulnerable, since it does not configure error_page redirection or use lua):<br />CVE-2019-20372: NGINX before 1.17.7, with certain error_page configurations, allows HTTP request smuggling, as demonstrated by the ability of an attacker to read unauthorized web pages in environments where NGINX is being fronted by a load balancer.<br />CVE-2020-11724: An issue was discovered in OpenResty before 1.15.8.4. ngx_http_lua_subrequest.c allows HTTP request smuggling, as demonstrated by the ngx.location.capture API.<br />Vulnerable: <= 1.6.2-5+deb8u6<br />Fixed: 1.6.2-5+deb8u7 | 3.7.12 | |
| <a name="2551780"></a> [2551780](#2551780) <a name="2551780"></a> <br />CM-30533 | CVE-2020-15389: jp2/opj_decompress.c in OpenJPEG through 2.3.1 has a use-after-free that can be triggered if there is a mix of valid and invalid files in a directory operated on by the decompressor. Triggering a double-free may also be possible. This is related to calling opj_image_destroy twice.<br />Vulnerable: <= 2.1.0-2+deb8u10<br />Fixed: 2.1.0-2+deb8u11 | 3.7.12 | |
| <a name="2551779"></a> [2551779](#2551779) <a name="2551779"></a> <br />CM-30532 | Several issues were discovered in Python 3.4, an interactive high-level object-oriented language, that allow an attacker to cause denial of service, trafic redirection, header injection and cross-site scripting.<br />CVE-2013-1753: The gzip_decode function in the xmlrpc client library allows remote attackers to cause a denial of service (memory consumption) via a crafted HTTP request.<br />CVE-2016-1000110:The CGIHandler class does not protect against the HTTP_PROXY variable name clash in a CGI script, which could allow a remote attacker to redirect HTTP requests.<br />CVE-2019-16935:The documentation XML-RPC server has XSS via the server_title field. This occurs in Lib/xmlrpc/server.py. If set_server_title is called with untrusted input, arbitrary JavaScript can be delivered to clients that visit the http URL for this server.<br />CVE-2019-18348: In urllib2, CRLF injection is possible if the attacker controls a url parameter, as demonstrated by the first argument to urllib.request.urlopen with \r\n (specifically in the host component of a URL) followed by an HTTP header.<br />CVE-2020-8492: Python allows an HTTP server to conduct Regular Expression Denial of Service (ReDoS) attacks against a client because of urllib.request.AbstractBasicAuthHandler catastrophic backtracking.<br />CVE-2020-14422: Lib/ipaddress.py improperly computes hash values in the IPv4Interface and IPv6Interface classes, which might allow a remote attacker to cause a denial of service if an application is affected by the performance of a dictionary containing IPv4Interface or IPv6Interface objects, and this attacker can cause many dictionary entries to be created.<br />Vulnerable: <= 3.4.2-1+deb8u7<br />Fixed: 3.4.2-1+deb8u8 | 3.7.12 | |
| <a name="2551778"></a> [2551778](#2551778) <a name="2551778"></a> <br />CM-30531 | Several vulnerabilities where found in Perl's regular expression compiler. An application that compiles untrusted regular expressions could be exploited to cause denial of service or code injection.<br />It is discouraged to allow untrusted regular expressions to be compiled by Perl.<br />CVE-2020-10543: Perl before 5.30.3 on 32-bit platforms allows a heap-based buffer overflow because nested regular expression quantifiers have an integer overflow.<br />CVE-2020-10878: Perl before 5.30.3 has an integer overflow related to mishandling of a "PL_regkind&#91;OP(n)&#93; == NOTHING" situation. A crafted regular expression could lead to malformed bytecode with a possibility of instruction injection.<br />CVE-2020-12723: regcomp.c in Perl before 5.30.3 allows a buffer overflow via a crafted regular expression because of recursive S_study_chunk calls.<br />Vulnerable: <= 5.20.2-3+deb8u12<br />Fixed: 5.20.2-3+deb8u13 | 3.7.12 | |
| <a name="2551708"></a> [2551708](#2551708) <a name="2551708"></a> <br />CM-30494 | On the Mellanox switch with the Spectrum and Spectrum-2 ASIC, IPv6 egress ACLs are not supported on subinterfaces. |  | |
| <a name="2551543"></a> [2551543](#2551543) <a name="2551543"></a> <br />CM-30403 | <code>switchd</code> might crash if more than 16 IPv6 default route next hops are installed in the kernel routing table and those 16 next hops recurse to MAC address table entries reachable over VXLAN VNI interfaces. This can occur when many IPv6 router advertisements (RAs) are received across VLAN interfaces that have IPv6 forwarding disabled.<br />To work around this issue, add the following parameters to the <code>/etc/sysctl.conf</code> file to disable IPv6 default route installation from received router advertisements, then run the <code>sudo sysctl -p --system</code> command.<br /><pre><br />net.ipv6.conf.all.accept_ra_defrtr = 0 <br />net.ipv6.conf.default.accept_ra_defrtr = 0<br /></pre> | 3.7.12 | |
| <a name="2551395"></a> [2551395](#2551395) <a name="2551395"></a> <br />CM-30343 | The <code>libnss3</code> package, available for optional installation on Cumulus Linux, has the following vulnerabilities:<br />CVE-2020-12399: Timing differences when performing DSA signatures.<br />CVE-2020-12402: Side channel vulnerabilities during RSA key generation.<br />Vulnerable: <= 3.26-1+deb8u10<br />Fixed: 3.26-1+deb8u11 | 3.7.12 | |
| <a name="2551356"></a> [2551356](#2551356) <a name="2551356"></a> <br />CM-30325 | The following vulnerabilities have been announced in the <code>qemu</code> package, which is available in the repository for optional installation on Cumulus Linux:<br />CVE-2020-1983: slirp: Fix use-after-free in ip_reass().<br />CVE-2020-13361: es1370_transfer_audio in hw/audio/es1370.c allowed guest OS users to trigger an out-of-bounds access during an es1370_write() operation.<br />CVE-2020-13362: megasas_lookup_frame in hw/scsi/megasas.c had an out-of-bounds read via a crafted reply_queue_head field from a guest OS user.<br />CVE-2020-13765: hw/core/loader: Fix possible crash in rom_copy().<br />Vulnerable: <= 2.1+dfsg-12+deb8u14<br />Fixed: 2.1+dfsg-12+deb8u15 | 3.7.12 | |
| <a name="2551351"></a> [2551351](#2551351) <a name="2551351"></a> <br />CM-30321 | CVE-2018-6381 CVE-2018-6484 CVE-2018-6540 CVE-2018-6541 CVE-2018-6869 CVE-2018-7725 CVE-2018-7726 CVE-2018-16548<br />Several issues have been fixed in <code>zziplib</code>, a library providing read access on ZIP-archives. They are all related to invalid memory access and resulting crash or memory leak.<br />libzzip-0-13 is not installed by default on Cumulus Linux, but is available in the repository for optional installation.<br />Vulnerable: <= 0.13.62-3+deb8u1<br />Fixed: 0.13.62-3+deb8u2 | 3.7.12 | |
| <a name="2551350"></a> [2551350](#2551350) <a name="2551350"></a> <br />CM-30320 | CVE-2017-10790: The _asn1_check_identifier function in GNU Libtasn1 through 4.12 causes a NULL pointer dereference and crash when reading crafted input that triggers assignment of a NULL value within an asn1_node structure. It may lead to a remote denial of service attack.<br />Vulnerable: <= 4.2-3+deb8u3<br />Fixed: 4.2-3+dev8u4 | 3.7.12 | |
| <a name="2551259"></a> [2551259](#2551259) <a name="2551259"></a> <br />CM-30274 | CVE-2016-2774: ISC DHCP 4.1.x before 4.1-ESV-R13 and 4.2.x and 4.3.x before 4.3.4 does not restrict the number of concurrent TCP sessions, which allows remote attackers to cause a denial of service (INSIST assertion failure or request-processing outage) by establishing many sessions.<br /><br />On Cumulus Linux, the isc-dhcp-server is installed by default, but is not enabled by default.<br /><br />Vulnerable: <= 4.3.1-6-cl3u14<br />Fixed: 4.3.1-6-cl3u15 | 3.7.12 | |
| <a name="2551162"></a> [2551162](#2551162) <a name="2551162"></a> <br />CM-30240 | <code>switchd</code> memory utilization might continue to increase if there are excessive and continuous link flaps over a long period of time.<br />To work around this issue, correct the cause of the frequent link flaps. You can restart <code>switchd</code> with the <code>sudo systemctl restart switchd</code> command to recover memory; this operation is impactful to all traffic on the switch during the restart. | 3.7.11-3.7.12, 4.0.0-4.2.0 | |
| <a name="2550735"></a> [2550735](#2550735) <a name="2550735"></a> <br />CM-30064 | The following security vulnerability has been found in BlueZ, in which the <code>libbluetooth3</code> library is available in the repository for optional installation in Cumulus Linux:<br />CVE-2020-0556: Improper access control in subsystem for BlueZ before version 5.54 may allow an unauthenticated user to potentially enable escalation of privilege and denial of service via adjacent access.<br />Vulnerable: <= 5.23-2+deb8u1<br />Fixed: 5.43-2+deb9u2~deb8u1 | 3.7.12 | |
| <a name="2550693"></a> [2550693](#2550693) <a name="2550693"></a> <br />CM-30040 | The following vulnerabilities have been announced in the <code>cups</code> package:<br />CVE-2019-8842: The 'ippReadIO' function may under-read an extension field<br />CVE-2020-3898: heap based buffer overflow in libcups's ppdFindOption() in ppd-mark.c<br />Vulnerable: <= 1.7.5-11+deb8u7<br />Fixed: 1.7.5-11+deb8u8 | 3.7.12 | |
| <a name="2550647"></a> [2550647](#2550647) <a name="2550647"></a> <br />CM-30009 | CVE-2020-12049: There was a file descriptor leak in the D-Bus message bus.  An unprivileged local attacker could use this to attack the system DBus daemon, leading to denial of service for all users of the machine.<br />Vulnerable: <= 1.8.22-0+deb8u2<br />Fixed: 1.8.22-0+deb8u3 | 3.7.12 | |
| <a name="2550512"></a> [2550512](#2550512) <a name="2550512"></a> <br />CM-29922 | The <code>python-httplib2</code> package, which is available in the repository for optional installation, has the following vulnerability:<br />CVE-2020-11078: In httplib2 before version 0.18.0, an attacker controlling unescaped part of uri for 'httplib2.Http.request()' could change request headers and body, send additional hidden requests to same server. This vulnerability impacts software that uses httplib2 with uri constructed by string concatenation, as opposed to proper urllib building with escaping. This has been fixed in 0.18.0.<br />Vulnerable: 0.9+dfsg-2<br />Fixed: 0.9+dfsg-2+deb8u1 | 3.7.12 | |
| <a name="2550511"></a> [2550511](#2550511) <a name="2550511"></a> <br />CM-29921 | The following vulnerabilities have been announced in <code>dosfstools</code>, which is available in the repository for optional installation:<br />CVE-2015-8872: The set_fat function in fat.c in dosfstools before 4.0 might allow attackers to corrupt a FAT12 filesystem or cause a denial of service (invalid memory read and crash) by writing an odd number of clusters to the third to last entry on a FAT12 filesystem, which triggers an "off-by-two error."<br />CVE-2016-4804: The read_boot function in boot.c in dosfstools before 4.0 allows attackers to cause a denial of service (crash) via a crafted filesystem, which triggers a heap-based buffer overflow in the (1) read_fat function or an out-of-bounds heap read in (2) get_fat function.<br />Vulnerable: 3.0.27-1<br />Fixed: 3.0.27-1+deb8u1 | 3.7.12 | |
| <a name="2550509"></a> [2550509](#2550509) <a name="2550509"></a> <br />CM-29920 | The json-c shared library (libjson-c2) had an integer overflow and out-of-bounds write via a large JSON file, as demonstrated by printbuf_memappend. The <code>libjson-c2</code> library is installed by default on Cumulus Linux 3.x.<br />Vulnerable: <= 0.11-4<br />Fixed: 0.11-4+deb8u2 | 3.7.12 | |
| <a name="2550507"></a> [2550507](#2550507) <a name="2550507"></a> <br />CM-29919 | Several vulnerabilities were discovered in BIND, a DNS server implementation. <br /><code>bind9-host</code> (containing only <code>/usr/bin/host</code>) and some libraries from the <code>bind9</code> source package are installed on the switch by default; the BIND server referred to in these vulnerabilities is not installed by default but is available in the repository for optional installation.<br />CVE-2020-8616: It was discovered that BIND does not sufficiently limit the number of fetches performed when processing referrals. An attacker can take advantage of this flaw to cause a denial of service (performance degradation) or use the recursing server in a reflection attack with a high amplification factor.<br />CVE-2020-8617: It was discovered that a logic error in the code which checks TSIG validity can be used to trigger an assertion failure, resulting in denial of service.<br />Vulnerable: <= 1:9.9.5.dfsg-9+deb8u18<br />Fixed: 1:9.9.5.dfsg-9+deb8u19 | 3.7.12 | |
| <a name="2550367"></a> [2550367](#2550367) <a name="2550367"></a> <br />CM-29834 | The following security vulnerability has been announced:<br />CVE-2020-13434: SQLite through 3.32.0 has an integer overflow in <code>sqlite3_str_vappendf</code> in <code>printf.c</code>.<br />Vulnerable: <= 3.8.7.1-1+deb8u5<br />Fixed: 3.8.7.1-1+deb8u6 | 3.7.12 | |
| <a name="2550323"></a> [2550323](#2550323) <a name="2550323"></a> <br />CM-29807 | After a neighbor is removed, the redistributed neighbor entry is withdrawn from the BGP table, but the prefix might still be selected as the bestpath when the host's originated prefix is not advertised.<br />To work around this issue, recreate the neighbor entry and flap the interface to the host. <br />Or, if the host is already down, manually create a neighbor entry with an invalid MAC address, which forces redistribute neighbor to re-withdraw the entry. | 3.7.3-3.7.12 | |
| <a name="2550275"></a> [2550275](#2550275) <a name="2550275"></a> <br />CM-29778 | If packets with an invalid checksum are received, the <code>cumulus-poe</code> service might restart and you see log messages similar to the following:<br />May 20 10:48:04.665635 leaf01 poed&#91;8012&#93;: ERROR : invalid checksum in response &#91;0xC2:0x00&#93;<br />May 20 10:48:04.671299 leaf01 poed&#91;8012&#93;: poed : ERROR : invalid checksum in response &#91;0xC2:0x00&#93;<br />May 20 10:48:04.708620 leaf01 systemd&#91;1&#93;: cumulus-poe.service: main process exited, code=exited, status=1/FAILURE<br />The service starts automatically but there is an impact to POE devices momentarily. | 3.7.12, 4.0.0-4.1.1 | |
| <a name="2550119"></a> [2550119](#2550119) <a name="2550119"></a> <br />CM-29692 | The following vulnerability has been announced in the <code>apt</code> package:<br />CVE-2020-3810: Shuaibing Lu discovered that missing input validation in the ar/tar implementations of APT, the high level package manager, could result in denial of service when processing specially crafted deb files.<br />Vulnerable: <= 1.0.9.8.5-cl3u1<br />Fixed: 1.0.9.8.5-cl3u2 | 3.7.12 | |
| <a name="2549869"></a> [2549869](#2549869) <a name="2549869"></a> <br />CM-29559 | The following vulnerability has been announced:<br />CVE-2020-11655: SQLite through 3.31.1 allows attackers to cause a denial of service (segmentation fault) via a malformed window-function query because the AggInfo object's initialization is mishandled.<br />Vulnerable: <= 3.8.7.1-1+deb8u4<br />Fixed: 3.8.7.1-1+deb8u5 | 3.7.12 | |
| <a name="2549835"></a> [2549835](#2549835) <a name="2549835"></a> <br />CM-29544 | The following vulnerability affects the openldap package:<br />CVE-2020-12243: A vulnerability was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. LDAP search filters with nested boolean expressions can result in denial of service (slapd daemon crash).<br />Vulnerable: <= 2.4.40+dfsg-1+deb8u5<br />Fixed: 2.4.40+dfsg-1+deb8u6 | 3.7.12 | |
| <a name="2549781"></a> [2549781](#2549781) <a name="2549781"></a> <br />CM-29518 | The following vulnerability affects the ruby2.1 package, which is installed by default:<br />CVE-2020-10663: The JSON gem through 2.2.0 for Ruby, as used in Ruby 2.1 has an unsafe object creation vulnerability. This is quite similar to CVE-2013-0269, but does not rely on poor garbage-collection behavior within Ruby. Specifically, use of JSON parsing methods can lead to creation of a malicious object within the interpreter, with adverse effects that are application-dependent.<br />Vulnerable: 2.1.5-2+deb8u9<br />Fixed: 2.1.5-2+deb8u10 | 3.7.12 | |
| <a name="2549777"></a> [2549777](#2549777) <a name="2549777"></a> <br />CM-29514 | The following security vulnerabilities were announced in the w3m package, which is available in the repository for optional installation:<br />CVE-2018-6196: w3m through 0.5.3 is prone to an infinite recursion flaw in HTMLlineproc0 because the feed_table_block_tag function in table.c does not prevent a negative indent value.<br />CVE-2018-6197: w3m through 0.5.3 is prone to a NULL pointer dereference flaw in formUpdateBuffer in form.c.<br />Vulnerable: <= 0.5.3-19+deb8u2<br />Fixed: 0.5.3-19+deb8u3 | 3.7.12 | |
| <a name="2549711"></a> [2549711](#2549711) <a name="2549711"></a> <br />CM-29484 | The following vulnerability affects libgd2/libgd3:<br />CVE-2018-14553: gdImageClone in gd.c in libgd 2.1.0-rc2 through 2.2.5 has a NULL pointer dereference allowing attackers to crash an application via a specific function call sequence. Only affects PHP when linked with an external libgd (not bundled).<br />Vulnerable: <= 2.1.0-5+deb8u13<br />Fixed: 2.1.0-5+deb8u14 | 3.7.12 | |
| <a name="2549710"></a> [2549710](#2549710) <a name="2549710"></a> <br />CM-29483 | The following vulnerability affects imptool:<br />CVE-2020-5208: It's been found that multiple functions in ipmitool before 1.8.19 neglect proper checking of the data received from a remote LAN party, which may lead to buffer overflows and potentially to remote code execution on the ipmitool side. This is especially dangerous if ipmitool is run as a privileged user.<br />Vulnerable: <= 1.8.14-4<br />Fixed: 1.8.14-4+deb8u1 | 3.7.12 | |
| <a name="2549677"></a> [2549677](#2549677) <a name="2549677"></a> <br />CM-29471 | After you add or remove a bridge VLAN identifier (VID) on a trunk port, the layer 2 VNI is put into VLAN 1. <br />To work around this issue, revert the configuration change. | 3.7.10-3.7.12, 4.0.0-4.1.1 | |
| <a name="2549397"></a> [2549397](#2549397) <a name="2549397"></a> <br />CM-29322 | When the BGP Multi-protocol Unreach NLRI attribute is received in a BGP update without a next hop attribute, the BGP session is brought down unexpectedly. RFC 4760 defines that the next-hop attribute is not required for updates containing MP_UNREACH_NLRI. | 3.7.12 | |
| <a name="2549348"></a> [2549348](#2549348) <a name="2549348"></a> <br />CM-29297 | The following vulnerability has been announced in git, which is available in the repository for optional installation:<br /><br />CVE-2020-5260: Felix Wilhelm of Google Project Zero discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline, the credential helper machinery can be fooled to return credential information for a wrong host.<br /><br />CVE-2020-11008: Carlo Arenas discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline or empty host, or lacks a scheme, the credential helper machinery can be fooled into providing credential information that is not appropriate for the protocol in use and host being contacted.<br /><br />Vulnerable: <= 2.1.4-2.1+deb8u8 (CVE-2020-5260) <= 2.1.4-2.1+deb8u9 (CVE-2020-11008)<br />Fixed: 2.1.4-2.1+deb8u10 | 3.7.12 | |
| <a name="2549307"></a> [2549307](#2549307) <a name="2549307"></a> <br />CM-29284 | The following vulnerabilities affect git, which is available in the repository for optional installation:<br />CVE-2020-5260: Felix Wilhelm of Google Project Zero discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline, the credential helper machinery can be fooled to return credential information for a wrong host.<br />CVE-2020-11008: Carlo Arenas discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline or empty host, or lacks a scheme, the credential helper machinery can be fooled into providing credential information that is not appropriate for the protocol in use and host being contacted. | 3.7.12, 4.0.0-4.1.1 | |
| <a name="2549110"></a> [2549110](#2549110) <a name="2549110"></a> <br />CM-29208 | The following vulnerability has been announced in ceph; the associated libraries librados2 and librbd1 are available in the Cumulus Linux 3 repository for optional installation.<br />CVE-2020-1760: It was discovered that there was a header-splitting vulnerability in ceph, a distributed storage and file system.<br />Vulnerable: <= 0.80.7-2+deb8u2<br />Fixed: 0.80.7-2+deb8u4 | 3.7.12 | |
| <a name="2548678"></a> [2548678](#2548678) <a name="2548678"></a> <br />CM-29048 | The following vulnerability exists in the ruby2.1 package:<br />CVE-2016-2338: An exploitable heap overflow vulnerability exists in the Psych::Emitter startdocument function of Ruby. In Psych::Emitter startdocument function heap buffer "head" allocation is made based on tags array length. Specially constructed object passed as element of tags array can increase this array size after mentioned allocation and cause heap overflow<br />Vulnerable: <= 2.1.5-2+deb8u8<br />Fixed: 2.1.5-2+deb8u9 | 3.7.12 | |
| <a name="2548674"></a> [2548674](#2548674) <a name="2548674"></a> <br />CM-29044 | A large number of flapping peers causes FRR to require a corresponding update to internal data structures that track peer information. Updating this internal data structure does not delete links that are down due to the flapping. The size of this array then grows to contain both current peers as well as peers that should have been deleted during the flap processing. The contents of this array is processed by FRR to poll the links, which consumes CPU for all items in the array. This additional polling consumes more CPU than necessary but has no functional impact.<br />To work around this issue, restart FRR. | 3.7.11-3.7.12, 4.0.0-4.1.1 | |
| <a name="2548666"></a> [2548666](#2548666) <a name="2548666"></a> <br />CM-29040 | The following issue has been found in <code>e2fsprogs</code>, a package that contains ext2/ext3/ext4 file system utilities:<br />CVE-2019-5188: A specially crafted ext4 directory can cause an out-of-bounds write on the stack, resulting in code execution. An attacker can corrupt a partition to trigger this vulnerability. | 3.7.12 | |
| <a name="2548659"></a> [2548659](#2548659) <a name="2548659"></a> <br />CM-29037 | When a link flap occurs while IPv6 traffic traverses interfaces, a kernel panic may occur with the following logs printed to the console:<br /><pre><br />&#91;1675080.282051&#93; BUG: unable to handle kernel NULL pointer dereference at 0000000000000110<br />&#91;1675080.291007&#93; IP: &#91;<ffffffff81709dec>&#93; fib6_lookup_1+0xac/0x170<br />...<br />&#91;1675080.757405&#93; Kernel panic - not syncing: Fatal exception in interrupt<br /></pre> | 3.7.12 | |
| <a name="2548586"></a> [2548586](#2548586) <a name="2548586"></a> <br />CM-28995 | After you flap an MLAG peerlink, a rare condition might occur where routes and neighbors for VXLAN-enabled VLANs are misprogrammed as non-VXLAN routes and neighbors due to VNI state transitions. This results in a forwarding failure for traffic destined to these misprogrammed routes and neighbors.<br />*Note*: Do not flap a VNI interface manually. The only expected time for a VNI interface to go down is when the MLAG secondary switch brings the VNIs protodown during a peer link failure where the backup IP address is still active.<br />To recover from this condition, restart <code>switchd</code> with the <code>sudo systemctl restart switchd</code> command. | 3.7.10-3.7.12, 4.1.0-4.1.1 | |
| <a name="2548580"></a> [2548580](#2548580) <a name="2548580"></a> <br />CM-28993 | The following security vulnerability has been announced that affects the libicu52 package:<br />CVE-2020-10531: An issue was discovered in International Components for Unicode (ICU) for C/C++ through 66.1. An integer overflow, leading to a heap-based buffer overflow, exists in the UnicodeString::doAppend() function in common/unistr.cpp.<br />Vulnerable: <= 52.1-8+deb8u7<br />Fixed: 52.1-8+deb8u8 | 3.7.12 | |
| <a name="2548579"></a> [2548579](#2548579) <a name="2548579"></a> <br />CM-28992 | The following security vulnerability has been announced:<br />CVE-2020-10531: An issue was discovered in International Components for Unicode (ICU) for C/C++ through 66.1. An integer overflow, leading to a heap-based buffer overflow, exists in the UnicodeString::doAppend() function in common/unistr.cpp. | 3.7.12, 4.0.0-4.1.0 | |
| <a name="2548505"></a> [2548505](#2548505) <a name="2548505"></a> <br />CM-28954 | The python-twisted-* packages, which are available for optional installation in Cumulus Linux but are not installed by default, were found to have the following security vulnerabilities:<br />CVE-2020-10808: In Twisted Web through 19.10.0, there was an HTTP request splitting vulnerability. When presented with two content-length headers, it ignored the first header. When the second content-length value was set to zero, the request body was interpreted as a pipelined request.<br />CVE-2020-10809: In Twisted Web through 19.10.0, there was an HTTP request splitting vulnerability. When presented with a content-length and a chunked encoding header, the content-length took precedence and the remainder of the request body was interpreted as a pipelined request. | 3.7.12 | |
| <a name="2548383"></a> [2548383](#2548383) <a name="2548383"></a> <br />CM-28867 | The QuantaMesh BMS T3048-LY8 switch shows a low fan RPM in syslog. | 3.7.5-3.7.12, 4.0.0-4.1.1 | |
| <a name="2548373"></a> [2548373](#2548373) <a name="2548373"></a> <br />CM-28862 | On the Edgecore AS5812 switch, the Innodisk DIMM causes a DIMM temperature sensor absent alert. | 3.7.12, 4.0.0-4.1.1 | |
| <a name="2548309"></a> [2548309](#2548309) <a name="2548309"></a> <br />CM-28811 | The following security vulnerability affects the <code>libvpx1</code> library:<br />CVE-2020-0034: It was discovered that there was an out-of-bounds buffer read<br />vulnerability in <code>libvpx</code>, a library implementing the VP8 & VP9 video<br />codecs. | 3.7.12 | |
| <a name="2548308"></a> [2548308](#2548308) <a name="2548308"></a> <br />CM-28810 | When the garbage collector does not release memory back to the operating system, <code>clagd</code> might consume a large amount of memory. As a result of low system memory, <code>systemd</code> might shut down services to reclaim memory.<br />  | 3.7.11-3.7.12, 4.1.0-4.1.1 | |
| <a name="2548116"></a> [2548116](#2548116) <a name="2548116"></a> <br />CM-28658 | The OVSDB log contains duplicate MAC addresses with the well-known BFD MAC address (00:23:20:00:00:01). This is mainly cosmetic, but clutters the log. | 3.7.12, 4.0.0-4.0.1 | |
| <a name="2548113"></a> [2548113](#2548113) <a name="2548113"></a> <br />CM-28656 | In OVSDB VLAN-aware mode, removing a VTEP binding on the NSX controller fails to clean up all interfaces associated with the logical switch. | 3.7.12, 4.0.0-4.1.1 | |
| <a name="2548111"></a> [2548111](#2548111) <a name="2548111"></a> <br />CM-28655 | When you remove, then re-add an NSX VTEP binding, the VXLAN VTEP interface is not recreated. | 3.7.9-3.7.12, 4.0.0-4.0.1 | |
| <a name="2547880"></a> [2547880](#2547880) <a name="2547880"></a> <br />CM-28488 | The following CVEs were announced that affect the cron package.  All of these require untrusted local user access.<br /><br />CVE-2017-9525 is a local user privilege escalation attack: In the cron package through 3.0pl1-128 on Debian, and through 3.0pl1-128ubuntu2 on Ubuntu, the postinst maintainer script allows for group-crontab-to-root privilege escalation via symlink attacks against unsafe usage of the chown and chmod programs.<br />CVE-2019-9704, CVE-2019-9705, CVE-2019-9706 are local user denial of service attacks.  Note: the fix for CVE-2019-9705 imposes a limitation on the length of a crontab file (the vulnerability was that an unlimited size crontab file could cause excessive memory consumption).<br />https://security-tracker.debian.org/tracker/DLA-1723-1<br /><br />Vulnerable: <= 3.0pl1-cl3u1<br />Fixed: 3.0pl1-cl3u2 | 3.7.12 | |
| <a name="2547879"></a> [2547879](#2547879) <a name="2547879"></a> <br />CM-28487 | The following CVE was announced for rsyslog:<br />CVE-2019-17041 CVE-2019-17042<br /><code>rsyslogd</code>, when receiving remote log messages and using optional pmaixforwardedfrom or pmcisconames parser modules (not enabled by default on Cumulus Linux), is vulnerable to CVE-2019-17041 and CVE-2019-17042 where malicious messages that appear to be from AIX or Cisco respectively may be caused to skip sanity checks, resulting in incorrect negative lengths causing heap overflows.<br />Do not enable (with $UDPServerRun or $InputTCPServerRun) receiving syslog messages from other hosts by the network. Also, do not enable (with $ModLoad) the vulnerable parsers pmaixforwardedfrom or pmcisconames.\<br />The default <code>/etc/rsyslog.conf</code> file on Cumulus Linux does NOT enable <code>$UDPServerRun</code> or <code>$InputTCPServerRun</code>, so the vulnerability is not network exploitable in the default configuration. In addition, the vulnerable parsers are not enabled in the default configuration.<br /><br />Vulnerable: <= 8.4.2-1-cl3u5<br />Fixed: 8.4.2-1-cl3u6 | 3.7.12 | |
| <a name="2547769"></a> [2547769](#2547769) <a name="2547769"></a> <br />CM-28437 | <code>syslog</code> might report a high load average with the CPU running a later microcode revision. | 3.7.4-3.7.12 | |
| <a name="2547667"></a> [2547667](#2547667) <a name="2547667"></a> <br />CM-28376 | On the Dell S5232F-ON switch, the output of <code>ledmgrd</code> shows <code>amber_blinking</code> but <code>smonctl</code> shows all OK. | 3.7.11-3.7.12, 4.0.0-4.1.1 | |
| <a name="2547663"></a> [2547663](#2547663) <a name="2547663"></a> <br />CM-28374 | When traffic from a double tag interface (facing a different site) is forwarded through VXLAN, the inner tag is not removed. The destination does not know this tag, so it discards it. | 3.7.8-3.7.12, 4.0.0-4.0.1 | |
| <a name="2547658"></a> [2547658](#2547658) <a name="2547658"></a> <br />CM-28371 | On the Lenovo NE0152T switch, one power supply (PSU2) always show as ABSENT in smonctl. | 3.7.11-3.7.12 | |
| <a name="2547610"></a> [2547610](#2547610) <a name="2547610"></a> <br />CM-28340 | Mellanox switches with the Spectrum A0 ASIC that are integrated with VMware NSX experience BFD connectivity issues with service nodes. As a result, VXLAN tunnels do not work.<br />Mellanox switches with the Spectrum A1 ASIC do **not** have this issue. | 3.7.11-3.7.12, 4.0.0-4.1.1 | |
| <a name="2547592"></a> [2547592](#2547592) <a name="2547592"></a> <br />CM-28331 | When you add a route map to advertise IPv4 unicast in a BGP EVPN configuration and the route map contains a set operation, BGP crashes. | 3.7.11-3.7.12 | |
| <a name="2547401"></a> [2547401](#2547401) <a name="2547401"></a> <br />CM-28223 | The following security vulnerability has been announced in qemu, which is not installed by default on Cumulus Linux but is available in the repository for optional installation:<br />CVE-2020-1711: block: iscsi: OOB heap access via an unexpected response of iSCSI Server | 3.7.11-3.7.12 | |
| <a name="2547293"></a> [2547293](#2547293) <a name="2547293"></a> <br />CM-28160 | On the Broadcom Trident3 switch with DHCP relay, where the DHCP server is reachable through the EVPN overlay, DHCP discover packets forwarded to the CPU might appear corrupt and might not get forwarded. | 3.7.9-3.7.12, 4.0.0-4.0.1 | |
| <a name="2547147"></a> [2547147](#2547147) <a name="2547147"></a> <br />CM-28086 | The <code>ospfd</code> daemon might crash with the following kernel trace: <br /><pre><br />2019-11-06T23:00:08.261749+09:00 cumulus ospfd&#91;5339&#93;: Assertion 'node' failed in file ospfd/ospf_packet.c, line 671, function ospf_write<br /></pre> | 3.7.11-3.7.12, 4.0.0-4.0.1 | |
| <a name="2546985"></a> [2546985](#2546985) <a name="2546985"></a> <br />CM-27999 | On the EdgeCore AS7326-56X switch, the PSU fans show constant LOW warnings. | 3.7.10-3.7.12, 4.0.0-4.2.0 | |
| <a name="2546951"></a> [2546951](#2546951) <a name="2546951"></a> <br />CM-27982 | <code>switchd</code> crashes when dynamic VRF route leaking is enabled and the following is true:<br />* The default route is leaked from VRF1 to VRF2<br />* Hardware-based dynamic VRF route leaking is configured (<code>vrf_route_leak_enable_dynamic</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file). <br />You might see logs similar to the following in <code>/var/log/syslog</code>:<br /><pre><br />kernel: &#91;159400.526241&#93; switchd&#91;21374&#93;: segfault at 1229cdd84 ip 00000000004142ca sp 00007ffd557a86d0 error 4 in switchd&#91;400000+71000&#93;<br /></pre><br />To work around this issue, use a route map to filter the default route (the source VRF is imported into the destination VRF). | 3.7.10-3.7.12, 4.0.0-4.1.1 | |
| <a name="2546267"></a> [2546267](#2546267) <a name="2546267"></a> <br />CM-27646 | Several vulnerabilities have been discovered in Git, a fast, scalable,<br />distributed revision control system, which is available in the Cumulus Linux 3.x repositories for optional installation.<br />CVE-2019-1348: export-marks is insecure, fix is to disable by default.<br />CVE-2019-1349: .git / git~1 filename vulnerability on NTFS<br />CVE-2019-1352: .git vulnerability with NTFS Alternate Streams Accesses<br />CVE-2019-1353: NTFS filesystem protection should be on by default<br />CVE-2019-1387: dubiously-nested submodule git directories should be disallowed<br />CVE-2019-19604: submodule update repository code execution vulnerability<br />Vulnerable: <= 2.1.4-2.1+deb8u7<br />Fixed: 2.1.4-2.1+deb8u8 | 3.7.10-3.7.12 | |
| <a name="2546141"></a> [2546141](#2546141) <a name="2546141"></a> <br />CM-27586 | CPU usage might be higher than normal if you have a high number of interfaces x VLANs and <code>lldpd</code> is active. This issue is introduced with code changes in Cumulus Linux 3.7.11, where VLAN information is now available for LLDP to advertise to neighbors (&#91;https://docs.cumulusnetworks.com/version/cumulus-linux-37/Layer-2/Link-Layer-Discovery-Protocol/#vlan-dot1-tlv&#93;). You might see high CPU usage even if VLAN (dot1) TLV configuration is disabled. <br />To check if <code>lldpd</code> is the heavy CPU resource user, run the following command:<br /><pre><br />cumulus&#64;switch:~$  ps -eo user,pid,ppid,cmd,%mem,%cpu --sort=-%cpu \| head<br /></pre><br />Alternatively, check for messages in the <code>/var/log/syslog</code> directory similar to:<br /><pre><br />2020-02-20T15:02:12.137857-05:00 leaf01 sysmonitor: High CPU use: 87%<br />2020-02-20T15:02:12.482398-05:00 leaf01 sysmonitor:   PID USER      PR    VIRT    RES %CPU %MEM     TIME+ COMMAND<br />2020-02-20T15:02:12.483112-05:00 leaf01 sysmonitor:  1570 _lldpd    20   73244  13800 76.6  0.3   4:43.06 lldpd<br /></pre><br />*Note*: The exact amount of CPU usage varies in each network based on a number of factors; however, it is unusual for <code>lldpd</code> to consume more than 30% CPU for an extended period of time.<br />To work around this issue, you can do one of the following:<br />* If the large number of VLANs is not absolutely necessary, manually prune the VLAN allowed list (if you use the range 1-2999, modify the <code>bridge-vids</code> list to include the VLANs being used).<br />* Stop the <code>lldpd</code> service. (This approach might be undesirable if the switch is providing services that rely on LLDP such as Voice VLAN.) To stop the <code>lldpd</code> service (runtime setting), run the <code>sudo systemctl stop lldpd.service</code> command. To disable the <code>lldpd</code> service upon boot, run <code>sudo systemctl disable lldpd.service</code>. | 3.7.11-3.7.12, 4.0.0-4.0.1 | |
| <a name="2543792"></a> [2543792](#2543792) <a name="2543792"></a> <br />CM-26225 | On the EdgeCore AS5712, AS6712, AS5812 and AS6812 switch, support for multiple PSU types results in log messages similar to the following:<br /><pre><br />2019-09-05T05:15:17.246597+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.274521+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br />2019-09-05T05:15:17.469556+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.497514+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br /></pre> | 3.7.9-3.7.12, 4.0.0-4.0.1 | |
| <a name="2543649"></a> [2543649](#2543649) <a name="2543649"></a> <br />CM-26138 | You cannot specify a source and destination MAC address in an ERSPAN ebtables rule. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i swp5 -s 00:25:90:b2:bd:9d -d 50:6b:4b:96:c4:04 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-3.7.12, 4.0.0-4.1.1 | |
| <a name="2543472"></a> [2543472](#2543472) <a name="2543472"></a> <br />CM-26024 | On switches with the Spectrum ASIC, the underlay hashes VXLAN packets for a given overlay flow randomly.<br />To work around this issue, configure the ECMP hash seed to the same value on the EVPN egress leaf switches. | 3.7.7-3.7.12, 4.0.0-4.0.1 | |
| <a name="2542767"></a> [2542767](#2542767) <a name="2542767"></a> <br />CM-25641 | If the BMC operating system fails to respond to IPMI, you see a traceback in <code>bmcd</code> and all the sensors might report ABSENT devices in <code>smonctl</code>. <br />To work around this issue, power cycle the switch. <br />  | 3.7.6-3.7.12, 4.0.0-4.0.1 | |
| <a name="2535845"></a> [2535845](#2535845) <a name="2535845"></a> <br />CM-21898 | On a Trident3 switch, IGMP packets are not policed by the police rule in the 00control ACL file. The packets are policed by the catchall policer in the 99control ACL file instead. <br /> <code>-A $INGRESS_CHAIN -p ipv4 -d 01:00:5e:00:00:00/ff:ff:ff:80:00:00 -j police --set-mode pkt --set-rate 100 --set-burst 100</code> <br />To work around this issue, let the CPU bound IGMP packet hit the following rule and change the policer rate to a desired value for IGMP packets: <br /> <code>-A $INGRESS_CHAIN -p ipv4 -d 01:00:5e:00:00:00/ff:ff:ff:80:00:00 -j police --set-mode pkt --set-rate 100 --set-burst 100</code> <br />Typically, the destination MAC address 01:00:5e:xx:xx:xx is used only for PIM/IGMP control and data stream packets. However, this workaround cannot handle data stream multicast packets that are not TCP/UDP; this is not typically done.  | 4.0.0-4.0.1 | |

## 3.7.12 Release Notes
### Open issues in 3.7.12

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-30832"></a> [CM-30832](#CM-30832) <a name="CM-30832"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with `Unable to read from device/fan1_input/pwm1` syslog messages. | 3.7.11-3.7.14, 4.1.1-4.2.1 | 3.7.14.2, 4.3.0|
| <a name="CM-28462"></a> [CM-28462](#CM-28462) <a name="CM-28462"></a> <br /> | On rare occasions, when you upgrade Cumulus Linux with the `apt-get upgrade` command, the upgrade fails and reports `No space left on device`. Checking the disk utilization shows that the disk is not full.<br/>To work around this issue, run the `apt-get upgrade` command again and reboot the device if prompted to complete the upgrade. | 3.7.10-3.7.14.2 | |
| <a name="CM-28080"></a> [CM-28080](#CM-28080) <a name="CM-28080"></a> <br /> | TACACS+ through ClearPass is not currently supported. Cumulus Linux sends authorization before authentication, but ClearPass does not accept an authorization before the user is authenticated. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2595889"></a> [2595889](#2595889) <a name="2595889"></a> <br />CM-31120 | In a traditional bridge configuration with <code>ip-forward off</code>, neighbors are synchronized to hardware with a <code>switchd</code> restart but are cleared when you flap the bridge interface. | 3.7.10-4.2.1 | 4.3.0|
| <a name="2595816"></a> [2595816](#2595816) <a name="2595816"></a> <br />CM-31222 | Tenant VRF BGP peers appear in the EVPN RMAC and nexthop tables, which causes the kernel RMAC to point at invalid IP address. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2589747"></a> [2589747](#2589747) <a name="2589747"></a> <br />CM-32226 | If <code>switchd</code> successfully signals <code>clagd</code> that it is going down, <code>clagd</code> stops responding to keepalive echo requests from the peer instead of sending a good bye to the peer over both the peerlink and the backup switch. Eventually, the keepalive timer expires and the secondary switch becomes the primary, and brings the bonds and VNIs back up. However, if <code>switchd</code> does not successfully signal it is going down, (in the event of a crash), the primary switch continues to respond to keepalives, and the bonds and VNIs are down on both peers.  | 3.7.12-4.2.1 | 4.3.0|
| <a name="2562511"></a> [2562511](#2562511) <a name="2562511"></a> <br /> | <code>hostapd} does not fail over to secondary RADIUS servers for 802.1x authentication when the primary radius is reachable but not responding to Access-Requests<br />If the primary RADIUS server is having a problem servicing requests, you can remove it from the configuration temporarily to force requests to be sent to alternate servers. | 3.7.10-3.7.14.2 | |
| <a name="2558184"></a> [2558184](#2558184) <a name="2558184"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2556061"></a> [2556061](#2556061) <a name="2556061"></a> <br />CM-33032 | On Edgecore AS4610 switches, the historic CPU usage displayed in <code>/run/sysmonitor/history</code> is sometimes shown as a negative value.  | 3.7.12-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2556037"></a> [2556037](#2556037) <a name="2556037"></a> <br />CM-33012 | After you add an interface to the bridge, an OSPF session flap can occur.<br /><br /> | 3.7.9-4.2.0 | 4.2.1-4.3.0|
| <a name="2555205"></a> [2555205](#2555205) <a name="2555205"></a> <br />CM-32545 | If the FRR and MSTP processes go down, an SNMP TRAP is not generated even with the following configuration in the <code>/etc/snmp/snmpd.conf</code> file. <br /><pre><br />proc watchfrr<br />proc mstpd<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRRis down!!!” PrErrorFlag.5 != 0<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRR is up!!!” PrErrorFlag.5 = 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is down!!!!" prErrorFlag.3 != 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is up!!!!" prErrorFlag.3 = 0<br /></pre><br /> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2554785"></a> [2554785](#2554785) <a name="2554785"></a> <br />CM-32275 | After you reboot a Broadcom switch, <code>switchd</code> might fail to restart and you see logs in <code>switchd.log</code> similar to the following:<br /><pre><br />...<br />Nov 12 12:20:05.063876 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.064310 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 0:system_init:<br />Nov 12 12:20:05.064428 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 system_init: Misc init failed: Operation timed out<br />Nov 12 12:20:05.064464 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.091995 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 LED: Loading 256 bytes into LED program memory<br />Nov 12 12:20:05.092029 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099547 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 PORT: Error: bcm ports not initialized<br />Nov 12 12:20:05.099579 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099646 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /var/lib/cumulus/rc.datapath_0: line 81 (error code -1): script terminated<br />Nov 12 12:20:05.099667 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099775 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /etc/bcm.d/rc.soc: line 70 (error code -1): script terminated<br />Nov 12 12:20:05.099798 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099871 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 ERROR loading rc script on unit 0<br />Nov 12 12:20:05.099892 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099943 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:299 CRIT loading of rc script failed, aborting!<br /></pre> | 3.7.11-4.2.1 | 4.3.0|
| <a name="2554719"></a> [2554719](#2554719) <a name="2554719"></a> <br />CM-32225 | A slow memory leak is observed (1% per 14 hours) in kmalloc-256.<br />To work around this issue, reboot the switch. | 3.7.12-3.7.14.2 | |
| <a name="2554369"></a> [2554369](#2554369) <a name="2554369"></a> <br />CM-32006 | Certain Dell S4048-ON switches show an incorrect vendor name and hang when you issue the <code>reboot</code> command.  | 3.7.12-4.2.1 | 4.3.0|
| <a name="2554329"></a> [2554329](#2554329) <a name="2554329"></a> <br />CM-31978 | On the Dell N3248PXE switch, fixed RJ45 interfaces with PoE neighbors can end up in _Paused_ mode after a <code>switchd</code> restart, which blocks traffic on that interface.  | 3.7.12-3.7.14.2 | |
| <a name="2554232"></a> [2554232](#2554232) <a name="2554232"></a> <br />CM-31929 | VXLAN encapsulated traffic is not routed to the next hop because the destination VTEP IP address is mis-programmed on the switch, which decapsulates the traffic unexpectedly. <br />To work around this issue, restart <code>switchd</code>. | 3.7.12-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553748"></a> [2553748](#2553748) <a name="2553748"></a> <br />CM-31627 | On switches with the Spectrum ASIC, the IPv6 default route is present in the kernel but missing in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2553732"></a> [2553732](#2553732) <a name="2553732"></a> <br />CM-31618 | A ping via a dual-connected bond fails, and the audio stream is not routed or encapsulated through the layer 3 VNI. | 3.7.12-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2553588"></a> [2553588](#2553588) <a name="2553588"></a> <br />CM-31565 | Multicast traffic on a VPN is sent to remote VTEPs that are not part of the VPN and the remote VTEPs receive multicast traffic encapsulated in a VXLAN ID that doesn't exist.<br />To work around this issue, disable IGMP snooping on the switch. | 3.7.12-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2553530"></a> [2553530](#2553530) <a name="2553530"></a> <br />CM-31545 | In an MLAG configuration with a layer 3 VNI, when you bounce the peer link, all layer 2 VNIs listed under the layer 3 VNI are duplicated. <br />To work around this issue, restart FRR with the <code>sudo systemctl restart frr.service</code> command.<br /><br /> | 3.7.10-3.7.13, 4.1.1-4.2.1 | 3.7.14, 4.3.0|
| <a name="2553450"></a> [2553450](#2553450) <a name="2553450"></a> <br />CM-31504 | On the the Dell N3248-PXE switch, when you insert two PSUs at different times, the newly inserted PSU is detected as OK but the fan and temp sensors are ABSENT.<br />To work around this issue, remove power to both PSUs at the same time, then reinsert power simultaneously. | 3.7.12-3.7.13, 4.2.1 | 3.7.14, 4.3.0|
| <a name="2553229"></a> [2553229](#2553229) <a name="2553229"></a> <br />CM-31412 | On the Dell N3248PXE switch, RJ45 fixed copper ports that auto-negotiate with a 100M or 10M neighbor incorrectly negotiate a half-duplex link that generates errors. Half duplex modes are not supported on this platform. | 3.7.12-3.7.13, 4.2.1 | 3.7.14, 4.3.0|
| <a name="2553219"></a> [2553219](#2553219) <a name="2553219"></a> <br />CM-31407 | You cannot configure SNMPv3 trap-destinations in non-default VRFs with an authentication username that contains fewer than eight characters. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2553116"></a> [2553116](#2553116) <a name="2553116"></a> <br />CM-31357 | When you manually set the link speed or duplex mode with ethtool to an unsupported value, then run a TDR check against the interface, you encounter a <code>switchd</code> service heartbeat failure.<br />To work around this issue, reboot the switch to clear the condition. Avoid setting the interface speed or duplex mode directly with ethtool. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553050"></a> [2553050](#2553050) <a name="2553050"></a> <br />CM-31322 | SNMP status might incorrectly reflect that a BGP neighbor is down due to an issue between <code>bgpd</code> and SNMP AgentX when the IP-FORWARD-MIB is also polled.<br />To work around this issue, avoid polling IP-FORWARD-MIB objects. | 3.7.12-3.7.14.2 | |
| <a name="2553015"></a> [2553015](#2553015) <a name="2553015"></a> <br />CM-31300 | If a neighbour contains a special character in PortID for LLDP, the <code>net show interface</code> command does not display the LLDP information or the command might fail. | 3.7.10-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2553001"></a> [2553001](#2553001) <a name="2553001"></a> <br />CM-31294 | When the following conditions exist, <code>clagd</code> might fail to establish a TCP control session across the subinterface (such as, peerlink.4094): <br />* <code>clagd</code> uses an IPv6 link-local address (LLA) to establish the TCP connection (the <code>clagd-peer-ip linklocal</code> command configures an IPv6 LLA connection)<br /><br />* Subsequent VLAN changes are made to VLAN sub-interfaces or adding or removing SVIs<br /><br />This issue occurs because the hardware stores one entry per VRF to represent the IPv6 LLA. The hardware entry for the LLA is removed when another interface is changed because the software interfaces are represented by a single entity in hardware. As a result, packets destined to the local IPv6 LLA address are received on the port but do not get forwarded to CPU for further processing.<br /><br />To workaround this issue, use IPv4 addresses under <code>peerlink.4094</code> and configure <code>clagd</code> to peer on IPv4 addresses. | 3.7.12-3.7.13 | 3.7.14-3.7.14.2, 4.2.0-4.3.0|
| <a name="2552939"></a> [2552939](#2552939) <a name="2552939"></a> <br />CM-31263 | RX_DRP on a bond interface increases without any data traffic while the slave port does not increase. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552925"></a> [2552925](#2552925) <a name="2552925"></a> <br />CM-31257 | On the EdgeCore AS-6712-32X, AS5812-54X and AS5812-54T switch models, the temp sensors (DIMM temp sensor) show ABSENT. The amber diagnostic light on the front of the switch might also be turned on due to this issue.<br />These messages and the light are cosmetic issues only and do not otherwise impact the function of the switch. | 3.7.12-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552742"></a> [2552742](#2552742) <a name="2552742"></a> <br />CM-31150 | On the Mellanox SN2410 switch, you see <code>switchd</code> core and <code>GBIN_MALLOC</code> errors.<br />To work around this issue, restart <code>switchd</code>. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552739"></a> [2552739](#2552739) <a name="2552739"></a> <br />CM-31148 | Counters for IPROUTER rules do not increase when traffic is forwarded to the CPU because there is no IP neighbor. | 3.7.2-3.7.14.2 | |
| <a name="2552647"></a> [2552647](#2552647) <a name="2552647"></a> <br />CM-31086 | When you add a member to a bond that has a subinterface configured (such as peerlink.4094), the new member is assigned only the VLAN of the subinterface for forwarding.<br />To work around this issue, bounce the bond or shutdown the new interface and use the remaining members over the bond. | 3.7.10-3.7.13, 4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552632"></a> [2552632](#2552632) <a name="2552632"></a> <br />CM-31073 | When you set the <code>sysctl</code> settings <code>net.ipv6.conf.all.accept_ra_defrtr</code> (to prevent acceptance of IPv6 default route advertisements) and <code>net.ipv6.conf.default.accept_ra_defrtr</code> (set for newly created interfaces), if you create a new virtual interface, any pre-existing interface does not start accepting IPv6 default route avertisements again.<br />To work around this issue, when you create a new virtual interface, set <code>net.ipv6.conf.<interface>.accept_ra_defrtr</code> to 0 for all interfaces and run <code>sysctl -p --system</code>. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552528"></a> [2552528](#2552528) <a name="2552528"></a> <br />CM-31028 | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2552506"></a> [2552506](#2552506) <a name="2552506"></a> <br />CM-31016 | Changing the order of the bridge ports might cause the bridge MAC address to change, which flaps the bridge and its ports.<br />To work around this issue, manually set the MAC address of the bridge interface by adding <code>hwaddress <mac-address></code> to the bridge stanza in the <code>/etc/network/interfaces</code> file. | 3.7.11-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552352"></a> [2552352](#2552352) <a name="2552352"></a> <br />CM-30914 | The following security vulnerabilities have been announced in the nss / libnss3 packages:<br />CVE-2020-6829: Side channel attack on ECDSA signature generation<br />CVE-2020-12400: P-384 and P-521 implementation uses a side-channel vulnerable modular inversion function<br />CVE-2020-12401: ECDSA timing attack mitigation bypass<br />Vulnerable: <= 3.26-1+debu8u11<br />Fixed: 3.26-1+debu8u12 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552351"></a> [2552351](#2552351) <a name="2552351"></a> <br />CM-30913 | The following vulnerability has been announced in the libx11 packages:<br />CVE-2020-14344: The X Input Method (XIM) client implementation in libX11 has some integer overflows and signed/unsigned comparison issues that can lead to heap corruption when handling malformed messages from an input method.<br />Vulnerable: <= 1.6.2-3+deb8u2<br />Fixed: 1.6.2-3+deb8u3 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552294"></a> [2552294](#2552294) <a name="2552294"></a> <br />CM-30879 | NCLU restarts FRR when removing a BGP VRF IPv4 aggregate-address command.<br />  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552236"></a> [2552236](#2552236) <a name="2552236"></a> <br />CM-30845 | The following vulnerabilities were reported against <code>qemu</code>, which is available in the repository for optional installation:<br />CVE-2020-13659: address_space_map in exec.c in QEMU 4.2.0 can trigger a NULL pointer dereference related to BounceBuffer.<br />CVE-2020-15863: stack-based overflow in xgmac_enet_send() in hw/net/xgmac.c.<br />Vulnerable: <= 2.1+dfsg-12+deb8u15<br />Fixed: 2.1+dfsg-12+deb8u16 | 3.7.12-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552214"></a> [2552214](#2552214) <a name="2552214"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14, 4.1.1-4.3.0 | 3.7.14.2|
| <a name="2552213"></a> [2552213](#2552213) <a name="2552213"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2552206"></a> [2552206](#2552206) <a name="2552206"></a> <br />CM-30827 | If the MAC address of an SVI changes, <code>clagd</code> does not update its permanent neighbor entry for the local interface, and it does not report the change to its MLAG peer. This leaves the MLAG peer in a state where its permanent neighbor for the MLAG peer's SVI IP address continues to use the old MAC address, which causes routed traffic over this SVI to be dropped.<br />To work around this issue, ifdown/ifup the SVI when a MAC address changes. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552187"></a> [2552187](#2552187) <a name="2552187"></a> <br />CM-30818 | The following vulnerabilities have been announced in <code>librsvg</code>, which is available in the repository for optional installation:<br />CVE-2016-6163: The rsvg_pattern_fix_fallback function in rsvg-paint_server.c in librsvg2 2.40.2 allows remote attackers to cause a denial of service (out-of-bounds read) via a crafted svg file.<br />CVE-2019-20446: In xml.rs in GNOME librsvg before 2.46.2, a crafted SVG file with nested patterns can cause denial of service when passed to the library for processing. The attacker constructs pattern elements so that the number of final rendered objects grows exponentially.<br />Vulnerable: <= 2.40.5-1+deb8u2<br />Fixed: 2.40.5-1+deb8u3 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551916"></a> [2551916](#2551916) <a name="2551916"></a> <br />CM-30582 | The following vulnerability has been announced in glib-networking, which is not installed by default, but is available in the repository for optional installation.<br />CVE-2020-13645: In GNOME glib-networking through 2.64.2, the implementation of GTlsClientConnection skips hostname verification of the server's TLS certificate if the application fails to specify the expected server identity. This is in contrast to its intended documented behavior, to fail the certificate verification. <br />Vulnerable: 2.42.0-2<br />Fixed: 2.42.0-2+deb8u1 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551915"></a> [2551915](#2551915) <a name="2551915"></a> <br />CM-30581 | The following vulnerabilities have been announced in NGINX, which is installed by default on Cumulus Linux (however, the default nginx configuration is not vulnerable, since it does not configure error_page redirection or use lua):<br />CVE-2019-20372: NGINX before 1.17.7, with certain error_page configurations, allows HTTP request smuggling, as demonstrated by the ability of an attacker to read unauthorized web pages in environments where NGINX is being fronted by a load balancer.<br />CVE-2020-11724: An issue was discovered in OpenResty before 1.15.8.4. ngx_http_lua_subrequest.c allows HTTP request smuggling, as demonstrated by the ngx.location.capture API.<br />Vulnerable: <= 1.6.2-5+deb8u6<br />Fixed: 1.6.2-5+deb8u7 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551912"></a> [2551912](#2551912) <a name="2551912"></a> <br />CM-30580 | <code>ifupdown2</code> does not account for link status or link down configuration when running <code>dhclient</code>. For example, <code>ifupdown2</code> ignores <code>link-down yes</code> during <code>ifup/ifreload</code> and runs the DHCP module if <code>inet dhcp</code> is configured on the interface. <code>ifupdown2</code> also runs the DHCP module even when the physical link configured for DHCP is down. | 3.7.12-4.2.0 | 4.2.1-4.3.0|
| <a name="2551780"></a> [2551780](#2551780) <a name="2551780"></a> <br />CM-30533 | CVE-2020-15389: jp2/opj_decompress.c in OpenJPEG through 2.3.1 has a use-after-free that can be triggered if there is a mix of valid and invalid files in a directory operated on by the decompressor. Triggering a double-free may also be possible. This is related to calling opj_image_destroy twice.<br />Vulnerable: <= 2.1.0-2+deb8u10<br />Fixed: 2.1.0-2+deb8u11 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551779"></a> [2551779](#2551779) <a name="2551779"></a> <br />CM-30532 | Several issues were discovered in Python 3.4, an interactive high-level object-oriented language, that allow an attacker to cause denial of service, trafic redirection, header injection and cross-site scripting.<br />CVE-2013-1753: The gzip_decode function in the xmlrpc client library allows remote attackers to cause a denial of service (memory consumption) via a crafted HTTP request.<br />CVE-2016-1000110:The CGIHandler class does not protect against the HTTP_PROXY variable name clash in a CGI script, which could allow a remote attacker to redirect HTTP requests.<br />CVE-2019-16935:The documentation XML-RPC server has XSS via the server_title field. This occurs in Lib/xmlrpc/server.py. If set_server_title is called with untrusted input, arbitrary JavaScript can be delivered to clients that visit the http URL for this server.<br />CVE-2019-18348: In urllib2, CRLF injection is possible if the attacker controls a url parameter, as demonstrated by the first argument to urllib.request.urlopen with \r\n (specifically in the host component of a URL) followed by an HTTP header.<br />CVE-2020-8492: Python allows an HTTP server to conduct Regular Expression Denial of Service (ReDoS) attacks against a client because of urllib.request.AbstractBasicAuthHandler catastrophic backtracking.<br />CVE-2020-14422: Lib/ipaddress.py improperly computes hash values in the IPv4Interface and IPv6Interface classes, which might allow a remote attacker to cause a denial of service if an application is affected by the performance of a dictionary containing IPv4Interface or IPv6Interface objects, and this attacker can cause many dictionary entries to be created.<br />Vulnerable: <= 3.4.2-1+deb8u7<br />Fixed: 3.4.2-1+deb8u8 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551778"></a> [2551778](#2551778) <a name="2551778"></a> <br />CM-30531 | Several vulnerabilities where found in Perl's regular expression compiler. An application that compiles untrusted regular expressions could be exploited to cause denial of service or code injection.<br />It is discouraged to allow untrusted regular expressions to be compiled by Perl.<br />CVE-2020-10543: Perl before 5.30.3 on 32-bit platforms allows a heap-based buffer overflow because nested regular expression quantifiers have an integer overflow.<br />CVE-2020-10878: Perl before 5.30.3 has an integer overflow related to mishandling of a "PL_regkind&#91;OP(n)&#93; == NOTHING" situation. A crafted regular expression could lead to malformed bytecode with a possibility of instruction injection.<br />CVE-2020-12723: regcomp.c in Perl before 5.30.3 allows a buffer overflow via a crafted regular expression because of recursive S_study_chunk calls.<br />Vulnerable: <= 5.20.2-3+deb8u12<br />Fixed: 5.20.2-3+deb8u13 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551748"></a> [2551748](#2551748) <a name="2551748"></a> <br />CM-30514 | In OVSDB high availability mode, deleting > 200 VLAN bindings might cause <code>ovs-vtepd</code> to crash.  Limit the deletion to 200 or fewer VLAN bindings. | 3.7.12-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2551732"></a> [2551732](#2551732) <a name="2551732"></a> <br />CM-30504 | When the OVSDB VTEP scale increases, the CPU utilization increases and eventually the switch (<code>ptmd</code>) fails to respond to the BFD, causing the BFD session to go down. As a result OVSDB cannot read the BFD socket status and outputs a warning in the <code>ovs-vtepd</code> debugs: <code>PTM socket error: Bad file descriptor</code>. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551729"></a> [2551729](#2551729) <a name="2551729"></a> <br />CM-30503 | In OVSDB high availability mode, if you create, then delete a binding, the FDB entry is not replaced and you see an error. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551715"></a> [2551715](#2551715) <a name="2551715"></a> <br />CM-30498 | There is a change to the default OVSDB bootstrapping process, where the script created now defaults to VLAN-aware bridge mode. If you want to use traditional bride mode, you need to force it by editing the <code>ovs-vtep-ctl</code> script generated by the bootstrap process. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551693"></a> [2551693](#2551693) <a name="2551693"></a> <br />CM-30486 | A host migrated to an 802.1X MAB port within the same broadcast domain fails to have the correct FDB entry installed if a dynamic FDB entry for that MAC address exists from previous connectivity in the broadcast domain.<br />To work around this issue, manually delete the dynamic FDB entry that is associated with the uplink trunk port. | 3.7.12-3.7.13, 4.1.1-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551675"></a> [2551675](#2551675) <a name="2551675"></a> <br />CM-30479 | When you restart <code>clagd</code>, the edge port setting on the peer link changes. | 3.7.2-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551651"></a> [2551651](#2551651) <a name="2551651"></a> <br />CM-30464 | The <code>net show dot1x interface summary</code> command output shows a MAC address with all zeros associated with a port. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551578"></a> [2551578](#2551578) <a name="2551578"></a> <br />CM-30422 | When you configure a bridge in the <code>/etc/network/interfaces</code> file, then try to reconfigure the bridge to be a VRF interface with the same name, <code>ifreload</code>/<code>ifup</code> commands fail with an <code>invalid table id</code> or <code>unable to get vrf table id</code> error. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2551543"></a> [2551543](#2551543) <a name="2551543"></a> <br />CM-30403 | <code>switchd</code> might crash if more than 16 IPv6 default route next hops are installed in the kernel routing table and those 16 next hops recurse to MAC address table entries reachable over VXLAN VNI interfaces. This can occur when many IPv6 router advertisements (RAs) are received across VLAN interfaces that have IPv6 forwarding disabled.<br />To work around this issue, add the following parameters to the <code>/etc/sysctl.conf</code> file to disable IPv6 default route installation from received router advertisements, then run the <code>sudo sysctl -p --system</code> command.<br /><pre><br />net.ipv6.conf.all.accept_ra_defrtr = 0 <br />net.ipv6.conf.default.accept_ra_defrtr = 0<br /></pre> | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551395"></a> [2551395](#2551395) <a name="2551395"></a> <br />CM-30343 | The <code>libnss3</code> package, available for optional installation on Cumulus Linux, has the following vulnerabilities:<br />CVE-2020-12399: Timing differences when performing DSA signatures.<br />CVE-2020-12402: Side channel vulnerabilities during RSA key generation.<br />Vulnerable: <= 3.26-1+deb8u10<br />Fixed: 3.26-1+deb8u11 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551356"></a> [2551356](#2551356) <a name="2551356"></a> <br />CM-30325 | The following vulnerabilities have been announced in the <code>qemu</code> package, which is available in the repository for optional installation on Cumulus Linux:<br />CVE-2020-1983: slirp: Fix use-after-free in ip_reass().<br />CVE-2020-13361: es1370_transfer_audio in hw/audio/es1370.c allowed guest OS users to trigger an out-of-bounds access during an es1370_write() operation.<br />CVE-2020-13362: megasas_lookup_frame in hw/scsi/megasas.c had an out-of-bounds read via a crafted reply_queue_head field from a guest OS user.<br />CVE-2020-13765: hw/core/loader: Fix possible crash in rom_copy().<br />Vulnerable: <= 2.1+dfsg-12+deb8u14<br />Fixed: 2.1+dfsg-12+deb8u15 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551351"></a> [2551351](#2551351) <a name="2551351"></a> <br />CM-30321 | CVE-2018-6381 CVE-2018-6484 CVE-2018-6540 CVE-2018-6541 CVE-2018-6869 CVE-2018-7725 CVE-2018-7726 CVE-2018-16548<br />Several issues have been fixed in <code>zziplib</code>, a library providing read access on ZIP-archives. They are all related to invalid memory access and resulting crash or memory leak.<br />libzzip-0-13 is not installed by default on Cumulus Linux, but is available in the repository for optional installation.<br />Vulnerable: <= 0.13.62-3+deb8u1<br />Fixed: 0.13.62-3+deb8u2 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551350"></a> [2551350](#2551350) <a name="2551350"></a> <br />CM-30320 | CVE-2017-10790: The _asn1_check_identifier function in GNU Libtasn1 through 4.12 causes a NULL pointer dereference and crash when reading crafted input that triggers assignment of a NULL value within an asn1_node structure. It may lead to a remote denial of service attack.<br />Vulnerable: <= 4.2-3+deb8u3<br />Fixed: 4.2-3+dev8u4 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551305"></a> [2551305](#2551305) <a name="2551305"></a> <br />CM-30296 | The <code>net show configuration</code> command provides the wrong <code>net add</code> command for ACL under the VLAN interface.<br /><br /> | 3.7.12-3.7.14.2, 4.1.0-4.3.0 | |
| <a name="2551288"></a> [2551288](#2551288) <a name="2551288"></a> <br />CM-30286 | When you remove BFD configuration by editing the <code>/etc/frr/frr.conf</code> file and restarting FRR, you see a traceback.<br />To work around this issue, either use NCLU or vtysh commands to remove the BFD configuration, or restart FRR with the new <code>/etc/frr/frr.conf</code> file. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2551259"></a> [2551259](#2551259) <a name="2551259"></a> <br />CM-30274 | CVE-2016-2774: ISC DHCP 4.1.x before 4.1-ESV-R13 and 4.2.x and 4.3.x before 4.3.4 does not restrict the number of concurrent TCP sessions, which allows remote attackers to cause a denial of service (INSIST assertion failure or request-processing outage) by establishing many sessions.<br /><br />On Cumulus Linux, the isc-dhcp-server is installed by default, but is not enabled by default.<br /><br />Vulnerable: <= 4.3.1-6-cl3u14<br />Fixed: 4.3.1-6-cl3u15 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2551162"></a> [2551162](#2551162) <a name="2551162"></a> <br />CM-30240 | <code>switchd</code> memory utilization might continue to increase if there are excessive and continuous link flaps over a long period of time.<br />To work around this issue, correct the cause of the frequent link flaps. You can restart <code>switchd</code> with the <code>sudo systemctl restart switchd</code> command to recover memory; this operation is impactful to all traffic on the switch during the restart. | 3.7.11-3.7.12, 4.0.0-4.2.0 | 3.7.13-3.7.14, 4.2.1-4.3.0|
| <a name="2550974"></a> [2550974](#2550974) <a name="2550974"></a> <br />CM-30195 | On the Dell S3000 switch, after installing the Cumulus Linux 4.1.1 disk image without a license, the switch sends a link beat if a remote host port is configured. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550942"></a> [2550942](#2550942) <a name="2550942"></a> <br />CM-30178 | NCLU tab completion for <code>net show</code> displays the text <code>add help text</code> instead of <code>system Information</code> for the system option. | 3.7.11-4.2.0 | 4.2.1-4.3.0|
| <a name="2550796"></a> [2550796](#2550796) <a name="2550796"></a> <br />CM-30103 | On a Broadcom switch with the Trident2+ ASIC, ACL rules for VLANs are not applied after a reboot and the counters remain at zero.<br />To work around this issue, either do not set <code>acl.non_atomic_update_mode = TRUE</code> in the <code>/etc/cumulus/switchd.conf</code> file or run the <code>cl-acltool -i</code> command after the reboot to install the  ACLs. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2550793"></a> [2550793](#2550793) <a name="2550793"></a> <br />CM-30101 | The NCLU <code>net show bridge spanning-tree</code> command displays the aging timer incorrectly.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550735"></a> [2550735](#2550735) <a name="2550735"></a> <br />CM-30064 | The following security vulnerability has been found in BlueZ, in which the <code>libbluetooth3</code> library is available in the repository for optional installation in Cumulus Linux:<br />CVE-2020-0556: Improper access control in subsystem for BlueZ before version 5.54 may allow an unauthenticated user to potentially enable escalation of privilege and denial of service via adjacent access.<br />Vulnerable: <= 5.23-2+deb8u1<br />Fixed: 5.43-2+deb9u2~deb8u1 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2550693"></a> [2550693](#2550693) <a name="2550693"></a> <br />CM-30040 | The following vulnerabilities have been announced in the <code>cups</code> package:<br />CVE-2019-8842: The 'ippReadIO' function may under-read an extension field<br />CVE-2020-3898: heap based buffer overflow in libcups's ppdFindOption() in ppd-mark.c<br />Vulnerable: <= 1.7.5-11+deb8u7<br />Fixed: 1.7.5-11+deb8u8 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2550647"></a> [2550647](#2550647) <a name="2550647"></a> <br />CM-30009 | CVE-2020-12049: There was a file descriptor leak in the D-Bus message bus.  An unprivileged local attacker could use this to attack the system DBus daemon, leading to denial of service for all users of the machine.<br />Vulnerable: <= 1.8.22-0+deb8u2<br />Fixed: 1.8.22-0+deb8u3 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2550601"></a> [2550601](#2550601) <a name="2550601"></a> <br />CM-29978 | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550512"></a> [2550512](#2550512) <a name="2550512"></a> <br />CM-29922 | The <code>python-httplib2</code> package, which is available in the repository for optional installation, has the following vulnerability:<br />CVE-2020-11078: In httplib2 before version 0.18.0, an attacker controlling unescaped part of uri for 'httplib2.Http.request()' could change request headers and body, send additional hidden requests to same server. This vulnerability impacts software that uses httplib2 with uri constructed by string concatenation, as opposed to proper urllib building with escaping. This has been fixed in 0.18.0.<br />Vulnerable: 0.9+dfsg-2<br />Fixed: 0.9+dfsg-2+deb8u1 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2550511"></a> [2550511](#2550511) <a name="2550511"></a> <br />CM-29921 | The following vulnerabilities have been announced in <code>dosfstools</code>, which is available in the repository for optional installation:<br />CVE-2015-8872: The set_fat function in fat.c in dosfstools before 4.0 might allow attackers to corrupt a FAT12 filesystem or cause a denial of service (invalid memory read and crash) by writing an odd number of clusters to the third to last entry on a FAT12 filesystem, which triggers an "off-by-two error."<br />CVE-2016-4804: The read_boot function in boot.c in dosfstools before 4.0 allows attackers to cause a denial of service (crash) via a crafted filesystem, which triggers a heap-based buffer overflow in the (1) read_fat function or an out-of-bounds heap read in (2) get_fat function.<br />Vulnerable: 3.0.27-1<br />Fixed: 3.0.27-1+deb8u1 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2550509"></a> [2550509](#2550509) <a name="2550509"></a> <br />CM-29920 | The json-c shared library (libjson-c2) had an integer overflow and out-of-bounds write via a large JSON file, as demonstrated by printbuf_memappend. The <code>libjson-c2</code> library is installed by default on Cumulus Linux 3.x.<br />Vulnerable: <= 0.11-4<br />Fixed: 0.11-4+deb8u2 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2550507"></a> [2550507](#2550507) <a name="2550507"></a> <br />CM-29919 | Several vulnerabilities were discovered in BIND, a DNS server implementation. <br /><code>bind9-host</code> (containing only <code>/usr/bin/host</code>) and some libraries from the <code>bind9</code> source package are installed on the switch by default; the BIND server referred to in these vulnerabilities is not installed by default but is available in the repository for optional installation.<br />CVE-2020-8616: It was discovered that BIND does not sufficiently limit the number of fetches performed when processing referrals. An attacker can take advantage of this flaw to cause a denial of service (performance degradation) or use the recursing server in a reflection attack with a high amplification factor.<br />CVE-2020-8617: It was discovered that a logic error in the code which checks TSIG validity can be used to trigger an assertion failure, resulting in denial of service.<br />Vulnerable: <= 1:9.9.5.dfsg-9+deb8u18<br />Fixed: 1:9.9.5.dfsg-9+deb8u19 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | 4.2.1-4.3.0, 4.3.0|
| <a name="2550466"></a> [2550466](#2550466) <a name="2550466"></a> <br />CM-29890 | Multiple paths to identical EVPN prefixes are either not displayed or not accepted into the l2vpn evpn table if they are received from a different AS. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550444"></a> [2550444](#2550444) <a name="2550444"></a> <br />CM-29872 | Tab completion for the <code>net show rollback description</code> command returns information about a snapshot instead of context help.<br />To work around this issue, run the <code>net show commit history</code> command to find descriptions instead of the <code>net show rollback description</code> command. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550443"></a> [2550443](#2550443) <a name="2550443"></a> <br />CM-29871 | The <code>net show rollback description <string></code> command returns an error even if the string matches a commit description.<br />To work around this issue, look for your string in the output of the <code>net show commit history</code> command (or grep for it there) instead. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550375"></a> [2550375](#2550375) <a name="2550375"></a> <br />CM-29838 | CPU utilization may increase when clag-managed bond interfaces are operationally/LACP down but the physical carrier remains up on the bond member switchports. This condition occurs when clag bond redirection is enabled and bond members remain up while the parent bond does not negotiate LACP.<br /><br />This issue is resolved in Cumulus Linux 3.7.14. | 3.7.9-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2550367"></a> [2550367](#2550367) <a name="2550367"></a> <br />CM-29834 | The following security vulnerability has been announced:<br />CVE-2020-13434: SQLite through 3.32.0 has an integer overflow in <code>sqlite3_str_vappendf</code> in <code>printf.c</code>.<br />Vulnerable: <= 3.8.7.1-1+deb8u5<br />Fixed: 3.8.7.1-1+deb8u6 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2550350"></a> [2550350](#2550350) <a name="2550350"></a> <br />CM-29830 | Unicast traffic from downlink hosts is flooded to multiple remote VTEPs, which might also cause high HwIfOutQDrops/TX_DRP on the uplink ports.<br />To work around this issue, restart <code>switchd</code>. | 3.7.10-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2550323"></a> [2550323](#2550323) <a name="2550323"></a> <br />CM-29807 | After a neighbor is removed, the redistributed neighbor entry is withdrawn from the BGP table, but the prefix might still be selected as the bestpath when the host's originated prefix is not advertised.<br />To work around this issue, recreate the neighbor entry and flap the interface to the host. <br />Or, if the host is already down, manually create a neighbor entry with an invalid MAC address, which forces redistribute neighbor to re-withdraw the entry. | 3.7.3-3.7.12 | 3.7.13-3.7.14.2, 4.0.0-4.3.0|
| <a name="2550276"></a> [2550276](#2550276) <a name="2550276"></a> <br />CM-29779 | In LLDP, the <code>snmp</code> subagent loses all subsequent <code>lldpRemSysName</code> (1.0.8802.1.1.2.1.4.1.1.9) entries after an entry with a missing SysName is added.<br />All the information from <code>lldpctl</code> is correct. Only the entries after the entry that is missing a SysName in <code>lldpRemSysName</code> disappear from the <code>snmp</code> subagent. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2550275"></a> [2550275](#2550275) <a name="2550275"></a> <br />CM-29778 | If packets with an invalid checksum are received, the <code>cumulus-poe</code> service might restart and you see log messages similar to the following:<br />May 20 10:48:04.665635 leaf01 poed&#91;8012&#93;: ERROR : invalid checksum in response &#91;0xC2:0x00&#93;<br />May 20 10:48:04.671299 leaf01 poed&#91;8012&#93;: poed : ERROR : invalid checksum in response &#91;0xC2:0x00&#93;<br />May 20 10:48:04.708620 leaf01 systemd&#91;1&#93;: cumulus-poe.service: main process exited, code=exited, status=1/FAILURE<br />The service starts automatically but there is an impact to POE devices momentarily. | 3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2550243"></a> [2550243](#2550243) <a name="2550243"></a> <br />CM-29759 | When you use <code>nginx</code> and <code>restserver</code> in management VRF to provide a REST API for the switch, <code>nginx</code> starts but <code>restserver</code> fails to start.<br />To work around this issue, comment out the <code>Requires=</code> line in the <code>/lib/systemd/system/restserver.service</code>. For example:<br /><pre><br />#Requires=nginx.service restserver.socket<br /></pre> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550196"></a> [2550196](#2550196) <a name="2550196"></a> <br />CM-29740 | The <code>exim4</code> package available for optional installation on Cumulus Linux 3.x has the following vulnerability:<br />DLA-2213-1 / CVE-2020-12783: Exim through 4.93 has an out-of-bounds read in the SPA authenticator that could result in SPA/NTLM authentication bypass in auths/spa.c and auths/auth-spa.c.  The spa authentication driver is not enabled by default.<br />Vulnerable: <= 4.84.2-2+deb8u6<br />Fixed: 4.84.2-2+deb8u7 | 3.7.12-3.7.14.2 | |
| <a name="2550119"></a> [2550119](#2550119) <a name="2550119"></a> <br />CM-29692 | The following vulnerability has been announced in the <code>apt</code> package:<br />CVE-2020-3810: Shuaibing Lu discovered that missing input validation in the ar/tar implementations of APT, the high level package manager, could result in denial of service when processing specially crafted deb files.<br />Vulnerable: <= 1.0.9.8.5-cl3u1<br />Fixed: 1.0.9.8.5-cl3u2 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2550056"></a> [2550056](#2550056) <a name="2550056"></a> <br />CM-29652 | The ACCTON-DIAG option under the Cumulus Linux GRUB menu does not work. When you select this option, you see the following error:<br /><pre><br />error: invalid signature.<br />Press any key to continue...<br /></pre> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549925"></a> [2549925](#2549925) <a name="2549925"></a> <br />CM-29594 | When you run an Ansible script to replace the <code>/etc/network/interfaces</code> file, then run the <code>ifreload -a</code> command, you see errors similar to the following:<br /><pre><br />error: swp1s1.2: netlink: cannot set link swp1s1.2 up: operation failed with 'Network is down' (100)<br />warning: cmd '/bin/ip addr del 10.0.0.1/24 dev eth0' failed: returned 2 (RTNETLINK answers: Cannot assign requested address<br /></pre><br />To work around this issue,  run the <code>ifreload -a</code> command a second time. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549872"></a> [2549872](#2549872) <a name="2549872"></a> <br />CM-29562 | If you have an SVI with multiple VRR IP addresses and try to delete one of the VRR configurations, <code>net commit</code> or <code>ifreload -a</code> returns an error. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549869"></a> [2549869](#2549869) <a name="2549869"></a> <br />CM-29559 | The following vulnerability has been announced:<br />CVE-2020-11655: SQLite through 3.31.1 allows attackers to cause a denial of service (segmentation fault) via a malformed window-function query because the AggInfo object's initialization is mishandled.<br />Vulnerable: <= 3.8.7.1-1+deb8u4<br />Fixed: 3.8.7.1-1+deb8u5 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2549859"></a> [2549859](#2549859) <a name="2549859"></a> <br />CM-29556 | The following vulnerability has been announced that affects ntp:<br />CVE-2020-11868: ntpd in ntp before 4.2.8p14 and 4.3.x before 4.3.100 allows an off-path attacker to block unauthenticated synchronization via a server mode packet with a spoofed source IP address, because transmissions are rescheduled even when a packet lacks a valid origin timestamp.<br />This affects: ntp-4.2.8p12 (possibly earlier) and ntp-4.2.8p13<br />The fix for https://bugs.ntp.org/3445 introduced a bug whereby a system that is running ntp-4.2.8p12 or p13 that only has one unauthenticated time source can be attacked in a way that causes the victim's next poll to its source to be delayed, for as long as the attack is maintained.<br />http://support.ntp.org/bin/view/Main/NtpBug3592 gives the following mitigations if it is not possible to upgrade to a version with the fix:<br />* Use authentication with symmetric peers.<br />* Have enough sources of time.  The default NTP configuration in Cumulus Linux has four time sources.<br /><br />Fixed: 4.2.8p12+dfsg-4+cl4u13 | 3.7.12-4.1.1 | 4.2.0-4.3.0|
| <a name="2549838"></a> [2549838](#2549838) <a name="2549838"></a> <br />CM-29546 | In vtysh, if you configure, then remove a layer 3 VNI for a VRF, the VNI is removed from zebra even if the VNI interface still exists in the kernel.<br />If you configure a layer 2 VNI as a layer 3 VNI by mistake, removing the layer 3 VNI binding removes it from zebra but EVPN-learned MACs and neighbors are not installed into the kernel.<br />To work around this issue, delete, then re-add the missing VNI. For example:<br /><pre><br />cumulus&#64;switch:~$ sudo ifdown vni10100<br />cumulus&#64;switch:~$ sudo ifup vni10100<br /></pre><br />If you flap the link with the <code>ip link set vni10100 down; ip link set vni10100 up</code> commands, zebra does not re-add the VNI. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2549835"></a> [2549835](#2549835) <a name="2549835"></a> <br />CM-29544 | The following vulnerability affects the openldap package:<br />CVE-2020-12243: A vulnerability was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. LDAP search filters with nested boolean expressions can result in denial of service (slapd daemon crash).<br />Vulnerable: <= 2.4.40+dfsg-1+deb8u5<br />Fixed: 2.4.40+dfsg-1+deb8u6 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2549794"></a> [2549794](#2549794) <a name="2549794"></a> <br />CM-29525 | The <code>asic-monitor.service</code> fails when you configure <code>/etc/cumulus/datapath/monitor.conf</code> with <code>monitor.histogram_pg.collect.port_group_list  = &#91;all_packet_pg&#93;</code> and there is traffic passing through the buffer. When the service fails, you see the following traceback in <code>journalctl</code>:<br /><pre><br />asic-monitor&#91;7389&#93;: asic-monitor-module INFO: 2020-05-01 18:28:12.548734: Egress queue(s) greater than 500 bytes in monitor port group histogram_pg<br />asic-monitor&#91;7389&#93;: asic-monitor ERROR: ASIC monitor exception: sx_api_port_counter_tc_get failed: Parameter Error<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 139, in <module><br />asic-monitor&#91;7389&#93;: main(sys.argv&#91;1:&#93;)<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 126, in main<br />asic-monitor&#91;7389&#93;: traceback.print_stack()<br />asic-monitor&#91;7389&#93;: Traceback (most recent call last):<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 117, in main<br />asic-monitor&#91;7389&#93;: monitor.run()<br />asic-monitor&#91;7389&#93;: File "/usr/lib/python2.7/dist-packages/cumulus/asic_monitor.py", line 158, in run<br />...<br /></pre> | 3.7.11-3.7.13, 4.1.1-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2549782"></a> [2549782](#2549782) <a name="2549782"></a> <br />CM-29519 | The JSON format output of the <code>net show bgp l2vpn evpn summary</code> command shows the incorrect neighbour state.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549781"></a> [2549781](#2549781) <a name="2549781"></a> <br />CM-29518 | The following vulnerability affects the ruby2.1 package, which is installed by default:<br />CVE-2020-10663: The JSON gem through 2.2.0 for Ruby, as used in Ruby 2.1 has an unsafe object creation vulnerability. This is quite similar to CVE-2013-0269, but does not rely on poor garbage-collection behavior within Ruby. Specifically, use of JSON parsing methods can lead to creation of a malicious object within the interpreter, with adverse effects that are application-dependent.<br />Vulnerable: 2.1.5-2+deb8u9<br />Fixed: 2.1.5-2+deb8u10 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2549777"></a> [2549777](#2549777) <a name="2549777"></a> <br />CM-29514 | The following security vulnerabilities were announced in the w3m package, which is available in the repository for optional installation:<br />CVE-2018-6196: w3m through 0.5.3 is prone to an infinite recursion flaw in HTMLlineproc0 because the feed_table_block_tag function in table.c does not prevent a negative indent value.<br />CVE-2018-6197: w3m through 0.5.3 is prone to a NULL pointer dereference flaw in formUpdateBuffer in form.c.<br />Vulnerable: <= 0.5.3-19+deb8u2<br />Fixed: 0.5.3-19+deb8u3 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2549731"></a> [2549731](#2549731) <a name="2549731"></a> <br />CM-29492 | When you create SPAN or ERSPAN rules in ebtables, the action fails to install if it is not in lowercase. Make sure that the SPAN or ERSPAN action is all lowercase; for example:<br /><pre><br />&#91;ebtables&#93;<br />-A FORWARD --in-interface swp10 -j span --dport swp1<br /></pre> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549711"></a> [2549711](#2549711) <a name="2549711"></a> <br />CM-29484 | The following vulnerability affects libgd2/libgd3:<br />CVE-2018-14553: gdImageClone in gd.c in libgd 2.1.0-rc2 through 2.2.5 has a NULL pointer dereference allowing attackers to crash an application via a specific function call sequence. Only affects PHP when linked with an external libgd (not bundled).<br />Vulnerable: <= 2.1.0-5+deb8u13<br />Fixed: 2.1.0-5+deb8u14 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2549710"></a> [2549710](#2549710) <a name="2549710"></a> <br />CM-29483 | The following vulnerability affects imptool:<br />CVE-2020-5208: It's been found that multiple functions in ipmitool before 1.8.19 neglect proper checking of the data received from a remote LAN party, which may lead to buffer overflows and potentially to remote code execution on the ipmitool side. This is especially dangerous if ipmitool is run as a privileged user.<br />Vulnerable: <= 1.8.14-4<br />Fixed: 1.8.14-4+deb8u1 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2549677"></a> [2549677](#2549677) <a name="2549677"></a> <br />CM-29471 | After you add or remove a bridge VLAN identifier (VID) on a trunk port, the layer 2 VNI is put into VLAN 1. <br />To work around this issue, revert the configuration change. | 3.7.10-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2549472"></a> [2549472](#2549472) <a name="2549472"></a> <br />CM-29367 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2549397"></a> [2549397](#2549397) <a name="2549397"></a> <br />CM-29322 | When the BGP Multi-protocol Unreach NLRI attribute is received in a BGP update without a next hop attribute, the BGP session is brought down unexpectedly. RFC 4760 defines that the next-hop attribute is not required for updates containing MP_UNREACH_NLRI. | 3.7.12 | 3.7.13-3.7.14.2, 4.0.0-4.3.0|
| <a name="2549371"></a> [2549371](#2549371) <a name="2549371"></a> <br />CM-29309 | When Optimized Multicast Flooding (OMF) is enabled with the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/switchd.conf</code> file, the switch continues to flood IPv6 multicast traffic to all slave ports when there is no MLD join receive. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549348"></a> [2549348](#2549348) <a name="2549348"></a> <br />CM-29297 | The following vulnerability has been announced in git, which is available in the repository for optional installation:<br /><br />CVE-2020-5260: Felix Wilhelm of Google Project Zero discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline, the credential helper machinery can be fooled to return credential information for a wrong host.<br /><br />CVE-2020-11008: Carlo Arenas discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline or empty host, or lacks a scheme, the credential helper machinery can be fooled into providing credential information that is not appropriate for the protocol in use and host being contacted.<br /><br />Vulnerable: <= 2.1.4-2.1+deb8u8 (CVE-2020-5260) <= 2.1.4-2.1+deb8u9 (CVE-2020-11008)<br />Fixed: 2.1.4-2.1+deb8u10 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2549307"></a> [2549307](#2549307) <a name="2549307"></a> <br />CM-29284 | The following vulnerabilities affect git, which is available in the repository for optional installation:<br />CVE-2020-5260: Felix Wilhelm of Google Project Zero discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline, the credential helper machinery can be fooled to return credential information for a wrong host.<br />CVE-2020-11008: Carlo Arenas discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline or empty host, or lacks a scheme, the credential helper machinery can be fooled into providing credential information that is not appropriate for the protocol in use and host being contacted. | 3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2549226"></a> [2549226](#2549226) <a name="2549226"></a> <br />CM-29259 | You might see the following <code>gport</code> error messages in <code>switchd.log</code>:<br /><pre><br />2020-04-10T19:50:01.011224+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x800007a find failed<br />2020-04-10T19:50:01.011631+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x8000009 find failed<br /></pre><br />These messages are harmless and can be ignored. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2549110"></a> [2549110](#2549110) <a name="2549110"></a> <br />CM-29208 | The following vulnerability has been announced in ceph; the associated libraries librados2 and librbd1 are available in the Cumulus Linux 3 repository for optional installation.<br />CVE-2020-1760: It was discovered that there was a header-splitting vulnerability in ceph, a distributed storage and file system.<br />Vulnerable: <= 0.80.7-2+deb8u2<br />Fixed: 0.80.7-2+deb8u4 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2548962"></a> [2548962](#2548962) <a name="2548962"></a> <br />CM-29165 | With FRR or OSPF, you might see an inconsistent link-state advertisement. For example, when you configure the OSPF default originate route as metric-type 1 with a specific metric, Cumulus Linux shows the default originate route as an external metric-type 2 route with the default metric in the database. This issue typically occurs when both IPv4 and IPv6 default routes exist in the routing table. | 3.7.12-4.1.1 | 4.2.0-4.3.0|
| <a name="2548930"></a> [2548930](#2548930) <a name="2548930"></a> <br />CM-29148 | On MLX switches that contain an OSPF IP unnumbered neighborship with a high scale of prefixes being learned, a link flap might cause the neighbor entry to not be programmed in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2548746"></a> [2548746](#2548746) <a name="2548746"></a> <br />CM-29068 | On the Broadcom switch with the Trident3 ASIC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548678"></a> [2548678](#2548678) <a name="2548678"></a> <br />CM-29048 | The following vulnerability exists in the ruby2.1 package:<br />CVE-2016-2338: An exploitable heap overflow vulnerability exists in the Psych::Emitter startdocument function of Ruby. In Psych::Emitter startdocument function heap buffer "head" allocation is made based on tags array length. Specially constructed object passed as element of tags array can increase this array size after mentioned allocation and cause heap overflow<br />Vulnerable: <= 2.1.5-2+deb8u8<br />Fixed: 2.1.5-2+deb8u9 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2548674"></a> [2548674](#2548674) <a name="2548674"></a> <br />CM-29044 | A large number of flapping peers causes FRR to require a corresponding update to internal data structures that track peer information. Updating this internal data structure does not delete links that are down due to the flapping. The size of this array then grows to contain both current peers as well as peers that should have been deleted during the flap processing. The contents of this array is processed by FRR to poll the links, which consumes CPU for all items in the array. This additional polling consumes more CPU than necessary but has no functional impact.<br />To work around this issue, restart FRR. | 3.7.11-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548672"></a> [2548672](#2548672) <a name="2548672"></a> <br />CM-29043 | When a multipath route that contains an EVPN path exists together with an IPv4 BGP path in the VRF, the RMAC to VTEP binding is incorrect. This invalid entry occurs because Cumulus Linux treats IPv4 routes received over the eBGP IPv4 peering incorrectly in the VRF.<br />To work around this issue, remove the unnecessary eBGP IPv4 peering. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548666"></a> [2548666](#2548666) <a name="2548666"></a> <br />CM-29040 | The following issue has been found in <code>e2fsprogs</code>, a package that contains ext2/ext3/ext4 file system utilities:<br />CVE-2019-5188: A specially crafted ext4 directory can cause an out-of-bounds write on the stack, resulting in code execution. An attacker can corrupt a partition to trigger this vulnerability. | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2548659"></a> [2548659](#2548659) <a name="2548659"></a> <br />CM-29037 | When a link flap occurs while IPv6 traffic traverses interfaces, a kernel panic may occur with the following logs printed to the console:<br /><pre><br />&#91;1675080.282051&#93; BUG: unable to handle kernel NULL pointer dereference at 0000000000000110<br />&#91;1675080.291007&#93; IP: &#91;<ffffffff81709dec>&#93; fib6_lookup_1+0xac/0x170<br />...<br />&#91;1675080.757405&#93; Kernel panic - not syncing: Fatal exception in interrupt<br /></pre> | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2548657"></a> [2548657](#2548657) <a name="2548657"></a> <br />CM-29035 | When you upgrade Cumulus Linux on the EdgeCore AS7726-32X or AS7326-56X switch, you might see firmware errors similar to the following:<br /><pre><br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso5.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3.bin for module tg3<br /></pre><br />You can safely ignore these error messages. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548586"></a> [2548586](#2548586) <a name="2548586"></a> <br />CM-28995 | After you flap an MLAG peerlink, a rare condition might occur where routes and neighbors for VXLAN-enabled VLANs are misprogrammed as non-VXLAN routes and neighbors due to VNI state transitions. This results in a forwarding failure for traffic destined to these misprogrammed routes and neighbors.<br />*Note*: Do not flap a VNI interface manually. The only expected time for a VNI interface to go down is when the MLAG secondary switch brings the VNIs protodown during a peer link failure where the backup IP address is still active.<br />To recover from this condition, restart <code>switchd</code> with the <code>sudo systemctl restart switchd</code> command. | 3.7.10-3.7.12, 4.1.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548580"></a> [2548580](#2548580) <a name="2548580"></a> <br />CM-28993 | The following security vulnerability has been announced that affects the libicu52 package:<br />CVE-2020-10531: An issue was discovered in International Components for Unicode (ICU) for C/C++ through 66.1. An integer overflow, leading to a heap-based buffer overflow, exists in the UnicodeString::doAppend() function in common/unistr.cpp.<br />Vulnerable: <= 52.1-8+deb8u7<br />Fixed: 52.1-8+deb8u8 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2548579"></a> [2548579](#2548579) <a name="2548579"></a> <br />CM-28992 | The following security vulnerability has been announced:<br />CVE-2020-10531: An issue was discovered in International Components for Unicode (ICU) for C/C++ through 66.1. An integer overflow, leading to a heap-based buffer overflow, exists in the UnicodeString::doAppend() function in common/unistr.cpp. | 3.7.12, 4.0.0-4.1.0 | 3.7.13-3.7.14, 4.1.1-4.3.0|
| <a name="2548505"></a> [2548505](#2548505) <a name="2548505"></a> <br />CM-28954 | The python-twisted-* packages, which are available for optional installation in Cumulus Linux but are not installed by default, were found to have the following security vulnerabilities:<br />CVE-2020-10808: In Twisted Web through 19.10.0, there was an HTTP request splitting vulnerability. When presented with two content-length headers, it ignored the first header. When the second content-length value was set to zero, the request body was interpreted as a pipelined request.<br />CVE-2020-10809: In Twisted Web through 19.10.0, there was an HTTP request splitting vulnerability. When presented with a content-length and a chunked encoding header, the content-length took precedence and the remainder of the request body was interpreted as a pipelined request. | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2548490"></a> [2548490](#2548490) <a name="2548490"></a> <br />CM-28944 | A change in a route map prefix list that should remove a route might not be reflected in the <code>ospf6</code> database or in peers, and the route might not be deleted. <br />To work around this issue, reenter the <code>redistribute <connected\|static> route-map <route-map-name></code> statement in the configuration. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548485"></a> [2548485](#2548485) <a name="2548485"></a> <br />CM-28940 | If you configure <code>aggregate-address <address> summary-only</code> before a component of the same aggregate is injected into the BGP table with the <code>network</code> or <code>redistribute</code> command, when you remove the <code>aggregate-address</code> configuration, the component stays suppressed; it is not advertised to peers. For example:<br />Existing configuration:<br /><pre><br />router bgp 1<br /> address-family ipv4 unicast<br />  aggregate-address 50.0.0.0/8 summary-only<br /> exit-address-family<br /></pre><br />If you add <code>network 50.0.0.1/32</code>, you see the following (expected) BGP table entries:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />*> 50.0.0.0         0.0.0.0                            32768 i<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />Removing <code>aggregate-address 50.0.0.0/8 summary-only</code> at this point results in the following (unexpected) BGP table entry:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />To work around this issue, remove, then re-add the component prefix routes. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548475"></a> [2548475](#2548475) <a name="2548475"></a> <br />CM-28932 | After you add a new VNI and a layer 3 SVI to a set of leafs, certain leafs might not be able to communicate on the layer 3 VNI. <br />To work around this issue, reboot the leaf switch or restart <code>switchd</code>. | 3.7.6-3.7.13 | 3.7.14-3.7.14.2, 4.0.0-4.3.0|
| <a name="2548383"></a> [2548383](#2548383) <a name="2548383"></a> <br />CM-28867 | The QuantaMesh BMS T3048-LY8 switch shows a low fan RPM in syslog. | 3.7.5-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548373"></a> [2548373](#2548373) <a name="2548373"></a> <br />CM-28862 | On the Edgecore AS5812 switch, the Innodisk DIMM causes a DIMM temperature sensor absent alert. | 3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548315"></a> [2548315](#2548315) <a name="2548315"></a> <br />CM-28816 | The following security advisory has been announced for bash: <br />CVE-2019-18276 Qualys scan QID 372268 setuid vulnerability<br />When bash or bash scripts are run setuid, bash is supposed to drop privileges, but does so incorrectly, so that an attacker with command access to the shell can use <code>enable -f</code> for runtime loading of a new builtin that calls <code>setuid()</code> to regain dropped privileges.<br />To work around this issue, do not make bash or bash scripts <code>setuid</code>. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548309"></a> [2548309](#2548309) <a name="2548309"></a> <br />CM-28811 | The following security vulnerability affects the <code>libvpx1</code> library:<br />CVE-2020-0034: It was discovered that there was an out-of-bounds buffer read<br />vulnerability in <code>libvpx</code>, a library implementing the VP8 & VP9 video<br />codecs. | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2548308"></a> [2548308](#2548308) <a name="2548308"></a> <br />CM-28810 | When the garbage collector does not release memory back to the operating system, <code>clagd</code> might consume a large amount of memory. As a result of low system memory, <code>systemd</code> might shut down services to reclaim memory.<br />  | 3.7.11-3.7.12, 4.1.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548117"></a> [2548117](#2548117) <a name="2548117"></a> <br />CM-28659 | In OVSDB traditional bridge mode, adding or removing a VLAN binding causes a traffic forwarding outage for around 20 seconds or more on adjacent VLAN bindings. Cumulus Linux does not support _traditional_ bridge mode with VMware NSX. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548116"></a> [2548116](#2548116) <a name="2548116"></a> <br />CM-28658 | The OVSDB log contains duplicate MAC addresses with the well-known BFD MAC address (00:23:20:00:00:01). This is mainly cosmetic, but clutters the log. | 3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2548113"></a> [2548113](#2548113) <a name="2548113"></a> <br />CM-28656 | In OVSDB VLAN-aware mode, removing a VTEP binding on the NSX controller fails to clean up all interfaces associated with the logical switch. | 3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548111"></a> [2548111](#2548111) <a name="2548111"></a> <br />CM-28655 | When you remove, then re-add an NSX VTEP binding, the VXLAN VTEP interface is not recreated. | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2548024"></a> [2548024](#2548024) <a name="2548024"></a> <br />CM-28596 | On the Dell Z9100 switch, 100G-SR4 modules might not link up reliably in certain ports. <br />swp1, 2, 3, 9, 10, 23, 24, 30, 31, and 32 might be affected<br />To work around this issue, move 100G SR4 modules to one of the ports not affected by this issue. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547942"></a> [2547942](#2547942) <a name="2547942"></a> <br />CM-28533 | On the Lenovo NE0152T switch, one power supply (PSU2) always show as ABSENT in smonctl. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547880"></a> [2547880](#2547880) <a name="2547880"></a> <br />CM-28488 | The following CVEs were announced that affect the cron package.  All of these require untrusted local user access.<br /><br />CVE-2017-9525 is a local user privilege escalation attack: In the cron package through 3.0pl1-128 on Debian, and through 3.0pl1-128ubuntu2 on Ubuntu, the postinst maintainer script allows for group-crontab-to-root privilege escalation via symlink attacks against unsafe usage of the chown and chmod programs.<br />CVE-2019-9704, CVE-2019-9705, CVE-2019-9706 are local user denial of service attacks.  Note: the fix for CVE-2019-9705 imposes a limitation on the length of a crontab file (the vulnerability was that an unlimited size crontab file could cause excessive memory consumption).<br />https://security-tracker.debian.org/tracker/DLA-1723-1<br /><br />Vulnerable: <= 3.0pl1-cl3u1<br />Fixed: 3.0pl1-cl3u2 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547879"></a> [2547879](#2547879) <a name="2547879"></a> <br />CM-28487 | The following CVE was announced for rsyslog:<br />CVE-2019-17041 CVE-2019-17042<br /><code>rsyslogd</code>, when receiving remote log messages and using optional pmaixforwardedfrom or pmcisconames parser modules (not enabled by default on Cumulus Linux), is vulnerable to CVE-2019-17041 and CVE-2019-17042 where malicious messages that appear to be from AIX or Cisco respectively may be caused to skip sanity checks, resulting in incorrect negative lengths causing heap overflows.<br />Do not enable (with $UDPServerRun or $InputTCPServerRun) receiving syslog messages from other hosts by the network. Also, do not enable (with $ModLoad) the vulnerable parsers pmaixforwardedfrom or pmcisconames.\<br />The default <code>/etc/rsyslog.conf</code> file on Cumulus Linux does NOT enable <code>$UDPServerRun</code> or <code>$InputTCPServerRun</code>, so the vulnerability is not network exploitable in the default configuration. In addition, the vulnerable parsers are not enabled in the default configuration.<br /><br />Vulnerable: <= 8.4.2-1-cl3u5<br />Fixed: 8.4.2-1-cl3u6 | 3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547839"></a> [2547839](#2547839) <a name="2547839"></a> <br />CM-28465 | When you try to configure <code>link-down</code> on a parent interface of a subinterface configured in a VRF, you encounter an error. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547799"></a> [2547799](#2547799) <a name="2547799"></a> <br />CM-28451 | An error similar to the following shows in syslog for Mellanox switches:<br /><pre><br />2020-02-12T19:59:22.208012+08:00 leaf01 sx_sdk: RM_TABLE: No resources available to add 1 entries to KVD hash Table HW resource<br />2020-02-12T19:59:22.208124+08:00 leaf01 sx_sdk: PORT: __port_vport_fid_set err = (No More Resources)<br /></pre><br />To work around this issue, reboot the switch. | 3.7.11-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2547784"></a> [2547784](#2547784) <a name="2547784"></a> <br />CM-28442 | PTM mis-detects incorrect hostnames of LLDP neighbors and does not fail them as expected. Instead they end up in an N/A cabling status. | 3.7.11-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547782"></a> [2547782](#2547782) <a name="2547782"></a> <br />CM-28441 | If a LLDP neighbor advertises a <code>PortDescr</code> that contains commas, <code>ptmctl -d</code> splits the string on the commas and misplaces its components in other columns. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547769"></a> [2547769](#2547769) <a name="2547769"></a> <br />CM-28437 | <code>syslog</code> might report a high load average with the CPU running a later microcode revision. | 3.7.4-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547706"></a> [2547706](#2547706) <a name="2547706"></a> <br />CM-28397 | When you configure ganged ports in the <code>ports.conf</code> file, the change does not take effect after you restart <code>switchd</code>. <br />To work around this issue, reboot the switch. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2547667"></a> [2547667](#2547667) <a name="2547667"></a> <br />CM-28376 | On the Dell S5232F-ON switch, the output of <code>ledmgrd</code> shows <code>amber_blinking</code> but <code>smonctl</code> shows all OK. | 3.7.11-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2547663"></a> [2547663](#2547663) <a name="2547663"></a> <br />CM-28374 | When traffic from a double tag interface (facing a different site) is forwarded through VXLAN, the inner tag is not removed. The destination does not know this tag, so it discards it. | 3.7.8-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547659"></a> [2547659](#2547659) <a name="2547659"></a> <br />CM-28372 | On the EdgeCore AS7326-56X switch, the default fan speed, which is defined in the thermal specification, results in excessive fan noise. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547658"></a> [2547658](#2547658) <a name="2547658"></a> <br />CM-28371 | On the Lenovo NE0152T switch, one power supply (PSU2) always show as ABSENT in smonctl. | 3.7.11-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547610"></a> [2547610](#2547610) <a name="2547610"></a> <br />CM-28340 | Mellanox switches with the Spectrum A0 ASIC that are integrated with VMware NSX experience BFD connectivity issues with service nodes. As a result, VXLAN tunnels do not work.<br />Mellanox switches with the Spectrum A1 ASIC do **not** have this issue. | 3.7.11-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2547592"></a> [2547592](#2547592) <a name="2547592"></a> <br />CM-28331 | When you add a route map to advertise IPv4 unicast in a BGP EVPN configuration and the route map contains a set operation, BGP crashes. | 3.7.11-3.7.12 | 3.7.13-3.7.14.2, 4.1.0-4.3.0|
| <a name="2547573"></a> [2547573](#2547573) <a name="2547573"></a> <br />CM-28322 | On Tomahawk switches, when the <code>vxlan_tnl_arp_punt_disable</code> option is set to FALSE, ARP packets are not forwarded to the CPU. | 3.7.9-4.0.1 | 4.1.0-4.3.0|
| <a name="2547443"></a> [2547443](#2547443) <a name="2547443"></a> <br />CM-28248 | On the Dell N3248PXE-ON switch, 25G SFP ports do not work in 10G mode. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547401"></a> [2547401](#2547401) <a name="2547401"></a> <br />CM-28223 | The following security vulnerability has been announced in qemu, which is not installed by default on Cumulus Linux but is available in the repository for optional installation:<br />CVE-2020-1711: block: iscsi: OOB heap access via an unexpected response of iSCSI Server | 3.7.11-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547381"></a> [2547381](#2547381) <a name="2547381"></a> <br />CM-28212 | The <code>hsflowd</code> service sends an undefined header protocol 0 in the sampled flow sample to the collector, which is not recognized by the sFlow tool. You see errors similar to the following:<br /><pre><br />Dec 20 08:43:27 netflow-nms sfcapd&#91;3991&#93;: SFLOW: readFlowSample_header() undefined headerProtocol = 0<br /></pre><br /> | 3.7.11-3.7.14 | 4.0.0-4.3.0|
| <a name="2547293"></a> [2547293](#2547293) <a name="2547293"></a> <br />CM-28160 | On the Broadcom Trident3 switch with DHCP relay, where the DHCP server is reachable through the EVPN overlay, DHCP discover packets forwarded to the CPU might appear corrupt and might not get forwarded. | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547246"></a> [2547246](#2547246) <a name="2547246"></a> <br />CM-28136 | The MLAG switch pair has VLANs defined that are not used on MLAG bonds. These VLANs still synchronize MAC addresses across to the peer switch. This results in log messages that indicate a MAC address is installed and the VLAN is not defined; for example:<br /><pre><br />RTM_NEWNEIGH with unconfigured vlan XXXX on port peerlink<br /></pre> | 3.7.10-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547147"></a> [2547147](#2547147) <a name="2547147"></a> <br />CM-28086 | The <code>ospfd</code> daemon might crash with the following kernel trace: <br /><pre><br />2019-11-06T23:00:08.261749+09:00 cumulus ospfd&#91;5339&#93;: Assertion 'node' failed in file ospfd/ospf_packet.c, line 671, function ospf_write<br /></pre> | 3.7.11-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547123"></a> [2547123](#2547123) <a name="2547123"></a> <br />CM-28078 | On the Broadcom switch with the Trident3 ASC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547120"></a> [2547120](#2547120) <a name="2547120"></a> <br />CM-28076 | After you hot swap a PSU, the <code>decode-syseeprom -t psuX</code> command shows the old PSU information (such as the serial number), until you run the <code>decode-syseeprom --init</code> command. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547100"></a> [2547100](#2547100) <a name="2547100"></a> <br />CM-28061 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546992"></a> [2546992](#2546992) <a name="2546992"></a> <br />CM-28004 | The wireshark packages (libwireshark5, libwireshark-data, wireshark, wireshark-common) available for optional installation on Cumulus Linux 3 are vulnerable to CVE-2018-12086: Buffer overflow in OPC UA applications allows remote attackers to trigger a stack overflow with carefully structured requests.  More information at https://www.wireshark.org/security/wnpa-sec-2018-50.html and https://security-tracker.debian.org/tracker/CVE-2018-12086 . | 3.7.11-3.7.14.2 | |
| <a name="2546991"></a> [2546991](#2546991) <a name="2546991"></a> <br />CM-28003 | The FRR service does not provide a way for automation to know if the configuration applied properly.<br />To work around this issue, execute the <code>vtysh -f <file></code> command in the automation file before starting the FRR service to validate the functional configuration and return an error code. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546989"></a> [2546989](#2546989) <a name="2546989"></a> <br />CM-28001 | The libxen packages are not installed on the switch by default, but are available in the repository for optional installation.<br /><br />Customers who optionally install the libxen packages should be aware of the following security advisory.<br /><br />Debian Security Advisory DSA-4602-1<br />CVE-2019-17349 CVE-2019-17350 CVE-2019-18420 CVE-2019-18421<br />CVE-2019-18422 CVE-2019-18423 CVE-2019-18424 CVE-2019-18425<br />CVE-2019-19577 CVE-2019-19578 CVE-2019-19579 CVE-2019-19580<br />CVE-2019-19581 CVE-2019-19582 CVE-2019-19583 CVE-2018-12207<br />CVE-2018-12126 CVE-2018-12127 CVE-2018-12130 CVE-2019-11091<br />CVE-2019-11135 CVE-2019-17348 CVE-2019-17347 CVE-2019-17346<br />CVE-2019-17345 CVE-2019-17344 CVE-2019-17343 CVE-2019-17342<br />CVE-2019-17341 CVE-2019-17340<br /><br />Multiple vulnerabilities have been discovered in the Xen hypervisor, which<br />could result in denial of service, guest-to-host privilege escalation or<br />information leaks.<br /><br />For more information, see https://security-tracker.debian.org/tracker/xen | 3.7.11-3.7.14.2 | |
| <a name="2546985"></a> [2546985](#2546985) <a name="2546985"></a> <br />CM-27999 | On the EdgeCore AS7326-56X switch, the PSU fans show constant LOW warnings. | 3.7.10-3.7.12, 4.0.0-4.2.0 | 3.7.13-3.7.14, 4.2.1-4.3.0|
| <a name="2546951"></a> [2546951](#2546951) <a name="2546951"></a> <br />CM-27982 | <code>switchd</code> crashes when dynamic VRF route leaking is enabled and the following is true:<br />* The default route is leaked from VRF1 to VRF2<br />* Hardware-based dynamic VRF route leaking is configured (<code>vrf_route_leak_enable_dynamic</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file). <br />You might see logs similar to the following in <code>/var/log/syslog</code>:<br /><pre><br />kernel: &#91;159400.526241&#93; switchd&#91;21374&#93;: segfault at 1229cdd84 ip 00000000004142ca sp 00007ffd557a86d0 error 4 in switchd&#91;400000+71000&#93;<br /></pre><br />To work around this issue, use a route map to filter the default route (the source VRF is imported into the destination VRF). | 3.7.10-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2546895"></a> [2546895](#2546895) <a name="2546895"></a> <br />CM-27957 | If you have configured a higher number of ports and VLANs (ports x VLANs) or the switch is a lower-powered (CPU) platform, the <code>switchd</code> service might fail to send a <code>systemd keepalive</code> within the watchdog timeout value (2 minutes by default) and you see an error similar to the following:<br /><pre><br />bq. systemd&#91;1&#93;: switchd.service watchdog timeout (limit 2min)!<br /></pre><br />To workaround this issue, either reduce the number of configured interfaces and, or VLANs, or increase the <code>systemd</code> timeout for <code>switchd.service</code>.<br />To increase the <code>systemd</code> timeout:<br /># Edit the <code>/etc/systemd/system/switchd.service.d/override.conf</code> file and increase the <code>WatchdogSec</code> parameter.<br /># Restart the <code>switchd</code> service with the <code>sudo systemctl restart switchd.service</code> command.<br /><code>systemd</code> will attempt to restart the <code>switchd</code> service automatically (after the watchdog timeout). If the restart fails multiple times in a short time period, run the <code>sudo systemctl reset-failed</code> command followed by the <code>sudo systemctl restart switchd</code> command.<br /> | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546848"></a> [2546848](#2546848) <a name="2546848"></a> <br />CM-27937 | Debian security advisory DSA-4213 for qemu lists a number of security vulnerabilities.<br />https://www.debian.org/security/2018/dsa-4213<br />One of the listed vulnerabilities is still present in the latest upstream version 2.1+dfsg-12+deb8u12 (the others have been fixed):<br />CVE-2017-15124 Daniel Berrange discovered that the integrated VNC server insufficiently restricted memory allocation, which could result in denial of service.<br />https://security-tracker.debian.org/tracker/CVE-2017-15124 | 3.7.11-3.7.14.2 | |
| <a name="2546577"></a> [2546577](#2546577) <a name="2546577"></a> <br />CM-27814 | A traditional bridge with QinQ and a VNI does not work for tagged traffic. | 3.7.10-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2546542"></a> [2546542](#2546542) <a name="2546542"></a> <br />CM-27793 | A security vulnerability has been announced in the cyrus-sasl2 (libsasl2-2 and libsasl2-modules) package. The libraries are installed by default on Cumulus Linux.<br />CVE-2019-19906: Stephan Zeisberg reported an out-of-bounds write vulnerability in the _sasl_add_string() function in cyrus-sasl2, a library implementing the Simple Authentication and Security Layer. A remote attacker can take advantage of this issue to cause denial-of-service conditions for applications using the library.<br />Vulnerable: 2.1.27+dfsg-1<br />Fixed: 2.1.27+dfsg-1+deb10u1 | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2546385"></a> [2546385](#2546385) <a name="2546385"></a> <br />CM-27698 | SNMP ifLastChange reports link transitions when there are none. | 3.7.6-3.7.14.2 | |
| <a name="2546267"></a> [2546267](#2546267) <a name="2546267"></a> <br />CM-27646 | Several vulnerabilities have been discovered in Git, a fast, scalable,<br />distributed revision control system, which is available in the Cumulus Linux 3.x repositories for optional installation.<br />CVE-2019-1348: export-marks is insecure, fix is to disable by default.<br />CVE-2019-1349: .git / git~1 filename vulnerability on NTFS<br />CVE-2019-1352: .git vulnerability with NTFS Alternate Streams Accesses<br />CVE-2019-1353: NTFS filesystem protection should be on by default<br />CVE-2019-1387: dubiously-nested submodule git directories should be disallowed<br />CVE-2019-19604: submodule update repository code execution vulnerability<br />Vulnerable: <= 2.1.4-2.1+deb8u7<br />Fixed: 2.1.4-2.1+deb8u8 | 3.7.10-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2546225"></a> [2546225](#2546225) <a name="2546225"></a> <br />CM-27627 | When you execute the following command on the Delta AG6248C switch, the switch reboots and then comes right back into Cumulus Linux without installing the new image. The install image is still in <code>/var/lib/cumulus/installer</code>, which causes issues with cl-support. <br /> <pre> <br /> sudo onie-install -fai http://<path to image> <br /> sudo reboot <br /> </pre> <br /> To work around this issue, use the <code>onie-select</code> command to access ONIE, and then use the <code>nos-install</code> command in ONIE to install a new binary image.  | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546203"></a> [2546203](#2546203) <a name="2546203"></a> <br />CM-27620 | When using QinQ with a traditional bridge, if you enable the LLDP dot1 TLV option, you see the following suboptimal behavior:<br />* Both the inner and outer VLAN information is sent as part of VLAN TLVs in the LLDP packet. <br />* If the outer VLAN ID is the same as the inner VLAN ID, only one VLAN TLV is sent with that VLAN ID in the LLDP packet. | 3.7.11-3.7.14.2 | |
| <a name="2546141"></a> [2546141](#2546141) <a name="2546141"></a> <br />CM-27586 | CPU usage might be higher than normal if you have a high number of interfaces x VLANs and <code>lldpd</code> is active. This issue is introduced with code changes in Cumulus Linux 3.7.11, where VLAN information is now available for LLDP to advertise to neighbors (&#91;https://docs.cumulusnetworks.com/version/cumulus-linux-37/Layer-2/Link-Layer-Discovery-Protocol/#vlan-dot1-tlv&#93;). You might see high CPU usage even if VLAN (dot1) TLV configuration is disabled. <br />To check if <code>lldpd</code> is the heavy CPU resource user, run the following command:<br /><pre><br />cumulus&#64;switch:~$  ps -eo user,pid,ppid,cmd,%mem,%cpu --sort=-%cpu \| head<br /></pre><br />Alternatively, check for messages in the <code>/var/log/syslog</code> directory similar to:<br /><pre><br />2020-02-20T15:02:12.137857-05:00 leaf01 sysmonitor: High CPU use: 87%<br />2020-02-20T15:02:12.482398-05:00 leaf01 sysmonitor:   PID USER      PR    VIRT    RES %CPU %MEM     TIME+ COMMAND<br />2020-02-20T15:02:12.483112-05:00 leaf01 sysmonitor:  1570 _lldpd    20   73244  13800 76.6  0.3   4:43.06 lldpd<br /></pre><br />*Note*: The exact amount of CPU usage varies in each network based on a number of factors; however, it is unusual for <code>lldpd</code> to consume more than 30% CPU for an extended period of time.<br />To work around this issue, you can do one of the following:<br />* If the large number of VLANs is not absolutely necessary, manually prune the VLAN allowed list (if you use the range 1-2999, modify the <code>bridge-vids</code> list to include the VLANs being used).<br />* Stop the <code>lldpd</code> service. (This approach might be undesirable if the switch is providing services that rely on LLDP such as Voice VLAN.) To stop the <code>lldpd</code> service (runtime setting), run the <code>sudo systemctl stop lldpd.service</code> command. To disable the <code>lldpd</code> service upon boot, run <code>sudo systemctl disable lldpd.service</code>. | 3.7.11-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2546131"></a> [2546131](#2546131) <a name="2546131"></a> <br />CM-27581 | On the Delta AG-6248C PoE switch, when you run the <code>apt upgrade</code> command, the upgrade does not work. Cumulus Linux uses <code>uboot</code> directly instead of <code>grub</code> to boot the kernel. Uboot needs a special header to boot the kernel, which is not present. Without this header, when you use the <code>apt upgrade</code> command to upgrade Linux packages, <code>uboot</code> is unable to boot up the kernel. <br />To work around this issue, upgrade Cumulus Linux by installing the Cumulus Linux image. Run the <code>onie-select</code> command to go into ONIE, and then use the <code>nos-install</code> command in ONIE to install a new image.<br />This workaround only works when an out-of-band network is present. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546010"></a> [2546010](#2546010) <a name="2546010"></a> <br />CM-27530 | When <code>hal.bcm.per_vlan_router_mac_lookup</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file, inter-VLAN traffic is forwarded to the CPU when associated VNI interfaces exist. | 3.7.10-3.7.14.2 | |
| <a name="2545997"></a> [2545997](#2545997) <a name="2545997"></a> <br />CM-27522 | The NCLU command <code>net show interface</code> produces an error if bonds with no members exist.<br />To work around this issue, remove the empty Bond interfaces from the <code>/etc/network/interfaces</code> file and run <code>sudo ifreload -a</code>. | 3.7.10-3.7.14.2 | |
| <a name="2545699"></a> [2545699](#2545699) <a name="2545699"></a> <br />CM-27354 | On the Celestica Pebble switch, if you use IPv6 routes with mask /65 to /127,  the <code>switchd</code> log fills with errors. | 3.7.10-3.7.13 | 3.7.14-3.7.14.2, 4.1.0-4.3.0|
| <a name="2545566"></a> [2545566](#2545566) <a name="2545566"></a> <br />CM-27272 | The Dell Z9100-ON switch incorrectly reports many sensors as ABSENT. | 3.7.12-4.0.1 | 4.1.0-4.3.0|
| <a name="2545446"></a> [2545446](#2545446) <a name="2545446"></a> <br />CM-27192 | If you use NCLU commands to add a non-MLAG bond, then add an MLAG configuration, the <code>net commit</code> command fails. However, a subsequent <code>net commit</code> command succeeds. | 3.7.10-3.7.14.2 | |
| <a name="2545404"></a> [2545404](#2545404) <a name="2545404"></a> <br />CM-27173 | On the Trident3 switch, unicast ARP packets received on a VNI and forwarded to the CPU are not policed. | 3.7.10-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2545125"></a> [2545125](#2545125) <a name="2545125"></a> <br />CM-27018 | If you configure more than one VRR interface on an SVI interface, deleting one of the VRR addresses does not remove the interface/address.  | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544978"></a> [2544978](#2544978) <a name="2544978"></a> <br />CM-26921 | If you delete an undefined bond, then add a bond slave, the <code>net commit</code> command fails. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544968"></a> [2544968](#2544968) <a name="2544968"></a> <br />CM-26913 | FRR configuration commands for an SVI interface might have the <code>\n</code> misplaced in the output.  For example:<br /><pre><br />sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />should be:<br /><pre><br />sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />To work around this issue, configure the interface manually in the <code>/etc/frr/frr.conf</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544953"></a> [2544953](#2544953) <a name="2544953"></a> <br />CM-26905 | When you update the hostname of a switch with the NCLU <code>net add hostname <hostname></code> command, then run <code>net commit</code>, the <code>lldpd</code> service does not restart and other devices still see the old hostname.<br />To work around this issue, run the <code>sudo systemctl restart lldpd.service</code> command. | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544904"></a> [2544904](#2544904) <a name="2544904"></a> <br />CM-26875 | After you delete an IPv6 numbered BGP peer group neighbor, Cumulus Linux might continue to send route advertisements.<br />To work around this issue, restart FRR after removing the IPv6 numbered configuration. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544556"></a> [2544556](#2544556) <a name="2544556"></a> <br />CM-26655 | If you reconfigure an NTP server with NCLU using different trailing options after the IP address (such as <code>iburst</code>), an invalid configuration is added to the <code>/etc/ntp.conf</code> file. For example:<br /><pre><br />net add time ntp server 1.2.3.4 iburst<br />net commit<br />net add time ntp server 1.2.3.4<br />net commit<br /></pre><br />If you need to alter existing server configurations, first remove the server, commit, then re-add the server with any trailing options. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544463"></a> [2544463](#2544463) <a name="2544463"></a> <br />CM-26599 | Auto-negotiation does not work with the QSFP28 cables and a remote system operating at 10G. Attempting to enable auto-negotiation with <code>ethtool -s swp<#> autoneg on</code> returns <code>Operation not supported</code>.<br />To work around this issue, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544456"></a> [2544456](#2544456) <a name="2544456"></a> <br />CM-26595 | The NCLU <code>net show lldp</code> command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544235"></a> [2544235](#2544235) <a name="2544235"></a> <br />CM-26463 | The following CVEs affect the linux kernel package:<br />CVE-2019-14821 CVE-2019-14835 CVE-2019-15117 CVE-2019-15118 CVE-2019-15902<br />Several vulnerabilities have been discovered in the Linux kernel that<br />may lead to a privilege escalation, denial of service or information<br />leaks.<br />For the detailed security status of linux,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/linux | 3.7.10-3.7.14.2 | |
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544113"></a> [2544113](#2544113) <a name="2544113"></a> <br />CM-26412 | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address changing between the MLAG bond and the peer link.<br />To work around this issue, disable MAC learning on QinQ VLANs by adding <code>bridge-learning off</code> to the VLAN stanza in the <code>etc/network/interfaces</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543900"></a> [2543900](#2543900) <a name="2543900"></a> <br />CM-26288 | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543841"></a> [2543841](#2543841) <a name="2543841"></a> <br />CM-26256 | The <code>net show evpn vni detail json</code> command includes an extra empty dictionary at the end of the output. <br /> | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543800"></a> [2543800](#2543800) <a name="2543800"></a> <br />CM-26230 | When <code>local-tunnelip</code> is an SVI, the static VXLAN tunnel does not work; the next hop router receives the packet but drops it as it does not know where to forward the packet. The static VXLAN tunnel does works if <code>local-tunnelip</code> is a loopback or a physical layer 3 interface. <br /> | 3.7.8-3.7.14 | 4.0.0-4.3.0|
| <a name="2543792"></a> [2543792](#2543792) <a name="2543792"></a> <br />CM-26225 | On the EdgeCore AS5712, AS6712, AS5812 and AS6812 switch, support for multiple PSU types results in log messages similar to the following:<br /><pre><br />2019-09-05T05:15:17.246597+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.274521+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br />2019-09-05T05:15:17.469556+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.497514+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br /></pre> | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543649"></a> [2543649](#2543649) <a name="2543649"></a> <br />CM-26138 | You cannot specify a source and destination MAC address in an ERSPAN ebtables rule. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i swp5 -s 00:25:90:b2:bd:9d -d 50:6b:4b:96:c4:04 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | 4.3.0|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543627"></a> [2543627](#2543627) <a name="2543627"></a> <br />CM-26126 | Tomahawk 40G DACs cannot disable auto-negotiation. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543472"></a> [2543472](#2543472) <a name="2543472"></a> <br />CM-26024 | On switches with the Spectrum ASIC, the underlay hashes VXLAN packets for a given overlay flow randomly.<br />To work around this issue, configure the ECMP hash seed to the same value on the EVPN egress leaf switches. | 3.7.7-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543270"></a> [2543270](#2543270) <a name="2543270"></a> <br />CM-25923 | The default route injected through OSPF when you configure <code>default-information originate always</code> is unreliable and might age out unexpectedly.<br />To work around this issue, rely on a different source of default route other than injection with <code>default-information originate</code>. | 3.7.8-4.1.1 | 4.2.0-4.3.0|
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543058"></a> [2543058](#2543058) <a name="2543058"></a> <br />CM-25798 | The IP neighbor entry for a link-local next hop is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces.<br />To work around this issue, flap the peering to the peer router (which might be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543052"></a> [2543052](#2543052) <a name="2543052"></a> <br />CM-25796 | Received EVPN type-5 and type-2 MACIP routes are not installed in the kernel (and hardware) routing tables for the associated VRF, which causes traffic to be blackholed. The failure to install the default route causes complete reachability failure for the particular tenant on the affected racks. The routes that are not installed are seen as "inactive" in the routing subsystem (FRR) VRF routing table. This problem is rare and can occur only in EVPN configurations that have user-configured route targets (RTs) for tenant VRFs, and only following a restart of FRR.<br />To work around this issue, either restart the FRR service on the affected switch with the <code>sudo systemctl restart frr.service</code> command or bounce the layer 3 SVI for the affected VRF; for example:<br /><pre><br />ifdown vlan123 ; sleep 2 ; ifup vlan123<br /></pre><br />You can run the <code>net show vrf vni</code> command to print a mapping of VRF : L3-VNI : L3-SVI. | 3.7.5-3.7.14 | 4.0.0-4.3.0|
| <a name="2543044"></a> [2543044](#2543044) <a name="2543044"></a> <br />CM-25794 | Under certain conditions, EVPN next hops might not be removed when the contributing peer goes down or might not be populated when the BGP session to the contributing peer comes up.<br />You can prevent EVPN next hops from not being removed when the contributing peer goes down by specifying static MAC addresses on all layer 3 VNIs. There is no workaround for preventing EVPN next hops from not being populated when the BGP session to the contributing peer comes up. | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2542979"></a> [2542979](#2542979) <a name="2542979"></a> <br />CM-25766 | On the Dell-N3048EP-ON switch, when you run the <code>sudo -E apt upgrade</code> command, the upgrade does not work.  | 3.7.7-4.1.1 | 4.2.0-4.3.0|
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542767"></a> [2542767](#2542767) <a name="2542767"></a> <br />CM-25641 | If the BMC operating system fails to respond to IPMI, you see a traceback in <code>bmcd</code> and all the sensors might report ABSENT devices in <code>smonctl</code>. <br />To work around this issue, power cycle the switch. <br />  | 3.7.6-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2542310"></a> [2542310](#2542310) <a name="2542310"></a> <br />CM-25404 | <code>hsflow</code> disregards the setting for <code>agent.cidr</code> in the <code>/etc/hsflowd.conf</code> file and selects an IPv6 agent address. The source IP address of the hsflowd packet is IPv4, but the agent address in the <code>hsflow</code> payload shows IPv6. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541165"></a> [2541165](#2541165) <a name="2541165"></a> <br />CM-24878 | On the Dell N3048EP-ON switch, UPOE is supported only on ports 1 thru 12. (UPOE uses all four pairs of standard Ethernet cabling whereas PoE delivers power over two twisted pairs.) When you plug a UPOE device in a port higher than port 12, <code>poectl</code> reports that <code>four_pair_mode_enabled</code> is true. However, this configuration is not supported on the port so <code>poectl</code> should report that <code>four_pair_mode_enabled</code> is false. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540950"></a> [2540950](#2540950) <a name="2540950"></a> <br />CM-24751 | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switch, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status.<br />  | 3.7.3-4.1.1 | 4.2.0-4.3.0|
| <a name="2540885"></a> [2540885](#2540885) <a name="2540885"></a> <br />CM-24703 | The Dell N3048EP-ON switch does not support 1G Base-T modules in the SFP ports. | 3.7.7-3.7.14.2 | |
| <a name="2540863"></a> [2540863](#2540863) <a name="2540863"></a> <br />CM-24686 | On the EdgeCore AS5812-54X switch, the PSU2 Fan1 fluctuates between OK and LOW. When the fan speed is reported as LOW, the RPM is shown as a negative number. <br /> | 3.7.3-3.7.14 | 4.0.0-4.3.0|
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539081"></a> [2539081](#2539081) <a name="2539081"></a> <br />CM-23792 | When you delete post-up and pre-down IP peer entries from the <code>etc/network/interfaces</code> file, then run the <code>ifreload</code> command, the IP addresses are not removed and the route remains in the route table. <br />To work around this issue, either delete the IP addresses without the /32 mask component or flush the IP addresses for the interface with the <code>ip addr flush dev <interface></code> command. <br /> | 3.7.0-3.7.14 | 4.0.0-4.3.0|
| <a name="2538875"></a> [2538875](#2538875) <a name="2538875"></a> <br />CM-23696 | IPv6 multicast traffic destined to an unregistered multicast group is flooded to all ports in a bridge despite the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/swichd.conf</code> file. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538302"></a> [2538302](#2538302) <a name="2538302"></a> <br />CM-23422 | <code>portwd</code> allows an error to change the module type based on the error. For example, a bad write to a module might cause the module type to flap, which causes the link itself to flap. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538256"></a> [2538256](#2538256) <a name="2538256"></a> <br />CM-23397 | On the Broadcom switch, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets. <br />  | 3.7.2-4.0.1 | 4.1.0-4.3.0|
| <a name="2537823"></a> [2537823](#2537823) <a name="2537823"></a> <br />CM-23125 | The OpenSSL package on Cumulus Linux 3.x has a vulnerability similar to CVE-2018-0734. (The OpenSSL DSA signature algorithm has been shown to be vulnerable to a timing side channel attack. An attacker could use variations in the signing algorithm to recover the private key).  According to Debian upstream, this version "is not vulnerable &#91;to CVE-2018-0734 exactly&#93;. Nevertheless, there is a bug fix that futher reduces the amount of leaked timing information. It got no CVE on its own and introduced this vulnerability."<br />Vulnerable on CL3: 1.0.1t-1+deb8u12 | 3.7.11-3.7.14.2 | |
| <a name="2537820"></a> [2537820](#2537820) <a name="2537820"></a> <br />CM-23123 | When you enable FEC (RS or BaseR) on an interface, removing the configuration from that interface does not revert the FEC status to off/none. <br /> | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537544"></a> [2537544](#2537544) <a name="2537544"></a> <br />CM-23021 | When you run the <code>mstpctl</code> command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of <code>mstpctl</code>; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | 4.3.0|
| <a name="2537514"></a> [2537514](#2537514) <a name="2537514"></a> <br />CM-23004 | The local fallback account authenticates using the local password when the RADIUS or TACACS service is up. The expected behavior is for this to fail and only succeed when the RADIUS OR TACACS server fails to respond. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537378"></a> [2537378](#2537378) <a name="2537378"></a> <br />CM-22937 | NCLU SNMPv3 user configuration (add, delete, modify) does not complete. Changes are made to the <code>/etc/snmp/snmpd.conf</code> file but the SNMPv3 user cache file <code>/var/lib/snmp/snmpd.conf</code> fails to update correctly and the configuration does not reflect in operation. <br />To work around this issue, stop <code>snmpd</code>, remove the cache file, then restart <code>snmpd</code>. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537188"></a> [2537188](#2537188) <a name="2537188"></a> <br />CM-22849 | When an event in the network, such as a <code>switchd</code> or networking service restart, leads to an OVSDB server high availability transition, an <code>ovs-vtepd</code> core might occur. <br />This core generation has no effect on the functionality of high availability when the active OVSDB server is back in the network. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2537104"></a> [2537104](#2537104) <a name="2537104"></a> <br />CM-22808 | When you try to stop <code>hsflowd</code> on the Trident II+ switch with the <code>systemctl stop hsflowd</code> command, the process hangs until you stop it with <code>SIGKILL</code>. <br /> | 3.7.1-3.7.14 | 4.0.0-4.3.0|
| <a name="2537061"></a> [2537061](#2537061) <a name="2537061"></a> <br />CM-22794 | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent. <br /> | 3.7.1-4.0.1 | 4.1.0-4.3.0|
| <a name="2536608"></a> [2536608](#2536608) <a name="2536608"></a> <br />CM-22583 | Single tagged ARP requests received on a QinQ-over-VXLAN access port are dropped if ARP suppression is enabled on an unrelated VNI. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on protocol sockets.<br />When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a <code>switchd</code> restart. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535965"></a> [2535965](#2535965) <a name="2535965"></a> <br />CM-22020 | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br />To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2534394"></a> [2534394](#2534394) <a name="2534394"></a> <br />CM-20480 | The python-crypto package, which is not installed by default on Cumulus Linux, but is present in the repository to be installed, has the following security vulnerability in the version available for Cumulus Linux 3.x:<br />CVE-2018-6594: lib/Crypto/PublicKey/ElGamal.py in PyCrypto through 2.6.1 generates weak ElGamal key parameters, which allows attackers to obtain sensitive information by reading ciphertext data (i.e., it does not have semantic security in face of a ciphertext-only attack). The Decisional Diffie-Hellman (DDH) assumption does not hold for PyCrypto's ElGamal implementation.<br />More information at https://security-tracker.debian.org/tracker/CVE-2018-6594 . | 3.7.9-3.7.14.2 | |
| <a name="2533691"></a> [2533691](#2533691) <a name="2533691"></a> <br />CM-19788 | If you configure a VLAN under a VLAN-aware bridge and create a subinterface of the same VLAN on one of the bridge ports, the bridge and interface compete for the same VLAN and if the interface is flapped, it stops working. Correcting the configuration and running the <code>ifreload</code> command does not resolve the conflict. <br />To work around this issue, correct the bridge VIDs and restart <code>switchd</code> or delete the subinterface.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2532017"></a> [2532017](#2532017) <a name="2532017"></a> <br />CM-18192 | In FRR, <code>bgp_snmp</code> does not show all BGP peers when peer groups used. | 3.7.11-4.0.1 | 4.1.0-4.3.0|

### Fixed Issues in 3.7.12
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="2547878"></a> [2547878](#2547878) <a name="2547878"></a> <br />CM-28486 | The following vulnerability has been found in the <code>libgcrypt20</code> cryptographic library.<br />CVE-2019-13627: there was a ECDSA timing attack.<br />For more information, see https://www.debian.org/lts/security/2020/dla-1931-2.en.html<br />Vulnerable: 1.6.3-2+deb8u7<br />Fixed: 1.6.3-2+deb8u8 | 3.7.11 | |
| <a name="2547876"></a> [2547876](#2547876) <a name="2547876"></a> <br />CM-28485 | The following vulnerability affects libxml2:<br />CVE-2019-19956: xmlParseBalancedChunkMemoryRecover in parser.c has a memory leak related to newDoc->oldNs.  This can lead to a denial of service.<br />For more information, see https://www.debian.org/lts/security/2019/dla-2048.en.html .<br />Vulnerable: 2.9.1+dfsg1-5+deb8u7<br />Fixed: 2.9.1+dfsg1-5+deb8u8 | 3.7.11 | |
| <a name="2547874"></a> [2547874](#2547874) <a name="2547874"></a> <br />CM-28484 | The following vulnerability affects libbsd, a package containing utility functions from BSD systems.<br />CVE-2016-2090: In function fgetwln() an off-by-one error could triggers a heap buffer overflow.<br />For more information, see https://www.debian.org/lts/security/2019/dla-2052.en.html .<br />Vulnerable: 0.7.0-2<br />Fixed: 0.7.0-2+deb8u1 | 3.7.11 | |
| <a name="2547558"></a> [2547558](#2547558) <a name="2547558"></a> <br />CM-28313 | On the EdgeCore Wedge100 and Facebook Wedge-100S switch, certain physical ports are not correctly mapped to the logical ones. For example:<br />Logical swp39 controls physical swp41<br />Logical swp40 controls physical swp42<br />Logical swp43 controls physical swp45<br />Logical swp44 controls physical swp46<br />This might causes incorrect forwarding behavior. | 3.7.11, 4.0.0-4.0.1 | |
| <a name="2547509"></a> [2547509](#2547509) <a name="2547509"></a> <br />CM-28276 | When a Trident3 switch receives packets containing an IP checksum value that is not compliant with RFC 1624, the TTL is decremented after a routing operation but the checksum is not recalculated. This results in the IP checksum value being invalid as the packet leaves the switch.  | 3.7.10-3.7.11, 4.0.0-4.0.1 | |
| <a name="2547400"></a> [2547400](#2547400) <a name="2547400"></a> <br />CM-28222 | The following security vulnerability has been announced in qemu, which is not installed by default on Cumulus Linux but is available in the repository for optional installation:<br />CVE-2020-7039: tcp_emu in tcp_subr.c in libslirp 4.1.0, as used in QEMU 4.2.0, mismanages memory, as demonstrated by IRC DCC commands in EMU_IRC. This can cause a heap-based buffer overflow or other out-of-bounds access which can lead to a DoS or potential execute arbitrary code.<br />Vulnerable: <= 2.1+dfsg-12+deb8u12<br />Fixed: 2.1+dfsg-12+deb8u13 | 3.7.11 | |
| <a name="2547303"></a> [2547303](#2547303) <a name="2547303"></a> <br />CM-28169 | On the Dell Z9264F-ON switch, the CPU core temperature sensors report ABSENT. | 3.7.11, 4.0.0-4.0.1 | |
| <a name="2547155"></a> [2547155](#2547155) <a name="2547155"></a> <br />CM-28091 | Two security issues were found in the Python interface to the apt package manager, which is installed by default on Cumulus Linux; package downloads from unsigned repositories were incorrectly rejected (CVE-2019-15796) and the hash validation relied on MD5 (CVE-2019-15795).<br />For more information, refer to https://security-tracker.debian.org/tracker/source-package/python-apt<br />Vulnerable: 0.9.3.12<br />Fixed: 0.9.3.13 | 3.7.11 | |
| <a name="2547149"></a> [2547149](#2547149) <a name="2547149"></a> <br />CM-28087 | The last eight ports of the EdgeCore AS4610-54P switch (swp41 through swp48) do not power UPOE access points. | 3.7.11, 4.0.0-4.0.1 | |
| <a name="2547122"></a> [2547122](#2547122) <a name="2547122"></a> <br />CM-28077 | An unhandled exception might occur after you run the <code>sudo poectl -i</code> command. In addition, random <code>poed</code> daemon restarts can occur without any unhandled exceptions but with an invalid response length error. Both issues can occur due to a SerialException.<br />To work around this issue, power cycle the switch. A software reboot does not resolve the issue. | 3.7.10-3.7.11, 4.0.0-4.0.1 | |
| <a name="2547106"></a> [2547106](#2547106) <a name="2547106"></a> <br />CM-28065 | Editing the outbound route-map of a BGP peer causes all received prefixes by that BGP peer to reset and reinstall. This might cause a brief impact to traffic for those prefixes. | 3.7.11 | |
| <a name="2547071"></a> [2547071](#2547071) <a name="2547071"></a> <br />CM-28048 | On the Lenovo NE2580 switch, the fan speeds are higher than expected within normal operating conditions. | 3.7.11, 4.0.0-4.0.1 | |
| <a name="2547043"></a> [2547043](#2547043) <a name="2547043"></a> <br />CM-28038 | After you convert a bond back to a layer 2 access port, ifupdown2 changes all SVI MTUs to 1500. <br />To work around this issue, run <code>ifreload -a</code> a second time. | 3.7.11, 4.0.0-4.0.1 | |
| <a name="2547013"></a> [2547013](#2547013) <a name="2547013"></a> <br />CM-28016 | On the Mellanox Spectrum switch, <code>switchd</code> can sometimes fail when PBR rules are installed or removed from hardware if the rule is setting a next hop learned via a routing protocol. | 3.7.7-3.7.11, 4.0.0-4.0.1 | |
| <a name="2546999"></a> [2546999](#2546999) <a name="2546999"></a> <br />CM-28007 | When you configure Cumulus Linux with a /32 address on a switch port with a configured peer address (for example, to connect to a device using IP unnumbered), the switch sends GARPs for the peer address. | 3.7.5-3.7.11 | |
| <a name="2546869"></a> [2546869](#2546869) <a name="2546869"></a> <br />CM-27947 | Broadcom Field Alert - SID - MMU 2B Errors<br />A few of the MMU memories on Broadcom switches are grouped together with single parity control. During SER correction when a parity error occurs on one of those groups, other memory in that group might also report a SER error. This occurs when the memory is accessed either by a packet hit or through a schan operation. This issue can cause SER errors in other memory and cause traffic mis-forwarding or a packet drop. | 3.7.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="2546815"></a> [2546815](#2546815) <a name="2546815"></a> <br />CM-27927 | On the Delta AG6248C switch, the NCLU <code>net show system sensors</code> command shows an error:<br /><pre><br />Could not collect output from command: &#91;'/usr/sbin/smonctl'&#93;<br /></pre><br />To work around this issue, run the <code>net show system sensors json</code> command instead. | 3.7.11 | |
| <a name="2546810"></a> [2546810](#2546810) <a name="2546810"></a> <br />CM-27924 | A security vulnerability has been announced in the cyrus-sasl2 (libsasl2-2 and libsasl2-modules) package. The libraries are installed by default on Cumulus Linux.<br />CVE-2019-19906: Stephan Zeisberg reported an out-of-bounds write vulnerability in the _sasl_add_string() function in cyrus-sasl2, a library implementing the Simple Authentication and Security Layer. A remote attacker can take advantage of this issue to cause denial-of-service conditions for applications using the library.<br />Vulnerable: 2.1.26.dfsg1-13+deb8u1<br />Fixed: 2.1.26.dfsg1-13+deb8u2 | 3.7.11 | |
| <a name="2546703"></a> [2546703](#2546703) <a name="2546703"></a> <br />CM-27855 | The FRR cl-support module times out on switches on the ARM platform even when the switch is not under heavy load.<br />To work around this issue, run the <code>cl-support -M</code> command to disable timeouts. | 3.7.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="2546564"></a> [2546564](#2546564) <a name="2546564"></a> <br />CM-27804 | You might see a <code>switchd</code> memory leak during ECMP group expansion or consolidation. | 3.7.10-3.7.11 | |
| <a name="2546502"></a> [2546502](#2546502) <a name="2546502"></a> <br />CM-27764 | On the EdgeCore AS7326-56X switch, eth0 and swp1 use the same MAC address. | 3.7.9-3.7.11, 4.0.0-4.0.1 | |
| <a name="2546354"></a> [2546354](#2546354) <a name="2546354"></a> <br />CM-27683 | The following CVEs were announced that affect the Linux kernel:<br />CVE-2019-12378: An issue was discovered in ip6_ra_control in net/ipv6/ipv6_sockglue.c in the Linux kernel through 5.1.5. There is an unchecked kmalloc of new_ra, which might allow an attacker to cause a denial of service (NULL pointer dereference and system crash).<br />CVE-2019-12381: An issue was discovered in ip_ra_control in net/ipv4/ip_sockglue.c in the Linux kernel through 5.1.5. There is an unchecked kmalloc of new_ra, which might allow an attacker to cause a denial of service (NULL pointer dereference and system crash).<br />CVE-2019-15239: In the Linux kernel, a certain net/ipv4/tcp_output.c change, which was properly incorporated into 4.16.12, was incorrectly backported to the earlier longterm kernels, introducing a new vulnerability that was potentially more severe than the issue that was intended to be fixed by backporting. Specifically, by adding to a write queue between disconnection and re-connection, a local attacker can trigger multiple use-after-free conditions. This can result in a kernel crash, or potentially in privilege escalation. <br />CVE-2019-19062: A memory leak in the crypto_report() function in crypto/crypto_user_base.c in the Linux kernel through 5.3.11 allows attackers to cause a denial of service (memory consumption) by triggering crypto_report_alg() failures, aka CID-ffdde5932042.<br />CVE-2019-19537: In the Linux kernel before 5.2.10, there is a race condition bug that can be caused by a malicious USB device in the USB character device driver layer, aka CID-303911cfc5b9. This affects drivers/usb/core/file.c.<br />CVE-2019-20054: In the Linux kernel before 5.0.6, there is a NULL pointer dereference in drop_sysctl_table() in fs/proc/proc_sysctl.c, related to put_links, aka CID-23da9588037e. | 3.7.11 | |
| <a name="2546329"></a> [2546329](#2546329) <a name="2546329"></a> <br />CM-27670 | A memory leak in <code>switchd</code> might occur, which causes <code>switchd</code> to restart. | 3.7.10-3.7.11, 4.0.0-4.0.1 | |
| <a name="2546265"></a> [2546265](#2546265) <a name="2546265"></a> <br />CM-27644 | Ifupdown2 does not set up the front panel interface for the <code>dhclient</code> to accept the DHCP OFFER.<br />To work around this issue, restart the networking service after <code>ifreload -a</code> with the <code>systemctl restart networking</code> command. | 3.7.10-3.7.11, 4.0.0-4.0.1 | |
| <a name="2546003"></a> [2546003](#2546003) <a name="2546003"></a> <br />CM-27525 | On the Delta AG6248C PoE switch, if the PoE priority is set to low on some ports, other ports with a higher priority might have their requests to draw power rejected instead of the lower priority ports being brought down. | 3.7.11 | |
| <a name="2545972"></a> [2545972](#2545972) <a name="2545972"></a> <br />CM-27507 | The <code>ports.conf</code> file on the Dell S5248F-ON switch does not show port ganging or breakout options. | 3.7.10-3.7.11 | |
| <a name="2545949"></a> [2545949](#2545949) <a name="2545949"></a> <br />CM-27496 | All Broadcom Trident3 X7 switches contain PCIE firmware, which is programmed by the vendor when the switch is manufactured. The latest version of this firmware (2.6) is incompatible with Cumulus Linux 3.7.11 and earlier, and Cumulus Linux 4.0. <br />To work around this issue, downgrade the Broadcom ASIC firmware to an earlier version. | 3.7.11, 4.0.0-4.0.1 | |
| <a name="2545837"></a> [2545837](#2545837) <a name="2545837"></a> <br />CM-27444 | If you use the NCLU commands to configure NTP and run the <code>net add time ntp source <interface></code> command before you run the <code>net add time ntp server <server> iburst</code> command, the <code>/etc/ntp.conf</code> file is misconfigured.<br />To work around this issue, run the <code>net add time ntp server <server> iburst</code> command before you run the <code>net add time ntp source <interface></code> command. | 3.7.10-3.7.11, 4.0.0-4.3.0 | |
| <a name="2545600"></a> [2545600](#2545600) <a name="2545600"></a> <br />CM-27295 | IPv6 table rules might affect forwarding. For example, if you create the following rule in the <code>/etc/cumulus/acl/policy.d/03-sshd.rules</code> file, the rule counter increments but IPv4 SSH traffic might be dropped.<br /><pre><br />&#91;ip6tables&#93;<br />-A INPUT -p tcp --dport 22 -j DROP<br /></pre> | 3.7.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="2545316"></a> [2545316](#2545316) <a name="2545316"></a> <br />CM-27120 | When an interface flap occurs, numbered IPv6 BGP sessions might fail to establish.<br />To work around this issue, run the <code>ip -6 route flush cache <IPv6-address></code> command to flush the IPv6 route cache. | 3.7.9-3.7.11 | |
| <a name="2544937"></a> [2544937](#2544937) <a name="2544937"></a> <br />CM-26894 | The <code>neighmgrd</code> service does not ignore neighbors on reserved devices (lo and management devices).  This issue is not seen when management VRF is enabled. | 3.7.8-3.7.11 | |
| <a name="2544854"></a> [2544854](#2544854) <a name="2544854"></a> <br />CM-26839 | On the Dell S5248F-ON switch, CPU core temp sensors may show as ABSENT. | 4.0.0-4.0.1 | |
| <a name="2544012"></a> [2544012](#2544012) <a name="2544012"></a> <br />CM-26351 | After you remove a subinterface, the BGP session stays in a Connect state. | 3.7.8-3.7.11 | |
| <a name="2543903"></a> [2543903](#2543903) <a name="2543903"></a> <br />CM-26291 | The Dell N3048EP, N3048UP, and N3248PXE switches do not report the class correctly when the powered device (PD) requests a class that is greater than four. The actual power grant is correct; however, <code>poectl</code> displays the class as 4 for a PD requesting anything above that value. |  | |
| <a name="2543816"></a> [2543816](#2543816) <a name="2543816"></a> <br />CM-26241 | On the Dell S5248F-ON switch, <code>smond</code> might generate syslog messages indicating that the fan input RPM is lower than the normal low speed of 2500 RPM. Speeds as low as 1700 RPM are acceptable in normal thermal environments; therefore, you can ignore these messages.<br /> | 3.7.6-3.7.11, 4.0.0-4.3.0 | |
| <a name="2542824"></a> [2542824](#2542824) <a name="2542824"></a> <br />CM-25665 | On the Broadcom Trident 3 switch, VXLAN encapsulated packets are dropped on the ingress port (tagged layer 2 port) during transit forwarding (the local switch does not terminate the VXLAN tunnel). An example of where this two-layer VXLAN inside VXLAN encapsulation might occur:<br />- VXLAN tunnel (#1) between two servers (different racks) to provide layer 2 extension for containers or VM hosts.<br />- VXLAN tunnel (#2) between the TOR switch in rack 1 to the TOR switch located in the remote rack. <br /><br />To work around this issue, either:<br />- Configure the edge port (facing the servers) to be an access port (instead of a trunk/tagged port)<br />- Change the destination port from 4789 to something else (VXLAN tunnel terminated by the servers) | 3.7.5-3.7.11, 4.0.0-4.0.1 | |
| <a name="2536617"></a> [2536617](#2536617) <a name="2536617"></a> <br />CM-22591 | CVE-2018-5391 (FragmentSmack) is a network vulnerability where an attacker can trigger time and calculation expensive fragment reassembly with specially crafted packets, leading to a denial of service. On a Cumulus Linux switch, the impact is limited to control plane and management plane traffic. Any control plane traffic coming in the front panel ports will be limited by existing policer ACLs.<br />To work around this issue, create a file called <code>/etc/sysctl.d/ip.conf</code> and add these settings:<br /><pre><br />net.ipv4.ipfrag_low_thresh = 196608<br />net.ipv6.ip6frag_low_thresh = 196608<br />net.ipv4.ipfrag_high_thresh = 262144<br />net.ipv6.ip6frag_high_thresh = 262144<br /></pre> | 3.7.0-3.7.11, 4.0.0-4.0.1 | |

## 3.7.11 Release Notes
### Open issues in 3.7.11

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-30832"></a> [CM-30832](#CM-30832) <a name="CM-30832"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with `Unable to read from device/fan1_input/pwm1` syslog messages. | 3.7.11-3.7.14, 4.1.1-4.2.1 | 3.7.14.2, 4.3.0|
| <a name="CM-28462"></a> [CM-28462](#CM-28462) <a name="CM-28462"></a> <br /> | On rare occasions, when you upgrade Cumulus Linux with the `apt-get upgrade` command, the upgrade fails and reports `No space left on device`. Checking the disk utilization shows that the disk is not full.<br/>To work around this issue, run the `apt-get upgrade` command again and reboot the device if prompted to complete the upgrade. | 3.7.10-3.7.14.2 | |
| <a name="CM-28080"></a> [CM-28080](#CM-28080) <a name="CM-28080"></a> <br /> | TACACS+ through ClearPass is not currently supported. Cumulus Linux sends authorization before authentication, but ClearPass does not accept an authorization before the user is authenticated. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2595889"></a> [2595889](#2595889) <a name="2595889"></a> <br />CM-31120 | In a traditional bridge configuration with <code>ip-forward off</code>, neighbors are synchronized to hardware with a <code>switchd</code> restart but are cleared when you flap the bridge interface. | 3.7.10-4.2.1 | 4.3.0|
| <a name="2562511"></a> [2562511](#2562511) <a name="2562511"></a> <br /> | <code>hostapd} does not fail over to secondary RADIUS servers for 802.1x authentication when the primary radius is reachable but not responding to Access-Requests<br />If the primary RADIUS server is having a problem servicing requests, you can remove it from the configuration temporarily to force requests to be sent to alternate servers. | 3.7.10-3.7.14.2 | |
| <a name="2558184"></a> [2558184](#2558184) <a name="2558184"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2556037"></a> [2556037](#2556037) <a name="2556037"></a> <br />CM-33012 | After you add an interface to the bridge, an OSPF session flap can occur.<br /><br /> | 3.7.9-4.2.0 | 4.2.1-4.3.0|
| <a name="2554785"></a> [2554785](#2554785) <a name="2554785"></a> <br />CM-32275 | After you reboot a Broadcom switch, <code>switchd</code> might fail to restart and you see logs in <code>switchd.log</code> similar to the following:<br /><pre><br />...<br />Nov 12 12:20:05.063876 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.064310 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 0:system_init:<br />Nov 12 12:20:05.064428 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 system_init: Misc init failed: Operation timed out<br />Nov 12 12:20:05.064464 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.091995 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 LED: Loading 256 bytes into LED program memory<br />Nov 12 12:20:05.092029 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099547 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 PORT: Error: bcm ports not initialized<br />Nov 12 12:20:05.099579 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099646 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /var/lib/cumulus/rc.datapath_0: line 81 (error code -1): script terminated<br />Nov 12 12:20:05.099667 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099775 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /etc/bcm.d/rc.soc: line 70 (error code -1): script terminated<br />Nov 12 12:20:05.099798 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099871 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 ERROR loading rc script on unit 0<br />Nov 12 12:20:05.099892 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099943 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:299 CRIT loading of rc script failed, aborting!<br /></pre> | 3.7.11-4.2.1 | 4.3.0|
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553748"></a> [2553748](#2553748) <a name="2553748"></a> <br />CM-31627 | On switches with the Spectrum ASIC, the IPv6 default route is present in the kernel but missing in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2553530"></a> [2553530](#2553530) <a name="2553530"></a> <br />CM-31545 | In an MLAG configuration with a layer 3 VNI, when you bounce the peer link, all layer 2 VNIs listed under the layer 3 VNI are duplicated. <br />To work around this issue, restart FRR with the <code>sudo systemctl restart frr.service</code> command.<br /><br /> | 3.7.10-3.7.13, 4.1.1-4.2.1 | 3.7.14, 4.3.0|
| <a name="2553015"></a> [2553015](#2553015) <a name="2553015"></a> <br />CM-31300 | If a neighbour contains a special character in PortID for LLDP, the <code>net show interface</code> command does not display the LLDP information or the command might fail. | 3.7.10-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2552739"></a> [2552739](#2552739) <a name="2552739"></a> <br />CM-31148 | Counters for IPROUTER rules do not increase when traffic is forwarded to the CPU because there is no IP neighbor. | 3.7.2-3.7.14.2 | |
| <a name="2552647"></a> [2552647](#2552647) <a name="2552647"></a> <br />CM-31086 | When you add a member to a bond that has a subinterface configured (such as peerlink.4094), the new member is assigned only the VLAN of the subinterface for forwarding.<br />To work around this issue, bounce the bond or shutdown the new interface and use the remaining members over the bond. | 3.7.10-3.7.13, 4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552528"></a> [2552528](#2552528) <a name="2552528"></a> <br />CM-31028 | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2552506"></a> [2552506](#2552506) <a name="2552506"></a> <br />CM-31016 | Changing the order of the bridge ports might cause the bridge MAC address to change, which flaps the bridge and its ports.<br />To work around this issue, manually set the MAC address of the bridge interface by adding <code>hwaddress <mac-address></code> to the bridge stanza in the <code>/etc/network/interfaces</code> file. | 3.7.11-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552352"></a> [2552352](#2552352) <a name="2552352"></a> <br />CM-30914 | The following security vulnerabilities have been announced in the nss / libnss3 packages:<br />CVE-2020-6829: Side channel attack on ECDSA signature generation<br />CVE-2020-12400: P-384 and P-521 implementation uses a side-channel vulnerable modular inversion function<br />CVE-2020-12401: ECDSA timing attack mitigation bypass<br />Vulnerable: <= 3.26-1+debu8u11<br />Fixed: 3.26-1+debu8u12 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552351"></a> [2552351](#2552351) <a name="2552351"></a> <br />CM-30913 | The following vulnerability has been announced in the libx11 packages:<br />CVE-2020-14344: The X Input Method (XIM) client implementation in libX11 has some integer overflows and signed/unsigned comparison issues that can lead to heap corruption when handling malformed messages from an input method.<br />Vulnerable: <= 1.6.2-3+deb8u2<br />Fixed: 1.6.2-3+deb8u3 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552214"></a> [2552214](#2552214) <a name="2552214"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14, 4.1.1-4.3.0 | 3.7.14.2|
| <a name="2552213"></a> [2552213](#2552213) <a name="2552213"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2551675"></a> [2551675](#2551675) <a name="2551675"></a> <br />CM-30479 | When you restart <code>clagd</code>, the edge port setting on the peer link changes. | 3.7.2-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551288"></a> [2551288](#2551288) <a name="2551288"></a> <br />CM-30286 | When you remove BFD configuration by editing the <code>/etc/frr/frr.conf</code> file and restarting FRR, you see a traceback.<br />To work around this issue, either use NCLU or vtysh commands to remove the BFD configuration, or restart FRR with the new <code>/etc/frr/frr.conf</code> file. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2551162"></a> [2551162](#2551162) <a name="2551162"></a> <br />CM-30240 | <code>switchd</code> memory utilization might continue to increase if there are excessive and continuous link flaps over a long period of time.<br />To work around this issue, correct the cause of the frequent link flaps. You can restart <code>switchd</code> with the <code>sudo systemctl restart switchd</code> command to recover memory; this operation is impactful to all traffic on the switch during the restart. | 3.7.11-3.7.12, 4.0.0-4.2.0 | 3.7.13-3.7.14, 4.2.1-4.3.0|
| <a name="2550974"></a> [2550974](#2550974) <a name="2550974"></a> <br />CM-30195 | On the Dell S3000 switch, after installing the Cumulus Linux 4.1.1 disk image without a license, the switch sends a link beat if a remote host port is configured. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550942"></a> [2550942](#2550942) <a name="2550942"></a> <br />CM-30178 | NCLU tab completion for <code>net show</code> displays the text <code>add help text</code> instead of <code>system Information</code> for the system option. | 3.7.11-4.2.0 | 4.2.1-4.3.0|
| <a name="2550601"></a> [2550601](#2550601) <a name="2550601"></a> <br />CM-29978 | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | 4.2.1-4.3.0, 4.3.0|
| <a name="2550375"></a> [2550375](#2550375) <a name="2550375"></a> <br />CM-29838 | CPU utilization may increase when clag-managed bond interfaces are operationally/LACP down but the physical carrier remains up on the bond member switchports. This condition occurs when clag bond redirection is enabled and bond members remain up while the parent bond does not negotiate LACP.<br /><br />This issue is resolved in Cumulus Linux 3.7.14. | 3.7.9-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2550350"></a> [2550350](#2550350) <a name="2550350"></a> <br />CM-29830 | Unicast traffic from downlink hosts is flooded to multiple remote VTEPs, which might also cause high HwIfOutQDrops/TX_DRP on the uplink ports.<br />To work around this issue, restart <code>switchd</code>. | 3.7.10-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2550323"></a> [2550323](#2550323) <a name="2550323"></a> <br />CM-29807 | After a neighbor is removed, the redistributed neighbor entry is withdrawn from the BGP table, but the prefix might still be selected as the bestpath when the host's originated prefix is not advertised.<br />To work around this issue, recreate the neighbor entry and flap the interface to the host. <br />Or, if the host is already down, manually create a neighbor entry with an invalid MAC address, which forces redistribute neighbor to re-withdraw the entry. | 3.7.3-3.7.12 | 3.7.13-3.7.14.2, 4.0.0-4.3.0|
| <a name="2549794"></a> [2549794](#2549794) <a name="2549794"></a> <br />CM-29525 | The <code>asic-monitor.service</code> fails when you configure <code>/etc/cumulus/datapath/monitor.conf</code> with <code>monitor.histogram_pg.collect.port_group_list  = &#91;all_packet_pg&#93;</code> and there is traffic passing through the buffer. When the service fails, you see the following traceback in <code>journalctl</code>:<br /><pre><br />asic-monitor&#91;7389&#93;: asic-monitor-module INFO: 2020-05-01 18:28:12.548734: Egress queue(s) greater than 500 bytes in monitor port group histogram_pg<br />asic-monitor&#91;7389&#93;: asic-monitor ERROR: ASIC monitor exception: sx_api_port_counter_tc_get failed: Parameter Error<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 139, in <module><br />asic-monitor&#91;7389&#93;: main(sys.argv&#91;1:&#93;)<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 126, in main<br />asic-monitor&#91;7389&#93;: traceback.print_stack()<br />asic-monitor&#91;7389&#93;: Traceback (most recent call last):<br />asic-monitor&#91;7389&#93;: File "/usr/bin/asic-monitor", line 117, in main<br />asic-monitor&#91;7389&#93;: monitor.run()<br />asic-monitor&#91;7389&#93;: File "/usr/lib/python2.7/dist-packages/cumulus/asic_monitor.py", line 158, in run<br />...<br /></pre> | 3.7.11-3.7.13, 4.1.1-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2549677"></a> [2549677](#2549677) <a name="2549677"></a> <br />CM-29471 | After you add or remove a bridge VLAN identifier (VID) on a trunk port, the layer 2 VNI is put into VLAN 1. <br />To work around this issue, revert the configuration change. | 3.7.10-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2549472"></a> [2549472](#2549472) <a name="2549472"></a> <br />CM-29367 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2549371"></a> [2549371](#2549371) <a name="2549371"></a> <br />CM-29309 | When Optimized Multicast Flooding (OMF) is enabled with the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/switchd.conf</code> file, the switch continues to flood IPv6 multicast traffic to all slave ports when there is no MLD join receive. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548930"></a> [2548930](#2548930) <a name="2548930"></a> <br />CM-29148 | On MLX switches that contain an OSPF IP unnumbered neighborship with a high scale of prefixes being learned, a link flap might cause the neighbor entry to not be programmed in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2548746"></a> [2548746](#2548746) <a name="2548746"></a> <br />CM-29068 | On the Broadcom switch with the Trident3 ASIC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548674"></a> [2548674](#2548674) <a name="2548674"></a> <br />CM-29044 | A large number of flapping peers causes FRR to require a corresponding update to internal data structures that track peer information. Updating this internal data structure does not delete links that are down due to the flapping. The size of this array then grows to contain both current peers as well as peers that should have been deleted during the flap processing. The contents of this array is processed by FRR to poll the links, which consumes CPU for all items in the array. This additional polling consumes more CPU than necessary but has no functional impact.<br />To work around this issue, restart FRR. | 3.7.11-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548586"></a> [2548586](#2548586) <a name="2548586"></a> <br />CM-28995 | After you flap an MLAG peerlink, a rare condition might occur where routes and neighbors for VXLAN-enabled VLANs are misprogrammed as non-VXLAN routes and neighbors due to VNI state transitions. This results in a forwarding failure for traffic destined to these misprogrammed routes and neighbors.<br />*Note*: Do not flap a VNI interface manually. The only expected time for a VNI interface to go down is when the MLAG secondary switch brings the VNIs protodown during a peer link failure where the backup IP address is still active.<br />To recover from this condition, restart <code>switchd</code> with the <code>sudo systemctl restart switchd</code> command. | 3.7.10-3.7.12, 4.1.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548490"></a> [2548490](#2548490) <a name="2548490"></a> <br />CM-28944 | A change in a route map prefix list that should remove a route might not be reflected in the <code>ospf6</code> database or in peers, and the route might not be deleted. <br />To work around this issue, reenter the <code>redistribute <connected\|static> route-map <route-map-name></code> statement in the configuration. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548475"></a> [2548475](#2548475) <a name="2548475"></a> <br />CM-28932 | After you add a new VNI and a layer 3 SVI to a set of leafs, certain leafs might not be able to communicate on the layer 3 VNI. <br />To work around this issue, reboot the leaf switch or restart <code>switchd</code>. | 3.7.6-3.7.13 | 3.7.14-3.7.14.2, 4.0.0-4.3.0|
| <a name="2548383"></a> [2548383](#2548383) <a name="2548383"></a> <br />CM-28867 | The QuantaMesh BMS T3048-LY8 switch shows a low fan RPM in syslog. | 3.7.5-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548308"></a> [2548308](#2548308) <a name="2548308"></a> <br />CM-28810 | When the garbage collector does not release memory back to the operating system, <code>clagd</code> might consume a large amount of memory. As a result of low system memory, <code>systemd</code> might shut down services to reclaim memory.<br />  | 3.7.11-3.7.12, 4.1.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548111"></a> [2548111](#2548111) <a name="2548111"></a> <br />CM-28655 | When you remove, then re-add an NSX VTEP binding, the VXLAN VTEP interface is not recreated. | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2548024"></a> [2548024](#2548024) <a name="2548024"></a> <br />CM-28596 | On the Dell Z9100 switch, 100G-SR4 modules might not link up reliably in certain ports. <br />swp1, 2, 3, 9, 10, 23, 24, 30, 31, and 32 might be affected<br />To work around this issue, move 100G SR4 modules to one of the ports not affected by this issue. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547942"></a> [2547942](#2547942) <a name="2547942"></a> <br />CM-28533 | On the Lenovo NE0152T switch, one power supply (PSU2) always show as ABSENT in smonctl. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547878"></a> [2547878](#2547878) <a name="2547878"></a> <br />CM-28486 | The following vulnerability has been found in the <code>libgcrypt20</code> cryptographic library.<br />CVE-2019-13627: there was a ECDSA timing attack.<br />For more information, see https://www.debian.org/lts/security/2020/dla-1931-2.en.html<br />Vulnerable: 1.6.3-2+deb8u7<br />Fixed: 1.6.3-2+deb8u8 | 3.7.11 | 3.7.12-3.7.14.2|
| <a name="2547876"></a> [2547876](#2547876) <a name="2547876"></a> <br />CM-28485 | The following vulnerability affects libxml2:<br />CVE-2019-19956: xmlParseBalancedChunkMemoryRecover in parser.c has a memory leak related to newDoc->oldNs.  This can lead to a denial of service.<br />For more information, see https://www.debian.org/lts/security/2019/dla-2048.en.html .<br />Vulnerable: 2.9.1+dfsg1-5+deb8u7<br />Fixed: 2.9.1+dfsg1-5+deb8u8 | 3.7.11 | 3.7.12-3.7.14.2|
| <a name="2547874"></a> [2547874](#2547874) <a name="2547874"></a> <br />CM-28484 | The following vulnerability affects libbsd, a package containing utility functions from BSD systems.<br />CVE-2016-2090: In function fgetwln() an off-by-one error could triggers a heap buffer overflow.<br />For more information, see https://www.debian.org/lts/security/2019/dla-2052.en.html .<br />Vulnerable: 0.7.0-2<br />Fixed: 0.7.0-2+deb8u1 | 3.7.11 | 3.7.12-3.7.14.2|
| <a name="2547839"></a> [2547839](#2547839) <a name="2547839"></a> <br />CM-28465 | When you try to configure <code>link-down</code> on a parent interface of a subinterface configured in a VRF, you encounter an error. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547799"></a> [2547799](#2547799) <a name="2547799"></a> <br />CM-28451 | An error similar to the following shows in syslog for Mellanox switches:<br /><pre><br />2020-02-12T19:59:22.208012+08:00 leaf01 sx_sdk: RM_TABLE: No resources available to add 1 entries to KVD hash Table HW resource<br />2020-02-12T19:59:22.208124+08:00 leaf01 sx_sdk: PORT: __port_vport_fid_set err = (No More Resources)<br /></pre><br />To work around this issue, reboot the switch. | 3.7.11-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2547784"></a> [2547784](#2547784) <a name="2547784"></a> <br />CM-28442 | PTM mis-detects incorrect hostnames of LLDP neighbors and does not fail them as expected. Instead they end up in an N/A cabling status. | 3.7.11-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547782"></a> [2547782](#2547782) <a name="2547782"></a> <br />CM-28441 | If a LLDP neighbor advertises a <code>PortDescr</code> that contains commas, <code>ptmctl -d</code> splits the string on the commas and misplaces its components in other columns. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547769"></a> [2547769](#2547769) <a name="2547769"></a> <br />CM-28437 | <code>syslog</code> might report a high load average with the CPU running a later microcode revision. | 3.7.4-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547706"></a> [2547706](#2547706) <a name="2547706"></a> <br />CM-28397 | When you configure ganged ports in the <code>ports.conf</code> file, the change does not take effect after you restart <code>switchd</code>. <br />To work around this issue, reboot the switch. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2547667"></a> [2547667](#2547667) <a name="2547667"></a> <br />CM-28376 | On the Dell S5232F-ON switch, the output of <code>ledmgrd</code> shows <code>amber_blinking</code> but <code>smonctl</code> shows all OK. | 3.7.11-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2547663"></a> [2547663](#2547663) <a name="2547663"></a> <br />CM-28374 | When traffic from a double tag interface (facing a different site) is forwarded through VXLAN, the inner tag is not removed. The destination does not know this tag, so it discards it. | 3.7.8-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547659"></a> [2547659](#2547659) <a name="2547659"></a> <br />CM-28372 | On the EdgeCore AS7326-56X switch, the default fan speed, which is defined in the thermal specification, results in excessive fan noise. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547658"></a> [2547658](#2547658) <a name="2547658"></a> <br />CM-28371 | On the Lenovo NE0152T switch, one power supply (PSU2) always show as ABSENT in smonctl. | 3.7.11-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547610"></a> [2547610](#2547610) <a name="2547610"></a> <br />CM-28340 | Mellanox switches with the Spectrum A0 ASIC that are integrated with VMware NSX experience BFD connectivity issues with service nodes. As a result, VXLAN tunnels do not work.<br />Mellanox switches with the Spectrum A1 ASIC do **not** have this issue. | 3.7.11-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2547592"></a> [2547592](#2547592) <a name="2547592"></a> <br />CM-28331 | When you add a route map to advertise IPv4 unicast in a BGP EVPN configuration and the route map contains a set operation, BGP crashes. | 3.7.11-3.7.12 | 3.7.13-3.7.14.2, 4.1.0-4.3.0|
| <a name="2547573"></a> [2547573](#2547573) <a name="2547573"></a> <br />CM-28322 | On Tomahawk switches, when the <code>vxlan_tnl_arp_punt_disable</code> option is set to FALSE, ARP packets are not forwarded to the CPU. | 3.7.9-4.0.1 | 4.1.0-4.3.0|
| <a name="2547558"></a> [2547558](#2547558) <a name="2547558"></a> <br />CM-28313 | On the EdgeCore Wedge100 and Facebook Wedge-100S switch, certain physical ports are not correctly mapped to the logical ones. For example:<br />Logical swp39 controls physical swp41<br />Logical swp40 controls physical swp42<br />Logical swp43 controls physical swp45<br />Logical swp44 controls physical swp46<br />This might causes incorrect forwarding behavior. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547509"></a> [2547509](#2547509) <a name="2547509"></a> <br />CM-28276 | When a Trident3 switch receives packets containing an IP checksum value that is not compliant with RFC 1624, the TTL is decremented after a routing operation but the checksum is not recalculated. This results in the IP checksum value being invalid as the packet leaves the switch.  | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547443"></a> [2547443](#2547443) <a name="2547443"></a> <br />CM-28248 | On the Dell N3248PXE-ON switch, 25G SFP ports do not work in 10G mode. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547401"></a> [2547401](#2547401) <a name="2547401"></a> <br />CM-28223 | The following security vulnerability has been announced in qemu, which is not installed by default on Cumulus Linux but is available in the repository for optional installation:<br />CVE-2020-1711: block: iscsi: OOB heap access via an unexpected response of iSCSI Server | 3.7.11-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547400"></a> [2547400](#2547400) <a name="2547400"></a> <br />CM-28222 | The following security vulnerability has been announced in qemu, which is not installed by default on Cumulus Linux but is available in the repository for optional installation:<br />CVE-2020-7039: tcp_emu in tcp_subr.c in libslirp 4.1.0, as used in QEMU 4.2.0, mismanages memory, as demonstrated by IRC DCC commands in EMU_IRC. This can cause a heap-based buffer overflow or other out-of-bounds access which can lead to a DoS or potential execute arbitrary code.<br />Vulnerable: <= 2.1+dfsg-12+deb8u12<br />Fixed: 2.1+dfsg-12+deb8u13 | 3.7.11 | 3.7.12-3.7.14.2|
| <a name="2547381"></a> [2547381](#2547381) <a name="2547381"></a> <br />CM-28212 | The <code>hsflowd</code> service sends an undefined header protocol 0 in the sampled flow sample to the collector, which is not recognized by the sFlow tool. You see errors similar to the following:<br /><pre><br />Dec 20 08:43:27 netflow-nms sfcapd&#91;3991&#93;: SFLOW: readFlowSample_header() undefined headerProtocol = 0<br /></pre><br /> | 3.7.11-3.7.14 | 4.0.0-4.3.0|
| <a name="2547303"></a> [2547303](#2547303) <a name="2547303"></a> <br />CM-28169 | On the Dell Z9264F-ON switch, the CPU core temperature sensors report ABSENT. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547293"></a> [2547293](#2547293) <a name="2547293"></a> <br />CM-28160 | On the Broadcom Trident3 switch with DHCP relay, where the DHCP server is reachable through the EVPN overlay, DHCP discover packets forwarded to the CPU might appear corrupt and might not get forwarded. | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547246"></a> [2547246](#2547246) <a name="2547246"></a> <br />CM-28136 | The MLAG switch pair has VLANs defined that are not used on MLAG bonds. These VLANs still synchronize MAC addresses across to the peer switch. This results in log messages that indicate a MAC address is installed and the VLAN is not defined; for example:<br /><pre><br />RTM_NEWNEIGH with unconfigured vlan XXXX on port peerlink<br /></pre> | 3.7.10-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547155"></a> [2547155](#2547155) <a name="2547155"></a> <br />CM-28091 | Two security issues were found in the Python interface to the apt package manager, which is installed by default on Cumulus Linux; package downloads from unsigned repositories were incorrectly rejected (CVE-2019-15796) and the hash validation relied on MD5 (CVE-2019-15795).<br />For more information, refer to https://security-tracker.debian.org/tracker/source-package/python-apt<br />Vulnerable: 0.9.3.12<br />Fixed: 0.9.3.13 | 3.7.11 | 3.7.12-3.7.14.2|
| <a name="2547149"></a> [2547149](#2547149) <a name="2547149"></a> <br />CM-28087 | The last eight ports of the EdgeCore AS4610-54P switch (swp41 through swp48) do not power UPOE access points. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547147"></a> [2547147](#2547147) <a name="2547147"></a> <br />CM-28086 | The <code>ospfd</code> daemon might crash with the following kernel trace: <br /><pre><br />2019-11-06T23:00:08.261749+09:00 cumulus ospfd&#91;5339&#93;: Assertion 'node' failed in file ospfd/ospf_packet.c, line 671, function ospf_write<br /></pre> | 3.7.11-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547123"></a> [2547123](#2547123) <a name="2547123"></a> <br />CM-28078 | On the Broadcom switch with the Trident3 ASC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547122"></a> [2547122](#2547122) <a name="2547122"></a> <br />CM-28077 | An unhandled exception might occur after you run the <code>sudo poectl -i</code> command. In addition, random <code>poed</code> daemon restarts can occur without any unhandled exceptions but with an invalid response length error. Both issues can occur due to a SerialException.<br />To work around this issue, power cycle the switch. A software reboot does not resolve the issue. | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547120"></a> [2547120](#2547120) <a name="2547120"></a> <br />CM-28076 | After you hot swap a PSU, the <code>decode-syseeprom -t psuX</code> command shows the old PSU information (such as the serial number), until you run the <code>decode-syseeprom --init</code> command. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547106"></a> [2547106](#2547106) <a name="2547106"></a> <br />CM-28065 | Editing the outbound route-map of a BGP peer causes all received prefixes by that BGP peer to reset and reinstall. This might cause a brief impact to traffic for those prefixes. | 3.7.11 | 3.7.12-3.7.14.2|
| <a name="2547100"></a> [2547100](#2547100) <a name="2547100"></a> <br />CM-28061 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547071"></a> [2547071](#2547071) <a name="2547071"></a> <br />CM-28048 | On the Lenovo NE2580 switch, the fan speeds are higher than expected within normal operating conditions. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547043"></a> [2547043](#2547043) <a name="2547043"></a> <br />CM-28038 | After you convert a bond back to a layer 2 access port, ifupdown2 changes all SVI MTUs to 1500. <br />To work around this issue, run <code>ifreload -a</code> a second time. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547013"></a> [2547013](#2547013) <a name="2547013"></a> <br />CM-28016 | On the Mellanox Spectrum switch, <code>switchd</code> can sometimes fail when PBR rules are installed or removed from hardware if the rule is setting a next hop learned via a routing protocol. | 3.7.7-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546999"></a> [2546999](#2546999) <a name="2546999"></a> <br />CM-28007 | When you configure Cumulus Linux with a /32 address on a switch port with a configured peer address (for example, to connect to a device using IP unnumbered), the switch sends GARPs for the peer address. | 3.7.5-3.7.11 | 3.7.12-3.7.14.2, 4.1.0-4.3.0|
| <a name="2546992"></a> [2546992](#2546992) <a name="2546992"></a> <br />CM-28004 | The wireshark packages (libwireshark5, libwireshark-data, wireshark, wireshark-common) available for optional installation on Cumulus Linux 3 are vulnerable to CVE-2018-12086: Buffer overflow in OPC UA applications allows remote attackers to trigger a stack overflow with carefully structured requests.  More information at https://www.wireshark.org/security/wnpa-sec-2018-50.html and https://security-tracker.debian.org/tracker/CVE-2018-12086 . | 3.7.11-3.7.14.2 | |
| <a name="2546991"></a> [2546991](#2546991) <a name="2546991"></a> <br />CM-28003 | The FRR service does not provide a way for automation to know if the configuration applied properly.<br />To work around this issue, execute the <code>vtysh -f <file></code> command in the automation file before starting the FRR service to validate the functional configuration and return an error code. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546989"></a> [2546989](#2546989) <a name="2546989"></a> <br />CM-28001 | The libxen packages are not installed on the switch by default, but are available in the repository for optional installation.<br /><br />Customers who optionally install the libxen packages should be aware of the following security advisory.<br /><br />Debian Security Advisory DSA-4602-1<br />CVE-2019-17349 CVE-2019-17350 CVE-2019-18420 CVE-2019-18421<br />CVE-2019-18422 CVE-2019-18423 CVE-2019-18424 CVE-2019-18425<br />CVE-2019-19577 CVE-2019-19578 CVE-2019-19579 CVE-2019-19580<br />CVE-2019-19581 CVE-2019-19582 CVE-2019-19583 CVE-2018-12207<br />CVE-2018-12126 CVE-2018-12127 CVE-2018-12130 CVE-2019-11091<br />CVE-2019-11135 CVE-2019-17348 CVE-2019-17347 CVE-2019-17346<br />CVE-2019-17345 CVE-2019-17344 CVE-2019-17343 CVE-2019-17342<br />CVE-2019-17341 CVE-2019-17340<br /><br />Multiple vulnerabilities have been discovered in the Xen hypervisor, which<br />could result in denial of service, guest-to-host privilege escalation or<br />information leaks.<br /><br />For more information, see https://security-tracker.debian.org/tracker/xen | 3.7.11-3.7.14.2 | |
| <a name="2546985"></a> [2546985](#2546985) <a name="2546985"></a> <br />CM-27999 | On the EdgeCore AS7326-56X switch, the PSU fans show constant LOW warnings. | 3.7.10-3.7.12, 4.0.0-4.2.0 | 3.7.13-3.7.14, 4.2.1-4.3.0|
| <a name="2546951"></a> [2546951](#2546951) <a name="2546951"></a> <br />CM-27982 | <code>switchd</code> crashes when dynamic VRF route leaking is enabled and the following is true:<br />* The default route is leaked from VRF1 to VRF2<br />* Hardware-based dynamic VRF route leaking is configured (<code>vrf_route_leak_enable_dynamic</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file). <br />You might see logs similar to the following in <code>/var/log/syslog</code>:<br /><pre><br />kernel: &#91;159400.526241&#93; switchd&#91;21374&#93;: segfault at 1229cdd84 ip 00000000004142ca sp 00007ffd557a86d0 error 4 in switchd&#91;400000+71000&#93;<br /></pre><br />To work around this issue, use a route map to filter the default route (the source VRF is imported into the destination VRF). | 3.7.10-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2546895"></a> [2546895](#2546895) <a name="2546895"></a> <br />CM-27957 | If you have configured a higher number of ports and VLANs (ports x VLANs) or the switch is a lower-powered (CPU) platform, the <code>switchd</code> service might fail to send a <code>systemd keepalive</code> within the watchdog timeout value (2 minutes by default) and you see an error similar to the following:<br /><pre><br />bq. systemd&#91;1&#93;: switchd.service watchdog timeout (limit 2min)!<br /></pre><br />To workaround this issue, either reduce the number of configured interfaces and, or VLANs, or increase the <code>systemd</code> timeout for <code>switchd.service</code>.<br />To increase the <code>systemd</code> timeout:<br /># Edit the <code>/etc/systemd/system/switchd.service.d/override.conf</code> file and increase the <code>WatchdogSec</code> parameter.<br /># Restart the <code>switchd</code> service with the <code>sudo systemctl restart switchd.service</code> command.<br /><code>systemd</code> will attempt to restart the <code>switchd</code> service automatically (after the watchdog timeout). If the restart fails multiple times in a short time period, run the <code>sudo systemctl reset-failed</code> command followed by the <code>sudo systemctl restart switchd</code> command.<br /> | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546869"></a> [2546869](#2546869) <a name="2546869"></a> <br />CM-27947 | Broadcom Field Alert - SID - MMU 2B Errors<br />A few of the MMU memories on Broadcom switches are grouped together with single parity control. During SER correction when a parity error occurs on one of those groups, other memory in that group might also report a SER error. This occurs when the memory is accessed either by a packet hit or through a schan operation. This issue can cause SER errors in other memory and cause traffic mis-forwarding or a packet drop. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546848"></a> [2546848](#2546848) <a name="2546848"></a> <br />CM-27937 | Debian security advisory DSA-4213 for qemu lists a number of security vulnerabilities.<br />https://www.debian.org/security/2018/dsa-4213<br />One of the listed vulnerabilities is still present in the latest upstream version 2.1+dfsg-12+deb8u12 (the others have been fixed):<br />CVE-2017-15124 Daniel Berrange discovered that the integrated VNC server insufficiently restricted memory allocation, which could result in denial of service.<br />https://security-tracker.debian.org/tracker/CVE-2017-15124 | 3.7.11-3.7.14.2 | |
| <a name="2546815"></a> [2546815](#2546815) <a name="2546815"></a> <br />CM-27927 | On the Delta AG6248C switch, the NCLU <code>net show system sensors</code> command shows an error:<br /><pre><br />Could not collect output from command: &#91;'/usr/sbin/smonctl'&#93;<br /></pre><br />To work around this issue, run the <code>net show system sensors json</code> command instead. | 3.7.11 | 3.7.12-3.7.14.2|
| <a name="2546810"></a> [2546810](#2546810) <a name="2546810"></a> <br />CM-27924 | A security vulnerability has been announced in the cyrus-sasl2 (libsasl2-2 and libsasl2-modules) package. The libraries are installed by default on Cumulus Linux.<br />CVE-2019-19906: Stephan Zeisberg reported an out-of-bounds write vulnerability in the _sasl_add_string() function in cyrus-sasl2, a library implementing the Simple Authentication and Security Layer. A remote attacker can take advantage of this issue to cause denial-of-service conditions for applications using the library.<br />Vulnerable: 2.1.26.dfsg1-13+deb8u1<br />Fixed: 2.1.26.dfsg1-13+deb8u2 | 3.7.11 | 3.7.12-3.7.14.2|
| <a name="2546703"></a> [2546703](#2546703) <a name="2546703"></a> <br />CM-27855 | The FRR cl-support module times out on switches on the ARM platform even when the switch is not under heavy load.<br />To work around this issue, run the <code>cl-support -M</code> command to disable timeouts. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546577"></a> [2546577](#2546577) <a name="2546577"></a> <br />CM-27814 | A traditional bridge with QinQ and a VNI does not work for tagged traffic. | 3.7.10-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2546564"></a> [2546564](#2546564) <a name="2546564"></a> <br />CM-27804 | You might see a <code>switchd</code> memory leak during ECMP group expansion or consolidation. | 3.7.10-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2546542"></a> [2546542](#2546542) <a name="2546542"></a> <br />CM-27793 | A security vulnerability has been announced in the cyrus-sasl2 (libsasl2-2 and libsasl2-modules) package. The libraries are installed by default on Cumulus Linux.<br />CVE-2019-19906: Stephan Zeisberg reported an out-of-bounds write vulnerability in the _sasl_add_string() function in cyrus-sasl2, a library implementing the Simple Authentication and Security Layer. A remote attacker can take advantage of this issue to cause denial-of-service conditions for applications using the library.<br />Vulnerable: 2.1.27+dfsg-1<br />Fixed: 2.1.27+dfsg-1+deb10u1 | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2546502"></a> [2546502](#2546502) <a name="2546502"></a> <br />CM-27764 | On the EdgeCore AS7326-56X switch, eth0 and swp1 use the same MAC address. | 3.7.9-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546451"></a> [2546451](#2546451) <a name="2546451"></a> <br />CM-27737 | On the EdgeCore AS7326-56X switch, you might see the RPM of certain fans run over the maximum threshold. | 3.7.11 | 3.7.12-3.7.14.2, 4.1.0-4.3.0|
| <a name="2546385"></a> [2546385](#2546385) <a name="2546385"></a> <br />CM-27698 | SNMP ifLastChange reports link transitions when there are none. | 3.7.6-3.7.14.2 | |
| <a name="2546354"></a> [2546354](#2546354) <a name="2546354"></a> <br />CM-27683 | The following CVEs were announced that affect the Linux kernel:<br />CVE-2019-12378: An issue was discovered in ip6_ra_control in net/ipv6/ipv6_sockglue.c in the Linux kernel through 5.1.5. There is an unchecked kmalloc of new_ra, which might allow an attacker to cause a denial of service (NULL pointer dereference and system crash).<br />CVE-2019-12381: An issue was discovered in ip_ra_control in net/ipv4/ip_sockglue.c in the Linux kernel through 5.1.5. There is an unchecked kmalloc of new_ra, which might allow an attacker to cause a denial of service (NULL pointer dereference and system crash).<br />CVE-2019-15239: In the Linux kernel, a certain net/ipv4/tcp_output.c change, which was properly incorporated into 4.16.12, was incorrectly backported to the earlier longterm kernels, introducing a new vulnerability that was potentially more severe than the issue that was intended to be fixed by backporting. Specifically, by adding to a write queue between disconnection and re-connection, a local attacker can trigger multiple use-after-free conditions. This can result in a kernel crash, or potentially in privilege escalation. <br />CVE-2019-19062: A memory leak in the crypto_report() function in crypto/crypto_user_base.c in the Linux kernel through 5.3.11 allows attackers to cause a denial of service (memory consumption) by triggering crypto_report_alg() failures, aka CID-ffdde5932042.<br />CVE-2019-19537: In the Linux kernel before 5.2.10, there is a race condition bug that can be caused by a malicious USB device in the USB character device driver layer, aka CID-303911cfc5b9. This affects drivers/usb/core/file.c.<br />CVE-2019-20054: In the Linux kernel before 5.0.6, there is a NULL pointer dereference in drop_sysctl_table() in fs/proc/proc_sysctl.c, related to put_links, aka CID-23da9588037e. | 3.7.11 | 3.7.12-3.7.14.2|
| <a name="2546329"></a> [2546329](#2546329) <a name="2546329"></a> <br />CM-27670 | A memory leak in <code>switchd</code> might occur, which causes <code>switchd</code> to restart. | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546267"></a> [2546267](#2546267) <a name="2546267"></a> <br />CM-27646 | Several vulnerabilities have been discovered in Git, a fast, scalable,<br />distributed revision control system, which is available in the Cumulus Linux 3.x repositories for optional installation.<br />CVE-2019-1348: export-marks is insecure, fix is to disable by default.<br />CVE-2019-1349: .git / git~1 filename vulnerability on NTFS<br />CVE-2019-1352: .git vulnerability with NTFS Alternate Streams Accesses<br />CVE-2019-1353: NTFS filesystem protection should be on by default<br />CVE-2019-1387: dubiously-nested submodule git directories should be disallowed<br />CVE-2019-19604: submodule update repository code execution vulnerability<br />Vulnerable: <= 2.1.4-2.1+deb8u7<br />Fixed: 2.1.4-2.1+deb8u8 | 3.7.10-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2546265"></a> [2546265](#2546265) <a name="2546265"></a> <br />CM-27644 | Ifupdown2 does not set up the front panel interface for the <code>dhclient</code> to accept the DHCP OFFER.<br />To work around this issue, restart the networking service after <code>ifreload -a</code> with the <code>systemctl restart networking</code> command. | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546225"></a> [2546225](#2546225) <a name="2546225"></a> <br />CM-27627 | When you execute the following command on the Delta AG6248C switch, the switch reboots and then comes right back into Cumulus Linux without installing the new image. The install image is still in <code>/var/lib/cumulus/installer</code>, which causes issues with cl-support. <br /> <pre> <br /> sudo onie-install -fai http://<path to image> <br /> sudo reboot <br /> </pre> <br /> To work around this issue, use the <code>onie-select</code> command to access ONIE, and then use the <code>nos-install</code> command in ONIE to install a new binary image.  | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546203"></a> [2546203](#2546203) <a name="2546203"></a> <br />CM-27620 | When using QinQ with a traditional bridge, if you enable the LLDP dot1 TLV option, you see the following suboptimal behavior:<br />* Both the inner and outer VLAN information is sent as part of VLAN TLVs in the LLDP packet. <br />* If the outer VLAN ID is the same as the inner VLAN ID, only one VLAN TLV is sent with that VLAN ID in the LLDP packet. | 3.7.11-3.7.14.2 | |
| <a name="2546141"></a> [2546141](#2546141) <a name="2546141"></a> <br />CM-27586 | CPU usage might be higher than normal if you have a high number of interfaces x VLANs and <code>lldpd</code> is active. This issue is introduced with code changes in Cumulus Linux 3.7.11, where VLAN information is now available for LLDP to advertise to neighbors (&#91;https://docs.cumulusnetworks.com/version/cumulus-linux-37/Layer-2/Link-Layer-Discovery-Protocol/#vlan-dot1-tlv&#93;). You might see high CPU usage even if VLAN (dot1) TLV configuration is disabled. <br />To check if <code>lldpd</code> is the heavy CPU resource user, run the following command:<br /><pre><br />cumulus&#64;switch:~$  ps -eo user,pid,ppid,cmd,%mem,%cpu --sort=-%cpu \| head<br /></pre><br />Alternatively, check for messages in the <code>/var/log/syslog</code> directory similar to:<br /><pre><br />2020-02-20T15:02:12.137857-05:00 leaf01 sysmonitor: High CPU use: 87%<br />2020-02-20T15:02:12.482398-05:00 leaf01 sysmonitor:   PID USER      PR    VIRT    RES %CPU %MEM     TIME+ COMMAND<br />2020-02-20T15:02:12.483112-05:00 leaf01 sysmonitor:  1570 _lldpd    20   73244  13800 76.6  0.3   4:43.06 lldpd<br /></pre><br />*Note*: The exact amount of CPU usage varies in each network based on a number of factors; however, it is unusual for <code>lldpd</code> to consume more than 30% CPU for an extended period of time.<br />To work around this issue, you can do one of the following:<br />* If the large number of VLANs is not absolutely necessary, manually prune the VLAN allowed list (if you use the range 1-2999, modify the <code>bridge-vids</code> list to include the VLANs being used).<br />* Stop the <code>lldpd</code> service. (This approach might be undesirable if the switch is providing services that rely on LLDP such as Voice VLAN.) To stop the <code>lldpd</code> service (runtime setting), run the <code>sudo systemctl stop lldpd.service</code> command. To disable the <code>lldpd</code> service upon boot, run <code>sudo systemctl disable lldpd.service</code>. | 3.7.11-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2546131"></a> [2546131](#2546131) <a name="2546131"></a> <br />CM-27581 | On the Delta AG-6248C PoE switch, when you run the <code>apt upgrade</code> command, the upgrade does not work. Cumulus Linux uses <code>uboot</code> directly instead of <code>grub</code> to boot the kernel. Uboot needs a special header to boot the kernel, which is not present. Without this header, when you use the <code>apt upgrade</code> command to upgrade Linux packages, <code>uboot</code> is unable to boot up the kernel. <br />To work around this issue, upgrade Cumulus Linux by installing the Cumulus Linux image. Run the <code>onie-select</code> command to go into ONIE, and then use the <code>nos-install</code> command in ONIE to install a new image.<br />This workaround only works when an out-of-band network is present. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546010"></a> [2546010](#2546010) <a name="2546010"></a> <br />CM-27530 | When <code>hal.bcm.per_vlan_router_mac_lookup</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file, inter-VLAN traffic is forwarded to the CPU when associated VNI interfaces exist. | 3.7.10-3.7.14.2 | |
| <a name="2546003"></a> [2546003](#2546003) <a name="2546003"></a> <br />CM-27525 | On the Delta AG6248C PoE switch, if the PoE priority is set to low on some ports, other ports with a higher priority might have their requests to draw power rejected instead of the lower priority ports being brought down. | 3.7.11 | 3.7.12-3.7.14.2|
| <a name="2545997"></a> [2545997](#2545997) <a name="2545997"></a> <br />CM-27522 | The NCLU command <code>net show interface</code> produces an error if bonds with no members exist.<br />To work around this issue, remove the empty Bond interfaces from the <code>/etc/network/interfaces</code> file and run <code>sudo ifreload -a</code>. | 3.7.10-3.7.14.2 | |
| <a name="2545972"></a> [2545972](#2545972) <a name="2545972"></a> <br />CM-27507 | The <code>ports.conf</code> file on the Dell S5248F-ON switch does not show port ganging or breakout options. | 3.7.10-3.7.11 | 3.7.12-3.7.14.2, 4.1.0-4.3.0|
| <a name="2545949"></a> [2545949](#2545949) <a name="2545949"></a> <br />CM-27496 | All Broadcom Trident3 X7 switches contain PCIE firmware, which is programmed by the vendor when the switch is manufactured. The latest version of this firmware (2.6) is incompatible with Cumulus Linux 3.7.11 and earlier, and Cumulus Linux 4.0. <br />To work around this issue, downgrade the Broadcom ASIC firmware to an earlier version. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2545837"></a> [2545837](#2545837) <a name="2545837"></a> <br />CM-27444 | If you use the NCLU commands to configure NTP and run the <code>net add time ntp source <interface></code> command before you run the <code>net add time ntp server <server> iburst</code> command, the <code>/etc/ntp.conf</code> file is misconfigured.<br />To work around this issue, run the <code>net add time ntp server <server> iburst</code> command before you run the <code>net add time ntp source <interface></code> command. | 3.7.10-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2545699"></a> [2545699](#2545699) <a name="2545699"></a> <br />CM-27354 | On the Celestica Pebble switch, if you use IPv6 routes with mask /65 to /127,  the <code>switchd</code> log fills with errors. | 3.7.10-3.7.13 | 3.7.14-3.7.14.2, 4.1.0-4.3.0|
| <a name="2545600"></a> [2545600](#2545600) <a name="2545600"></a> <br />CM-27295 | IPv6 table rules might affect forwarding. For example, if you create the following rule in the <code>/etc/cumulus/acl/policy.d/03-sshd.rules</code> file, the rule counter increments but IPv4 SSH traffic might be dropped.<br /><pre><br />&#91;ip6tables&#93;<br />-A INPUT -p tcp --dport 22 -j DROP<br /></pre> | 3.7.2-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2545446"></a> [2545446](#2545446) <a name="2545446"></a> <br />CM-27192 | If you use NCLU commands to add a non-MLAG bond, then add an MLAG configuration, the <code>net commit</code> command fails. However, a subsequent <code>net commit</code> command succeeds. | 3.7.10-3.7.14.2 | |
| <a name="2545404"></a> [2545404](#2545404) <a name="2545404"></a> <br />CM-27173 | On the Trident3 switch, unicast ARP packets received on a VNI and forwarded to the CPU are not policed. | 3.7.10-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2545316"></a> [2545316](#2545316) <a name="2545316"></a> <br />CM-27120 | When an interface flap occurs, numbered IPv6 BGP sessions might fail to establish.<br />To work around this issue, run the <code>ip -6 route flush cache <IPv6-address></code> command to flush the IPv6 route cache. | 3.7.9-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2545125"></a> [2545125](#2545125) <a name="2545125"></a> <br />CM-27018 | If you configure more than one VRR interface on an SVI interface, deleting one of the VRR addresses does not remove the interface/address.  | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544978"></a> [2544978](#2544978) <a name="2544978"></a> <br />CM-26921 | If you delete an undefined bond, then add a bond slave, the <code>net commit</code> command fails. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544968"></a> [2544968](#2544968) <a name="2544968"></a> <br />CM-26913 | FRR configuration commands for an SVI interface might have the <code>\n</code> misplaced in the output.  For example:<br /><pre><br />sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />should be:<br /><pre><br />sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />To work around this issue, configure the interface manually in the <code>/etc/frr/frr.conf</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544953"></a> [2544953](#2544953) <a name="2544953"></a> <br />CM-26905 | When you update the hostname of a switch with the NCLU <code>net add hostname <hostname></code> command, then run <code>net commit</code>, the <code>lldpd</code> service does not restart and other devices still see the old hostname.<br />To work around this issue, run the <code>sudo systemctl restart lldpd.service</code> command. | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544937"></a> [2544937](#2544937) <a name="2544937"></a> <br />CM-26894 | The <code>neighmgrd</code> service does not ignore neighbors on reserved devices (lo and management devices).  This issue is not seen when management VRF is enabled. | 3.7.8-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2544904"></a> [2544904](#2544904) <a name="2544904"></a> <br />CM-26875 | After you delete an IPv6 numbered BGP peer group neighbor, Cumulus Linux might continue to send route advertisements.<br />To work around this issue, restart FRR after removing the IPv6 numbered configuration. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544556"></a> [2544556](#2544556) <a name="2544556"></a> <br />CM-26655 | If you reconfigure an NTP server with NCLU using different trailing options after the IP address (such as <code>iburst</code>), an invalid configuration is added to the <code>/etc/ntp.conf</code> file. For example:<br /><pre><br />net add time ntp server 1.2.3.4 iburst<br />net commit<br />net add time ntp server 1.2.3.4<br />net commit<br /></pre><br />If you need to alter existing server configurations, first remove the server, commit, then re-add the server with any trailing options. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544463"></a> [2544463](#2544463) <a name="2544463"></a> <br />CM-26599 | Auto-negotiation does not work with the QSFP28 cables and a remote system operating at 10G. Attempting to enable auto-negotiation with <code>ethtool -s swp<#> autoneg on</code> returns <code>Operation not supported</code>.<br />To work around this issue, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544456"></a> [2544456](#2544456) <a name="2544456"></a> <br />CM-26595 | The NCLU <code>net show lldp</code> command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544235"></a> [2544235](#2544235) <a name="2544235"></a> <br />CM-26463 | The following CVEs affect the linux kernel package:<br />CVE-2019-14821 CVE-2019-14835 CVE-2019-15117 CVE-2019-15118 CVE-2019-15902<br />Several vulnerabilities have been discovered in the Linux kernel that<br />may lead to a privilege escalation, denial of service or information<br />leaks.<br />For the detailed security status of linux,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/linux | 3.7.10-3.7.14.2 | |
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544113"></a> [2544113](#2544113) <a name="2544113"></a> <br />CM-26412 | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address changing between the MLAG bond and the peer link.<br />To work around this issue, disable MAC learning on QinQ VLANs by adding <code>bridge-learning off</code> to the VLAN stanza in the <code>etc/network/interfaces</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544012"></a> [2544012](#2544012) <a name="2544012"></a> <br />CM-26351 | After you remove a subinterface, the BGP session stays in a Connect state. | 3.7.8-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2543900"></a> [2543900](#2543900) <a name="2543900"></a> <br />CM-26288 | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543841"></a> [2543841](#2543841) <a name="2543841"></a> <br />CM-26256 | The <code>net show evpn vni detail json</code> command includes an extra empty dictionary at the end of the output. <br /> | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543816"></a> [2543816](#2543816) <a name="2543816"></a> <br />CM-26241 | On the Dell S5248F-ON switch, <code>smond</code> might generate syslog messages indicating that the fan input RPM is lower than the normal low speed of 2500 RPM. Speeds as low as 1700 RPM are acceptable in normal thermal environments; therefore, you can ignore these messages.<br /> | 3.7.6-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2543800"></a> [2543800](#2543800) <a name="2543800"></a> <br />CM-26230 | When <code>local-tunnelip</code> is an SVI, the static VXLAN tunnel does not work; the next hop router receives the packet but drops it as it does not know where to forward the packet. The static VXLAN tunnel does works if <code>local-tunnelip</code> is a loopback or a physical layer 3 interface. <br /> | 3.7.8-3.7.14 | 4.0.0-4.3.0|
| <a name="2543792"></a> [2543792](#2543792) <a name="2543792"></a> <br />CM-26225 | On the EdgeCore AS5712, AS6712, AS5812 and AS6812 switch, support for multiple PSU types results in log messages similar to the following:<br /><pre><br />2019-09-05T05:15:17.246597+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.274521+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br />2019-09-05T05:15:17.469556+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.497514+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br /></pre> | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543649"></a> [2543649](#2543649) <a name="2543649"></a> <br />CM-26138 | You cannot specify a source and destination MAC address in an ERSPAN ebtables rule. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i swp5 -s 00:25:90:b2:bd:9d -d 50:6b:4b:96:c4:04 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | 4.3.0|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543627"></a> [2543627](#2543627) <a name="2543627"></a> <br />CM-26126 | Tomahawk 40G DACs cannot disable auto-negotiation. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543472"></a> [2543472](#2543472) <a name="2543472"></a> <br />CM-26024 | On switches with the Spectrum ASIC, the underlay hashes VXLAN packets for a given overlay flow randomly.<br />To work around this issue, configure the ECMP hash seed to the same value on the EVPN egress leaf switches. | 3.7.7-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543270"></a> [2543270](#2543270) <a name="2543270"></a> <br />CM-25923 | The default route injected through OSPF when you configure <code>default-information originate always</code> is unreliable and might age out unexpectedly.<br />To work around this issue, rely on a different source of default route other than injection with <code>default-information originate</code>. | 3.7.8-4.1.1 | 4.2.0-4.3.0|
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543058"></a> [2543058](#2543058) <a name="2543058"></a> <br />CM-25798 | The IP neighbor entry for a link-local next hop is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces.<br />To work around this issue, flap the peering to the peer router (which might be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543052"></a> [2543052](#2543052) <a name="2543052"></a> <br />CM-25796 | Received EVPN type-5 and type-2 MACIP routes are not installed in the kernel (and hardware) routing tables for the associated VRF, which causes traffic to be blackholed. The failure to install the default route causes complete reachability failure for the particular tenant on the affected racks. The routes that are not installed are seen as "inactive" in the routing subsystem (FRR) VRF routing table. This problem is rare and can occur only in EVPN configurations that have user-configured route targets (RTs) for tenant VRFs, and only following a restart of FRR.<br />To work around this issue, either restart the FRR service on the affected switch with the <code>sudo systemctl restart frr.service</code> command or bounce the layer 3 SVI for the affected VRF; for example:<br /><pre><br />ifdown vlan123 ; sleep 2 ; ifup vlan123<br /></pre><br />You can run the <code>net show vrf vni</code> command to print a mapping of VRF : L3-VNI : L3-SVI. | 3.7.5-3.7.14 | 4.0.0-4.3.0|
| <a name="2543044"></a> [2543044](#2543044) <a name="2543044"></a> <br />CM-25794 | Under certain conditions, EVPN next hops might not be removed when the contributing peer goes down or might not be populated when the BGP session to the contributing peer comes up.<br />You can prevent EVPN next hops from not being removed when the contributing peer goes down by specifying static MAC addresses on all layer 3 VNIs. There is no workaround for preventing EVPN next hops from not being populated when the BGP session to the contributing peer comes up. | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2542979"></a> [2542979](#2542979) <a name="2542979"></a> <br />CM-25766 | On the Dell-N3048EP-ON switch, when you run the <code>sudo -E apt upgrade</code> command, the upgrade does not work.  | 3.7.7-4.1.1 | 4.2.0-4.3.0|
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542824"></a> [2542824](#2542824) <a name="2542824"></a> <br />CM-25665 | On the Broadcom Trident 3 switch, VXLAN encapsulated packets are dropped on the ingress port (tagged layer 2 port) during transit forwarding (the local switch does not terminate the VXLAN tunnel). An example of where this two-layer VXLAN inside VXLAN encapsulation might occur:<br />- VXLAN tunnel (#1) between two servers (different racks) to provide layer 2 extension for containers or VM hosts.<br />- VXLAN tunnel (#2) between the TOR switch in rack 1 to the TOR switch located in the remote rack. <br /><br />To work around this issue, either:<br />- Configure the edge port (facing the servers) to be an access port (instead of a trunk/tagged port)<br />- Change the destination port from 4789 to something else (VXLAN tunnel terminated by the servers) | 3.7.5-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2542767"></a> [2542767](#2542767) <a name="2542767"></a> <br />CM-25641 | If the BMC operating system fails to respond to IPMI, you see a traceback in <code>bmcd</code> and all the sensors might report ABSENT devices in <code>smonctl</code>. <br />To work around this issue, power cycle the switch. <br />  | 3.7.6-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2542310"></a> [2542310](#2542310) <a name="2542310"></a> <br />CM-25404 | <code>hsflow</code> disregards the setting for <code>agent.cidr</code> in the <code>/etc/hsflowd.conf</code> file and selects an IPv6 agent address. The source IP address of the hsflowd packet is IPv4, but the agent address in the <code>hsflow</code> payload shows IPv6. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541165"></a> [2541165](#2541165) <a name="2541165"></a> <br />CM-24878 | On the Dell N3048EP-ON switch, UPOE is supported only on ports 1 thru 12. (UPOE uses all four pairs of standard Ethernet cabling whereas PoE delivers power over two twisted pairs.) When you plug a UPOE device in a port higher than port 12, <code>poectl</code> reports that <code>four_pair_mode_enabled</code> is true. However, this configuration is not supported on the port so <code>poectl</code> should report that <code>four_pair_mode_enabled</code> is false. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540950"></a> [2540950](#2540950) <a name="2540950"></a> <br />CM-24751 | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switch, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status.<br />  | 3.7.3-4.1.1 | 4.2.0-4.3.0|
| <a name="2540885"></a> [2540885](#2540885) <a name="2540885"></a> <br />CM-24703 | The Dell N3048EP-ON switch does not support 1G Base-T modules in the SFP ports. | 3.7.7-3.7.14.2 | |
| <a name="2540863"></a> [2540863](#2540863) <a name="2540863"></a> <br />CM-24686 | On the EdgeCore AS5812-54X switch, the PSU2 Fan1 fluctuates between OK and LOW. When the fan speed is reported as LOW, the RPM is shown as a negative number. <br /> | 3.7.3-3.7.14 | 4.0.0-4.3.0|
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539081"></a> [2539081](#2539081) <a name="2539081"></a> <br />CM-23792 | When you delete post-up and pre-down IP peer entries from the <code>etc/network/interfaces</code> file, then run the <code>ifreload</code> command, the IP addresses are not removed and the route remains in the route table. <br />To work around this issue, either delete the IP addresses without the /32 mask component or flush the IP addresses for the interface with the <code>ip addr flush dev <interface></code> command. <br /> | 3.7.0-3.7.14 | 4.0.0-4.3.0|
| <a name="2538875"></a> [2538875](#2538875) <a name="2538875"></a> <br />CM-23696 | IPv6 multicast traffic destined to an unregistered multicast group is flooded to all ports in a bridge despite the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/swichd.conf</code> file. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538302"></a> [2538302](#2538302) <a name="2538302"></a> <br />CM-23422 | <code>portwd</code> allows an error to change the module type based on the error. For example, a bad write to a module might cause the module type to flap, which causes the link itself to flap. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538256"></a> [2538256](#2538256) <a name="2538256"></a> <br />CM-23397 | On the Broadcom switch, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets. <br />  | 3.7.2-4.0.1 | 4.1.0-4.3.0|
| <a name="2537823"></a> [2537823](#2537823) <a name="2537823"></a> <br />CM-23125 | The OpenSSL package on Cumulus Linux 3.x has a vulnerability similar to CVE-2018-0734. (The OpenSSL DSA signature algorithm has been shown to be vulnerable to a timing side channel attack. An attacker could use variations in the signing algorithm to recover the private key).  According to Debian upstream, this version "is not vulnerable &#91;to CVE-2018-0734 exactly&#93;. Nevertheless, there is a bug fix that futher reduces the amount of leaked timing information. It got no CVE on its own and introduced this vulnerability."<br />Vulnerable on CL3: 1.0.1t-1+deb8u12 | 3.7.11-3.7.14.2 | |
| <a name="2537820"></a> [2537820](#2537820) <a name="2537820"></a> <br />CM-23123 | When you enable FEC (RS or BaseR) on an interface, removing the configuration from that interface does not revert the FEC status to off/none. <br /> | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537544"></a> [2537544](#2537544) <a name="2537544"></a> <br />CM-23021 | When you run the <code>mstpctl</code> command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of <code>mstpctl</code>; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | 4.3.0|
| <a name="2537514"></a> [2537514](#2537514) <a name="2537514"></a> <br />CM-23004 | The local fallback account authenticates using the local password when the RADIUS or TACACS service is up. The expected behavior is for this to fail and only succeed when the RADIUS OR TACACS server fails to respond. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537378"></a> [2537378](#2537378) <a name="2537378"></a> <br />CM-22937 | NCLU SNMPv3 user configuration (add, delete, modify) does not complete. Changes are made to the <code>/etc/snmp/snmpd.conf</code> file but the SNMPv3 user cache file <code>/var/lib/snmp/snmpd.conf</code> fails to update correctly and the configuration does not reflect in operation. <br />To work around this issue, stop <code>snmpd</code>, remove the cache file, then restart <code>snmpd</code>. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537188"></a> [2537188](#2537188) <a name="2537188"></a> <br />CM-22849 | When an event in the network, such as a <code>switchd</code> or networking service restart, leads to an OVSDB server high availability transition, an <code>ovs-vtepd</code> core might occur. <br />This core generation has no effect on the functionality of high availability when the active OVSDB server is back in the network. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2537104"></a> [2537104](#2537104) <a name="2537104"></a> <br />CM-22808 | When you try to stop <code>hsflowd</code> on the Trident II+ switch with the <code>systemctl stop hsflowd</code> command, the process hangs until you stop it with <code>SIGKILL</code>. <br /> | 3.7.1-3.7.14 | 4.0.0-4.3.0|
| <a name="2537061"></a> [2537061](#2537061) <a name="2537061"></a> <br />CM-22794 | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent. <br /> | 3.7.1-4.0.1 | 4.1.0-4.3.0|
| <a name="2536617"></a> [2536617](#2536617) <a name="2536617"></a> <br />CM-22591 | CVE-2018-5391 (FragmentSmack) is a network vulnerability where an attacker can trigger time and calculation expensive fragment reassembly with specially crafted packets, leading to a denial of service. On a Cumulus Linux switch, the impact is limited to control plane and management plane traffic. Any control plane traffic coming in the front panel ports will be limited by existing policer ACLs.<br />To work around this issue, create a file called <code>/etc/sysctl.d/ip.conf</code> and add these settings:<br /><pre><br />net.ipv4.ipfrag_low_thresh = 196608<br />net.ipv6.ip6frag_low_thresh = 196608<br />net.ipv4.ipfrag_high_thresh = 262144<br />net.ipv6.ip6frag_high_thresh = 262144<br /></pre> | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2536608"></a> [2536608](#2536608) <a name="2536608"></a> <br />CM-22583 | Single tagged ARP requests received on a QinQ-over-VXLAN access port are dropped if ARP suppression is enabled on an unrelated VNI. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on protocol sockets.<br />When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a <code>switchd</code> restart. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535965"></a> [2535965](#2535965) <a name="2535965"></a> <br />CM-22020 | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br />To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2534394"></a> [2534394](#2534394) <a name="2534394"></a> <br />CM-20480 | The python-crypto package, which is not installed by default on Cumulus Linux, but is present in the repository to be installed, has the following security vulnerability in the version available for Cumulus Linux 3.x:<br />CVE-2018-6594: lib/Crypto/PublicKey/ElGamal.py in PyCrypto through 2.6.1 generates weak ElGamal key parameters, which allows attackers to obtain sensitive information by reading ciphertext data (i.e., it does not have semantic security in face of a ciphertext-only attack). The Decisional Diffie-Hellman (DDH) assumption does not hold for PyCrypto's ElGamal implementation.<br />More information at https://security-tracker.debian.org/tracker/CVE-2018-6594 . | 3.7.9-3.7.14.2 | |
| <a name="2532017"></a> [2532017](#2532017) <a name="2532017"></a> <br />CM-18192 | In FRR, <code>bgp_snmp</code> does not show all BGP peers when peer groups used. | 3.7.11-4.0.1 | 4.1.0-4.3.0|

### Fixed Issues in 3.7.11
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="2547912"></a> [2547912](#2547912) <a name="2547912"></a> <br />CM-28511 | The following vulnerabilities were discovered in cURL, an URL transfer library.<br />CVE-2019-5436: A heap buffer overflow in the TFTP receiving code was discovered, which could allow DoS or arbitrary code execution.<br />CVE-2019-5482: Thomas Vegas discovered a heap buffer overflow that could be triggered when a small non-default TFTP blocksize is used.<br />Vulnerable: 7.38.0-4+deb8u15<br />Fixed: 7.38.0-4+deb8u16 | 3.7.10 | |
| <a name="2547402"></a> [2547402](#2547402) <a name="2547402"></a> <br />CM-28224 | The following security vulnerability has been announced in qemu, which is not installed by default on Cumulus Linux but is available in the repository for optional installation:<br />CVE-2019-15890: libslirp 4.0.0, as used in QEMU 4.1.0, has a use-after-free in ip_reass in ip_input.c.<br />Vulnerable: <= 2.1+dfsg-12+deb8u11<br />Fixed: 2.1+dfsg-12+deb8u12 | 3.7.10 | |
| <a name="2547118"></a> [2547118](#2547118) <a name="2547118"></a> <br />CM-28074 | The following security vulnerabilities have been announced in the libtiff5 library on Cumulus Linux 4.0:<br />CVE-2019-14973, CVE-2019-17546: Multiple integer overflows have been discovered in the libtiff library and the included tools.<br />Vulnerable: 4.0.10-4<br />Fixed: 4.1.0+git191117-2~deb10u1 | 3.7.10, 4.0.0-4.0.1 | |
| <a name="2546228"></a> [2546228](#2546228) <a name="2546228"></a> <br />CM-27628 | The following security vulnerabilities have been announced in the nss/libnss3 library, which is not installed by default but is available in the repository:<br />CVE-2019-11745: Out-of-bounds write when passing an output buffer smaller than the block size to NSC_EncryptUpdate<br />CVE-2019-17007: nss: Handling of Netscape Certificate Sequences in CERT_DecodeCertPackage() may crash with a NULL deref leading to DoS<br />See https://security-tracker.debian.org/tracker/source-package/nss for more information.<br />Vulnerable: <= 3.26-1+debu8u7<br />Fixed: 3.26-1+debu8u9 | 3.7.10 | |
| <a name="2545868"></a> [2545868](#2545868) <a name="2545868"></a> <br />CM-27457 | If you delete, then re-add a PBR policy on an interface, the configured PBR policy is not programmed in the kernel or <code>switchd</code>. | 3.7.9-3.7.10, 4.0.0-4.0.1 | |
| <a name="2545866"></a> [2545866](#2545866) <a name="2545866"></a> <br />CM-27456 | After making a series of PBR configuration changes using NCLU commands, the stale PBR entry is still present in the kernel. | 3.7.9-3.7.10, 4.0.0-4.0.1 | |
| <a name="2545694"></a> [2545694](#2545694) <a name="2545694"></a> <br />CM-27351 | On rare occasions, after rebooting the MLAG secondary switch, one MLAG device might see the peer as down, which can cause traffic disruption to connected hosts. | 3.7.7-3.7.10 | |
| <a name="2545644"></a> [2545644](#2545644) <a name="2545644"></a> <br />CM-27321 | The following CVEs were announced that affect the ghostscript package:<br />CVE-2019-14869: Manfred Paul and Lukas Schauer reported that the .charkeys procedure in Ghostscript, the GPL PostScript/PDF interpreter, does not properly restrict privileged calls, which could result in bypass of file system restrictions of the dSAFER sandbox.<br />Cumulus Linux 3: <= 9.26a~dfsg-0+deb8u5 vulnerable, >= 9.26a~dfsg-0+deb8u6 fixed.<br />https://security-tracker.debian.org/tracker/ghostscript<br />https://security-tracker.debian.org/tracker/CVE-2019-14869 | 3.7.10 | |
| <a name="2545608"></a> [2545608](#2545608) <a name="2545608"></a> <br />CM-27299 | The protocol daemon <code>bgpd</code> crashes when a link/neighbor flaps if static routes pointing to Null0 are advertising through BGP.<br />To work around this issue, reboot the switch, then remove the static routes or stop advertising these routes. | 3.7.9-3.7.10, 4.0.0-4.0.1 | |
| <a name="2545563"></a> [2545563](#2545563) <a name="2545563"></a> <br />CM-27269 | The following Linux kernel security vulnerabilities do not affect Cumulus Linux in supported configurations:<br />CVE-2018-12207 CVE-2019-0154 CVE-2019-0155 CVE-2019-11135<br />Several vulnerabilities have been discovered in the Linux kernel that may may to a privilege escalation, denial of service, or information leak.<br />CVE-2018-12207: Intel CPU hypervisor vulnerability.  Running hypervisors on Cumulus Linux is not supported.<br />CVE-2019-0154, CVE-2019-0155:  Intel GPU vulnerabilities.  GPUs are not present on our switches.<br />CVE-2019-11135, CVE-2019-11139: Intel CPU transactional memory vulnerability.  None of our switches support transactional memory.<br />For the detailed security status of linux, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/linux |  | |
| <a name="2545520"></a> [2545520](#2545520) <a name="2545520"></a> <br />CM-27243 | The length of the netlink message is not set properly for non-bridge family type messages. The same length is used for both bridge and non-bridge even though the bridge family type message has an extra attribute. This causes extra bytes to be left over in non-bridge family type netlink messages. | 3.7.10, 4.0.0-4.3.0 | |
| <a name="2545505"></a> [2545505](#2545505) <a name="2545505"></a> <br />CM-27233 | If you change multiple BGP or BFD timers in the <code>/etc/frr/frr.conf</code> file and then reload FRR, a traceback is encountered and the change does not take effect. | 3.7.9-3.7.10 | |
| <a name="2545448"></a> [2545448](#2545448) <a name="2545448"></a> <br />CM-27193 | The <code>l1-show</code> command prints a traceback for switch ports that have sub-interfaces configured. There is no functional impact to traffic but the <code>l1-show</code> troubleshooting and validation command does not execute on switch ports that have VLAN sub-interfaces. | 3.7.10, 4.0.0-4.0.1 | |
| <a name="2545405"></a> [2545405](#2545405) <a name="2545405"></a> <br />CM-27174 | The <code>ospfd</code> daemon might crash with the following kernel trace: <br /><pre><br />2019-11-06T23:00:08.261749+09:00 cumulus ospfd&#91;5339&#93;: Assertion 'node' failed in file ospfd/ospf_packet.c, line 671, function ospf_write<br /></pre> | 3.7.6-3.7.10 | |
| <a name="2545236"></a> [2545236](#2545236) <a name="2545236"></a> <br />CM-27096 | On the Edgecore AS6812 switch, you might see rare I2C errors. | 3.7.2-3.7.10, 4.0.0-4.0.1 | |
| <a name="2545133"></a> [2545133](#2545133) <a name="2545133"></a> <br />CM-27025 | On the Mellanox switch, ACL lookups are performed for VLAN matches when no rules with <code>UNTAGGED</code> match are present. | 3.7.2-3.7.10, 4.0.0-4.0.1 | |
| <a name="2545087"></a> [2545087](#2545087) <a name="2545087"></a> <br />CM-26996 | On the Mellanox switch with the Spectrum ASIC, the <code>--set-burst</code> parameter in an iptables rule does not take effect. | 3.7.10, 4.0.0-4.0.1 | |
| <a name="2545049"></a> [2545049](#2545049) <a name="2545049"></a> <br />CM-26968 | When networking fails to start properly, an MLAG memory leak occurs, which might cause memory issues. | 3.7.9-3.7.10, 4.0.0-4.0.1 | |
| <a name="2545027"></a> [2545027](#2545027) <a name="2545027"></a> <br />CM-26954 | In the default VRF, VRRP might crash and stay in an initialize state. As a result, VRRP multicast traffic is not generated. | 3.7.8-3.7.10 | |
| <a name="2545019"></a> [2545019](#2545019) <a name="2545019"></a> <br />CM-26947 | The following CVEs affect the OpenLDAP utilities:<br />CVE-2019-13057 CVE-2019-13565<br />For the detailed security status, refer to the security tracker page at:<br />https://security-tracker.debian.org/tracker/CVE-2019-13565<br />https://security-tracker.debian.org/tracker/CVE-2019-13057<br />Vulnerable versions: < 2.4.40+dfsg-1+deb8u5<br />Fixed versions: >= 2.4.40+dfsg-1+deb8u5 |  | |
| <a name="2544867"></a> [2544867](#2544867) <a name="2544867"></a> <br />CM-26849 | Package: tcpdump<br />CVE ID: CVE-2018-10103 CVE-2018-10105 CVE-2018-14461 CVE-2018-14462<br />CVE-2018-14463 CVE-2018-14464 CVE-2018-14465 CVE-2018-14466<br />CVE-2018-14467 CVE-2018-14468 CVE-2018-14469 CVE-2018-14470<br />CVE-2018-14879 CVE-2018-14880 CVE-2018-14881 CVE-2018-14882<br />CVE-2018-16227 CVE-2018-16228 CVE-2018-16229 CVE-2018-16230<br />CVE-2018-16300 CVE-2018-16451 CVE-2018-16452 CVE-2019-15166<br />Several vulnerabilities have been discovered in tcpdump, a command-line<br />network traffic analyzer. These vulnerabilities might result in denial of<br />service or, potentially, execution of arbitrary code.<br />For the detailed security status of tcpdump, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/tcpdump<br />Fixed versions: 4.9.3-1~deb10u1 on Cumulus Linux 4, 4.9.3-1~deb8u1 on Cumulus Linux 3. | 3.7.10 | |
| <a name="2544847"></a> [2544847](#2544847) <a name="2544847"></a> <br />CM-26838 | You might experience a <code>bgpd</code> memory usage increase and significant update exchanges due to host moves between VTEPs. | 3.7.7-3.7.10, 4.0.0-4.0.1 | |
| <a name="2544815"></a> [2544815](#2544815) <a name="2544815"></a> <br />CM-26815 | If a router MAC address changes on a VTEP, other VTEPs might still point to the previous router MAC address. | 3.7.10 | |
| <a name="2544723"></a> [2544723](#2544723) <a name="2544723"></a> <br />CM-26769 | Setting ProtoDown on ports populated with SFP modules providing RJ-45 1000BASE-T interfaces does not cause the carrier to be dropped. The kernel shows carrier down; however, the remote device still shows a link. | 3.7.6-3.7.10, 4.0.0-4.3.0 | |
| <a name="2544625"></a> [2544625](#2544625) <a name="2544625"></a> <br />CM-26703 | VXLAN encapsulated ICMP packets hit the catchall EFP policer instead of the ICMP policer and you might experience partial packet loss.<br /> | 3.7.9-3.7.10, 4.0.0-4.0.1 | |
| <a name="2544609"></a> [2544609](#2544609) <a name="2544609"></a> <br />CM-26691 | BGP is configured with soft reconfiguration-in for its peers, which is not working correctly and causes routes to have an unexpected label. As a result, transit traffic is not forwarded by the switch. | 3.7.7-3.7.10 | |
| <a name="2544559"></a> [2544559](#2544559) <a name="2544559"></a> <br />CM-26657 | When you install a large number of new rules with nonatomic mode enabled, there is a chance that you install more rules than the number of available slots in the slice, which results in the slice being completely wiped and reinstalled. This causes a large drop increase, including to cpu0, and might cause a major outage by dropping all BGP sessions. | 3.7.8-3.7.10 | |
| <a name="2544401"></a> [2544401](#2544401) <a name="2544401"></a> <br />CM-26566 | Package: openssl<br />CVE ID:  CVE-2019-1547 CVE-2019-1549 CVE-2019-1563<br />Three security issues were discovered in OpenSSL: A timing attack against<br />ECDSA, a padding oracle in PKCS7_dataDecode() and CMS_decrypt_set1_pkey()<br />and it was discovered that a feature of the random number generator (RNG)<br />intended to protect against shared RNG state between parent and child<br />processes in the event of a fork() syscall was not used by default.<br />Fixed version: 1.1.1d-0+deb10u1<br />We recommend that you upgrade your openssl packages.<br />For the detailed security status of openssl,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/openssl | 3.7.0-3.7.10 | |
| <a name="2544385"></a> [2544385](#2544385) <a name="2544385"></a> <br />CM-26556 | The QCT QuantaMesh BMS T7032-IX7 switch may report "failed to request GPIO pin"   errors during the boot up.  | 3.7.5-3.7.10 | |
| <a name="2544329"></a> [2544329](#2544329) <a name="2544329"></a> <br />CM-26525 | When an MLAG peerlink frequently alternates states between learning and blocking, an excessive number of TCP sessions might be created, which results in the following error display:<br /><pre><br />OSError: &#91;Errno 24&#93; Too many open files<br /></pre> | 4.0.0-4.0.1 | |
| <a name="2544324"></a> [2544324](#2544324) <a name="2544324"></a> <br />CM-26523 | Package: hostapd<br />CVE ID: CVE-2019-13377 CVE-2019-16275<br />Two vulnerabilities were found in the WPA protocol implementation found in wpa_supplication (station) and hostapd (access point).<br />CVE-2019-13377<br />A timing-based side-channel attack against WPA3's Dragonfly handshake when using Brainpool curves could be used by an attacker to retrieve the password.<br />CVE-2019-16275<br />Insufficient source address validation for some received Management frames in hostapd could lead to a denial of service for stations associated to an access point. An attacker in radio range of the access point could inject a specially constructed unauthenticated IEEE 802.11 frame to the access point to cause associated stations to be disconnected and require a reconnection to the network.<br />Fixed version: 1:2.8.0-cl4u3 | 3.7.0-3.7.10 | |
| <a name="2544213"></a> [2544213](#2544213) <a name="2544213"></a> <br />CM-26450 | Cumulus Linux poed generates excessive debug log entries.  These will be reduced in a future release. | 3.7.3-3.7.10, 4.0.0-4.0.1 | |
| <a name="2544200"></a> [2544200](#2544200) <a name="2544200"></a> <br />CM-26448 | Traffic sent to the SVI IP address of a switch might be lost if all of the following conditions are met:<br />* The switch is a member of an MLAG pair<br />* The traffic is sourced from a layer 2 adjacent host<br />* The host is located within a VRF of the MLAG pair<br />* The traffic from the source crosses the peer link<br />* VXLAN is configured on the MLAG pair<br /><br />This issue does not impact transit traffic or traffic that does not meet all of the described conditions.<br />To workaround this issue, restart <code>switchd</code>. | 3.7.9-3.7.10, 4.0.0-4.0.1 | |
| <a name="2544182"></a> [2544182](#2544182) <a name="2544182"></a> <br />CM-26437 | NCLU crashes when you run the <code>net add interface storage-optimized pfc</code> command because non-ascii quotes exist in the <code>datapath.conf</code> file.<br />To work around this issue, manually edit the <code>/usr/lib/python2.7/dist-packages/cumulus/__chip_config/mlx/datapath.conf</code> file and replace the non-ascii single quotes  with ascii single quotes (standard single quote on the keyboard). | 3.7.9-3.7.10 | |
| <a name="2544057"></a> [2544057](#2544057) <a name="2544057"></a> <br />CM-26372 | FRR crashes when adding an IPv6 neighbor with extended-nexthop capability. | 3.7.9-3.7.10 | |
| <a name="2543937"></a> [2543937](#2543937) <a name="2543937"></a> <br />CM-26308 | An interface alias configured outside FRR using <code>iproute2</code> is imported into the FRR running configuration and overrides the internal description. After an FRR reload, this causes FRR to delete the interface alias in an inefficient way. Depending on how many interfaces with aliases you have configured, this can cause a FRR reload to time out.<br />To work around this issue, remove the interface alias description from <code>iproute2</code>. | 3.7.8-3.7.10, 4.0.0-4.3.0 | |
| <a name="2543875"></a> [2543875](#2543875) <a name="2543875"></a> <br />CM-26272 | On the Mellanox Spectrum switch, a route withdrawal might cause the associated next hop neighbor entry to be deleted in hardware but remain in the kernel. This can cause traffic going through the directly connected route to the removed neighbor entry to be forwarded to the CPU. | 3.7.6-3.7.10 | |
| <a name="2543835"></a> [2543835](#2543835) <a name="2543835"></a> <br />CM-26252 | The following CVEs were announced that affect the ghostscript package:<br />CVE ID : CVE-2019-14811 CVE-2019-14812 CVE-2019-14813 CVE-2019-14817<br />It was discovered that various procedures in Ghostscript, the GPL PostScript/PDF interpreter, do not properly restrict privileged calls, which could result in bypass of file system restrictions of the dSAFER sandbox.<br />We recommend that you upgrade your ghostscript packages.<br />For the detailed security status of ghostscript, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/ghostscript | 3.7.0-3.7.10 | |
| <a name="2543781"></a> [2543781](#2543781) <a name="2543781"></a> <br />CM-26217 | NCLU does not allow you to configure OSPF NSSAs. For example: <br /><pre><br />cumulus&#64;switch:~$ net add ospf area 0.0.0.1 nssa <br />ERROR: Command not found. <br />net add ospf area 0.0.0.1 nssa<br /></pre><br />To work around this issue, use FRR instead. For example: <br /><pre><br />switch# configure terminal <br />switch(config)# router ospf <br />switch(config-router)# area 0.0.0.1 nssa <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | |
| <a name="2543727"></a> [2543727](#2543727) <a name="2543727"></a> <br />CM-26181 | ACL rules, such as the following, fail to install if you use swp+ (interfaces mentioned as wildcards).<br /><pre><br />-A FORWARD -i swp+ -j LOG<br />-A FORWARD -i swp+ -j DROP<br /></pre><br />You can now install such rules with swp+. | 3.7.3-3.7.10 | |
| <a name="2543724"></a> [2543724](#2543724) <a name="2543724"></a> <br />CM-26179 | If a hostname contains utf-8 characters, the NCLU <code>net show lldp</code> command outputs the following error: <br /><pre><br />ERROR: 'ascii' codec can't encode character u'\xe9' in position 3: ordinal not in range(128) <br />See /var/log/netd.log for more details.  <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | |
| <a name="2543708"></a> [2543708](#2543708) <a name="2543708"></a> <br />CM-26169 | Cumulus Linux does not map QinQ packets to VXLANs in a configuration with a VLAN-aware bridge and MLAG on the Trident3 platform. <br /> | 3.7.9-3.7.10 | |
| <a name="2543690"></a> [2543690](#2543690) <a name="2543690"></a> <br />CM-26158 | On the Mellanox switch, UFT profiles are unable to support the documented capacity for routes to addresses that are more than 64 bits in length. The listed capacities assume 64-bit destination IP addresses. | 3.7.8-3.7.10, 4.0.0-4.0.1 | |
| <a name="2543668"></a> [2543668](#2543668) <a name="2543668"></a> <br />CM-26147 | On the EdgeCore AS4610 switch, the <code>ping</code> command fails unless you run the command with <code>sudo</code>. <br /> To work around this issue, run the following commands: <br /><pre><br /> cumulus&#64;switch:~$ sudo setcap cap_net_raw+ep /usr/share/mgmt-vrf/bin/ping <br /> cumulus&#64;switch:~$ sudo setcap cap_net_raw+ep /usr/share/mgmt-vrf/bin/ping6<br /></pre><br /> Run the following command to verify the workaround: <br /> <pre> <br /> cumulus&#64;switch:~$ getcap /usr/share/mgmt-vrf/bin/ping* <br /> </pre> <br /> You should see the following output: <br /> <pre> <br /> /usr/share/mgmt-vrf/bin/ping = cap_net_raw+ep <br /> /usr/share/mgmt-vrf/bin/ping6 = cap_net_raw+ep <br /> </pre> <br />  | 3.7.6-3.7.10, 4.1.0-4.1.1 | |
| <a name="2543665"></a> [2543665](#2543665) <a name="2543665"></a> <br />CM-26146 | <code>clagd</code> memory consumption increases under certain unknown conditions. <br /> | 3.7.8-3.7.10 | |
| <a name="2543560"></a> [2543560](#2543560) <a name="2543560"></a> <br />CM-26082 | The following vulnerabilities are only applicable if qemu is installed from the repo mirror. It is not present in the base image by default, so base images without qemu installed are not vulnerable.<br />CVE-2018-20815 CVE-2019-13164 CVE-2019-14378: Multiple security issues were discovered in QEMU, a fast processor emulator, which could result in denial of service, the execution of arbitrary code or bypass of ACLs.<br />Cumulus Linux 3: >= 2.1+dfsg-12+deb8u12 fixed.<br />https://security-tracker.debian.org/tracker/qemu<br />https://security-tracker.debian.org/tracker/CVE-2018-20815<br />https://security-tracker.debian.org/tracker/CVE-2019-13164<br />https://security-tracker.debian.org/tracker/CVE-2019-14378 | 3.7.10 | |
| <a name="2543374"></a> [2543374](#2543374) <a name="2543374"></a> <br />CM-25973 | After a remote VTEP peer link goes down, the tunnel destination IP address might be incorrect in hardware, which might cause loss of overlay communication between VTEPs. | 3.7.8-3.7.10 | |
| <a name="2543325"></a> [2543325](#2543325) <a name="2543325"></a> <br />CM-25955 | Lenovo switches do not send or receive LLDP on eth0 interfaces. | 3.7.7-3.7.10 | |
| <a name="2543113"></a> [2543113](#2543113) <a name="2543113"></a> <br />CM-25824 | NCLU restarts FRR when attempting to remove a BGP VRF stanza. This happens regardless of whether the VRF is valid/configured elsewhere on the switch or the removal is successful. To work around this issue, remove the stanza using vtysh. <br /> | 3.7.3-3.7.10 | |
| <a name="2542958"></a> [2542958](#2542958) <a name="2542958"></a> <br />CM-25747 | When transitioning from a down state to an up state due to peerlink failure and recovery, MLAG does not start the initDelay timer before trying to bring everything back up. | 3.7.7-3.7.10 | |
| <a name="2542913"></a> [2542913](#2542913) <a name="2542913"></a> <br />CM-25718 | IF-MIB::ifHCInOctets reports significantly lower values than reported by interface counters seen elsewhere. | 3.7.6-3.7.10 | |
| <a name="2542885"></a> [2542885](#2542885) <a name="2542885"></a> <br />CM-25704 | The following CVEs affect the linux package: CVE-2019-13272<br />It was discovered that the ptrace subsystem in the Linux kernel mishandles the management of the credentials of a process that wants to create a ptrace relationship, allowing a local user to obtain root privileges under certain scenarios.<br />Cumulus Linux is not affected.<br />For the detailed security status of linux please refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/CVE-2019-13272 |  | |
| <a name="2542872"></a> [2542872](#2542872) <a name="2542872"></a> <br />CM-25693 | After you issue the NCLU <code>net del bgp vrf <vrf> autonomous-system <AS></code> command and commit the change, Cumulus Linux does not remove the configuration from the <code>/etc/frr/frr.conf</code> file or the <code>net show config commands</code>. <br /> | 3.7.3-3.7.10, 4.0.0-4.0.1 | |
| <a name="2542835"></a> [2542835](#2542835) <a name="2542835"></a> <br />CM-25672 | <code>snmpd</code> fails because NCLU does not remove <code>agentaddress &#64;vrf</code> lines when running the <code>net add snmp-server listening-address all</code> command. | 3.7.4-3.7.10 | |
| <a name="2542765"></a> [2542765](#2542765) <a name="2542765"></a> <br />CM-25640 | When you configure the switch to send an EAP request with the <code>net add dot1x send-eap-request-id</code> command, the switch ignores re-authentication attempts and does not send back an EAPol. <br /> | 3.7.6-3.7.10 | |
| <a name="2542510"></a> [2542510](#2542510) <a name="2542510"></a> <br />CM-25505 | In EVPN symmetric or centralized configurations with BGP peering over a peer link, VXLAN routed packets transiting an MLAG peer are dropped until the <code>clagd</code> <code>init-delay</code> timer expires during the bring-up sequence following a reboot.<br />The problem is caused by a race condition when programming the anycast IP address (used to terminate VXLAN tunnels), where the hardware is programmed before the software by <code>clagd</code>.<br />To work around this issue, configure the BGP path across the peer link to be less preferred. The example below uses AS path prepending and the MLAG switches are iBGP neighbors. However, other BGP configurations achieve the same result. <br />In the <code>/etc/frr/frr.conf</code> file, make a new AS path access list and route map to apply BGP pre-pending of the local ASN one or more times. For example: <br /><pre> <br />ip as-path access-list MY_ASN permit ^$ <br /><br />route-map peerlink-add-asn permit 10 <br />match as-path MY_ASN <br />set as-path prepend 4200000101 <br />route-map peerlink-add-asn permit 20 <br /></pre>  | 3.7.6-3.7.10, 4.0.0-4.0.1 | |
| <a name="2542384"></a> [2542384](#2542384) <a name="2542384"></a> <br />CM-25447 | When you define a trap destination using &#64;mgmt, <code>snmpd</code> indicates that the network is unreachable even though the IP address is reachable in the management VRF. <br />To work around this issue, remove <code>&#64;mgmt vrf</code> references in the <code>/etc/snmp/snmpd.conf</code> file, stop <code>snmpd</code>, then start <code>snmpd</code> manually in the management VRF with the <code>systemctl start snmpd&#64;mgmt</code> command. <br /> | 3.7.6-3.7.10 | |
| <a name="2542248"></a> [2542248](#2542248) <a name="2542248"></a> <br />CM-25376 | When you generate a cl-support file, <code>clagd.service</code> prints log messages similar to the following: <br /><pre> <br />019-03-21T07:18:15.727581+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - start <br />2019-03-21T07:18:15.728157+00:00 leaf01 clagd&#91;20912&#93;: #012thread: CollectSysInfo (140608446367488) <br />2019-03-21T07:18:15.735986+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 783, in __bootstrap <br />2019-03-21T07:18:15.736585+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 810, in __bootstrap_inner <br />2019-03-21T07:18:15.737045+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 763, in run <br />2019-03-21T07:18:15.737933+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 930, in CollectSysInfoT <br />2019-03-21T07:18:15.739527+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 187, in CollectSysInfo <br />2019-03-21T07:18:15.740540+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 621, in wait <br />2019-03-21T07:18:15.742293+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/dist-packages/clag/clagthread.py, line 48, in wait <br />. <br />. <br />2019-03-21T07:18:16.456061+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - end <br /></pre> <br /> | 3.7.6-3.7.10 | |
| <a name="2542065"></a> [2542065](#2542065) <a name="2542065"></a> <br />CM-25298 | The following CVEs were announced in a Debian Security Advisory that affects vim modelines. <br />Package: vim and neovim <br />CVE ID: CVE-2019-12735 <br />Debian Bugs: 930020, 930024 <br />getchar.c in Vim before 8.1.1365 and Neovim before 0.3.6 allows remote attackers to execute arbitrary OS commands via the :source! command in a modeline, as demonstrated by execute in Vim, and assert_fails or nvim_input in Neovim. <br />For the detailed security status, refer to the security tracker page at: <br />https://security-tracker.debian.org/tracker/CVE-2019-12735 <br />https://people.canonical.com/~ubuntu-security/cve/2019/CVE-2019-12735.html <br />https://github.com/numirias/security/blob/master/doc/2019-06-04_ace-vim-neovim.md <br />Cumulus Networks recommends that you disable modelines in the the <code>vimrc</code> file (set nomodeline) to use the securemodelines plugin or to disable modelineexpr (since patch 8.1.1366, Vim-only) to disallow expressions in modelines. <br />To check if you have modelines enabled, open vim and enter: <br />:set modeline? <br />If vim returns <code>nomodeline</code>, you are _not_ vulnerable. If you are vulnerable or you want to ensure your security with this issue, add these lines to your <code>vimrc</code> file: <br /><pre> <br />set modelines=0 <br />set nomodeline <br /></pre> <br />modeline is enabled by default. <br />Verify that you do not have any existing lines in <code>.vimrc</code> that set <code>modelines</code> or <code>modeline</code>. |  | |
| <a name="2537536"></a> [2537536](#2537536) <a name="2537536"></a> <br />CM-23016 | When FRR restarts, <code>snmp&#91;err&#93; dev/kmem: Permission denied</code> error messages are recorded in the log file and SNMPd might crash periodically. | 3.7.5-3.7.10 | |
| <a name="2536639"></a> [2536639](#2536639) <a name="2536639"></a> <br />CM-22605 | On a Dell S4048 switch, when you set the eth0 speed to 100, either with NCLU or by editing the <code>/etc/network/interfaces</code> file, the <code>igb</code> driver crashes, which brings down eth0. <br />To work around this issue: <br />* If eth0 is configured in the management VRF, power cycle the switch; the eth0 configuration fails and reverts back to the default (auto-negotiation/1000). <br />* If eth0 is configured in the default VRF and you power cycle after the crash, <code>igb</code> continues to crash on boot up (before getting to login prompt); power-cycle the switch, select the Advanced option in GRUB to boot to recovery mode, then modify the <code>/etc/network/interfaces</code> file. | 3.7.0-3.7.10 | |
| <a name="2536559"></a> [2536559](#2536559) <a name="2536559"></a> <br />CM-22538 | When deleting an interface using NCLU, if the <code>/etc/network/interfaces</code> alias is different than the <code>/etc/frr/frr.conf</code> description, the <code>net commit</code> command returns the following error: <br /><pre><br /> /etc/frr/daemons was modified by another user.<br /></pre><br />Despite this error, the change is made and the description is removed from the <code>frr.conf</code> file.  | 3.7.3-3.7.10 | |
| <a name="2536231"></a> [2536231](#2536231) <a name="2536231"></a> <br />CM-22277 | On the Broadcom switch with the Trident3 ASIC, the ECN-CE bit is set by default on transit traffic. This might result in hosts adjusting traffic behavior if they are configured for the ECN feature. <br />In Cumulus Linux 3.7.11, the default behavior changed; the ECN-CE bit is _no longer_ set by default on transit traffic. | 3.7.3-3.7.10, 4.0.0-4.0.1 | |
| <a name="2535306"></a> [2535306](#2535306) <a name="2535306"></a> <br />CM-21373 | Debian issued the following security advisory, DSA-4231-1, which affects the libgcrypt20 package. This advisory applies only to the the Debian Stretch release. <br />Debian Jessie, upon which Cumulus Linux 3.0 - 3.6.2 is based, is vulnerable. <br />CVE-2018-0495 <br />It was discovered that Libgcrypt is prone to a local side-channel attack allowing recovery of ECDSA private keys. <br />For the stable distribution (stretch), this problem has been fixed in version 1.7.6-2+deb9u3. <br />We recommend that you upgrade your libgcrypt20 packages. <br />For the detailed security status of libgcrypt20, refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/libgcrypt20 |  | |
| <a name="2535209"></a> [2535209](#2535209) <a name="2535209"></a> <br />CM-21278 | The <code>net show lldp</code> command sometimes shows the port description in the <code>Remote Port</code> field. The <code>net show interface</code> command shows the correct value in the <code>Remote Host</code> field.<br />To work around this issue, use <code>net show interface</code> command for LLDP output when connected to Cisco equipment. | 3.7.5-3.7.10, 4.0.0-4.3.0 | |
| <a name="2534450"></a> [2534450](#2534450) <a name="2534450"></a> <br />CM-20534 | The default BGP instance must be provisioned and always exist for proper operation of dynamic leaking of routes between VRFs.  | 3.7.0-3.7.10 | |
| <a name="2534040"></a> [2534040](#2534040) <a name="2534040"></a> <br />CM-20132 | On Trident2 switches running 802.3x regular link pause, pause frames are accounted in HwIfInDiscards counters and are dropped instead of processed. |  | |
| <a name="2532593"></a> [2532593](#2532593) <a name="2532593"></a> <br />CM-18727 | On the Mellanox SN-2100 switch, unicast packets are counted in multicast queue counters. |  | |
| <a name="2528990"></a> [2528990](#2528990) <a name="2528990"></a> <br />CM-15278 | During a link flap test, you might occasionally see a message similar to: <code>warning: swp6: netlink: cannot set link swp6 down: &#91;Errno 98&#93; Address already in use</code>. | 3.7.6-3.7.10 | |
| <a name="2526985"></a> [2526985](#2526985) <a name="2526985"></a> <br />CM-13316 | When you try to remove a VNI from a bridge using a regex match, the VNI is added back when you run the <code>ifreload -a</code> command. |  | |

## 3.7.10 Release Notes
### Open issues in 3.7.10

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-28462"></a> [CM-28462](#CM-28462) <a name="CM-28462"></a> <br /> | On rare occasions, when you upgrade Cumulus Linux with the `apt-get upgrade` command, the upgrade fails and reports `No space left on device`. Checking the disk utilization shows that the disk is not full.<br/>To work around this issue, run the `apt-get upgrade` command again and reboot the device if prompted to complete the upgrade. | 3.7.10-3.7.14.2 | |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2595889"></a> [2595889](#2595889) <a name="2595889"></a> <br />CM-31120 | In a traditional bridge configuration with <code>ip-forward off</code>, neighbors are synchronized to hardware with a <code>switchd</code> restart but are cleared when you flap the bridge interface. | 3.7.10-4.2.1 | 4.3.0|
| <a name="2562511"></a> [2562511](#2562511) <a name="2562511"></a> <br /> | <code>hostapd} does not fail over to secondary RADIUS servers for 802.1x authentication when the primary radius is reachable but not responding to Access-Requests<br />If the primary RADIUS server is having a problem servicing requests, you can remove it from the configuration temporarily to force requests to be sent to alternate servers. | 3.7.10-3.7.14.2 | |
| <a name="2556037"></a> [2556037](#2556037) <a name="2556037"></a> <br />CM-33012 | After you add an interface to the bridge, an OSPF session flap can occur.<br /><br /> | 3.7.9-4.2.0 | 4.2.1-4.3.0|
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553530"></a> [2553530](#2553530) <a name="2553530"></a> <br />CM-31545 | In an MLAG configuration with a layer 3 VNI, when you bounce the peer link, all layer 2 VNIs listed under the layer 3 VNI are duplicated. <br />To work around this issue, restart FRR with the <code>sudo systemctl restart frr.service</code> command.<br /><br /> | 3.7.10-3.7.13, 4.1.1-4.2.1 | 3.7.14, 4.3.0|
| <a name="2553015"></a> [2553015](#2553015) <a name="2553015"></a> <br />CM-31300 | If a neighbour contains a special character in PortID for LLDP, the <code>net show interface</code> command does not display the LLDP information or the command might fail. | 3.7.10-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2552739"></a> [2552739](#2552739) <a name="2552739"></a> <br />CM-31148 | Counters for IPROUTER rules do not increase when traffic is forwarded to the CPU because there is no IP neighbor. | 3.7.2-3.7.14.2 | |
| <a name="2552647"></a> [2552647](#2552647) <a name="2552647"></a> <br />CM-31086 | When you add a member to a bond that has a subinterface configured (such as peerlink.4094), the new member is assigned only the VLAN of the subinterface for forwarding.<br />To work around this issue, bounce the bond or shutdown the new interface and use the remaining members over the bond. | 3.7.10-3.7.13, 4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552528"></a> [2552528](#2552528) <a name="2552528"></a> <br />CM-31028 | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2552352"></a> [2552352](#2552352) <a name="2552352"></a> <br />CM-30914 | The following security vulnerabilities have been announced in the nss / libnss3 packages:<br />CVE-2020-6829: Side channel attack on ECDSA signature generation<br />CVE-2020-12400: P-384 and P-521 implementation uses a side-channel vulnerable modular inversion function<br />CVE-2020-12401: ECDSA timing attack mitigation bypass<br />Vulnerable: <= 3.26-1+debu8u11<br />Fixed: 3.26-1+debu8u12 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552351"></a> [2552351](#2552351) <a name="2552351"></a> <br />CM-30913 | The following vulnerability has been announced in the libx11 packages:<br />CVE-2020-14344: The X Input Method (XIM) client implementation in libX11 has some integer overflows and signed/unsigned comparison issues that can lead to heap corruption when handling malformed messages from an input method.<br />Vulnerable: <= 1.6.2-3+deb8u2<br />Fixed: 1.6.2-3+deb8u3 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2551675"></a> [2551675](#2551675) <a name="2551675"></a> <br />CM-30479 | When you restart <code>clagd</code>, the edge port setting on the peer link changes. | 3.7.2-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551288"></a> [2551288](#2551288) <a name="2551288"></a> <br />CM-30286 | When you remove BFD configuration by editing the <code>/etc/frr/frr.conf</code> file and restarting FRR, you see a traceback.<br />To work around this issue, either use NCLU or vtysh commands to remove the BFD configuration, or restart FRR with the new <code>/etc/frr/frr.conf</code> file. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2550601"></a> [2550601](#2550601) <a name="2550601"></a> <br />CM-29978 | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | 4.2.1-4.3.0, 4.3.0|
| <a name="2550375"></a> [2550375](#2550375) <a name="2550375"></a> <br />CM-29838 | CPU utilization may increase when clag-managed bond interfaces are operationally/LACP down but the physical carrier remains up on the bond member switchports. This condition occurs when clag bond redirection is enabled and bond members remain up while the parent bond does not negotiate LACP.<br /><br />This issue is resolved in Cumulus Linux 3.7.14. | 3.7.9-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2550350"></a> [2550350](#2550350) <a name="2550350"></a> <br />CM-29830 | Unicast traffic from downlink hosts is flooded to multiple remote VTEPs, which might also cause high HwIfOutQDrops/TX_DRP on the uplink ports.<br />To work around this issue, restart <code>switchd</code>. | 3.7.10-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2550323"></a> [2550323](#2550323) <a name="2550323"></a> <br />CM-29807 | After a neighbor is removed, the redistributed neighbor entry is withdrawn from the BGP table, but the prefix might still be selected as the bestpath when the host's originated prefix is not advertised.<br />To work around this issue, recreate the neighbor entry and flap the interface to the host. <br />Or, if the host is already down, manually create a neighbor entry with an invalid MAC address, which forces redistribute neighbor to re-withdraw the entry. | 3.7.3-3.7.12 | 3.7.13-3.7.14.2, 4.0.0-4.3.0|
| <a name="2549677"></a> [2549677](#2549677) <a name="2549677"></a> <br />CM-29471 | After you add or remove a bridge VLAN identifier (VID) on a trunk port, the layer 2 VNI is put into VLAN 1. <br />To work around this issue, revert the configuration change. | 3.7.10-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548586"></a> [2548586](#2548586) <a name="2548586"></a> <br />CM-28995 | After you flap an MLAG peerlink, a rare condition might occur where routes and neighbors for VXLAN-enabled VLANs are misprogrammed as non-VXLAN routes and neighbors due to VNI state transitions. This results in a forwarding failure for traffic destined to these misprogrammed routes and neighbors.<br />*Note*: Do not flap a VNI interface manually. The only expected time for a VNI interface to go down is when the MLAG secondary switch brings the VNIs protodown during a peer link failure where the backup IP address is still active.<br />To recover from this condition, restart <code>switchd</code> with the <code>sudo systemctl restart switchd</code> command. | 3.7.10-3.7.12, 4.1.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548475"></a> [2548475](#2548475) <a name="2548475"></a> <br />CM-28932 | After you add a new VNI and a layer 3 SVI to a set of leafs, certain leafs might not be able to communicate on the layer 3 VNI. <br />To work around this issue, reboot the leaf switch or restart <code>switchd</code>. | 3.7.6-3.7.13 | 3.7.14-3.7.14.2, 4.0.0-4.3.0|
| <a name="2548383"></a> [2548383](#2548383) <a name="2548383"></a> <br />CM-28867 | The QuantaMesh BMS T3048-LY8 switch shows a low fan RPM in syslog. | 3.7.5-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548111"></a> [2548111](#2548111) <a name="2548111"></a> <br />CM-28655 | When you remove, then re-add an NSX VTEP binding, the VXLAN VTEP interface is not recreated. | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547912"></a> [2547912](#2547912) <a name="2547912"></a> <br />CM-28511 | The following vulnerabilities were discovered in cURL, an URL transfer library.<br />CVE-2019-5436: A heap buffer overflow in the TFTP receiving code was discovered, which could allow DoS or arbitrary code execution.<br />CVE-2019-5482: Thomas Vegas discovered a heap buffer overflow that could be triggered when a small non-default TFTP blocksize is used.<br />Vulnerable: 7.38.0-4+deb8u15<br />Fixed: 7.38.0-4+deb8u16 | 3.7.10 | 3.7.11-3.7.14.2|
| <a name="2547769"></a> [2547769](#2547769) <a name="2547769"></a> <br />CM-28437 | <code>syslog</code> might report a high load average with the CPU running a later microcode revision. | 3.7.4-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547663"></a> [2547663](#2547663) <a name="2547663"></a> <br />CM-28374 | When traffic from a double tag interface (facing a different site) is forwarded through VXLAN, the inner tag is not removed. The destination does not know this tag, so it discards it. | 3.7.8-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547573"></a> [2547573](#2547573) <a name="2547573"></a> <br />CM-28322 | On Tomahawk switches, when the <code>vxlan_tnl_arp_punt_disable</code> option is set to FALSE, ARP packets are not forwarded to the CPU. | 3.7.9-4.0.1 | 4.1.0-4.3.0|
| <a name="2547509"></a> [2547509](#2547509) <a name="2547509"></a> <br />CM-28276 | When a Trident3 switch receives packets containing an IP checksum value that is not compliant with RFC 1624, the TTL is decremented after a routing operation but the checksum is not recalculated. This results in the IP checksum value being invalid as the packet leaves the switch.  | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547402"></a> [2547402](#2547402) <a name="2547402"></a> <br />CM-28224 | The following security vulnerability has been announced in qemu, which is not installed by default on Cumulus Linux but is available in the repository for optional installation:<br />CVE-2019-15890: libslirp 4.0.0, as used in QEMU 4.1.0, has a use-after-free in ip_reass in ip_input.c.<br />Vulnerable: <= 2.1+dfsg-12+deb8u11<br />Fixed: 2.1+dfsg-12+deb8u12 | 3.7.10 | 3.7.11-3.7.14.2|
| <a name="2547293"></a> [2547293](#2547293) <a name="2547293"></a> <br />CM-28160 | On the Broadcom Trident3 switch with DHCP relay, where the DHCP server is reachable through the EVPN overlay, DHCP discover packets forwarded to the CPU might appear corrupt and might not get forwarded. | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547246"></a> [2547246](#2547246) <a name="2547246"></a> <br />CM-28136 | The MLAG switch pair has VLANs defined that are not used on MLAG bonds. These VLANs still synchronize MAC addresses across to the peer switch. This results in log messages that indicate a MAC address is installed and the VLAN is not defined; for example:<br /><pre><br />RTM_NEWNEIGH with unconfigured vlan XXXX on port peerlink<br /></pre> | 3.7.10-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547122"></a> [2547122](#2547122) <a name="2547122"></a> <br />CM-28077 | An unhandled exception might occur after you run the <code>sudo poectl -i</code> command. In addition, random <code>poed</code> daemon restarts can occur without any unhandled exceptions but with an invalid response length error. Both issues can occur due to a SerialException.<br />To work around this issue, power cycle the switch. A software reboot does not resolve the issue. | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547118"></a> [2547118](#2547118) <a name="2547118"></a> <br />CM-28074 | The following security vulnerabilities have been announced in the libtiff5 library on Cumulus Linux 4.0:<br />CVE-2019-14973, CVE-2019-17546: Multiple integer overflows have been discovered in the libtiff library and the included tools.<br />Vulnerable: 4.0.10-4<br />Fixed: 4.1.0+git191117-2~deb10u1 | 3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2547013"></a> [2547013](#2547013) <a name="2547013"></a> <br />CM-28016 | On the Mellanox Spectrum switch, <code>switchd</code> can sometimes fail when PBR rules are installed or removed from hardware if the rule is setting a next hop learned via a routing protocol. | 3.7.7-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546999"></a> [2546999](#2546999) <a name="2546999"></a> <br />CM-28007 | When you configure Cumulus Linux with a /32 address on a switch port with a configured peer address (for example, to connect to a device using IP unnumbered), the switch sends GARPs for the peer address. | 3.7.5-3.7.11 | 3.7.12-3.7.14.2, 4.1.0-4.3.0|
| <a name="2546985"></a> [2546985](#2546985) <a name="2546985"></a> <br />CM-27999 | On the EdgeCore AS7326-56X switch, the PSU fans show constant LOW warnings. | 3.7.10-3.7.12, 4.0.0-4.2.0 | 3.7.13-3.7.14, 4.2.1-4.3.0|
| <a name="2546951"></a> [2546951](#2546951) <a name="2546951"></a> <br />CM-27982 | <code>switchd</code> crashes when dynamic VRF route leaking is enabled and the following is true:<br />* The default route is leaked from VRF1 to VRF2<br />* Hardware-based dynamic VRF route leaking is configured (<code>vrf_route_leak_enable_dynamic</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file). <br />You might see logs similar to the following in <code>/var/log/syslog</code>:<br /><pre><br />kernel: &#91;159400.526241&#93; switchd&#91;21374&#93;: segfault at 1229cdd84 ip 00000000004142ca sp 00007ffd557a86d0 error 4 in switchd&#91;400000+71000&#93;<br /></pre><br />To work around this issue, use a route map to filter the default route (the source VRF is imported into the destination VRF). | 3.7.10-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2546869"></a> [2546869](#2546869) <a name="2546869"></a> <br />CM-27947 | Broadcom Field Alert - SID - MMU 2B Errors<br />A few of the MMU memories on Broadcom switches are grouped together with single parity control. During SER correction when a parity error occurs on one of those groups, other memory in that group might also report a SER error. This occurs when the memory is accessed either by a packet hit or through a schan operation. This issue can cause SER errors in other memory and cause traffic mis-forwarding or a packet drop. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546703"></a> [2546703](#2546703) <a name="2546703"></a> <br />CM-27855 | The FRR cl-support module times out on switches on the ARM platform even when the switch is not under heavy load.<br />To work around this issue, run the <code>cl-support -M</code> command to disable timeouts. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546577"></a> [2546577](#2546577) <a name="2546577"></a> <br />CM-27814 | A traditional bridge with QinQ and a VNI does not work for tagged traffic. | 3.7.10-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2546564"></a> [2546564](#2546564) <a name="2546564"></a> <br />CM-27804 | You might see a <code>switchd</code> memory leak during ECMP group expansion or consolidation. | 3.7.10-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2546502"></a> [2546502](#2546502) <a name="2546502"></a> <br />CM-27764 | On the EdgeCore AS7326-56X switch, eth0 and swp1 use the same MAC address. | 3.7.9-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546385"></a> [2546385](#2546385) <a name="2546385"></a> <br />CM-27698 | SNMP ifLastChange reports link transitions when there are none. | 3.7.6-3.7.14.2 | |
| <a name="2546329"></a> [2546329](#2546329) <a name="2546329"></a> <br />CM-27670 | A memory leak in <code>switchd</code> might occur, which causes <code>switchd</code> to restart. | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546267"></a> [2546267](#2546267) <a name="2546267"></a> <br />CM-27646 | Several vulnerabilities have been discovered in Git, a fast, scalable,<br />distributed revision control system, which is available in the Cumulus Linux 3.x repositories for optional installation.<br />CVE-2019-1348: export-marks is insecure, fix is to disable by default.<br />CVE-2019-1349: .git / git~1 filename vulnerability on NTFS<br />CVE-2019-1352: .git vulnerability with NTFS Alternate Streams Accesses<br />CVE-2019-1353: NTFS filesystem protection should be on by default<br />CVE-2019-1387: dubiously-nested submodule git directories should be disallowed<br />CVE-2019-19604: submodule update repository code execution vulnerability<br />Vulnerable: <= 2.1.4-2.1+deb8u7<br />Fixed: 2.1.4-2.1+deb8u8 | 3.7.10-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2546265"></a> [2546265](#2546265) <a name="2546265"></a> <br />CM-27644 | Ifupdown2 does not set up the front panel interface for the <code>dhclient</code> to accept the DHCP OFFER.<br />To work around this issue, restart the networking service after <code>ifreload -a</code> with the <code>systemctl restart networking</code> command. | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546228"></a> [2546228](#2546228) <a name="2546228"></a> <br />CM-27628 | The following security vulnerabilities have been announced in the nss/libnss3 library, which is not installed by default but is available in the repository:<br />CVE-2019-11745: Out-of-bounds write when passing an output buffer smaller than the block size to NSC_EncryptUpdate<br />CVE-2019-17007: nss: Handling of Netscape Certificate Sequences in CERT_DecodeCertPackage() may crash with a NULL deref leading to DoS<br />See https://security-tracker.debian.org/tracker/source-package/nss for more information.<br />Vulnerable: <= 3.26-1+debu8u7<br />Fixed: 3.26-1+debu8u9 | 3.7.10 | 3.7.11-3.7.14.2|
| <a name="2546010"></a> [2546010](#2546010) <a name="2546010"></a> <br />CM-27530 | When <code>hal.bcm.per_vlan_router_mac_lookup</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file, inter-VLAN traffic is forwarded to the CPU when associated VNI interfaces exist. | 3.7.10-3.7.14.2 | |
| <a name="2545997"></a> [2545997](#2545997) <a name="2545997"></a> <br />CM-27522 | The NCLU command <code>net show interface</code> produces an error if bonds with no members exist.<br />To work around this issue, remove the empty Bond interfaces from the <code>/etc/network/interfaces</code> file and run <code>sudo ifreload -a</code>. | 3.7.10-3.7.14.2 | |
| <a name="2545972"></a> [2545972](#2545972) <a name="2545972"></a> <br />CM-27507 | The <code>ports.conf</code> file on the Dell S5248F-ON switch does not show port ganging or breakout options. | 3.7.10-3.7.11 | 3.7.12-3.7.14.2, 4.1.0-4.3.0|
| <a name="2545868"></a> [2545868](#2545868) <a name="2545868"></a> <br />CM-27457 | If you delete, then re-add a PBR policy on an interface, the configured PBR policy is not programmed in the kernel or <code>switchd</code>. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545866"></a> [2545866](#2545866) <a name="2545866"></a> <br />CM-27456 | After making a series of PBR configuration changes using NCLU commands, the stale PBR entry is still present in the kernel. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545837"></a> [2545837](#2545837) <a name="2545837"></a> <br />CM-27444 | If you use the NCLU commands to configure NTP and run the <code>net add time ntp source <interface></code> command before you run the <code>net add time ntp server <server> iburst</code> command, the <code>/etc/ntp.conf</code> file is misconfigured.<br />To work around this issue, run the <code>net add time ntp server <server> iburst</code> command before you run the <code>net add time ntp source <interface></code> command. | 3.7.10-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2545699"></a> [2545699](#2545699) <a name="2545699"></a> <br />CM-27354 | On the Celestica Pebble switch, if you use IPv6 routes with mask /65 to /127,  the <code>switchd</code> log fills with errors. | 3.7.10-3.7.13 | 3.7.14-3.7.14.2, 4.1.0-4.3.0|
| <a name="2545694"></a> [2545694](#2545694) <a name="2545694"></a> <br />CM-27351 | On rare occasions, after rebooting the MLAG secondary switch, one MLAG device might see the peer as down, which can cause traffic disruption to connected hosts. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.1.0-4.3.0|
| <a name="2545644"></a> [2545644](#2545644) <a name="2545644"></a> <br />CM-27321 | The following CVEs were announced that affect the ghostscript package:<br />CVE-2019-14869: Manfred Paul and Lukas Schauer reported that the .charkeys procedure in Ghostscript, the GPL PostScript/PDF interpreter, does not properly restrict privileged calls, which could result in bypass of file system restrictions of the dSAFER sandbox.<br />Cumulus Linux 3: <= 9.26a~dfsg-0+deb8u5 vulnerable, >= 9.26a~dfsg-0+deb8u6 fixed.<br />https://security-tracker.debian.org/tracker/ghostscript<br />https://security-tracker.debian.org/tracker/CVE-2019-14869 | 3.7.10 | 3.7.11-3.7.14.2|
| <a name="2545608"></a> [2545608](#2545608) <a name="2545608"></a> <br />CM-27299 | The protocol daemon <code>bgpd</code> crashes when a link/neighbor flaps if static routes pointing to Null0 are advertising through BGP.<br />To work around this issue, reboot the switch, then remove the static routes or stop advertising these routes. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545600"></a> [2545600](#2545600) <a name="2545600"></a> <br />CM-27295 | IPv6 table rules might affect forwarding. For example, if you create the following rule in the <code>/etc/cumulus/acl/policy.d/03-sshd.rules</code> file, the rule counter increments but IPv4 SSH traffic might be dropped.<br /><pre><br />&#91;ip6tables&#93;<br />-A INPUT -p tcp --dport 22 -j DROP<br /></pre> | 3.7.2-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2545520"></a> [2545520](#2545520) <a name="2545520"></a> <br />CM-27243 | The length of the netlink message is not set properly for non-bridge family type messages. The same length is used for both bridge and non-bridge even though the bridge family type message has an extra attribute. This causes extra bytes to be left over in non-bridge family type netlink messages. | 3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2545505"></a> [2545505](#2545505) <a name="2545505"></a> <br />CM-27233 | If you change multiple BGP or BFD timers in the <code>/etc/frr/frr.conf</code> file and then reload FRR, a traceback is encountered and the change does not take effect. | 3.7.9-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2545448"></a> [2545448](#2545448) <a name="2545448"></a> <br />CM-27193 | The <code>l1-show</code> command prints a traceback for switch ports that have sub-interfaces configured. There is no functional impact to traffic but the <code>l1-show</code> troubleshooting and validation command does not execute on switch ports that have VLAN sub-interfaces. | 3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545446"></a> [2545446](#2545446) <a name="2545446"></a> <br />CM-27192 | If you use NCLU commands to add a non-MLAG bond, then add an MLAG configuration, the <code>net commit</code> command fails. However, a subsequent <code>net commit</code> command succeeds. | 3.7.10-3.7.14.2 | |
| <a name="2545405"></a> [2545405](#2545405) <a name="2545405"></a> <br />CM-27174 | The <code>ospfd</code> daemon might crash with the following kernel trace: <br /><pre><br />2019-11-06T23:00:08.261749+09:00 cumulus ospfd&#91;5339&#93;: Assertion 'node' failed in file ospfd/ospf_packet.c, line 671, function ospf_write<br /></pre> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2545404"></a> [2545404](#2545404) <a name="2545404"></a> <br />CM-27173 | On the Trident3 switch, unicast ARP packets received on a VNI and forwarded to the CPU are not policed. | 3.7.10-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2545316"></a> [2545316](#2545316) <a name="2545316"></a> <br />CM-27120 | When an interface flap occurs, numbered IPv6 BGP sessions might fail to establish.<br />To work around this issue, run the <code>ip -6 route flush cache <IPv6-address></code> command to flush the IPv6 route cache. | 3.7.9-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2545236"></a> [2545236](#2545236) <a name="2545236"></a> <br />CM-27096 | On the Edgecore AS6812 switch, you might see rare I2C errors. | 3.7.2-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545133"></a> [2545133](#2545133) <a name="2545133"></a> <br />CM-27025 | On the Mellanox switch, ACL lookups are performed for VLAN matches when no rules with <code>UNTAGGED</code> match are present. | 3.7.2-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545125"></a> [2545125](#2545125) <a name="2545125"></a> <br />CM-27018 | If you configure more than one VRR interface on an SVI interface, deleting one of the VRR addresses does not remove the interface/address.  | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2545087"></a> [2545087](#2545087) <a name="2545087"></a> <br />CM-26996 | On the Mellanox switch with the Spectrum ASIC, the <code>--set-burst</code> parameter in an iptables rule does not take effect. | 3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545049"></a> [2545049](#2545049) <a name="2545049"></a> <br />CM-26968 | When networking fails to start properly, an MLAG memory leak occurs, which might cause memory issues. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545027"></a> [2545027](#2545027) <a name="2545027"></a> <br />CM-26954 | In the default VRF, VRRP might crash and stay in an initialize state. As a result, VRRP multicast traffic is not generated. | 3.7.8-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544978"></a> [2544978](#2544978) <a name="2544978"></a> <br />CM-26921 | If you delete an undefined bond, then add a bond slave, the <code>net commit</code> command fails. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544968"></a> [2544968](#2544968) <a name="2544968"></a> <br />CM-26913 | FRR configuration commands for an SVI interface might have the <code>\n</code> misplaced in the output.  For example:<br /><pre><br />sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />should be:<br /><pre><br />sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />To work around this issue, configure the interface manually in the <code>/etc/frr/frr.conf</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544953"></a> [2544953](#2544953) <a name="2544953"></a> <br />CM-26905 | When you update the hostname of a switch with the NCLU <code>net add hostname <hostname></code> command, then run <code>net commit</code>, the <code>lldpd</code> service does not restart and other devices still see the old hostname.<br />To work around this issue, run the <code>sudo systemctl restart lldpd.service</code> command. | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544937"></a> [2544937](#2544937) <a name="2544937"></a> <br />CM-26894 | The <code>neighmgrd</code> service does not ignore neighbors on reserved devices (lo and management devices).  This issue is not seen when management VRF is enabled. | 3.7.8-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2544904"></a> [2544904](#2544904) <a name="2544904"></a> <br />CM-26875 | After you delete an IPv6 numbered BGP peer group neighbor, Cumulus Linux might continue to send route advertisements.<br />To work around this issue, restart FRR after removing the IPv6 numbered configuration. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544867"></a> [2544867](#2544867) <a name="2544867"></a> <br />CM-26849 | Package: tcpdump<br />CVE ID: CVE-2018-10103 CVE-2018-10105 CVE-2018-14461 CVE-2018-14462<br />CVE-2018-14463 CVE-2018-14464 CVE-2018-14465 CVE-2018-14466<br />CVE-2018-14467 CVE-2018-14468 CVE-2018-14469 CVE-2018-14470<br />CVE-2018-14879 CVE-2018-14880 CVE-2018-14881 CVE-2018-14882<br />CVE-2018-16227 CVE-2018-16228 CVE-2018-16229 CVE-2018-16230<br />CVE-2018-16300 CVE-2018-16451 CVE-2018-16452 CVE-2019-15166<br />Several vulnerabilities have been discovered in tcpdump, a command-line<br />network traffic analyzer. These vulnerabilities might result in denial of<br />service or, potentially, execution of arbitrary code.<br />For the detailed security status of tcpdump, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/tcpdump<br />Fixed versions: 4.9.3-1~deb10u1 on Cumulus Linux 4, 4.9.3-1~deb8u1 on Cumulus Linux 3. | 3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544847"></a> [2544847](#2544847) <a name="2544847"></a> <br />CM-26838 | You might experience a <code>bgpd</code> memory usage increase and significant update exchanges due to host moves between VTEPs. | 3.7.7-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544829"></a> [2544829](#2544829) <a name="2544829"></a> <br />CM-26829 | Frames received with a VLAN tag of 0 on an interface configured as a bridge port and forwarded to the CPU for processing might appear tagged with the native VLAN when viewed with <code>tcpdump</code>.  | 3.7.8-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544815"></a> [2544815](#2544815) <a name="2544815"></a> <br />CM-26815 | If a router MAC address changes on a VTEP, other VTEPs might still point to the previous router MAC address. | 3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544723"></a> [2544723](#2544723) <a name="2544723"></a> <br />CM-26769 | Setting ProtoDown on ports populated with SFP modules providing RJ-45 1000BASE-T interfaces does not cause the carrier to be dropped. The kernel shows carrier down; however, the remote device still shows a link. | 3.7.6-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2544625"></a> [2544625](#2544625) <a name="2544625"></a> <br />CM-26703 | VXLAN encapsulated ICMP packets hit the catchall EFP policer instead of the ICMP policer and you might experience partial packet loss.<br /> | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544609"></a> [2544609](#2544609) <a name="2544609"></a> <br />CM-26691 | BGP is configured with soft reconfiguration-in for its peers, which is not working correctly and causes routes to have an unexpected label. As a result, transit traffic is not forwarded by the switch. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544559"></a> [2544559](#2544559) <a name="2544559"></a> <br />CM-26657 | When you install a large number of new rules with nonatomic mode enabled, there is a chance that you install more rules than the number of available slots in the slice, which results in the slice being completely wiped and reinstalled. This causes a large drop increase, including to cpu0, and might cause a major outage by dropping all BGP sessions. | 3.7.8-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544556"></a> [2544556](#2544556) <a name="2544556"></a> <br />CM-26655 | If you reconfigure an NTP server with NCLU using different trailing options after the IP address (such as <code>iburst</code>), an invalid configuration is added to the <code>/etc/ntp.conf</code> file. For example:<br /><pre><br />net add time ntp server 1.2.3.4 iburst<br />net commit<br />net add time ntp server 1.2.3.4<br />net commit<br /></pre><br />If you need to alter existing server configurations, first remove the server, commit, then re-add the server with any trailing options. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544463"></a> [2544463](#2544463) <a name="2544463"></a> <br />CM-26599 | Auto-negotiation does not work with the QSFP28 cables and a remote system operating at 10G. Attempting to enable auto-negotiation with <code>ethtool -s swp<#> autoneg on</code> returns <code>Operation not supported</code>.<br />To work around this issue, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544456"></a> [2544456](#2544456) <a name="2544456"></a> <br />CM-26595 | The NCLU <code>net show lldp</code> command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544401"></a> [2544401](#2544401) <a name="2544401"></a> <br />CM-26566 | Package: openssl<br />CVE ID:  CVE-2019-1547 CVE-2019-1549 CVE-2019-1563<br />Three security issues were discovered in OpenSSL: A timing attack against<br />ECDSA, a padding oracle in PKCS7_dataDecode() and CMS_decrypt_set1_pkey()<br />and it was discovered that a feature of the random number generator (RNG)<br />intended to protect against shared RNG state between parent and child<br />processes in the event of a fork() syscall was not used by default.<br />Fixed version: 1.1.1d-0+deb10u1<br />We recommend that you upgrade your openssl packages.<br />For the detailed security status of openssl,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/openssl | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544385"></a> [2544385](#2544385) <a name="2544385"></a> <br />CM-26556 | The QCT QuantaMesh BMS T7032-IX7 switch may report "failed to request GPIO pin"   errors during the boot up.  | 3.7.5-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544324"></a> [2544324](#2544324) <a name="2544324"></a> <br />CM-26523 | Package: hostapd<br />CVE ID: CVE-2019-13377 CVE-2019-16275<br />Two vulnerabilities were found in the WPA protocol implementation found in wpa_supplication (station) and hostapd (access point).<br />CVE-2019-13377<br />A timing-based side-channel attack against WPA3's Dragonfly handshake when using Brainpool curves could be used by an attacker to retrieve the password.<br />CVE-2019-16275<br />Insufficient source address validation for some received Management frames in hostapd could lead to a denial of service for stations associated to an access point. An attacker in radio range of the access point could inject a specially constructed unauthenticated IEEE 802.11 frame to the access point to cause associated stations to be disconnected and require a reconnection to the network.<br />Fixed version: 1:2.8.0-cl4u3 | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544235"></a> [2544235](#2544235) <a name="2544235"></a> <br />CM-26463 | The following CVEs affect the linux kernel package:<br />CVE-2019-14821 CVE-2019-14835 CVE-2019-15117 CVE-2019-15118 CVE-2019-15902<br />Several vulnerabilities have been discovered in the Linux kernel that<br />may lead to a privilege escalation, denial of service or information<br />leaks.<br />For the detailed security status of linux,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/linux | 3.7.10-3.7.14.2 | |
| <a name="2544213"></a> [2544213](#2544213) <a name="2544213"></a> <br />CM-26450 | Cumulus Linux poed generates excessive debug log entries.  These will be reduced in a future release. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544200"></a> [2544200](#2544200) <a name="2544200"></a> <br />CM-26448 | Traffic sent to the SVI IP address of a switch might be lost if all of the following conditions are met:<br />* The switch is a member of an MLAG pair<br />* The traffic is sourced from a layer 2 adjacent host<br />* The host is located within a VRF of the MLAG pair<br />* The traffic from the source crosses the peer link<br />* VXLAN is configured on the MLAG pair<br /><br />This issue does not impact transit traffic or traffic that does not meet all of the described conditions.<br />To workaround this issue, restart <code>switchd</code>. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544182"></a> [2544182](#2544182) <a name="2544182"></a> <br />CM-26437 | NCLU crashes when you run the <code>net add interface storage-optimized pfc</code> command because non-ascii quotes exist in the <code>datapath.conf</code> file.<br />To work around this issue, manually edit the <code>/usr/lib/python2.7/dist-packages/cumulus/__chip_config/mlx/datapath.conf</code> file and replace the non-ascii single quotes  with ascii single quotes (standard single quote on the keyboard). | 3.7.9-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544113"></a> [2544113](#2544113) <a name="2544113"></a> <br />CM-26412 | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address changing between the MLAG bond and the peer link.<br />To work around this issue, disable MAC learning on QinQ VLANs by adding <code>bridge-learning off</code> to the VLAN stanza in the <code>etc/network/interfaces</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544057"></a> [2544057](#2544057) <a name="2544057"></a> <br />CM-26372 | FRR crashes when adding an IPv6 neighbor with extended-nexthop capability. | 3.7.9-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544012"></a> [2544012](#2544012) <a name="2544012"></a> <br />CM-26351 | After you remove a subinterface, the BGP session stays in a Connect state. | 3.7.8-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2543937"></a> [2543937](#2543937) <a name="2543937"></a> <br />CM-26308 | An interface alias configured outside FRR using <code>iproute2</code> is imported into the FRR running configuration and overrides the internal description. After an FRR reload, this causes FRR to delete the interface alias in an inefficient way. Depending on how many interfaces with aliases you have configured, this can cause a FRR reload to time out.<br />To work around this issue, remove the interface alias description from <code>iproute2</code>. | 3.7.8-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543900"></a> [2543900](#2543900) <a name="2543900"></a> <br />CM-26288 | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543875"></a> [2543875](#2543875) <a name="2543875"></a> <br />CM-26272 | On the Mellanox Spectrum switch, a route withdrawal might cause the associated next hop neighbor entry to be deleted in hardware but remain in the kernel. This can cause traffic going through the directly connected route to the removed neighbor entry to be forwarded to the CPU. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543841"></a> [2543841](#2543841) <a name="2543841"></a> <br />CM-26256 | The <code>net show evpn vni detail json</code> command includes an extra empty dictionary at the end of the output. <br /> | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543840"></a> [2543840](#2543840) <a name="2543840"></a> <br />CM-26255 | On the Mellanox SN2700 switch, you cannot enable resilient hashing (RASH) and set the bucket size to 64 in the <code>traffic.conf</code> file.<br /><br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2543835"></a> [2543835](#2543835) <a name="2543835"></a> <br />CM-26252 | The following CVEs were announced that affect the ghostscript package:<br />CVE ID : CVE-2019-14811 CVE-2019-14812 CVE-2019-14813 CVE-2019-14817<br />It was discovered that various procedures in Ghostscript, the GPL PostScript/PDF interpreter, do not properly restrict privileged calls, which could result in bypass of file system restrictions of the dSAFER sandbox.<br />We recommend that you upgrade your ghostscript packages.<br />For the detailed security status of ghostscript, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/ghostscript | 3.7.0-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2543816"></a> [2543816](#2543816) <a name="2543816"></a> <br />CM-26241 | On the Dell S5248F-ON switch, <code>smond</code> might generate syslog messages indicating that the fan input RPM is lower than the normal low speed of 2500 RPM. Speeds as low as 1700 RPM are acceptable in normal thermal environments; therefore, you can ignore these messages.<br /> | 3.7.6-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2543800"></a> [2543800](#2543800) <a name="2543800"></a> <br />CM-26230 | When <code>local-tunnelip</code> is an SVI, the static VXLAN tunnel does not work; the next hop router receives the packet but drops it as it does not know where to forward the packet. The static VXLAN tunnel does works if <code>local-tunnelip</code> is a loopback or a physical layer 3 interface. <br /> | 3.7.8-3.7.14 | 4.0.0-4.3.0|
| <a name="2543792"></a> [2543792](#2543792) <a name="2543792"></a> <br />CM-26225 | On the EdgeCore AS5712, AS6712, AS5812 and AS6812 switch, support for multiple PSU types results in log messages similar to the following:<br /><pre><br />2019-09-05T05:15:17.246597+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.274521+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br />2019-09-05T05:15:17.469556+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.497514+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br /></pre> | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543781"></a> [2543781](#2543781) <a name="2543781"></a> <br />CM-26217 | NCLU does not allow you to configure OSPF NSSAs. For example: <br /><pre><br />cumulus&#64;switch:~$ net add ospf area 0.0.0.1 nssa <br />ERROR: Command not found. <br />net add ospf area 0.0.0.1 nssa<br /></pre><br />To work around this issue, use FRR instead. For example: <br /><pre><br />switch# configure terminal <br />switch(config)# router ospf <br />switch(config-router)# area 0.0.0.1 nssa <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543727"></a> [2543727](#2543727) <a name="2543727"></a> <br />CM-26181 | ACL rules, such as the following, fail to install if you use swp+ (interfaces mentioned as wildcards).<br /><pre><br />-A FORWARD -i swp+ -j LOG<br />-A FORWARD -i swp+ -j DROP<br /></pre><br />You can now install such rules with swp+. | 3.7.3-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543724"></a> [2543724](#2543724) <a name="2543724"></a> <br />CM-26179 | If a hostname contains utf-8 characters, the NCLU <code>net show lldp</code> command outputs the following error: <br /><pre><br />ERROR: 'ascii' codec can't encode character u'\xe9' in position 3: ordinal not in range(128) <br />See /var/log/netd.log for more details.  <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543708"></a> [2543708](#2543708) <a name="2543708"></a> <br />CM-26169 | Cumulus Linux does not map QinQ packets to VXLANs in a configuration with a VLAN-aware bridge and MLAG on the Trident3 platform. <br /> | 3.7.9-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543690"></a> [2543690](#2543690) <a name="2543690"></a> <br />CM-26158 | On the Mellanox switch, UFT profiles are unable to support the documented capacity for routes to addresses that are more than 64 bits in length. The listed capacities assume 64-bit destination IP addresses. | 3.7.8-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2543668"></a> [2543668](#2543668) <a name="2543668"></a> <br />CM-26147 | On the EdgeCore AS4610 switch, the <code>ping</code> command fails unless you run the command with <code>sudo</code>. <br /> To work around this issue, run the following commands: <br /><pre><br /> cumulus&#64;switch:~$ sudo setcap cap_net_raw+ep /usr/share/mgmt-vrf/bin/ping <br /> cumulus&#64;switch:~$ sudo setcap cap_net_raw+ep /usr/share/mgmt-vrf/bin/ping6<br /></pre><br /> Run the following command to verify the workaround: <br /> <pre> <br /> cumulus&#64;switch:~$ getcap /usr/share/mgmt-vrf/bin/ping* <br /> </pre> <br /> You should see the following output: <br /> <pre> <br /> /usr/share/mgmt-vrf/bin/ping = cap_net_raw+ep <br /> /usr/share/mgmt-vrf/bin/ping6 = cap_net_raw+ep <br /> </pre> <br />  | 3.7.6-3.7.10, 4.1.0-4.1.1 | 3.7.11-3.7.14, 4.2.0-4.3.0|
| <a name="2543665"></a> [2543665](#2543665) <a name="2543665"></a> <br />CM-26146 | <code>clagd</code> memory consumption increases under certain unknown conditions. <br /> | 3.7.8-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543649"></a> [2543649](#2543649) <a name="2543649"></a> <br />CM-26138 | You cannot specify a source and destination MAC address in an ERSPAN ebtables rule. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i swp5 -s 00:25:90:b2:bd:9d -d 50:6b:4b:96:c4:04 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | 4.3.0|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543627"></a> [2543627](#2543627) <a name="2543627"></a> <br />CM-26126 | Tomahawk 40G DACs cannot disable auto-negotiation. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543560"></a> [2543560](#2543560) <a name="2543560"></a> <br />CM-26082 | The following vulnerabilities are only applicable if qemu is installed from the repo mirror. It is not present in the base image by default, so base images without qemu installed are not vulnerable.<br />CVE-2018-20815 CVE-2019-13164 CVE-2019-14378: Multiple security issues were discovered in QEMU, a fast processor emulator, which could result in denial of service, the execution of arbitrary code or bypass of ACLs.<br />Cumulus Linux 3: >= 2.1+dfsg-12+deb8u12 fixed.<br />https://security-tracker.debian.org/tracker/qemu<br />https://security-tracker.debian.org/tracker/CVE-2018-20815<br />https://security-tracker.debian.org/tracker/CVE-2019-13164<br />https://security-tracker.debian.org/tracker/CVE-2019-14378 | 3.7.10 | 3.7.11-3.7.14.2|
| <a name="2543472"></a> [2543472](#2543472) <a name="2543472"></a> <br />CM-26024 | On switches with the Spectrum ASIC, the underlay hashes VXLAN packets for a given overlay flow randomly.<br />To work around this issue, configure the ECMP hash seed to the same value on the EVPN egress leaf switches. | 3.7.7-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543374"></a> [2543374](#2543374) <a name="2543374"></a> <br />CM-25973 | After a remote VTEP peer link goes down, the tunnel destination IP address might be incorrect in hardware, which might cause loss of overlay communication between VTEPs. | 3.7.8-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543325"></a> [2543325](#2543325) <a name="2543325"></a> <br />CM-25955 | Lenovo switches do not send or receive LLDP on eth0 interfaces. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543270"></a> [2543270](#2543270) <a name="2543270"></a> <br />CM-25923 | The default route injected through OSPF when you configure <code>default-information originate always</code> is unreliable and might age out unexpectedly.<br />To work around this issue, rely on a different source of default route other than injection with <code>default-information originate</code>. | 3.7.8-4.1.1 | 4.2.0-4.3.0|
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543113"></a> [2543113](#2543113) <a name="2543113"></a> <br />CM-25824 | NCLU restarts FRR when attempting to remove a BGP VRF stanza. This happens regardless of whether the VRF is valid/configured elsewhere on the switch or the removal is successful. To work around this issue, remove the stanza using vtysh. <br /> | 3.7.3-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543058"></a> [2543058](#2543058) <a name="2543058"></a> <br />CM-25798 | The IP neighbor entry for a link-local next hop is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces.<br />To work around this issue, flap the peering to the peer router (which might be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543052"></a> [2543052](#2543052) <a name="2543052"></a> <br />CM-25796 | Received EVPN type-5 and type-2 MACIP routes are not installed in the kernel (and hardware) routing tables for the associated VRF, which causes traffic to be blackholed. The failure to install the default route causes complete reachability failure for the particular tenant on the affected racks. The routes that are not installed are seen as "inactive" in the routing subsystem (FRR) VRF routing table. This problem is rare and can occur only in EVPN configurations that have user-configured route targets (RTs) for tenant VRFs, and only following a restart of FRR.<br />To work around this issue, either restart the FRR service on the affected switch with the <code>sudo systemctl restart frr.service</code> command or bounce the layer 3 SVI for the affected VRF; for example:<br /><pre><br />ifdown vlan123 ; sleep 2 ; ifup vlan123<br /></pre><br />You can run the <code>net show vrf vni</code> command to print a mapping of VRF : L3-VNI : L3-SVI. | 3.7.5-3.7.14 | 4.0.0-4.3.0|
| <a name="2543044"></a> [2543044](#2543044) <a name="2543044"></a> <br />CM-25794 | Under certain conditions, EVPN next hops might not be removed when the contributing peer goes down or might not be populated when the BGP session to the contributing peer comes up.<br />You can prevent EVPN next hops from not being removed when the contributing peer goes down by specifying static MAC addresses on all layer 3 VNIs. There is no workaround for preventing EVPN next hops from not being populated when the BGP session to the contributing peer comes up. | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2542979"></a> [2542979](#2542979) <a name="2542979"></a> <br />CM-25766 | On the Dell-N3048EP-ON switch, when you run the <code>sudo -E apt upgrade</code> command, the upgrade does not work.  | 3.7.7-4.1.1 | 4.2.0-4.3.0|
| <a name="2542958"></a> [2542958](#2542958) <a name="2542958"></a> <br />CM-25747 | When transitioning from a down state to an up state due to peerlink failure and recovery, MLAG does not start the initDelay timer before trying to bring everything back up. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542913"></a> [2542913](#2542913) <a name="2542913"></a> <br />CM-25718 | IF-MIB::ifHCInOctets reports significantly lower values than reported by interface counters seen elsewhere. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542872"></a> [2542872](#2542872) <a name="2542872"></a> <br />CM-25693 | After you issue the NCLU <code>net del bgp vrf <vrf> autonomous-system <AS></code> command and commit the change, Cumulus Linux does not remove the configuration from the <code>/etc/frr/frr.conf</code> file or the <code>net show config commands</code>. <br /> | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2542835"></a> [2542835](#2542835) <a name="2542835"></a> <br />CM-25672 | <code>snmpd</code> fails because NCLU does not remove <code>agentaddress &#64;vrf</code> lines when running the <code>net add snmp-server listening-address all</code> command. | 3.7.4-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542824"></a> [2542824](#2542824) <a name="2542824"></a> <br />CM-25665 | On the Broadcom Trident 3 switch, VXLAN encapsulated packets are dropped on the ingress port (tagged layer 2 port) during transit forwarding (the local switch does not terminate the VXLAN tunnel). An example of where this two-layer VXLAN inside VXLAN encapsulation might occur:<br />- VXLAN tunnel (#1) between two servers (different racks) to provide layer 2 extension for containers or VM hosts.<br />- VXLAN tunnel (#2) between the TOR switch in rack 1 to the TOR switch located in the remote rack. <br /><br />To work around this issue, either:<br />- Configure the edge port (facing the servers) to be an access port (instead of a trunk/tagged port)<br />- Change the destination port from 4789 to something else (VXLAN tunnel terminated by the servers) | 3.7.5-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2542767"></a> [2542767](#2542767) <a name="2542767"></a> <br />CM-25641 | If the BMC operating system fails to respond to IPMI, you see a traceback in <code>bmcd</code> and all the sensors might report ABSENT devices in <code>smonctl</code>. <br />To work around this issue, power cycle the switch. <br />  | 3.7.6-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2542765"></a> [2542765](#2542765) <a name="2542765"></a> <br />CM-25640 | When you configure the switch to send an EAP request with the <code>net add dot1x send-eap-request-id</code> command, the switch ignores re-authentication attempts and does not send back an EAPol. <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2542510"></a> [2542510](#2542510) <a name="2542510"></a> <br />CM-25505 | In EVPN symmetric or centralized configurations with BGP peering over a peer link, VXLAN routed packets transiting an MLAG peer are dropped until the <code>clagd</code> <code>init-delay</code> timer expires during the bring-up sequence following a reboot.<br />The problem is caused by a race condition when programming the anycast IP address (used to terminate VXLAN tunnels), where the hardware is programmed before the software by <code>clagd</code>.<br />To work around this issue, configure the BGP path across the peer link to be less preferred. The example below uses AS path prepending and the MLAG switches are iBGP neighbors. However, other BGP configurations achieve the same result. <br />In the <code>/etc/frr/frr.conf</code> file, make a new AS path access list and route map to apply BGP pre-pending of the local ASN one or more times. For example: <br /><pre> <br />ip as-path access-list MY_ASN permit ^$ <br /><br />route-map peerlink-add-asn permit 10 <br />match as-path MY_ASN <br />set as-path prepend 4200000101 <br />route-map peerlink-add-asn permit 20 <br /></pre>  | 3.7.6-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2542384"></a> [2542384](#2542384) <a name="2542384"></a> <br />CM-25447 | When you define a trap destination using &#64;mgmt, <code>snmpd</code> indicates that the network is unreachable even though the IP address is reachable in the management VRF. <br />To work around this issue, remove <code>&#64;mgmt vrf</code> references in the <code>/etc/snmp/snmpd.conf</code> file, stop <code>snmpd</code>, then start <code>snmpd</code> manually in the management VRF with the <code>systemctl start snmpd&#64;mgmt</code> command. <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542310"></a> [2542310](#2542310) <a name="2542310"></a> <br />CM-25404 | <code>hsflow</code> disregards the setting for <code>agent.cidr</code> in the <code>/etc/hsflowd.conf</code> file and selects an IPv6 agent address. The source IP address of the hsflowd packet is IPv4, but the agent address in the <code>hsflow</code> payload shows IPv6. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542248"></a> [2542248](#2542248) <a name="2542248"></a> <br />CM-25376 | When you generate a cl-support file, <code>clagd.service</code> prints log messages similar to the following: <br /><pre> <br />019-03-21T07:18:15.727581+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - start <br />2019-03-21T07:18:15.728157+00:00 leaf01 clagd&#91;20912&#93;: #012thread: CollectSysInfo (140608446367488) <br />2019-03-21T07:18:15.735986+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 783, in __bootstrap <br />2019-03-21T07:18:15.736585+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 810, in __bootstrap_inner <br />2019-03-21T07:18:15.737045+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 763, in run <br />2019-03-21T07:18:15.737933+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 930, in CollectSysInfoT <br />2019-03-21T07:18:15.739527+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 187, in CollectSysInfo <br />2019-03-21T07:18:15.740540+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 621, in wait <br />2019-03-21T07:18:15.742293+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/dist-packages/clag/clagthread.py, line 48, in wait <br />. <br />. <br />2019-03-21T07:18:16.456061+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - end <br /></pre> <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541165"></a> [2541165](#2541165) <a name="2541165"></a> <br />CM-24878 | On the Dell N3048EP-ON switch, UPOE is supported only on ports 1 thru 12. (UPOE uses all four pairs of standard Ethernet cabling whereas PoE delivers power over two twisted pairs.) When you plug a UPOE device in a port higher than port 12, <code>poectl</code> reports that <code>four_pair_mode_enabled</code> is true. However, this configuration is not supported on the port so <code>poectl</code> should report that <code>four_pair_mode_enabled</code> is false. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540950"></a> [2540950](#2540950) <a name="2540950"></a> <br />CM-24751 | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switch, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status.<br />  | 3.7.3-4.1.1 | 4.2.0-4.3.0|
| <a name="2540885"></a> [2540885](#2540885) <a name="2540885"></a> <br />CM-24703 | The Dell N3048EP-ON switch does not support 1G Base-T modules in the SFP ports. | 3.7.7-3.7.14.2 | |
| <a name="2540863"></a> [2540863](#2540863) <a name="2540863"></a> <br />CM-24686 | On the EdgeCore AS5812-54X switch, the PSU2 Fan1 fluctuates between OK and LOW. When the fan speed is reported as LOW, the RPM is shown as a negative number. <br /> | 3.7.3-3.7.14 | 4.0.0-4.3.0|
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539081"></a> [2539081](#2539081) <a name="2539081"></a> <br />CM-23792 | When you delete post-up and pre-down IP peer entries from the <code>etc/network/interfaces</code> file, then run the <code>ifreload</code> command, the IP addresses are not removed and the route remains in the route table. <br />To work around this issue, either delete the IP addresses without the /32 mask component or flush the IP addresses for the interface with the <code>ip addr flush dev <interface></code> command. <br /> | 3.7.0-3.7.14 | 4.0.0-4.3.0|
| <a name="2538875"></a> [2538875](#2538875) <a name="2538875"></a> <br />CM-23696 | IPv6 multicast traffic destined to an unregistered multicast group is flooded to all ports in a bridge despite the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/swichd.conf</code> file. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538302"></a> [2538302](#2538302) <a name="2538302"></a> <br />CM-23422 | <code>portwd</code> allows an error to change the module type based on the error. For example, a bad write to a module might cause the module type to flap, which causes the link itself to flap. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538256"></a> [2538256](#2538256) <a name="2538256"></a> <br />CM-23397 | On the Broadcom switch, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets. <br />  | 3.7.2-4.0.1 | 4.1.0-4.3.0|
| <a name="2537820"></a> [2537820](#2537820) <a name="2537820"></a> <br />CM-23123 | When you enable FEC (RS or BaseR) on an interface, removing the configuration from that interface does not revert the FEC status to off/none. <br /> | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537544"></a> [2537544](#2537544) <a name="2537544"></a> <br />CM-23021 | When you run the <code>mstpctl</code> command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of <code>mstpctl</code>; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | 4.3.0|
| <a name="2537536"></a> [2537536](#2537536) <a name="2537536"></a> <br />CM-23016 | When FRR restarts, <code>snmp&#91;err&#93; dev/kmem: Permission denied</code> error messages are recorded in the log file and SNMPd might crash periodically. | 3.7.5-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2537514"></a> [2537514](#2537514) <a name="2537514"></a> <br />CM-23004 | The local fallback account authenticates using the local password when the RADIUS or TACACS service is up. The expected behavior is for this to fail and only succeed when the RADIUS OR TACACS server fails to respond. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537378"></a> [2537378](#2537378) <a name="2537378"></a> <br />CM-22937 | NCLU SNMPv3 user configuration (add, delete, modify) does not complete. Changes are made to the <code>/etc/snmp/snmpd.conf</code> file but the SNMPv3 user cache file <code>/var/lib/snmp/snmpd.conf</code> fails to update correctly and the configuration does not reflect in operation. <br />To work around this issue, stop <code>snmpd</code>, remove the cache file, then restart <code>snmpd</code>. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537188"></a> [2537188](#2537188) <a name="2537188"></a> <br />CM-22849 | When an event in the network, such as a <code>switchd</code> or networking service restart, leads to an OVSDB server high availability transition, an <code>ovs-vtepd</code> core might occur. <br />This core generation has no effect on the functionality of high availability when the active OVSDB server is back in the network. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2537104"></a> [2537104](#2537104) <a name="2537104"></a> <br />CM-22808 | When you try to stop <code>hsflowd</code> on the Trident II+ switch with the <code>systemctl stop hsflowd</code> command, the process hangs until you stop it with <code>SIGKILL</code>. <br /> | 3.7.1-3.7.14 | 4.0.0-4.3.0|
| <a name="2537061"></a> [2537061](#2537061) <a name="2537061"></a> <br />CM-22794 | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent. <br /> | 3.7.1-4.0.1 | 4.1.0-4.3.0|
| <a name="2536639"></a> [2536639](#2536639) <a name="2536639"></a> <br />CM-22605 | On a Dell S4048 switch, when you set the eth0 speed to 100, either with NCLU or by editing the <code>/etc/network/interfaces</code> file, the <code>igb</code> driver crashes, which brings down eth0. <br />To work around this issue: <br />* If eth0 is configured in the management VRF, power cycle the switch; the eth0 configuration fails and reverts back to the default (auto-negotiation/1000). <br />* If eth0 is configured in the default VRF and you power cycle after the crash, <code>igb</code> continues to crash on boot up (before getting to login prompt); power-cycle the switch, select the Advanced option in GRUB to boot to recovery mode, then modify the <code>/etc/network/interfaces</code> file. | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2536617"></a> [2536617](#2536617) <a name="2536617"></a> <br />CM-22591 | CVE-2018-5391 (FragmentSmack) is a network vulnerability where an attacker can trigger time and calculation expensive fragment reassembly with specially crafted packets, leading to a denial of service. On a Cumulus Linux switch, the impact is limited to control plane and management plane traffic. Any control plane traffic coming in the front panel ports will be limited by existing policer ACLs.<br />To work around this issue, create a file called <code>/etc/sysctl.d/ip.conf</code> and add these settings:<br /><pre><br />net.ipv4.ipfrag_low_thresh = 196608<br />net.ipv6.ip6frag_low_thresh = 196608<br />net.ipv4.ipfrag_high_thresh = 262144<br />net.ipv6.ip6frag_high_thresh = 262144<br /></pre> | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2536608"></a> [2536608](#2536608) <a name="2536608"></a> <br />CM-22583 | Single tagged ARP requests received on a QinQ-over-VXLAN access port are dropped if ARP suppression is enabled on an unrelated VNI. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2536559"></a> [2536559](#2536559) <a name="2536559"></a> <br />CM-22538 | When deleting an interface using NCLU, if the <code>/etc/network/interfaces</code> alias is different than the <code>/etc/frr/frr.conf</code> description, the <code>net commit</code> command returns the following error: <br /><pre><br /> /etc/frr/daemons was modified by another user.<br /></pre><br />Despite this error, the change is made and the description is removed from the <code>frr.conf</code> file.  | 3.7.3-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536231"></a> [2536231](#2536231) <a name="2536231"></a> <br />CM-22277 | On the Broadcom switch with the Trident3 ASIC, the ECN-CE bit is set by default on transit traffic. This might result in hosts adjusting traffic behavior if they are configured for the ECN feature. <br />In Cumulus Linux 3.7.11, the default behavior changed; the ECN-CE bit is _no longer_ set by default on transit traffic. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on protocol sockets.<br />When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a <code>switchd</code> restart. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535965"></a> [2535965](#2535965) <a name="2535965"></a> <br />CM-22020 | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br />To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535209"></a> [2535209](#2535209) <a name="2535209"></a> <br />CM-21278 | The <code>net show lldp</code> command sometimes shows the port description in the <code>Remote Port</code> field. The <code>net show interface</code> command shows the correct value in the <code>Remote Host</code> field.<br />To work around this issue, use <code>net show interface</code> command for LLDP output when connected to Cisco equipment. | 3.7.5-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2534450"></a> [2534450](#2534450) <a name="2534450"></a> <br />CM-20534 | The default BGP instance must be provisioned and always exist for proper operation of dynamic leaking of routes between VRFs.  | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2534394"></a> [2534394](#2534394) <a name="2534394"></a> <br />CM-20480 | The python-crypto package, which is not installed by default on Cumulus Linux, but is present in the repository to be installed, has the following security vulnerability in the version available for Cumulus Linux 3.x:<br />CVE-2018-6594: lib/Crypto/PublicKey/ElGamal.py in PyCrypto through 2.6.1 generates weak ElGamal key parameters, which allows attackers to obtain sensitive information by reading ciphertext data (i.e., it does not have semantic security in face of a ciphertext-only attack). The Decisional Diffie-Hellman (DDH) assumption does not hold for PyCrypto's ElGamal implementation.<br />More information at https://security-tracker.debian.org/tracker/CVE-2018-6594 . | 3.7.9-3.7.14.2 | |
| <a name="2528990"></a> [2528990](#2528990) <a name="2528990"></a> <br />CM-15278 | During a link flap test, you might occasionally see a message similar to: <code>warning: swp6: netlink: cannot set link swp6 down: &#91;Errno 98&#93; Address already in use</code>. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|

### Fixed Issues in 3.7.10
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="2544073"></a> [2544073](#2544073) <a name="2544073"></a> <br />CM-26383 | After upgrading to Cumulus Linux 3.7.9 on a Broadcom switch, CPU generated traffic (such as ICMP, OSPF, ARP, and so on) egresses access ports with a 802.1Q header or interfaces with a bridge-pvid, with a VLAN ID of 0. Equipment from other vendors might drop this traffic. | 3.7.9 | |

## 3.7.9 Release Notes
### Open issues in 3.7.9

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2556037"></a> [2556037](#2556037) <a name="2556037"></a> <br />CM-33012 | After you add an interface to the bridge, an OSPF session flap can occur.<br /><br /> | 3.7.9-4.2.0 | 4.2.1-4.3.0|
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552739"></a> [2552739](#2552739) <a name="2552739"></a> <br />CM-31148 | Counters for IPROUTER rules do not increase when traffic is forwarded to the CPU because there is no IP neighbor. | 3.7.2-3.7.14.2 | |
| <a name="2552528"></a> [2552528](#2552528) <a name="2552528"></a> <br />CM-31028 | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2552352"></a> [2552352](#2552352) <a name="2552352"></a> <br />CM-30914 | The following security vulnerabilities have been announced in the nss / libnss3 packages:<br />CVE-2020-6829: Side channel attack on ECDSA signature generation<br />CVE-2020-12400: P-384 and P-521 implementation uses a side-channel vulnerable modular inversion function<br />CVE-2020-12401: ECDSA timing attack mitigation bypass<br />Vulnerable: <= 3.26-1+debu8u11<br />Fixed: 3.26-1+debu8u12 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552351"></a> [2552351](#2552351) <a name="2552351"></a> <br />CM-30913 | The following vulnerability has been announced in the libx11 packages:<br />CVE-2020-14344: The X Input Method (XIM) client implementation in libX11 has some integer overflows and signed/unsigned comparison issues that can lead to heap corruption when handling malformed messages from an input method.<br />Vulnerable: <= 1.6.2-3+deb8u2<br />Fixed: 1.6.2-3+deb8u3 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2551675"></a> [2551675](#2551675) <a name="2551675"></a> <br />CM-30479 | When you restart <code>clagd</code>, the edge port setting on the peer link changes. | 3.7.2-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551288"></a> [2551288](#2551288) <a name="2551288"></a> <br />CM-30286 | When you remove BFD configuration by editing the <code>/etc/frr/frr.conf</code> file and restarting FRR, you see a traceback.<br />To work around this issue, either use NCLU or vtysh commands to remove the BFD configuration, or restart FRR with the new <code>/etc/frr/frr.conf</code> file. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2550601"></a> [2550601](#2550601) <a name="2550601"></a> <br />CM-29978 | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | 4.2.1-4.3.0, 4.3.0|
| <a name="2550375"></a> [2550375](#2550375) <a name="2550375"></a> <br />CM-29838 | CPU utilization may increase when clag-managed bond interfaces are operationally/LACP down but the physical carrier remains up on the bond member switchports. This condition occurs when clag bond redirection is enabled and bond members remain up while the parent bond does not negotiate LACP.<br /><br />This issue is resolved in Cumulus Linux 3.7.14. | 3.7.9-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2550323"></a> [2550323](#2550323) <a name="2550323"></a> <br />CM-29807 | After a neighbor is removed, the redistributed neighbor entry is withdrawn from the BGP table, but the prefix might still be selected as the bestpath when the host's originated prefix is not advertised.<br />To work around this issue, recreate the neighbor entry and flap the interface to the host. <br />Or, if the host is already down, manually create a neighbor entry with an invalid MAC address, which forces redistribute neighbor to re-withdraw the entry. | 3.7.3-3.7.12 | 3.7.13-3.7.14.2, 4.0.0-4.3.0|
| <a name="2548475"></a> [2548475](#2548475) <a name="2548475"></a> <br />CM-28932 | After you add a new VNI and a layer 3 SVI to a set of leafs, certain leafs might not be able to communicate on the layer 3 VNI. <br />To work around this issue, reboot the leaf switch or restart <code>switchd</code>. | 3.7.6-3.7.13 | 3.7.14-3.7.14.2, 4.0.0-4.3.0|
| <a name="2548383"></a> [2548383](#2548383) <a name="2548383"></a> <br />CM-28867 | The QuantaMesh BMS T3048-LY8 switch shows a low fan RPM in syslog. | 3.7.5-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548111"></a> [2548111](#2548111) <a name="2548111"></a> <br />CM-28655 | When you remove, then re-add an NSX VTEP binding, the VXLAN VTEP interface is not recreated. | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547769"></a> [2547769](#2547769) <a name="2547769"></a> <br />CM-28437 | <code>syslog</code> might report a high load average with the CPU running a later microcode revision. | 3.7.4-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547663"></a> [2547663](#2547663) <a name="2547663"></a> <br />CM-28374 | When traffic from a double tag interface (facing a different site) is forwarded through VXLAN, the inner tag is not removed. The destination does not know this tag, so it discards it. | 3.7.8-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547573"></a> [2547573](#2547573) <a name="2547573"></a> <br />CM-28322 | On Tomahawk switches, when the <code>vxlan_tnl_arp_punt_disable</code> option is set to FALSE, ARP packets are not forwarded to the CPU. | 3.7.9-4.0.1 | 4.1.0-4.3.0|
| <a name="2547293"></a> [2547293](#2547293) <a name="2547293"></a> <br />CM-28160 | On the Broadcom Trident3 switch with DHCP relay, where the DHCP server is reachable through the EVPN overlay, DHCP discover packets forwarded to the CPU might appear corrupt and might not get forwarded. | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547013"></a> [2547013](#2547013) <a name="2547013"></a> <br />CM-28016 | On the Mellanox Spectrum switch, <code>switchd</code> can sometimes fail when PBR rules are installed or removed from hardware if the rule is setting a next hop learned via a routing protocol. | 3.7.7-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546999"></a> [2546999](#2546999) <a name="2546999"></a> <br />CM-28007 | When you configure Cumulus Linux with a /32 address on a switch port with a configured peer address (for example, to connect to a device using IP unnumbered), the switch sends GARPs for the peer address. | 3.7.5-3.7.11 | 3.7.12-3.7.14.2, 4.1.0-4.3.0|
| <a name="2546869"></a> [2546869](#2546869) <a name="2546869"></a> <br />CM-27947 | Broadcom Field Alert - SID - MMU 2B Errors<br />A few of the MMU memories on Broadcom switches are grouped together with single parity control. During SER correction when a parity error occurs on one of those groups, other memory in that group might also report a SER error. This occurs when the memory is accessed either by a packet hit or through a schan operation. This issue can cause SER errors in other memory and cause traffic mis-forwarding or a packet drop. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546703"></a> [2546703](#2546703) <a name="2546703"></a> <br />CM-27855 | The FRR cl-support module times out on switches on the ARM platform even when the switch is not under heavy load.<br />To work around this issue, run the <code>cl-support -M</code> command to disable timeouts. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546502"></a> [2546502](#2546502) <a name="2546502"></a> <br />CM-27764 | On the EdgeCore AS7326-56X switch, eth0 and swp1 use the same MAC address. | 3.7.9-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546385"></a> [2546385](#2546385) <a name="2546385"></a> <br />CM-27698 | SNMP ifLastChange reports link transitions when there are none. | 3.7.6-3.7.14.2 | |
| <a name="2545868"></a> [2545868](#2545868) <a name="2545868"></a> <br />CM-27457 | If you delete, then re-add a PBR policy on an interface, the configured PBR policy is not programmed in the kernel or <code>switchd</code>. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545866"></a> [2545866](#2545866) <a name="2545866"></a> <br />CM-27456 | After making a series of PBR configuration changes using NCLU commands, the stale PBR entry is still present in the kernel. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545694"></a> [2545694](#2545694) <a name="2545694"></a> <br />CM-27351 | On rare occasions, after rebooting the MLAG secondary switch, one MLAG device might see the peer as down, which can cause traffic disruption to connected hosts. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.1.0-4.3.0|
| <a name="2545608"></a> [2545608](#2545608) <a name="2545608"></a> <br />CM-27299 | The protocol daemon <code>bgpd</code> crashes when a link/neighbor flaps if static routes pointing to Null0 are advertising through BGP.<br />To work around this issue, reboot the switch, then remove the static routes or stop advertising these routes. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545600"></a> [2545600](#2545600) <a name="2545600"></a> <br />CM-27295 | IPv6 table rules might affect forwarding. For example, if you create the following rule in the <code>/etc/cumulus/acl/policy.d/03-sshd.rules</code> file, the rule counter increments but IPv4 SSH traffic might be dropped.<br /><pre><br />&#91;ip6tables&#93;<br />-A INPUT -p tcp --dport 22 -j DROP<br /></pre> | 3.7.2-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2545505"></a> [2545505](#2545505) <a name="2545505"></a> <br />CM-27233 | If you change multiple BGP or BFD timers in the <code>/etc/frr/frr.conf</code> file and then reload FRR, a traceback is encountered and the change does not take effect. | 3.7.9-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2545405"></a> [2545405](#2545405) <a name="2545405"></a> <br />CM-27174 | The <code>ospfd</code> daemon might crash with the following kernel trace: <br /><pre><br />2019-11-06T23:00:08.261749+09:00 cumulus ospfd&#91;5339&#93;: Assertion 'node' failed in file ospfd/ospf_packet.c, line 671, function ospf_write<br /></pre> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2545316"></a> [2545316](#2545316) <a name="2545316"></a> <br />CM-27120 | When an interface flap occurs, numbered IPv6 BGP sessions might fail to establish.<br />To work around this issue, run the <code>ip -6 route flush cache <IPv6-address></code> command to flush the IPv6 route cache. | 3.7.9-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2545236"></a> [2545236](#2545236) <a name="2545236"></a> <br />CM-27096 | On the Edgecore AS6812 switch, you might see rare I2C errors. | 3.7.2-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545133"></a> [2545133](#2545133) <a name="2545133"></a> <br />CM-27025 | On the Mellanox switch, ACL lookups are performed for VLAN matches when no rules with <code>UNTAGGED</code> match are present. | 3.7.2-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545049"></a> [2545049](#2545049) <a name="2545049"></a> <br />CM-26968 | When networking fails to start properly, an MLAG memory leak occurs, which might cause memory issues. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545027"></a> [2545027](#2545027) <a name="2545027"></a> <br />CM-26954 | In the default VRF, VRRP might crash and stay in an initialize state. As a result, VRRP multicast traffic is not generated. | 3.7.8-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544978"></a> [2544978](#2544978) <a name="2544978"></a> <br />CM-26921 | If you delete an undefined bond, then add a bond slave, the <code>net commit</code> command fails. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544968"></a> [2544968](#2544968) <a name="2544968"></a> <br />CM-26913 | FRR configuration commands for an SVI interface might have the <code>\n</code> misplaced in the output.  For example:<br /><pre><br />sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />should be:<br /><pre><br />sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />To work around this issue, configure the interface manually in the <code>/etc/frr/frr.conf</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544937"></a> [2544937](#2544937) <a name="2544937"></a> <br />CM-26894 | The <code>neighmgrd</code> service does not ignore neighbors on reserved devices (lo and management devices).  This issue is not seen when management VRF is enabled. | 3.7.8-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2544904"></a> [2544904](#2544904) <a name="2544904"></a> <br />CM-26875 | After you delete an IPv6 numbered BGP peer group neighbor, Cumulus Linux might continue to send route advertisements.<br />To work around this issue, restart FRR after removing the IPv6 numbered configuration. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544847"></a> [2544847](#2544847) <a name="2544847"></a> <br />CM-26838 | You might experience a <code>bgpd</code> memory usage increase and significant update exchanges due to host moves between VTEPs. | 3.7.7-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544829"></a> [2544829](#2544829) <a name="2544829"></a> <br />CM-26829 | Frames received with a VLAN tag of 0 on an interface configured as a bridge port and forwarded to the CPU for processing might appear tagged with the native VLAN when viewed with <code>tcpdump</code>.  | 3.7.8-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544723"></a> [2544723](#2544723) <a name="2544723"></a> <br />CM-26769 | Setting ProtoDown on ports populated with SFP modules providing RJ-45 1000BASE-T interfaces does not cause the carrier to be dropped. The kernel shows carrier down; however, the remote device still shows a link. | 3.7.6-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2544625"></a> [2544625](#2544625) <a name="2544625"></a> <br />CM-26703 | VXLAN encapsulated ICMP packets hit the catchall EFP policer instead of the ICMP policer and you might experience partial packet loss.<br /> | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544609"></a> [2544609](#2544609) <a name="2544609"></a> <br />CM-26691 | BGP is configured with soft reconfiguration-in for its peers, which is not working correctly and causes routes to have an unexpected label. As a result, transit traffic is not forwarded by the switch. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544559"></a> [2544559](#2544559) <a name="2544559"></a> <br />CM-26657 | When you install a large number of new rules with nonatomic mode enabled, there is a chance that you install more rules than the number of available slots in the slice, which results in the slice being completely wiped and reinstalled. This causes a large drop increase, including to cpu0, and might cause a major outage by dropping all BGP sessions. | 3.7.8-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544556"></a> [2544556](#2544556) <a name="2544556"></a> <br />CM-26655 | If you reconfigure an NTP server with NCLU using different trailing options after the IP address (such as <code>iburst</code>), an invalid configuration is added to the <code>/etc/ntp.conf</code> file. For example:<br /><pre><br />net add time ntp server 1.2.3.4 iburst<br />net commit<br />net add time ntp server 1.2.3.4<br />net commit<br /></pre><br />If you need to alter existing server configurations, first remove the server, commit, then re-add the server with any trailing options. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544463"></a> [2544463](#2544463) <a name="2544463"></a> <br />CM-26599 | Auto-negotiation does not work with the QSFP28 cables and a remote system operating at 10G. Attempting to enable auto-negotiation with <code>ethtool -s swp<#> autoneg on</code> returns <code>Operation not supported</code>.<br />To work around this issue, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544456"></a> [2544456](#2544456) <a name="2544456"></a> <br />CM-26595 | The NCLU <code>net show lldp</code> command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544401"></a> [2544401](#2544401) <a name="2544401"></a> <br />CM-26566 | Package: openssl<br />CVE ID:  CVE-2019-1547 CVE-2019-1549 CVE-2019-1563<br />Three security issues were discovered in OpenSSL: A timing attack against<br />ECDSA, a padding oracle in PKCS7_dataDecode() and CMS_decrypt_set1_pkey()<br />and it was discovered that a feature of the random number generator (RNG)<br />intended to protect against shared RNG state between parent and child<br />processes in the event of a fork() syscall was not used by default.<br />Fixed version: 1.1.1d-0+deb10u1<br />We recommend that you upgrade your openssl packages.<br />For the detailed security status of openssl,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/openssl | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544385"></a> [2544385](#2544385) <a name="2544385"></a> <br />CM-26556 | The QCT QuantaMesh BMS T7032-IX7 switch may report "failed to request GPIO pin"   errors during the boot up.  | 3.7.5-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544324"></a> [2544324](#2544324) <a name="2544324"></a> <br />CM-26523 | Package: hostapd<br />CVE ID: CVE-2019-13377 CVE-2019-16275<br />Two vulnerabilities were found in the WPA protocol implementation found in wpa_supplication (station) and hostapd (access point).<br />CVE-2019-13377<br />A timing-based side-channel attack against WPA3's Dragonfly handshake when using Brainpool curves could be used by an attacker to retrieve the password.<br />CVE-2019-16275<br />Insufficient source address validation for some received Management frames in hostapd could lead to a denial of service for stations associated to an access point. An attacker in radio range of the access point could inject a specially constructed unauthenticated IEEE 802.11 frame to the access point to cause associated stations to be disconnected and require a reconnection to the network.<br />Fixed version: 1:2.8.0-cl4u3 | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544213"></a> [2544213](#2544213) <a name="2544213"></a> <br />CM-26450 | Cumulus Linux poed generates excessive debug log entries.  These will be reduced in a future release. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544200"></a> [2544200](#2544200) <a name="2544200"></a> <br />CM-26448 | Traffic sent to the SVI IP address of a switch might be lost if all of the following conditions are met:<br />* The switch is a member of an MLAG pair<br />* The traffic is sourced from a layer 2 adjacent host<br />* The host is located within a VRF of the MLAG pair<br />* The traffic from the source crosses the peer link<br />* VXLAN is configured on the MLAG pair<br /><br />This issue does not impact transit traffic or traffic that does not meet all of the described conditions.<br />To workaround this issue, restart <code>switchd</code>. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544182"></a> [2544182](#2544182) <a name="2544182"></a> <br />CM-26437 | NCLU crashes when you run the <code>net add interface storage-optimized pfc</code> command because non-ascii quotes exist in the <code>datapath.conf</code> file.<br />To work around this issue, manually edit the <code>/usr/lib/python2.7/dist-packages/cumulus/__chip_config/mlx/datapath.conf</code> file and replace the non-ascii single quotes  with ascii single quotes (standard single quote on the keyboard). | 3.7.9-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544113"></a> [2544113](#2544113) <a name="2544113"></a> <br />CM-26412 | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address changing between the MLAG bond and the peer link.<br />To work around this issue, disable MAC learning on QinQ VLANs by adding <code>bridge-learning off</code> to the VLAN stanza in the <code>etc/network/interfaces</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544073"></a> [2544073](#2544073) <a name="2544073"></a> <br />CM-26383 | After upgrading to Cumulus Linux 3.7.9 on a Broadcom switch, CPU generated traffic (such as ICMP, OSPF, ARP, and so on) egresses access ports with a 802.1Q header or interfaces with a bridge-pvid, with a VLAN ID of 0. Equipment from other vendors might drop this traffic. | 3.7.9 | 3.7.10-3.7.14.2|
| <a name="2544057"></a> [2544057](#2544057) <a name="2544057"></a> <br />CM-26372 | FRR crashes when adding an IPv6 neighbor with extended-nexthop capability. | 3.7.9-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544012"></a> [2544012](#2544012) <a name="2544012"></a> <br />CM-26351 | After you remove a subinterface, the BGP session stays in a Connect state. | 3.7.8-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2543937"></a> [2543937](#2543937) <a name="2543937"></a> <br />CM-26308 | An interface alias configured outside FRR using <code>iproute2</code> is imported into the FRR running configuration and overrides the internal description. After an FRR reload, this causes FRR to delete the interface alias in an inefficient way. Depending on how many interfaces with aliases you have configured, this can cause a FRR reload to time out.<br />To work around this issue, remove the interface alias description from <code>iproute2</code>. | 3.7.8-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543900"></a> [2543900](#2543900) <a name="2543900"></a> <br />CM-26288 | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543875"></a> [2543875](#2543875) <a name="2543875"></a> <br />CM-26272 | On the Mellanox Spectrum switch, a route withdrawal might cause the associated next hop neighbor entry to be deleted in hardware but remain in the kernel. This can cause traffic going through the directly connected route to the removed neighbor entry to be forwarded to the CPU. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543841"></a> [2543841](#2543841) <a name="2543841"></a> <br />CM-26256 | The <code>net show evpn vni detail json</code> command includes an extra empty dictionary at the end of the output. <br /> | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543840"></a> [2543840](#2543840) <a name="2543840"></a> <br />CM-26255 | On the Mellanox SN2700 switch, you cannot enable resilient hashing (RASH) and set the bucket size to 64 in the <code>traffic.conf</code> file.<br /><br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2543835"></a> [2543835](#2543835) <a name="2543835"></a> <br />CM-26252 | The following CVEs were announced that affect the ghostscript package:<br />CVE ID : CVE-2019-14811 CVE-2019-14812 CVE-2019-14813 CVE-2019-14817<br />It was discovered that various procedures in Ghostscript, the GPL PostScript/PDF interpreter, do not properly restrict privileged calls, which could result in bypass of file system restrictions of the dSAFER sandbox.<br />We recommend that you upgrade your ghostscript packages.<br />For the detailed security status of ghostscript, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/ghostscript | 3.7.0-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2543816"></a> [2543816](#2543816) <a name="2543816"></a> <br />CM-26241 | On the Dell S5248F-ON switch, <code>smond</code> might generate syslog messages indicating that the fan input RPM is lower than the normal low speed of 2500 RPM. Speeds as low as 1700 RPM are acceptable in normal thermal environments; therefore, you can ignore these messages.<br /> | 3.7.6-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2543800"></a> [2543800](#2543800) <a name="2543800"></a> <br />CM-26230 | When <code>local-tunnelip</code> is an SVI, the static VXLAN tunnel does not work; the next hop router receives the packet but drops it as it does not know where to forward the packet. The static VXLAN tunnel does works if <code>local-tunnelip</code> is a loopback or a physical layer 3 interface. <br /> | 3.7.8-3.7.14 | 4.0.0-4.3.0|
| <a name="2543792"></a> [2543792](#2543792) <a name="2543792"></a> <br />CM-26225 | On the EdgeCore AS5712, AS6712, AS5812 and AS6812 switch, support for multiple PSU types results in log messages similar to the following:<br /><pre><br />2019-09-05T05:15:17.246597+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.274521+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br />2019-09-05T05:15:17.469556+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.497514+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br /></pre> | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543781"></a> [2543781](#2543781) <a name="2543781"></a> <br />CM-26217 | NCLU does not allow you to configure OSPF NSSAs. For example: <br /><pre><br />cumulus&#64;switch:~$ net add ospf area 0.0.0.1 nssa <br />ERROR: Command not found. <br />net add ospf area 0.0.0.1 nssa<br /></pre><br />To work around this issue, use FRR instead. For example: <br /><pre><br />switch# configure terminal <br />switch(config)# router ospf <br />switch(config-router)# area 0.0.0.1 nssa <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543727"></a> [2543727](#2543727) <a name="2543727"></a> <br />CM-26181 | ACL rules, such as the following, fail to install if you use swp+ (interfaces mentioned as wildcards).<br /><pre><br />-A FORWARD -i swp+ -j LOG<br />-A FORWARD -i swp+ -j DROP<br /></pre><br />You can now install such rules with swp+. | 3.7.3-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543724"></a> [2543724](#2543724) <a name="2543724"></a> <br />CM-26179 | If a hostname contains utf-8 characters, the NCLU <code>net show lldp</code> command outputs the following error: <br /><pre><br />ERROR: 'ascii' codec can't encode character u'\xe9' in position 3: ordinal not in range(128) <br />See /var/log/netd.log for more details.  <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543708"></a> [2543708](#2543708) <a name="2543708"></a> <br />CM-26169 | Cumulus Linux does not map QinQ packets to VXLANs in a configuration with a VLAN-aware bridge and MLAG on the Trident3 platform. <br /> | 3.7.9-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543690"></a> [2543690](#2543690) <a name="2543690"></a> <br />CM-26158 | On the Mellanox switch, UFT profiles are unable to support the documented capacity for routes to addresses that are more than 64 bits in length. The listed capacities assume 64-bit destination IP addresses. | 3.7.8-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2543668"></a> [2543668](#2543668) <a name="2543668"></a> <br />CM-26147 | On the EdgeCore AS4610 switch, the <code>ping</code> command fails unless you run the command with <code>sudo</code>. <br /> To work around this issue, run the following commands: <br /><pre><br /> cumulus&#64;switch:~$ sudo setcap cap_net_raw+ep /usr/share/mgmt-vrf/bin/ping <br /> cumulus&#64;switch:~$ sudo setcap cap_net_raw+ep /usr/share/mgmt-vrf/bin/ping6<br /></pre><br /> Run the following command to verify the workaround: <br /> <pre> <br /> cumulus&#64;switch:~$ getcap /usr/share/mgmt-vrf/bin/ping* <br /> </pre> <br /> You should see the following output: <br /> <pre> <br /> /usr/share/mgmt-vrf/bin/ping = cap_net_raw+ep <br /> /usr/share/mgmt-vrf/bin/ping6 = cap_net_raw+ep <br /> </pre> <br />  | 3.7.6-3.7.10, 4.1.0-4.1.1 | 3.7.11-3.7.14, 4.2.0-4.3.0|
| <a name="2543665"></a> [2543665](#2543665) <a name="2543665"></a> <br />CM-26146 | <code>clagd</code> memory consumption increases under certain unknown conditions. <br /> | 3.7.8-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543649"></a> [2543649](#2543649) <a name="2543649"></a> <br />CM-26138 | You cannot specify a source and destination MAC address in an ERSPAN ebtables rule. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i swp5 -s 00:25:90:b2:bd:9d -d 50:6b:4b:96:c4:04 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | 4.3.0|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543627"></a> [2543627](#2543627) <a name="2543627"></a> <br />CM-26126 | Tomahawk 40G DACs cannot disable auto-negotiation. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543472"></a> [2543472](#2543472) <a name="2543472"></a> <br />CM-26024 | On switches with the Spectrum ASIC, the underlay hashes VXLAN packets for a given overlay flow randomly.<br />To work around this issue, configure the ECMP hash seed to the same value on the EVPN egress leaf switches. | 3.7.7-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543374"></a> [2543374](#2543374) <a name="2543374"></a> <br />CM-25973 | After a remote VTEP peer link goes down, the tunnel destination IP address might be incorrect in hardware, which might cause loss of overlay communication between VTEPs. | 3.7.8-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543325"></a> [2543325](#2543325) <a name="2543325"></a> <br />CM-25955 | Lenovo switches do not send or receive LLDP on eth0 interfaces. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543270"></a> [2543270](#2543270) <a name="2543270"></a> <br />CM-25923 | The default route injected through OSPF when you configure <code>default-information originate always</code> is unreliable and might age out unexpectedly.<br />To work around this issue, rely on a different source of default route other than injection with <code>default-information originate</code>. | 3.7.8-4.1.1 | 4.2.0-4.3.0|
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543113"></a> [2543113](#2543113) <a name="2543113"></a> <br />CM-25824 | NCLU restarts FRR when attempting to remove a BGP VRF stanza. This happens regardless of whether the VRF is valid/configured elsewhere on the switch or the removal is successful. To work around this issue, remove the stanza using vtysh. <br /> | 3.7.3-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543058"></a> [2543058](#2543058) <a name="2543058"></a> <br />CM-25798 | The IP neighbor entry for a link-local next hop is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces.<br />To work around this issue, flap the peering to the peer router (which might be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543052"></a> [2543052](#2543052) <a name="2543052"></a> <br />CM-25796 | Received EVPN type-5 and type-2 MACIP routes are not installed in the kernel (and hardware) routing tables for the associated VRF, which causes traffic to be blackholed. The failure to install the default route causes complete reachability failure for the particular tenant on the affected racks. The routes that are not installed are seen as "inactive" in the routing subsystem (FRR) VRF routing table. This problem is rare and can occur only in EVPN configurations that have user-configured route targets (RTs) for tenant VRFs, and only following a restart of FRR.<br />To work around this issue, either restart the FRR service on the affected switch with the <code>sudo systemctl restart frr.service</code> command or bounce the layer 3 SVI for the affected VRF; for example:<br /><pre><br />ifdown vlan123 ; sleep 2 ; ifup vlan123<br /></pre><br />You can run the <code>net show vrf vni</code> command to print a mapping of VRF : L3-VNI : L3-SVI. | 3.7.5-3.7.14 | 4.0.0-4.3.0|
| <a name="2543044"></a> [2543044](#2543044) <a name="2543044"></a> <br />CM-25794 | Under certain conditions, EVPN next hops might not be removed when the contributing peer goes down or might not be populated when the BGP session to the contributing peer comes up.<br />You can prevent EVPN next hops from not being removed when the contributing peer goes down by specifying static MAC addresses on all layer 3 VNIs. There is no workaround for preventing EVPN next hops from not being populated when the BGP session to the contributing peer comes up. | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2542979"></a> [2542979](#2542979) <a name="2542979"></a> <br />CM-25766 | On the Dell-N3048EP-ON switch, when you run the <code>sudo -E apt upgrade</code> command, the upgrade does not work.  | 3.7.7-4.1.1 | 4.2.0-4.3.0|
| <a name="2542958"></a> [2542958](#2542958) <a name="2542958"></a> <br />CM-25747 | When transitioning from a down state to an up state due to peerlink failure and recovery, MLAG does not start the initDelay timer before trying to bring everything back up. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542913"></a> [2542913](#2542913) <a name="2542913"></a> <br />CM-25718 | IF-MIB::ifHCInOctets reports significantly lower values than reported by interface counters seen elsewhere. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542872"></a> [2542872](#2542872) <a name="2542872"></a> <br />CM-25693 | After you issue the NCLU <code>net del bgp vrf <vrf> autonomous-system <AS></code> command and commit the change, Cumulus Linux does not remove the configuration from the <code>/etc/frr/frr.conf</code> file or the <code>net show config commands</code>. <br /> | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2542835"></a> [2542835](#2542835) <a name="2542835"></a> <br />CM-25672 | <code>snmpd</code> fails because NCLU does not remove <code>agentaddress &#64;vrf</code> lines when running the <code>net add snmp-server listening-address all</code> command. | 3.7.4-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542824"></a> [2542824](#2542824) <a name="2542824"></a> <br />CM-25665 | On the Broadcom Trident 3 switch, VXLAN encapsulated packets are dropped on the ingress port (tagged layer 2 port) during transit forwarding (the local switch does not terminate the VXLAN tunnel). An example of where this two-layer VXLAN inside VXLAN encapsulation might occur:<br />- VXLAN tunnel (#1) between two servers (different racks) to provide layer 2 extension for containers or VM hosts.<br />- VXLAN tunnel (#2) between the TOR switch in rack 1 to the TOR switch located in the remote rack. <br /><br />To work around this issue, either:<br />- Configure the edge port (facing the servers) to be an access port (instead of a trunk/tagged port)<br />- Change the destination port from 4789 to something else (VXLAN tunnel terminated by the servers) | 3.7.5-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2542767"></a> [2542767](#2542767) <a name="2542767"></a> <br />CM-25641 | If the BMC operating system fails to respond to IPMI, you see a traceback in <code>bmcd</code> and all the sensors might report ABSENT devices in <code>smonctl</code>. <br />To work around this issue, power cycle the switch. <br />  | 3.7.6-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2542765"></a> [2542765](#2542765) <a name="2542765"></a> <br />CM-25640 | When you configure the switch to send an EAP request with the <code>net add dot1x send-eap-request-id</code> command, the switch ignores re-authentication attempts and does not send back an EAPol. <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2542510"></a> [2542510](#2542510) <a name="2542510"></a> <br />CM-25505 | In EVPN symmetric or centralized configurations with BGP peering over a peer link, VXLAN routed packets transiting an MLAG peer are dropped until the <code>clagd</code> <code>init-delay</code> timer expires during the bring-up sequence following a reboot.<br />The problem is caused by a race condition when programming the anycast IP address (used to terminate VXLAN tunnels), where the hardware is programmed before the software by <code>clagd</code>.<br />To work around this issue, configure the BGP path across the peer link to be less preferred. The example below uses AS path prepending and the MLAG switches are iBGP neighbors. However, other BGP configurations achieve the same result. <br />In the <code>/etc/frr/frr.conf</code> file, make a new AS path access list and route map to apply BGP pre-pending of the local ASN one or more times. For example: <br /><pre> <br />ip as-path access-list MY_ASN permit ^$ <br /><br />route-map peerlink-add-asn permit 10 <br />match as-path MY_ASN <br />set as-path prepend 4200000101 <br />route-map peerlink-add-asn permit 20 <br /></pre>  | 3.7.6-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2542384"></a> [2542384](#2542384) <a name="2542384"></a> <br />CM-25447 | When you define a trap destination using &#64;mgmt, <code>snmpd</code> indicates that the network is unreachable even though the IP address is reachable in the management VRF. <br />To work around this issue, remove <code>&#64;mgmt vrf</code> references in the <code>/etc/snmp/snmpd.conf</code> file, stop <code>snmpd</code>, then start <code>snmpd</code> manually in the management VRF with the <code>systemctl start snmpd&#64;mgmt</code> command. <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542310"></a> [2542310](#2542310) <a name="2542310"></a> <br />CM-25404 | <code>hsflow</code> disregards the setting for <code>agent.cidr</code> in the <code>/etc/hsflowd.conf</code> file and selects an IPv6 agent address. The source IP address of the hsflowd packet is IPv4, but the agent address in the <code>hsflow</code> payload shows IPv6. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542248"></a> [2542248](#2542248) <a name="2542248"></a> <br />CM-25376 | When you generate a cl-support file, <code>clagd.service</code> prints log messages similar to the following: <br /><pre> <br />019-03-21T07:18:15.727581+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - start <br />2019-03-21T07:18:15.728157+00:00 leaf01 clagd&#91;20912&#93;: #012thread: CollectSysInfo (140608446367488) <br />2019-03-21T07:18:15.735986+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 783, in __bootstrap <br />2019-03-21T07:18:15.736585+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 810, in __bootstrap_inner <br />2019-03-21T07:18:15.737045+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 763, in run <br />2019-03-21T07:18:15.737933+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 930, in CollectSysInfoT <br />2019-03-21T07:18:15.739527+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 187, in CollectSysInfo <br />2019-03-21T07:18:15.740540+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 621, in wait <br />2019-03-21T07:18:15.742293+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/dist-packages/clag/clagthread.py, line 48, in wait <br />. <br />. <br />2019-03-21T07:18:16.456061+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - end <br /></pre> <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541165"></a> [2541165](#2541165) <a name="2541165"></a> <br />CM-24878 | On the Dell N3048EP-ON switch, UPOE is supported only on ports 1 thru 12. (UPOE uses all four pairs of standard Ethernet cabling whereas PoE delivers power over two twisted pairs.) When you plug a UPOE device in a port higher than port 12, <code>poectl</code> reports that <code>four_pair_mode_enabled</code> is true. However, this configuration is not supported on the port so <code>poectl</code> should report that <code>four_pair_mode_enabled</code> is false. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540950"></a> [2540950](#2540950) <a name="2540950"></a> <br />CM-24751 | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switch, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status.<br />  | 3.7.3-4.1.1 | 4.2.0-4.3.0|
| <a name="2540885"></a> [2540885](#2540885) <a name="2540885"></a> <br />CM-24703 | The Dell N3048EP-ON switch does not support 1G Base-T modules in the SFP ports. | 3.7.7-3.7.14.2 | |
| <a name="2540863"></a> [2540863](#2540863) <a name="2540863"></a> <br />CM-24686 | On the EdgeCore AS5812-54X switch, the PSU2 Fan1 fluctuates between OK and LOW. When the fan speed is reported as LOW, the RPM is shown as a negative number. <br /> | 3.7.3-3.7.14 | 4.0.0-4.3.0|
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539081"></a> [2539081](#2539081) <a name="2539081"></a> <br />CM-23792 | When you delete post-up and pre-down IP peer entries from the <code>etc/network/interfaces</code> file, then run the <code>ifreload</code> command, the IP addresses are not removed and the route remains in the route table. <br />To work around this issue, either delete the IP addresses without the /32 mask component or flush the IP addresses for the interface with the <code>ip addr flush dev <interface></code> command. <br /> | 3.7.0-3.7.14 | 4.0.0-4.3.0|
| <a name="2538875"></a> [2538875](#2538875) <a name="2538875"></a> <br />CM-23696 | IPv6 multicast traffic destined to an unregistered multicast group is flooded to all ports in a bridge despite the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/swichd.conf</code> file. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538302"></a> [2538302](#2538302) <a name="2538302"></a> <br />CM-23422 | <code>portwd</code> allows an error to change the module type based on the error. For example, a bad write to a module might cause the module type to flap, which causes the link itself to flap. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538256"></a> [2538256](#2538256) <a name="2538256"></a> <br />CM-23397 | On the Broadcom switch, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets. <br />  | 3.7.2-4.0.1 | 4.1.0-4.3.0|
| <a name="2537820"></a> [2537820](#2537820) <a name="2537820"></a> <br />CM-23123 | When you enable FEC (RS or BaseR) on an interface, removing the configuration from that interface does not revert the FEC status to off/none. <br /> | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537544"></a> [2537544](#2537544) <a name="2537544"></a> <br />CM-23021 | When you run the <code>mstpctl</code> command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of <code>mstpctl</code>; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | 4.3.0|
| <a name="2537536"></a> [2537536](#2537536) <a name="2537536"></a> <br />CM-23016 | When FRR restarts, <code>snmp&#91;err&#93; dev/kmem: Permission denied</code> error messages are recorded in the log file and SNMPd might crash periodically. | 3.7.5-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2537514"></a> [2537514](#2537514) <a name="2537514"></a> <br />CM-23004 | The local fallback account authenticates using the local password when the RADIUS or TACACS service is up. The expected behavior is for this to fail and only succeed when the RADIUS OR TACACS server fails to respond. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537378"></a> [2537378](#2537378) <a name="2537378"></a> <br />CM-22937 | NCLU SNMPv3 user configuration (add, delete, modify) does not complete. Changes are made to the <code>/etc/snmp/snmpd.conf</code> file but the SNMPv3 user cache file <code>/var/lib/snmp/snmpd.conf</code> fails to update correctly and the configuration does not reflect in operation. <br />To work around this issue, stop <code>snmpd</code>, remove the cache file, then restart <code>snmpd</code>. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537188"></a> [2537188](#2537188) <a name="2537188"></a> <br />CM-22849 | When an event in the network, such as a <code>switchd</code> or networking service restart, leads to an OVSDB server high availability transition, an <code>ovs-vtepd</code> core might occur. <br />This core generation has no effect on the functionality of high availability when the active OVSDB server is back in the network. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2537104"></a> [2537104](#2537104) <a name="2537104"></a> <br />CM-22808 | When you try to stop <code>hsflowd</code> on the Trident II+ switch with the <code>systemctl stop hsflowd</code> command, the process hangs until you stop it with <code>SIGKILL</code>. <br /> | 3.7.1-3.7.14 | 4.0.0-4.3.0|
| <a name="2537061"></a> [2537061](#2537061) <a name="2537061"></a> <br />CM-22794 | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent. <br /> | 3.7.1-4.0.1 | 4.1.0-4.3.0|
| <a name="2536639"></a> [2536639](#2536639) <a name="2536639"></a> <br />CM-22605 | On a Dell S4048 switch, when you set the eth0 speed to 100, either with NCLU or by editing the <code>/etc/network/interfaces</code> file, the <code>igb</code> driver crashes, which brings down eth0. <br />To work around this issue: <br />* If eth0 is configured in the management VRF, power cycle the switch; the eth0 configuration fails and reverts back to the default (auto-negotiation/1000). <br />* If eth0 is configured in the default VRF and you power cycle after the crash, <code>igb</code> continues to crash on boot up (before getting to login prompt); power-cycle the switch, select the Advanced option in GRUB to boot to recovery mode, then modify the <code>/etc/network/interfaces</code> file. | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2536617"></a> [2536617](#2536617) <a name="2536617"></a> <br />CM-22591 | CVE-2018-5391 (FragmentSmack) is a network vulnerability where an attacker can trigger time and calculation expensive fragment reassembly with specially crafted packets, leading to a denial of service. On a Cumulus Linux switch, the impact is limited to control plane and management plane traffic. Any control plane traffic coming in the front panel ports will be limited by existing policer ACLs.<br />To work around this issue, create a file called <code>/etc/sysctl.d/ip.conf</code> and add these settings:<br /><pre><br />net.ipv4.ipfrag_low_thresh = 196608<br />net.ipv6.ip6frag_low_thresh = 196608<br />net.ipv4.ipfrag_high_thresh = 262144<br />net.ipv6.ip6frag_high_thresh = 262144<br /></pre> | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2536608"></a> [2536608](#2536608) <a name="2536608"></a> <br />CM-22583 | Single tagged ARP requests received on a QinQ-over-VXLAN access port are dropped if ARP suppression is enabled on an unrelated VNI. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2536559"></a> [2536559](#2536559) <a name="2536559"></a> <br />CM-22538 | When deleting an interface using NCLU, if the <code>/etc/network/interfaces</code> alias is different than the <code>/etc/frr/frr.conf</code> description, the <code>net commit</code> command returns the following error: <br /><pre><br /> /etc/frr/daemons was modified by another user.<br /></pre><br />Despite this error, the change is made and the description is removed from the <code>frr.conf</code> file.  | 3.7.3-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536231"></a> [2536231](#2536231) <a name="2536231"></a> <br />CM-22277 | On the Broadcom switch with the Trident3 ASIC, the ECN-CE bit is set by default on transit traffic. This might result in hosts adjusting traffic behavior if they are configured for the ECN feature. <br />In Cumulus Linux 3.7.11, the default behavior changed; the ECN-CE bit is _no longer_ set by default on transit traffic. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on protocol sockets.<br />When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a <code>switchd</code> restart. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535965"></a> [2535965](#2535965) <a name="2535965"></a> <br />CM-22020 | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br />To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535209"></a> [2535209](#2535209) <a name="2535209"></a> <br />CM-21278 | The <code>net show lldp</code> command sometimes shows the port description in the <code>Remote Port</code> field. The <code>net show interface</code> command shows the correct value in the <code>Remote Host</code> field.<br />To work around this issue, use <code>net show interface</code> command for LLDP output when connected to Cisco equipment. | 3.7.5-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2534450"></a> [2534450](#2534450) <a name="2534450"></a> <br />CM-20534 | The default BGP instance must be provisioned and always exist for proper operation of dynamic leaking of routes between VRFs.  | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2534394"></a> [2534394](#2534394) <a name="2534394"></a> <br />CM-20480 | The python-crypto package, which is not installed by default on Cumulus Linux, but is present in the repository to be installed, has the following security vulnerability in the version available for Cumulus Linux 3.x:<br />CVE-2018-6594: lib/Crypto/PublicKey/ElGamal.py in PyCrypto through 2.6.1 generates weak ElGamal key parameters, which allows attackers to obtain sensitive information by reading ciphertext data (i.e., it does not have semantic security in face of a ciphertext-only attack). The Decisional Diffie-Hellman (DDH) assumption does not hold for PyCrypto's ElGamal implementation.<br />More information at https://security-tracker.debian.org/tracker/CVE-2018-6594 . | 3.7.9-3.7.14.2 | |
| <a name="2528990"></a> [2528990](#2528990) <a name="2528990"></a> <br />CM-15278 | During a link flap test, you might occasionally see a message similar to: <code>warning: swp6: netlink: cannot set link swp6 down: &#91;Errno 98&#93; Address already in use</code>. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|

### Fixed Issues in 3.7.9
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="2548191"></a> [2548191](#2548191) <a name="2548191"></a> <br />CM-28712 | A security scanner may detect a version of wpa or hostapd that is not listed as having been fixed for CVE-2019-13377 and/or CVE-2019-16275.  Cumulus Linux since 3.7.9 and 4.0.0 has a customized version of wpa and hostapd which includes the fixes for these vulnerabilities. | 3.7.8 | |
| <a name="2545688"></a> [2545688](#2545688) <a name="2545688"></a> <br />CM-27349 | Debian security advisory DSA-4213 for qemu lists a number of security vulnerabilities.<br />https://www.debian.org/security/2018/dsa-4213<br />The latest upstream version 2.1+dfsg-12+deb8u12 fixes the following vulnerabilities listed in that announcement:<br />CVE-2017-15038 Tuomas Tynkkynen discovered an information leak in 9pfs.<br />CVE-2017-15119 Eric Blake discovered that the NBD server insufficiently restricts large option requests, resulting in denial of service.<br />CVE-2017-15268 A memory leak in websockets support may result in denial of service.<br />CVE-2017-15289 Guoxiang Niu discovered an OOB write in the emulated Cirrus graphics adaptor which could result in denial of service.<br />CVE-2017-16845 Cyrille Chatras discovered an information leak in PS/2 mouse and keyboard emulation which could be exploited during instance migration.<br />CVE-2017-17381 Dengzhan Heyuandong Bijunhua and Liweichao discovered that an implementation error in the virtio vring implementation could result in denial of service.<br />CVE-2017-18043 Eric Blake discovered an integer overflow in an internally used macro which could result in denial of service.<br />CVE-2018-5683 Jiang Xin and Lin ZheCheng discovered an OOB memory access in the emulated VGA adaptor which could result in denial of service.<br />CVE-2018-7550 Cyrille Chatras discovered that an OOB memory write when using multiboot could result in the execution of arbitrary code.<br />The following remains vulnerable in 2.1+dfsg-12+deb8u12:<br />CVE-2017-15124 Daniel Berrange discovered that the integrated VNC server insufficiently restricted memory allocation, which could result in denial of service.<br />Note: qemu is not installed by default, but is available in the repository for optional installation. |  | |
| <a name="2543546"></a> [2543546](#2543546) <a name="2543546"></a> <br />CM-26073 | <code>{watchfrr</code> calls <code>sudo /usr/sbin/service frr restart bgpd</code> but restarts all FRR daemons which can cause a large outage. This occurs because <code>watchfrr</code> uses an old style service command, which causes all daemons to restart when a daemon fails.  | 3.7.7-3.7.8 | |
| <a name="2543469"></a> [2543469](#2543469) <a name="2543469"></a> <br />CM-26022 | When using the UFT lpm-equal profile, IPv6 routes are limited to 16K.  | 3.7.8 | |
| <a name="2543389"></a> [2543389](#2543389) <a name="2543389"></a> <br />CM-25979 | Dynamic route-leaking works as expected until FRR is restarted or the switch is rebooted. After the restart or reboot, the import RT under the VRF where routes are being imported is incorrect. | 3.7.7-3.7.8 | |
| <a name="2543329"></a> [2543329](#2543329) <a name="2543329"></a> <br />CM-25956 | The following CVEs were announced in Debian Security Advisory DSA-4499-1 and affect the ghostscript package. <br />--------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4499-1 security&#64;debian.org <br />https://www.debian.org/security/ Salvatore Bonaccorso <br />August 12, 2019 https://www.debian.org/security/faq <br />--------------------------------------------------------------------------------------- <br />Package: ghostscript <br />CVE ID: CVE-2019-10216 <br />Debian Bug: 934638 <br />Netanel reported that the .buildfont1 procedure in Ghostscript, the GPL PostScript/PDF interpreter, does not <br />properly restrict privileged calls, which could result in bypass of file system restrictions of the dSAFER sandbox. <br />For the oldstable distribution (stretch), this problem has been fixed in version 9.26a~dfsg-0+deb9u4. <br />For the stable distribution (buster), this problem has been fixed in version 9.27~dfsg-2+deb10u1. <br />We recommend that you upgrade your ghostscript packages. <br />For the detailed security status of ghostscript, refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/ghostscript |  | |
| <a name="2543311"></a> [2543311](#2543311) <a name="2543311"></a> <br />CM-25944 | The following CVEs were announced in Debian Security Advisory DSA-4495 and DSA 4497 and affect the linux kernel package. <br />--------------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4495-1 security&#64;debian.org <br />https://www.debian.org/security/ Ben Hutchings <br />August 10, 2019 https://www.debian.org/security/faq <br />--------------------------------------------------------------------------------------------- <br />Package: linux <br />CVE ID: CVE-2018-20836 CVE-2019-1125 CVE-2019-1999 CVE-2019-10207 CVE-2019-10638 CVE-2019-12817 <br />CVE-2019-12984 CVE-2019-13233 CVE-2019-13631 CVE-2019-13648 CVE-2019-14283 CVE-2019-14284 <br />Several vulnerabilities have been discovered in the Linux kernel that may lead to a privilege escalation, denial of service or information leaks. <br />CVE-2015-8553 <br />Jan Beulich discovered that CVE-2015-2150 was not completely addressed. If a PCI physical function is passed through to a Xen guest, the guest is able to access its memory and I/O regions before enabling decoding of those regions. This could result in a denial-of-service (unexpected NMI) on the host. <br />The fix for this is incompatible with qemu versions before 2.5. <br />(CVE ID not yet assigned) <br />Denis Andzakovic reported a missing type check in the IPv4 multicast routing implementation. A user with the CAP_NET_ADMIN <br />capability (in any user namespace) could use this for denial-of-service (memory corruption or crash) or possibly for privilege escalation. <br />CVE-2018-5995 <br />ADLab of VenusTech discovered that the kernel logged the virtual addresses assigned to per-CPU data, which could make it easier to <br />exploit other vulnerabilities. <br />CVE-2018-20836 <br />chenxiang reported a race condition in libsas, the kernel subsystem supporting Serial Attached SCSI (SAS) devices, which could lead <br />to a use-after-free. It is not clear how this might be exploited. <br />CVE-2019-1125 <br />It was discovered that most x86 processors could speculatively skip a conditional SWAPGS instruction used when entering the kernel <br />from user mode, and/or could speculatively execute it when it should be skipped. This is a subtype of Spectre variant 1, which could <br />allow local users to obtain sensitive information from the kernel or other processes. It has been mitigated by using memory barriers to limit speculative execution. Systems using an i386 kernel are not affected as the kernel does not use SWAPGS. <br />CVE-2019-1999 <br />A race condition was discovered in the Android binder driver, which could lead to a use-after-free. If this driver is loaded, a local user might be able to use this for denial-of-service (memory corruption) or for privilege escalation. <br />CVE-2019-1125 <br />It was discovered that most x86 processors could speculatively skip a conditional SWAPGS instruction used when entering the kernel <br />from user mode, and/or could speculatively execute it when it should be skipped. This is a subtype of Spectre variant 1, which could <br />allow local users to obtain sensitive information from the kernel or other processes. It has been mitigated by using memory barriers to <br />limit speculative execution. Systems using an i386 kernel are not affected as the kernel does not use SWAPGS. <br />CVE-2019-3882 <br />It was found that the vfio implementation did not limit the number of DMA mappings to device memory. A local user granted ownership of <br />a vfio device could use this to cause a denial of service (out-of-memory condition). <br />CVE-2019-3900 <br />It was discovered that vhost drivers did not properly control the amount of work done to service requests from guest VMs. A malicious <br />guest could use this to cause a denial-of-service (unbounded CPU usage) on the host. <br />CVE-2019-10207 <br />The syzkaller tool found a potential null dereference in various drivers for UART-attached Bluetooth adapters. A local user with access <br />to a pty device or other suitable tty device could use this for denial-of-service (BU G/oops). <br />CVE-2019-10638 <br />Amit Klein and Benny Pinkas discovered that the generation of IP packet IDs used a weak hash function, "jhash". This could enable <br />tracking individual computers as they communicate with different remote servers and from different networks. The "siphash" function is <br />now used instead. <br />CVE-2019-10639 <br />Amit Klein and Benny Pinkas discovered that the generation of IP packet IDs used a weak hash function that incorporated a kernel <br />virtual address. This hash function is no longer used for IP IDs, although it is still used for other purposes in the network stack. <br />CVE-2019-12817 <br />It was discovered that on the PowerPC (ppc64el) architecture, the hash page table (HPT) code did not correctly handle fork() in a <br />process with memory mapped at addresses above 512 TiB. This could lead to a use-after-free in the kernel, or unintended sharing of <br />memory between user processes. A local user could use this for privilege escalation. Systems using the radix MMU, or a custom kernel <br />with a 4 KiB page size, are not affected. <br />CVE-2019-12984 <br />It was discovered that the NFC protocol implementation did not properly validate a netlink control message, potentially leading to a null <br />pointer dereference. A local user on a system with an NFC interface could use this for denial-of-service (BUG/oops). <br />CVE-2019-13233 <br />Jann Horn discovered a race condition on the x86 architecture, in use of the LDT. This could lead to a use-after-free. A local user could possibly use this for denial-of-service. <br />CVE-2019-13631 <br />It was discovered that the gtco driver for USB input tablets could overrun a stack buffer with constant data while parsing the device's <br />descriptor. A physically present user with a specially constructed USB device could use this to cause a denial-of-service (BUG/oops), or possibly for privilege escalation. <br />CVE-2019-13648 <br />Praveen Pandey reported that on PowerPC (ppc64el) systems without Transactional Memory (TM), the kernel would still attempt to <br />restore TM state passed to the sigreturn() system call. A local user could use this for denial-of-service (oops). <br />CVE-2019-14283 <br />The syzkaller tool found a missing bounds check in the floppy disk driver. A local user with access to a floppy disk device, with a <br />disk present, could use this to read kernel memory beyond the I/O buffer, possibly obtaining sensitive information. <br />CVE-2019-14284 <br />The syzkaller tool found a potential division-by-zero in the floppy disk driver. A local user with access to a floppy disk device could <br />use this for denial-of-service (oops). <br />(CVE ID not yet assigned) <br />Denis Andzakovic reported a possible use-after-free in the TCP sockets implementation. A local user could use this for denial-of-service (memory corruption or crash) or possibly for privilege escalation. <br />(CVE ID not yet assigned) <br />The netfilter conntrack subsystem used kernel addresses as user-visible IDs, which could make it easier to exploit other security vulnerabilities. <br />XSA-300 <br />Julien Grall reported that Linux does not limit the amount of memory which a domain will attempt to baloon out, nor limits the amount of <br />"foreign / grant map" memory which any individual guest can consume, leading to denial of service conditions (for host or guests). <br />For the oldstable distribution (stretch), these problems have been fixed in version 4.9.168-1+deb9u5. <br />For the stable distribution (buster), these problems have been fixed in version 4.19.37-5+deb10u2. <br />For the oldstable distribution (stretch), these problems will be fixed soon. <br />We recommend that you upgrade your linux packages. <br />For the detailed security status of linux, refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/linux |  | |
| <a name="2543008"></a> [2543008](#2543008) <a name="2543008"></a> <br />CM-25784 | The following CVEs were announced in Debian Security Advisory DSA-4489-1. <br />--------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4489-1 security&#64;debian.org <br />https://www.debian.org/security/ Salvatore Bonaccorso <br />July 27, 2019 https://www.debian.org/security/faq <br />--------------------------------------------------------------------------------------- <br />Package: patch <br />CVE ID: CVE-2019-13636 CVE-2019-13638 <br />Debian Bug: 932401 933140 <br />Imre Rad discovered several vulnerabilities in GNU patch, leading to shell command injection or escape from <br />the working directory and access and overwrite files, if specially crafted patch files are processed. <br />This update includes a bugfix for a regression introduced by the patch to address CVE-2018-1000156 when <br />applying an ed-style patch (#933140). <br />For the oldstable distribution (stretch), these problems have been fixed in version 2.7.5-1+deb9u2. <br />For the stable distribution (buster), these problems have been fixed in version 2.7.6-3+deb10u1. <br />We recommend that you upgrade your patch packages. <br />For the detailed security status of patch please refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/patch |  | |
| <a name="2543004"></a> [2543004](#2543004) <a name="2543004"></a> <br />CM-25783 | Cumulus Linux installer images have a shell script that validates checksum integrity. When you run <code>onie-install</code>, this check is run but the installer is still staged even if the checksum validation fails. <br />To work around this issue, perform your own checksum validation before staging a new image with <code>onie-install</code>.  | 3.7.7-3.7.8 | |
| <a name="2542985"></a> [2542985](#2542985) <a name="2542985"></a> <br />CM-25770 | On a Tomahawk switch, the 5m 40G DACs (40G CR4) do not come up when both sides have auto-negotiation enabled. | 3.7.7-3.7.8 | |
| <a name="2542966"></a> [2542966](#2542966) <a name="2542966"></a> <br />CM-25754 | A port that is used as both a double tag interface and a VXLAN access side interface does not forward correctly; VXLAN decapsulation is does not occur.  However, do not configure double tagged interfaces on VXLAN uplink ports as this will cause VXLAN routing issues. |  | |
| <a name="2542939"></a> [2542939](#2542939) <a name="2542939"></a> <br />CM-25735 | When MLAG is re-establishing its peering after a member reboot, the VNIs on the peer briefly go into a protodown state. This can cause complete downtime to dually connected hosts as the member coming back up is still in <code>initDelay</code>. This issue does resolve itself as the VNIs do come back up within ten seconds.  | 3.7.8 | |
| <a name="2542853"></a> [2542853](#2542853) <a name="2542853"></a> <br />CM-25684 | For interfaces configured with RS FEC, when <code>switchd</code> is restarted, the link goes down but does not automatically come back up. This occurs because the FEC status is not replayed correctly into the kernel. <br />To work around this issue, run the <code>ifreload -a</code> command to bring up the interface after <code>switchd</code> is restarted.  | 3.7.6-3.7.8 | |
| <a name="2542837"></a> [2542837](#2542837) <a name="2542837"></a> <br />CM-25674 | On Mellanox switches, policer iptables are not working as expected. For example, when using a policer with mode KB/MB/GB to rate-limit interfaces, the syntax is accepted but the data plane transfer speed is not affected by the rule.  | 3.7.6-3.7.8, 4.0.0-4.3.0 | |
| <a name="2542820"></a> [2542820](#2542820) <a name="2542820"></a> <br />CM-25664 | On the Trident3 platform, you can only add 50 percent of the total ECMP next hops. A log message indicates that the table is full.  | 3.7.7-3.7.8 | |
| <a name="2542774"></a> [2542774](#2542774) <a name="2542774"></a> <br />CM-25646 | When moving an IP address from the address line to <code>inet dhcp</code>, then issuing the <code>ifreload -a</code> command, the old address is not removed from the interface. NCLU still reports the old address only and reports it as a DHCP address.  | 3.7.6-3.7.8 | |
| <a name="2542726"></a> [2542726](#2542726) <a name="2542726"></a> <br />CM-25619 | After configuring <code>switchd hal.bcm.per_vlan_router_mac_lookup</code> to TRUE on a Broadcom switch,  layer 2 traffic works over VXLAN but the host is not able to ping the locally connected gateway and loses routing ability to other IPs and subnets.  | 3.7.5-3.7.8 | |
| <a name="2542711"></a> [2542711](#2542711) <a name="2542711"></a> <br />CM-25610 | BGP update packets are sometimes missing the mandatory <code>nexthop</code> attribute, which causes connections to reset. For example, this issue is seen when using VRF route leaking with a mix of BGP unnumbered and BGP numbered peers.  | 3.7.6-3.7.8 | |
| <a name="2542480"></a> [2542480](#2542480) <a name="2542480"></a> <br />CM-25489 | When BGP <code>remove-private-AS replace-AS</code> is configured under the BGP IPv4 or IPv6 address family between a pair of switches configured as BGP peers, a BGP route update might cause the BGP session to flap. <br />To work around this issue, do not configure <code>remove-private-AS replace-AS</code> in the BGP IPv4 or IPv6 address family. | 3.7.6-3.7.8 | |
| <a name="2542472"></a> [2542472](#2542472) <a name="2542472"></a> <br />CM-25488 | On Broadcom-based VXLAN routing capable platforms, VXLAN traffic received at the egress VTEP might drop because the hardware is mis-programming. This issue is related to timing and is not easily reproduced. <br />This issue might occur after a VXLAN interface (VNI) state transition (the peerlink goes down and puts VNI into a protodown state, then the peerlink comes back and the VNI returns to UP) and is related to how the next-hop information is programmed in hardware. Sometimes the host routes corresponding to this VXLAN segment are mis-programmed with the wrong next hop information. <br />To work around this issue, restart the <code>switchd</code> service with the <code>sudo systemctl restart switchd.service</code> command.  |  | |
| <a name="2542423"></a> [2542423](#2542423) <a name="2542423"></a> <br />CM-25467 | The following CVEs were announced in Debian Security Advisory DSA-4472-1 and affect the expat (libexpat1) package. <br />------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4472-1 security&#64;debian.org <br />https://www.debian.org/security/ Salvatore Bonaccorso <br />June 28, 2019 https://www.debian.org/security/faq <br />------------------------------------------------------------------------------------- <br />Package: expat <br />CVE ID: CVE-2018-20843 <br />Debian Bug: 931031 <br />It was discovered that Expat, an XML parsing C library, did not properly handled XML input including XML names <br />that contain a large number of colons, potentially resulting in denial of service. <br />For the stable distribution (stretch), this problem has been fixed in version 2.2.0-2+deb9u2. <br />We recommend that you upgrade your expat packages. <br />For the detailed security status of expat, refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/expat |  | |
| <a name="2542365"></a> [2542365](#2542365) <a name="2542365"></a> <br />CM-25432 | The <code>snmpd</code> service frequently crashes due to <code>double free or corruption</code>.  | 3.7.6-3.7.8 | |
| <a name="2542341"></a> [2542341](#2542341) <a name="2542341"></a> <br />CM-25417 | The IP neighbor entry for a link-local next hop (169.254.x.x) is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces. <br />To work around this issue, flap the peering to the peer router (which can be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.8 | |
| <a name="2542336"></a> [2542336](#2542336) <a name="2542336"></a> <br />CM-25414 | On the Mellanox SN2410 switch, <code>switchd</code> does not start.  | 3.7.2-3.7.8 | |
| <a name="2542297"></a> [2542297](#2542297) <a name="2542297"></a> <br />CM-25395 | When you run the NCLU <code>net del all</code> command, the <code>exec-timeout</code> setting changes in the <code>/etc/frr.frr.conf</code> file.  | 3.7.6-3.7.8 | |
| <a name="2542193"></a> [2542193](#2542193) <a name="2542193"></a> <br />CM-25358 | When you configure the <code>link-down yes</code> attribute to a physical SVI, the VRR (-v0) interface is not brought down, and the locally-connected subnet can still be redistributed into routing protocols and advertised to neighbors despite the physical SVI being administratively down. <br />To work around this issue, manually bring down the VRR (-v0) interface with the <code>ip link set dev</code> command. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo ip link set dev vlan1755-v0 down <br /></pre>  | 3.7.6-3.7.8 | |
| <a name="2542160"></a> [2542160](#2542160) <a name="2542160"></a> <br />CM-25343 | The following CVEs were announced in Debian Security Advisory DSA-4465-1 and affect the linux kernel. <br />------------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4465-1 security&#64;debian.org <br />https://www.debian.org/security/ Salvatore Bonaccorso <br />June 17, 2019 https://www.debian.org/security/faq <br />------------------------------------------------------------------------------------------- <br />Package: linux <br />CVE ID: CVE-2019-3846 CVE-2019-5489 CVE-2019-9500 CVE-2019-9503 CVE-2019-10126 CVE-2019-11477 <br />CVE-2019-11478 CVE-2019-11479 CVE-2019-11486 CVE-2019-11599 CVE-2019-11815 CVE-2019-11833 CVE-2019-11884 <br />Debian Bug: 928989 <br />Several vulnerabilities have been discovered in the Linux kernel that may lead to a privilege escalation, denial of service or <br />information leaks. <br />CVE-2019-3846, CVE-2019-10126 <br />huangwen reported multiple buffer overflows in the Marvell wifi (mwifiex) driver, which a local user could use to cause denial of <br />service or the execution of arbitrary code. <br />CVE-2019-5489 <br />Daniel Gruss, Erik Kraft, Trishita Tiwari, Michael Schwarz, Ari Trachtenberg, Jason Hennessey, Alex Ionescu, and Anders Fogh <br />discovered that local users could use the mincore() system call to obtain sensitive information from other processes that access <br />the same memory-mapped file. <br />CVE-2019-9500, CVE-2019-9503 <br />Hugues Anguelkov discovered a buffer overflow and missing access validation in the Broadcom FullMAC wifi driver (brcmfmac), <br />which a attacker on the same wifi network could use to cause denial of service or the execution of arbitrary code. <br />CVE-2019-11477 <br />Jonathan Looney reported that a specially crafted sequence of TCP selective acknowledgements (SACKs) allows a remotely <br />triggerable kernel panic. <br />CVE-2019-11478 <br />Jonathan Looney reported that a specially crafted sequence of TCP selective acknowledgements (SACKs) will fragment the TCP <br />retransmission queue, allowing an attacker to cause excessive resource usage. <br />CVE-2019-11479 <br />Jonathan Looney reported that an attacker could force the Linux kernel to segment its responses into multiple TCP segments, <br />each of which contains only 8 bytes of data, drastically increasing the bandwidth required to deliver the same amount of data. <br />This update introduces a new sysctl value to control the minimal MSS (net.ipv4.tcp_min_snd_mss), which by default uses the <br />formerly hard-coded value of 48. We recommend raising this to 536 unless you know that your network requires a lower value. <br />CVE-2019-11486 <br />Jann Horn of Google reported numerous race conditions in the Siemens R3964 line discipline. A local user could use these to <br />cause unspecified security impact. This module has therefore been disabled. <br />CVE-2019-11599 <br />Jann Horn of Google reported a race condition in the core dump implementation which could lead to a use-after-free. A local <br />user could use this to read sensitive information, to cause a denial of service (memory corruption), or for privilege escalation. <br />CVE-2019-11815 <br />It was discovered that a use-after-free in the Reliable Datagram Sockets protocol could result in denial of service and potentially <br />privilege escalation. This protocol module (rds) is not auto-loaded on Debian systems, so this issue only affects systems where <br />it is explicitly loaded. <br />CVE-2019-11833 <br />It was discovered that the ext4 filesystem implementation writes uninitialised data from kernel memory to new extent blocks. <br />A local user able to write to an ext4 filesystem and then read the filesystem image, for example using a removable drive, might be <br />able to use this to obtain sensitive information. <br />CVE-2019-11884 <br />It was discovered that the Bluetooth HIDP implementation did not ensure that new connection names were null-terminated. <br />A local user with CAP_NET_ADMIN capability might be able to use this to obtain sensitive information from the kernel stack. <br />For the stable distribution (stretch), these problems have been fixed in version 4.9.168-1+deb9u3. <br />We recommend that you upgrade your linux packages. <br />For the detailed security status of linux, refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/linux | 3.7.6-3.7.8 | |
| <a name="2542058"></a> [2542058](#2542058) <a name="2542058"></a> <br />CM-25295 | The <code>ifquery</code> command should return a non-zero value if there is a syntax error. However, it currently returns zero. This issue affects automation scripts that validate a file before copying it into place. | 3.7.6-3.7.8 | |
| <a name="2542032"></a> [2542032](#2542032) <a name="2542032"></a> <br />CM-25284 | If you configure a <code>sys-mac</code> with a single digit, <code>ifreload -a</code> does not indicate that the MAC address is invalid for the MLAG sys-mac and the <code>clagd</code> process fails silently.  | 3.7.6-3.7.8 | |
| <a name="2541924"></a> [2541924](#2541924) <a name="2541924"></a> <br />CM-25240 | If the <code>address-virtual</code> MAC address is missing a leading zero in the last octet, the interface bounces. | 3.7.6-3.7.8 | |
| <a name="2541604"></a> [2541604](#2541604) <a name="2541604"></a> <br />CM-25079 | The <code>snmpd</code> service exits with a message similar to the following: <br /><pre> <br />Error in '/usr/sbin/snmpd': double free or corruption (fasttop): 0x00000000018a4e50 *** <br /></pre> <br />This problem might occur during or after network convergence events. For example, when <code>bgpd</code> needs to process a high number of updates and the CPU cannot keep up, <code>bgpd</code> is disconnected and <code>agentx</code> generates a core dump in <code>snmpd</code> due to a memory allocation problem. <br />To work around this issue, disable <code>agentx</code> by commenting out the following lines in the <code>/etc/snmp/snmpd.conf</code> file. Then, restart the <code>snmpd</code> service with the <code>systemctl restart snmpd</code> command. <br /><pre> <br />agentxperms 777 777 snmp snmp <br />agentxsocket /var/agentx/master <br /></pre> <br />If you still want to poll the BGP4-MIB information, re-enable the <code>bgp pass persist</code> script by adding the following line in the <code>/etc/snmp/snmpd.conf</code> file: <br /><pre> <br />pass_persist 1.3.6.1.2.1.15 /usr/share/snmp/bgp4_pp.py <br /></pre>  | 3.7.2-3.7.8 | |
| <a name="2541346"></a> [2541346](#2541346) <a name="2541346"></a> <br />CM-24963 | The following CVEs were announced in Debian Security Advisory DSA-4440-1. <br />--------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4440-1 security&#64;debian.org <br />https://www.debian.org/security/ Moritz Muehlenhoff <br />May 09, 2019 https://www.debian.org/security/faq <br />--------------------------------------------------------------------------------------- <br />Package: bind9 <br />CVE ID: CVE-2018-5743 CVE-2018-5745 CVE-2019-6465 <br />Multiple vulnerabilities were found in the BIND DNS server: <br />CVE-2018-5743 <br />Connection limits were incorrectly enforced. <br />CVE-2018-5745 <br />The "managed-keys" feature was susceptible to denial of service by triggering an assert. <br />CVE-2019-6465 <br />ACLs for zone transfers were incorrectly enforced for dynamically loadable zones (DLZs). <br />For the stable distribution (stretch), these problems have been fixed in version 1:9.10.3.dfsg.P4-12.3+deb9u5. <br />We recommend that you upgrade your bind9 packages. <br />For the detailed security status of bind9 please refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/bind9 |  | |
| <a name="2541005"></a> [2541005](#2541005) <a name="2541005"></a> <br />CM-24784 | NCLU is unable to delete a BGP neighbor configuration if there is a VRF VNI mapping in the <code>/etc/frr/frr.conf</code> file. For example, the following NCLU command produces an error: <br /><pre> <br />cumulus&#64;leaf01$ net del bgp neighbor swp5 interface peer-group spine <br />'router bgp 65001' configuration does not have 'neighbor swp5 interface peer-group spine' <br /></pre>  | 3.7.7-3.7.8 | |
| <a name="2540685"></a> [2540685](#2540685) <a name="2540685"></a> <br />CM-24593 | On a Dell S5248F (Trident3) switch, packets from switch ports are forwarded to the CPU and are sometimes corrupted. The corruption might result in BGP peerings being down, which can lead to all VXLAN traffic to and from a node to be lost, causing an outage to dually connected hosts in a rack. To work around this issue, restart <code>switchd</code>. | 3.7.3-3.7.8 | |
| <a name="2540601"></a> [2540601](#2540601) <a name="2540601"></a> <br />CM-24544 | If the <code>clagd-vxlan-anycast-ip</code> is removed from the <code>/etc/network/interfaces</code> file (either with the NCLU command or by editing the file manually), MLAG still believes it is present until clagd restarts.  | 3.7.3-3.7.8 | |
| <a name="2540359"></a> [2540359](#2540359) <a name="2540359"></a> <br />CM-24440 | <code>bgpd</code> creates a core dump at zclient_send_interface_radv_req. This is an issue with how FRRouting checks next hops and has been pushed upstream to FRRouting. | 3.7.6-3.7.8 | |
| <a name="2538741"></a> [2538741](#2538741) <a name="2538741"></a> <br />CM-23652 | The NCLU command <code>net show bridge spanning-tree</code> does not show the MLAG peer link as part of the STP forwarding instance.<br />To work around this issue, use the <code>mstpctl</code> command to confirm the STP status of the port. | 3.7.2-3.7.8 | |
| <a name="2538710"></a> [2538710](#2538710) <a name="2538710"></a> <br />CM-23636 | The following CVEs were announced in Debian Security Advisory DSA-4436-1 and affect the imagemagick packages. <br />------------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4371-1 security&#64;debian.org <br />https://www.debian.org/security/ Yves-Alexis Perez <br />January 22, 2019 https://www.debian.org/security/faq <br />------------------------------------------------------------------------------------------- <br />Max Justicz discovered a vulnerability in APT, the high level package manager. <br />The code handling HTTP redirects in the HTTP transport method doesn't properly sanitize fields transmitted over the wire. This vulnerability could be used by an attacker located as a man-in-the-middle between APT and a mirror to inject malicous content in the HTTP connection. This content could then be recognized as a valid package by APT and used later for code execution with root privileges on the target machine. Since the vulnerability is present in the package manager itself, it is recommended to disable redirects in order to prevent exploitation during this upgrade only, using: <br />apt -o Acquire::http::AllowRedirect=false update <br />apt -o Acquire::http::AllowRedirect=false upgrade <br />The code handling HTTP redirects in the HTTP transport method doesn't properly sanitize fields transmitted over the wire. <br />This vulnerability could be used by an attacker located as a man-in-the-middle between APT and a mirror to inject malicous content in the HTTP connection. This content could then be recognized as a valid package by APT and used later for code execution with root privileges on the target machine. Since the vulnerability is present in the package manager itself, it is recommended to disable redirects in order to prevent exploitation during this upgrade only, using: <br />apt -o Acquire::http::AllowRedirect=false update <br />apt -o Acquire::http::AllowRedirect=false upgrade <br />This is known to break some proxies when used against security.debian.org. If that happens, people can switch their security APT source to use deb http://cdn-fastly.deb.debian.org/debian-security stable/updates main <br />For the stable distribution (stretch), this problem has been fixed in version 1.4.9. |  | |
| <a name="2538480"></a> [2538480](#2538480) <a name="2538480"></a> <br />CM-23523 | Modifying the <code>/etc/netd.conf</code> file to set <code>show_linux_command = True</code> does not take effect.  | 3.7.2-3.7.8 | |
| <a name="2538321"></a> [2538321](#2538321) <a name="2538321"></a> <br />CM-23431 | On the Trident3 switch, the input chain ACLs drop action forwards packets if the traffic is destined to the CPU on an SVI.  |  | |
| <a name="2538257"></a> [2538257](#2538257) <a name="2538257"></a> <br />CM-23398 | The following CVEs were announced in Debian Security Advisory DSA-4359-1 and affect the wireshark packages, some of which are available for optional installation on Cumulus Linux:<br />CVE ID: CVE-2018-12086 CVE-2018-18225 CVE-2018-18226 CVE-2018-18227 CVE-2018-19622 CVE-2018-19623 CVE-2018-19624 CVE-2018-19625 CVE-2018-19626 CVE-2018-19627 CVE-2018-19628 <br />All CVEs except for CVE-2018-12086 are fixed in Cumulus Linux 3.7.9.<br />Packages: libwireshark5, libwireshark-data, libwiretap8, libwscodecs2, libwsutil9, tshark, wireshark, wireshark-common, wireshark-doc<br />These problems have been fixed in version 1.12.1+g01b65bf-4+deb8u19<br />We recommend that you upgrade your wireshark packages.<br />For the detailed security status of wireshark, refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/wireshark | 3.7.8 | |
| <a name="2538022"></a> [2538022](#2538022) <a name="2538022"></a> <br />CM-23285 | When you remove an interface from a bridge and add it to a VRF in the same commit/ifreload, the IPv6 link-local address is not created automatically. <br />To work around this issue, do the change in two separate commits. First, remove the interface from the bridge, which causes it to be a layer 2 interface. Then, enslave the interface to the VRF.  | 3.7.2-3.7.8 | |
| <a name="2537799"></a> [2537799](#2537799) <a name="2537799"></a> <br />CM-23114 | The following CVEs were announced in Debian Security Advisory DSA-4347-1. <br />-------------------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4347-1 security&#64;debian.org <br />https://www.debian.org/security/ Salvatore Bonaccorso <br />November 29, 2018 https://www.debian.org/security/faq <br />-------------------------------------------------------------------------------------------------- <br />Package: perl <br />CVE ID: CVE-2018-18311 CVE-2018-18312 CVE-2018-18313 CVE-2018-18314 <br />Multiple vulnerabilities were discovered in the implementation of the Perl programming language. <br />The Common Vulnerabilities and Exposures project identifies the following problems: <br />CVE-2018-18311 <br />Jayakrishna Menon and Christophe Hauser discovered an integer overflow vulnerability in Perl_my_setenv leading to a <br />heap-basedbuffer overflow with attacker-controlled input. <br />CVE-2018-18312 <br />Eiichi Tsukata discovered that a crafted regular expression could cause a heap-based buffer overflow write during <br />compilation, potentially allowing arbitrary code execution. <br />CVE-2018-18313 <br />Eiichi Tsukata discovered that a crafted regular expression could cause a heap-based buffer overflow read during compilation which leads to information leak. <br />CVE-2018-18314 <br />Jakub Wilk discovered that a specially crafted regular expression could lead to a heap-based buffer overflow. <br />For the stable distribution (stretch), these problems have been fixed in version 5.24.1-3+deb9u5. <br />We recommend that you upgrade your perl packages. <br />For the detailed security status of perl please refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/perl |  | |
| <a name="2537753"></a> [2537753](#2537753) <a name="2537753"></a> <br />CM-23096 | The following CVEs were announced in Debian Security Advisory DSA-4372-1. <br />-------------------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4346-1 security&#64;debian.org <br />https://www.debian.org/security/ Salvatore Bonaccorso <br />November 27, 2018 https://www.debian.org/security/faq <br />-------------------------------------------------------------------------------------------------- <br />Package: ghostscript <br />CVE ID: CVE-2018-19409 CVE-2018-19475 CVE-2018-19476 CVE-2018-19477 <br />Several vulnerabilities were discovered in Ghostscript, the GPL PostScript/PDF interpreter, which may <br />result in denial of service or the execution of arbitrary code if a malformed Postscript file is processed <br />(despite the -dSAFER sandbox being enabled). <br />This update rebases ghostscript for stretch to the upstream version 9.26 which includes additional changes. <br />For the stable distribution (stretch), these problems have been fixed in version 9.26~dfsg-0+deb9u1. <br />We recommend that you upgrade your ghostscript packages. <br />For the detailed security status of ghostscript please refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/ghostscript |  | |
| <a name="2537153"></a> [2537153](#2537153) <a name="2537153"></a> <br />CM-22834 | In rare cases, certain IPv6 BGP peers fail to reestablish after <code>switchd</code> restarts. | 3.7.2-3.7.8 | |
| <a name="2536651"></a> [2536651](#2536651) <a name="2536651"></a> <br />CM-22608 | Mellanox Spectrum and Helix4 switches occasionally send malformed packets and do not send any flow samples (only counters). <br />While this issue is fixed for switches with the Spectrum ASIC, this is a &#91;known limitation\|https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Network-Troubleshooting/Monitoring-System-Statistics-and-Network-Traffic-with-sFlow/#caveats-and-errata&#93; on this Helix4 platform. | 3.7.0-3.7.8 | |
| <a name="2536154"></a> [2536154](#2536154) <a name="2536154"></a> <br />CM-22203 | By default, the nginx server used for the HTTP API on port 8080 is enabled, but does not listen to external requests. However, it appears to be listening and answering external requests.  |  | |
| <a name="2535445"></a> [2535445](#2535445) <a name="2535445"></a> <br />CM-21511 | If a VNI is configured before the bridge in <code>/etc/network/interfaces</code>, the switch does not send IGMP queries. <br />To work around this issue, edit the <code>/etc/network/interfaces</code> file to define the bridge before the VNI. For example: <br /><pre> <br /># The primary network interface <br />auto eth0 <br />iface eth0 inet dhcp <br /><br />auto lo <br />iface lo inet loopback <br />address 10.26.10.11/32 <br /><br />auto swp9 <br />iface swp9 <br />bridge-access 100 <br /><br />auto swp10 <br />iface swp10 <br />bridge-access 100 <br /><br />auto bridge <br />iface bridge <br />bridge-ports swp9 swp10 vni-10 <br />bridge-vids 100 <br />bridge-vlan-aware yes <br />bridge-mcquerier 1 <br /><br />auto vni-10 <br />iface vni-10 <br />vxlan-id 10 <br />vxlan-local-tunnelip 10.0.0.11 <br />bridge-access 100 <br /><br />auto bridge.100 <br />vlan bridge.100 <br />bridge-igmp-querier-src 123.1.1.1 <br /><br />auto vlan100 <br />iface vlan100 <br />address 10.26.100.2/24 <br />vlan-id 100 <br />vlan-raw-device bridge <br /></pre> <br />. |  | |
| <a name="2534887"></a> [2534887](#2534887) <a name="2534887"></a> <br />CM-20966 | The NCLU <code>net show lldp</code> and <code>net show interface</code> commands do not show LLDP information for swp* (eth is unaffected).  |  | |
| <a name="2534730"></a> [2534730](#2534730) <a name="2534730"></a> <br />CM-20809 | The following CVEs were announced in a Debian Security Advisory. <br />-------------------------------------------------------------------------------------------------- <br />It was discovered that Ghostscript incorrectly handled certain PostScript files. An attacker could possibly use this to <br />cause a denial of server. (CVE-2016-10317) <br />It was discovered that Ghostscript incorrectly handled certain PDF files. An attacker could possibly use this to cause <br />a denial of service. (CVE-2018-10194) <br />Debian CVE links: https://security-tracker.debian.org/tracker/CVE-2016-10317 and https://security-tracker.debian.org/tracker/CVE-2018-10194 |  | |
| <a name="2533865"></a> [2533865](#2533865) <a name="2533865"></a> <br />CM-19960 | The following CVEs were announced in Debian Security Advisory DSA-4131. <br />------------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4131-1 security&#64;debian.org <br />https://www.debian.org/security/ Moritz Muehlenhoff <br />March 04, 2018 https://www.debian.org/security/faq <br />------------------------------------------------------------------------------------------ <br />Package: xen <br />CVE ID: CVE-2018-7540 CVE-2018-7541 CVE-2018-7542 <br />Multiple vulnerabilities have been discovered in the Xen hypervisor: <br />CVE-2018-7540 <br />Jann Horn discovered that missing checks in page table freeing may result in denial of service. <br />CVE-2018-7541 <br />Jan Beulich discovered that incorrect error handling in grant table checks may result in guest-to-host <br />denial of service and potentially privilege escalation. <br />CVE-2018-7542 <br />Ian Jackson discovered that insufficient handling of x86 PVH guests without local APICs may result in <br />guest-to-host denial of service. <br />For the stable distribution (stretch), these problems have been fixed in version <br />4.8.3+comet2+shim4.10.0+comet3-1+deb9u5. <br />We recommend that you upgrade your xen packages. <br />For the detailed security status of xen please refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/xen |  | |
| <a name="2532396"></a> [2532396](#2532396) <a name="2532396"></a> <br />CM-18537 | Drops due to congestion do not appear to be counted on a Mellanox switch. To work around this issue, run the <code>sudo ethtool -S swp1</code> command to collect interface traffic statistics.  |  | |

## 3.7.8 Release Notes
### Open issues in 3.7.8

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552739"></a> [2552739](#2552739) <a name="2552739"></a> <br />CM-31148 | Counters for IPROUTER rules do not increase when traffic is forwarded to the CPU because there is no IP neighbor. | 3.7.2-3.7.14.2 | |
| <a name="2552528"></a> [2552528](#2552528) <a name="2552528"></a> <br />CM-31028 | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2552352"></a> [2552352](#2552352) <a name="2552352"></a> <br />CM-30914 | The following security vulnerabilities have been announced in the nss / libnss3 packages:<br />CVE-2020-6829: Side channel attack on ECDSA signature generation<br />CVE-2020-12400: P-384 and P-521 implementation uses a side-channel vulnerable modular inversion function<br />CVE-2020-12401: ECDSA timing attack mitigation bypass<br />Vulnerable: <= 3.26-1+debu8u11<br />Fixed: 3.26-1+debu8u12 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552351"></a> [2552351](#2552351) <a name="2552351"></a> <br />CM-30913 | The following vulnerability has been announced in the libx11 packages:<br />CVE-2020-14344: The X Input Method (XIM) client implementation in libX11 has some integer overflows and signed/unsigned comparison issues that can lead to heap corruption when handling malformed messages from an input method.<br />Vulnerable: <= 1.6.2-3+deb8u2<br />Fixed: 1.6.2-3+deb8u3 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2551675"></a> [2551675](#2551675) <a name="2551675"></a> <br />CM-30479 | When you restart <code>clagd</code>, the edge port setting on the peer link changes. | 3.7.2-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551288"></a> [2551288](#2551288) <a name="2551288"></a> <br />CM-30286 | When you remove BFD configuration by editing the <code>/etc/frr/frr.conf</code> file and restarting FRR, you see a traceback.<br />To work around this issue, either use NCLU or vtysh commands to remove the BFD configuration, or restart FRR with the new <code>/etc/frr/frr.conf</code> file. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2550601"></a> [2550601](#2550601) <a name="2550601"></a> <br />CM-29978 | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | 4.2.1-4.3.0, 4.3.0|
| <a name="2550323"></a> [2550323](#2550323) <a name="2550323"></a> <br />CM-29807 | After a neighbor is removed, the redistributed neighbor entry is withdrawn from the BGP table, but the prefix might still be selected as the bestpath when the host's originated prefix is not advertised.<br />To work around this issue, recreate the neighbor entry and flap the interface to the host. <br />Or, if the host is already down, manually create a neighbor entry with an invalid MAC address, which forces redistribute neighbor to re-withdraw the entry. | 3.7.3-3.7.12 | 3.7.13-3.7.14.2, 4.0.0-4.3.0|
| <a name="2548475"></a> [2548475](#2548475) <a name="2548475"></a> <br />CM-28932 | After you add a new VNI and a layer 3 SVI to a set of leafs, certain leafs might not be able to communicate on the layer 3 VNI. <br />To work around this issue, reboot the leaf switch or restart <code>switchd</code>. | 3.7.6-3.7.13 | 3.7.14-3.7.14.2, 4.0.0-4.3.0|
| <a name="2548383"></a> [2548383](#2548383) <a name="2548383"></a> <br />CM-28867 | The QuantaMesh BMS T3048-LY8 switch shows a low fan RPM in syslog. | 3.7.5-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548191"></a> [2548191](#2548191) <a name="2548191"></a> <br />CM-28712 | A security scanner may detect a version of wpa or hostapd that is not listed as having been fixed for CVE-2019-13377 and/or CVE-2019-16275.  Cumulus Linux since 3.7.9 and 4.0.0 has a customized version of wpa and hostapd which includes the fixes for these vulnerabilities. | 3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2547769"></a> [2547769](#2547769) <a name="2547769"></a> <br />CM-28437 | <code>syslog</code> might report a high load average with the CPU running a later microcode revision. | 3.7.4-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547663"></a> [2547663](#2547663) <a name="2547663"></a> <br />CM-28374 | When traffic from a double tag interface (facing a different site) is forwarded through VXLAN, the inner tag is not removed. The destination does not know this tag, so it discards it. | 3.7.8-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547013"></a> [2547013](#2547013) <a name="2547013"></a> <br />CM-28016 | On the Mellanox Spectrum switch, <code>switchd</code> can sometimes fail when PBR rules are installed or removed from hardware if the rule is setting a next hop learned via a routing protocol. | 3.7.7-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546999"></a> [2546999](#2546999) <a name="2546999"></a> <br />CM-28007 | When you configure Cumulus Linux with a /32 address on a switch port with a configured peer address (for example, to connect to a device using IP unnumbered), the switch sends GARPs for the peer address. | 3.7.5-3.7.11 | 3.7.12-3.7.14.2, 4.1.0-4.3.0|
| <a name="2546869"></a> [2546869](#2546869) <a name="2546869"></a> <br />CM-27947 | Broadcom Field Alert - SID - MMU 2B Errors<br />A few of the MMU memories on Broadcom switches are grouped together with single parity control. During SER correction when a parity error occurs on one of those groups, other memory in that group might also report a SER error. This occurs when the memory is accessed either by a packet hit or through a schan operation. This issue can cause SER errors in other memory and cause traffic mis-forwarding or a packet drop. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546703"></a> [2546703](#2546703) <a name="2546703"></a> <br />CM-27855 | The FRR cl-support module times out on switches on the ARM platform even when the switch is not under heavy load.<br />To work around this issue, run the <code>cl-support -M</code> command to disable timeouts. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546385"></a> [2546385](#2546385) <a name="2546385"></a> <br />CM-27698 | SNMP ifLastChange reports link transitions when there are none. | 3.7.6-3.7.14.2 | |
| <a name="2545694"></a> [2545694](#2545694) <a name="2545694"></a> <br />CM-27351 | On rare occasions, after rebooting the MLAG secondary switch, one MLAG device might see the peer as down, which can cause traffic disruption to connected hosts. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.1.0-4.3.0|
| <a name="2545600"></a> [2545600](#2545600) <a name="2545600"></a> <br />CM-27295 | IPv6 table rules might affect forwarding. For example, if you create the following rule in the <code>/etc/cumulus/acl/policy.d/03-sshd.rules</code> file, the rule counter increments but IPv4 SSH traffic might be dropped.<br /><pre><br />&#91;ip6tables&#93;<br />-A INPUT -p tcp --dport 22 -j DROP<br /></pre> | 3.7.2-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2545405"></a> [2545405](#2545405) <a name="2545405"></a> <br />CM-27174 | The <code>ospfd</code> daemon might crash with the following kernel trace: <br /><pre><br />2019-11-06T23:00:08.261749+09:00 cumulus ospfd&#91;5339&#93;: Assertion 'node' failed in file ospfd/ospf_packet.c, line 671, function ospf_write<br /></pre> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2545236"></a> [2545236](#2545236) <a name="2545236"></a> <br />CM-27096 | On the Edgecore AS6812 switch, you might see rare I2C errors. | 3.7.2-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545133"></a> [2545133](#2545133) <a name="2545133"></a> <br />CM-27025 | On the Mellanox switch, ACL lookups are performed for VLAN matches when no rules with <code>UNTAGGED</code> match are present. | 3.7.2-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545027"></a> [2545027](#2545027) <a name="2545027"></a> <br />CM-26954 | In the default VRF, VRRP might crash and stay in an initialize state. As a result, VRRP multicast traffic is not generated. | 3.7.8-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544937"></a> [2544937](#2544937) <a name="2544937"></a> <br />CM-26894 | The <code>neighmgrd</code> service does not ignore neighbors on reserved devices (lo and management devices).  This issue is not seen when management VRF is enabled. | 3.7.8-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2544847"></a> [2544847](#2544847) <a name="2544847"></a> <br />CM-26838 | You might experience a <code>bgpd</code> memory usage increase and significant update exchanges due to host moves between VTEPs. | 3.7.7-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544829"></a> [2544829](#2544829) <a name="2544829"></a> <br />CM-26829 | Frames received with a VLAN tag of 0 on an interface configured as a bridge port and forwarded to the CPU for processing might appear tagged with the native VLAN when viewed with <code>tcpdump</code>.  | 3.7.8-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544723"></a> [2544723](#2544723) <a name="2544723"></a> <br />CM-26769 | Setting ProtoDown on ports populated with SFP modules providing RJ-45 1000BASE-T interfaces does not cause the carrier to be dropped. The kernel shows carrier down; however, the remote device still shows a link. | 3.7.6-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2544609"></a> [2544609](#2544609) <a name="2544609"></a> <br />CM-26691 | BGP is configured with soft reconfiguration-in for its peers, which is not working correctly and causes routes to have an unexpected label. As a result, transit traffic is not forwarded by the switch. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544559"></a> [2544559](#2544559) <a name="2544559"></a> <br />CM-26657 | When you install a large number of new rules with nonatomic mode enabled, there is a chance that you install more rules than the number of available slots in the slice, which results in the slice being completely wiped and reinstalled. This causes a large drop increase, including to cpu0, and might cause a major outage by dropping all BGP sessions. | 3.7.8-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544401"></a> [2544401](#2544401) <a name="2544401"></a> <br />CM-26566 | Package: openssl<br />CVE ID:  CVE-2019-1547 CVE-2019-1549 CVE-2019-1563<br />Three security issues were discovered in OpenSSL: A timing attack against<br />ECDSA, a padding oracle in PKCS7_dataDecode() and CMS_decrypt_set1_pkey()<br />and it was discovered that a feature of the random number generator (RNG)<br />intended to protect against shared RNG state between parent and child<br />processes in the event of a fork() syscall was not used by default.<br />Fixed version: 1.1.1d-0+deb10u1<br />We recommend that you upgrade your openssl packages.<br />For the detailed security status of openssl,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/openssl | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544385"></a> [2544385](#2544385) <a name="2544385"></a> <br />CM-26556 | The QCT QuantaMesh BMS T7032-IX7 switch may report "failed to request GPIO pin"   errors during the boot up.  | 3.7.5-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544324"></a> [2544324](#2544324) <a name="2544324"></a> <br />CM-26523 | Package: hostapd<br />CVE ID: CVE-2019-13377 CVE-2019-16275<br />Two vulnerabilities were found in the WPA protocol implementation found in wpa_supplication (station) and hostapd (access point).<br />CVE-2019-13377<br />A timing-based side-channel attack against WPA3's Dragonfly handshake when using Brainpool curves could be used by an attacker to retrieve the password.<br />CVE-2019-16275<br />Insufficient source address validation for some received Management frames in hostapd could lead to a denial of service for stations associated to an access point. An attacker in radio range of the access point could inject a specially constructed unauthenticated IEEE 802.11 frame to the access point to cause associated stations to be disconnected and require a reconnection to the network.<br />Fixed version: 1:2.8.0-cl4u3 | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544213"></a> [2544213](#2544213) <a name="2544213"></a> <br />CM-26450 | Cumulus Linux poed generates excessive debug log entries.  These will be reduced in a future release. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544012"></a> [2544012](#2544012) <a name="2544012"></a> <br />CM-26351 | After you remove a subinterface, the BGP session stays in a Connect state. | 3.7.8-3.7.11 | 3.7.12-3.7.14.2|
| <a name="2543937"></a> [2543937](#2543937) <a name="2543937"></a> <br />CM-26308 | An interface alias configured outside FRR using <code>iproute2</code> is imported into the FRR running configuration and overrides the internal description. After an FRR reload, this causes FRR to delete the interface alias in an inefficient way. Depending on how many interfaces with aliases you have configured, this can cause a FRR reload to time out.<br />To work around this issue, remove the interface alias description from <code>iproute2</code>. | 3.7.8-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543900"></a> [2543900](#2543900) <a name="2543900"></a> <br />CM-26288 | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543875"></a> [2543875](#2543875) <a name="2543875"></a> <br />CM-26272 | On the Mellanox Spectrum switch, a route withdrawal might cause the associated next hop neighbor entry to be deleted in hardware but remain in the kernel. This can cause traffic going through the directly connected route to the removed neighbor entry to be forwarded to the CPU. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543841"></a> [2543841](#2543841) <a name="2543841"></a> <br />CM-26256 | The <code>net show evpn vni detail json</code> command includes an extra empty dictionary at the end of the output. <br /> | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543840"></a> [2543840](#2543840) <a name="2543840"></a> <br />CM-26255 | On the Mellanox SN2700 switch, you cannot enable resilient hashing (RASH) and set the bucket size to 64 in the <code>traffic.conf</code> file.<br /><br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2543835"></a> [2543835](#2543835) <a name="2543835"></a> <br />CM-26252 | The following CVEs were announced that affect the ghostscript package:<br />CVE ID : CVE-2019-14811 CVE-2019-14812 CVE-2019-14813 CVE-2019-14817<br />It was discovered that various procedures in Ghostscript, the GPL PostScript/PDF interpreter, do not properly restrict privileged calls, which could result in bypass of file system restrictions of the dSAFER sandbox.<br />We recommend that you upgrade your ghostscript packages.<br />For the detailed security status of ghostscript, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/ghostscript | 3.7.0-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2543816"></a> [2543816](#2543816) <a name="2543816"></a> <br />CM-26241 | On the Dell S5248F-ON switch, <code>smond</code> might generate syslog messages indicating that the fan input RPM is lower than the normal low speed of 2500 RPM. Speeds as low as 1700 RPM are acceptable in normal thermal environments; therefore, you can ignore these messages.<br /> | 3.7.6-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2543800"></a> [2543800](#2543800) <a name="2543800"></a> <br />CM-26230 | When <code>local-tunnelip</code> is an SVI, the static VXLAN tunnel does not work; the next hop router receives the packet but drops it as it does not know where to forward the packet. The static VXLAN tunnel does works if <code>local-tunnelip</code> is a loopback or a physical layer 3 interface. <br /> | 3.7.8-3.7.14 | 4.0.0-4.3.0|
| <a name="2543781"></a> [2543781](#2543781) <a name="2543781"></a> <br />CM-26217 | NCLU does not allow you to configure OSPF NSSAs. For example: <br /><pre><br />cumulus&#64;switch:~$ net add ospf area 0.0.0.1 nssa <br />ERROR: Command not found. <br />net add ospf area 0.0.0.1 nssa<br /></pre><br />To work around this issue, use FRR instead. For example: <br /><pre><br />switch# configure terminal <br />switch(config)# router ospf <br />switch(config-router)# area 0.0.0.1 nssa <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543727"></a> [2543727](#2543727) <a name="2543727"></a> <br />CM-26181 | ACL rules, such as the following, fail to install if you use swp+ (interfaces mentioned as wildcards).<br /><pre><br />-A FORWARD -i swp+ -j LOG<br />-A FORWARD -i swp+ -j DROP<br /></pre><br />You can now install such rules with swp+. | 3.7.3-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543724"></a> [2543724](#2543724) <a name="2543724"></a> <br />CM-26179 | If a hostname contains utf-8 characters, the NCLU <code>net show lldp</code> command outputs the following error: <br /><pre><br />ERROR: 'ascii' codec can't encode character u'\xe9' in position 3: ordinal not in range(128) <br />See /var/log/netd.log for more details.  <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543690"></a> [2543690](#2543690) <a name="2543690"></a> <br />CM-26158 | On the Mellanox switch, UFT profiles are unable to support the documented capacity for routes to addresses that are more than 64 bits in length. The listed capacities assume 64-bit destination IP addresses. | 3.7.8-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2543668"></a> [2543668](#2543668) <a name="2543668"></a> <br />CM-26147 | On the EdgeCore AS4610 switch, the <code>ping</code> command fails unless you run the command with <code>sudo</code>. <br /> To work around this issue, run the following commands: <br /><pre><br /> cumulus&#64;switch:~$ sudo setcap cap_net_raw+ep /usr/share/mgmt-vrf/bin/ping <br /> cumulus&#64;switch:~$ sudo setcap cap_net_raw+ep /usr/share/mgmt-vrf/bin/ping6<br /></pre><br /> Run the following command to verify the workaround: <br /> <pre> <br /> cumulus&#64;switch:~$ getcap /usr/share/mgmt-vrf/bin/ping* <br /> </pre> <br /> You should see the following output: <br /> <pre> <br /> /usr/share/mgmt-vrf/bin/ping = cap_net_raw+ep <br /> /usr/share/mgmt-vrf/bin/ping6 = cap_net_raw+ep <br /> </pre> <br />  | 3.7.6-3.7.10, 4.1.0-4.1.1 | 3.7.11-3.7.14, 4.2.0-4.3.0|
| <a name="2543665"></a> [2543665](#2543665) <a name="2543665"></a> <br />CM-26146 | <code>clagd</code> memory consumption increases under certain unknown conditions. <br /> | 3.7.8-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543649"></a> [2543649](#2543649) <a name="2543649"></a> <br />CM-26138 | You cannot specify a source and destination MAC address in an ERSPAN ebtables rule. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i swp5 -s 00:25:90:b2:bd:9d -d 50:6b:4b:96:c4:04 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | 4.3.0|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543627"></a> [2543627](#2543627) <a name="2543627"></a> <br />CM-26126 | Tomahawk 40G DACs cannot disable auto-negotiation. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543546"></a> [2543546](#2543546) <a name="2543546"></a> <br />CM-26073 | <code>{watchfrr</code> calls <code>sudo /usr/sbin/service frr restart bgpd</code> but restarts all FRR daemons which can cause a large outage. This occurs because <code>watchfrr</code> uses an old style service command, which causes all daemons to restart when a daemon fails.  | 3.7.7-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2543472"></a> [2543472](#2543472) <a name="2543472"></a> <br />CM-26024 | On switches with the Spectrum ASIC, the underlay hashes VXLAN packets for a given overlay flow randomly.<br />To work around this issue, configure the ECMP hash seed to the same value on the EVPN egress leaf switches. | 3.7.7-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543469"></a> [2543469](#2543469) <a name="2543469"></a> <br />CM-26022 | When using the UFT lpm-equal profile, IPv6 routes are limited to 16K.  | 3.7.8 | 3.7.9-3.7.14.2|
| <a name="2543389"></a> [2543389](#2543389) <a name="2543389"></a> <br />CM-25979 | Dynamic route-leaking works as expected until FRR is restarted or the switch is rebooted. After the restart or reboot, the import RT under the VRF where routes are being imported is incorrect. | 3.7.7-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2543374"></a> [2543374](#2543374) <a name="2543374"></a> <br />CM-25973 | After a remote VTEP peer link goes down, the tunnel destination IP address might be incorrect in hardware, which might cause loss of overlay communication between VTEPs. | 3.7.8-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543325"></a> [2543325](#2543325) <a name="2543325"></a> <br />CM-25955 | Lenovo switches do not send or receive LLDP on eth0 interfaces. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543270"></a> [2543270](#2543270) <a name="2543270"></a> <br />CM-25923 | The default route injected through OSPF when you configure <code>default-information originate always</code> is unreliable and might age out unexpectedly.<br />To work around this issue, rely on a different source of default route other than injection with <code>default-information originate</code>. | 3.7.8-4.1.1 | 4.2.0-4.3.0|
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543113"></a> [2543113](#2543113) <a name="2543113"></a> <br />CM-25824 | NCLU restarts FRR when attempting to remove a BGP VRF stanza. This happens regardless of whether the VRF is valid/configured elsewhere on the switch or the removal is successful. To work around this issue, remove the stanza using vtysh. <br /> | 3.7.3-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543058"></a> [2543058](#2543058) <a name="2543058"></a> <br />CM-25798 | The IP neighbor entry for a link-local next hop is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces.<br />To work around this issue, flap the peering to the peer router (which might be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543052"></a> [2543052](#2543052) <a name="2543052"></a> <br />CM-25796 | Received EVPN type-5 and type-2 MACIP routes are not installed in the kernel (and hardware) routing tables for the associated VRF, which causes traffic to be blackholed. The failure to install the default route causes complete reachability failure for the particular tenant on the affected racks. The routes that are not installed are seen as "inactive" in the routing subsystem (FRR) VRF routing table. This problem is rare and can occur only in EVPN configurations that have user-configured route targets (RTs) for tenant VRFs, and only following a restart of FRR.<br />To work around this issue, either restart the FRR service on the affected switch with the <code>sudo systemctl restart frr.service</code> command or bounce the layer 3 SVI for the affected VRF; for example:<br /><pre><br />ifdown vlan123 ; sleep 2 ; ifup vlan123<br /></pre><br />You can run the <code>net show vrf vni</code> command to print a mapping of VRF : L3-VNI : L3-SVI. | 3.7.5-3.7.14 | 4.0.0-4.3.0|
| <a name="2543044"></a> [2543044](#2543044) <a name="2543044"></a> <br />CM-25794 | Under certain conditions, EVPN next hops might not be removed when the contributing peer goes down or might not be populated when the BGP session to the contributing peer comes up.<br />You can prevent EVPN next hops from not being removed when the contributing peer goes down by specifying static MAC addresses on all layer 3 VNIs. There is no workaround for preventing EVPN next hops from not being populated when the BGP session to the contributing peer comes up. | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2543004"></a> [2543004](#2543004) <a name="2543004"></a> <br />CM-25783 | Cumulus Linux installer images have a shell script that validates checksum integrity. When you run <code>onie-install</code>, this check is run but the installer is still staged even if the checksum validation fails. <br />To work around this issue, perform your own checksum validation before staging a new image with <code>onie-install</code>.  | 3.7.7-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542985"></a> [2542985](#2542985) <a name="2542985"></a> <br />CM-25770 | On a Tomahawk switch, the 5m 40G DACs (40G CR4) do not come up when both sides have auto-negotiation enabled. | 3.7.7-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542979"></a> [2542979](#2542979) <a name="2542979"></a> <br />CM-25766 | On the Dell-N3048EP-ON switch, when you run the <code>sudo -E apt upgrade</code> command, the upgrade does not work.  | 3.7.7-4.1.1 | 4.2.0-4.3.0|
| <a name="2542958"></a> [2542958](#2542958) <a name="2542958"></a> <br />CM-25747 | When transitioning from a down state to an up state due to peerlink failure and recovery, MLAG does not start the initDelay timer before trying to bring everything back up. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542939"></a> [2542939](#2542939) <a name="2542939"></a> <br />CM-25735 | When MLAG is re-establishing its peering after a member reboot, the VNIs on the peer briefly go into a protodown state. This can cause complete downtime to dually connected hosts as the member coming back up is still in <code>initDelay</code>. This issue does resolve itself as the VNIs do come back up within ten seconds.  | 3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542913"></a> [2542913](#2542913) <a name="2542913"></a> <br />CM-25718 | IF-MIB::ifHCInOctets reports significantly lower values than reported by interface counters seen elsewhere. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542872"></a> [2542872](#2542872) <a name="2542872"></a> <br />CM-25693 | After you issue the NCLU <code>net del bgp vrf <vrf> autonomous-system <AS></code> command and commit the change, Cumulus Linux does not remove the configuration from the <code>/etc/frr/frr.conf</code> file or the <code>net show config commands</code>. <br /> | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2542853"></a> [2542853](#2542853) <a name="2542853"></a> <br />CM-25684 | For interfaces configured with RS FEC, when <code>switchd</code> is restarted, the link goes down but does not automatically come back up. This occurs because the FEC status is not replayed correctly into the kernel. <br />To work around this issue, run the <code>ifreload -a</code> command to bring up the interface after <code>switchd</code> is restarted.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542837"></a> [2542837](#2542837) <a name="2542837"></a> <br />CM-25674 | On Mellanox switches, policer iptables are not working as expected. For example, when using a policer with mode KB/MB/GB to rate-limit interfaces, the syntax is accepted but the data plane transfer speed is not affected by the rule.  | 3.7.6-3.7.8, 4.0.0-4.3.0 | 3.7.9-3.7.14|
| <a name="2542835"></a> [2542835](#2542835) <a name="2542835"></a> <br />CM-25672 | <code>snmpd</code> fails because NCLU does not remove <code>agentaddress &#64;vrf</code> lines when running the <code>net add snmp-server listening-address all</code> command. | 3.7.4-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542824"></a> [2542824](#2542824) <a name="2542824"></a> <br />CM-25665 | On the Broadcom Trident 3 switch, VXLAN encapsulated packets are dropped on the ingress port (tagged layer 2 port) during transit forwarding (the local switch does not terminate the VXLAN tunnel). An example of where this two-layer VXLAN inside VXLAN encapsulation might occur:<br />- VXLAN tunnel (#1) between two servers (different racks) to provide layer 2 extension for containers or VM hosts.<br />- VXLAN tunnel (#2) between the TOR switch in rack 1 to the TOR switch located in the remote rack. <br /><br />To work around this issue, either:<br />- Configure the edge port (facing the servers) to be an access port (instead of a trunk/tagged port)<br />- Change the destination port from 4789 to something else (VXLAN tunnel terminated by the servers) | 3.7.5-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2542820"></a> [2542820](#2542820) <a name="2542820"></a> <br />CM-25664 | On the Trident3 platform, you can only add 50 percent of the total ECMP next hops. A log message indicates that the table is full.  | 3.7.7-3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542774"></a> [2542774](#2542774) <a name="2542774"></a> <br />CM-25646 | When moving an IP address from the address line to <code>inet dhcp</code>, then issuing the <code>ifreload -a</code> command, the old address is not removed from the interface. NCLU still reports the old address only and reports it as a DHCP address.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542767"></a> [2542767](#2542767) <a name="2542767"></a> <br />CM-25641 | If the BMC operating system fails to respond to IPMI, you see a traceback in <code>bmcd</code> and all the sensors might report ABSENT devices in <code>smonctl</code>. <br />To work around this issue, power cycle the switch. <br />  | 3.7.6-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2542765"></a> [2542765](#2542765) <a name="2542765"></a> <br />CM-25640 | When you configure the switch to send an EAP request with the <code>net add dot1x send-eap-request-id</code> command, the switch ignores re-authentication attempts and does not send back an EAPol. <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2542726"></a> [2542726](#2542726) <a name="2542726"></a> <br />CM-25619 | After configuring <code>switchd hal.bcm.per_vlan_router_mac_lookup</code> to TRUE on a Broadcom switch,  layer 2 traffic works over VXLAN but the host is not able to ping the locally connected gateway and loses routing ability to other IPs and subnets.  | 3.7.5-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542711"></a> [2542711](#2542711) <a name="2542711"></a> <br />CM-25610 | BGP update packets are sometimes missing the mandatory <code>nexthop</code> attribute, which causes connections to reset. For example, this issue is seen when using VRF route leaking with a mix of BGP unnumbered and BGP numbered peers.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542510"></a> [2542510](#2542510) <a name="2542510"></a> <br />CM-25505 | In EVPN symmetric or centralized configurations with BGP peering over a peer link, VXLAN routed packets transiting an MLAG peer are dropped until the <code>clagd</code> <code>init-delay</code> timer expires during the bring-up sequence following a reboot.<br />The problem is caused by a race condition when programming the anycast IP address (used to terminate VXLAN tunnels), where the hardware is programmed before the software by <code>clagd</code>.<br />To work around this issue, configure the BGP path across the peer link to be less preferred. The example below uses AS path prepending and the MLAG switches are iBGP neighbors. However, other BGP configurations achieve the same result. <br />In the <code>/etc/frr/frr.conf</code> file, make a new AS path access list and route map to apply BGP pre-pending of the local ASN one or more times. For example: <br /><pre> <br />ip as-path access-list MY_ASN permit ^$ <br /><br />route-map peerlink-add-asn permit 10 <br />match as-path MY_ASN <br />set as-path prepend 4200000101 <br />route-map peerlink-add-asn permit 20 <br /></pre>  | 3.7.6-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2542480"></a> [2542480](#2542480) <a name="2542480"></a> <br />CM-25489 | When BGP <code>remove-private-AS replace-AS</code> is configured under the BGP IPv4 or IPv6 address family between a pair of switches configured as BGP peers, a BGP route update might cause the BGP session to flap. <br />To work around this issue, do not configure <code>remove-private-AS replace-AS</code> in the BGP IPv4 or IPv6 address family. | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542384"></a> [2542384](#2542384) <a name="2542384"></a> <br />CM-25447 | When you define a trap destination using &#64;mgmt, <code>snmpd</code> indicates that the network is unreachable even though the IP address is reachable in the management VRF. <br />To work around this issue, remove <code>&#64;mgmt vrf</code> references in the <code>/etc/snmp/snmpd.conf</code> file, stop <code>snmpd</code>, then start <code>snmpd</code> manually in the management VRF with the <code>systemctl start snmpd&#64;mgmt</code> command. <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542365"></a> [2542365](#2542365) <a name="2542365"></a> <br />CM-25432 | The <code>snmpd</code> service frequently crashes due to <code>double free or corruption</code>.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542341"></a> [2542341](#2542341) <a name="2542341"></a> <br />CM-25417 | The IP neighbor entry for a link-local next hop (169.254.x.x) is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces. <br />To work around this issue, flap the peering to the peer router (which can be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542336"></a> [2542336](#2542336) <a name="2542336"></a> <br />CM-25414 | On the Mellanox SN2410 switch, <code>switchd</code> does not start.  | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542310"></a> [2542310](#2542310) <a name="2542310"></a> <br />CM-25404 | <code>hsflow</code> disregards the setting for <code>agent.cidr</code> in the <code>/etc/hsflowd.conf</code> file and selects an IPv6 agent address. The source IP address of the hsflowd packet is IPv4, but the agent address in the <code>hsflow</code> payload shows IPv6. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542297"></a> [2542297](#2542297) <a name="2542297"></a> <br />CM-25395 | When you run the NCLU <code>net del all</code> command, the <code>exec-timeout</code> setting changes in the <code>/etc/frr.frr.conf</code> file.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542248"></a> [2542248](#2542248) <a name="2542248"></a> <br />CM-25376 | When you generate a cl-support file, <code>clagd.service</code> prints log messages similar to the following: <br /><pre> <br />019-03-21T07:18:15.727581+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - start <br />2019-03-21T07:18:15.728157+00:00 leaf01 clagd&#91;20912&#93;: #012thread: CollectSysInfo (140608446367488) <br />2019-03-21T07:18:15.735986+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 783, in __bootstrap <br />2019-03-21T07:18:15.736585+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 810, in __bootstrap_inner <br />2019-03-21T07:18:15.737045+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 763, in run <br />2019-03-21T07:18:15.737933+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 930, in CollectSysInfoT <br />2019-03-21T07:18:15.739527+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 187, in CollectSysInfo <br />2019-03-21T07:18:15.740540+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 621, in wait <br />2019-03-21T07:18:15.742293+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/dist-packages/clag/clagthread.py, line 48, in wait <br />. <br />. <br />2019-03-21T07:18:16.456061+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - end <br /></pre> <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542193"></a> [2542193](#2542193) <a name="2542193"></a> <br />CM-25358 | When you configure the <code>link-down yes</code> attribute to a physical SVI, the VRR (-v0) interface is not brought down, and the locally-connected subnet can still be redistributed into routing protocols and advertised to neighbors despite the physical SVI being administratively down. <br />To work around this issue, manually bring down the VRR (-v0) interface with the <code>ip link set dev</code> command. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo ip link set dev vlan1755-v0 down <br /></pre>  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542160"></a> [2542160](#2542160) <a name="2542160"></a> <br />CM-25343 | The following CVEs were announced in Debian Security Advisory DSA-4465-1 and affect the linux kernel. <br />------------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4465-1 security&#64;debian.org <br />https://www.debian.org/security/ Salvatore Bonaccorso <br />June 17, 2019 https://www.debian.org/security/faq <br />------------------------------------------------------------------------------------------- <br />Package: linux <br />CVE ID: CVE-2019-3846 CVE-2019-5489 CVE-2019-9500 CVE-2019-9503 CVE-2019-10126 CVE-2019-11477 <br />CVE-2019-11478 CVE-2019-11479 CVE-2019-11486 CVE-2019-11599 CVE-2019-11815 CVE-2019-11833 CVE-2019-11884 <br />Debian Bug: 928989 <br />Several vulnerabilities have been discovered in the Linux kernel that may lead to a privilege escalation, denial of service or <br />information leaks. <br />CVE-2019-3846, CVE-2019-10126 <br />huangwen reported multiple buffer overflows in the Marvell wifi (mwifiex) driver, which a local user could use to cause denial of <br />service or the execution of arbitrary code. <br />CVE-2019-5489 <br />Daniel Gruss, Erik Kraft, Trishita Tiwari, Michael Schwarz, Ari Trachtenberg, Jason Hennessey, Alex Ionescu, and Anders Fogh <br />discovered that local users could use the mincore() system call to obtain sensitive information from other processes that access <br />the same memory-mapped file. <br />CVE-2019-9500, CVE-2019-9503 <br />Hugues Anguelkov discovered a buffer overflow and missing access validation in the Broadcom FullMAC wifi driver (brcmfmac), <br />which a attacker on the same wifi network could use to cause denial of service or the execution of arbitrary code. <br />CVE-2019-11477 <br />Jonathan Looney reported that a specially crafted sequence of TCP selective acknowledgements (SACKs) allows a remotely <br />triggerable kernel panic. <br />CVE-2019-11478 <br />Jonathan Looney reported that a specially crafted sequence of TCP selective acknowledgements (SACKs) will fragment the TCP <br />retransmission queue, allowing an attacker to cause excessive resource usage. <br />CVE-2019-11479 <br />Jonathan Looney reported that an attacker could force the Linux kernel to segment its responses into multiple TCP segments, <br />each of which contains only 8 bytes of data, drastically increasing the bandwidth required to deliver the same amount of data. <br />This update introduces a new sysctl value to control the minimal MSS (net.ipv4.tcp_min_snd_mss), which by default uses the <br />formerly hard-coded value of 48. We recommend raising this to 536 unless you know that your network requires a lower value. <br />CVE-2019-11486 <br />Jann Horn of Google reported numerous race conditions in the Siemens R3964 line discipline. A local user could use these to <br />cause unspecified security impact. This module has therefore been disabled. <br />CVE-2019-11599 <br />Jann Horn of Google reported a race condition in the core dump implementation which could lead to a use-after-free. A local <br />user could use this to read sensitive information, to cause a denial of service (memory corruption), or for privilege escalation. <br />CVE-2019-11815 <br />It was discovered that a use-after-free in the Reliable Datagram Sockets protocol could result in denial of service and potentially <br />privilege escalation. This protocol module (rds) is not auto-loaded on Debian systems, so this issue only affects systems where <br />it is explicitly loaded. <br />CVE-2019-11833 <br />It was discovered that the ext4 filesystem implementation writes uninitialised data from kernel memory to new extent blocks. <br />A local user able to write to an ext4 filesystem and then read the filesystem image, for example using a removable drive, might be <br />able to use this to obtain sensitive information. <br />CVE-2019-11884 <br />It was discovered that the Bluetooth HIDP implementation did not ensure that new connection names were null-terminated. <br />A local user with CAP_NET_ADMIN capability might be able to use this to obtain sensitive information from the kernel stack. <br />For the stable distribution (stretch), these problems have been fixed in version 4.9.168-1+deb9u3. <br />We recommend that you upgrade your linux packages. <br />For the detailed security status of linux, refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/linux | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542058"></a> [2542058](#2542058) <a name="2542058"></a> <br />CM-25295 | The <code>ifquery</code> command should return a non-zero value if there is a syntax error. However, it currently returns zero. This issue affects automation scripts that validate a file before copying it into place. | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542032"></a> [2542032](#2542032) <a name="2542032"></a> <br />CM-25284 | If you configure a <code>sys-mac</code> with a single digit, <code>ifreload -a</code> does not indicate that the MAC address is invalid for the MLAG sys-mac and the <code>clagd</code> process fails silently.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2541924"></a> [2541924](#2541924) <a name="2541924"></a> <br />CM-25240 | If the <code>address-virtual</code> MAC address is missing a leading zero in the last octet, the interface bounces. | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2541604"></a> [2541604](#2541604) <a name="2541604"></a> <br />CM-25079 | The <code>snmpd</code> service exits with a message similar to the following: <br /><pre> <br />Error in '/usr/sbin/snmpd': double free or corruption (fasttop): 0x00000000018a4e50 *** <br /></pre> <br />This problem might occur during or after network convergence events. For example, when <code>bgpd</code> needs to process a high number of updates and the CPU cannot keep up, <code>bgpd</code> is disconnected and <code>agentx</code> generates a core dump in <code>snmpd</code> due to a memory allocation problem. <br />To work around this issue, disable <code>agentx</code> by commenting out the following lines in the <code>/etc/snmp/snmpd.conf</code> file. Then, restart the <code>snmpd</code> service with the <code>systemctl restart snmpd</code> command. <br /><pre> <br />agentxperms 777 777 snmp snmp <br />agentxsocket /var/agentx/master <br /></pre> <br />If you still want to poll the BGP4-MIB information, re-enable the <code>bgp pass persist</code> script by adding the following line in the <code>/etc/snmp/snmpd.conf</code> file: <br /><pre> <br />pass_persist 1.3.6.1.2.1.15 /usr/share/snmp/bgp4_pp.py <br /></pre>  | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541165"></a> [2541165](#2541165) <a name="2541165"></a> <br />CM-24878 | On the Dell N3048EP-ON switch, UPOE is supported only on ports 1 thru 12. (UPOE uses all four pairs of standard Ethernet cabling whereas PoE delivers power over two twisted pairs.) When you plug a UPOE device in a port higher than port 12, <code>poectl</code> reports that <code>four_pair_mode_enabled</code> is true. However, this configuration is not supported on the port so <code>poectl</code> should report that <code>four_pair_mode_enabled</code> is false. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541005"></a> [2541005](#2541005) <a name="2541005"></a> <br />CM-24784 | NCLU is unable to delete a BGP neighbor configuration if there is a VRF VNI mapping in the <code>/etc/frr/frr.conf</code> file. For example, the following NCLU command produces an error: <br /><pre> <br />cumulus&#64;leaf01$ net del bgp neighbor swp5 interface peer-group spine <br />'router bgp 65001' configuration does not have 'neighbor swp5 interface peer-group spine' <br /></pre>  | 3.7.7-3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2540950"></a> [2540950](#2540950) <a name="2540950"></a> <br />CM-24751 | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switch, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status.<br />  | 3.7.3-4.1.1 | 4.2.0-4.3.0|
| <a name="2540885"></a> [2540885](#2540885) <a name="2540885"></a> <br />CM-24703 | The Dell N3048EP-ON switch does not support 1G Base-T modules in the SFP ports. | 3.7.7-3.7.14.2 | |
| <a name="2540863"></a> [2540863](#2540863) <a name="2540863"></a> <br />CM-24686 | On the EdgeCore AS5812-54X switch, the PSU2 Fan1 fluctuates between OK and LOW. When the fan speed is reported as LOW, the RPM is shown as a negative number. <br /> | 3.7.3-3.7.14 | 4.0.0-4.3.0|
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540685"></a> [2540685](#2540685) <a name="2540685"></a> <br />CM-24593 | On a Dell S5248F (Trident3) switch, packets from switch ports are forwarded to the CPU and are sometimes corrupted. The corruption might result in BGP peerings being down, which can lead to all VXLAN traffic to and from a node to be lost, causing an outage to dually connected hosts in a rack. To work around this issue, restart <code>switchd</code>. | 3.7.3-3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2540601"></a> [2540601](#2540601) <a name="2540601"></a> <br />CM-24544 | If the <code>clagd-vxlan-anycast-ip</code> is removed from the <code>/etc/network/interfaces</code> file (either with the NCLU command or by editing the file manually), MLAG still believes it is present until clagd restarts.  | 3.7.3-3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540359"></a> [2540359](#2540359) <a name="2540359"></a> <br />CM-24440 | <code>bgpd</code> creates a core dump at zclient_send_interface_radv_req. This is an issue with how FRRouting checks next hops and has been pushed upstream to FRRouting. | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539081"></a> [2539081](#2539081) <a name="2539081"></a> <br />CM-23792 | When you delete post-up and pre-down IP peer entries from the <code>etc/network/interfaces</code> file, then run the <code>ifreload</code> command, the IP addresses are not removed and the route remains in the route table. <br />To work around this issue, either delete the IP addresses without the /32 mask component or flush the IP addresses for the interface with the <code>ip addr flush dev <interface></code> command. <br /> | 3.7.0-3.7.14 | 4.0.0-4.3.0|
| <a name="2538875"></a> [2538875](#2538875) <a name="2538875"></a> <br />CM-23696 | IPv6 multicast traffic destined to an unregistered multicast group is flooded to all ports in a bridge despite the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/swichd.conf</code> file. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538741"></a> [2538741](#2538741) <a name="2538741"></a> <br />CM-23652 | The NCLU command <code>net show bridge spanning-tree</code> does not show the MLAG peer link as part of the STP forwarding instance.<br />To work around this issue, use the <code>mstpctl</code> command to confirm the STP status of the port. | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538480"></a> [2538480](#2538480) <a name="2538480"></a> <br />CM-23523 | Modifying the <code>/etc/netd.conf</code> file to set <code>show_linux_command = True</code> does not take effect.  | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2538302"></a> [2538302](#2538302) <a name="2538302"></a> <br />CM-23422 | <code>portwd</code> allows an error to change the module type based on the error. For example, a bad write to a module might cause the module type to flap, which causes the link itself to flap. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538257"></a> [2538257](#2538257) <a name="2538257"></a> <br />CM-23398 | The following CVEs were announced in Debian Security Advisory DSA-4359-1 and affect the wireshark packages, some of which are available for optional installation on Cumulus Linux:<br />CVE ID: CVE-2018-12086 CVE-2018-18225 CVE-2018-18226 CVE-2018-18227 CVE-2018-19622 CVE-2018-19623 CVE-2018-19624 CVE-2018-19625 CVE-2018-19626 CVE-2018-19627 CVE-2018-19628 <br />All CVEs except for CVE-2018-12086 are fixed in Cumulus Linux 3.7.9.<br />Packages: libwireshark5, libwireshark-data, libwiretap8, libwscodecs2, libwsutil9, tshark, wireshark, wireshark-common, wireshark-doc<br />These problems have been fixed in version 1.12.1+g01b65bf-4+deb8u19<br />We recommend that you upgrade your wireshark packages.<br />For the detailed security status of wireshark, refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/wireshark | 3.7.8 | 3.7.9-3.7.14.2|
| <a name="2538256"></a> [2538256](#2538256) <a name="2538256"></a> <br />CM-23397 | On the Broadcom switch, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets. <br />  | 3.7.2-4.0.1 | 4.1.0-4.3.0|
| <a name="2538022"></a> [2538022](#2538022) <a name="2538022"></a> <br />CM-23285 | When you remove an interface from a bridge and add it to a VRF in the same commit/ifreload, the IPv6 link-local address is not created automatically. <br />To work around this issue, do the change in two separate commits. First, remove the interface from the bridge, which causes it to be a layer 2 interface. Then, enslave the interface to the VRF.  | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2537820"></a> [2537820](#2537820) <a name="2537820"></a> <br />CM-23123 | When you enable FEC (RS or BaseR) on an interface, removing the configuration from that interface does not revert the FEC status to off/none. <br /> | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537544"></a> [2537544](#2537544) <a name="2537544"></a> <br />CM-23021 | When you run the <code>mstpctl</code> command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of <code>mstpctl</code>; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | 4.3.0|
| <a name="2537536"></a> [2537536](#2537536) <a name="2537536"></a> <br />CM-23016 | When FRR restarts, <code>snmp&#91;err&#93; dev/kmem: Permission denied</code> error messages are recorded in the log file and SNMPd might crash periodically. | 3.7.5-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2537514"></a> [2537514](#2537514) <a name="2537514"></a> <br />CM-23004 | The local fallback account authenticates using the local password when the RADIUS or TACACS service is up. The expected behavior is for this to fail and only succeed when the RADIUS OR TACACS server fails to respond. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537378"></a> [2537378](#2537378) <a name="2537378"></a> <br />CM-22937 | NCLU SNMPv3 user configuration (add, delete, modify) does not complete. Changes are made to the <code>/etc/snmp/snmpd.conf</code> file but the SNMPv3 user cache file <code>/var/lib/snmp/snmpd.conf</code> fails to update correctly and the configuration does not reflect in operation. <br />To work around this issue, stop <code>snmpd</code>, remove the cache file, then restart <code>snmpd</code>. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537188"></a> [2537188](#2537188) <a name="2537188"></a> <br />CM-22849 | When an event in the network, such as a <code>switchd</code> or networking service restart, leads to an OVSDB server high availability transition, an <code>ovs-vtepd</code> core might occur. <br />This core generation has no effect on the functionality of high availability when the active OVSDB server is back in the network. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2537153"></a> [2537153](#2537153) <a name="2537153"></a> <br />CM-22834 | In rare cases, certain IPv6 BGP peers fail to reestablish after <code>switchd</code> restarts. | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2537104"></a> [2537104](#2537104) <a name="2537104"></a> <br />CM-22808 | When you try to stop <code>hsflowd</code> on the Trident II+ switch with the <code>systemctl stop hsflowd</code> command, the process hangs until you stop it with <code>SIGKILL</code>. <br /> | 3.7.1-3.7.14 | 4.0.0-4.3.0|
| <a name="2537061"></a> [2537061](#2537061) <a name="2537061"></a> <br />CM-22794 | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent. <br /> | 3.7.1-4.0.1 | 4.1.0-4.3.0|
| <a name="2536651"></a> [2536651](#2536651) <a name="2536651"></a> <br />CM-22608 | Mellanox Spectrum and Helix4 switches occasionally send malformed packets and do not send any flow samples (only counters). <br />While this issue is fixed for switches with the Spectrum ASIC, this is a &#91;known limitation\|https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Network-Troubleshooting/Monitoring-System-Statistics-and-Network-Traffic-with-sFlow/#caveats-and-errata&#93; on this Helix4 platform. | 3.7.0-3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2536639"></a> [2536639](#2536639) <a name="2536639"></a> <br />CM-22605 | On a Dell S4048 switch, when you set the eth0 speed to 100, either with NCLU or by editing the <code>/etc/network/interfaces</code> file, the <code>igb</code> driver crashes, which brings down eth0. <br />To work around this issue: <br />* If eth0 is configured in the management VRF, power cycle the switch; the eth0 configuration fails and reverts back to the default (auto-negotiation/1000). <br />* If eth0 is configured in the default VRF and you power cycle after the crash, <code>igb</code> continues to crash on boot up (before getting to login prompt); power-cycle the switch, select the Advanced option in GRUB to boot to recovery mode, then modify the <code>/etc/network/interfaces</code> file. | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2536617"></a> [2536617](#2536617) <a name="2536617"></a> <br />CM-22591 | CVE-2018-5391 (FragmentSmack) is a network vulnerability where an attacker can trigger time and calculation expensive fragment reassembly with specially crafted packets, leading to a denial of service. On a Cumulus Linux switch, the impact is limited to control plane and management plane traffic. Any control plane traffic coming in the front panel ports will be limited by existing policer ACLs.<br />To work around this issue, create a file called <code>/etc/sysctl.d/ip.conf</code> and add these settings:<br /><pre><br />net.ipv4.ipfrag_low_thresh = 196608<br />net.ipv6.ip6frag_low_thresh = 196608<br />net.ipv4.ipfrag_high_thresh = 262144<br />net.ipv6.ip6frag_high_thresh = 262144<br /></pre> | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2536608"></a> [2536608](#2536608) <a name="2536608"></a> <br />CM-22583 | Single tagged ARP requests received on a QinQ-over-VXLAN access port are dropped if ARP suppression is enabled on an unrelated VNI. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2536559"></a> [2536559](#2536559) <a name="2536559"></a> <br />CM-22538 | When deleting an interface using NCLU, if the <code>/etc/network/interfaces</code> alias is different than the <code>/etc/frr/frr.conf</code> description, the <code>net commit</code> command returns the following error: <br /><pre><br /> /etc/frr/daemons was modified by another user.<br /></pre><br />Despite this error, the change is made and the description is removed from the <code>frr.conf</code> file.  | 3.7.3-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536231"></a> [2536231](#2536231) <a name="2536231"></a> <br />CM-22277 | On the Broadcom switch with the Trident3 ASIC, the ECN-CE bit is set by default on transit traffic. This might result in hosts adjusting traffic behavior if they are configured for the ECN feature. <br />In Cumulus Linux 3.7.11, the default behavior changed; the ECN-CE bit is _no longer_ set by default on transit traffic. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on protocol sockets.<br />When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a <code>switchd</code> restart. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535965"></a> [2535965](#2535965) <a name="2535965"></a> <br />CM-22020 | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br />To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535209"></a> [2535209](#2535209) <a name="2535209"></a> <br />CM-21278 | The <code>net show lldp</code> command sometimes shows the port description in the <code>Remote Port</code> field. The <code>net show interface</code> command shows the correct value in the <code>Remote Host</code> field.<br />To work around this issue, use <code>net show interface</code> command for LLDP output when connected to Cisco equipment. | 3.7.5-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2534450"></a> [2534450](#2534450) <a name="2534450"></a> <br />CM-20534 | The default BGP instance must be provisioned and always exist for proper operation of dynamic leaking of routes between VRFs.  | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2528990"></a> [2528990](#2528990) <a name="2528990"></a> <br />CM-15278 | During a link flap test, you might occasionally see a message similar to: <code>warning: swp6: netlink: cannot set link swp6 down: &#91;Errno 98&#93; Address already in use</code>. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|

### Fixed Issues in 3.7.8
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="2543061"></a> [2543061](#2543061) <a name="2543061"></a> <br />CM-25801 | When you run the <code>hostnamectl status</code> command or start the <code>systemd-hostnamed</code> process, you see constant <code>unregister_netdevice</code> kernel messages in syslog and on the console. This causes syslog to become filled with these messages and makes troubleshooting difficult.  | 3.7.7 | |

## 3.7.7 Release Notes
### Open issues in 3.7.7

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552739"></a> [2552739](#2552739) <a name="2552739"></a> <br />CM-31148 | Counters for IPROUTER rules do not increase when traffic is forwarded to the CPU because there is no IP neighbor. | 3.7.2-3.7.14.2 | |
| <a name="2552528"></a> [2552528](#2552528) <a name="2552528"></a> <br />CM-31028 | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2552352"></a> [2552352](#2552352) <a name="2552352"></a> <br />CM-30914 | The following security vulnerabilities have been announced in the nss / libnss3 packages:<br />CVE-2020-6829: Side channel attack on ECDSA signature generation<br />CVE-2020-12400: P-384 and P-521 implementation uses a side-channel vulnerable modular inversion function<br />CVE-2020-12401: ECDSA timing attack mitigation bypass<br />Vulnerable: <= 3.26-1+debu8u11<br />Fixed: 3.26-1+debu8u12 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2552351"></a> [2552351](#2552351) <a name="2552351"></a> <br />CM-30913 | The following vulnerability has been announced in the libx11 packages:<br />CVE-2020-14344: The X Input Method (XIM) client implementation in libX11 has some integer overflows and signed/unsigned comparison issues that can lead to heap corruption when handling malformed messages from an input method.<br />Vulnerable: <= 1.6.2-3+deb8u2<br />Fixed: 1.6.2-3+deb8u3 | 3.7.0-3.7.13 | 3.7.14-3.7.14.2|
| <a name="2551675"></a> [2551675](#2551675) <a name="2551675"></a> <br />CM-30479 | When you restart <code>clagd</code>, the edge port setting on the peer link changes. | 3.7.2-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551288"></a> [2551288](#2551288) <a name="2551288"></a> <br />CM-30286 | When you remove BFD configuration by editing the <code>/etc/frr/frr.conf</code> file and restarting FRR, you see a traceback.<br />To work around this issue, either use NCLU or vtysh commands to remove the BFD configuration, or restart FRR with the new <code>/etc/frr/frr.conf</code> file. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | 4.2.1-4.3.0, 4.3.0|
| <a name="2550323"></a> [2550323](#2550323) <a name="2550323"></a> <br />CM-29807 | After a neighbor is removed, the redistributed neighbor entry is withdrawn from the BGP table, but the prefix might still be selected as the bestpath when the host's originated prefix is not advertised.<br />To work around this issue, recreate the neighbor entry and flap the interface to the host. <br />Or, if the host is already down, manually create a neighbor entry with an invalid MAC address, which forces redistribute neighbor to re-withdraw the entry. | 3.7.3-3.7.12 | 3.7.13-3.7.14.2, 4.0.0-4.3.0|
| <a name="2548475"></a> [2548475](#2548475) <a name="2548475"></a> <br />CM-28932 | After you add a new VNI and a layer 3 SVI to a set of leafs, certain leafs might not be able to communicate on the layer 3 VNI. <br />To work around this issue, reboot the leaf switch or restart <code>switchd</code>. | 3.7.6-3.7.13 | 3.7.14-3.7.14.2, 4.0.0-4.3.0|
| <a name="2548383"></a> [2548383](#2548383) <a name="2548383"></a> <br />CM-28867 | The QuantaMesh BMS T3048-LY8 switch shows a low fan RPM in syslog. | 3.7.5-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2547769"></a> [2547769](#2547769) <a name="2547769"></a> <br />CM-28437 | <code>syslog</code> might report a high load average with the CPU running a later microcode revision. | 3.7.4-3.7.12 | 3.7.13-3.7.14.2|
| <a name="2547013"></a> [2547013](#2547013) <a name="2547013"></a> <br />CM-28016 | On the Mellanox Spectrum switch, <code>switchd</code> can sometimes fail when PBR rules are installed or removed from hardware if the rule is setting a next hop learned via a routing protocol. | 3.7.7-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546999"></a> [2546999](#2546999) <a name="2546999"></a> <br />CM-28007 | When you configure Cumulus Linux with a /32 address on a switch port with a configured peer address (for example, to connect to a device using IP unnumbered), the switch sends GARPs for the peer address. | 3.7.5-3.7.11 | 3.7.12-3.7.14.2, 4.1.0-4.3.0|
| <a name="2546869"></a> [2546869](#2546869) <a name="2546869"></a> <br />CM-27947 | Broadcom Field Alert - SID - MMU 2B Errors<br />A few of the MMU memories on Broadcom switches are grouped together with single parity control. During SER correction when a parity error occurs on one of those groups, other memory in that group might also report a SER error. This occurs when the memory is accessed either by a packet hit or through a schan operation. This issue can cause SER errors in other memory and cause traffic mis-forwarding or a packet drop. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546703"></a> [2546703](#2546703) <a name="2546703"></a> <br />CM-27855 | The FRR cl-support module times out on switches on the ARM platform even when the switch is not under heavy load.<br />To work around this issue, run the <code>cl-support -M</code> command to disable timeouts. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546385"></a> [2546385](#2546385) <a name="2546385"></a> <br />CM-27698 | SNMP ifLastChange reports link transitions when there are none. | 3.7.6-3.7.14.2 | |
| <a name="2545694"></a> [2545694](#2545694) <a name="2545694"></a> <br />CM-27351 | On rare occasions, after rebooting the MLAG secondary switch, one MLAG device might see the peer as down, which can cause traffic disruption to connected hosts. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.1.0-4.3.0|
| <a name="2545600"></a> [2545600](#2545600) <a name="2545600"></a> <br />CM-27295 | IPv6 table rules might affect forwarding. For example, if you create the following rule in the <code>/etc/cumulus/acl/policy.d/03-sshd.rules</code> file, the rule counter increments but IPv4 SSH traffic might be dropped.<br /><pre><br />&#91;ip6tables&#93;<br />-A INPUT -p tcp --dport 22 -j DROP<br /></pre> | 3.7.2-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2545405"></a> [2545405](#2545405) <a name="2545405"></a> <br />CM-27174 | The <code>ospfd</code> daemon might crash with the following kernel trace: <br /><pre><br />2019-11-06T23:00:08.261749+09:00 cumulus ospfd&#91;5339&#93;: Assertion 'node' failed in file ospfd/ospf_packet.c, line 671, function ospf_write<br /></pre> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2545236"></a> [2545236](#2545236) <a name="2545236"></a> <br />CM-27096 | On the Edgecore AS6812 switch, you might see rare I2C errors. | 3.7.2-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545133"></a> [2545133](#2545133) <a name="2545133"></a> <br />CM-27025 | On the Mellanox switch, ACL lookups are performed for VLAN matches when no rules with <code>UNTAGGED</code> match are present. | 3.7.2-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544847"></a> [2544847](#2544847) <a name="2544847"></a> <br />CM-26838 | You might experience a <code>bgpd</code> memory usage increase and significant update exchanges due to host moves between VTEPs. | 3.7.7-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544723"></a> [2544723](#2544723) <a name="2544723"></a> <br />CM-26769 | Setting ProtoDown on ports populated with SFP modules providing RJ-45 1000BASE-T interfaces does not cause the carrier to be dropped. The kernel shows carrier down; however, the remote device still shows a link. | 3.7.6-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2544609"></a> [2544609](#2544609) <a name="2544609"></a> <br />CM-26691 | BGP is configured with soft reconfiguration-in for its peers, which is not working correctly and causes routes to have an unexpected label. As a result, transit traffic is not forwarded by the switch. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544401"></a> [2544401](#2544401) <a name="2544401"></a> <br />CM-26566 | Package: openssl<br />CVE ID:  CVE-2019-1547 CVE-2019-1549 CVE-2019-1563<br />Three security issues were discovered in OpenSSL: A timing attack against<br />ECDSA, a padding oracle in PKCS7_dataDecode() and CMS_decrypt_set1_pkey()<br />and it was discovered that a feature of the random number generator (RNG)<br />intended to protect against shared RNG state between parent and child<br />processes in the event of a fork() syscall was not used by default.<br />Fixed version: 1.1.1d-0+deb10u1<br />We recommend that you upgrade your openssl packages.<br />For the detailed security status of openssl,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/openssl | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544385"></a> [2544385](#2544385) <a name="2544385"></a> <br />CM-26556 | The QCT QuantaMesh BMS T7032-IX7 switch may report "failed to request GPIO pin"   errors during the boot up.  | 3.7.5-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2544324"></a> [2544324](#2544324) <a name="2544324"></a> <br />CM-26523 | Package: hostapd<br />CVE ID: CVE-2019-13377 CVE-2019-16275<br />Two vulnerabilities were found in the WPA protocol implementation found in wpa_supplication (station) and hostapd (access point).<br />CVE-2019-13377<br />A timing-based side-channel attack against WPA3's Dragonfly handshake when using Brainpool curves could be used by an attacker to retrieve the password.<br />CVE-2019-16275<br />Insufficient source address validation for some received Management frames in hostapd could lead to a denial of service for stations associated to an access point. An attacker in radio range of the access point could inject a specially constructed unauthenticated IEEE 802.11 frame to the access point to cause associated stations to be disconnected and require a reconnection to the network.<br />Fixed version: 1:2.8.0-cl4u3 | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544213"></a> [2544213](#2544213) <a name="2544213"></a> <br />CM-26450 | Cumulus Linux poed generates excessive debug log entries.  These will be reduced in a future release. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543875"></a> [2543875](#2543875) <a name="2543875"></a> <br />CM-26272 | On the Mellanox Spectrum switch, a route withdrawal might cause the associated next hop neighbor entry to be deleted in hardware but remain in the kernel. This can cause traffic going through the directly connected route to the removed neighbor entry to be forwarded to the CPU. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543840"></a> [2543840](#2543840) <a name="2543840"></a> <br />CM-26255 | On the Mellanox SN2700 switch, you cannot enable resilient hashing (RASH) and set the bucket size to 64 in the <code>traffic.conf</code> file.<br /><br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2543835"></a> [2543835](#2543835) <a name="2543835"></a> <br />CM-26252 | The following CVEs were announced that affect the ghostscript package:<br />CVE ID : CVE-2019-14811 CVE-2019-14812 CVE-2019-14813 CVE-2019-14817<br />It was discovered that various procedures in Ghostscript, the GPL PostScript/PDF interpreter, do not properly restrict privileged calls, which could result in bypass of file system restrictions of the dSAFER sandbox.<br />We recommend that you upgrade your ghostscript packages.<br />For the detailed security status of ghostscript, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/ghostscript | 3.7.0-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2543816"></a> [2543816](#2543816) <a name="2543816"></a> <br />CM-26241 | On the Dell S5248F-ON switch, <code>smond</code> might generate syslog messages indicating that the fan input RPM is lower than the normal low speed of 2500 RPM. Speeds as low as 1700 RPM are acceptable in normal thermal environments; therefore, you can ignore these messages.<br /> | 3.7.6-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2543781"></a> [2543781](#2543781) <a name="2543781"></a> <br />CM-26217 | NCLU does not allow you to configure OSPF NSSAs. For example: <br /><pre><br />cumulus&#64;switch:~$ net add ospf area 0.0.0.1 nssa <br />ERROR: Command not found. <br />net add ospf area 0.0.0.1 nssa<br /></pre><br />To work around this issue, use FRR instead. For example: <br /><pre><br />switch# configure terminal <br />switch(config)# router ospf <br />switch(config-router)# area 0.0.0.1 nssa <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543727"></a> [2543727](#2543727) <a name="2543727"></a> <br />CM-26181 | ACL rules, such as the following, fail to install if you use swp+ (interfaces mentioned as wildcards).<br /><pre><br />-A FORWARD -i swp+ -j LOG<br />-A FORWARD -i swp+ -j DROP<br /></pre><br />You can now install such rules with swp+. | 3.7.3-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543724"></a> [2543724](#2543724) <a name="2543724"></a> <br />CM-26179 | If a hostname contains utf-8 characters, the NCLU <code>net show lldp</code> command outputs the following error: <br /><pre><br />ERROR: 'ascii' codec can't encode character u'\xe9' in position 3: ordinal not in range(128) <br />See /var/log/netd.log for more details.  <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543668"></a> [2543668](#2543668) <a name="2543668"></a> <br />CM-26147 | On the EdgeCore AS4610 switch, the <code>ping</code> command fails unless you run the command with <code>sudo</code>. <br /> To work around this issue, run the following commands: <br /><pre><br /> cumulus&#64;switch:~$ sudo setcap cap_net_raw+ep /usr/share/mgmt-vrf/bin/ping <br /> cumulus&#64;switch:~$ sudo setcap cap_net_raw+ep /usr/share/mgmt-vrf/bin/ping6<br /></pre><br /> Run the following command to verify the workaround: <br /> <pre> <br /> cumulus&#64;switch:~$ getcap /usr/share/mgmt-vrf/bin/ping* <br /> </pre> <br /> You should see the following output: <br /> <pre> <br /> /usr/share/mgmt-vrf/bin/ping = cap_net_raw+ep <br /> /usr/share/mgmt-vrf/bin/ping6 = cap_net_raw+ep <br /> </pre> <br />  | 3.7.6-3.7.10, 4.1.0-4.1.1 | 3.7.11-3.7.14, 4.2.0-4.3.0|
| <a name="2543649"></a> [2543649](#2543649) <a name="2543649"></a> <br />CM-26138 | You cannot specify a source and destination MAC address in an ERSPAN ebtables rule. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i swp5 -s 00:25:90:b2:bd:9d -d 50:6b:4b:96:c4:04 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | 4.3.0|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543627"></a> [2543627](#2543627) <a name="2543627"></a> <br />CM-26126 | Tomahawk 40G DACs cannot disable auto-negotiation. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543546"></a> [2543546](#2543546) <a name="2543546"></a> <br />CM-26073 | <code>{watchfrr</code> calls <code>sudo /usr/sbin/service frr restart bgpd</code> but restarts all FRR daemons which can cause a large outage. This occurs because <code>watchfrr</code> uses an old style service command, which causes all daemons to restart when a daemon fails.  | 3.7.7-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2543472"></a> [2543472](#2543472) <a name="2543472"></a> <br />CM-26024 | On switches with the Spectrum ASIC, the underlay hashes VXLAN packets for a given overlay flow randomly.<br />To work around this issue, configure the ECMP hash seed to the same value on the EVPN egress leaf switches. | 3.7.7-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543389"></a> [2543389](#2543389) <a name="2543389"></a> <br />CM-25979 | Dynamic route-leaking works as expected until FRR is restarted or the switch is rebooted. After the restart or reboot, the import RT under the VRF where routes are being imported is incorrect. | 3.7.7-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2543325"></a> [2543325](#2543325) <a name="2543325"></a> <br />CM-25955 | Lenovo switches do not send or receive LLDP on eth0 interfaces. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543113"></a> [2543113](#2543113) <a name="2543113"></a> <br />CM-25824 | NCLU restarts FRR when attempting to remove a BGP VRF stanza. This happens regardless of whether the VRF is valid/configured elsewhere on the switch or the removal is successful. To work around this issue, remove the stanza using vtysh. <br /> | 3.7.3-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543061"></a> [2543061](#2543061) <a name="2543061"></a> <br />CM-25801 | When you run the <code>hostnamectl status</code> command or start the <code>systemd-hostnamed</code> process, you see constant <code>unregister_netdevice</code> kernel messages in syslog and on the console. This causes syslog to become filled with these messages and makes troubleshooting difficult.  | 3.7.7 | 3.7.8-3.7.14.2|
| <a name="2543058"></a> [2543058](#2543058) <a name="2543058"></a> <br />CM-25798 | The IP neighbor entry for a link-local next hop is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces.<br />To work around this issue, flap the peering to the peer router (which might be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.14 | 4.0.0-4.3.0|
| <a name="2543052"></a> [2543052](#2543052) <a name="2543052"></a> <br />CM-25796 | Received EVPN type-5 and type-2 MACIP routes are not installed in the kernel (and hardware) routing tables for the associated VRF, which causes traffic to be blackholed. The failure to install the default route causes complete reachability failure for the particular tenant on the affected racks. The routes that are not installed are seen as "inactive" in the routing subsystem (FRR) VRF routing table. This problem is rare and can occur only in EVPN configurations that have user-configured route targets (RTs) for tenant VRFs, and only following a restart of FRR.<br />To work around this issue, either restart the FRR service on the affected switch with the <code>sudo systemctl restart frr.service</code> command or bounce the layer 3 SVI for the affected VRF; for example:<br /><pre><br />ifdown vlan123 ; sleep 2 ; ifup vlan123<br /></pre><br />You can run the <code>net show vrf vni</code> command to print a mapping of VRF : L3-VNI : L3-SVI. | 3.7.5-3.7.14 | 4.0.0-4.3.0|
| <a name="2543044"></a> [2543044](#2543044) <a name="2543044"></a> <br />CM-25794 | Under certain conditions, EVPN next hops might not be removed when the contributing peer goes down or might not be populated when the BGP session to the contributing peer comes up.<br />You can prevent EVPN next hops from not being removed when the contributing peer goes down by specifying static MAC addresses on all layer 3 VNIs. There is no workaround for preventing EVPN next hops from not being populated when the BGP session to the contributing peer comes up. | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2543004"></a> [2543004](#2543004) <a name="2543004"></a> <br />CM-25783 | Cumulus Linux installer images have a shell script that validates checksum integrity. When you run <code>onie-install</code>, this check is run but the installer is still staged even if the checksum validation fails. <br />To work around this issue, perform your own checksum validation before staging a new image with <code>onie-install</code>.  | 3.7.7-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542985"></a> [2542985](#2542985) <a name="2542985"></a> <br />CM-25770 | On a Tomahawk switch, the 5m 40G DACs (40G CR4) do not come up when both sides have auto-negotiation enabled. | 3.7.7-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542979"></a> [2542979](#2542979) <a name="2542979"></a> <br />CM-25766 | On the Dell-N3048EP-ON switch, when you run the <code>sudo -E apt upgrade</code> command, the upgrade does not work.  | 3.7.7-4.1.1 | 4.2.0-4.3.0|
| <a name="2542958"></a> [2542958](#2542958) <a name="2542958"></a> <br />CM-25747 | When transitioning from a down state to an up state due to peerlink failure and recovery, MLAG does not start the initDelay timer before trying to bring everything back up. | 3.7.7-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542913"></a> [2542913](#2542913) <a name="2542913"></a> <br />CM-25718 | IF-MIB::ifHCInOctets reports significantly lower values than reported by interface counters seen elsewhere. | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542872"></a> [2542872](#2542872) <a name="2542872"></a> <br />CM-25693 | After you issue the NCLU <code>net del bgp vrf <vrf> autonomous-system <AS></code> command and commit the change, Cumulus Linux does not remove the configuration from the <code>/etc/frr/frr.conf</code> file or the <code>net show config commands</code>. <br /> | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2542853"></a> [2542853](#2542853) <a name="2542853"></a> <br />CM-25684 | For interfaces configured with RS FEC, when <code>switchd</code> is restarted, the link goes down but does not automatically come back up. This occurs because the FEC status is not replayed correctly into the kernel. <br />To work around this issue, run the <code>ifreload -a</code> command to bring up the interface after <code>switchd</code> is restarted.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542837"></a> [2542837](#2542837) <a name="2542837"></a> <br />CM-25674 | On Mellanox switches, policer iptables are not working as expected. For example, when using a policer with mode KB/MB/GB to rate-limit interfaces, the syntax is accepted but the data plane transfer speed is not affected by the rule.  | 3.7.6-3.7.8, 4.0.0-4.3.0 | 3.7.9-3.7.14|
| <a name="2542835"></a> [2542835](#2542835) <a name="2542835"></a> <br />CM-25672 | <code>snmpd</code> fails because NCLU does not remove <code>agentaddress &#64;vrf</code> lines when running the <code>net add snmp-server listening-address all</code> command. | 3.7.4-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542824"></a> [2542824](#2542824) <a name="2542824"></a> <br />CM-25665 | On the Broadcom Trident 3 switch, VXLAN encapsulated packets are dropped on the ingress port (tagged layer 2 port) during transit forwarding (the local switch does not terminate the VXLAN tunnel). An example of where this two-layer VXLAN inside VXLAN encapsulation might occur:<br />- VXLAN tunnel (#1) between two servers (different racks) to provide layer 2 extension for containers or VM hosts.<br />- VXLAN tunnel (#2) between the TOR switch in rack 1 to the TOR switch located in the remote rack. <br /><br />To work around this issue, either:<br />- Configure the edge port (facing the servers) to be an access port (instead of a trunk/tagged port)<br />- Change the destination port from 4789 to something else (VXLAN tunnel terminated by the servers) | 3.7.5-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2542820"></a> [2542820](#2542820) <a name="2542820"></a> <br />CM-25664 | On the Trident3 platform, you can only add 50 percent of the total ECMP next hops. A log message indicates that the table is full.  | 3.7.7-3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542774"></a> [2542774](#2542774) <a name="2542774"></a> <br />CM-25646 | When moving an IP address from the address line to <code>inet dhcp</code>, then issuing the <code>ifreload -a</code> command, the old address is not removed from the interface. NCLU still reports the old address only and reports it as a DHCP address.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542767"></a> [2542767](#2542767) <a name="2542767"></a> <br />CM-25641 | If the BMC operating system fails to respond to IPMI, you see a traceback in <code>bmcd</code> and all the sensors might report ABSENT devices in <code>smonctl</code>. <br />To work around this issue, power cycle the switch. <br />  | 3.7.6-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2542765"></a> [2542765](#2542765) <a name="2542765"></a> <br />CM-25640 | When you configure the switch to send an EAP request with the <code>net add dot1x send-eap-request-id</code> command, the switch ignores re-authentication attempts and does not send back an EAPol. <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2542726"></a> [2542726](#2542726) <a name="2542726"></a> <br />CM-25619 | After configuring <code>switchd hal.bcm.per_vlan_router_mac_lookup</code> to TRUE on a Broadcom switch,  layer 2 traffic works over VXLAN but the host is not able to ping the locally connected gateway and loses routing ability to other IPs and subnets.  | 3.7.5-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542711"></a> [2542711](#2542711) <a name="2542711"></a> <br />CM-25610 | BGP update packets are sometimes missing the mandatory <code>nexthop</code> attribute, which causes connections to reset. For example, this issue is seen when using VRF route leaking with a mix of BGP unnumbered and BGP numbered peers.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542510"></a> [2542510](#2542510) <a name="2542510"></a> <br />CM-25505 | In EVPN symmetric or centralized configurations with BGP peering over a peer link, VXLAN routed packets transiting an MLAG peer are dropped until the <code>clagd</code> <code>init-delay</code> timer expires during the bring-up sequence following a reboot.<br />The problem is caused by a race condition when programming the anycast IP address (used to terminate VXLAN tunnels), where the hardware is programmed before the software by <code>clagd</code>.<br />To work around this issue, configure the BGP path across the peer link to be less preferred. The example below uses AS path prepending and the MLAG switches are iBGP neighbors. However, other BGP configurations achieve the same result. <br />In the <code>/etc/frr/frr.conf</code> file, make a new AS path access list and route map to apply BGP pre-pending of the local ASN one or more times. For example: <br /><pre> <br />ip as-path access-list MY_ASN permit ^$ <br /><br />route-map peerlink-add-asn permit 10 <br />match as-path MY_ASN <br />set as-path prepend 4200000101 <br />route-map peerlink-add-asn permit 20 <br /></pre>  | 3.7.6-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2542480"></a> [2542480](#2542480) <a name="2542480"></a> <br />CM-25489 | When BGP <code>remove-private-AS replace-AS</code> is configured under the BGP IPv4 or IPv6 address family between a pair of switches configured as BGP peers, a BGP route update might cause the BGP session to flap. <br />To work around this issue, do not configure <code>remove-private-AS replace-AS</code> in the BGP IPv4 or IPv6 address family. | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542384"></a> [2542384](#2542384) <a name="2542384"></a> <br />CM-25447 | When you define a trap destination using &#64;mgmt, <code>snmpd</code> indicates that the network is unreachable even though the IP address is reachable in the management VRF. <br />To work around this issue, remove <code>&#64;mgmt vrf</code> references in the <code>/etc/snmp/snmpd.conf</code> file, stop <code>snmpd</code>, then start <code>snmpd</code> manually in the management VRF with the <code>systemctl start snmpd&#64;mgmt</code> command. <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542365"></a> [2542365](#2542365) <a name="2542365"></a> <br />CM-25432 | The <code>snmpd</code> service frequently crashes due to <code>double free or corruption</code>.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542341"></a> [2542341](#2542341) <a name="2542341"></a> <br />CM-25417 | The IP neighbor entry for a link-local next hop (169.254.x.x) is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces. <br />To work around this issue, flap the peering to the peer router (which can be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542336"></a> [2542336](#2542336) <a name="2542336"></a> <br />CM-25414 | On the Mellanox SN2410 switch, <code>switchd</code> does not start.  | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542310"></a> [2542310](#2542310) <a name="2542310"></a> <br />CM-25404 | <code>hsflow</code> disregards the setting for <code>agent.cidr</code> in the <code>/etc/hsflowd.conf</code> file and selects an IPv6 agent address. The source IP address of the hsflowd packet is IPv4, but the agent address in the <code>hsflow</code> payload shows IPv6. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542297"></a> [2542297](#2542297) <a name="2542297"></a> <br />CM-25395 | When you run the NCLU <code>net del all</code> command, the <code>exec-timeout</code> setting changes in the <code>/etc/frr.frr.conf</code> file.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542248"></a> [2542248](#2542248) <a name="2542248"></a> <br />CM-25376 | When you generate a cl-support file, <code>clagd.service</code> prints log messages similar to the following: <br /><pre> <br />019-03-21T07:18:15.727581+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - start <br />2019-03-21T07:18:15.728157+00:00 leaf01 clagd&#91;20912&#93;: #012thread: CollectSysInfo (140608446367488) <br />2019-03-21T07:18:15.735986+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 783, in __bootstrap <br />2019-03-21T07:18:15.736585+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 810, in __bootstrap_inner <br />2019-03-21T07:18:15.737045+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 763, in run <br />2019-03-21T07:18:15.737933+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 930, in CollectSysInfoT <br />2019-03-21T07:18:15.739527+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 187, in CollectSysInfo <br />2019-03-21T07:18:15.740540+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 621, in wait <br />2019-03-21T07:18:15.742293+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/dist-packages/clag/clagthread.py, line 48, in wait <br />. <br />. <br />2019-03-21T07:18:16.456061+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - end <br /></pre> <br /> | 3.7.6-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2542193"></a> [2542193](#2542193) <a name="2542193"></a> <br />CM-25358 | When you configure the <code>link-down yes</code> attribute to a physical SVI, the VRR (-v0) interface is not brought down, and the locally-connected subnet can still be redistributed into routing protocols and advertised to neighbors despite the physical SVI being administratively down. <br />To work around this issue, manually bring down the VRR (-v0) interface with the <code>ip link set dev</code> command. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo ip link set dev vlan1755-v0 down <br /></pre>  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542160"></a> [2542160](#2542160) <a name="2542160"></a> <br />CM-25343 | The following CVEs were announced in Debian Security Advisory DSA-4465-1 and affect the linux kernel. <br />------------------------------------------------------------------------------------------- <br />Debian Security Advisory DSA-4465-1 security&#64;debian.org <br />https://www.debian.org/security/ Salvatore Bonaccorso <br />June 17, 2019 https://www.debian.org/security/faq <br />------------------------------------------------------------------------------------------- <br />Package: linux <br />CVE ID: CVE-2019-3846 CVE-2019-5489 CVE-2019-9500 CVE-2019-9503 CVE-2019-10126 CVE-2019-11477 <br />CVE-2019-11478 CVE-2019-11479 CVE-2019-11486 CVE-2019-11599 CVE-2019-11815 CVE-2019-11833 CVE-2019-11884 <br />Debian Bug: 928989 <br />Several vulnerabilities have been discovered in the Linux kernel that may lead to a privilege escalation, denial of service or <br />information leaks. <br />CVE-2019-3846, CVE-2019-10126 <br />huangwen reported multiple buffer overflows in the Marvell wifi (mwifiex) driver, which a local user could use to cause denial of <br />service or the execution of arbitrary code. <br />CVE-2019-5489 <br />Daniel Gruss, Erik Kraft, Trishita Tiwari, Michael Schwarz, Ari Trachtenberg, Jason Hennessey, Alex Ionescu, and Anders Fogh <br />discovered that local users could use the mincore() system call to obtain sensitive information from other processes that access <br />the same memory-mapped file. <br />CVE-2019-9500, CVE-2019-9503 <br />Hugues Anguelkov discovered a buffer overflow and missing access validation in the Broadcom FullMAC wifi driver (brcmfmac), <br />which a attacker on the same wifi network could use to cause denial of service or the execution of arbitrary code. <br />CVE-2019-11477 <br />Jonathan Looney reported that a specially crafted sequence of TCP selective acknowledgements (SACKs) allows a remotely <br />triggerable kernel panic. <br />CVE-2019-11478 <br />Jonathan Looney reported that a specially crafted sequence of TCP selective acknowledgements (SACKs) will fragment the TCP <br />retransmission queue, allowing an attacker to cause excessive resource usage. <br />CVE-2019-11479 <br />Jonathan Looney reported that an attacker could force the Linux kernel to segment its responses into multiple TCP segments, <br />each of which contains only 8 bytes of data, drastically increasing the bandwidth required to deliver the same amount of data. <br />This update introduces a new sysctl value to control the minimal MSS (net.ipv4.tcp_min_snd_mss), which by default uses the <br />formerly hard-coded value of 48. We recommend raising this to 536 unless you know that your network requires a lower value. <br />CVE-2019-11486 <br />Jann Horn of Google reported numerous race conditions in the Siemens R3964 line discipline. A local user could use these to <br />cause unspecified security impact. This module has therefore been disabled. <br />CVE-2019-11599 <br />Jann Horn of Google reported a race condition in the core dump implementation which could lead to a use-after-free. A local <br />user could use this to read sensitive information, to cause a denial of service (memory corruption), or for privilege escalation. <br />CVE-2019-11815 <br />It was discovered that a use-after-free in the Reliable Datagram Sockets protocol could result in denial of service and potentially <br />privilege escalation. This protocol module (rds) is not auto-loaded on Debian systems, so this issue only affects systems where <br />it is explicitly loaded. <br />CVE-2019-11833 <br />It was discovered that the ext4 filesystem implementation writes uninitialised data from kernel memory to new extent blocks. <br />A local user able to write to an ext4 filesystem and then read the filesystem image, for example using a removable drive, might be <br />able to use this to obtain sensitive information. <br />CVE-2019-11884 <br />It was discovered that the Bluetooth HIDP implementation did not ensure that new connection names were null-terminated. <br />A local user with CAP_NET_ADMIN capability might be able to use this to obtain sensitive information from the kernel stack. <br />For the stable distribution (stretch), these problems have been fixed in version 4.9.168-1+deb9u3. <br />We recommend that you upgrade your linux packages. <br />For the detailed security status of linux, refer to its security tracker page at: <br />https://security-tracker.debian.org/tracker/linux | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542058"></a> [2542058](#2542058) <a name="2542058"></a> <br />CM-25295 | The <code>ifquery</code> command should return a non-zero value if there is a syntax error. However, it currently returns zero. This issue affects automation scripts that validate a file before copying it into place. | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2542032"></a> [2542032](#2542032) <a name="2542032"></a> <br />CM-25284 | If you configure a <code>sys-mac</code> with a single digit, <code>ifreload -a</code> does not indicate that the MAC address is invalid for the MLAG sys-mac and the <code>clagd</code> process fails silently.  | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2541924"></a> [2541924](#2541924) <a name="2541924"></a> <br />CM-25240 | If the <code>address-virtual</code> MAC address is missing a leading zero in the last octet, the interface bounces. | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2541604"></a> [2541604](#2541604) <a name="2541604"></a> <br />CM-25079 | The <code>snmpd</code> service exits with a message similar to the following: <br /><pre> <br />Error in '/usr/sbin/snmpd': double free or corruption (fasttop): 0x00000000018a4e50 *** <br /></pre> <br />This problem might occur during or after network convergence events. For example, when <code>bgpd</code> needs to process a high number of updates and the CPU cannot keep up, <code>bgpd</code> is disconnected and <code>agentx</code> generates a core dump in <code>snmpd</code> due to a memory allocation problem. <br />To work around this issue, disable <code>agentx</code> by commenting out the following lines in the <code>/etc/snmp/snmpd.conf</code> file. Then, restart the <code>snmpd</code> service with the <code>systemctl restart snmpd</code> command. <br /><pre> <br />agentxperms 777 777 snmp snmp <br />agentxsocket /var/agentx/master <br /></pre> <br />If you still want to poll the BGP4-MIB information, re-enable the <code>bgp pass persist</code> script by adding the following line in the <code>/etc/snmp/snmpd.conf</code> file: <br /><pre> <br />pass_persist 1.3.6.1.2.1.15 /usr/share/snmp/bgp4_pp.py <br /></pre>  | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541165"></a> [2541165](#2541165) <a name="2541165"></a> <br />CM-24878 | On the Dell N3048EP-ON switch, UPOE is supported only on ports 1 thru 12. (UPOE uses all four pairs of standard Ethernet cabling whereas PoE delivers power over two twisted pairs.) When you plug a UPOE device in a port higher than port 12, <code>poectl</code> reports that <code>four_pair_mode_enabled</code> is true. However, this configuration is not supported on the port so <code>poectl</code> should report that <code>four_pair_mode_enabled</code> is false. <br /> | 3.7.6-3.7.14.2 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541005"></a> [2541005](#2541005) <a name="2541005"></a> <br />CM-24784 | NCLU is unable to delete a BGP neighbor configuration if there is a VRF VNI mapping in the <code>/etc/frr/frr.conf</code> file. For example, the following NCLU command produces an error: <br /><pre> <br />cumulus&#64;leaf01$ net del bgp neighbor swp5 interface peer-group spine <br />'router bgp 65001' configuration does not have 'neighbor swp5 interface peer-group spine' <br /></pre>  | 3.7.7-3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2540950"></a> [2540950](#2540950) <a name="2540950"></a> <br />CM-24751 | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switch, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status.<br />  | 3.7.3-4.1.1 | 4.2.0-4.3.0|
| <a name="2540885"></a> [2540885](#2540885) <a name="2540885"></a> <br />CM-24703 | The Dell N3048EP-ON switch does not support 1G Base-T modules in the SFP ports. | 3.7.7-3.7.14.2 | |
| <a name="2540863"></a> [2540863](#2540863) <a name="2540863"></a> <br />CM-24686 | On the EdgeCore AS5812-54X switch, the PSU2 Fan1 fluctuates between OK and LOW. When the fan speed is reported as LOW, the RPM is shown as a negative number. <br /> | 3.7.3-3.7.14 | 4.0.0-4.3.0|
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540685"></a> [2540685](#2540685) <a name="2540685"></a> <br />CM-24593 | On a Dell S5248F (Trident3) switch, packets from switch ports are forwarded to the CPU and are sometimes corrupted. The corruption might result in BGP peerings being down, which can lead to all VXLAN traffic to and from a node to be lost, causing an outage to dually connected hosts in a rack. To work around this issue, restart <code>switchd</code>. | 3.7.3-3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2540601"></a> [2540601](#2540601) <a name="2540601"></a> <br />CM-24544 | If the <code>clagd-vxlan-anycast-ip</code> is removed from the <code>/etc/network/interfaces</code> file (either with the NCLU command or by editing the file manually), MLAG still believes it is present until clagd restarts.  | 3.7.3-3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540359"></a> [2540359](#2540359) <a name="2540359"></a> <br />CM-24440 | <code>bgpd</code> creates a core dump at zclient_send_interface_radv_req. This is an issue with how FRRouting checks next hops and has been pushed upstream to FRRouting. | 3.7.6-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539081"></a> [2539081](#2539081) <a name="2539081"></a> <br />CM-23792 | When you delete post-up and pre-down IP peer entries from the <code>etc/network/interfaces</code> file, then run the <code>ifreload</code> command, the IP addresses are not removed and the route remains in the route table. <br />To work around this issue, either delete the IP addresses without the /32 mask component or flush the IP addresses for the interface with the <code>ip addr flush dev <interface></code> command. <br /> | 3.7.0-3.7.14 | 4.0.0-4.3.0|
| <a name="2538875"></a> [2538875](#2538875) <a name="2538875"></a> <br />CM-23696 | IPv6 multicast traffic destined to an unregistered multicast group is flooded to all ports in a bridge despite the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/swichd.conf</code> file. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538741"></a> [2538741](#2538741) <a name="2538741"></a> <br />CM-23652 | The NCLU command <code>net show bridge spanning-tree</code> does not show the MLAG peer link as part of the STP forwarding instance.<br />To work around this issue, use the <code>mstpctl</code> command to confirm the STP status of the port. | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538480"></a> [2538480](#2538480) <a name="2538480"></a> <br />CM-23523 | Modifying the <code>/etc/netd.conf</code> file to set <code>show_linux_command = True</code> does not take effect.  | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2538302"></a> [2538302](#2538302) <a name="2538302"></a> <br />CM-23422 | <code>portwd</code> allows an error to change the module type based on the error. For example, a bad write to a module might cause the module type to flap, which causes the link itself to flap. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538256"></a> [2538256](#2538256) <a name="2538256"></a> <br />CM-23397 | On the Broadcom switch, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets. <br />  | 3.7.2-4.0.1 | 4.1.0-4.3.0|
| <a name="2538022"></a> [2538022](#2538022) <a name="2538022"></a> <br />CM-23285 | When you remove an interface from a bridge and add it to a VRF in the same commit/ifreload, the IPv6 link-local address is not created automatically. <br />To work around this issue, do the change in two separate commits. First, remove the interface from the bridge, which causes it to be a layer 2 interface. Then, enslave the interface to the VRF.  | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2537820"></a> [2537820](#2537820) <a name="2537820"></a> <br />CM-23123 | When you enable FEC (RS or BaseR) on an interface, removing the configuration from that interface does not revert the FEC status to off/none. <br /> | 3.7.2-3.7.14 | 4.0.0-4.3.0|
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537544"></a> [2537544](#2537544) <a name="2537544"></a> <br />CM-23021 | When you run the <code>mstpctl</code> command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of <code>mstpctl</code>; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | 4.3.0|
| <a name="2537536"></a> [2537536](#2537536) <a name="2537536"></a> <br />CM-23016 | When FRR restarts, <code>snmp&#91;err&#93; dev/kmem: Permission denied</code> error messages are recorded in the log file and SNMPd might crash periodically. | 3.7.5-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2537514"></a> [2537514](#2537514) <a name="2537514"></a> <br />CM-23004 | The local fallback account authenticates using the local password when the RADIUS or TACACS service is up. The expected behavior is for this to fail and only succeed when the RADIUS OR TACACS server fails to respond. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537378"></a> [2537378](#2537378) <a name="2537378"></a> <br />CM-22937 | NCLU SNMPv3 user configuration (add, delete, modify) does not complete. Changes are made to the <code>/etc/snmp/snmpd.conf</code> file but the SNMPv3 user cache file <code>/var/lib/snmp/snmpd.conf</code> fails to update correctly and the configuration does not reflect in operation. <br />To work around this issue, stop <code>snmpd</code>, remove the cache file, then restart <code>snmpd</code>. <br /> | 3.7.1-3.7.14.2 | |
| <a name="2537188"></a> [2537188](#2537188) <a name="2537188"></a> <br />CM-22849 | When an event in the network, such as a <code>switchd</code> or networking service restart, leads to an OVSDB server high availability transition, an <code>ovs-vtepd</code> core might occur. <br />This core generation has no effect on the functionality of high availability when the active OVSDB server is back in the network. <br /> | 3.7.2-3.7.14.2 | |
| <a name="2537153"></a> [2537153](#2537153) <a name="2537153"></a> <br />CM-22834 | In rare cases, certain IPv6 BGP peers fail to reestablish after <code>switchd</code> restarts. | 3.7.2-3.7.8 | 3.7.9-3.7.14.2|
| <a name="2537104"></a> [2537104](#2537104) <a name="2537104"></a> <br />CM-22808 | When you try to stop <code>hsflowd</code> on the Trident II+ switch with the <code>systemctl stop hsflowd</code> command, the process hangs until you stop it with <code>SIGKILL</code>. <br /> | 3.7.1-3.7.14 | 4.0.0-4.3.0|
| <a name="2537061"></a> [2537061](#2537061) <a name="2537061"></a> <br />CM-22794 | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent. <br /> | 3.7.1-4.0.1 | 4.1.0-4.3.0|
| <a name="2536651"></a> [2536651](#2536651) <a name="2536651"></a> <br />CM-22608 | Mellanox Spectrum and Helix4 switches occasionally send malformed packets and do not send any flow samples (only counters). <br />While this issue is fixed for switches with the Spectrum ASIC, this is a &#91;known limitation\|https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Network-Troubleshooting/Monitoring-System-Statistics-and-Network-Traffic-with-sFlow/#caveats-and-errata&#93; on this Helix4 platform. | 3.7.0-3.7.8 | 3.7.9-3.7.14.2, 4.0.0-4.3.0|
| <a name="2536639"></a> [2536639](#2536639) <a name="2536639"></a> <br />CM-22605 | On a Dell S4048 switch, when you set the eth0 speed to 100, either with NCLU or by editing the <code>/etc/network/interfaces</code> file, the <code>igb</code> driver crashes, which brings down eth0. <br />To work around this issue: <br />* If eth0 is configured in the management VRF, power cycle the switch; the eth0 configuration fails and reverts back to the default (auto-negotiation/1000). <br />* If eth0 is configured in the default VRF and you power cycle after the crash, <code>igb</code> continues to crash on boot up (before getting to login prompt); power-cycle the switch, select the Advanced option in GRUB to boot to recovery mode, then modify the <code>/etc/network/interfaces</code> file. | 3.7.0-3.7.10 | 3.7.11-3.7.14.2, 4.0.0-4.3.0|
| <a name="2536617"></a> [2536617](#2536617) <a name="2536617"></a> <br />CM-22591 | CVE-2018-5391 (FragmentSmack) is a network vulnerability where an attacker can trigger time and calculation expensive fragment reassembly with specially crafted packets, leading to a denial of service. On a Cumulus Linux switch, the impact is limited to control plane and management plane traffic. Any control plane traffic coming in the front panel ports will be limited by existing policer ACLs.<br />To work around this issue, create a file called <code>/etc/sysctl.d/ip.conf</code> and add these settings:<br /><pre><br />net.ipv4.ipfrag_low_thresh = 196608<br />net.ipv6.ip6frag_low_thresh = 196608<br />net.ipv4.ipfrag_high_thresh = 262144<br />net.ipv6.ip6frag_high_thresh = 262144<br /></pre> | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2536608"></a> [2536608](#2536608) <a name="2536608"></a> <br />CM-22583 | Single tagged ARP requests received on a QinQ-over-VXLAN access port are dropped if ARP suppression is enabled on an unrelated VNI. <br /> | 3.7.0-3.7.14.2 | |
| <a name="2536559"></a> [2536559](#2536559) <a name="2536559"></a> <br />CM-22538 | When deleting an interface using NCLU, if the <code>/etc/network/interfaces</code> alias is different than the <code>/etc/frr/frr.conf</code> description, the <code>net commit</code> command returns the following error: <br /><pre><br /> /etc/frr/daemons was modified by another user.<br /></pre><br />Despite this error, the change is made and the description is removed from the <code>frr.conf</code> file.  | 3.7.3-3.7.10 | 3.7.11-3.7.14.2|
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536231"></a> [2536231](#2536231) <a name="2536231"></a> <br />CM-22277 | On the Broadcom switch with the Trident3 ASIC, the ECN-CE bit is set by default on transit traffic. This might result in hosts adjusting traffic behavior if they are configured for the ECN feature. <br />In Cumulus Linux 3.7.11, the default behavior changed; the ECN-CE bit is _no longer_ set by default on transit traffic. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on 