---
title: Cumulus Linux 4.0 Release Notes
author: NVIDIA
weight: -30
product: Cumulus Linux
version: "4.0"
toc: 1
type: rn
pdfhidden: True
---
<a href="/cumulus-linux-40/rn.xls"> {{<rn_icon alt="Download 4.0 Release Notes xls" >}}</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="/cumulus-linux-40/rn.xls">Download all 4.0 release notes as .xls</a>
## 4.0.1 Release Notes
### Open issues in 4.0.1

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-27719"></a> [CM-27719](#CM-27719) <a name="CM-27719"></a> <br /> | Several vulnerabilities have been discovered in the interpreter for the Ruby language, which could result in unauthorized access by bypassing intended path matchings, denial of service, or the execution of arbitrary code.<br/>These vulnerabilities affect the ruby2.5 package that is available for optional installation in Cumulus Linux 4.x, but is not installed by default.<br/>CVE-2019-15845: Ruby through 2.4.7, 2.5.x through 2.5.6, and 2.6.x through 2.6.4 mishandles path checking within File.fnmatch functions.<br/>CVE-2019-16201: WEBrick::HTTPAuth::DigestAuth in Ruby through 2.4.7, 2.5.x through 2.5.6, and 2.6.x through 2.6.4 has a regular expression Denial of Service cause by looping/backtracking. A victim must expose a WEBrick server that uses DigestAuth to the Internet or a untrusted network.<br/>CVE-2019-16254: Ruby through 2.4.7, 2.5.x through 2.5.6, and 2.6.x through 2.6.4 allows HTTP Response Splitting. If a program using WEBrick inserts untrusted input into the response header, an attacker can exploit it to insert a newline character to split a header, and inject malicious content to deceive clients.<br/>CVE-2019-16255: Ruby through 2.4.7, 2.5.x through 2.5.6, and 2.6.x through 2.6.4 allows code injection if the first argument (aka the "command" argument) to Shell#&#91;&#93; or Shell#test in lib/shell.rb is untrusted data. An attacker can exploit this to call an arbitrary Ruby method.<br/>Vulnerable: 2.5.5-3 | 4.0.0-4.0.1 | |
| <a name="CM-27699"></a> [CM-27699](#CM-27699) <a name="CM-27699"></a> <br /> | In a default VX instance, a ping to a device's hostname fails.<br/>To work around this issue, edit the `/etc/gai.conf` file and uncomment `precedence ::ffff:0:0/96  10`. | 4.0.0-4.0.1 | |
| <a name="CM-27678"></a> [CM-27678](#CM-27678) <a name="CM-27678"></a> <br /> | The `net show bridge macs` command returns an empty interface column.<br/>To work around this issue, run the `bridge fdb show` command to show the interface. | 4.0.0-4.0.1 | |
| <a name="CM-27645"></a> [CM-27645](#CM-27645) <a name="CM-27645"></a> <br /> | Several vulnerabilities have been discovered in git, a fast, scalable,<br/>distributed revision control system, which is installed by default on Cumulus Linux 4.x.<br/>CVE-2019-1348: export-marks is insecure, fix is to disable by default.<br/>CVE-2019-1349: .git / git~1 filename vulnerability on NTFS<br/>CVE-2019-1352: .git vulnerability with NTFS Alternate Streams Accesses<br/>CVE-2019-1353: NTFS filesystem protection should be on by default<br/>CVE-2019-1387: dubiously-nested submodule git directories should be disallowed<br/>CVE-2019-19604: submodule update repository code execution vulnerability<br/>Vulnerable: <= 2.20.1-2 | 4.0.0-4.0.1 | |
| <a name="CM-27642"></a> [CM-27642](#CM-27642) <a name="CM-27642"></a> <br /> | The following CVEs were announced that affect the libssh package:<br/>CVE-2019-14889 has been announced in the libssh library, where unsanitized user-provided scp command lines could allow an attacker to execute arbitrary commands on the server.<br/>The libssh library is not installed on Cumulus Linux by default, but is available in the Cumulus Linux 4 repository for optional installation. Note that libssh is distinct from libssh2 and openssh, which are present on the switches and in the repositories.<br/>See the following for more information:<br/><a href="https://www.libssh.org/security/advisories/CVE-2019-14889.txt" class="external-link" rel="nofollow">https://www.libssh.org/security/advisories/CVE-2019-14889.txt</a><br/><a href="https://security-tracker.debian.org/tracker/CVE-2019-14889" class="external-link" rel="nofollow">https://security-tracker.debian.org/tracker/CVE-2019-14889</a> | 4.0.0-4.0.1 | |
| <a name="CM-27619"></a> [CM-27619](#CM-27619) <a name="CM-27619"></a> <br /> | The following security vulnerabilities have been announced in the nss / libnss3 library, which is not installed by default but is available in the repository:<br/>CVE-2019-11745: Out-of-bounds write when passing an output buffer smaller than the block size to NSC_EncryptUpdate<br/>CVE-2019-17007: nss: Handling of Netscape Certificate Sequences in CERT_DecodeCertPackage() may crash with a NULL deref leading to DoS<br/>See <a href="https://security-tracker.debian.org/tracker/source-package/nss" class="external-link" rel="nofollow">https://security-tracker.debian.org/tracker/source-package/nss</a> for more information.<br/>Vulnerable: <= 3.42.1-1+deb10u1 | 4.0.0-4.0.1 | |
| <a name="CM-27422"></a> [CM-27422](#CM-27422) <a name="CM-27422"></a> <br /> | The control plane ACL files uses variables that were not defined, which results in an error on boot.<br/>Add the following two lines to the top of the file `/etc/cumulus/acl/policy.d/00control_plane.rules`:<br /><pre>BOOTPC_PORT = 67<br />BOOTPS_PORT = 68<br /></pre></div></div> | 4.0.0-4.0.1 | |
| <a name="CM-27367"></a> [CM-27367](#CM-27367) <a name="CM-27367"></a> <br /> | Under certain circumstances, `switchd` might crash, then restart, on Mellanox switches with the Spectrum or Spectrum-2 ASIC.   | 4.0.0-4.0.1 | |
| <a name="CM-27275"></a> [CM-27275](#CM-27275) <a name="CM-27275"></a> <br /> | CVE-2018-12207: Improper invalidation for page table updates by a virtual guest operating system for multiple Intel(R) Processors may allow an authenticated user to potentially enable denial of service of the host system via local access.<br/>Running hypervisors for virtual guest operating systems is not supported on Cumulus Linux.  Additionally, an affected package qemu is not included in the image, although it is available on upstream repo mirrors.   | 4.0.0-4.0.1 | |
| <a name="CM-27254"></a> [CM-27254](#CM-27254) <a name="CM-27254"></a> <br /> | On Mellanox switches with the Spectrum and Spectrum-2 ASIC, IPv6 egress ACLs are not supported on subinterfaces. | 4.0.0-4.0.1 | |
| <a name="CM-27243"></a> [CM-27243](#CM-27243) <a name="CM-27243"></a> <br /> | The length of the netlink message is not set properly for non-bridge family type messages. The same length is used for both bridge and non-bridge family type messages even though the bridge family type message has an extra attribute. This causes extra bytes to be left over in non-bridge family type netlink messages. | 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-27229"></a> [CM-27229](#CM-27229) <a name="CM-27229"></a> <br /> | On a traditional bridge, VLAN tagged traffic is not discarded when it exceeds the port security MAC limit. | 4.0.0-4.0.1 | |
| <a name="CM-27184"></a> [CM-27184](#CM-27184) <a name="CM-27184"></a> <br /> | With the port security feature, if you change the number of MAC addresses allowed to access a port with the NCLU `net add interface <port> port-security mac-limit <number>` command, the `net show configuration commands` command might fail. | 4.0.0-4.0.1 | |
| <a name="CM-27179"></a> [CM-27179](#CM-27179) <a name="CM-27179"></a> <br /> | On rare occasions on a Mellanox SN3700C switch, if you insert and remove, then reinsert an AOC or QSFP28 optical transceiver quickly, port #32 might get stuck.<br/>To avoid this issue, wait 15 seconds before insertion and before removal of the module. | 4.0.0-4.0.1 | |
| <a name="CM-27143"></a> [CM-27143](#CM-27143) <a name="CM-27143"></a> <br /> | The CPU core temperature sensors are absent on the Dell S5248F-ON switch. | 4.0.0-4.0.1 | |
| <a name="CM-27136"></a> [CM-27136](#CM-27136) <a name="CM-27136"></a> <br /> | With a high number of active routes (20K or more), when you perform a networking restart, the FRR log files might become flooded with error messages associated with the restart. These logs are normal and are not directly a problem. However, the large number of messages can cause the logs to <em>rotate away</em> any previous history, which prevents you from tracing back events leading up to the restart. In a troubleshooting environment, this can be problematic. | 4.0.0-4.0.1 | |
| <a name="CM-27131"></a> [CM-27131](#CM-27131) <a name="CM-27131"></a> <br /> | On switches with the Broadcom Tomahawk3 ASIC, such as the EdgeCore Minipack AS8000, SPAN and ERSPAN functionality is not supported. | 4.0.0-4.0.1 | |
| <a name="CM-27118"></a> [CM-27118](#CM-27118) <a name="CM-27118"></a> <br /> | Switches with the Broadcom Tomahawk3 ASIC, such as the EdgeCore Minipack AS8000, might not learn all MAC address on a port configured for bridging when the hardware MAC table is near the maximum capacity. | 4.0.0-4.0.1 | |
| <a name="CM-27099"></a> [CM-27099](#CM-27099) <a name="CM-27099"></a> <br /> | Precision Time Protocol (PTP) is not currently supported on Mellanox switches with the Spectrum-2 ASIC.  | 4.0.0-4.0.1 | |
| <a name="CM-27094"></a> [CM-27094](#CM-27094) <a name="CM-27094"></a> <br /> | On the Delta AG9032v1 switch, smonctl and sensors report inaccurate PSU current and power. | 3.5.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-27081"></a> [CM-27081](#CM-27081) <a name="CM-27081"></a> <br /> | On the switches with the Broadcom Tomahawk3 ASIC, such as the EdgeCore Minipack AS8000, if you configure more than 96 ports in a layer 2 bridge, `switchd` might hit a timeout error and restart.   | 4.0.0-4.0.1 | |
| <a name="CM-27018"></a> [CM-27018](#CM-27018) <a name="CM-27018"></a> <br /> | When more than one VRR interface is configured on an SVI interface, deleting one of the VRR addresses does not remove the interface/address.  | 3.7.10-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26996"></a> [CM-26996](#CM-26996) <a name="CM-26996"></a> <br /> | On Mellanox switches with the Spectrum ASIC, the `--set-burst` parameter in an iptables rule does not take effect. | 3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-26961"></a> [CM-26961](#CM-26961) <a name="CM-26961"></a> <br /> | On Mellanox switches, error messages with `hw-management-thermal-events.sh` are displayed on shutdown. | 4.0.0-4.0.1 | |
| <a name="CM-26942"></a> [CM-26942](#CM-26942) <a name="CM-26942"></a> <br /> | Port security is not currently supported on VX. The NCLU commands produce errors. | 4.0.0-4.0.1 | |
| <a name="CM-26921"></a> [CM-26921](#CM-26921) <a name="CM-26921"></a> <br /> | If you delete an undefined bond, then add a bond slave, the `net commit` command fails. | 3.7.9-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26913"></a> [CM-26913](#CM-26913) <a name="CM-26913"></a> <br /> | FRR configuration commands for an SVI interface might have the \n misplaced in the output.  For example:<br /><pre>sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre></div></div>should be:<br /><pre>sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre></div></div>To work around this issue, configure the interface manually in the `/etc/frr/frr.conf` file. | 3.7.9-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26907"></a> [CM-26907](#CM-26907) <a name="CM-26907"></a> <br /> | NCLU incorrectly allows you to apply port security configuration on layer 2 and layer 3 ports that are not part of a bridge. | 4.0.0-4.0.1 | |
| <a name="CM-26905"></a> [CM-26905](#CM-26905) <a name="CM-26905"></a> <br /> | When you update the hostname of a switch with the NCLU `net add hostname <hostname>` command, then run `net commit`, the `lldpd` service is not restarted and other devices still see the old name.<br/>To work around this issue, run the `sudo systemctl restart lldpd.service` command. | 3.7.10-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26875"></a> [CM-26875](#CM-26875) <a name="CM-26875"></a> <br /> | After deleting an IPv6 numbered BGP peer group neighbor, Cumulus Linux may continue to send RAs.  To address this, restart frr after removing IPv6 numbered configuration. | 3.7.9-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26769"></a> [CM-26769](#CM-26769) <a name="CM-26769"></a> <br /> | Setting ProtoDown on ports populated with SFP modules providing RJ-45 1000BASE-T interfaces does not cause the carrier to be dropped. The kernel shows carrier down; however, the remote device still shows a link. | 3.7.6-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-26702"></a> [CM-26702](#CM-26702) <a name="CM-26702"></a> <br /> | On Mellanox switches with the Spectrum-2 ASIC, policy-based routing (PBR) is not currently supported. | 4.0.0-4.0.1 | |
| <a name="CM-26655"></a> [CM-26655](#CM-26655) <a name="CM-26655"></a> <br /> | Reconfiguring an NTP server via NCLU with different trailing options (such as iburst) after the IP address causes an invalid configuration to be added to the `/etc/ntp.conf` file.  As an example<br /><pre>net add time ntp server 1.2.3.4 iburst<br />net commit<br />net add time ntp server 1.2.3.4<br />net commit<br /></pre></div></div>If you need to alter existing server configurations, first remove the server, commit, then re-add the server with any trailing options. | 3.7.9-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26599"></a> [CM-26599](#CM-26599) <a name="CM-26599"></a> <br /> | Auto-negotiation does not work with the QSFP28 cables and a remote system opreating at 10G. Attempting to enable auto-negotiation via `ethtool -s swp<#> autoneg on` returns `Operation not supported`<br />As a workaround, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26595"></a> [CM-26595](#CM-26595) <a name="CM-26595"></a> <br /> | The NCLU `net show lldp` command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26525"></a> [CM-26525](#CM-26525) <a name="CM-26525"></a> <br /> | When an MLAG peerlink frequently alternates states between learning and blocking, an excessive number of TCP sessions might be created, which results in the following error display:<br /><pre>OSError: &#91;Errno 24&#93; Too many open files<br /></pre></div></div> | 3.6.2-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-26516"></a> [CM-26516](#CM-26516) <a name="CM-26516"></a> <br /> | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26450"></a> [CM-26450](#CM-26450) <a name="CM-26450"></a> <br /> | Cumulus Linux poed generates excessive debug log entries.  These will be reduced in a future release. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-26437"></a> [CM-26437](#CM-26437) <a name="CM-26437"></a> <br /> | NCLU crashes when you run the `net add interface storage-optimized pfc` command because non-ascii quotes exist in the `datapath.conf` file.<br/>To work around this issue, manually edit the `/usr/lib/python2.7/dist-packages/cumulus/__chip_config/mlx/datapath.conf` file and replace the non-ascii single quotes  with ascii single quotes (standard single quote on the keyboard). | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-26423"></a> [CM-26423](#CM-26423) <a name="CM-26423"></a> <br /> | NCLU requires you to specify an interface with multiple address-virtual statements in ascending MAC address order.  | 3.7.5-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26412"></a> [CM-26412](#CM-26412) <a name="CM-26412"></a> <br /> | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address flipping between the MLAG bond and the peer link.<br/>To work around this issue, disable MAC learning on QinQ VLANs by adding `bridge-learning off` to the VLAN stanza in the `etc/network/interfaces` file. | 3.7.9-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26308"></a> [CM-26308](#CM-26308) <a name="CM-26308"></a> <br /> | An interface alias configured outside FRR using `iproute2` is imported into the FRR running configuration and overrides the internal description. After an FRR reload, this causes FRR to delete the interface alias in an inefficient way. Depending on how many interfaces with aliases you have configured, this can cause a FRR reload to time out.<br/>To work around this issue, remove the interface alias description from `iproute2`. | 3.7.8-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-26288"></a> [CM-26288](#CM-26288) <a name="CM-26288"></a> <br /> | On Mellanox switches, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26256"></a> [CM-26256](#CM-26256) <a name="CM-26256"></a> <br /> | The `net show evpn vni detail json` command includes an extra empty dictionary at the end of the output.  | 3.7.8-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26241"></a> [CM-26241](#CM-26241) <a name="CM-26241"></a> <br /> | On the Dell S5248F-ON switch, `smond` may generate syslog messages indicating that the fan input RPM is lower than the normal low speed of 2500 RPM.  Speeds as low as 1700 RPM are acceptable in normal thermal environments and so these messages can be disregarded. | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26225"></a> [CM-26225](#CM-26225) <a name="CM-26225"></a> <br /> | On the EdgeCore AS5712, AS6712, AS5812 and AS6812 switch, support for multiple PSU types results in log messages similar to the following:<br /><pre>2019-09-05T05:15:17.246597+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.274521+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br />2019-09-05T05:15:17.469556+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.497514+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br /></pre></div></div> | 3.7.9-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26217"></a> [CM-26217](#CM-26217) <a name="CM-26217"></a> <br /> | NCLU does not allow you to configure OSPF NSSAs. For example: <br /><pre>cumulus&#64;switch:~$ net add ospf area 0.0.0.1 nssa <br />ERROR: Command not found. <br />net add ospf area 0.0.0.1 nssa<br /></pre></div></div>To work around this issue, use FRR instead. For example: <br /><pre>switch# configure terminal <br />switch(config)# router ospf <br />switch(config-router)# area 0.0.0.1 nssa <br /></pre></div></div> | 3.7.7-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-26200"></a> [CM-26200](#CM-26200) <a name="CM-26200"></a> <br /> | The following CVEs were announced that affect the systemd-resolved package. <br/>Cumulus Linux does not enable `systemd-resolved` by default, so Cumulus Linux is not vulnerable as shipped. <br/>CVE-2019-15718 <br/>Missing access controls on systemd-resolved's D-Bus interface <br/>Source Package Release Version Status: buster 241-7 vulnerable<br/>For the detailed security status, refer to the security tracker page at:<br/><a href="https://security-tracker.debian.org/tracker/CVE-2019-15718" class="external-link" rel="nofollow">https://security-tracker.debian.org/tracker/CVE-2019-15718</a> | 4.0.0-4.0.1 | |
| <a name="CM-26179"></a> [CM-26179](#CM-26179) <a name="CM-26179"></a> <br /> | If a hostname contains utf-8 characters, the NCLU `net show lldp` command outputs the following error: <br /><pre>ERROR: 'ascii' codec can't encode character u'\xe9' in position 3: ordinal not in range(128) <br />See /var/log/netd.log for more details.  <br /></pre></div></div> | 3.7.7-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-26158"></a> [CM-26158](#CM-26158) <a name="CM-26158"></a> <br /> | On Mellanox switches, UFT profiles are unable to support the documented capacity for routes to addresses that are more than 64 bits in length. The listed capacities assume 64-bit destination IP addresses. | 3.7.8-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-26139"></a> [CM-26139](#CM-26139) <a name="CM-26139"></a> <br /> | Selective ERSPAN does not work when you specify a bridge port. | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26138"></a> [CM-26138](#CM-26138) <a name="CM-26138"></a> <br /> | You cannot specify a source and destination MAC address in an ERSPAN ebtables rule. For example, the following rule does not work:<br /><pre>-A FORWARD -i swp5 -s 00:25:90:b2:bd:9d -d 50:6b:4b:96:c4:04 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre></div></div> | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26137"></a> [CM-26137](#CM-26137) <a name="CM-26137"></a> <br /> | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre>-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre></div></div> | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26136"></a> [CM-26136](#CM-26136) <a name="CM-26136"></a> <br /> | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-26024"></a> [CM-26024](#CM-26024) <a name="CM-26024"></a> <br /> | On switches with the Spectrum ASIC, the underlay hashes VXLAN packets for a given overlay flow randomly.<br/>To work around this issue, configure the ECMP hash seed to the same value on the EVPN egress leaf switches. | 3.7.7-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-25986"></a> [CM-25986](#CM-25986) <a name="CM-25986"></a> <br /> | On the Mellanox SN3700C switch, the time required to establish a link (from the time a link is set to `admin up` until the link becomes operationally up) can take between 5 and 10 seconds.  | 4.0.0-4.0.1 | |
| <a name="CM-25890"></a> [CM-25890](#CM-25890) <a name="CM-25890"></a> <br /> | In some cases, the `switchd` service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18). | 3.7.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-25859"></a> [CM-25859](#CM-25859) <a name="CM-25859"></a> <br /> | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The `net commit` commands succeeds even though the MTU is not changed as expected.<br/>To work around this issue, change the MTU on all SVIs and the bridge manually in the `/etc/network/interfaces` file, then apply the change with the `ifreload -a` command. | 3.7.7-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-25815"></a> [CM-25815](#CM-25815) <a name="CM-25815"></a> <br /> | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment , if the `/etc/network/interfaces` file is replaced with a different file that does not have the SVI and layer 2 VNI configuration anymore, the original virtual MAC does not get populated through the EVPN route until FRR is restarted.  | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-25766"></a> [CM-25766](#CM-25766) <a name="CM-25766"></a> <br /> | When you run the `apt upgrade` command on the Dell-N3048EP switch, the upgrade does not work.  | 3.7.7-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-25740"></a> [CM-25740](#CM-25740) <a name="CM-25740"></a> <br /> | On Broadcom Maverick switches with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br/><br />To work around this issue, configure the bridge with `bridge-vlan-protocol 802.1ad`: <br /><br /><pre> <br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre></div></div>  | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-25694"></a> [CM-25694](#CM-25694) <a name="CM-25694"></a> <br /> | If a packet is policed by ebtables, it does not increment an ACL drop on the ingress interface. Instead, it increments the TDBGC3/6 drop counter to the CPU. | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-25693"></a> [CM-25693](#CM-25693) <a name="CM-25693"></a> <br /> | After you issue the NCLU `net del bgp vrf <vrf> autonomous-system <AS>` command and commit the change, Cumulus Linux does not remove the configuration from the `/etc/frr/frr.conf` file or the `net show config commands`.  | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-25683"></a> [CM-25683](#CM-25683) <a name="CM-25683"></a> <br /> | NCLU fails to remove the BGP neighbor statement when the BGP unnumbered interface belongs to a VRF. However, if the interface belongs to the default VRF, the BGP neighbor statement is removed.  | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-25641"></a> [CM-25641](#CM-25641) <a name="CM-25641"></a> <br /> | If the BMC operating system fails to respond to IPMI, you see a traceback in `bmcd`, and all the sensors might report ABSENT devices in `smonctl`. <br/><br />To work around this issue, power cycle the switch.  | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-25505"></a> [CM-25505](#CM-25505) <a name="CM-25505"></a> <br /> | During the bring-up sequence following a reboot, VXLAN routed packets (tenant traffic flows) transiting an MLAG peer are dropped until the `clagd` `init-delay` timer expires. <br/>The problem is caused by a race condition when programming the anycast IP address (used to terminate VXLAN tunnels), where the hardware is programmed before the software by `clagd`. To route the tenant traffic flows, the kernel must perform address resolution but has to wait for the `clagd` `init-delay` timer to expire before the bonds can forward traffic. During the time when the ARP entry is unresolved, packets might be dropped. <br/>During the `init-delay` period, the ARP cache is not yet populated so the problem exists until either the `init-delay` timer expires or `clagd` neighbor synchronization is complete. By default the `clagd` `init-delay` timer is set to 10 seconds and `clagd` neighbor synchronization occurs halfway through the `init-delay` period. Traffic resumes forwarding after one of the two criteria described above are met. <br/>You might see this issue in EVPN symmetric or centralized configurations with BGP peering over a peer link. <br/>To work around this issue, configure the BGP path across the peer link to be less preferred. The example below uses AS path prepending and the MLAG switches are iBGP neighbors. However, other BGP configurations achieve the same result. <br/>In the `/etc/frr/frr.conf` file, make a new AS path access list and route map to apply BGP pre-pending of the local ASN one or more times. For example: <br /><pre> <br />ip as-path access-list MY_ASN permit ^$ <br /><br />route-map peerlink-add-asn permit 10 <br />match as-path MY_ASN <br />set as-path prepend 4200000101 <br />route-map peerlink-add-asn permit 20 <br /></pre></div></div>  | 3.7.6-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-25400"></a> [CM-25400](#CM-25400) <a name="CM-25400"></a> <br /> | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the vlan-id and the raw-device bridge stanzas are not added automatically.  | 3.7.6-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-25397"></a> [CM-25397](#CM-25397) <a name="CM-25397"></a> <br /> | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted.  | 3.7.3-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24993"></a> [CM-24993](#CM-24993) <a name="CM-24993"></a> <br /> | When you try to change the NTP time zone with the NCLU `net add time zone <timezone>` command or by editing the `/etc/timezone` file manually, the configuration does not take effect.<br/>To work around this issue, change the time zone with the `sudo timedatectl set-timezone <timezone>` command. For example:<br /><pre>cumulus&#64;switch:~$ sudo timedatectl set-timezone US/Eastern<br /></pre></div></div> | 4.0.0-4.0.1 | |
| <a name="CM-24894"></a> [CM-24894](#CM-24894) <a name="CM-24894"></a> <br /> | The `maximum-prefix` configuration under the IPv4 address family has an optional restart value which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24803"></a> [CM-24803](#CM-24803) <a name="CM-24803"></a> <br /> | When you execute the following command on the Dell N3048EP-ON, the switch reboots and then comes right back into Cumulus Linux without installing the new image. The install image is still in `/var/lib/cumulus/installer`, which causes issues with cl-support. <br /><br /><pre> <br /> sudo onie-install -fai http://<path to image> <br /> sudo reboot <br /> </pre></div></div> <br />To work around this issue, use the `onie-select` command to access ONIE, and then use the `nos-install` command in ONIE to install a new binary image. <br/>The workaround only works when an out-of-band network is present. | 3.7.6-3.7.11, 4.0.1 | |
| <a name="CM-24799"></a> [CM-24799](#CM-24799) <a name="CM-24799"></a> <br /> | On switches using the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br/>This issue only affects QinQ configurations.  | 3.7.5-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24762"></a> [CM-24762](#CM-24762) <a name="CM-24762"></a> <br /> | On the EdgeCore AS7326 switch, the 1000BASE-T SFP RJ-45 on a 25G port does not work at 1G.  | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-24751"></a> [CM-24751](#CM-24751) <a name="CM-24751"></a> <br /> | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switches, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status<br /> | 3.7.3-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24652"></a> [CM-24652](#CM-24652) <a name="CM-24652"></a> <br /> | In an EVPN environment, the centralized MAC address is not getting installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br/><br />This issue does not manifest itself in a pure distributed routing (symmetric or asymmetric) environment or in a pure centralized routing environment.  | 3.7.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24618"></a> [CM-24618](#CM-24618) <a name="CM-24618"></a> <br /> | If the interface alias contains a single or double quotation mark, or an apostrophe, the `net show configuration` commands fail with the following error: <br /><br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre></div></div>  | 3.6.1-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24473"></a> [CM-24473](#CM-24473) <a name="CM-24473"></a> <br /> | SNMP incorrectly requires engine ID specification.  | 3.7.4-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24435"></a> [CM-24435](#CM-24435) <a name="CM-24435"></a> <br /> | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a <em>match interface</em> condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br/><br />For example, this command is incorrect: <br /><br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre></div></div> <br />These commands are correct: <br /><br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre></div></div>  | 3.7.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24426"></a> [CM-24426](#CM-24426) <a name="CM-24426"></a> <br /> | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the `net add vrf <name>` command just displays <ENTER>. For example: <br /><br /><pre> <br />cumulus&#64;switch:~$ net add vrf mgmt <br /><ENTER> <br /></pre></div></div> <br />Tab completion for the `net add vrf <name> ip address <address>` command works correctly.  | 3.7.4-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24379"></a> [CM-24379](#CM-24379) <a name="CM-24379"></a> <br /> | On Maverick switches, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24343"></a> [CM-24343](#CM-24343) <a name="CM-24343"></a> <br /> | The `net del bridge bridge mcsnoop yes` command does not return the value to the default of disabled. <br/>To work around this issue, use the `net add bridge bridge mcsnoop no` command to delete the `mcsnoop attribute` and return to the default value. | 3.7.4-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24332"></a> [CM-24332](#CM-24332) <a name="CM-24332"></a> <br /> | On Broadcom switches, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node.  | 3.7.3-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24272"></a> [CM-24272](#CM-24272) <a name="CM-24272"></a> <br /> | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the `net commit` command fails. <br/><br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre></div></div>  | 3.7.4-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24271"></a> [CM-24271](#CM-24271) <a name="CM-24271"></a> <br /> | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br/><br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre></div></div>  | 3.7.4-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24270"></a> [CM-24270](#CM-24270) <a name="CM-24270"></a> <br /> | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. <br/>To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre></div></div>  | 3.7.4-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24262"></a> [CM-24262](#CM-24262) <a name="CM-24262"></a> <br /> | NCLU does not honor "auto all" in the `/etc/network/interfaces` file and removes the existing configuration if no individual `auto <iface>` lines exist.  | 3.7.3-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24241"></a> [CM-24241](#CM-24241) <a name="CM-24241"></a> <br /> | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group <br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre></div></div>  | 3.7.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24222"></a> [CM-24222](#CM-24222) <a name="CM-24222"></a> <br /> | When an LDAP user that does not have NCLU privileges (either in the `netshow` or `netedit` group, or in the `/etc/netd.conf` file) runs an NCLU command, a traceback occurs instead of a permissions error.  | 3.7.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-24035"></a> [CM-24035](#CM-24035) <a name="CM-24035"></a> <br /> | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type.  | 3.7.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23825"></a> [CM-23825](#CM-23825) <a name="CM-23825"></a> <br /> | The `net add interface <interface> ptm-enable` command adds `no ptm-enable` for that interface in the `frr.conf` file. <br/><br />Running the `net add` or the `net del` command does not remove `no ptm-enable` from the `frr.conf` file. You have to remove it manually using vtysh.  | 3.7.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23665"></a> [CM-23665](#CM-23665) <a name="CM-23665"></a> <br /> | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when using `net add vxlan <span class="error">&#91;L3VNI&#93; bridge access <span class="error">&#91;VLAN&#93;` <br/>This configuration breaks network connectivity in an MLAG system in an EVPN symmetric routing configuration. <br/>To restore connectivity, you need to remove the VLAN ID from the bridge.  | 3.7.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23661"></a> [CM-23661](#CM-23661) <a name="CM-23661"></a> <br /> | When you configure a GRE tunnel on a Mellanox switch, the traffic behind the local tunnel endpoint destined through the GRE tunnel is software-forwarded.  | 3.7.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23651"></a> [CM-23651](#CM-23651) <a name="CM-23651"></a> <br /> | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync.  | 3.7.3-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23584"></a> [CM-23584](#CM-23584) <a name="CM-23584"></a> <br /> | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain.  | 3.7.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23570"></a> [CM-23570](#CM-23570) <a name="CM-23570"></a> <br /> | On an RMP/1G-T switch, when you remove `link-speed 100` with the NCLU command or by editing the `etc/network/interfaces` file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br/>After you remove the link-speed, `ethtool` shows the advertised link modes as not reported and Speed/Duplex as unknown.<br/>To work around this issue and bring the interface back up, either restart `switchd` or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br/>Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23418"></a> [CM-23418](#CM-23418) <a name="CM-23418"></a> <br /> | For QSFP modules, the `sudo ifdown` command does not disable the Tx laser.  | 3.7.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23417"></a> [CM-23417](#CM-23417) <a name="CM-23417"></a> <br /> | When using NCLU to create an ibgp peering across the peerlink, the addition of the `net add bgp l2vpn evpn neighbor peerlink.4094 activate` command creates a new EBGP neighborship when one has already been configured for IBGP. This is unexpected, the existing IBGP configuration is valid.  | 3.7.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23397"></a> [CM-23397](#CM-23397) <a name="CM-23397"></a> <br /> | On Broadcom switches, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets.  | 3.6.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23311"></a> [CM-23311](#CM-23311) <a name="CM-23311"></a> <br /> | In an EVPN centralized routing configuration, where the layer 2 network extends beyond VTEPs, (for example, host with bridges), the gateway MAC address does not get refreshed in the network when ARP suppression is enabled on the gateway.<br/>To work around this issue, disable ARP suppression on the centralized gateway. | 4.0.0-4.0.1 | |
| <a name="CM-23075"></a> [CM-23075](#CM-23075) <a name="CM-23075"></a> <br /> | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the `/etc/default/isc-dhcp-relay` file. For example, 1500 SVI interfaces causes the `dhcrelay` service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre></div></div> <br />Eventually the `dhcrelay` service stops.  | 3.7.1-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-23021"></a> [CM-23021](#CM-23021) <a name="CM-23021"></a> <br /> | When you run the `mstpctl` command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of `mstpctl`; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-22926"></a> [CM-22926](#CM-22926) <a name="CM-22926"></a> <br /> | The SNMP port state returns an incorrect value of blocking for an interface which is down. The correct value should be `disabled`. | 3.7.1-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-22794"></a> [CM-22794](#CM-22794) <a name="CM-22794"></a> <br /> | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent.  | 3.6.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-22554"></a> [CM-22554](#CM-22554) <a name="CM-22554"></a> <br /> | If you try to bring down several members of a bond remotely at the same time, the link state of one of the interfaces might not transition correctly to the down state; however, all links show down in hardware.  | 3.6.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-22386"></a> [CM-22386](#CM-22386) <a name="CM-22386"></a> <br /> | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peerlink. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware.  | 3.7.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-22301"></a> [CM-22301](#CM-22301) <a name="CM-22301"></a> <br /> | For an unresolved address, the IPROUTER default policer rule has been modified to <em>not</em> match on packets exiting a TUNNEL and headed to the CPU to resolve the address via ARP. As a result, the following default rule no longer matches TUNNEL ingress packets. <br /><br /><pre> <br />A $INGRESS_CHAIN --in-interface $INGRESS_INTF -m addrtype --dst-type <br />IPROUTER -j POLICE --set-mode pkt --set-rate 400 --set-burst 100 <br /></pre></div></div> <br />These packets are now policed by catch all rules. <br/><br />To work around this issue, the VPORT value on a TRIDENT switch must be changed from binary 011 to 100.  | 3.6.1-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-22287"></a> [CM-22287](#CM-22287) <a name="CM-22287"></a> <br /> | When a layer 3 ECMP path is brought down on the EdgeCore AS7712 (Tomahawk) switch running in atomic mode, traffic traversing the path stops working for about four seconds. When the switch is changed to non-atomic mode, the delay is less than one second. This issue is seen across OSPF and static ECMP routes.  | 3.6.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-22228"></a> [CM-22228](#CM-22228) <a name="CM-22228"></a> <br /> | Counters associated with VLANs and VRFs are not working on Trident 2+ switches.  | 3.7.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-22020"></a> [CM-22020](#CM-22020) <a name="CM-22020"></a> <br /> | On the Trident3 platform, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br/>To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-21927"></a> [CM-21927](#CM-21927) <a name="CM-21927"></a> <br /> | When running `ifreload` after updating an interface configuration, sometimes VLANs are not programmed into the hardware data plane. The Linux control plane looks normal but the VLAN has not been programmed into the hardware and packets that arrive for the VLAN might be dropped. <br/>To work around this issue, remove and re-add the affected VLANs from the port.  | 3.5.3-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-21898"></a> [CM-21898](#CM-21898) <a name="CM-21898"></a> <br /> | On a Trident 3 switch, IGMP packets are not getting policed by the police rule in the 00control ACL file. The packets are policed by the catchall policer in the 99control ACL file instead. <br/><br />`-A $INGRESS_CHAIN -p ipv4 -d 01:00:5e:00:00:00/ff:ff:ff:80:00:00 -j police --set-mode pkt --set-rate 100 --set-burst 100` <br/><br />To work around this issue, let the CPU bound IGMP packet hit the following rule and change the policer rate to a desired value for IGMP packets: <br/><br />`-A $INGRESS_CHAIN -p ipv4 -d 01:00:5e:00:00:00/ff:ff:ff:80:00:00 -j police --set-mode pkt --set-rate 100 --set-burst 100` <br/><br />Typically, the destination MAC address 01:00:5e:xx:xx:xx is used only for PIM/IGMP control and data stream packets. However, this workaround cannot handle data stream multicast packets that are not TCP/UDP; this is not typically done.  | 3.6.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-21785"></a> [CM-21785](#CM-21785) <a name="CM-21785"></a> <br /> | The source address of the ICMPv6 time exceeded message (traceroute hop) is sourced from the wrong VRF when the traceroute target resides on the same switch but in a different VRF. | 3.6.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-21769"></a> [CM-21769](#CM-21769) <a name="CM-21769"></a> <br /> | On a Mellanox switch, GRE tunneling does not work if the tunnel source is configured on an SVI interface. If  the tunnel source is configured on a physical switch port, then tunneling works as expected. | 3.6.1-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-21667"></a> [CM-21667](#CM-21667) <a name="CM-21667"></a> <br /> | FRR does not add BGP `ttl-security` to either the running configuration or to the `/etc/frr/frr.conf` file when configured on a peer group instead of a specific neighbor. <br/>To work around this issue, add `ttl-security` to individual neighbors instead of the peer group. | 3.6.1-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-21278"></a> [CM-21278](#CM-21278) <a name="CM-21278"></a> <br /> | The `net show lldp` command sometimes shows the port description in the `Remote Port` field. The `net show interface` command shows the correct value in the `Remote Host` field.<br/>To work around this issue, use `net show interface` command for LLDP output when connected to Cisco equipment. | 3.5.3-3.7.10, 4.0.0-4.0.1 | 3.7.11|
| <a name="CM-21058"></a> [CM-21058](#CM-21058) <a name="CM-21058"></a> <br /> | The advertised routes list may be empty for an EVPN peering even though the remote switch reports received routes. | 3.6.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-21055"></a> [CM-21055](#CM-21055) <a name="CM-21055"></a> <br /> | On Mellanox switches, the destination MAC address of ERSPAN GRE packets is set to all zeros; therefore, the packets might be dropped by the first transit switch. | 3.6.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-20813"></a> [CM-20813](#CM-20813) <a name="CM-20813"></a> <br /> | Span rules matching the out-interface as a bond do not mirror packets. | 3.6.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-20508"></a> [CM-20508](#CM-20508) <a name="CM-20508"></a> <br /> | The Cumulus-Resource-Query-MIB defines the ability to gather buffer utilization status but when these objects are polled, they return nothing.  | 3.5.3-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-20033"></a> [CM-20033](#CM-20033) <a name="CM-20033"></a> <br /> | The VLAN interface stays up even though the physical link carrying the VLAN is admin or carrier down<br /> | 3.5.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-19788"></a> [CM-19788](#CM-19788) <a name="CM-19788"></a> <br /> | If you configure a VLAN under a VLAN-aware bridge and create a subinterface of the same VLAN on one of the bridge ports, the bridge and interface compete for the same VLAN and if the interface is flapped, it stops working. Correcting the configuration and running the ifreload command does not resolve the conflict. <br/>To work around this issue, correct the bridge VIDs and restart switchd or delete the subinterface.  | 3.5.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-19724"></a> [CM-19724](#CM-19724) <a name="CM-19724"></a> <br /> | PIM and MSDP entries are set to the internal COS value of 6 so they are grouped together with the bulk traffic priority group in the default `traffic.conf` file. However, PIM, IGMP, and MSDP are considered control-plane and should be set to the internal COS value of 7.  | 3.5.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-19454"></a> [CM-19454](#CM-19454) <a name="CM-19454"></a> <br /> | When you use NCLU to bring a bond admin down (`net add bond <bond> link down`), the bond interface goes into admin down state but the switch ports enslaved to the bond remain UP. If you are using bond-lacp-bypass-allow or balance-xor mode, the host might continue to send traffic. This traffic will be dropped because although the bond slaves are UP, they are not members of the bridge.<br/>To work around this issue, use the `sudo ifdown <bondname>` command. | 3.5.0-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-17494"></a> [CM-17494](#CM-17494) <a name="CM-17494"></a> <br /> | In certain cases, a peer device sends an ARP request from a source IP address that is not on the connected subnet and the switch creates a STALE neighbor entry. Eventually, the switch attempts to keep the entry fresh and sends ARP requests to the host. If the host responds, the switch has REACHABLE neighbor entries for hosts that are not on the connected subnet. <br/>To work around this issue, change the value of `arp_ignore` to 2. See <a href="https://support.cumulusnetworks.com/hc/en-us/articles/203859616-Default-ARP-Settings-in-Cumulus-Linux" class="external-link" rel="nofollow">Default ARP Settings in Cumulus Linux</a> for more information. | 3.3.2-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-16571"></a> [CM-16571](#CM-16571) <a name="CM-16571"></a> <br /> | NCLU cannot manage `rsyslog` to addresses routed via a VRF.  In Cumulus Linux 4.0.0 and later, management VRF is enabled by default.   To work around this issue, update the `/etc/network/interfaces` file to disable management VRF. | 3.4.3-3.7.11, 4.0.0-4.0.1 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.11, 4.0.0-4.0.1 | |

### Fixed Issues in 4.0.1
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |

## 4.0.0 Release Notes
### Open issues in 4.0.0

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-28249"></a> [CM-28249](#CM-28249) <a name="CM-28249"></a> <br /> | On the Mellanox switch, when you modify the buffer and queue configuration without restarting `switchd`, you might see a one second interruption in forwarding. | 4.0.0-4.3.0 | |
| <a name="CM-28080"></a> [CM-28080](#CM-28080) <a name="CM-28080"></a> <br /> | TACACS+ through ClearPass is not currently supported. Cumulus Linux sends authorization before authentication, but ClearPass does not accept an authorization before the user is authenticated. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2595889"></a> [2595889](#2595889) <a name="2595889"></a> <br />CM-31120 | In a traditional bridge configuration with <code>ip-forward off</code>, neighbors are synchronized to hardware with a <code>switchd</code> restart but are cleared when you flap the bridge interface. | 3.7.10-4.2.1 | 4.3.0|
| <a name="2595816"></a> [2595816](#2595816) <a name="2595816"></a> <br />CM-31222 | Tenant VRF BGP peers appear in the EVPN RMAC and nexthop tables, which causes the kernel RMAC to point at invalid IP address. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2589747"></a> [2589747](#2589747) <a name="2589747"></a> <br />CM-32226 | If <code>switchd</code> successfully signals <code>clagd</code> that it is going down, <code>clagd</code> stops responding to keepalive echo requests from the peer instead of sending a good bye to the peer over both the peerlink and the backup switch. Eventually, the keepalive timer expires and the secondary switch becomes the primary, and brings the bonds and VNIs back up. However, if <code>switchd</code> does not successfully signal it is going down, (in the event of a crash), the primary switch continues to respond to keepalives, and the bonds and VNIs are down on both peers.  | 3.7.12-4.2.1 | 4.3.0|
| <a name="2578872"></a> [2578872](#2578872) <a name="2578872"></a> <br /> | CVE-2021-20270: It was discovered that Pygments, a syntax highlighting package written in Python, could be forced into an infinite loop, resulting in denial of service<br />Vulnerable: 2.3.1+dfsg-1Fixed: 2.3.1+dfsg-1+deb10u1 | 4.0.0-4.3.0 | |
| <a name="2578870"></a> [2578870](#2578870) <a name="2578870"></a> <br /> | CVE-2020-35523 CVE-2020-35524: Two vulnerabilities have been discovered in the libtiff library and the included tools, which may result in denial of service or the execution of arbitrary code if malformed image files are processed<br />Vulnerable: <= 4.1.0+git191117-2~deb10u1Fixed: 4.1.0+git191117-2~deb10u2 | 4.0.0-4.3.0 | |
| <a name="2566880"></a> [2566880](#2566880) <a name="2566880"></a> <br /> | CVE-2021-27803: A vulnerability was discovered in how p2p/p2p_pd.c in wpa_supplicant before 2.10 processes P2P (Wi-Fi Direct) provision discovery requests. It could result in denial of service or other impact (potentially execution of arbitrary code), for an attacker within radio range. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2564839"></a> [2564839](#2564839) <a name="2564839"></a> <br /> | Several vulnerabilities have been discovered in the GRUB2 bootloader:CVE-2020-14372: It was discovered that the acpi command allows a privileged user to load crafted ACPI tables when Secure Boot is enabled<br />CVE-2020-25632: A use-after-free vulnerability was found in the rmmod command<br />CVE-2020-25647: An out-of-bound write vulnerability was found in the grub_usb_device_initialize() function, which is called to handle USB device initialization<br />CVE-2020-27749: A stack buffer overflow flaw was found in grub_parser_split_cmdline<br />CVE-2020-27779: It was discovered that the cutmem command allows a privileged user  to remove memory regions when Secure Boot is enabled<br />CVE-2021-20225: A heap out-of-bounds write vulnerability was found in the short form option parser<br />CVE-2021-20233: A heap out-of-bound write flaw was found caused by mis-calculation of space required for quoting in the menu rendering. | 4.0.0-4.3.0 | |
| <a name="2556783"></a> [2556783](#2556783) <a name="2556783"></a> <br />CM-33398 | CVE-2021-0326: An issue has been found in wpa, a set of tools to support WPA and WPA2 (IEEE 802.11i). Missing validation of data can result in a buffer over-write, which might lead to a DoS of the wpa_supplicant process or potentially arbitrary code execution.<br />Vulnerable: <= 2.8.0-cl3.7.14u1, <= 2.8.0-cl4.2.1u1 | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2556778"></a> [2556778](#2556778) <a name="2556778"></a> <br />CM-33395 | CVE-2021-26937: A  flaw in the handling of combining characters in screen, a terminal multiplexer with VT100/ANSI terminal emulation can result in denial of service, or potentially the execution of arbitrary code via a specially crafted UTF-8 character sequence.<br />Vulnerable: 4.6.2-3<br />Fixed: 4.6.2-3+deb10u1 | 4.0.0-4.3.0 | |
| <a name="2556776"></a> [2556776](#2556776) <a name="2556776"></a> <br />CM-33394 | CVE-2021-27212: A vulnerability in the Certificate List Exact Assertion validation was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of this flaw to cause a denial of service (slapd daemon crash) via specially crafted packets.<br />Vulnerable: <= 2.4.47+dfsg-3+deb10u5<br />Fixed: 2.4.47+dfsg-3+deb10u6 | 4.0.0-4.3.0 | |
| <a name="2556775"></a> [2556775](#2556775) <a name="2556775"></a> <br />CM-33393 | DSA-4859-1 (no CVE): zstd, a compression utility, was vulnerable to a race condition: it temporarily exposed, during a very short timeframe, a world-readable version of its input even if the original file had restrictive permissions.<br />Vulnerable: <= 1.3.8+dfsg-3+deb10u1<br />Fixed: 1.3.8+dfsg-3+deb10u2 | 4.0.0-4.3.0 | |
| <a name="2556764"></a> [2556764](#2556764) <a name="2556764"></a> <br />CM-33385 | In a configuration with both traditional and vlan-aware bridges, the VLAN membership check on a vlan-aware switch does not drop PVST BPBUs that come from a traditional bridge. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2556731"></a> [2556731](#2556731) <a name="2556731"></a> <br />CM-33359 | CVE-2020-8625: A buffer overflow vulnerability was discovered in the SPNEGO implementation affecting the GSSAPI security policy negotiation in BIND, a DNS server implementation, which could result in denial of service (daemon crash), or potentially the execution of arbitrary code.<br />Vulnerable: <= 9.11.5.P4+dfsg-5.1+deb10u2<br />Fixed: 9.11.5.P4+dfsg-5.1+deb10u3 | 4.0.0-4.3.0 | |
| <a name="2556691"></a> [2556691](#2556691) <a name="2556691"></a> <br />CM-33334 | The following vulnerabilities have been announced in the openssl packages:<br />CVE-2021-23840: Calls to EVP_CipherUpdate, EVP_EncryptUpdate and EVP_DecryptUpdate may overflow the output length argument in some cases where the input length is close to the maximum permissable length for an integer on the platform. In such cases the return value from the function call will be 1 (indicating success), but the output length value will be negative. This could cause applications to behave incorrectly or crash.<br />CVE-2021-23841: The OpenSSL public API function X509_issuer_and_serial_hash() attempts to create a unique hash value based on the issuer and serial number data contained<br />within an X509 certificate. However it fails to correctly handle any errors that may occur while parsing the issuer field (which might occur if the issuer field is maliciously constructed). This may subsequently result in a NULL pointer deref and a crash leading to a potential denial of service attack.<br />CVE-2019-1551: There is an overflow bug in the x64_64 Montgomery squaring procedure used in exponentiation with 512-bit moduli. No EC algorithms are affected. Analysis suggests that attacks against 2-prime RSA1024, 3-prime RSA1536, and DSA1024 as a result of this defect would be very difficult to perform and are not believed likely. Attacks against DH512 are considered just feasible. However, for an attack the target would have to re-use the DH512 private key, which is not recommended anyway. Also applications directly using the low level API BN_mod_exp may be affected if they use BN_FLG_CONSTTIME.<br />Vulnerable: <= 1.1.1d-0+deb10u4<br />Fixed: 1.1.1d-0+deb10u5 | 4.0.0-4.3.0 | |
| <a name="2556659"></a> [2556659](#2556659) <a name="2556659"></a> <br />CM-33315 | CVE-2020-35498: A vulnerability was found in openvswitch. A limitation in the implementation of userspace packet parsing can allow a malicious user to send a specially crafted packet causing the resulting megaflow in the kernel to be too wide, potentially causing a denial of service. The highest threat from this vulnerability is to system availability.<br />Vulnerable: <= 2.8.90-1-cl4u5 | 4.0.0-4.3.0 | |
| <a name="2556569"></a> [2556569](#2556569) <a name="2556569"></a> <br />CM-33283 | DSA-4850-1 (no CVE): libzstd adds read permissions to files while being compressed or uncompressed.<br />Vulnerable: 1.3.8+dfsg-3<br />Fixed: 1.3.8+dfsg-3+deb10u1 | 4.0.0-4.3.0 | |
| <a name="2556500"></a> [2556500](#2556500) <a name="2556500"></a> <br />CM-33258 | Cumulus Linux does not support bond members at 200G or greater. | 4.0.0-4.3.0 | |
| <a name="2556456"></a> [2556456](#2556456) <a name="2556456"></a> <br />CM-33237 | CVE-2020-36221, CVE-2020-36222, CVE-2020-36223, CVE-2020-36224, CVE-2020-36225, CVE-2020-36226, CVE-2020-36227, CVE-2020-36228, CVE-2020-36229, CVE-2020-36230:  Several vulnerabilities were discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of these flaws to cause a denial of service (slapd daemon crash, infinite loops) via specially crafted packets.<br />Vulnerable: <= 2.4.47+dfsg-3+deb10u4<br />Fixed: 2.4.47+dfsg-3+deb10u5 | 4.0.0-4.3.0 | |
| <a name="2556279"></a> [2556279](#2556279) <a name="2556279"></a> <br />CM-33160 | CVE-2021-3156: A serious heap-based buffer overflow has been discovered in sudo that is exploitable by any local user. It has been given the name Baron Samedit by its discoverer. The bug can be leveraged to elevate privileges to root, even if the user is not listed in the sudoers file. User authentication is not required to exploit the bug.<br />Vulnerable: <= 1.8.27-1+deb10u2<br />Fixed: 1.8.27-1+deb10u3 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2556218"></a> [2556218](#2556218) <a name="2556218"></a> <br />CM-33117 | The following vulnerability affects lldpd:<br />CVE-2020-27827: A packet that contains multiple instances of certain TLVs will cause lldpd to continually allocate memory and leak the old memory.  As an example, multiple instances of system name TLV will cause old values to be dropped by the decoding routine.<br />Fixed: 1.0.4-0-cl4.3.0u2 | 3.7.14-4.2.1 | 4.3.0|
| <a name="2556037"></a> [2556037](#2556037) <a name="2556037"></a> <br />CM-33012 | After you add an interface to the bridge, an OSPF session flap can occur.<br /><br /> | 3.7.9-4.2.0 | 4.2.1-4.3.0|
| <a name="2556012"></a> [2556012](#2556012) <a name="2556012"></a> <br />CM-32994 | On Broadcom switches, after repeated VLAN or VXLAN configuration changes, <code>switchd</code> memory might not free up appropriately, which can lead to a crash.  | 3.7.14, 4.0.0-4.2.1 | 3.7.14.2, 4.3.0|
| <a name="2555761"></a> [2555761](#2555761) <a name="2555761"></a> <br />CM-32860 | The following vulnerabilities were announced in the p11-kit (libp11-kit0) packages:<br />CVE-2020-29361: Multiple integer overflows have been discovered in the array allocations in the p11-kit library and the p11-kit list command, where overflow checks are missing before calling realloc or calloc.<br />CVE-2020-29362: A heap-based buffer over-read has been discovered in the RPC protocol used by thep11-kit server/remote commands and the client library. When the remote entity supplies a byte array through a serialized PKCS#11 function call, the receiving entity may allow the reading of up to 4 bytes of memory past the heap allocation.<br />CVE-2020-29363: A heap-based buffer overflow has been discovered in the RPC protocol used by p11-kit server/remote commands and the client library. When the remote entity supplies a serialized byte array in a CK_ATTRIBUTE, the receiving entity may not allocate sufficient length for the buffer to store the deserialized value.<br />Vulnerable: 0.23.15-2<br />Fixed: 0.23.15-2_deb10u1 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2555691"></a> [2555691](#2555691) <a name="2555691"></a> <br />CM-32829 | The NET-SNMP-EXTEND-MIB, disabled in Cumulus Linux 4.2.1 and 3.7.14 to prevent security vulnerability CVE-2020-15862, is re-enabled read-only. | 3.7.14-4.2.1 | 4.3.0|
| <a name="2555528"></a> [2555528](#2555528) <a name="2555528"></a> <br />CM-32750 | In an EVPN Active/Active configuration, when one of the peers reboots and begins to refresh IP neighbor entries shared by the MLAG peer, some of these ARP messages might be dropped by the MLAG peer's ARP policer.<br />To work around this issue, increase the burst value of the ARP policers to 200 or higher. | 3.7.14-4.2.1 | 4.3.0|
| <a name="2555506"></a> [2555506](#2555506) <a name="2555506"></a> <br />CM-32733 | CVE-2020-29479 CVE-2020-29480 CVE-2020-29481 CVE-2020-29482 CVE-2020-29483 CVE-2020-29484 CVE-2020-29485 CVE-2020-29486 CVE-2020-29566 CVE-2020-29570 CVE-2020-29571<br />Several security issues affecting Xenstore could result in cross domain access (denial of service, information leaks or privilege escalation) or denial of service against xenstored.<br />Additional vulnerabilities could result in guest-to-host denial of<br />service.<br />Vulnerable: <= 4.11.4+57-g41a822c392-1<br />Fixed: 4.11.4+57-g41a822c392-2 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2555428"></a> [2555428](#2555428) <a name="2555428"></a> <br />CM-32683 | When you change the SVI <code>vlan-id</code> value in the <code>/etc/network/interfaces</code> file, then run <code>ifreload -a</code>, the 802.1Q ID for the SVI in the kernel does not change.<br />This operation is not supported in the kernel without recreating the SVI. To apply the change, run <code>ifdown</code>, then <code>ifup</code> for the SVI to recreate the interface. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2555401"></a> [2555401](#2555401) <a name="2555401"></a> <br />CM-32661 | On the Edgecore AS7312 switch, eth0 and swp use the same MAC address. | 3.7.14-4.2.1 | 4.3.0|
| <a name="2555373"></a> [2555373](#2555373) <a name="2555373"></a> <br />CM-32641 | CVE-2020-27350: Missing input validation in the ar/tar implementations of APT, the high level package manager, could cause out-of-bounds reads or infinite loops, resulting in denial of service when processing malformed deb files.<br />CVE-2020-27351: Various memory and file descriptor leaks were discovered in the Python interface to the APT package management runtime library, which could result in denial of service.<br />Vulnerable: apt <= 1.8.2.1, python-apt <= 1.8.4.1<br />Fixed: apt 1.8.2.2, python-apt 1.8.4.3 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2555339"></a> [2555339](#2555339) <a name="2555339"></a> <br />CM-32622 | The following vulnerability has been announced in OpenSSL:<br />CVE-2020-1971: A flaw in the GENERAL_NAME_cmp() function could cause a NULL dereference when both GENERAL_NAMEs contain an EDIPARTYNAME, resulting in denial of service.  More information can be found at https://www.openssl.org/news/secadv/20201208.txt .<br />Vulnerable: <= 1.1.1d-0+deb10u3<br />Fixed: 1.1.1d-0+deb10u4 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2555270"></a> [2555270](#2555270) <a name="2555270"></a> <br />CM-32592 | CVE-2020-27670 CVE-2020-27671 CVE-2020-27672 CVE-2020-27674 CVE-2020-28368: Multiple vulnerabilities have been discovered in the Xen hypervisor, which could result in denial of service, privilege escalation or information leaks.<br />Vulnerable: < 4.11.4+57-g41a822c392-1<br />Fixed: 4.11.4+57-g41a822c392-1 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2555205"></a> [2555205](#2555205) <a name="2555205"></a> <br />CM-32545 | If the FRR and MSTP processes go down, an SNMP TRAP is not generated even with the following configuration in the <code>/etc/snmp/snmpd.conf</code> file. <br /><pre><br />proc watchfrr<br />proc mstpd<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRRis down!!!” PrErrorFlag.5 != 0<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRR is up!!!” PrErrorFlag.5 = 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is down!!!!" prErrorFlag.3 != 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is up!!!!" prErrorFlag.3 = 0<br /></pre><br /> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2555183"></a> [2555183](#2555183) <a name="2555183"></a> <br />CM-32532 | CVE-2020-8927: A buffer overflow exists in the Brotli library versions prior to 1.0.8 where an attacker controlling the input length of a "one-shot" decompression request to a script can trigger a crash, which happens when copying over chunks of data larger than 2 GiB.  If one cannot update to a fixed version, we recommend to use the "streaming" API as opposed to the "one-shot" API, and impose chunk size limits.<br />Vulnerable: 1.0.7-2<br />Fixed: 1.0.7-2+deb10u1 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2554992"></a> [2554992](#2554992) <a name="2554992"></a> <br />CM-32420 | When running traditional mode bridges at scale (for example, when you have more than 200 bridges and a large number of MAC addresses), MLAG bonds flap intermittently from dual to single connected, then back to dual connected, which causes a layer 2 loop and STP state changes.<br />To work around this issue, either shut down one side of the MLAG bond or prune out VLANS over the bond. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2554982"></a> [2554982](#2554982) <a name="2554982"></a> <br />CM-32412 | CVE-2020-28196: MIT Kerberos 5 (aka krb5) before 1.17.2 and 1.18.x before 1.18.3 allows unbounded recursion via an ASN.1-encoded Kerberos message because the lib/krb5/asn.1/asn1_encode.c support for BER indefinite lengths lacks a recursion limit.<br />Vulnerable: 1.17-3<br />Fixed: 1.17-3+deb10u1 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2554834"></a> [2554834](#2554834) <a name="2554834"></a> <br />CM-32311 | CVE-2020-25709, CVE-2020-25710: Two vulnerabilities in the certificate list syntax verification and in the handling of CSN normalization were discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of these flaws to cause a denial of service (slapd daemon crash) via specially crafted packets.<br />Vulnerable: <= 2.4.47+dfsg-3+deb10u3<br />Fixed: 2.4.47+dfsg-3+deb10u4 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2554785"></a> [2554785](#2554785) <a name="2554785"></a> <br />CM-32275 | After you reboot a Broadcom switch, <code>switchd</code> might fail to restart and you see logs in <code>switchd.log</code> similar to the following:<br /><pre><br />...<br />Nov 12 12:20:05.063876 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.064310 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 0:system_init:<br />Nov 12 12:20:05.064428 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 system_init: Misc init failed: Operation timed out<br />Nov 12 12:20:05.064464 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.091995 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 LED: Loading 256 bytes into LED program memory<br />Nov 12 12:20:05.092029 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099547 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 PORT: Error: bcm ports not initialized<br />Nov 12 12:20:05.099579 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099646 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /var/lib/cumulus/rc.datapath_0: line 81 (error code -1): script terminated<br />Nov 12 12:20:05.099667 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099775 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /etc/bcm.d/rc.soc: line 70 (error code -1): script terminated<br />Nov 12 12:20:05.099798 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099871 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 ERROR loading rc script on unit 0<br />Nov 12 12:20:05.099892 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099943 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:299 CRIT loading of rc script failed, aborting!<br /></pre> | 3.7.11-4.2.1 | 4.3.0|
| <a name="2554707"></a> [2554707](#2554707) <a name="2554707"></a> <br />CM-32215 | On the Dell S5048F-ON switch, optical transceivers do not come up and the modules are in reset mode. | 4.0.0-4.2.1 | 4.3.0|
| <a name="2554617"></a> [2554617](#2554617) <a name="2554617"></a> <br />CM-32169 | OpenSSH is vulnerable to CVE-2020-14145, as described in https://www.fzi.de/fileadmin/user_upload/2020-06-26-FSA-2020-2.pdf.  <br />This is an information leak in algorithm negotiation that can allow man-in-the-middle attacks on initial connection attempts without a previously stored server host key on the client. If desired, mitigation using UpdateHostKeys and HostKeyAlgorithms is also given in that paper. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2554588"></a> [2554588](#2554588) <a name="2554588"></a> <br />CM-32149 | If you try reconfigure a DHCP server after you delete the switch configuration with the <code>net del all</code> command, the <code>dhcpd</code> service fails because a duplicate process is running.<br />To work around this issue, edit the <code>/usr/lib/python2.7/dist-packages/nclu/plugins/dhcp.py</code> file to change:<br /><pre><br />DHCPD_PID="-pf {0}" <br /></pre><br />to:<br /><pre><br />DHCPD_PID="-pf {1}"<br /></pre> | 3.7.13-4.2.1 | 4.3.0|
| <a name="2554533"></a> [2554533](#2554533) <a name="2554533"></a> <br />CM-32112 | On the ARM platform, NTP peer associations slowly increase to larger offsets (~500ms). | 4.0.0-4.3.0 | |
| <a name="2554531"></a> [2554531](#2554531) <a name="2554531"></a> <br />CM-32110 | CVE-2020-25692: A vulnerability in the handling of normalization with modrdn was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can use this flaw to cause a denial of service (slapd daemon crash) via a specially crafted packet.<br />The slapd package is not present in the image or repository, although the OpenLDAP libraries are present.<br />Vulnerable: <= 2.4.47+dfsg-3+deb10u2<br />Fixed: 2.4.47+dfsg-3+deb10u3 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2554369"></a> [2554369](#2554369) <a name="2554369"></a> <br />CM-32006 | Certain Dell S4048-ON switches show an incorrect vendor name and hang when you issue the <code>reboot</code> command.  | 3.7.12-4.2.1 | 4.3.0|
| <a name="2554307"></a> [2554307](#2554307) <a name="2554307"></a> <br />CM-31968 | The following vulnerability has been announced in freetype:<br />CVE-2020-15999: Sergei Glazunov discovered a heap-based buffer overflow vulnerability in the handling of embedded PNG bitmaps in FreeType. Opening malformed fonts may result in denial of service or the execution of arbitrary code.<br />Vulnerable: <= 2.9.1-3+deb10u1<br />Fixed: 2.9.1-3+deb10u2 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2554282"></a> [2554282](#2554282) <a name="2554282"></a> <br />CM-31954 | A security issue was discovered in the MariaDB database server.<br />Vulnerable: 10.3.25-0<br />Fixed: 10.3.25-0+deb10u1 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2554131"></a> [2554131](#2554131) <a name="2554131"></a> <br />CM-31864 | CVE-2020-14355: Multiple buffer overflow vulnerabilities were found in the QUIC image decoding process of the SPICE remote display system, before spice-0.14.2-1.<br />Both the SPICE client (spice-gtk) and server are affected by these flaws. These flaws allow a malicious client or server to send specially crafted messages that, when processed by the QUIC image compression algorithm, result in a process crash or potential code execution.<br />Vulnerable: 0.14.0-1.3<br />Fixed: 0.14.0-1.3+deb10u1 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553878"></a> [2553878](#2553878) <a name="2553878"></a> <br />CM-31697 | Multiple vulnerabilities have been discovered in the Xen hypervisor, which could result in denial of service, guest-to-host privilege escalation or information leaks.  These include the following:CVE-2020-25595, CVE-2020-25596, CVE-2020-25597, CVE-2020-25599, CVE-2020-25600, CVE-2020-25601, CVE-2020-25602, CVE-2020-25603, CVE-2020-25604.<br />Vulnerable: < 4.11.4+37-g3263f257ca-1<br />Fixed: 4.11.4+37-g3263f257ca-1 | 4.0.0-4.2.1 | 4.3.0|
| <a name="2553748"></a> [2553748](#2553748) <a name="2553748"></a> <br />CM-31627 | On switches with the Spectrum ASIC, the IPv6 default route is present in the kernel but missing in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2553732"></a> [2553732](#2553732) <a name="2553732"></a> <br />CM-31618 | A ping via a dual-connected bond fails, and the audio stream is not routed or encapsulated through the layer 3 VNI. | 3.7.12-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2553677"></a> [2553677](#2553677) <a name="2553677"></a> <br />CM-31605 | When you configure an SNMPv3 user with the <code>net-snmp-config</code> configuration command from the <code>libsnmp-dev</code> package, you get an error message similar to the one below:<br /><pre><br />cumulus&#64;switch:mgmt-vrf:~$ sudo net-snmp-config --create-snmpv3-user -a shaauthpass -x aesprivpass -A SHA -X AES userSHAwithAES<br />adding the following line to /var/lib/snmp/snmpd.conf:           <br />   createUser userSHAwithAES SHA "shaauthpass" AES "aesprivpass"       <br />adding the following line to /snmp/snmpd.conf:                           <br />   rwuser userSHAwithAES                                           <br />touch: cannot touch ‘/snmp/snmpd.conf’: No such file or directory<br />/usr/bin/net-snmp-create-v3-user: 144: /usr/bin/net-snmp-create-v3-user: cannot create /snmp/snmpd.conf: Directory nonexistent<br /></pre><br />To work around this issue, use the NCLU command to configure SNMPv3 user parameters; for example:<br /><pre><br />cumulus&#64;switch:mgmt-vrf:~$ net add snmp-server username user999 auth-md5 user999password encrypt-des user999encryption<br /></pre><br />Alternatively, directly edit the <code>/etc/snmp/snmpd.conf</code> file as described in the documentation. | 3.7.13-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553588"></a> [2553588](#2553588) <a name="2553588"></a> <br />CM-31565 | Multicast traffic on a VPN is sent to remote VTEPs that are not part of the VPN and the remote VTEPs receive multicast traffic encapsulated in a VXLAN ID that doesn't exist.<br />To work around this issue, disable IGMP snooping on the switch. | 3.7.12-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2553219"></a> [2553219](#2553219) <a name="2553219"></a> <br />CM-31407 | You cannot configure SNMPv3 trap-destinations in non-default VRFs with an authentication username that contains fewer than eight characters. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2553146"></a> [2553146](#2553146) <a name="2553146"></a> <br />CM-31374 | CVE-2020-15166: ZeroMQ, a lightweight messaging kernel library<br />does not properly handle connecting peers before a handshake is<br />completed. A remote, unauthenticated client connecting to an application<br />using the libzmq library, running with a socket listening with CURVE<br />encryption/authentication enabled can take advantage of this flaw to<br />cause a denial of service affecting authenticated and encrypted clients.<br />Vulnerable: <= 4.3.1-4+deb10u1<br />Fixed: 4.3.1-4+deb10u2 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2553145"></a> [2553145](#2553145) <a name="2553145"></a> <br />CM-31373 | The following vulnerabilities have been announced in the qemu packages, which are available for optional installation:<br />CVE-2020-12829: An integer overflow in the sm501 display device may result in denial of service.<br />CVE-2020-14364: An out-of-bounds write in the USB emulation code may result in guest-to-host code execution.<br />CVE-2020-15863: A buffer overflow in the XGMAC network device may result in denial of service or the execution of arbitrary code.<br />CVE-2020-16092: A triggerable assert in the e1000e and vmxnet3 devices may result in denial of service.<br />Vulnerable: <= 3.1+dfsg-8+deb10u7<br />Fixed: 3.1+dfsg-8+deb10u8 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2553116"></a> [2553116](#2553116) <a name="2553116"></a> <br />CM-31357 | When you manually set the link speed or duplex mode with ethtool to an unsupported value, then run a TDR check against the interface, you encounter a <code>switchd</code> service heartbeat failure.<br />To work around this issue, reboot the switch to clear the condition. Avoid setting the interface speed or duplex mode directly with ethtool. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552939"></a> [2552939](#2552939) <a name="2552939"></a> <br />CM-31263 | RX_DRP on a bond interface increases without any data traffic while the slave port does not increase. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552869"></a> [2552869](#2552869) <a name="2552869"></a> <br />CM-31231 | On the Dell N3048EP switch, the module information from SFP ports is not displayed in the <code>l1-show</code> command.<br />To work around this issue, use the <code>ethtool -m <interface></code> command. | 3.7.13-4.2.1 | 4.3.0|
| <a name="2552858"></a> [2552858](#2552858) <a name="2552858"></a> <br />CM-31225 | The following vulnerabilities have been announced in the BIND9 server, which is available for optional installation:<br />CVE-2020-8619: an asterisk character in an empty non-terminal can cause an assertion failure, resulting in denial of service.<br />CVE-2020-8622: a truncated TSIG response can lead to an assertion failure, resulting in denial of service.<br />CVE-2020-8623: a flaw in the native PKCS#11 code can lead to a remotely triggerable assertion failure, resulting in denial of service.<br />CVE-2020-8624: update-policy rules of type "subdomain" are enforced incorrectly, allowing updates to all parts of the zone along with the intended subdomain.<br />Vulnerable: <= 9.11.5.P4+dfsg-5.1+deb10u1<br />Fixed: 9.11.5.P4+dfsg-5.1+deb10u2 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2552817"></a> [2552817](#2552817) <a name="2552817"></a> <br />CM-31192 | CVE-2020-11724: An issue was discovered in OpenResty before 1.15.8.4. ngx_http_lua_subrequest.c allows HTTP request smuggling, as demonstrated by the ngx.location.capture API.<br />Vulnerable: <= 1.14.2-2+deb10u2<br />Fixed: 1.14.2-2+deb10u3 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2552791"></a> [2552791](#2552791) <a name="2552791"></a> <br />CM-31174 | The following vulnerabilities have been announced in the ghostscript libgs9 package, which is available for optional installation. These can allow an attacker to elevate privileges or cause a denial of service with crafted PS/EPS/PDF files.<br />CVE-2020-16287 CVE-2020-16288 CVE-2020-16289 CVE-2020-16290 CVE-2020-16291 CVE-2020-16292 CVE-2020-16293 CVE-2020-16294 CVE-2020-16295 CVE-2020-16296 CVE-2020-16297 CVE-2020-16298 CVE-2020-16299 CVE-2020-16300 CVE-2020-16301 CVE-2020-16302 CVE-2020-16303 CVE-2020-16304 CVE-2020-16305 CVE-2020-16306 CVE-2020-16307 CVE-2020-16308 CVE-2020-16309 CVE-2020-16310 CVE-2020-17538<br />Vulnerable: <= 9.27~dfsg-2+deb10u3<br />Fixed: 9.27~dfsg-2+deb10u4 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2552742"></a> [2552742](#2552742) <a name="2552742"></a> <br />CM-31150 | On the Mellanox SN2410 switch, you see <code>switchd</code> core and <code>GBIN_MALLOC</code> errors.<br />To work around this issue, restart <code>switchd</code>. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552632"></a> [2552632](#2552632) <a name="2552632"></a> <br />CM-31073 | When you set the <code>sysctl</code> settings <code>net.ipv6.conf.all.accept_ra_defrtr</code> (to prevent acceptance of IPv6 default route advertisements) and <code>net.ipv6.conf.default.accept_ra_defrtr</code> (set for newly created interfaces), if you create a new virtual interface, any pre-existing interface does not start accepting IPv6 default route avertisements again.<br />To work around this issue, when you create a new virtual interface, set <code>net.ipv6.conf.<interface>.accept_ra_defrtr</code> to 0 for all interfaces and run <code>sysctl -p --system</code>. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2552610"></a> [2552610](#2552610) <a name="2552610"></a> <br />CM-31057 | The following vulnerability has been announced:<br />CVE-2019-11360: A buffer overflow in <code>iptables-restore</code> in netfilter iptables 1.8.2 allows an attacker to (at least) crash the program or potentially gain code execution via a specially crafted iptables-save file. This is related to <code>add_param_to_argv</code> in <code>xshared.c</code>. | 3.7.13-4.2.0 | 4.2.1-4.3.0|
| <a name="2552608"></a> [2552608](#2552608) <a name="2552608"></a> <br />CM-31055 | The following vulnerability has been announced:<br />CVE-2019-20892: net-snmp before 5.8.1.pre1 has a double free in usm_free_usmStateReference in snmplib/snmpusm.c via an SNMPv3 GetBulk request. <br />Fixed:  5.8.0-cl4.2.1u1,  5.8.0-cl3.7.14u1 | 3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552555"></a> [2552555](#2552555) <a name="2552555"></a> <br />CM-31038 | The following vulnerability has been announced:<br />CVE-2019-20795: iproute2 has a use-after-free in get_netnsid_from_name in ip/ipnetns.c.<br />Vulnerable: <= 4.19.0-cl4u3 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2552528"></a> [2552528](#2552528) <a name="2552528"></a> <br />CM-31028 | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2552506"></a> [2552506](#2552506) <a name="2552506"></a> <br />CM-31016 | Changing the order of the bridge ports might cause the bridge MAC address to change, which flaps the bridge and its ports.<br />To work around this issue, manually set the MAC address of the bridge interface by adding <code>hwaddress <mac-address></code> to the bridge stanza in the <code>/etc/network/interfaces</code> file. | 3.7.11-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552407"></a> [2552407](#2552407) <a name="2552407"></a> <br />CM-30957 | The following vulnerability has been announced in the json-c / libjson_c3 packages:<br />CVE-2020-12762: json-c through 0.14 has an integer overflow and out-of-bounds write via a large JSON file, as demonstrated by printbuf_memappend.<br />Vulnerable: 0.12.1+ds-2<br />Fixed: 0.12.1+ds-2+deb10u1 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2552298"></a> [2552298](#2552298) <a name="2552298"></a> <br />CM-30882 | The following vulnerability has been announced in net-snmp:<br />CVE-2020-15862: A privilege escalation involving the NET-SNMP-EXTEND-MIB support (which is enabled by default at compile-time).<br />The fixed versions disable NET-SNMP-EXTEND-MIB support.<br /><br />Vulnerable: <= 5.8.0-cl3u11, <= 5.8.0-cl4u4<br />Fixed: 5.8.0-cl3.7.14u3, 5.8.0-cl4.2.1u1 | 3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552294"></a> [2552294](#2552294) <a name="2552294"></a> <br />CM-30879 | NCLU restarts FRR when removing a BGP VRF IPv4 aggregate-address command.<br />  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552283"></a> [2552283](#2552283) <a name="2552283"></a> <br />CM-30872 | Several vulnerabilities have been discovered in the GRUB2 bootloader.<br />CVE-2020-10713: A flaw in the grub.cfg parsing code was found allowing to break UEFI Secure Boot and load arbitrary code. Details can be found at https://www.eclypsium.com/2020/07/29/theres-a-hole-in-the-boot/<br />CVE-2020-14308: It was discovered that grub_malloc does not validate the allocation size allowing for arithmetic overflow and subsequently a heap-based buffer overflow.<br />CVE-2020-14309: An integer overflow in grub_squash_read_symlink may lead to a heap-based buffer overflow.<br />CVE-2020-14310: An integer overflow in read_section_from_string may lead to a heap-based buffer overflow.<br />CVE-2020-14311: An integer overflow in grub_ext2_read_link may lead to a heap-based buffer overflow.<br />CVE-2020-15706: script: Avoid a use-after-free when redefining a function during execution.<br />CVE-2020-15707: An integer overflow flaw was found in the initrd size handling.<br />Vulnerable: <= 2.02+dfsg1-20, <= 2.02+dfsg1-cl4u1<br />Fixed: 2.02+dfsg1-20+deb10u2, 2.02+dfsg1-cl4.2.1u1 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2552266"></a> [2552266](#2552266) <a name="2552266"></a> <br />CM-30863 | OpenSSH scp is vulnerable to CVE-2020-15778, where clients that have authorized access to the SSH server can execute commands on the server by copying maliciously named files.<br />The two scenarios where an exploit may be useful to an attacker:<br />-The user is authorized to <code>scp</code> but not <code>ssh</code> (based on the <code>command</code> option in the <code>authorized_keys</code> file), so this vulnerability can allow executing a remote command on the target computer when not authorized to do so.<br />-An attacker plants a maliciously named file in a directory tree that someone later uses <code>scp -r</code> to copy over to the target computer.<br />Be aware that restricting users to <code>scp</code> by using the <code>command</code> option in the <code>authorized_keys</code> file is not effective in preventing those users from executing arbitrary commands on the server.<br />If you want to use <code>scp -r</code> to copy directory trees, avoid copying directory trees to which attackers may have added maliciously-named files. Archiving the directory tree with <code>tar</code>, <code>zip</code>, or a similar program, then copying the archive over to be extracted on the server avoids having to use <code>scp -r</code> altogether. In addition, OpenSSH provides <code>sftp</code>, which you can use instead of <code>scp</code> to copy files.<br />To disable scp completely, use <code>/bin/chmod 0 /usr/bin/scp</code> . | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552248"></a> [2552248](#2552248) <a name="2552248"></a> <br />CM-30856 | The following vulnerability has been announced in NGINX, which is installed by default on Cumulus Linux (however, the default NGINX configuration is not vulnerable, as it does not configure <code>error_page redirection</code>):<br />CVE-2019-20372: NGINX before 1.17.7, with certain error_page configurations, allows HTTP request smuggling, as demonstrated by the ability of an attacker to read unauthorized web pages in environments where NGINX is being fronted by a load balancer.<br />To work around this issue, do not use <code>error_page redirection</code> in the vulnerable configuration.  https://bertjwregeer.keybase.pub/2019-12-10%20-%20error_page%20request%20smuggling.pdf describes the vulnerability and the vulnerable configuration.<br />Fixed: 1.14.2-2+deb10u2 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2552206"></a> [2552206](#2552206) <a name="2552206"></a> <br />CM-30827 | If the MAC address of an SVI changes, <code>clagd</code> does not update its permanent neighbor entry for the local interface, and it does not report the change to its MLAG peer. This leaves the MLAG peer in a state where its permanent neighbor for the MLAG peer's SVI IP address continues to use the old MAC address, which causes routed traffic over this SVI to be dropped.<br />To work around this issue, ifdown/ifup the SVI when a MAC address changes. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2552203"></a> [2552203](#2552203) <a name="2552203"></a> <br />CM-30826 | The following vulnerability has been announced in QEMU:<br />CVE-2020-8608: In libslirp 4.1.0, as used in QEMU 4.2.0, tcp_subr.c misuses snprintf return values, leading to a buffer overflow in later code.<br />Vulnerable: <= 3.1+dfsg-8+deb10u6<br />Fixed: 3.1+dfsg-8+deb10u7 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2551912"></a> [2551912](#2551912) <a name="2551912"></a> <br />CM-30580 | <code>ifupdown2</code> does not account for link status or link down configuration when running <code>dhclient</code>. For example, <code>ifupdown2</code> ignores <code>link-down yes</code> during <code>ifup/ifreload</code> and runs the DHCP module if <code>inet dhcp</code> is configured on the interface. <code>ifupdown2</code> also runs the DHCP module even when the physical link configured for DHCP is down. | 3.7.12-4.2.0 | 4.2.1-4.3.0|
| <a name="2551896"></a> [2551896](#2551896) <a name="2551896"></a> <br />CM-30565 | Several denial of service vulnerabilities have been announced in the <code>qemu</code> packages:<br />CVE-2020-10756 CVE-2020-13361 CVE-2020-13362 CVE-2020-13754 CVE-2020-13659<br />Vulnerable: <= 1:3.1+dfsg-8+deb10u5<br />Fixed: 1:3.1+dfsg-8+deb10u6 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2551853"></a> [2551853](#2551853) <a name="2551853"></a> <br />CM-30546 | The following vulnerabilities have been announced in the <code>nss</code> packages, including <code>libnss3</code>, which may be used by other programs:<br />CVE-2019-17006: Check length of inputs for cryptographic primitives<br />CVE-2019-17023: After a HelloRetryRequest has been sent, the client may negotiate a lower protocol that TLS 1.3, resulting in an invalid state transition in the TLS State Machine. If the client gets into this state, incoming Application Data records will be ignored.<br />CVE-2020-12399: NSS has shown timing differences when performing DSA signatures, which was exploitable and could eventually leak private keys.<br />CVE-2020-12402: During RSA key generation, bignum implementations used a variation of the Binary Extended Euclidean Algorithm which entailed significantly input-dependent flow. This allowed an attacker able to perform electromagnetic-based side channel attacks to record traces leading to the recovery of the secret primes.<br />Vulnerable: <= 3.42.1-1+deb10u2<br />Fixed: 3.42.1-1+deb10u3 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2551771"></a> [2551771](#2551771) <a name="2551771"></a> <br />CM-30525 | When a specific PIM join/prune packet is received from a PIM neighbor the <code>pimd</code> process might crash with a core file. | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2551748"></a> [2551748](#2551748) <a name="2551748"></a> <br />CM-30514 | In OVSDB high availability mode, deleting > 200 VLAN bindings might cause <code>ovs-vtepd</code> to crash.  Limit the deletion to 200 or fewer VLAN bindings. | 3.7.12-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2551732"></a> [2551732](#2551732) <a name="2551732"></a> <br />CM-30504 | When the OVSDB VTEP scale increases, the CPU utilization increases and eventually the switch (<code>ptmd</code>) fails to respond to the BFD, causing the BFD session to go down. As a result OVSDB cannot read the BFD socket status and outputs a warning in the <code>ovs-vtepd</code> debugs: <code>PTM socket error: Bad file descriptor</code>. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551729"></a> [2551729](#2551729) <a name="2551729"></a> <br />CM-30503 | In OVSDB high availability mode, if you create, then delete a binding, the FDB entry is not replaced and you see an error. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551715"></a> [2551715](#2551715) <a name="2551715"></a> <br />CM-30498 | There is a change to the default OVSDB bootstrapping process, where the script created now defaults to VLAN-aware bridge mode. If you want to use traditional bride mode, you need to force it by editing the <code>ovs-vtep-ctl</code> script generated by the bootstrap process. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551686"></a> [2551686](#2551686) <a name="2551686"></a> <br />CM-30484 | Multiple vulnerabilities have been discovered in the Xen hypervisor, which might result in denial of service, guest-to-host privilege escalation, or information leaks.<br />The CVE IDs are CVE-2020-11739, CVE-2020-11740, CVE-2020-11741, CVE-2020-11742, CVE-2020-11743, CVE-2020-15563, CVE-2020-15564, CVE-2020-15565, CVE-2020-15566, CVE-2020-15567.<br />Xen packages are not installed by default on Cumulus Linux, but some libxen* packages are in the repository for optional installation.<br />Vulnerable: < 4.11.3+24-g14b62ab3e5-1~deb10u1<br />Fixed: 4.11.4+24-gddaaccbbab-1~deb10u1 | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2551675"></a> [2551675](#2551675) <a name="2551675"></a> <br />CM-30479 | When you restart <code>clagd</code>, the edge port setting on the peer link changes. | 3.7.2-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551665"></a> [2551665](#2551665) <a name="2551665"></a> <br />CM-30472 | On the QuantaMesh T1048-LY4 switch, pluggables inserted into SFP+ ports are not detected.<br />To workaround this issue, downgrade to Cumulus Linux 3.7 ESR. | 4.0.0-4.2.0 | 4.2.1-4.3.0|
| <a name="2551651"></a> [2551651](#2551651) <a name="2551651"></a> <br />CM-30464 | The <code>net show dot1x interface summary</code> command output shows a MAC address with all zeros associated with a port. | 3.7.12-3.7.13, 4.0.0-4.2.0 | 3.7.14, 4.2.1-4.3.0|
| <a name="2551613"></a> [2551613](#2551613) <a name="2551613"></a> <br />CM-30447 | The following vulnerabilities have been announced in <code>ruby2.5</code>, which is not installed on the switch by default, but is available in the repository for optional installation:<br />CVE-2020-10663: The JSON gem through 2.2.0 for Ruby, as used in Ruby 2.4 through 2.4.9, 2.5 through 2.5.7, and 2.6 through 2.6.5, has an Unsafe Object Creation Vulnerability. This is quite similar to CVE-2013-0269, but does not rely on poor garbage-collection behavior within Ruby. Specifically, use of JSON parsing methods can lead to creation of a malicious object within the interpreter, with adverse effects that are application-dependent.<br />CVE-2020-10933: An issue was discovered in Ruby 2.5.x through 2.5.7, 2.6.x through 2.6.5, and 2.7.0. If a victim calls BasicSocket#read_nonblock(requested_size, buffer, exception: false), the method resizes the buffer to fit the requested size, but no data is copied. Thus, the buffer string provides the previous value of the heap. This may expose possibly sensitive data from the interpreter.<br />Vulnerable: <= 2.5.5-3+deb10u1<br />Fixed: 2.5.5-3+deb10u2 | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2551578"></a> [2551578](#2551578) <a name="2551578"></a> <br />CM-30422 | When you configure a bridge in the <code>/etc/network/interfaces</code> file, then try to reconfigure the bridge to be a VRF interface with the same name, <code>ifreload</code>/<code>ifup</code> commands fail with an <code>invalid table id</code> or <code>unable to get vrf table id</code> error. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2551335"></a> [2551335](#2551335) <a name="2551335"></a> <br />CM-30312 | When TACACS+ is configured and the management VRF is enabled, users with privilege level 13 are prevented from running <code>ip</code> and <code>cat</code> commands. | 4.0.0-4.3.0 | |
| <a name="2551162"></a> [2551162](#2551162) <a name="2551162"></a> <br />CM-30240 | <code>switchd</code> memory utilization might continue to increase if there are excessive and continuous link flaps over a long period of time.<br />To work around this issue, correct the cause of the frequent link flaps. You can restart <code>switchd</code> with the <code>sudo systemctl restart switchd</code> command to recover memory; this operation is impactful to all traffic on the switch during the restart. | 3.7.11-3.7.12, 4.0.0-4.2.0 | 3.7.13-3.7.14, 4.2.1-4.3.0|
| <a name="2551124"></a> [2551124](#2551124) <a name="2551124"></a> <br />CM-30231 | When the dynamic or static flag on a bridge fdb (MAC) entry is changed to the opposite state, the new flag is not set appropriately in hardware. This can allow a static fdb entry to be unexpectedly learned dynamically on a different interface, or can prevent a dynamic entry from being updated or learned elsewhere.<br />This condition can occur during a manual replacement of a local MAC address or when EVPN updates a dynamic MAC address to add or remove the Sticky Mac flag. Either situation results in the MAC address keeping the original flag in hardware.<br />To work around this issue, delete or withdraw the fdb entry, then add the static MAC address directly. For example:<br /><pre><br />bridge fdb del 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master<br />bridge fdb add 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master &#91; static \| dynamic &#93;<br /></pre><br />If you are unable to delete an EVPN-learned remote MAC address, you can replace the dynamic MAC address with a local static one, then delete the static MAC address. For example:<br /><pre><br />bridge fdb replace 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master static<br />bridge fdb del 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master<br />bridge fdb add 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master &#91; static \| dynamic &#93;<br /></pre> | 4.0.0-4.2.1 | 4.3.0|
| <a name="2551111"></a> [2551111](#2551111) <a name="2551111"></a> <br />CM-30230 | If a remote EVPN Sticky MAC &#91;Static MAC address&#93; is unexpectedly learned dynamically on a local interface, the selected entries in zebra and BGP are in an inconsistent state.<br />zebra increments the local MAC mobility sequence number and considers the MAC address to be local, but BGP maintains the remote Sticky MAC as the best path selected. This results in zebra installing the local MAC address and BGP not updating the route for the MAC address. | 4.0.0-4.2.1 | 4.3.0|
| <a name="2550942"></a> [2550942](#2550942) <a name="2550942"></a> <br />CM-30178 | NCLU tab completion for <code>net show</code> displays the text <code>add help text</code> instead of <code>system Information</code> for the system option. | 3.7.11-4.2.0 | 4.2.1-4.3.0|
| <a name="2550918"></a> [2550918](#2550918) <a name="2550918"></a> <br />CM-30164 | The <code>/usr/share/zoneinfo/leap-seconds.list</code> file expires periodically and results in log messages being generated about that expiration.<br />To work around this issue, you must update the file from https://www.ietf.org/timezones/data/leap-seconds.list or upgrade the <code>tzdata</code> package to the newest version. | 4.0.0-4.2.1 | 4.3.0|
| <a name="2550796"></a> [2550796](#2550796) <a name="2550796"></a> <br />CM-30103 | On a Broadcom switch with the Trident2+ ASIC, ACL rules for VLANs are not applied after a reboot and the counters remain at zero.<br />To work around this issue, either do not set <code>acl.non_atomic_update_mode = TRUE</code> in the <code>/etc/cumulus/switchd.conf</code> file or run the <code>cl-acltool -i</code> command after the reboot to install the  ACLs. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2550793"></a> [2550793](#2550793) <a name="2550793"></a> <br />CM-30101 | The NCLU <code>net show bridge spanning-tree</code> command displays the aging timer incorrectly.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550690"></a> [2550690](#2550690) <a name="2550690"></a> <br />CM-30038 | The following vulnerability has been announced that affects GnuTLS:<br />CVE-2020-13777: GnuTLS 3.6.x before 3.6.14 uses incorrect cryptography for encrypting a session ticket (a loss of confidentiality in TLS 1.2, and an authentication bypass in TLS 1.3). The earliest affected version is 3.6.4 (2018-09-24) because of an error in a 2018-09-18 commit. Until the first key rotation, the TLS server always uses wrong data in place of an encryption key derived from an application.<br />Vulnerable: <= 3.6.7-4+deb10u3<br />Fixed: 3.6.7-4+deb10u4 | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2550601"></a> [2550601](#2550601) <a name="2550601"></a> <br />CM-29978 | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | 4.2.1-4.3.0, 4.3.0|
| <a name="2550444"></a> [2550444](#2550444) <a name="2550444"></a> <br />CM-29872 | Tab completion for the <code>net show rollback description</code> command returns information about a snapshot instead of context help.<br />To work around this issue, run the <code>net show commit history</code> command to find descriptions instead of the <code>net show rollback description</code> command. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550443"></a> [2550443](#2550443) <a name="2550443"></a> <br />CM-29871 | The <code>net show rollback description <string></code> command returns an error even if the string matches a commit description.<br />To work around this issue, look for your string in the output of the <code>net show commit history</code> command (or grep for it there) instead. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550378"></a> [2550378](#2550378) <a name="2550378"></a> <br />CM-29841 | The following vulnerabilities have been announced that affect Unbound:<br />CVE-2020-12662 and CVE-2020-12663 have been discovered in Unbound, a recursive-only caching DNS server; a traffic amplification attack against third party authoritative name servers (NXNSAttack) and insufficient sanitisation of replies from upstream servers could result in denial of service via an infinite loop.<br />Unbound is not provided for Cumulus Linux, but the libunbound8 library package is available for optional installation on Cumulus Linux.<br />Vulnerable: <= 1.9.0-2+deb10u1<br />Fixed: 1.9.0-2+deb10u2 | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2550375"></a> [2550375](#2550375) <a name="2550375"></a> <br />CM-29838 | CPU utilization may increase when clag-managed bond interfaces are operationally/LACP down but the physical carrier remains up on the bond member switchports. This condition occurs when clag bond redirection is enabled and bond members remain up while the parent bond does not negotiate LACP.<br /><br />This issue is resolved in Cumulus Linux 3.7.14. | 3.7.9-3.7.13, 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2550350"></a> [2550350](#2550350) <a name="2550350"></a> <br />CM-29830 | Unicast traffic from downlink hosts is flooded to multiple remote VTEPs, which might also cause high HwIfOutQDrops/TX_DRP on the uplink ports.<br />To work around this issue, restart <code>switchd</code>. | 3.7.10-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2550276"></a> [2550276](#2550276) <a name="2550276"></a> <br />CM-29779 | In LLDP, the <code>snmp</code> subagent loses all subsequent <code>lldpRemSysName</code> (1.0.8802.1.1.2.1.4.1.1.9) entries after an entry with a missing SysName is added.<br />All the information from <code>lldpctl</code> is correct. Only the entries after the entry that is missing a SysName in <code>lldpRemSysName</code> disappear from the <code>snmp</code> subagent. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2550275"></a> [2550275](#2550275) <a name="2550275"></a> <br />CM-29778 | If packets with an invalid checksum are received, the <code>cumulus-poe</code> service might restart and you see log messages similar to the following:<br />May 20 10:48:04.665635 leaf01 poed&#91;8012&#93;: ERROR : invalid checksum in response &#91;0xC2:0x00&#93;<br />May 20 10:48:04.671299 leaf01 poed&#91;8012&#93;: poed : ERROR : invalid checksum in response &#91;0xC2:0x00&#93;<br />May 20 10:48:04.708620 leaf01 systemd&#91;1&#93;: cumulus-poe.service: main process exited, code=exited, status=1/FAILURE<br />The service starts automatically but there is an impact to POE devices momentarily. | 3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2550244"></a> [2550244](#2550244) <a name="2550244"></a> <br />CM-29760 | Several vulnerabilities were discovered in BIND, a DNS server implementation.  <br /><code>bind9-host</code> (containing only <code>/usr/bin/host</code>) and some libraries from the <code>bind9</code> source package are installed on the switch by default; the BIND server referred to in these vulnerabilities is not installed by default but is available in the repository for optional installation.<br />CVE-2019-6477: It was discovered that TCP-pipelined queries can bypass tcp-client limits resulting in denial of service.<br />CVE-2020-8616: It was discovered that BIND does not sufficiently limit the number of fetches performed when processing referrals. An attacker can take advantage of this flaw to cause a denial of service (performance degradation) or use the recursing server in a reflection attack with a high amplification factor.<br />CVE-2020-8617: It was discovered that a logic error in the code which checks TSIG validity can be used to trigger an assertion failure, resulting in denial of service.<br />Vulnerable: 9.11.5.P4+dfsg-5.1<br />Fixed: 9.11.5.P4+dfsg-5.1+deb10u1 | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2550243"></a> [2550243](#2550243) <a name="2550243"></a> <br />CM-29759 | When you use <code>nginx</code> and <code>restserver</code> in management VRF to provide a REST API for the switch, <code>nginx</code> starts but <code>restserver</code> fails to start.<br />To work around this issue, comment out the <code>Requires=</code> line in the <code>/lib/systemd/system/restserver.service</code>. For example:<br /><pre><br />#Requires=nginx.service restserver.socket<br /></pre> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550117"></a> [2550117](#2550117) <a name="2550117"></a> <br />CM-29691 | The following vulnerability has been announced in the apt package:<br />CVE-2020-3810: Shuaibing Lu discovered that missing input validation in the ar/tar implementations of APT, the high level package manager, could result in denial of service when processing specially crafted deb files.<br />Vulnerable: <= 1.8.2<br />Fixed: 1.8.2.1 | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2549925"></a> [2549925](#2549925) <a name="2549925"></a> <br />CM-29594 | When you run an Ansible script to replace the <code>/etc/network/interfaces</code> file, then run the <code>ifreload -a</code> command, you see errors similar to the following:<br /><pre><br />error: swp1s1.2: netlink: cannot set link swp1s1.2 up: operation failed with 'Network is down' (100)<br />warning: cmd '/bin/ip addr del 10.0.0.1/24 dev eth0' failed: returned 2 (RTNETLINK answers: Cannot assign requested address<br /></pre><br />To work around this issue,  run the <code>ifreload -a</code> command a second time. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549859"></a> [2549859](#2549859) <a name="2549859"></a> <br />CM-29556 | The following vulnerability has been announced that affects ntp:<br />CVE-2020-11868: ntpd in ntp before 4.2.8p14 and 4.3.x before 4.3.100 allows an off-path attacker to block unauthenticated synchronization via a server mode packet with a spoofed source IP address, because transmissions are rescheduled even when a packet lacks a valid origin timestamp.<br />This affects: ntp-4.2.8p12 (possibly earlier) and ntp-4.2.8p13<br />The fix for https://bugs.ntp.org/3445 introduced a bug whereby a system that is running ntp-4.2.8p12 or p13 that only has one unauthenticated time source can be attacked in a way that causes the victim's next poll to its source to be delayed, for as long as the attack is maintained.<br />http://support.ntp.org/bin/view/Main/NtpBug3592 gives the following mitigations if it is not possible to upgrade to a version with the fix:<br />* Use authentication with symmetric peers.<br />* Have enough sources of time.  The default NTP configuration in Cumulus Linux has four time sources.<br /><br />Fixed: 4.2.8p12+dfsg-4+cl4u13 | 3.7.12-4.1.1 | 4.2.0-4.3.0|
| <a name="2549838"></a> [2549838](#2549838) <a name="2549838"></a> <br />CM-29546 | In vtysh, if you configure, then remove a layer 3 VNI for a VRF, the VNI is removed from zebra even if the VNI interface still exists in the kernel.<br />If you configure a layer 2 VNI as a layer 3 VNI by mistake, removing the layer 3 VNI binding removes it from zebra but EVPN-learned MACs and neighbors are not installed into the kernel.<br />To work around this issue, delete, then re-add the missing VNI. For example:<br /><pre><br />cumulus&#64;switch:~$ sudo ifdown vni10100<br />cumulus&#64;switch:~$ sudo ifup vni10100<br /></pre><br />If you flap the link with the <code>ip link set vni10100 down; ip link set vni10100 up</code> commands, zebra does not re-add the VNI. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2549782"></a> [2549782](#2549782) <a name="2549782"></a> <br />CM-29519 | The JSON format output of the <code>net show bgp l2vpn evpn summary</code> command shows the incorrect neighbour state.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549712"></a> [2549712](#2549712) <a name="2549712"></a> <br />CM-29485 | The following vulnerability affects the openldap package:<br />CVE-2020-12243: A vulnerability was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. LDAP search filters with nested boolean expressions can result in denial of service (slapd daemon crash).<br />Vulnerable: <= 2.4.47+dfsg-3+deb10u1<br />Fixed: 2.4.47+dfsg-3+deb10u2 | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2549677"></a> [2549677](#2549677) <a name="2549677"></a> <br />CM-29471 | After you add or remove a bridge VLAN identifier (VID) on a trunk port, the layer 2 VNI is put into VLAN 1. <br />To work around this issue, revert the configuration change. | 3.7.10-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2549656"></a> [2549656](#2549656) <a name="2549656"></a> <br />CM-29460 | The following security vulnerabilities affect qemu packages, which are available for optional installation on Cumulus Linux:<br />CVE-2019-12068: In QEMU 1:4.1-1, 1:2.1+dfsg-12+deb8u6, 1:2.8+dfsg-6+deb9u8, 1:3.1+dfsg-8~deb10u1, 1:3.1+dfsg-8+deb10u2, and 1:2.1+dfsg-12+deb8u12 (fixed), when executing script in lsi_execute_script(), the LSI scsi adapter emulator advances 's->dsp' index to read next opcode. This can lead to an infinite loop if the next opcode is empty. Move the existing loop exit after 10k iterations so that it covers no-op opcodes as well.<br />CVE-2019-15034: hw/display/bochs-display.c in QEMU 4.0.0 does not ensure a sufficient PCI config space allocation, leading to a buffer overflow involving the PCIe extended config space.<br />CVE-2019-20382: QEMU 4.1.0 has a memory leak in zrle_compress_data in ui/vnc-enc-zrle.c during a VNC disconnect operation because libz is misused, resulting in a situation where memory allocated in deflateInit2 is not freed in deflateEnd.<br />CVE-2020-1983: A use after free vulnerability in ip_reass() in ip_input.c of libslirp 4.2.0 and prior releases allows crafted packets to cause a denial of service.<br />Vulnerable: <= 3.1+dfsg-8+deb10u4<br />Fixed: 3.1+dfsg-8+deb10u5 | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2549511"></a> [2549511](#2549511) <a name="2549511"></a> <br />CM-29385 | The following vulnerability affects the openssl package:<br />CVE-2020-1967: Bernd Edlinger discovered that malformed data passed to the SSL_check_chain() function during or after a TLS 1.3 handshake could cause a NULL dereference, resulting in denial of service.<br />Vulnerable: <= 1.1.1d-0+deb10u2<br />Fixed: 1.1.1d-0+deb10u3 | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2549472"></a> [2549472](#2549472) <a name="2549472"></a> <br />CM-29367 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2549385"></a> [2549385](#2549385) <a name="2549385"></a> <br />CM-29312 | FRR incorrectly orders <code>advertise-all-vni</code> to be later in the configuration than manual <code>rd</code> or <code>route-target</code> definitions. This causes the <code>rd</code> or <code>route-target</code> configuration to be misapplied or not applied at all.<br />To work around this issue, when you manually configure the <code>rd</code> or <code>route-target</code> for a VNI, you must manually edit the <code>/etc/frr/frr.conf</code> file to define <code>advertise-all-vni</code> before the <code>rd</code> or <code>route-target</code> configuration within the <code>l2vpn evpn</code> address family. | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2549371"></a> [2549371](#2549371) <a name="2549371"></a> <br />CM-29309 | When Optimized Multicast Flooding (OMF) is enabled with the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/switchd.conf</code> file, the switch continues to flood IPv6 multicast traffic to all slave ports when there is no MLD join receive. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549347"></a> [2549347](#2549347) <a name="2549347"></a> <br />CM-29296 | The following vulnerabilities have been announced in git, which is available in the repository for optional installation:<br />CVE-2020-5260: Felix Wilhelm of Google Project Zero discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline, the credential helper machinery can be fooled to return credential information for a wrong host.<br />CVE-2020-11008: Carlo Arenas discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline or empty host, or lacks a scheme, the credential helper machinery can be fooled into providing credential information that is not appropriate for the protocol in use and host being contacted.<br />Vulnerable: <= 2.20.1-2+deb10u1 (CVE-2020-5260) <= 2.20.1-2+deb10u2 (CVE-2020-11008)<br />Fixed: 2.20.1-2+deb10u3 | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2549307"></a> [2549307](#2549307) <a name="2549307"></a> <br />CM-29284 | The following vulnerabilities affect git, which is available in the repository for optional installation:<br />CVE-2020-5260: Felix Wilhelm of Google Project Zero discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline, the credential helper machinery can be fooled to return credential information for a wrong host.<br />CVE-2020-11008: Carlo Arenas discovered a flaw in git, a fast, scalable, distributed revision control system. With a crafted URL that contains a newline or empty host, or lacks a scheme, the credential helper machinery can be fooled into providing credential information that is not appropriate for the protocol in use and host being contacted. | 3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2549226"></a> [2549226](#2549226) <a name="2549226"></a> <br />CM-29259 | You might see the following <code>gport</code> error messages in <code>switchd.log</code>:<br /><pre><br />2020-04-10T19:50:01.011224+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x800007a find failed<br />2020-04-10T19:50:01.011631+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x8000009 find failed<br /></pre><br />These messages are harmless and can be ignored. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548988"></a> [2548988](#2548988) <a name="2548988"></a> <br />CM-29178 | On Mellanox switches, the thermal monitoring script starts in suspended mode and, as a result, the fans run at sixty percent. You also see the following log message:<br /><pre><br />hw-management.sh&#91;847&#93;: Thermal algorithm is manually suspend.<br /></pre><br />To work around this issue, run the following command to enable thermal monitoring:<br /><pre><br />cumulus&#64;switch:~$ sudo echo 0 > /var/run/hw-management/config/suspend<br /></pre> | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2548962"></a> [2548962](#2548962) <a name="2548962"></a> <br />CM-29165 | With FRR or OSPF, you might see an inconsistent link-state advertisement. For example, when you configure the OSPF default originate route as metric-type 1 with a specific metric, Cumulus Linux shows the default originate route as an external metric-type 2 route with the default metric in the database. This issue typically occurs when both IPv4 and IPv6 default routes exist in the routing table. | 3.7.12-4.1.1 | 4.2.0-4.3.0|
| <a name="2548933"></a> [2548933](#2548933) <a name="2548933"></a> <br />CM-29151 | The following security vulnerability in the gnutls28 / libgnutls* packages has been announced for Cumulus Linux 4.x (Cumulus Linux 3.x is not vulnerable):<br />CVE-2020-11501: GnuTLS 3.6.x before 3.6.13 uses incorrect cryptography for DTLS. The earliest affected version is 3.6.3 (2018-07-16) because of an error in a 2017-10-06 commit. The DTLS client always uses 32 '\0' bytes instead of a random value, and thus contributes no randomness to a DTLS negotiation. This breaks the security guarantees of the DTLS protocol.<br />Vulnerable: <= 3.6.7-4+deb10u2<br />Not vulnerable: 3.6.7-4+deb10u3 | 4.0.0-4.1.0 | 4.1.1-4.3.0|
| <a name="2548930"></a> [2548930](#2548930) <a name="2548930"></a> <br />CM-29148 | On MLX switches that contain an OSPF IP unnumbered neighborship with a high scale of prefixes being learned, a link flap might cause the neighbor entry to not be programmed in hardware. | 3.7.11-4.2.1 | 4.3.0|
| <a name="2548855"></a> [2548855](#2548855) <a name="2548855"></a> <br />CM-29111 | Due to a packaging error, all switches installed from the same Cumulus Linux image have the same SSH host keys. This affects switches originally installed with Cumulus Linux 4.0.0 and 4.1.0 from a disk image only (including those that were upgraded by <code>apt</code> to a later release).<br /><br />As a result, this issue allows an attacker to more easily bypass remote host verification when a user connects by SSH to what is believed to be a previously used remote host but is really the attacker's host. For example, this issue can be exploited by a spoofing or man-in-the-middle attack.<br /><br />To resolve this issue, generate new SSH host keys for any switch that has Cumulus Linux 4.0.0 or 4.1.0 installed on it:<br /><br /><pre><br />cumulus&#64;switch:~$ sudo rm /etc/ssh/ssh_host*<br />cumulus&#64;switch:~$ sudo dpkg-reconfigure openssh-server<br />cumulus&#64;switch:~$ sudo systemctl restart ssh<br /></pre><br /><br />After generating new SSH host keys, SSH clients that have previously logged into that switch will see a warning that the switch's SSH host key changed; this is expected behavior. Be sure to inform anyone who may log in to the switch that you generated new SSH host keys. These users must log in to the affected switches with their SSH clients, where they will be given instructions on how to remove the old SSH host keys from the known hosts files to avoid a spoofing or man-in-the-middle attack directed at their SSH clients.<br /><br />*Notes* <br /><br />* This issue is fixed in Cumulus Linux 4.1.1. However, we recommend you generate new SSH host keys as this is the most reliable solution.<br />* If you upgrade from Cumulus Linux 4.0.0 or 4.1.0 to version 4.1.1 or later using <code>apt-get</code> and you didn't generate new SSH host keys, you will need to generate new SSH host keys after the upgrade.<br />* If you perform a fresh install of Cumulus Linux 4.1.1 or later using a disk image, you will lose your existing local configuration.<br /> | 4.0.0-4.1.0 | 4.1.1-4.3.0, 4.2.0-4.3.0|
| <a name="2548746"></a> [2548746](#2548746) <a name="2548746"></a> <br />CM-29068 | On the Broadcom switch with the Trident3 ASIC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548710"></a> [2548710](#2548710) <a name="2548710"></a> <br />CM-29057 | The following vulnerability was reported in the bluez package. No bluez packages are installed by default on Cumulus Linux 4.x, but libbluetooth3 is available from the repository for optional installation.<br />CVE-2020-0556: It was reported that the BlueZ's HID and HOGP profile implementations<br />don't specifically require bonding between the device and the host.<br />Malicious devices can take advantage of this flaw to connect to a target<br />host and impersonate an existing HID device without security or to cause<br />an SDP or GATT service discovery to take place which would allow HID<br />reports to be injected to the input subsystem from a non-bonded source. | 4.0.0-4.1.0 | 4.1.1-4.3.0|
| <a name="2548674"></a> [2548674](#2548674) <a name="2548674"></a> <br />CM-29044 | A large number of flapping peers causes FRR to require a corresponding update to internal data structures that track peer information. Updating this internal data structure does not delete links that are down due to the flapping. The size of this array then grows to contain both current peers as well as peers that should have been deleted during the flap processing. The contents of this array is processed by FRR to poll the links, which consumes CPU for all items in the array. This additional polling consumes more CPU than necessary but has no functional impact.<br />To work around this issue, restart FRR. | 3.7.11-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548672"></a> [2548672](#2548672) <a name="2548672"></a> <br />CM-29043 | When a multipath route that contains an EVPN path exists together with an IPv4 BGP path in the VRF, the RMAC to VTEP binding is incorrect. This invalid entry occurs because Cumulus Linux treats IPv4 routes received over the eBGP IPv4 peering incorrectly in the VRF.<br />To work around this issue, remove the unnecessary eBGP IPv4 peering. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548657"></a> [2548657](#2548657) <a name="2548657"></a> <br />CM-29035 | When you upgrade Cumulus Linux on the EdgeCore AS7726-32X or AS7326-56X switch, you might see firmware errors similar to the following:<br /><pre><br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso5.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3.bin for module tg3<br /></pre><br />You can safely ignore these error messages. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548655"></a> [2548655](#2548655) <a name="2548655"></a> <br />CM-29033 | When using <code>apt-get update && apt-get upgrade</code> to upgrade from Cumulus Linux 4.0.0 or 4.1.0 to version 4.1.1 or later, a message similar to the following may appear. <br /><pre><br />Reading package lists... Done<br />E: Repository 'http://apt.cumulusnetworks.com/repo CumulusLinux-4-latest InRelease' changed its 'Label' value from 'cumulus-repository-4.0.0' to 'cumulus-repository-4.1.0'<br />E: Repository 'http://apt.cumulusnetworks.com/repo CumulusLinux-4-latest InRelease' changed its 'Codename' value from 'CumulusLinux-4.0.0' to 'CumulusLinux-4.1.0'<br />N: This must be accepted explicitly before updates for this repository can be applied. See apt-secure(8) manpage for details.<br /></pre><br />To work around this issue and proceed with the upgrade, run <code>apt-get update --allow-releaseinfo-change</code>.  | 4.0.0-4.1.0 | 4.1.1-4.3.0|
| <a name="2548579"></a> [2548579](#2548579) <a name="2548579"></a> <br />CM-28992 | The following security vulnerability has been announced:<br />CVE-2020-10531: An issue was discovered in International Components for Unicode (ICU) for C/C++ through 66.1. An integer overflow, leading to a heap-based buffer overflow, exists in the UnicodeString::doAppend() function in common/unistr.cpp. | 3.7.12, 4.0.0-4.1.0 | 3.7.13-3.7.14, 4.1.1-4.3.0|
| <a name="2548561"></a> [2548561](#2548561) <a name="2548561"></a> <br />CM-28982 | On the EdgeCore Minipack-AS8000, when you try to configure ROCEv2, you see errors indicating that PFC is not working properly. | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2548490"></a> [2548490](#2548490) <a name="2548490"></a> <br />CM-28944 | A change in a route map prefix list that should remove a route might not be reflected in the <code>ospf6</code> database or in peers, and the route might not be deleted. <br />To work around this issue, reenter the <code>redistribute <connected\|static> route-map <route-map-name></code> statement in the configuration. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2548485"></a> [2548485](#2548485) <a name="2548485"></a> <br />CM-28940 | If you configure <code>aggregate-address <address> summary-only</code> before a component of the same aggregate is injected into the BGP table with the <code>network</code> or <code>redistribute</code> command, when you remove the <code>aggregate-address</code> configuration, the component stays suppressed; it is not advertised to peers. For example:<br />Existing configuration:<br /><pre><br />router bgp 1<br /> address-family ipv4 unicast<br />  aggregate-address 50.0.0.0/8 summary-only<br /> exit-address-family<br /></pre><br />If you add <code>network 50.0.0.1/32</code>, you see the following (expected) BGP table entries:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />*> 50.0.0.0         0.0.0.0                            32768 i<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />Removing <code>aggregate-address 50.0.0.0/8 summary-only</code> at this point results in the following (unexpected) BGP table entry:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />To work around this issue, remove, then re-add the component prefix routes. | 3.7.12-4.2.1 | 4.3.0|
| <a name="2548422"></a> [2548422](#2548422) <a name="2548422"></a> <br />CM-28900 | You might see a core file in FRRouting related to OSPFv3 if the switch is configured as both an OSPFv3 ABR and ASBR, and other switches in the same area are also configured as both ABR and ASBR. This issue is not seen with a single ABR or ASBR in an area or if there are multiple ASBRs in an area not acting as ABRs. To work around this issue, do not perform redistribution on more than one ABR in the same area.  | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2548383"></a> [2548383](#2548383) <a name="2548383"></a> <br />CM-28867 | The QuantaMesh BMS T3048-LY8 switch shows a low fan RPM in syslog. | 3.7.5-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548373"></a> [2548373](#2548373) <a name="2548373"></a> <br />CM-28862 | On the Edgecore AS5812 switch, the Innodisk DIMM causes a DIMM temperature sensor absent alert. | 3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548324"></a> [2548324](#2548324) <a name="2548324"></a> <br />CM-28825 | <code>hostapd</code> is not installed in Cumulus Linux 4.0.0 by default.<br />To work around this issue, run the following commands to install the package:<br /><pre><br />cumulus&#64;switch:~$ sudo apt-get update -y<br />cumulus&#64;switch:~$ sudo apt-get install hostapd -y<br /></pre> | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2548320"></a> [2548320](#2548320) <a name="2548320"></a> <br />CM-28821 | When configuring VRF route leaking, if you define <code>import vrf route-map <name></code> but do not have any imported VRFs, the route map command displays incorrectly, and as a result, FRR fails to reload. | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2548315"></a> [2548315](#2548315) <a name="2548315"></a> <br />CM-28816 | The following security advisory has been announced for bash: <br />CVE-2019-18276 Qualys scan QID 372268 setuid vulnerability<br />When bash or bash scripts are run setuid, bash is supposed to drop privileges, but does so incorrectly, so that an attacker with command access to the shell can use <code>enable -f</code> for runtime loading of a new builtin that calls <code>setuid()</code> to regain dropped privileges.<br />To work around this issue, do not make bash or bash scripts <code>setuid</code>. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548289"></a> [2548289](#2548289) <a name="2548289"></a> <br />CM-28794 | When the NETQ agent is active, you see the following errors in in the FFR log file: <br /><pre><br />2020-03-05T16:00:05.036398+09:00 &#91;switch01&#93;&#91;bgpd&#93;&#91;err&#93; &#91;EC 100663314&#93; Attempting to process an I/O event but for fd: 29(4) no thread to handle this!<br />2020-03-05T16:01:30.841455+09:00 &#91;switch01&#91;bgpd&#93;&#91;err&#93; &#91;EC 100663314&#93; Attempting to process an I/O event but for fd: 29(4) no thread to handle this!<br /></pre><br />You also see the following errors in the <code>ptmd</code> log file:<br /><pre><br />2020-03-05T15:59:12.877549+09:00 &#91;switch01&#93;&#91;ptmd&#93;&#91;info&#93; New client connection fd&#91;17&#93; tot&#91;1&#93;<br />2020-03-05T15:59:12.899906+09:00 &#91;switch01&#93;&#91;ptmd&#93;&#91;info&#93; Free client connection fd&#91;17&#93; tot&#91;0&#93;<br /></pre><br />You can ignore these errors. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2548260"></a> [2548260](#2548260) <a name="2548260"></a> <br />CM-28770 | The <code>net add routing route-map <name> permit <seq> set community <comm></code> command does not add the set statement into the <code>/etc/frr/frr.conf</code> file. | 4.0.0-4.3.0 | |
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548117"></a> [2548117](#2548117) <a name="2548117"></a> <br />CM-28659 | In OVSDB traditional bridge mode, adding or removing a VLAN binding causes a traffic forwarding outage for around 20 seconds or more on adjacent VLAN bindings. Cumulus Linux does not support _traditional_ bridge mode with VMware NSX. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548116"></a> [2548116](#2548116) <a name="2548116"></a> <br />CM-28658 | The OVSDB log contains duplicate MAC addresses with the well-known BFD MAC address (00:23:20:00:00:01). This is mainly cosmetic, but clutters the log. | 3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2548113"></a> [2548113](#2548113) <a name="2548113"></a> <br />CM-28656 | In OVSDB VLAN-aware mode, removing a VTEP binding on the NSX controller fails to clean up all interfaces associated with the logical switch. | 3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2548111"></a> [2548111](#2548111) <a name="2548111"></a> <br />CM-28655 | When you remove, then re-add an NSX VTEP binding, the VXLAN VTEP interface is not recreated. | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2548024"></a> [2548024](#2548024) <a name="2548024"></a> <br />CM-28596 | On the Dell Z9100 switch, 100G-SR4 modules might not link up reliably in certain ports. <br />swp1, 2, 3, 9, 10, 23, 24, 30, 31, and 32 might be affected<br />To work around this issue, move 100G SR4 modules to one of the ports not affected by this issue. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547942"></a> [2547942](#2547942) <a name="2547942"></a> <br />CM-28533 | On the Lenovo NE0152T switch, one power supply (PSU2) always show as ABSENT in smonctl. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547911"></a> [2547911](#2547911) <a name="2547911"></a> <br />CM-28510 | The following vulnerabilities were discovered in cURL, an URL transfer library.<br />CVE-2019-5481: Thomas Vegas discovered a double-free in the FTP-KRB code, triggered by a malicious server sending a very large data block.<br />CVE-2019-5482: Thomas Vegas discovered a heap buffer overflow that could be triggered when a small non-default TFTP blocksize is used.<br />Vulnerable: 7.64.0-4<br />Fixed: 7.64.0-4+deb10u1 | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2547881"></a> [2547881](#2547881) <a name="2547881"></a> <br />CM-28489 | The following CVEs were announced for rsyslog:<br />CVE-2019-17041 CVE-2019-17042<br /><br />rsyslogd, when receiving remote log messages (not enabled by default on Cumulus Linux) with the pmaisforwardedfrom or pmcisconames optional log parsers (also not enabled by default on Cumulus Linux), is vulnerable to CVE-2019-17041 and CVE-2019-17042 where malicious messages that appear to be from AIX or Cisco respectively may be caused to skip sanity checks, resulting in incorrect negative lengths causing heap overflows.<br />Vulnerable: 8.1901.0-1<br /><br />Recommendation:<br /><br />Do not enable receiving syslog messages from other hosts by the network (with $UDPServerRun or $InputTCPServerRun).  Also, do not enable (with $ModLoad) the vulnerable parsers pmaixforwardedfrom or pmcisconames.  The default /etc/rsyslog.conf file on Cumulus Linux does not enable any of these.<br /> | 4.0.0-4.3.0 | |
| <a name="2547839"></a> [2547839](#2547839) <a name="2547839"></a> <br />CM-28465 | When you try to configure <code>link-down</code> on a parent interface of a subinterface configured in a VRF, you encounter an error. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547831"></a> [2547831](#2547831) <a name="2547831"></a> <br />CM-28458 | NCLU incorrectly allows you to configure port security on bond/MLAG interfaces.<br />Port security is not supported on bond/MLAG interfaces. | 4.0.0-4.3.0 | |
| <a name="2547799"></a> [2547799](#2547799) <a name="2547799"></a> <br />CM-28451 | An error similar to the following shows in syslog for Mellanox switches:<br /><pre><br />2020-02-12T19:59:22.208012+08:00 leaf01 sx_sdk: RM_TABLE: No resources available to add 1 entries to KVD hash Table HW resource<br />2020-02-12T19:59:22.208124+08:00 leaf01 sx_sdk: PORT: __port_vport_fid_set err = (No More Resources)<br /></pre><br />To work around this issue, reboot the switch. | 3.7.11-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2547784"></a> [2547784](#2547784) <a name="2547784"></a> <br />CM-28442 | PTM mis-detects incorrect hostnames of LLDP neighbors and does not fail them as expected. Instead they end up in an N/A cabling status. | 3.7.11-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547782"></a> [2547782](#2547782) <a name="2547782"></a> <br />CM-28441 | If a LLDP neighbor advertises a <code>PortDescr</code> that contains commas, <code>ptmctl -d</code> splits the string on the commas and misplaces its components in other columns. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547706"></a> [2547706](#2547706) <a name="2547706"></a> <br />CM-28397 | When you configure ganged ports in the <code>ports.conf</code> file, the change does not take effect after you restart <code>switchd</code>. <br />To work around this issue, reboot the switch. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2547667"></a> [2547667](#2547667) <a name="2547667"></a> <br />CM-28376 | On the Dell S5232F-ON switch, the output of <code>ledmgrd</code> shows <code>amber_blinking</code> but <code>smonctl</code> shows all OK. | 3.7.11-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2547663"></a> [2547663](#2547663) <a name="2547663"></a> <br />CM-28374 | When traffic from a double tag interface (facing a different site) is forwarded through VXLAN, the inner tag is not removed. The destination does not know this tag, so it discards it. | 3.7.8-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547659"></a> [2547659](#2547659) <a name="2547659"></a> <br />CM-28372 | On the EdgeCore AS7326-56X switch, the default fan speed, which is defined in the thermal specification, results in excessive fan noise. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547610"></a> [2547610](#2547610) <a name="2547610"></a> <br />CM-28340 | Mellanox switches with the Spectrum A0 ASIC that are integrated with VMware NSX experience BFD connectivity issues with service nodes. As a result, VXLAN tunnels do not work.<br />Mellanox switches with the Spectrum A1 ASIC do **not** have this issue. | 3.7.11-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2547573"></a> [2547573](#2547573) <a name="2547573"></a> <br />CM-28322 | On Tomahawk switches, when the <code>vxlan_tnl_arp_punt_disable</code> option is set to FALSE, ARP packets are not forwarded to the CPU. | 3.7.9-4.0.1 | 4.1.0-4.3.0|
| <a name="2547558"></a> [2547558](#2547558) <a name="2547558"></a> <br />CM-28313 | On the EdgeCore Wedge100 and Facebook Wedge-100S switch, certain physical ports are not correctly mapped to the logical ones. For example:<br />Logical swp39 controls physical swp41<br />Logical swp40 controls physical swp42<br />Logical swp43 controls physical swp45<br />Logical swp44 controls physical swp46<br />This might causes incorrect forwarding behavior. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547509"></a> [2547509](#2547509) <a name="2547509"></a> <br />CM-28276 | When a Trident3 switch receives packets containing an IP checksum value that is not compliant with RFC 1624, the TTL is decremented after a routing operation but the checksum is not recalculated. This results in the IP checksum value being invalid as the packet leaves the switch.  | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547443"></a> [2547443](#2547443) <a name="2547443"></a> <br />CM-28248 | On the Dell N3248PXE-ON switch, 25G SFP ports do not work in 10G mode. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547405"></a> [2547405](#2547405) <a name="2547405"></a> <br />CM-28226 | When you restart the <code>hsflowd</code> service, you see a <code>systemd</code> warning message similar to the following:<br /><pre><br />Warning: The unit file, source configuration file or drop-ins of hsflowd&#64;mgmt.service changed on disk. Run 'systemctl daemon-reload'.<br /></pre> | 4.0.0-4.3.0 | |
| <a name="2547399"></a> [2547399](#2547399) <a name="2547399"></a> <br />CM-28221 | The following security vulnerabilities have been announced in qemu, which is not installed by default on Cumulus Linux but is available in the repository for optional installation:<br />CVE-2019-15890 CVE-2020-7039 CVE-2020-1711: security issues have been found in the SLiRP networking implementation of QEMU, a fast processor emulator, which could result in the execution of arbitrary code or denial of service.<br />https://security-tracker.debian.org/tracker/source-package/qemu<br />Vulnerable: <= 3.1+dfsg-8+deb10u3<br />Fixed: 3.1+dfsg-8+deb10u4 | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2547396"></a> [2547396](#2547396) <a name="2547396"></a> <br />CM-28218 | The following security vulnerability affects libidn2, which is installed by default on Cumulus Linux:<br />CVE-2019-18224: A heap-based buffer overflow vulnerability was discovered in the idn2_to_ascii_4i() function in libidn2, the GNU library for Internationalized Domain Names (IDNs), which could result in denial of service, or the execution of arbitrary code when processing a long domain string. For more information, see:<br />https://security-tracker.debian.org/tracker/libidn2<br />https://security-tracker.debian.org/tracker/CVE-2019-18224<br />Vulnerable: 2.0.5-1<br />Fixed: 2.0.5-1+deb10u1 | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2547360"></a> [2547360](#2547360) <a name="2547360"></a> <br />CM-28200 | The Mellanox SN3700C switch experiences a kernel memory leak in the bridge IPv4 multicast receive function. When IGMP snooping is disabled, received IGMP packets are cloned and the clone is not freed, causing a memory leak.<br />Because this memory leak is in the kernel, you cannot clear it by restarting a service; you must reboot the switch to clear the allocated memory. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2547341"></a> [2547341](#2547341) <a name="2547341"></a> <br />CM-28189 | When <code>host-resources</code> and <code>ucd-snmp-mib</code> are polled, you see permission denied messages similar to the following:<br /><pre><br />Jan 30 19:22:53 switch123 snmpd&#91;23172&#93;: Cannot statfs /sys/kernel/debug/tracing: Permission denied<br /></pre> | 3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547303"></a> [2547303](#2547303) <a name="2547303"></a> <br />CM-28169 | On the Dell Z9264F-ON switch, the CPU core temperature sensors report ABSENT. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547293"></a> [2547293](#2547293) <a name="2547293"></a> <br />CM-28160 | On the Broadcom Trident3 switch with DHCP relay, where the DHCP server is reachable through the EVPN overlay, DHCP discover packets forwarded to the CPU might appear corrupt and might not get forwarded. | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547286"></a> [2547286](#2547286) <a name="2547286"></a> <br />CM-28156 | NCLU crashes when you run the <code>net add interface storage-optimized pfc</code> command because non-ASCII quotes exist in the <code>datapath.conf</code> file.<br />To work around this issue, manually edit the <code>/usr/lib/python2.7/dist-packages/cumulus/__chip_config/mlx/datapath.conf</code> file and replace the non-ASCII single quotes with ASCII single quotes (standard single quote on the keyboard). | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2547266"></a> [2547266](#2547266) <a name="2547266"></a> <br />CM-28150 | On the Broadcom switch with the Trident3 ASIC, the ECN-CE bit is set by default on transit traffic. This might result in hosts adjusting traffic behavior if they are configured for the ECN feature. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2547246"></a> [2547246](#2547246) <a name="2547246"></a> <br />CM-28136 | The MLAG switch pair has VLANs defined that are not used on MLAG bonds. These VLANs still synchronize MAC addresses across to the peer switch. This results in log messages that indicate a MAC address is installed and the VLAN is not defined; for example:<br /><pre><br />RTM_NEWNEIGH with unconfigured vlan XXXX on port peerlink<br /></pre> | 3.7.10-3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2547205"></a> [2547205](#2547205) <a name="2547205"></a> <br />CM-28119 | On the Delta AG6248C switch, the NCLU <code>net show system sensors</code> command shows an error:<br /><pre><br />Could not collect output from command: &#91;'/usr/sbin/smonctl'&#93;<br /></pre><br />To work around this issue, run the <code>net show system sensors json</code> command instead. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2547154"></a> [2547154](#2547154) <a name="2547154"></a> <br />CM-28090 | Two security issues were found in the Python interface to the apt package manager, which is installed by default on Cumulus Linux; package downloads from unsigned repositories were incorrectly rejected (CVE-2019-15796) and the hash validation relied on MD5 (CVE-2019-15795).<br />For more information, see https://security-tracker.debian.org/tracker/source-package/python-apt<br />Vulnerable: 1.8.4<br />Fixed: 1.8.4.1 | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2547149"></a> [2547149](#2547149) <a name="2547149"></a> <br />CM-28087 | The last eight ports of the EdgeCore AS4610-54P switch (swp41 through swp48) do not power UPOE access points. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547147"></a> [2547147](#2547147) <a name="2547147"></a> <br />CM-28086 | The <code>ospfd</code> daemon might crash with the following kernel trace: <br /><pre><br />2019-11-06T23:00:08.261749+09:00 cumulus ospfd&#91;5339&#93;: Assertion 'node' failed in file ospfd/ospf_packet.c, line 671, function ospf_write<br /></pre> | 3.7.11-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2547128"></a> [2547128](#2547128) <a name="2547128"></a> <br />CM-28081 | The cumulus-overrides package contains the <code>/etc/apt/preferences.d/20_prefer_cumulus</code> file that pins packages from specific release names. The pinning file contains the wrong name.<br />To work around this issue, use the origin instead of the release name. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2547123"></a> [2547123](#2547123) <a name="2547123"></a> <br />CM-28078 | On the Broadcom switch with the Trident3 ASC, packet priority remark values assigned from each internal CoS value continue to work with default values; if you change the internal CoS value, the change does not take effect. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547122"></a> [2547122](#2547122) <a name="2547122"></a> <br />CM-28077 | An unhandled exception might occur after you run the <code>sudo poectl -i</code> command. In addition, random <code>poed</code> daemon restarts can occur without any unhandled exceptions but with an invalid response length error. Both issues can occur due to a SerialException.<br />To work around this issue, power cycle the switch. A software reboot does not resolve the issue. | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547120"></a> [2547120](#2547120) <a name="2547120"></a> <br />CM-28076 | After you hot swap a PSU, the <code>decode-syseeprom -t psuX</code> command shows the old PSU information (such as the serial number), until you run the <code>decode-syseeprom --init</code> command. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2547118"></a> [2547118](#2547118) <a name="2547118"></a> <br />CM-28074 | The following security vulnerabilities have been announced in the libtiff5 library on Cumulus Linux 4.0:<br />CVE-2019-14973, CVE-2019-17546: Multiple integer overflows have been discovered in the libtiff library and the included tools.<br />Vulnerable: 4.0.10-4<br />Fixed: 4.1.0+git191117-2~deb10u1 | 3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2547100"></a> [2547100](#2547100) <a name="2547100"></a> <br />CM-28061 | On switches with the Trident3 ASIC, PFC is not working as expected. If you set the PFC for only one CoS,  pause frames are sent for all CoS traffic. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2547071"></a> [2547071](#2547071) <a name="2547071"></a> <br />CM-28048 | On the Lenovo NE2580 switch, the fan speeds are higher than expected within normal operating conditions. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547043"></a> [2547043](#2547043) <a name="2547043"></a> <br />CM-28038 | After you convert a bond back to a layer 2 access port, ifupdown2 changes all SVI MTUs to 1500. <br />To work around this issue, run <code>ifreload -a</code> a second time. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2547013"></a> [2547013](#2547013) <a name="2547013"></a> <br />CM-28016 | On the Mellanox Spectrum switch, <code>switchd</code> can sometimes fail when PBR rules are installed or removed from hardware if the rule is setting a next hop learned via a routing protocol. | 3.7.7-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546991"></a> [2546991](#2546991) <a name="2546991"></a> <br />CM-28003 | The FRR service does not provide a way for automation to know if the configuration applied properly.<br />To work around this issue, execute the <code>vtysh -f <file></code> command in the automation file before starting the FRR service to validate the functional configuration and return an error code. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546988"></a> [2546988](#2546988) <a name="2546988"></a> <br />CM-28000 | The following security advisory has been announced for the libxen packages, which are not installed by default in Cumulus Linux but are available in the repository for installation:<br />Debian Security Advisory DSA-4602-1<br />CVE-2019-17349 CVE-2019-17350 CVE-2019-18420 CVE-2019-18421<br />CVE-2019-18422 CVE-2019-18423 CVE-2019-18424 CVE-2019-18425<br />CVE-2019-19577 CVE-2019-19578 CVE-2019-19579 CVE-2019-19580<br />CVE-2019-19581 CVE-2019-19582 CVE-2019-19583 CVE-2018-12207<br />CVE-2018-12126 CVE-2018-12127 CVE-2018-12130 CVE-2019-11091<br />CVE-2019-11135 CVE-2019-17348 CVE-2019-17347 CVE-2019-17346<br />CVE-2019-17345 CVE-2019-17344 CVE-2019-17343 CVE-2019-17342<br />CVE-2019-17341 CVE-2019-17340<br />Multiple vulnerabilities have been discovered in the Xen hypervisor, which<br />could result in denial of service, guest-to-host privilege escalation or<br />information leaks.<br />In addition this update provides mitigations for the "TSX Asynchronous Abort"<br />speculative side channel attack. For additional information, refer to<br />https://xenbits.xen.org/xsa/advisory-305.html<br />For more information, see https://security-tracker.debian.org/tracker/xen .<br />Fixed version: 4.11.3+24-g14b62ab3e5-1~deb10u1. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2546985"></a> [2546985](#2546985) <a name="2546985"></a> <br />CM-27999 | On the EdgeCore AS7326-56X switch, the PSU fans show constant LOW warnings. | 3.7.10-3.7.12, 4.0.0-4.2.0 | 3.7.13-3.7.14, 4.2.1-4.3.0|
| <a name="2546951"></a> [2546951](#2546951) <a name="2546951"></a> <br />CM-27982 | <code>switchd</code> crashes when dynamic VRF route leaking is enabled and the following is true:<br />* The default route is leaked from VRF1 to VRF2<br />* Hardware-based dynamic VRF route leaking is configured (<code>vrf_route_leak_enable_dynamic</code> is set to TRUE in the <code>/etc/cumulus/switchd.conf</code> file). <br />You might see logs similar to the following in <code>/var/log/syslog</code>:<br /><pre><br />kernel: &#91;159400.526241&#93; switchd&#91;21374&#93;: segfault at 1229cdd84 ip 00000000004142ca sp 00007ffd557a86d0 error 4 in switchd&#91;400000+71000&#93;<br /></pre><br />To work around this issue, use a route map to filter the default route (the source VRF is imported into the destination VRF). | 3.7.10-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2546895"></a> [2546895](#2546895) <a name="2546895"></a> <br />CM-27957 | If you have configured a higher number of ports and VLANs (ports x VLANs) or the switch is a lower-powered (CPU) platform, the <code>switchd</code> service might fail to send a <code>systemd keepalive</code> within the watchdog timeout value (2 minutes by default) and you see an error similar to the following:<br /><pre><br />bq. systemd&#91;1&#93;: switchd.service watchdog timeout (limit 2min)!<br /></pre><br />To workaround this issue, either reduce the number of configured interfaces and, or VLANs, or increase the <code>systemd</code> timeout for <code>switchd.service</code>.<br />To increase the <code>systemd</code> timeout:<br /># Edit the <code>/etc/systemd/system/switchd.service.d/override.conf</code> file and increase the <code>WatchdogSec</code> parameter.<br /># Restart the <code>switchd</code> service with the <code>sudo systemctl restart switchd.service</code> command.<br /><code>systemd</code> will attempt to restart the <code>switchd</code> service automatically (after the watchdog timeout). If the restart fails multiple times in a short time period, run the <code>sudo systemctl reset-failed</code> command followed by the <code>sudo systemctl restart switchd</code> command.<br /> | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546874"></a> [2546874](#2546874) <a name="2546874"></a> <br />CM-27950 | On the Dell S5232F, S5248F, S5296F, and S3048 switch, using the <code>poweroff</code> or <code>halt</code> commands does not fully power off the switch. | 4.0.0-4.3.0 | |
| <a name="2546869"></a> [2546869](#2546869) <a name="2546869"></a> <br />CM-27947 | Broadcom Field Alert - SID - MMU 2B Errors<br />A few of the MMU memories on Broadcom switches are grouped together with single parity control. During SER correction when a parity error occurs on one of those groups, other memory in that group might also report a SER error. This occurs when the memory is accessed either by a packet hit or through a schan operation. This issue can cause SER errors in other memory and cause traffic mis-forwarding or a packet drop. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546739"></a> [2546739](#2546739) <a name="2546739"></a> <br />CM-27875 | The Mellanox SN3700C switch does not forward LLDP or LACP traffic. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2546703"></a> [2546703](#2546703) <a name="2546703"></a> <br />CM-27855 | The FRR cl-support module times out on switches on the ARM platform even when the switch is not under heavy load.<br />To work around this issue, run the <code>cl-support -M</code> command to disable timeouts. | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546577"></a> [2546577](#2546577) <a name="2546577"></a> <br />CM-27814 | A traditional bridge with QinQ and a VNI does not work for tagged traffic. | 3.7.10-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2546559"></a> [2546559](#2546559) <a name="2546559"></a> <br />CM-27801 | On the Mellanox SN3700C switch, if you try to break out 100G switch ports into 2x50G, the configuration fails and <code>switchd</code> does not restart. Breaking out the ports into 4x25G works without issue. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2546542"></a> [2546542](#2546542) <a name="2546542"></a> <br />CM-27793 | A security vulnerability has been announced in the cyrus-sasl2 (libsasl2-2 and libsasl2-modules) package. The libraries are installed by default on Cumulus Linux.<br />CVE-2019-19906: Stephan Zeisberg reported an out-of-bounds write vulnerability in the _sasl_add_string() function in cyrus-sasl2, a library implementing the Simple Authentication and Security Layer. A remote attacker can take advantage of this issue to cause denial-of-service conditions for applications using the library.<br />Vulnerable: 2.1.27+dfsg-1<br />Fixed: 2.1.27+dfsg-1+deb10u1 | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2546502"></a> [2546502](#2546502) <a name="2546502"></a> <br />CM-27764 | On the EdgeCore AS7326-56X switch, eth0 and swp1 use the same MAC address. | 3.7.9-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546485"></a> [2546485](#2546485) <a name="2546485"></a> <br />CM-27753 | The EdgeCore Minipack-AS8000 switch supports FEC RS by default; you cannot disable this setting. However, the <code>ethtool --show-fec</code> command output indicates that FEC is disabled. Also, if you try to change the FEC setting, Cumulus Linux reports an error. For example:<br /><pre><br />cumulus&#64;switch:~$  net add interface swp23 link speed 100000<br />cumulus&#64;switch:~$  net add interface swp23 link autoneg off<br />cumulus&#64;switch:~$  net add interface swp23 link fec rs<br />"/sbin/ifreload -a" failed:<br />error: swp23: cmd '/sbin/ethtool --set-fec swp23 encoding rs' failed: returned 255 (Cannot set FEC settings: Operation not supported)<br />Command '&#91;'/sbin/ifreload', '-a'&#93;' returned non-zero exit status 1<br /></pre> | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2546454"></a> [2546454](#2546454) <a name="2546454"></a> <br />CM-27740 | When you run the NCLU <code>net del all</code> command to delete all configuration on the switch, you see an error similar to the following:<br /><pre><br />ERROR: &#91;Errno 2&#93; No such file or directory: '/cumulus/switchd/config/interface/<swp>/port_security/enable'#012Traceback<br /></pre> | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2546423"></a> [2546423](#2546423) <a name="2546423"></a> <br />CM-27719 | Several vulnerabilities have been discovered in the interpreter for the Ruby language, which could result in unauthorized access by bypassing intended path matchings, denial of service, or the execution of arbitrary code.<br />These vulnerabilities affect the ruby2.5 package that is available for optional installation in Cumulus Linux 4.x, but is not installed by default.<br />CVE-2019-15845: Ruby through 2.4.7, 2.5.x through 2.5.6, and 2.6.x through 2.6.4 mishandles path checking within File.fnmatch functions.<br />CVE-2019-16201: WEBrick::HTTPAuth::DigestAuth in Ruby through 2.4.7, 2.5.x through 2.5.6, and 2.6.x through 2.6.4 has a regular expression Denial of Service cause by looping/backtracking. A victim must expose a WEBrick server that uses DigestAuth to the Internet or a untrusted network.<br />CVE-2019-16254: Ruby through 2.4.7, 2.5.x through 2.5.6, and 2.6.x through 2.6.4 allows HTTP Response Splitting. If a program using WEBrick inserts untrusted input into the response header, an attacker can exploit it to insert a newline character to split a header, and inject malicious content to deceive clients.<br />CVE-2019-16255: Ruby through 2.4.7, 2.5.x through 2.5.6, and 2.6.x through 2.6.4 allows code injection if the first argument (aka the "command" argument) to Shell#&#91;&#93; or Shell#test in lib/shell.rb is untrusted data. An attacker can exploit this to call an arbitrary Ruby method.<br />Vulnerable: 2.5.5-3 | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2546389"></a> [2546389](#2546389) <a name="2546389"></a> <br />CM-27699 | In a default VX instance, a ping to a device's hostname fails.<br />To work around this issue, edit the <code>/etc/gai.conf</code> file and uncomment <code>precedence ::ffff:0:0/96  10</code>.<br /> | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2546337"></a> [2546337](#2546337) <a name="2546337"></a> <br />CM-27678 | The <code>net show bridge macs</code> command returns an empty interface column.<br />To work around this issue, run the <code>bridge fdb show</code> command to show the interface. | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2546329"></a> [2546329](#2546329) <a name="2546329"></a> <br />CM-27670 | A memory leak in <code>switchd</code> might occur, which causes <code>switchd</code> to restart. | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546266"></a> [2546266](#2546266) <a name="2546266"></a> <br />CM-27645 | Several vulnerabilities have been discovered in git, a fast, scalable,<br />distributed revision control system, which is installed by default on Cumulus Linux 4.x.<br />CVE-2019-1348: export-marks is insecure, fix is to disable by default.<br />CVE-2019-1349: .git / git~1 filename vulnerability on NTFS<br />CVE-2019-1352: .git vulnerability with NTFS Alternate Streams Accesses<br />CVE-2019-1353: NTFS filesystem protection should be on by default<br />CVE-2019-1387: dubiously-nested submodule git directories should be disallowed<br />CVE-2019-19604: submodule update repository code execution vulnerability<br />Vulnerable: <= 2.20.1-2<br />Fixed: 2.20.1-2+deb10u1 | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2546265"></a> [2546265](#2546265) <a name="2546265"></a> <br />CM-27644 | Ifupdown2 does not set up the front panel interface for the <code>dhclient</code> to accept the DHCP OFFER.<br />To work around this issue, restart the networking service after <code>ifreload -a</code> with the <code>systemctl restart networking</code> command. | 3.7.10-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2546261"></a> [2546261](#2546261) <a name="2546261"></a> <br />CM-27642 | The following CVEs were announced that affect the libssh package:<br />CVE-2019-14889 has been announced in the libssh library, where unsanitized user-provided scp command lines could allow an attacker to execute arbitrary commands on the server.<br />The libssh library is not installed on Cumulus Linux by default, but is available in the Cumulus Linux 4 repository for optional installation. Note that libssh is distinct from libssh2 and openssh, which are present on the switches and in the repositories.<br />See the following for more information:<br />https://www.libssh.org/security/advisories/CVE-2019-14889.txt<br />https://security-tracker.debian.org/tracker/CVE-2019-14889 | 4.0.0-4.3.0 | |
| <a name="2546255"></a> [2546255](#2546255) <a name="2546255"></a> <br />CM-27637 | On the EdgeCore Minipack-AS8000 switch, a 100G DAC link does not come up when auto-negotiation is enabled on the neighbor. This switch does not support 100G DAC auto-negotiation at this time. | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2546225"></a> [2546225](#2546225) <a name="2546225"></a> <br />CM-27627 | When you execute the following command on the Delta AG6248C switch, the switch reboots and then comes right back into Cumulus Linux without installing the new image. The install image is still in <code>/var/lib/cumulus/installer</code>, which causes issues with cl-support. <br /> <pre> <br /> sudo onie-install -fai http://<path to image> <br /> sudo reboot <br /> </pre> <br /> To work around this issue, use the <code>onie-select</code> command to access ONIE, and then use the <code>nos-install</code> command in ONIE to install a new binary image.  | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546201"></a> [2546201](#2546201) <a name="2546201"></a> <br />CM-27619 | The following security vulnerabilities have been announced in the nss/libnss3 library, which is not installed by default but is available in the repository:<br />CVE-2019-11745: Out-of-bounds write when passing an output buffer smaller than the block size to NSC_EncryptUpdate<br />CVE-2019-17007: nss: Handling of Netscape Certificate Sequences in CERT_DecodeCertPackage() may crash with a NULL deref leading to DoS<br />See https://security-tracker.debian.org/tracker/source-package/nss for more information.<br />Vulnerable: <= 3.42.1-1+deb10u1 | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2546141"></a> [2546141](#2546141) <a name="2546141"></a> <br />CM-27586 | CPU usage might be higher than normal if you have a high number of interfaces x VLANs and <code>lldpd</code> is active. This issue is introduced with code changes in Cumulus Linux 3.7.11, where VLAN information is now available for LLDP to advertise to neighbors (&#91;https://docs.cumulusnetworks.com/version/cumulus-linux-37/Layer-2/Link-Layer-Discovery-Protocol/#vlan-dot1-tlv&#93;). You might see high CPU usage even if VLAN (dot1) TLV configuration is disabled. <br />To check if <code>lldpd</code> is the heavy CPU resource user, run the following command:<br /><pre><br />cumulus&#64;switch:~$  ps -eo user,pid,ppid,cmd,%mem,%cpu --sort=-%cpu \| head<br /></pre><br />Alternatively, check for messages in the <code>/var/log/syslog</code> directory similar to:<br /><pre><br />2020-02-20T15:02:12.137857-05:00 leaf01 sysmonitor: High CPU use: 87%<br />2020-02-20T15:02:12.482398-05:00 leaf01 sysmonitor:   PID USER      PR    VIRT    RES %CPU %MEM     TIME+ COMMAND<br />2020-02-20T15:02:12.483112-05:00 leaf01 sysmonitor:  1570 _lldpd    20   73244  13800 76.6  0.3   4:43.06 lldpd<br /></pre><br />*Note*: The exact amount of CPU usage varies in each network based on a number of factors; however, it is unusual for <code>lldpd</code> to consume more than 30% CPU for an extended period of time.<br />To work around this issue, you can do one of the following:<br />* If the large number of VLANs is not absolutely necessary, manually prune the VLAN allowed list (if you use the range 1-2999, modify the <code>bridge-vids</code> list to include the VLANs being used).<br />* Stop the <code>lldpd</code> service. (This approach might be undesirable if the switch is providing services that rely on LLDP such as Voice VLAN.) To stop the <code>lldpd</code> service (runtime setting), run the <code>sudo systemctl stop lldpd.service</code> command. To disable the <code>lldpd</code> service upon boot, run <code>sudo systemctl disable lldpd.service</code>. | 3.7.11-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2546131"></a> [2546131](#2546131) <a name="2546131"></a> <br />CM-27581 | On the Delta AG-6248C PoE switch, when you run the <code>apt upgrade</code> command, the upgrade does not work. Cumulus Linux uses <code>uboot</code> directly instead of <code>grub</code> to boot the kernel. Uboot needs a special header to boot the kernel, which is not present. Without this header, when you use the <code>apt upgrade</code> command to upgrade Linux packages, <code>uboot</code> is unable to boot up the kernel. <br />To work around this issue, upgrade Cumulus Linux by installing the Cumulus Linux image. Run the <code>onie-select</code> command to go into ONIE, and then use the <code>nos-install</code> command in ONIE to install a new image.<br />This workaround only works when an out-of-band network is present. | 3.7.11-4.1.1 | 4.2.0-4.3.0|
| <a name="2546061"></a> [2546061](#2546061) <a name="2546061"></a> <br />CM-27547 | Trident2+ switches do not enable DFE for 10G and 4x10G DACs. As a result, longer or marginal 10G DACs might not link up reliably.<br />To work around this issue, run the following command after a reboot.<br />On the SFP side:<br /><pre><br />echo CR > /cumulus/switchd/config/interface/swp${port}/interface_mode ; done<br /></pre><br />On the QSFP side:<br /><pre><br />echo CR > /cumulus/switchd/config/interface/swp${port}/interface_mode ; done<br /></pre> | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2545988"></a> [2545988](#2545988) <a name="2545988"></a> <br />CM-27517 | When <code>hsflowd</code> is used on the switch, you might experience a kernel panic. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2545949"></a> [2545949](#2545949) <a name="2545949"></a> <br />CM-27496 | All Broadcom Trident3 X7 switches contain PCIE firmware, which is programmed by the vendor when the switch is manufactured. The latest version of this firmware (2.6) is incompatible with Cumulus Linux 3.7.11 and earlier, and Cumulus Linux 4.0. <br />To work around this issue, downgrade the Broadcom ASIC firmware to an earlier version. | 3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2545934"></a> [2545934](#2545934) <a name="2545934"></a> <br />CM-27489 | Mellanox switches might experience higher CPU usage from the <code>sx_sdk</code> service or when BFD is in use.<br />To work around this issue, disable BFD to alleviate some of the CPU load. | 3.7.13, 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2545868"></a> [2545868](#2545868) <a name="2545868"></a> <br />CM-27457 | If you delete, then re-add a PBR policy on an interface, the configured PBR policy is not programmed in the kernel or <code>switchd</code>. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545866"></a> [2545866](#2545866) <a name="2545866"></a> <br />CM-27456 | After making a series of PBR configuration changes using NCLU commands, the stale PBR entry is still present in the kernel. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545851"></a> [2545851](#2545851) <a name="2545851"></a> <br />CM-27454 | The Mellanox minimal platform module driver probe does not handle error conditions correctly.<br />To work around this issue, power cycle the  switch. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2545837"></a> [2545837](#2545837) <a name="2545837"></a> <br />CM-27444 | If you use the NCLU commands to configure NTP and run the <code>net add time ntp source <interface></code> command before you run the <code>net add time ntp server <server> iburst</code> command, the <code>/etc/ntp.conf</code> file is misconfigured.<br />To work around this issue, run the <code>net add time ntp server <server> iburst</code> command before you run the <code>net add time ntp source <interface></code> command. | 3.7.10-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2545724"></a> [2545724](#2545724) <a name="2545724"></a> <br />CM-27367 | On the Mellanox switch with the Spectrum or Spectrum-2 ASIC, <code>switchd</code> might crash, then restart under certain conditions. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2545608"></a> [2545608](#2545608) <a name="2545608"></a> <br />CM-27299 | The protocol daemon <code>bgpd</code> crashes when a link/neighbor flaps if static routes pointing to Null0 are advertising through BGP.<br />To work around this issue, reboot the switch, then remove the static routes or stop advertising these routes. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545600"></a> [2545600](#2545600) <a name="2545600"></a> <br />CM-27295 | IPv6 table rules might affect forwarding. For example, if you create the following rule in the <code>/etc/cumulus/acl/policy.d/03-sshd.rules</code> file, the rule counter increments but IPv4 SSH traffic might be dropped.<br /><pre><br />&#91;ip6tables&#93;<br />-A INPUT -p tcp --dport 22 -j DROP<br /></pre> | 3.7.2-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2545570"></a> [2545570](#2545570) <a name="2545570"></a> <br />CM-27275 | CVE-2018-12207: Improper invalidation for page table updates by a virtual guest operating system for multiple Intel(R) Processors may allow an authenticated user to potentially enable denial of service of the host system via local access.<br />Running hypervisors for virtual guest operating systems is not supported on Cumulus Linux.  Additionally, an affected package qemu is not included in the image, although it is available on upstream repo mirrors.   | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2545566"></a> [2545566](#2545566) <a name="2545566"></a> <br />CM-27272 | The Dell Z9100-ON switch incorrectly reports many sensors as ABSENT. | 3.7.12-4.0.1 | 4.1.0-4.3.0|
| <a name="2545537"></a> [2545537](#2545537) <a name="2545537"></a> <br />CM-27254 | On the Mellanox switch with the Spectrum and Spectrum-2 ASIC, IPv6 egress ACLs are not supported on subinterfaces. | 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2545520"></a> [2545520](#2545520) <a name="2545520"></a> <br />CM-27243 | The length of the netlink message is not set properly for non-bridge family type messages. The same length is used for both bridge and non-bridge even though the bridge family type message has an extra attribute. This causes extra bytes to be left over in non-bridge family type netlink messages. | 3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2545501"></a> [2545501](#2545501) <a name="2545501"></a> <br />CM-27229 | On a traditional bridge, VLAN tagged traffic is not discarded when it exceeds the port security MAC limit. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2545448"></a> [2545448](#2545448) <a name="2545448"></a> <br />CM-27193 | The <code>l1-show</code> command prints a traceback for switch ports that have sub-interfaces configured. There is no functional impact to traffic but the <code>l1-show</code> troubleshooting and validation command does not execute on switch ports that have VLAN sub-interfaces. | 3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545437"></a> [2545437](#2545437) <a name="2545437"></a> <br />CM-27184 | With the port security feature, if you change the number of MAC addresses allowed to access a port with the NCLU <code>net add interface <port> port-security mac-limit <number></code> command, the <code>net show configuration commands</code> command might fail. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2545410"></a> [2545410](#2545410) <a name="2545410"></a> <br />CM-27179 | On rare occasions on a Mellanox SN3700C switch, if you insert and remove, then reinsert an AOC or QSFP28 optical transceiver quickly, port #32 might get stuck.<br />To avoid this issue, wait 15 seconds before insertion and before removal of the module. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2545404"></a> [2545404](#2545404) <a name="2545404"></a> <br />CM-27173 | On the Trident3 switch, unicast ARP packets received on a VNI and forwarded to the CPU are not policed. | 3.7.10-3.7.13, 4.0.0-4.0.1 | 3.7.14, 4.1.0-4.3.0|
| <a name="2545362"></a> [2545362](#2545362) <a name="2545362"></a> <br />CM-27143 | On the Dell S5248F-ON switch, the CPU core temperature sensors show <code>ABSENT</code>. | 4.0.0-4.3.0 | |
| <a name="2545352"></a> [2545352](#2545352) <a name="2545352"></a> <br />CM-27136 | With a high number of active routes (20K or more), when you perform a networking restart, the FRR log files might become flooded with error messages associated with the restart. These logs are normal and are not directly a problem. However, the large number of messages can cause the logs to _rotate away_ any previous history, which prevents you from tracing back events leading up to the restart. In a troubleshooting environment, this can be problematic. | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2545314"></a> [2545314](#2545314) <a name="2545314"></a> <br />CM-27118 | The Broadcom switch with the Tomahawk3 ASIC, such as the EdgeCore Minipack AS8000, might not learn all MAC address on a port configured for bridging when the hardware MAC table is near the maximum capacity. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2545239"></a> [2545239](#2545239) <a name="2545239"></a> <br />CM-27099 | On the Mellanox switch with the Spectrum-2 ASIC, Precision Time Protocol (PTP) is not currently supported.  | 4.0.0-4.3.0 | |
| <a name="2545236"></a> [2545236](#2545236) <a name="2545236"></a> <br />CM-27096 | On the Edgecore AS6812 switch, you might see rare I2C errors. | 3.7.2-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545233"></a> [2545233](#2545233) <a name="2545233"></a> <br />CM-27094 | On the Delta AG9032v1 switch, smonctl and sensors report inaccurate PSU current and power. | 4.0.0-4.3.0 | |
| <a name="2545164"></a> [2545164](#2545164) <a name="2545164"></a> <br />CM-27049 | On the Mellanox switch with the Spectrum 2 ASIC, interfaces using 100G or 200G Direct Attach Cables (DACs) do not come up with the interface default configuration.<br />To work around this issue and bring the interfaces up, perform the following configuration on both sides of the link:<br />* Set the interface speed to the desired speed<br />* Set link auto-negotiation to _off_<br />* Set link FEC to RS mode | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2545133"></a> [2545133](#2545133) <a name="2545133"></a> <br />CM-27025 | On the Mellanox switch, ACL lookups are performed for VLAN matches when no rules with <code>UNTAGGED</code> match are present. | 3.7.2-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545125"></a> [2545125](#2545125) <a name="2545125"></a> <br />CM-27018 | If you configure more than one VRR interface on an SVI interface, deleting one of the VRR addresses does not remove the interface/address.  | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2545087"></a> [2545087](#2545087) <a name="2545087"></a> <br />CM-26996 | On the Mellanox switch with the Spectrum ASIC, the <code>--set-burst</code> parameter in an iptables rule does not take effect. | 3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545049"></a> [2545049](#2545049) <a name="2545049"></a> <br />CM-26968 | When networking fails to start properly, an MLAG memory leak occurs, which might cause memory issues. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2545040"></a> [2545040](#2545040) <a name="2545040"></a> <br />CM-26961 | On the Mellanox switch, error messages with <code>hw-management-thermal-events.sh</code> are displayed on shutdown. | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2545012"></a> [2545012](#2545012) <a name="2545012"></a> <br />CM-26942 | Port security is not currently supported on VX. The NCLU commands produce errors. | 4.0.0-4.3.0 | |
| <a name="2544978"></a> [2544978](#2544978) <a name="2544978"></a> <br />CM-26921 | If you delete an undefined bond, then add a bond slave, the <code>net commit</code> command fails. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544968"></a> [2544968](#2544968) <a name="2544968"></a> <br />CM-26913 | FRR configuration commands for an SVI interface might have the <code>\n</code> misplaced in the output.  For example:<br /><pre><br />sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />should be:<br /><pre><br />sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />To work around this issue, configure the interface manually in the <code>/etc/frr/frr.conf</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544957"></a> [2544957](#2544957) <a name="2544957"></a> <br />CM-26907 | NCLU incorrectly allows you to apply port security configuration on layer 2 and layer 3 ports that are not part of a bridge. | 4.0.0-4.3.0 | |
| <a name="2544953"></a> [2544953](#2544953) <a name="2544953"></a> <br />CM-26905 | When you update the hostname of a switch with the NCLU <code>net add hostname <hostname></code> command, then run <code>net commit</code>, the <code>lldpd</code> service does not restart and other devices still see the old hostname.<br />To work around this issue, run the <code>sudo systemctl restart lldpd.service</code> command. | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544904"></a> [2544904](#2544904) <a name="2544904"></a> <br />CM-26875 | After you delete an IPv6 numbered BGP peer group neighbor, Cumulus Linux might continue to send route advertisements.<br />To work around this issue, restart FRR after removing the IPv6 numbered configuration. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544880"></a> [2544880](#2544880) <a name="2544880"></a> <br />CM-26860 | When you run the NCLU <code>net show commit last</code> or <code>net show commit <number></code> command, where <code><number></code> is the last commit, no output is shown.  | 4.0.0-4.3.0 | |
| <a name="2544856"></a> [2544856](#2544856) <a name="2544856"></a> <br />CM-26841 | In the <code>ethool -m</code> output, the Revision Compliance field might show <code>Unallocated</code> when the SFF-8363 Revision Compliance value is SFF-8636 version 2.8 or later. | 4.0.0-4.1.1 | 4.2.0-4.3.0|
| <a name="2544854"></a> [2544854](#2544854) <a name="2544854"></a> <br />CM-26839 | On the Dell S5248F-ON switch, CPU core temp sensors may show as ABSENT. | 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2544847"></a> [2544847](#2544847) <a name="2544847"></a> <br />CM-26838 | You might experience a <code>bgpd</code> memory usage increase and significant update exchanges due to host moves between VTEPs. | 3.7.7-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544723"></a> [2544723](#2544723) <a name="2544723"></a> <br />CM-26769 | Setting ProtoDown on ports populated with SFP modules providing RJ-45 1000BASE-T interfaces does not cause the carrier to be dropped. The kernel shows carrier down; however, the remote device still shows a link. | 3.7.6-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2544625"></a> [2544625](#2544625) <a name="2544625"></a> <br />CM-26703 | VXLAN encapsulated ICMP packets hit the catchall EFP policer instead of the ICMP policer and you might experience partial packet loss.<br /> | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544556"></a> [2544556](#2544556) <a name="2544556"></a> <br />CM-26655 | If you reconfigure an NTP server with NCLU using different trailing options after the IP address (such as <code>iburst</code>), an invalid configuration is added to the <code>/etc/ntp.conf</code> file. For example:<br /><pre><br />net add time ntp server 1.2.3.4 iburst<br />net commit<br />net add time ntp server 1.2.3.4<br />net commit<br /></pre><br />If you need to alter existing server configurations, first remove the server, commit, then re-add the server with any trailing options. | 3.7.9-4.1.1 | 4.2.0-4.3.0|
| <a name="2544463"></a> [2544463](#2544463) <a name="2544463"></a> <br />CM-26599 | Auto-negotiation does not work with the QSFP28 cables and a remote system operating at 10G. Attempting to enable auto-negotiation with <code>ethtool -s swp<#> autoneg on</code> returns <code>Operation not supported</code>.<br />To work around this issue, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544456"></a> [2544456](#2544456) <a name="2544456"></a> <br />CM-26595 | The NCLU <code>net show lldp</code> command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544329"></a> [2544329](#2544329) <a name="2544329"></a> <br />CM-26525 | When an MLAG peerlink frequently alternates states between learning and blocking, an excessive number of TCP sessions might be created, which results in the following error display:<br /><pre><br />OSError: &#91;Errno 24&#93; Too many open files<br /></pre> | 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544213"></a> [2544213](#2544213) <a name="2544213"></a> <br />CM-26450 | Cumulus Linux poed generates excessive debug log entries.  These will be reduced in a future release. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544200"></a> [2544200](#2544200) <a name="2544200"></a> <br />CM-26448 | Traffic sent to the SVI IP address of a switch might be lost if all of the following conditions are met:<br />* The switch is a member of an MLAG pair<br />* The traffic is sourced from a layer 2 adjacent host<br />* The host is located within a VRF of the MLAG pair<br />* The traffic from the source crosses the peer link<br />* VXLAN is configured on the MLAG pair<br /><br />This issue does not impact transit traffic or traffic that does not meet all of the described conditions.<br />To workaround this issue, restart <code>switchd</code>. | 3.7.9-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544113"></a> [2544113](#2544113) <a name="2544113"></a> <br />CM-26412 | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address changing between the MLAG bond and the peer link.<br />To work around this issue, disable MAC learning on QinQ VLANs by adding <code>bridge-learning off</code> to the VLAN stanza in the <code>etc/network/interfaces</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543937"></a> [2543937](#2543937) <a name="2543937"></a> <br />CM-26308 | An interface alias configured outside FRR using <code>iproute2</code> is imported into the FRR running configuration and overrides the internal description. After an FRR reload, this causes FRR to delete the interface alias in an inefficient way. Depending on how many interfaces with aliases you have configured, this can cause a FRR reload to time out.<br />To work around this issue, remove the interface alias description from <code>iproute2</code>. | 3.7.8-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543900"></a> [2543900](#2543900) <a name="2543900"></a> <br />CM-26288 | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543841"></a> [2543841](#2543841) <a name="2543841"></a> <br />CM-26256 | The <code>net show evpn vni detail json</code> command includes an extra empty dictionary at the end of the output. <br /> | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543816"></a> [2543816](#2543816) <a name="2543816"></a> <br />CM-26241 | On the Dell S5248F-ON switch, <code>smond</code> might generate syslog messages indicating that the fan input RPM is lower than the normal low speed of 2500 RPM. Speeds as low as 1700 RPM are acceptable in normal thermal environments; therefore, you can ignore these messages.<br /> | 3.7.6-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2543792"></a> [2543792](#2543792) <a name="2543792"></a> <br />CM-26225 | On the EdgeCore AS5712, AS6712, AS5812 and AS6812 switch, support for multiple PSU types results in log messages similar to the following:<br /><pre><br />2019-09-05T05:15:17.246597+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.274521+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br />2019-09-05T05:15:17.469556+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/11-0050/eeprom for psu2<br />2019-09-05T05:15:17.497514+00:00 hp-6712-03 decode-syseeprom: Unable to find eeprom at /sys/bus/i2c/devices/12-0053/eeprom for psu2<br /></pre> | 3.7.9-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543781"></a> [2543781](#2543781) <a name="2543781"></a> <br />CM-26217 | NCLU does not allow you to configure OSPF NSSAs. For example: <br /><pre><br />cumulus&#64;switch:~$ net add ospf area 0.0.0.1 nssa <br />ERROR: Command not found. <br />net add ospf area 0.0.0.1 nssa<br /></pre><br />To work around this issue, use FRR instead. For example: <br /><pre><br />switch# configure terminal <br />switch(config)# router ospf <br />switch(config-router)# area 0.0.0.1 nssa <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543750"></a> [2543750](#2543750) <a name="2543750"></a> <br />CM-26200 | The following CVEs were announced that affect the systemd-resolved package. <br />Cumulus Linux does not enable <code>systemd-resolved</code> by default, so Cumulus Linux is not vulnerable as shipped. <br />CVE-2019-15718 <br />Missing access controls on systemd-resolved's D-Bus interface <br />Source Package Release Version Status: buster 241-7 vulnerable<br />For the detailed security status, refer to the security tracker page at:<br />https://security-tracker.debian.org/tracker/CVE-2019-15718 | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2543724"></a> [2543724](#2543724) <a name="2543724"></a> <br />CM-26179 | If a hostname contains utf-8 characters, the NCLU <code>net show lldp</code> command outputs the following error: <br /><pre><br />ERROR: 'ascii' codec can't encode character u'\xe9' in position 3: ordinal not in range(128) <br />See /var/log/netd.log for more details.  <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543690"></a> [2543690](#2543690) <a name="2543690"></a> <br />CM-26158 | On the Mellanox switch, UFT profiles are unable to support the documented capacity for routes to addresses that are more than 64 bits in length. The listed capacities assume 64-bit destination IP addresses. | 3.7.8-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2543649"></a> [2543649](#2543649) <a name="2543649"></a> <br />CM-26138 | You cannot specify a source and destination MAC address in an ERSPAN ebtables rule. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i swp5 -s 00:25:90:b2:bd:9d -d 50:6b:4b:96:c4:04 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-3.7.12, 4.0.0-4.1.1 | 3.7.13-3.7.14, 4.2.0-4.3.0|
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | 4.3.0|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543472"></a> [2543472](#2543472) <a name="2543472"></a> <br />CM-26024 | On switches with the Spectrum ASIC, the underlay hashes VXLAN packets for a given overlay flow randomly.<br />To work around this issue, configure the ECMP hash seed to the same value on the EVPN egress leaf switches. | 3.7.7-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2543401"></a> [2543401](#2543401) <a name="2543401"></a> <br />CM-25986 | On the Mellanox Spectrum-2 switch, the time required to establish a link (from the time a link is set to <code>admin up</code> until the link becomes operationally up) can take up to 15 seconds on 40G interfaces and up to 30 seconds on 100G interfaces. <br />To work around this issue, wait up to 15 seconds on 40G interfaces and 30 seconds on 100G interfaces for the link to establish. | 4.0.0-4.2.1 | 4.3.0|
| <a name="2543270"></a> [2543270](#2543270) <a name="2543270"></a> <br />CM-25923 | The default route injected through OSPF when you configure <code>default-information originate always</code> is unreliable and might age out unexpectedly.<br />To work around this issue, rely on a different source of default route other than injection with <code>default-information originate</code>. | 3.7.8-4.1.1 | 4.2.0-4.3.0|
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542979"></a> [2542979](#2542979) <a name="2542979"></a> <br />CM-25766 | On the Dell-N3048EP-ON switch, when you run the <code>sudo -E apt upgrade</code> command, the upgrade does not work.  | 3.7.7-4.1.1 | 4.2.0-4.3.0|
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542872"></a> [2542872](#2542872) <a name="2542872"></a> <br />CM-25693 | After you issue the NCLU <code>net del bgp vrf <vrf> autonomous-system <AS></code> command and commit the change, Cumulus Linux does not remove the configuration from the <code>/etc/frr/frr.conf</code> file or the <code>net show config commands</code>. <br /> | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2542837"></a> [2542837](#2542837) <a name="2542837"></a> <br />CM-25674 | On Mellanox switches, policer iptables are not working as expected. For example, when using a policer with mode KB/MB/GB to rate-limit interfaces, the syntax is accepted but the data plane transfer speed is not affected by the rule.  | 3.7.6-3.7.8, 4.0.0-4.3.0 | 3.7.9-3.7.14|
| <a name="2542824"></a> [2542824](#2542824) <a name="2542824"></a> <br />CM-25665 | On the Broadcom Trident 3 switch, VXLAN encapsulated packets are dropped on the ingress port (tagged layer 2 port) during transit forwarding (the local switch does not terminate the VXLAN tunnel). An example of where this two-layer VXLAN inside VXLAN encapsulation might occur:<br />- VXLAN tunnel (#1) between two servers (different racks) to provide layer 2 extension for containers or VM hosts.<br />- VXLAN tunnel (#2) between the TOR switch in rack 1 to the TOR switch located in the remote rack. <br /><br />To work around this issue, either:<br />- Configure the edge port (facing the servers) to be an access port (instead of a trunk/tagged port)<br />- Change the destination port from 4789 to something else (VXLAN tunnel terminated by the servers) | 3.7.5-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2542767"></a> [2542767](#2542767) <a name="2542767"></a> <br />CM-25641 | If the BMC operating system fails to respond to IPMI, you see a traceback in <code>bmcd</code> and all the sensors might report ABSENT devices in <code>smonctl</code>. <br />To work around this issue, power cycle the switch. <br />  | 3.7.6-3.7.12, 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2542510"></a> [2542510](#2542510) <a name="2542510"></a> <br />CM-25505 | In EVPN symmetric or centralized configurations with BGP peering over a peer link, VXLAN routed packets transiting an MLAG peer are dropped until the <code>clagd</code> <code>init-delay</code> timer expires during the bring-up sequence following a reboot.<br />The problem is caused by a race condition when programming the anycast IP address (used to terminate VXLAN tunnels), where the hardware is programmed before the software by <code>clagd</code>.<br />To work around this issue, configure the BGP path across the peer link to be less preferred. The example below uses AS path prepending and the MLAG switches are iBGP neighbors. However, other BGP configurations achieve the same result. <br />In the <code>/etc/frr/frr.conf</code> file, make a new AS path access list and route map to apply BGP pre-pending of the local ASN one or more times. For example: <br /><pre> <br />ip as-path access-list MY_ASN permit ^$ <br /><br />route-map peerlink-add-asn permit 10 <br />match as-path MY_ASN <br />set as-path prepend 4200000101 <br />route-map peerlink-add-asn permit 20 <br /></pre>  | 3.7.6-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541428"></a> [2541428](#2541428) <a name="2541428"></a> <br />CM-24993 | When you try to change the NTP time zone with the NCLU <code>net add time zone <timezone></code> command or by editing the <code>/etc/timezone</code> file manually, the configuration does not take effect.<br />To work around this issue, change the time zone with the <code>sudo timedatectl set-timezone <timezone></code> command. For example:<br /><pre><br />cumulus&#64;switch:~$ sudo timedatectl set-timezone US/Eastern<br /></pre><br /> | 4.0.0-4.0.1 | 4.1.0-4.3.0|
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540950"></a> [2540950](#2540950) <a name="2540950"></a> <br />CM-24751 | On the QuantaMesh T4048-IX8 or EdgeCore AS7326-56X switch, when using a 1000BASE-T SFP module, the module LEDs do not light to reflect link status.<br />  | 3.7.3-4.1.1 | 4.2.0-4.3.0|
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538256"></a> [2538256](#2538256) <a name="2538256"></a> <br />CM-23397 | On the Broadcom switch, when a link-local multicast frame is received on an access port with a VNI in the bridge, two copies of the packet are sent across the VNI to remote VTEPs and the receiving hosts observe duplicate packets. <br />  | 3.7.2-4.0.1 | 4.1.0-4.3.0|
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537544"></a> [2537544](#2537544) <a name="2537544"></a> <br />CM-23021 | When you run the <code>mstpctl</code> command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of <code>mstpctl</code>; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | 4.3.0|
| <a name="2537061"></a> [2537061](#2537061) <a name="2537061"></a> <br />CM-22794 | The Dell S5048F-ON switch (with reverse airflow, rear to front), shows the Temp-3 sensor as absent. <br /> | 3.7.1-4.0.1 | 4.1.0-4.3.0|
| <a name="2536617"></a> [2536617](#2536617) <a name="2536617"></a> <br />CM-22591 | CVE-2018-5391 (FragmentSmack) is a network vulnerability where an attacker can trigger time and calculation expensive fragment reassembly with specially crafted packets, leading to a denial of service. On a Cumulus Linux switch, the impact is limited to control plane and management plane traffic. Any control plane traffic coming in the front panel ports will be limited by existing policer ACLs.<br />To work around this issue, create a file called <code>/etc/sysctl.d/ip.conf</code> and add these settings:<br /><pre><br />net.ipv4.ipfrag_low_thresh = 196608<br />net.ipv6.ip6frag_low_thresh = 196608<br />net.ipv4.ipfrag_high_thresh = 262144<br />net.ipv6.ip6frag_high_thresh = 262144<br /></pre> | 3.7.0-3.7.11, 4.0.0-4.0.1 | 3.7.12-3.7.14, 4.1.0-4.3.0|
| <a name="2536576"></a> [2536576](#2536576) <a name="2536576"></a> <br />CM-22554 | If you try to bring down several members of a bond remotely at the same time, the link state of one of the interfaces might not transition correctly to the down state; however, all links show down in hardware. <br />  | 4.0.0-4.3.0 | |
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536256"></a> [2536256](#2536256) <a name="2536256"></a> <br />CM-22301 | For an unresolved address, the IPROUTER default policer rule has been modified to _not_ match on packets exiting a TUNNEL and headed to the CPU to resolve the address via ARP. As a result, the following default rule no longer matches TUNNEL ingress packets. <br /><pre> <br />A $INGRESS_CHAIN --in-interface $INGRESS_INTF -m addrtype --dst-type <br />IPROUTER -j POLICE --set-mode pkt --set-rate 400 --set-burst 100 <br /></pre> <br />These packets are now policed by catch all rules. <br />To work around this issue, the VPORT value on a TRIDENT switch must be changed from binary 011 to 100. <br /> | 4.0.0-4.3.0 | |
| <a name="2536242"></a> [2536242](#2536242) <a name="2536242"></a> <br />CM-22287 | On the EdgeCore AS7712 (Tomahawk) switch running in atomic mode, when a layer 3 ECMP path is brought down, traffic traversing the path stops working for about four seconds. When the switch is changed to non-atomic mode, the delay is less than one second. This issue is seen across OSPF and static ECMP routes.  | 4.0.0-4.3.0 | |
| <a name="2536231"></a> [2536231](#2536231) <a name="2536231"></a> <br />CM-22277 | On the Broadcom switch with the Trident3 ASIC, the ECN-CE bit is set by default on transit traffic. This might result in hosts adjusting traffic behavior if they are configured for the ECN feature. <br />In Cumulus Linux 3.7.11, the default behavior changed; the ECN-CE bit is _no longer_ set by default on transit traffic. | 3.7.3-3.7.10, 4.0.0-4.0.1 | 3.7.11-3.7.14, 4.1.0-4.3.0|
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on protocol sockets.<br />When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a <code>switchd</code> restart. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535965"></a> [2535965](#2535965) <a name="2535965"></a> <br />CM-22020 | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br />To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535845"></a> [2535845](#2535845) <a name="2535845"></a> <br />CM-21898 | On a Trident3 switch, IGMP packets are not policed by the police rule in the 00control ACL file. The packets are policed by the catchall policer in the 99control ACL file instead. <br /> <code>-A $INGRESS_CHAIN -p ipv4 -d 01:00:5e:00:00:00/ff:ff:ff:80:00:00 -j police --set-mode pkt --set-rate 100 --set-burst 100</code> <br />To work around this issue, let the CPU bound IGMP packet hit the following rule and change the policer rate to a desired value for IGMP packets: <br /> <code>-A $INGRESS_CHAIN -p ipv4 -d 01:00:5e:00:00:00/ff:ff:ff:80:00:00 -j police --set-mode pkt --set-rate 100 --set-burst 100</code> <br />Typically, the destination MAC address 01:00:5e:xx:xx:xx is used only for PIM/IGMP control and data stream packets. However, this workaround cannot handle data stream multicast packets that are not TCP/UDP; this is not typically done.  | 4.0.0-4.0.1 | 3.7.13-3.7.14, 4.1.0-4.3.0|
| <a name="2535723"></a> [2535723](#2535723) <a name="2535723"></a> <br />CM-21785 | The source address of the ICMPv6 time exceeded message (traceroute hop) is sourced from the wrong VRF when the traceroute target resides on the same switch but in a different VRF. | 4.0.0-4.3.0 | |
| <a name="2535707"></a> [2535707](#2535707) <a name="2535707"></a> <br />CM-21769 | On the Mellanox switch, GRE tunneling does not work if the tunnel source is configured on an SVI interface. If  the tunnel source is configured on a physical switch port, then tunneling works as expected. | 4.0.0-4.1.1 | 3.7.14, 4.2.0-4.3.0|
| <a name="2535605"></a> [2535605](#2535605) <a name="2535605"></a> <br />CM-21667 | FRR does not add BGP <code>ttl-security</code> to either the running configuration or to the <code>/etc/frr/frr.conf</code> file when configured on a peer group instead of a specific neighbor. <br />To work around this issue, add <code>ttl-security</code> to individual neighbors instead of the peer group. | 4.0.0-4.3.0 | |
| <a name="2535209"></a> [2535209](#2535209) <a name="2535209"></a> <br />CM-21278 | The <code>net show lldp</code> command sometimes shows the port description in the <code>Remote Port</code> field. The <code>net show interface</code> command shows the correct value in the <code>Remote Host</code> field.<br />To work around this issue, use <code>net show interface</code> command for LLDP output when connected to Cisco equipment. | 3.7.5-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2534978"></a> [2534978](#2534978) <a name="2534978"></a> <br />CM-21055 | On the Mellanox switch, the destination MAC address of ERSPAN GRE packets is set to all zeros; therefore, the first transit switch might drop packets. | 4.0.0-4.2.1 | 3.7.14, 4.3.0|
| <a name="2534734"></a> [2534734](#2534734) <a name="2534734"></a> <br />CM-20813 | Span rules matching the out-interface as a bond do not mirror packets. | 4.0.0-4.3.0 | |
| <a name="2534422"></a> [2534422](#2534422) <a name="2534422"></a> <br />CM-20508 | The Cumulus-Resource-Query-MIB defines the ability to gather buffer utilization status but when these objects are polled, they return nothing. <br /> | 4.0.0-4.3.0 | |
| <a name="2533940"></a> [2533940](#2533940) <a name="2533940"></a> <br />CM-20033 | The VLAN interface stays up even though the physical link carrying the VLAN is admin or carrier down.<br /><br /> | 4.0.0-4.3.0 | |
| <a name="2533691"></a> [2533691](#2533691) <a name="2533691"></a> <br />CM-19788 | If you configure a VLAN under a VLAN-aware bridge and create a subinterface of the same VLAN on one of the bridge ports, the bridge and interface compete for the same VLAN and if the interface is flapped, it stops working. Correcting the configuration and running the <code>ifreload</code> command does not resolve the conflict. <br />To work around this issue, correct the bridge VIDs and restart <code>switchd</code> or delete the subinterface.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2533625"></a> [2533625](#2533625) <a name="2533625"></a> <br />CM-19724 | PIM and MSDP entries are set to the internal COS value of 6 so they are grouped together with the bulk traffic priority group in the default <code>traffic.conf</code> file. However, PIM, IGMP, and MSDP are considered control-plane and should be set to the internal COS value of 7.  | 4.0.0-4.3.0 | |
| <a name="2533337"></a> [2533337](#2533337) <a name="2533337"></a> <br />CM-19454 | When you use NCLU to bring a bond admin down (<code>net add bond <bond> link down</code>), the bond interface goes into admin down state but the switch ports enslaved to the bond remain UP. If you are using bond-lacp-bypass-allow or balance-xor mode, the host might continue to send traffic. This traffic will be dropped because although the bond slaves are UP, they are not members of the bridge.<br />To work around this issue, use the <code>sudo ifdown <bondname></code> command. | 4.0.0-4.3.0 | |
| <a name="2532017"></a> [2532017](#2532017) <a name="2532017"></a> <br />CM-18192 | In FRR, <code>bgp_snmp</code> does not show all BGP peers when peer groups used. | 3.7.11-4.0.1 | 4.1.0-4.3.0|
| <a name="2531273"></a> [2531273](#2531273) <a name="2531273"></a> <br />CM-17494 | In certain cases, a peer device sends an ARP request from a source IP address that is not on the connected subnet and the switch creates a STALE neighbor entry. Eventually, the switch attempts to keep the entry fresh and sends ARP requests to the host. If the host responds, the switch has REACHABLE neighbor entries for hosts that are not on the connected subnet. <br />To work around this issue, change the value of <code>arp_ignore</code> to 2. See &#91;Address Resolution Protocol in the Cumulus Linux user guide\|https://docs.cumulusnetworks.com/cumulus-linux/Layer-3/Address-Resolution-Protocol-ARP/&#93; for more information. | 4.0.0-4.3.0 | |
| <a name="2530322"></a> [2530322](#2530322) <a name="2530322"></a> <br />CM-16571 | NCLU cannot manage <code>rsyslog</code> to addresses routed via a VRF.  In Cumulus Linux 4.0.0 and later, management VRF is enabled by default.   To work around this issue, update the <code>/etc/network/interfaces</code> file to disable management VRF. | 4.0.0-4.3.0 | |

### Fixed Issues in 4.0.0
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="2555278"></a> [2555278](#2555278) <a name="2555278"></a> <br />CM-32597 | When you change the anycast address for the MLAG pair (clagd-vxlan-anycast-ip), high peak traffic occurs on the peer link interface of all MLAG switches. | 3.7.13-3.7.14 | |
| <a name="2552383"></a> [2552383](#2552383) <a name="2552383"></a> <br />CM-30936 | The following security vulnerability has been announced in net-snmp:<br />CVE-2020-15681: A privilege escalation vulnerability was discovered in Net-SNMP due to incorrect symlink handling.<br />Vulnerable: <= 5.8.0-cl3u10<br />Fixed: 5.8.0-cl3u11, 5.8.0-cl4u4 | 3.7.6 | |
| <a name="2551288"></a> [2551288](#2551288) <a name="2551288"></a> <br />CM-30286 | When you remove BFD configuration by editing the <code>/etc/frr/frr.conf</code> file and restarting FRR, you see a traceback.<br />To work around this issue, either use NCLU or vtysh commands to remove the BFD configuration, or restart FRR with the new <code>/etc/frr/frr.conf</code> file. | 3.7.7-3.7.14 | |
| <a name="2550323"></a> [2550323](#2550323) <a name="2550323"></a> <br />CM-29807 | After a neighbor is removed, the redistributed neighbor entry is withdrawn from the BGP table, but the prefix might still be selected as the bestpath when the host's originated prefix is not advertised.<br />To work around this issue, recreate the neighbor entry and flap the interface to the host. <br />Or, if the host is already down, manually create a neighbor entry with an invalid MAC address, which forces redistribute neighbor to re-withdraw the entry. | 3.7.3-3.7.12 | |
| <a name="2549397"></a> [2549397](#2549397) <a name="2549397"></a> <br />CM-29322 | When the BGP Multi-protocol Unreach NLRI attribute is received in a BGP update without a next hop attribute, the BGP session is brought down unexpectedly. RFC 4760 defines that the next-hop attribute is not required for updates containing MP_UNREACH_NLRI. | 3.7.12 | |
| <a name="2548475"></a> [2548475](#2548475) <a name="2548475"></a> <br />CM-28932 | After you add a new VNI and a layer 3 SVI to a set of leafs, certain leafs might not be able to communicate on the layer 3 VNI. <br />To work around this issue, reboot the leaf switch or restart <code>switchd</code>. | 3.7.6-3.7.13 | |
| <a name="2548191"></a> [2548191](#2548191) <a name="2548191"></a> <br />CM-28712 | A security scanner may detect a version of wpa or hostapd that is not listed as having been fixed for CVE-2019-13377 and/or CVE-2019-16275.  Cumulus Linux since 3.7.9 and 4.0.0 has a customized version of wpa and hostapd which includes the fixes for these vulnerabilities. | 3.7.8 | |
| <a name="2547381"></a> [2547381](#2547381) <a name="2547381"></a> <br />CM-28212 | The <code>hsflowd</code> service sends an undefined header protocol 0 in the sampled flow sample to the collector, which is not recognized by the sFlow tool. You see errors similar to the following:<br /><pre><br />Dec 20 08:43:27 netflow-nms sfcapd&#91;3991&#93;: SFLOW: readFlowSample_header() undefined headerProtocol = 0<br /></pre><br /> | 3.7.11-3.7.14 | |
| <a name="2545563"></a> [2545563](#2545563) <a name="2545563"></a> <br />CM-27269 | The following Linux kernel security vulnerabilities do not affect Cumulus Linux in supported configurations:<br />CVE-2018-12207 CVE-2019-0154 CVE-2019-0155 CVE-2019-11135<br />Several vulnerabilities have been discovered in the Linux kernel that may may to a privilege escalation, denial of service, or information leak.<br />CVE-2018-12207: Intel CPU hypervisor vulnerability.  Running hypervisors on Cumulus Linux is not supported.<br />CVE-2019-0154, CVE-2019-0155:  Intel GPU vulnerabilities.  GPUs are not present on our switches.<br />CVE-2019-11135, CVE-2019-11139: Intel CPU transactional memory vulnerability.  None of our switches support transactional memory.<br />For the detailed security status of linux, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/linux |  | |
| <a name="2545013"></a> [2545013](#2545013) <a name="2545013"></a> <br />CM-26943 | Package        : file libmagic1 libmagic-mgc<br />CVE ID         : CVE-2019-18218<br /><br />A buffer overflow was found in file, a file type classification tool,<br />which may result in denial of service or potentially the execution of<br />arbitrary code if a malformed CDF (Composite Document File) file is<br />processed.<br /><br />For the detailed security status of file please refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/file<br />https://security-tracker.debian.org/tracker/CVE-2019-18218<br /><br />Vulnerable versions: < 1:5.35-4+deb10u1<br />Fixed versions: >= 1:5.35-4+deb10u1 |  | |
| <a name="2544867"></a> [2544867](#2544867) <a name="2544867"></a> <br />CM-26849 | Package: tcpdump<br />CVE ID: CVE-2018-10103 CVE-2018-10105 CVE-2018-14461 CVE-2018-14462<br />CVE-2018-14463 CVE-2018-14464 CVE-2018-14465 CVE-2018-14466<br />CVE-2018-14467 CVE-2018-14468 CVE-2018-14469 CVE-2018-14470<br />CVE-2018-14879 CVE-2018-14880 CVE-2018-14881 CVE-2018-14882<br />CVE-2018-16227 CVE-2018-16228 CVE-2018-16229 CVE-2018-16230<br />CVE-2018-16300 CVE-2018-16451 CVE-2018-16452 CVE-2019-15166<br />Several vulnerabilities have been discovered in tcpdump, a command-line<br />network traffic analyzer. These vulnerabilities might result in denial of<br />service or, potentially, execution of arbitrary code.<br />For the detailed security status of tcpdump, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/tcpdump<br />Fixed versions: 4.9.3-1~deb10u1 on Cumulus Linux 4, 4.9.3-1~deb8u1 on Cumulus Linux 3. | 3.7.10 | |
| <a name="2544815"></a> [2544815](#2544815) <a name="2544815"></a> <br />CM-26815 | If a router MAC address changes on a VTEP, other VTEPs might still point to the previous router MAC address. | 3.7.10 | |
| <a name="2544609"></a> [2544609](#2544609) <a name="2544609"></a> <br />CM-26691 | BGP is configured with soft reconfiguration-in for its peers, which is not working correctly and causes routes to have an unexpected label. As a result, transit traffic is not forwarded by the switch. | 3.7.7-3.7.10 | |
| <a name="2544559"></a> [2544559](#2544559) <a name="2544559"></a> <br />CM-26657 | When you install a large number of new rules with nonatomic mode enabled, there is a chance that you install more rules than the number of available slots in the slice, which results in the slice being completely wiped and reinstalled. This causes a large drop increase, including to cpu0, and might cause a major outage by dropping all BGP sessions. | 3.7.8-3.7.10 | |
| <a name="2544401"></a> [2544401](#2544401) <a name="2544401"></a> <br />CM-26566 | Package: openssl<br />CVE ID:  CVE-2019-1547 CVE-2019-1549 CVE-2019-1563<br />Three security issues were discovered in OpenSSL: A timing attack against<br />ECDSA, a padding oracle in PKCS7_dataDecode() and CMS_decrypt_set1_pkey()<br />and it was discovered that a feature of the random number generator (RNG)<br />intended to protect against shared RNG state between parent and child<br />processes in the event of a fork() syscall was not used by default.<br />Fixed version: 1.1.1d-0+deb10u1<br />We recommend that you upgrade your openssl packages.<br />For the detailed security status of openssl,  refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/openssl | 3.7.0-3.7.10 | |
| <a name="2544324"></a> [2544324](#2544324) <a name="2544324"></a> <br />CM-26523 | Package: hostapd<br />CVE ID: CVE-2019-13377 CVE-2019-16275<br />Two vulnerabilities were found in the WPA protocol implementation found in wpa_supplication (station) and hostapd (access point).<br />CVE-2019-13377<br />A timing-based side-channel attack against WPA3's Dragonfly handshake when using Brainpool curves could be used by an attacker to retrieve the password.<br />CVE-2019-16275<br />Insufficient source address validation for some received Management frames in hostapd could lead to a denial of service for stations associated to an access point. An attacker in radio range of the access point could inject a specially constructed unauthenticated IEEE 802.11 frame to the access point to cause associated stations to be disconnected and require a reconnection to the network.<br />Fixed version: 1:2.8.0-cl4u3 | 3.7.0-3.7.10 | |
| <a name="2543875"></a> [2543875](#2543875) <a name="2543875"></a> <br />CM-26272 | On the Mellanox Spectrum switch, a route withdrawal might cause the associated next hop neighbor entry to be deleted in hardware but remain in the kernel. This can cause traffic going through the directly connected route to the removed neighbor entry to be forwarded to the CPU. | 3.7.6-3.7.10 | |
| <a name="2543800"></a> [2543800](#2543800) <a name="2543800"></a> <br />CM-26230 | When <code>local-tunnelip</code> is an SVI, the static VXLAN tunnel does not work; the next hop router receives the packet but drops it as it does not know where to forward the packet. The static VXLAN tunnel does works if <code>local-tunnelip</code> is a loopback or a physical layer 3 interface. <br /> | 3.7.8-3.7.14 | |
| <a name="2543727"></a> [2543727](#2543727) <a name="2543727"></a> <br />CM-26181 | ACL rules, such as the following, fail to install if you use swp+ (interfaces mentioned as wildcards).<br /><pre><br />-A FORWARD -i swp+ -j LOG<br />-A FORWARD -i swp+ -j DROP<br /></pre><br />You can now install such rules with swp+. | 3.7.3-3.7.10 | |
| <a name="2543708"></a> [2543708](#2543708) <a name="2543708"></a> <br />CM-26169 | Cumulus Linux does not map QinQ packets to VXLANs in a configuration with a VLAN-aware bridge and MLAG on the Trident3 platform. <br /> | 3.7.9-3.7.10 | |
| <a name="2543665"></a> [2543665](#2543665) <a name="2543665"></a> <br />CM-26146 | <code>clagd</code> memory consumption increases under certain unknown conditions. <br /> | 3.7.8-3.7.10 | |
| <a name="2543637"></a> [2543637](#2543637) <a name="2543637"></a> <br />CM-26130 | Package: linux<br />CVE ID: CVE-2018-20836 CVE-2019-1125 CVE-2019-1999 CVE-2019-10207 CVE-2019-10638 CVE-2019-12817 CVE-2019-12984 CVE-2019-13233 CVE-2019-13631 CVE-2019-13648 CVE-2019-14283 CVE-2019-14284<br />Several vulnerabilities have been discovered in the Linux kernel that may lead to a privilege escalation, denial of service or information leaks.<br />For the 4.0.0 release, these problems have been fixed in version 4.19.76-1+cl4u1<br />For the detailed security status of linux, refer to its security tracker page at:<br />https://security-tracker.debian.org/tracker/linux |  | |
| <a name="2543627"></a> [2543627](#2543627) <a name="2543627"></a> <br />CM-26126 | Tomahawk 40G DACs cannot disable auto-negotiation. | 3.7.7-3.7.14 | |
| <a name="2543374"></a> [2543374](#2543374) <a name="2543374"></a> <br />CM-25973 | After a remote VTEP peer link goes down, the tunnel destination IP address might be incorrect in hardware, which might cause loss of overlay communication between VTEPs. | 3.7.8-3.7.10 | |
| <a name="2543325"></a> [2543325](#2543325) <a name="2543325"></a> <br />CM-25955 | Lenovo switches do not send or receive LLDP on eth0 interfaces. | 3.7.7-3.7.10 | |
| <a name="2543113"></a> [2543113](#2543113) <a name="2543113"></a> <br />CM-25824 | NCLU restarts FRR when attempting to remove a BGP VRF stanza. This happens regardless of whether the VRF is valid/configured elsewhere on the switch or the removal is successful. To work around this issue, remove the stanza using vtysh. <br /> | 3.7.3-3.7.10 | |
| <a name="2543058"></a> [2543058](#2543058) <a name="2543058"></a> <br />CM-25798 | The IP neighbor entry for a link-local next hop is not installed by FRR, which results in a forwarding failure for routes via that next hop. This is a rare problem that occurs with IPv4 route exchange over IPv6 GUA peering with no IPv4 addresses on the interfaces.<br />To work around this issue, flap the peering to the peer router (which might be a route reflector) to recover. To avoid this issue, configure IPv6 router advertisements on the connecting interfaces. | 3.7.7-3.7.14 | |
| <a name="2543052"></a> [2543052](#2543052) <a name="2543052"></a> <br />CM-25796 | Received EVPN type-5 and type-2 MACIP routes are not installed in the kernel (and hardware) routing tables for the associated VRF, which causes traffic to be blackholed. The failure to install the default route causes complete reachability failure for the particular tenant on the affected racks. The routes that are not installed are seen as "inactive" in the routing subsystem (FRR) VRF routing table. This problem is rare and can occur only in EVPN configurations that have user-configured route targets (RTs) for tenant VRFs, and only following a restart of FRR.<br />To work around this issue, either restart the FRR service on the affected switch with the <code>sudo systemctl restart frr.service</code> command or bounce the layer 3 SVI for the affected VRF; for example:<br /><pre><br />ifdown vlan123 ; sleep 2 ; ifup vlan123<br /></pre><br />You can run the <code>net show vrf vni</code> command to print a mapping of VRF : L3-VNI : L3-SVI. | 3.7.5-3.7.14 | |
| <a name="2543044"></a> [2543044](#2543044) <a name="2543044"></a> <br />CM-25794 | Under certain conditions, EVPN next hops might not be removed when the contributing peer goes down or might not be populated when the BGP session to the contributing peer comes up.<br />You can prevent EVPN next hops from not being removed when the contributing peer goes down by specifying static MAC addresses on all layer 3 VNIs. There is no workaround for preventing EVPN next hops from not being populated when the BGP session to the contributing peer comes up. | 3.7.2-3.7.14 | |
| <a name="2542966"></a> [2542966](#2542966) <a name="2542966"></a> <br />CM-25754 | A port that is used as both a double tag interface and a VXLAN access side interface does not forward correctly; VXLAN decapsulation is does not occur.  However, do not configure double tagged interfaces on VXLAN uplink ports as this will cause VXLAN routing issues. |  | |
| <a name="2542958"></a> [2542958](#2542958) <a name="2542958"></a> <br />CM-25747 | When transitioning from a down state to an up state due to peerlink failure and recovery, MLAG does not start the initDelay timer before trying to bring everything back up. | 3.7.7-3.7.10 | |
| <a name="2542939"></a> [2542939](#2542939) <a name="2542939"></a> <br />CM-25735 | When MLAG is re-establishing its peering after a member reboot, the VNIs on the peer briefly go into a protodown state. This can cause complete downtime to dually connected hosts as the member coming back up is still in <code>initDelay</code>. This issue does resolve itself as the VNIs do come back up within ten seconds.  | 3.7.8 | |
| <a name="2542913"></a> [2542913](#2542913) <a name="2542913"></a> <br />CM-25718 | IF-MIB::ifHCInOctets reports significantly lower values than reported by interface counters seen elsewhere. | 3.7.6-3.7.10 | |
| <a name="2542835"></a> [2542835](#2542835) <a name="2542835"></a> <br />CM-25672 | <code>snmpd</code> fails because NCLU does not remove <code>agentaddress &#64;vrf</code> lines when running the <code>net add snmp-server listening-address all</code> command. | 3.7.4-3.7.10 | |
| <a name="2542820"></a> [2542820](#2542820) <a name="2542820"></a> <br />CM-25664 | On the Trident3 platform, you can only add 50 percent of the total ECMP next hops. A log message indicates that the table is full.  | 3.7.7-3.7.8 | |
| <a name="2542384"></a> [2542384](#2542384) <a name="2542384"></a> <br />CM-25447 | When you define a trap destination using &#64;mgmt, <code>snmpd</code> indicates that the network is unreachable even though the IP address is reachable in the management VRF. <br />To work around this issue, remove <code>&#64;mgmt vrf</code> references in the <code>/etc/snmp/snmpd.conf</code> file, stop <code>snmpd</code>, then start <code>snmpd</code> manually in the management VRF with the <code>systemctl start snmpd&#64;mgmt</code> command. <br /> | 3.7.6-3.7.10 | |
| <a name="2542339"></a> [2542339](#2542339) <a name="2542339"></a> <br />CM-25415 | In a typical CLOS network, each leaf is connected to all spine nodes; VXLAN packets follow leaf-spine links. However certain failure scenarios or maintenance activity might result in the MLAG primary switch being isolated from the spine layer (the only available network path is now across the peer link). As a result, the MLAG primary switch fails to transmit VXLAN encapsulated packets out on the peer link. It is also possible for the MLAG secondary switch to be isolated from the spine layer and then the problem is seen on the MLAG secondary switch. <br />The issue occurs because the Broadcom Trident3 switch does not perform VLAN translation for VXLAN encapsulated packets where the tunnel is not terminated. <br />To work around this issue, configure the BGP peering on a _new_ VLAN interface (for example, vlan4093) instead of the peer link sub-interface (peerlink.4094). <br /> | 3.7.6 | |
| <a name="2542248"></a> [2542248](#2542248) <a name="2542248"></a> <br />CM-25376 | When you generate a cl-support file, <code>clagd.service</code> prints log messages similar to the following: <br /><pre> <br />019-03-21T07:18:15.727581+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - start <br />2019-03-21T07:18:15.728157+00:00 leaf01 clagd&#91;20912&#93;: #012thread: CollectSysInfo (140608446367488) <br />2019-03-21T07:18:15.735986+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 783, in __bootstrap <br />2019-03-21T07:18:15.736585+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 810, in __bootstrap_inner <br />2019-03-21T07:18:15.737045+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 763, in run <br />2019-03-21T07:18:15.737933+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 930, in CollectSysInfoT <br />2019-03-21T07:18:15.739527+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/sbin/clagd, line 187, in CollectSysInfo <br />2019-03-21T07:18:15.740540+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/threading.py, line 621, in wait <br />2019-03-21T07:18:15.742293+00:00 leaf01 clagd&#91;20912&#93;: file: /usr/lib/python2.7/dist-packages/clag/clagthread.py, line 48, in wait <br />. <br />. <br />2019-03-21T07:18:16.456061+00:00 leaf01 clagd&#91;20912&#93;: DumpThreadStacks - end <br /></pre> <br /> | 3.7.6-3.7.10 | |
| <a name="2541441"></a> [2541441](#2541441) <a name="2541441"></a> <br />CM-25001 | The following CVEs were announced in Debian Security Advisory DSA-444-1, DSA-4447-1 and affect the linux kernel and microcode. <br />Package: linux <br />CVE ID: CVE-2018-12126 CVE-2018-12127 CVE-2018-12130 CVE-2019-11091 <br />Multiple researchers have discovered vulnerabilities in the way the Intel processor designs have implemented speculative forwarding of data filled into temporary microarchitectural structures (buffers). <br />This flaw could allow an attacker controlling an unprivileged process to read sensitive information, including from the kernel and all other processes running on the system or cross guest/host boundaries to read host memory. <br />See https://www.kernel.org/doc/html/latest/admin-guide/hw-vuln/mds.html for more details. <br />To fully resolve these vulnerabilities it is also necessary to install updated CPU microcode. Contact your hardware ndor for microcode uppdates.<br />In addition, this update includes a fix for a regression causing deadlocks inside the loopback driver. <br />Fixed in version 4.19.76-1+cl4u1 |  | |
| <a name="2541005"></a> [2541005](#2541005) <a name="2541005"></a> <br />CM-24784 | NCLU is unable to delete a BGP neighbor configuration if there is a VRF VNI mapping in the <code>/etc/frr/frr.conf</code> file. For example, the following NCLU command produces an error: <br /><pre> <br />cumulus&#64;leaf01$ net del bgp neighbor swp5 interface peer-group spine <br />'router bgp 65001' configuration does not have 'neighbor swp5 interface peer-group spine' <br /></pre>  | 3.7.7-3.7.8 | |
| <a name="2540685"></a> [2540685](#2540685) <a name="2540685"></a> <br />CM-24593 | On a Dell S5248F (Trident3) switch, packets from switch ports are forwarded to the CPU and are sometimes corrupted. The corruption might result in BGP peerings being down, which can lead to all VXLAN traffic to and from a node to be lost, causing an outage to dually connected hosts in a rack. To work around this issue, restart <code>switchd</code>. | 3.7.3-3.7.8 | |
| <a name="2540601"></a> [2540601](#2540601) <a name="2540601"></a> <br />CM-24544 | If the <code>clagd-vxlan-anycast-ip</code> is removed from the <code>/etc/network/interfaces</code> file (either with the NCLU command or by editing the file manually), MLAG still believes it is present until clagd restarts.  | 3.7.3-3.7.8 | |
| <a name="2539081"></a> [2539081](#2539081) <a name="2539081"></a> <br />CM-23792 | When you delete post-up and pre-down IP peer entries from the <code>etc/network/interfaces</code> file, then run the <code>ifreload</code> command, the IP addresses are not removed and the route remains in the route table. <br />To work around this issue, either delete the IP addresses without the /32 mask component or flush the IP addresses for the interface with the <code>ip addr flush dev <interface></code> command. <br /> | 3.7.0-3.7.14 | |
| <a name="2538345"></a> [2538345](#2538345) <a name="2538345"></a> <br />CM-23440 | In an EVPN symmetric routing deployment with active-active anycast IP configured, the next hop attribute is sometimes set to a unique address instead of the anycast IP address. <br />To work around this issue, do not use <code>default-originate ipv4</code>; instead configure the network statements (recommended for small scale deployments). <br /> | 3.7.2 | |
| <a name="2537820"></a> [2537820](#2537820) <a name="2537820"></a> <br />CM-23123 | When you enable FEC (RS or BaseR) on an interface, removing the configuration from that interface does not revert the FEC status to off/none. <br /> | 3.7.2-3.7.14 | |
| <a name="2537536"></a> [2537536](#2537536) <a name="2537536"></a> <br />CM-23016 | When FRR restarts, <code>snmp&#91;err&#93; dev/kmem: Permission denied</code> error messages are recorded in the log file and SNMPd might crash periodically. | 3.7.5-3.7.10 | |
| <a name="2537104"></a> [2537104](#2537104) <a name="2537104"></a> <br />CM-22808 | When you try to stop <code>hsflowd</code> on the Trident II+ switch with the <code>systemctl stop hsflowd</code> command, the process hangs until you stop it with <code>SIGKILL</code>. <br /> | 3.7.1-3.7.14 | |
| <a name="2536651"></a> [2536651](#2536651) <a name="2536651"></a> <br />CM-22608 | Mellanox Spectrum and Helix4 switches occasionally send malformed packets and do not send any flow samples (only counters). <br />While this issue is fixed for switches with the Spectrum ASIC, this is a &#91;known limitation\|https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Network-Troubleshooting/Monitoring-System-Statistics-and-Network-Traffic-with-sFlow/#caveats-and-errata&#93; on this Helix4 platform. | 3.7.0-3.7.8 | |
| <a name="2536639"></a> [2536639](#2536639) <a name="2536639"></a> <br />CM-22605 | On a Dell S4048 switch, when you set the eth0 speed to 100, either with NCLU or by editing the <code>/etc/network/interfaces</code> file, the <code>igb</code> driver crashes, which brings down eth0. <br />To work around this issue: <br />* If eth0 is configured in the management VRF, power cycle the switch; the eth0 configuration fails and reverts back to the default (auto-negotiation/1000). <br />* If eth0 is configured in the default VRF and you power cycle after the crash, <code>igb</code> continues to crash on boot up (before getting to login prompt); power-cycle the switch, select the Advanced option in GRUB to boot to recovery mode, then modify the <code>/etc/network/interfaces</code> file. | 3.7.0-3.7.10 | |
| <a name="2534982"></a> [2534982](#2534982) <a name="2534982"></a> <br />CM-21058 | The advertised routes list may be empty for an EVPN peering even though the remote switch reports received routes.<br /> |  | |
| <a name="2534450"></a> [2534450](#2534450) <a name="2534450"></a> <br />CM-20534 | The default BGP instance must be provisioned and always exist for proper operation of dynamic leaking of routes between VRFs.  | 3.7.0-3.7.10 | |
| <a name="2534040"></a> [2534040](#2534040) <a name="2534040"></a> <br />CM-20132 | On Trident2 switches running 802.3x regular link pause, pause frames are accounted in HwIfInDiscards counters and are dropped instead of processed. |  | |
| <a name="2532396"></a> [2532396](#2532396) <a name="2532396"></a> <br />CM-18537 | Drops due to congestion do not appear to be counted on a Mellanox switch. To work around this issue, run the <code>sudo ethtool -S swp1</code> command to collect interface traffic statistics.  |  | |
| <a name="2531343"></a> [2531343](#2531343) <a name="2531343"></a> <br />CM-17557 | When sFlow is enabled, some sampled packets, such as IPMC, are forwarded twice (in the ASIC and then again through the kernel networking stack). |  | |
| <a name="2529322"></a> [2529322](#2529322) <a name="2529322"></a> <br />CM-15601 | On a Mellanox switch in an MLAG configuration, routed packets that arrive on one switch to be forwarded to a destination MAC across the peer link are dropped due to MLAG loop prevention. This affects both routed unicast and multicast packets.<br /><br />To work around this issue, modify the routing design or policy such that routes do not have a next hop of an MLAG peer switch that traverses the MLAG peer link.  |  | |
| <a name="2528800"></a> [2528800](#2528800) <a name="2528800"></a> <br />CM-15094 | Counter samples for an 80G bond (2 x 40G) exported from the switch show an interface speed (ifSpeed) of 14.464Gbps. <br /> |  | |

