---
title: Troubleshooting Log Files
author: NVIDIA
weight: 1060
toc: 4
---
The only real unique entity for logging on Cumulus Linux compared to any other Linux distribution is `switchd.log`, which logs the HAL (hardware abstraction layer) from hardware like the Broadcom or Mellanox Spectrum ASIC.

Read {{<exlink url="http://www.cyberciti.biz/faq/linux-log-files-location-and-how-do-i-view-logs-files/" text="this guide on NixCraft">}} to understand how `/var/log` works.

## Log File Descriptions

| Log | Description |
|---- |------------ |
| `/var/log/alternatives.log` | Information from update-alternatives.|
| `/var/log/apt`|Information from the `apt` utility. For example, from `apt-get install` and `apt-get remove`. |
| `/var/log/audit/*` |Information stored by the Linux audit daemon, `auditd`. |
| `/var/log/autoprovision` | Output generated by running the zero touch provisioning script (ZTP). |
| `/var/log/boot.log` | Information that is logged when the system boots. |
| `/var/log/btmp` | Information about failed login attempts. Use the last command to view the `btmp` file. For example:<pre>cumulus@switch:~$ last -f /var/log/btmp \| more</pre> |
| `/var/log/clagd.log` | Status of the `clagd` service. |
| `/var/log/dpkg.log` | Information logged when a package is installed or removed using the `dpkg` command. |
| `/var/log/frr/*` | FRRouting - Used to troubleshoots routing, such as an MD5 or MTU mismatch with OSPF. |
| `/var/log/gunicorn` | Error and access events in Gunicorn. |
| `/var/log/installer/*` | Directory containing files related to the installation of Cumulus Linux. |
| `/var/log/lastlog` | Formats and prints the contents of the last login log file. |
| `/var/log/netd.log`| Log file for NCLU. |
| `/var/log/netd-history.log`| Log file for NCLU configuration commits. |
| `/var/log/nginx`| Errors and processed requests in NGINX. |
| `/var/log/ntpstats` | Logs for network configuration protocol.|
| `/var/log/openvswitch/*` | ovsdb-server logs. |
| `/var/log/ptmd`| Prescriptive Topology Manager (PTM) errors and information. |
| `/var/log/switchd.log` | The HAL log for Cumulus Linux.<br>This is specific to Cumulus Linux. Any switchd crashes are logged here. |
| `/var/log/syslog` | The main system log, which logs everything except auth-related messages.<br>The primary log; grep this file to see what problem occurred. |
| `/var/log/wtmp` | Login records file. |
