---
title: switchd Log Message Reference
author: NVIDIA
weight: 1250
toc: 3
---
The following table lists the log messages generated by `switchd`, organized by severity, then message text. These messages appear in `/var/log/switchd.log`.
<!-- vale off -->
| Severity | Message Text | Explanation | Recommended Action |
|--------- |------------- |------------ |------------------- |
| CRITICAL | _port_group_config_values_get: hal_list_get failed on [str]|List create failed. | File a ticket with Cumulus Support. |
| CRITICAL | _range_limits_get: start linux interface name buffer is NULL|Invalid parameter. | File a ticket with Cumulus Support. |
| CRITICAL | _range_limits_get: end linux interface name buffer is NULL|Invalid parameter. | File a ticket with Cumulus Support. |
| CRITICAL | _range_limits_get: [str]-[str] not recognized|Invalid port set configuration. | Check QoS configuration file. |
| CRITICAL | _range_limits_get: port range [str] not recognized | Invalid port set configuration. | Check QoS configuration file. |
| CRITICAL | _port_group_ports_set: hal_list_get failed on [str] | Port set list create failed. |Check QoS configuration file. |
| CRITICAL | _port_group_name_list_get: hal_list_get failed on [str] | List create failed. | Check QoS configuration file. |
| CRITICAL | _port_group_range_translate: _get_range_limits failed on [str] | Invalid port set configuration. |Check QoS configuration file. |
| CRITICAL | _priority_group_config_get: hal_list_get failed on [str] | Configuration list create failed. | File a ticket with Cumulus Support. |
| CRITICAL | hal_list_get: list string [str] contains more elements than the maximum allowed ([int]) | List capacity exceeded. | File a ticket with Cumulus Support. |
| CRITICAL | hal_sh_datapath_file_read: could not load config file [str] | Could not load the back end QoS configuration file. | Check backend QoS configuration file. |
| CRITICAL | Unable to reallocate [int] bytes of memory | Memory allocation failed. | File a ticket with Cumulus Support. |
| CRITICAL | No backends found.|No back ends found. | File a ticket with Cumulus Support. |
| CRITICAL | License: email is longer than [int] characters | Email length exceeds maximum. | Modify email address. |
| CRITICAL | License: license data is longer than [int] | License data exceeds maximum. | Check license. |
| CRITICAL | License: Invalid format | Invalid license format. | Check license. |
| CRITICAL | No license file. | No license file found. | Check license file. |
| CRITICAL | The Cumulus Linux license appears to be invalid.<br>This WILL NOT affect your system operations at the moment. Future versions will enforce fully valid licenses on the system.<br>Please contact <licensing@cumulusnetworks.com> at your convenience so we can validate and assist you with this licensing issue. | Invalid license. | Check license. |
| CRITICAL | No license file. | No license file found. | Check license file. |
| CRITICAL | Incomplete license. | Incomplete license. | Check license. |
| CRITICAL | License is expired! | License is expired. |Renew license. |
| CRITICAL | unable to get tap_name for port [uint] | Port config failed: no port name. | File a ticket with Cumulus Support. |
| CRITICAL | Voluntary restart by timestamp check requested|Voluntary switchd restart. | None. |
| CRITICAL | Couldn't write ready file [str]|Could not mark switchd startup complete. | File a ticket with Cumulus Support. |
| CRITICAL | Could not open [str] to record error type|Could not report restart reason. | File a ticket with Cumulus Support. |
| CRITICAL | Error setting signal handlers. | Signal handler initialization failed. | File a ticket with Cumulus Support. |
| CRITICAL | No license to run switchd! | No switchd license is installed. | Install switchd license. |
| CRITICAL |daemon call failed with rv [int] | switchd could not be daemonized. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't write pid file [str] | Could not write out the process ID. | File a ticket with Cumulus Support. |
| CRITICAL | Switchd fs init failed. | Failed to initialize the switchd file system. | File a ticket with Cumulus Support. |
| CRITICAL | Switchd config failed. | Could not load the switchd configuration file. | Check switchd configuration file. |
| CRITICAL | Netlink init failed. | Netlink initialization failed. | File a ticket with Cumulus Support. |
| CRITICAL | HAL init failed. | HAL initialization failed. | File a ticket with Cumulus Support. |
| CRITICAL | NIC init failed. | NC initialization failed. | File a ticket with Cumulus Support. |
| CRITICAL | Port init failed. | Port initialization failed. | File a ticket with Cumulus Support. |
| CRITICAL | Bridges init failed. | Bridges initialization failed. | File a ticket with Cumulus Support. |
| CRITICAL | Bonds init failed. | Bonds initialization failed. | File a ticket with Cumulus Support. |
| CRITICAL | Logical networks init failed. | Logical networks initialization failed. | File a ticket with Cumulus Support. |
| CRITICAL | Interface list init failed. | Interface list initialization failed. | File a ticket with Cumulus Support. |
| CRITICAL | Switchd fs mount failed. | Could not mount switchd file system. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add route [str] | Failure in VRF route leak feature. This message notifies that a route entry could not be properly added to one of the software tables. | File a ticket with Cumulus Support. |
| CRITICAL | MAC address [str] couldn't be added to or retrieved from hash|Relates to merging MAC tables. The message notifies that an entry expected in a MAC address software table is not found therein. | This should never be seen. File a ticket with Cumulus Support. |
| CRITICAL | Failed to add route [str] | Add MPLS transit LSP to a software table failed. | File a ticket with Cumulus Support. |
| CRITICAL | [str]: hal port list malloc failed | Memory exhausted. | File a ticket with Cumulus Support. |
|CRITICAL | Failed to add [str] to [str] | "Failed to add <port> to <multicast route>". Issue happens when addition of the port to a software table fails. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add hal mroute for [str] | Failed to add multicast route to a software table. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add [str] to [str] | "Failed to add <port> to <multicast route>". Issue happens when addition of the port to a software table fails. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add grp [str] to mroute | A multicast route for a group could not be added to a software hash table. | File a ticket with Cumulus Support. |
| CRITICAL | Maximum number of bonds exceeded, max is [int] | Maximum number of bonds exceeded. | Reduce the number of bonds on the switch. |
| CRITICAL | Maximum number of slaves per bond exceeded, max is [int] | Maximum number of bond members per bond exceeded. | Reduce the number of bond members configured for a bond. |
| CRITICAL | rtnl slave state get failed for bond:[int] port: [int] | Could not get the bond member state from Netlink. | File a ticket with Cumulus Support. |
| CRITICAL |Failed to add route [str] | Failed to add route to a software table. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add [str] to bridge [int] | Failed to add a port to the bridge. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add [str] to grp [str] | Failed to add a port to the MDB group. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add [str] to bridge [int] | Failed to add an MDB group to the bridge. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add bridge [int] to mdb | Failed to add a given bridge to MDB. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add port [str] in grp [str], bridge [int] | Failed to add a port to a group for the specific bridge. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add [str] to bridge [int] | Failed to add a port to the bridge. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add port [str] in grp [str] | Failed to add a port to the MDB group. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add [str] to bridge [int] | Failed to add a port to the bridge. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add bridge [str] to mdb | Failed to add a given bridge to MDB. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add [str] to bridge [int] | Failed to add a port to the bridge. | File a ticket with Cumulus Support. |
| CRITICAL | arptables: Memory allocation for rules failed,malloc: [str] | ACL out of memory resource. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to create kernel bridge | L2: Bridge hash table add failed. | File a ticket with Cumulus Support. |
| CRITICAL | Open of /dev/net/tun failed: [str] | Failed to create a net device. | File a ticket with Cumulus Support. |
| CRITICAL | TUNSETIFF failed: [str] | Failed to create a net device. | File a ticket with Cumulus Support. |
| CRITICAL | SIOCGIFHWADDR failed: [str] | Failed to create a net device. | File a ticket with Cumulus Support. |
| CRITICAL | SIOCSIFHWADDR failed: [str] | Failed to create a net device. | File a ticket with Cumulus Support. |
| CRITICAL | TUNSETPERSIST failed: [str] | Failed to create a net device. | File a ticket with Cumulus Support. |
| CRITICAL | TUNSETOFFLOAD failed: [str] | Failed to create a net device. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't create tuntap ioctl socket. | Failed to create a net device.|File a ticket with Cumulus Support. |
| CRITICAL | Couldn't get netdev flags. | Failed to create a net device.|File a ticket with Cumulus Support. |
| CRITICAL | Couldn't Set netdev flags. | Failed to create a net device. | File a ticket with Cumulus Support. |
| CRITICAL | [str]: rtnl_link_alloc failed for family [int] | Failed to create filters. | File a ticket with Cumulus Support. |
| CRITICAL |[str]: rtnl_neigh_alloc failed for family [int] | Failed to create filters. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to blacklist interface [int] | Failed to block interfaces. | Check block interfaces. |
| CRITICAL |F ailed to blacklist interface [int] | Failed to block interfaces. | Check block interfaces. |
| CRITICAL | Failed to add [str], ifindex [int] to sw_intfs | Failed to create interfaces. | Recreate the interface. |
| CRITICAL | Failed to delete ifindex [int] from sw_intfs | Failed to create interfaces. | Recreate the interface. |
| CRITICAL | [str]: could not load interface config|Syncing database failed between kernel and switchd. | File a ticket with Cumulus Support. |
| CRITICAL | bogus filesystem path: [str] | Failed to add a file in SFS (simple file system). | File a ticket with Cumulus Support. |
| CRITICAL | Need file spec | Failed to add a file in SFS (simple file system). | File a ticket with Cumulus Support. |
| CRITICAL | can't replace existing directory with file: [str] | Failed to add a file in SFS (simple file system). | File a ticket with Cumulus Support. |
| CRITICAL | filesystem already initialized | Failed to initialize in SFS (simple file system). | File a ticket with Cumulus Support. |
| CRITICAL | filesystem hash table alloc failed | Failed to allocate hash table in SFS init. | File a ticket with Cumulus Support. |
| CRITICAL | filesystem mount failed | Failed to mount SFS in swtichd init. | File a ticket with Cumulus Support. |
| CRITICAL | filesystem new failed | Failed to mount SFS in swtichd init. | File a ticket with Cumulus Support. |
| CRITICAL | bogus filesystem path: [str] | Failed to delete filesystem in SFS. | File a ticket with Cumulus Support. |
| CRITICAL | pthread_create failed: [str] | Failed to create a thread in NIC init. | File a ticket with Cumulus Support. |
| CRITICAL | pthread_detach failed: [str] | Failed to detach a thread in NIC init. | File a ticket with Cumulus Support. |
| CRITICAL | TX Ring allocation failed: [str] | Failed to alloc packt buffer in NIC init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't increase netlink rbuf size: [str] | Failed to init buffer size in Netlink socket. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't increase netlink wbuf size: [str] | Failed to init buffer size in Netlink socket. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't allocate netlink socket. | Failed to create a Netlink socket. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't connect netlink socket: [str] | Failed to create a Netlink socket. | File a ticket with Cumulus Support. |
| CRITICAL | nl_resync_route failed for cache [int]: [str] | Failied to create a resync router function in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't set bufsize for manager netlink socket.|Failied to reinitialize buffer size in Netlink socket. | File a ticket with Cumulus Support. |
| CRITICAL | invalid cache mngrinfo. | Failied to create a resync in Netlink idle callback. | File a ticket with Cumulus Support. |
| CRITICAL | [str]: failed to close socket: [str] | Failed to configure FD in Netlink socket. | File a ticket with Cumulus Support. |
| CRITICAL | [str]: nl_cache_mngr_data_ready failed: [str] | Failed to configure FD in Netlink socket. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't allocate netlink socket. | Failed to create a socket in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't allocate netlink socket. | Failed to create a socket in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't allocate manager netlink socket. |Failed to create a socket in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't create cache manager: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't set bufsize for manager netlink socket. | Failed to allocate a cache in Netlink init. |File a ticket with Cumulus Support. |
| CRITICAL | Couldn't add link cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support.|
| CRITICAL | Couldn't add link cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't add route cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't add mdb cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't alloc neigh cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't add mroute cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't alloc tcqdisc cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't add tcqdisc cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't alloc tcclass cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't add tcclass cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't alloc tccls cache: [str] | Failed to allocate a cache in Netlink init.|File a ticket with Cumulus Support.|
| CRITICAL | Couldn't add tccls cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't alloc tcact cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't add tcact cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't alloc rule cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't add rule cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't add neigh cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't alloc netconf cache: [str] | Failed to allocate a cache in Netlink init. | File a ticket with Cumulus Support. |
| CRITICAL | Couldn't initialize genl/port interface | Failed to initialize port interface in Netlink init. |File a ticket with Cumulus Support. |
| CRITICAL | Failed to create kernel bridge | Failed to allocate a hash entry in bridge sync. | File a ticket with Cumulus Support. |
| CRITICAL |Port msg [str] failure: err [int] | Failed to configure PORT FEC parameter. | File a ticket with Cumulus Support. |
| CRITICAL | Port msg [str] reply failure: err [int] | Failed to configure PORT FEC parameter. | File a ticket with Cumulus Support. |
| CRITICAL | Failed run recvmsg_default on port socket, err [int], [str] | Failed to initialize PORT receiving messages. | File a ticket with Cumulus Support. |
| CRITICAL | vlan stats send failure: err [int] | Failed to configure status in VLAN. | File a ticket with Cumulus Support. |
| CRITICAL | mroute hitbits send failure: err [int] | Failed to configure hit bit status in MCAST router. | File a ticket with Cumulus Support. |
| CRITICAL | Port send stats failure: err [int] | Failed to configure status in PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Port send settings failure: err [int] | Failed to configure settings in PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Port send carrier failure: err [int] | Failed to configure carrier in PORT. | File a ticket with Cumulus Support. |
| CRITICAL  |ifindex [int] already registered for port ops | Failed to register interface options in PORT. | File a ticket with Cumulus Support. |
| CRITICAL | ifindex [int] not registered for port ops | Failed to unregister interface options in PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to allocate port hash table | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to allocate port socket | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to genl connect to port socket | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to allocate port sync socket | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to genl connect to port socket | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to set genl port sync socket to non-blocking | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to resolve port ops, err [int] | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to resolve port multicast group | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to register port ops, err [int] | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to add port group membership, err [int] | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | Failed to modify port socket notify cb, err [int] | Failed to initialize PORT. | File a ticket with Cumulus Support. |
| CRITICAL | [str]:[int]: [str][str]Assertion [str] failed | Failed to find the function name in switchd. | File a ticket with Cumulus Support. |
| ERROR | priority group [int] headroom count [int] exceeds the maximum value [int] |P ort headroom buffers exceed ASIC limit. | File a ticket with Cumulus Support. |
| ERROR | shared buffer type [int] not recognized|Invalid buffer type. | File a ticket with Cumulus Support. |
| ERROR | sx_api_cos_prio_to_ieeeprio_set failed: [str] | IEEE priority map configuration write failed. | File a ticket with Cumulus Support. |
| ERROR | _hal_mlx_packet_2_switch: priority field [int] not supported | Packet priority field not supported for source. | Check QoS configuration file. |
| ERROR | priority field [int] not supported |P acket priority field not supported for remark. | Check QoS configuration file. |
| ERROR | cos list length [int] is longer than maximum value [int] | ECN/RED configuration: list is too long. |Check QoS configuration file. |
| ERROR | hash params get failed: [str] | ASIC ECMP hash seed configuration read failed. | File a ticket with Cumulus Support. |
| ERROR | hash params set failed: [str] | ASIC ECMP hash seed configuration write failed. | File a ticket with Cumulus Support. |
| ERROR | hal_sh_datapath_pfc_set: PFC configuration not supported on the CPU port | CPU port does not support priority flow control. | File a ticket with Cumulus Support. |
| ERROR | hal_sh_datapath_init: datapath init failed: rv [int]: [str] | Back end QoS initialization failed. | Check for detailed log messages. |
| ERROR | _priority_field_list_get: Packet priority field [str] not supported | Invalid packet priority field. |Check QoS configuration file. |
| ERROR | _sfs_init: could not load traffic config file [str] | Traffic configuration file missing or is unreadable. | Check QoS configuration file. |
| ERROR | _sfs_port_init: could not load traffic config file [str] | Traffic configuration file missing or is unreadable. | Check QoS configuration file. |
| ERROR | _add_port_group: port group [str] exceeds max port group count [int] | Too many port groups configured. | Check QoS configuration file. |
| ERROR | _add_port_group: memory allocation failed for port group [str] | Memory allocation failed. | File a ticket with Cumulus Support. |
| ERROR | _switch_priority_config: [str] | ASIC scheduler configuration failed. | File a ticket with Cumulus Support. |
| ERROR | _priority_map_config map function, hal port [int]: [str] | ASIC priority map configuration failed. | File a ticket with Cumulus Support. |
| ERROR | _priority_map_config enable function: [str] | ASIC priority map enable configuration failed. | File a ticket with Cumulus Support. |
| ERROR | _port_group_range_translate: invalid port list: range length is 0, id list is 0 | Invalid port set configuration. | Check QoS configuration file. |
|ERROR|_port_group_range_translate: failed: port list not created from range [str] to [str]|Invalid port set configuration.|Check QoS configuration file.|
|ERROR|hal_datapath_init: priority field initialization expects 3 three priority fields, got [int]|Invalid inputs.|File a ticket with Cumulus Support.|
|ERROR|hal_datapath_init: priority map direction initialization expects two priority map directions, got [int]|Invalid inputs.|File a ticket with Cumulus Support.|
|ERROR|hal_datapath_init: DOS config failed: [str]|ASIC DoS config failed.|File a ticket with Cumulus Support.|
|ERROR|_cutthrough_config: Cutthrough config failed on HAL port [int]: [str]|ASIC cut-through configuration failed.|File a ticket with Cumulus Support.|
|ERROR|_source_priority_map_init: packet priority map size [int] is larger than array length [int]|Configured priority map list is too large.|Check QoS configuration file.|
|ERROR|_source_priority_map_populate: packet priority map entry index [int] is larger than array length [int]|Configured priority map list is too large.|Check QoS configuration file.|
|ERROR|_remark_priority_map_init: packet priority map entry index [int] is larger than array length [int]|Configured priority map list is too large.|Check QoS configuration file.|
|ERROR|_remark_priority_map_populate: packet priority map entry index [int] is larger than array length [int]|Configured priority map list is too large.|Check QoS configuration file.|
|ERROR|_priority_map_get: field index [int] is out of bounds: [int] available field entries|Invalid packet priority field.|Check QoS configuration file.|
|ERROR|_priority_map_get: cos ID [int] is out of bounds: [int] cos ID values|Invalid priority value.|Check QoS configuration file.|
|ERROR|_priority_map_get: old syntax flag [int] should be less than [int]|Invalid configuration syntax.|File a ticket with Cumulus Support.|
|ERROR|hal_list_get: strdup returned NULL|Memory allocation failed.|File a ticket with Cumulus Support.|
|ERROR|hal_port_pause_set: RX pause not allowed on port [int]|Invalid operation for the current port configuration.|Check QoS configuration file.|
|ERROR|vlan_range_confi: incorrect format, revert to default|Invalid configuration.|Correct configured VLAN range.|
|ERROR|vlan_range_confi: incorrect format, revert to default|Invalid configuration.|Correct configured VLAN range.|
|ERROR|vlan_range_confi: incorrect range, revert to default|Invalid configuration.|Correct configured VLAN range.|
|ERROR|vlan_range_confi: minimum range is [int], revert to default|Invalid configuration.|Correct configured VLAN range.|
|ERROR|backend_enum_info_key unsupported type [uint]|Invalid backend type.|File a ticket with Cumulus Support.|
|ERROR|hal_init [str] enum_fn [str]: dlerror [str]|No back end enum function found.|File a ticket with Cumulus Support.|
|ERROR|hal_init failed to open [str]: [str]|Could not open the back end DLL.|File a ticket with Cumulus Support.|
|ERROR|hal_init unsupported type [uint]|Invalid back end type.|File a ticket with Cumulus Support.|
|ERROR|hal_init: backend function at offset [int] non populated: [address]|Back end function pointer is not set.|File a ticket with Cumulus Support.|
|ERROR|Unable to setup handling of SIGHUP for log rotation: [str]|Signal handler initiailzation failed.|File a ticket with Cumulus Support.|
|ERROR|Couldn't delete pid file [str], [str]|Could not delete process ID file.|File a ticket with Cumulus Support.|
|ERROR|Failed to update VRF [str] to table id [uint]|||
|ERROR|Failed to add VRF [str] with table id [uint]|||
|ERROR|Failed to get VRF table id for index [int]|VRF table ID not found for the master link.|File a ticket with Cumulus Support.|
|ERROR|[int] hosts were ignored due to capacity.|Kernel neighbors did not fit in the hardware table.|Modify neighbor configuration.|
|ERROR|[int] routes were ignored due to total capacity.|Kernel routes did not fit in the hardware table.|Modify route configuration.|
|ERROR|[int] [str] routes were ignored due to capacity.|Kernel routes did not fit in the hardware table.|Modify route configuration.|
|ERROR|Ignoring VRF [str]; table id 0 is reserved for default VRF|Invalid table ID for the VRF.|Modify VRF configuration.|
|ERROR|Failed to update VRF [str] to table id [uint]|Failed to update the VRF table ID.|File a ticket with Cumulus Support.|
|ERROR|Failed to add VRF [str] with table id [uint]|Failed to add the VRF.|File a ticket with Cumulus Support.|
|ERROR|Failed to set type to 'vrf' in link filter|Failed to update the Netlink cache link type.|File a ticket with Cumulus Support.|
|ERROR|Found [int] VRF entries after sync. cleaning up.|VRF entries remaining after sync operation.|File a ticket with Cumulus Support.|
|ERROR|Ignoring attempts to delete default route for table 0|Failed to remove the default route.|File a ticket with Cumulus Support.|
|ERROR|Master interface not found in nl cache for index [int]|Link object not found in Netlink cache.|File a ticket with Cumulus Support.|
|ERROR|Maximum number of VRFs already exist. Can not add VRF for table [uint]|More VRFs have been configured than the maximum number supported by the platform.|Reduce the number of configured VRFs.|
|ERROR|Failed to delete REPL route from Hash Table|Failure in VRF route leak feature. This message notifies that an entry could not be properly deleted from one of the software tables.|File a ticket with Cumulus Support.|
|ERROR|Failed to add route [str]|Failure in VRF route leak feature. This message notifies that a route entry could not be properly added to one of the software tables.|File a ticket with Cumulus Support.|
|ERROR|Route [str] in HW, but not in HAL cache. Adding.|Happens when HAL resync is triggered. Route discovered in hardware but it is not in the software database.|No action is required as software auto-corrects.|
|ERROR|HW route [str] doesn't match HAL route [str]. Updating.|Happens when HAL resync is triggered. Route discovered in hardware but it is not matching the software database.|No action is required as software auto-corrects.|
|ERROR|Route [str] in HAL cache, but not in HW. Deleting.|Happens when HAL resync is triggered. Route discovered in software but it is not seen in the hardware.|No action is required as software auto-corrects.|
|ERROR|No parent interface for [str]|The parent interface of an interface could not be derived. This is a software issue.|File a ticket with Cumulus Support.|
|ERROR|[str]: sfs backing pointer is NULL|FUSE file pointer is NULL.|File a ticket with Cumulus Support.|
|ERROR|port sample rate string not found|Port sampling rate is not set.|Correct the configuration.|
|ERROR|[str]: hal port pointer is NULL for port sample string [str]|Port pointer is incorrect when port sampling is set.|File a ticket with Cumulus Support.|
|ERROR|port sample rate string [str] not recognized|Port sampling rate is not configured properly.|Correct the configuration.|
|ERROR|port sample interface [str] in port sample string '[str]' not recognized|Port sampling port-name is not configured properly.|Correct the configuration.|
|ERROR|port sample rate value not recognized in string [str]|Port sampling value is not configured properly.|Correct the configuration.|
|ERROR|port sample rate value [str] does not contain a valid integer|Port sampling value is not configured properly using integer values.|Correct the configuration.|
|ERROR|[int] mroutes were ignored due to total capacity.|Maximum number of multicast routes exceeded.|Reduce the number of multicast routres in the switch/fabric.|
|ERROR|local_ip format in fuse node is incorrect [str]|Local_IP value formatting in FUSE file is incorrect.|Correct the configuration.|
|ERROR|local_ip fuse node read failed|Local_IP value formatting in FUSE file is invalid.|Correct the configuration.|
|ERROR|vxlan encap dscp action invalid|VXLAN encap DSCP action in FUSE file is invalid.|Correct the configuration.|
|ERROR|vxlan encap dscp action [[str]] invalid|VXLAN encap DSCP action formatting in FUSE file is invalid.|Correct the configuration.|
|ERROR|vxlan decap dscp action invalid|VXLAN decap DSCP action in FUSE file is invalid.|Correct the configuration.|
|ERROR|vxlan decap dscp action invalid|VXLAN decap DSCP action formatting in FUSE file is invalid.|Correct the configuration.|
|ERROR|sx_api_lag_hash_flow_params_set failed: [str]|Set hash flow parameters failed in the SDK.||
|ERROR|bond IDs exhausted|Maximum number of bonds exhausted.|Reduce the numbert of configured bonds.|
|ERROR|bond_id [uint] swid [uint] lag create failed: [str]|Setting a LAG port group failed in the SDK.||
|ERROR|bond_id [uint] lag_id 0x%x port state set failed: [str]|Port state could not be set to ADMIN_UP in the SDK.||
|ERROR|bond_id [uint] lag_id 0x%x ingr_filter set failed: [str]|Ingress filter set failed for specified bond_id and lag_id in the SDK.||
|ERROR|bond_id [uint] old lag_id 0x%x not cleaned up|Could not find the mapping of the bond_id with the old lag_id, hence cleanup was not successful.||
|ERROR|lag_id 0x%x swid [uint] failed: [str]|Removal of the LAG port group for the specified lag_id failed.||
|ERROR|cannot find bond slave port [uint]|During addition of a bond slave port to a bond, the slave port entry in the software tables could not be found.||
|ERROR|ifp not found for bond_id [uint]|Software entry for a bond_id could not be found in the database.||
|ERROR|[str] member [str] add failed: [str]|Adding a member to a LAG group failed in the SDK.||
|ERROR|[str] member [str] delete failed: [str]|Deleting a member in a LAG group failed in the SDK.||
|ERROR|invalid port_storm_ctrl_type [uint]|Invalid Storm-Control-Type (invalid value) detected in the software. Internal error.||
|ERROR|unexpected duplicate bond if_key [str]|Existing duplicate bond key found in the software table.||
|ERROR|lag_id 0x%x with no corresponding bond id|bond_id could not be located for the given lag_id.||
|ERROR|[str] collector set failed for [str]: [str]|Adding the specified port to the collector set for the bond failed.||
|ERROR|[str] distributor set failed for [str]: [str]|Adding the specified port to the distributor set for the bond failed.||
|ERROR|cannot find base bond slave [str] for bond_id [int]|During update of a bond, the slave port entry in the software tables could not be found.||
|ERROR|unexpected duplicate bond interface [str]|Existing duplicate bond interface found in the software table.||
|ERROR|unexpected duplicate lag_id 0x%x|Existing duplicate lag_id found in the software table.||
|ERROR|info not found for bond_id [uint]|An expected entry could not be found for a given bond_id in a software table.||
|ERROR|[str] unexpected duplicate member [str]|Duplicate entry for the specified interface found for a bond in a software table.||
|ERROR|info not found for bond_id [uint]|An expected entry could not be found for a given bond_id in a software table.||
|ERROR|initialization failed: [str]|SDK API call for tunnel initialization failed.|File a ticket with Cumulus Support.|
|ERROR|logical network type [uint] key [uint] not found|Logical network of given type and key was not found in the software tables.|File a ticket with Cumulus Support.|
|ERROR|logical network type [uint] key [uint] not found|Logical network of given type and key was not found in the software tables.|File a ticket with Cumulus Support.|
|ERROR|failed to create keys tunnel type [uint] and key [uint]|Failed to create logical network keys of given tunnel type and interface key in the software tables.|File a ticket with Cumulus Support.|
|ERROR|failed to update the decap key for gre entry tunnel_id:|Failed to update the GRE decap keys for the given tunnel.|File a ticket with Cumulus Support.|
|ERROR|failed to find the decap key for tunnel_id : (0x%x)|Failed to find the GRE decap keys for the given tunnel.|File a ticket with Cumulus Support.|
|ERROR|failed to update a decap entry tunnel_id : (0x%x)|Failed to update the GRE decap keys for the given tunnel.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate entry in gre_tunnel_key_ht|GRE tunnel key table has an existing duplicate entry.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate entry in gre_tunnel_id_ht|GRE tunnel ID table has an existing duplicate entry.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate entry in gre_olay_ulay_ht|GRE tunnel overlay/underlay table has an existing duplicate entry.|File a ticket with Cumulus Support.|
|ERROR|failed to create the hw decap key for gre entry tunnel_id:|Failed to create the GRE decap keys for the given tunnel.|File a ticket with Cumulus Support.|
|ERROR|failed to create a decap entry tunnel_id : (0x%x)|Failed to create a decap entry in the software table for the given tunnel_id.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate entry in gre_decap_ht tunnel_id|GRE decap table has an existing duplicate entry for the given tunnel.|File a ticket with Cumulus Support.|
|ERROR|failed to create|Failed to set up a tunnel between the given local and remote IP addresses.|File a ticket with Cumulus Support.|
|ERROR|unable to find overlay overlay info from overlay ifindex:|While removing a GRE tunnel, the overlay info could not be retrieved from the software tables for the given ifindex.|File a ticket with Cumulus Support.|
|ERROR|failed to create key for type [uint]|Failed to create the GRE keys for the given tunnel type.|File a ticket with Cumulus Support.|
|ERROR|failed to find gre entry|Failed to find a logical network entry for a tunnel in the software tables during tunnel removal.|File a ticket with Cumulus Support.|
|ERROR|failed to find gre entry|Failed to find a GRE decap entry for a tunnel during tunnel removal.|File a ticket with Cumulus Support.|
|ERROR|Failed to open SX-API, error: [str]|SDK API open failed.|File a ticket with Cumulus Support.|
|ERROR|Failed to set SDK VERBOSITY level, error: [str]|Failed to set SDK VERBOSITY level.|File a ticket with Cumulus Support.|
|ERROR|num_devices [uint] is invalid|SDK found zero (asic) devices.|File a ticket with Cumulus Support.|
|ERROR|Failed to initialize SDK ([str])|Failed to initialize SDK.|File a ticket with Cumulus Support.|
|ERROR|*** failed to configure the requested setup ***|The board configuration could not be enforced.|File a ticket with Cumulus Support.|
|ERROR|more devices encountered than configured [uint]|More devices encountered than configured.|File a ticket with Cumulus Support.|
|ERROR|duplicate device ID [uint]|Found an existing duplicate device when adding a new device.|File a ticket with Cumulus Support.|
|ERROR|invalid unit [uint] num_devices [uint]|Internal error: given unit number is out of range.|File a ticket with Cumulus Support.|
|ERROR|invalid port [uint] num_ports [uint]|Internal error: given port number is out of range.|File a ticket with Cumulus Support.|
|ERROR|ERROR: Fail to extract data from XML file|The topology map could not be extracted from the XML file.|File a ticket with Cumulus Support.|
|ERROR|Device ID already added|A device is already added to the topology database.|File a ticket with Cumulus Support.|
|ERROR|Device ID [uint] NOT found in the XML file|A device could not be found in the databse.|File a ticket with Cumulus Support.|
|ERROR|Failed to add device [uint] to the SDK (sx_api_topo_device_set)|Failed to add a device to the topology database.|File a ticket with Cumulus Support.|
|ERROR|Failed to allocate memory for tree tree_info array,|Memory exhausted.|Restart switchd, if possible. File a ticket with Cumulus Support.|
|ERROR|ERROR: Fail to add topo tree|Top tree could not be added.|File a ticket with Cumulus Support.|
|ERROR|Failed to set topo device ready for device [uint]: [str]|Could not set DEVICE_READY in the SDK.|File a ticket with Cumulus Support.|
|ERROR|Unable to load file [str]<span></span> (file not exists or corrupted )|The specified XML configuration file could not be loaded as it either does not exist or is possibly corrupted.|File a ticket with Cumulus Support.|
|ERROR|Unable to parse file (error #[int]: [str])|The specified XML configuration file could not be parsed.|File a ticket with Cumulus Support.|
|ERROR|Expat error #[int]<span></span> (line [int] , column [int]): [str]|A parsing error encountered when parsing the configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing number of devices|Error parsing the number of child devices in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing device mac address|Error parsing the device MAC address in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing device MAC address|Error parsing the device MAC address in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error mac cannot be 00:00:00:00:00:00|Found a device MAC address of all zeores in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Failed running [str]|Specified system command failed.|File a ticket with Cumulus Support.|
|ERROR|Error parsing dev_number|Error parsing the device number in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing device mac address|Error parsing the device MAC address in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing device MAC address|Error parsing the device MAC address in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing number of physical ports value|Error parsing the number of PHY ports in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Invalid number of physical ports [uint]|Found zero or more than the allowed maximum port numbers in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing ports list section|Error parsing the port list section in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing local port number|Error parsing the local port number in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing mapping mode|Error parsing the mapping mode in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing label port|Error parsing the label port in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing width value|Error parsing the port width in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing RX lanes value , local port: [[int]]|Error parsing the RX lanes value in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing lanes value , local port: [[int]]|Error parsing the lanes value in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing lanes value, local port: [[int]]|Error parsing the lanes value in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing lane to module value, local port: [[int]]|Error parsing the lane to module mapping value in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing lane to module value , local port: [[int]]|Error parsing the lane to module mapping value in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing port mode value|Error parsing the in the port mode value XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing port speed value|Error parsing the in the port speed value XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing swid value|Error parsing the swid value in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Error parsing autoneg value|Error parsing the autoneg value in the XML configuration file.|File a ticket with Cumulus Support.|
|ERROR|Conflict detected in lid 0x%0x port [uint] dev_id [uint]|lid already detected in a software table.|File a ticket with Cumulus Support.|
|ERROR|port_device_set has failed for device [uint]<span></span> ([str])|Could not set a port device to the SDK.|File a ticket with Cumulus Support.|
|ERROR|topo_xml_device_add failed for device [uint]<span></span> ([str])|A device could not be added to a topo_xml_device database.|File a ticket with Cumulus Support.|
|ERROR|mode set dev [int] port 0x%x failed: [str]|Port mode could not be set to STACKING mode in the SDK.|File a ticket with Cumulus Support.|
|ERROR|binding dev [int] port 0x%x to swid [int] failed: [str]|Binding the device and port to the swid failed in the SDK.|File a ticket with Cumulus Support.|
|ERROR|port_init dev [int] port 0x%x failed: [str]|Specified device/port could not be initialized in the SDK.|File a ticket with Cumulus Support.|
|ERROR|swid set failed: [str]|swid set failed in the SDK.|File a ticket with Cumulus Support.|
|ERROR|Failed to set port 0x%x mapping: [str]|Port mapping failed for the specified port in the SDK.|File a ticket with Cumulus Support.|
|ERROR|Failed to set port 0x%x mapping: [str]|Port mapping failed for the specified port in the SDK.|File a ticket with Cumulus Support.|
|ERROR|invalid bridge_vlan [uint] for bridge_id [int]|The specified bridge_vlan is not valid for the given bridge_id.|File a ticket with Cumulus Support|
|ERROR|vfid not set for vlan [uint]|VFID is not set for the specified VLAN.|File a ticket with Cumulus Support.|
|ERROR|new group check failed for vlan [uint] mac [str]: [str]|The specified MAC address and VLAN already exist in a group.|File a ticket with Cumulus Support.|
|ERROR|old port list get failed for vlan [uint] mac [str]: [str]|Could not find the existing port list for the given MAC address and VLAN.|File a ticket with Cumulus Support.|
|ERROR|port delete failed for vlan [uint] mac [str]: [str]|Could not delete the existing port list for the given MAC address and VLAN.|File a ticket with Cumulus Support.|
|ERROR|create failed for vlan [uint] mac [str]: [str]|Could not create a new multicast group for the given MAC address and VLAN.|File a ticket with Cumulus Support.|
|ERROR|port add failed for vlan [uint] mac [str]: [str]|Could not add a port to the port list for the given MAC address and VLAN.|File a ticket with Cumulus Support.|
|ERROR|invalid bridge_vlan [uint] for bridge_id [int]|The specified bridge_vlan is not valid for the given bridge_id.|File a ticket with Cumulus Support.|
|ERROR|vfid not set for vlan [uint]|The specified MAC address and VLAN already exist in a group.|File a ticket with Cumulus Support.|
|ERROR|group delete failed for vlan [uint] mac [str]: [str]|Could not delete a multicast group for the given MAC address and VLAN.|File a ticket with Cumulus Support.|
|ERROR|invalid bridge_vlan [uint] for bridge_id [int]|The specified bridge_vlan is not valid for the given bridge_id.|File a ticket with Cumulus Support.|
|ERROR|vfid not set for vlan [uint]|VFID is not set for the specified VLAN.|File a ticket with Cumulus Support.|
|ERROR|flood_mode_get failed for swid [int] vfid [int] [str]|Flood mode value could not be retrieved for the given swid/port/vfid.|File a ticket with Cumulus Support.|
|ERROR|unreg_mc_flood_ports fail for swid [int], vfid [int], [str]|Unregistered multicast flood ports setting for given swid/port/vfid failed in the SDK.|File a ticket with Cumulus Support.|
|ERROR|mroute ports [int] exceeds [int]|A multicast route has a larger number of ports than the RIFs on the switch.|File a ticket with Cumulus Support.|
|ERROR|no container id retrieved for [str]|Egress container could not be retrieved.|File a ticket with Cumulus Support.|
|ERROR|route cmd [str] failed: [str]|Setting multicast route in the SDK failed.|File a ticket with Cumulus Support.|
|ERROR|router table_id [uint] vrid [int] set failed: [str]|Setting a VRID for a router failed.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate key list size [uint]|Unexpected duplicate entry found in next-hop list.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate key type [str] min_mtu [uint] fid [uint]|Unexpected duplicate entry in container anchor.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate nh_list num_elems [uint]|Unexpcted duplicate next-hop list in container.|File a ticket with Cumulus Support.|
|ERROR|failed for nh_list num_elems [uint]: [str]|Could not create a new container for the next-hop list in the SDK.|File a ticket with Cumulus Support.|
|ERROR|failed for type [str] container_id [uint] num_elems [uint]: [str]|Could not free a container for the next-hop list in the SDK.|File a ticket with Cumulus Support.|
|ERROR|unsupported chip type [uint]|Chip type in table is not supported.|File a ticket with Cumulus Support.|
|ERROR|invalid parse depth|VXLAN parsing depth setting is invalid.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate ln_type [uint] ln_key [uint]|Unexpected duplicate entry in logical VPN key table.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate ID 0x%x|Unexpected duplicate entry in logical VPN ID table.|File a ticket with Cumulus Support.|
|ERROR|unsupported ln_type [int] or ln_key [int]|Unsupported logical network type encountered.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate ln_type [uint] ln_key [uint]|Unexpected duplicate entry in logical network table.|File a ticket with Cumulus Support.|
|ERROR|lid 0x%x remote_ip [str] not found|Local ID to remote_ip mapping retrieval failed.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate key [uint]|Unexpected duplicate entry in the VPN map table.|File a ticket with Cumulus Support.|
|ERROR|invalid VPN or vlan [uint]|Invalid VPN/VLAN value provided for creating a VPM map entry.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate entry|Unexpected duplicate entry in VPN decap table.|File a ticket with Cumulus Support.|
|ERROR|invalid VPN|Invalid VPN value provided for creating a VPN decap entry.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate key [str] type [uint]|Unexpected duplicate entry in VPN next-hop table.|File a ticket with Cumulus Support.|
|ERROR|tunnel get failed: [str]|Tunnel attribute retrieval from the SDK failed.|File a ticket with Cumulus Support.|
|ERROR|tunnel update failed: [str]|Tunnel attribute update in the SDK failed.|File a ticket with Cumulus Support.|
|ERROR|creation failed: [str]|VXLAN tunnel creation failed.|File a ticket with Cumulus Support.|
|ERROR|tunnel_id 0x%x hash set failed: [str]|VXLAN UDP header src port control setting in SDK for enabling better entropy failed.|File a ticket with Cumulus Support.|
|ERROR|unsupported type [uint]|Unsupported tunnel type encountered.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate key for tunnel_id 0x%x|Unexpected duplicate entry in logical VPN tunnel key table.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate ID for tunnel_id 0x%x|Unexpected duplicate entry in logical VPN ID table.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate ln_type [uint] ln_key [uint]|Unexpected duplicate entry in logical network table.|File a ticket with Cumulus Support.|
|ERROR|update failed: [str]|VXLAN tunnel update failed.|File a ticket with Cumulus Support.|
|ERROR|unsupported type [uint]|Unsupported tunnel type encountered.|File a ticket with Cumulus Support.|
|ERROR|tunnnel_id 0x%x failed: [str]|VXLAN tunnel destroy failed.|File a ticket with Cumulus Support.|
|ERROR|tunnel_id 0x%x ttl [uint] failed: [str]|VXLAN tunnel TTL set failed.|File a ticket with Cumulus Support.|
|ERROR|failed: [str]|VXLAN tunnel map set failed.|File a ticket with Cumulus Support.|
|ERROR|vfid not available for vlan [uint]|VFID is not set for the specified VLAN.|File a ticket with Cumulus Support.|
|ERROR|failed: [str]|VXLAN tunnel map set failed.|File a ticket with Cumulus Support.|
|ERROR|failed: [str]|Tunnel decap entry could not be set.|File a ticket with Cumulus Support.|
|ERROR|failed: [str]|Tunnel decap entry could not be set.|File a ticket with Cumulus Support.|
|ERROR|[str] group_id [uint] vid [uint] failed: [str]|FDB flood set for a group failed.|File a ticket with Cumulus Support.|
|ERROR|group_id [uint] vid [uint] failed: [str]|FDB flood set for a group failed.|File a ticket with Cumulus Support.|
|ERROR|creation failed: [str]|VPN device addition to the SDK failed.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate entry|VPN port table has an existing duplicate entry.|File a ticket with Cumulus Support.|
|ERROR|vpn_port 0x%x failed: [str]|VPN device deletion from the SDK failed.|File a ticket with Cumulus Support.|
|ERROR|tunnel encap dscp action PRESERVE is invalid|PRESERVE is not a valid action.|Check configuration.|
|ERROR|tunnel_id 0x%x cos set failed: [str]|COS set failed for a tunnel.|File a ticket with Cumulus Support.|
|ERROR|tunnel decap dscp action SET is invalid|SET is not a valid DSCP action.|Check configuration.|
|ERROR|tunnel_id 0x%x cos set failed: [str]|COS set failed for a tunnel.|File a ticket with Cumulus Support.|
|ERROR|tunnel id not found: ln_type [uint] ln_key [uint]|Specified tunnel ID was not found in the VPN table.|File a ticket with Cumulus Support.|
|ERROR|Error opening socket for grat arp [str], ifi [int]: [str]|Gratuitous ARP socket could not be opened.|File a ticket with Cumulus Support.|
|ERROR|Error sending grat arp [str], ifi [int]: [str]|Gratuitous ARP socket could not be sent.|File a ticket with Cumulus Support.|
|ERROR|Failed to update table id for port [int], interface [str]/[int]|table_id could not be updated for a port.|File a ticket with Cumulus Support.|
|ERROR|interface not found at index [int]|Interface information for a given ifindex could not be found.|File a ticket with Cumulus Support.|
|ERROR|Failed to open IPv4 socket [str]|IPv4 socket open failed.|File a ticket with Cumulus Support.|
|ERROR|Failed to set SO_RCVBUF [str]|Socket option SO_RCVBUF set failed.|File a ticket with Cumulus Support.|
|ERROR|No source MAC address ifindex [int], [str]|No source MAC address found for given ifiindex.|File a ticket with Cumulus Support.|
|ERROR|Failed to open IPv6 socket [str]|IPv6 socket open failed.|File a ticket with Cumulus Support.|
|ERROR|Failed to set SO_RCVBUF [str]|Socket option SO_RCVBUF set failed.|File a ticket with Cumulus Support.|
|ERROR|No source MAC address ifindex [int], [str]|No source MAC address found for given ifiindex.|File a ticket with Cumulus Support.|
|ERROR|Adding ctx to hash table failed|Adding ctx to hash table failed.|File a ticket with Cumulus Support.|
|ERROR|Getting pktinj failed|Getting pktinj failed.|File a ticket with Cumulus Support.|
|ERROR|ERSPAN target is supported with the following field(s): --src-ip <ipaddr> --dst-ip <ipaddr>.|ACL unsupported ERSPAN target.|See ACL user documentation.|
|ERROR|Inverse flags not supported for UDP|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|Specified Match [str] not supported|ACL unsupported match.|See ACL user documentation.|
|ERROR|Specified Target [str] not supported|ACL unsupported target.|See ACL user documentation.|
|ERROR|Inverse flags not supported for ARP|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|Inverse flags not supported for IP|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|Inverse flags not supported for IPv6|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|Traffic class [hex] not supported for IP|ACL unsupported match.|See ACL user documentation.|
|ERROR|Range for ICMP Types i.e [hex]-[hex] not supported|ACL unsupported match.|See ACL user documentation.|
|ERROR|Range for ICMP codes i.e [hex]-[hex] not supported|ACL unsupported match.|See ACL user documentation.|
|ERROR|Invert flags not supported for mark_m|ACL unsupported match.|See ACL user documentation.|
|ERROR|OR bitmask [hex] not supported for mark_m match|ACL unsupported match.|See ACL user documentation.|
|ERROR|Inverse flags not supported for VLAN|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|Inverse flags not supported for ICMP|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|vlanid match not supported for VLAN|ACL vlanid usupported match.|See ACL user documentation.|
|ERROR|vlan prio match not supported for VLAN|ACL vlan prio unsupported match.|See ACL user documentation.|
|ERROR|IP, IPv6, ARP options are not supported for LOG|ACL unsupported match for LOG action.|See ACL user documentation.|
|ERROR|Interface [str] not supported for SPAN|ACL unsupported target.|See ACL user documentation.|
|ERROR|SPAN target is supported with the following|ACL unsupported SPAN target.|See ACL user documentation.|
|ERROR|ERSPAN target is supported with the following|ACL unsupported match.|See ACL user documentation.|
|ERROR|Inverse flags not supported for ICMPv6|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|target bitmask [hex] not supported for mark|ACL unsupported verdicts continue/return/etc.|See ACL user documentation.|
|ERROR|Specified Match [str] not supported|ACL unsupported match.|See ACL user documentation.|
|ERROR|Specified watcher [str] not supported|ACL unsupported watcher action.|See ACL user documentation.|
|ERROR|Specified target [str] not supported|ACL unsupported target action.|See ACL user documentation.|
|ERROR|Inverse flags not supported for Multiport|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|Inverse flags not supported for TOS|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|Inverse flags not supported for DSCP|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|Inverse flags or Limit Interface or Source not supported for addrtype|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|Dest addrtypes other than IPROUTER/LOCAL not supported|ACL unsupported match for addrtype.|See ACL user documentation.|
|ERROR|IP6 Fragment IDs not supported|ACL unsupported match.|See ACL user documentation.|
|ERROR|IP6 Length/Reserved or Last or More fragment Fields not supported|ACL unsupported match.|See ACL user documentation.|
|ERROR|Greater/Lesser/Not equal to mode not supported for TTL field|ACL unsupported match.|See ACL user documentation.|
|ERROR|Greater/Lesser/Not equal mode not supported for HL field|ACL unsupported match.|See ACL user documentation.|
|ERROR|Inverse flags not supported for match mark|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|TCP SEQ, TCP Options or IP options, UID are not supported for LOG|ACL unsupported match.|See ACL user documentation.|
|ERROR|TCP SEQ, TCP Options or IP options, UID are not supported for LOG|ACL unsupported match.|See ACL user documentation.|
|ERROR|Inverse flags or options not supported for TCP|ACL inverse match not supported.|See ACL user documentation.|
|ERROR|Interface [str] not supported for SPAN|ACL unsupported target interface in SPAN rule.|See ACL user documentation.|
|ERROR|SPAN target is supported with the following " field(s): --dport swp<n>."|ACL unsupported SPAN target.|See ACL user documentation.|
|ERROR|Interface [str] not supported for SPAN|ACL unsupported target interface.|See ACL user documentation.|
|ERROR|SPAN target is supported with the following field(s): --dport swp<n>.|ACL unsupported SPAN target.|See ACL user documentation.|
|ERROR|resource region [uint] destroy failed: [str]|ACL: Mellanox API for region destroy failed.|File a ticket with Cumulus Support.|
|ERROR|resource region [uint] size [uint] create failed: [str]|ACL: Mellanox API for TCAM region create failed.|Check if there are too many rules/tables.|
|ERROR|unexpected duplicate key [str]|ACL: Internal interface cache has duplicate.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate user: [str] key_idx [val] offset [val]|ACL: Duplicate entry in interface rule hash.|File a ticket with Cumulus Support.|
|ERROR|expected trap_id [uint]<span></span>(actual [uint]) type [uint]<span></span> (actual [val])|ACL: INPUT chain trap counter get ID invalid.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] region [str] [str] size [uint] creation failed: [str]|ACL: Mellanox API for TCAM region create failed.|Check if there are too many rules/tables.|
|ERROR|table [str] chain [str] region [str] [str] size [uint] acl_id creation failed: [str]|ACL: Mellanox API for ACL ID create failed.|Check if there are too many rules/tables.|
|ERROR|table [str] chain [str] region [str] [str] rules del @offset [val] num_rules [val] failed: [str]|ACL: Mellanox API for setting region to ACL ID failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] region [str] [str] size [uint] acl_id destroy failed: [str]|ACL: Mellanox API for unsetting region from ACL ID failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] region [str] [str] size [uint] destroy failed: [str]|ACL: Mellanox API for region destroy failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] region [str] [str] rules add @offset [val] num_rules [val] failed: [str]|ACL: Mellanox API for setting rule in a region failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] failed to allocate Mark value [val]|ACL: Mark value alloc failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] Mark values must be less than [val] when partial mask is in use|ACL: Masked mark use limitation.|Change mask match rules.|
|ERROR|PBR: Unsupported route type ecmp|PBR: Invalid ECMP route.|File a ticket with Cumulus Support.|
|ERROR|PBR: Unsupported route type singe hop|PBR: Invalid non-ECMP route.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] region [str] action [str] is not supported|ACL: Unsupported action.|Remove rule with the action.|
|ERROR|PBR: couldn't set default forward action for rule|PBR: Default action accept couldn't be set for PBR rules.|File a ticket with Cumulus Support.|
|ERROR|[str] offset [uint] or key_idx [uint] exceeds rule list size [uint] or descriptor size [val]|ACL: Too may rules in a region.|File a ticket with Cumulus Support.|
|ERROR|[str] offset [uint] key_idx [uint] invalid key_id [uint]|ACL: Invalid src/dst port/intf in rule.|Remove the rule.|
|ERROR|acl group [str] creation failed: [str]|ACL: Mellanox API for ACL group create failed.|Check for too many ACL tables|
|ERROR|table [str] chain [str] key handle create failed: [str]|ACL: Mellanox API to create a key list handle failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] key attr query failed: [str]|ACL: Mellanox API to get key attributes failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] key handle delete failed: [str]|ACL: Mellanox API for key handle delete failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] region [str] [str] size [uint] offset too large|ACL: Rule offset in region larger than region size.|File a ticket with Cumulus Support.|
|ERROR|region set failed: [str]|ACL: Mellanox API for TCAM region create failed.|Check if there are too many rules/tables.|
|ERROR|acl set failed: [str]|ACL: Mellanox API for ACL ID create failed.|Check if there are too many rules/tables.|
|ERROR|rules set failed: [str]|ACL: Mellanox API for rule set failed.|Check if there are too many rules.|
|ERROR|[str] malloc failed|ACL: Memory resource allocation error.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] too many keys in rule|ACL: Too many keys used in a rule.|Delete the rule.|
|ERROR|table [str] chain [str] too many actions in rule"|ACL: Too many actions in rule.|Modify the rule.|
|ERROR|table [str] chain [str] rule can match on a single output interface only|ACL: Rule match limitation.|Delete the rule.|
|ERROR|table [str] chain [str] number of input interfaces ([uint]) cannot be less than number of output interfaces ([val])|ACL: Rule replication limitation.|Remove the rule.|
|ERROR|table [str] chain [str] key classification missing for [val] input bridge interface(s)|ACL: Ingress/egress intf missing.|Check ACL rules.|
|ERROR|table [str] chain [str] key classification missing for [val] input interface(s)|ACL: Ingress/egress port/bond missing.|Check ACL rules.|
|ERROR|analyzer set failed: [str]|ACL: Mellanox API for setting ERSPAN analyzer port failed.|File a ticket with Cumulus Support.|
|ERROR|session [uint] [str] failed: [str]|ACL: Mellanox API for en/dis of SPAN session failed.|File a ticket with Cumulus Support.|
|ERROR|session [uint] edit failed: [str]|ACL: Mellanox API for ERSPAN session modify failed.|File a ticket with Cumulus Support.|
|ERROR|session [uint] [str] lid 0x%x add failed: [str]|ACL: Mellanox API to set SPAN mirror source failed.|File a ticket with Cumulus Support.|
|ERROR|session [uint] [str] lid 0x%x delete failed: [str]|ACL: Mellanox API to unset SPAN mirror sources failed.|File a ticket with Cumulus Support.|
|ERROR|span init failed: [str]|ACL: Mellanox API for SPAN engine initialization failed.|File a ticket with Cumulus Support.|
|ERROR|Unexpected duplicate session key|ACL: Duplicate SPAN session key.|File a ticket with Cumulus Support.|
|ERROR|session create failed: [str]|ACL: Mellanox API for session create failed.|File a ticket with Cumulus Support.|
|ERROR|out of SPAN/ERSPAN sessions|ACL: Too many SPAN/ERSPAN session targets.|Check and reduce SPAN sesions.|
|ERROR|session [uint] analyzer delete failed: [str]|ACL: Mellanox API for session delete failed.|File a ticket with Cumulus Support.|
|ERROR|session [uint] destroy failed: [str]|ACL: Mellanox API for for session destroy failed.|File a ticket with Cumulus Support.|
|ERROR|Non flow-based SPAN does not support router interface|ACL: Non-flow based cannot SPAN from routed interface.|Remove these SPAN rules.|
|ERROR|Non flow-based SPAN does not support sub-interface|ACL: Non-flow based cannot SPAN from routed sub-interface.|Remove these SPAN rules.|
|ERROR|unsupported session_type [uint]|ACL: Mirror session has to be SPAN or ERSPAN.|Remove these rules.|
|ERROR|router interface ([str]) is not supported as SPAN dport|ACL: SPAN destination cannot be router interface.|Remove these rules.|
|ERROR|unsupported chip type [uint]|ACL: Wrong plaform/chip type.|File a ticket with Cumulus Support.|
|ERROR|policer creation failed: [str]|ACL: Mellanox internal API to allocate a policer resource failed.|Check number of ACL rules using policers.|
|ERROR|unexpected duplicate ID [val]|ACL: Duplicate policer ID allocated.|File a ticket with Cumulus Support.|
|ERROR|policer [val] delete failed [str]|ACL: Mellnox internal API to delete policer resource failed.|File a ticket with Cumulus Support.|
|ERROR|tricolor conversion failed pir [uint] cir [uint] cbs [val] ebs [val]|ACL: Converting tricolor policer rates to kbps failed.|File a ticket with Cumulus Support.|
|ERROR|conversion failed mode [uint] rate [uint] burst [uint]|ACL: Converting color bind policer rates to kpbs failed.|File a ticket with Cumulus Support.|
|ERROR|counter creation failed: [str]|ACL: Mellanox internal API for allocating a counter failed.|Check number of ACL rules.|
|ERROR|counter [uint] delete failed: [str]|ACL: Mellanox internal API for counter delete failed.|File a ticket with Cumulus Support.|
|ERROR|counter [uint] failed: [str]|ACL: Mellanox internal API for counter read failed.|File a ticket with Cumulus Support.|
|ERROR|policer [val] counter failed: [str]|ACL: Mellanox internal API for for policer counter read failed.|File a ticket with Cumulus Support.|
|ERROR|invalid interface [str]|ACL: Invalid interface specified in ACL rule.|Check ACL rule set.|
|ERROR|bond id [uint] not fully established|ACL: Bond interface not fully up.|Check bond interface configuration on local/remote ends.|
|ERROR|unsupported interface type: [str]|ACL: An ACL rule has an unsupported type of interface specified in match.|Check ACL rule set for interfaces specified.|
|ERROR|mixing PBS ports in different swids [uint] and [uint] is not allowed|ACL: SPAN using policy-based switching doesn't support target ports in different units.|Change SPAN rule configuration.|
|ERROR|unexpected duplicate PBS key with [uint] port(s)|ACL: Duplicate PBS key used for SPAN.|File a ticket with Cumulus Support.|
|ERROR|create failed for PBS record with [uint] port(s): [str]|ACL: Mellanox internal API for PBS set failed.|File a ticket with Cumulus Support.|
|ERROR|pbs_id [uint] delete failed: [str]|ACL: Mellanox internal API for PBS ID delete failed.|File a ticket with Cumulus Support.|
|ERROR|[str] failed for pbs_id [uint]: [str]|ACL: Mellanox internal API for PBS ID delete failed.|File a ticket with Cumulus Support.|
|ERROR|group [str] set failed: [str]|ACL: Mellanox internal API that binds an ACL group to a hardware resource like port/VLAN failed.|File a ticket with Cumulus Support.|
|ERROR|user tokens exhausted|ACL: Mellanox internal API for user token alloc failed.|Check number of ACL rules.|
|ERROR|hardware platform does not support user tokens|ACL: Mellanox plaform doesn't support user tokens.|File a ticket with Cumulus Support.|
|ERROR|unexpected duplicate mark key [uint]|ACL: User token duplicate allocated.|File a ticket with Cumulus Support.|
|ERROR|bind [str] set failed on port 0x%x: [str]|ACL: Mellanox internal API that binds an ACL group to a port failed.|File a ticket with Cumulus Support.|
|ERROR|bind [str] unset failed on port 0x%x: [str]|ACL: Mellanox internal API that unbinds an ACL group from a port failed.|File a ticket with Cumulus Support.|
|ERROR|bind [str] cmd [uint] failed on bond 0x%x: [str]|ACL: Mellanox internal API that un/binds an ACL group with a bond interface failed.|File a ticket with Cumulus Support.|
|ERROR|bind [str] set failed on port 0x%x: [str]|ACL: Mellanox internal API that binds an ACL group to a bond member failed.|File a ticket with Cumulus Support.|
|ERROR|bind [str] cmd [uint] failed on RIF 0x[uint]: [str]|ACL: Mellanox internal API that binds an ACL group to an L3 ingress interface failed.|File a ticket with Cumulus Support.|
|ERROR|group set failed: [str]|ACL: Mellanox internal API that sets the group of an ACL failed.|File a ticket with Cumulus Support.|
|ERROR|range creation failed: [str]|ACL: Mellanox internal API to allocate an L4 port range resource failed.|Check number of ranges being used in ACLs.|
|ERROR|range delete failed: [str]|ACL: Mellanox internal API to free an L4 port range resource failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] chain [str] region [str] [str] size [uint] creation failed: [str]|ACL: Mellanox API for TCAM region create failed.|Check if there are too many rules/tables.|
|ERROR|table [str] chain [str] region [str] [str] size [uint] acl_id creation failed: [str]|ACL: Mellanox API for ACL ID create failed.|Check if there are too many rules/tables.|
|ERROR|table [str] chain [str] region [str] [str] rules del @offset [val] num_rules [val] failed: [str]|ACL: Mellanox API for setting region to ACL ID failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] [str] chain [str] region [str] [str] rules del @offset [val] num_rules [val] failed: [str]|ACL: Mellanox API for setting region to ACL ID failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] [str] chain [str] region [str] [str] size [uint] acl_id destroy failed: [str]|ACL: Mellanox API for unsetting region from ACL ID failed.|File a ticket with Cumulus Support.|
|ERROR|table [str] [str] chain [str] region [str] [str] size [uint] destroy failed: [str]|ACL: Mellanox API for region destroy failed.|File a ticket with Cumulus Support.|
|ERROR|acl group [str] creation failed: [str]|ACL: Mellanox API for ACL group create failed.|Check for too many ACL tables.|
|ERROR|table [str] [str] chain [str] region [str] [str] size [uint] offset too large|ACL: Rule offset in region larger than region size.|File a ticket with Cumulus Support.|
|ERROR|region set failed: [str]|ACL: Mellanox API for TCAM region create failed.|Check if there are too many rules/tables.|
|ERROR|acl set failed: [str]|ACL: Mellanox API for ACL ID create failed.|Check if there are too many rules/tables.|
|ERROR|rules set failed: [str]|ACL: Mellanox API for rule set failed.|Check if there are too many rules.|
|ERROR|iACL action cannot be satisfied with eACL key|ACL: Invalid dependency between ingress and egress ACLs.|Check ACL rules.|
|ERROR|eACL action cannot be satisfied with iACL key|ACL: Invalid dependency between ingress and egress ACLs.|Check ACL rules.|
|ERROR|ACL can match one single output interface only|ACL: Don't support multiple out interface match.|Check ACL rules.|
|ERROR|expected trap_id [uint]<span></span> (actual [uint]) type [uint]<span></span> (actual [val])|ACL: INPUT chain trap counter get ID invalid.|File a ticket with Cumulus Support.|
|ERROR|[str] [str] API [str]: dlerror [str]|nftables unsupported.|Ignore this error message.|
|ERROR|Memory allocation failed|ACL out of memory resource.|File a ticket with Cumulus Support.|
|ERROR|Rule with LOG must be followed by same rule with DROP|An ACL rule with a LOG action must be followed by same rule with a DROP action.|See ACL user documentaion for more info.|
|ERROR|Rule with LOG must be followed by same rule with DROP|An ACL rule with a LOG action must be followed by same rule with a DROP action.|See ACL user documentaion for more info.|
|ERROR|Rule with log watcher must be have DROP action|An ACL rule with a watcher action must be followed by same rule with a DROP action.|See ACL user documentaion for more info.|
|ERROR|Rule with LOG must be followed by same rule with DROP|An ACL rule with a LOG action must be followed by same rule with a DROP action.|See ACL user documentaion for more info.|
|ERROR|[str] not found in hal_bonds|ACL: Bond interface in rule not present.|Check bond configuration.|
|ERROR|Inverse flags for SRC/DST IP, IN/OUT interface, TOS, Protocol not supported|ACL inverse match flags are not supported.|See ACL user documentaion.|
|ERROR|Target Verdict :[str] not supported|ACL rule target verdict queue/stop/return/etc not supported.|See ACL user documentation for supported targets.|
|ERROR|Fall through target not supported|ACL fall through action not supported.|See ACL documentation for supported actions.|
|ERROR|Jump, target:[val] not supported|ACL jump action not supported.|See ACL documentation for supported actions.|
|ERROR|Module, target:[str] not supported|Specified ACL action not supported.|See ACL documentation for supported actions.|
|ERROR|iptables: Invalid argument|iptables rules likely empty.|Check iptables rules list.|
|ERROR|iptables:Could not open raw IPv4,socket.|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|iptables:Error retrieving getsockopt SO_GET_INFO:|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|iptables: Memory allocation for counters failed for size|ACL out of memory resource.|File a ticket with Cumulus Support.|
|ERROR|iptables: Error retrieving getsockopt SO_GET_ENTRIES:|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|iptables: Memory allocation for rules failed for size|ACL out of memory resource.|File a ticket with Cumulus Support.|
|ERROR|Inverse flags for SRC/DST IP, IN/OUT interface, TOS, Protocol not supported|ACL inverse match flags are not supported.|See ACL user documentaion.|
|ERROR|Target Verdict :[str] not supported|ACL rule target verdict queue/stop/return/etc not supported.|See ACL user documentation for supported targets.|
|ERROR|Fall through target not supported|ACL fall through action not supported.|See ACL documentation for supported actions.|
|ERROR|Jump, target:[val] not supported|ACL jump action not supported.|See ACL documentation for supported actions.|
|ERROR|Module, target:[str] not supported|Specified ACL action not supported.|See ACL documentation for supported actions.|
|ERROR|iptables: Invalid argument|iptables rules likely empty.|Check iptables rules list.|
|ERROR|ip6tables:Could not open raw IPv6,socket.|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|ip6tables:Error retrieving getsockopt SO_GET_INFO:|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|ip6tables: Memory allocation for rules failed for size|ACL out of memory resource.|File a ticket with Cumulus Support.|
|ERROR|ip6tables: Error retrieving getsockopt SO_GET_ENTRIES:|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|iptables: Memory allocation for rules failed for size|ACL out of memory resource.|File a ticket with Cumulus Support.|
|ERROR|arptables:Could not open raw IPv6 socket.|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|arptables:Error retrieving getsockopt SO_GET_INFO: [str]|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|arptables: Error retrieving getsockopt SO_GET_ENTRIES: [str]|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|Inverse flags for SRC/DST MAC, IN/OUT/logical interface, Protocol not supported|ACL unsupported match.|See ACL documentation for supported matches.|
|ERROR|logical interface in:[str] out:[str] not supported|ACL unsupported match.|See ACL documentation for supported matches.|
|ERROR|Protocol field: LENGTH not supported|ACL unsupported LENGTH field match for Ethernet packets.|See ACL documentation for supported matches.|
|ERROR|Policy not supported|ACL unsupported ebtables action continue/return/etc.|See ACL documentation for supported actions.|
|ERROR|Target verdict: [str] not supported|ACL unsupported ebtables verdict.|See ACL documentation for supported actions.|
|ERROR|Fall through or Jump target not supported|ACL fall through/jump action not supported.|See ACL documentation for supported actions.|
|ERROR|Target verdict: [str] not supported|ACL target verdict queue/stop/return/etc not supported.|See ACL user documentation for supported targets.|
|ERROR|ebtables: Invalid argument|iptables rules likely empty or read from kernel failed.|Check ebtables rules list or file a ticket with Cumulus Support.|
|ERROR|ebtables:Could not open raw IPv4,socket.|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|ebtables:Error retrieving getsockopt SO_GET_INFO:|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|ebtables: Memory allocation for rules failed for size|ACL out of memory resource.|File a ticket with Cumulus Support.|
|ERROR|ebtables: Error retrieving getsockopt SO_GET_ENTRIES:|Internal socket error.|File a ticket with Cumulus Support.|
|ERROR|sfs_add: [str] failed|ACL: FUSE file system node creation failed.|File a ticket with Cumulus Support.|
|ERROR|MAX retries reached, stats sync acl failed - %d|ACL: Kernel updation of stats failed after retries.|File a ticket with Cumulus Support.|
|ERROR|sync_acl hardware installation failed|Hardware offload of ACL rule set failed, typically due to TCAM resource exhaustion and/or unsupported rules.|Check the ACL rule set/number of rules/user documentation.|
|ERROR|ACL: Restore of current table failed: sync_acl hardware installation failed|Hardware restore of previously installed ACL rule set failed.|File a ticket with Cumulus Support.|
|ERROR|kernel tunnel not found for if_key [str]|L2: Failed to lookup a tunnel interface.|Check configuration.|
|ERROR|[str] duplicate member [str] for bridge [int]|L2: Duplicate bridge in hash table.|File a ticket with Cumulus Support.|
|ERROR|tc: u32 ip: unknown match: handle: [hex] index:[int] off:[int] offmask:[hex] val:[hex] mask: [hex]|TC rule harware offload unsupported.|Remove TC rules.|
|ERROR|tc: u32 ip: match parse failed: handle: [hex], index:[int], rv: [int]|TC rule harware offload unsupported.|Remove TC rule.|
|ERROR|TC: [str]|TC rule harware offload unsupported.|Remove TC rule.|
|ERROR|TC: sync_clss hardware installation failed|TC rule harware offload unsupported.|Remove TC rule.|
|ERROR|IPRULE: sync to h/w failed in non atomic mode. IPRULE rules deleted. Please retry|Failed to install ACL rules.|Remove ACL rules and reinstall ACL rules.|
|ERROR|IPRULE: event handler failed|Failed to install ACL rules.|Remove ACL rules and reinstall ACL rules.|
|ERROR|TC: sync to h/w failed in non atomic mode. TC rules deleted. Please retry|Failed to install ACL rules.|Remove ACL rules and reinstall ACL rules.|
|ERROR|TC: event handler failed|Syncing database failed between kernel and switchd.|File a ticket with Cumulus Support.|
|ERROR|sigaction failed for signal [int], [str]|Failed to initialize signal handler.|File a ticket with Cumulus Support.|
|ERROR|Ignoring VRF [str]; table id 0 is reserved for default VRF|Failed to add a new entry in the ARP table.||
|ERROR|Unable to setup handling of SIGHUP for log rotation: [str]|Failed to create a polling thread in NIC init.|File a ticket with Cumulus Support.|
|ERROR|read error on fd errno [int]|Failed to attach a port in NIC.|File a ticket with Cumulus Support.|
|ERROR|[str] duplicate member [str] for bridge [int]|Failed to allocate a member in the kernel bridge.|Please check there are no duplicate bridge members.|
|ERROR|[str]: no context|Failed to append the CSV command in Prescriptive Topology Manager.|File a ticket with Cumulus Support.|
|ERROR|[str]: Could not append key|Failed to append CSV command in Prescriptive Topology Manager|File a ticket with Cumulus Support.|
|ERROR|[str]: Could not append val|Failed to append CSV command in Prescriptive Topology Manager|File a ticket with Cumulus Support.|
|ERROR|[str]: Could not allocate csv|Failed to initialize the CSV command in Prescriptive Topology Manager.|File a ticket with Cumulus Support.|
|ERROR|[str]: Could not allocate record|Failed to initialize the CSV command in Prescriptive Topology Manager.|File a ticket with Cumulus Support.|
|ERROR|[str]: Could not allocate context|Failed to initialize the CSV command in Prescriptive Topology Manager.|File a ticket with Cumulus Support.|
|ERROR|[str]: no context|Failed to complete the CSV command in Prescriptive Topology Manager.|File a ticket with Cumulus Support.|
|ERROR|[str]: cannot serialize|Failed to complete the CSV command in Prescriptive Topology Manager.|File a ticket with Cumulus Support.|
|ERROR|fatal recv error([str]), closing connection, rc [int]|Failed to complete the CSV command in Prescriptive Topology Manager.|File a ticket with Cumulus Support.|
|ERROR|Cannot allocate csv for msg|Failed to read the CSV command in Prescriptive Topology Manager.|File a ticket with Cumulus Support.|
|ERROR|[str]: Could not allocate context|Failed to decode the CSV command in Prescriptive Topology Manager.|File a ticket with Cumulus Support.|
|ERROR|STP mode_set failed for port [int]: [str]|Failed to set spanning tree mode in port [uint], error msg [str]. Forwarding behavior would be impacted by this failure.|File a ticket and contact Cumulus Support.|
|ERROR|failed to set port [int] vlan_ingress_filter enable|Failed to set VLAN ingress filter for port [uint], error msg [str].|File a ticket and contact Cumulus Support.|
|ERROR|failed to set FDB polling interval swid [uint]: [str]|Failed to set FDB polling interval for Mellanox SDK switchd id [int], error msg [str]. Failure to do this impacts MAC address learning behavior.|File a ticket and contact Cumulus Support.|
|ERROR|failed to set FDB notify_params swid [uint]: [str]|Failed to set FDB MAC address learning notification in Mellanox SDK for switch id [uint], error msg [str]. This error impacts the capability of the switch to learn MAC address.|File a ticket and contact Cumulus Support.|
|ERROR|failed to create trap group [uint] trap id [uint] swid [uint] group_attr.prio : [int] error: [str]|Failed to create the TRAP groups in the Mellanox SDK. Traps groups are used for policing trap IDs, which are used to punt control packets to OS stack. This failure impacts packet forwarding.|File a ticket and contact Cumulus Support.|
|ERROR|failed to open host ifc group [uint] trap id [uint] swid [uint] error [str]|Failed to retrieve the file descriptor of the current open channel to the Mellanox SDK, for ifc group [uint] trap ID [uit] swid [uint], error msg [str]. The error is not recoverable.|File a ticket and contact Cumulus Support.|
|ERROR|failed to obtain group [uint] FD for polling|Failed to retrieve the FD for a trap group [id]. The error is not recoverable.|File a ticket and contact Cumulus Support.|
|ERROR|failed to define trap [uint] group [uint] swid [uint] error: [str]|Failed to set trap ID [uint], trap group [uint], switch ID [uint], for user defined trap, error msg [str] .|File a ticket and contact Cumulus Support.|
|ERROR|failed to set trap [uint] group [uint] swid [uint] error: [str]|Failed to set trap ID [uint], trap group [uint], switch ID [uint], for user defined trap, error msg [str].|File a ticket and contact Cumulus Support.|
|ERROR|failed to register trap [uint] swid [uint] error: [str]|Failed to register trap ID [uint] in switch ID [uint] in Mellanox SDK, error msg [str].|File a ticket and contact Cumulus Support.|
|ERROR|trap_id [uint] was not installed|Trap ID [uint] was not installed in the Mellanox SDK. This would impact packet forwarding from the switch ASIC to the control plane.|File a ticket and contact Cumulus Support.|
|ERROR|trap_id [uint] was not installed|Trap ID [uint] was not installed in the Mellanox SDK. This would impact packet forwarding from the switch ASIC to the control plane.|File a ticket and contact Cumulus Support.|
|ERROR|dflt_trap_parsing_depth get failed: [str]|Failed to retrieve the Mellanox Spectrum chip parsing depth from Mellanox SDK, error msg [str]. Possibly the parsing depth has not been set correctly. This would impact hardware packet forwarding.|File a ticket and contact Cumulus Support.|
|ERROR|new_depth [uint] failed: [str]|Failed to set the packet parsing depth [uint] in Mellanox SDK, error msg [str]. This failure impacts hadrware packet forwarding.|File a ticket and contact Cumulus Support.|
|ERROR|failed to set trap [uint] group [uint] swid [uint] action [uint] error: [str]|Failed to set trap ID [uint], trap group [uint], switch ID [uint], trap action. Failure would lead to the respective control packet not reaching the CPU.|File a ticket and contact Cumulus Support.|
|ERROR|[str] failed to convert trap policer attributes|Failed to get the policer unit for policer group name [str]. Policer unit can be metered with unit of packets for bytes.|File a ticket and contact Cumulus Support.|
|ERROR|[str] failed to create policer: [str]|Failed to create policer for policer group [str], error msg [str]. Failure to set policer would impact packet forwarding from hadrware data path to CPU.|File a ticket and contact Cumulus Support.|
|ERROR|[str] sw_rate_limiter set failed: [str]|Failed to set the software rate limiter for policy group [str] in Mellanox SDK, error msg [str]. This failure could impact rate limiting for packets forwarded to CPU.|File a ticket and contact Cumulus Support.|
|ERROR|group [str] failed to edit policer: [str]|Failed to modify policer for policer group [str], error msg [str]. Failure to set policer would impact packet forwarding from hadrware data path to CPU.|File a ticket and contact Cumulus Support.|
|ERROR|unknown trap group [uint]|A trap group ID [uint] unknown to the Mellanox SDK is being used to configure the Mellanox SDK policer. This is an internal configuration error.|File a ticket and contact Cumulus Support.|
|ERROR|group [str] failed to bind policer %" PRIu64 ": [str]|Policer group [str] with policer ID [uint64] failed to bind in the Mellanox SDK, error msg [str]. This error would impact policing of packets being forwarded from hardware to CPU.|File a ticket and contact Cumulus Support.|
|ERROR|group [str] failed to unbind policer %" PRIu64 ": [str]|Policer group [str] with policer ID [uint64] failed to unbind in the Mellanox SDK, error msg [str]. This error would impact policing of packets being forwarded from hardware to CPU.|File a ticket and contact Cumulus Support.|
|ERROR|unsupported type [uint]|Failed to create a trap counter type as the trap counter type [uint] does not match one of the well-defined ones in the Mellanox SDK. This is an internal configuration error.|File a ticket and contact Cumulus Support.|
|ERROR|unsupported type [uint]|Failed to create a trap counter type as the trap counter type [uint] does not match one of the well-defined ones in Mellanox SDK. This is an internal configuration error.|File a ticket and contact Cumulus Support.|
|ERROR|type [uint] failed: [str]|Failed to retrieve the host IFC counter for the counter type [int] from the Mellanox SDK, error msg [str].|File a ticket and contact Cumulus Support.|
|ERROR|unknown meter_type [uint]|Incorrect policer unit [uint] used to find out the policer group meter unit. Policer unit can be metered with unit of packets for bytes. This is an internal error.|File a ticket and contact Cumulus Support.|
|ERROR|unrecognized lid [hex]|Failed to retrieve the interface key from logical port id [uint].|File a ticket and contact Cumulus Support.|
|ERROR|[str] unexpected duplicate key [uint]|Failed to add an interface [str] vport with internal VLAN ID [uint] in external VLAN vport hash table because of duplicate entry [uint].|File a ticket and contact Cumulus Support.|
|ERROR|[str] int_vid [uint] ext_vid [uint]: [str]|Failed to create a virtual port from logical port, interface [str], internal vlan id [uint] and external vlan id[uint], error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|Unexpected duplicate vport_lid [hex] for [str]|Failed to add vport logical interface id [uint], interface [str], in vlan vport hash table because of duplicate entry [uint]|File a ticket and contact Cumulus Support.|
|ERROR|delete failed for [str] int_vid [uint] ext_vid [uint]: [str]|Failed to delete a virtual port from logical port, interface [str], internal vlan id [uint] and external vlan id [uint], error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|[str] vrid not found for table [uint]|virtual router id not found in virtual id table [id] in software|File a ticket and contact Cumulus Support.|
|ERROR|delete failed for int_vid [uint] ext_vid [uint] vport_lid [hex] : [str]|Failed to delete a virtual port from logical port, internal vlan id [uint], virtual port logical if [uint] and external vlan id [uint], error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|[str] vrid not found for table [uint]|virtual router id not found in virtual id table [id] in software|File a ticket and contact Cumulus Support.|
|ERROR|port [int] ext_vlan [int] already exists|port [uint] and external vlan [uint] already exists in the e2i table|File a ticket and contact Cumulus Support.|
|ERROR|[str] int_vlan [int] already assigned to [str]|interface [str] with internal vlan [uint] is already assigned to interface [str] in the e2i table. This is an internal configration error|File a ticket and contact Cumulus Support.|
|ERROR|failed to get base bond for [str]|Failed to get the bond interface for interface [str]|File a ticket and contact Cumulus Support.|
|ERROR|failed to add to interface ht s[str]|Failed to add interface [str] to the ifp hash table because an entry already exists|File a ticket and contact Cumulus Support.|
|ERROR|[str] old_int_vlan [int] inconsistent|interface [str] with vlan [uint] is inconsistent in the e2i table|File a ticket and contact Cumulus Support.|
|ERROR|[str] new_int_vlan [int] already assigned to [str]|interface [str] with internal vlan [uint] is already assigned to interface [str] in the e2i table. This is an internal configration error|File a ticket and contact Cumulus Support.|
|ERROR|UC flood block [uint] failed for [str] vlan [uint]: [str]|unicast flood block [uint] failed for interface [str] for vlan id [uint], error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|learn mode [uint] failed for [str] vlan [uint]: [str]|learn mode [uint] failed for interface [str] and internal vlan [uint], error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|error processing bridge vlan information|error processing bridge vlan information|File a ticket and contact Cumulus Support.|
|ERROR|bond_mbrs_vlan_port_set failed for bond: [int]|failed to set vlan for bond members for bond id [uint]|File a ticket and contact Cumulus Support.|
|ERROR|unsupported interface type: [uint]|unsupported interface type [uint]|File a ticket and contact Cumulus Support.|
|ERROR|cannot find STG for bridge_vlan [uint] vid [uint]|cannot find the spanning tree group for bridge vlan [uint] and vlan id [uint]|File a ticket and contact Cumulus Support.|
|ERROR|flood_mode_set failed for swid [int] vid [int]|Flood mode could not be set for unregistered multicast in swid [uint] vlan id [uint]|File a ticket and contact Cumulus Support.|
|ERROR|vlans set failed for [str]: [str]|setting of vlan failed for interface [str], error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|qinq mode set failed for [str]: [str]|failed to set qinq mode for interface [str], error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|qinq mode set failed for [str]: [str]|failed to set qinq mode for bond for interface [str], error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|unsupported interface type: [uint]|unsupported interface type [uint]|File a ticket and contact Cumulus Support.|
|ERROR|bond id [uint] not fully created|bond id [uint] creation is not complete|File a ticket and contact Cumulus Support.|
|ERROR|cannot find bridge vlan for bridge: [int]|unable to find bridge vlan for the bridge id [uint]|File a ticket and contact Cumulus Support.|
|ERROR|cannot find bond vlan for bond|cannot find bond vlan for the bond|File a ticket and contact Cumulus Support.|
|ERROR|cannot allocate vlan for bond interface|Failed to allocate vlan for bond interface|File a ticket and contact Cumulus Support.|
|ERROR|cannot allocate vlan for sub-interface|Failed to allocate vlan for sub interface|File a ticket and contact Cumulus Support.|
|ERROR|gre tunnel decap entry creation failed : [str]|Failed to create decapsulation entry in Mellanox SDK. Decapsulation of GRE packet woould not be operational, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|gre tunnel decap destroy failed : [str]|Failed to delete the GRE decapsulation entry in Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|gre tunnel curr decap entry delete failed : [str]|Failed to delete the GRE decapsulation entry in Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|gre tunnel new decap entry update failed : [str]|Failed to create decapsulation entry in Mellanox SDK. Decapsulation of GRE packet woould not be operational, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|failed to make logical gre key|Failed to form the logical GRE key from the interface information provided|File a ticket and contact Cumulus Support.|
|ERROR|failed to make gre decap key|Failed to form the logical decap GRE key from the information provided|File a ticket and contact Cumulus Support.|
|ERROR|failed to make overlay key from underlay key|Failed to create overlay gre key from underlay information|File a ticket and contact Cumulus Support.|
|ERROR|unable to find gre entry for tunnel id ([hex]|Failed to find gre entry from tunnel id in the gre tunnel key hash table, using tunnel id [uint]|File a ticket and contact Cumulus Support.|
|ERROR|duplicate entry in overlay ht : ifindex ([int]|Unable to add a duplicate gre entry with ifindex [uint] in the gre overlay hash table. A duplicate config is being attempted|File a ticket and contact Cumulus Support.|
|ERROR|failed to create overlay rif : ifindex : [int] tunnel type [uint] key [uint]|Unable to create an overlay router interface with ifindex [uint] , tunnel type [uint] and tunel key [uint]|File a ticket and contact Cumulus Support.|
|ERROR|gre tunnel creation failed: [str] :|Failed to create tunnel id for GRE in Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|invalid argument|GRE update is being called with an invalid GRE information, no operation would be performed|File a ticket and contact Cumulus Support.|
|ERROR|gre tunnel ([hex]) update failed: [str] :|Failed to update tunnel id [hex] for GRE in Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|gre tunnel destroy failed: [str]|Failed to delete tunnel id for GRE in Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|loopback rif for ifindex ([int]) : [str]|Failed to add the loopback router interface, interface ifindex [uint] in Mellanox SDK, error [str]|File a ticket and contact Cumulus Support.|
|ERROR|ifindex ([int]) overlay rif ([int]) : [str]|Failed to delete the loopback router interface, interface ifindex [uint], overlay router interface [uint] in Mellanox SDK, error [str]|File a ticket and contact Cumulus Support.|
|ERROR|cannot allocate bridge vlan for bridge id [int]|Failed to allocate bridge vlan for bridge id [uint]|Check The Cumulus Linux Configuration guide|
|ERROR|flood_mode_set failed for swid [int] vid [int]|Flood mode could not be set for unregistered multicast in swid [uint] vlan id [uint]|File a ticket and contact Cumulus Support.|
|ERROR|cannot allocate ln_vlan [uint] for bridge_id [int]|Failed to allocate vlan [uint] for bridge id [uint]|Check The Cumulus Linux Configuration guide|
|ERROR|flood_mode_set failed for swid [int] vid [int]|Flood mode could not be set for unregistered multicast in swid [uint] vlan id [uint]|File a ticket and contact Cumulus Support.|
|ERROR|vlan [uint] not yet allocated|vlan [uint] does not exists for the bridge and is not allocated|Check The Cumulus Linux Configuration guide|
|ERROR|[str] bridge_id [uint] vlan [uint] port [hex] failed: [str]|failed to add a unicast mac address [str] on bridge id [uint] vlan [uint] port [uint]. This could be an internal error or could be because of configuration error|File a ticket and contact Cumulus Support.|
|ERROR|[str] bridge_id [uint] vlan [uint] port [hex] failed: [str]|failed to delete a unicast mac address [str] on bridge id [uint] vlan [uint] port [uint]. This could be an internal error or could be because of configuration error|File a ticket and contact Cumulus Support.|
|ERROR|num_macs [uint] num_failed_macs [uint] delete failed: [str]|failed to delete a number [uint] of unicast mac address, error msg [str]. This could be an internal error or could be because of configuration error|File a ticket and contact Cumulus Support.|
|ERROR|num_macs [uint] learn set failed: [str]|failed to add [uint] unicast mac addressess, error msg [str]. This could be because of resource exhaustion|File a ticket and contact Cumulus Support.|
|ERROR|num_macs [uint] delete failed: [str]|failed to delete a number [uint] of unicast mac address, error message [str]. This could be an internal error or could be because of configuration error|File a ticket and contact Cumulus Support.|
|ERROR|age_time set failed [str] on swid [uint]|Failed to set fdb ageing time. This would cause the mac addresses in FDB not to age mac address|File a ticket and contact Cumulus Support.|
|ERROR|cannot find vlan for brmac [str] vfid [uint]|vlan [uint] does not exists for the bridge and so could not find the vlan for bridge mac address|Check The Cumulus Linux Configuration guide|
|ERROR|vfid not set for vlan [uint]|failed to return a translated vlan id for vlan [uint]|File a ticket and contact Cumulus Support.|
|ERROR|num_macs [uint] delete failed: [str]|failed to delete a number [uint] of unicast mac address, error msg [str]. This could be an internal error or could be because of configuration error|File a ticket and contact Cumulus Support.|
|ERROR|bridge_vlan [uint] expected swid [uint] but found [uint]|bridge vlan id [uint] expected switchd id [uint] for the vlan is [uint] switch id|Check The Cumulus Linux Configuration guide|
|ERROR|num_macs [uint] delete failed: [str]|failed to delete a number [uint] of unicast mac address, error msg [str]. This could be an internal error or could be because of configuration error|File a ticket and contact Cumulus Support.|
|ERROR|bridge_vlan [uint] expected swid [uint] but found [uint]|bridge vlan id [uint] expected switchd id [uint] for the vlan is [uint] switch id|Check The Cumulus Linux Configuration guide|
|ERROR|get failed: [str]|Failed to get fdb unicast mac address from Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|num_macs [uint] delete failed: [str]|failed to delete a unicast mac address [str] on bridge id [uint] vlan [uint] port [uint]. This could be an internal error or could be because of configuration error|File a ticket and contact Cumulus Support.|
|ERROR|internal vlans exhausted|total number of internal vlan has exhausted. No morevlans could be addded|Check The Cumulus Linux Configuration guide|
|ERROR|identity map failed for vlan [uint]: [str]|Failed to map the forwarding id to the vlan id [uint] in Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|learn mode_failed for vlan [uint]: [str]|failed to set the learning mode for vlan id [uint], error message [str]|File a ticket and contact Cumulus Support.|
|ERROR|failed to get members for vlan [uint]: [str]|Failed to get member port for vlan [uint], error message [uint]|File a ticket and contact Cumulus Support.|
|ERROR|vlan [uint] is not an L3 vlan|vlan [uint] entry is not representing a l3 interface|Check The Cumulus Linux Configuration guide|
|ERROR|unsupported interface type: [uint]|unsupported interface type [uint]|File a ticket and contact Cumulus Support.|
|ERROR|[hex] int_vlan [uint] failed: [str]|failed to set the internal vlan [uint] for the logical port id [uint], error msg [str]|Check The Cumulus Linux Configuration guide|
|ERROR|[hex] pvid [uint] failed: [str]|failed to set the logical interface [uint] to van id [uint], error msg [str]|Check The Cumulus Linux Configuration guide|
|ERROR|[hex] int_vlan [uint] failed: [str]|failed to unset the internal vlan [uint] for the logical port id [uint], error msg [str]|Check The Cumulus Linux Configuration guide|
|ERROR|[hex] revert pvid: [str]|failed to delete the logical interface [uint] to vlan id [uint], error msg [str]|Check The Cumulus Linux Configuration guide|
|ERROR|unsupported interface type: [uint]|unsupported interface type [uint]|File a ticket and contact Cumulus Support.|
|ERROR|unsupported interface type: [uint]|unsupported interface type [uint]|File a ticket and contact Cumulus Support.|
|ERROR|failed for lid [hex] int_vlan [uint] STG [uint]: [str]|Failed to set the spanning tree group for logical interface [uint], internal vlan [uint] spanning tree group [uint], error msg [%s]|File a ticket and contact Cumulus Support.|
|ERROR|unsupported if_type [uint]|unsupported interface type [uint]|File a ticket and contact Cumulus Support.|
|ERROR|port [str] not established|port interface [str] has not been established yet|File a ticket and contact Cumulus Support.|
|ERROR|failed for [str] lid [hex]: [str]|Failed to set the port, logical id [uint], interface [str], to accept the frame type, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|list allocation failed|failed to allocate memory for the ports|File a ticket and contact Cumulus Support.|
|ERROR|STGs exhausted|Total number of spanning tree group has exhausetd. please consult configuration manual|Check The Cumulus Linux Configuration guide|
|ERROR|MSTP instance set failed for STG [int]: [str]|Failed to set the MSTP instance for the spanning tree group [uint] in Mellanox SDK, error msg [str]|Check The Cumulus Linux Configuration guide|
|ERROR|failed to delete STG [uint]: [str]|Failed to delete the MSTP instance for the spanning tree group [uint] in Mellanox SDK, error msg [str]|Check The Cumulus Linux Configuration guide|
|ERROR|failed to add vlan [int] to STG [int]: [str]|Failed to add vlan [uint] to spanning tree group [uint] in Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|failed to remove vlan [int] from STG [int]: [str]|Failed to delete vlan [uint] to spanning tree group [uint] in Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|vlan [uint] not yet created|vlan [uint] does not exist and is not allocated|Check The Cumulus Linux Configuration guide|
|ERROR|STG [int] not yet created|spanning tree group id [uint] is not created|File a ticket and contact Cumulus Support.|
|ERROR|Duplicate vfid [uint]|Failed to add virtual forwarding id [uint] in hash table because of a duplicate entry|File a ticket and contact Cumulus Support.|
|ERROR|fdb_uc_mac_addr_get failed: [str]|Failed to get fdb unicast mac address from Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|failed to allocate mac_list|Failed to allocate mac address list|Check The Cumulus Linux Configuration guide|
|ERROR|init set failed: [str]|Initilizition of router module in Mellanox SDK failed.|File a ticket and contact Cumulus Support.|
|ERROR|hash params set failed: [str]|Initilizition of router ecmp hash module in Mellanox SDK failed.|File a ticket and contact Cumulus Support.|
|ERROR|router #[uint] set failed: [str]|Initilizition of virtual router id [uint] failed, because of error [str] in Mellanox SDK.|Check The Cumulus Linux Configuration guide|
|ERROR|[str] failed cmd [str] vlan [uint] mac [str] fwd_state [str]: [str]|Routed interface description [str] failed to add/update/delete [str] with vlan [uint] mac [str] forwarding state [str]|Check The Cumulus Linux Configuration guide|
|ERROR|[str] cmd [str] failed for vlan [uint] mac [str]: [str]|Routed interface description [str] failed to add/update/delete [str] with vlan [uint] mac [str] error [str]|Check The Cumulus Linux Configuration guide|
|ERROR|failed for intf [uint]: [str]|Failed to get retrieve router interface id [uint], errorstr [str]|File a ticket and contact Cumulus Support.|
|ERROR|failed for vlan [uint] intf [uint]: [str]|Failed to delete interface for vlan [uint] interface id [uint] error [str]|File a ticket and contact Cumulus Support.|
|ERROR|neigh delete all failed for intf [uint]: [str]|Deletion of all the neighbor entries for the interface id [uint] error [str]|File a ticket and contact Cumulus Support.|
|ERROR|interface state set failed for l3_intf_id [uint]: [str]|Failed to set state for l3 interface id [uint] error [str]|File a ticket and contact Cumulus Support.|
|ERROR|invalid router mac [str]|check for a unicast mac address [str] failed|Check The Cumulus Linux Configuration guide|
|ERROR|failed for l3_intf_id [int] mac [str] vlan [uint]: [str]|Failed to add mac address [str] for interface id [uint] vlan [uint] error [str]|File a ticket and contact Cumulus Support.|
|ERROR|failed for l3_intf_id [int] mac [str] vlan [uint]: [str]|Failed to delete mac address [str] for interface id [uint] vlan [uint] error [str]|File a ticket and contact Cumulus Support.|
|ERROR|Invalid table id: must be between [int] and [int]|An Invalid vrf id is being tried to program, vrf id should be in range of vrf id [uint] - [uint]|File a ticket and contact Cumulus Support.|
|ERROR|calloc failed to allocate a new ECMP entry|Failed to allocate a new entry for ECMP|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate SDK ecmp id [uint]<span></span> (HAL ECMP id [int]|Failed to add an ECMP entry id [uint] in hash table because of duplicate ECMP ID [uint]|File a ticket and contact Cumulus Support.|
|ERROR|unable to reconstruct original route [str]|Failed to construct a route [str] from a hardware entry to a hardware abstraction layer entry entry, for the purpose of updating the existing entry|File a ticket and contact Cumulus Support.|
|ERROR|unable to obtain HW info for original route [str]|Failed to retrieve a route [str] from the hardware, for the purpose of updating the existing entry|File a ticket and contact Cumulus Support.|
|ERROR|activity get failed: [str]|Failed to check the neighbor activity information, error [str]|File a ticket and contact Cumulus Support.|
|ERROR|route [str] not found in hal_routes|Failed to find the route [str] in software|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate l3_intf_id [uint]|Found duplicate l3 interface id [uint] in software|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate RIF param [uint]|Found duplicate l3 interface id [uint] parameters in software|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate l3_intf_id [uint] vlan [uint]|Found duplicate l3 interface id [uint] having vlan [uint] in software|File a ticket and contact Cumulus Support.|
|ERROR|failed for vlan [uint] l3_intf_id [uint]: [str]|Failed to delete the router interface, vlan [uint] interface if [uint] in Mellanox SDK, error [str]|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate entry|Failed to add the router interface because of duplicate entry|File a ticket and contact Cumulus Support.|
|ERROR|vlan not found for l3_intf_id [uint]|Failed retrieve l3 interface [uint] param|File a ticket and contact Cumulus Support.|
|ERROR|[str] vlan [uint] does not exist for bridge_id [int]|vlan [uint] does not exists for the bridge id [uint]|Check The Cumulus Linux Configuration guide|
|ERROR|[str] no bridge exists for bridge_id [int]|bridge id [uint] does not exists in the software database|Check The Cumulus Linux Configuration guide|
|ERROR|[str] cannot allocate vlan [uint] for bridge_id [int]|failed to allocate bridge id [uint] for vlan id [uint] in mellaox SDK.|File a ticket and contact Cumulus Support.|
|ERROR|interface [str] not an svi|Interface [str] type is expected to be SVI, but it is not SVI|File a ticket and contact Cumulus Support.|
|ERROR|[str] vrid not found for table [uint]|virtual router id not found in virtual id table [id] in software|File a ticket and contact Cumulus Support.|
|ERROR|invalid interface: [str]|An interface check has found that the .|File a ticket and contact Cumulus Support.|
|ERROR|[str] vrid not found for table [uint]|virtual router id not found in virtual id table [id] in software|File a ticket and contact Cumulus Support.|
|ERROR|neighbor set failed for netdev_rif [uint]: [str]|Setting up of a neighbor failed on the netdev router interface [uint]|File a ticket and contact Cumulus Support.|
|ERROR|neighbor delete failed: [str]|Deletion of the neighbor entry failed, error [str]|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate:|Addition of the interface to the software table failed because of an already existing interface|File a ticket and contact Cumulus Support.|
|ERROR|Failed to get vrid for table [uint]|virtual router id not found in virtual id table [id] in software|File a ticket and contact Cumulus Support.|
|ERROR|Failed to get vrid for table [uint]|virtual router id not found in virtual id table [id] in software|File a ticket and contact Cumulus Support.|
|ERROR|route_op [uint] neighbor route must have a valid netdev:|route operation to add/del [uint] failed as the route does not have a valid next hop net device|File a ticket and contact Cumulus Support.|
|ERROR|cannot find vlan_if for next hop [str]|vlan interface [str] could not be found for the next hop, as the next hop programming is being done on a vlan interface|File a ticket and contact Cumulus Support.|
|ERROR|cannot find parent bond info|Failed to retrieve the master bond interface descriptor for port id [uint] and vlan id [uint]|File a ticket and contact Cumulus Support.|
|ERROR|no RIF found for [str]|Router interface [str] not found for neighbor|File a ticket and contact Cumulus Support.|
|ERROR|unexpected rif type [str]|A router interface type [str] found and it is an invalid type of router interface|File a ticket and contact Cumulus Support.|
|ERROR|neigh_get vrid [uint] failed: [str]|Failed to retrieve the neighbor from the virtual router id [uint]|File a ticket and contact Cumulus Support.|
|ERROR|failed to allocate neigh_entry_list|Failed to allocate memory for a list of neighbors|File a ticket and contact Cumulus Support.|
|ERROR|route cmd [str] failed for vrid [int]: [str]|Failed operation [str] on a unicast route on vrid [uint]|File a ticket and contact Cumulus Support.|
|ERROR|for [str]|Failed to set a unicast route [str] in Mellanox SDK.|File a ticket and contact Cumulus Support.|
|ERROR|route delete failed for [str]: [str]|Failed to delete route in route [str] in the Mellanox SDK, error msg [str]|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate:|Found duplicate route in software|File a ticket and contact Cumulus Support.|
|ERROR|unknown route type [uint]|Route inspected is an unknown route type [uint], unsupported by Mellanox SDK.|File a ticket and contact Cumulus Support.|
|ERROR|ECMP SDK id [uint] not found|ECMP id [uint] for the route not found in the Mellanox SDK.|File a ticket and contact Cumulus Support.|
|ERROR|Failed to get vrid for table [uint]|virtual router id not found in virtual id table [id] in software.|File a ticket and contact Cumulus Support.|
|ERROR|too many next hops [int] for hal_route [str]|number of next hop [uint] exceeded the max limit for the route [str].|File a ticket and contact Cumulus Support.|
|ERROR|Cannot allocate an ECMP key|Failed to allocate an ECMP key to program a new route.|File a ticket and contact Cumulus Support.|
|ERROR|Failed to get vrid for table [uint]|virtual router id not found in virtual id table [id] in software.|File a ticket and contact Cumulus Support.|
|ERROR|unknown route type [uint]|Route inspected is an unknown route type [uint], unsupported by Mellanox SDK.|File a ticket and contact Cumulus Support.|
|ERROR|route get failed for prefix_type [uint]: [str]|Failed to retrieve a unicast route from Mellanox SDK, error reason [str].|File a ticket and contact Cumulus Support.|
|ERROR|Failed to get table_id for vrid [uint]|Failed to retrieve vritual router table id for virtual router id [uint].|File a ticket and contact Cumulus Support.|
|ERROR|sx_api_router_uc_route_get_all failed: [str]|Failed to retrieve a unicast route from Mellanox SDK, error reason [str].|File a ticket and contact Cumulus Support.|
|ERROR|failed to allocate uc_route_entry_list|Failed to allocate a list for unicast route entries.|File a ticket and contact Cumulus Support.|
|ERROR|ECMP hal_route_to_hw_ecmp_key failed|Failed to retrieve a ecmp key for a route from Mellanox SDK.|File a ticket and contact Cumulus Support.|
|ERROR|unable to find gre entry for tunnel|Failed to find a GRE tunnel entry.|File a ticket and contact Cumulus Support.|
|ERROR|unable to make logical gre key from if_key|Failed to create a logical GRE key from the interface key.|File a ticket and contact Cumulus Support.|
|ERROR|ECMP route contains one or more unresolvable nexthops|ECMP route has one or more unresolved next hop. So programming for the route is not performed.|File a ticket and contact Cumulus Support.|
|ERROR|ecmp: can't hold the ECMP entry|ECMP container NULL or invalid, so route entry programming would not be performed.|File a ticket and contact Cumulus Support.|
|ERROR|onlink host route key setup failed|Failed to create onlink host route key.|File a ticket and contact Cumulus Support.|
|ERROR|onlink host route creation failed|Failed to create onlink host route.|File a ticket and contact Cumulus Support.|
|ERROR|sx_api_router_ecmp_clone_set failed on parent SDK ECMP ID [int]: [str]|Failed to clone ecmp route to the parent ecmp|File a ticket and contact Cumulus Support.|
|ERROR|ecmp: empty ECMP container add failed: [str]|Failed to create a new and empty ecmp container with attriuts in Mellanox SDK, status msg [str].|File a ticket and contact Cumulus Support.|
|ERROR|ecmp: ECMP [str] failed: [str] num_next_hops is [int].|Failed to (create/update) operation [str], an ecmp container, status msg [str], with number of nexthops [uint].|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate ECMP key|Failed to add an ECMP key in ecmp key hash table, as a duplicate entry already exists.|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate ECMP SDK id [uint]|Failed to add an ECMP id in ecmp id hash table, as a duplicate entry already exists.|File a ticket and contact Cumulus Support.|
|ERROR|ecmp_id [uint] delete failed: [str]|Failed to delete a ecmp entry, ecmp id [uint], status msg [str].|File a ticket and contact Cumulus Support.|
|ERROR|onlink host route key setup failed.|Failed to create onlink host route key|File a ticket and contact Cumulus Support.|
|ERROR|ecmp pbr refcount: can't hold the ECMP sdkid: [int] entry.|ecmp entry not found in the software while programming entries for PBR.|File a ticket and contact Cumulus Support.|
|ERROR|ecmp pbr refcount: can't put the ECMP sdkid: [int] entry.|ecmp entry not found in the software while programming entries for PBR.|File a ticket and contact Cumulus Support.|
|ERROR|SDK ecmp_id [uint] failed: [str]|Failed to set ecmp attributes with ecmp id [uint] in Mellanox SDK, error mesg [str].|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate ECMP clone ID key|Failed to add an ECMP clone id in, clone id hash table, as a duplicate entry already exists.|File a ticket and contact Cumulus Support.|
|ERROR|onlink host route not suppported on non-Spectrum backend|Onlink host route not supported on non-spectrum backend.|File a ticket and contact Cumulus Support.|
|ERROR|onlink host route not suppported on non-Spectrum backend|Onlink host route not supported on non-spectrum backend.|File a ticket and contact Cumulus Support.|
|ERROR|unexpected duplicate:|Failed to add an ECMP entry in hash table because a duplicate entry already exists.|File a ticket and contact Cumulus Support.|
|ERROR|cannot find vlan_if for next hop [str]|vlan interface [str] could not be found for the next hop, as the next hop programming is being done on a vlan interface.|File a ticket and contact Cumulus Support.|
|ERROR|invalid rif for [str]|An interface check found that routed interface [str] is invalid.|File a ticket and contact Cumulus Support.|
|ERROR|hal_clag_set_port_egress_mask failed in backend[[int]] for|Failed to install egress mask on MLAG port.|File a ticket with Cumulus Support.|
|ERROR|hal_clag_set_ln_egress_mask failed in backend[[int]] for|Failed to install egress mask on VXLAN device.|File a ticket with Cumulus Support.|
|ERROR|ln_key [int] anycast_ip not set|MLAG anycast IP is not set.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_tc_prio_map_get hal port [int] returned [str]|ASIC egress queue map configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_tc_prio_map_set logical port 0x%x returned [str]|ASIC egress queue map configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|hal_mlx_priority_source_trust_get HAL port [int] logical port 0x%x returned [str]|ASIC priority source trust configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|hal_mlx_priority_source_trust_set HAL port [int] logical port 0x%x returned [str]|ASIC priority source trust configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|hal_mlx_rewrite_enable_get HAL port [int] logical port 0x%x returned [str]|ASIC priority rewrite enable configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|hal_mlx_rewrite_enable_set HAL port [int] logical port 0x%x returned [str]|ASIC priority rewrite enable configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_tc_mcaware_get hal port [int] returned [str]|ASIC MC buffer configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_tc_mcaware_set hal port [int] returned [str]|ASIC MC buffer configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_tc_prio_map_set hal port [int] returned [str]|ASIC egress queue map configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|buffer pool [int] size 0 is invalid: this pool was not created|Invalid buffer pool size.|Check back end QoS configuration file.|
|WARNING|Pool configuration mode [int] not recognized: defaulting to buffer units|Invalid parameter.|Check back end QoS configuration file.|
|WARNING|sx_api_cos_shared_buff_pool_set for sw pool id [int] to size [int]<span></span> (mode [int]) failed: [str],|ASIC buffer pool configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|Hardware buffer pool index [int] too large (max is [int])|Too many buffer pools for ASIC limit.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_prio_buff_map_get failed for MLX port [int]: [str]|Priority group buffer map read failed.|File a ticket with Cumulus Support.|
|WARNING|switch priority [int] greater than max value [int]|Invalid switch priority.|Check QoS configuration file.|
|WARNING|sx_api_cos_port_prio_buff_map_set failed for MLX port [int]: [str]|ASIC packet buffer configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|reserved buffer type [int] not recognized|Invalid buffer type.|File a ticket with Cumulus Support.|
|WARNING|cos ID [int] larger than maximum switch priority value [int]|Invalid internal switch priority value.|File a ticket with Cumulus Support.|
|WARNING|profile element index [int] too large for array size [int]: [int] map entries, priority field [int]|Priority profle index is too large for the array.|File a ticket with Cumulus Support.|
|WARNING|[str] failed for MLX port 0x%x, buffer count [int]: [str]|ASIC packet buffer configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_shared_buff_pool_get failed, cannot get pool size or mode : [str]|ASIC buffer pool configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|pool [int] mode [int] not recognized|Invalid buffer pool mode.|File a ticket with Cumulus Support.|
|WARNING|MLX logical port 0x%x: cos ID [int] larger than maximum switch priority value [int]|Invalid switch priority value.|File a ticket with Cumulus Support.|
|WARNING|unlimited egress buffer for flow controlled switch priority [int]: unicast config may not match multicast config on some ports|Possible buffer configuration conflict.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_shared_buff_pool_get failed, cannot report pool configurations: [str]|ASIC buffer pool configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_pools_list_get, pool count == 0, failed: [str]|Buffer pool configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_pools_list_get, pool count == [uint] failed: [str]|Buffer pool configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|_pool_buffer_list_get failed: [str]|Buffer pool configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_shared_buff_pool_get failed, cannot report pool configurations: [str]|ASIC packet buffer configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_pcpdei_to_prio_get port [int]<span></span> (0x%x) returned [str]|ASIC L2 priority source map get operation failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_buff_type_set failed for HAL port [int]/MLX port [int]: [str]|ASIC packet buffer configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_shared_buff_type_set failed for HAL port [int]/MLX port [int]: [str]|ASIC packet buffer configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_pcpdei_to_prio_set port [int] logical port 0x%x returned [str]|ASIC L2 priority source map set operation failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_dscp_to_prio_get port [int]<span></span> (0x%x) returned [str]|ASIC L3 priority source map get operation failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_dscp_to_prio_set port [int] returned [str]|ASIC L3 priority source map set operation failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_prio_to_pcpdei_rewrite_set hal port [int] element count [int]: returned [str]|ASIC L2 priority remark map set operation failed.|File a ticket with Cumulus Support.|
|WARNING|switch priority [int] color [int] pcp [int] deci [int]|failed L2 priority remark map.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_prio_to_dscp_rewrite_set hal port [int] logical_port [int] element count [int]: returned [str]|ASIC L3 priority remark map set operation failed.|File a ticket with Cumulus Support.|
|WARNING|switch priority [int] color [int] dscp [int]|failed L3 priority remark map.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_ets_element_get logical port 0x%x returned [str]|ASIC scheduler configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_ets_element_set (destroy) logical port 0x%x returned [str]|ASIC scheduler configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_ets_element_get hal port [int] returned [str]|ASIC scheduler configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_ets_element_set logical port 0x%x level [int] index [int] returned [str]|ASIC scheduler configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_ets_element_get hal port [int] returned [str]|ASIC scheduler configuration read failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_ets_element_set (destroy) hal port [int] returned [str]|ASIC scheduler configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_port_ets_element_set hal port [int] level [int] index [int] returned [str]|ASIC scheduler configuration write failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_port_pfc_enable_set hal port [int] returned [str]|ASIC priority flow control configuration failed.|File a ticket with Cumulus Support.|
|WARNING|switch priority [int] is not supported for MLX unit|Internal switch priority not supported.|Check QoS configuration file.|
|WARNING|sx_api_cos_redecn_general_param_get returned [str]|ASIC ECN configuration failed.|File a ticket with Cumulus Support.|
|WARNING|hal_mlx_ecn_red_set HAL port [int] min_threshold_bytes [int] is less than minimum size, using [int] bytes|invalid parameter.|Check QoS configuration file.|
|WARNING|hal_mlx_ecn_red_set HAL port [int] max_threshold_bytes [int] is greater than maximum size, using [int] bytes|invalid parameter.|Check QoS configuration file.|
|WARNING|sx_api_cos_redecn_profile_set returned [str]|ASIC ECN configuration failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_redecn_tc_enable_set returned [str]|ASIC ECN configuration failed.|File a ticket with Cumulus Support.|
|WARNING|sx_api_cos_redecn_profle_tc_bind_set for hal port [int] flow type [int] returned [str]|ASIC ECN configuration failed.|File a ticket with Cumulus Support.|
|WARNING|hal_sh_datapath_file_read: egress port MC buffer percent [perc] reduced to 100.0|Invalid egress port MC buffer value.|Check back end QoS configuration file.|
|WARNING|priority group PG ID [int] is larger than the PG ID mask size [int]|Invalid priority group ID value configured.|Check back end QoS configuration file.|
|WARNING|No priority group ID found for lossless traffic|No priority group ID found for lossless traffic.|File a ticket with Cumulus Support.|
|WARNING|_queue_info_set: port_q_count_get failed for hal port [int]|Could not find port queue limits.|File a ticket with Cumulus Support.|
|WARNING|hal_sh_datapath_packet_buffer_set: [str]|Back end packet buffer config failed.|Check for detailed log messages.|
|WARNING|unable to set FEC parameters while autoneg is enabled|Invalid operation for the current port configuration.|Disable auto-negotiation on the port.|
|WARNING|ethtool settings nwords too large: [int]|Invalid parameter: using default.|File a ticket with Cumulus Support.|
|WARNING|_port_group_priority_map_get: arg is NULL|Invalid parameter.|File a ticket with Cumulus Support.|
|WARNING|_port_group_config_values_get: _port_group_find failed on [str] [str]|Port group not found or created.|File a ticket with Cumulus Support.|
|WARNING|_port_group_set_get: [str] port set not found|Port group port set not found.|Check QoS configuration file.|
|WARNING|_port_pause_config: config_port_pause failed: [str]|ASIC port pause configuration failed.|File a ticket with Cumulus Support.|
|WARNING|_priority_flow_control_config: hal_port_pfc_set failed on hal port [int]: [str]|ASIC priority flow control configuration failed.|File a ticket with Cumulus Support.|
|WARNING|_config_port_packet_buffers: [str]|ASIC packet buffer config failed.|File a ticket with Cumulus Support.|
|WARNING|_switch_priority_config: hal port [int]: [str]|_switch_priority_config: hal port [int]: [str]|File a ticket with Cumulus Support.|
|WARNING|_config_port_packet_buffers: [str]|ASIC packet buffer config failed.|File a ticket with Cumulus Support.|
|WARNING|_priority_map_config: priority map direction [int] is larger then max value HAL_DATAPATH_PRIORITY_DIRECTION_MAX|Invalid parameter.|File a ticket with Cumulus Support.|
|WARNING|_priority_map_config: packet priority field [int] not supported|Invalid packet priority field(s).|Check QoS configuration file.|
|WARNING|_hash_config: route_ecmp_max_paths_set failed: [str]|ASIC ECMP configuration failed.|File a ticket with Cumulus Support.|
|WARNING|_hash_config: hash config failed: [str]|ASIC symmetric hash configuration failed.|File a ticket with Cumulus Support.|
|WARNING|_hash_config: ecmp hash seed config faild: [str]|ASIC ECMP hash configuration failed.|File a ticket with Cumulus Support.|
|WARNING|_hash_config: hash config failed: [str]|ASIC resilient hash configuration failed.|File a ticket with Cumulus Support.|
|WARNING|_mpls_config: mpls enable config failed: [str]|ASIC MPLS configuration failed.|File a ticket with Cumulus Support.|
|WARNING|_ecn_red_config: hal_datapath_ecn_red_set failed on hal port [int]: [str]|ASIC ECN/RED configuration failed.|File a ticket with Cumulus Support.|
|WARNING|_port_attribute_mark: flow control configuration conflict on hal port [int]:|Flow control configuration conflict.|Check QoS configuration file.|
|WARNING|hal_datapath_forwarding_profile_get: forwarding table profile path was NULL|Memory allocation failed.|File a ticket with Cumulus Support.|
|WARNING|hal_datapath_forwarding_profile_get: sfs_config_get failed for [str]|Missing forwarding table profile configuration.|Check QoS configuration file.|
|WARNING|hal_datapath_init: packet priority source mapping configuration failed|Packet priority source map configuration failed.|Check for detailed log messages.|
|WARNING|hal_datapath_init: packet priority remark configuration failed|Packet priority remark map configuration failed.|Check for detailed log messages.|
|WARNING|_config_value_read: sfs path is null|Invalid parameter.|File a ticket with Cumulus Support.|
|WARNING|_config_value_read: sfs_config_get [str] failed|Configuration parameter not found.|File a ticket with Cumulus Support.|
|WARNING|_config_value_read: sfs_config_get [str] returned NULL configuration|Configuration value not found.|File a ticket with Cumulus Support.|
|WARNING|_cos_show_node_create: sfs_add failed for CoS node|switchd fuse node create failed.|File a ticket with Cumulus Support.|
|WARNING|_priority_map_get: remark list has more than one packet priority value: configuring the first value|Ignoring surplus remark values.|Check QoS configuration file.|
|WARNING|_priority_map_list_get: [str]|ASIC priority profile create failed.|File a ticket with Cumulus Support.|
|WARNING|_switch_priority_config_values_get: scheduling algorithm [str] not recognized|Invalid scheduling algorithm.|Check QoS configuration file.|
|WARNING|hal_list_get: list type [int] is not supported|Invalid list type.|File a ticket with Cumulus Support.|
|WARNING|Couldn't read a random number [int] setting seed to [uint]|No ECMP hash seed found in file.|Check file or accept default random seed.|
|WARNING|Couldn't read a random number [int] setting seed1 to [uint]|No ECMP hash seed1 found in file.|Check file or accept default random seed.|
|WARNING|Neighbor entry is not IPv4 or v6: [int]!|Netlink neighbor object has invalid family.|File a ticket with Cumulus Support.|
|WARNING|Neighbor entry had unexpected flags [int]|Netlink neighbor object has unsupported flags.|File a ticket with Cumulus Support.|
|WARNING|[str]: route table mode [int] not supported|Invalid route table ASIC mode.|File a ticket with Cumulus Support.|
|WARNING|[str]: host table mode [int] not supported|Invalid neighbor table ASIC mode.|File a ticket with Cumulus Support.|
|WARNING|Route [[str]] is not IPv4 or v6 or MPLS, family: [int]|Netlink route object has invalid family.|File a ticket with Cumulus Support.|
|WARNING|Route [[str]] has unexpected flags: [int]|Netlink route object has unsupported flags.|File a ticket with Cumulus Support.|
|WARNING|Route [[str]] has unexpected type: [int]|Netlink route object has unsupported type.|File a ticket with Cumulus Support.|
|WARNING|Route [[str]] has unexpected tos: [int]|Netlink route object has unsupported TOS value.|File a ticket with Cumulus Support.|
|WARNING|Route [[str]] has non-NULL src.|Netlink route object has non-NULL source.|File a ticket with Cumulus Support.|
|WARNING|Route [[str]] has non-zero iif: [int]|Netlink route object has non-NULL interface.|File a ticket with Cumulus Support.|
|WARNING|[int] routes exceeded [int] ecmp NHs, and were truncated.|Routes exceeded per-route nexthop limit.|Modify route next-hop configuration.|
|WARNING|[int] routes reverted to non-ECMP due to NH table|Total number of nexthops did not fit in hardware table.|Modify route next-hop configuration.|
|WARNING|[str]: route table mode [int] not supported|Hardware route table is set to an incorrect mode.|File a ticket with Cumulus Support.|
|WARNING|[str]: host table mode [int] not supported|Hardware host table is set to an incorrect mode.|File a ticket with Cumulus Support.|
|WARNING|vpn_id 0x%x for ln_type [uint] ln_key [uint] tunnel_id 0x%x invalid local_ip [str]|Local IP for a tunnel is invalid.|File a ticket with Cumulus Support.|
|WARNING|Error removing isolated port [int] from [int]. Error: [str]|Removing isolated VPN port from the SDK failed.|File a ticket with Cumulus Support.|
|WARNING|Error adding isolated port [int] to [int]. Error: [str]|Adding isolated VPN port to the SDK failed.|File a ticket with Cumulus Support.|
|WARNING|Error removing isolated port [int] from [int].|Moving isolated VPN port from the SDK failed.|File a ticket with Cumulus Support.|
|WARNING|[str]: failed to push port settings to hal. err = [int]|table_id could not be set for a port.|File a ticket with Cumulus Support.|
|WARNING|[str] not found in grp [str], bridge [int]|A port not found in the given group for the specific bridge.|File a ticket with Cumulus Support.|
|WARNING|grp [str] not found in bridge [int]|During deletion, an MDB group was not found for a specific bridge.|File a ticket with Cumulus Support.|
|WARNING|lid 0x%x cannot be both SPAN source|ACL: SPAN source and target cannot be the same.|Remove the rule.|
|WARNING|CPU not supported as mirror port|ACL: Mirror target port cannot be CPU.|Remove these SPAN rules.|
|WARNING|table [str] [str] chain [str] L2 header field match not supported with IPv6 key|ACL: Specified match unsupported.|Remove the rule.|
|WARNING|table [str] [str] chain [str] IP TTL not supported with MAC+IPv4 key|ACL: Unsupported match.|Remove the rule.|
|WARNING|table [str] [str] chain [str] requires hardware IPv6 rule format but platform does not support MAC+IPv6 key combination|ACL: Unsupported match.|Remove the rule.|
|WARNING|table [str] [str] chain [str] requires hardware IPv4 rule but platform does not support IPv4 key with|ACL: Unsupported match.|Remove the rule.|
|WARNING|logical network type not supported|ACL: Unsupported interface type in internal VXLAN rules.|File a ticket with Cumulus Support.|
|WARNING|Detected excessive moves of mac address [str] on bridge [str], last seen on [str] and [str].|L2: Too many MAC moves seen.|Check network topology for loops or intrusion.|
|WARNING|Memory allocation failed|Memory exhausted.|File a ticket with Cumulus Support.|
|WARNING|Can't open configuration file [str]: [int]|Failed to read configuration file in SFS.|File a ticket with Cumulus Support.|
|WARNING|tx failed with count [int], start %p|Failed to transfer packets in NIC.|File a ticket with Cumulus Support.|
|WARNING|Detected excessive moves of mac address [str] on bridge [str],|Moved MAC addresses over threshold.||
|WARNING|Unsupported command [str]|Wrong FEC command.|File a ticket with Cumulus Support.|
|WARNING|genl_talk returned error for ifindex [int]<span></span> ([str])|Failed to read cached settings in PORT.|File a ticket with Cumulus Support.|
|WARNING|new tag_state [str] mismatches with [str] for [str] int_vlan [uint]|The new configured tag state [str] mismatches with the old tag state [str] for the internal VLAN [id].|File a ticket and contact Cumulus Support.|
|WARNING|verbosity level for SDK module [uint] not present|incorrect verbosity level for the Mellanox SDK module is being configured. This is an internal error. |File a ticket and contact Cumulus Support.|
|WARNING|legacy SX2 nexthop route type [uint] not handled. |for Legacy Mellanox SX2 chip, next hop of route type [uint] not handled. |File a ticket and contact Cumulus Support.|
|WARNING|hash_table_delete of clone parent from id_ht %p failed. |Failed to delete an ECMP clone id in, clone id hash table, as a entry does not exists. |File a ticket and contact Cumulus Support.|
|WARNING|[str]: no parent for [str]|Missing parent interface. |File a ticket with Cumulus Support.|
|WARNING|[str]: no parent for [str]|Missing parent interface. |File a ticket with Cumulus Support.|
<!-- vale on -->