---
title: Campus Deployments
author: NVIDIA
weight: 1300
toc: 3
---

Cumulus Linux includes a number of features that you can use to deploy in a campus setting. These features include:

- {{<link url="802.1X-Interfaces">}}
- {{<link url="Inter-subnet-Routing">}}
- {{<link url="Power-over-Ethernet-PoE" text="Power over Ethernet">}}
- {{<link url="TDR-Cable-Diagnostics" text="TDR - time domain reflectometer">}}
- {{<link url="Voice-VLAN">}}

These features work in conjunction with the following core Cumulus Linux functionality to provide a complete campus deployment:

- Automation/{{<link url="Zero-Touch-Provisioning-ZTP" text="zero touch provisioning">}}
- {{<link url="Switch-Port-Attributes#port-speed-and-duplex-mode" text="Half duplex mode">}}
- {{<link url="Layer-2">}}, including {{<link url="Link-Layer-Discovery-Protocol" text="LLDP">}} and {{<link url="Multi-Chassis-Link-Aggregation-MLAG" text="MLAG">}}
- {{<link url="Layer-3">}}, including {{<link url="Open-Shortest-Path-First-OSPF" text="OSPF">}} and {{<link url="Border-Gateway-Protocol-BGP" text="BGP">}}
- {{<link url="Buffer-and-Queue-Management" text="QoS">}}

## Related Information

For a deep dive into campus architecture, read the {{<exlink url="https://docs.cumulusnetworks.com/guides/campus-architecture-guide/" text="campus architecture solution guide">}}.
