---
title: Cumulus Linux 4.3 Release Notes
author: NVIDIA
weight: -30
product: Cumulus Linux
version: "4.3"
toc: 1
type: rn
pdfhidden: True
---
<a href="/cumulus-linux-43/rn.xls"> {{<rn_icon alt="Download 4.3 Release Notes xls" >}}</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="/cumulus-linux-43/rn.xls">Download all 4.3 release notes as .xls</a>
## 4.3.0 Release Notes
### Open issues in 4.3.0

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-33167"></a> [CM-33167](#CM-33167) <a name="CM-33167"></a> <br /> | On the Mellanox SN4700 switch, if you use the CREDO CABLE with a 4x100 configuration, the system experiences issues accessing the ASIC Thermal sensors. | 4.3.0 | |
| <a name="CM-32055"></a> [CM-32055](#CM-32055) <a name="CM-32055"></a> <br /> | During a graceful restart of a peer router, if the link between the local system (Helper) and the restarting router flaps, the stale routes announced by the restarting router are no longer used for forwarding by the Helper router even though they remain in the BGP RIB. | 4.3.0 | |
| <a name="CM-28249"></a> [CM-28249](#CM-28249) <a name="CM-28249"></a> <br /> | On the Mellanox switch, when you modify the buffer and queue configuration without restarting `switchd`, you might see a one second interruption in forwarding. | 4.0.0-4.3.0 | |
| <a name="CM-28080"></a> [CM-28080](#CM-28080) <a name="CM-28080"></a> <br /> | TACACS+ through ClearPass is not currently supported. Cumulus Linux sends authorization before authentication, but ClearPass does not accept an authorization before the user is authenticated. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> <br /> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty: <br /><br /><pre> <br />cumulus&#64;switch:~$ netq show sensors temp changes \| grep absent \| grep -v psu <br />P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s <br />P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s <br />P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s <br /></pre></div></div> <br />This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> <br /> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2578872"></a> [2578872](#2578872) <a name="2578872"></a> <br /> | CVE-2021-20270: It was discovered that Pygments, a syntax highlighting package written in Python, could be forced into an infinite loop, resulting in denial of service<br />Vulnerable: 2.3.1+dfsg-1Fixed: 2.3.1+dfsg-1+deb10u1 | 4.0.0-4.3.0 | |
| <a name="2578870"></a> [2578870](#2578870) <a name="2578870"></a> <br /> | CVE-2020-35523 CVE-2020-35524: Two vulnerabilities have been discovered in the libtiff library and the included tools, which may result in denial of service or the execution of arbitrary code if malformed image files are processed<br />Vulnerable: <= 4.1.0+git191117-2~deb10u1Fixed: 4.1.0+git191117-2~deb10u2 | 4.0.0-4.3.0 | |
| <a name="2574368"></a> [2574368](#2574368) <a name="2574368"></a> <br /> | When you run the NCLU <code>net add bgp maximum-paths ibgp</code> command, FRR restarts unexpectedly<br />To work around this issue, either use the <code>vtysh</code> commands or edit the <code>/etc/frr/frr.conf</code> file directly, then run <code>systemctl reload frr</code>. | 4.1.1-4.3.0 | |
| <a name="2566880"></a> [2566880](#2566880) <a name="2566880"></a> <br /> | CVE-2021-27803: A vulnerability was discovered in how p2p/p2p_pd.c in wpa_supplicant before 2.10 processes P2P (Wi-Fi Direct) provision discovery requests. It could result in denial of service or other impact (potentially execution of arbitrary code), for an attacker within radio range. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2564839"></a> [2564839](#2564839) <a name="2564839"></a> <br /> | Several vulnerabilities have been discovered in the GRUB2 bootloader:CVE-2020-14372: It was discovered that the acpi command allows a privileged user to load crafted ACPI tables when Secure Boot is enabled<br />CVE-2020-25632: A use-after-free vulnerability was found in the rmmod command<br />CVE-2020-25647: An out-of-bound write vulnerability was found in the grub_usb_device_initialize() function, which is called to handle USB device initialization<br />CVE-2020-27749: A stack buffer overflow flaw was found in grub_parser_split_cmdline<br />CVE-2020-27779: It was discovered that the cutmem command allows a privileged user  to remove memory regions when Secure Boot is enabled<br />CVE-2021-20225: A heap out-of-bounds write vulnerability was found in the short form option parser<br />CVE-2021-20233: A heap out-of-bound write flaw was found caused by mis-calculation of space required for quoting in the menu rendering. | 4.0.0-4.3.0 | |
| <a name="2558184"></a> [2558184](#2558184) <a name="2558184"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2556816"></a> [2556816](#2556816) <a name="2556816"></a> <br />CM-33419 | When ARP suppression is enabled, RARP packets sometimes get dropped and are not flooded by the local VTEP. <br />To work around this issue, disable ARP suppression. | 3.7.14-3.7.14.2, 4.3.0 | |
| <a name="2556783"></a> [2556783](#2556783) <a name="2556783"></a> <br />CM-33398 | CVE-2021-0326: An issue has been found in wpa, a set of tools to support WPA and WPA2 (IEEE 802.11i). Missing validation of data can result in a buffer over-write, which might lead to a DoS of the wpa_supplicant process or potentially arbitrary code execution.<br />Vulnerable: <= 2.8.0-cl3.7.14u1, <= 2.8.0-cl4.2.1u1 | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2556778"></a> [2556778](#2556778) <a name="2556778"></a> <br />CM-33395 | CVE-2021-26937: A  flaw in the handling of combining characters in screen, a terminal multiplexer with VT100/ANSI terminal emulation can result in denial of service, or potentially the execution of arbitrary code via a specially crafted UTF-8 character sequence.<br />Vulnerable: 4.6.2-3<br />Fixed: 4.6.2-3+deb10u1 | 4.0.0-4.3.0 | |
| <a name="2556776"></a> [2556776](#2556776) <a name="2556776"></a> <br />CM-33394 | CVE-2021-27212: A vulnerability in the Certificate List Exact Assertion validation was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of this flaw to cause a denial of service (slapd daemon crash) via specially crafted packets.<br />Vulnerable: <= 2.4.47+dfsg-3+deb10u5<br />Fixed: 2.4.47+dfsg-3+deb10u6 | 4.0.0-4.3.0 | |
| <a name="2556775"></a> [2556775](#2556775) <a name="2556775"></a> <br />CM-33393 | DSA-4859-1 (no CVE): zstd, a compression utility, was vulnerable to a race condition: it temporarily exposed, during a very short timeframe, a world-readable version of its input even if the original file had restrictive permissions.<br />Vulnerable: <= 1.3.8+dfsg-3+deb10u1<br />Fixed: 1.3.8+dfsg-3+deb10u2 | 4.0.0-4.3.0 | |
| <a name="2556772"></a> [2556772](#2556772) <a name="2556772"></a> <br />CM-33391 | The <code>net show clag verify-vlans</code> command fails with the following log: <br /><pre><br />WARNING: '/usr/bin/clagctl verifyvlans' failed due to:<br />Command '&#91;'/usr/bin/clagctl', 'verifyvlans'&#93;' returned non-zero exit status 1<br /></pre><br />To work around this issue, run the <code>/usr/bin/clagctl verifyvlans</code> command or the <code>net show clag verbose</code> command. | 4.2.1-4.3.0 | |
| <a name="2556764"></a> [2556764](#2556764) <a name="2556764"></a> <br />CM-33385 | In a configuration with both traditional and vlan-aware bridges, the VLAN membership check on a vlan-aware switch does not drop PVST BPBUs that come from a traditional bridge. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2556731"></a> [2556731](#2556731) <a name="2556731"></a> <br />CM-33359 | CVE-2020-8625: A buffer overflow vulnerability was discovered in the SPNEGO implementation affecting the GSSAPI security policy negotiation in BIND, a DNS server implementation, which could result in denial of service (daemon crash), or potentially the execution of arbitrary code.<br />Vulnerable: <= 9.11.5.P4+dfsg-5.1+deb10u2<br />Fixed: 9.11.5.P4+dfsg-5.1+deb10u3 | 4.0.0-4.3.0 | |
| <a name="2556691"></a> [2556691](#2556691) <a name="2556691"></a> <br />CM-33334 | The following vulnerabilities have been announced in the openssl packages:<br />CVE-2021-23840: Calls to EVP_CipherUpdate, EVP_EncryptUpdate and EVP_DecryptUpdate may overflow the output length argument in some cases where the input length is close to the maximum permissable length for an integer on the platform. In such cases the return value from the function call will be 1 (indicating success), but the output length value will be negative. This could cause applications to behave incorrectly or crash.<br />CVE-2021-23841: The OpenSSL public API function X509_issuer_and_serial_hash() attempts to create a unique hash value based on the issuer and serial number data contained<br />within an X509 certificate. However it fails to correctly handle any errors that may occur while parsing the issuer field (which might occur if the issuer field is maliciously constructed). This may subsequently result in a NULL pointer deref and a crash leading to a potential denial of service attack.<br />CVE-2019-1551: There is an overflow bug in the x64_64 Montgomery squaring procedure used in exponentiation with 512-bit moduli. No EC algorithms are affected. Analysis suggests that attacks against 2-prime RSA1024, 3-prime RSA1536, and DSA1024 as a result of this defect would be very difficult to perform and are not believed likely. Attacks against DH512 are considered just feasible. However, for an attack the target would have to re-use the DH512 private key, which is not recommended anyway. Also applications directly using the low level API BN_mod_exp may be affected if they use BN_FLG_CONSTTIME.<br />Vulnerable: <= 1.1.1d-0+deb10u4<br />Fixed: 1.1.1d-0+deb10u5 | 4.0.0-4.3.0 | |
| <a name="2556659"></a> [2556659](#2556659) <a name="2556659"></a> <br />CM-33315 | CVE-2020-35498: A vulnerability was found in openvswitch. A limitation in the implementation of userspace packet parsing can allow a malicious user to send a specially crafted packet causing the resulting megaflow in the kernel to be too wide, potentially causing a denial of service. The highest threat from this vulnerability is to system availability.<br />Vulnerable: <= 2.8.90-1-cl4u5 | 4.0.0-4.3.0 | |
| <a name="2556569"></a> [2556569](#2556569) <a name="2556569"></a> <br />CM-33283 | DSA-4850-1 (no CVE): libzstd adds read permissions to files while being compressed or uncompressed.<br />Vulnerable: 1.3.8+dfsg-3<br />Fixed: 1.3.8+dfsg-3+deb10u1 | 4.0.0-4.3.0 | |
| <a name="2556556"></a> [2556556](#2556556) <a name="2556556"></a> <br />CM-33281 | The <code>ethtool -m <interface></code> command does not show Mellanox 100G transceiver MMA1L30-CM information and produces the following error:<br /><pre><br />root&#64;spine01:mgmt:~# ethtool -m swp51<br />Cannot get Module EEPROM data: Invalid argument<br /></pre><br />To work around this issue, run the <code>mlxlink -d /dev/mst/mt53104_pciconf0 -c -m -e --show_fec --show_serdes_tx --show_device -p 51</code> command to show the transceiver information. | 4.3.0 | |
| <a name="2556500"></a> [2556500](#2556500) <a name="2556500"></a> <br />CM-33258 | Cumulus Linux does not support bond members at 200G or greater. | 4.0.0-4.3.0 | |
| <a name="2556463"></a> [2556463](#2556463) <a name="2556463"></a> <br />CM-33240 | On the on the Mellanox SN2410 switch, when you restart <code>switchd</code> or reboot the system, you see the following error messages:<br /><pre><br />&#91; 1446.599850&#93; switch 2-0048: HW semaphore is not released<br />&#91; 1446.605828&#93; switch 2-0048: Cmd exec failed (opcode=40(ACCESS_REG),opcode_mod=0,in_mod=0,status=30(BAD_PKT))<br />&#91; 1446.616378&#93; switch 2-0048: Reg cmd access failed (reg_id=9002(mfsc),type=write)<br />&#91; 1446.624365&#93; switch 2-0048: Failed to write PWM duty<br /></pre><br />This is a cosmetic issue and does not affect operation of the switch. | 4.3.0 | |
| <a name="2556456"></a> [2556456](#2556456) <a name="2556456"></a> <br />CM-33237 | CVE-2020-36221, CVE-2020-36222, CVE-2020-36223, CVE-2020-36224, CVE-2020-36225, CVE-2020-36226, CVE-2020-36227, CVE-2020-36228, CVE-2020-36229, CVE-2020-36230:  Several vulnerabilities were discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of these flaws to cause a denial of service (slapd daemon crash, infinite loops) via specially crafted packets.<br />Vulnerable: <= 2.4.47+dfsg-3+deb10u4<br />Fixed: 2.4.47+dfsg-3+deb10u5 | 4.0.0-4.3.0 | |
| <a name="2556369"></a> [2556369](#2556369) <a name="2556369"></a> <br />CM-33196 | If you use NCLU to configure an ACL for eth0, you can't designate it as an INPUT rule; the rule is automatically created as a FORWARD rule in the <code>/etc/cumulus/acl/policy.d/50_nclu_acl.rules</code> file.<br />To work around this issue, manually create an ACL in the <code>/etc/cumulus/acl/policy.d/</code> file with "-A INPUT -i eth0". | 4.2.1-4.3.0 | |
| <a name="2556353"></a> [2556353](#2556353) <a name="2556353"></a> <br />CM-33185 | In vtysh you can enable and disable debugs from either exec mode or global configuration mode (config t). When disabling OSPF debugs from exec mode, the debug is disabled at runtime but left in the running-configuration.<br />To work around this issue, disable OSPF debugs from global configuration mode (config t). | 4.2.1-4.3.0 | |
| <a name="2556249"></a> [2556249](#2556249) <a name="2556249"></a> <br />CM-33139 | On a Mellanox switch, the <code>cl-resource-query -j</code> command takes a long time to run with the max acl-heavy or ip-acl-heavy profile. | 4.3.0 | |
| <a name="2556082"></a> [2556082](#2556082) <a name="2556082"></a> <br />CM-33050 | The NCLU <code>net del vrf</code> command does not delete a numbered VRF. For example:<br /><pre><br />cumulus&#64;leaf01:~$ net del vrf 55<br />ERROR: Command not found<br /></pre> | 4.2.1-4.3.0 | |
| <a name="2556081"></a> [2556081](#2556081) <a name="2556081"></a> <br />CM-33049 | You cannot set the time zone can with NCLU commands. | 4.1.1-4.3.0 | |
| <a name="2556064"></a> [2556064](#2556064) <a name="2556064"></a> <br />CM-33035 | EAP-TLS fail on wired connections when the reachability to the RADIUS server does not use the eth0 (mgmt) VRF interface. | 4.2.1-4.3.0 | |
| <a name="2556061"></a> [2556061](#2556061) <a name="2556061"></a> <br />CM-33032 | On Edgecore AS4610 switches, the historic CPU usage displayed in <code>/run/sysmonitor/history</code> is sometimes shown as a negative value.  | 3.7.12-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2555932"></a> [2555932](#2555932) <a name="2555932"></a> <br />CM-32953 | On Mellanox switches, you can't ping the SVI of the MLAG peer over the peer link after the packet is VXLAN decapsulated. | 4.2.1-4.3.0 | |
| <a name="2555931"></a> [2555931](#2555931) <a name="2555931"></a> <br />CM-32951 | When the EVPN primary IP address and advertise SVI IP address options are both configured, the SVI ARP is not forwarded between MLAG switches. | 4.2.1-4.3.0 | |
| <a name="2555873"></a> [2555873](#2555873) <a name="2555873"></a> <br />CM-32914 | On Mellanox switches, egress ACLs with VLAN keys do not filter layer 2 multicast or broadcast traffic. | 4.3.0 | |
| <a name="2555763"></a> [2555763](#2555763) <a name="2555763"></a> <br />CM-32861 | The NCLU <code>net del bgp neighbor</code> command does not delete the neighbor and displays an error similar to the following:<br /><pre><br />ERROR: --- /run/nclu/frr/frr.conf.scratchpad.baseline   2021-01-04 17:23:59.250463331 +0000<br />+++ /run/nclu/frr/frr.conf.scratchpad    2021-01-04 17:25:59.213673980 +0000<br /></pre><br />To work around this issue, use the FRR command to delete a neighbor. | 4.3.0 | |
| <a name="2555613"></a> [2555613](#2555613) <a name="2555613"></a> <br />CM-32786 | The <code>net show configuration commands</code> command incorrectly displays the NCLU syntax to disable IPv6 forwarding on interfaces. For example:<br /><pre><br /># net show configuration commands<br />net add vlan 1 ip6-forward off <br /></pre><br />The correct NCLU command to disable IPv6 forwarding is <code>net add vlan 1 ipv6 forward off</code> (without the hyphen). | 4.2.1-4.3.0 | |
| <a name="2555318"></a> [2555318](#2555318) <a name="2555318"></a> <br />CM-32612 | If you try to enable BGP graceful restart when it is already enabled, you see an error similar to the following in the <code>frr.log</code> file:<br /><pre><br />2020-12-07T19:20:26.004333+00:00 cumulus bgpd&#91;4954&#93;: VRF default: Handle GR command GLOBAL_GR_CMD, current GR state GLOBAL_GR, new GR state GLOBAL_INVALID<br /></pre><br />This error has no functional impact. | 4.3.0 | |
| <a name="2555265"></a> [2555265](#2555265) <a name="2555265"></a> <br />CM-32588 | On the Mellanox SN2700 and SN2410 switch, the MTEF-PSF-AC-I and MTEF-PSR-AC-I PSUs incorrectly show 460W instead of the correct 550W. This is a cosmetic issue that does not affect the actual wattage or throughput of the power supplies. | 4.3.0 | |
| <a name="2555205"></a> [2555205](#2555205) <a name="2555205"></a> <br />CM-32545 | If the FRR and MSTP processes go down, an SNMP TRAP is not generated even with the following configuration in the <code>/etc/snmp/snmpd.conf</code> file. <br /><pre><br />proc watchfrr<br />proc mstpd<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRRis down!!!” PrErrorFlag.5 != 0<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRR is up!!!” PrErrorFlag.5 = 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is down!!!!" prErrorFlag.3 != 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is up!!!!" prErrorFlag.3 = 0<br /></pre><br /> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2555148"></a> [2555148](#2555148) <a name="2555148"></a> <br />CM-32516 | When using NCLU to add new BGP neighbors to existing configurations, the existence of address-family statements are ignored and the neighbors are added at the end of these lines. This might cause a problem if you try to activate these new neighbors in any of the existing address-family configurations.<br />To work around this issue, configure the new BGP neighbors with vtysh. | 3.7.14-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2554986"></a> [2554986](#2554986) <a name="2554986"></a> <br />CM-32416 | The <code>ethtool</code> utility doesn't contain the latest values, as a result the <code>Revision Compliance</code> field shows <code>Unallocated</code>.  | 4.2.1-4.3.0 | |
| <a name="2554812"></a> [2554812](#2554812) <a name="2554812"></a> <br />CM-32296 | If the RMAC of a layer 3 SVI changes, the <code>show vrf vni</code> command is not updated with the new value. However, the new RMAC is seen in the <code>show evpn vni</code> command and is present on self-originated EVPN routes. | 4.2.1-4.3.0 | |
| <a name="2554798"></a> [2554798](#2554798) <a name="2554798"></a> <br />CM-32286 | On the Mellanox SN3700C switch, PIM multicast packets are duplicated at the egress VTEP. | 4.2.0-4.3.0 | |
| <a name="2554783"></a> [2554783](#2554783) <a name="2554783"></a> <br />CM-32274 | If you apply an outbound route map to a BGP peer that uses <code>set as-path prepend last-as</code>, advertised locally-originated routes have the ASN of the peer prepended to the AS path.<br />This might trigger AS path loop prevention on the peer, where the peer ignores locally-originated prefixes. | 4.2.1-4.3.0 | |
| <a name="2554709"></a> [2554709](#2554709) <a name="2554709"></a> <br />CM-32217 | The IP address specified in the <code>ip pim use-source</code> command configured on the loopback interface should be inherited by unnumbered interfaces during their Primary IP address selection process.  If <code>ip pim use-source</code> is configured on the loopback after an unnumbered interface has already selected their Primary IP address, the unnumbered interface does not update its Primary IP address to be the new use-source value until after there is a netlink update for that interface.<br />To work around this issue, configure <code>ip pim use-source</code> on each unnumbered interface directly or ensure <code>ip pim use-source</code> is applied to the loopback before other unnumbered interfaces are enabled for PIM. | 3.7.13-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="2554617"></a> [2554617](#2554617) <a name="2554617"></a> <br />CM-32169 | OpenSSH is vulnerable to CVE-2020-14145, as described in https://www.fzi.de/fileadmin/user_upload/2020-06-26-FSA-2020-2.pdf.  <br />This is an information leak in algorithm negotiation that can allow man-in-the-middle attacks on initial connection attempts without a previously stored server host key on the client. If desired, mitigation using UpdateHostKeys and HostKeyAlgorithms is also given in that paper. | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2554582"></a> [2554582](#2554582) <a name="2554582"></a> <br />CM-32144 | On switches with the Maverick ASIC, control traffic is dropped due to receive buffering. | 4.2.0-4.3.0 | |
| <a name="2554533"></a> [2554533](#2554533) <a name="2554533"></a> <br />CM-32112 | On the ARM platform, NTP peer associations slowly increase to larger offsets (~500ms). | 4.0.0-4.3.0 | |
| <a name="2554466"></a> [2554466](#2554466) <a name="2554466"></a> <br />CM-32068 | Kernel routes added by <code>iproute2</code> are missing in FRR after an interface flap.<br />To work around this issue, configure a static route in FRR.<br /> | 4.2.1-4.3.0 | |
| <a name="2554299"></a> [2554299](#2554299) <a name="2554299"></a> <br />CM-31962 | In a VRRP configuration, BGP unnumbered sessions for VRFs fail to establish after a networking restart. | 4.2.0-4.3.0 | |
| <a name="2554231"></a> [2554231](#2554231) <a name="2554231"></a> <br />CM-31928 | On the Mellanox SN3700C switch, <code>hwmon</code> fails to collect information and show errors similar to the following:<br /><pre><br />2020-10-01T17:48:09.558200+09:00 &#91;sn3700c1&#93;&#91;kernel&#93;&#91;err&#93; &#91;25666.121068&#93; mlxsw_minimal 2-0048: Could not acquire lock<br />2020-10-01T17:48:09.558200+09:00 &#91;sn3700c1&#93;&#91;kernel&#93;&#91;err&#93; &#91;25666.127069&#93; mlxsw_minimal 2-0048: Reg cmd access failed (reg_id=900a(mtmp),type=query)<br />2020-10-01T17:48:10.554707+09:00 &#91;sn3700c2&#93;&#91;kernel&#93;&#91;err&#93; &#91;25160.069404&#93; mlxsw_minimal 2-0048: Could not acquire lock<br />2020-10-01T17:48:10.554707+09:00 &#91;sn3700c2&#93;&#91;kernel&#93;&#91;err&#93; &#91;25160.075393&#93; mlxsw_minimal 2-0048: Reg cmd access failed (reg_id=900f(mtbr),type=query)<br />2020-10-01T17:48:10.554707+09:00 &#91;sn3700c2&#93;&#91;kernel&#93;&#91;err&#93; &#91;25160.084265&#93; hwmon hwmon7: Failed to query module temperature sensor<br /></pre> | 4.2.1-4.3.0 | |
| <a name="2554222"></a> [2554222](#2554222) <a name="2554222"></a> <br />CM-31921 | The NCLU command to enable bridge learning fails.<br />As a work around, enable bridge learning in the <code>/etc/network/interface</code> file. For example:<br /><pre><br />auto vni-30<br />iface vni-30<br />    vxlan-id 30<br />    bridge-access 30<br />    bridge-arp-nd-suppress on<br />    bridge-learning on<br />    vxlan-local-tunnelip 10.10.10.1<br />    mstpctl-bpduguard yes<br />    mstpctl-portbpdufilter yes<br />    mtu 9166<br /></pre> | 4.2.1-4.3.0 | |
| <a name="2554218"></a> [2554218](#2554218) <a name="2554218"></a> <br />CM-31917 | MLAG packets received on the peer link are dropped instead of routed. | 4.2.0-4.3.0 | |
| <a name="2554202"></a> [2554202](#2554202) <a name="2554202"></a> <br />CM-31904 | The output of the <code>net show commit</code> command does not show the last commit or the specified commit number but is empty instead. | 4.2.1-4.3.0 | |
| <a name="2553887"></a> [2553887](#2553887) <a name="2553887"></a> <br />CM-31700 | When using TACACS+ configured with a DEFAULT user providing privilege level lower than 16, TACACS+ configured users with privilege level 16 access might not be able to run privilege level 16 NCLU commands, such as <code>net add</code> and <code>net del</code> and see an error similar to the following:<br /><pre><br />ERROR: You do not have permission to execute that command.<br /></pre><br />To work around this issue, remove the DEFAULT user from the TACACS+ server. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553677"></a> [2553677](#2553677) <a name="2553677"></a> <br />CM-31605 | When you configure an SNMPv3 user with the <code>net-snmp-config</code> configuration command from the <code>libsnmp-dev</code> package, you get an error message similar to the one below:<br /><pre><br />cumulus&#64;switch:mgmt-vrf:~$ sudo net-snmp-config --create-snmpv3-user -a shaauthpass -x aesprivpass -A SHA -X AES userSHAwithAES<br />adding the following line to /var/lib/snmp/snmpd.conf:           <br />   createUser userSHAwithAES SHA "shaauthpass" AES "aesprivpass"       <br />adding the following line to /snmp/snmpd.conf:                           <br />   rwuser userSHAwithAES                                           <br />touch: cannot touch ‘/snmp/snmpd.conf’: No such file or directory<br />/usr/bin/net-snmp-create-v3-user: 144: /usr/bin/net-snmp-create-v3-user: cannot create /snmp/snmpd.conf: Directory nonexistent<br /></pre><br />To work around this issue, use the NCLU command to configure SNMPv3 user parameters; for example:<br /><pre><br />cumulus&#64;switch:mgmt-vrf:~$ net add snmp-server username user999 auth-md5 user999password encrypt-des user999encryption<br /></pre><br />Alternatively, directly edit the <code>/etc/snmp/snmpd.conf</code> file as described in the documentation. | 3.7.13-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553237"></a> [2553237](#2553237) <a name="2553237"></a> <br />CM-31418 | The default NTP configuration is to use eth0 as the NTP source interface. In Cumulus Linux 4.0 and later, eth0 is in the management VRF by default; therefore the NTP service runs automatically in the management VRF. <br />NVIDIA does not recommend running NTP with a source interface other than eth0 as this can expose a security vulnerability. Changing the NTP source interface name with NCLU to a non-management VRF interface might result in NTP not functioning because the NTP service is still running in the management VRF.<br /><br /> | 4.2.0-4.3.0 | |
| <a name="2553231"></a> [2553231](#2553231) <a name="2553231"></a> <br />CM-31414 | On the Mellanox SN4700 switch, 8x50G port breakout is not supported currently. | 4.2.1-4.3.0 | |
| <a name="2553116"></a> [2553116](#2553116) <a name="2553116"></a> <br />CM-31357 | When you manually set the link speed or duplex mode with ethtool to an unsupported value, then run a TDR check against the interface, you encounter a <code>switchd</code> service heartbeat failure.<br />To work around this issue, reboot the switch to clear the condition. Avoid setting the interface speed or duplex mode directly with ethtool. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2553063"></a> [2553063](#2553063) <a name="2553063"></a> <br />CM-31327 | After you manually edit the <code>/etc/resolv.conf</code> file to change or remove a VRF for a given DNS server, <code>ifreload</code> does not remove IP rules created for DNS servers in the VRF. <br />To work around this issue, run the <code>net add/del dns nameserver vrf <name></code> command to force the DNS configuration. | 3.7.13-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2553015"></a> [2553015](#2553015) <a name="2553015"></a> <br />CM-31300 | If a neighbour contains a special character in PortID for LLDP, the <code>net show interface</code> command does not display the LLDP information or the command might fail. | 3.7.10-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2552691"></a> [2552691](#2552691) <a name="2552691"></a> <br />CM-31111 | On the EdgeCore AS4610 switch, the eth0 interface remains down when physically connected to a 1G interface.<br />To work around this issue, configure the link speed to 1000 and set auto-negotiation on for the eth0 interface, then flap eth0 with the <code>ip link set eth0 down/up</code> command to bring up the port. | 4.2.0-4.3.0 | |
| <a name="2552453"></a> [2552453](#2552453) <a name="2552453"></a> <br />CM-30987 | On the Mellanox switch, RoCE with PFC configuration is not applied to all ports in hardware when a range is used in the <code>traffic.conf</code> file.<br />To work around this issue, use NCLU to configure RoCE with PFC or list individual ports in the <code>traffic.conf</code> file. | 4.2.0-4.3.0 | |
| <a name="2552309"></a> [2552309](#2552309) <a name="2552309"></a> <br />CM-30889 | The following messages are seen on an Edgecord Minipack-AS8000 running Cumulus Linux 4.2.0:<br /><br /><pre><br />Hal_bcm_console.c:294 MMU config profile 0 prigroup 0: Service Pool 0 has no space and cannot be assigned<br />Hal_bcm_console.c:294 MMU config port 0 idx 0: Pool 0 has no space and cannot be assigned<br /></pre><br /><br />These messages are for internal validation purposes only and can be safely ignored.<br /><br /> | 4.2.0-4.3.0 | |
| <a name="2552294"></a> [2552294](#2552294) <a name="2552294"></a> <br />CM-30879 | NCLU restarts FRR when removing a BGP VRF IPv4 aggregate-address command.<br />  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552266"></a> [2552266](#2552266) <a name="2552266"></a> <br />CM-30863 | OpenSSH scp is vulnerable to CVE-2020-15778, where clients that have authorized access to the SSH server can execute commands on the server by copying maliciously named files.<br />The two scenarios where an exploit may be useful to an attacker:<br />-The user is authorized to <code>scp</code> but not <code>ssh</code> (based on the <code>command</code> option in the <code>authorized_keys</code> file), so this vulnerability can allow executing a remote command on the target computer when not authorized to do so.<br />-An attacker plants a maliciously named file in a directory tree that someone later uses <code>scp -r</code> to copy over to the target computer.<br />Be aware that restricting users to <code>scp</code> by using the <code>command</code> option in the <code>authorized_keys</code> file is not effective in preventing those users from executing arbitrary commands on the server.<br />If you want to use <code>scp -r</code> to copy directory trees, avoid copying directory trees to which attackers may have added maliciously-named files. Archiving the directory tree with <code>tar</code>, <code>zip</code>, or a similar program, then copying the archive over to be extracted on the server avoids having to use <code>scp -r</code> altogether. In addition, OpenSSH provides <code>sftp</code>, which you can use instead of <code>scp</code> to copy files.<br />To disable scp completely, use <code>/bin/chmod 0 /usr/bin/scp</code> . | 3.7.14-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2552214"></a> [2552214](#2552214) <a name="2552214"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14, 4.1.1-4.3.0 | 3.7.14.2|
| <a name="2552213"></a> [2552213](#2552213) <a name="2552213"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with <code>Unable to read from device/fan1_input/pwm1</code> syslog messages. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2551666"></a> [2551666](#2551666) <a name="2551666"></a> <br />CM-30473 | If you modify an interface name, then reuse the previous interface name for a different VLAN, the <code>ifreload -a</code> command generates an error similar to the following:<br /><pre><br />warning: <interface-name>: interface not recognized - please check interface configuration<br /></pre><br /> | 4.1.0-4.3.0 | |
| <a name="2551578"></a> [2551578](#2551578) <a name="2551578"></a> <br />CM-30422 | When you configure a bridge in the <code>/etc/network/interfaces</code> file, then try to reconfigure the bridge to be a VRF interface with the same name, <code>ifreload</code>/<code>ifup</code> commands fail with an <code>invalid table id</code> or <code>unable to get vrf table id</code> error. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2551565"></a> [2551565](#2551565) <a name="2551565"></a> <br />CM-30414 | If you toggle VRRP priority values between VRRP routers, then run a <code>switchd</code> restart, a few IPv6 VRRP instances might not converge. As a result, both the VRRP routers act as _master_ routers for the impacted IPv6 VRRP instances. IPv4 VRRP instances are not affected.<br />To work around this issue, remove, then add the VRRP configuration with NCLU commands or vtysh in FRR.<br /> | 3.7.13-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="2551335"></a> [2551335](#2551335) <a name="2551335"></a> <br />CM-30312 | When TACACS+ is configured and the management VRF is enabled, users with privilege level 13 are prevented from running <code>ip</code> and <code>cat</code> commands. | 4.0.0-4.3.0 | |
| <a name="2551305"></a> [2551305](#2551305) <a name="2551305"></a> <br />CM-30296 | The <code>net show configuration</code> command provides the wrong <code>net add</code> command for ACL under the VLAN interface.<br /><br /> | 3.7.12-3.7.14.2, 4.1.0-4.3.0 | |
| <a name="2551273"></a> [2551273](#2551273) <a name="2551273"></a> <br />CM-30280 | On a Mellanox SN2010 switch, the Locator LED is on after you upgrade Cumulus Linux. | 4.1.0-4.3.0 | |
| <a name="2550974"></a> [2550974](#2550974) <a name="2550974"></a> <br />CM-30195 | On the Dell S3000 switch, after installing the Cumulus Linux 4.1.1 disk image without a license, the switch sends a link beat if a remote host port is configured. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550950"></a> [2550950](#2550950) <a name="2550950"></a> <br />CM-30182 | The <code>net show time ntp servers</code> command does not show any output with management VRF. | 4.1.1-4.3.0 | |
| <a name="2550793"></a> [2550793](#2550793) <a name="2550793"></a> <br />CM-30101 | The NCLU <code>net show bridge spanning-tree</code> command displays the aging timer incorrectly.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550771"></a> [2550771](#2550771) <a name="2550771"></a> <br />CM-30089 | Cumulus Linux supports a maximum of 300 ACLs for use with 802.1X interfaces. This limit encompasses the default ACLs, pre-auth ACLs and dynamic ACLs. Exceeding this limit can affect the performance of the switch. | 4.1.0-4.3.0 | |
| <a name="2550713"></a> [2550713](#2550713) <a name="2550713"></a> <br />CM-30052 | Configuring the subinterface of a VXLAN uplink under another traditional bridge, which also has the VXLAN VNI enslaved, causes <code>switchd</code> to use high CPU due to very frequent VXLAN tunnel sync events.<br />To work around this issue, do not enslave the subinterface of a VXLAN layer 3 uplink under a traditional bridge in a VXLAN configuration. | 4.1.1-4.3.0 | |
| <a name="2550704"></a> [2550704](#2550704) <a name="2550704"></a> <br /> | On the Mellanox SN3420 switch, 25G SR optics only link up in force mode. | 4.3.0 | |
| <a name="2550601"></a> [2550601](#2550601) <a name="2550601"></a> <br />CM-29978 | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550466"></a> [2550466](#2550466) <a name="2550466"></a> <br />CM-29890 | Multiple paths to identical EVPN prefixes are either not displayed or not accepted into the l2vpn evpn table if they are received from a different AS. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2550444"></a> [2550444](#2550444) <a name="2550444"></a> <br />CM-29872 | Tab completion for the <code>net show rollback description</code> command returns information about a snapshot instead of context help.<br />To work around this issue, run the <code>net show commit history</code> command to find descriptions instead of the <code>net show rollback description</code> command. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550443"></a> [2550443](#2550443) <a name="2550443"></a> <br />CM-29871 | The <code>net show rollback description <string></code> command returns an error even if the string matches a commit description.<br />To work around this issue, look for your string in the output of the <code>net show commit history</code> command (or grep for it there) instead. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550243"></a> [2550243](#2550243) <a name="2550243"></a> <br />CM-29759 | When you use <code>nginx</code> and <code>restserver</code> in management VRF to provide a REST API for the switch, <code>nginx</code> starts but <code>restserver</code> fails to start.<br />To work around this issue, comment out the <code>Requires=</code> line in the <code>/lib/systemd/system/restserver.service</code>. For example:<br /><pre><br />#Requires=nginx.service restserver.socket<br /></pre> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2550056"></a> [2550056](#2550056) <a name="2550056"></a> <br />CM-29652 | The ACCTON-DIAG option under the Cumulus Linux GRUB menu does not work. When you select this option, you see the following error:<br /><pre><br />error: invalid signature.<br />Press any key to continue...<br /></pre> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549925"></a> [2549925](#2549925) <a name="2549925"></a> <br />CM-29594 | When you run an Ansible script to replace the <code>/etc/network/interfaces</code> file, then run the <code>ifreload -a</code> command, you see errors similar to the following:<br /><pre><br />error: swp1s1.2: netlink: cannot set link swp1s1.2 up: operation failed with 'Network is down' (100)<br />warning: cmd '/bin/ip addr del 10.0.0.1/24 dev eth0' failed: returned 2 (RTNETLINK answers: Cannot assign requested address<br /></pre><br />To work around this issue,  run the <code>ifreload -a</code> command a second time. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549872"></a> [2549872](#2549872) <a name="2549872"></a> <br />CM-29562 | If you have an SVI with multiple VRR IP addresses and try to delete one of the VRR configurations, <code>net commit</code> or <code>ifreload -a</code> returns an error. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549782"></a> [2549782](#2549782) <a name="2549782"></a> <br />CM-29519 | The JSON format output of the <code>net show bgp l2vpn evpn summary</code> command shows the incorrect neighbour state.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2549731"></a> [2549731](#2549731) <a name="2549731"></a> <br />CM-29492 | When you create SPAN or ERSPAN rules in ebtables, the action fails to install if it is not in lowercase. Make sure that the SPAN or ERSPAN action is all lowercase; for example:<br /><pre><br />&#91;ebtables&#93;<br />-A FORWARD --in-interface swp10 -j span --dport swp1<br /></pre> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="2549392"></a> [2549392](#2549392) <a name="2549392"></a> <br />CM-29319 | When you configure an RD or RT with NCLU, you see duplicate VNI stanzas in the <code>/etc/frr/frr.conf</code> file. <br />To work around this issue, manually edit the <code>etc/frr/frr.conf</code> file to define <code>advertise-all-vni</code> before the RD or RT configuration within the l2vpn EVPN address family, then reload the FRR service with the <code>sudo systemctl reload frr</code> command. | 4.1.0-4.3.0 | |
| <a name="2549371"></a> [2549371](#2549371) <a name="2549371"></a> <br />CM-29309 | When Optimized Multicast Flooding (OMF) is enabled with the <code>bridge.optimized_mcast_flood = TRUE</code> setting in the <code>/etc/cumulus/switchd.conf</code> file, the switch continues to flood IPv6 multicast traffic to all slave ports when there is no MLD join receive. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548924"></a> [2548924](#2548924) <a name="2548924"></a> <br />CM-29146 | On the EdgeCore Minipack AS8000, storm control does not restrict unknown unicast, broadcast, or multicast traffic. | 4.1.1-4.3.0 | |
| <a name="2548315"></a> [2548315](#2548315) <a name="2548315"></a> <br />CM-28816 | The following security advisory has been announced for bash: <br />CVE-2019-18276 Qualys scan QID 372268 setuid vulnerability<br />When bash or bash scripts are run setuid, bash is supposed to drop privileges, but does so incorrectly, so that an attacker with command access to the shell can use <code>enable -f</code> for runtime loading of a new builtin that calls <code>setuid()</code> to regain dropped privileges.<br />To work around this issue, do not make bash or bash scripts <code>setuid</code>. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548260"></a> [2548260](#2548260) <a name="2548260"></a> <br />CM-28770 | The <code>net add routing route-map <name> permit <seq> set community <comm></code> command does not add the set statement into the <code>/etc/frr/frr.conf</code> file. | 4.0.0-4.3.0 | |
| <a name="2548243"></a> [2548243](#2548243) <a name="2548243"></a> <br />CM-28754 | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548181"></a> [2548181](#2548181) <a name="2548181"></a> <br />CM-28705 | On the Mellanox SN3800 switch, 4x25G DAC breakouts are not supported. | 4.1.0-4.3.0 | |
| <a name="2548117"></a> [2548117](#2548117) <a name="2548117"></a> <br />CM-28659 | In OVSDB traditional bridge mode, adding or removing a VLAN binding causes a traffic forwarding outage for around 20 seconds or more on adjacent VLAN bindings. Cumulus Linux does not support _traditional_ bridge mode with VMware NSX. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2548062"></a> [2548062](#2548062) <a name="2548062"></a> <br />CM-28622 | When ports are split to 4x25G, RS FEC needs to explicitly configured on both ends (especially when interoperating with non-Mellanox switches). | 4.1.0-4.3.0 | |
| <a name="2548060"></a> [2548060](#2548060) <a name="2548060"></a> <br />CM-28620 | On the Mellanox SN3800 switch, links do not come up when the ports are configured for 40G. | 4.1.0-4.3.0 | |
| <a name="2547890"></a> [2547890](#2547890) <a name="2547890"></a> <br />CM-28497 | QinQ across VXLAN on a traditional bridge does not work. | 4.1.0-4.3.0 | |
| <a name="2547881"></a> [2547881](#2547881) <a name="2547881"></a> <br />CM-28489 | The following CVEs were announced for rsyslog:<br />CVE-2019-17041 CVE-2019-17042<br /><br />rsyslogd, when receiving remote log messages (not enabled by default on Cumulus Linux) with the pmaisforwardedfrom or pmcisconames optional log parsers (also not enabled by default on Cumulus Linux), is vulnerable to CVE-2019-17041 and CVE-2019-17042 where malicious messages that appear to be from AIX or Cisco respectively may be caused to skip sanity checks, resulting in incorrect negative lengths causing heap overflows.<br />Vulnerable: 8.1901.0-1<br /><br />Recommendation:<br /><br />Do not enable receiving syslog messages from other hosts by the network (with $UDPServerRun or $InputTCPServerRun).  Also, do not enable (with $ModLoad) the vulnerable parsers pmaixforwardedfrom or pmcisconames.  The default /etc/rsyslog.conf file on Cumulus Linux does not enable any of these.<br /> | 4.0.0-4.3.0 | |
| <a name="2547831"></a> [2547831](#2547831) <a name="2547831"></a> <br />CM-28458 | NCLU incorrectly allows you to configure port security on bond/MLAG interfaces.<br />Port security is not supported on bond/MLAG interfaces. | 4.0.0-4.3.0 | |
| <a name="2547706"></a> [2547706](#2547706) <a name="2547706"></a> <br />CM-28397 | When you configure ganged ports in the <code>ports.conf</code> file, the change does not take effect after you restart <code>switchd</code>. <br />To work around this issue, reboot the switch. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2547405"></a> [2547405](#2547405) <a name="2547405"></a> <br />CM-28226 | When you restart the <code>hsflowd</code> service, you see a <code>systemd</code> warning message similar to the following:<br /><pre><br />Warning: The unit file, source configuration file or drop-ins of hsflowd&#64;mgmt.service changed on disk. Run 'systemctl daemon-reload'.<br /></pre> | 4.0.0-4.3.0 | |
| <a name="2546991"></a> [2546991](#2546991) <a name="2546991"></a> <br />CM-28003 | The FRR service does not provide a way for automation to know if the configuration applied properly.<br />To work around this issue, execute the <code>vtysh -f <file></code> command in the automation file before starting the FRR service to validate the functional configuration and return an error code. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546895"></a> [2546895](#2546895) <a name="2546895"></a> <br />CM-27957 | If you have configured a higher number of ports and VLANs (ports x VLANs) or the switch is a lower-powered (CPU) platform, the <code>switchd</code> service might fail to send a <code>systemd keepalive</code> within the watchdog timeout value (2 minutes by default) and you see an error similar to the following:<br /><pre><br />bq. systemd&#91;1&#93;: switchd.service watchdog timeout (limit 2min)!<br /></pre><br />To workaround this issue, either reduce the number of configured interfaces and, or VLANs, or increase the <code>systemd</code> timeout for <code>switchd.service</code>.<br />To increase the <code>systemd</code> timeout:<br /># Edit the <code>/etc/systemd/system/switchd.service.d/override.conf</code> file and increase the <code>WatchdogSec</code> parameter.<br /># Restart the <code>switchd</code> service with the <code>sudo systemctl restart switchd.service</code> command.<br /><code>systemd</code> will attempt to restart the <code>switchd</code> service automatically (after the watchdog timeout). If the restart fails multiple times in a short time period, run the <code>sudo systemctl reset-failed</code> command followed by the <code>sudo systemctl restart switchd</code> command.<br /> | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2546874"></a> [2546874](#2546874) <a name="2546874"></a> <br />CM-27950 | On the Dell S5232F, S5248F, S5296F, and S3048 switch, using the <code>poweroff</code> or <code>halt</code> commands does not fully power off the switch. | 4.0.0-4.3.0 | |
| <a name="2546261"></a> [2546261](#2546261) <a name="2546261"></a> <br />CM-27642 | The following CVEs were announced that affect the libssh package:<br />CVE-2019-14889 has been announced in the libssh library, where unsanitized user-provided scp command lines could allow an attacker to execute arbitrary commands on the server.<br />The libssh library is not installed on Cumulus Linux by default, but is available in the Cumulus Linux 4 repository for optional installation. Note that libssh is distinct from libssh2 and openssh, which are present on the switches and in the repositories.<br />See the following for more information:<br />https://www.libssh.org/security/advisories/CVE-2019-14889.txt<br />https://security-tracker.debian.org/tracker/CVE-2019-14889 | 4.0.0-4.3.0 | |
| <a name="2545837"></a> [2545837](#2545837) <a name="2545837"></a> <br />CM-27444 | If you use the NCLU commands to configure NTP and run the <code>net add time ntp source <interface></code> command before you run the <code>net add time ntp server <server> iburst</code> command, the <code>/etc/ntp.conf</code> file is misconfigured.<br />To work around this issue, run the <code>net add time ntp server <server> iburst</code> command before you run the <code>net add time ntp source <interface></code> command. | 3.7.10-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2545520"></a> [2545520](#2545520) <a name="2545520"></a> <br />CM-27243 | The length of the netlink message is not set properly for non-bridge family type messages. The same length is used for both bridge and non-bridge even though the bridge family type message has an extra attribute. This causes extra bytes to be left over in non-bridge family type netlink messages. | 3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2545362"></a> [2545362](#2545362) <a name="2545362"></a> <br />CM-27143 | On the Dell S5248F-ON switch, the CPU core temperature sensors show <code>ABSENT</code>. | 4.0.0-4.3.0 | |
| <a name="2545239"></a> [2545239](#2545239) <a name="2545239"></a> <br />CM-27099 | On the Mellanox switch with the Spectrum-2 ASIC, Precision Time Protocol (PTP) is not currently supported.  | 4.0.0-4.3.0 | |
| <a name="2545233"></a> [2545233](#2545233) <a name="2545233"></a> <br />CM-27094 | On the Delta AG9032v1 switch, smonctl and sensors report inaccurate PSU current and power. | 4.0.0-4.3.0 | |
| <a name="2545125"></a> [2545125](#2545125) <a name="2545125"></a> <br />CM-27018 | If you configure more than one VRR interface on an SVI interface, deleting one of the VRR addresses does not remove the interface/address.  | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2545012"></a> [2545012](#2545012) <a name="2545012"></a> <br />CM-26942 | Port security is not currently supported on VX. The NCLU commands produce errors. | 4.0.0-4.3.0 | |
| <a name="2544978"></a> [2544978](#2544978) <a name="2544978"></a> <br />CM-26921 | If you delete an undefined bond, then add a bond slave, the <code>net commit</code> command fails. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544968"></a> [2544968](#2544968) <a name="2544968"></a> <br />CM-26913 | FRR configuration commands for an SVI interface might have the <code>\n</code> misplaced in the output.  For example:<br /><pre><br />sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />should be:<br /><pre><br />sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />To work around this issue, configure the interface manually in the <code>/etc/frr/frr.conf</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544957"></a> [2544957](#2544957) <a name="2544957"></a> <br />CM-26907 | NCLU incorrectly allows you to apply port security configuration on layer 2 and layer 3 ports that are not part of a bridge. | 4.0.0-4.3.0 | |
| <a name="2544953"></a> [2544953](#2544953) <a name="2544953"></a> <br />CM-26905 | When you update the hostname of a switch with the NCLU <code>net add hostname <hostname></code> command, then run <code>net commit</code>, the <code>lldpd</code> service does not restart and other devices still see the old hostname.<br />To work around this issue, run the <code>sudo systemctl restart lldpd.service</code> command. | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544880"></a> [2544880](#2544880) <a name="2544880"></a> <br />CM-26860 | When you run the NCLU <code>net show commit last</code> or <code>net show commit <number></code> command, where <code><number></code> is the last commit, no output is shown.  | 4.0.0-4.3.0 | |
| <a name="2544723"></a> [2544723](#2544723) <a name="2544723"></a> <br />CM-26769 | Setting ProtoDown on ports populated with SFP modules providing RJ-45 1000BASE-T interfaces does not cause the carrier to be dropped. The kernel shows carrier down; however, the remote device still shows a link. | 3.7.6-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2544463"></a> [2544463](#2544463) <a name="2544463"></a> <br />CM-26599 | Auto-negotiation does not work with the QSFP28 cables and a remote system operating at 10G. Attempting to enable auto-negotiation with <code>ethtool -s swp<#> autoneg on</code> returns <code>Operation not supported</code>.<br />To work around this issue, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544456"></a> [2544456](#2544456) <a name="2544456"></a> <br />CM-26595 | The NCLU <code>net show lldp</code> command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544311"></a> [2544311](#2544311) <a name="2544311"></a> <br />CM-26516 | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544155"></a> [2544155](#2544155) <a name="2544155"></a> <br />CM-26423 | NCLU requires you to specify an interface with multiple <code>address-virtual</code> statements in ascending MAC address order. <br /><br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2544113"></a> [2544113](#2544113) <a name="2544113"></a> <br />CM-26412 | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address changing between the MLAG bond and the peer link.<br />To work around this issue, disable MAC learning on QinQ VLANs by adding <code>bridge-learning off</code> to the VLAN stanza in the <code>etc/network/interfaces</code> file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543937"></a> [2543937](#2543937) <a name="2543937"></a> <br />CM-26308 | An interface alias configured outside FRR using <code>iproute2</code> is imported into the FRR running configuration and overrides the internal description. After an FRR reload, this causes FRR to delete the interface alias in an inefficient way. Depending on how many interfaces with aliases you have configured, this can cause a FRR reload to time out.<br />To work around this issue, remove the interface alias description from <code>iproute2</code>. | 3.7.8-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543900"></a> [2543900](#2543900) <a name="2543900"></a> <br />CM-26288 | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543841"></a> [2543841](#2543841) <a name="2543841"></a> <br />CM-26256 | The <code>net show evpn vni detail json</code> command includes an extra empty dictionary at the end of the output. <br /> | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543816"></a> [2543816](#2543816) <a name="2543816"></a> <br />CM-26241 | On the Dell S5248F-ON switch, <code>smond</code> might generate syslog messages indicating that the fan input RPM is lower than the normal low speed of 2500 RPM. Speeds as low as 1700 RPM are acceptable in normal thermal environments; therefore, you can ignore these messages.<br /> | 3.7.6-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="2543781"></a> [2543781](#2543781) <a name="2543781"></a> <br />CM-26217 | NCLU does not allow you to configure OSPF NSSAs. For example: <br /><pre><br />cumulus&#64;switch:~$ net add ospf area 0.0.0.1 nssa <br />ERROR: Command not found. <br />net add ospf area 0.0.0.1 nssa<br /></pre><br />To work around this issue, use FRR instead. For example: <br /><pre><br />switch# configure terminal <br />switch(config)# router ospf <br />switch(config-router)# area 0.0.0.1 nssa <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543724"></a> [2543724](#2543724) <a name="2543724"></a> <br />CM-26179 | If a hostname contains utf-8 characters, the NCLU <code>net show lldp</code> command outputs the following error: <br /><pre><br />ERROR: 'ascii' codec can't encode character u'\xe9' in position 3: ordinal not in range(128) <br />See /var/log/netd.log for more details.  <br /></pre> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2543646"></a> [2543646](#2543646) <a name="2543646"></a> <br />CM-26136 | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543211"></a> [2543211](#2543211) <a name="2543211"></a> <br />CM-25890 | In some cases, the <code>switchd</code> service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18).<br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543164"></a> [2543164](#2543164) <a name="2543164"></a> <br />CM-25859 | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The <code>net commit</code> command succeeds even though the MTU is not changed as expected.<br />To work around this issue, change the MTU on all SVIs and the bridge manually in the <code>/etc/network/interfaces</code> file, then apply the change with the <code>ifreload -a</code> command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2543096"></a> [2543096](#2543096) <a name="2543096"></a> <br />CM-25815 | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the <code>/etc/network/interfaces</code> file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542945"></a> [2542945](#2542945) <a name="2542945"></a> <br />CM-25740 | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br />To work around this issue, configure the bridge with <code>bridge-vlan-protocol 802.1ad</code>: <br /><pre><br />cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre>  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542837"></a> [2542837](#2542837) <a name="2542837"></a> <br />CM-25674 | On Mellanox switches, policer iptables are not working as expected. For example, when using a policer with mode KB/MB/GB to rate-limit interfaces, the syntax is accepted but the data plane transfer speed is not affected by the rule.  | 3.7.6-3.7.8, 4.0.0-4.3.0 | 3.7.9-3.7.14|
| <a name="2542305"></a> [2542305](#2542305) <a name="2542305"></a> <br />CM-25400 | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the <code>vlan-id</code> and the raw-device bridge stanzas are not added automatically. <br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2542301"></a> [2542301](#2542301) <a name="2542301"></a> <br />CM-25397 | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541212"></a> [2541212](#2541212) <a name="2541212"></a> <br />CM-24894 | The <code>maximum-prefix</code> configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2541029"></a> [2541029](#2541029) <a name="2541029"></a> <br />CM-24799 | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br />This issue only affects QinQ configurations. <br />  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540808"></a> [2540808](#2540808) <a name="2540808"></a> <br />CM-24652 | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br />This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540753"></a> [2540753](#2540753) <a name="2540753"></a> <br />CM-24618 | If the interface alias contains a single or double quotation mark, or an apostrophe, the <code>net show configuration</code> commands fail with the following error: <br /><pre> <br />ERROR: No closing quotation <br />See /var/log/netd.log for more details. <br /></pre> <br /> | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540444"></a> [2540444](#2540444) <a name="2540444"></a> <br />CM-24473 | SNMP incorrectly requires engine ID specification. <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540352"></a> [2540352](#2540352) <a name="2540352"></a> <br />CM-24435 | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a _match interface_ condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br />For example, this command is incorrect: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9-10 <br /></pre> <br />These commands are correct: <br /><pre> <br />net add routing route-map Proxy-ARP permit 25 match interface swp9 <br />net add routing route-map Proxy-ARP permit 30 match interface swp10 <br /></pre> <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540340"></a> [2540340](#2540340) <a name="2540340"></a> <br />CM-24426 | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the <code>net add vrf <name></code> command just displays <ENTER>. For example: <br /> <pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre> <br /> Tab completion for the <code>net add vrf <name> ip address <address></code> command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540274"></a> [2540274](#2540274) <a name="2540274"></a> <br />CM-24379 | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540204"></a> [2540204](#2540204) <a name="2540204"></a> <br />CM-24350 | When links come up after FRR is started, VRF connected routes do not get redistributed. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540192"></a> [2540192](#2540192) <a name="2540192"></a> <br />CM-24343 | The <code>net del bridge bridge mcsnoop yes</code> command does not return the value to the default of disabled. <br />To work around this issue, use the <code>net add bridge bridge mcsnoop no</code> command to delete the <code>mcsnoop attribute</code> and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540155"></a> [2540155](#2540155) <a name="2540155"></a> <br />CM-24332 | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540042"></a> [2540042](#2540042) <a name="2540042"></a> <br />CM-24272 | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the <code>net commit</code> command fails. <br />To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface br0.100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# vrrp 1 advertisement-interval <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540041"></a> [2540041](#2540041) <a name="2540041"></a> <br />CM-24271 | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br />To work around this issue, run the vtysh command inside FRR to change the default priority. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface vlan100 <br />switch(config-if)# vrrp 1 priority 110 <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540040"></a> [2540040](#2540040) <a name="2540040"></a> <br />CM-24270 | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example: <br /><pre> <br />cumulus&#64;switch:~$ sudo vtysh <br />switch# configure terminal <br />switch(config)# interface swp4 <br />switch(config-if)# vrrp 1 version 2 <br />switch(config-if)# no vrrp 1 preempt <br />switch(config-if)# end <br />switch# write memory <br />switch# exit <br />cumulus&#64;switch:~ <br /></pre> <br /> | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2540031"></a> [2540031](#2540031) <a name="2540031"></a> <br />CM-24262 | NCLU does not honor <code>auto all</code> in the <code>/etc/network/interfaces</code> file and removes the existing configuration if no individual <code>auto <iface></code> lines exist. <br />  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539994"></a> [2539994](#2539994) <a name="2539994"></a> <br />CM-24241 | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre> <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539962"></a> [2539962](#2539962) <a name="2539962"></a> <br />CM-24222 | When an LDAP user that does not have NCLU privileges (either in the <code>netshow</code> or <code>netedit</code> group, or in the <code>/etc/netd.conf</code> file) runs an NCLU command, a traceback occurs instead of a permissions error. <br /> | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539670"></a> [2539670](#2539670) <a name="2539670"></a> <br />CM-24035 | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2539124"></a> [2539124](#2539124) <a name="2539124"></a> <br />CM-23825 | The <code>net add interface <interface> ptm-enable</code> command adds <code>no ptm-enable</code> for that interface in the <code>frr.conf</code> file. <br />Running the <code>net add</code> or the <code>net del</code> command does not remove <code>no ptm-enable</code> from the <code>frr.conf</code> file. You have to remove it manually using vtysh. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538790"></a> [2538790](#2538790) <a name="2538790"></a> <br />CM-23665 | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run <code>net add vxlan <layer3-vni> bridge access <vlan></code>. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br />To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538740"></a> [2538740](#2538740) <a name="2538740"></a> <br />CM-23651 | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync. <br /> | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538590"></a> [2538590](#2538590) <a name="2538590"></a> <br />CM-23584 | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain. <br /> | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538562"></a> [2538562](#2538562) <a name="2538562"></a> <br />CM-23570 | On an RMP/1G-T switch, when you remove <code>link-speed 100</code> with the NCLU command or by editing the <code>etc/network/interfaces</code> file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br />After you remove the link-speed, <code>ethtool</code> shows the advertised link modes as not reported and Speed/Duplex as unknown.<br />To work around this issue and bring the interface back up, either restart <code>switchd</code> or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br />Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538295"></a> [2538295](#2538295) <a name="2538295"></a> <br />CM-23418 | For QSFP modules, the <code>sudo ifdown</code> command does not disable the Tx laser. <br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2538294"></a> [2538294](#2538294) <a name="2538294"></a> <br />CM-23417 | If you use NCLU to create an iBGP peering across the peer link, running the <code>net add bgp l2vpn evpn neighbor peerlink.4094 activate</code> command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2537699"></a> [2537699](#2537699) <a name="2537699"></a> <br />CM-23075 | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the <code>/etc/default/isc-dhcp-relay</code> file. For example, 1500 SVI interfaces causes the <code>dhcrelay</code> service to exit without a core file and logs similar to the following are generated for the interfaces: <br /><pre> <br />2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51 <br />2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51 <br /></pre> <br />Eventually the <code>dhcrelay</code> service stops. <br /> | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536576"></a> [2536576](#2536576) <a name="2536576"></a> <br />CM-22554 | If you try to bring down several members of a bond remotely at the same time, the link state of one of the interfaces might not transition correctly to the down state; however, all links show down in hardware. <br />  | 4.0.0-4.3.0 | |
| <a name="2536384"></a> [2536384](#2536384) <a name="2536384"></a> <br />CM-22386 | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware. <br />  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2536256"></a> [2536256](#2536256) <a name="2536256"></a> <br />CM-22301 | For an unresolved address, the IPROUTER default policer rule has been modified to _not_ match on packets exiting a TUNNEL and headed to the CPU to resolve the address via ARP. As a result, the following default rule no longer matches TUNNEL ingress packets. <br /><pre> <br />A $INGRESS_CHAIN --in-interface $INGRESS_INTF -m addrtype --dst-type <br />IPROUTER -j POLICE --set-mode pkt --set-rate 400 --set-burst 100 <br /></pre> <br />These packets are now policed by catch all rules. <br />To work around this issue, the VPORT value on a TRIDENT switch must be changed from binary 011 to 100. <br /> | 4.0.0-4.3.0 | |
| <a name="2536242"></a> [2536242](#2536242) <a name="2536242"></a> <br />CM-22287 | On the EdgeCore AS7712 (Tomahawk) switch running in atomic mode, when a layer 3 ECMP path is brought down, traffic traversing the path stops working for about four seconds. When the switch is changed to non-atomic mode, the delay is less than one second. This issue is seen across OSPF and static ECMP routes.  | 4.0.0-4.3.0 | |
| <a name="2536179"></a> [2536179](#2536179) <a name="2536179"></a> <br />CM-22228 | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535986"></a> [2535986](#2535986) <a name="2535986"></a> <br />CM-22041 | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in <code>No buffer space available</code> error messages on protocol sockets.<br />When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a <code>switchd</code> restart. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535965"></a> [2535965](#2535965) <a name="2535965"></a> <br />CM-22020 | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br />To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2535723"></a> [2535723](#2535723) <a name="2535723"></a> <br />CM-21785 | The source address of the ICMPv6 time exceeded message (traceroute hop) is sourced from the wrong VRF when the traceroute target resides on the same switch but in a different VRF. | 4.0.0-4.3.0 | |
| <a name="2535605"></a> [2535605](#2535605) <a name="2535605"></a> <br />CM-21667 | FRR does not add BGP <code>ttl-security</code> to either the running configuration or to the <code>/etc/frr/frr.conf</code> file when configured on a peer group instead of a specific neighbor. <br />To work around this issue, add <code>ttl-security</code> to individual neighbors instead of the peer group. | 4.0.0-4.3.0 | |
| <a name="2535209"></a> [2535209](#2535209) <a name="2535209"></a> <br />CM-21278 | The <code>net show lldp</code> command sometimes shows the port description in the <code>Remote Port</code> field. The <code>net show interface</code> command shows the correct value in the <code>Remote Host</code> field.<br />To work around this issue, use <code>net show interface</code> command for LLDP output when connected to Cisco equipment. | 3.7.5-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="2534734"></a> [2534734](#2534734) <a name="2534734"></a> <br />CM-20813 | Span rules matching the out-interface as a bond do not mirror packets. | 4.0.0-4.3.0 | |
| <a name="2534422"></a> [2534422](#2534422) <a name="2534422"></a> <br />CM-20508 | The Cumulus-Resource-Query-MIB defines the ability to gather buffer utilization status but when these objects are polled, they return nothing. <br /> | 4.0.0-4.3.0 | |
| <a name="2533940"></a> [2533940](#2533940) <a name="2533940"></a> <br />CM-20033 | The VLAN interface stays up even though the physical link carrying the VLAN is admin or carrier down.<br /><br /> | 4.0.0-4.3.0 | |
| <a name="2533691"></a> [2533691](#2533691) <a name="2533691"></a> <br />CM-19788 | If you configure a VLAN under a VLAN-aware bridge and create a subinterface of the same VLAN on one of the bridge ports, the bridge and interface compete for the same VLAN and if the interface is flapped, it stops working. Correcting the configuration and running the <code>ifreload</code> command does not resolve the conflict. <br />To work around this issue, correct the bridge VIDs and restart <code>switchd</code> or delete the subinterface.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="2533625"></a> [2533625](#2533625) <a name="2533625"></a> <br />CM-19724 | PIM and MSDP entries are set to the internal COS value of 6 so they are grouped together with the bulk traffic priority group in the default <code>traffic.conf</code> file. However, PIM, IGMP, and MSDP are considered control-plane and should be set to the internal COS value of 7.  | 4.0.0-4.3.0 | |
| <a name="2533337"></a> [2533337](#2533337) <a name="2533337"></a> <br />CM-19454 | When you use NCLU to bring a bond admin down (<code>net add bond <bond> link down</code>), the bond interface goes into admin down state but the switch ports enslaved to the bond remain UP. If you are using bond-lacp-bypass-allow or balance-xor mode, the host might continue to send traffic. This traffic will be dropped because although the bond slaves are UP, they are not members of the bridge.<br />To work around this issue, use the <code>sudo ifdown <bondname></code> command. | 4.0.0-4.3.0 | |
| <a name="2531273"></a> [2531273](#2531273) <a name="2531273"></a> <br />CM-17494 | In certain cases, a peer device sends an ARP request from a source IP address that is not on the connected subnet and the switch creates a STALE neighbor entry. Eventually, the switch attempts to keep the entry fresh and sends ARP requests to the host. If the host responds, the switch has REACHABLE neighbor entries for hosts that are not on the connected subnet. <br />To work around this issue, change the value of <code>arp_ignore</code> to 2. See &#91;Address Resolution Protocol in the Cumulus Linux user guide\|https://docs.cumulusnetworks.com/cumulus-linux/Layer-3/Address-Resolution-Protocol-ARP/&#93; for more information. | 4.0.0-4.3.0 | |
| <a name="2530322"></a> [2530322](#2530322) <a name="2530322"></a> <br />CM-16571 | NCLU cannot manage <code>rsyslog</code> to addresses routed via a VRF.  In Cumulus Linux 4.0.0 and later, management VRF is enabled by default.   To work around this issue, update the <code>/etc/network/interfaces</code> file to disable management VRF. | 4.0.0-4.3.0 | |

### Fixed Issues in 4.3.0
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="CM-30832"></a> [CM-30832](#CM-30832) <a name="CM-30832"></a> <br /> | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with `Unable to read from device/fan1_input/pwm1` syslog messages. | 3.7.11-3.7.14, 4.1.1-4.2.1 | |
| <a name="2589747"></a> [2589747](#2589747) <a name="2589747"></a> <br />CM-32226 | If <code>switchd</code> successfully signals <code>clagd</code> that it is going down, <code>clagd</code> stops responding to keepalive echo requests from the peer instead of sending a good bye to the peer over both the peerlink and the backup switch. Eventually, the keepalive timer expires and the secondary switch becomes the primary, and brings the bonds and VNIs back up. However, if <code>switchd</code> does not successfully signal it is going down, (in the event of a crash), the primary switch continues to respond to keepalives, and the bonds and VNIs are down on both peers.  | 3.7.12-4.2.1 | |
| <a name="2556334"></a> [2556334](#2556334) <a name="2556334"></a> <br />CM-33176 | On the Mellanox SN-4700 switch, when you use a 2x100G configuration, the links do not come up. |  | |
| <a name="2556279"></a> [2556279](#2556279) <a name="2556279"></a> <br />CM-33160 | CVE-2021-3156: A serious heap-based buffer overflow has been discovered in sudo that is exploitable by any local user. It has been given the name Baron Samedit by its discoverer. The bug can be leveraged to elevate privileges to root, even if the user is not listed in the sudoers file. User authentication is not required to exploit the bug.<br />Vulnerable: <= 1.8.27-1+deb10u2<br />Fixed: 1.8.27-1+deb10u3 | 4.0.0-4.2.1 | |
| <a name="2556218"></a> [2556218](#2556218) <a name="2556218"></a> <br />CM-33117 | The following vulnerability affects lldpd:<br />CVE-2020-27827: A packet that contains multiple instances of certain TLVs will cause lldpd to continually allocate memory and leak the old memory.  As an example, multiple instances of system name TLV will cause old values to be dropped by the decoding routine.<br />Fixed: 1.0.4-0-cl4.3.0u2 | 3.7.14-4.2.1 | |
| <a name="2556215"></a> [2556215](#2556215) <a name="2556215"></a> <br />CM-33115 | When you run any of the vtysh <code>show bgp ipv4</code> or <code>show bgp ipv6</code> statistics commands, the <code>bgpd</code> service crashes. | 4.2.1 | |
| <a name="2556012"></a> [2556012](#2556012) <a name="2556012"></a> <br />CM-32994 | On Broadcom switches, after repeated VLAN or VXLAN configuration changes, <code>switchd</code> memory might not free up appropriately, which can lead to a crash.  | 3.7.14, 4.0.0-4.2.1 | |
| <a name="2555761"></a> [2555761](#2555761) <a name="2555761"></a> <br />CM-32860 | The following vulnerabilities were announced in the p11-kit (libp11-kit0) packages:<br />CVE-2020-29361: Multiple integer overflows have been discovered in the array allocations in the p11-kit library and the p11-kit list command, where overflow checks are missing before calling realloc or calloc.<br />CVE-2020-29362: A heap-based buffer over-read has been discovered in the RPC protocol used by thep11-kit server/remote commands and the client library. When the remote entity supplies a byte array through a serialized PKCS#11 function call, the receiving entity may allow the reading of up to 4 bytes of memory past the heap allocation.<br />CVE-2020-29363: A heap-based buffer overflow has been discovered in the RPC protocol used by p11-kit server/remote commands and the client library. When the remote entity supplies a serialized byte array in a CK_ATTRIBUTE, the receiving entity may not allocate sufficient length for the buffer to store the deserialized value.<br />Vulnerable: 0.23.15-2<br />Fixed: 0.23.15-2_deb10u1 | 4.0.0-4.2.1 | |
| <a name="2555691"></a> [2555691](#2555691) <a name="2555691"></a> <br />CM-32829 | The NET-SNMP-EXTEND-MIB, disabled in Cumulus Linux 4.2.1 and 3.7.14 to prevent security vulnerability CVE-2020-15862, is re-enabled read-only. | 3.7.14-4.2.1 | |
| <a name="2555589"></a> [2555589](#2555589) <a name="2555589"></a> <br />CM-32774 | You can't delete a BGP community list created with NCLU. | 4.2.1 | |
| <a name="2555532"></a> [2555532](#2555532) <a name="2555532"></a> <br />CM-32753 | QinQ (802.1Q) packets routed to a layer 3 subinterface are still double tagged with the VLAN of the subinterface and the original inner VLAN when they leave the subinterface. | 4.2.0-4.2.1 | |
| <a name="2555528"></a> [2555528](#2555528) <a name="2555528"></a> <br />CM-32750 | In an EVPN Active/Active configuration, when one of the peers reboots and begins to refresh IP neighbor entries shared by the MLAG peer, some of these ARP messages might be dropped by the MLAG peer's ARP policer.<br />To work around this issue, increase the burst value of the ARP policers to 200 or higher. | 3.7.14-4.2.1 | |
| <a name="2555506"></a> [2555506](#2555506) <a name="2555506"></a> <br />CM-32733 | CVE-2020-29479 CVE-2020-29480 CVE-2020-29481 CVE-2020-29482 CVE-2020-29483 CVE-2020-29484 CVE-2020-29485 CVE-2020-29486 CVE-2020-29566 CVE-2020-29570 CVE-2020-29571<br />Several security issues affecting Xenstore could result in cross domain access (denial of service, information leaks or privilege escalation) or denial of service against xenstored.<br />Additional vulnerabilities could result in guest-to-host denial of<br />service.<br />Vulnerable: <= 4.11.4+57-g41a822c392-1<br />Fixed: 4.11.4+57-g41a822c392-2 | 4.0.0-4.2.1 | |
| <a name="2555494"></a> [2555494](#2555494) <a name="2555494"></a> <br />CM-32728 | On Broadcom switches, when WARN level <code>switchd</code> log messages are generated, <code>switchd</code> might crash resulting in a core file generated on the system. | 3.7.14 | |
| <a name="2555484"></a> [2555484](#2555484) <a name="2555484"></a> <br />CM-32723 | <code>ospf6d</code> restarts when you run the NCLU <code>net show ospf6 databse</code> command or the vtysh <code>show ipv6 ospf6 database</code> command.  | 4.2.0-4.2.1 | |
| <a name="2555428"></a> [2555428](#2555428) <a name="2555428"></a> <br />CM-32683 | When you change the SVI <code>vlan-id</code> value in the <code>/etc/network/interfaces</code> file, then run <code>ifreload -a</code>, the 802.1Q ID for the SVI in the kernel does not change.<br />This operation is not supported in the kernel without recreating the SVI. To apply the change, run <code>ifdown</code>, then <code>ifup</code> for the SVI to recreate the interface. | 3.7.13-4.2.1 | |
| <a name="2555426"></a> [2555426](#2555426) <a name="2555426"></a> <br />CM-32681 | Broadcom switches running Cumulus Linux do not support EVPN Multihoming. When a BGP update with EVPN multihoming attributes is received, <code>switchd</code> crashes. <br />EVPN Multihoming is supported on Mellanox switches only. | 4.2.1 | |
| <a name="2555401"></a> [2555401](#2555401) <a name="2555401"></a> <br />CM-32661 | On the Edgecore AS7312 switch, eth0 and swp use the same MAC address. | 3.7.14-4.2.1 | |
| <a name="2555380"></a> [2555380](#2555380) <a name="2555380"></a> <br />CM-32647 | When you start <code>asic-monitor</code>, you might see increasing memory usage. | 4.2.1 | |
| <a name="2555373"></a> [2555373](#2555373) <a name="2555373"></a> <br />CM-32641 | CVE-2020-27350: Missing input validation in the ar/tar implementations of APT, the high level package manager, could cause out-of-bounds reads or infinite loops, resulting in denial of service when processing malformed deb files.<br />CVE-2020-27351: Various memory and file descriptor leaks were discovered in the Python interface to the APT package management runtime library, which could result in denial of service.<br />Vulnerable: apt <= 1.8.2.1, python-apt <= 1.8.4.1<br />Fixed: apt 1.8.2.2, python-apt 1.8.4.3 | 4.0.0-4.2.1 | |
| <a name="2555339"></a> [2555339](#2555339) <a name="2555339"></a> <br />CM-32622 | The following vulnerability has been announced in OpenSSL:<br />CVE-2020-1971: A flaw in the GENERAL_NAME_cmp() function could cause a NULL dereference when both GENERAL_NAMEs contain an EDIPARTYNAME, resulting in denial of service.  More information can be found at https://www.openssl.org/news/secadv/20201208.txt .<br />Vulnerable: <= 1.1.1d-0+deb10u3<br />Fixed: 1.1.1d-0+deb10u4 | 4.0.0-4.2.1 | |
| <a name="2555270"></a> [2555270](#2555270) <a name="2555270"></a> <br />CM-32592 | CVE-2020-27670 CVE-2020-27671 CVE-2020-27672 CVE-2020-27674 CVE-2020-28368: Multiple vulnerabilities have been discovered in the Xen hypervisor, which could result in denial of service, privilege escalation or information leaks.<br />Vulnerable: < 4.11.4+57-g41a822c392-1<br />Fixed: 4.11.4+57-g41a822c392-1 | 4.0.0-4.2.1 | |
| <a name="2555223"></a> [2555223](#2555223) <a name="2555223"></a> <br />CM-32554 | An EVPN route map filter matching a VNI on egress on the originating router might not set a large-community correctly:<br /><pre><br />route-map TEST-TAG permit 10<br />  match evpn vni 109001<br />  set large-community 20:20:333<br />!<br /></pre><br />To work around this issue, remove the VNI match to allow the tag to be applied on egress.<br />The VNI match works if applied at some other non-originating router either in the ingress or egress direction. | 4.2.1 | |
| <a name="2555183"></a> [2555183](#2555183) <a name="2555183"></a> <br />CM-32532 | CVE-2020-8927: A buffer overflow exists in the Brotli library versions prior to 1.0.8 where an attacker controlling the input length of a "one-shot" decompression request to a script can trigger a crash, which happens when copying over chunks of data larger than 2 GiB.  If one cannot update to a fixed version, we recommend to use the "streaming" API as opposed to the "one-shot" API, and impose chunk size limits.<br />Vulnerable: 1.0.7-2<br />Fixed: 1.0.7-2+deb10u1 | 4.0.0-4.2.1 | |
| <a name="2554992"></a> [2554992](#2554992) <a name="2554992"></a> <br />CM-32420 | When running traditional mode bridges at scale (for example, when you have more than 200 bridges and a large number of MAC addresses), MLAG bonds flap intermittently from dual to single connected, then back to dual connected, which causes a layer 2 loop and STP state changes.<br />To work around this issue, either shut down one side of the MLAG bond or prune out VLANS over the bond. | 3.7.13-4.2.1 | |
| <a name="2554982"></a> [2554982](#2554982) <a name="2554982"></a> <br />CM-32412 | CVE-2020-28196: MIT Kerberos 5 (aka krb5) before 1.17.2 and 1.18.x before 1.18.3 allows unbounded recursion via an ASN.1-encoded Kerberos message because the lib/krb5/asn.1/asn1_encode.c support for BER indefinite lengths lacks a recursion limit.<br />Vulnerable: 1.17-3<br />Fixed: 1.17-3+deb10u1 | 4.0.0-4.2.1 | |
| <a name="2554866"></a> [2554866](#2554866) <a name="2554866"></a> <br />CM-32329 | On the Mellanox SN3420 switch, 1000BaseT and 1000Base-SX/LX modules do not link up. | 4.2.1 | |
| <a name="2554834"></a> [2554834](#2554834) <a name="2554834"></a> <br />CM-32311 | CVE-2020-25709, CVE-2020-25710: Two vulnerabilities in the certificate list syntax verification and in the handling of CSN normalization were discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of these flaws to cause a denial of service (slapd daemon crash) via specially crafted packets.<br />Vulnerable: <= 2.4.47+dfsg-3+deb10u3<br />Fixed: 2.4.47+dfsg-3+deb10u4 | 4.0.0-4.2.1 | |
| <a name="2554810"></a> [2554810](#2554810) <a name="2554810"></a> <br />CM-32294 | Some non-Mellanox ethernet modules do not link up on the Mellanox SN3420 switch with Cumulus PSID in the Hardware revision. To see if a Mellanox SN3420 switch has the Cumulus PSID, check the output of <code>mlxfwmanager</code> for <code>MSN3420-CxxxC_Ax</code> in the <code>Part Number</code> Field.  A Mellanox SN3420 switch with <code>MSN3420-CxxxO_Ax</code> has an Onie PSID and is unaffected by this issue.<br />To work around this issue, use Mellanox ethernet modules with the Mellanox SN3420 switch, | 4.2.1 | |
| <a name="2554785"></a> [2554785](#2554785) <a name="2554785"></a> <br />CM-32275 | After you reboot a Broadcom switch, <code>switchd</code> might fail to restart and you see logs in <code>switchd.log</code> similar to the following:<br /><pre><br />...<br />Nov 12 12:20:05.063876 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.064310 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 0:system_init:<br />Nov 12 12:20:05.064428 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 system_init: Misc init failed: Operation timed out<br />Nov 12 12:20:05.064464 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.091995 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 LED: Loading 256 bytes into LED program memory<br />Nov 12 12:20:05.092029 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099547 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 PORT: Error: bcm ports not initialized<br />Nov 12 12:20:05.099579 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099646 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /var/lib/cumulus/rc.datapath_0: line 81 (error code -1): script terminated<br />Nov 12 12:20:05.099667 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099775 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /etc/bcm.d/rc.soc: line 70 (error code -1): script terminated<br />Nov 12 12:20:05.099798 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099871 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 ERROR loading rc script on unit 0<br />Nov 12 12:20:05.099892 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099943 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:299 CRIT loading of rc script failed, aborting!<br /></pre> | 3.7.11-4.2.1 | |
| <a name="2554730"></a> [2554730](#2554730) <a name="2554730"></a> <br />CM-32235 | In an EVPN multihoming configuration, reloading FRR causes brief traffic loss. | 4.2.1 | |
| <a name="2554711"></a> [2554711](#2554711) <a name="2554711"></a> <br />CM-32219 | On the Mellanox SN3700C switch, running <code>cl-support</code> with a large number of ports configured can cause <code>switchd</code> to crash. | 4.2.1 | |
| <a name="2554707"></a> [2554707](#2554707) <a name="2554707"></a> <br />CM-32215 | On the Dell S5048F-ON switch, optical transceivers do not come up and the modules are in reset mode. | 4.0.0-4.2.1 | |
| <a name="2554588"></a> [2554588](#2554588) <a name="2554588"></a> <br />CM-32149 | If you try reconfigure a DHCP server after you delete the switch configuration with the <code>net del all</code> command, the <code>dhcpd</code> service fails because a duplicate process is running.<br />To work around this issue, edit the <code>/usr/lib/python2.7/dist-packages/nclu/plugins/dhcp.py</code> file to change:<br /><pre><br />DHCPD_PID="-pf {0}" <br /></pre><br />to:<br /><pre><br />DHCPD_PID="-pf {1}"<br /></pre> | 3.7.13-4.2.1 | |
| <a name="2554531"></a> [2554531](#2554531) <a name="2554531"></a> <br />CM-32110 | CVE-2020-25692: A vulnerability in the handling of normalization with modrdn was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can use this flaw to cause a denial of service (slapd daemon crash) via a specially crafted packet.<br />The slapd package is not present in the image or repository, although the OpenLDAP libraries are present.<br />Vulnerable: <= 2.4.47+dfsg-3+deb10u2<br />Fixed: 2.4.47+dfsg-3+deb10u3 | 4.0.0-4.2.1 | |
| <a name="2554503"></a> [2554503](#2554503) <a name="2554503"></a> <br />CM-32086 | If the peer link does not trunk all VLANs on an MLAG bond, all FDB entries learned through that MLAG bond are not redirected over the peer link when the MLAG bond goes down. As a result,  traffic destined to the MAC addresses that arrives on the MLAG peer with the downed MLAG port is dropped.<br />To work around this issue, ensure that the peer link trunks all VLANs that exist on all MLAG bonds.<br /><br /> | 4.2.0-4.2.1 | |
| <a name="2554401"></a> [2554401](#2554401) <a name="2554401"></a> <br />CM-32030 | On the Mellanox SN4600C switch, the fan speed fluctuates when only one PSU is plugged in.<br />To work around this issue, use both PSUs. | 4.2.1 | |
| <a name="2554369"></a> [2554369](#2554369) <a name="2554369"></a> <br />CM-32006 | Certain Dell S4048-ON switches show an incorrect vendor name and hang when you issue the <code>reboot</code> command.  | 3.7.12-4.2.1 | |
| <a name="2554334"></a> [2554334](#2554334) <a name="2554334"></a> <br />CM-31982 | The INPUT chain POLICE target acts as ACCEPT instead of continue. | 4.2.1 | |
| <a name="2554307"></a> [2554307](#2554307) <a name="2554307"></a> <br />CM-31968 | The following vulnerability has been announced in freetype:<br />CVE-2020-15999: Sergei Glazunov discovered a heap-based buffer overflow vulnerability in the handling of embedded PNG bitmaps in FreeType. Opening malformed fonts may result in denial of service or the execution of arbitrary code.<br />Vulnerable: <= 2.9.1-3+deb10u1<br />Fixed: 2.9.1-3+deb10u2 | 4.0.0-4.2.1 | |
| <a name="2554292"></a> [2554292](#2554292) <a name="2554292"></a> <br />CM-31959 | With traditional bridges, a race condition occurs when Cumulus Linux tries to derive MAC addresses.<br />To work around this issue, use a static MAC address; specify a MAC address in the <code>/etc/network/interfaces</code> file under the bridge's stanza. | 4.2.1 | |
| <a name="2554282"></a> [2554282](#2554282) <a name="2554282"></a> <br />CM-31954 | A security issue was discovered in the MariaDB database server.<br />Vulnerable: 10.3.25-0<br />Fixed: 10.3.25-0+deb10u1 | 4.0.0-4.2.1 | |
| <a name="2554253"></a> [2554253](#2554253) <a name="2554253"></a> <br />CM-31942 | After upgrading the Mellanox SN2410 switch, the FAN is set to full speed. | 4.2.1 | |
| <a name="2554246"></a> [2554246](#2554246) <a name="2554246"></a> <br />CM-31936 | When you back up and restore a configuration using the conf-backup utility, the switch might hang when rebooted. | 4.1.1-4.2.1 | |
| <a name="2554131"></a> [2554131](#2554131) <a name="2554131"></a> <br />CM-31864 | CVE-2020-14355: Multiple buffer overflow vulnerabilities were found in the QUIC image decoding process of the SPICE remote display system, before spice-0.14.2-1.<br />Both the SPICE client (spice-gtk) and server are affected by these flaws. These flaws allow a malicious client or server to send specially crafted messages that, when processed by the QUIC image compression algorithm, result in a process crash or potential code execution.<br />Vulnerable: 0.14.0-1.3<br />Fixed: 0.14.0-1.3+deb10u1 | 4.0.0-4.2.1 | |
| <a name="2553953"></a> [2553953](#2553953) <a name="2553953"></a> <br />CM-31739 | On Mellanox Spectrum based switches running 4.1.0 or higher, if FORWARD chain ACLs are configured on the system, a switch port breakout action applied with a reload of the switchd service may cause switchd to crash. | 4.2.0-4.2.1 | |
| <a name="2553878"></a> [2553878](#2553878) <a name="2553878"></a> <br />CM-31697 | Multiple vulnerabilities have been discovered in the Xen hypervisor, which could result in denial of service, guest-to-host privilege escalation or information leaks.  These include the following:CVE-2020-25595, CVE-2020-25596, CVE-2020-25597, CVE-2020-25599, CVE-2020-25600, CVE-2020-25601, CVE-2020-25602, CVE-2020-25603, CVE-2020-25604.<br />Vulnerable: < 4.11.4+37-g3263f257ca-1<br />Fixed: 4.11.4+37-g3263f257ca-1 | 4.0.0-4.2.1 | |
| <a name="2553748"></a> [2553748](#2553748) <a name="2553748"></a> <br />CM-31627 | On switches with the Spectrum ASIC, the IPv6 default route is present in the kernel but missing in hardware. | 3.7.11-4.2.1 | |
| <a name="2553743"></a> [2553743](#2553743) <a name="2553743"></a> <br />CM-31623 | The next hop for static routes configured in a non-default VRF might be incorrectly flagged as inactive. Remove and reconfigure the static VRF route to recover from this condition.  | 4.2.1 | |
| <a name="2553732"></a> [2553732](#2553732) <a name="2553732"></a> <br />CM-31618 | A ping via a dual-connected bond fails, and the audio stream is not routed or encapsulated through the layer 3 VNI. | 3.7.12-3.7.13, 4.0.0-4.2.1 | |
| <a name="2553588"></a> [2553588](#2553588) <a name="2553588"></a> <br />CM-31565 | Multicast traffic on a VPN is sent to remote VTEPs that are not part of the VPN and the remote VTEPs receive multicast traffic encapsulated in a VXLAN ID that doesn't exist.<br />To work around this issue, disable IGMP snooping on the switch. | 3.7.12-3.7.13, 4.0.0-4.2.1 | |
| <a name="2553568"></a> [2553568](#2553568) <a name="2553568"></a> <br />CM-31560 | After a MAC address moves from one remote VTEP to another, the MAC address continues to point to the old VTEP IP address in hardware. | 4.1.1-4.2.1 | |
| <a name="2553530"></a> [2553530](#2553530) <a name="2553530"></a> <br />CM-31545 | In an MLAG configuration with a layer 3 VNI, when you bounce the peer link, all layer 2 VNIs listed under the layer 3 VNI are duplicated. <br />To work around this issue, restart FRR with the <code>sudo systemctl restart frr.service</code> command.<br /><br /> | 3.7.10-3.7.13, 4.1.1-4.2.1 | |
| <a name="2553468"></a> [2553468](#2553468) <a name="2553468"></a> <br />CM-31512 | Digital Optical Monitoring (DOM) Data is displayed incorrectly on SFP fiber modules inserted in the Fiberstore N8500-48B6C, Celestica Questone, and Celestica RedstoneV switches. | 4.2.0-4.2.1 | |
| <a name="2553450"></a> [2553450](#2553450) <a name="2553450"></a> <br />CM-31504 | On the the Dell N3248-PXE switch, when you insert two PSUs at different times, the newly inserted PSU is detected as OK but the fan and temp sensors are ABSENT.<br />To work around this issue, remove power to both PSUs at the same time, then reinsert power simultaneously. | 3.7.12-3.7.13, 4.2.1 | |
| <a name="2553349"></a> [2553349](#2553349) <a name="2553349"></a> <br />CM-31469 | When you delete a layer 2 VNI and VLAN, the layer 3 VNI reports an incorrect layer 2 VNI number.<br />To work around this issue, either restart FRR or delete the VNI interface first, then delete the VLAN/SVI. | 4.2.0-4.2.1 | |
| <a name="2553278"></a> [2553278](#2553278) <a name="2553278"></a> <br />CM-31441 | Leaked routes are sometimes missing from the destination VRF after a reboot. | 4.2.0-4.2.1 | |
| <a name="2553229"></a> [2553229](#2553229) <a name="2553229"></a> <br />CM-31412 | On the Dell N3248PXE switch, RJ45 fixed copper ports that auto-negotiate with a 100M or 10M neighbor incorrectly negotiate a half-duplex link that generates errors. Half duplex modes are not supported on this platform. | 3.7.12-3.7.13, 4.2.1 | |
| <a name="2553219"></a> [2553219](#2553219) <a name="2553219"></a> <br />CM-31407 | You cannot configure SNMPv3 trap-destinations in non-default VRFs with an authentication username that contains fewer than eight characters. | 3.7.12-4.2.1 | |
| <a name="2553118"></a> [2553118](#2553118) <a name="2553118"></a> <br />CM-31358 | The Dell 100G-LR4 (Innolight) transceiver cannot link up due to a power budget exceeded error on the Mellanox SN4600C switch. | 4.2.0-4.2.1 | |
| <a name="2552939"></a> [2552939](#2552939) <a name="2552939"></a> <br />CM-31263 | RX_DRP on a bond interface increases without any data traffic while the slave port does not increase. | 3.7.12-4.2.1 | |
| <a name="2552881"></a> [2552881](#2552881) <a name="2552881"></a> <br />CM-31238 | IPv6 TCP or UDP connections (sourcing from an ephemeral port in the range 34048 to 35071) are not forwarded if the switch has more than one layer 2 VNI defined. The traffic might be locally switched on the bridge and dropped. <br />To work around this issue, disable ARP/ND suppression to remove the internal ACL rule that affects the ports. | 3.7.13, 4.2.1 | |
| <a name="2552869"></a> [2552869](#2552869) <a name="2552869"></a> <br />CM-31231 | On the Dell N3048EP switch, the module information from SFP ports is not displayed in the <code>l1-show</code> command.<br />To work around this issue, use the <code>ethtool -m <interface></code> command. | 3.7.13-4.2.1 | |
| <a name="2552742"></a> [2552742](#2552742) <a name="2552742"></a> <br />CM-31150 | On the Mellanox SN2410 switch, you see <code>switchd</code> core and <code>GBIN_MALLOC</code> errors.<br />To work around this issue, restart <code>switchd</code>. | 3.7.12-4.2.1 | |
| <a name="2552710"></a> [2552710](#2552710) <a name="2552710"></a> <br />CM-31125 | The MLAG bonds on a secondary switch do not change to a unique MAC address on the peerlink. As a result, a backup double failure can occur where both peers go down. | 4.2.0-4.2.1 | |
| <a name="2552687"></a> [2552687](#2552687) <a name="2552687"></a> <br />CM-31107 | When you boot Cumulus VX 4.2 for the first time, ZTP does not execute because it thinks that the <code>/etc/shadow</code> file has been modified. This is due to the default password change implemented in CL 4.2.<br />To work around this issue, boot the switch, manually change the password, then run <code>sudo ztp -R</code> to reset the ZTP script. | 4.2.0-4.2.1 | |
| <a name="2552528"></a> [2552528](#2552528) <a name="2552528"></a> <br />CM-31028 | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | |
| <a name="2552354"></a> [2552354](#2552354) <a name="2552354"></a> <br />CM-30916 | On the Mellanox SN4700 switch, you might see _Bad signal integrity_ issues on 200G and 400G ports. | 4.2.1 | |
| <a name="2551873"></a> [2551873](#2551873) <a name="2551873"></a> <br />CM-30555 | If you have an existing community list of any type, redefining the same sequence number results in the entire community list being deleted.<br />To work around this issue, delete the community list sequence before trying to adjust it. | 4.2.0-4.2.1 | |
| <a name="2551748"></a> [2551748](#2551748) <a name="2551748"></a> <br />CM-30514 | In OVSDB high availability mode, deleting > 200 VLAN bindings might cause <code>ovs-vtepd</code> to crash.  Limit the deletion to 200 or fewer VLAN bindings. | 3.7.12-3.7.13, 4.0.0-4.2.1 | |
| <a name="2551687"></a> [2551687](#2551687) <a name="2551687"></a> <br />CM-30485 | When you run <code>cl-ecmpcalc</code> to determine a hardware hash result, tests might fail. | 4.2.0-4.2.1 | |
| <a name="2551422"></a> [2551422](#2551422) <a name="2551422"></a> <br />CM-30361 | On Mellanox switches with the Spectrum-2 switch, the lpm-balanced forwarding profile does not work. | 4.1.1-4.2.1 | |
| <a name="2551187"></a> [2551187](#2551187) <a name="2551187"></a> <br />CM-30247 | dot1qVlanIndex in the dot1qVlanStaticTable of the SNMP Q-BRIDGE-MIB does not use VLAN ID and does not comply with RFC 4363. | 4.1.1-4.2.1 | |
| <a name="2551124"></a> [2551124](#2551124) <a name="2551124"></a> <br />CM-30231 | When the dynamic or static flag on a bridge fdb (MAC) entry is changed to the opposite state, the new flag is not set appropriately in hardware. This can allow a static fdb entry to be unexpectedly learned dynamically on a different interface, or can prevent a dynamic entry from being updated or learned elsewhere.<br />This condition can occur during a manual replacement of a local MAC address or when EVPN updates a dynamic MAC address to add or remove the Sticky Mac flag. Either situation results in the MAC address keeping the original flag in hardware.<br />To work around this issue, delete or withdraw the fdb entry, then add the static MAC address directly. For example:<br /><pre><br />bridge fdb del 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master<br />bridge fdb add 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master &#91; static \| dynamic &#93;<br /></pre><br />If you are unable to delete an EVPN-learned remote MAC address, you can replace the dynamic MAC address with a local static one, then delete the static MAC address. For example:<br /><pre><br />bridge fdb replace 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master static<br />bridge fdb del 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master<br />bridge fdb add 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master &#91; static \| dynamic &#93;<br /></pre> | 4.0.0-4.2.1 | |
| <a name="2550973"></a> [2550973](#2550973) <a name="2550973"></a> <br />CM-30194 | After you enable ROCE with the <code>net add interface <switch-port> storage-optimized pfc</code> command, you cannot verify the command because it is not shown in the <code>net show config</code> command output. | 4.1.1-4.2.1 | |
| <a name="2550918"></a> [2550918](#2550918) <a name="2550918"></a> <br />CM-30164 | The <code>/usr/share/zoneinfo/leap-seconds.list</code> file expires periodically and results in log messages being generated about that expiration.<br />To work around this issue, you must update the file from https://www.ietf.org/timezones/data/leap-seconds.list or upgrade the <code>tzdata</code> package to the newest version. | 4.0.0-4.2.1 | |
| <a name="2550906"></a> [2550906](#2550906) <a name="2550906"></a> <br />CM-30159 | After you delete a bond, the deleted bond members have the deleted bond MAC address instead of their original MAC address, which might result in traffic being discarded. <br />To work around this issue, perform a full switch restart. | 4.1.1-4.2.1 | |
| <a name="2550796"></a> [2550796](#2550796) <a name="2550796"></a> <br />CM-30103 | On a Broadcom switch with the Trident2+ ASIC, ACL rules for VLANs are not applied after a reboot and the counters remain at zero.<br />To work around this issue, either do not set <code>acl.non_atomic_update_mode = TRUE</code> in the <code>/etc/cumulus/switchd.conf</code> file or run the <code>cl-acltool -i</code> command after the reboot to install the  ACLs. | 3.7.12-4.2.1 | |
| <a name="2550479"></a> [2550479](#2550479) <a name="2550479"></a> <br />CM-29899 | VXLAN interface as in-interface or out-interface in an ACL is not supported in Spectrum-based switches. | 3.7.7-4.2.0 | |
| <a name="2550375"></a> [2550375](#2550375) <a name="2550375"></a> <br />CM-29838 | CPU utilization may increase when clag-managed bond interfaces are operationally/LACP down but the physical carrier remains up on the bond member switchports. This condition occurs when clag bond redirection is enabled and bond members remain up while the parent bond does not negotiate LACP.<br /><br />This issue is resolved in Cumulus Linux 3.7.14. | 3.7.9-3.7.13, 4.0.0-4.2.1 | |
| <a name="2550348"></a> [2550348](#2550348) <a name="2550348"></a> <br />CM-29829 | Due to a known limitation, DHCPv6 snooping is not supported on Mellanox platforms.<br />Please refer the Mellanox support case | 4.2.0-4.2.1 | |
| <a name="2550276"></a> [2550276](#2550276) <a name="2550276"></a> <br />CM-29779 | In LLDP, the <code>snmp</code> subagent loses all subsequent <code>lldpRemSysName</code> (1.0.8802.1.1.2.1.4.1.1.9) entries after an entry with a missing SysName is added.<br />All the information from <code>lldpctl</code> is correct. Only the entries after the entry that is missing a SysName in <code>lldpRemSysName</code> disappear from the <code>snmp</code> subagent. | 3.7.12-4.2.1 | |
| <a name="2549838"></a> [2549838](#2549838) <a name="2549838"></a> <br />CM-29546 | In vtysh, if you configure, then remove a layer 3 VNI for a VRF, the VNI is removed from zebra even if the VNI interface still exists in the kernel.<br />If you configure a layer 2 VNI as a layer 3 VNI by mistake, removing the layer 3 VNI binding removes it from zebra but EVPN-learned MACs and neighbors are not installed into the kernel.<br />To work around this issue, delete, then re-add the missing VNI. For example:<br /><pre><br />cumulus&#64;switch:~$ sudo ifdown vni10100<br />cumulus&#64;switch:~$ sudo ifup vni10100<br /></pre><br />If you flap the link with the <code>ip link set vni10100 down; ip link set vni10100 up</code> commands, zebra does not re-add the VNI. | 3.7.12-4.2.1 | |
| <a name="2549784"></a> [2549784](#2549784) <a name="2549784"></a> <br />CM-29520 | On Mellanox switches, when the networking service and <code>switchd</code> starts up, a rare condition might occur where <code>switchd</code> crashes and the following log message is generated:<br /><pre><br /><code>CRIT backend/mlx/hal_mlx_nexthop.c:294: hal_mlx_ecmp_data_reinit: Assertion '(num_next_hops)' failed.</code><br /></pre> | 4.1.0-4.2.1 | |
| <a name="2549226"></a> [2549226](#2549226) <a name="2549226"></a> <br />CM-29259 | You might see the following <code>gport</code> error messages in <code>switchd.log</code>:<br /><pre><br />2020-04-10T19:50:01.011224+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x800007a find failed<br />2020-04-10T19:50:01.011631+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x8000009 find failed<br /></pre><br />These messages are harmless and can be ignored. | 3.7.12-4.2.1 | |
| <a name="2548930"></a> [2548930](#2548930) <a name="2548930"></a> <br />CM-29148 | On MLX switches that contain an OSPF IP unnumbered neighborship with a high scale of prefixes being learned, a link flap might cause the neighbor entry to not be programmed in hardware. | 3.7.11-4.2.1 | |
| <a name="2548672"></a> [2548672](#2548672) <a name="2548672"></a> <br />CM-29043 | When a multipath route that contains an EVPN path exists together with an IPv4 BGP path in the VRF, the RMAC to VTEP binding is incorrect. This invalid entry occurs because Cumulus Linux treats IPv4 routes received over the eBGP IPv4 peering incorrectly in the VRF.<br />To work around this issue, remove the unnecessary eBGP IPv4 peering. | 3.7.12-4.2.1 | |
| <a name="2548485"></a> [2548485](#2548485) <a name="2548485"></a> <br />CM-28940 | If you configure <code>aggregate-address <address> summary-only</code> before a component of the same aggregate is injected into the BGP table with the <code>network</code> or <code>redistribute</code> command, when you remove the <code>aggregate-address</code> configuration, the component stays suppressed; it is not advertised to peers. For example:<br />Existing configuration:<br /><pre><br />router bgp 1<br /> address-family ipv4 unicast<br />  aggregate-address 50.0.0.0/8 summary-only<br /> exit-address-family<br /></pre><br />If you add <code>network 50.0.0.1/32</code>, you see the following (expected) BGP table entries:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />*> 50.0.0.0         0.0.0.0                            32768 i<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />Removing <code>aggregate-address 50.0.0.0/8 summary-only</code> at this point results in the following (unexpected) BGP table entry:<br /><pre><br />Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />To work around this issue, remove, then re-add the component prefix routes. | 3.7.12-4.2.1 | |
| <a name="2548408"></a> [2548408](#2548408) <a name="2548408"></a> <br />CM-28891 | <code>net show configuration commands</code> does not show the RoCE <code>net add interface <swp> storage-optimized pfc</code> configuration. | 4.1.0-4.2.1 | |
| <a name="2543647"></a> [2543647](#2543647) <a name="2543647"></a> <br />CM-26137 | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre><br />-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre> | 3.7.6-4.2.1 | |
| <a name="2534978"></a> [2534978](#2534978) <a name="2534978"></a> <br />CM-21055 | On the Mellanox switch, the destination MAC address of ERSPAN GRE packets is set to all zeros; therefore, the first transit switch might drop packets. | 4.0.0-4.2.1 | |

