---
title: Cumulus Linux 5.0 Release Notes
author: NVIDIA
weight: -30
product: Cumulus Linux
version: "5.0"
toc: 1
type: rn
pdfhidden: True
---
<a href="/cumulus-linux-43/rn.xls"><img src="/images/xls_icon.png" height="20px" width="20px" alt="Download 4.3 Release Notes xls" /></a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="/cumulus-linux-43/rn.xls">Download all 4.3 release notes as .xls</a>
## 4.3.0 Release Notes
### Open issues in 4.3.0

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="CM-33283"></a> [CM-33283](#CM-33283) <a name="CM-33283"></a> | DSA-4850-1 (no CVE): libzstd adds read permissions to files while being compressed or uncompressed.<br/>Vulnerable: 1.3.8+dfsg-3<br/>Fixed: 1.3.8+dfsg-3+deb10u1 | 4.0.0-4.3.0 | |
| <a name="CM-33262"></a> [CM-33262](#CM-33262) <a name="CM-33262"></a> | When you change a VRR MAC address, the associated virtual interface goes down.<br/>To work around this issue, run the `ip link set <virtual-interface> up` command or bounce the SVI. | 4.2.1-4.3.0 | |
| <a name="CM-33258"></a> [CM-33258](#CM-33258) <a name="CM-33258"></a> | Cumulus Linux does not support bond members at 200G or greater. | 4.0.0-4.3.0 | |
| <a name="CM-33240"></a> [CM-33240](#CM-33240) <a name="CM-33240"></a> | On the on the Mellanox SN2410 switch, when you restart `switchd` or reboot the system, you see the following error messages:<br /><pre>&#91; 1446.599850&#93; switch 2-0048: HW semaphore is not released<br />&#91; 1446.605828&#93; switch 2-0048: Cmd exec failed (opcode=40(ACCESS_REG),opcode_mod=0,in_mod=0,status=30(BAD_PKT))<br />&#91; 1446.616378&#93; switch 2-0048: Reg cmd access failed (reg_id=9002(mfsc),type=write)<br />&#91; 1446.624365&#93; switch 2-0048: Failed to write PWM duty<br /></pre><br />This is a cosmetic issue and does not affect operation of the switch. | 4.3.0 | |
| <a name="CM-33237"></a> [CM-33237](#CM-33237) <a name="CM-33237"></a> | CVE-2020-36221, CVE-2020-36222, CVE-2020-36223, CVE-2020-36224, CVE-2020-36225, CVE-2020-36226, CVE-2020-36227, CVE-2020-36228, CVE-2020-36229, CVE-2020-36230:  Several vulnerabilities were discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of these flaws to cause a denial of service (slapd daemon crash, infinite loops) via specially crafted packets.<br/>Vulnerable: <= 2.4.47+dfsg-3+deb10u4<br/>Fixed: 2.4.47+dfsg-3+deb10u5 | 4.0.0-4.3.0 | |
| <a name="CM-33196"></a> [CM-33196](#CM-33196) <a name="CM-33196"></a> | If you use NCLU to configure an ACL for eth0, you can't designate it as an INPUT rule; the rule is automatically created as a FORWARD rule in the `/etc/cumulus/acl/policy.d/50_nclu_acl.rules` file.<br/>To work around this issue, manually create an ACL in the `/etc/cumulus/acl/policy.d/` file with "-A INPUT -i eth0". | 4.2.1-4.3.0 | |
| <a name="CM-33185"></a> [CM-33185](#CM-33185) <a name="CM-33185"></a> | In vtysh you can enable and disable debugs from either exec mode or global configuration mode (config t). When disabling OSPF debugs from exec mode, the debug is disabled at runtime but left in the running-configuration.<br/>To work around this issue, disable OSPF debugs from global configuration mode (config t). | 4.2.1-4.3.0 | |
| <a name="CM-33167"></a> [CM-33167](#CM-33167) <a name="CM-33167"></a> | On the Mellanox SN4700 switch, if you use the CREDO CABLE with a 4x100 configuration, the system experiences issues accessing the ASIC Thermal sensors. | 4.3.0 | |
| <a name="CM-33139"></a> [CM-33139](#CM-33139) <a name="CM-33139"></a> | On a Mellanox switch, the `cl-resource-query -j` command takes a long time to run with the max acl-heavy or ip-acl-heavy profile. | 4.3.0 | |
| <a name="CM-33112"></a> [CM-33112](#CM-33112) <a name="CM-33112"></a> | The MTU size configured under a layer 2 VNI interface is not applied for VXLAN traffic. | 4.2.1-4.3.0 | |
| <a name="CM-33050"></a> [CM-33050](#CM-33050) <a name="CM-33050"></a> | The NCLU `net del vrf` command does not delete a numbered VRF. For example:<br /><pre>cumulus&#64;leaf01:~$ net del vrf 55<br />ERROR: Command not found<br /></pre><br /> | 4.2.1-4.3.0 | |
| <a name="CM-33049"></a> [CM-33049](#CM-33049) <a name="CM-33049"></a> | You cannot set the time zone can with NCLU commands. | 4.1.1-4.3.0 | |
| <a name="CM-33035"></a> [CM-33035](#CM-33035) <a name="CM-33035"></a> | EAP-TLS fail on wired connections when the reachability to the RADIUS server does not use the eth0 (mgmt) VRF interface. | 4.2.1-4.3.0 | |
| <a name="CM-33032"></a> [CM-33032](#CM-33032) <a name="CM-33032"></a> | On Edgecore AS4610 switches, the historic CPU usage displayed in `/run/sysmonitor/history` is sometimes shown as a negative value.  | 3.7.12-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="CM-32953"></a> [CM-32953](#CM-32953) <a name="CM-32953"></a> | On Mellanox switches, you can't ping the SVI of the MLAG peer over the peer link after the packet is VXLAN decapsulated. | 4.2.1-4.3.0 | |
| <a name="CM-32951"></a> [CM-32951](#CM-32951) <a name="CM-32951"></a> | When the EVPN primary IP address and advertise SVI IP address options are both configured, the SVI ARP is not forwarded between MLAG switches. | 4.2.1-4.3.0 | |
| <a name="CM-32914"></a> [CM-32914](#CM-32914) <a name="CM-32914"></a> | On Mellanox switches, egress ACLs with VLAN keys do not filter layer 2 multicast or broadcast traffic. | 4.3.0 | |
| <a name="CM-32861"></a> [CM-32861](#CM-32861) <a name="CM-32861"></a> | The NCLU `net del bgp neighbor` command does not delete the neighbor and displays an error similar to the following:<br /><pre>ERROR: --- /run/nclu/frr/frr.conf.scratchpad.baseline   2021-01-04 17:23:59.250463331 +0000<br />+++ /run/nclu/frr/frr.conf.scratchpad    2021-01-04 17:25:59.213673980 +0000<br /></pre><br />To work around this issue, use the FRR command to delete a neighbor. | 4.3.0 | |
| <a name="CM-32786"></a> [CM-32786](#CM-32786) <a name="CM-32786"></a> | The `net show configuration commands` command incorrectly displays the NCLU syntax to disable IPv6 forwarding on interfaces. For example:<br /><pre># net show configuration commands<br />net add vlan 1 ip6-forward off <br /></pre><br />The correct NCLU command to disable IPv6 forwarding is `net add vlan 1 ipv6 forward off` (without the hyphen). | 4.2.1-4.3.0 | |
| <a name="CM-32612"></a> [CM-32612](#CM-32612) <a name="CM-32612"></a> | If you try to enable BGP graceful restart when it is already enabled, you see an error similar to the following in the `frr.log` file:<br /><pre>2020-12-07T19:20:26.004333+00:00 cumulus bgpd&#91;4954&#93;: VRF default: Handle GR command GLOBAL_GR_CMD, current GR state GLOBAL_GR, new GR state GLOBAL_INVALID<br /></pre><br />This error has no functional impact. | 4.3.0 | |
| <a name="CM-32588"></a> [CM-32588](#CM-32588) <a name="CM-32588"></a> | On the Mellanox SN2700 and SN2410 switch, the MTEF-PSF-AC-I and MTEF-PSR-AC-I PSUs incorrectly show 460W instead of the correct 550W. This is a cosmetic issue that does not affect the actual wattage or throughput of the power supplies. | 4.3.0 | |
| <a name="CM-32545"></a> [CM-32545](#CM-32545) <a name="CM-32545"></a> | If the FRR and MSTP processes go down, an SNMP TRAP is not generated even with the following configuration in the `/etc/snmp/snmpd.conf` file. <br /><pre>proc watchfrr<br />proc mstpd<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRRis down!!!” PrErrorFlag.5 != 0<br />monitor -I -r 1 -o prNames.5 -o prErrMessage.5 “Process FRR is up!!!” PrErrorFlag.5 = 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is down!!!!" prErrorFlag.3 != 0<br />monitor -I -r 1  -o prNames.3 -o prErrMessage.3  "Process mstpd is up!!!!" prErrorFlag.3 = 0<br /></pre><br /> | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-32516"></a> [CM-32516](#CM-32516) <a name="CM-32516"></a> | When using NCLU to add new BGP neighbors to existing configurations, the existence of address-family statements are ignored and the neighbors are added at the end of these lines. This might cause a problem if you try to activate these new neighbors in any of the existing address-family configurations.<br/>To work around this issue, configure the new BGP neighbors with vtysh. | 3.7.14-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="CM-32416"></a> [CM-32416](#CM-32416) <a name="CM-32416"></a> | The `ethtool` utility doesn't contain the latest values, as a result the `Revision Compliance` field shows `Unallocated`.  | 4.2.1-4.3.0 | |
| <a name="CM-32296"></a> [CM-32296](#CM-32296) <a name="CM-32296"></a> | If the RMAC of a layer 3 SVI changes, the `show vrf vni` command is not updated with the new value. However, the new RMAC is seen in the `show evpn vni` command and is present on self-originated EVPN routes. | 4.2.1-4.3.0 | |
| <a name="CM-32286"></a> [CM-32286](#CM-32286) <a name="CM-32286"></a> | On the Mellanox SN3700C switch, PIM multicast packets are duplicated at the egress VTEP. | 4.2.0-4.3.0 | |
| <a name="CM-32274"></a> [CM-32274](#CM-32274) <a name="CM-32274"></a> | If you apply an outbound route map to a BGP peer that uses `set as-path prepend last-as`, advertised locally-originated routes have the ASN of the peer prepended to the AS path.<br/>This might trigger AS path loop prevention on the peer, where the peer ignores locally-originated prefixes. | 4.2.1-4.3.0 | |
| <a name="CM-32217"></a> [CM-32217](#CM-32217) <a name="CM-32217"></a> | The IP address specified in the `ip pim use-source` command configured on the loopback interface should be inherited by unnumbered interfaces during their Primary IP address selection process.  If `ip pim use-source` is configured on the loopback after an unnumbered interface has already selected their Primary IP address, the unnumbered interface does not update its Primary IP address to be the new use-source value until after there is a netlink update for that interface.<br/>To work around this issue, configure `ip pim use-source` on each unnumbered interface directly or ensure `ip pim use-source` is applied to the loopback before other unnumbered interfaces are enabled for PIM. | 3.7.13-3.7.14.2, 4.2.1-4.3.0 | |
| <a name="CM-32169"></a> [CM-32169](#CM-32169) <a name="CM-32169"></a> | OpenSSH is vulnerable to CVE-2020-14145, as described in <a href="https://www.fzi.de/fileadmin/user_upload/2020-06-26-FSA-2020-2.pdf" class="external-link" rel="nofollow">https://www.fzi.de/fileadmin/user_upload/2020-06-26-FSA-2020-2.pdf</a>.  <br/>This is an information leak in algorithm negotiation that can allow man-in-the-middle attacks on initial connection attempts without a previously stored server host key on the client. If desired, mitigation using UpdateHostKeys and HostKeyAlgorithms is also given in that paper. | 3.0.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-32144"></a> [CM-32144](#CM-32144) <a name="CM-32144"></a> | On switches with the Maverick ASIC, control traffic is dropped due to receive buffering. | 4.2.0-4.3.0 | |
| <a name="CM-32112"></a> [CM-32112](#CM-32112) <a name="CM-32112"></a> | On the ARM platform, NTP peer associations slowly increase to larger offsets (~500ms). | 4.0.0-4.3.0 | |
| <a name="CM-32068"></a> [CM-32068](#CM-32068) <a name="CM-32068"></a> | Kernel routes added by `iproute2` are missing in FRR after an interface flap.<br/>To work around this issue, configure a static route in FRR. | 4.2.1-4.3.0 | |
| <a name="CM-32055"></a> [CM-32055](#CM-32055) <a name="CM-32055"></a> | During a graceful restart of a peer router, if the link between the local system (Helper) and the restarting router flaps, the stale routes announced by the restarting router are no longer used for forwarding by the Helper router even though they remain in the BGP RIB. | 4.3.0 | |
| <a name="CM-31962"></a> [CM-31962](#CM-31962) <a name="CM-31962"></a> | In a VRRP configuration, BGP unnumbered sessions for VRFs fail to establish after a networking restart. | 4.2.0-4.3.0 | |
| <a name="CM-31928"></a> [CM-31928](#CM-31928) <a name="CM-31928"></a> | On the Mellanox SN3700C switch, `hwmon` fails to collect information and show errors similar to the following:<br /><pre>2020-10-01T17:48:09.558200+09:00 &#91;sn3700c1&#93;&#91;kernel&#93;&#91;err&#93; &#91;25666.121068&#93; mlxsw_minimal 2-0048: Could not acquire lock<br />2020-10-01T17:48:09.558200+09:00 &#91;sn3700c1&#93;&#91;kernel&#93;&#91;err&#93; &#91;25666.127069&#93; mlxsw_minimal 2-0048: Reg cmd access failed (reg_id=900a(mtmp),type=query)<br />2020-10-01T17:48:10.554707+09:00 &#91;sn3700c2&#93;&#91;kernel&#93;&#91;err&#93; &#91;25160.069404&#93; mlxsw_minimal 2-0048: Could not acquire lock<br />2020-10-01T17:48:10.554707+09:00 &#91;sn3700c2&#93;&#91;kernel&#93;&#91;err&#93; &#91;25160.075393&#93; mlxsw_minimal 2-0048: Reg cmd access failed (reg_id=900f(mtbr),type=query)<br />2020-10-01T17:48:10.554707+09:00 &#91;sn3700c2&#93;&#91;kernel&#93;&#91;err&#93; &#91;25160.084265&#93; hwmon hwmon7: Failed to query module temperature sensor<br /></pre><br /> | 4.2.1-4.3.0 | |
| <a name="CM-31921"></a> [CM-31921](#CM-31921) <a name="CM-31921"></a> | The NCLU command to enable bridge learning fails.<br/>As a work around, enable bridge learning in the `/etc/network/interface` file. For example:<br /><pre>auto vni-30<br />iface vni-30<br />    vxlan-id 30<br />    bridge-access 30<br />    bridge-arp-nd-suppress on<br />    bridge-learning on<br />    vxlan-local-tunnelip 10.10.10.1<br />    mstpctl-bpduguard yes<br />    mstpctl-portbpdufilter yes<br />    mtu 9166<br /></pre><br /> | 4.2.1-4.3.0 | |
| <a name="CM-31917"></a> [CM-31917](#CM-31917) <a name="CM-31917"></a> | MLAG packets received on the peer link are dropped instead of routed. | 4.2.0-4.3.0 | |
| <a name="CM-31904"></a> [CM-31904](#CM-31904) <a name="CM-31904"></a> | The output of the `net show commit` command does not show the last commit or the specified commit number but is empty instead. | 4.2.1-4.3.0 | |
| <a name="CM-31605"></a> [CM-31605](#CM-31605) <a name="CM-31605"></a> | When you configure an SNMPv3 user with the `net-snmp-config` configuration command from the `libsnmp-dev` package, you get an error message similar to the one below:<br /><pre>cumulus&#64;switch:mgmt-vrf:~$ sudo net-snmp-config --create-snmpv3-user -a shaauthpass -x aesprivpass -A SHA -X AES userSHAwithAES<br />adding the following line to /var/lib/snmp/snmpd.conf:           <br />   createUser userSHAwithAES SHA "shaauthpass" AES "aesprivpass"       <br />adding the following line to /snmp/snmpd.conf:                           <br />   rwuser userSHAwithAES                                           <br />touch: cannot touch ‘/snmp/snmpd.conf’: No such file or directory<br />/usr/bin/net-snmp-create-v3-user: 144: /usr/bin/net-snmp-create-v3-user: cannot create /snmp/snmpd.conf: Directory nonexistent<br /></pre><br />To work around this issue, use the NCLU command to configure SNMPv3 user parameters; for example:<br /><pre>cumulus&#64;switch:mgmt-vrf:~$ net add snmp-server username user999 auth-md5 user999password encrypt-des user999encryption<br /></pre><br />Alternatively, directly edit the `/etc/snmp/snmpd.conf` file as described in the documentation. | 3.7.13-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-31418"></a> [CM-31418](#CM-31418) <a name="CM-31418"></a> | The default NTP configuration is to use eth0 as the NTP source interface. In Cumulus Linux 4.0 and later, eth0 is in the management VRF by default; therefore the NTP service runs automatically in the management VRF. <br/>NVIDIA does not recommend running NTP with a source interface other than eth0 as this can expose a security vulnerability. Changing the NTP source interface name with NCLU to a non-management VRF interface might result in NTP not functioning because the NTP service is still running in the management VRF. | 4.2.0-4.3.0 | |
| <a name="CM-31414"></a> [CM-31414](#CM-31414) <a name="CM-31414"></a> | On the Mellanox SN4700 switch, 8x50G port breakout is not supported currently. | 4.2.1-4.3.0 | |
| <a name="CM-31404"></a> [CM-31404](#CM-31404) <a name="CM-31404"></a> | On the Delta AG7648 switch, the System LED and the Power LED do not display correctly. | 3.7.13-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-31327"></a> [CM-31327](#CM-31327) <a name="CM-31327"></a> | After you manually edit the `/etc/resolv.conf` file to change or remove a VRF for a given DNS server, `ifreload` does not remove IP rules created for DNS servers in the VRF. <br/>To work around this issue, run the `net add/del dns nameserver vrf <name>` command to force the DNS configuration. | 3.7.13-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="CM-31300"></a> [CM-31300](#CM-31300) <a name="CM-31300"></a> | If a neighbour contains a special character in PortID for LLDP, the `net show interface` command does not display the LLDP information or the command might fail. | 3.7.10-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="CM-31111"></a> [CM-31111](#CM-31111) <a name="CM-31111"></a> | On the EdgeCore AS4610 switch, the eth0 interface remains down when physically connected to a 1G interface.<br/>To work around this issue, configure the link speed to 1000 and set auto-negotiation on for the eth0 interface, then flap eth0 with the `ip link set eth0 down/up` command to bring up the port. | 4.2.0-4.3.0 | |
| <a name="CM-30987"></a> [CM-30987](#CM-30987) <a name="CM-30987"></a> | On the Mellanox switch, RoCE with PFC configuration is not applied to all ports in hardware when a range is used in the `traffic.conf` file.<br/>To work around this issue, use NCLU to configure RoCE with PFC or list individual ports in the `traffic.conf` file. | 4.2.0-4.3.0 | |
| <a name="CM-30879"></a> [CM-30879](#CM-30879) <a name="CM-30879"></a> | NCLU restarts FRR when removing a BGP VRF IPv4 aggregate-address command. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-30863"></a> [CM-30863](#CM-30863) <a name="CM-30863"></a> | OpenSSH scp is vulnerable to CVE-2020-15778, where clients that have authorized access to the SSH server can execute commands on the server by copying maliciously named files.<br/>The two scenarios where an exploit may be useful to an attacker:<br/>-The user is authorized to `scp` but not `ssh` (based on the `command` option in the `authorized_keys` file), so this vulnerability can allow executing a remote command on the target computer when not authorized to do so.<br/>-An attacker plants a maliciously named file in a directory tree that someone later uses `scp -r` to copy over to the target computer.<br/>Be aware that restricting users to `scp` by using the `command` option in the `authorized_keys` file is not effective in preventing those users from executing arbitrary commands on the server.<br/>If you want to use `scp -r` to copy directory trees, avoid copying directory trees to which attackers may have added maliciously-named files. Archiving the directory tree with `tar`, `zip`, or a similar program, then copying the archive over to be extracted on the server avoids having to use `scp -r` altogether. In addition, OpenSSH provides `sftp`, which you can use instead of `scp` to copy files.<br/>To disable scp completely, use `/bin/chmod 0 /usr/bin/scp` . | 3.0.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-30473"></a> [CM-30473](#CM-30473) <a name="CM-30473"></a> | If you modify an interface name, then reuse the previous interface name for a different VLAN, the `ifreload -a` command generates an error similar to the following:<br /><pre>warning: <interface-name>: interface not recognized - please check interface configuration<br /></pre><br /> | 4.1.0-4.3.0 | |
| <a name="CM-30422"></a> [CM-30422](#CM-30422) <a name="CM-30422"></a> | When you configure a bridge in the `/etc/network/interfaces` file, then try to reconfigure the bridge to be a VRF interface with the same name, `ifreload`/`ifup` commands fail with an `invalid table id` or `unable to get vrf table id` error. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-30414"></a> [CM-30414](#CM-30414) <a name="CM-30414"></a> | If you toggle VRRP priority values between VRRP routers, then run a `switchd` restart, a few IPv6 VRRP instances might not converge. As a result, both the VRRP routers act as <em>master</em> routers for the impacted IPv6 VRRP instances. IPv4 VRRP instances are not affected.<br/>To work around this issue, remove, then add the VRRP configuration with NCLU commands or vtysh in FRR. | 3.7.13-3.7.14.2, 4.2.0-4.3.0 | |
| <a name="CM-30312"></a> [CM-30312](#CM-30312) <a name="CM-30312"></a> | When TACACS+ is configured and the management VRF is enabled, users with privilege level 13 are prevented from running `ip` and `cat` commands. | 4.0.0-4.3.0 | |
| <a name="CM-30296"></a> [CM-30296](#CM-30296) <a name="CM-30296"></a> | The `net show configuration` command provides the wrong `net add` command for ACL under the VLAN interface. | 3.7.12-3.7.14.2, 4.1.0-4.3.0 | |
| <a name="CM-30280"></a> [CM-30280](#CM-30280) <a name="CM-30280"></a> | On a Mellanox SN2010 switch, the Locator LED is on after you upgrade Cumulus Linux. | 4.1.0-4.3.0 | |
| <a name="CM-30195"></a> [CM-30195](#CM-30195) <a name="CM-30195"></a> | On the Dell S3000 switch, after installing the Cumulus Linux 4.1.1 disk image without a license, the switch sends a link beat if a remote host port is configured. | 3.7.11-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="CM-30182"></a> [CM-30182](#CM-30182) <a name="CM-30182"></a> | The `net show time ntp servers` command does not show any output with management VRF. | 4.1.1-4.3.0 | |
| <a name="CM-30165"></a> [CM-30165](#CM-30165) <a name="CM-30165"></a> | When you use a phone with EAP and voice VLAN is configured (<b>and MAB is not configured</b>), after the phone authenticates, all tagged traffic from the phone is dropped.<br/>To work around this issue, enable MAB on the interface. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-30101"></a> [CM-30101](#CM-30101) <a name="CM-30101"></a> | The NCLU `net show bridge spanning-tree` command displays the aging timer incorrectly.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-30089"></a> [CM-30089](#CM-30089) <a name="CM-30089"></a> | Cumulus Linux supports a maximum of 300 ACLs for use with 802.1X interfaces. This limit encompasses the default ACLs, pre-auth ACLs and dynamic ACLs. Exceeding this limit can affect the performance of the switch. | 4.1.0-4.3.0 | |
| <a name="CM-30052"></a> [CM-30052](#CM-30052) <a name="CM-30052"></a> | Configuring the subinterface of a VXLAN uplink under another traditional bridge, which also has the VXLAN VNI enslaved, causes `switchd` to use high CPU due to very frequent VXLAN tunnel sync events.<br/>To work around this issue, do not enslave the subinterface of a VXLAN layer 3 uplink under a traditional bridge in a VXLAN configuration. | 4.1.1-4.3.0 | |
| <a name="CM-29890"></a> [CM-29890](#CM-29890) <a name="CM-29890"></a> | Multiple paths to identical EVPN prefixes are either not displayed or not accepted into the l2vpn evpn table if they are received from a different AS. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="CM-29872"></a> [CM-29872](#CM-29872) <a name="CM-29872"></a> | Tab completion for the `net show rollback description` command returns information about a snapshot instead of context help.<br/>To work around this issue, run the `net show commit history` command to find descriptions instead of the `net show rollback description` command. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-29871"></a> [CM-29871](#CM-29871) <a name="CM-29871"></a> | The `net show rollback description <string>` command returns an error even if the string matches a commit description.<br/>To work around this issue, look for your string in the output of the `net show commit history` command (or grep for it there) instead. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-29667"></a> [CM-29667](#CM-29667) <a name="CM-29667"></a> | After installing Cumulus Linux on the Mellanox SN2100 switch, if you break out a port (for example, if you break out swp1 into four ports: swp1s0, swp1s1, swp1s2, swp1s3) in the `/etc/cumulus/ports.conf` file, then run the `systemctl start switchd` command, the update does not take effect.<br/>To work around this issue, run the `systemctl restart switchd` command. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-29652"></a> [CM-29652](#CM-29652) <a name="CM-29652"></a> | The ACCTON-DIAG option under the Cumulus Linux GRUB menu does not work. When you select this option, you see the following error:<br /><pre>error: invalid signature.<br />Press any key to continue...<br /></pre><br /> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="CM-29594"></a> [CM-29594](#CM-29594) <a name="CM-29594"></a> | When you run an Ansible script to replace the `/etc/network/interfaces` file, then run the `ifreload -a` command, you see errors similar to the following:<br /><pre>error: swp1s1.2: netlink: cannot set link swp1s1.2 up: operation failed with 'Network is down' (100)<br />warning: cmd '/bin/ip addr del 10.0.0.1/24 dev eth0' failed: returned 2 (RTNETLINK answers: Cannot assign requested address<br /></pre><br />To work around this issue,  run the `ifreload -a` command a second time. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-29562"></a> [CM-29562](#CM-29562) <a name="CM-29562"></a> | If you have an SVI with multiple VRR IP addresses and try to delete one of the VRR configurations, `net commit` or `ifreload -a` returns an error. | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="CM-29519"></a> [CM-29519](#CM-29519) <a name="CM-29519"></a> | The JSON format output of the `net show bgp l2vpn evpn summary` command shows the incorrect neighbour state.  | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-29492"></a> [CM-29492](#CM-29492) <a name="CM-29492"></a> | When you create SPAN or ERSPAN rules in ebtables, the action fails to install if it is not in lowercase. Make sure that the SPAN or ERSPAN action is all lowercase; for example:<br /><pre>&#91;ebtables&#93;<br />-A FORWARD --in-interface swp10 -j span --dport swp1<br /></pre><br /> | 3.7.12-3.7.14.2, 4.1.1-4.3.0 | |
| <a name="CM-29319"></a> [CM-29319](#CM-29319) <a name="CM-29319"></a> | When you configure an RD or RT with NCLU, you see duplicate VNI stanzas in the `/etc/frr/frr.conf` file. <br/>To work around this issue, manually edit the `etc/frr/frr.conf` file to define `advertise-all-vni` before the RD or RT configuration within the l2vpn EVPN address family, then reload the FRR service with the `sudo systemctl reload frr` command. | 4.1.0-4.3.0 | |
| <a name="CM-29309"></a> [CM-29309](#CM-29309) <a name="CM-29309"></a> | When Optimized Multicast Flooding (OMF) is enabled with the `bridge.optimized_mcast_flood = TRUE` setting in the `/etc/cumulus/switchd.conf` file, the switch continues to flood IPv6 multicast traffic to all slave ports when there is no MLD join receive. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-29146"></a> [CM-29146](#CM-29146) <a name="CM-29146"></a> | On the EdgeCore Minipack AS8000, storm control does not restrict unknown unicast, broadcast, or multicast traffic. | 4.1.1-4.3.0 | |
| <a name="CM-28816"></a> [CM-28816](#CM-28816) <a name="CM-28816"></a> | The following security advisory has been announced for bash: <br/>CVE-2019-18276 Qualys scan QID 372268 setuid vulnerability<br/>When bash or bash scripts are run setuid, bash is supposed to drop privileges, but does so incorrectly, so that an attacker with command access to the shell can use `enable -f` for runtime loading of a new builtin that calls `setuid()` to regain dropped privileges.<br/>To work around this issue, do not make bash or bash scripts `setuid`. | 3.0.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-28770"></a> [CM-28770](#CM-28770) <a name="CM-28770"></a> | The `net add routing route-map <name> permit <seq> set community <comm>` command does not add the set statement into the `/etc/frr/frr.conf` file. | 4.0.0-4.3.0 | |
| <a name="CM-28754"></a> [CM-28754](#CM-28754) <a name="CM-28754"></a> | On switches with the Trident2+ ASIC, adding SPAN rules disables PBR rules. | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-28613"></a> [CM-28613](#CM-28613) <a name="CM-28613"></a> | In EVPN Active-Active (MLAG) environments, rebooting one member of an MLAG pair should result in the local MAC mobility sequence number reverting to 0. Sometimes a reboot of one MLAG peer results in the local MAC mobility sequence number being set to a non-zero value despite that no more mobility events occur. This issue is cosmetic only, as BGP does not advertise the incorrect sequence number and forwarding entries correctly point to the remote VTEP where the MAC is now located. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-28611"></a> [CM-28611](#CM-28611) <a name="CM-28611"></a> | In an EVPN Active-Active (MLAG) environment, sometimes a local-to-remote MAC mobility event results in the local sequence number appearing higher than the remote sequence number in zebra. This issue is cosmetic only, as BGP does not advertise the incorrect sequence number and forwarding entries correctly point to the remote VTEP where the MAC is now located. | 3.7.12-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-28497"></a> [CM-28497](#CM-28497) <a name="CM-28497"></a> | QinQ across VXLAN on a traditional bridge does not work. | 4.1.0-4.3.0 | |
| <a name="CM-28489"></a> [CM-28489](#CM-28489) <a name="CM-28489"></a> | The following CVEs were announced for rsyslog:<br/>CVE-2019-17041 CVE-2019-17042rsyslogd, when receiving remote log messages (not enabled by default on Cumulus Linux) with the pmaisforwardedfrom or pmcisconames optional log parsers (also not enabled by default on Cumulus Linux), is vulnerable to CVE-2019-17041 and CVE-2019-17042 where malicious messages that appear to be from AIX or Cisco respectively may be caused to skip sanity checks, resulting in incorrect negative lengths causing heap overflows.<br/>Vulnerable: 8.1901.0-1Recommendation:Do not enable receiving syslog messages from other hosts by the network (with $UDPServerRun or $InputTCPServerRun).  Also, do not enable (with $ModLoad) the vulnerable parsers pmaixforwardedfrom or pmcisconames.  The default /etc/rsyslog.conf file on Cumulus Linux does not enable any of these. | 4.0.0-4.3.0 | |
| <a name="CM-28458"></a> [CM-28458](#CM-28458) <a name="CM-28458"></a> | NCLU incorrectly allows you to configure port security on bond/MLAG interfaces.<br/>Port security is not supported on bond/MLAG interfaces. | 4.0.0-4.3.0 | |
| <a name="CM-28393"></a> [CM-28393](#CM-28393) <a name="CM-28393"></a> | On the Dell S5232F-ON switch, EVPN and dynamic VRF route leaking results in the CPU forwarding traffic to newly-learned type-2 routes.<br/>To work around this issue, restart FRR. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-28249"></a> [CM-28249](#CM-28249) <a name="CM-28249"></a> | On the Mellanox switch, when you modify the buffer and queue configuration without restarting `switchd`, you might see a one second interruption in forwarding. | 4.0.0-4.3.0 | |
| <a name="CM-28226"></a> [CM-28226](#CM-28226) <a name="CM-28226"></a> | When you restart the `hsflowd` service, you see a `systemd` warning message similar to the following:<br /><pre>Warning: The unit file, source configuration file or drop-ins of hsflowd&#64;mgmt.service changed on disk. Run 'systemctl daemon-reload'.<br /></pre><br /> | 4.0.0-4.3.0 | |
| <a name="CM-28080"></a> [CM-28080](#CM-28080) <a name="CM-28080"></a> | TACACS+ through ClearPass is not currently supported. Cumulus Linux sends authorization before authentication, but ClearPass does not accept an authorization before the user is authenticated. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-28003"></a> [CM-28003](#CM-28003) <a name="CM-28003"></a> | The FRR service does not provide a way for automation to know if the configuration applied properly.<br/>To work around this issue, execute the `vtysh -f <file>` command in the automation file before starting the FRR service to validate the functional configuration and return an error code. | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-27957"></a> [CM-27957](#CM-27957) <a name="CM-27957"></a> | If you have configured a higher number of ports and VLANs (ports x VLANs) or the switch is a lower-powered (CPU) platform, the `switchd` service might fail to send a `systemd keepalive` within the watchdog timeout value (2 minutes by default) and you see an error similar to the following:<br /><pre>bq. systemd&#91;1&#93;: switchd.service watchdog timeout (limit 2min)!<br /></pre><br />To workaround this issue, either reduce the number of configured interfaces and, or VLANs, or increase the `systemd` timeout for `switchd.service`.<br/>To increase the `systemd` timeout:<ol>	<li>Edit the `/etc/systemd/system/switchd.service.d/override.conf` file and increase the `WatchdogSec` parameter.</li>	<li>Restart the `switchd` service with the `sudo systemctl restart switchd.service` command.<br/>`systemd` will attempt to restart the `switchd` service automatically (after the watchdog timeout). If the restart fails multiple times in a short time period, run the `sudo systemctl reset-failed` command followed by the `sudo systemctl restart switchd` command.</li></ol> | 3.7.11-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-27950"></a> [CM-27950](#CM-27950) <a name="CM-27950"></a> | On the Dell S5232F, S5248F, S5296F, and S3048 switch, using the `poweroff` or `halt` commands does not fully power off the switch. | 4.0.0-4.3.0 | |
| <a name="CM-27642"></a> [CM-27642](#CM-27642) <a name="CM-27642"></a> | The following CVEs were announced that affect the libssh package:<br/>CVE-2019-14889 has been announced in the libssh library, where unsanitized user-provided scp command lines could allow an attacker to execute arbitrary commands on the server.<br/>The libssh library is not installed on Cumulus Linux by default, but is available in the Cumulus Linux 4 repository for optional installation. Note that libssh is distinct from libssh2 and openssh, which are present on the switches and in the repositories.<br/>See the following for more information:<br/><a href="https://www.libssh.org/security/advisories/CVE-2019-14889.txt" class="external-link" rel="nofollow">https://www.libssh.org/security/advisories/CVE-2019-14889.txt</a><br/><a href="https://security-tracker.debian.org/tracker/CVE-2019-14889" class="external-link" rel="nofollow">https://security-tracker.debian.org/tracker/CVE-2019-14889</a> | 4.0.0-4.3.0 | |
| <a name="CM-27444"></a> [CM-27444](#CM-27444) <a name="CM-27444"></a> | If you use the NCLU commands to configure NTP and run the `net add time ntp source <interface>` command before you run the `net add time ntp server <server> iburst` command, the `/etc/ntp.conf` file is misconfigured.<br/>To work around this issue, run the `net add time ntp server <server> iburst` command before you run the `net add time ntp source <interface>` command. | 3.7.10-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="CM-27243"></a> [CM-27243](#CM-27243) <a name="CM-27243"></a> | The length of the netlink message is not set properly for non-bridge family type messages. The same length is used for both bridge and non-bridge even though the bridge family type message has an extra attribute. This causes extra bytes to be left over in non-bridge family type netlink messages. | 3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="CM-27143"></a> [CM-27143](#CM-27143) <a name="CM-27143"></a> | On the Dell S5248F-ON switch, the CPU core temperature sensors show `ABSENT`. | 4.0.0-4.3.0 | |
| <a name="CM-27099"></a> [CM-27099](#CM-27099) <a name="CM-27099"></a> | On the Mellanox switch with the Spectrum-2 ASIC, Precision Time Protocol (PTP) is not currently supported.  | 4.0.0-4.3.0 | |
| <a name="CM-27094"></a> [CM-27094](#CM-27094) <a name="CM-27094"></a> | On the Delta AG9032v1 switch, smonctl and sensors report inaccurate PSU current and power. | 3.5.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-27018"></a> [CM-27018](#CM-27018) <a name="CM-27018"></a> | If you configure more than one VRR interface on an SVI interface, deleting one of the VRR addresses does not remove the interface/address.  | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26942"></a> [CM-26942](#CM-26942) <a name="CM-26942"></a> | Port security is not currently supported on VX. The NCLU commands produce errors. | 4.0.0-4.3.0 | |
| <a name="CM-26921"></a> [CM-26921](#CM-26921) <a name="CM-26921"></a> | If you delete an undefined bond, then add a bond slave, the `net commit` command fails. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26913"></a> [CM-26913](#CM-26913) <a name="CM-26913"></a> | FRR configuration commands for an SVI interface might have the `\n` misplaced in the output.  For example:<br /><pre>sudo sh -c "printf 'interface 50\nvrf TEST description L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />should be:<br /><pre>sudo sh -c "printf 'interface 50 vrf TEST\ndescription L3 routing interface\n' >> /etc/frr/frr.conf"<br /></pre><br />To work around this issue, configure the interface manually in the `/etc/frr/frr.conf` file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26907"></a> [CM-26907](#CM-26907) <a name="CM-26907"></a> | NCLU incorrectly allows you to apply port security configuration on layer 2 and layer 3 ports that are not part of a bridge. | 4.0.0-4.3.0 | |
| <a name="CM-26905"></a> [CM-26905](#CM-26905) <a name="CM-26905"></a> | When you update the hostname of a switch with the NCLU `net add hostname <hostname>` command, then run `net commit`, the `lldpd` service does not restart and other devices still see the old hostname.<br/>To work around this issue, run the `sudo systemctl restart lldpd.service` command. | 3.7.10-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26860"></a> [CM-26860](#CM-26860) <a name="CM-26860"></a> | When you run the NCLU `net show commit last` or `net show commit <number>` command, where `<number>` is the last commit, no output is shown.  | 4.0.0-4.3.0 | |
| <a name="CM-26769"></a> [CM-26769](#CM-26769) <a name="CM-26769"></a> | Setting ProtoDown on ports populated with SFP modules providing RJ-45 1000BASE-T interfaces does not cause the carrier to be dropped. The kernel shows carrier down; however, the remote device still shows a link. | 3.7.6-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="CM-26599"></a> [CM-26599](#CM-26599) <a name="CM-26599"></a> | Auto-negotiation does not work with the QSFP28 cables and a remote system operating at 10G. Attempting to enable auto-negotiation with `ethtool -s swp<#> autoneg on` returns `Operation not supported`.<br/>To work around this issue, do not use auto-negotiation and set the local port speed to 10G. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26595"></a> [CM-26595](#CM-26595) <a name="CM-26595"></a> | The NCLU `net show lldp` command displays the speed of a ganged port group as the speed of one of the individual links, rather than the sum of their speeds. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26516"></a> [CM-26516](#CM-26516) <a name="CM-26516"></a> | Applying a policy-based routing (PBR) rule for all traffic from a host might disrupt ARP refresh for that connected host. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26423"></a> [CM-26423](#CM-26423) <a name="CM-26423"></a> | NCLU requires you to specify an interface with multiple `address-virtual` statements in ascending MAC address order.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26412"></a> [CM-26412](#CM-26412) <a name="CM-26412"></a> | Mac learning is not disabled by default on a double tagged peer link interface resulting in the MAC address changing between the MLAG bond and the peer link.<br/>To work around this issue, disable MAC learning on QinQ VLANs by adding `bridge-learning off` to the VLAN stanza in the `etc/network/interfaces` file. | 3.7.9-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26308"></a> [CM-26308](#CM-26308) <a name="CM-26308"></a> | An interface alias configured outside FRR using `iproute2` is imported into the FRR running configuration and overrides the internal description. After an FRR reload, this causes FRR to delete the interface alias in an inefficient way. Depending on how many interfaces with aliases you have configured, this can cause a FRR reload to time out.<br/>To work around this issue, remove the interface alias description from `iproute2`. | 3.7.8-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="CM-26288"></a> [CM-26288](#CM-26288) <a name="CM-26288"></a> | On the Mellanox switch, static VXLAN tunnels incorrectly allow traffic from any remote tunnel IP address. | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26256"></a> [CM-26256](#CM-26256) <a name="CM-26256"></a> | The `net show evpn vni detail json` command includes an extra empty dictionary at the end of the output.  | 3.7.8-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-26241"></a> [CM-26241](#CM-26241) <a name="CM-26241"></a> | On the Dell S5248F-ON switch, `smond` might generate syslog messages indicating that the fan input RPM is lower than the normal low speed of 2500 RPM. Speeds as low as 1700 RPM are acceptable in normal thermal environments; therefore, you can ignore these messages. | 3.7.6-3.7.11, 4.0.0-4.3.0 | 3.7.12-3.7.14|
| <a name="CM-26217"></a> [CM-26217](#CM-26217) <a name="CM-26217"></a> | NCLU does not allow you to configure OSPF NSSAs. For example: <br /><pre>cumulus&#64;switch:~$ net add ospf area 0.0.0.1 nssa <br />ERROR: Command not found. <br />net add ospf area 0.0.0.1 nssa<br /></pre><br />To work around this issue, use FRR instead. For example: <br /><pre>switch# configure terminal <br />switch(config)# router ospf <br />switch(config-router)# area 0.0.0.1 nssa <br /></pre><br /> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="CM-26179"></a> [CM-26179](#CM-26179) <a name="CM-26179"></a> | If a hostname contains utf-8 characters, the NCLU `net show lldp` command outputs the following error: <br /><pre>ERROR: 'ascii' codec can't encode character u'\xe9' in position 3: ordinal not in range(128) <br />See /var/log/netd.log for more details.  <br /></pre><br /> | 3.7.7-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="CM-26136"></a> [CM-26136](#CM-26136) <a name="CM-26136"></a> | In an ebtables rule, ERSPAN (upper case) does not work. You need to specify erspan (lower case). | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-25890"></a> [CM-25890](#CM-25890) <a name="CM-25890"></a> | In some cases, the `switchd` service might warn of excessive MAC moves from one switch port to itself (for example, from swp18 to swp18). | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-25859"></a> [CM-25859](#CM-25859) <a name="CM-25859"></a> | The MTU of an SVI cannot be higher than the MTU on the bridge. Changing the MTU on the SVI with NCLU does not update the bridge MTU. The `net commit` command succeeds even though the MTU is not changed as expected.<br/>To work around this issue, change the MTU on all SVIs and the bridge manually in the `/etc/network/interfaces` file, then apply the change with the `ifreload -a` command. | 3.7.7-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-25815"></a> [CM-25815](#CM-25815) <a name="CM-25815"></a> | When an SVI with a virtual MAC is configured with a layer 2 VNI in an EVPN environment, if you replace the `/etc/network/interfaces` file with a different file that does not have the SVI and layer 2 VNI configuration, the original virtual MAC is not populated through the EVPN route until FRR is restarted.  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-25740"></a> [CM-25740](#CM-25740) <a name="CM-25740"></a> | On the Broadcom Maverick switch with a QinQ configuration, the packets coming into the CPU might be tagged incorrectly; for example, 802.1ad + 802.1q tags are expected in the packets but the packets have 802.1q + 802.1q tags. <br/>To work around this issue, configure the bridge with `bridge-vlan-protocol 802.1ad`: <br /><pre>cumulus&#64;switch:~$ net add bridge mybridge vlan-protocol 802.1ad <br /></pre><br />  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-25694"></a> [CM-25694](#CM-25694) <a name="CM-25694"></a> | If a packet is policed by ebtables, it does not increment an ACL drop on the ingress interface. Instead, it increments the TDBGC3/6 drop counter to the CPU. | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-25674"></a> [CM-25674](#CM-25674) <a name="CM-25674"></a> | On Mellanox switches, policer iptables are not working as expected. For example, when using a policer with mode KB/MB/GB to rate-limit interfaces, the syntax is accepted but the data plane transfer speed is not affected by the rule.  | 3.7.6-3.7.8, 4.0.0-4.3.0 | 3.7.9-3.7.14|
| <a name="CM-25400"></a> [CM-25400](#CM-25400) <a name="CM-25400"></a> | If an SVI exists in the configuration before you assign it an IP address, when you do assign the IP address with the NCLU command, the `vlan-id` and the raw-device bridge stanzas are not added automatically.  | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-25397"></a> [CM-25397](#CM-25397) <a name="CM-25397"></a> | When first creating a bond and enslaving an interface, NCLU hides some of the bridge command suggestions, although they are still accepted.  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24894"></a> [CM-24894](#CM-24894) <a name="CM-24894"></a> | The `maximum-prefix` configuration under the IPv4 address family has an optional restart value, which you can configure. This configuration is ignored and, instead of restarting the sessions every x minutes, the peer constantly changes between established and idle due to the prefix count being exceeded.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24799"></a> [CM-24799](#CM-24799) <a name="CM-24799"></a> | On switches with the Trident2 ASIC, 802.1Q-encapsulated control plane traffic received on an interface with 802.1AD configured subinterfaces might be dropped. <br/>This issue only affects QinQ configurations.  | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24652"></a> [CM-24652](#CM-24652) <a name="CM-24652"></a> | In an EVPN environment, the centralized MAC address is not installed on the MLAG pair because Cumulus Linux does not perform an SVI MAC check per VLAN. <br/>This issue does not affect a pure distributed routing (symmetric or asymmetric) environment or a pure centralized routing environment. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24618"></a> [CM-24618](#CM-24618) <a name="CM-24618"></a> | If the interface alias contains a single or double quotation mark, or an apostrophe, the `net show configuration` commands fail with the following error:  <br /><pre>  ERROR: No closing quotation  See /var/log/netd.log for more details.  </pre><br />  | 3.6.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24473"></a> [CM-24473](#CM-24473) <a name="CM-24473"></a> | SNMP incorrectly requires engine ID specification.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24435"></a> [CM-24435](#CM-24435) <a name="CM-24435"></a> | When you use NCLU to configure a route map, the parser allows for glob matching of interfaces for a <em>match interface</em> condition when there can only be a single interface matched. The proper syntax is to use multiple route map clauses, each matching a single interface, instead of a single clause matching multiple interfaces. <br/> For example, this command is incorrect:  <br /><pre>  net add routing route-map Proxy-ARP permit 25 match interface swp9-10  </pre><br />  These commands are correct:  <br /><pre>  net add routing route-map Proxy-ARP permit 25 match interface swp9  net add routing route-map Proxy-ARP permit 30 match interface swp10  </pre><br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24426"></a> [CM-24426](#CM-24426) <a name="CM-24426"></a> | NCLU allows for the configuration of addresses on VRF interfaces, but tab completion for the `net add vrf <name>` command just displays <ENTER>. For example:  <br /><pre> <br /> cumulus&#64;switch:~$ net add vrf mgmt <br /> <ENTER> <br /> </pre><br />  Tab completion for the `net add vrf <name> ip address <address>` command works correctly.  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24379"></a> [CM-24379](#CM-24379) <a name="CM-24379"></a> | On the Maverick switch, CPU forwarded packets might be dropped when there is no route to a leaked host route. | 3.7.5-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24343"></a> [CM-24343](#CM-24343) <a name="CM-24343"></a> | The `net del bridge bridge mcsnoop yes` command does not return the value to the default of disabled. <br/>To work around this issue, use the `net add bridge bridge mcsnoop no` command to delete the `mcsnoop attribute` and return to the default value. | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24332"></a> [CM-24332](#CM-24332) <a name="CM-24332"></a> | On the Broadcom switch, when moving configuration from bridged to routed (or toggling from routed to bridged to routed), some traffic is not seen by the kernel. This can cause BGP to not establish on a transit node.  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24272"></a> [CM-24272](#CM-24272) <a name="CM-24272"></a> | When you try to configure the VRRP priority and advertisement-interval with NCLU on a traditional mode bridge, the `net commit` command fails. <br/> To work around this issue, use the vtysh command (inside FRR) to change the VRRP priority or advertisement-interval on traditional bridges. For example:  <br /><pre>  cumulus&#64;switch:~$ sudo vtysh  switch# configure terminal  switch(config)# interface br0.100  switch(config-if)# vrrp 1 priority 110  switch(config-if)# vrrp 1 advertisement-interval  switch(config-if)# end  switch# write memory  switch# exit  cumulus&#64;switch:~  </pre><br />  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24271"></a> [CM-24271](#CM-24271) <a name="CM-24271"></a> | On SVIs in a VLAN-aware bridge, you cannot change the VRRP priority with NCLU. <br/> To work around this issue, run the vtysh command inside FRR to change the default priority. For example:  <br /><pre>  cumulus&#64;switch:~$ sudo vtysh  switch# configure terminal  switch(config)# interface vlan100  switch(config-if)# vrrp 1 priority 110  switch(config-if)# end  switch# write memory  switch# exit  cumulus&#64;switch:~  </pre><br />  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24270"></a> [CM-24270](#CM-24270) <a name="CM-24270"></a> | Cumulus Linux uses VRRPv3 as the default version, and enables both preempt and accept mode by default. You cannot change these default values with NCLU. <br/>To work around this issue, run the vtysh commands (inside FRR) to change the default values. For example:  <br /><pre>  cumulus&#64;switch:~$ sudo vtysh  switch# configure terminal  switch(config)# interface swp4  switch(config-if)# vrrp 1 version 2  switch(config-if)# no vrrp 1 preempt  switch(config-if)# end  switch# write memory  switch# exit  cumulus&#64;switch:~  </pre><br />  | 3.7.4-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24262"></a> [CM-24262](#CM-24262) <a name="CM-24262"></a> | NCLU does not honor `auto all` in the `/etc/network/interfaces` file and removes the existing configuration if no individual `auto <iface>` lines exist.  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24241"></a> [CM-24241](#CM-24241) <a name="CM-24241"></a> | When you try to remove a BGP peer group configuration with NCLU, the command fails but no warning message is shown. For example: <br /><pre> <br />cumulus&#64;switch:~$ net del bgp neighbor fabric peer-group<br />'router bgp 65001' configuration does not have 'neighbor fabric peer-group' <br /></pre><br />  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24222"></a> [CM-24222](#CM-24222) <a name="CM-24222"></a> | When an LDAP user that does not have NCLU privileges (either in the `netshow` or `netedit` group, or in the `/etc/netd.conf` file) runs an NCLU command, a traceback occurs instead of a permissions error.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-24035"></a> [CM-24035](#CM-24035) <a name="CM-24035"></a> | On the Edgecore 4610-54P switch, automatic medium-dependent interface crossover (auto-MDIX) stops working on a 100M full duplex interface and does not detect the required cable connection type.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-23825"></a> [CM-23825](#CM-23825) <a name="CM-23825"></a> | The `net add interface <interface> ptm-enable` command adds `no ptm-enable` for that interface in the `frr.conf` file. <br/> Running the `net add` or the `net del` command does not remove `no ptm-enable` from the `frr.conf` file. You have to remove it manually using vtysh.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-23665"></a> [CM-23665](#CM-23665) <a name="CM-23665"></a> | NCLU automatically adds the VLAN ID (for the layer 3 VNI/SVI) to the bridge when you run `net add vxlan <layer3-vni> bridge access <vlan>`. This configuration breaks network connectivity in an EVPN symmetric routing configuration using MLAG. <br/>To restore connectivity, remove the VLAN ID from the bridge.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-23661"></a> [CM-23661](#CM-23661) <a name="CM-23661"></a> | On the Mellanox switch, when you configure a GRE tunnel, the traffic behind the local tunnel endpoint destined through the GRE tunnel is software-forwarded.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-23651"></a> [CM-23651](#CM-23651) <a name="CM-23651"></a> | In an EVPN symmetric routing configuration, when an IP address is frozen, kernel neighbor table information and kernel VRF routing table information about the frozen IP address might be out-of-sync.  | 3.7.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-23584"></a> [CM-23584](#CM-23584) <a name="CM-23584"></a> | When you configure a control plane ACL to define permit and deny rules destined to the local switch, NCLU programs the control plane ACL rules into the FORWARD chain.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-23570"></a> [CM-23570](#CM-23570) <a name="CM-23570"></a> | On an RMP/1G-T switch, when you remove `link-speed 100` with the NCLU command or by editing the `etc/network/interfaces` file to revert the 100M interface to the default (1G auto), the interface fails to recover and does not come back up.<br/>After you remove the link-speed, `ethtool` shows the advertised link modes as not reported and Speed/Duplex as unknown.<br/>To work around this issue and bring the interface back up, either restart `switchd` or use ethtool to configure the speed, advertised, duplex or MDI-X settings. <br/>Note: The advertised link mode gets set incorrectly if you include 1000baseT/Half. The port will come up successfully at 1G. | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-23418"></a> [CM-23418](#CM-23418) <a name="CM-23418"></a> | For QSFP modules, the `sudo ifdown` command does not disable the Tx laser.  | 3.7.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-23417"></a> [CM-23417](#CM-23417) <a name="CM-23417"></a> | If you use NCLU to create an iBGP peering across the peer link, running the `net add bgp l2vpn evpn neighbor peerlink.4094 activate` command creates a new eBGP neighborship when one has already been configured for iBGP. This is unexpected; the existing iBGP configuration is valid.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-23311"></a> [CM-23311](#CM-23311) <a name="CM-23311"></a> | In an EVPN centralized routing configuration, where the layer 2 network extends beyond VTEPs, (for example, a host with bridges), the gateway MAC address does not get refreshed in the network when ARP suppression is enabled on the gateway.<br/>To work around this issue, disable ARP suppression on the centralized gateway. | 4.0.0-4.3.0 | |
| <a name="CM-23075"></a> [CM-23075](#CM-23075) <a name="CM-23075"></a> | There is a limitation on the number of SVI interfaces you can specify as DHCP relay interfaces in the `/etc/default/isc-dhcp-relay` file. For example, 1500 SVI interfaces causes the `dhcrelay` service to exit without a core file and logs similar to the following are generated for the interfaces:  <br /><pre>  2018-11-10T23:35:30.992370-08:00 Dev dhcrelay: Listening on LPF/vlan.101/a0:00:00:00:00:51  2018-11-10T23:35:30.993472-08:00 Dev dhcrelay: Sending on LPF/vlan.101/a0:00:00:00:00:51  </pre><br />  Eventually the `dhcrelay` service stops.  | 3.7.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-22554"></a> [CM-22554](#CM-22554) <a name="CM-22554"></a> | If you try to bring down several members of a bond remotely at the same time, the link state of one of the interfaces might not transition correctly to the down state; however, all links show down in hardware.  | 3.6.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-22386"></a> [CM-22386](#CM-22386) <a name="CM-22386"></a> | The BFD packet redirection logic used by OVSDB server high availability mode redirects BUM packets across the peer link. The iptables rule for redirection does differentiate between BFD and non-BFD VXLAN inner packets because the service node sends all frames with its own IP address as the tunnel source IP address. The VXLAN encapsulated BUM packets do not get forwarded to the CPU and do not go through the iptable redirection rule; only VXLAN encapsulated BFD packets get forwarded to the CPU due to the inner MAC DA lookup in hardware.  | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-22301"></a> [CM-22301](#CM-22301) <a name="CM-22301"></a> | For an unresolved address, the IPROUTER default policer rule has been modified to <em>not</em> match on packets exiting a TUNNEL and headed to the CPU to resolve the address via ARP. As a result, the following default rule no longer matches TUNNEL ingress packets.  <br /><pre>  A $INGRESS_CHAIN --in-interface $INGRESS_INTF -m addrtype --dst-type  IPROUTER -j POLICE --set-mode pkt --set-rate 400 --set-burst 100  </pre><br />  These packets are now policed by catch all rules. <br/> To work around this issue, the VPORT value on a TRIDENT switch must be changed from binary 011 to 100.  | 3.6.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-22287"></a> [CM-22287](#CM-22287) <a name="CM-22287"></a> | On the EdgeCore AS7712 (Tomahawk) switch running in atomic mode, when a layer 3 ECMP path is brought down, traffic traversing the path stops working for about four seconds. When the switch is changed to non-atomic mode, the delay is less than one second. This issue is seen across OSPF and static ECMP routes.  | 3.6.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-22228"></a> [CM-22228](#CM-22228) <a name="CM-22228"></a> | On switches with the Trident 2+ ASIC, counters associated with VLANs and VRFs are not working. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-22041"></a> [CM-22041](#CM-22041) <a name="CM-22041"></a> | At a high CPU transmit traffic rate (for example, if there is unexpected CPU generated flooding or replication in software), when the ASIC packet driver cannot keep up with the transmit rate because there are no free DMA buffers, it can back pressure by suspending the switch port transmit queues. This can fill up the application socket buffers resulting in `No buffer space available` error messages on protocol sockets.<br/>When the driver recovers, it automatically resumes the transmit queues. In most cases these error messages are transient. In rare cases, the hardware queues might get stuck, which you can recover with a `switchd` restart. | 3.4.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-22020"></a> [CM-22020](#CM-22020) <a name="CM-22020"></a> | On the Trident3 switch, static PIM with IIF based on a layer 2 bridge does not work reliably. PIM Join via signaling is required for IPMC to work properly.<br/>To work around this issue, use dynamic signaling (joins) to manage IP multicast traffic. | 3.7.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21785"></a> [CM-21785](#CM-21785) <a name="CM-21785"></a> | The source address of the ICMPv6 time exceeded message (traceroute hop) is sourced from the wrong VRF when the traceroute target resides on the same switch but in a different VRF. | 3.6.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21678"></a> [CM-21678](#CM-21678) <a name="CM-21678"></a> | On a Dell switch with a Maverick ASIC, NetQ might receive false alerts like the following via PagerDuty:  <div class="code panel" style="border-width: 1px;"><div class="codeContent panelContent"><pre class="code-java">  cumulus&#64;<span class="code-keyword">switch</span>:~$ netq show sensors temp changes \| grep absent \| grep -v psu  P2Leaf01 temp9 networking asic die temp sensor absent 43 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s  P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to find driver path: /cumulu Add 7d:22h:1m:41s  P2Leaf01 temp6 networking asic die temp sensor absent 47 105 100 5 Unable to read temp4_highest Add 9d:23h:26m:6s  P2Leaf01 temp6 networking asic die temp sensor absent 45 105 100 5 Unable to read temp4_highest Add 14d:22h:46m:45s  </pre><br />  This message might occur as a result of a timeout at the hardware level, or the switch might be reporting a failure to get a response.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21667"></a> [CM-21667](#CM-21667) <a name="CM-21667"></a> | FRR does not add BGP `ttl-security` to either the running configuration or to the `/etc/frr/frr.conf` file when configured on a peer group instead of a specific neighbor. <br/>To work around this issue, add `ttl-security` to individual neighbors instead of the peer group. | 3.6.1-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-21278"></a> [CM-21278](#CM-21278) <a name="CM-21278"></a> | The `net show lldp` command sometimes shows the port description in the `Remote Port` field. The `net show interface` command shows the correct value in the `Remote Host` field.<br/>To work around this issue, use `net show interface` command for LLDP output when connected to Cisco equipment. | 3.5.3-3.7.10, 4.0.0-4.3.0 | 3.7.11-3.7.14|
| <a name="CM-20813"></a> [CM-20813](#CM-20813) <a name="CM-20813"></a> | Span rules matching the out-interface as a bond do not mirror packets. | 3.6.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-20508"></a> [CM-20508](#CM-20508) <a name="CM-20508"></a> | The Cumulus-Resource-Query-MIB defines the ability to gather buffer utilization status but when these objects are polled, they return nothing.  | 3.5.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-20033"></a> [CM-20033](#CM-20033) <a name="CM-20033"></a> | The VLAN interface stays up even though the physical link carrying the VLAN is admin or carrier down. | 3.5.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-19724"></a> [CM-19724](#CM-19724) <a name="CM-19724"></a> | PIM and MSDP entries are set to the internal COS value of 6 so they are grouped together with the bulk traffic priority group in the default `traffic.conf` file. However, PIM, IGMP, and MSDP are considered control-plane and should be set to the internal COS value of 7.  | 3.5.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-19454"></a> [CM-19454](#CM-19454) <a name="CM-19454"></a> | When you use NCLU to bring a bond admin down (`net add bond <bond> link down`), the bond interface goes into admin down state but the switch ports enslaved to the bond remain UP. If you are using bond-lacp-bypass-allow or balance-xor mode, the host might continue to send traffic. This traffic will be dropped because although the bond slaves are UP, they are not members of the bridge.<br/>To work around this issue, use the `sudo ifdown <bondname>` command. | 3.5.0-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-17934"></a> [CM-17934](#CM-17934) <a name="CM-17934"></a> | FRR tracks interface speed based on the value it learns from the Linux kernel for that interface. If the interface speed changes, FRR does not update its interface speed cache. This can lead to issues for routing protocols that derive metrics from interface speed as the cost can become out of sync with the interface speed.<br/>To work around this issue, manually define the routing protocol metric for these interfaces or restart FRR. | 3.7.6-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-17494"></a> [CM-17494](#CM-17494) <a name="CM-17494"></a> | In certain cases, a peer device sends an ARP request from a source IP address that is not on the connected subnet and the switch creates a STALE neighbor entry. Eventually, the switch attempts to keep the entry fresh and sends ARP requests to the host. If the host responds, the switch has REACHABLE neighbor entries for hosts that are not on the connected subnet. <br/>To work around this issue, change the value of `arp_ignore` to 2. See <a href="https://docs.cumulusnetworks.com/cumulus-linux/Layer-3/Address-Resolution-Protocol-ARP/" class="external-link" rel="nofollow">Address Resolution Protocol in the Cumulus Linux user guide</a> for more information. | 3.3.2-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-16571"></a> [CM-16571](#CM-16571) <a name="CM-16571"></a> | NCLU cannot manage `rsyslog` to addresses routed via a VRF.  In Cumulus Linux 4.0.0 and later, management VRF is enabled by default.   To work around this issue, update the `/etc/network/interfaces` file to disable management VRF. | 3.4.3-3.7.14.2, 4.0.0-4.3.0 | |
| <a name="CM-15812"></a> [CM-15812](#CM-15812) <a name="CM-15812"></a> | Multicast forwarding fails for IP addresses whose DMAC overlaps with reserved DIPs. | 3.2.1-3.7.14.2, 4.0.0-4.3.0 | |

### Fixed Issues in 4.3.0
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="CM-33160"></a> [CM-33160](#CM-33160) | CVE-2021-3156: A serious heap-based buffer overflow has been discovered in sudo that is exploitable by any local user. It has been given the name Baron Samedit by its discoverer. The bug can be leveraged to elevate privileges to root, even if the user is not listed in the sudoers file. User authentication is not required to exploit the bug.<br/>Vulnerable: <= 1.8.27-1+deb10u2<br/>Fixed: 1.8.27-1+deb10u3 | 4.0.0-4.2.1 | |
| <a name="CM-33115"></a> [CM-33115](#CM-33115) | When you run any of the vtysh `show bgp ipv4` or `show bgp ipv6` statistics commands, the `bgpd` service crashes. | 4.2.1 | |
| <a name="CM-32994"></a> [CM-32994](#CM-32994) | On Broadcom switches, after repeated VLAN or VXLAN configuration changes, `switchd` memory might not free up appropriately, which can lead to a crash.  | 3.7.14, 4.0.0-4.2.1 | |
| <a name="CM-32860"></a> [CM-32860](#CM-32860) | The following vulnerabilities were announced in the p11-kit (libp11-kit0) packages:<br/>CVE-2020-29361: Multiple integer overflows have been discovered in the array allocations in the p11-kit library and the p11-kit list command, where overflow checks are missing before calling realloc or calloc.<br/>CVE-2020-29362: A heap-based buffer over-read has been discovered in the RPC protocol used by thep11-kit server/remote commands and the client library. When the remote entity supplies a byte array through a serialized PKCS#11 function call, the receiving entity may allow the reading of up to 4 bytes of memory past the heap allocation.<br/>CVE-2020-29363: A heap-based buffer overflow has been discovered in the RPC protocol used by p11-kit server/remote commands and the client library. When the remote entity supplies a serialized byte array in a CK_ATTRIBUTE, the receiving entity may not allocate sufficient length for the buffer to store the deserialized value.<br/>Vulnerable: 0.23.15-2<br/>Fixed: 0.23.15-2_deb10u1 | 4.0.0-4.2.1 | |
| <a name="CM-32829"></a> [CM-32829](#CM-32829) | The NET-SNMP-EXTEND-MIB, disabled in Cumulus Linux 4.2.1 and 3.7.14 to prevent security vulnerability CVE-2020-15862, is re-enabled read-only. | 3.7.14-4.2.1 | |
| <a name="CM-32774"></a> [CM-32774](#CM-32774) | You can't delete a BGP community list created with NCLU. | 4.2.1 | |
| <a name="CM-32753"></a> [CM-32753](#CM-32753) | QinQ (802.1Q) packets routed to a layer 3 subinterface are still double tagged with the VLAN of the subinterface and the original inner VLAN when they leave the subinterface. | 4.2.0-4.2.1 | |
| <a name="CM-32750"></a> [CM-32750](#CM-32750) | In an EVPN Active/Active configuration, when one of the peers reboots and begins to refresh IP neighbor entries shared by the MLAG peer, some of these ARP messages might be dropped by the MLAG peer's ARP policer.<br/>To work around this issue, increase the burst value of the ARP policers to 200 or higher. | 3.7.14-4.2.1 | |
| <a name="CM-32733"></a> [CM-32733](#CM-32733) | CVE-2020-29479 CVE-2020-29480 CVE-2020-29481 CVE-2020-29482 CVE-2020-29483 CVE-2020-29484 CVE-2020-29485 CVE-2020-29486 CVE-2020-29566 CVE-2020-29570 CVE-2020-29571<br/>Several security issues affecting Xenstore could result in cross domain access (denial of service, information leaks or privilege escalation) or denial of service against xenstored.<br/>Additional vulnerabilities could result in guest-to-host denial of<br/>service.<br/>Vulnerable: <= 4.11.4+57-g41a822c392-1<br/>Fixed: 4.11.4+57-g41a822c392-2 | 4.0.0-4.2.1 | |
| <a name="CM-32728"></a> [CM-32728](#CM-32728) | On Broadcom switches, when WARN level `switchd` log messages are generated, `switchd` might crash resulting in a core file generated on the system. | 3.7.14 | |
| <a name="CM-32723"></a> [CM-32723](#CM-32723) | `ospf6d` restarts when you run the NCLU `net show ospf6 databse` command or the vtysh `show ipv6 ospf6 database` command.  | 4.2.0-4.2.1 | |
| <a name="CM-32683"></a> [CM-32683](#CM-32683) | When you change the SVI `vlan-id` value in the `/etc/network/interfaces` file, then run `ifreload -a`, the 802.1Q ID for the SVI in the kernel does not change.<br/>This operation is not supported in the kernel without recreating the SVI. To apply the change, run `ifdown`, then `ifup` for the SVI to recreate the interface. | 3.7.13-4.2.1 | |
| <a name="CM-32681"></a> [CM-32681](#CM-32681) | Broadcom switches running Cumulus Linux do not support EVPN Multihoming. When a BGP update with EVPN multihoming attributes is received, `switchd` crashes. <br/>EVPN Multihoming is supported on Mellanox switches only. | 4.2.1 | |
| <a name="CM-32661"></a> [CM-32661](#CM-32661) | On the Edgecore AS7312 switch, eth0 and swp use the same MAC address. | 3.7.14-4.2.1 | |
| <a name="CM-32647"></a> [CM-32647](#CM-32647) | When you start `asic-monitor`, you might see increasing memory usage. | 4.2.1 | |
| <a name="CM-32641"></a> [CM-32641](#CM-32641) | CVE-2020-27350: Missing input validation in the ar/tar implementations of APT, the high level package manager, could cause out-of-bounds reads or infinite loops, resulting in denial of service when processing malformed deb files.<br/>CVE-2020-27351: Various memory and file descriptor leaks were discovered in the Python interface to the APT package management runtime library, which could result in denial of service.<br/>Vulnerable: apt <= 1.8.2.1, python-apt <= 1.8.4.1<br/>Fixed: apt 1.8.2.2, python-apt 1.8.4.3 | 4.0.0-4.2.1 | |
| <a name="CM-32622"></a> [CM-32622](#CM-32622) | The following vulnerability has been announced in OpenSSL:<br/>CVE-2020-1971: A flaw in the GENERAL_NAME_cmp() function could cause a NULL dereference when both GENERAL_NAMEs contain an EDIPARTYNAME, resulting in denial of service.  More information can be found at <a href="https://www.openssl.org/news/secadv/20201208.txt" class="external-link" rel="nofollow">https://www.openssl.org/news/secadv/20201208.txt</a> .<br/>Vulnerable: <= 1.1.1d-0+deb10u3<br/>Fixed: 1.1.1d-0+deb10u4 | 4.0.0-4.2.1 | |
| <a name="CM-32592"></a> [CM-32592](#CM-32592) | CVE-2020-27670 CVE-2020-27671 CVE-2020-27672 CVE-2020-27674 CVE-2020-28368: Multiple vulnerabilities have been discovered in the Xen hypervisor, which could result in denial of service, privilege escalation or information leaks.<br/>Vulnerable: < 4.11.4+57-g41a822c392-1<br/>Fixed: 4.11.4+57-g41a822c392-1 | 4.0.0-4.2.1 | |
| <a name="CM-32554"></a> [CM-32554](#CM-32554) | An EVPN route map filter matching a VNI on egress on the originating router might not set a large-community correctly:<br /><pre>route-map TEST-TAG permit 10<br />  match evpn vni 109001<br />  set large-community 20:20:333<br />!<br /></pre><br />To work around this issue, remove the VNI match to allow the tag to be applied on egress.<br/>The VNI match works if applied at some other non-originating router either in the ingress or egress direction. | 4.2.1 | |
| <a name="CM-32532"></a> [CM-32532](#CM-32532) | CVE-2020-8927: A buffer overflow exists in the Brotli library versions prior to 1.0.8 where an attacker controlling the input length of a "one-shot" decompression request to a script can trigger a crash, which happens when copying over chunks of data larger than 2 GiB.  If one cannot update to a fixed version, we recommend to use the "streaming" API as opposed to the "one-shot" API, and impose chunk size limits.<br/>Vulnerable: 1.0.7-2<br/>Fixed: 1.0.7-2+deb10u1 | 4.0.0-4.2.1 | |
| <a name="CM-32420"></a> [CM-32420](#CM-32420) | When running traditional mode bridges at scale (for example, when you have more than 200 bridges and a large number of MAC addresses), MLAG bonds flap intermittently from dual to single connected, then back to dual connected, which causes a layer 2 loop and STP state changes.<br/>To work around this issue, either shut down one side of the MLAG bond or prune out VLANS over the bond. | 3.7.13-4.2.1 | |
| <a name="CM-32412"></a> [CM-32412](#CM-32412) | CVE-2020-28196: MIT Kerberos 5 (aka krb5) before 1.17.2 and 1.18.x before 1.18.3 allows unbounded recursion via an ASN.1-encoded Kerberos message because the lib/krb5/asn.1/asn1_encode.c support for BER indefinite lengths lacks a recursion limit.<br/>Vulnerable: 1.17-3<br/>Fixed: 1.17-3+deb10u1 | 4.0.0-4.2.1 | |
| <a name="CM-32329"></a> [CM-32329](#CM-32329) | On the Mellanox SN3420 switch, 1000BaseT and 1000Base-SX/LX modules do not link up. | 4.2.1 | |
| <a name="CM-32311"></a> [CM-32311](#CM-32311) | CVE-2020-25709, CVE-2020-25710: Two vulnerabilities in the certificate list syntax verification and in the handling of CSN normalization were discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can take advantage of these flaws to cause a denial of service (slapd daemon crash) via specially crafted packets.<br/>Vulnerable: <= 2.4.47+dfsg-3+deb10u3<br/>Fixed: 2.4.47+dfsg-3+deb10u4 | 4.0.0-4.2.1 | |
| <a name="CM-32294"></a> [CM-32294](#CM-32294) | Some non-Mellanox ethernet modules do not link up on the Mellanox SN3420 switch with Cumulus PSID in the Hardware revision. To see if a Mellanox SN3420 switch has the Cumulus PSID, check the output of `mlxfwmanager` for `MSN3420-CxxxC_Ax` in the `Part Number` Field.  A Mellanox SN3420 switch with `MSN3420-CxxxO_Ax` has an Onie PSID and is unaffected by this issue.<br/>To work around this issue, use Mellanox ethernet modules with the Mellanox SN3420 switch, | 4.2.1 | |
| <a name="CM-32275"></a> [CM-32275](#CM-32275) | After you reboot a Broadcom switch, `switchd` might fail to restart and you see logs in `switchd.log` similar to the following:<br /><pre>...<br />Nov 12 12:20:05.063876 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.064310 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 0:system_init:<br />Nov 12 12:20:05.064428 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 system_init: Misc init failed: Operation timed out<br />Nov 12 12:20:05.064464 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.091995 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 LED: Loading 256 bytes into LED program memory<br />Nov 12 12:20:05.092029 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099547 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 PORT: Error: bcm ports not initialized<br />Nov 12 12:20:05.099579 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099646 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /var/lib/cumulus/rc.datapath_0: line 81 (error code -1): script terminated<br />Nov 12 12:20:05.099667 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099775 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 Error: file /etc/bcm.d/rc.soc: line 70 (error code -1): script terminated<br />Nov 12 12:20:05.099798 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099871 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:294 ERROR loading rc script on unit 0<br />Nov 12 12:20:05.099892 leaf01 switchd&#91;9867&#93;:<br />Nov 12 12:20:05.099943 leaf01 switchd&#91;9867&#93;: hal_bcm_console.c:299 CRIT loading of rc script failed, aborting!<br /></pre><br /> | 3.7.11-4.2.1 | |
| <a name="CM-32235"></a> [CM-32235](#CM-32235) | In an EVPN multihoming configuration, reloading FRR causes brief traffic loss. | 4.2.1 | |
| <a name="CM-32226"></a> [CM-32226](#CM-32226) | If `switchd` successfully signals `clagd` that it is going down, `clagd` stops responding to keepalive echo requests from the peer instead of sending a good bye to the peer over both the peerlink and the backup switch. Eventually, the keepalive timer expires and the secondary switch becomes the primary, and brings the bonds and VNIs back up. However, if `switchd` does not successfully signal it is going down, (in the event of a crash), the primary switch continues to respond to keepalives, and the bonds and VNIs are down on both peers.  | 3.7.12-4.2.1 | |
| <a name="CM-32219"></a> [CM-32219](#CM-32219) | On the Mellanox SN3700C switch, running `cl-support` with a large number of ports configured can cause `switchd` to crash. | 4.2.1 | |
| <a name="CM-32215"></a> [CM-32215](#CM-32215) | On the Dell S5048F-ON switch, optical transceivers do not come up and the modules are in reset mode. | 4.0.0-4.2.1 | |
| <a name="CM-32149"></a> [CM-32149](#CM-32149) | If you try reconfigure a DHCP server after you delete the switch configuration with the `net del all` command, the `dhcpd` service fails because a duplicate process is running.<br/>To work around this issue, edit the `/usr/lib/python2.7/dist-packages/nclu/plugins/dhcp.py` file to change:<br /><pre>DHCPD_PID="-pf {0}" <br /></pre><br />to:<br /><pre>DHCPD_PID="-pf {1}"<br /></pre><br /> | 3.7.13-4.2.1 | |
| <a name="CM-32110"></a> [CM-32110](#CM-32110) | CVE-2020-25692: A vulnerability in the handling of normalization with modrdn was discovered in OpenLDAP, a free implementation of the Lightweight Directory Access Protocol. An unauthenticated remote attacker can use this flaw to cause a denial of service (slapd daemon crash) via a specially crafted packet.<br/>The slapd package is not present in the image or repository, although the OpenLDAP libraries are present.<br/>Vulnerable: <= 2.4.47+dfsg-3+deb10u2<br/>Fixed: 2.4.47+dfsg-3+deb10u3 | 4.0.0-4.2.1 | |
| <a name="CM-32086"></a> [CM-32086](#CM-32086) | If the peer link does not trunk all VLANs on an MLAG bond, all FDB entries learned through that MLAG bond are not redirected over the peer link when the MLAG bond goes down. As a result,  traffic destined to the MAC addresses that arrives on the MLAG peer with the downed MLAG port is dropped.<br/>To work around this issue, ensure that the peer link trunks all VLANs that exist on all MLAG bonds. | 4.2.0-4.2.1 | |
| <a name="CM-32030"></a> [CM-32030](#CM-32030) | On the Mellanox SN4600C switch, the fan speed fluctuates when only one PSU is plugged in.<br/>To work around this issue, use both PSUs. | 4.2.1 | |
| <a name="CM-32006"></a> [CM-32006](#CM-32006) | Certain Dell S4048-ON switches show an incorrect vendor name and hang when you issue the `reboot` command.  | 3.7.12-4.2.1 | |
| <a name="CM-31982"></a> [CM-31982](#CM-31982) | The INPUT chain POLICE target acts as ACCEPT instead of continue. | 4.2.1 | |
| <a name="CM-31968"></a> [CM-31968](#CM-31968) | The following vulnerability has been announced in freetype:<br/>CVE-2020-15999: Sergei Glazunov discovered a heap-based buffer overflow vulnerability in the handling of embedded PNG bitmaps in FreeType. Opening malformed fonts may result in denial of service or the execution of arbitrary code.<br/>Vulnerable: <= 2.9.1-3+deb10u1<br/>Fixed: 2.9.1-3+deb10u2 | 4.0.0-4.2.1 | |
| <a name="CM-31959"></a> [CM-31959](#CM-31959) | With traditional bridges, a race condition occurs when Cumulus Linux tries to derive MAC addresses.<br/>To work around this issue, use a static MAC address; specify a MAC address in the `/etc/network/interfaces` file under the bridge's stanza. | 4.2.1 | |
| <a name="CM-31954"></a> [CM-31954](#CM-31954) | A security issue was discovered in the MariaDB database server.<br/>Vulnerable: 10.3.25-0<br/>Fixed: 10.3.25-0+deb10u1 | 4.0.0-4.2.1 | |
| <a name="CM-31942"></a> [CM-31942](#CM-31942) | After upgrading the Mellanox SN2410 switch, the FAN is set to full speed. | 4.2.1 | |
| <a name="CM-31936"></a> [CM-31936](#CM-31936) | When you back up and restore a configuration using the conf-backup utility, the switch might hang when rebooted. | 4.1.1-4.2.1 | |
| <a name="CM-31864"></a> [CM-31864](#CM-31864) | CVE-2020-14355: Multiple buffer overflow vulnerabilities were found in the QUIC image decoding process of the SPICE remote display system, before spice-0.14.2-1.<br/>Both the SPICE client (spice-gtk) and server are affected by these flaws. These flaws allow a malicious client or server to send specially crafted messages that, when processed by the QUIC image compression algorithm, result in a process crash or potential code execution.<br/>Vulnerable: 0.14.0-1.3<br/>Fixed: 0.14.0-1.3+deb10u1 | 4.0.0-4.2.1 | |
| <a name="CM-31697"></a> [CM-31697](#CM-31697) | Multiple vulnerabilities have been discovered in the Xen hypervisor, which could result in denial of service, guest-to-host privilege escalation or information leaks.  These include the following:CVE-2020-25595, CVE-2020-25596, CVE-2020-25597, CVE-2020-25599, CVE-2020-25600, CVE-2020-25601, CVE-2020-25602, CVE-2020-25603, CVE-2020-25604.<br/>Vulnerable: < 4.11.4+37-g3263f257ca-1<br/>Fixed: 4.11.4+37-g3263f257ca-1 | 4.0.0-4.2.1 | |
| <a name="CM-31627"></a> [CM-31627](#CM-31627) | On switches with the Spectrum ASIC, the IPv6 default route is present in the kernel but missing in hardware. | 3.7.11-4.2.1 | |
| <a name="CM-31618"></a> [CM-31618](#CM-31618) | A ping via a dual-connected bond fails, and the audio stream is not routed or encapsulated through the layer 3 VNI. | 3.7.12-3.7.13, 4.0.0-4.2.1 | |
| <a name="CM-31565"></a> [CM-31565](#CM-31565) | Multicast traffic on a VPN is sent to remote VTEPs that are not part of the VPN and the remote VTEPs receive multicast traffic encapsulated in a VXLAN ID that doesn't exist.<br/>To work around this issue, disable IGMP snooping on the switch. | 3.7.12-3.7.13, 4.0.0-4.2.1 | |
| <a name="CM-31560"></a> [CM-31560](#CM-31560) | After a MAC address moves from one remote VTEP to another, the MAC address continues to point to the old VTEP IP address in hardware. | 4.1.1-4.2.1 | |
| <a name="CM-31545"></a> [CM-31545](#CM-31545) | In an MLAG configuration with a layer 3 VNI, when you bounce the peer link, all layer 2 VNIs listed under the layer 3 VNI are duplicated. <br/>To work around this issue, restart FRR with the `sudo systemctl restart frr.service` command. | 3.7.10-3.7.13, 4.1.1-4.2.1 | |
| <a name="CM-31504"></a> [CM-31504](#CM-31504) | On the the Dell N3248-PXE switch, when you insert two PSUs at different times, the newly inserted PSU is detected as OK but the fan and temp sensors are ABSENT.<br/>To work around this issue, remove power to both PSUs at the same time, then reinsert power simultaneously. | 3.7.12-3.7.13, 4.2.1 | |
| <a name="CM-31469"></a> [CM-31469](#CM-31469) | When you delete a layer 2 VNI and VLAN, the layer 3 VNI reports an incorrect layer 2 VNI number.<br/>To work around this issue, either restart FRR or delete the VNI interface first, then delete the VLAN/SVI. | 4.2.0-4.2.1 | |
| <a name="CM-31441"></a> [CM-31441](#CM-31441) | Leaked routes are sometimes missing from the destination VRF after a reboot. | 4.2.0-4.2.1 | |
| <a name="CM-31412"></a> [CM-31412](#CM-31412) | On the Dell N3248PXE switch, RJ45 fixed copper ports that auto-negotiate with a 100M or 10M neighbor incorrectly negotiate a half-duplex link that generates errors. Half duplex modes are not supported on this platform. | 3.7.12-3.7.13, 4.2.1 | |
| <a name="CM-31407"></a> [CM-31407](#CM-31407) | You cannot configure SNMPv3 trap-destinations in non-default VRFs with an authentication username that contains fewer than eight characters. | 3.7.12-4.2.1 | |
| <a name="CM-31358"></a> [CM-31358](#CM-31358) | The Dell 100G-LR4 (Innolight) transceiver cannot link up due to a power budget exceeded error on the Mellanox SN4600C switch. | 4.2.0-4.2.1 | |
| <a name="CM-31263"></a> [CM-31263](#CM-31263) | RX_DRP on a bond interface increases without any data traffic while the slave port does not increase. | 3.7.12-4.2.1 | |
| <a name="CM-31238"></a> [CM-31238](#CM-31238) | IPv6 TCP or UDP connections (sourcing from an ephemeral port in the range 34048 to 35071) are not forwarded if the switch has more than one layer 2 VNI defined. The traffic might be locally switched on the bridge and dropped. <br/>To work around this issue, disable ARP/ND suppression to remove the internal ACL rule that affects the ports. | 3.7.13, 4.2.1 | |
| <a name="CM-31231"></a> [CM-31231](#CM-31231) | On the Dell N3048EP switch, the module information from SFP ports is not displayed in the `l1-show` command.<br/>To work around this issue, use the `ethtool -m <interface>` command. | 3.7.13-4.2.1 | |
| <a name="CM-31222"></a> [CM-31222](#CM-31222) | Tenant VRF BGP peers appear in the EVPN RMAC and nexthop tables, which causes the kernel RMAC to point at invalid IP address. | 3.7.12-4.2.1 | |
| <a name="CM-31150"></a> [CM-31150](#CM-31150) | On the Mellanox SN2410 switch, you see `switchd` core and `GBIN_MALLOC` errors.<br/>To work around this issue, restart `switchd`. | 3.7.12-4.2.1 | |
| <a name="CM-31125"></a> [CM-31125](#CM-31125) | The MLAG bonds on a secondary switch do not change to a unique MAC address on the peerlink. As a result, a backup double failure can occur where both peers go down. | 4.2.0-4.2.1 | |
| <a name="CM-31120"></a> [CM-31120](#CM-31120) | In a traditional bridge configuration with `ip-forward off`, neighbors are synchronized to hardware with a `switchd` restart but are cleared when you flap the bridge interface. | 3.7.10-4.2.1 | |
| <a name="CM-31107"></a> [CM-31107](#CM-31107) | When you boot Cumulus VX 4.2 for the first time, ZTP does not execute because it thinks that the `/etc/shadow` file has been modified. This is due to the default password change implemented in CL 4.2.<br/>To work around this issue, boot the switch, manually change the password, then run `sudo ztp -R` to reset the ZTP script. | 4.2.0-4.2.1 | |
| <a name="CM-31073"></a> [CM-31073](#CM-31073) | When you set the `sysctl` settings `net.ipv6.conf.all.accept_ra_defrtr` (to prevent acceptance of IPv6 default route advertisements) and `net.ipv6.conf.default.accept_ra_defrtr` (set for newly created interfaces), if you create a new virtual interface, any pre-existing interface does not start accepting IPv6 default route avertisements again.<br/>To work around this issue, when you create a new virtual interface, set `net.ipv6.conf.<interface>.accept_ra_defrtr` to 0 for all interfaces and run `sysctl -p --system`. | 3.7.12-4.2.1 | |
| <a name="CM-31028"></a> [CM-31028](#CM-31028) | Ingress SPAN/ERSPAN does not mirror packets when the next hop is EVPN encapsulated. | 3.7.7-3.7.13, 4.0.0-4.2.1 | |
| <a name="CM-30916"></a> [CM-30916](#CM-30916) | On the Mellanox SN4700 switch, you might see <em>Bad signal integrity</em> issues on 200G and 400G ports. | 4.2.1 | |
| <a name="CM-30832"></a> [CM-30832](#CM-30832) | The Mellanox SN2700 and SN2410 switch intermittently reports PSU fan state changes with `Unable to read from device/fan1_input/pwm1` syslog messages. | 3.7.11-3.7.14, 4.1.1-4.2.1 | |
| <a name="CM-30555"></a> [CM-30555](#CM-30555) | If you have an existing community list of any type, redefining the same sequence number results in the entire community list being deleted.<br/>To work around this issue, delete the community list sequence before trying to adjust it. | 4.2.0-4.2.1 | |
| <a name="CM-30514"></a> [CM-30514](#CM-30514) | In OVSDB high availability mode, deleting > 200 VLAN bindings might cause `ovs-vtepd` to crash.  Limit the deletion to 200 or fewer VLAN bindings. | 3.7.12-3.7.13, 4.0.0-4.2.1 | |
| <a name="CM-30485"></a> [CM-30485](#CM-30485) | When you run `cl-ecmpcalc` to determine a hardware hash result, tests might fail. | 4.2.0-4.2.1 | |
| <a name="CM-30361"></a> [CM-30361](#CM-30361) | On Mellanox switches with the Spectrum-2 switch, the lpm-balanced forwarding profile does not work. | 4.1.1-4.2.1 | |
| <a name="CM-30247"></a> [CM-30247](#CM-30247) | dot1qVlanIndex in the dot1qVlanStaticTable of the SNMP Q-BRIDGE-MIB does not use VLAN ID and does not comply with RFC 4363. | 4.1.1-4.2.1 | |
| <a name="CM-30231"></a> [CM-30231](#CM-30231) | When the dynamic or static flag on a bridge fdb (MAC) entry is changed to the opposite state, the new flag is not set appropriately in hardware. This can allow a static fdb entry to be unexpectedly learned dynamically on a different interface, or can prevent a dynamic entry from being updated or learned elsewhere.<br/>This condition can occur during a manual replacement of a local MAC address or when EVPN updates a dynamic MAC address to add or remove the Sticky Mac flag. Either situation results in the MAC address keeping the original flag in hardware.<br/>To work around this issue, delete or withdraw the fdb entry, then add the static MAC address directly. For example:<br /><pre>bridge fdb del 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master<br />bridge fdb add 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master &#91; static \| dynamic &#93;<br /></pre><br />If you are unable to delete an EVPN-learned remote MAC address, you can replace the dynamic MAC address with a local static one, then delete the static MAC address. For example:<br /><pre>bridge fdb replace 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master static<br />bridge fdb del 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master<br />bridge fdb add 50:6b:4b:ee:ee:ee dev swp31 vlan 24 master &#91; static \| dynamic &#93;<br /></pre><br /> | 4.0.0-4.2.1 | |
| <a name="CM-30230"></a> [CM-30230](#CM-30230) | If a remote EVPN Sticky MAC <span class="error">&#91;Static MAC address&#93;</span> is unexpectedly learned dynamically on a local interface, the selected entries in zebra and BGP are in an inconsistent state.<br/>zebra increments the local MAC mobility sequence number and considers the MAC address to be local, but BGP maintains the remote Sticky MAC as the best path selected. This results in zebra installing the local MAC address and BGP not updating the route for the MAC address. | 4.0.0-4.2.1 | |
| <a name="CM-30194"></a> [CM-30194](#CM-30194) | After you enable ROCE with the `net add interface <switch-port> storage-optimized pfc` command, you cannot verify the command because it is not shown in the `net show config` command output. | 4.1.1-4.2.1 | |
| <a name="CM-30164"></a> [CM-30164](#CM-30164) | The `/usr/share/zoneinfo/leap-seconds.list` file expires periodically and results in log messages being generated about that expiration.<br/>To work around this issue, you must update the file from <a href="https://www.ietf.org/timezones/data/leap-seconds.list" class="external-link" rel="nofollow">https://www.ietf.org/timezones/data/leap-seconds.list</a> or upgrade the `tzdata` package to the newest version. | 4.0.0-4.2.1 | |
| <a name="CM-30159"></a> [CM-30159](#CM-30159) | After you delete a bond, the deleted bond members have the deleted bond MAC address instead of their original MAC address, which might result in traffic being discarded. <br/>To work around this issue, perform a full switch restart. | 4.1.1-4.2.1 | |
| <a name="CM-30103"></a> [CM-30103](#CM-30103) | On a Broadcom switch with the Trident2+ ASIC, ACL rules for VLANs are not applied after a reboot and the counters remain at zero.<br/>To work around this issue, either do not set `acl.non_atomic_update_mode = TRUE` in the `/etc/cumulus/switchd.conf` file or run the `cl-acltool -i` command after the reboot to install the  ACLs. | 3.7.12-4.2.1 | |
| <a name="CM-29978"></a> [CM-29978](#CM-29978) | The received PVST BPDU for a VLAN is flooded even though the ingress port doesn't have the VLAN tagged. | 3.7.8-3.7.13, 4.0.0-4.2.1 | |
| <a name="CM-29838"></a> [CM-29838](#CM-29838) | CPU utilization may increase when clag-managed bond interfaces are operationally/LACP down but the physical carrier remains up on the bond member switchports. This condition occurs when clag bond redirection is enabled and bond members remain up while the parent bond does not negotiate LACP.This issue is resolved in Cumulus Linux 3.7.14. | 3.7.9-3.7.13, 4.0.0-4.2.1 | |
| <a name="CM-29779"></a> [CM-29779](#CM-29779) | In LLDP, the `snmp` subagent loses all subsequent `lldpRemSysName` (1.0.8802.1.1.2.1.4.1.1.9) entries after an entry with a missing SysName is added.<br/>All the information from `lldpctl` is correct. Only the entries after the entry that is missing a SysName in `lldpRemSysName` disappear from the `snmp` subagent. | 3.7.12-4.2.1 | |
| <a name="CM-29759"></a> [CM-29759](#CM-29759) | When you use `nginx` and `restserver` in management VRF to provide a REST API for the switch, `nginx` starts but `restserver` fails to start.<br/>To work around this issue, comment out the `Requires=` line in the `/lib/systemd/system/restserver.service`. For example:<br /><pre>#Requires=nginx.service restserver.socket<br /></pre><br /> | 3.7.12-4.2.1 | |
| <a name="CM-29546"></a> [CM-29546](#CM-29546) | In vtysh, if you configure, then remove a layer 3 VNI for a VRF, the VNI is removed from zebra even if the VNI interface still exists in the kernel.<br/>If you configure a layer 2 VNI as a layer 3 VNI by mistake, removing the layer 3 VNI binding removes it from zebra but EVPN-learned MACs and neighbors are not installed into the kernel.<br/>To work around this issue, delete, then re-add the missing VNI. For example:<br /><pre>cumulus&#64;switch:~$ sudo ifdown vni10100<br />cumulus&#64;switch:~$ sudo ifup vni10100<br /></pre><br />If you flap the link with the `ip link set vni10100 down; ip link set vni10100 up` commands, zebra does not re-add the VNI. | 3.7.12-4.2.1 | |
| <a name="CM-29520"></a> [CM-29520](#CM-29520) | On Mellanox switches, when the networking service and `switchd` starts up, a rare condition might occur where `switchd` crashes and the following log message is generated:<br /><pre><code>CRIT backend/mlx/hal_mlx_nexthop.c:294: hal_mlx_ecmp_data_reinit: Assertion '(num_next_hops)' failed.</code><br /></pre><br /> | 4.1.0-4.2.1 | |
| <a name="CM-29259"></a> [CM-29259](#CM-29259) | You might see the following `gport` error messages in `switchd.log`:<div class="code panel" style="border-width: 1px;"><div class="codeContent panelContent"><pre class="code-java"><br />2020-04-10T19:50:01.011224+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x800007a find failed<br />2020-04-10T19:50:01.011631+09:00 E1PDX0V1ELF0001 6 switchd&#91;925&#93;: hal_bcm_mdb.c:530 gport 0x8000009 find failed<br /></pre><br />These messages are harmless and can be ignored. | 3.7.12-4.2.1 | |
| <a name="CM-29148"></a> [CM-29148](#CM-29148) | On MLX switches that contain an OSPF IP unnumbered neighborship with a high scale of prefixes being learned, a link flap might cause the neighbor entry to not be programmed in hardware. | 3.7.11-4.2.1 | |
| <a name="CM-29043"></a> [CM-29043](#CM-29043) | When a multipath route that contains an EVPN path exists together with an IPv4 BGP path in the VRF, the RMAC to VTEP binding is incorrect. This invalid entry occurs because Cumulus Linux treats IPv4 routes received over the eBGP IPv4 peering incorrectly in the VRF.<br/>To work around this issue, remove the unnecessary eBGP IPv4 peering. | 3.7.12-4.2.1 | |
| <a name="CM-29035"></a> [CM-29035](#CM-29035) | When you upgrade Cumulus Linux on the EdgeCore AS7726-32X or AS7326-56X switch, you might see firmware errors similar to the following:<br /><pre>W: Possible missing firmware /lib/firmware/tigon/tg3_tso5.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3_tso.bin for module tg3<br />W: Possible missing firmware /lib/firmware/tigon/tg3.bin for module tg3<br /></pre><br />You can safely ignore these error messages. | 3.7.12-4.2.1 | |
| <a name="CM-28940"></a> [CM-28940](#CM-28940) | If you configure `aggregate-address <address> summary-only` before a component of the same aggregate is injected into the BGP table with the `network` or `redistribute` command, when you remove the `aggregate-address` configuration, the component stays suppressed; it is not advertised to peers. For example:<br/>Existing configuration:<br /><pre>router bgp 1<br /> address-family ipv4 unicast<br />  aggregate-address 50.0.0.0/8 summary-only<br /> exit-address-family<br /></pre><br />If you add `network 50.0.0.1/32`, you see the following (expected) BGP table entries:<br /><pre>Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />*> 50.0.0.0         0.0.0.0                            32768 i<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />Removing `aggregate-address 50.0.0.0/8 summary-only` at this point results in the following (unexpected) BGP table entry:<br /><pre>Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br />              i internal, r RIB-failure, S Stale, R Removed<br />Origin codes: i - IGP, e - EGP, ? - incomplete<br />   Network          Next Hop            Metric LocPrf Weight Path<br />s> 50.0.0.1/32      0.0.0.0                  0         32768 i<br /></pre><br />To work around this issue, remove, then re-add the component prefix routes. | 3.7.12-4.2.1 | |
| <a name="CM-28891"></a> [CM-28891](#CM-28891) | `net show configuration commands` does not show the RoCE `net add interface <swp> storage-optimized pfc` configuration. | 4.1.0-4.2.1 | |
| <a name="CM-26137"></a> [CM-26137](#CM-26137) | ERSPAN in ebtables does not work for VNIs. For example, the following rule does not work:<br /><pre>-A FORWARD -i vni10 -j erspan --src-ip 100.1.1.2 --dst-ip 100.1.1.1 --ttl 64<br /></pre><br /> | 3.7.6-4.2.1 | |
| <a name="CM-25986"></a> [CM-25986](#CM-25986) | On the Mellanox Spectrum-2 switch, the time required to establish a link (from the time a link is set to `admin up` until the link becomes operationally up) can take up to 15 seconds on 40G interfaces and up to 30 seconds on 100G interfaces. <br/>To work around this issue, wait up to 15 seconds on 40G interfaces and 30 seconds on 100G interfaces for the link to establish. | 4.0.0-4.2.1 | |
| <a name="CM-23021"></a> [CM-23021](#CM-23021) | When you run the `mstpctl` command, you might see the bridge-port state as blocking when it is actually disabled. You might see the same incorrect bridge-port state when other programs or tools use the output of `mstpctl`; for example, SNMP output from the BRIDGE-MIB. | 3.7.1-4.2.1 | |
| <a name="CM-21055"></a> [CM-21055](#CM-21055) | On the Mellanox switch, the destination MAC address of ERSPAN GRE packets is set to all zeros; therefore, the first transit switch might drop packets. | 3.6.0-3.7.13, 4.0.0-4.2.1 | |

