---
title: Create and Run Searches
author: Cumulus Networks
weight: 260
toc: 4
---
The Global Search field in the UI header enables you to search for
devices or cards. You can create new searches or run existing searches.

## Create a Search

As with most search fields, simply begin entering the criteria in the
search field. As you type, items that match the search criteria are
shown in the search history dropdown along with the last time the search
was viewed. Wildcards are not allowed, but this predictive matching
eliminates the need for them. By default, the most recent searches are
shown. If more have been performed, they can be accessed. This may
provide a quicker search by reducing entry specifics and suggesting
recent searches. Selecting a suggested search from the list provides a
preview of the search results to the right.

To create a new search:

1.  Click in the **Global Search** field.
2.  Enter your search criteria.
3.  Click the device hostname or card workflow in the search list to
    open the associated information.  

    {{< figure src="/images/netq/search-create-auto-suggest-222.png" width="300" >}}

    {{%notice note%}}

If you have more matches than fit in the window, click the **See All
    \# Results** link to view all found matches. The count represents
    the number of devices found. It does not include cards found.

    {{%/notice%}}

## Run a Recent Search

You can re-run a recent search, saving time if you are comparing data
from two or more devices.

To re-run a recent search:

1.  Click in the **Global Search** field.

2.  When the desired search appears in the suggested searches list,
    select it.  

    {{< figure src="/images/netq/search-rerun-222.png" width="300" >}}

    {{%notice note%}}

You may need to click **See All \# Results** to find the desired
    search. If you do not find it in the list, you may still be able to
    find it in the **Recent Actions** list.

    {{%/notice%}}
