---
title: NetQ CLI Changes
author: Cumulus Networks
weight: 490
toc: 3
---

A number of commands have changed in this release to accommodate the addition of new options or to simplify their syntax. Additionally, new commands have been added and others have been removed. A summary of those changes is provided here.

## New Commands

The following table summarizes the new commands available with this release. They include event configuration commands.

| Command | Summary | Version |
| ------- | ------- | ------- |
| netq add events-config [events_config_id &lt;text-events-config-id-anchor>] [events_config_name &lt;text-events-config-name-anchor>] [message_type &lt;text-message-type-anchor>] [scope &lt;text-events-scope-anchor>] [is_active true \| is_active false] [suppress_until &lt;text-suppress-until>] | Configures the suppression of events generated by NetQ. | 3.1.0 |
| netq del events-config events_config_id &lt;text-events-config-id-anchor>  | Removes an event suppression configuration. | 3.1.0 |
| netq show events-config [events_config_id &lt;text-events-config-id-anchor>] [show-filter-conditions \| message_type &lt;text-message-type-anchor> show-filter-conditions] [json] | Displays event suppression configurations. | 3.1.0 |
| netq add notification channel email &lt;text-channel-name> to &lt;text-email-toids>  [smtpserver &lt;text-email-hostname>] [smtpport &lt;text-email-port>] [login &lt;text-email-id>] [password &lt;text-email-password>] [severity info \| severity warning \| severity error \| severity debug] | Configures an email channel for NetQ notifications. | 3.1.0 |
| netq lcm add netq-image &lt;text-image-path> | Lifecycle management command for adding a Cumulus NetQ disk image. | 3.1.0 |
| netq install update-settings &lt;text-key> &lt;text-value> | Advanced setting for overriding system variables after encountering issues during installation. File a {{<exlink url="https://support.mellanox.com/s/contact-support-page" text="support ticket">}} with the NVIDIA Cumulus Networks Global Support Services team before trying this command. | 3.1.0 |
| netq [&lt;hostname>] show dom type (laser_rx_power\|laser_output_power\|laser_bias_current) [interface &lt;text-dom-port-anchor>] [channel_id &lt;text-channel-id>] [around &lt;text-time>] [json] | Displays digital optical monitoring information for laser bias current, laser output power and received signal average optical power. | 3.1.0 |
| netq [&lt;hostname>] show dom type (module_temperature\|module_voltage) [interface &lt;text-dom-port-anchor>] [around &lt;text-time>] [json] | Displays digital optical monitoring information for module temperature and voltage. | 3.1.0 |
| netq trace (&lt;mac> vlan &lt;1-4096>) from &lt;mac-src> [around &lt;text-time>] [json\|detail\|pretty] | Ability to run a trace from a source MAC address. | 3.1.0 |
| netq add trace &lt;mac> [vlan &lt;1-4096>] from (&lt;src-hostname> \| &lt;ip-src>) [vrf &lt;vrf>] [alert-on-failure] | Adds a layer 2 on-demand trace for a MAC address from a hostname or IP address. The trace results appear in the NetQ UI only, not the terminal. | 3.1.0 |
| netq add trace name &lt;text-new-trace-name> &lt;mac> [vlan &lt;1-4096>] from (&lt;src-hostname> \| &lt;ip-src>) [vrf &lt;vrf>] interval &lt;text-time-min> [alert-on-failure] | Adds a layer 2 scheduled trace to be run at a given interval for a MAC address from a hostname or IP address. The trace results appear in the NetQ UI only, not the terminal. | 3.1.0 |
| netq add trace &lt;ip> from (&lt;src-hostname> \| &lt;ip-src>) [vrf &lt;vrf>] [alert-on-failure] | Adds a layer 3 on-demand trace for an IP address from a hostname or IP address. The trace results appear in the NetQ UI only, not the terminal. | 3.1.0 |
| netq add trace name &lt;text-new-trace-name> &lt;ip> from (&lt;src-hostname> \| &lt;ip-src>) [vrf &lt;vrf>] interval &lt;text-time-min> [alert-on-failure] | Adds a layer 3 scheduled trace to be run at a given interval for an IP address from a hostname or IP address. The trace results appear in the NetQ UI only, not the terminal. | 3.1.0 |
| netq del trace &lt;text-trace-name> | Deletes a scheduled trace. | 3.1.0 |
| netq show trace settings [name &lt;text-trace-name>] [json] | Displays the settings for all scheduled traces or a specified scheduled trace. | 3.1.0 |
| netq show trace summary [name &lt;text-trace-name>] [around &lt;text-time-hr>] [json] | Displays summary information for all scheduled traces or a specified scheduled trace. | 3.1.0 |
| netq show trace results &lt;text-job-id> [json] | Displays the results for the specified trace. | 3.1.0 |
| netq add validation type (ntp \| interfaces \| license \| sensors \| evpn \| vxlan \| agents \| mlag \| vlan \| bgp \| mtu \| ospf) [alert-on-failure] | Adds a new on-demand validation. | 3.1.0 |
| netq add validation name &lt;text-new-validation-name> type (ntp \| interfaces \| license \| sensors \| evpn \| vxlan \| agents \| mlag \| vlan \| bgp \| mtu \| ospf) interval &lt;text-time-min> [alert-on-failure] | Adds a new scheduled validation to be run at a given interval. | 3.1.0 |
| netq del validation &lt;text-validation-name> | Removes a validation. | 3.1.0 |
| netq show validation settings [name &lt;text-validation-name>] [type ntp \| type interfaces \| type license \| type sensors \| type evpn \| type vxlan \| type agents \| type mlag \| type vlan \| type bgp \| type mtu \| type ospf] [json] | Displays the settings for all scheduled validations or the specified scheduled validation. | 3.1.0 |
| netq show validation summary [name &lt;text-validation-name>] type (ntp \| interfaces \| license \| sensors \| evpn \| vxlan \| agents \| mlag \| vlan \| bgp \| mtu \| ospf) [around &lt;text-time-hr>] [json] | Displays summary information for all scheduled validations or the specified scheduled validation. | 3.1.0 |

## Modified Commands

The following table summarizes the commands that have been changed with this release.

| Updated Command | Old Command | What Changed | Version |
| --------------- | ----------- | ------------ | ------- |
| netq lcm upgrade name &lt;text-job-name> cl-version &lt;text-cumulus-linux-version> netq-version &lt;text-netq-version> hostnames &lt;text-switch-hostnames> [run-restore-on-failure] [run-before-after] | netq lcm upgrade name &lt;text-job-name> image-id &lt;text-image-id> license &lt;text-cumulus-license> hostnames &lt;text-switch-hostnames> [order &lt;text-upgrade-order>] [run-before-after] | You now specify the Cumulus Linux and NetQ versions instead of an image ID. You can also specify whether to run LCM restore if there is a failure during the upgrade, and you can specify whether to run LCM before or after the upgrade. | 3.1.0 |
| netq lcm add credentials username &lt;text-switch-username> (password &lt;text-switch-password> \| ssh-key &lt;text-ssh-key>)  | netq lcm add credentials (username &lt;text-switch-username> password &lt;text-switch-password> \| ssh-key &lt;text-ssh-key>) | *username* is now a required parameter. | 3.1.0 |
| netq lcm add cl-image &lt;text-image-path>  | netq lcm add image &lt;text-image-path> | Option name changed to `cl-image`, for specifying a Cumulus Linux disk image to add. This was required because you can add Cumulus NetQ images now with the `netq lcm add netq-image` command.  | 3.1.0 |
| netq bootstrap worker tarball &lt;text-tarball-name> master-ip &lt;text-master-ip> [password &lt;text-password>] | netq bootstrap worker tarball &lt;text-tarball-name> master-ip &lt;text-master-ip>  | You can now specify a password to the host. | 3.1.0 |
