---
title: What's New
author: Cumulus Networks
weight: 10
subsection: true
toc: 1
cascade:
    product: Cumulus NetQ
    version: "3.2"
    imgData: cumulus-netq
    siteSlug: cumulus-netq
---
NVIDIA NetQ {{<version>}} eases your customers deployment and maintenance activities for their data center networks with new configuration, performance, and security features and improvements.

## What's New in NetQ 3.2.1

NetQ 3.2.1 contains bug fixes.

## What's New in NetQ 3.2.0

NetQ 3.2.0 includes the following new features and improvements:

- Profile-based {{<link title="Manage Switch Configurations" text="switch configuration management">}} for system parameters with one-click configuration push to multiple switches reduces errors and configuration time required by manual configuration
- Simple and intuitive GUI to {{<link title="Install NetQ" text="install">}} and {{<link title="Upgrade NetQ" text="upgrade">}} the NetQ Platform, Collector, and Agent software simplifies maintenance and reduces downtime
- Login password security check and auto-expiration along with a user audit trail improve application compliance and security
- Detection of congestion and latency issues in real-time with {{<link title="Configure and Monitor What Just Happened Metrics" text="WJH">}} increases visibility into switch performance
- Detection of optical transceiver performance degradation ({{<link title="Monitor Switch Performance/#view-digital-optics-health" text="Digital Optical Monitoring">}}) enables proactive avoidance of network downtime
- Detection of {{<link title="Configure Notifications/#configure-threshold-based-event-notifications" text="Layer 1 link flapping">}} expands real-time and historical interface validation
- Intuitive textual descriptions of actions (creation, moves, deletion) on MAC addresses provide an easy to understand, precise history of MAC addresses in the network fabric

Upgrade paths for customers include:

- NetQ 2.4.x to NetQ 3.2.1
- NetQ 3.0.0 to NetQ 3.2.1
- NetQ 3.1.x to NetQ 3.2.1
- NetQ 3.2.0 to NetQ 3.2.1

Upgrades from NetQ 2.3.x and earlier require a fresh installation.

For information regarding bug fixes and known issues present in this release, refer to the {{<link title="NVIDIA NetQ 3.2 Release Notes" text="release notes">}}.
