---
title: Configure System Event Notifications
author: NVIDIA
weight: 780
toc: 3
---
To take advantage of the numerous event messages generated and processed by NetQ, you must integrate with third-party event notification applications. You can integrate NetQ with Syslog, PagerDuty, Slack, and Email. You may integrate with one or more of these applications simultaneously.

In an on-premises deployment, the NetQ On-premises Appliance or VM receives the raw data stream from the NetQ Agents, processes the data, stores, and delivers events to the Notification function. Notification then filters and sends messages to any configured notification applications. In a cloud deployment, the NetQ Cloud Appliance or VM passes the raw data stream on to the NetQ Cloud service for processing and delivery.

{{<figure src="/images/netq/event-notif-arch-onprem-330.png">}}

{{<figure src="/images/netq/event-notif-arch-cloud-330.png">}}

{{<notice note>}}

You may choose to implement a proxy server (that sits between the NetQ Appliance or VM and the integration channels) that receives, processes and distributes the notifications rather than having them sent directly to the integration channel. If you use such a proxy, you must configure NetQ with the proxy information.

{{</notice>}}

Notifications are generated for the following types of events:

| Category | Events |
| --- | --- | 
| Network Protocol Validations | <ul><li>BGP status and session state</li><li>MLAG (CLAG) status and session state</li><li>EVPN status and session state</li><li>LLDP status</li><li>OSPF status and session state </li><li>VLAN status and session state \*</li><li>VXLAN status and session state \*</li></ul> |
| Interfaces | <ul><li>Link status</li><li>Ports and cables status</li><li>MTU status</li></ul> |
| Services | <ul><li>NetQ Agent status</li><li>PTM\*</li><li>SSH \*</li><li>NTP status\*</li></ul> |
| Traces | <ul><li>On-demand trace status</li><li>Scheduled trace status</li></ul> |
| Sensors | <ul><li>Fan status</li><li>PSU (power supply unit) status</li><li>Temperature status</li></ul> |
| System Software | <ul><li>Configuration File changes</li><li>Running Configuration File changes</li><li>Cumulus Linux License status</li><li>Cumulus Linux Support status</li><li>Software Package status</li><li>Operating System version</li><li>Lifecycle Management status</li></ul> |
| System Hardware | <ul><li>Physical resources status</li><li>BTRFS status</li><li>SSD utilization status</li></ul> |

*\* This type of event can only be viewed in the CLI with this release.*

Event filters are based on rules you create. You must have at least one rule per filter. A select set of events can be triggered by a user-configured threshold.

Refer to the {{<link title="System Event Messages Reference">}} for descriptions and examples of these events.

## Event Message Format

Messages have the following structure:
`<message-type><timestamp><opid><hostname><severity><message>`

| Element  | Description  |
| ----------- | -------------- |
| message type | Category of event; *agent*, *bgp*, *clag*, *clsupport*, *configdiff*, *evpn*, *license*, *link*, *lldp*, *mtu*, *node*, *ntp*, *ospf*, *packageinfo*, *ptm*, *resource*, *runningconfigdiff*, *sensor*, *services*, *ssdutil*, *tca*, *trace*, *version*, *vlan* or *vxlan* |
| timestamp    | Date and time event occurred  |
| opid         | Identifier of the service or process that generated the event |
| hostname     | Hostname of network device where event occurred |
| severity     | Severity level in which the given event is classified; *debug*, *error*, *info*, *warning,* or *critical* |
| message      | Text description of event  |

For example:

{{<figure src="/images/netq/event-msg-format.png">}}

You can integrate notification channels using the NetQ UI or the NetQ CLI.

- Channels card: specify channels
- Threshold Crossing Rules card: specify rules and filters, assign existing channels
-`netq notification (channel|rule|filter)` command: specify channels, rules, and filters

To set up the integrations, you must configure NetQ with at least one channel, one rule, and one filter. To refine what messages you want to view and where to send them, you can add additional rules and filters and set thresholds on supported event types. You can also configure a proxy server to receive, process, and forward the messages. This is accomplished using the NetQ UI and NetQ CLI in the following order:

{{<figure src="/images/netq/notif-config-wkflow.png">}}

## Configure Basic NetQ Event Notifications

The simplest configuration you can create is one that sends all events generated by all interfaces to a single notification application. This is described here. For more granular configurations and examples, refer to {{<link url="#configure-advanced-netq-event-notifications" text="Configure Advanced NetQ Event Notifications">}}.

A notification configuration must contain one channel, one rule, and one filter. Creation of the configuration follows this same path:

1. Add a channel.
2. Add a rule that accepts a selected set events.
3. Add a filter that associates this rule with the newly created channel.

### Create a Channel

The first step is to create a PagerDuty, Slack, syslog, or Email channel to receive the notifications.

{{< tabs "TabID81" >}}

{{< tab "Slack" >}}

You can use the NetQ UI or the NetQ CLI to create a Slack channel.

{{< tabs "TabID191" >}}

{{< tab "NetQ UI" >}}

1. Click <img src="https://icons.cumulusnetworks.com/01-Interface-Essential/03-Menu/navigation-menu.svg" height="18" width="18"/>, and then click **Channels** in the **Notifications** column.

    {{<figure src="/images/netq/main-menu-channels-selected-320.png" width="600">}}

2. The **Slack** tab is displayed by default.

    {{<figure src="/images/netq/channels-noslack-created-320.png" width="700">}}

3. Add a channel.

    - When no channels have been specified, click **Add Slack Channel**.
    - When at least one channel has been specified, click <img src="https://icons.cumulusnetworks.com/01-Interface-Essential/43-Remove-Add/add-circle.svg" height="18" width="18"/> above the table.

4. Provide a unique name for the channel. Note that spaces are not allowed. Use dashes or camelCase instead.

    {{<figure src="/images/netq/channels-add-slack-300.png" width="250">}}

5. Create an *incoming webhook* as described in the documentation for your version of Slack. Then copy and paste it here.

6. Click **Add**.

7. To verify the channel configuration, click **Test**.

    {{<figure src="/images/netq/channels-verify-slack-320.png" width="250">}}

<div style="padding-left: 18px;">Otherwise, click <strong>Close</strong>.</div>

    {{<figure src="/images/netq/channels-slack-created-320.png" width="700">}}

8. To return to your workbench, click {{<img src="https://icons.cumulusnetworks.com/01-Interface-Essential/33-Form-Validation/close.svg" height="14" width="14">}} in the top right corner of the card.

{{< /tab >}}

{{< tab "NetQ CLI" >}}

To create and verify the specification of a Slack channel, run:

```
netq add notification channel slack <text-channel-name> webhook <text-webhook-url> [severity info|severity warning|severity error|severity debug] [tag <text-slack-tag>]
netq show notification channel [json]
```

This example shows the creation of a *slk-netq-events* channel and verifies the configuration.

1. Create an *incoming webhook* as described in the documentation for your version of Slack.

2. Create the channel.

    ```
    cumulus@switch:~$ netq add notification channel slack slk-netq-events webhook https://hooks.slack.com/services/text/moretext/evenmoretext
    Successfully added/updated channel slk-netq-events
    ```

3. Verify the configuration.

    ```
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity Channel Info
    --------------- ---------------- -------- ----------------------
    slk-netq-events slack            info     webhook:https://hooks.s
                                                lack.com/services/text/
                                                moretext/evenmoretext
    ```

{{< /tab >}}

{{< /tabs >}}

{{< /tab >}}

{{< tab "PagerDuty" >}}

You can use the NetQ UI or the NetQ CLI to create a PagerDuty channel.

{{< tabs "TabID125" >}}

{{< tab "NetQ UI" >}}

1. Click <img src="https://icons.cumulusnetworks.com/01-Interface-Essential/03-Menu/navigation-menu.svg" height="18" width="18"/>, and then click **Channels** in the **Notifications** column.

    {{<figure src="/images/netq/main-menu-channels-selected-320.png" width="600">}}

2. Click **PagerDuty**.

    {{<figure src="/images/netq/channels-nopagerduty-created-320.png" width="700">}}

3. Add a channel.

    - When no channels have been specified, click **Add PagerDuty Channel**.
    - When at least one channel has been specified, click <img src="https://icons.cumulusnetworks.com/01-Interface-Essential/43-Remove-Add/add-circle.svg" height="18" width="18"/> above the table.

4. Provide a unique name for the channel. Note that spaces are not allowed. Use dashes or camelCase instead.

    {{<figure src="/images/netq/channels-add-pagerduty-300.png" width="250">}}

5. Obtain and enter an integration key (also called a service key or routing key).

6. Click **Add**.

7. Verify it is correctly configured.

    {{<figure src="/images/netq/channels-verify-pagerduty-320.png" width="250">}}

<div style="padding-left: 18px;">Otherwise, click <strong>Close</strong>.</div>

    {{<figure src="/images/netq/channels-pagerduty-created-320.png" width="700">}}

8. To return to your workbench, click {{<img src="https://icons.cumulusnetworks.com/01-Interface-Essential/33-Form-Validation/close.svg" height="14" width="14">}} in the top right corner of the card.

{{< /tab >}}

{{< tab "NetQ CLI" >}}

To create and verify the specification of a PagerDuty channel, run:

```
netq add notification channel pagerduty <text-channel-name> integration-key <text-integration-key> [severity info|severity warning|severity error|severity debug]
netq show notification channel [json]
```

This example shows the creation of a *pd-netq-events* channel and verifies the configuration.

1. Obtain an integration key as described in this PagerDuty {{<exlink url="https://support.pagerduty.com/docs/services-and-integrations#section-events-api-v2" text="support page">}}.

2. Create the channel.

    ```
    cumulus@switch:~$ netq add notification channel pagerduty pd-netq-events integration-key c6d666e210a8425298ef7abde0d1998
    Successfully added/updated channel pd-netq-events
    ```
3. Verify the configuration.

    ```
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity         Channel Info
    --------------- ---------------- ---------------- ------------------------
    pd-netq-events  pagerduty        info             integration-key: c6d666e
                                                    210a8425298ef7abde0d1998
    ```

{{< /tab >}}

{{< /tabs >}}

{{< /tab >}}

{{< tab "Syslog" >}}

You can use the NetQ UI or the NetQ CLI to create a Slack channel.

{{< tabs "TabID261" >}}

{{< tab "NetQ UI" >}}

1. Click <img src="https://icons.cumulusnetworks.com/01-Interface-Essential/03-Menu/navigation-menu.svg" height="18" width="18"/>, and then click **Channels** in the **Notifications** column.

    {{<figure src="/images/netq/main-menu-channels-selected-320.png" width="600">}}

2. Click **Syslog**.

    {{<figure src="/images/netq/channels-nosyslog-created-320.png" width="700">}}

3. Add a channel.

    - When no channels have been specified, click **Add Syslog Channel**.
    - When at least one channel has been specified, click <img src="https://icons.cumulusnetworks.com/01-Interface-Essential/43-Remove-Add/add-circle.svg" height="18" width="18"/> above the table.

4. Provide a unique name for the channel. Note that spaces are not allowed. Use dashes or camelCase instead.

    {{<figure src="/images/netq/channels-add-syslog-300.png" width="250">}}

5. Enter the IP address and port of the Syslog server.

6. Click **Add**.

7. To verify the channel configuration, click **Test**.

    {{<figure src="/images/netq/channels-verify-syslog-320.png" width="250">}}

<div style="padding-left: 18px;">Otherwise, click <strong>Close</strong>.</div>

    {{<figure src="/images/netq/channels-syslog-created-320.png" width="700">}}

8. To return to your workbench, click {{<img src="https://icons.cumulusnetworks.com/01-Interface-Essential/33-Form-Validation/close.svg" height="14" width="14">}} in the top right corner of the card.

{{< /tab >}}

{{< tab "NetQ CLI" >}}

To create and verify the specification of a syslog channel, run:

```
netq add notification channel syslog <text-channel-name> hostname <text-syslog-hostname> port <text-syslog-port> [severity info | severity warning | severity error | severity debug]
netq show notification channel [json]
```

This example shows the creation of a *syslog-netq-events* channel and verifies the configuration.

1. Obtain the syslog server hostname (or IP address) and port.

2. Create the channel.

    ```
    cumulus@switch:~$ netq add notification channel syslog syslog-netq-events hostname syslog-server port 514
    Successfully added/updated channel syslog-netq-events
    ```

3. Verify the configuration.

    ```
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity Channel Info
    --------------- ---------------- -------- ----------------------
    syslog-netq-eve syslog            info     host:syslog-server
    nts                                        port: 514
    ```

{{< /tab >}}

{{< /tabs >}}

{{< /tab >}}

{{< tab "Email" >}}

You can use the NetQ UI or the NetQ CLI to create an Email channel.

{{< tabs "TabID328" >}}

{{< tab "NetQ UI" >}}

1. Click <img src="https://icons.cumulusnetworks.com/01-Interface-Essential/03-Menu/navigation-menu.svg" height="18" width="18"/>, and then click **Channels** in the **Notifications** column.

    {{<figure src="/images/netq/main-menu-channels-selected-320.png" width="600">}}

2. Click **Email**.

    {{<figure src="/images/netq/channels-noemail-created-320.png" width="700">}}

3. Add a channel.

    - When no channels have been specified, click **Add Email Channel**.
    - When at least one channel has been specified, click <img src="https://icons.cumulusnetworks.com/01-Interface-Essential/43-Remove-Add/add-circle.svg" height="18" width="18"/> above the table.

4. Provide a unique name for the channel. Note that spaces are not allowed. Use dashes or camelCase instead.

    {{<figure src="/images/netq/channels-add-email-320.png" width="250">}}

5. Enter a list of emails for the persons who you want to receive the notifications from this channel.

    Enter the emails separated by commas, and no spaces. For example: `user1@domain.com,user2@domain.com,user3@domain.com`.

6. The first time you configure an Email channel, you must also specify the SMTP server information:

    - **Host**: hostname or IP address of the SMTP server
    - **Port**: port of the SMTP server; typically 587
    - **User ID/Password**: your administrative credentials
    - **From**: email address that indicates who sent the event messages

    After the first time, any additional email channels you create can use this configuration, by clicking **Existing**.

7. Click **Add**.

8. To verify the channel configuration, click **Test**.

    {{<figure src="/images/netq/channels-verify-email-320.png" width="250">}}

<div style="padding-left: 18px;">Otherwise, click <strong>Close</strong>.</div>

    {{<figure src="/images/netq/channels-email-created-320.png" width="700">}}

9. To return to your workbench, click {{<img src="https://icons.cumulusnetworks.com/01-Interface-Essential/33-Form-Validation/close.svg" height="14" width="14">}} in the top right corner of the card.

{{< /tab >}}

{{< tab "NetQ CLI" >}}

To create and verify the specification of an Email channel, run:

```
netq add notification channel email <text-channel-name> to <text-email-toids> [smtpserver <text-email-hostname>] [smtpport <text-email-port>] [login <text-email-id>] [password <text-email-password>] [severity info | severity warning | severity error | severity debug]
netq add notification channel email <text-channel-name> to <text-email-toids>
netq show notification channel [json]
```

The configuration is different depending on whether you are using the on-premises or cloud version of NetQ. No SMTP configuration is required  for cloud deployments as the NetQ cloud service uses the NetQ SMTP server to push email notifications.

For an **on-premises** deployment:

1. Set up an SMTP server. The server can be internal or public.

2. Create a user account (login and password) on the SMTP server. Notifications are sent to this address.

3. Create the notification channel using this form of the CLI command:

    ```
    netq add notification channel email <text-channel-name> to <text-email-toids>  [smtpserver <text-email-hostname>] [smtpport <text-email-port>] [login <text-email-id>] [password <text-email-password>] [severity info | severity warning | severity error | severity debug]
    ```

<div style="padding-left: 18px;">For example:

```
cumulus@switch:~$ netq add notification channel email onprem-email to netq-notifications@domain.com smtpserver smtp.domain.com smtpport 587 login smtphostlogin@domain.com password MyPassword123
Successfully added/updated channel onprem-email
```

</div>

4. Verify the configuration.

    ```
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity         Channel Info
    --------------- ---------------- ---------------- ------------------------
    onprem-email    email            info             password: MyPassword123,
                                                      port: 587,
                                                      isEncrypted: True,
                                                      host: smtp.domain.com,
                                                      from: smtphostlogin@doma
                                                      in.com,
                                                      id: smtphostlogin@domain
                                                      .com,
                                                      to: netq-notifications@d
                                                      omain.com
    ```

For a **cloud** deployment:

1. Create the notification channel using this form of the CLI command:

    ```
    netq add notification channel email <text-channel-name> to <text-email-toids>
    ```

<div style="padding-left: 18px;">For example:

```
cumulus@switch:~$ netq add notification channel email cloud-email to netq-cloud-notifications@domain.com
Successfully added/updated channel cloud-email
```

</div>

2. Verify the configuration.

    ```
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity         Channel Info
    --------------- ---------------- ---------------- ------------------------
    cloud-email    email            info             password: TEiO98BOwlekUP
                                                     TrFev2/Q==, port: 587,
                                                     isEncrypted: True,
                                                     host: netqsmtp.domain.com,
                                                     from: netqsmtphostlogin@doma
                                                     in.com,
                                                     id: smtphostlogin@domain
                                                     .com,
                                                     to: netq-notifications@d
                                                     omain.com

    ```

{{< /tab >}}

{{< /tabs >}}

{{< /tab >}}

{{< /tabs >}}

### Create a Rule

The second step is to create and verify a rule that accepts a set of events. Rules for system events are created using the NetQ CLI.

To create and verify the specification of a rule, run:

```
netq add notification rule <text-rule-name> key <text-rule-key> value <text-rule-value>
netq show notification rule [json]
```

Refer to {{<link title="#create-rules">}} for a list of available keys and values.

This example creates a rule named *all-interfaces*, using the key *ifname* and the value *ALL* to indicate that all events from all interfaces should be sent to any channel with this rule.

```
cumulus@switch:~$ netq add notification rule all-interfaces key ifname value ALL
Successfully added/updated rule all-ifs

cumulus@switch:~$ netq show notification rule
Matching config_notify records:
Name            Rule Key         Rule Value
--------------- ---------------- --------------------
all-interfaces  ifname           ALL
```

Refer to {{<link title="#Configure Threshold-based Event Notifications" text="Advanced Configuration">}} to create rules based on thresholds.

### Create a Filter

The final step is to create a filter to tie the rule to the channel. Filters are created for system events using the NetQ CLI.

To create and verify a filter, run:

```
netq add notification filter <text-filter-name> rule <text-rule-name-anchor> channel <text-channel-name-anchor>
netq show notification filter [json]
```

These examples use the channels created in the {{<link title="#Create a Channel">}} topic and the rule created in the {{<link title="#Create a Rule">}} topic.

{{< tabs "TabID466" >}}

{{< tab "PagerDuty" >}}

```
cumulus@switch:~$ netq add notification filter notify-all-ifs rule all-interfaces channel pd-netq-events
Successfully added/updated filter notify-all-ifs

cumulus@switch:~$ netq show notification filter
Matching config_notify records:
Name            Order      Severity         Channels         Rules
--------------- ---------- ---------------- ---------------- ----------
notify-all-ifs  1          info             pd-netq-events   all-interfaces
```

{{< /tab >}}

{{< tab "Slack" >}}

```
cumulus@switch:~$ netq add notification filter notify-all-ifs rule all-interfaces channel slk-netq-events
Successfully added/updated filter notify-all-ifs

cumulus@switch:~$ netq show notification filter
Matching config_notify records:
Name            Order      Severity         Channels         Rules
--------------- ---------- ---------------- ---------------- ----------
notify-all-ifs  1          info             slk-netq-events   all-interfaces
```

{{< /tab >}}

{{< tab "Syslog" >}}

```
cumulus@switch:~$ netq add notification filter notify-all-ifs rule all-interfaces channel syslog-netq-events
Successfully added/updated filter notify-all-ifs

cumulus@switch:~$ netq show notification filter
Matching config_notify records:
Name            Order      Severity         Channels         Rules
--------------- ---------- ---------------- ---------------- ----------
notify-all-ifs  1          info             syslog-netq-events all-ifs
```

{{< /tab >}}

{{< tab "Email" >}}

```
cumulus@switch:~$ netq add notification filter notify-all-ifs rule all-interfaces channel onprem-email
Successfully added/updated filter notify-all-ifs

cumulus@switch:~$ netq show notification filter
Matching config_notify records:
Name            Order      Severity         Channels         Rules
--------------- ---------- ---------------- ---------------- ----------
notify-all-ifs  1          info             onprem-email all-ifs
```

{{< /tab >}}

{{< /tabs >}}

NetQ is now configured to send all interface events to your selected channel.

Refer to {{<link title="#Configure Threshold-based Event Notifications" text="Advanced Configuration">}} to create filters for threshold-based events.

## Configure Advanced NetQ Event Notifications

If you want to create more granular notifications based on such items as selected devices, characteristics of devices, or protocols, or you want to use a proxy server, you need more than the basic notification configuration. Details for creating these more complex notification configurations are included here.

### Configure a Proxy Server

To send notification messages through a proxy server instead of directly to a notification channel, you configure NetQ with the hostname and optionally a port of a proxy server. If no port is specified, NetQ defaults to port 80. Only one proxy server is currently  supported. To simplify deployment, configure your proxy server before configuring channels, rules, or filters.

To configure and verify the proxy server, run:

```
netq add notification proxy <text-proxy-hostname> [port <text-proxy-port>]
netq show notification proxy
```

This example configures and verifies the *proxy4* server on port *80* to act as a proxy for event notifications.

```
cumulus@switch:~$ netq add notification proxy proxy4
Successfully configured notifier proxy proxy4:80

cumulus@switch:~$ netq show notification proxy
Matching config_notify records:
Proxy URL          Slack Enabled              PagerDuty Enabled
------------------ -------------------------- ----------------------------------
proxy4:80          yes                        yes
```

### Create Channels

Create one or more PagerDuty, Slack, syslog, or Email channels to receive the notifications.

{{< tabs "TabID566" >}}

{{< tab "PagerDuty" >}}

NetQ sends notifications to PagerDuty as PagerDuty events.

For example:

{{<figure src="/images/netq/NetQ-PagerDuty-ex-output.png">}}

To create and verify the specification of a PagerDuty channel, run:

```
netq add notification channel pagerduty <text-channel-name> integration-key <text-integration-key> [severity info|severity warning|severity error|severity debug]
netq show notification channel [json]
```

where:

<table>
<colgroup>
<col style="width: 35%" />
<col style="width: 65%" />
</colgroup>
<thead>
<tr>
<th>Option</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr>
<td>&lt;text-channel-name&gt;</td>
<td>User-specified PagerDuty channel name</td>
</tr>
<tr>
<td>integration-key &lt;text-integration-key&gt;</td>
<td>The {{<exlink url="https://v2.developer.pagerduty.com/docs/events-api-v2" text="integration">}} key is also called the service_key or routing_key. The default is an empty string (&quot;&quot;).</td>
</tr>
<tr>
<td>severity &lt;level&gt;</td>
<td>(Optional) The log level to set, which can be one of <em>info</em>, <em>warning</em>, <em>error</em>, <em>critical</em> or <em>debug</em>. The severity defaults to <em>info</em> if unspecified.</td>
</tr>
</tbody>
</table>

This example shows the creation of a *pd-netq-events* channel and verifies the configuration.

1. Obtain an integration key as described in this PagerDuty {{<exlink url="https://support.pagerduty.com/docs/services-and-integrations#section-events-api-v2" text="support page">}}.

2. Create the channel.

    ```
    cumulus@switch:~$ netq add notification channel pagerduty pd-netq-events integration-key c6d666e210a8425298ef7abde0d1998
    Successfully added/updated channel pd-netq-events
    ```

3. Verify the configuration.

    ```
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity         Channel Info
    --------------- ---------------- ---------------- ------------------------
    pd-netq-events  pagerduty        info             integration-key: c6d666e
                                                    210a8425298ef7abde0d1998
    ```

{{< /tab >}}

{{< tab "Slack" >}}

NetQ Notifier sends notifications to Slack as incoming webhooks for a
Slack channel you configure.

For example:

{{<figure src="/images/netq/slack-ex-output.png">}}

To create and verify the specification of a Slack channel, run:

```
netq add notification channel slack <text-channel-name> webhook <text-webhook-url> [severity info|severity warning|severity error|severity debug] [tag <text-slack-tag>]
netq show notification channel [json]
```

where:

<table>
<colgroup>
<col style="width: 35%" />
<col style="width: 65%" />
</colgroup>
<thead>
<tr class="header">
<th>Option</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>&lt;text-channel-name&gt;</td>
<td>User-specified Slack channel name</p></td>
</tr>
<tr class="even">
<td>webhook &lt;text-webhook-url&gt;</td>
<td>WebHook URL for the desired channel. For example: <em>https://hooks.slack.com/services/text/moretext/evenmoretext</em></td>
</tr>
<tr class="odd">
<td>severity &lt;level&gt;</td>
<td>The log level to set, which can be one of <em>error, warning, info,</em> or <em>debug</em>. The severity defaults to <em>info</em>.</td>
</tr>
<tr class="even">
<td>tag &lt;text-slack-tag&gt;</td>
<td>Optional tag appended to the Slack notification to highlight particular channels or people. The tag value must be preceded by the @ sign. For example, <em>@netq-info</em>.</td>
</tr>
</tbody>
</table>

This example shows the creation of a *slk-netq-events* channel and verifies the configuration.

1. Create an incoming webhook as described in the documentation for your version of Slack.

2. Create the channel.

    ```
    cumulus@switch:~$ netq add notification channel slack slk-netq-events webhook https://hooks.slack.com/services/text/moretext/evenmoretext severity warning tag @netq-ops
    Successfully added/updated channel slk-netq-events
    ```

3. Verify the configuration.

    ```
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity         Channel Info
    --------------- ---------------- ---------------- ------------------------
    slk-netq-events slack            warning          tag: @netq-ops,
                                                      webhook: https://hooks.s
                                                      lack.com/services/text/m
                                                      oretext/evenmoretext
    ```

{{< /tab >}}

{{< tab "Syslog" >}}

To create and verify the specification of a syslog channel, run:

```
netq add notification channel syslog <text-channel-name> hostname <text-syslog-hostname> port <text-syslog-port> [severity info | severity warning | severity error | severity debug]
netq show notification channel [json]
```
where:

<table>
<colgroup>
<col style="width: 35%" />
<col style="width: 65%" />
</colgroup>
<thead>
<tr class="header">
<th>Option</th>
<th>Description</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>&lt;text-channel-name&gt;</td>
<td>User-specified syslog channel name</p></td>
</tr>
<tr class="even">
<td>hostname &lt;text-syslog-hostname&gt;</td>
<td>Hostname or IP address of the syslog server to receive notifications</td>
</tr>
<tr class="odd">
<td>port &lt;text-syslog-port&gt;</td>
<td>Port on the syslog server to receive notifications</td>
</tr>
<tr class="even">
<td>severity &lt;level&gt;</td>
<td>The log level to set, which can be one of <em>error, warning, info,</em> or <em>debug</em>. The severity defaults to <em>info</em>.</td>
</tr>
</tbody>
</table>

This example shows the creation of a *syslog-netq-events* channel and verifies the configuration.

1. Obtain the syslog server hostname (or IP address) and port.

2. Create the channel.

    ```
    cumulus@switch:~$ netq add notification channel syslog syslog-netq-events hostname syslog-server port 514 severity error
    Successfully added/updated channel syslog-netq-events
    ```

3. Verify the configuration.

    ```
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity Channel Info
    --------------- ---------------- -------- ----------------------
    syslog-netq-eve syslog           error     host:syslog-server
    nts                                        port: 514
    ```

{{< /tab >}}

{{< tab "Email" >}}

The configuration is different depending on whether you are using the on-premises or cloud version of NetQ.

{{< tabs "TabID780" >}}

{{< tab "On-premises" >}}

To create an Email notification channel for an on-premises deployment, run:

```
netq add notification channel email <text-channel-name> to <text-email-toids> [smtpserver <text-email-hostname>] [smtpport <text-email-port>] [login <text-email-id>] [password <text-email-password>] [severity info | severity warning | severity error | severity debug]
```

This example creates an email channel named *onprem-email* that uses the *smtpserver* on port *587* to send messages to those persons with access to the *smtphostlogin* account.

1. Set up an SMTP server. The server can be internal or public.

2. Create a user account (login and password) on the SMTP server. Notifications are sent to this address.

3. Create the notification channel.

    ```
    cumulus@switch:~$ netq add notification channel email onprem-email to netq-notifications@domain.com smtpserver smtp.domain.com smtpport 587 login smtphostlogin@domain.com password MyPassword123 severity warning
    Successfully added/updated channel onprem-email
    ```

4. Verify the configuration.

    ```
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity         Channel Info
    --------------- ---------------- ---------------- ------------------------
    onprem-email    email            warning          password: MyPassword123,
                                                      port: 587,
                                                      isEncrypted: True,
                                                      host: smtp.domain.com,
                                                      from: smtphostlogin@doma
                                                      in.com,
                                                      id: smtphostlogin@domain
                                                      .com,
                                                      to: netq-notifications@d
                                                      omain.com
    ```

{{< /tab >}}

{{< tab "Cloud" >}}

In cloud deployments as the NetQ cloud service uses the NetQ SMTP server to push email notifications.

To create an Email notification channel for a cloud deployment, run:

```
netq add notification channel email <text-channel-name> to <text-email-toids> [severity info | severity warning | severity error | severity debug]
netq show notification channel [json]
```

This example creates an email channel named *cloud-email* that uses the NetQ SMTP server to send messages to those persons with access to the *netq-cloud-notifications* account.

1. Create the channel.

    ```
    cumulus@switch:~$ netq add notification channel email cloud-email to netq-cloud-notifications@domain.com severity error
    Successfully added/updated channel cloud-email
    ```

2. Verify the configuration.

    ```
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity         Channel Info
    --------------- ---------------- ---------------- ------------------------
    cloud-email    email            error            password: TEiO98BOwlekUP
                                                     TrFev2/Q==, port: 587,
                                                     isEncrypted: True,
                                                     host: netqsmtp.domain.com,
                                                     from: netqsmtphostlogin@doma
                                                     in.com,
                                                     id: smtphostlogin@domain
                                                     .com,
                                                     to: netq-notifications@d
                                                     omain.com

    ```

{{< /tab >}}

{{< /tabs >}}

{{< /tab >}}

{{< /tabs >}}

### Create Rules

Each rule is comprised of a single key-value pair. The key-value pair indicates what messages to include or drop from event information sent to a notification channel. You can create more than one rule for a single filter. Creating multiple rules for a given filter can provide a very defined filter. For example, you can specify rules around hostnames or interface names, enabling you to filter messages specific to those hosts or interfaces. You should have already defined channels (as described earlier).

There is a fixed set of valid rule keys. Values are entered as regular expressions and *vary according to your deployment*.

#### Rule Keys and Values

<table>
<tr>
<th>Service</th>
<th>Rule Key</th>
<th>Description</th>
<th>Example Rule Values</th>
</tr>
<tr>
<td rowspan="9">BGP</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>bgp</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf11, exit01, spine-4</td>
</tr>
<tr>
<td>peer</td>
<td>User-defined, text-based name for a peer switch or host</td>
<td>server4, leaf-3, exit02, spine06</td>
</tr>
<tr>
<td>desc</td>
<td>Text description</td>
<td> </td>
</tr>
<tr>
<td>vrf</td>
<td>Name of VRF interface</td>
<td>mgmt, default</td>
</tr>
<tr>
<td>old_state</td>
<td>Previous state of the BGP service</td>
<td>Established, Failed</td>
</tr>
<tr>
<td>new_state</td>
<td>Current state of the BGP service</td>
<td>Established, Failed</td>
</tr>
<tr>
<td>old_last_reset_time</td>
<td>Previous time that BGP service was reset</td>
<td>Apr3, 2019, 4:17 pm</td>
</tr>
<tr>
<td>new_last_reset_time</td>
<td>Most recent time that BGP service was reset</td>
<td>Apr8, 2019, 11:38 am</td>
</tr>
<tr>
<tr>
<td rowspan="5">ConfigDiff</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>configdiff</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf11, exit01, spine-4</td>
</tr>
<tr>
<td>vni</td>
<td>Virtual Network Instance identifier</td>
<td>12, 23</td>
</tr>
<tr>
<td>old_state</td>
<td>Previous state of the configuration file</td>
<td>created, modified</td>
</tr>
<tr>
<td>new_state</td>
<td>Current state of the configuration file</td>
<td>created, modified</td>
</tr>
<tr>
<td rowspan="7">EVPN</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>evpn</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf-9, exit01, spine04</td>
</tr>
<tr>
<td>vni</td>
<td>Virtual Network Instance identifier</td>
<td>12, 23</td>
</tr>
<tr>
<td>old_in_kernel_state</td>
<td>Previous VNI state, in kernel or not</td>
<td>true, false</td>
</tr>
<tr>
<td>new_in_kernel_state</td>
<td>Current VNI state, in kernel or not</td>
<td>true, false</td>
</tr>
<tr>
<td>old_adv_all_vni_state</td>
<td>Previous VNI advertising state, advertising all or not</td>
<td>true, false</td>
</tr>
<tr>
<td>new_adv_all_vni_state</td>
<td>Current VNI advertising state, advertising all or not</td>
<td>true, false</td>
</tr>
<td rowspan="6">LCM</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>clag</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf-9, exit01, spine04</td>
</tr>
<tr>
<td>old_conflicted_bonds</td>
<td>Previous pair of interfaces in a conflicted bond</td>
<td>swp7 swp8, swp3 swp4</td>
</tr>
<tr>
<td>new_conflicted_bonds</td>
<td>Current pair of interfaces in a conflicted bond</td>
<td>swp11 swp12, swp23 swp24</td>
</tr>
<tr>
<td>old_state_protodownbond</td>
<td>Previous state of the bond</td>
<td>protodown, up</td>
</tr>
<tr>
<td>new_state_protodownbond</td>
<td>Current state of the bond</td>
<td>protodown, up</td>
</tr>
<tr>
<td rowspan="3">Link</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>link</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf-6, exit01, spine7</td>
</tr>
<tr>
<td>ifname</td>
<td>Software interface name</td>
<td>eth0, swp53</td>
</tr>
<tr>
<td rowspan="7">LLDP</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>lldp</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf41, exit01, spine-5, tor-36</td>
</tr>
<tr>
<td>ifname</td>
<td>Software interface name</td>
<td>eth1, swp12</td>
</tr>
<tr>
<td>old_peer_ifname</td>
<td>Previous software interface name</td>
<td>eth1, swp12, swp27</td>
</tr>
<tr>
<td>new_peer_ifname</td>
<td>Current software interface name</td>
<td>eth1, swp12, swp27</td>
</tr>
<tr>
<td>old_peer_hostname</td>
<td>Previous user-defined, text-based name for a peer switch or host</td>
<td>server02, leaf41, exit01, spine-5, tor-36</td>
</tr>
<tr>
<td>new_peer_hostname</td>
<td>Current user-defined, text-based name for a peer switch or host</td>
<td>server02, leaf41, exit01, spine-5, tor-36</td>
</tr>
<td rowspan="6">MLAG (CLAG)</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>clag</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf-9, exit01, spine04</td>
</tr>
<tr>
<td>old_conflicted_bonds</td>
<td>Previous pair of interfaces in a conflicted bond</td>
<td>swp7 swp8, swp3 swp4</td>
</tr>
<tr>
<td>new_conflicted_bonds</td>
<td>Current pair of interfaces in a conflicted bond</td>
<td>swp11 swp12, swp23 swp24</td>
</tr>
<tr>
<td>old_state_protodownbond</td>
<td>Previous state of the bond</td>
<td>protodown, up</td>
</tr>
<tr>
<td>new_state_protodownbond</td>
<td>Current state of the bond</td>
<td>protodown, up</td>
</tr>
<tr>
<td rowspan="4">Node</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>node</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf41, exit01, spine-5, tor-36</td>
</tr>
<tr>
<td>ntp_state</td>
<td>Current state of NTP service</td>
<td>in sync, not sync</td>
</tr>
<tr>
<td>db_state</td>
<td>Current state of DB</td>
<td>Add, Update, Del, Dead</td>
</tr>
<tr>
<td rowspan="4">NTP</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>ntp</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf-9, exit01, spine04</td>
</tr>
<tr>
<td>old_state</td>
<td>Previous state of service</td>
<td>in sync, not sync</td>
</tr>
<tr>
<td>new_state</td>
<td>Current state of service</td>
<td>in sync, not sync</td>
</tr>
<tr>
<td rowspan="20">Port</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>port</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf13, exit01, spine-8, tor-36</td>
</tr>
<tr>
<td>ifname</td>
<td>Interface name</td>
<td>eth0, swp14</td>
</tr>
<tr>
<td>old_speed</td>
<td>Previous speed rating of port</td>
<td>10 G, 25 G, 40 G, unknown</td>
</tr>
<tr>
<td>old_transreceiver</td>
<td>Previous transceiver</td>
<td>40G Base-CR4, 25G Base-CR</td>
</tr>
<tr>
<td>old_vendor_name</td>
<td>Previous vendor name of installed port module</td>
<td>Amphenol, OEM, Mellanox, Fiberstore, Finisar</td>
</tr>
<tr>
<td>old_serial_number</td>
<td>Previous serial number of installed port module</td>
<td>MT1507VS05177, AVE1823402U, PTN1VH2</td>
</tr>
<tr>
<td>old_supported_fec</td>
<td>Previous forward error correction (FEC) support status</td>
<td>none, Base R, RS</td>
</tr>
<tr>
<td>old_advertised_fec</td>
<td>Previous FEC advertising state</td>
<td>true, false, not reported</td>
</tr>
<tr>
<td>old_fec</td>
<td>Previous FEC capability</td>
<td>none</td>
</tr>
<tr>
<td>old_autoneg</td>
<td>Previous activation state of auto-negotiation</td>
<td>on, off</td>
</tr>
<tr>
<td>new_speed</td>
<td>Current speed rating of port</td>
<td>10 G, 25 G, 40 G</td>
</tr>
<tr>
<td>new_transreceiver</td>
<td>Current transceiver</td>
<td>40G Base-CR4, 25G Base-CR</td>
</tr>
<tr>
<td>new_vendor_name</td>
<td>Current vendor name of installed port module</td>
<td>Amphenol, OEM, Mellanox, Fiberstore, Finisar</td>
</tr>
<tr>
<td>new_part_number</td>
<td>Current part number of installed port module</td>
<td>SFP-H10GB-CU1M, MC3309130-001, 603020003</td>
</tr>
<tr>
<td>new_serial_number</td>
<td>Current serial number of installed port module</td>
<td>MT1507VS05177, AVE1823402U, PTN1VH2</td>
</tr>
<tr>
<td>new_supported_fec</td>
<td>Current FEC support status</td>
<td>none, Base R, RS</td>
</tr>
<tr>
<td>new_advertised_fec</td>
<td>Current FEC advertising state</td>
<td>true, false</td>
</tr>
<tr>
<td>new_fec</td>
<td>Current FEC capability</td>
<td>none</td>
</tr>
<tr>
<td>new_autoneg</td>
<td>Current activation state of auto-negotiation</td>
<td>on, off</td>
</tr>
<tr>
<td rowspan="10">Sensors</td>
<td>sensor</td>
<td>Network protocol or service identifier</td>
<td>Fan: fan1, fan-2<br>
Power Supply Unit: psu1, psu2<br>
Temperature: psu1temp1, temp2</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf-26, exit01, spine2-4</td>
</tr>
<tr>
<td>old_state</td>
<td>Previous state of a fan, power supply unit, or thermal sensor</td>
<td>Fan: ok, absent, bad<br>  
PSU: ok, absent, bad<br>  
Temp: ok, busted, bad, critical</td>
</tr>
<tr>
<td>new_state</td>
<td>Current state of a fan, power supply unit, or thermal sensor</td>
<td>Fan: ok, absent, bad<br>  
PSU: ok, absent, bad<br>  
Temp: ok, busted, bad, critical</td>
</tr>
<tr>
<td>old_s_state</td>
<td>Previous state of a fan or power supply unit.</td>
<td>Fan: up, down<br>  
PSU: up, down</td>
</tr>
<tr>
<td>new_s_state</td>
<td>Current state of a fan or power supply unit.</td>
<td>Fan: up, down<br>  
PSU: up, down</td>
</tr>
<tr>
<td>new_s_max</td>
<td>Current maximum temperature threshold value</td>
<td>Temp: 110</td>
</tr>
<tr>
<td>new_s_crit</td>
<td>Current critical high temperature threshold value</td>
<td>Temp: 85</td>
</tr>
<tr>
<td>new_s_lcrit</td>
<td>Current critical low temperature threshold value</td>
<td>Temp: -25</td>
</tr>
<tr>
<td>new_s_min</td>
<td>Current minimum temperature threshold value</td>
<td>Temp: -50</td>
</tr>
<tr>
<td rowspan="7">Services</td>
<td>message_type</td>
<td>Network protocol or service identifier</td>
<td>services</td>
</tr>
<tr>
<td>hostname</td>
<td>User-defined, text-based name for a switch or host</td>
<td>server02, leaf03, exit01, spine-8</td>
</tr>
<tr>
<td>name</td>
<td>Name of service</td>
<td>clagd, lldpd, ssh, ntp, netqd, netq-agent</td>
</tr>
<tr>
<td>old_pid</td>
<td>Previous process or service identifier</td>
<td>12323, 52941</td>
</tr>
<tr>
<td>new_pid</td>
<td>Current process or service identifier</td>
<td>12323, 52941</td>
</tr>
<tr>
<td>old_status</td>
<td>Previous status of service</td>
<td>up, down</td>
</tr>
<tr>
<td>new_status</td>
<td>Current status of service</td>
<td>up, down</td>
</tr>
</table>

{{<notice note>}}

Rule names are case sensitive, and no wildcards are permitted. Rule names may contain spaces, but must be enclosed with single quotes in commands. It is easier to use dashes in place of spaces or mixed case for better readability. For example, use bgpSessionChanges or BGP-session-changes or BGPsessions, instead of 'BGP Session Changes'. Use Tab completion to view the command options syntax.

{{</notice>}}

#### Example Rules

Create a BGP Rule Based on Hostname:

    cumulus@switch:~$ netq add notification rule bgpHostname key hostname value spine-01
    Successfully added/updated rule bgpHostname 

Create a Rule Based on a Configuration File State Change:

    cumulus@switch:~$ netq add notification rule sysconf key configdiff value updated
    Successfully added/updated rule sysconf

Create an EVPN Rule Based on a VNI:

    cumulus@switch:~$ netq add notification rule evpnVni key vni value 42
    Successfully added/updated rule evpnVni

Create an Interface Rule Based on FEC Support:

    cumulus@switch:~$ netq add notification rule fecSupport key new_supported_fec value supported
    Successfully added/updated rule fecSupport

Create a Service Rule Based on a Status Change:

    cumulus@switch:~$ netq add notification rule svcStatus key new_status value down
    Successfully added/updated rule svcStatus

Create a Sensor Rule Based on a Threshold:

    cumulus@switch:~$ netq add notification rule overTemp key new_s_crit value 24
    Successfully added/updated rule overTemp

Create an Interface Rule Based on Port:

    cumulus@switch:~$ netq add notification rule swp52 key port value swp52
    Successfully added/updated rule swp52 

#### View the Rule Configurations

Use the `netq show notification` command to view the rules on your
platform.

    cumulus@switch:~$ netq show notification rule
     
    Matching config_notify records:
    Name            Rule Key         Rule Value
    --------------- ---------------- --------------------
    bgpHostname     hostname         spine-01
    evpnVni         vni              42
    fecSupport      new_supported_fe supported
                    c
    overTemp        new_s_crit       24
    svcStatus       new_status       down
    swp52           port             swp52
    sysconf         configdiff       updated

### Create Filters

You can limit or direct event messages using filters. Filters are created based on rules you define; like those in the previous section. Each filter contains one or more rules. When a message matches the rule, it is sent to the indicated destination. Before you can create filters, you need to have already defined the rules and configured channels (as described earlier).

As filters are created, they are added to the bottom of a filter list. By default, filters are processed in the order they appear in this list (from top to bottom) until a match is found. This means that each event message is first evaluated by the first filter listed, and if it matches then it is processed, ignoring all other filters, and the system moves on to the next event message received. If the event does not match the first filter, it is tested against the second filter, and if it matches then it is processed and the system moves on to the next event received. And so forth. Events that do not match any filter are ignored.

You may need to change the order of filters in the list to ensure you capture the events you want and drop the events you do not want. This is possible using the *before* or *after* keywords to ensure one rule is processed before or after another.

This diagram shows an example with four defined filters with sample output results.

{{<figure src="/images/netq/NQ-3x-Filter-Process-Flow.png" width="300">}}

{{<notice note>}}

Filter names may contain spaces, but <em>must</em> be enclosed with single quotes in commands. It is easier to use dashes in place of spaces or mixed case for better readability. For example, use bgpSessionChanges or BGP-session-changes or BGPsessions, instead of 'BGP Session Changes'. Filter names are also case sensitive.

{{</notice>}}

#### Example Filters

Create a filter for BGP Events on a Particular Device:

    cumulus@switch:~$ netq add notification filter bgpSpine rule bgpHostname channel pd-netq-events
    Successfully added/updated filter bgpSpine

Create a Filter for a Given VNI in Your EVPN Overlay:

    cumulus@switch:~$ netq add notification filter vni42 severity warning rule evpnVni channel pd-netq-events
    Successfully added/updated filter vni42

Create a Filter for when a Configuration File has been Updated:

    cumulus@switch:~$ netq add notification filter configChange severity info rule sysconf channel slk-netq-events
    Successfully added/updated filter configChange

Create a Filter to Monitor Ports with FEC Support:

    cumulus@switch:~$ netq add notification filter newFEC rule fecSupport channel slk-netq-events
    Successfully added/updated filter newFEC

Create a Filter to Monitor for Services that Change to a Down State:

    cumulus@switch:~$ netq add notification filter svcDown severity error rule svcStatus channel slk-netq-events
    Successfully added/updated filter svcDown

Create a Filter to Monitor Overheating Platforms:

    cumulus@switch:~$ netq add notification filter critTemp severity error rule overTemp channel onprem-email
    Successfully added/updated filter critTemp

Create a Filter to Drop Messages from a Given Interface, and match
against this filter before any other filters. To create a drop style
filter, do not specify a channel. To put the filter first, use the
*before* option.

    cumulus@switch:~$ netq add notification filter swp52Drop severity error rule swp52 before bgpSpine
    Successfully added/updated filter swp52Drop

#### View the Filter Configurations

Use the `netq show notification` command to view the filters on your
platform.

    cumulus@switch:~$ netq show notification filter
    Matching config_notify records:
    Name            Order      Severity         Channels         Rules
    --------------- ---------- ---------------- ---------------- ----------
    swp52Drop       1          error            NetqDefaultChann swp52
                                                el
    bgpSpine        2          info             pd-netq-events   bgpHostnam
                                                                 e
    vni42           3          warning          pd-netq-events   evpnVni
    configChange    4          info             slk-netq-events  sysconf
    newFEC          5          info             slk-netq-events  fecSupport
    svcDown         6          critical         slk-netq-events  svcStatus
    critTemp        7          critical         onprem-email     overTemp

#### Reorder Filters

When you look at the results of the `netq show notification filter` command above, you might notice that although you have the drop-based filter first (no point in looking at something you are going to drop anyway, so that is good), but the critical severity events are processed last, per the current definitions. If you wanted to process those before
lesser severity events, you can reorder the list using the `before` and `after` options.

For example, to put the two critical severity event filters just below the drop filter:

```
cumulus@switch:~$ netq add notification filter critTemp after swp52Drop
Successfully added/updated filter critTemp
cumulus@switch:~$ netq add notification filter svcDown before bgpSpine
Successfully added/updated filter svcDown
```

{{<notice tip>}}

You do not need to reenter all the severity, channel, and rule information for existing rules if you only want to change their processing order.

{{</notice>}}

Run the `netq show notification` command again to verify the changes:

```
cumulus@switch:~$ netq show notification filter
Matching config_notify records:
Name            Order      Severity         Channels         Rules
--------------- ---------- ---------------- ---------------- ----------
swp52Drop       1          error            NetqDefaultChann swp52
                                            el
critTemp        2          critical         onprem-email     overTemp
svcDown         3          critical         slk-netq-events  svcStatus
bgpSpine        4          info             pd-netq-events   bgpHostnam
                                                                e
vni42           5          warning          pd-netq-events   evpnVni
configChange    6          info             slk-netq-events  sysconf
newFEC          7          info             slk-netq-events  fecSupport
```

### Suppress Events

NetQ can generate many network events. You can configure whether to suppress any events from appearing in NetQ output. By default, all events are delivered.

You can suppress an event until a certain period of time; otherwise, the event is suppressed for 2 years. Providing an end time eliminates the generation of messages for a short period of time, which is useful when you are testing a new network configuration and the switch may be generating many messages.

You can suppress events for the following types of messages:

- agent: NetQ Agent messages
- bgp: BGP-related messages
- btrfsinfo: Messages related to the BTRFS file system in Cumulus Linux
- clag: MLAG-related messages
- clsupport: Messages generated when creating the `cl-support script`
- configdiff: Messages related to the difference between two configurations
- evpn: EVPN-related messages
- link: Messages related to links, including state and interface name
- ntp: NTP-related messages
- ospf: OSPF-related messages
- sensor: Messages related to various sensors
- services: Service-related information, including whether a service is active or inactive
- ssdutil: Messages related to the storage on the switch

#### Add an Event Suppression Configuration

When you add a new configuration, you can specify a scope, which limits the suppression in the following order:

1. Hostname.
1. Severity.
1. Message type-specific filters. For example, the target VNI for EVPN messages, or the interface name for a link message.

NetQ has a predefined set of filter conditions. To see these conditions, run `netq show events-config show-filter-conditions`:

```
cumulus@switch:~$ netq show events-config show-filter-conditions
Matching config_events records:
Message Name             Filter Condition Name                      Filter Condition Hierarchy                           Filter Condition Description
------------------------ ------------------------------------------ ---------------------------------------------------- --------------------------------------------------------
evpn                     vni                                        3                                                    Target VNI
evpn                     severity                                   2                                                    Severity critical/info
evpn                     hostname                                   1                                                    Target Hostname
clsupport                fileAbsName                                3                                                    Target File Absolute Name
clsupport                severity                                   2                                                    Severity critical/info
clsupport                hostname                                   1                                                    Target Hostname
link                     new_state                                  4                                                    up / down
link                     ifname                                     3                                                    Target Ifname
link                     severity                                   2                                                    Severity critical/info
link                     hostname                                   1                                                    Target Hostname
ospf                     ifname                                     3                                                    Target Ifname
ospf                     severity                                   2                                                    Severity critical/info
ospf                     hostname                                   1                                                    Target Hostname
sensor                   new_s_state                                4                                                    New Sensor State Eg. ok
sensor                   sensor                                     3                                                    Target Sensor Name Eg. Fan, Temp
sensor                   severity                                   2                                                    Severity critical/info
sensor                   hostname                                   1                                                    Target Hostname
configdiff               old_state                                  5                                                    Old State
configdiff               new_state                                  4                                                    New State
configdiff               type                                       3                                                    File Name
configdiff               severity                                   2                                                    Severity critical/info
configdiff               hostname                                   1                                                    Target Hostname
ssdutil                  info                                       3                                                    low health / significant health drop
ssdutil                  severity                                   2                                                    Severity critical/info
ssdutil                  hostname                                   1                                                    Target Hostname
agent                    db_state                                   3                                                    Database State
agent                    severity                                   2                                                    Severity critical/info
agent                    hostname                                   1                                                    Target Hostname
ntp                      new_state                                  3                                                    yes / no
ntp                      severity                                   2                                                    Severity critical/info
ntp                      hostname                                   1                                                    Target Hostname
bgp                      vrf                                        4                                                    Target VRF
bgp                      peer                                       3                                                    Target Peer
bgp                      severity                                   2                                                    Severity critical/info
bgp                      hostname                                   1                                                    Target Hostname
services                 new_status                                 4                                                    active / inactive
services                 name                                       3                                                    Target Service Name Eg.netqd, mstpd, zebra
services                 severity                                   2                                                    Severity critical/info
services                 hostname                                   1                                                    Target Hostname
btrfsinfo                info                                       3                                                    high btrfs allocation space / data storage efficiency
btrfsinfo                severity                                   2                                                    Severity critical/info
btrfsinfo                hostname                                   1                                                    Target Hostname
clag                     severity                                   2                                                    Severity critical/info
clag                     hostname                                   1                                                    Target Hostname
```

For example, to create a configuration called `mybtrfs` that suppresses OSPF-related events on leaf01 for the next 10 minutes, run:

```
netq add events-config events_config_name mybtrfs message_type ospf scope '[{"scope_name":"hostname","scope_value":"leaf01"},{"scope_name":"severity","scope_value":"*"}]' suppress_until 600
```

#### Remove an Event Suppression Configuration

To remove an event suppression configuration, run `netq del events-config events_config_id <text-events-config-id-anchor>`.

```
cumulus@switch:~$ netq del events-config events_config_id eventsconfig_10
Successfully deleted Events Config eventsconfig_10
```

#### Show Event Suppression Configurations

You can view all event suppression configurations, or you can filter by a specific configuration or message type.

```
cumulus@switch:~$ netq show events-config events_config_id eventsconfig_1
Matching config_events records:
Events Config ID     Events Config Name   Message Type         Scope                                                        Active Suppress Until
-------------------- -------------------- -------------------- ------------------------------------------------------------ ------ --------------------
eventsconfig_1       job_cl_upgrade_2d89c agent                {"db_state":"*","hostname":"spine02","severity":"*"}         True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine02
eventsconfig_1       job_cl_upgrade_2d89c bgp                  {"vrf":"*","peer":"*","hostname":"spine04","severity":"*"}   True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c btrfsinfo            {"hostname":"spine04","info":"*","severity":"*"}             True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c clag                 {"hostname":"spine04","severity":"*"}                        True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c clsupport            {"fileAbsName":"*","hostname":"spine04","severity":"*"}      True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c configdiff           {"new_state":"*","old_state":"*","type":"*","hostname":"spin True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                      e04","severity":"*"}                                                2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c evpn                 {"hostname":"spine04","vni":"*","severity":"*"}              True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c link                 {"ifname":"*","new_state":"*","hostname":"spine04","severity True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                      ":"*"}                                                              2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c ntp                  {"new_state":"*","hostname":"spine04","severity":"*"}        True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c ospf                 {"ifname":"*","hostname":"spine04","severity":"*"}           True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c sensor               {"sensor":"*","new_s_state":"*","hostname":"spine04","severi True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                      ty":"*"}                                                            2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c services             {"new_status":"*","name":"*","hostname":"spine04","severity" True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                      :"*"}                                                               2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_1       job_cl_upgrade_2d89c ssdutil              {"hostname":"spine04","info":"*","severity":"*"}             True   Tue Jul  7 16:16:20
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     spine04
eventsconfig_10      job_cl_upgrade_2d89c btrfsinfo            {"hostname":"fw2","info":"*","severity":"*"}                 True   Tue Jul  7 16:16:22
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     fw2
eventsconfig_10      job_cl_upgrade_2d89c clag                 {"hostname":"fw2","severity":"*"}                            True   Tue Jul  7 16:16:22
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     fw2
eventsconfig_10      job_cl_upgrade_2d89c clsupport            {"fileAbsName":"*","hostname":"fw2","severity":"*"}          True   Tue Jul  7 16:16:22
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     fw2
eventsconfig_10      job_cl_upgrade_2d89c link                 {"ifname":"*","new_state":"*","hostname":"fw2","severity":"* True   Tue Jul  7 16:16:22
                     21b3effd79796e585c35                      "}                                                                  2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     fw2
eventsconfig_10      job_cl_upgrade_2d89c ospf                 {"ifname":"*","hostname":"fw2","severity":"*"}               True   Tue Jul  7 16:16:22
                     21b3effd79796e585c35                                                                                          2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     fw2
eventsconfig_10      job_cl_upgrade_2d89c sensor               {"sensor":"*","new_s_state":"*","hostname":"fw2","severity": True   Tue Jul  7 16:16:22
                     21b3effd79796e585c35                      "*"}                                                                2020
                     096d5fc6cef32b463e37
                     cca88d8ee862ae104d5_
                     fw2
```

When you filter for a message type, you must include the `show-filter-conditions` keyword to show the conditions associated with that message type and the hierarchy in which they're processed.

```
cumulus@switch:~$ netq show events-config message_type evpn show-filter-conditions
Matching config_events records:
Message Name             Filter Condition Name                      Filter Condition Hierarchy                           Filter Condition Description
------------------------ ------------------------------------------ ---------------------------------------------------- --------------------------------------------------------
evpn                     vni                                        3                                                    Target VNI
evpn                     severity                                   2                                                    Severity critical/info
evpn                     hostname                                   1                                                    Target Hostname
```

## Examples of Advanced Notification Configurations

Putting all of these channel, rule, and filter definitions together you
create a complete notification configuration. The following are example
notification configurations are created using the three-step process
outlined above.

### Create a Notification for BGP Events from a Selected Switch

In this example, we created a notification integration with a PagerDuty
channel called *pd-netq-events*. We then created a rule *bgpHostname*
and a filter called *4bgpSpine* for any notifications from *spine-01*.
The result is that any info severity event messages from Spine-01 are
filtered to the *pd-netq-events* channel.

    cumulus@switch:~$ netq add notification channel pagerduty pd-netq-events integration-key 1234567890
    Successfully added/updated channel pd-netq-events
    cumulus@switch:~$ netq add notification rule bgpHostname key node value spine-01
    Successfully added/updated rule bgpHostname
     
    cumulus@switch:~$ netq add notification filter bgpSpine rule bgpHostname channel pd-netq-events
    Successfully added/updated filter bgpSpine
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity         Channel Info
    --------------- ---------------- ---------------- ------------------------
    pd-netq-events  pagerduty        info             integration-key: 1234567
                                                      890   

    cumulus@switch:~$ netq show notification rule
    Matching config_notify records:
    Name            Rule Key         Rule Value
    --------------- ---------------- --------------------
    bgpHostname     hostname         spine-01
     
    cumulus@switch:~$ netq show notification filter
    Matching config_notify records:
    Name            Order      Severity         Channels         Rules
    --------------- ---------- ---------------- ---------------- ----------
    bgpSpine        1          info             pd-netq-events   bgpHostnam
                                                                 e

### Create a Notification for Warnings on a Given EVPN VNI

In this example, we created a notification integration with a PagerDuty
channel called *pd-netq-events*. We then created a rule *evpnVni* and a
filter called *3vni42* for any warnings messages from VNI 42 on the EVPN
overlay network. The result is that any warning severity event messages
from VNI 42 are filtered to the *pd-netq-events* channel.

    cumulus@switch:~$ netq add notification channel pagerduty pd-netq-events integration-key 1234567890
    Successfully added/updated channel pd-netq-events
     
    cumulus@switch:~$ netq add notification rule evpnVni key vni value 42
    Successfully added/updated rule evpnVni
     
    cumulus@switch:~$ netq add notification filter vni42 rule evpnVni channel pd-netq-events
    Successfully added/updated filter vni42
     
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity         Channel Info
    --------------- ---------------- ---------------- ------------------------
    pd-netq-events  pagerduty        info             integration-key: 1234567
                                                      890   

    cumulus@switch:~$ netq show notification rule
    Matching config_notify records:
    Name            Rule Key         Rule Value
    --------------- ---------------- --------------------
    bgpHostname     hostname         spine-01
    evpnVni         vni              42
     
    cumulus@switch:~$ netq show notification filter
    Matching config_notify records:
    Name            Order      Severity         Channels         Rules
    --------------- ---------- ---------------- ---------------- ----------
    bgpSpine        1          info             pd-netq-events   bgpHostnam
                                                                 e
    vni42           2          warning          pd-netq-events   evpnVni

### Create a Notification for Configuration File Changes

In this example, we created a notification integration with a Slack
channel called *slk-netq-events*. We then created a rule *sysconf* and a
filter called *configChange* for any configuration file update messages.
The result is that any configuration update messages are filtered to the
*slk-netq-events* channel.

    cumulus@switch:~$ netq add notification channel slack slk-netq-events webhook https://hooks.slack.com/services/text/moretext/evenmoretext
    Successfully added/updated channel slk-netq-events
     
    cumulus@switch:~$ netq add notification rule sysconf key configdiff value updated
    Successfully added/updated rule sysconf
     
    cumulus@switch:~$ netq add notification filter configChange severity info rule sysconf channel slk-netq-events
    Successfully added/updated filter configChange
     
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity Channel Info
    --------------- ---------------- -------- ----------------------
    slk-netq-events slack            info     webhook:https://hooks.s
                                              lack.com/services/text/
                                              moretext/evenmoretext     
     
    cumulus@switch:~$ netq show notification rule
    Matching config_notify records:
    Name            Rule Key         Rule Value
    --------------- ---------------- --------------------
    bgpHostname     hostname         spine-01
    evpnVni         vni              42
    sysconf         configdiff       updated

    cumulus@switch:~$ netq show notification filter
    Matching config_notify records:
    Name            Order      Severity         Channels         Rules
    --------------- ---------- ---------------- ---------------- ----------
    bgpSpine        1          info             pd-netq-events   bgpHostnam
                                                                 e
    vni42           2          warning          pd-netq-events   evpnVni
    configChange    3          info             slk-netq-events  sysconf

### Create a Notification for When a Service Goes Down

In this example, we created a notification integration with a Slack
channel called *slk-netq-events*. We then created a rule *svcStatus* and
a filter called *svcDown* for any services state messages indicating a
service is no longer operational. The result is that any service down
messages are filtered to the *slk-netq-events* channel.

    cumulus@switch:~$ netq add notification channel slack slk-netq-events webhook https://hooks.slack.com/services/text/moretext/evenmoretext
    Successfully added/updated channel slk-netq-events
     
    cumulus@switch:~$ netq add notification rule svcStatus key new_status value down
    Successfully added/updated rule svcStatus
     
    cumulus@switch:~$ netq add notification filter svcDown severity error rule svcStatus channel slk-netq-events
    Successfully added/updated filter svcDown
     
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity Channel Info
    --------------- ---------------- -------- ----------------------
    slk-netq-events slack            info     webhook:https://hooks.s
                                              lack.com/services/text/
                                              moretext/evenmoretext     
     
    cumulus@switch:~$ netq show notification rule
    Matching config_notify records:
    Name            Rule Key         Rule Value
    --------------- ---------------- --------------------
    bgpHostname     hostname         spine-01
    evpnVni         vni              42
    svcStatus       new_status       down
    sysconf         configdiff       updated

    cumulus@switch:~$ netq show notification filter
    Matching config_notify records:
    Name            Order      Severity         Channels         Rules
    --------------- ---------- ---------------- ---------------- ----------
    bgpSpine        1          info             pd-netq-events   bgpHostnam
                                                                 e
    vni42           2          warning          pd-netq-events   evpnVni
    configChange    3          info             slk-netq-events  sysconf
    svcDown         4          critical         slk-netq-events  svcStatus

### Create a Filter to Drop Notifications from a Given Interface

In this example, we created a notification integration with a Slack
channel called *slk-netq-events*. We then created a rule *swp52* and a
filter called *swp52Drop* that drops all notifications for events from
interface *swp52*.

    cumulus@switch:~$ netq add notification channel slack slk-netq-events webhook https://hooks.slack.com/services/text/moretext/evenmoretext
    Successfully added/updated channel slk-netq-events
     
    cumulus@switch:~$ netq add notification rule swp52 key port value swp52
    Successfully added/updated rule swp52
     
    cumulus@switch:~$ netq add notification filter swp52Drop severity error rule swp52 before bgpSpine
    Successfully added/updated filter swp52Drop
     
    cumulus@switch:~$ netq show notification channel
    Matching config_notify records:
    Name            Type             Severity Channel Info
    --------------- ---------------- -------- ----------------------
    slk-netq-events slack            info     webhook:https://hooks.s
                                              lack.com/services/text/
                                              moretext/evenmoretext     
     
    cumulus@switch:~$ netq show notification rule
    Matching config_notify records:
    Name            Rule Key         Rule Value
    --------------- ---------------- --------------------
    bgpHostname     hostname         spine-01
    evpnVni         vni              42
    svcStatus       new_status       down
    swp52           port             swp52
    sysconf         configdiff       updated

    cumulus@switch:~$ netq show notification filter
    Matching config_notify records:
    Name            Order      Severity         Channels         Rules
    --------------- ---------- ---------------- ---------------- ----------
    swp52Drop       1          error            NetqDefaultChann swp52
                                                el
    bgpSpine        2          info             pd-netq-events   bgpHostnam
                                                                 e
    vni42           3          warning          pd-netq-events   evpnVni
    configChange    4          info             slk-netq-events  sysconf
    svcDown         5          critical         slk-netq-events  svcStatus

### Create a Notification for a Given Device that has a Tendency to Overheat (using multiple rules)

In this example, we created a notification when switch *leaf04* has
passed over the high temperature threshold. Two rules were needed to
create this notification, one to identify the specific device and one to
identify the temperature trigger. We sent the message to the
*pd-netq-events* channel.

```
cumulus@switch:~$ netq add notification channel pagerduty pd-netq-events integration-key 1234567890
Successfully added/updated channel pd-netq-events
 
cumulus@switch:~$ netq add notification rule switchLeaf04 key hostname value leaf04
Successfully added/updated rule switchLeaf04
cumulus@switch:~$ netq add notification rule overTemp key new_s_crit value 24
Successfully added/updated rule overTemp
 
cumulus@switch:~$ netq add notification filter critTemp rule switchLeaf04 channel pd-netq-events
Successfully added/updated filter critTemp
cumulus@switch:~$ netq add notification filter critTemp severity critical rule overTemp channel pd-netq-events
Successfully added/updated filter critTemp
 
cumulus@switch:~$ netq show notification channel
Matching config_notify records:
Name            Type             Severity         Channel Info
--------------- ---------------- ---------------- ------------------------
pd-netq-events  pagerduty        info             integration-key: 1234567
                                                  890

cumulus@switch:~$ netq show notification rule
Matching config_notify records:
Name            Rule Key         Rule Value
--------------- ---------------- --------------------
bgpHostname     hostname         spine-01
evpnVni         vni              42
overTemp        new_s_crit       24
svcStatus       new_status       down
switchLeaf04    hostname         leaf04
swp52           port             swp52
sysconf         configdiff       updated

cumulus@switch:~$ netq show notification filter
Matching config_notify records:
Name            Order      Severity         Channels         Rules
--------------- ---------- ---------------- ---------------- ----------
swp52Drop       1          error            NetqDefaultChann swp52
                                            el
bgpSpine        2          info             pd-netq-events   bgpHostnam
                                                             e
vni42           3          warning          pd-netq-events   evpnVni
configChange    4          info             slk-netq-events  sysconf
svcDown         5          critical         slk-netq-events  svcStatus
critTemp        6          critical         pd-netq-events   switchLeaf
                                                             04
                                                             overTemp
```

### View Notification Configurations in JSON Format

You can view configured integrations using the `netq show notification` commands. To view the channels, filters, and rules, run the three flavors of the command. Include the `json` option to display JSON-formatted output.

For example:

    cumulus@switch:~$ netq show notification channel json
    {
        "config_notify":[
            {
                "type":"slack",
                "name":"slk-netq-events",
                "channelInfo":"webhook:https://hooks.slack.com/services/text/moretext/evenmoretext",
                "severity":"info"
            },
            {
                "type":"pagerduty",
                "name":"pd-netq-events",
                "channelInfo":"integration-key: 1234567890",
                "severity":"info"
        }
        ],
        "truncatedResult":false
    }
     
    cumulus@switch:~$ netq show notification rule json
    {
        "config_notify":[
            {
                "ruleKey":"hostname",
                "ruleValue":"spine-01",
                "name":"bgpHostname"
            },
            {
                "ruleKey":"vni",
                "ruleValue":42,
                "name":"evpnVni"
            },
            {
                "ruleKey":"new_supported_fec",
                "ruleValue":"supported",
                "name":"fecSupport"
            },
            {
                "ruleKey":"new_s_crit",
                "ruleValue":24,
                "name":"overTemp"
            },
            {
                "ruleKey":"new_status",
                "ruleValue":"down",
                "name":"svcStatus"
            },
            {
                "ruleKey":"configdiff",
                "ruleValue":"updated",
                "name":"sysconf"
        }
        ],
        "truncatedResult":false
    }
     
    cumulus@switch:~$ netq show notification filter json
    {
        "config_notify":[
            {
                "channels":"pd-netq-events",
                "rules":"overTemp",
                "name":"1critTemp",
                "severity":"critical"
            },
            {
                "channels":"pd-netq-events",
                "rules":"evpnVni",
                "name":"3vni42",
                "severity":"warning"
            },
            {
                "channels":"pd-netq-events",
                "rules":"bgpHostname",
                "name":"4bgpSpine",
                "severity":"info"
            },
            {
                "channels":"slk-netq-events",
                "rules":"sysconf",
                "name":"configChange",
                "severity":"info"
            },
            {
                "channels":"slk-netq-events",
                "rules":"fecSupport",
                "name":"newFEC",
                "severity":"info"
            },
            {
                "channels":"slk-netq-events",
                "rules":"svcStatus",
                "name":"svcDown",
                "severity":"critical"
        }
        ],
        "truncatedResult":false
    }

## Manage NetQ Event Notification Integrations

You might need to modify event notification configurations at some point in the lifecycle of your deployment. You can add channels, rules, filters, and a proxy at any time. You can remove channels, rules, and filters if they are not part of an existing notification configuration.

For integrations with threshold-based event notifications, refer to {{<link title="#Manage Threshold-based Event Notifications">}}.

### Remove an Event Notification Channel

If you retire selected channels from a given notification application, you might want to remove them from NetQ as well. You can remove channels if they are not part of an existing notification configuration using the NetQ UI or the NetQ CLI.

{{< tabs "TabID1908" >}}

{{< tab "NetQ UI" >}}

To remove notification channels:

1. Click <img src="https://icons.cumulusnetworks.com/01-Interface-Essential/03-Menu/navigation-menu.svg" height="18" width="18"/>, and then click **Channels** in the **Notifications** column.

    {{<figure src="/images/netq/main-menu-channels-selected-300.png" width="600">}}

<div style="padding-left: 18px;">This opens the Channels view.</div>

    {{<figure src="/images/netq/channels-slack-created-300.png" width="700">}}

2. Click the tab for the type of channel you want to remove (Slack, PagerDuty, Syslog, Email).

3. Select one or more channels.

4. Click <img src="https://icons.cumulusnetworks.com/01-Interface-Essential/23-Delete/bin-1.svg" height="18" width="18"/>.

{{< /tab >}}

{{< tab "NetQ CLI" >}}

To remove notification channels, run:

```
netq config del notification channel <text-channel-name-anchor>
```

This example removes a Slack integration and verifies it is no longer in
the configuration:

```
cumulus@switch:~$ netq del notification channel slk-netq-events

cumulus@switch:~$ netq show notification channel
Matching config_notify records:
Name            Type             Severity         Channel Info
--------------- ---------------- ---------------- ------------------------
pd-netq-events  pagerduty        info             integration-key: 1234567
                                                    890
```

{{< /tab >}}

{{< /tabs >}}

### Delete an Event Notification Rule

You may find after some experience with a given rule that you want to edit or remove the rule to better meet your needs. You can remove rules if they are not part of an existing notification configuration using the NetQ CLI.

To remove notification rules, run:

```
netq config del notification rule <text-rule-name-anchor>
```

This example removes a rule named *swp52* and verifies it is no longer in
the configuration:

```
cumulus@switch:~$ netq del notification rule swp52

cumulus@switch:~$ netq show notification rule
Matching config_notify records:
Name            Rule Key         Rule Value
--------------- ---------------- --------------------
bgpHostname     hostname         spine-01
evpnVni         vni              42
overTemp        new_s_crit       24
svcStatus       new_status       down
switchLeaf04    hostname         leaf04
sysconf         configdiff       updated
```

### Delete an Event Notification Filter

You may find after some experience with a given filter that you want to edit or remove the filter to better meet your current needs. You can remove filters if they are not part of an existing notification configuration using the NetQ CLI.

To remove notification filters, run:

```
netq del notification filter <text-filter-name-anchor>
```

This example removes a filter named *bgpSpine* and verifies it is no longer in
the configuration:

```
cumulus@switch:~$ netq del notification filter bgpSpine

cumulus@switch:~$ netq show notification filter
Matching config_notify records:
Name            Order      Severity         Channels         Rules
--------------- ---------- ---------------- ---------------- ----------
swp52Drop       1          error            NetqDefaultChann swp52
                                            el
vni42           2          warning          pd-netq-events   evpnVni
configChange    3          info             slk-netq-events  sysconf
svcDown         4          critical         slk-netq-events  svcStatus
critTemp        5          critical         pd-netq-events   switchLeaf
                                                                04
                                                                overTemp
```

### Delete an Event Notification Proxy

You can remove the proxy server by running the `netq del notification proxy` command. This changes the NetQ behavior to send events directly to the notification channels.

```
cumulus@switch:~$ netq del notification proxy
Successfully overwrote notifier proxy to null
```
