---
title: Manage Events and Notifications
author: NVIDIA
weight: 770
toc: 3
---
Events provide information about how the network and its devices are operating. NetQ allows you to view current events and compare that with events at an earlier time. Event notifications are available through Slack, PagerDuty, syslog, and Email channels and aid troubleshooting and resolution of problems in the network before they become critical.

Three types of events are available in NetQ:

- **System**: wide range of events generated by the system about network protocols and services operation, hardware and software status, and system services
- **Threshold-based** (TCA): selected set of system-related events generated based on user-configured threshold values
- **What Just Happened** (WJH): network hardware events generated when WJH feature is enabled on NVIDIA Spectrum&trade; switches

The NetQ UI provides two event workflows and two summary tables:

- Events|Alarms card: tracks critical severity system and TCA events for a given time frame
- Events|Info card: tracks all warning, info, and debug severity system and TCA events for a given time frame
- All Events table: lists all system events in the last 24 hours
- What Just Happened table: lists the 1000 most recent WJH events in the last 24 hours

The NetQ CLI provides the `netq show events` command to view system and TCA events for a given time frame. The `netq show wjh-drop` command lists all WJH events or those with a selected drop type.

To take advantage of these events, use the instructions contained in this topic to configure one or more notification channels for system and threshold-based events and setup WJH for selected switches.
