---
title: NVIDIA NetQ 3.3 Release Notes
author: NVIDIA/NVIDIA
weight: 30
product: Cumulus NetQ
version: "3.3"
toc: 1
type: rn
pdfhidden: True
---
<a href="/cumulus-netq-33/rn.xls"> {{<rn_icon alt="Download 3.3 Release Notes xls" >}}</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="/cumulus-netq-33/rn.xls">Download all 3.3 release notes as .xls</a>
## 3.3.1 Release Notes
### Open issues in 3.3.1

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="2555854"></a> [2555854](#2555854) <a name="2555854"></a> <br />NETQ-8245 | NetQ Agent: If a NetQ Agent is downgraded to the 3.0.0 version from any higher release, the default commands file present in the _/etc/netq/commands/_ also needs to be updated to prevent the NetQ Agent from becoming rotten. | 3.0.0-3.3.1 | |
| <a name="2555197"></a> [2555197](#2555197) <a name="2555197"></a> <br />NETQ-7966 | NetQ CLI: Occasionally, when a command response contains a large number of objects to be displayed the NetQ CLI does not display all results in the console. When this occurs, view all results using the <code>json</code> format option. | 3.3.0-3.3.1 | |
| <a name="2553453"></a> [2553453](#2553453) <a name="2553453"></a> <br />NETQ-7318 | The <code>netqd</code> daemon logs a traceback to _/var/log/netqd.log_ when the OPTA server is unreachable and <code>netq show</code> commands are run. | 3.1.0-3.3.1 | |
| <a name="2551545"></a> [2551545](#2551545) <a name="2551545"></a> <br />NETQ-6640 | Infra: Rarely, after a node is restarted, Kubernetes pods do not synchronize properly and the output of <code>netq show opta-health</code> shows failures. Node operation is not functionally impacted. You can safely remove the failures by running <code>kubectl get pods \| grep MatchNodeSelector \| cut \-f1 \-d' ' \| xargs kubectl delete pod</code>. To work around the issue, do not label nodes using the API. Instead label nodes through local configuration using <code>kubelet flag "--node-labels"</code>. | 3.1.0-3.3.1 | |
| <a name="2549649"></a> [2549649](#2549649) <a name="2549649"></a> <br />NETQ-5737 | NetQ UI: Warnings might appear during the post-upgrade phase for a Cumulus Linux switch upgrade job. They are caused by services that have not yet been restored by the time the job is complete. Cumulus Networks recommend waiting five minutes, creating a network snapshot, then comparing that to the pre-upgrade snapshot. If the comparison shows no differences for the services, the warnings can be ignored. If there are differences, then troubleshooting the relevant service(s) is recommended. | 3.0.0-3.3.1 | |
| <a name="2549319"></a> [2549319](#2549319) <a name="2549319"></a> <br />NETQ-5571 | NetQ UI: The legend and segment colors on Switches and Upgrade History card graphs sometimes do not match. These cards appear on the lifecycle management dashboard (Manage Switch Assets view). Hover over graph to view the correct values. | 3.0.0-3.3.1 | |
| <a name="2543867"></a> [2543867](#2543867) <a name="2543867"></a> <br />NETQ-3451 | NetQ UI: If either the hostname or the ASN of a BGP peer is invalid, the full screen BGP Service card does not provide the ability to open cards for a selected BGP session. | 2.3.0-2.4.1, 3.0.0-3.3.1 | |

### Fixed Issues in 3.3.1
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="2556545"></a> [2556545](#2556545) <a name="2556545"></a> <br />NETQ-8556 | NetQ Agent: When upgrading to NetQ 3.3.0, sometimes the NetQ Agent fails to complete the upgrade on Broadcom-based swtiches. To work around this issue, update the following file on the switch where the NetQ Agent is running:<br>Open the _armel-netq-commands.yml_ file in the _/etc/netq/commands/_ directory for editing.<br>Copy and append the following to the file:<pre> - service: "inventory"<br />   commands:<br />     - key: "os-release"<br />       command: "cat /etc/os-release"<br />       isactive: true<br />       parser: "local"<br />     - key: "eprom"<br />       command: "/usr/cumulus/bin/decode-syseeprom -j"<br />       isactive: true<br />       parser: "local"<br />     - key: "lscpu"<br />       command: "/usr/bin/lscpu"<br />       isactive: true<br />       parser: "local"<br />     - key: "meminfo"<br />       command: "cat /proc/meminfo"<br />       isactive: true<br />       parser: "local"<br />     - key: "lsblk"<br />       command: "lsblk -d -n -o name,size,type,vendor,tran,rev,model"<br />       isactive: true<br />       parser: "local"<br />     - key: "dmicode"<br />       command: "dmidecode -t 17"<br />       isactive: true<br />       parser: "local"<br />     - key: "is-opta"<br />       command: "cat /etc/app-release"<br />       isactive: true<br />       parser: "local"</pre>Remove the existing generated command file<br /><pre>cumulus&#64;switch:~$ rm /var/run/netq/netq-commands.yml</pre>Restart the NetQ Agent<br /><pre>cumulus&#64;switch:~$ netq config restart agent</pre> | 3.3.0 | |
| <a name="2556434"></a> [2556434](#2556434) <a name="2556434"></a> <br />NETQ-8492 | NetQ UI: When switches are running NetQ but hosts are not, the topology does not display the spine and leaf layers as separate tiers. | 3.3.0 | |
| <a name="2556275"></a> [2556275](#2556275) <a name="2556275"></a> <br />NETQ-8410 | NetQ UI: The full-screen BGP Validation card for the default validation can become unresponsive when a very large number of sessions or errors are present. | 3.3.0 | |
| <a name="2556268"></a> [2556268](#2556268) <a name="2556268"></a> <br />NETQ-8409 | NetQ UI: When assigning a switch configuration profile to a switch using the lifecycle management, you cannot save the per-switch variable data. This prevents you from applying the switch configuration. Upgrade to NetQ 3.3.1 to take advantage of this feature. | 3.3.0 | |
| <a name="2556227"></a> [2556227](#2556227) <a name="2556227"></a> <br />NETQ-8396 | Admin UI: For cloud deployments, clicking the _Open NetQ_ link at the bottom of the Admin UI NetQ Health page returns an error _default backend - 404_ as it attempts to open the NetQ UI on the on-site NetQ Cloud Appliance or VM running the NetQ Collector software. In cloud deployments, the NetQ UI is run in the Cloud rather than locally, thus causing the error. To open the NetQ UI and view your data, enter _https://netq.cumulusnetworks.com/_ into the address bar of your browser. | 3.3.0 | |
| <a name="2556205"></a> [2556205](#2556205) <a name="2556205"></a> <br /> | NetQ CLI: User cannot remove a notification channel when threshold-based event rules are configured. | 3.2.1-3.3.0 | |
| <a name="2556192"></a> [2556192](#2556192) <a name="2556192"></a> <br />NETQ-8387 | NetQ UI: In multi-site on-premises deployments, when a new premises (created using the Premises card) is selected from the dropdown in the application header, the NetQ UI becomes unresponsive for many navigation tabs. To work around this issue, manually update the database as follows:<br>In a terminal window, open the database shell (cqlsh)<br /><pre>$ CASSANDRA_POD='kubectl get pods \| grep cassandra \| cut -f1 -d" "' ; kubectl exec -it $CASSANDRA_POD -- cqlsh</pre>Display the premises table<br /><pre>cqlsh> select opid,name,namespace from master.premises ;</pre>The resulting output would be similar to this, with new premises having an empty namespace:<pre><br />opid  \| name  \| namespace-------+-------+-----------<br />20001 \| site1 \|      null<br />    0 \| OPID0 \|      null<br />20002 \| site2 \|          <br />20000 \| site0 \|      null<br />20003 \| site3 \|          (5 rows)</pre>For each new premises, insert a _null_ value into the database to resolve the issue. For example the new premises _site3_ has an empty namespace value, run following query against its opid _20003_ to change the value<br /><pre>cqlsh> insert into master.premises (opid,namespace) values (20003,null);</pre>Verify the new premises now have null values in the database<br /><pre>cqlsh> select opid,name,namespace from master.premises ;<br />opid  \| name  \| namespace-------+-------+-----------<br />20001 \| site1 \|      null<br />    0 \| OPID0 \|      null<br />20002 \| site2 \|      null     <br />20000 \| site0 \|      null<br />20003 \| site3 \|      null(5 rows)</pre> | 3.3.0 | |
| <a name="2556117"></a> [2556117](#2556117) <a name="2556117"></a> <br />NETQ-8353 | NetQ Infra: The NetQ Agent fails to start when switch is running Cumulus Linux version 4.1.1 or 4.2.0. To work around this issue, run the following on each switch:<br>For CL 4.1.1, rename the WJH types file to the 4.3.3260 version:<pre>cumulus&#64;switch:~$ sudo mv /usr/lib/cumulus/wjh/wjh_types_4.4.3260.py /usr/lib/cumulus/wjh/wjh_types_4.3.3260.py </pre>Then restart the NetQ Agent:<pre>cumulus&#64;switch:~$ netq config restart agent</pre>For CL 4.2.0, edit the following line in the /usr/sbin/netq-agent-prestart script to change the version from 4.4.095 to 4.4.0952:<pre>elif &#91; $sx_sdk_ver == “4.4.0952” &#93; \|\| &#91;  $sx_sdk_ver == “4.4.1624” &#93; \|\| &#91; $sx_sdk_ver == “4.3.3260” &#93;; </pre>Then restart the NetQ Agent:<pre>cumulus&#64;switch:~$ netq config restart agent</pre> | 3.3.0 | |
| <a name="2556007"></a> [2556007](#2556007) <a name="2556007"></a> <br />NETQ-8312 | NetQ API: Several APIs are presenting the following error when viewed in Swagger UI:<pre>Fetch errorundefined https://api.prod2.netq.cumulusnetworks.com/netq/telemetry/v1/api-docs/events/swagger.json</pre>To correct this presentation issue:Open the netqui YAML file for editing<br /><pre>kubectl edit netquis netqui</pre>Locate the _misc_ section. For example:<pre>misc:<br /> cassandraReconnectLogOnly: "true"<br /> clusterName: netq<br /> forgotPasswordLink: /link/to/set/password<br /> ...<br /> smtpSSL: "true"<br /> tlsEnabled: "true"</pre>Add the <code>document_namespace</code> parameter below the <code>tlsEnabled</code> parameter<br /><pre>misc:<br /> cassandraReconnectLogOnly: "true"<br /> clusterName: netq<br /> forgotPasswordLink: /link/to/set/password<br /> ...<br /> smtpSSL: "true"<br /> tlsEnabled: "true"<br /> document_namespace: "default"</pre>Save the file. | 3.3.0 | |
| <a name="2555848"></a> [2555848](#2555848) <a name="2555848"></a> <br />NETQ-8244 | NetQ Infra: It is important to plan your upgrade to NetQ 3.3.0 because the NetQ Appliance or VM becomes unavailable for approximately an hour during the process. No data is lost in the process. | 3.3.0 | |
| <a name="2555617"></a> [2555617](#2555617) <a name="2555617"></a> <br />NETQ-8131 | NetQ Infra: Upgrading the NetQ Agent before upgrading the NetQ CLI for version 3.3.0 causes the NetQ CLI to fail the upgrade. To work around this issue, upgrade the NetQ CLI first, then follow with the NetQ Agent upgrade. | 3.3.0 | |
| <a name="2555587"></a> [2555587](#2555587) <a name="2555587"></a> <br />NETQ-8117 | NetQ UI: Switches with LLDP enabled only on eth0 are not shown on the topology diagram. | 3.3.0 | |

## 3.3.0 Release Notes
### Open issues in 3.3.0

|  Issue ID 	|   Description	|   Affects	|   Fixed |
|---	        |---	        |---	    |---	                |
| <a name="2556545"></a> [2556545](#2556545) <a name="2556545"></a> <br />NETQ-8556 | NetQ Agent: When upgrading to NetQ 3.3.0, sometimes the NetQ Agent fails to complete the upgrade on Broadcom-based swtiches. To work around this issue, update the following file on the switch where the NetQ Agent is running:<br>Open the _armel-netq-commands.yml_ file in the _/etc/netq/commands/_ directory for editing.<br>Copy and append the following to the file:<pre> - service: "inventory"<br />   commands:<br />     - key: "os-release"<br />       command: "cat /etc/os-release"<br />       isactive: true<br />       parser: "local"<br />     - key: "eprom"<br />       command: "/usr/cumulus/bin/decode-syseeprom -j"<br />       isactive: true<br />       parser: "local"<br />     - key: "lscpu"<br />       command: "/usr/bin/lscpu"<br />       isactive: true<br />       parser: "local"<br />     - key: "meminfo"<br />       command: "cat /proc/meminfo"<br />       isactive: true<br />       parser: "local"<br />     - key: "lsblk"<br />       command: "lsblk -d -n -o name,size,type,vendor,tran,rev,model"<br />       isactive: true<br />       parser: "local"<br />     - key: "dmicode"<br />       command: "dmidecode -t 17"<br />       isactive: true<br />       parser: "local"<br />     - key: "is-opta"<br />       command: "cat /etc/app-release"<br />       isactive: true<br />       parser: "local"</pre>Remove the existing generated command file<br /><pre>cumulus&#64;switch:~$ rm /var/run/netq/netq-commands.yml</pre>Restart the NetQ Agent<br /><pre>cumulus&#64;switch:~$ netq config restart agent</pre> | 3.3.0 | 3.3.1|
| <a name="2556434"></a> [2556434](#2556434) <a name="2556434"></a> <br />NETQ-8492 | NetQ UI: When switches are running NetQ but hosts are not, the topology does not display the spine and leaf layers as separate tiers. | 3.3.0 | 3.3.1|
| <a name="2556275"></a> [2556275](#2556275) <a name="2556275"></a> <br />NETQ-8410 | NetQ UI: The full-screen BGP Validation card for the default validation can become unresponsive when a very large number of sessions or errors are present. | 3.3.0 | 3.3.1|
| <a name="2556268"></a> [2556268](#2556268) <a name="2556268"></a> <br />NETQ-8409 | NetQ UI: When assigning a switch configuration profile to a switch using the lifecycle management, you cannot save the per-switch variable data. This prevents you from applying the switch configuration. Upgrade to NetQ 3.3.1 to take advantage of this feature. | 3.3.0 | 3.3.1|
| <a name="2556227"></a> [2556227](#2556227) <a name="2556227"></a> <br />NETQ-8396 | Admin UI: For cloud deployments, clicking the _Open NetQ_ link at the bottom of the Admin UI NetQ Health page returns an error _default backend - 404_ as it attempts to open the NetQ UI on the on-site NetQ Cloud Appliance or VM running the NetQ Collector software. In cloud deployments, the NetQ UI is run in the Cloud rather than locally, thus causing the error. To open the NetQ UI and view your data, enter _https://netq.cumulusnetworks.com/_ into the address bar of your browser. | 3.3.0 | 3.3.1|
| <a name="2556205"></a> [2556205](#2556205) <a name="2556205"></a> <br /> | NetQ CLI: User cannot remove a notification channel when threshold-based event rules are configured. | 3.2.1-3.3.0 | 3.3.1|
| <a name="2556192"></a> [2556192](#2556192) <a name="2556192"></a> <br />NETQ-8387 | NetQ UI: In multi-site on-premises deployments, when a new premises (created using the Premises card) is selected from the dropdown in the application header, the NetQ UI becomes unresponsive for many navigation tabs. To work around this issue, manually update the database as follows:<br>In a terminal window, open the database shell (cqlsh)<br /><pre>$ CASSANDRA_POD='kubectl get pods \| grep cassandra \| cut -f1 -d" "' ; kubectl exec -it $CASSANDRA_POD -- cqlsh</pre>Display the premises table<br /><pre>cqlsh> select opid,name,namespace from master.premises ;</pre>The resulting output would be similar to this, with new premises having an empty namespace:<pre><br />opid  \| name  \| namespace-------+-------+-----------<br />20001 \| site1 \|      null<br />    0 \| OPID0 \|      null<br />20002 \| site2 \|          <br />20000 \| site0 \|      null<br />20003 \| site3 \|          (5 rows)</pre>For each new premises, insert a _null_ value into the database to resolve the issue. For example the new premises _site3_ has an empty namespace value, run following query against its opid _20003_ to change the value<br /><pre>cqlsh> insert into master.premises (opid,namespace) values (20003,null);</pre>Verify the new premises now have null values in the database<br /><pre>cqlsh> select opid,name,namespace from master.premises ;<br />opid  \| name  \| namespace-------+-------+-----------<br />20001 \| site1 \|      null<br />    0 \| OPID0 \|      null<br />20002 \| site2 \|      null     <br />20000 \| site0 \|      null<br />20003 \| site3 \|      null(5 rows)</pre> | 3.3.0 | 3.3.1|
| <a name="2556117"></a> [2556117](#2556117) <a name="2556117"></a> <br />NETQ-8353 | NetQ Infra: The NetQ Agent fails to start when switch is running Cumulus Linux version 4.1.1 or 4.2.0. To work around this issue, run the following on each switch:<br>For CL 4.1.1, rename the WJH types file to the 4.3.3260 version:<pre>cumulus&#64;switch:~$ sudo mv /usr/lib/cumulus/wjh/wjh_types_4.4.3260.py /usr/lib/cumulus/wjh/wjh_types_4.3.3260.py </pre>Then restart the NetQ Agent:<pre>cumulus&#64;switch:~$ netq config restart agent</pre>For CL 4.2.0, edit the following line in the /usr/sbin/netq-agent-prestart script to change the version from 4.4.095 to 4.4.0952:<pre>elif &#91; $sx_sdk_ver == “4.4.0952” &#93; \|\| &#91;  $sx_sdk_ver == “4.4.1624” &#93; \|\| &#91; $sx_sdk_ver == “4.3.3260” &#93;; </pre>Then restart the NetQ Agent:<pre>cumulus&#64;switch:~$ netq config restart agent</pre> | 3.3.0 | 3.3.1|
| <a name="2556015"></a> [2556015](#2556015) <a name="2556015"></a> <br />NETQ-8317 | NetQ Infra: When adding a data source with the Grafana plugin, an error message appears "Cannot read property 'status' of undefined" implying the data source is not added when, in fact, it has been. Ignore the error and continue with configuring the plugin. | 3.3.0 | 3.3.1|
| <a name="2556007"></a> [2556007](#2556007) <a name="2556007"></a> <br />NETQ-8312 | NetQ API: Several APIs are presenting the following error when viewed in Swagger UI:<pre>Fetch errorundefined https://api.prod2.netq.cumulusnetworks.com/netq/telemetry/v1/api-docs/events/swagger.json</pre>To correct this presentation issue:Open the netqui YAML file for editing<br /><pre>kubectl edit netquis netqui</pre>Locate the _misc_ section. For example:<pre>misc:<br /> cassandraReconnectLogOnly: "true"<br /> clusterName: netq<br /> forgotPasswordLink: /link/to/set/password<br /> ...<br /> smtpSSL: "true"<br /> tlsEnabled: "true"</pre>Add the <code>document_namespace</code> parameter below the <code>tlsEnabled</code> parameter<br /><pre>misc:<br /> cassandraReconnectLogOnly: "true"<br /> clusterName: netq<br /> forgotPasswordLink: /link/to/set/password<br /> ...<br /> smtpSSL: "true"<br /> tlsEnabled: "true"<br /> document_namespace: "default"</pre>Save the file. | 3.3.0 | 3.3.1|
| <a name="2555854"></a> [2555854](#2555854) <a name="2555854"></a> <br />NETQ-8245 | NetQ Agent: If a NetQ Agent is downgraded to the 3.0.0 version from any higher release, the default commands file present in the _/etc/netq/commands/_ also needs to be updated to prevent the NetQ Agent from becoming rotten. | 3.0.0-3.3.1 | |
| <a name="2555848"></a> [2555848](#2555848) <a name="2555848"></a> <br />NETQ-8244 | NetQ Infra: It is important to plan your upgrade to NetQ 3.3.0 because the NetQ Appliance or VM becomes unavailable for approximately an hour during the process. No data is lost in the process. | 3.3.0 | 3.3.1|
| <a name="2555617"></a> [2555617](#2555617) <a name="2555617"></a> <br />NETQ-8131 | NetQ Infra: Upgrading the NetQ Agent before upgrading the NetQ CLI for version 3.3.0 causes the NetQ CLI to fail the upgrade. To work around this issue, upgrade the NetQ CLI first, then follow with the NetQ Agent upgrade. | 3.3.0 | 3.3.1|
| <a name="2555587"></a> [2555587](#2555587) <a name="2555587"></a> <br />NETQ-8117 | NetQ UI: Switches with LLDP enabled only on eth0 are not shown on the topology diagram. | 3.3.0 | 3.3.1|
| <a name="2555197"></a> [2555197](#2555197) <a name="2555197"></a> <br />NETQ-7966 | NetQ CLI: Occasionally, when a command response contains a large number of objects to be displayed the NetQ CLI does not display all results in the console. When this occurs, view all results using the <code>json</code> format option. | 3.3.0-3.3.1 | |
| <a name="2553453"></a> [2553453](#2553453) <a name="2553453"></a> <br />NETQ-7318 | The <code>netqd</code> daemon logs a traceback to _/var/log/netqd.log_ when the OPTA server is unreachable and <code>netq show</code> commands are run. | 3.1.0-3.3.1 | |
| <a name="2551545"></a> [2551545](#2551545) <a name="2551545"></a> <br />NETQ-6640 | Infra: Rarely, after a node is restarted, Kubernetes pods do not synchronize properly and the output of <code>netq show opta-health</code> shows failures. Node operation is not functionally impacted. You can safely remove the failures by running <code>kubectl get pods \| grep MatchNodeSelector \| cut \-f1 \-d' ' \| xargs kubectl delete pod</code>. To work around the issue, do not label nodes using the API. Instead label nodes through local configuration using <code>kubelet flag "--node-labels"</code>. | 3.1.0-3.3.1 | |
| <a name="2549649"></a> [2549649](#2549649) <a name="2549649"></a> <br />NETQ-5737 | NetQ UI: Warnings might appear during the post-upgrade phase for a Cumulus Linux switch upgrade job. They are caused by services that have not yet been restored by the time the job is complete. Cumulus Networks recommend waiting five minutes, creating a network snapshot, then comparing that to the pre-upgrade snapshot. If the comparison shows no differences for the services, the warnings can be ignored. If there are differences, then troubleshooting the relevant service(s) is recommended. | 3.0.0-3.3.1 | |
| <a name="2549319"></a> [2549319](#2549319) <a name="2549319"></a> <br />NETQ-5571 | NetQ UI: The legend and segment colors on Switches and Upgrade History card graphs sometimes do not match. These cards appear on the lifecycle management dashboard (Manage Switch Assets view). Hover over graph to view the correct values. | 3.0.0-3.3.1 | |
| <a name="2543867"></a> [2543867](#2543867) <a name="2543867"></a> <br />NETQ-3451 | NetQ UI: If either the hostname or the ASN of a BGP peer is invalid, the full screen BGP Service card does not provide the ability to open cards for a selected BGP session. | 2.3.0-2.4.1, 3.0.0-3.3.1 | |

### Fixed Issues in 3.3.0
|  Issue ID 	|   Description	|   Affects	|
|---	        |---	        |---	    |
| <a name="2556006"></a> [2556006](#2556006) <a name="2556006"></a> <br />NETQ-8311 | NetQ Infra: Customers with cloud deployments who wish to use the lifecycle management (LCM) feature in NetQ 3.3.0 must upgrade their NetQ Cloud Appliance or Virtual Machine as well as the NetQ Agent. | 3.2.1 | |
| <a name="2549246"></a> [2549246](#2549246) <a name="2549246"></a> <br />NETQ-5529 | NetQ UI: Snapshot comparison cards may not render correctly after navigating away from a workbench and then returning to it. If you are viewing the Snapshot comparison card(s) on a custom workbench, refresh the page to reload the data. If you are viewing it on the Cumulus Default workbench, after refreshing the page you must recreate the comparison(s). | 2.4.0-3.2.1 | |

