---
title: Cumulus VX
author: Cumulus Networks
weight: -34
subsection: true
cascade:
  product: Cumulus VX
  version: '4.x'
toc: 1

---
Welcome to NVIDIA&#174; Cumulus VX.

## What is Cumulus VX?

Cumulus VX is a free virtual machine (VM) that provides all the features of Cumulus Linux. Use Cumulus VX to learn and test Cumulus Linux in your own environment, at your own pace, without organizational and economic barriers. You can also produce sandbox environments for prototype assessment, pre-production rollouts, and script development. Read the {{<link url="/Overview" text="Cumulus VX overview">}} for additional information about Cumulus VX, to see a list of the supported hypervisors, and to read the support policy.

{{%notice note%}}
Cumulus Networks also offers {{<exlink url="https://cumulusnetworks.com/products/cumulus-in-the-cloud/" text="Cumulus in the Cloud">}}, which is a free, personal, virtual data center network that provides a low-effort way to see Cumulus Networks technology in action. This is a good way to try out Cumulus Linux if you have platform or disk limitations.
{{%/notice%}}

## How do I use Cumulus VX?

This document describes how to install Cumulus VX on a {{<link url="Overview#supported-hypervisors" text="supported hypervisor">}} and configure the created VMs using a simple two leaf and one spine topology. After you successfully install and configure the VMs, you can run basic commands to get up and running. You can then explore further using the {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux" text="Cumulus Linux documentation">}} as a resource.

The {{<link url="Advanced-Configuration" text="Advanced Configuration">}} section of this document provides additional procedures to configure the two leaf, one spine topology for use with the {{<exlink url="https://cumulusnetworks.com/lp/cumulus-linux-on-demand/" text="Cumulus Linux on demand">}} self-paced labs and to create your own topology with the topology converter for use with Vagrant and Libvirt.
