---
title: Cumulus Linux vs Cisco NX-OS Interface Show Commands
author: Cumulus Networks
weight: 513
toc: 4
---

Cumulus Linux includes a number of interface show commands to troubleshoot your switch. While Cumulus Linux *is* Linux, and the same tried and true Linux commands work in the same way, the Cumulus Linux [network command line utility](https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Network-Command-Line-Utility-NCLU/) shows even more relevant information in a single command.

## Show Layer 1 and 2 Interface Status

| Network OS                    | Output                        |
| ----------------------------- | ----------------------------- |
| **Cumulus Linux**                 | Show current interface state for all switch ports:<br><pre>cumulus@switch:~$ net show interface all<br>      Name           Master       Speed      MTU  Mode              Remote Host      Remote Port       Summary<br><br>UP     lo             None       N/A      65536  Loopback                                              IP: 10.254.0.3/32, 127.0.0.1/8, ::1/128<br>UP     eth0           mgmt       1G        1500  Mgmt              oob-mgmt-switch  swp8               IP: 192.168.0.13/24(DHCP)<br>UP     swp1           bond-swp1  1G        1500  BondMember        server03         44:38:39:00:00:28  Master: bond-swp1(UP)<br>UP     swp2           bond-swp2  1G        1500  BondMember        server04         44:38:39:00:00:23  Master: bond-swp2(UP)<br>UP     swp49          peerlink   1G        1500  BondMember        leaf04           swp49              Master: peerlink(UP)<br>UP     swp50          peerlink   1G        1500  BondMember        leaf04           swp50              Master: peerlink(UP)<br>UP     swp51          None       1G        1500  BGP Unnumbered    spine01          swp3<br>UP     swp52          None       1G        1500  BGP Unnumbered    spine02          swp3<br>UP     bond-swp1      bridge     1G        1500  Bond/Access                                           Bond Members: swp1(UP)<br>UP     bond-swp2      bridge     1G        1500  Bond/Access                                           Bond Members: swp2(UP)<br>UP     bridge         None       N/A       1500  Bridge/L2                                             Untagged Members: bond-swp1-2, peerlink<br>UP     mgmt           None       N/A      65536  Interface/L3                                          IP: 127.0.0.1/8<br>UP     peerlink       bridge     2G        1500  Bond/Trunk                                            Bond Members: swp49(UP), swp50(UP)<br>UP     peerlink.4094  None       2G        1500  SubInt/L3                                             IP: 169.254.1.1/30<br>ADMDN  vagrant        None       0M        1500  NotConfigured <br>UP     vlan20         None       N/A       1500  Interface/L3                                          IP: 10.3.20.253/24<br>UP     vlan20-v0      None       N/A       1500  Interface/L3                                          IP: 10.3.20.254/32</pre>          |
| |  Show current interface state for all switch ports that are up:<br><pre>cumulus@switch:~$ net show interface \| grep UP</pre> |
| **Cisco Nexus 3000 Series**       | Show current interface state for all switch ports:<br><pre>switch# show interface brief<br>Port   VRF          Status IP Address                                Speed     MTU<br>mgmt0  \--           up     192.168.0.1                                 1000     1500<br><br>Ethernet      VLAN   Type Mode   Status  Reason                      Speed     Port<br>Interface                                                                      Ch #<br>Eth1/1        1      eth  access up      none                         1000(D)   \--<br>Eth1/2        \--     eth  routed down    Administratively down        auto(D)   \--<br> ...</pre>  |
|                                   | Another way to show current interface state for all switch ports that are up:<br><pre>switch# show interface brief | include up</pre> |

## Show IP Address Information

IP addresses information for interfaces can be seen a variety of ways in Cumulus Linux. The best way is to use [NCLU](https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Network-Command-Line-Utility-NCLU/).

| Network OS                    | Output                        |
| ----------------------------- | ----------------------------- |
| **Cumulus Linux**                 | Show current IP addresses for all ports (includes ports with or without an IP address):<br><pre>cumulus@switch:~$ net show interface<br>      Name           Master       Speed      MTU  Mode              Remote Host      Remote Port       Summary<br><br>UP     lo             None       N/A      65536  Loopback                                              IP: 10.254.0.3/32, 127.0.0.1/8, ::1/128<br>UP     eth0           mgmt       1G        1500  Mgmt              oob-mgmt-switch  swp8               IP: 192.168.0.13/24(DHCP)<br>UP     swp1           bond-swp1  1G        1500  BondMember        server03         44:38:39:00:00:28  Master: bond-swp1(UP)<br>UP     swp2           bond-swp2  1G        1500  BondMember        server04         44:38:39:00:00:23  Master: bond-swp2(UP)<br>UP     swp49          peerlink   1G        1500  BondMember        leaf04           swp49              Master: peerlink(UP)<br>UP     swp50          peerlink   1G        1500  BondMember        leaf04           swp50              Master: peerlink(UP)<br>UP     swp51          None       1G        1500  BGP Unnumbered    spine01          swp3<br>UP     swp52          None       1G        1500  BGP Unnumbered    spine02          swp3<br>UP     bond-swp1      bridge     1G        1500  Bond/Access                                           Bond Members: swp1(UP)<br>UP     bond-swp2      bridge     1G        1500  Bond/Access                                           Bond Members: swp2(UP)<br>UP     bridge         None       N/A       1500  Bridge/L2                                             Untagged Members: bond-swp1-2, peerlink<br>UP     mgmt           None       N/A      65536  Interface/L3                                          IP: 127.0.0.1/8<br>UP     peerlink       bridge     2G        1500  Bond/Trunk                                            Bond Members: swp49(UP), swp50(UP)<br>UP     peerlink.4094  None       2G        1500  SubInt/L3                                             IP: 169.254.1.1/30<br>ADMDN  vagrant        None       0M        1500  NotConfigured <br>UP     vlan20         None       N/A       1500  Interface/L3                                          IP: 10.3.20.253/24<br>UP     vlan20-v0      None       N/A       1500  Interface/L3                                          IP: 10.3.20.254/32</pre>          |
| |  Show current interface state for all switch ports that are up:<br><pre>cumulus@switch:~$ net show interface \| grep UP</pre> |
| **Cisco Nexus 3000 Series**       | Show current IP addresses for all ports that are up (this includes only ports with an IP address):<br><pre>switch# sh ip[v6] interface brief<br>IP Interface Status for VRF "default"(1)<br>Interface            IP Address      Interface Status<br>eth1/1               192.168.0.1     protocol-up/link-up/admin-up<br>eth1/2               10.10.10.10     protocol-up/link-up/admin-up<br>...</pre> |
|                                   | Another way to show current interface state for all switch ports that are up:<br><pre>switch# show ip interface brief \| include up</pre> |

## Show LLDP Neighbor Information

LLDP is used as a way to gather and show information on neighbors and the ports they are connected through. This is very similar CDP in a Cisco Nexus 3000.

| Network OS                    | Output                        |
| ----------------------------- | ----------------------------- |
| **Cumulus Linux**             | Show LLDP neighbors:<br><pre>cumulus@switch:~$ net show lldp<br>Summary                    LocalPort    Speed    Mode             RemotePort         RemoteHost<br><br>IP: 192.168.0.13/24(DHCP)  eth0         1G       Mgmt             swp8               oob-mgmt-switch<br>Master: bond-swp1(UP)      swp1         1G       BondMember       44:38:39:00:00:28  server03<br>Master: bond-swp2(UP)      swp2         1G       BondMember       44:38:39:00:00:23  server04<br>Master: peerlink(UP)       swp49        1G       BondMember       swp49              leaf04<br>Master: peerlink(UP)       swp50        1G       BondMember       swp50              leaf04<br>                           swp51        1G       NotConfigured    swp3               spine01<br>                           swp52        1G       NotConfigured    swp3               spine02      |
| **Cisco Nexus 3000 Series**       | Show current CDP neighbors:<br><pre>switch# show cdp neighbors<br>Capability Codes: R - Router, T - Trans-Bridge, B - Source-Route-Bridge<br>                       S - Switch, H - Host, I - IGMP, r - Repeater,<br>                       V - VoIP-Phone, D - Remotely-Managed-Device,<br>                       s - Supports-STP-Dispute<br><br>Device ID              Local Intrfce   Hldtme  Capability  Platform      Port ID<br><br>d13-dist-1               mgmt0           148     S I      WS-C2960-24TC  Fas0/9<br>n5k(FLC12080012)         Eth1/1          8       S I s    N5K-C5020P-BA  Eth1/5<br>... </pre> |

## Showing Interface Counters

The ability to see interface counters from NetStat helps in monitoring traffic across each interface.

| Network OS                    | Output                        |
| ----------------------------- | ----------------------------- |
| **Cumulus Linux**             | Show interface counters:<br><pre>cumulus@switch:~$ net show counters<br>Kernel Interface table<br>Iface            MTU    Met    RX_OK    RX_ERR    RX_DRP    RX_OVR    TX_OK    TX_ERR    TX_DRP    TX_OVR  Flg<br><br>bond-swp1       1500      0       1298         0         0        0     1950         0         0        0  BMmRU<br>bond-swp2       1500      0       1322         0         0        0     1976         0         0        0  BMmRU<br>bridge          1500      0         26         0         0        0       27         0         0        0  BMRU<br>eth0            1500      0       9306         0         0        0     6462         0         0        0  BMRU<br>lo             65536      0          0         0         0        0        0         0         0        0  LRU<br>mgmt           65536      0       6001         0         0        0     4907         0         0        0  OmRU<br>peerlink        1500      0       4643         0         4        0     4645         0         0        0  BMmRU<br>peerlink.4094   1500      0       1533         0         0        0     1534         0         0        0  BMRU<br>swp1            1500      0       1306         0         0        0     1950         0         0        0  BMsRU<br>swp2            1500      0       1330         0         0        0     1976         0         0        0  BMsRU<br>swp49           1500      0       2328         0         0        0     2324         0         0        0  BMsRU<br>swp50           1500      0       2315         0         2        0     2321         0         0        0  BMsRU<br>swp51           1500      0       1235         0         0        0     1212         0         0        0  BMRU<br>swp52           1500      0       1046         0         0        0     1049         0         0        0  BMRU<br>vlan20          1500      0         24         0         0        0       20         0         0        0  BMRU<br>vlan20-v0       1500      0         15         0         0        0       13         0         0        0  BMRU</pre>|
| **Cisco Nexus 3000 Series**       | Show interface counters: Cisco equivalent to `net show counters`:<br><pre>switch# show int counter er<br><br>Port        Align-Err    FCS-Err   Xmit-Err    Rcv-Err UnderSize OutDiscards<br>Te1/1               0          0          0          0         0           0<br>Te1/2               0          0          0          0         0           0<br>Te1/3               0          0          0          0         0           0<br>Te1/4               0          0          0          0         0           0<br>Te1/5               0          0          0          0         0           0<br>Te1/6               0          0          0          0         0           0<br>Te1/7               0          0          0          0         0           0<br>Te1/8               0          0          0          0         0           0<br>Te2/1               0          0          0          0         0           0<br>Te2/2               0          0          0          0         0           0<br>Te2/3               0          0          0          0         0           0<br>Te2/4               0          0          0          0         0           0<br>Te2/5               0          0          0          0         0           0<br>Te2/6               0          0          0          0         0           0<br>Te2/7               0          0          0          0         0           0<br>Te2/8               0          0          0          0         0           0<br>Gi5/1               0          0          0          0         0           0<br>Gi5/2               0          0          0          0         0           0<br>Gi5/3               0          0          0          0         0           0<br>Te5/4               0          0          0          0         0           0<br>Te5/5               0          0          0          0         0           0<br><br>Port        Align-Err    FCS-Err   Xmit-Err    Rcv-Err UnderSize OutDiscards<br>Gi6/1               0          0          0          0         0           0<br>Gi6/2               0          0          0          0         0           0<br>Gi6/3               0          0          0          0         0           0<br>Te6/4               0          0          0          0         0           0<br>Te6/5               0          0          0          0         0           0<br>Po1                 0          0          0          0         0           0<br>Po2                 0          0          0          0         0           0<br>Po100               0          0          0          0         0           0<br><br>Port      Single-Col Multi-Col  Late-Col Excess-Col Carri-Sen     Runts    Giants<br>Te1/1              0         0         0          0         0         0         0<br>Te1/2              0         0         0          0         0         0         0<br>Te1/3              0         0         0          0         0         0         0<br>Te1/4              0         0         0          0         0         0         0<br>Te1/5              0         0         0          0         0         0         0<br>Te1/6              0         0         0          0         0         0         0<br><br>Port      Single-Col Multi-Col  Late-Col Excess-Col Carri-Sen     Runts    Giants<br>Te1/7              0         0         0          0         0         0         0<br>Te1/8              0         0         0          0         0         0         0<br>Te2/1              0         0         0          0         0         0         0<br>Te2/2              0         0         0          0         0         0         0<br>Te2/3              0         0         0          0         0         0         0<br>Te2/4              0         0         0          0         0         0         0<br>Te2/5              0         0         0          0         0         0         0<br>Te2/6              0         0         0          0         0         0         0<br>Te2/7              0         0         0          0         0         0         0<br>Te2/8              0         0         0          0         0         0         0<br>Gi5/1              0         0         0          0         0         0         0<br><br>Port      Single-Col Multi-Col  Late-Col Excess-Col Carri-Sen     Runts    Giants<br>Gi5/2              0         0         0          0         0         0         0<br>Gi5/3              0         0         0          0         0         0         0<br>Te5/4              0         0         0          0         0         0         0<br>Te5/5              0         0         0          0         0         0         0<br>Gi6/1              0         0         0          0         0         0         0<br>Gi6/2              0         0         0          0         0         0         0<br>Gi6/3              0         0         0          0         0         0         0<br>Te6/4              0         0         0          0         0         0         0<br>Te6/5              0         0         0          0         0         0         0<br>Po1                0         0         0          0         0         0         0<br>Po2                0         0         0          0         0         0         0<br><br>Port      Single-Col Multi-Col  Late-Col Excess-Col Carri-Sen     Runts    Giants<br>Po100              0         0         0          0         0         0         0<br><br>Port       SQETest-Err Deferred-Tx IntMacTx-Err IntMacRx-Err Symbol-Err<br>Te1/1                0           0            0            0          0<br>Te1/2                0           0            0            0          0<br>Te1/3                0           0            0            0          0<br>Te1/4                0           0            0            0          0<br>Te1/5                0           0            0            0          0<br>Te1/6                0           0            0            0          0<br>Te1/7                0           0            0            0          0<br>Te1/8                0           0            0            0          0<br>Te2/1                0           0            0            0          0<br>Te2/2                0           0            0            0          0<br>Te2/3                0           0            0            0          0<br>Te2/4                0           0            0            0          0<br>Te2/5                0           0            0            0          0<br>Te2/6                0           0            0            0          0<br>Te2/7                0           0            0            0          0<br>Te2/8                0           0            0            0          0<br>Gi5/1                0           0            0            0          0<br>Gi5/2                0           0            0            0          0<br><br>Port       SQETest-Err Deferred-Tx IntMacTx-Err IntMacRx-Err Symbol-Err<br>Gi5/3                0           0            0            0          0<br>Te5/4                0           0            0            0          0<br>Te5/5                0           0            0            0          0<br>Gi6/1                0           0            0            0          0<br>Gi6/2                0           0            0            0          0<br>Gi6/3                0           0            0            0          0<br>Te6/4                0           0            0            0          0<br>Te6/5                0           0            0            0          0<br>Po1                  0           0            0            0          0<br>Po2                  0           0            0            0          0<br>Po100                0           0            0            0          0<br><br>switch# show int counter<br><br>Port            InOctets   InUcastPkts   InMcastPkts   InBcastPkts<br>Te1/1                  0             0             0             0<br>Te1/2                  0             0             0             0<br>Te1/3                  0             0             0             0<br>Te1/4             233333            41          1392             0<br>Te1/5             209475             0          1323             0<br>Te1/6                  0             0             0             0<br>Te1/7                  0             0             0             0<br>Te1/8                  0             0             0             0<br>Te2/1             496926            20          4403             0<br>Te2/2             215649             0          1323             0<br>Te2/3             497358            20          4407             0<br>Te2/4             215649             0          1323             0<br>Te2/5                  0             0             0             0<br>Te2/6                  0             0             0             0<br>Te2/7                  0             0             0             0<br>Te2/8                  0             0             0             0<br>Gi5/1                  0             0             0             0<br>Gi5/2                  0             0             0             0<br>Gi5/3            5361234          2855         57437          3876<br>Te5/4                  0             0             0             0<br>Te5/5                  0             0             0             0<br><br>Port            InOctets   InUcastPkts   InMcastPkts   InBcastPkts<br>Gi6/1                  0             0             0             0<br>Gi6/2                  0             0             0             0<br>Gi6/3                  0             0             0             0<br>Te6/4                  0             0             0             0<br>Te6/5                  0             0             0             0<br>Po1               442808            41          2715             0<br>Po2              1425672            40         11457             0<br>Po100                  0             0             0             0<br><br>Port           OutOctets  OutUcastPkts  OutMcastPkts  OutBcastPkts<br>Te1/1                  0             0             0             0<br>Te1/2                  0             0             0             0<br>Te1/3                  0             0             0             0<br>Te1/4             360918            41          1485             0<br>Te1/5             353770             0          1442             0<br>Te1/6                  0             0             0             0<br>Te1/7                  0             0             0             0<br>Te1/8                  0             0             0             0<br>Te2/1            5966040             0         81656             0<br>Te2/2             414592             0          2327             0<br>Te2/3            3411794             0         31756             0<br>Te2/4             417438            40          2327             0<br>Te2/5                  0             0             0             0<br><br>Port           OutOctets  OutUcastPkts  OutMcastPkts  OutBcastPkts<br>Te2/6                  0             0             0             0<br>Te2/7                  0             0             0             0<br>Te2/8                  0             0             0             0<br>Gi5/1                  0             0             0             0<br>Gi5/2                  0             0             0             0<br>Gi5/3             238494            33           533             0<br>Te5/4                  0             0             0             0<br>Te5/5                  0             0             0             0<br>Gi6/1                  0             0             0             0<br>Gi6/2                  0             0             0             0<br>Gi6/3                  0             0             0             0<br>Te6/4                  0             0             0             0<br>Te6/5                  0             0             0             0<br>Po1               714688            41          2927             0<br>Po2             10209864            40        118066             0<br>Po100                  0             0             0             0</pre>|
