---
title: Spectre and Meltdown Vulnerability Fixes
author: Cumulus Networks
weight: 451
toc: 4
---

## Issue

Patches are available for the Spectre and Meltdown vulnerabilities that {{<link url="Meltdown-and-Spectre-Modern-CPU-Vulnerabilities" text="Cumulus Networks announced previously">}}. They remedy the following vulnerabilities:

- {{<exlink url="https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-5753" text="CVE-2017-5753">}}: Bounds check bypass (Spectre variant 1)
- {{<exlink url="https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-5715" text="CVE-2017-5715">}}: Branch target injection (Spectre variant 2)
- {{<exlink url="https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-5754" text="CVE-2017-5754">}}: Rogue data cache load (Meltdown)

{{%notice note%}}

This issue was announced on the Cumulus Networks {{<exlink url="https://lists.cumulusnetworks.com/pipermail/cumulus-security-announce/2019-April/000012.html" text="security announcement mailing list">}} on April 3, 2019.

{{%/notice%}}

## Environment

- This issue applies to Cumulus Linux 3.0.0 - 3.7.12 ESR only. The Spectre and Meltdown patches are enabled by default in Cumulus Linux 4.0.0 and later.

## Verified Platforms

Cumulus Networks has tested and verified that the patches are available for the following platforms; the resolution listed below applies to {{<exlink url="https://cumulusnetworks.com/hcl" text="all supported platforms">}}:

- Dell Z9100-ON
- Dell Z9264F-ON
- Edgecore AS6712-32X
- Edgecore  AS5712-54X
- HPE Altoline 6940
- HPE Altoline 6920
- Mellanox Spectrum

## Resolution

The patches have been applied to the Cumulus Linux 3.7.4 kernel and later releases, but are disabled by default in the 3.7.x branch. They are disabled because, although we have done extensive testing, this fix includes a number of kernel changes and may impact switch performance. If you wish, you can leave this fix disabled.

You enable the patches by configuring some kernel command line options in GRUB configuration files, rebooting the switch, then updating your switch BIOS.

The command line option is in the `/etc/default/grub.d/00-spectre-meltdown.cfg` file. If you installed Cumulus Linux 3.7.4 from the binary installation image, the command line option also appears in `/etc/default/grub`.

To apply the patches, do the following:

1.  Edit the `/etc/default/grub.d/00-spectre-meltdown.cfg` file as follows:  

        cumulus@switch:~$ sed -i "s/GRUB_CMDLINE_LINUX_DEFAULT/#GRUB_CMDLINE_LINUX_DEFAULT/" /etc/default/grub.d/00-spectre-meltdown.cfg

2.  If you did a binary install of Cumulus Linux 3.7.4 or later, you also must edit `/etc/default/grub` as follows:  

        cumulus@switch:~$ sed -i 's/GRUB_CMDLINE_LINUX_DEFAULT="quiet noibrs noibpb nolfence spectre_v2=off nopti"/#GRUB_CMDLINE_LINUX_DEFAULT="quiet noibrs noibpb nolfence spectre_v2=off nopti"\
        GRUB_CMDLINE_LINUX_DEFAULT="quiet"/' /etc/default/grub

3.  Run `update-grub`:  

        cumulus@switch:~$ update-grub

4.  Reboot the switch.

5.  Update the BIOS on your switch. For information on how to do this, contact your switch manufacturer.

6.  Verify that the GRUB option was successfully enabled, check `/proc/cmdline` to make sure the following does not exist:  

        cumulus@switch:~$ grep "noibrs noibpb nolfence spectre_v2=off nopti" /proc/cmdline
        cumulus@switch:~$ 

    You can also verify that the GRUB option was successfully enabled by
    checking:  

        cumulus@switch:~$ rgrep . /sys/devices/system/cpu/vulnerabilities
        /sys/devices/system/cpu/vulnerabilities/spectre_v1:Mitigation: lfence
        /sys/devices/system/cpu/vulnerabilities/spectre_v2:Mitigation: IBRS IBPB
        /sys/devices/system/cpu/vulnerabilities/meltdown:Mitigation: PTI
        cumulus@switch:~$ 
