---
title: Cumulus Linux Command Reference Guide
author: Cumulus Networks
weight: 102
toc: 3
---

## Common System Commands

| Command(s) | Description | Example | More Information |
| ---------- | ----------- | ------- | ---------------- |
| `!!` | Replays last CLI command (same as `!-1`, which is one command back in the CLI history). | <pre>cumulus@leaf1$ echo "Hello World"<br>Hello World<br>cumulus@leaf1$ !!<br>echo "Hello World"<br>Hello World</pre> | {{<exlink url="https://www.gnu.org/software/bash/manual/html_node/Event-Designators.html" text="Event Designators">}} |
| `cat /etc/lsb-release` | Displays software version information. | <pre>cumulus@leaf1$ cat /etc/lsb-release<br>DISTRIB_ID="Cumulus Linux"<br>DISTRIB_RELEASE=4.2.0<br>DISTRIB_DESCRIPTION="Cumulus Linux 4.2.0"</pre> | {{<exlink url="http://linux.die.net/man/1/lsb_release" text="lsb_release">}} |
| `cat /etc/os-release` | Displays detailed software version information. | <pre>NAME="Cumulus Linux"<br>VERSION_ID=4.2.0<br>VERSION="Cumulus Linux 4.2.0"<br>PRETTY_NAME="Cumulus Linux"<br>ID=cumulus-linux<br>ID_LIKE=debian<br>CPE_NAME=cpe:/o:cumulusnetworks:cumulus_linux:4.2.0<br>HOME_URL="http://www.cumulusnetworks.com/"<br>SUPPORT_URL="http://support.cumulusnetworks.com/"</pre>| {{<exlink url="http://0pointer.de/public/systemd-man/os-release.html" text="os-release">}} |
| `cl-license` | Displays license status and information; installs license. | <pre>cumulus@leaf1$ sudo cl-license<br>cwlicense\@cumulusnetworks.com\|XXXXX</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Quick-Start-Guide/#install-the-license" text="License Installation">}} |
| `onie-select` | Uninstalls and reinstalls an image; boots into rescue mode.<br><br>**Note:** Requires sudo or root. | <pre>cumulus@leaf1$ sudo onie-select -i<br>WARNING:<br>WARNING: Operating System install requested.<br>WARNING: This will wipe out all system data.<br>WARNING:<br>Are you sure (y/N)? y<br>Enabling install at next reboot...done.<br>Reboot required to take effect.</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Installation-Management/Managing-Cumulus-Linux-Disk-Images/" text="Image Management">}} |
| `decode-syseeprom`[^1] | Displays hardware version information; sets EEPROM content. | <pre>cumulus@leaf1$ sudo decode-syseeprom<br>TlvInfo Header:<br>   Id String:    TlvInfo<br>   Version:      1<br>   Total Length: 108<br>TLV Name             Code Len Value<br>-------------------- ---- --- -----<br>Serial Number        0x23  10 ADXXXXXXXX<br>Product Name         0x21  10 AS4600-54T<br>Manufacture Date     0x25  19 06/30/2012 12:00:00<br>Base MAC Address     0x24   6 70:72:CF:XX:XX:XX<br>Label Revision       0x27   4 R01A<br>Platform Name        0x28  28 powerpc-accton_as4600_54t-r0<br>ONIE Version         0x29   7 2014.11<br>MAC Addresses        0x2A   2 65<br>CRC-32               0xFE   4 0x182BXXXX<br>(checksum valid)</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Monitoring-System-Hardware/" text="Monitoring System Hardware">}} |
| `dmesg` | Displays system boot messages. | <pre>cumulus@leaf1$ dmesg<br>&lt;snip for brevity><br>[ 2485.689082] bonding: bond0: Removing slave swp1.<br>[ 2485.689169] bonding: bond0: releasing backup interface swp1<br>[ 2486.029832] ADDRCONF(NETDEV_UP): swp1: link is not ready<br>[ 2489.431326] ADDRCONF(NETDEV_CHANGE): swp1: link becomes ready<br>[ 2536.508917] bonding: bond0: enslaving swp1 as a backup interface with a down link.<br>[ 2536.602285] bonding: bond0: link status definitely up for interface swp1, 0 Mbps half duplex.<br>[ 2536.902216] bonding: bond0: link status definitely down for interface swp1, disabling it<br>[ 2540.108185] bonding: bond0: link status definitely up for interface swp1, 1000 Mbps full duplex.<br>[ 2569.010752] bonding: bond0: link status definitely down for interface swp1, disabling it<br>[ 2571.810708] bonding: bond0: link status definitely up for interface swp1, 1000 Mbps full duplex.</pre> | {{<exlink url="http://man7.org/linux/man-pages/man1/dmesg.1.html" text="dmesg">}} |
| `/usr/lib/cumulus/onie/onie-version` | Displays ONIE version. | <pre>cumulus@leaf1$ /usr/lib/cumulus/onie/onie-version<br>ONIE version        : 2018.08<br>ONIE vendor_id      : 42623<br>ONIE build_machine  : cumulus_vx<br>ONIE machine_rev    : 0<br>ONIE arch           : x86_64<br>ONIE build_platform : x86_64-cumulus_vx-r0<br>ONIE config_version : 1<br>ONIE build_date     : 2018-08-14T03:52-0700<br>ONIE partition_type : gpt<br>ONIE kernel_version : 4.1.38<br>ONIE firmware       : auto<br>ONIE switch_asic    : qemu<br>ONIE skip_ethmgmt_macs: yes<br>ONIE grub_image_name: grubx64.efi<br>ONIE uefi_boot_loader: grubx64.efi<br>ONIE uefi_arch      : x64</pre> | {{<exlink url="https://opencomputeproject.github.io/onie/cli/index.html" text="ONIE command line reference">}} |
| `history` | Displays CLI command history. | <pre>cumulus@leaf1$ history<br>    1  exit<br>    2  ping -I bond0 10.0.0.2<br>    3  smonctl<br>    4  sudo su -<br>    5  echo hi<br>    6  history</pre> | {{<exlink url="http://linux.die.net/man/3/history" text="history">}} |
| `hostname`<br>`cat /etc/hostname` | Displays/sets hostname. A reboot is required if changes to the `/etc/hostname` file are made. | <pre>cumulus@leaf1$ hostname<br>leaf1</pre> | {{<exlink url="http://linux.die.net/man/1/hostname" text="hostname">}} |
| `date`[^1] | Displays time and timezone information. | <pre>cumulus@leaf1:~# date<br>Thu Feb 11 21:17:32 UTC 2016</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Setting-Date-and-Time/" text="date">}} |
| `ping -I bond0 <INTERFACE_IP>` | Pings sourced from a specified interface. This can also be a virtual interface. | <pre>cumulus@leaf1$ ping -I bond0 10.0.0.1<br>PING 10.0.0.1 (10.0.0.1) from 10.0.0.1 bond0: 56(84) bytes of data.<br>64 bytes from 10.0.0.1: icmp_req=1 ttl=64 time=0.083 ms<br>64 bytes from 10.0.0.1: icmp_req=2 ttl=64 time=0.079 ms<br>^C<br>--- 10.0.0.1 ping statistics ---<br>2 packets transmitted, 2 received, 0% packet loss, time 1000ms<br>rtt min/avg/max/mdev = 0.079/0.081/0.083/0.002 ms</pre> | {{<exlink url="http://linux.die.net/man/8/ping" text="ping">}} |
| `sensors -f` | Displays PSU, fan, and environmental information (in Fahrenheit). | <pre>cumulus@leaf1$ sensors -f<br>lm75a-i2c-0-4b<br>Adapter: MPC adapter<br>temp1:        +86.9 F  (high = +113.0 F, hyst = +113.0 F)<br><br>lm75a-i2c-1-48<br>Adapter: MPC adapter<br>temp1:        +91.4 F  (high = +149.0 F, hyst = +149.0 F)<br><br>lm75a-i2c-1-49<br>Adapter: MPC adapter<br>temp1:        +88.7 F  (high = +113.0 F, hyst = +113.0 F)<br><br>lm75a-i2c-1-4e<br>Adapter: MPC adapter<br>temp1:        +98.6 F  (high = +149.0 F, hyst = +149.0 F)<br><br>lm75a-i2c-1-4f<br>Adapter: MPC adapter<br>temp1:        +79.7 F  (high = +113.0 F, hyst = +113.0 F)<br><br>emc2305-i2c-1-4d<br>Adapter: MPC adapter<br>fan1:        9060 RPM  (div = 4)<br>fan2:        9060 RPM  (div = 4)<br>fan3:        9060 RPM  (div = 4)<br>fan4:        8998 RPM  (div = 4)<br>fan5:        9018 RPM  (div = 4)</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Monitoring-System-Hardware/#monitor-hardware-health-using-sensors" text="sensors">}} |
| `tail -n<N> /var/log/syslog` | Displays the last *N* lines of syslog. | <pre>cumulus@leaf1$ tail -n30 /var/log/syslog<br>Sep 23 23:17:01 leaf1 CRON[31219]: pam_unix(cron:session): session closed for user root<br>Sep 23 23:20:57 leaf1 dhclient: DHCPREQUEST on eth0 to 192.168.0.1 port 67<br>Sep 23 23:20:57 leaf1 dhclient: DHCPACK from 192.168.0.1<br>Sep 23 23:20:57 leaf1 dhclient: bound to 192.168.0.11 -- renewal in 1620 seconds.<br>Sep 23 23:20:57 leaf1 cl-autoprovision[31423]: version: 0.4<br>Sep 23 23:20:57 leaf1 cl-autoprovision[31423]: Provisioning has already occured, use --force to override<br>Sep 23 23:21:54 leaf1 sudo:  cumulus : TTY=pts/0 ; PWD=/home/cumulus ; USER=root ; COMMAND=/bin/bash<br>Sep 23 23:23:08 leaf1 sshd[23560]: Received disconnect from 192.168.0.1: 11: disconnected by user<br>Sep 23 23:23:08 leaf1 sshd[23558]: pam_unix(sshd:session): session closed for user cumulus<br>Sep 23 23:23:10 leaf1 sshd[31560]: Accepted publickey for cumulus from 192.168.0.1 port 44133 ssh2<br>Sep 23 23:23:10 leaf1 sshd[31560]: pam_unix(sshd:session): session opened for user cumulus by (uid=0)<br>Sep 23 23:23:22 leaf1 sudo:  cumulus : TTY=pts/0 ; PWD=/home/cumulus ; USER=root ; COMMAND=/bin/echo hi<br>Sep 23 23:23:40 leaf1 sudo:  cumulus : TTY=pts/0 ; PWD=/home/cumulus ; USER=root ; COMMAND=/sbin/hwclock<br>Sep 23 23:25:03 leaf1 sshd[31562]: Received disconnect from 192.168.0.1: 11: disconnected by user<br>Sep 23 23:25:03 leaf1 sshd[31560]: pam_unix(sshd:session): session closed for user cumulus<br>Sep 23 23:25:04 leaf1 sshd[31673]: Accepted publickey for cumulus from 192.168.0.1 port 44134 ssh2<br>Sep 23 23:25:04 leaf1 sshd[31673]: pam_unix(sshd:session): session opened for user cumulus by (uid=0)<br>Sep 23 23:30:01 leaf1 CRON[31946]: pam_unix(cron:session): session opened for user root by (uid=0)<br>Sep 23 23:30:01 leaf1 CRON[31945]: pam_unix(cron:session): session opened for user root by (uid=0)<br>Sep 23 23:30:01 leaf1 /USR/SBIN/CRON[31947]: (root) CMD (   /usr/sbin/logrotate /etc/logrotate.conf)<br>Sep 23 23:30:01 leaf1 /USR/SBIN/CRON[31948]: (root) CMD (   /usr/sbin/logrotate /etc/logrotate.conf)<br>Sep 23 23:30:01 leaf1 CRON[31946]: pam_unix(cron:session): session closed for user root<br>Sep 23 23:30:01 leaf1 CRON[31945]: pam_unix(cron:session): session closed for user root<br>Sep 23 23:45:01 leaf1 CRON[32703]: pam_unix(cron:session): session opened for user root by (uid=0)<br>Sep 23 23:45:01 leaf1 CRON[32702]: pam_unix(cron:session): session opened for user root by (uid=0)<br>Sep 23 23:45:01 leaf1 /USR/SBIN/CRON[32704]: (root) CMD (   /usr/sbin/logrotate /etc/logrotate.conf)<br>Sep 23 23:45:01 leaf1 /USR/SBIN/CRON[32705]: (root) CMD (   /usr/sbin/logrotate /etc/logrotate.conf)<br>Sep 23 23:45:01 leaf1 CRON[32703]: pam_unix(cron:session): session closed for user root<br>Sep 23 23:45:01 leaf1 CRON[32702]: pam_unix(cron:session): session closed for user root</pre> | {{<exlink url="http://linux.die.net/man/1/tail" text="tail">}} |
| `top` | Displays real time CPU/memory utilization and the top processes. | <pre>cumulus@leaf1$ top<br>top - 23:47:40 up 1 day,  3:13,  1 user,  load average: 0.13, 0.24, 0.23<br>Tasks:  64 total,   1 running,  63 sleeping,   0 stopped,   0 zombie<br>%Cpu(s): 17.9 us,  7.6 sy,  0.0 ni, 74.5 id,  0.0 wa,  0.0 hi,  0.0 si,  0.0 st<br>KiB Mem:   2006792 total,   202936 used,  1803856 free,    23324 buffers<br>KiB Swap:        0 total,        0 used,        0 free,    77356 cached<br><br>PID USER      PR  NI  VIRT  RES  SHR S  %CPU %MEM    TIME+  COMMAND<br>3157 root      15  -5  166m  47m  11m S  24.5  2.4 342:24.96 switchd<br>368 cumulus   20   0  3696 1504 1084 R   0.3  0.1   0:00.06 top</pre> | {{<exlink url="https://linux.die.net/man/1/top" text="top">}} |
| `uname -a` | Displays machine information, including kernel version, release, operating system, and hostname. | <pre>cumulus@leaf1$ uname -a<br>Linux leaf1 3.2.65-1+deb7u2+cl2.5+2 #3.2.65-1+deb7u2+cl2.5+2 SMP Mon Jun 1 18:26:55 PDT 2015 ppc powerpc GNU/Linux</pre> | {{<exlink url="http://linux.die.net/man/1/uname" text="uname">}} |
| `whoami` | Displays the current active user/account. | <pre>cumulus@leaf1$ whoami<br>cumulus</pre> |  {{<exlink url="http://linux.die.net/man/1/whoami" text="whoami">}} |
| `dpkg-reconfigure tzdata`[^1] | Configures the timezone. | <pre>cumulus@leaf1$ sudo dpkg-reconfigure tzdata<br>Configuring tzdata<br>------------------<br><br>Please select the geographic area in which you live. Subsequent configuration questions will narrow this down by presenting a list of cities, representing the time zones in which they are located.<br><br>  1. Africa  2. America  3. Antarctica  4. Australia  5. Arctic  6. Asia  7. Atlantic  8. Europe  9. Indian  10. Pacific  11. SystemV  12. US  13. Etc<br>Geographic area: 12<br><br>Please select the city or region corresponding to your time zone.<br><br>  1. Alaska  2. Aleutian  3. Arizona  4. Central  5. Eastern  6. Hawaii  7. Indiana-Starke  8. Michigan  9. Mountain  10. Pacific  11. Pacific-New  12. Samoa<br>Time zone: 10<br><br>Current default time zone: 'US/Pacific'<br>Local time is now:      Wed Sep 23 17:01:00 PDT 2015.<br>Universal Time is now:  Thu Sep 24 00:01:00 UTC 2015.</pre> |  {{<exlink url="https://wiki.debian.org/TimeZoneChanges" text="Debian wiki on timezone changes">}} |
| `reboot`[^1] | Reboots the switch. | <pre>cumulus@leaf1$ sudo reboot<br><br>Broadcast message from root@leaf1 (pts/0) (Wed Sep 23 17:04:44 2015):<br><br>The system is going down for reboot NOW!</pre> |  {{<exlink url="http://linux.die.net/man/8/reboot" text="reboot">}} |
| `sudo su`<br>`sudo -i`<br>`sudo /bin/bash` | Switches user to root/super user. | <pre>cumulus@leaf1$ sudo su<br>[sudo] password for cumulus:<br>root@leaf1:~#</pre> |  {{<exlink url="http://askubuntu.com/a/376386" text="Different ways to become root">}} |

## File Editing Commands

| Command(s) | Description | More Information |
| ---------- | ----------- | ---------------- |
| `nano` | Basic, user-friendly text editor with persistent on-screen keybindings. |  {{<exlink url="http://www.nano-editor.org/dist/v2.2/nano.1.html" text="nano">}} |
| `vi` | Advanced text editor. |  {{<link title="vi for Beginners" text="vi for Beginners">}} |

## Interface Commands

| Command(s) | Description | Example | More Information |
| ---------- | ----------- | ------- | ---------------- |
| `arp -n`[^1^](#sudo)<br>`cat /proc/net/arp` | Displays ARP table with IP addresses instead of trying to resolve hostnames (when using the -n flag). | <pre>cumulus@leaf1$ sudo arp -n<br>Address                  HWtype  HWaddress           Flags Mask            Iface<br>10.1.1.2                 ether   08:9e:01:ce:d8:64   C                     swp1s0<br>10.1.1.34                ether   00:e0:ec:25:7c:d7   C                     swp1s2<br>10.1.1.6                 ether   08:9e:01:ce:d8:65   C                     swp1s1<br>192.168.0.1              ether   72:01:84:88:f5:8b   C                     eth0<br>10.1.1.38                ether   00:e0:ec:25:7c:d8   C                     swp1s3</pre> |  {{<exlink url="http://linux.die.net/man/8/arp" text="arp man page">}}  |
| `cat /etc/network/interfaces` | Displays the interface configuration, bridges, bonds, and VLANs. This file is not indicative of the current running state. | <pre>cumulus@leaf1$ cat /etc/network/interfaces<br>#Configured By Ansible<br><br>auto lo<br>iface lo inet loopback<br><br>auto lo:1<br>iface lo:1 inet static<br>  address 10.2.1.1/32<br><br>auto eth0<br>iface eth0 inet dhcp</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-1-and-Switch-Ports/Interface-Configuration-and-Management/" text="Configuring and Managing Network Interfaces">}} |
| `cat /proc/net/bonding/bond0` | Displays bond0's bond (LAG) information. | <pre>cumulus@leaf1$ cat /proc/net/bonding/bond0<br>Ethernet Channel Bonding Driver: v3.7.1 (April 27, 2011)<br><br>Bonding Mode: IEEE 802.3ad Dynamic link aggregation<br>Transmit Hash Policy: layer3+4 (1)<br>MII Status: up<br>MII Polling Interval (ms): 100<br>Up Delay (ms): 0<br>Down Delay (ms): 0<br><br>802.3ad info<br>LACP rate: fast<br>Min links: 1<br>Aggregator selection policy (ad_select): stable<br>System Identification: 65535 08:9e:01:f8:90:80<br>Active Aggregator Info:<br>    Aggregator ID: 1<br>    Number of ports: 2<br>    Actor Key: 17<br>    Partner Key: 17<br>    Partner Mac Address: 08:9e:01:f8:98:c8<br>LACP Bypass Info:<br>    Allowed: 0<br>    Timeout: 0<br>    All-active: 0<br><br>Slave Interface: swp2<br>MII Status: up<br>Speed: 1000 Mbps<br>Duplex: full<br>Link Failure Count: 1<br>Permanent HW addr: 08:9e:01:f8:90:80<br>Aggregator ID: 1<br>LACP bypass priority: 0<br>Slave queue ID: 0<br><br>Slave Interface: swp1<br>MII Status: up<br>Speed: 1000 Mbps<br>Duplex: full<br>Link Failure Count: 0<br>Permanent HW addr: 08:9e:01:f8:90:7f<br>Aggregator ID: 1<br>LACP bypass priority: 0<br>Slave queue ID: 0</pre> |  {{<exlink url="http://linux.die.net/man/5/proc" text="proc man page">}} |
| `cl-netstat`<br>`cl-netstat -c` | Displays/clears counters for cl-netstat. | <pre>cumulus@leaf1$ cl-netstat<br><br>Kernel Interface table<br>Iface      MTU    Met    RX_OK    RX_ERR    RX_DRP    RX_OVR    TX_OK    TX_ERR    TX_DRP    TX_OVR  Flg<br>-------  -----  -----  -------  --------  --------  --------  -------  --------  --------  --------  -----<br>br0       1500      0        0         0         0         0        4         0         0         0  BMRU<br>br1       1500      0        0         0         0         0        5         0         0         0  BMRU<br>eth0      1500      0     9973         0         0         0     7761         0         0         0  BMRU<br>lo       16436      0        4         0         0         0        4         0         0         0  LRU<br>swp1s0    1500      0     2275         0         1         0     2485         0         0         0  BMRU<br>swp1s1    1500      0     2452         0         1         0     2324         0         0         0  BMRU<br>swp1s2    1500      0     2448         0         3         0     2338         0         0         0  BMRU<br>swp1s3    1500      0     2453         0         3         0     2442         0         0         0  BMRU<br>swp32s0   1500      0        0         0         0         0    10081         0         0         0  BMRU<br>swp32s1   1500      0        0         0         0         0    10082         0         0         0  BMRU</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Troubleshooting-Network-Interfaces/Monitoring-Interfaces-and-Transceivers-Using-ethtool/#view-and-clear-interface-counters" text="View and Clear Interface Counters">}} |
| `ethtool <INTERFACE>`[^1] | Displays low level port information. | <pre>cumulus@leaf1$ sudo ethtool swp32s0<br>Settings for swp32s0:<br>    Supported ports: [ TP ]<br>    Supported link modes:   10baseT/Full<br>                            100baseT/Full<br>                            1000baseT/Full<br>                            10000baseT/Full<br>    Supported pause frame use: Symmetric Receive-only<br>    Supports auto-negotiation: Yes<br>    Advertised link modes:  1000baseT/Full<br>                            10000baseT/Full<br>    Advertised pause frame use: Symmetric<br>    Advertised auto-negotiation: No<br>    Speed: 10000Mb/s<br>    Duplex: Full<br>    Port: FIBRE<br>    PHYAD: 0<br>    Transceiver: external<br>    Auto-negotiation: off<br>    Current message level: 0x00000000 (0)<br><br>    Link detected: yes</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Troubleshooting-Network-Interfaces/Monitoring-Interfaces-and-Transceivers-Using-ethtool/#monitor-interface-status-using-ethtool" text="Monitor Interfaces using ethtool">}} |
| `ethtool -S <INTERFACE>`[^1] | Displays detailed low level statistics. | <pre>cumulus@leaf1$ sudo ethtool -S swp32s0<br>     HwIfInOctets: 0<br>     HwIfInUcastPkts: 0<br>     HwIfInBcastPkts: 0<br>     HwIfInMcastPkts: 0<br>     HwIfOutOctets: 692670<br>     HwIfOutUcastPkts: 0<br>     HwIfOutMcastPkts: 10128<br>     HwIfOutBcastPkts: 0<br>     HwIfInDiscards: 0<br>     HwIfInL3Drops: 0<br>     HwIfInBufferDrops: 0<br>     HwIfInAclDrops: 0<br>     HwIfInDot3LengthErrors: 0<br>     HwIfInErrors: 0<br>     SoftInErrors: 0<br>     SoftInDrops: 0<br>     SoftInFrameErrors: 0<br>     HwIfOutDiscards: 0<br>     HwIfOutErrors: 0<br>     HwIfOutQDrops: 0<br>     HwIfOutNonQDrops: 0<br>     SoftOutErrors: 0<br>     SoftOutDrops: 0<br>     SoftOutTxFifoFull: 0<br>     HwIfOutQLen: 0<br>     HwIfInDot3FrameErrors: 0<br>     HwIfInPausePkt: 0<br>     HwIfOutPausePkt: 0<br>     HwIfInPfc0Pkt: 0<br>     HwIfOutPfc0Pkt: 0<br>     HwIfInPfc1Pkt: 0<br>     HwIfOutPfc1Pkt: 0<br>     HwIfInPfc2Pkt: 0<br>     HwIfOutPfc2Pkt: 0<br>     HwIfInPfc3Pkt: 0<br>     HwIfOutPfc3Pkt: 0<br>     HwIfInPfc4Pkt: 0<br>     HwIfOutPfc4Pkt: 0<br>     HwIfInPfc5Pkt: 0<br>     HwIfOutPfc5Pkt: 0<br>     HwIfInPfc6Pkt: 0<br>     HwIfOutPfc6Pkt: 0<br>     HwIfInPfc7Pkt: 0<br>     HwIfOutPfc7Pkt: 0</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Troubleshooting-Network-Interfaces/Monitoring-Interfaces-and-Transceivers-Using-ethtool/#monitor-interface-status-using-ethtool" text="Monitor Interfaces using ethtool">}} |
| `ifquery <INTERFACE>` | Displays configuration information for an interface. | <pre>cumulus@leaf1$ sudo ifquery -a<br>auto lo<br>iface lo inet loopback<br><br>auto lo<br>iface lo inet static<br>    address 10.2.1.1/32<br><br>auto eth0<br>iface eth0 inet dhcp<br><br>auto swp1s0<br>iface swp1s0 inet static<br>    address 10.1.1.1/30<br><br>auto swp1s1<br>iface swp1s1 inet static<br>    address 10.1.1.5/30<br><br>auto swp1s2<br>iface swp1s2 inet static<br>    address 10.1.1.33/30<br><br>auto swp1s3<br>iface swp1s3 inet static<br>    address 10.1.1.37/30<br><br>auto br1<br>iface br1 inet static<br>    address 10.4.1.129/25<br>    bridge-ports swp32s1<br>    bridge-stp on<br><br>auto br0<br>iface br0 inet static<br>    address 10.4.1.1/25<br>    bridge-ports swp32s0<br>    bridge-stp on</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Troubleshooting-Network-Interfaces/#use-ifquery-to-validate-and-debug-interface-configurations" text="Use ifquery">}} |
| `ifreload -a`[^1]<br>`service networking reload` | Runs ifdown, then ifup, on any interfaces with configuration changes. | <pre>cumulus@leaf1$ ifreload -a<br>cumulus@leaf1$</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Troubleshooting-Network-Interfaces/#use-ifquery-to-validate-and-debug-interface-configurations" text="Use ifupdown2">}} |
| `ifdown <INTERFACE>;ifup <INTERFACE>`[^1] | Brings a specified interface down, then back up. | <pre>cumulus@leaf1$ sudo ifdown swp1s0<br>cumulus@leaf1$ sudo ifup swp1s0<br>cumulus@leaf1$</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Monitoring-and-Troubleshooting/Troubleshooting-Network-Interfaces/#use-ifquery-to-validate-and-debug-interface-configurations" text="Use ifupdown2">}} |
| `ip addr show` | Displays all configured IP addresses. | <pre>cumulus@leaf1$ ip addr show<br>1: lo: <LOOPBACK,UP,LOWER_UP> mtu 16436 qdisc noqueue state UNKNOWN<br>    link/loopback 00:00:00:00:00:00 brd 00:00:00:00:00:00<br>    inet 127.0.0.1/8 scope host lo<br>    inet 10.2.1.1/32 scope global lo<br>    inet6 ::1/128 scope host<br>       valid_lft forever preferred_lft forever<br>2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP qlen 1000<br>    link/ether 44:38:39:00:49:8b brd ff:ff:ff:ff:ff:ff<br>    inet 192.168.0.11/24 brd 192.168.0.255 scope global eth0<br>    inet6 fe80::4638:39ff:fe00:498b/64 scope link<br>       valid_lft forever preferred_lft forever<br>5: swp1s0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP qlen 500<br>    link/ether 44:38:39:00:49:8c brd ff:ff:ff:ff:ff:ff<br>    inet 10.1.1.1/30 scope global swp1s0<br>    inet6 fe80::4638:39ff:fe00:498c/64 scope link<br>       valid_lft forever preferred_lft forever<br>6: swp1s1: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP qlen 500<br>    link/ether 44:38:39:00:49:8d brd ff:ff:ff:ff:ff:ff<br>    inet 10.1.1.5/30 scope global swp1s1<br>    inet6 fe80::4638:39ff:fe00:498d/64 scope link<br>       valid_lft forever preferred_lft forever<br>7: swp1s2: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP qlen 500<br>    link/ether 44:38:39:00:49:8e brd ff:ff:ff:ff:ff:ff<br>    inet 10.1.1.33/30 scope global swp1s2<br>    inet6 fe80::4638:39ff:fe00:498e/64 scope link<br>       valid_lft forever preferred_lft forever<br>8: swp1s3: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP qlen 500<br>    link/ether 44:38:39:00:49:8f brd ff:ff:ff:ff:ff:ff<br>    inet 10.1.1.37/30 scope global swp1s3<br>    inet6 fe80::4638:39ff:fe00:498f/64 scope link<br>       valid_lft forever preferred_lft forever</pre> |  {{<exlink url="http://linux.die.net/man/8/ip" text="ip man page">}} |
| `ip link show` | Displays interface information. | <pre>cumulus@leaf1$ ip link show<br>1: lo: <LOOPBACK,UP,LOWER_UP> mtu 16436 qdisc noqueue state UNKNOWN mode DEFAULT<br>    link/loopback 00:00:00:00:00:00 brd 00:00:00:00:00:00<br>2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP mode DEFAULT qlen 1000<br>    link/ether 44:38:39:00:49:8b brd ff:ff:ff:ff:ff:ff<br>5: swp1s0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP mode DEFAULT qlen 500<br>    link/ether 44:38:39:00:49:8c brd ff:ff:ff:ff:ff:ff<br>6: swp1s1: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP mode DEFAULT qlen 500<br>    link/ether 44:38:39:00:49:8d brd ff:ff:ff:ff:ff:ff<br>7: swp1s2: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP mode DEFAULT qlen 500<br>    link/ether 44:38:39:00:49:8e brd ff:ff:ff:ff:ff:ff<br>8: swp1s3: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP mode DEFAULT qlen 500<br>    link/ether 44:38:39:00:49:8f brd ff:ff:ff:ff:ff:ff<br>9: swp2: <BROADCAST,MULTICAST> mtu 1500 qdisc noop state DOWN mode DEFAULT qlen 500<br>    link/ether 44:38:39:00:49:90 brd ff:ff:ff:ff:ff:ff</pre> | {{<exlink url="http://linux.die.net/man/8/ip" text="ip man page">}} |
| `ip -s link` | Displays interface statistics. | <pre>cumulus@leaf1$ ip -s link<br>1: lo: <LOOPBACK,UP,LOWER_UP> mtu 16436 qdisc noqueue state UNKNOWN mode DEFAULT<br>    link/loopback 00:00:00:00:00:00 brd 00:00:00:00:00:00<br>    RX: bytes  packets  errors  dropped overrun mcast<br>    112        4        0       0       0       0<br>    TX: bytes  packets  errors  dropped carrier collsns<br>    112        4        0       0       0       0<br>2: eth0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP mode DEFAULT qlen 1000<br>    link/ether 44:38:39:00:49:8b brd ff:ff:ff:ff:ff:ff<br>    RX: bytes  packets  errors  dropped overrun mcast<br>    3208342    10725    0       0       0       0<br>    TX: bytes  packets  errors  dropped carrier collsns<br>    1067425    8355     0       0       0       0<br>5: swp1s0: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP mode DEFAULT qlen 500<br>    link/ether 44:38:39:00:49:8c brd ff:ff:ff:ff:ff:ff<br>    RX: bytes  packets  errors  dropped overrun mcast<br>    1982       21       0       1       0       5<br>    TX: bytes  packets  errors  dropped carrier collsns<br>    2071       23       0       0       0       0<br>6: swp1s1: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP mode DEFAULT qlen 500<br>    link/ether 44:38:39:00:49:8d brd ff:ff:ff:ff:ff:ff<br>    RX: bytes  packets  errors  dropped overrun mcast<br>    212068     2516     0       1       0       646<br>    TX: bytes  packets  errors  dropped carrier collsns<br>    205763     2384     0       0       0       0<br>7: swp1s2: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP mode DEFAULT qlen 500<br>    link/ether 44:38:39:00:49:8e brd ff:ff:ff:ff:ff:ff<br>    RX: bytes  packets  errors  dropped overrun mcast<br>    213608     2512     0       3       0       648<br>    TX: bytes  packets  errors  dropped carrier collsns<br>    207061     2398     0       0       0       0<br>8: swp1s3: <BROADCAST,MULTICAST,UP,LOWER_UP> mtu 1500 qdisc pfifo_fast state UP mode DEFAULT qlen 500<br>    link/ether 44:38:39:00:49:8f brd ff:ff:ff:ff:ff:ff<br>    RX: bytes  packets  errors  dropped overrun mcast<br>    213598     2517     0       3       0       648<br>    TX: bytes  packets  errors  dropped carrier collsns<br>    214315     2506     0       0       0       0<br>9: swp2: <BROADCAST,MULTICAST> mtu 1500 qdisc noop state DOWN mode DEFAULT qlen 500<br>    link/ether 44:38:39:00:49:90 brd ff:ff:ff:ff:ff:ff<br>    RX: bytes  packets  errors  dropped overrun mcast<br>    0          0        0       0       0       0<br>    TX: bytes  packets  errors  dropped carrier collsns<br>    0          0        0       0       0       0</pre> | {{<exlink url="http://linux.die.net/man/8/ip" text="ip man page">}} |
| `ip -br link show` | Displays a brief, one line summary of each interface; appends `up` to show only administratively up interfaces. | <pre>cumulus@leaf1$ ip -br link show<br><br>lo           UNKNOWN  00:00:00:00:00:00  <LOOPBACK,UP,LOWER_UP><br>eth0         UP       44:38:39:00:49:8b  <BROADCAST,MULTICAST,UP,LOWER_UP><br>swp1s0       UP       <br>swp1s1       UP       44:38:39:00:49:8d  <BROADCAST,MULTICAST,UP,LOWER_UP><br>swp1s2       UP       44:38:39:00:49:8e  <BROADCAST,MULTICAST,UP,LOWER_UP><br>swp1s3       UP       44:38:39:00:49:8f  <BROADCAST,MULTICAST,UP,LOWER_UP><br>swp2         DOWN     44:38:39:00:49:90  <BROADCAST,MULTICAST></pre> | {{<exlink url="http://linux.die.net/man/8/ip" text="ip man page">}} |
| `lldpcli show neighbors`[^1] | Displays LLDP neighbor information. | <pre>cumulus@leaf1$ sudo lldpcli show neighbors<br>-------------------------------------------------------------------------------<br>LLDP neighbors:<br>-------------------------------------------------------------------------------<br>Interface:    eth0, via: LLDP, RID: 6, Time: 0 day, 05:22:26<br>  Chassis:<br>    ChassisID:    mac 70:72:cf:f5:4a:3b<br>    SysName:      cwl42-prod-ag-tor-1<br>    SysDescr:     Cumulus Linux version 2.5.3 running on accton as4600_54t<br>    MgmtIP:       10.70.6.194<br>    Capability:   Bridge, on<br>    Capability:   Router, on<br>  Port:<br>    PortID:       ifname swp3<br>    PortDescr:    swp3<br>-------------------------------------------------------------------------------<br>Interface:    swp1s2, via: LLDP, RID: 5, Time: 0 day, 05:22:45<br>  Chassis:<br>    ChassisID:    mac 00:e0:ec:25:7c:a4<br>    SysName:      spine2<br>    SysDescr:     Cumulus Linux version 2.5.5 running on cel kennisis<br>    MgmtIP:       10.2.1.4<br>    Capability:   Bridge, off<br>    Capability:   Router, on<br>  Port:<br>    PortID:       ifname swp51<br>    PortDescr:    swp51<br>-------------------------------------------------------------------------------<br>Interface:    swp1s3, via: LLDP, RID: 5, Time: 0 day, 05:22:45<br>  Chassis:<br>    ChassisID:    mac 00:e0:ec:25:7c:a4<br>    SysName:      spine2<br>    SysDescr:     Cumulus Linux version 2.5.5 running on cel kennisis<br>    MgmtIP:       10.2.1.4<br>    Capability:   Bridge, off<br>    Capability:   Router, on<br>  Port:<br>    PortID:       ifname swp52<br>    PortDescr:    swp52<br>-------------------------------------------------------------------------------<br>Interface:    swp1s0, via: LLDP, RID: 7, Time: 0 day, 05:22:13<br>  Chassis:<br>    ChassisID:    mac 08:9e:01:ce:d8:33<br>    SysName:      spine1<br>    SysDescr:     Cumulus Linux version 2.5.5 running on quanta lb9<br>    MgmtIP:       10.2.1.3<br>    Capability:   Bridge, off<br>    Capability:   Router, on<br>  Port:<br>    PortID:       ifname swp49<br>    PortDescr:    swp49<br>-------------------------------------------------------------------------------</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-2/Link-Layer-Discovery-Protocol/" text="LLDP">}} |
| `netstat -i` | Displays statistics for UP interfaces. | <pre>cumulus@leaf1$ netstat -i<br>Kernel Interface table<br>Iface   MTU Met   RX-OK RX-ERR RX-DRP RX-OVR    TX-OK TX-ERR TX-DRP TX-OVR Flg<br>br0        1500 0         0      0      0 0             4      0      0      0 BMU<br>br1        1500 0         0      0      0 0             5      0      0      0 BMU<br>eth0       1500 0     11066      0      0 0          8640      0      0      0 BMRU<br>lo        16436 0         4      0      0 0             4      0      0      0 LRU<br>swp1s0     1500 0        29      0      1 0            33      0      0      0 BMRU<br>swp1s1     1500 0      2526      0      1 0          2392      0      0      0 BMRU<br>swp1s2     1500 0      2521      0      3 0          2406      0      0      0 BMRU<br>swp1s3     1500 0      2526      0      3 0          2514      0      0      0 BMRU<br>swp32s0    1500 0         0      0      0 0         11232      0      0      0 BMRU<br>swp32s1    1500 0         0      0      0 0         10179      0      0      0 BMRU</pre> |  {{<exlink url="http://linux.die.net/man/8/netstat" text="netstat man page">}} |

## Bridge/STP Commands

| Command(s) | Description | Example | More Information |
| ---------- | ----------- | ------- | ---------------- |
| `brctl show` | Displays bridge information. | <pre>cumulus@leaf1$ brctl show<br><br>bridge name bridge id       STP enabled interfaces<br>br0     8000.7072cfbe0d6c   yes     swp32s0<br>br1     8000.7072cfbe0d6d   yes     swp32s1</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-2/Ethernet-Bridging-VLANs/" text="Ethernet Bridging">}} |
| `brctl showmacs <BRIDGE>` | Displays the MAC FDB for a bridge. | <pre>cumulus@leaf1$ brctl showmacs br0<br>port name mac addr      vlan    is local?   ageing timer<br>swp32s0   70:72:cf:be:0d:6c 0   yes        0.00</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-2/Ethernet-Bridging-VLANs/" text="Ethernet Bridging">}} |
| `brctl showstp <BRIDGE>` | Displays the STP information for a bridge. | <pre>cumulus@leaf1$ brctl showstp br1<br>br1<br> bridge id      8000.7072cfbe0d6d<br> designated root    8000.7072cfbe0d6d<br> root port         0            path cost          0<br> max age          20.00         bridge max age        20.00<br> hello time        2.00         bridge hello time      2.00<br> forward delay        15.00         bridge forward delay      15.00<br> ageing time         300.00<br> hello timer           0.00         tcn timer          0.00<br> topology change timer     0.00         gc timer         277.39<br> hash elasticity    4096            hash max        4096<br> mc last member count      2            mc init query count    2<br> mc router         1            mc snooping        1<br> mc last member timer      1.00         mc membership timer  260.00<br> mc querier timer    255.00         mc query interval    125.00<br> mc response interval     10.00         mc init query interval    31.25<br> mc querier        0            mc query ifaddr        0<br> flags<br><br>swp32s1 (1)<br> port id        8001            state            forwarding<br> designated root    8000.7072cfbe0d6d   path cost          2<br> designated bridge  8000.7072cfbe0d6d   message age timer      0.00<br> designated port    8001            forward delay timer    0.00<br> designated cost       0            hold timer         0.00<br> mc router         1            mc fast leave          0<br> flags</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-2/Ethernet-Bridging-VLANs/" text="Ethernet Bridging">}} |
| `bridge fdb show` | Displays the FDB for all bridges. | <pre>cumulus@leaf1$ bridge fdb show<br>70:72:cf:be:0d:6d dev swp32s1 vlan 0 master br1 permanent<br>70:72:cf:be:0d:6c dev swp32s0 vlan 0 master br0 permanent</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-2/Ethernet-Bridging-VLANs/" text="Ethernet Bridging">}} |
| `bridge vlan show` | Displays VLAN-aware bridge mode VLAN configuration. | <pre>cumulus@leaf1$ bridge vlan show<br><br>port    vlan ids<br>swp32s0  1 PVID Egress Untagged<br>     100<br>     200<br><br>swp32s1  1 PVID Egress Untagged<br>     100<br>     200<br><br>bridge  None</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-2/Ethernet-Bridging-VLANs/" text="Ethernet Bridging">}} |
| `clagctl -v` | Displays MLAG information. | <pre>cumulus@leaf1$ clagctl -v<br>The peer is alive<br>     Our Priority, ID, and Role: 4096 34:17:eb:f6:15:fd primary<br>    Peer Priority, ID, and Role: 4096 34:17:eb:f9:80:fd secondary<br>          Peer Interface and IP: peerlink.4094 169.254.255.1<br>               VxLAN Anycast IP: 10.254.4.1<br>                      Backup IP: 10.11.26.37 (active)<br>                     System MAC: 44:38:39:ff:00:01<br>CLAG Interfaces<br>Our Interface      Peer Interface     CLAG Id   Conflicts              Proto-Down Reason<br>----------------   ----------------   -------   --------------------   -----------------<br>          vni100   vni100             -         -                      -<br>           bond0   -                  1         -                      -<br>           bond1   bond1              2         -                      -<br>           bond2   bond2              3         -                      -<br>           vni30   vni30              -         -                      -<br>           vni20   vni20              -         -                      -<br>           vni40   vni40              -         -                      -<br>Our LACP Information<br>Our Interface      Partner MAC         CIST PortId   CLAG Id   Oper St   Flags<br>----------------   -----------------   -----------   -------   -------   -----<br>bond0              00:00:00:00:00:00   None          1         None      -<br>bond1              b0:83:fe:eb:91:99   None          2         None      D<br>bond2              00:01:e8:8b:c9:da   None          3         None      D<br>Peer LACP Information<br>Peer Interface     Partner MAC         CIST PortId   CLAG Id   Oper St   Flags<br>----------------   -----------------   -----------   -------   -------   -----<br>bond0              00:00:00:00:00:00   None          1         None      -<br>bond1              b0:83:fe:eb:91:99   None          2         None      D<br>bond2              00:01:e8:8b:c9:da   None          3         None      D<br>Backup info:<br>IP: 10.11.26.37; State: active; Role: primary<br>Peer priority and id: 4096 34:17:eb:f9:80:fd; Peer role: secondary<br>Our Interface      Dynamic MAC         VLAN Id<br>----------------   -----------------   -------<br>vni100             00:00:02:00:00:06   0<br>vni100             00:00:02:00:00:01   0<br>bond1              00:0c:29:48:b1:38   20<br>vni20              00:0c:29:ea:71:3c   20<br>bond2              00:00:01:00:00:00   0<br>vni100             00:00:02:00:00:03   0<br>vni100             00:00:02:00:00:0a   0<br>bond2              00:00:01:00:00:01   0<br>vni100             00:00:02:00:00:04   0<br>bond2              00:00:01:00:00:02   0<br>vni100             00:00:02:00:00:08   0<br>bond2              00:00:01:00:00:03   0<br>Peer Interface     Dynamic MAC         VLAN Id<br>bond2              00:00:01:00:00:09   0<br>bond2              00:00:01:00:00:06   0<br>bond2              00:00:01:00:00:07   0<br>bond2              00:01:e8:8b:c9:dc   0<br>vni100             00:00:02:00:00:00   0<br>vni100             00:00:02:00:00:05   0<br>vni100             00:00:02:00:00:09   0<br>bond2              00:00:01:00:00:04   0<br>vni100             00:00:02:00:00:02   0<br>vni100             00:00:02:00:00:07   0<br>bond2              00:00:01:00:00:08   0<br>bond2              00:00:01:00:00:05   0<br>bond2              00:00:01:00:00:0a   0<br>Our Multicast Group      Port               VLAN Id   Device             Age<br>----------------------   ----------------   -------   ----------------   ---<br>Peer Multicast Group     Port               VLAN Id   Device             Age<br>----------------------   ----------------   -------   ----------------   ---<br>Our Router Port    Device             Age<br>----------------   ----------------   ---<br>Peer Router Port   Device             Age<br>----------------   ----------------   ---<br>Our VLAN Information<br>Our Interface      VLAN Id<br>----------------   -------<br>vni100             None<br>bond1              20, 30, 40<br>bond2              None<br>vni30              None<br>vni20              None<br>vni40              None<br>Peer VLAN Information<br>Peer Interface     VLAN Id<br>----------------   -------<br>vni100             None<br>bond1              20, 30, 40<br>bond2              None<br>vni30              None<br>vni20              None</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-2/Multi-Chassis-Link-Aggregation-MLAG/" text="Multi-Chassis Link Aggregation - MLAG">}} |
| `mstpctl showbridge` | Displays mstpd (RSTP) information. | <pre>cumulus@leaf1$ mstpctl showbridge<br>bridge CIST info<br>  enabled         yes<br>  bridge id       8.000.70:72:CF:BE:0D:6C<br>  designated root 8.000.70:72:CF:BE:0D:6C<br>  regional root   8.000.70:72:CF:BE:0D:6C<br>  root port       none<br>  path cost     0          internal path cost   0<br>  max age       20         bridge max age       20<br>  forward delay 15         bridge forward delay 15<br>  tx hold count 6          max hops             20<br>  hello time    2          ageing time          300<br>  force protocol version     rstp<br>  time since topology change 69446s<br>  topology change count      0<br>  topology change            no<br>  topology change port       None<br>  last topology change port  None</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-2/Spanning-Tree-and-Rapid-Spanning-Tree/" text="Spanning Tree and Rapid Spanning Tree">}} |
| `mstpctl showport <BRIDGE>` | Displays the summary of each port\'s role on a bridge. | <pre>cumulus@leaf1$ mstpctl showport bridge<br> E swp32s0 8.002 forw 8.000.70:72:CF:BE:0D:6C 8.000.70:72:CF:BE:0D:6C 8.002 Desg<br> E swp32s1 8.001 forw 8.000.70:72:CF:BE:0D:6C 8.000.70:72:CF:BE:0D:6C 8.001 Desg</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-2/Spanning-Tree-and-Rapid-Spanning-Tree/" text="Spanning Tree and Rapid Spanning Tree">}} |
| `mstpctl showportdetail <BRIDGE>` | Displays detailed mstpd port information for a bridge. | <pre>cumulus@leaf1$ mstpctl showportdetail bridge<br>bridge:swp32s0 CIST info<br>  enabled            yes                     role                 Designated<br>  port id            8.002                   state                forwarding<br>  external port cost 2000                    admin external cost  0<br>  internal port cost 2000                    admin internal cost  0<br>  designated root    8.000.70:72:CF:BE:0D:6C dsgn external cost   0<br>  dsgn regional root 8.000.70:72:CF:BE:0D:6C dsgn internal cost   0<br>  designated bridge  8.000.70:72:CF:BE:0D:6C designated port      8.002<br>  admin edge port    no                      auto edge port       yes<br>  oper edge port     yes                     topology change ack  no<br>  point-to-point     yes                     admin point-to-point auto<br>  restricted role    no                      restricted TCN       no<br>  port hello time    2                       disputed             no<br>  bpdu guard port    no                      bpdu guard error     no<br>  network port       no                      BA inconsistent      no<br>  Num TX BPDU        34819                   Num TX TCN           0<br>  Num RX BPDU        0                       Num RX TCN           0<br>  Num Transition FWD 1                       Num Transition BLK   0<br>  bpdufilter port    no<br>  clag ISL           no                      clag ISL Oper UP     no<br>  clag role          unknown                 clag dual conn mac   0:0:0:0:0:0<br>  clag remote portID F.FFF                   clag system mac      0:0:0:0:0:0<br>bridge:swp32s1 CIST info<br>  enabled            yes                     role                 Designated<br>  port id            8.001                   state                forwarding<br>  external port cost 2000                    admin external cost  0<br>  internal port cost 2000                    admin internal cost  0<br>  designated root    8.000.70:72:CF:BE:0D:6C dsgn external cost   0<br>  dsgn regional root 8.000.70:72:CF:BE:0D:6C dsgn internal cost   0<br>  designated bridge  8.000.70:72:CF:BE:0D:6C designated port      8.001<br>  admin edge port    no                      auto edge port       yes<br>  oper edge port     yes                     topology change ack  no<br>  point-to-point     yes                     admin point-to-point auto<br>  restricted role    no                      restricted TCN       no<br>  port hello time    2                       disputed             no<br>  bpdu guard port    no                      bpdu guard error     no<br>  network port       no                      BA inconsistent      no<br>  Num TX BPDU        34819                   Num TX TCN           0<br>  Num RX BPDU        0                       Num RX TCN           0<br>  Num Transition FWD 1                       Num Transition BLK   0<br>  bpdufilter port    no<br>  clag ISL           no                      clag ISL Oper UP     no<br>  clag role          unknown                 clag dual conn mac   0:0:0:0:0:0<br>  clag remote portID F.FFF                   clag system mac      0:0:0:0:0:0</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-2/Spanning-Tree-and-Rapid-Spanning-Tree/" text="Spanning Tree and Rapid Spanning Tree">}} |

## Routing Commands

| Command(s) | Description | Example | More Information |
| ---------- | ----------- | ------- | ---------------- |
| `ip route show` | Displays the Linux route table. | <pre>cumulus@leaf1$ ip route show<br>default via 192.168.0.1 dev eth0<br>10.1.1.0/30 dev swp1s0  proto kernel  scope link  src 10.1.1.1<br>10.1.1.4/30 dev swp1s1  proto kernel  scope link  src 10.1.1.5<br>10.1.1.16/30 via 10.1.1.2 dev swp1s0  proto zebra  metric 20<br>10.1.1.20/30 via 10.1.1.2 dev swp1s0  proto zebra  metric 20<br>10.1.1.32/30 dev swp1s2  proto kernel  scope link  src 10.1.1.33<br>10.1.1.36/30 dev swp1s3  proto kernel  scope link  src 10.1.1.37<br>10.1.1.48/30 via 10.1.1.34 dev swp1s2  proto zebra  metric 20<br>10.1.1.52/30 via 10.1.1.34 dev swp1s2  proto zebra  metric 20<br>10.2.1.2 via 10.1.1.2 dev swp1s0  proto zebra  metric 20<br>10.2.1.3 via 10.1.1.2 dev swp1s0  proto zebra  metric 20<br>10.2.1.4 via 10.1.1.34 dev swp1s2  proto zebra  metric 20<br>10.4.1.0/25 dev br0  proto kernel  scope link  src 10.4.1.1<br>10.4.1.128/25 dev br1  proto kernel  scope link  src 10.4.1.129<br>10.4.2.0/25 via 10.1.1.2 dev swp1s0  proto zebra  metric 20<br>10.4.2.128/25 via 10.1.1.2 dev swp1s0  proto zebra  metric 20<br>192.168.0.0/24 dev eth0  proto kernel  scope link  src 192.168.0.11</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-3/Routing/" text="Routing">}} |
| `ptmctl -d` | Displays detailed Prescriptive Topology Manager (PTM) information. | <pre>cumulus@leaf1$ ptmctl -d<br>----------------------------------------------------------------------------------------------------------------------------<br>port     cbl     exp           act           sysname  portID  portDescr  match   last  BFD     BFD   BFD    BFD   BFD<br>         status  nbr           nbr                                       on      upd   status  peer  local  type  DownDiag<br>----------------------------------------------------------------------------------------------------------------------------<br>swp1s0   pass    spine1:swp49  spine1:swp49  spine1   swp49   swp49      IfName  37s   N/A     N/A   N/A    N/A   N/A<br>swp1s1   pass    spine1:swp50  spine1:swp50  spine1   swp50   swp50      IfName  37s   N/A     N/A   N/A    N/A   N/A<br>swp1s2   pass    spine2:swp51  spine2:swp51  spine2   swp51   swp51      IfName  37s   N/A     N/A   N/A    N/A   N/A<br>swp1s3   pass    spine2:swp52  spine2:swp52  spine2   swp52   swp52      IfName  37s   N/A     N/A   N/A    N/A   N/A<br>swp17    N/A     leaf2:swp17   no-info       N/A      N/A     N/A        N/A     N/A   N/A     N/A   N/A    N/A   N/A<br>swp18    N/A     leaf2:swp18   no-info       N/A      N/A     N/A        N/A     N/A   N/A     N/A   N/A    N/A   N/A<br>swp32s0  N/A     server1:eth3  no-info       N/A      N/A     N/A        N/A     N/A   N/A     N/A   N/A    N/A   N/A<br>swp32s1  N/A     server2:eth2  no-info       N/A      N/A     N/A        N/A     N/A   N/A     N/A   N/A    N/A   N/A</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-1-and-Switch-Ports/Prescriptive-Topology-Manager-PTM/" text="PTM">}} |
| `vtysh`[^1] | A modal (interactive industry standard) CLI for configuring FRRouting. | <pre>cumulus@leaf1$ sudo vtysh<br><br>Hello, this is FRRouting (version 7.0+cl4u1).<br>Copyright 1996-2005 Kunihiro Ishiguro, et al.<br><br>leaf01# show ver<br>FRRouting 7.0+cl4u1 (leaf01).<br>Copyright 1996-2005 Kunihiro Ishiguro, et al.</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-3/Configure-FRRouting/#frrouting-vtysh-modal-cli" text="Configure FRRouting - Modal">}} |
| `vtysh -c "show ip route"`[^1] | Displays the FRRouting routing table. | <pre>cumulus@leaf1$ sudo vtysh -c "show ip route"<br><br>Codes: K - kernel route, C - connected, S - static, R - RIP,<br>       O - OSPF, I - IS-IS, B - BGP, E - EIGRP, N - NHRP,<br>       T - Table, v - VNC, V - VNC-Direct, A - Babel, D - SHARP,<br>       F - PBR, f - OpenFabric,<br>       > - selected route, * - FIB route, q - queued route, r - rejected route<br><br>K>* 0.0.0.0/0 [0/0] via 192.168.0.254, eth0, 1d23h44m<br>C>* 10.0.0.11/32 is directly connected, lo, 1d23h44m<br>B>* 10.0.0.12/32 [20/0] via fe80::4638:39ff:fe00:25, swp52, 1d23h44m<br>  *                     via fe80::4638:39ff:fe00:54, swp51, 1d23h44m<br>B>* 10.0.0.13/32 [20/0] via fe80::4638:39ff:fe00:25, swp52, 1d23h44m<br>  *                     via fe80::4638:39ff:fe00:54, swp51, 1d23h44m<br>B>* 10.0.0.14/32 [20/0] via fe80::4638:39ff:fe00:25, swp52, 1d23h44m<br>  *                     via fe80::4638:39ff:fe00:54, swp51, 1d23h44m<br>B>* 10.0.0.22/32 [20/0] via fe80::4638:39ff:fe00:25, swp52, 1d23h44m<br>B>* 10.0.0.121/32 [20/0] via fe80::4638:39ff:fe00:54, swp51, 1d23h44m<br>C * 172.16.1.0/24 [0/1024] is directly connected, vlan100-v0, 1d23h03m<br>C>* 172.16.1.0/24 is directly connected, vlan100, 1d23h03m<br>B>* 172.16.2.0/24 [20/0] via fe80::4638:39ff:fe00:25, swp52, 1d23h42m<br>  *                      via fe80::4638:39ff:fe00:54, swp51, 1d23h42m<br>C>* 192.168.0.0/24 is directly connected, eth0, 1d23h44m</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-3/Configure-FRRouting/" text="Configure FRRouting">}} |
| `net show ospf neighbor`[^1] | Displays OSPF neighbors. | <pre>cumulus@switch:~$ net show ospf neighbor<br>Neighbor ID     Pri State           Dead Time Address         Interface                        RXmtL RqstL DBsmL<br>10.0.255.101      1 Full/DROther      38.091s 10.0.255.11     swp51:10.0.255.21                    0     0     0<br>10.0.255.102      1 Full/DROther      38.085s 10.0.255.12     swp52:10.0.255.21                    0     0     0 </pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-3/Open-Shortest-Path-First-OSPF/" text="OSPF">}} |
| `net show bgp summary`[^1]<br>`vtysh -c "show ip bgp summary"`[^1] | Displays BGP summary information. | <pre>cumulus@leaf01:~$ sudo vtysh -c "show ip bgp summary"<br><br>IPv4 Unicast Summary:<br>BGP router identifier 10.0.0.11, local AS number 65011 vrf-id 0<br>BGP table version 89<br>RIB entries 15, using 2760 bytes of memory<br>Peers 2, using 41 KiB of memory<br>Peer groups 1, using 64 bytes of memory<br><br>Neighbor        V         AS MsgRcvd MsgSent   TblVer  InQ OutQ  Up/Down State/PfxRcd<br>spine01(swp51)  4      65020   57399   57432        0    0    0 1d23h47m            5<br>spine02(swp52)  4      65020   57400   57432        0    0    0 1d23h47m            5<br><br>Total number of neighbors 2</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-3/Border-Gateway-Protocol-BGP/" text="BGP">}} |
| `net show bgp ipv4 unicast`<br>`vtysh -c "show ip bgp"`[^1] | Displays the BGP routing table. | <pre>cumulus@leaf1$ sudo vtysh -c "show ip bgp"<br>BGP table version is 220, local router ID is 10.2.1.1<br>Status codes: s suppressed, d damped, h history, * valid, > best, = multipath,<br>              i internal, r RIB-failure, S Stale, R Removed<br>Origin codes: i - IGP, e - EGP, ? - incomplete<br><br>   Network          Next Hop            Metric LocPrf Weight Path<br>*> 10.1.1.0/30      0.0.0.0                  0         32768 ?<br>* i                 10.1.1.2                 0    100      0 ?<br>* i                 10.1.1.6                 0    100      0 ?<br>*> 10.1.1.4/30      0.0.0.0                  0         32768 ?<br>* i                 10.1.1.6                 0    100      0 ?<br>* i                 10.1.1.2                 0    100      0 ?<br>* i10.1.1.16/30     10.1.1.6                 0    100      0 ?<br>*>i                 10.1.1.2                 0    100      0 ?<br>* i                 10.1.1.38                0    100      0 ?<br>* i                 10.1.1.34                0    100      0 ?<br>* i10.1.1.20/30     10.1.1.6                 0    100      0 ?<br>*>i                 10.1.1.2                 0    100      0 ?<br>* i                 10.1.1.38                0    100      0 ?<br>* i                 10.1.1.34                0    100      0 ?<br>*> 10.1.1.32/30     0.0.0.0                  0         32768 ?<br>* i                 10.1.1.38                0    100      0 ?<br>* i                 10.1.1.34                0    100      0 ?<br>*> 10.1.1.36/30     0.0.0.0                  0         32768 ?<br>* i                 10.1.1.38                0    100      0 ?<br>* i                 10.1.1.34                0    100      0 ?<br>* i10.1.1.48/30     10.1.1.38                0    100      0 ?<br>*>i                 10.1.1.34                0    100      0 ?<br>* i                 10.1.1.6                 0    100      0 ?<br>* i                 10.1.1.2                 0    100      0 ?<br>* i10.1.1.52/30     10.1.1.38                0    100      0 ?<br>*>i                 10.1.1.34                0    100      0 ?<br>* i                 10.1.1.6                 0    100      0 ?<br>* i                 10.1.1.2                 0    100      0 ?<br>*> 10.2.1.1/32      0.0.0.0                  0         32768 ?<br>* i10.2.1.2/32      10.1.1.38                0    100      0 ?<br>* i                 10.1.1.34                0    100      0 ?<br>* i                 10.1.1.6                 0    100      0 ?<br>*>i                 10.1.1.2                 0    100      0 ?<br>* i10.2.1.3/32      10.1.1.6                 0    100      0 ?<br>*>i                 10.1.1.2                 0    100      0 ?<br>* i10.2.1.4/32      10.1.1.38                0    100      0 ?<br>*>i                 10.1.1.34                0    100      0 ?<br>* i10.4.2.0/25      10.1.1.38                0    100      0 ?<br>* i                 10.1.1.34                0    100      0 ?<br>* i                 10.1.1.6                 0    100      0 ?<br>*>i                 10.1.1.2                 0    100      0 ?<br>* i10.4.2.128/25    10.1.1.38                0    100      0 ?<br>* i                 10.1.1.34                0    100      0 ?<br>* i                 10.1.1.6                 0    100      0 ?<br>*>i                 10.1.1.2                 0    100      0 ?<br>*> 192.168.0.0      0.0.0.0                  0         32768 ?<br>* i                 10.1.1.6                 0    100      0 ?<br>* i                 10.1.1.2                 0    100      0 ?<br>* i                 10.1.1.38                0    100      0 ?<br>* i                 10.1.1.34                0    100      0 ?<br><br>Total number of prefixes 15</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/Layer-3/Border-Gateway-Protocol-BGP/" text="BGP">}} |

## ACL Commands

| Command(s) | Description | Example | More Information |
| ---------- | ----------- | ------- | ---------------- |
| `cl-acltool -L all`[^1] | Displays all filter rules. | <pre>cumulus@leaf1$ sudo cl-acltool -L all<br>-------------------------------<br>Listing rules of type iptables:<br>-------------------------------<br>TABLE filter :<br>Chain INPUT (policy ACCEPT 11749 packets, 1752K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br>    0     0 DROP       all  --  swp+   any     240.0.0.0/5          anywhere<br>    0     0 DROP       all  --  swp+   any     loopback/8           anywhere<br>    0     0 DROP       all  --  swp+   any     base-address.mcast.net/8  anywhere<br>    0     0 DROP       all  --  swp+   any     255.255.255.255      anywhere<br>    0     0 SETCLASS   udp  --  swp+   any     anywhere             anywhere             udp dpt:3785 SETCLASS  class:7<br>    0     0 POLICE     udp  --  any    any     anywhere             anywhere             udp dpt:3785 POLICE  mode:pkt rate:2000 burst:2000<br>    0     0 SETCLASS   udp  --  swp+   any     anywhere             anywhere             udp dpt:3784 SETCLASS  class:7<br>    0     0 POLICE     udp  --  any    any     anywhere             anywhere             udp dpt:3784 POLICE  mode:pkt rate:2000 burst:2000<br>    0     0 SETCLASS   udp  --  swp+   any     anywhere             anywhere             udp dpt:4784 SETCLASS  class:7<br>    0     0 POLICE     udp  --  any    any     anywhere             anywhere             udp dpt:4784 POLICE  mode:pkt rate:2000 burst:2000<br>    0     0 SETCLASS   ospf --  swp+   any     anywhere             anywhere             SETCLASS  class:7<br>    0     0 POLICE     ospf --  any    any     anywhere             anywhere             POLICE  mode:pkt rate:2000 burst:2000<br>20312 1650K SETCLASS   tcp  --  swp+   any     anywhere             anywhere             tcp dpt:bgp SETCLASS  class:7<br>20312 1732K POLICE     tcp  --  any    any     anywhere             anywhere             tcp dpt:bgp POLICE  mode:pkt rate:2000 burst:2000<br>    5   453 SETCLASS   tcp  --  swp+   any     anywhere             anywhere             tcp spt:bgp SETCLASS  class:7<br>    5   473 POLICE     tcp  --  any    any     anywhere             anywhere             tcp spt:bgp POLICE  mode:pkt rate:2000 burst:2000<br>    0     0 SETCLASS   tcp  --  swp+   any     anywhere             anywhere             tcp dpt:5342 SETCLASS  class:7<br>    0     0 POLICE     tcp  --  any    any     anywhere             anywhere             tcp dpt:5342 POLICE  mode:pkt rate:2000 burst:2000<br>    0     0 SETCLASS   tcp  --  swp+   any     anywhere             anywhere             tcp spt:5342 SETCLASS  class:7<br>    0     0 POLICE     tcp  --  any    any     anywhere             anywhere             tcp spt:5342 POLICE  mode:pkt rate:2000 burst:2000<br>    5   330 SETCLASS   icmp --  swp+   any     anywhere             anywhere             SETCLASS  class:2<br>    8   574 POLICE     icmp --  any    any     anywhere             anywhere             POLICE  mode:pkt rate:100 burst:40<br>    0     0 SETCLASS   udp  --  swp+   any     anywhere             anywhere             udp dpts:bootps:bootpc SETCLASS  class:2<br>   16  5248 POLICE     udp  --  any    any     anywhere             anywhere             udp dpt:bootps POLICE  mode:pkt rate:100 burst:100<br>  108 40068 POLICE     udp  --  any    any     anywhere             anywhere             udp dpt:bootpc POLICE  mode:pkt rate:100 burst:100<br>    0     0 SETCLASS   tcp  --  swp+   any     anywhere             anywhere             tcp dpts:bootps:bootpc SETCLASS  class:2<br>    0     0 POLICE     tcp  --  any    any     anywhere             anywhere             tcp dpt:bootps POLICE  mode:pkt rate:100 burst:100<br>    0     0 POLICE     tcp  --  any    any     anywhere             anywhere             tcp dpt:bootpc POLICE  mode:pkt rate:100 burst:100<br>    0     0 SETCLASS   udp  --  swp+   any     anywhere             anywhere             udp dpt:10001 SETCLASS  class:3<br>    0     0 POLICE     udp  --  any    any     anywhere             anywhere             udp dpt:10001 POLICE  mode:pkt rate:2000 burst:2000<br>    0     0 SETCLASS   igmp --  swp+   any     anywhere             anywhere             SETCLASS  class:6<br>    0     0 POLICE     igmp --  any    any     anywhere             anywhere             POLICE  mode:pkt rate:300 burst:100<br>    0     0 POLICE     all  --  swp+   any     anywhere             anywhere             ADDRTYPE match dst-type LOCAL POLICE  mode:pkt rate:1000 burst:1000 class:0<br>    0     0 POLICE     all  --  swp+   any     anywhere             anywhere             ADDRTYPE match dst-type IPROUTER POLICE  mode:pkt rate:400 burst:100 class:0<br>    0     0 SETCLASS   all  --  swp+   any     anywhere             anywhere             SETCLASS  class:0<br><br>Chain FORWARD (policy ACCEPT 0 packets, 0 bytes)<br> pkts bytes target     prot opt in     out     source               destination<br>    0     0 DROP       all  --  swp+   any     240.0.0.0/5          anywhere<br>    0     0 DROP       all  --  swp+   any     loopback/8           anywhere<br>    0     0 DROP       all  --  swp+   any     base-address.mcast.net/8  anywhere<br>    0     0 DROP       all  --  swp+   any     255.255.255.255      anywhere<br><br>Chain OUTPUT (policy ACCEPT 31983 packets, 2328K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br><br>TABLE mangle :<br>Chain PREROUTING (policy ACCEPT 31472 packets, 2689K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br>Chain INPUT (policy ACCEPT 11137 packets, 1399K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br>Chain FORWARD (policy ACCEPT 0 packets, 0 bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br>Chain OUTPUT (policy ACCEPT 31390 packets, 2272K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br>Chain POSTROUTING (policy ACCEPT 31394 packets, 2272K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br><br>TABLE raw :<br>Chain PREROUTING (policy ACCEPT 31473 packets, 2689K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br>Chain OUTPUT (policy ACCEPT 31391 packets, 2272K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br><br>--------------------------------<br>Listing rules of type ip6tables:<br>--------------------------------<br>TABLE filter :<br>Chain INPUT (policy ACCEPT 9473 packets, 836K <br> pkts bytes target     prot opt in     out     source               destination<br>    0     0 DROP       all      swp+   any     ip6-mcastprefix/8    anywhere<br>    0     0 DROP       all      swp+   any     ::/128               anywhere<br>    0     0 DROP       all      swp+   any     ::ffff:0.0.0.0/96    anywhere<br>    0     0 DROP       all      swp+   any     localhost/128        anywhere<br>    0     0 POLICE     udp      swp+   any     anywhere             anywhere             udp dpt:3785 POLICE  mode:pkt rate:2000 burst:2000 class:7<br>    0     0 POLICE     udp      swp+   any     anywhere             anywhere             udp dpt:3784 POLICE  mode:pkt rate:2000 burst:2000 class:7<br>    0     0 POLICE     udp      swp+   any     anywhere             anywhere             udp dpt:4784 POLICE  mode:pkt rate:2000 burst:2000 class:7<br>    0     0 POLICE     ospf     swp+   any     anywhere             anywhere             POLICE  mode:pkt rate:2000 burst:2000 class:7<br>    0     0 POLICE     tcp      swp+   any     anywhere             anywhere             tcp dpt:bgp POLICE  mode:pkt rate:2000 burst:2000 class:7<br>    0     0 POLICE     tcp      swp+   any     anywhere             anywhere             tcp spt:bgp POLICE  mode:pkt rate:2000 burst:2000 class:7<br>    0     0 POLICE     ipv6-icmp    swp+   any     anywhere             anywhere             ipv6-icmp router-solicitation POLICE  mode:pkt rate:100 burst:100 class:2<br>    0     0 POLICE     ipv6-icmp    swp+   any     anywhere             anywhere             ipv6-icmp router-advertisement POLICE  mode:pkt rate:500 burst:500 class:2<br>    0     0 POLICE     ipv6-icmp    swp+   any     anywhere             anywhere             ipv6-icmp neighbour-solicitation POLICE  mode:pkt rate:400 burst:400 class:2<br>    0     0 POLICE     ipv6-icmp    swp+   any     anywhere             anywhere             ipv6-icmp neighbour-advertisement POLICE  mode:pkt rate:400 burst:400 class:2<br>    0     0 POLICE     ipv6-icmp    swp+   any     anywhere             anywhere             ipv6-icmptype 130 POLICE  mode:pkt rate:200 burst:100 class:6<br>    0     0 POLICE     ipv6-icmp    swp+   any     anywhere             anywhere             ipv6-icmptype 131 POLICE  mode:pkt rate:200 burst:100 class:6<br>    0     0 POLICE     ipv6-icmp    swp+   any     anywhere             anywhere             ipv6-icmptype 132 POLICE  mode:pkt rate:200 burst:100 class:6<br>    4   376 POLICE     ipv6-icmp    swp+   any     anywhere             anywhere             ipv6-icmptype 143 POLICE  mode:pkt rate:200 burst:100 class:6<br>    0     0 POLICE     ipv6-icmp    swp+   any     anywhere             anywhere             POLICE  mode:pkt rate:64 burst:40 class:2<br>    0     0 POLICE     udp      swp+   any     anywhere             anywhere             udp dpts:dhcpv6-client:dhcpv6-server POLICE  mode:pkt rate:100 burst:100 class:2<br>    0     0 POLICE     tcp      swp+   any     anywhere             anywhere             tcp dpts:dhcpv6-client:dhcpv6-server POLICE  mode:pkt rate:100 burst:100 class:2<br>    0     0 POLICE     all      swp+   any     anywhere             anywhere             ADDRTYPE match dst-type LOCAL POLICE  mode:pkt rate:1000 burst:1000 class:0<br>    0     0 POLICE     all      swp+   any     anywhere             anywhere             ADDRTYPE match dst-type IPROUTER POLICE  mode:pkt rate:400 burst:100 class:0<br>    0     0 SETCLASS   all      swp+   any     anywhere             anywhere             SETCLASS  class:0<br><br>Chain FORWARD (policy ACCEPT 2 packets, 208 bytes)<br> pkts bytes target     prot opt in     out     source               destination<br>    0     0 DROP       all      swp+   any     ip6-mcastprefix/8    anywhere<br>    0     0 DROP       all      swp+   any     ::/128               anywhere<br>    0     0 DROP       all      swp+   any     ::ffff:0.0.0.0/96    anywhere<br>    0     0 DROP       all      swp+   any     localhost/128        anywhere<br><br>Chain OUTPUT (policy ACCEPT 9683 packets, 884K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br><br>TABLE mangle :<br>Chain PREROUTING (policy ACCEPT 9455 packets, 835K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br>Chain INPUT (policy ACCEPT 9449 packets, 834K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br>Chain FORWARD (policy ACCEPT 2 packets, 208 bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br>Chain OUTPUT (policy ACCEPT 9641 packets, 880K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br>Chain POSTROUTING (policy ACCEPT 9625 packets, 879K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br><br>TABLE raw :<br>Chain PREROUTING (policy ACCEPT 9455 packets, 835K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br>Chain OUTPUT (policy ACCEPT 9641 packets, 880K bytes)<br> pkts bytes target     prot opt in     out     source               destination<br><br><br>-------------------------------<br>Listing rules of type ebtables:<br>-------------------------------<br>TABLE filter :<br>Bridge table: filter<br><br>Bridge chain: INPUT, entries: 16, policy: ACCEPT<br>-d BGA -i swp+ -j setclass --class 7 , pcnt = 0 -- bcnt = 0<br>-d BGA -j police --set-mode pkt --set-rate 2000 --set-burst 2000 , pcnt = 0 -- bcnt = 0<br>-d 1:80:c2:0:0:2 -i swp+ -j setclass --class 7 , pcnt = 0 -- bcnt = 0<br>-d 1:80:c2:0:0:2 -j police --set-mode pkt --set-rate 2000 --set-burst 2000 , pcnt = 0 -- bcnt = 0<br>-d 1:80:c2:0:0:e -i swp+ -j setclass --class 6 , pcnt = 23045 -- bcnt = 2926715<br>-d 1:80:c2:0:0:e -j police --set-mode pkt --set-rate 200 --set-burst 200 , pcnt = 23045 -- bcnt = 3018895<br>-d 1:0:c:cc:cc:cc -i swp+ -j setclass --class 6 , pcnt = 0 -- bcnt = 0<br>-d 1:0:c:cc:cc:cc -j police --set-mode pkt --set-rate 200 --set-burst 200 , pcnt = 0 -- bcnt = 0<br>-p ARP -i swp+ -j setclass --class 2 , pcnt = 45529 -- bcnt = 2913856<br>-p ARP -j police --set-mode pkt --set-rate 400 --set-burst 100 , pcnt = 45529 -- bcnt = 3095972<br>-d 1:0:c:cc:cc:cd -i swp+ -j setclass --class 7 , pcnt = 0 -- bcnt = 0<br>-d 1:0:c:cc:cc:cd -j police --set-mode pkt --set-rate 2000 --set-burst 2000 , pcnt = 0 -- bcnt = 0<br>-p IPv4 -i swp+ -j ACCEPT , pcnt = 0 -- bcnt = 0<br>-p IPv6 -i swp+ -j ACCEPT , pcnt = 4 -- bcnt = 376<br>-i swp+ -j setclass --class 0 , pcnt = 0 -- bcnt = 0<br>-j police --set-mode pkt --set-rate 100 --set-burst 100 , pcnt = 0 -- bcnt = 0<br><br>Bridge chain: FORWARD, entries: 0, policy: ACCEPT<br><br>Bridge chain: OUTPUT, entries: 0, policy: ACCEPT</pre> |  {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Netfilter-ACLs/" text="Netfilter - ACLs">}} |
| `iptables -L`[^1] | Displays the IPv4 filter rules. | <pre>cumulus@leaf1$ sudo iptables -L<br>Chain INPUT (policy ACCEPT)<br>target     prot opt source               destination<br>DROP       all  --  240.0.0.0/5          anywhere<br>DROP       all  --  loopback/8           anywhere<br>DROP       all  --  base-address.mcast.net/8  anywhere<br>DROP       all  --  255.255.255.255      anywhere<br>SETCLASS   udp  --  anywhere             anywhere             udp dpt:3785 SETCLASS  class:7<br>POLICE     udp  --  anywhere             anywhere             udp dpt:3785 POLICE  mode:pkt rate:2000 burst:2000<br>SETCLASS   udp  --  anywhere             anywhere             udp dpt:3784 SETCLASS  class:7<br>POLICE     udp  --  anywhere             anywhere             udp dpt:3784 POLICE  mode:pkt rate:2000 burst:2000<br>SETCLASS   udp  --  anywhere             anywhere             udp dpt:4784 SETCLASS  class:7<br>POLICE     udp  --  anywhere             anywhere             udp dpt:4784 POLICE  mode:pkt rate:2000 burst:2000<br>SETCLASS   ospf --  anywhere             anywhere             SETCLASS  class:7<br>POLICE     ospf --  anywhere             anywhere             POLICE  mode:pkt rate:2000 burst:2000<br>SETCLASS   tcp  --  anywhere             anywhere             tcp dpt:bgp SETCLASS  class:7<br>POLICE     tcp  --  anywhere             anywhere             tcp dpt:bgp POLICE  mode:pkt rate:2000 burst:2000<br>SETCLASS   tcp  --  anywhere             anywhere             tcp spt:bgp SETCLASS  class:7<br>POLICE     tcp  --  anywhere             anywhere             tcp spt:bgp POLICE  mode:pkt rate:2000 burst:2000<br>SETCLASS   tcp  --  anywhere             anywhere             tcp dpt:5342 SETCLASS  class:7<br>POLICE     tcp  --  anywhere             anywhere             tcp dpt:5342 POLICE  mode:pkt rate:2000 burst:2000<br>SETCLASS   tcp  --  anywhere             anywhere             tcp spt:5342 SETCLASS  class:7<br>POLICE     tcp  --  anywhere             anywhere             tcp spt:5342 POLICE  mode:pkt rate:2000 burst:2000<br>SETCLASS   icmp --  anywhere             anywhere             SETCLASS  class:2<br>POLICE     icmp --  anywhere             anywhere             POLICE  mode:pkt rate:100 burst:40<br>SETCLASS   udp  --  anywhere             anywhere             udp dpts:bootps:bootpc SETCLASS  class:2<br>POLICE     udp  --  anywhere             anywhere             udp dpt:bootps POLICE  mode:pkt rate:100 burst:100<br>POLICE     udp  --  anywhere             anywhere             udp dpt:bootpc POLICE  mode:pkt rate:100 burst:100<br>SETCLASS   tcp  --  anywhere             anywhere             tcp dpts:bootps:bootpc SETCLASS  class:2<br>POLICE     tcp  --  anywhere             anywhere             tcp dpt:bootps POLICE  mode:pkt rate:100 burst:100<br>POLICE     tcp  --  anywhere             anywhere             tcp dpt:bootpc POLICE  mode:pkt rate:100 burst:100<br>SETCLASS   udp  --  anywhere             anywhere             udp dpt:10001 SETCLASS  class:3<br>POLICE     udp  --  anywhere             anywhere             udp dpt:10001 POLICE  mode:pkt rate:2000 burst:2000<br>SETCLASS   igmp --  anywhere             anywhere             SETCLASS  class:6<br>POLICE     igmp --  anywhere             anywhere             POLICE  mode:pkt rate:300 burst:100<br>POLICE     all  --  anywhere             anywhere             ADDRTYPE match dst-type LOCAL POLICE  mode:pkt rate:1000 burst:1000 class:0<br>POLICE     all  --  anywhere             anywhere             ADDRTYPE match dst-type IPROUTER POLICE  mode:pkt rate:400 burst:100 class:0<br>SETCLASS   all  --  anywhere             anywhere             SETCLASS  class:0<br><br>Chain FORWARD (policy ACCEPT)<br>target     prot opt source               destination<br>DROP       all  --  240.0.0.0/5          anywhere<br>DROP       all  --  loopback/8           anywhere<br>DROP       all  --  base-address.mcast.net/8  anywhere<br>DROP       all  --  255.255.255.255      anywhere<br><br>Chain OUTPUT (policy ACCEPT)<br>target     prot opt source               destination</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Netfilter-ACLs/" text="Netfilter - ACLs">}} |
| `ip6tables -L`[^1] | Displays the IPv6 filter rules. | <pre>cumulus@leaf1$ sudo ip6tables -L<br>Chain INPUT (policy ACCEPT)<br>target     prot opt source               destination<br>DROP       all      ip6-mcastprefix/8    anywhere<br>DROP       all      ::/128               anywhere<br>DROP       all      ::ffff:0.0.0.0/96    anywhere<br>DROP       all      localhost/128        anywhere<br>POLICE     udp      anywhere             anywhere             udp dpt:3785 POLICE  mode:pkt rate:2000 burst:2000 class:7<br>POLICE     udp      anywhere             anywhere             udp dpt:3784 POLICE  mode:pkt rate:2000 burst:2000 class:7<br>POLICE     udp      anywhere             anywhere             udp dpt:4784 POLICE  mode:pkt rate:2000 burst:2000 class:7<br>POLICE     ospf     anywhere             anywhere             POLICE  mode:pkt rate:2000 burst:2000 class:7<br>POLICE     tcp      anywhere             anywhere             tcp dpt:bgp POLICE  mode:pkt rate:2000 burst:2000 class:7<br>POLICE     tcp      anywhere             anywhere             tcp spt:bgp POLICE  mode:pkt rate:2000 burst:2000 class:7<br>POLICE     ipv6-icmp    anywhere             anywhere             ipv6-icmp router-solicitation POLICE  mode:pkt rate:100 burst:100 class:2<br>POLICE     ipv6-icmp    anywhere             anywhere             ipv6-icmp router-advertisement POLICE  mode:pkt rate:500 burst:500 class:2<br>POLICE     ipv6-icmp    anywhere             anywhere             ipv6-icmp neighbour-solicitation POLICE  mode:pkt rate:400 burst:400 class:2<br>POLICE     ipv6-icmp    anywhere             anywhere             ipv6-icmp neighbour-advertisement POLICE  mode:pkt rate:400 burst:400 class:2<br>POLICE     ipv6-icmp    anywhere             anywhere             ipv6-icmptype 130 POLICE  mode:pkt rate:200 burst:100 class:6<br>POLICE     ipv6-icmp    anywhere             anywhere             ipv6-icmptype 131 POLICE  mode:pkt rate:200 burst:100 class:6<br>POLICE     ipv6-icmp    anywhere             anywhere             ipv6-icmptype 132 POLICE  mode:pkt rate:200 burst:100 class:6<br>POLICE     ipv6-icmp    anywhere             anywhere             ipv6-icmptype 143 POLICE  mode:pkt rate:200 burst:100 class:6<br>POLICE     ipv6-icmp    anywhere             anywhere             POLICE  mode:pkt rate:64 burst:40 class:2<br>POLICE     udp      anywhere             anywhere             udp dpts:dhcpv6-client:dhcpv6-server POLICE  mode:pkt rate:100 burst:100 class:2<br>POLICE     tcp      anywhere             anywhere             tcp dpts:dhcpv6-client:dhcpv6-server POLICE  mode:pkt rate:100 burst:100 class:2<br>POLICE     all      anywhere             anywhere             ADDRTYPE match dst-type LOCAL POLICE  mode:pkt rate:1000 burst:1000 class:0<br>POLICE     all      anywhere             anywhere             ADDRTYPE match dst-type IPROUTER POLICE  mode:pkt rate:400 burst:100 class:0<br>SETCLASS   all      anywhere             anywhere             SETCLASS  class:0<br><br>Chain FORWARD (policy ACCEPT)<br>target     prot opt source               destination<br>DROP       all      ip6-mcastprefix/8    anywhere<br>DROP       all      ::/128               anywhere<br>DROP       all      ::ffff:0.0.0.0/96    anywhere<br>DROP       all      localhost/128        anywhere<br><br>Chain OUTPUT (policy ACCEPT)<br>target     prot opt source               destination</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Netfilter-ACLs/" text="Netfilter - ACLs">}} |
| `ebtables -L`[^1] | Displays the ebtables (L2 MAC address) filter rules. | <pre>cumulus@leaf1$ sudo ebtables -L<br>Bridge table: filter<br><br>Bridge chain: INPUT, entries: 16, policy: ACCEPT<br>-d BGA -i swp+ -j setclass --class 7<br>-d BGA -j police --set-mode pkt --set-rate 2000 --set-burst 2000<br>-d 1:80:c2:0:0:2 -i swp+ -j setclass --class 7<br>-d 1:80:c2:0:0:2 -j police --set-mode pkt --set-rate 2000 --set-burst 2000<br>-d 1:80:c2:0:0:e -i swp+ -j setclass --class 6<br>-d 1:80:c2:0:0:e -j police --set-mode pkt --set-rate 200 --set-burst 200<br>-d 1:0:c:cc:cc:cc -i swp+ -j setclass --class 6<br>-d 1:0:c:cc:cc:cc -j police --set-mode pkt --set-rate 200 --set-burst 200<br>-p ARP -i swp+ -j setclass --class 2<br>-p ARP -j police --set-mode pkt --set-rate 400 --set-burst 100<br>-d 1:0:c:cc:cc:cd -i swp+ -j setclass --class 7<br>-d 1:0:c:cc:cc:cd -j police --set-mode pkt --set-rate 2000 --set-burst 2000<br>-p IPv4 -i swp+ -j ACCEPT<br>-p IPv6 -i swp+ -j ACCEPT<br>-i swp+ -j setclass --class 0<br>-j police --set-mode pkt --set-rate 100 --set-burst 100<br><br>Bridge chain: FORWARD, entries: 0, policy: ACCEPT<br><br>Bridge chain: OUTPUT, entries: 0, policy: ACCEPT</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Netfilter-ACLs/" text="Netfilter - ACLs">}} |

## Miscellaneous Commands

| Command(s) | Description | Example | More Information |
| ---------- | ----------- | ------- | ---------------- |
| `netstat -l` | Displays all active listening port connections. | <pre>cumulus@leaf1$ netstat -l<br>Active Internet connections (only servers)<br>Proto Recv-Q Send-Q Local Address           Foreign Address         State<br>tcp        0      0 0.0.0.0:zebra           0.0.0.0:*               LISTEN<br>tcp        0      0 0.0.0.0:bgpd            0.0.0.0:*               LISTEN<br>tcp        0      0 localhost:http-alt      0.0.0.0:*               LISTEN<br>tcp        0      0 0.0.0.0:bgp             0.0.0.0:*               LISTEN<br>tcp        0      0 0.0.0.0:ssh             0.0.0.0:*               LISTEN<br>tcp        0      0 0.0.0.0:2616            0.0.0.0:*               LISTEN<br>tcp6       0      0 [::]:zebra              [::]:*                  LISTEN<br>tcp6       0      0 [::]:bgpd               [::]:*                  LISTEN<br>tcp6       0      0 [::]:bgp                [::]:*                  LISTEN<br>tcp6       0      0 [::]:ssh                [::]:*                  LISTEN<br>tcp6       0      0 [::]:2616               [::]:*                  LISTEN<br>tcp6       0      0 fe80::4638:39ff:fe:5342 [::]:*                  LISTEN<br>udp        0      0 0.0.0.0:bootpc          0.0.0.0:*<br>udp        0      0 leaf01:ntp              0.0.0.0:*<br>udp        0      0 localhost:ntp           0.0.0.0:*<br>udp        0      0 0.0.0.0:ntp             0.0.0.0:*<br>udp        0      0 0.0.0.0:4784            0.0.0.0:*<br>udp        0      0 0.0.0.0:34489           0.0.0.0:*<br>udp        0      0 0.0.0.0:3784            0.0.0.0:*<br>udp        0      0 0.0.0.0:3785            0.0.0.0:*<br>udp        0      0 0.0.0.0:5342            0.0.0.0:*<br>udp6       0      0 fe80::a200:ff:fe00::ntp [::]:*<br>udp6       0      0 localhost:ntp           [::]:*<br>udp6       0      0 [::]:ntp                [::]:*<br>udp6       0      0 [::]:4784               [::]:*<br>udp6       0      0 [::]:3784               [::]:*<br>raw6       0      0 [::]:ipv6-icmp          [::]:*                  7<br>Active UNIX domain sockets (only servers)<br>Proto RefCnt Flags       Type       State         I-Node   Path<br>unix  2      [ ACC ]     STREAM     LISTENING     30989    /var/run/frr/bgpd.vty<br>unix  2      [ ACC ]     STREAM     LISTENING     95538    /var/run/clag-zebra.socket<br>unix  2      [ ACC ]     STREAM     LISTENING     95545    /var/run/clagd.socket<br>unix  2      [ ACC ]     STREAM     LISTENING     31033    /var/run/frr/staticd.vty<br>unix  2      [ ACC ]     STREAM     LISTENING     27316    @/var/run/ptmd.socket<br>unix  2      [ ACC ]     STREAM     LISTENING     10123    /run/systemd/private<br>unix  2      [ ACC ]     STREAM     LISTENING     30869    /var/run/frr/watchfrr.vty<br>unix  2      [ ACC ]     STREAM     LISTENING     10138    /run/lvm/lvmpolld.socket<br>unix  2      [ ACC ]     STREAM     LISTENING     10149    /run/systemd/fsck.progress<br>unix  2      [ ACC ]     STREAM     LISTENING     12197    /run/uuidd/request<br>unix  2      [ ACC ]     SEQPACKET  LISTENING     10152    /run/udev/control<br>unix  2      [ ACC ]     STREAM     LISTENING     10155    /run/systemd/journal/stdout<br>unix  2      [ ACC ]     STREAM     LISTENING     12213    /var/run/dbus/system_bus_socket<br>unix  2      [ ACC ]     STREAM     LISTENING     27308    @/var/run/ptmd-quagga.socket<br>unix  2      [ ACC ]     STREAM     LISTENING     28094    /run/nclu/uds<br>unix  2      [ ACC ]     STREAM     LISTENING     27594    /var/run/lldpd.socket<br>unix  2      [ ACC ]     STREAM     LISTENING     26838    /var/run/neighmgrd/uds<br>unix  2      [ ACC ]     STREAM     LISTENING     30952    /var/run/frr/zserv.api<br>unix  2      [ ACC ]     STREAM     LISTENING     30959    /var/run/frr/zebra.vty</pre> | {{<exlink url="http://linux.die.net/man/8/netstat" text="netstat man page">}} |
| `netstat -at` | Displays all active listening TCP socket connections. | <pre>cumulus@leaf1$ netstat -at<br>Active Internet connections (servers and established)<br>Proto Recv-Q Send-Q Local Address           Foreign Address         State<br>tcp        0      0 \*:bgp                   \*:*                     LISTEN<br>tcp        0      0 \*:ssh                   \*:*                     LISTEN<br>tcp        0      0 localhost.localdom:2812 *:*                     LISTEN<br>tcp        0      0 localhost.localdo:zebra *:*                     LISTEN<br>tcp        0      0 localhost.localdo:ospfd *:*                     LISTEN<br>tcp        0      0 localhost.localdom:bgpd *:*                     LISTEN<br>tcp        0      0 10.1.1.1:bgp            10.1.1.2:57267          ESTABLISHED<br>tcp        0      0 10.1.1.5:bgp            10.1.1.6:47451          ESTABLISHED<br>tcp        0      0 10.1.1.33:bgp           10.1.1.34:56332         ESTABLISHED<br>tcp        0      0 leaf1.lab.local:ssh     wbench.lab.local:50308  ESTABLISHED<br>tcp        0      0 10.1.1.37:bgp           10.1.1.38:45210         ESTABLISHED<br>tcp6       0      0 [::]:bgp                [::]:*                  LISTEN<br>tcp6       0      0 [::]:ssh                [::]:*                  LISTEN</pre> | {{<exlink url="http://linux.die.net/man/8/netstat" text="netstat man page">}} |
| `netstat -au` | Displays all active listening UDP socket connections. | <pre>cumulus@leaf1$ netstat -au<br>Active Internet connections (servers and established)<br>Proto Recv-Q Send-Q Local Address           Foreign Address         State<br>udp        0      0 *:46609                 *:*<br>udp        0      0 *:bootpc                *:*<br>udp        0      0 leaf1.lab.local:ntp     *:*<br>udp        0      0 localhost.localdoma:ntp *:*<br>udp        0      0 *:ntp                   *:*<br>udp        0      0 *:4784                  *:*<br>udp        0      0 *:3784                  *:*<br>udp        0      0 *:3785                  *:*<br>udp6       0      0 [::]:5638               [::]:*<br>udp6       0      0 fe80::7272:cfff:feb:ntp [::]:*<br>udp6       0      0 localhost:ntp           [::]:*<br>udp6       0      0 [::]:ntp                [::]:*<br>udp6       0      0 [::]:4784               [::]:*<br>udp6       0      0 [::]:3784               [::]:*</pre> | {{<exlink url="http://linux.die.net/man/8/netstat" text="netstat man page">}} |
| `ps -ef` | Displays all running processes. | <pre>cumulus@leaf1$ ps -ef<br>UID        PID  PPID  C STIME TTY          TIME CMD<br>root         1     0  0 Aug27 ?        00:00:21 /sbin/init<br>root         2     0  0 Aug27 ?        00:00:00 [kthreadd]<br>root         3     2  0 Aug27 ?        00:00:00 [rcu_gp]<br>root         4     2  0 Aug27 ?        00:00:00 [rcu_par_gp]<br>root         6     2  0 Aug27 ?        00:00:00 [kworker/0:0H-kblockd]<br>root         8     2  0 Aug27 ?        00:00:00 [mm_percpu_wq]<br>root         9     2  0 Aug27 ?        00:00:05 [ksoftirqd/0]<br>root        10     2  0 Aug27 ?        00:00:34 [rcu_sched]<br>root        11     2  0 Aug27 ?        00:00:00 [rcu_bh]<br>root        12     2  0 Aug27 ?        00:00:00 [migration/0]<br>root        14     2  0 Aug27 ?        00:00:00 [cpuhp/0]<br>root        15     2  0 Aug27 ?        00:00:00 [kdevtmpfs]<br>root        16     2  0 Aug27 ?        00:00:00 [netns]<br>root        17     2  0 Aug27 ?        00:00:00 [kauditd]<br>root        18     2  0 Aug27 ?        00:00:00 [khungtaskd]<br>root        19     2  0 Aug27 ?        00:00:00 [oom_reaper]<br>root        20     2  0 Aug27 ?        00:00:00 [writeback]<br>root        21     2  0 Aug27 ?        00:00:00 [kcompactd0]<br>root        22     2  0 Aug27 ?        00:00:00 [ksmd]<br>root        23     2  0 Aug27 ?        00:00:00 [khugepaged]<br>root        24     2  0 Aug27 ?        00:00:00 [crypto]<br>root        25     2  0 Aug27 ?        00:00:00 [kintegrityd]<br>root        26     2  0 Aug27 ?        00:00:00 [kblockd]<br>root        27     2  0 Aug27 ?        00:00:00 [ata_sff]<br>root        28     2  0 Aug27 ?        00:00:00 [edac-poller]<br>root        29     2  0 Aug27 ?        00:00:00 [watchdogd]<br>root        30     2  0 Aug27 ?        00:00:00 [rpciod]<br>root        31     2  0 Aug27 ?        00:00:00 [kworker/u3:0]<br>root        32     2  0 Aug27 ?        00:00:00 [xprtiod]<br>root        33     2  0 Aug27 ?        00:00:00 [kswapd0]<br>root        34     2  0 Aug27 ?        00:00:00 [nfsiod]<br>root        49     2  0 Aug27 ?        00:00:00 [kthrotld]<br>root        50     2  0 Aug27 ?        00:00:01 [kworker/0:1H-kblockd]<br>root        51     2  0 Aug27 ?        00:00:00 [scsi_eh_0]<br>root        52     2  0 Aug27 ?        00:00:00 [scsi_tmf_0]<br>root        53     2  0 Aug27 ?        00:00:00 [scsi_eh_1]<br>root        54     2  0 Aug27 ?        00:00:00 [scsi_tmf_1]<br>root        56     2  0 Aug27 ?        00:00:00 [ipv6_addrconf]<br>root       115     2  0 Aug27 ?        00:00:03 [jbd2/vda4-8]<br>root       116     2  0 Aug27 ?        00:00:00 [ext4-rsv-conver]<br>    root       207     1  0 Aug27 ?        00:01:44 /lib/systemd/systemd-journald<br>root       221     1  0 Aug27 ?        00:00:00 /lib/systemd/systemd-udevd<br>root       232     1  0 Aug27 ?        00:00:03 /usr/sbin/haveged --Foreground --verbose=1 -w 1024<br>root       238     1  0 Aug27 ?        00:00:00 /sbin/auditd<br>root       268     1  0 Aug27 ?        00:00:28 /usr/sbin/rsyslogd -n -iNONE<br>message+   273     1  0 Aug27 ?        00:00:00 /usr/bin/dbus-daemon --system --address=systemd: --no<br>root       275     1  0 Aug27 ?        00:00:00 /usr/sbin/rasdaemon -f -r<br>root       279     1  0 Aug27 ?        00:00:00 /lib/systemd/systemd-logind<br>root       284     1  0 Aug27 ?        00:00:00 /usr/sbin/cron -f -L 38<br>root       292     1  0 Aug27 ?        00:00:01 /usr/sbin/wd_keepalive<br>root       293     1  0 Aug27 tty1     00:00:00 /sbin/agetty -o -p -- \u --noclear tty1 linux<br>root       294     1  0 Aug27 ?        00:01:22 /sbin/mstpd -d -v2<br>root       326     1  0 Aug27 ?        00:00:00 nginx: master process /usr/sbin/nginx -g daemon on; m<br>www-data   327   326  0 Aug27 ?        00:00:00 nginx: worker process<br>root       468     1  0 Aug27 ?        00:00:00 /usr/sbin/switchd -vx<br>root       488     1  0 Aug27 ?        00:06:46 /usr/bin/python2 /usr/sbin/smond<br>root       493     1  0 Aug27 ?        00:00:49 /usr/bin/python2 /usr/sbin/pwmd<br>root       494     1  0 Aug27 ?        00:00:31 /usr/bin/python2 /usr/sbin/ledmgrd<br>root       564     1  0 Aug27 ?        00:00:02 /sbin/dhclient -pf /run/dhclient.eth0.pid -lf /var/li<br>root       635     1  0 Aug27 ?        00:13:29 /usr/bin/python2 /usr/bin/neighmgrd<br>root       637     1  0 Aug27 ?        00:00:07 /bin/bash /usr/lib/cumulus/sysmonitor<br>root       646     1  0 Aug27 ?        00:00:01 /usr/bin/python -O /usr/sbin/netd -d<br>root       657     1  0 Aug27 ?        00:00:00 /usr/sbin/sshd -D<br>ntp        700     1  0 Aug27 ?        00:00:30 /usr/sbin/ntpd -n -u ntp:ntp -g<br>root       704     1  0 Aug27 ttyS0    00:00:00 /sbin/agetty -o -p -- \u --keep-baud 115200,38400,960<br>root       705     1  0 Aug27 ?        00:00:19 /usr/sbin/ptmd -l INFO<br>_lldpd     707     1  0 Aug27 ?        00:00:00 lldpd: monitor.<br>_lldpd     711   707  0 Aug27 ?        00:01:00 lldpd: 10 neighbors.<br>root      1055     2  0 Aug27 ?        00:00:00 [peerlink]<br>root      1157     2  0 Aug27 ?        00:00:00 [server01]<br>root      1165     2  0 Aug27 ?        00:00:00 [server02]<br>root      1537     1  0 Aug27 ?        00:00:23 /usr/lib/frr/watchfrr -d zebra bgpd staticd<br>frr       1553     1  0 Aug27 ?        00:02:18 /usr/lib/frr/zebra -d<br>frr       1557     1  0 Aug27 ?        00:00:52 /usr/lib/frr/bgpd -d<br>frr       1563     1  0 Aug27 ?        00:00:08 /usr/lib/frr/staticd -d<br>root      3352     2  0 01:51 ?        00:00:00 [kworker/0:1]<br>root      3559     2  0 01:57 ?        00:00:03 [kworker/0:0-events]<br>root      4478     1  1 Aug27 ?        00:43:46 /usr/bin/python /usr/sbin/clagd --daemon linklocal pe<br>root      4613     2  0 02:24 ?        00:00:00 [kworker/u2:1-server02]<br>root      5433     2  0 02:49 ?        00:00:00 [kworker/u2:0-peerlink]<br>root      5637   657  0 02:55 ?        00:00:00 sshd: cumulus [priv]<br>cumulus   5672  5637  0 02:55 ?        00:00:00 sshd: cumulus@pts/0<br>cumulus   5673  5672  0 02:55 pts/0    00:00:00 -bash<br>root      6317     2  0 03:12 ?        00:00:00 [kworker/u2:2-events_unbound]<br>root      6372   637  0 03:13 ?        00:00:00 sleep 60<br>cumulus   6398  5673  0 03:14 pts/0    00:00:00 ps -ef</pre> |  {{<exlink url="http://linux.die.net/man/1/ps" text="ps man page">}} |

## NCLU net show Command

The {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Network-Command-Line-Utility-NCLU/" text="NCLU">}} `net show` command displays a lot of useful information about the network, including netstat counters, interface details and LLDP information, as just three examples.

| Command(s) | Description | Example | More Information |
| ---------- | ----------- | ------- | ---------------- |
| `net show counters` | Displays interface counters. | <pre>cumulus@leaf1$ net show counters<br>Kernel Interface table<br>Iface            MTU    Met    RX_OK    RX_ERR    RX_DRP    RX_OVR    TX_OK    TX_ERR    TX_DRP    TX_OVR  Flg<br>-------------  -----  -----  -------  --------  --------  --------  -------  --------  --------  --------  -----<br>bond-swp1       1500      0     1298         0         0         0     1950         0         0         0  BMmRU<br>bond-swp2       1500      0     1322         0         0         0     1976         0         0         0  BMmRU<br>bridge          1500      0       26         0         0         0       27         0         0         0  BMRU<br>eth0            1500      0     9306         0         0         0     6462         0         0         0  BMRU<br>lo             65536      0        0         0         0         0        0         0         0         0  LRU<br>mgmt           65536      0     6001         0         0         0     4907         0         0         0  OmRU<br>peerlink        1500      0     4643         0         4         0     4645         0         0         0  BMmRU<br>peerlink.4094   1500      0     1533         0         0         0     1534         0         0         0  BMRU<br>swp1            1500      0     1306         0         0         0     1950         0         0         0  BMsRU<br>swp2            1500      0     1330         0         0         0     1976         0         0         0  BMsRU<br>swp49           1500      0     2328         0         0         0     2324         0         0         0  BMsRU<br>swp50           1500      0     2315         0         2         0     2321         0         0         0  BMsRU<br>swp51           1500      0     1235         0         0         0     1212         0         0         0  BMRU<br>swp52           1500      0     1046         0         0         0     1049         0         0         0  BMRU<br>vlan20          1500      0       24         0         0         0       20         0         0         0  BMRU<br>vlan20-v0       1500      0       15         0         0         0       13         0         0         0  BMRU</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Network-Command-Line-Utility-NCLU/" text="NCLU">}} |
| `net show lldp` | Displays all LLDP neighbors, in a table format. | <pre>cumulus@leaf1$ net show lldp<br><br>LocalPort  Speed  Mode        RemoteHost       RemotePort<br>---------  -----  ----------  ---------------  ----------<br>eth0       1G     Mgmt        oob-mgmt-switch  swp6<br>eth0       1G     Mgmt        oob-mgmt-switch  swp6<br>swp1       1G     BondMember  server01         eth1<br>swp2       1G     BondMember  server02         eth1<br>swp49      1G     BondMember  leaf02           swp49<br>swp49      1G     BondMember  leaf02           to Leaf01<br>swp50      1G     BondMember  leaf02           swp50<br>swp50      1G     BondMember  leaf02           to Leaf01<br>swp51      1G     Default     spine01          to Leaf01<br>swp51      1G     Default     spine01          swp1<br>swp52      1G     Default     spine02          swp1<br>swp52      1G     Default     spine02          to Leaf01</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Network-Command-Line-Utility-NCLU/" text="NCLU">}} |
| `net show interface` | Displays significant and relevant information for all \'up\' interfaces. | <pre>cumulus@leaf1$ net show interface<br><br>       Name           Master     Speed      MTU  Mode            Remote Host      Remote Port        Summary<br>-----  -------------  ---------  -------  -----  --------------  ---------------  -----------------  ---------------------------------------<br>UP     lo             None       N/A      65536  Loopback                                            IP: 10.254.0.3/32, 127.0.0.1/8, ::1/128<br>UP     eth0           mgmt       1G        1500  Mgmt            oob-mgmt-switch  swp8               IP: 192.168.0.13/24(DHCP)<br>UP     swp1           bond-swp1  1G        1500  BondMember      server03         44:38:39:00:00:28  Master: bond-swp1(UP)<br>UP     swp2           bond-swp2  1G        1500  BondMember      server04         44:38:39:00:00:23  Master: bond-swp2(UP)<br>UP     swp49          peerlink   1G        1500  BondMember      leaf04           swp49              Master: peerlink(UP)<br>UP     swp50          peerlink   1G        1500  BondMember      leaf04           swp50              Master: peerlink(UP)<br>UP     swp51          None       1G        1500  BGP Unnumbered  spine01          swp3<br>UP     swp52          None       1G        1500  BGP Unnumbered  spine02          swp3<br>UP     bond-swp1      bridge     1G        1500  Bond/Access                                         Bond Members: swp1(UP)<br>UP     bond-swp2      bridge     1G        1500  Bond/Access                                         Bond Members: swp2(UP)<br>UP     bridge         None       N/A       1500  Bridge/L2                                           Untagged Members: bond-swp1-2, peerlink<br>UP     mgmt           None       N/A      65536  Interface/L3                                        IP: 127.0.0.1/8<br>UP     peerlink       bridge     2G        1500  Bond/Trunk                                          Bond Members: swp49(UP), swp50(UP)<br>UP     peerlink.4094  None       2G        1500  SubInt/L3                                           IP: 169.254.1.1/30<br>ADMDN  vagrant        None       0M        1500  NotConfigured<br>UP     vlan20         None       N/A       1500  Interface/L3                                        IP: 10.3.20.253/24<br>UP     vlan20-v0      None       N/A       1500  Interface/L3                                        IP: 10.3.20.254/32</pre> | {{<exlink url="https://docs.cumulusnetworks.com/cumulus-linux/System-Configuration/Network-Command-Line-Utility-NCLU/" text="NCLU">}} |

[^1]: Requires `sudo` or to be logged in as root.
