---
title: Perpetual Licenses General Questions
author: Cumulus Networks
weight: 612
toc: 4
---

## How can I evaluate Cumulus Linux?

If you don\'t have a network switch on our {{<exlink url="https://cumulusnetworks.com/hcl" text="hardware compatibility list">}} (HCL) available for testing, reserve a {{<exlink url="https://cumulusnetworks.com/try-for-free/" text="Cumulus in the Cloud">}} and try out a test setup in your browser. {{<exlink url="https://cumulusnetworks.com/products/cumulus-in-the-cloud/autoprovision/" text="Build your simulation here">}} and start your test drive.

If you already have hardware from our HCL, fill out {{<exlink url="https://cumulusnetworks.com/contact/" text="this form">}} and a Cumulus Networks representative will contact you.

## How Is Cumulus Linux licensed?

Cumulus Linux is commercially available through a perpetual license model, giving customers right to use Cumulus Linux for the lifetime of the Open Networking hardware it runs on.

## What will I receive when I purchase a Cumulus Linux license?

Purchasing a Cumulus Linux license gives you right to use Cumulus Linux for the lifetime of the Open Networking hardware on which it runs. Combined with the license, customers can purchase a Software Updates and Support contract for 1-, 3-, and 5-year terms. An active contract gives customers full access to Cumulus Linux updates and our 24/7 enterprise-class support team, which are essential to running a mission critical production environment. Software Updates and Support includes:

- All software upgrades, including major and minor software releases.
- All software updates, including maintenance releases and security patches.
- Technical support.

When you purchase a Cumulus Linux license, you receive:

- Your order confirmation with proof of your purchase and entitlement to run the software, obtain updates, and receive technical support.
- Access to the {{<exlink url="https://cumulusnetworks.com/landing/" text="Cumulus Networks Customer Portal">}}, which includes account and user management, license and contract management, 24x7 support, and Cumulus Linux software downloads.

You need to purchase the hardware separately.

## How much does a Cumulus Linux license cost?

Contact our {{<exlink url="mailto:sales@cumulusnetworks.com" text="sales team">}} for more information.

## How can I order a Cumulus Linux license?

Cumulus Networks partners with approved resellers and distributors to facilitate your license procurement. Sign up on {{<exlink url="https://cumulusnetworks.com/contact/" text="our website">}} for assistance and information on our approved resellers.

Cumulus Networks does not sell any hardware; our resellers often do. Check our {{<exlink url="https://cumulusnetworks.com/hcl" text="HCL">}} for the list of our supported hardware.

## On how many switches can I run Cumulus Linux?

You can run Cumulus Linux concurrently on a number of switches equal to the number of licenses you have.

## Are Cumulus Linux licenses tied to specific hardware?

Cumulus Linux subscriptions are not tied to the specific hardware acquired at the time of purchase, but one license can run on just one switch at any given time. You can transfer a license from one switch to another, provided that:

- You are keeping within the number of licenses noted in your account entitlement inventory.
- The replacement switch has the same maximum port speed, such as 25G.
- The replacement switch has the same type of ASIC, such as Broadcom Tomahawk or Mellanox Spectrum.
- The license has the same term.

Because Cumulus Linux subscriptions are not tied to hardware, you can stock extra switches that meet the above requirements as backups to quickly replace any failing hardware. For instance, if you purchase 2 Cumulus Linux, 10G, 1 year subscriptions, you can run Cumulus Linux on two switches concurrently. If one of the two switches you are using fails, you can install the Cumulus Linux license file that is on that failing hardware to one of your spare switches, so long as it meets the requirements specified above.

## How do I know how many licenses I already have purchased and how do I find the expiration dates for my Software Updates and Support contracts?

Upon purchase of a Cumulus Linux license you will be granted access to the {{<exlink url="https://cumulusnetworks.com/landing/" text="Cumulus Networks Customer Portal">}}. After logging in to the portal, you can view your complete license history including active, pending, and expired Software Updates and Support contracts.

## How can I get a copy of the Cumulus Networks EULA (end-user license agreement)?

Please click the following link to view {{<exlink url="http://cumulusnetworks.com/downloads/eula/latest/view/" text="our EULA">}}.

## When does my Software Updates and Support contract start?

- **New license with a Software Updates and Support contract:** Upon purchase, you have 45 days to activate your license and Software Updates and Support contract through the {{<exlink url="https://cumulusnetworks.com/landing/" text="Cumulus Networks Customer Portal">}}. The date when you activate your contract is the start date. If not activated before 45 days, your contract will automatically activate on the 45th day after purchase.

    If you procured your license through Dell, your contract will start within 2 business days after you claim your license from our portal.
- **Renewal:** Renewals start on the last active date of the contract, regardless of when the renewal is purchased. For example, your Cumulus Linux 10G 1 year support contract starts on 2/2/2016 and expires on 2/2/2017. Its renewal will start on 2/2/2017.
- **Co-term:** Co-terminable contract start on the last active date of the contract, the same as renewals. For more information on co-terms, contact your account team.

## What happens when the Software Updates and Support contract expires?

Cumulus Linux licenses are perpetual but Software Updates and Support contracts are terms. With an expired contract you will be unable to get access to Cumulus Linux software updates or upgrades, and will be unable to contact our 24/7 enterprise-class support team, which are essential to running a mission critical production environment.
