---
title: SONiC Platform APIs
author: Cumulus Networks
weight: 80
product: SONiC
version: 4.0
siteSlug: sonic
---

| Modules | APIs |
| ------- | ---- |
| Chassis/eeprom APIs | get_base_mac(): Retrieves the base MAC address for the chassis<br />get_serial_number():Retrieves the hardware serial number for the chassis<br />get_system_eeprom_info():Retrieves the full content of system EEPROM information for the chassis<br />get_reboot_cause():Retrieves the cause of the previous reboot<br />get_component_name_list():Retrieves a list of the names of components available on the chassis (e.g., BIOS, CPLD, FPGA, etc.)<br />get_firmware_version():Retrieves platform-specific hardware/firmware versions for chassis components such as BIOS, CPLD, FPGA, etc.<br />install_component_firmware():Install firmware to component |
| FAN APIs | get_name(): Retrieves the name of the device<br />get_presence():Retrieves the presence of the device<br />get_model():Retrieves the model number (or part number) of the device<br />get_serial():Retrieves the serial number of the device<br />get_status():Retrieves the operational status of the device<br />get_direction():Retrieves the direction of fan<br />get_speed():Retrieves the speed of fan as a percentage of full speed<br />get_target_speed():Retrieves the target (expected) speed of the fan<br />get_speed_tolerance():Retrieves the speed tolerance of the fan<br />set_speed():Sets the fan speed<br />set_status_led():Sets the state of the fan module status LED<br />get_status_led():Gets the state of the fan status LED |
| PSU APIs | get_name(): Retrieves the name of the device<br />get_presence():Retrieves the presence of the device<br />get_model():Retrieves the model number (or part number) of the device<br />get_serial():Retrieves the serial number of the device<br />get_status():Retrieves the operational status of the device<br />get_num_fans():Retrieves the number of fan modules available on this PSU<br />get_all_fans():Retrieves all fan modules available on this PSU<br />get_fan():Retrieves fan module represented by (0-based) index &lt;index><br />get_voltage():Retrieves current PSU voltage output<br />get_current():Retrieves present electric current supplied by PSU<br />get_power():Retrieves current energy supplied by PSU<br />get_powergood_status():Retrieves the powergood status of PSU<br />set_status_led():Sets the state of the PSU status LED<br />get_status_led():Gets the state of the PSU status LED |
| SFP APIs | get_name(): Retrieves the name of the device // could be formed by using component type + index<br />get_presence():Retrieves the presence of the device<br />get_model():Retrieves the model number (or part number) of the device<br />get_serial():Retrieves the serial number of the device<br />get_status():Retrieves the operational status of the device<br />get_transceiver_info():Retrieves transceiver info of this SFP<br />get_transceiver_bulk_status():Retrieves transceiver bulk status of this SFP<br />get_transceiver_threshold_info():Retrieves transceiver threshold info of this SFP<br />get_reset_status():Retrieves the reset status of SFP<br />get_rx_los():Retrieves the RX LOS (lost-of-signal) status of SFP<br />get_tx_fault():Retrieves the TX fault status of SFP<br />get_tx_disable():Retrieves the tx_disable status of this SFP<br />get_tx_disable_channel():Retrieves the TX disabled channels in this SFP<br />get_lpmode():Retrieves the lpmode (low power mode) status of this SFP<br />get_power_override():Retrieves the power-override status of this SFP<br />get_temperature():Retrieves the temperature of this SFP<br />get_voltage():Retrieves the supply voltage of this SFP<br />get_tx_bias():Retrieves the TX bias current of this SFP<br />get_rx_power():Retrieves the received optical power for this SFP<br />get_tx_power():Retrieves the TX power of this SFP<br />reset():Reset SFP and return all user module settings to their default state.<br />tx_disable():Disable SFP TX for all channels<br />tx_disable_channel():Sets the tx_disable for specified SFP channels<br />set_lpmode():Sets the lpmode (low power mode) of SFP<br />set_power_override():Sets SFP power level using power_override and power_set |
| Thermal APIs | get_name(): Retrieves the name of the device<br />get_presence():Retrieves the presence of the device<br />get_model():Retrieves the model number (or part number) of the device<br />get_serial():Retrieves the serial number of the device<br />get_status():Retrieves the operational status of the device<br />get_temperature():Retrieves current temperature reading from thermal<br />get_high_threshold():Retrieves the high threshold temperature of thermal<br />get_low_threshold():Retrieves the low threshold temperature of thermal<br />set_high_threshold():Sets the high threshold temperature of thermal<br />set_low_threshold():Sets the low threshold temperature of thermal |
| Watchdog APIs | arm():Arm the hardware watchdog with a timeout of &lt;seconds> seconds.<br />disarm(self):Disarm the hardware watchdog<br />is_armed(self):Retrieves the armed state of the hardware watchdog.<br />get_remaining_time(self):If the watchdog is armed, retrieve the number of seconds remaining on the watchdog timer |
