---
name: Lint proposal
about: Propose a new lint rule or a modification to an existing one.
title: 'proposal: `<rule_name>`'
labels: 'lint proposal, status: pending'
assignees: ''

---

## <lint_name>

*Replace <lint_name> above with your proposed rule name.  (See notes on naming in [Writing Lints].)*

## Description

*Provide a short description suitable for display in console output.*

## Details

*Give a detailed description that should provide context and motivation.  Ideally this could be used directly in the rule's documentation.*

## Kind

*Does this enforce style advice?  Guard against errors?  Other?*

## Good Examples 

*Add a few examples that demonstrate a “good” adoption of this lint’s principle.*

## Bad Examples

*Add a few examples that demonstrate where this lint should fire.*

## Discussion

*Add any other motivation or useful context here.*

### Discussion checklist

- [ ] List any existing rules this proposal modifies, complements, overlaps or conflicts with.
- [ ] List any relevant issues (reported here, the [SDK Tracker], or elsewhere).
- [ ] If there's any prior art (e.g., in other linters), please add references here.
- [ ] If this proposal corresponds to [Effective Dart] or [Flutter Style Guide] advice, please call it out. (If there isn't any corresponding advice, should there be?)
- [ ] If this proposal is motivated by real-world examples, please provide as many details as you can.  Demonstrating potential impact is _especially valuable_.

<!-- Links -->
[Writing Lints]: https://github.com/dart-lang/linter/blob/main/doc/writing-lints.md
[Effective Dart]: https://dart.dev/guides/language/effective-dart
[Flutter Style Guide]: https://github.com/flutter/flutter/wiki/Style-guide-for-Flutter-repo
[SDK Tracker]: https://github.com/dart-lang/sdk/issues
