// Copyright (c) 2010, Lawrence Livermore National Security, LLC. Produced at
// the Lawrence Livermore National Laboratory. LLNL-CODE-443271. All Rights
// reserved. See file COPYRIGHT for details.
//
// This file is part of the GLVis visualization tool and library. For more
// information and source code availability see http://glvis.org.
//
// GLVis is free software; you can redistribute it and/or modify it under the
// terms of the GNU Lesser General Public License (as published by the Free
// Software Foundation) version 2.1 dated February 1999.

#ifndef GLVIS_COLOR_PALETTES
#define GLVIS_COLOR_PALETTES

#include <cstdio>
#include <iostream>
#include <iomanip>

using namespace std;

const int RGB_Palette_1_Size = 5;
double RGB_Palette_1[RGB_Palette_1_Size][3] =
{
   { 0, 0, 1 },
   { 0, 1, 1 },
   { 0, 1, 0 },
   { 1, 1, 0 },
   { 1, 0, 0 }
};

const int RGB_Palette_2_Size = 2;
double RGB_Palette_2[RGB_Palette_2_Size][3] =
{
   { 1.0, 0.0, 0.0 },
   { 1.0, 0.0, 0.0 }
};

const int RGB_Palette_3_Size = 65;
double RGB_Palette_3[RGB_Palette_3_Size][3] =
{
   {      0,      0, 0.5000 },
   {      0,      0, 0.5625 },
   {      0,      0, 0.6250 },
   {      0,      0, 0.6875 },
   {      0,      0, 0.7500 },
   {      0,      0, 0.8125 },
   {      0,      0, 0.8750 },
   {      0,      0, 0.9375 },
   {      0,      0, 1.0000 },
   {      0, 0.0625, 1.0000 },
   {      0, 0.1250, 1.0000 },
   {      0, 0.1875, 1.0000 },
   {      0, 0.2500, 1.0000 },
   {      0, 0.3125, 1.0000 },
   {      0, 0.3750, 1.0000 },
   {      0, 0.4375, 1.0000 },
   {      0, 0.5000, 1.0000 },
   {      0, 0.5625, 1.0000 },
   {      0, 0.6250, 1.0000 },
   {      0, 0.6875, 1.0000 },
   {      0, 0.7500, 1.0000 },
   {      0, 0.8125, 1.0000 },
   {      0, 0.8750, 1.0000 },
   {      0, 0.9375, 1.0000 },

#if 0
   // original
   {      0, 1.0000, 1.0000 },
   { 0.0625, 1.0000, 0.9375 },
   { 0.1250, 1.0000, 0.8750 },
   { 0.1875, 1.0000, 0.8125 },
   { 0.2500, 1.0000, 0.7500 },
   { 0.3125, 1.0000, 0.6875 },
   { 0.3750, 1.0000, 0.6250 },
   { 0.4375, 1.0000, 0.5625 },
   { 0.5000, 1.0000, 0.5000 },

   { 0.5625, 1.0000, 0.4375 },
   { 0.6250, 1.0000, 0.3750 },
   { 0.6875, 1.0000, 0.3125 },
   { 0.7500, 1.0000, 0.2500 },
   { 0.8125, 1.0000, 0.1875 },
   { 0.8750, 1.0000, 0.1250 },
   { 0.9375, 1.0000, 0.0625 },
   { 1.0000, 1.0000,      0 },
#else
   // modification
   {      0, 1.0000, 1.0000 },
   {      0, 0.9750, 0.8750 },
   {      0, 0.9500, 0.7500 },
   {      0, 0.9250, 0.6250 },
   {      0, 0.9000, 0.5000 },
   {      0, 0.8750, 0.3750 },
   {      0, 0.8500, 0.2500 },
   {      0, 0.8250, 0.1250 },
   {      0, 0.8000,      0 },

   // x=[1/8:1/8:1]
   // red=x.^(.6)
   { 0.2872, 0.8250,      0 },
   { 0.4353, 0.8500,      0 },
   { 0.5552, 0.8750,      0 },
   { 0.6598, 0.9000,      0 },
   { 0.7543, 0.9250,      0 },
   { 0.8415, 0.9500,      0 },
   { 0.9230, 0.9750,      0 },
   { 1.0000, 1.0000,      0 },
#endif

   { 1.0000, 0.9375,      0 },
   { 1.0000, 0.8750,      0 },
   { 1.0000, 0.8125,      0 },
   { 1.0000, 0.7500,      0 },
   { 1.0000, 0.6875,      0 },
   { 1.0000, 0.6250,      0 },
   { 1.0000, 0.5625,      0 },
   { 1.0000, 0.5000,      0 },
   { 1.0000, 0.4375,      0 },
   { 1.0000, 0.3750,      0 },
   { 1.0000, 0.3125,      0 },
   { 1.0000, 0.2500,      0 },
   { 1.0000, 0.1875,      0 },
   { 1.0000, 0.1250,      0 },
   { 1.0000, 0.0625,      0 },
   { 1.0000,      0,      0 },
   { 0.9375,      0,      0 },
   { 0.8750,      0,      0 },
   { 0.8125,      0,      0 },
   { 0.7500,      0,      0 },
   { 0.6875,      0,      0 },
   { 0.6250,      0,      0 },
   { 0.5625,      0,      0 },
   { 0.5000,      0,      0 }
};

const int RGB_Palette_4_Size = 2;
double RGB_Palette_4[RGB_Palette_4_Size][3] =
{
   { 1.0, 0.8431, 0.0 },
   { 1.0, 0.8431, 0.0 }
};

const int RGB_Palette_5_Size = 64; // bone
double RGB_Palette_5[RGB_Palette_5_Size][3] =
{
   { 0, 0, 0.0052083333 },
   { 0.013888889, 0.013888889, 0.024305556 },
   { 0.027777778, 0.027777778, 0.043402778 },
   { 0.041666667, 0.041666667, 0.0625 },
   { 0.055555556, 0.055555556, 0.081597222 },
   { 0.069444444, 0.069444444, 0.10069444 },
   { 0.083333333, 0.083333333, 0.11979167 },
   { 0.097222222, 0.097222222, 0.13888889 },
   { 0.11111111, 0.11111111, 0.15798611 },
   { 0.125, 0.125, 0.17708333 },
   { 0.13888889, 0.13888889, 0.19618056 },
   { 0.15277778, 0.15277778, 0.21527778 },
   { 0.16666667, 0.16666667, 0.234375 },
   { 0.18055556, 0.18055556, 0.25347222 },
   { 0.19444444, 0.19444444, 0.27256944 },
   { 0.20833333, 0.20833333, 0.29166667 },
   { 0.22222222, 0.22222222, 0.31076389 },
   { 0.23611111, 0.23611111, 0.32986111 },
   { 0.25, 0.25, 0.34895833 },
   { 0.26388889, 0.26388889, 0.36805556 },
   { 0.27777778, 0.27777778, 0.38715278 },
   { 0.29166667, 0.29166667, 0.40625 },
   { 0.30555556, 0.30555556, 0.42534722 },
   { 0.31944444, 0.31944444, 0.44444444 },
   { 0.33333333, 0.33854167, 0.45833333 },
   { 0.34722222, 0.35763889, 0.47222222 },
   { 0.36111111, 0.37673611, 0.48611111 },
   { 0.375, 0.39583333, 0.5 },
   { 0.38888889, 0.41493056, 0.51388889 },
   { 0.40277778, 0.43402778, 0.52777778 },
   { 0.41666667, 0.453125, 0.54166667 },
   { 0.43055556, 0.47222222, 0.55555556 },
   { 0.44444444, 0.49131944, 0.56944444 },
   { 0.45833333, 0.51041667, 0.58333333 },
   { 0.47222222, 0.52951389, 0.59722222 },
   { 0.48611111, 0.54861111, 0.61111111 },
   { 0.5, 0.56770833, 0.625 },
   { 0.51388889, 0.58680556, 0.63888889 },
   { 0.52777778, 0.60590278, 0.65277778 },
   { 0.54166667, 0.625, 0.66666667 },
   { 0.55555556, 0.64409722, 0.68055556 },
   { 0.56944444, 0.66319444, 0.69444444 },
   { 0.58333333, 0.68229167, 0.70833333 },
   { 0.59722222, 0.70138889, 0.72222222 },
   { 0.61111111, 0.72048611, 0.73611111 },
   { 0.625, 0.73958333, 0.75 },
   { 0.63888889, 0.75868056, 0.76388889 },
   { 0.65277778, 0.77777778, 0.77777778 },
   { 0.67447917, 0.79166667, 0.79166667 },
   { 0.69618056, 0.80555556, 0.80555556 },
   { 0.71788194, 0.81944444, 0.81944444 },
   { 0.73958333, 0.83333333, 0.83333333 },
   { 0.76128472, 0.84722222, 0.84722222 },
   { 0.78298611, 0.86111111, 0.86111111 },
   { 0.8046875, 0.875, 0.875 },
   { 0.82638889, 0.88888889, 0.88888889 },
   { 0.84809028, 0.90277778, 0.90277778 },
   { 0.86979167, 0.91666667, 0.91666667 },
   { 0.89149306, 0.93055556, 0.93055556 },
   { 0.91319444, 0.94444444, 0.94444444 },
   { 0.93489583, 0.95833333, 0.95833333 },
   { 0.95659722, 0.97222222, 0.97222222 },
   { 0.97829861, 0.98611111, 0.98611111 },
   { 1, 1, 1 }
};

const int RGB_Palette_6_Size = 64; // hot
double RGB_Palette_6[RGB_Palette_6_Size][3] =
{
   { 0.041666667, 0, 0 },
   { 0.083333333, 0, 0 },
   { 0.125, 0, 0 },
   { 0.16666667, 0, 0 },
   { 0.20833333, 0, 0 },
   { 0.25, 0, 0 },
   { 0.29166667, 0, 0 },
   { 0.33333333, 0, 0 },
   { 0.375, 0, 0 },
   { 0.41666667, 0, 0 },
   { 0.45833333, 0, 0 },
   { 0.5, 0, 0 },
   { 0.54166667, 0, 0 },
   { 0.58333333, 0, 0 },
   { 0.625, 0, 0 },
   { 0.66666667, 0, 0 },
   { 0.70833333, 0, 0 },
   { 0.75, 0, 0 },
   { 0.79166667, 0, 0 },
   { 0.83333333, 0, 0 },
   { 0.875, 0, 0 },
   { 0.91666667, 0, 0 },
   { 0.95833333, 0, 0 },
   { 1, 0, 0 },
   { 1, 0.041666667, 0 },
   { 1, 0.083333333, 0 },
   { 1, 0.125, 0 },
   { 1, 0.16666667, 0 },
   { 1, 0.20833333, 0 },
   { 1, 0.25, 0 },
   { 1, 0.29166667, 0 },
   { 1, 0.33333333, 0 },
   { 1, 0.375, 0 },
   { 1, 0.41666667, 0 },
   { 1, 0.45833333, 0 },
   { 1, 0.5, 0 },
   { 1, 0.54166667, 0 },
   { 1, 0.58333333, 0 },
   { 1, 0.625, 0 },
   { 1, 0.66666667, 0 },
   { 1, 0.70833333, 0 },
   { 1, 0.75, 0 },
   { 1, 0.79166667, 0 },
   { 1, 0.83333333, 0 },
   { 1, 0.875, 0 },
   { 1, 0.91666667, 0 },
   { 1, 0.95833333, 0 },
   { 1, 1, 0 },
   { 1, 1, 0.0625 },
   { 1, 1, 0.125 },
   { 1, 1, 0.1875 },
   { 1, 1, 0.25 },
   { 1, 1, 0.3125 },
   { 1, 1, 0.375 },
   { 1, 1, 0.4375 },
   { 1, 1, 0.5 },
   { 1, 1, 0.5625 },
   { 1, 1, 0.625 },
   { 1, 1, 0.6875 },
   { 1, 1, 0.75 },
   { 1, 1, 0.8125 },
   { 1, 1, 0.875 },
   { 1, 1, 0.9375 },
   { 1, 1, 1 }
};

const int RGB_Palette_7_Size = 64; // pink
double RGB_Palette_7[RGB_Palette_7_Size][3] =
{
   { 0.11785113, 0, 0 },
   { 0.19585655, 0.1028689, 0.1028689 },
   { 0.2506605, 0.14547859, 0.14547859 },
   { 0.29546842, 0.17817416, 0.17817416 },
   { 0.33432392, 0.2057378, 0.2057378 },
   { 0.36911162, 0.23002185, 0.23002185 },
   { 0.40089186, 0.25197632, 0.25197632 },
   { 0.43033148, 0.27216553, 0.27216553 },
   { 0.45788217, 0.29095719, 0.29095719 },
   { 0.4838667, 0.3086067, 0.3086067 },
   { 0.5085252, 0.32530002, 0.32530002 },
   { 0.53204209, 0.34117754, 0.34117754 },
   { 0.5545626, 0.35634832, 0.35634832 },
   { 0.57620359, 0.37089909, 0.37089909 },
   { 0.5970607, 0.38490018, 0.38490018 },
   { 0.6172134, 0.39840954, 0.39840954 },
   { 0.63672858, 0.4114756, 0.4114756 },
   { 0.65566316, 0.42413934, 0.42413934 },
   { 0.67406608, 0.43643578, 0.43643578 },
   { 0.69197975, 0.44839514, 0.44839514 },
   { 0.70944124, 0.46004371, 0.46004371 },
   { 0.72648316, 0.47140452, 0.47140452 },
   { 0.74313436, 0.48249791, 0.48249791 },
   { 0.75942055, 0.49334191, 0.49334191 },
   { 0.76635604, 0.51754917, 0.50395263 },
   { 0.77322933, 0.54067369, 0.5143445 },
   { 0.78004206, 0.56284895, 0.52453053 },
   { 0.78679579, 0.58418305, 0.53452248 },
   { 0.79349205, 0.60476503, 0.54433105 },
   { 0.80013226, 0.62466922, 0.55396598 },
   { 0.80671783, 0.64395849, 0.56343617 },
   { 0.81325006, 0.66268653, 0.5727498 },
   { 0.81973024, 0.68089965, 0.58191437 },
   { 0.8261596, 0.69863813, 0.59093684 },
   { 0.8325393, 0.71593724, 0.59982361 },
   { 0.83887049, 0.73282811, 0.60858062 },
   { 0.84515425, 0.74933833, 0.6172134 },
   { 0.85139164, 0.76549254, 0.62572709 },
   { 0.85758366, 0.78131283, 0.63412649 },
   { 0.86373129, 0.79681907, 0.64241607 },
   { 0.86983548, 0.81202927, 0.65060005 },
   { 0.87589712, 0.82695975, 0.65868235 },
   { 0.8819171, 0.84162541, 0.66666667 },
   { 0.88789627, 0.85603985, 0.67455649 },
   { 0.89383544, 0.87021557, 0.68235509 },
   { 0.89973541, 0.88416403, 0.69006556 },
   { 0.90559694, 0.89789584, 0.69769082 },
   { 0.91142078, 0.91142078, 0.70523365 },
   { 0.91720763, 0.91720763, 0.72716562 },
   { 0.92295821, 0.92295821, 0.7484552 },
   { 0.92867317, 0.92867317, 0.76915572 },
   { 0.93435318, 0.93435318, 0.78931355 },
   { 0.93999887, 0.93999887, 0.80896923 },
   { 0.94561086, 0.94561086, 0.82815854 },
   { 0.95118973, 0.95118973, 0.84691316 },
   { 0.95673607, 0.95673607, 0.86526138 },
   { 0.96225045, 0.96225045, 0.88322851 },
   { 0.9677334, 0.9677334, 0.90083735 },
   { 0.97318546, 0.97318546, 0.91810853 },
   { 0.97860715, 0.97860715, 0.93506076 },
   { 0.98399897, 0.98399897, 0.95171107 },
   { 0.9893614, 0.9893614, 0.96807506 },
   { 0.99469492, 0.99469492, 0.98416699 },
   { 1, 1, 1 }
};

const int RGB_Palette_8_Size = 64; // cool
double RGB_Palette_8[RGB_Palette_8_Size][3] =
{
   { 0, 1, 1 },
   { 0.015873016, 0.98412698, 1 },
   { 0.031746032, 0.96825397, 1 },
   { 0.047619048, 0.95238095, 1 },
   { 0.063492063, 0.93650794, 1 },
   { 0.079365079, 0.92063492, 1 },
   { 0.095238095, 0.9047619, 1 },
   { 0.11111111, 0.88888889, 1 },
   { 0.12698413, 0.87301587, 1 },
   { 0.14285714, 0.85714286, 1 },
   { 0.15873016, 0.84126984, 1 },
   { 0.17460317, 0.82539683, 1 },
   { 0.19047619, 0.80952381, 1 },
   { 0.20634921, 0.79365079, 1 },
   { 0.22222222, 0.77777778, 1 },
   { 0.23809524, 0.76190476, 1 },
   { 0.25396825, 0.74603175, 1 },
   { 0.26984127, 0.73015873, 1 },
   { 0.28571429, 0.71428571, 1 },
   { 0.3015873, 0.6984127, 1 },
   { 0.31746032, 0.68253968, 1 },
   { 0.33333333, 0.66666667, 1 },
   { 0.34920635, 0.65079365, 1 },
   { 0.36507937, 0.63492063, 1 },
   { 0.38095238, 0.61904762, 1 },
   { 0.3968254, 0.6031746, 1 },
   { 0.41269841, 0.58730159, 1 },
   { 0.42857143, 0.57142857, 1 },
   { 0.44444444, 0.55555556, 1 },
   { 0.46031746, 0.53968254, 1 },
   { 0.47619048, 0.52380952, 1 },
   { 0.49206349, 0.50793651, 1 },
   { 0.50793651, 0.49206349, 1 },
   { 0.52380952, 0.47619048, 1 },
   { 0.53968254, 0.46031746, 1 },
   { 0.55555556, 0.44444444, 1 },
   { 0.57142857, 0.42857143, 1 },
   { 0.58730159, 0.41269841, 1 },
   { 0.6031746, 0.3968254, 1 },
   { 0.61904762, 0.38095238, 1 },
   { 0.63492063, 0.36507937, 1 },
   { 0.65079365, 0.34920635, 1 },
   { 0.66666667, 0.33333333, 1 },
   { 0.68253968, 0.31746032, 1 },
   { 0.6984127, 0.3015873, 1 },
   { 0.71428571, 0.28571429, 1 },
   { 0.73015873, 0.26984127, 1 },
   { 0.74603175, 0.25396825, 1 },
   { 0.76190476, 0.23809524, 1 },
   { 0.77777778, 0.22222222, 1 },
   { 0.79365079, 0.20634921, 1 },
   { 0.80952381, 0.19047619, 1 },
   { 0.82539683, 0.17460317, 1 },
   { 0.84126984, 0.15873016, 1 },
   { 0.85714286, 0.14285714, 1 },
   { 0.87301587, 0.12698413, 1 },
   { 0.88888889, 0.11111111, 1 },
   { 0.9047619, 0.095238095, 1 },
   { 0.92063492, 0.079365079, 1 },
   { 0.93650794, 0.063492063, 1 },
   { 0.95238095, 0.047619048, 1 },
   { 0.96825397, 0.031746032, 1 },
   { 0.98412698, 0.015873016, 1 },
   { 1, 0, 1 }
};

const int RGB_Palette_9_Size = 64; // summer
double RGB_Palette_9[RGB_Palette_9_Size][3] =
{
   { 0, 0.5, 0.4 },
   { 0.015873016, 0.50793651, 0.4 },
   { 0.031746032, 0.51587302, 0.4 },
   { 0.047619048, 0.52380952, 0.4 },
   { 0.063492063, 0.53174603, 0.4 },
   { 0.079365079, 0.53968254, 0.4 },
   { 0.095238095, 0.54761905, 0.4 },
   { 0.11111111, 0.55555556, 0.4 },
   { 0.12698413, 0.56349206, 0.4 },
   { 0.14285714, 0.57142857, 0.4 },
   { 0.15873016, 0.57936508, 0.4 },
   { 0.17460317, 0.58730159, 0.4 },
   { 0.19047619, 0.5952381, 0.4 },
   { 0.20634921, 0.6031746, 0.4 },
   { 0.22222222, 0.61111111, 0.4 },
   { 0.23809524, 0.61904762, 0.4 },
   { 0.25396825, 0.62698413, 0.4 },
   { 0.26984127, 0.63492063, 0.4 },
   { 0.28571429, 0.64285714, 0.4 },
   { 0.3015873, 0.65079365, 0.4 },
   { 0.31746032, 0.65873016, 0.4 },
   { 0.33333333, 0.66666667, 0.4 },
   { 0.34920635, 0.67460317, 0.4 },
   { 0.36507937, 0.68253968, 0.4 },
   { 0.38095238, 0.69047619, 0.4 },
   { 0.3968254, 0.6984127, 0.4 },
   { 0.41269841, 0.70634921, 0.4 },
   { 0.42857143, 0.71428571, 0.4 },
   { 0.44444444, 0.72222222, 0.4 },
   { 0.46031746, 0.73015873, 0.4 },
   { 0.47619048, 0.73809524, 0.4 },
   { 0.49206349, 0.74603175, 0.4 },
   { 0.50793651, 0.75396825, 0.4 },
   { 0.52380952, 0.76190476, 0.4 },
   { 0.53968254, 0.76984127, 0.4 },
   { 0.55555556, 0.77777778, 0.4 },
   { 0.57142857, 0.78571429, 0.4 },
   { 0.58730159, 0.79365079, 0.4 },
   { 0.6031746, 0.8015873, 0.4 },
   { 0.61904762, 0.80952381, 0.4 },
   { 0.63492063, 0.81746032, 0.4 },
   { 0.65079365, 0.82539683, 0.4 },
   { 0.66666667, 0.83333333, 0.4 },
   { 0.68253968, 0.84126984, 0.4 },
   { 0.6984127, 0.84920635, 0.4 },
   { 0.71428571, 0.85714286, 0.4 },
   { 0.73015873, 0.86507937, 0.4 },
   { 0.74603175, 0.87301587, 0.4 },
   { 0.76190476, 0.88095238, 0.4 },
   { 0.77777778, 0.88888889, 0.4 },
   { 0.79365079, 0.8968254, 0.4 },
   { 0.80952381, 0.9047619, 0.4 },
   { 0.82539683, 0.91269841, 0.4 },
   { 0.84126984, 0.92063492, 0.4 },
   { 0.85714286, 0.92857143, 0.4 },
   { 0.87301587, 0.93650794, 0.4 },
   { 0.88888889, 0.94444444, 0.4 },
   { 0.9047619, 0.95238095, 0.4 },
   { 0.92063492, 0.96031746, 0.4 },
   { 0.93650794, 0.96825397, 0.4 },
   { 0.95238095, 0.97619048, 0.4 },
   { 0.96825397, 0.98412698, 0.4 },
   { 0.98412698, 0.99206349, 0.4 },
   { 1, 1, 0.4 }
};

const int RGB_Palette_10_Size = 64; // hsv
double RGB_Palette_10[RGB_Palette_10_Size][3] =
{
   { 1, 0, 0 },
   { 1, 0.09375, 0 },
   { 1, 0.1875, 0 },
   { 1, 0.28125, 0 },
   { 1, 0.375, 0 },
   { 1, 0.46875, 0 },
   { 1, 0.5625, 0 },
   { 1, 0.65625, 0 },
   { 1, 0.75, 0 },
   { 1, 0.84375, 0 },
   { 1, 0.9375, 0 },
   { 0.96875, 1, 0 },
   { 0.875, 1, 0 },
   { 0.78125, 1, 0 },
   { 0.6875, 1, 0 },
   { 0.59375, 1, 0 },
   { 0.5, 1, 0 },
   { 0.40625, 1, 0 },
   { 0.3125, 1, 0 },
   { 0.21875, 1, 0 },
   { 0.125, 1, 0 },
   { 0.03125, 1, 0 },
   { 0, 1, 0.0625 },
   { 0, 1, 0.15625 },
   { 0, 1, 0.25 },
   { 0, 1, 0.34375 },
   { 0, 1, 0.4375 },
   { 0, 1, 0.53125 },
   { 0, 1, 0.625 },
   { 0, 1, 0.71875 },
   { 0, 1, 0.8125 },
   { 0, 1, 0.90625 },
   { 0, 1, 1 },
   { 0, 0.90625, 1 },
   { 0, 0.8125, 1 },
   { 0, 0.71875, 1 },
   { 0, 0.625, 1 },
   { 0, 0.53125, 1 },
   { 0, 0.4375, 1 },
   { 0, 0.34375, 1 },
   { 0, 0.25, 1 },
   { 0, 0.15625, 1 },
   { 0, 0.0625, 1 },
   { 0.03125, 0, 1 },
   { 0.125, 0, 1 },
   { 0.21875, 0, 1 },
   { 0.3125, 0, 1 },
   { 0.40625, 0, 1 },
   { 0.5, 0, 1 },
   { 0.59375, 0, 1 },
   { 0.6875, 0, 1 },
   { 0.78125, 0, 1 },
   { 0.875, 0, 1 },
   { 0.96875, 0, 1 },
   { 1, 0, 0.9375 },
   { 1, 0, 0.84375 },
   { 1, 0, 0.75 },
   { 1, 0, 0.65625 },
   { 1, 0, 0.5625 },
   { 1, 0, 0.46875 },
   { 1, 0, 0.375 },
   { 1, 0, 0.28125 },
   { 1, 0, 0.1875 },
   { 1, 0, 0.09375 }
};

const int RGB_Palette_11_Size = 64; // copper
double RGB_Palette_11[RGB_Palette_11_Size][3] =
{
   { 0, 0, 0 },
   { 0.01984127, 0.0124, 0.0078968254 },
   { 0.03968254, 0.0248, 0.015793651 },
   { 0.05952381, 0.0372, 0.023690476 },
   { 0.079365079, 0.0496, 0.031587302 },
   { 0.099206349, 0.062, 0.039484127 },
   { 0.11904762, 0.0744, 0.047380952 },
   { 0.13888889, 0.0868, 0.055277778 },
   { 0.15873016, 0.0992, 0.063174603 },
   { 0.17857143, 0.1116, 0.071071429 },
   { 0.1984127, 0.124, 0.078968254 },
   { 0.21825397, 0.1364, 0.086865079 },
   { 0.23809524, 0.1488, 0.094761905 },
   { 0.25793651, 0.1612, 0.10265873 },
   { 0.27777778, 0.1736, 0.11055556 },
   { 0.29761905, 0.186, 0.11845238 },
   { 0.31746032, 0.1984, 0.12634921 },
   { 0.33730159, 0.2108, 0.13424603 },
   { 0.35714286, 0.2232, 0.14214286 },
   { 0.37698413, 0.2356, 0.15003968 },
   { 0.3968254, 0.248, 0.15793651 },
   { 0.41666667, 0.2604, 0.16583333 },
   { 0.43650794, 0.2728, 0.17373016 },
   { 0.45634921, 0.2852, 0.18162698 },
   { 0.47619048, 0.2976, 0.18952381 },
   { 0.49603175, 0.31, 0.19742063 },
   { 0.51587302, 0.3224, 0.20531746 },
   { 0.53571429, 0.3348, 0.21321429 },
   { 0.55555556, 0.3472, 0.22111111 },
   { 0.57539683, 0.3596, 0.22900794 },
   { 0.5952381, 0.372, 0.23690476 },
   { 0.61507937, 0.3844, 0.24480159 },
   { 0.63492063, 0.3968, 0.25269841 },
   { 0.6547619, 0.4092, 0.26059524 },
   { 0.67460317, 0.4216, 0.26849206 },
   { 0.69444444, 0.434, 0.27638889 },
   { 0.71428571, 0.4464, 0.28428571 },
   { 0.73412698, 0.4588, 0.29218254 },
   { 0.75396825, 0.4712, 0.30007937 },
   { 0.77380952, 0.4836, 0.30797619 },
   { 0.79365079, 0.496, 0.31587302 },
   { 0.81349206, 0.5084, 0.32376984 },
   { 0.83333333, 0.5208, 0.33166667 },
   { 0.8531746, 0.5332, 0.33956349 },
   { 0.87301587, 0.5456, 0.34746032 },
   { 0.89285714, 0.558, 0.35535714 },
   { 0.91269841, 0.5704, 0.36325397 },
   { 0.93253968, 0.5828, 0.37115079 },
   { 0.95238095, 0.5952, 0.37904762 },
   { 0.97222222, 0.6076, 0.38694444 },
   { 0.99206349, 0.62, 0.39484127 },
   { 1, 0.6324, 0.4027381 },
   { 1, 0.6448, 0.41063492 },
   { 1, 0.6572, 0.41853175 },
   { 1, 0.6696, 0.42642857 },
   { 1, 0.682, 0.4343254 },
   { 1, 0.6944, 0.44222222 },
   { 1, 0.7068, 0.45011905 },
   { 1, 0.7192, 0.45801587 },
   { 1, 0.7316, 0.4659127 },
   { 1, 0.744, 0.47380952 },
   { 1, 0.7564, 0.48170635 },
   { 1, 0.7688, 0.48960317 },
   { 1, 0.7812, 0.4975 }
};

const int RGB_Palette_12_Size = 2;
double RGB_Palette_12[RGB_Palette_12_Size][3] =
{
   { 1.0, 1.0, 1.0 },
   { 1.0, 1.0, 1.0 }
};

/*
  const int RGB_Palette_13_Size = 6;
  double RGB_Palette_13[RGB_Palette_13_Size][3] =
  {
  { 0, 0, 1 },
  { 0, 1, 1 },
  { 0, 1, 0 },
  { 1, 1, 0 },
  { 1, 0, 0 },
  { 1, 0, 1 }
  };

  const int RGB_Palette_14_Size = 4;
  double RGB_Palette_14[RGB_Palette_14_Size][3] =
  {
  { 0, 0, 1 },
  { 0, 1, 0 },
  { 1, 1, 0 },
  { 1, 0, 0 }
  };

  const int RGB_Palette_15_Size = 7;
  double RGB_Palette_15[RGB_Palette_15_Size][3] =
  {
  { 0,   0, 1 },
  { 0,   1, 1 },
  { 0,   1, 0 },
  { 1,   1, 0 },
  { 1, 0.5, 0 },
  { 1,   0, 0 },
  { 1,   0, 1 }
  };

  const int RGB_Palette_16_Size = 8;
  double RGB_Palette_16[RGB_Palette_16_Size][3] =
  {
  { 0,   0, 1 },
  { 0,   1, 1 },
  { 0,   1, 0 },
  { 1,   1, 0 },
  { 1, 0.5, 0 },
  { 1,   0, 0 },
  { 1,   0, 1 },
  { 0.5, 0, 1 }
  };
*/

const int RGB_Palette_13_Size = (4*16+1); // vivid
double RGB_Palette_13[RGB_Palette_13_Size][3];

const int RGB_Palette_14_Size = 256; // gimp - BrushedAluminum
double RGB_Palette_14[RGB_Palette_14_Size][3] =
{
   { 0.42968750, 0.44531250, 0.41015625 },
   { 0.43750000, 0.44531250, 0.41406250 },
   { 0.44140625, 0.44921875, 0.41796875 },
   { 0.44531250, 0.45312500, 0.42187500 },
   { 0.44921875, 0.45703125, 0.42578125 },
   { 0.45312500, 0.46093750, 0.42968750 },
   { 0.45703125, 0.46484375, 0.43359375 },
   { 0.46093750, 0.46875000, 0.43750000 },
   { 0.46484375, 0.47265625, 0.44140625 },
   { 0.47656250, 0.48437500, 0.45312500 },
   { 0.48828125, 0.49609375, 0.46484375 },
   { 0.49609375, 0.50390625, 0.47265625 },
   { 0.49609375, 0.50781250, 0.47656250 },
   { 0.50000000, 0.51171875, 0.48046875 },
   { 0.50390625, 0.51171875, 0.48437500 },
   { 0.50390625, 0.51562500, 0.48437500 },
   { 0.50781250, 0.51562500, 0.48828125 },
   { 0.51171875, 0.51953125, 0.49218750 },
   { 0.51953125, 0.53125000, 0.50000000 },
   { 0.54687500, 0.55468750, 0.52734375 },
   { 0.54687500, 0.55859375, 0.53125000 },
   { 0.55078125, 0.55859375, 0.53125000 },
   { 0.55078125, 0.55859375, 0.53125000 },
   { 0.55078125, 0.55859375, 0.53515625 },
   { 0.55078125, 0.56250000, 0.53515625 },
   { 0.55468750, 0.56250000, 0.53515625 },
   { 0.55468750, 0.56250000, 0.53515625 },
   { 0.55468750, 0.56250000, 0.53515625 },
   { 0.55468750, 0.56250000, 0.53515625 },
   { 0.55468750, 0.56250000, 0.53906250 },
   { 0.55468750, 0.56250000, 0.53906250 },
   { 0.55468750, 0.56640625, 0.53906250 },
   { 0.55859375, 0.57031250, 0.54296875 },
   { 0.58203125, 0.58984375, 0.56640625 },
   { 0.59375000, 0.60156250, 0.57421875 },
   { 0.59765625, 0.60546875, 0.58203125 },
   { 0.60156250, 0.60937500, 0.58593750 },
   { 0.60546875, 0.61328125, 0.58984375 },
   { 0.61328125, 0.62109375, 0.59765625 },
   { 0.61718750, 0.62500000, 0.60156250 },
   { 0.62109375, 0.62890625, 0.60546875 },
   { 0.62500000, 0.63281250, 0.60937500 },
   { 0.62890625, 0.63671875, 0.61328125 },
   { 0.63281250, 0.64062500, 0.61718750 },
   { 0.63671875, 0.64453125, 0.62109375 },
   { 0.64062500, 0.64843750, 0.62890625 },
   { 0.64453125, 0.65234375, 0.63281250 },
   { 0.64843750, 0.65625000, 0.63671875 },
   { 0.65234375, 0.66015625, 0.64062500 },
   { 0.66015625, 0.66796875, 0.64843750 },
   { 0.66796875, 0.67578125, 0.65625000 },
   { 0.67578125, 0.68359375, 0.66406250 },
   { 0.68359375, 0.68750000, 0.67187500 },
   { 0.68359375, 0.69140625, 0.67187500 },
   { 0.68359375, 0.69140625, 0.67187500 },
   { 0.68750000, 0.69140625, 0.67578125 },
   { 0.68750000, 0.69531250, 0.67578125 },
   { 0.69140625, 0.69531250, 0.67968750 },
   { 0.69140625, 0.69921875, 0.67968750 },
   { 0.69531250, 0.69921875, 0.68359375 },
   { 0.69531250, 0.69921875, 0.68359375 },
   { 0.69531250, 0.70312500, 0.68750000 },
   { 0.69921875, 0.70312500, 0.68750000 },
   { 0.69921875, 0.70703125, 0.68750000 },
   { 0.70312500, 0.70703125, 0.69140625 },
   { 0.70312500, 0.70703125, 0.69140625 },
   { 0.70312500, 0.71093750, 0.69531250 },
   { 0.70703125, 0.71093750, 0.69531250 },
   { 0.70703125, 0.71484375, 0.69921875 },
   { 0.71093750, 0.71484375, 0.69921875 },
   { 0.71093750, 0.71484375, 0.69921875 },
   { 0.71093750, 0.71875000, 0.70312500 },
   { 0.73046875, 0.73437500, 0.71875000 },
   { 0.74609375, 0.75000000, 0.73437500 },
   { 0.74609375, 0.75000000, 0.73437500 },
   { 0.74609375, 0.75000000, 0.73437500 },
   { 0.74609375, 0.75000000, 0.73828125 },
   { 0.74609375, 0.75000000, 0.73828125 },
   { 0.74609375, 0.75000000, 0.73828125 },
   { 0.75000000, 0.75390625, 0.73828125 },
   { 0.75000000, 0.75390625, 0.74218750 },
   { 0.75000000, 0.75390625, 0.74218750 },
   { 0.75390625, 0.75781250, 0.74609375 },
   { 0.76171875, 0.76562500, 0.75390625 },
   { 0.77343750, 0.77734375, 0.76562500 },
   { 0.79296875, 0.79687500, 0.78906250 },
   { 0.80078125, 0.80078125, 0.79687500 },
   { 0.80468750, 0.80468750, 0.80078125 },
   { 0.80859375, 0.81250000, 0.80859375 },
   { 0.81640625, 0.81640625, 0.81250000 },
   { 0.82031250, 0.82421875, 0.81640625 },
   { 0.82812500, 0.82812500, 0.82421875 },
   { 0.83203125, 0.83203125, 0.82812500 },
   { 0.83593750, 0.83984375, 0.83203125 },
   { 0.83593750, 0.83593750, 0.82812500 },
   { 0.83203125, 0.83593750, 0.82421875 },
   { 0.82812500, 0.83203125, 0.81640625 },
   { 0.82812500, 0.82812500, 0.81250000 },
   { 0.82421875, 0.82421875, 0.80859375 },
   { 0.82031250, 0.82031250, 0.80078125 },
   { 0.81640625, 0.81640625, 0.79687500 },
   { 0.80859375, 0.80859375, 0.77734375 },
   { 0.80078125, 0.79687500, 0.76171875 },
   { 0.82421875, 0.82031250, 0.79296875 },
   { 0.83593750, 0.83203125, 0.80468750 },
   { 0.84375000, 0.84375000, 0.81640625 },
   { 0.85156250, 0.85156250, 0.82812500 },
   { 0.85937500, 0.85546875, 0.83593750 },
   { 0.86328125, 0.86328125, 0.84375000 },
   { 0.87109375, 0.86718750, 0.85156250 },
   { 0.87500000, 0.87109375, 0.85546875 },
   { 0.87890625, 0.87500000, 0.86328125 },
   { 0.88281250, 0.88281250, 0.86718750 },
   { 0.88671875, 0.88281250, 0.87109375 },
   { 0.89062500, 0.88671875, 0.87500000 },
   { 0.89453125, 0.89062500, 0.87890625 },
   { 0.89453125, 0.89453125, 0.88281250 },
   { 0.89843750, 0.89843750, 0.88671875 },
   { 0.90234375, 0.89843750, 0.89062500 },
   { 0.90234375, 0.90234375, 0.89453125 },
   { 0.90625000, 0.90625000, 0.89843750 },
   { 0.90625000, 0.90625000, 0.90234375 },
   { 0.91015625, 0.91015625, 0.90234375 },
   { 0.91015625, 0.91015625, 0.90625000 },
   { 0.91406250, 0.91406250, 0.91015625 },
   { 0.91796875, 0.91796875, 0.91406250 },
   { 0.92187500, 0.92187500, 0.91796875 },
   { 0.92578125, 0.92578125, 0.92187500 },
   { 0.92968750, 0.92578125, 0.92578125 },
   { 0.92968750, 0.92968750, 0.92968750 },
   { 0.92968750, 0.92968750, 0.92968750 },
   { 0.93359375, 0.92968750, 0.92968750 },
   { 0.93359375, 0.93359375, 0.93359375 },
   { 0.92968750, 0.92968750, 0.92968750 },
   { 0.92578125, 0.92578125, 0.92578125 },
   { 0.91406250, 0.91406250, 0.91406250 },
   { 0.90625000, 0.90625000, 0.90625000 },
   { 0.89453125, 0.89453125, 0.89453125 },
   { 0.87890625, 0.87890625, 0.87890625 },
   { 0.85937500, 0.85937500, 0.85937500 },
   { 0.83203125, 0.83203125, 0.83203125 },
   { 0.67968750, 0.67968750, 0.68359375 },
   { 0.73046875, 0.73046875, 0.73828125 },
   { 0.75390625, 0.75390625, 0.76562500 },
   { 0.76953125, 0.76953125, 0.78515625 },
   { 0.77734375, 0.77734375, 0.79296875 },
   { 0.78515625, 0.78515625, 0.79687500 },
   { 0.79687500, 0.79296875, 0.80078125 },
   { 0.80468750, 0.79687500, 0.80078125 },
   { 0.81250000, 0.80468750, 0.80468750 },
   { 0.81640625, 0.80468750, 0.80468750 },
   { 0.80859375, 0.80078125, 0.80078125 },
   { 0.80468750, 0.79296875, 0.79296875 },
   { 0.79687500, 0.78906250, 0.78906250 },
   { 0.79296875, 0.78515625, 0.78515625 },
   { 0.78515625, 0.77734375, 0.78125000 },
   { 0.78125000, 0.77343750, 0.77343750 },
   { 0.77343750, 0.76953125, 0.76953125 },
   { 0.76171875, 0.75781250, 0.76171875 },
   { 0.73828125, 0.73828125, 0.73828125 },
   { 0.72265625, 0.72656250, 0.72656250 },
   { 0.72265625, 0.73046875, 0.72656250 },
   { 0.72656250, 0.73437500, 0.72265625 },
   { 0.72656250, 0.73828125, 0.72265625 },
   { 0.72656250, 0.74218750, 0.72265625 },
   { 0.73046875, 0.74218750, 0.71875000 },
   { 0.73046875, 0.74609375, 0.71875000 },
   { 0.73046875, 0.75000000, 0.71875000 },
   { 0.73046875, 0.75390625, 0.71875000 },
   { 0.73046875, 0.75390625, 0.71875000 },
   { 0.71875000, 0.73828125, 0.70312500 },
   { 0.69921875, 0.71484375, 0.68359375 },
   { 0.67968750, 0.69531250, 0.66796875 },
   { 0.65234375, 0.66406250, 0.64062500 },
   { 0.62109375, 0.62890625, 0.61328125 },
   { 0.61718750, 0.62500000, 0.60937500 },
   { 0.61718750, 0.62109375, 0.60937500 },
   { 0.61328125, 0.62109375, 0.60546875 },
   { 0.60937500, 0.61718750, 0.60156250 },
   { 0.60546875, 0.61328125, 0.59765625 },
   { 0.60156250, 0.60546875, 0.59375000 },
   { 0.59375000, 0.59765625, 0.58984375 },
   { 0.58203125, 0.58984375, 0.57812500 },
   { 0.57031250, 0.57421875, 0.56640625 },
   { 0.54687500, 0.54687500, 0.54296875 },
   { 0.52343750, 0.52343750, 0.52343750 },
   { 0.52343750, 0.52343750, 0.52343750 },
   { 0.52343750, 0.52343750, 0.52343750 },
   { 0.52343750, 0.52343750, 0.52343750 },
   { 0.52343750, 0.52343750, 0.51953125 },
   { 0.52343750, 0.51953125, 0.51953125 },
   { 0.51953125, 0.51953125, 0.51562500 },
   { 0.51562500, 0.51171875, 0.50390625 },
   { 0.50781250, 0.50390625, 0.49218750 },
   { 0.46484375, 0.45703125, 0.44921875 },
   { 0.50781250, 0.49218750, 0.49218750 },
   { 0.54296875, 0.51953125, 0.52734375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.51171875, 0.49609375 },
   { 0.50781250, 0.50781250, 0.49609375 },
   { 0.50781250, 0.50781250, 0.49609375 },
   { 0.50390625, 0.50781250, 0.49218750 },
   { 0.50390625, 0.50390625, 0.49218750 },
   { 0.50000000, 0.50390625, 0.49218750 },
   { 0.50000000, 0.50000000, 0.48828125 },
   { 0.49609375, 0.49609375, 0.48828125 },
   { 0.49218750, 0.48828125, 0.48437500 },
   { 0.48437500, 0.48046875, 0.47656250 },
   { 0.47656250, 0.46875000, 0.46875000 },
   { 0.47656250, 0.46484375, 0.46875000 },
   { 0.47265625, 0.46484375, 0.46484375 },
   { 0.47265625, 0.46484375, 0.46484375 },
   { 0.47265625, 0.46484375, 0.46484375 },
   { 0.47265625, 0.46484375, 0.46484375 },
   { 0.47265625, 0.46093750, 0.46484375 },
   { 0.47265625, 0.46093750, 0.46484375 },
   { 0.47265625, 0.46093750, 0.46484375 },
   { 0.47265625, 0.46093750, 0.46484375 },
   { 0.47265625, 0.45703125, 0.46484375 },
   { 0.46875000, 0.45703125, 0.46093750 },
   { 0.46875000, 0.45703125, 0.46093750 },
   { 0.46875000, 0.45703125, 0.46093750 },
   { 0.46875000, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.45703125 },
   { 0.46484375, 0.45312500, 0.45703125 },
   { 0.46484375, 0.45312500, 0.45703125 },
   { 0.46484375, 0.45312500, 0.45703125 },
   { 0.46484375, 0.45312500, 0.45703125 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46484375, 0.45312500, 0.46093750 },
   { 0.46875000, 0.45312500, 0.46093750 },
   { 0.47265625, 0.45703125, 0.46484375 },
   { 0.46875000, 0.45312500, 0.46093750 },
   { 0.47656250, 0.45703125, 0.46875000 },
   { 0.48437500, 0.46484375, 0.47656250 },
   { 0.48828125, 0.47265625, 0.48437500 },
   { 0.49609375, 0.48046875, 0.49218750 },
   { 0.50390625, 0.48828125, 0.50000000 },
   { 0.51171875, 0.49218750, 0.50390625 },
   { 0.51562500, 0.49609375, 0.51171875 },
   { 0.51953125, 0.50390625, 0.51562500 },
   { 0.52734375, 0.50781250, 0.52343750 },
   { 0.53125000, 0.51171875, 0.52734375 },
   { 0.53515625, 0.51953125, 0.53125000 },
   { 0.54296875, 0.52343750, 0.53906250 },
   { 0.54687500, 0.52734375, 0.54296875 },
   { 0.55468750, 0.53515625, 0.54687500 },
};

const int RGB_Palette_15_Size = 256; // gimp - Sunrise
double RGB_Palette_15[RGB_Palette_15_Size][3] =
{
   { 0.85937500, 0.85937500, 0.85937500 },
   { 0.85937500, 0.85937500, 0.85546875 },
   { 0.86328125, 0.86328125, 0.85546875 },
   { 0.86328125, 0.86328125, 0.85546875 },
   { 0.86328125, 0.86718750, 0.85546875 },
   { 0.86718750, 0.86718750, 0.85156250 },
   { 0.86718750, 0.87109375, 0.85156250 },
   { 0.87109375, 0.87109375, 0.85156250 },
   { 0.87109375, 0.87500000, 0.85156250 },
   { 0.87109375, 0.87500000, 0.84765625 },
   { 0.87500000, 0.87890625, 0.84765625 },
   { 0.87500000, 0.87890625, 0.84765625 },
   { 0.87890625, 0.88281250, 0.84765625 },
   { 0.87890625, 0.88281250, 0.84375000 },
   { 0.88281250, 0.88671875, 0.84375000 },
   { 0.88281250, 0.89062500, 0.84375000 },
   { 0.88281250, 0.89062500, 0.84375000 },
   { 0.88671875, 0.89453125, 0.83984375 },
   { 0.88671875, 0.89453125, 0.83984375 },
   { 0.89062500, 0.89843750, 0.83984375 },
   { 0.89062500, 0.89843750, 0.83984375 },
   { 0.89062500, 0.90234375, 0.83593750 },
   { 0.89453125, 0.90234375, 0.83593750 },
   { 0.89453125, 0.90625000, 0.83593750 },
   { 0.89843750, 0.90625000, 0.83593750 },
   { 0.89843750, 0.91015625, 0.83203125 },
   { 0.90234375, 0.91015625, 0.83203125 },
   { 0.90234375, 0.91406250, 0.83203125 },
   { 0.90625000, 0.91796875, 0.82812500 },
   { 0.91015625, 0.92187500, 0.82812500 },
   { 0.91406250, 0.92578125, 0.82421875 },
   { 0.91796875, 0.92968750, 0.82421875 },
   { 0.91796875, 0.93750000, 0.82031250 },
   { 0.92187500, 0.94140625, 0.82031250 },
   { 0.92578125, 0.94531250, 0.81640625 },
   { 0.92968750, 0.94921875, 0.81640625 },
   { 0.93359375, 0.95312500, 0.81250000 },
   { 0.93750000, 0.95703125, 0.81250000 },
   { 0.93750000, 0.96093750, 0.80859375 },
   { 0.94140625, 0.96484375, 0.80859375 },
   { 0.94531250, 0.95312500, 0.78906250 },
   { 0.94531250, 0.93750000, 0.77343750 },
   { 0.94531250, 0.92578125, 0.75781250 },
   { 0.94921875, 0.91406250, 0.74218750 },
   { 0.94921875, 0.89843750, 0.72265625 },
   { 0.95312500, 0.88671875, 0.70703125 },
   { 0.95312500, 0.87500000, 0.69140625 },
   { 0.95703125, 0.86328125, 0.67187500 },
   { 0.95703125, 0.84765625, 0.65625000 },
   { 0.95703125, 0.83593750, 0.64062500 },
   { 0.96093750, 0.82421875, 0.62500000 },
   { 0.96093750, 0.80859375, 0.60546875 },
   { 0.96484375, 0.79687500, 0.58984375 },
   { 0.96484375, 0.78515625, 0.57421875 },
   { 0.96484375, 0.76953125, 0.55859375 },
   { 0.96875000, 0.75781250, 0.53906250 },
   { 0.96875000, 0.74218750, 0.51953125 },
   { 0.97265625, 0.72265625, 0.49609375 },
   { 0.97265625, 0.70703125, 0.47265625 },
   { 0.97656250, 0.68750000, 0.44921875 },
   { 0.98046875, 0.67187500, 0.42578125 },
   { 0.98046875, 0.65234375, 0.40625000 },
   { 0.98437500, 0.63671875, 0.38281250 },
   { 0.98437500, 0.62109375, 0.35937500 },
   { 0.98828125, 0.60156250, 0.33593750 },
   { 0.98828125, 0.58593750, 0.31250000 },
   { 0.99218750, 0.56640625, 0.28906250 },
   { 0.99218750, 0.55078125, 0.26953125 },
   { 0.98828125, 0.53906250, 0.26562500 },
   { 0.98046875, 0.53125000, 0.26171875 },
   { 0.97265625, 0.52343750, 0.26171875 },
   { 0.96484375, 0.51562500, 0.25781250 },
   { 0.95703125, 0.50781250, 0.25781250 },
   { 0.94921875, 0.49609375, 0.25390625 },
   { 0.94140625, 0.48828125, 0.25390625 },
   { 0.93359375, 0.48046875, 0.25390625 },
   { 0.92578125, 0.47265625, 0.25000000 },
   { 0.91406250, 0.46484375, 0.25000000 },
   { 0.90625000, 0.45312500, 0.24609375 },
   { 0.89843750, 0.44531250, 0.24609375 },
   { 0.89062500, 0.43750000, 0.24218750 },
   { 0.88281250, 0.42968750, 0.24218750 },
   { 0.87500000, 0.42187500, 0.23828125 },
   { 0.86718750, 0.41015625, 0.23828125 },
   { 0.85937500, 0.40234375, 0.23437500 },
   { 0.85156250, 0.39453125, 0.23437500 },
   { 0.84375000, 0.38671875, 0.23046875 },
   { 0.83593750, 0.37890625, 0.23046875 },
   { 0.82812500, 0.36718750, 0.22656250 },
   { 0.82031250, 0.35937500, 0.22656250 },
   { 0.81250000, 0.35156250, 0.22265625 },
   { 0.80468750, 0.34375000, 0.22265625 },
   { 0.79687500, 0.33593750, 0.21875000 },
   { 0.78906250, 0.32812500, 0.21875000 },
   { 0.77734375, 0.31250000, 0.21484375 },
   { 0.75781250, 0.29296875, 0.21093750 },
   { 0.74218750, 0.27343750, 0.20703125 },
   { 0.72265625, 0.25000000, 0.20312500 },
   { 0.70312500, 0.23046875, 0.19921875 },
   { 0.68359375, 0.21093750, 0.19140625 },
   { 0.66406250, 0.19140625, 0.18750000 },
   { 0.64843750, 0.16796875, 0.18359375 },
   { 0.62890625, 0.14843750, 0.17968750 },
   { 0.60937500, 0.12890625, 0.17578125 },
   { 0.58984375, 0.10937500, 0.17187500 },
   { 0.57421875, 0.09375000, 0.16406250 },
   { 0.56250000, 0.09765625, 0.16015625 },
   { 0.55078125, 0.09765625, 0.15625000 },
   { 0.53906250, 0.10156250, 0.15234375 },
   { 0.52734375, 0.10546875, 0.14843750 },
   { 0.51562500, 0.10546875, 0.14062500 },
   { 0.50390625, 0.10937500, 0.13671875 },
   { 0.49218750, 0.10937500, 0.13281250 },
   { 0.48046875, 0.11328125, 0.12890625 },
   { 0.46875000, 0.11718750, 0.12500000 },
   { 0.45703125, 0.11718750, 0.11718750 },
   { 0.44531250, 0.12109375, 0.11328125 },
   { 0.43359375, 0.12109375, 0.10937500 },
   { 0.42187500, 0.12500000, 0.10546875 },
   { 0.41015625, 0.12890625, 0.09765625 },
   { 0.39843750, 0.12890625, 0.09375000 },
   { 0.38281250, 0.13281250, 0.08984375 },
   { 0.37109375, 0.13671875, 0.08203125 },
   { 0.35937500, 0.13671875, 0.07812500 },
   { 0.34375000, 0.14062500, 0.07421875 },
   { 0.33203125, 0.14453125, 0.06640625 },
   { 0.32031250, 0.14453125, 0.06250000 },
   { 0.30468750, 0.14843750, 0.05468750 },
   { 0.29296875, 0.15234375, 0.05078125 },
   { 0.28515625, 0.15625000, 0.05078125 },
   { 0.28515625, 0.16015625, 0.06640625 },
   { 0.28515625, 0.16406250, 0.07812500 },
   { 0.28906250, 0.16796875, 0.09375000 },
   { 0.28906250, 0.17578125, 0.10546875 },
   { 0.28906250, 0.17968750, 0.12109375 },
   { 0.28906250, 0.18359375, 0.13281250 },
   { 0.29296875, 0.18750000, 0.14843750 },
   { 0.29296875, 0.19531250, 0.16015625 },
   { 0.29296875, 0.19921875, 0.17578125 },
   { 0.29296875, 0.20312500, 0.18750000 },
   { 0.29296875, 0.20703125, 0.20312500 },
   { 0.29687500, 0.21484375, 0.21484375 },
   { 0.29687500, 0.21875000, 0.23046875 },
   { 0.29687500, 0.22265625, 0.24218750 },
   { 0.29687500, 0.22656250, 0.25781250 },
   { 0.30078125, 0.23437500, 0.26953125 },
   { 0.30078125, 0.23828125, 0.28515625 },
   { 0.30078125, 0.24218750, 0.29687500 },
   { 0.30078125, 0.25000000, 0.31250000 },
   { 0.30078125, 0.25390625, 0.32421875 },
   { 0.30468750, 0.25781250, 0.33984375 },
   { 0.30468750, 0.26171875, 0.35156250 },
   { 0.30468750, 0.26953125, 0.36718750 },
   { 0.30468750, 0.27343750, 0.37890625 },
   { 0.30859375, 0.27734375, 0.39453125 },
   { 0.30859375, 0.28125000, 0.40625000 },
   { 0.30859375, 0.28906250, 0.42187500 },
   { 0.30859375, 0.29687500, 0.44140625 },
   { 0.31250000, 0.30468750, 0.46484375 },
   { 0.31250000, 0.31250000, 0.48437500 },
   { 0.31250000, 0.32031250, 0.50781250 },
   { 0.31640625, 0.32812500, 0.53125000 },
   { 0.31640625, 0.33593750, 0.55078125 },
   { 0.32031250, 0.34375000, 0.57421875 },
   { 0.32031250, 0.35156250, 0.59375000 },
   { 0.32031250, 0.35937500, 0.61718750 },
   { 0.32421875, 0.36718750, 0.63671875 },
   { 0.32421875, 0.37500000, 0.66015625 },
   { 0.32421875, 0.38281250, 0.67968750 },
   { 0.32812500, 0.39062500, 0.70312500 },
   { 0.32812500, 0.39843750, 0.72265625 },
   { 0.32812500, 0.40625000, 0.74609375 },
   { 0.33203125, 0.41406250, 0.76562500 },
   { 0.33203125, 0.42187500, 0.78906250 },
   { 0.33593750, 0.42578125, 0.79687500 },
   { 0.34375000, 0.43359375, 0.80078125 },
   { 0.34765625, 0.44140625, 0.80078125 },
   { 0.35546875, 0.44531250, 0.80468750 },
   { 0.36328125, 0.45312500, 0.80468750 },
   { 0.36718750, 0.46093750, 0.80859375 },
   { 0.37500000, 0.46484375, 0.81250000 },
   { 0.37890625, 0.47265625, 0.81250000 },
   { 0.38671875, 0.48046875, 0.81640625 },
   { 0.39062500, 0.48828125, 0.81640625 },
   { 0.39843750, 0.49218750, 0.82031250 },
   { 0.40234375, 0.50000000, 0.82421875 },
   { 0.41015625, 0.50781250, 0.82421875 },
   { 0.41796875, 0.51171875, 0.82812500 },
   { 0.42187500, 0.51953125, 0.82812500 },
   { 0.42968750, 0.52734375, 0.83203125 },
   { 0.43359375, 0.53125000, 0.83593750 },
   { 0.44140625, 0.53906250, 0.83593750 },
   { 0.44531250, 0.54687500, 0.83984375 },
   { 0.45312500, 0.55078125, 0.83984375 },
   { 0.45703125, 0.55859375, 0.84375000 },
   { 0.46484375, 0.56640625, 0.84765625 },
   { 0.47265625, 0.57421875, 0.84765625 },
   { 0.47656250, 0.57812500, 0.85156250 },
   { 0.48437500, 0.58593750, 0.85156250 },
   { 0.48828125, 0.59375000, 0.85546875 },
   { 0.49609375, 0.59765625, 0.85937500 },
   { 0.50000000, 0.60546875, 0.85937500 },
   { 0.50781250, 0.61328125, 0.86328125 },
   { 0.51562500, 0.61718750, 0.86328125 },
   { 0.51953125, 0.62500000, 0.86718750 },
   { 0.52734375, 0.63281250, 0.87109375 },
   { 0.53125000, 0.63671875, 0.87109375 },
   { 0.53906250, 0.64453125, 0.87500000 },
   { 0.54296875, 0.65234375, 0.87500000 },
   { 0.55078125, 0.66015625, 0.87890625 },
   { 0.55468750, 0.66406250, 0.88281250 },
   { 0.56250000, 0.67187500, 0.88281250 },
   { 0.57031250, 0.67968750, 0.88671875 },
   { 0.57421875, 0.68359375, 0.88671875 },
   { 0.58203125, 0.69140625, 0.89062500 },
   { 0.58593750, 0.69921875, 0.89453125 },
   { 0.59375000, 0.70312500, 0.89453125 },
   { 0.60156250, 0.71093750, 0.89843750 },
   { 0.60546875, 0.71875000, 0.90234375 },
   { 0.61328125, 0.72656250, 0.90234375 },
   { 0.62109375, 0.73437500, 0.90625000 },
   { 0.62500000, 0.73828125, 0.91015625 },
   { 0.63281250, 0.74609375, 0.91015625 },
   { 0.63671875, 0.75390625, 0.91406250 },
   { 0.64453125, 0.76171875, 0.91406250 },
   { 0.65234375, 0.76953125, 0.91796875 },
   { 0.65625000, 0.77734375, 0.92187500 },
   { 0.66406250, 0.78125000, 0.92187500 },
   { 0.67187500, 0.78906250, 0.92578125 },
   { 0.67578125, 0.79687500, 0.92968750 },
   { 0.68359375, 0.80468750, 0.92968750 },
   { 0.69140625, 0.81250000, 0.93359375 },
   { 0.69531250, 0.81640625, 0.93750000 },
   { 0.70312500, 0.82421875, 0.93750000 },
   { 0.71093750, 0.83203125, 0.94140625 },
   { 0.71484375, 0.83984375, 0.94531250 },
   { 0.72265625, 0.84765625, 0.94531250 },
   { 0.73046875, 0.85156250, 0.94921875 },
   { 0.73437500, 0.85937500, 0.95312500 },
   { 0.74218750, 0.86718750, 0.95312500 },
   { 0.75000000, 0.87500000, 0.95703125 },
   { 0.75390625, 0.88281250, 0.95703125 },
   { 0.76171875, 0.88671875, 0.96093750 },
   { 0.76953125, 0.89453125, 0.96484375 },
   { 0.77343750, 0.90234375, 0.96484375 },
   { 0.78125000, 0.91015625, 0.96875000 },
   { 0.78906250, 0.91796875, 0.97265625 },
   { 0.79296875, 0.92187500, 0.97265625 },
   { 0.80078125, 0.92968750, 0.97656250 },
   { 0.80859375, 0.93750000, 0.98046875 },
   { 0.81250000, 0.94531250, 0.98046875 },
   { 0.82031250, 0.95312500, 0.98437500 },
   { 0.82812500, 0.95703125, 0.98828125 },
   { 0.83203125, 0.96484375, 0.98828125 },
   { 0.83984375, 0.97265625, 0.99218750 },
   { 0.84765625, 0.98046875, 0.99218750 },
};
const int RGB_Palette_16_Size = 256; // gimp - Horizon
double RGB_Palette_16[RGB_Palette_16_Size][3] =
{
   { 0.04687500, 0.35546875, 0.56640625 },
   { 0.05468750, 0.36328125, 0.57031250 },
   { 0.06250000, 0.36718750, 0.57421875 },
   { 0.07031250, 0.37109375, 0.57812500 },
   { 0.07812500, 0.37890625, 0.58203125 },
   { 0.08593750, 0.38281250, 0.58593750 },
   { 0.09375000, 0.38671875, 0.58984375 },
   { 0.10156250, 0.39453125, 0.59375000 },
   { 0.10937500, 0.39843750, 0.59765625 },
   { 0.11718750, 0.40234375, 0.59765625 },
   { 0.12500000, 0.41015625, 0.60156250 },
   { 0.13281250, 0.41406250, 0.60546875 },
   { 0.14062500, 0.41796875, 0.60937500 },
   { 0.14843750, 0.42578125, 0.61328125 },
   { 0.15625000, 0.42968750, 0.61718750 },
   { 0.16406250, 0.43359375, 0.62109375 },
   { 0.17187500, 0.44140625, 0.62500000 },
   { 0.17968750, 0.44531250, 0.62500000 },
   { 0.18750000, 0.44921875, 0.62890625 },
   { 0.19531250, 0.45703125, 0.63281250 },
   { 0.20312500, 0.46093750, 0.63671875 },
   { 0.21093750, 0.46484375, 0.64062500 },
   { 0.21875000, 0.47265625, 0.64453125 },
   { 0.22656250, 0.47656250, 0.64843750 },
   { 0.23437500, 0.48046875, 0.65234375 },
   { 0.24218750, 0.48828125, 0.65234375 },
   { 0.25000000, 0.49218750, 0.65625000 },
   { 0.25781250, 0.49609375, 0.66015625 },
   { 0.26562500, 0.50390625, 0.66406250 },
   { 0.27343750, 0.50781250, 0.66796875 },
   { 0.28125000, 0.51171875, 0.67187500 },
   { 0.28906250, 0.51953125, 0.67578125 },
   { 0.29687500, 0.52343750, 0.67968750 },
   { 0.30859375, 0.52734375, 0.67968750 },
   { 0.31640625, 0.53515625, 0.68359375 },
   { 0.32421875, 0.53906250, 0.68750000 },
   { 0.33203125, 0.54296875, 0.69140625 },
   { 0.33984375, 0.55078125, 0.69531250 },
   { 0.34765625, 0.55468750, 0.69921875 },
   { 0.35546875, 0.55859375, 0.70312500 },
   { 0.36328125, 0.56640625, 0.70703125 },
   { 0.37109375, 0.57031250, 0.70703125 },
   { 0.37890625, 0.57421875, 0.71093750 },
   { 0.38671875, 0.58203125, 0.71484375 },
   { 0.39453125, 0.58593750, 0.71875000 },
   { 0.40234375, 0.58984375, 0.72265625 },
   { 0.41015625, 0.59765625, 0.72656250 },
   { 0.41796875, 0.60156250, 0.73046875 },
   { 0.42578125, 0.60546875, 0.73437500 },
   { 0.43359375, 0.61328125, 0.73828125 },
   { 0.44140625, 0.61718750, 0.73828125 },
   { 0.44921875, 0.62109375, 0.74218750 },
   { 0.45703125, 0.62890625, 0.74609375 },
   { 0.46484375, 0.63281250, 0.75000000 },
   { 0.47265625, 0.63671875, 0.75390625 },
   { 0.48046875, 0.64453125, 0.75781250 },
   { 0.48828125, 0.64843750, 0.76171875 },
   { 0.49609375, 0.65234375, 0.76562500 },
   { 0.50390625, 0.66015625, 0.76562500 },
   { 0.51171875, 0.66406250, 0.76953125 },
   { 0.51953125, 0.66796875, 0.77343750 },
   { 0.52734375, 0.67187500, 0.77734375 },
   { 0.53515625, 0.67968750, 0.78125000 },
   { 0.54296875, 0.68359375, 0.78125000 },
   { 0.54687500, 0.68750000, 0.78515625 },
   { 0.55468750, 0.69140625, 0.78906250 },
   { 0.56250000, 0.69531250, 0.79296875 },
   { 0.57031250, 0.69921875, 0.79296875 },
   { 0.57421875, 0.70312500, 0.79687500 },
   { 0.58203125, 0.71093750, 0.80078125 },
   { 0.58984375, 0.71484375, 0.80468750 },
   { 0.59765625, 0.71875000, 0.80468750 },
   { 0.60156250, 0.72265625, 0.80859375 },
   { 0.60937500, 0.72656250, 0.81250000 },
   { 0.61718750, 0.73046875, 0.81640625 },
   { 0.62500000, 0.73437500, 0.81640625 },
   { 0.62890625, 0.74218750, 0.82031250 },
   { 0.63671875, 0.74609375, 0.82421875 },
   { 0.64453125, 0.75000000, 0.82812500 },
   { 0.65234375, 0.75390625, 0.83203125 },
   { 0.65625000, 0.75781250, 0.83203125 },
   { 0.66406250, 0.76171875, 0.83593750 },
   { 0.67187500, 0.76562500, 0.83984375 },
   { 0.67968750, 0.77343750, 0.84375000 },
   { 0.68359375, 0.77734375, 0.84375000 },
   { 0.69140625, 0.78125000, 0.84765625 },
   { 0.69921875, 0.78515625, 0.85156250 },
   { 0.70703125, 0.78906250, 0.85546875 },
   { 0.71093750, 0.79296875, 0.85546875 },
   { 0.71875000, 0.79687500, 0.85937500 },
   { 0.72656250, 0.80468750, 0.86328125 },
   { 0.73437500, 0.80859375, 0.86718750 },
   { 0.73828125, 0.81250000, 0.86718750 },
   { 0.74609375, 0.81640625, 0.87109375 },
   { 0.75390625, 0.82031250, 0.87500000 },
   { 0.76171875, 0.82421875, 0.87890625 },
   { 0.76562500, 0.82812500, 0.87890625 },
   { 0.77343750, 0.83593750, 0.88281250 },
   { 0.78125000, 0.83984375, 0.88671875 },
   { 0.78906250, 0.84375000, 0.89062500 },
   { 0.79296875, 0.84765625, 0.89062500 },
   { 0.80078125, 0.85156250, 0.89453125 },
   { 0.80859375, 0.85546875, 0.89843750 },
   { 0.81640625, 0.85937500, 0.90234375 },
   { 0.82031250, 0.86718750, 0.90234375 },
   { 0.82812500, 0.87109375, 0.90625000 },
   { 0.83593750, 0.87500000, 0.91015625 },
   { 0.83984375, 0.87890625, 0.91406250 },
   { 0.84765625, 0.88281250, 0.91406250 },
   { 0.85546875, 0.88671875, 0.91796875 },
   { 0.86328125, 0.89062500, 0.92187500 },
   { 0.86718750, 0.89843750, 0.92578125 },
   { 0.87500000, 0.90234375, 0.92578125 },
   { 0.88281250, 0.90625000, 0.92968750 },
   { 0.89062500, 0.91015625, 0.93359375 },
   { 0.89453125, 0.91406250, 0.93750000 },
   { 0.90234375, 0.91796875, 0.93750000 },
   { 0.91015625, 0.92187500, 0.94140625 },
   { 0.91796875, 0.92578125, 0.94531250 },
   { 0.92187500, 0.93359375, 0.94921875 },
   { 0.92968750, 0.93750000, 0.94921875 },
   { 0.93750000, 0.94140625, 0.95312500 },
   { 0.94531250, 0.94531250, 0.95703125 },
   { 0.94921875, 0.94921875, 0.96093750 },
   { 0.95703125, 0.95312500, 0.96093750 },
   { 0.96484375, 0.95703125, 0.96484375 },
   { 0.97265625, 0.96484375, 0.96875000 },
   { 0.97656250, 0.96875000, 0.97265625 },
   { 0.98437500, 0.97265625, 0.97265625 },
   { 0.99218750, 0.97656250, 0.97656250 },
   { 0.99218750, 0.98828125, 0.98828125 },
   { 0.98828125, 0.98046875, 0.97656250 },
   { 0.98437500, 0.97265625, 0.96484375 },
   { 0.98437500, 0.96484375, 0.95312500 },
   { 0.98046875, 0.95703125, 0.94531250 },
   { 0.97656250, 0.94921875, 0.93359375 },
   { 0.97265625, 0.94140625, 0.92578125 },
   { 0.97265625, 0.93359375, 0.91406250 },
   { 0.96875000, 0.92578125, 0.90625000 },
   { 0.96484375, 0.91796875, 0.89453125 },
   { 0.96484375, 0.91406250, 0.88671875 },
   { 0.96093750, 0.90625000, 0.87500000 },
   { 0.95703125, 0.89843750, 0.86718750 },
   { 0.95703125, 0.89062500, 0.85937500 },
   { 0.95312500, 0.88671875, 0.84765625 },
   { 0.94921875, 0.87890625, 0.83984375 },
   { 0.94921875, 0.87109375, 0.83203125 },
   { 0.94531250, 0.86328125, 0.82421875 },
   { 0.94140625, 0.85937500, 0.81250000 },
   { 0.94140625, 0.85156250, 0.80468750 },
   { 0.93750000, 0.84375000, 0.79687500 },
   { 0.93750000, 0.83984375, 0.78906250 },
   { 0.93359375, 0.83203125, 0.77734375 },
   { 0.92968750, 0.82421875, 0.76953125 },
   { 0.92578125, 0.81640625, 0.75781250 },
   { 0.92578125, 0.80859375, 0.74609375 },
   { 0.92187500, 0.80078125, 0.73828125 },
   { 0.91796875, 0.79296875, 0.72656250 },
   { 0.91406250, 0.78515625, 0.71484375 },
   { 0.91406250, 0.77734375, 0.70312500 },
   { 0.91015625, 0.76562500, 0.69140625 },
   { 0.90625000, 0.75781250, 0.68359375 },
   { 0.90234375, 0.75000000, 0.67187500 },
   { 0.89843750, 0.74218750, 0.66015625 },
   { 0.89843750, 0.73437500, 0.65234375 },
   { 0.89453125, 0.72656250, 0.64062500 },
   { 0.89062500, 0.71875000, 0.63281250 },
   { 0.89062500, 0.71484375, 0.62109375 },
   { 0.88671875, 0.70703125, 0.61328125 },
   { 0.88281250, 0.69921875, 0.60156250 },
   { 0.87890625, 0.69140625, 0.59375000 },
   { 0.87890625, 0.68359375, 0.58203125 },
   { 0.87500000, 0.67578125, 0.57031250 },
   { 0.87109375, 0.66796875, 0.56250000 },
   { 0.87109375, 0.66015625, 0.55078125 },
   { 0.87109375, 0.66015625, 0.55078125 },
   { 0.86718750, 0.66015625, 0.55078125 },
   { 0.86718750, 0.65625000, 0.54687500 },
   { 0.86718750, 0.65625000, 0.54687500 },
   { 0.86718750, 0.65625000, 0.54296875 },
   { 0.86718750, 0.65234375, 0.54296875 },
   { 0.86718750, 0.65234375, 0.54296875 },
   { 0.86718750, 0.65234375, 0.53906250 },
   { 0.86718750, 0.65234375, 0.53906250 },
   { 0.86718750, 0.64843750, 0.53515625 },
   { 0.86328125, 0.64843750, 0.53515625 },
   { 0.86328125, 0.64843750, 0.53515625 },
   { 0.86328125, 0.64453125, 0.53125000 },
   { 0.86328125, 0.64453125, 0.53125000 },
   { 0.86328125, 0.64453125, 0.53125000 },
   { 0.86328125, 0.64062500, 0.52734375 },
   { 0.86328125, 0.64062500, 0.52734375 },
   { 0.86328125, 0.64062500, 0.52343750 },
   { 0.86328125, 0.64062500, 0.52343750 },
   { 0.85937500, 0.63671875, 0.52343750 },
   { 0.85937500, 0.63671875, 0.51953125 },
   { 0.85937500, 0.63671875, 0.51953125 },
   { 0.85937500, 0.63281250, 0.51562500 },
   { 0.85937500, 0.63281250, 0.51562500 },
   { 0.85937500, 0.63281250, 0.51562500 },
   { 0.85937500, 0.63281250, 0.51171875 },
   { 0.85937500, 0.62890625, 0.51171875 },
   { 0.85937500, 0.62890625, 0.50781250 },
   { 0.85546875, 0.62890625, 0.50781250 },
   { 0.85546875, 0.62500000, 0.50781250 },
   { 0.85546875, 0.62500000, 0.50390625 },
   { 0.85546875, 0.62500000, 0.50390625 },
   { 0.85546875, 0.62109375, 0.50000000 },
   { 0.85546875, 0.62109375, 0.50000000 },
   { 0.85546875, 0.62109375, 0.50000000 },
   { 0.85546875, 0.62109375, 0.49609375 },
   { 0.85546875, 0.61718750, 0.49609375 },
   { 0.85156250, 0.61718750, 0.49609375 },
   { 0.85156250, 0.61718750, 0.49218750 },
   { 0.85156250, 0.61328125, 0.49218750 },
   { 0.85156250, 0.61328125, 0.48828125 },
   { 0.85156250, 0.61328125, 0.48828125 },
   { 0.85156250, 0.61328125, 0.48828125 },
   { 0.85156250, 0.60937500, 0.48437500 },
   { 0.85156250, 0.60937500, 0.48437500 },
   { 0.85156250, 0.60937500, 0.48046875 },
   { 0.84765625, 0.60546875, 0.48046875 },
   { 0.84765625, 0.60546875, 0.47656250 },
   { 0.84765625, 0.60156250, 0.47656250 },
   { 0.84765625, 0.60156250, 0.47265625 },
   { 0.84765625, 0.59765625, 0.46875000 },
   { 0.84765625, 0.59765625, 0.46875000 },
   { 0.84375000, 0.59765625, 0.46484375 },
   { 0.84375000, 0.59375000, 0.46484375 },
   { 0.84375000, 0.59375000, 0.46093750 },
   { 0.84375000, 0.58984375, 0.46093750 },
   { 0.84375000, 0.58984375, 0.45703125 },
   { 0.84375000, 0.58593750, 0.45703125 },
   { 0.83984375, 0.58593750, 0.45312500 },
   { 0.83984375, 0.58593750, 0.44921875 },
   { 0.83984375, 0.58203125, 0.44921875 },
   { 0.83984375, 0.58203125, 0.44531250 },
   { 0.83984375, 0.57812500, 0.44531250 },
   { 0.83984375, 0.57812500, 0.44140625 },
   { 0.83984375, 0.57421875, 0.44140625 },
   { 0.83593750, 0.57421875, 0.43750000 },
   { 0.83593750, 0.57421875, 0.43359375 },
   { 0.83593750, 0.57031250, 0.43359375 },
   { 0.83593750, 0.57031250, 0.42968750 },
   { 0.83593750, 0.56640625, 0.42968750 },
   { 0.83593750, 0.56640625, 0.42578125 },
   { 0.83203125, 0.56640625, 0.42578125 },
   { 0.83203125, 0.56250000, 0.42187500 },
   { 0.83203125, 0.56250000, 0.42187500 },
   { 0.83203125, 0.55859375, 0.41796875 },
   { 0.83203125, 0.55859375, 0.41406250 },
   { 0.83203125, 0.55468750, 0.41406250 },
   { 0.82812500, 0.55468750, 0.41015625 },
   { 0.82812500, 0.55468750, 0.41015625 },
   { 0.82812500, 0.55078125, 0.40625000 },
   { 0.82812500, 0.55078125, 0.40625000 },
};

const int RGB_Palette_17_Size = 255; // gimp - Hilite
double RGB_Palette_17[RGB_Palette_17_Size][3] =
{
   { 0.64062500, 0.56250000, 0.70312500 },
   { 0.62500000, 0.56250000, 0.70312500 },
   { 0.62500000, 0.56250000, 0.70312500 },
   { 0.62500000, 0.56250000, 0.68750000 },
   { 0.62500000, 0.56250000, 0.68750000 },
   { 0.62500000, 0.54687500, 0.67187500 },
   { 0.62500000, 0.54687500, 0.67187500 },
   { 0.62500000, 0.54687500, 0.65625000 },
   { 0.62500000, 0.54687500, 0.65625000 },
   { 0.62500000, 0.54687500, 0.65625000 },
   { 0.62500000, 0.54687500, 0.64062500 },
   { 0.62500000, 0.53125000, 0.64062500 },
   { 0.60937500, 0.53125000, 0.62500000 },
   { 0.60937500, 0.53125000, 0.62500000 },
   { 0.60937500, 0.53125000, 0.60937500 },
   { 0.60937500, 0.53125000, 0.60937500 },
   { 0.60937500, 0.53125000, 0.60937500 },
   { 0.60937500, 0.51562500, 0.59375000 },
   { 0.60937500, 0.51562500, 0.59375000 },
   { 0.60937500, 0.51562500, 0.57812500 },
   { 0.60937500, 0.51562500, 0.57812500 },
   { 0.60937500, 0.51562500, 0.56250000 },
   { 0.60937500, 0.51562500, 0.56250000 },
   { 0.59375000, 0.50000000, 0.56250000 },
   { 0.59375000, 0.50000000, 0.54687500 },
   { 0.59375000, 0.50000000, 0.54687500 },
   { 0.59375000, 0.50000000, 0.53125000 },
   { 0.59375000, 0.50000000, 0.53125000 },
   { 0.59375000, 0.50000000, 0.51562500 },
   { 0.59375000, 0.50000000, 0.51562500 },
   { 0.59375000, 0.48437500, 0.51562500 },
   { 0.59375000, 0.48437500, 0.50000000 },
   { 0.59375000, 0.48437500, 0.50000000 },
   { 0.59375000, 0.48437500, 0.48437500 },
   { 0.57812500, 0.48437500, 0.48437500 },
   { 0.57812500, 0.48437500, 0.46875000 },
   { 0.57812500, 0.46875000, 0.46875000 },
   { 0.57812500, 0.46875000, 0.46875000 },
   { 0.57812500, 0.46875000, 0.45312500 },
   { 0.57812500, 0.46875000, 0.45312500 },
   { 0.57812500, 0.46875000, 0.43750000 },
   { 0.57812500, 0.46875000, 0.43750000 },
   { 0.57812500, 0.45312500, 0.42187500 },
   { 0.57812500, 0.45312500, 0.42187500 },
   { 0.56250000, 0.45312500, 0.42187500 },
   { 0.56250000, 0.45312500, 0.40625000 },
   { 0.56250000, 0.45312500, 0.40625000 },
   { 0.56250000, 0.45312500, 0.39062500 },
   { 0.56250000, 0.43750000, 0.39062500 },
   { 0.56250000, 0.43750000, 0.37500000 },
   { 0.56250000, 0.43750000, 0.37500000 },
   { 0.56250000, 0.43750000, 0.37500000 },
   { 0.56250000, 0.43750000, 0.35937500 },
   { 0.56250000, 0.43750000, 0.35937500 },
   { 0.56250000, 0.43750000, 0.34375000 },
   { 0.54687500, 0.42187500, 0.34375000 },
   { 0.54687500, 0.42187500, 0.32812500 },
   { 0.54687500, 0.42187500, 0.32812500 },
   { 0.54687500, 0.42187500, 0.32812500 },
   { 0.54687500, 0.42187500, 0.31250000 },
   { 0.54687500, 0.42187500, 0.31250000 },
   { 0.54687500, 0.40625000, 0.29687500 },
   { 0.54687500, 0.40625000, 0.29687500 },
   { 0.54687500, 0.40625000, 0.28125000 },
   { 0.54687500, 0.40625000, 0.28125000 },
   { 0.54687500, 0.40625000, 0.28125000 },
   { 0.53125000, 0.40625000, 0.26562500 },
   { 0.53125000, 0.39062500, 0.26562500 },
   { 0.53125000, 0.39062500, 0.25000000 },
   { 0.53125000, 0.39062500, 0.25000000 },
   { 0.53125000, 0.39062500, 0.23437500 },
   { 0.53125000, 0.39062500, 0.23437500 },
   { 0.53125000, 0.39062500, 0.23437500 },
   { 0.53125000, 0.37500000, 0.21875000 },
   { 0.53125000, 0.37500000, 0.21875000 },
   { 0.53125000, 0.37500000, 0.20312500 },
   { 0.53125000, 0.37500000, 0.20312500 },
   { 0.51562500, 0.37500000, 0.18750000 },
   { 0.51562500, 0.37500000, 0.18750000 },
   { 0.51562500, 0.37500000, 0.18750000 },
   { 0.51562500, 0.35937500, 0.17187500 },
   { 0.51562500, 0.35937500, 0.17187500 },
   { 0.51562500, 0.35937500, 0.15625000 },
   { 0.51562500, 0.35937500, 0.15625000 },
   { 0.51562500, 0.35937500, 0.14062500 },
   { 0.51562500, 0.35937500, 0.14062500 },
   { 0.51562500, 0.34375000, 0.14062500 },
   { 0.51562500, 0.34375000, 0.12500000 },
   { 0.50000000, 0.34375000, 0.12500000 },
   { 0.50000000, 0.34375000, 0.10937500 },
   { 0.50000000, 0.34375000, 0.10937500 },
   { 0.50000000, 0.34375000, 0.09375000 },
   { 0.50000000, 0.32812500, 0.09375000 },
   { 0.50000000, 0.32812500, 0.09375000 },
   { 0.50000000, 0.32812500, 0.07812500 },
   { 0.50000000, 0.32812500, 0.07812500 },
   { 0.50000000, 0.32812500, 0.06250000 },
   { 0.50000000, 0.32812500, 0.06250000 },
   { 0.48437500, 0.31250000, 0.04687500 },
   { 0.48437500, 0.31250000, 0.04687500 },
   { 0.48437500, 0.31250000, 0.04687500 },
   { 0.48437500, 0.32812500, 0.06250000 },
   { 0.50000000, 0.32812500, 0.06250000 },
   { 0.50000000, 0.34375000, 0.07812500 },
   { 0.50000000, 0.34375000, 0.07812500 },
   { 0.50000000, 0.35937500, 0.09375000 },
   { 0.51562500, 0.35937500, 0.09375000 },
   { 0.51562500, 0.35937500, 0.10937500 },
   { 0.51562500, 0.37500000, 0.10937500 },
   { 0.53125000, 0.37500000, 0.12500000 },
   { 0.53125000, 0.39062500, 0.12500000 },
   { 0.53125000, 0.39062500, 0.12500000 },
   { 0.53125000, 0.40625000, 0.14062500 },
   { 0.54687500, 0.40625000, 0.14062500 },
   { 0.54687500, 0.42187500, 0.15625000 },
   { 0.54687500, 0.42187500, 0.15625000 },
   { 0.56250000, 0.42187500, 0.17187500 },
   { 0.56250000, 0.43750000, 0.17187500 },
   { 0.56250000, 0.43750000, 0.18750000 },
   { 0.56250000, 0.45312500, 0.18750000 },
   { 0.57812500, 0.45312500, 0.20312500 },
   { 0.57812500, 0.46875000, 0.20312500 },
   { 0.57812500, 0.46875000, 0.21875000 },
   { 0.59375000, 0.46875000, 0.21875000 },
   { 0.59375000, 0.48437500, 0.21875000 },
   { 0.59375000, 0.48437500, 0.23437500 },
   { 0.59375000, 0.50000000, 0.23437500 },
   { 0.60937500, 0.50000000, 0.25000000 },
   { 0.60937500, 0.51562500, 0.25000000 },
   { 0.60937500, 0.51562500, 0.26562500 },
   { 0.62500000, 0.53125000, 0.26562500 },
   { 0.62500000, 0.53125000, 0.28125000 },
   { 0.62500000, 0.53125000, 0.28125000 },
   { 0.62500000, 0.54687500, 0.29687500 },
   { 0.64062500, 0.54687500, 0.29687500 },
   { 0.64062500, 0.56250000, 0.29687500 },
   { 0.64062500, 0.56250000, 0.31250000 },
   { 0.64062500, 0.57812500, 0.31250000 },
   { 0.65625000, 0.57812500, 0.32812500 },
   { 0.65625000, 0.57812500, 0.32812500 },
   { 0.65625000, 0.59375000, 0.34375000 },
   { 0.67187500, 0.59375000, 0.34375000 },
   { 0.67187500, 0.60937500, 0.35937500 },
   { 0.67187500, 0.60937500, 0.35937500 },
   { 0.67187500, 0.62500000, 0.37500000 },
   { 0.68750000, 0.62500000, 0.37500000 },
   { 0.68750000, 0.64062500, 0.39062500 },
   { 0.68750000, 0.64062500, 0.39062500 },
   { 0.70312500, 0.64062500, 0.39062500 },
   { 0.70312500, 0.65625000, 0.40625000 },
   { 0.70312500, 0.65625000, 0.40625000 },
   { 0.70312500, 0.67187500, 0.42187500 },
   { 0.71875000, 0.67187500, 0.42187500 },
   { 0.71875000, 0.68750000, 0.43750000 },
   { 0.71875000, 0.68750000, 0.43750000 },
   { 0.73437500, 0.68750000, 0.45312500 },
   { 0.73437500, 0.70312500, 0.45312500 },
   { 0.73437500, 0.70312500, 0.46875000 },
   { 0.73437500, 0.71875000, 0.46875000 },
   { 0.75000000, 0.71875000, 0.46875000 },
   { 0.75000000, 0.73437500, 0.48437500 },
   { 0.75000000, 0.73437500, 0.48437500 },
   { 0.76562500, 0.75000000, 0.50000000 },
   { 0.76562500, 0.75000000, 0.50000000 },
   { 0.76562500, 0.75000000, 0.51562500 },
   { 0.76562500, 0.76562500, 0.51562500 },
   { 0.78125000, 0.76562500, 0.53125000 },
   { 0.78125000, 0.78125000, 0.53125000 },
   { 0.78125000, 0.78125000, 0.54687500 },
   { 0.78125000, 0.79687500, 0.54687500 },
   { 0.79687500, 0.79687500, 0.56250000 },
   { 0.79687500, 0.79687500, 0.56250000 },
   { 0.79687500, 0.81250000, 0.56250000 },
   { 0.81250000, 0.81250000, 0.57812500 },
   { 0.81250000, 0.82812500, 0.57812500 },
   { 0.81250000, 0.82812500, 0.59375000 },
   { 0.81250000, 0.84375000, 0.59375000 },
   { 0.82812500, 0.84375000, 0.60937500 },
   { 0.82812500, 0.85937500, 0.60937500 },
   { 0.82812500, 0.85937500, 0.62500000 },
   { 0.84375000, 0.85937500, 0.62500000 },
   { 0.84375000, 0.87500000, 0.64062500 },
   { 0.84375000, 0.87500000, 0.64062500 },
   { 0.84375000, 0.89062500, 0.64062500 },
   { 0.85937500, 0.89062500, 0.65625000 },
   { 0.85937500, 0.90625000, 0.65625000 },
   { 0.85937500, 0.90625000, 0.67187500 },
   { 0.87500000, 0.90625000, 0.67187500 },
   { 0.87500000, 0.92187500, 0.68750000 },
   { 0.87500000, 0.92187500, 0.68750000 },
   { 0.87500000, 0.93750000, 0.70312500 },
   { 0.89062500, 0.93750000, 0.70312500 },
   { 0.89062500, 0.95312500, 0.71875000 },
   { 0.89062500, 0.95312500, 0.71875000 },
   { 0.90625000, 0.96875000, 0.73437500 },
   { 0.90625000, 0.96875000, 0.73437500 },
   { 0.90625000, 0.96875000, 0.73437500 },
   { 0.90625000, 0.96875000, 0.73437500 },
   { 0.89062500, 0.95312500, 0.73437500 },
   { 0.89062500, 0.95312500, 0.73437500 },
   { 0.89062500, 0.95312500, 0.73437500 },
   { 0.87500000, 0.95312500, 0.73437500 },
   { 0.87500000, 0.93750000, 0.73437500 },
   { 0.87500000, 0.93750000, 0.73437500 },
   { 0.85937500, 0.93750000, 0.73437500 },
   { 0.85937500, 0.92187500, 0.73437500 },
   { 0.85937500, 0.92187500, 0.73437500 },
   { 0.84375000, 0.92187500, 0.73437500 },
   { 0.84375000, 0.92187500, 0.73437500 },
   { 0.84375000, 0.90625000, 0.73437500 },
   { 0.82812500, 0.90625000, 0.73437500 },
   { 0.82812500, 0.90625000, 0.71875000 },
   { 0.82812500, 0.89062500, 0.71875000 },
   { 0.81250000, 0.89062500, 0.71875000 },
   { 0.81250000, 0.89062500, 0.71875000 },
   { 0.81250000, 0.89062500, 0.71875000 },
   { 0.79687500, 0.87500000, 0.71875000 },
   { 0.79687500, 0.87500000, 0.71875000 },
   { 0.79687500, 0.87500000, 0.71875000 },
   { 0.79687500, 0.85937500, 0.71875000 },
   { 0.78125000, 0.85937500, 0.71875000 },
   { 0.78125000, 0.85937500, 0.71875000 },
   { 0.78125000, 0.85937500, 0.71875000 },
   { 0.76562500, 0.84375000, 0.71875000 },
   { 0.76562500, 0.84375000, 0.71875000 },
   { 0.76562500, 0.84375000, 0.71875000 },
   { 0.75000000, 0.82812500, 0.71875000 },
   { 0.75000000, 0.82812500, 0.71875000 },
   { 0.75000000, 0.82812500, 0.70312500 },
   { 0.73437500, 0.82812500, 0.70312500 },
   { 0.73437500, 0.81250000, 0.70312500 },
   { 0.73437500, 0.81250000, 0.70312500 },
   { 0.71875000, 0.81250000, 0.70312500 },
   { 0.71875000, 0.79687500, 0.70312500 },
   { 0.71875000, 0.79687500, 0.70312500 },
   { 0.70312500, 0.79687500, 0.70312500 },
   { 0.70312500, 0.79687500, 0.70312500 },
   { 0.70312500, 0.78125000, 0.70312500 },
   { 0.68750000, 0.78125000, 0.70312500 },
   { 0.68750000, 0.78125000, 0.70312500 },
   { 0.68750000, 0.76562500, 0.70312500 },
   { 0.67187500, 0.76562500, 0.70312500 },
   { 0.67187500, 0.76562500, 0.70312500 },
   { 0.67187500, 0.76562500, 0.70312500 },
   { 0.67187500, 0.75000000, 0.70312500 },
   { 0.65625000, 0.75000000, 0.68750000 },
   { 0.65625000, 0.75000000, 0.68750000 },
   { 0.65625000, 0.73437500, 0.68750000 },
   { 0.64062500, 0.73437500, 0.68750000 },
   { 0.64062500, 0.73437500, 0.68750000 },
   { 0.64062500, 0.73437500, 0.68750000 },
   { 0.62500000, 0.71875000, 0.68750000 },
   { 0.62500000, 0.71875000, 0.68750000 },
   { 0.62500000, 0.71875000, 0.68750000 },
   { 0.60937500, 0.70312500, 0.68750000 },
};

const int RGB_Palette_18_Size = 256; // gimp - DeepSea
double RGB_Palette_18[RGB_Palette_18_Size][3] =
{
   { 0.00000000, 0.00781250, 0.16406250 },
   { 0.00000000, 0.00781250, 0.16796875 },
   { 0.00000000, 0.01171875, 0.17187500 },
   { 0.00000000, 0.01562500, 0.17187500 },
   { 0.00390625, 0.01562500, 0.17578125 },
   { 0.00390625, 0.01953125, 0.17968750 },
   { 0.00390625, 0.02343750, 0.18359375 },
   { 0.00781250, 0.02343750, 0.18750000 },
   { 0.00781250, 0.02734375, 0.18750000 },
   { 0.00781250, 0.03125000, 0.19140625 },
   { 0.01171875, 0.03125000, 0.19531250 },
   { 0.01171875, 0.03515625, 0.19921875 },
   { 0.01171875, 0.03906250, 0.20312500 },
   { 0.01562500, 0.03906250, 0.20312500 },
   { 0.01562500, 0.04296875, 0.20703125 },
   { 0.01562500, 0.04687500, 0.21093750 },
   { 0.01953125, 0.04687500, 0.21484375 },
   { 0.01953125, 0.05078125, 0.21875000 },
   { 0.01953125, 0.05468750, 0.21875000 },
   { 0.01953125, 0.05468750, 0.22265625 },
   { 0.02343750, 0.05859375, 0.22656250 },
   { 0.02343750, 0.06250000, 0.23046875 },
   { 0.02343750, 0.06250000, 0.23437500 },
   { 0.02734375, 0.06640625, 0.23437500 },
   { 0.02734375, 0.07031250, 0.23828125 },
   { 0.02734375, 0.07031250, 0.24218750 },
   { 0.03125000, 0.07421875, 0.24609375 },
   { 0.03125000, 0.07812500, 0.24609375 },
   { 0.03125000, 0.07812500, 0.25000000 },
   { 0.03515625, 0.08203125, 0.25390625 },
   { 0.03515625, 0.08593750, 0.25781250 },
   { 0.03515625, 0.08593750, 0.26171875 },
   { 0.03906250, 0.08984375, 0.26171875 },
   { 0.03906250, 0.09375000, 0.26562500 },
   { 0.03906250, 0.09375000, 0.26953125 },
   { 0.03906250, 0.09765625, 0.27343750 },
   { 0.04296875, 0.10156250, 0.27734375 },
   { 0.04296875, 0.10156250, 0.27734375 },
   { 0.04296875, 0.10546875, 0.28125000 },
   { 0.04687500, 0.10937500, 0.28515625 },
   { 0.04687500, 0.10937500, 0.28906250 },
   { 0.04687500, 0.11328125, 0.29296875 },
   { 0.05078125, 0.11718750, 0.29296875 },
   { 0.05078125, 0.11718750, 0.29687500 },
   { 0.05078125, 0.12109375, 0.30078125 },
   { 0.05468750, 0.12500000, 0.30468750 },
   { 0.05468750, 0.12500000, 0.30859375 },
   { 0.05468750, 0.12890625, 0.30859375 },
   { 0.05859375, 0.13281250, 0.31250000 },
   { 0.05859375, 0.13671875, 0.31640625 },
   { 0.05859375, 0.13671875, 0.32031250 },
   { 0.05859375, 0.14062500, 0.32421875 },
   { 0.06250000, 0.14453125, 0.32421875 },
   { 0.06250000, 0.14453125, 0.32812500 },
   { 0.06250000, 0.14843750, 0.33203125 },
   { 0.06640625, 0.15234375, 0.33593750 },
   { 0.06640625, 0.15234375, 0.33984375 },
   { 0.06640625, 0.15625000, 0.33984375 },
   { 0.07031250, 0.16015625, 0.34375000 },
   { 0.07031250, 0.16015625, 0.34765625 },
   { 0.07031250, 0.16406250, 0.35156250 },
   { 0.07421875, 0.16796875, 0.35546875 },
   { 0.07421875, 0.16796875, 0.35546875 },
   { 0.07421875, 0.17187500, 0.35937500 },
   { 0.07812500, 0.17578125, 0.36328125 },
   { 0.07812500, 0.17578125, 0.36718750 },
   { 0.07812500, 0.17968750, 0.37109375 },
   { 0.08203125, 0.18359375, 0.37109375 },
   { 0.08203125, 0.18359375, 0.37500000 },
   { 0.08203125, 0.18750000, 0.37890625 },
   { 0.08203125, 0.19140625, 0.38281250 },
   { 0.08593750, 0.19140625, 0.38671875 },
   { 0.08593750, 0.19531250, 0.38671875 },
   { 0.08593750, 0.19531250, 0.39062500 },
   { 0.08984375, 0.19921875, 0.39453125 },
   { 0.08984375, 0.19921875, 0.39453125 },
   { 0.08984375, 0.20312500, 0.39453125 },
   { 0.08984375, 0.20312500, 0.39843750 },
   { 0.08984375, 0.20312500, 0.39843750 },
   { 0.08984375, 0.20703125, 0.40234375 },
   { 0.09375000, 0.20703125, 0.40234375 },
   { 0.09375000, 0.21093750, 0.40625000 },
   { 0.09375000, 0.21093750, 0.40625000 },
   { 0.09375000, 0.21093750, 0.41015625 },
   { 0.09375000, 0.21484375, 0.41015625 },
   { 0.09765625, 0.21484375, 0.41406250 },
   { 0.09765625, 0.21875000, 0.41406250 },
   { 0.09765625, 0.21875000, 0.41796875 },
   { 0.09765625, 0.21875000, 0.41796875 },
   { 0.09765625, 0.22265625, 0.42187500 },
   { 0.10156250, 0.22265625, 0.42187500 },
   { 0.10156250, 0.22656250, 0.42578125 },
   { 0.10156250, 0.22656250, 0.42578125 },
   { 0.10156250, 0.22656250, 0.42968750 },
   { 0.10156250, 0.23046875, 0.42968750 },
   { 0.10156250, 0.23046875, 0.43359375 },
   { 0.10546875, 0.23437500, 0.43359375 },
   { 0.10546875, 0.23437500, 0.43359375 },
   { 0.10546875, 0.23437500, 0.43750000 },
   { 0.10546875, 0.23828125, 0.43750000 },
   { 0.10546875, 0.23828125, 0.44140625 },
   { 0.10937500, 0.24218750, 0.44140625 },
   { 0.10937500, 0.24218750, 0.44531250 },
   { 0.10937500, 0.24218750, 0.44531250 },
   { 0.10937500, 0.24609375, 0.44921875 },
   { 0.10937500, 0.24609375, 0.44921875 },
   { 0.11328125, 0.25000000, 0.45312500 },
   { 0.11328125, 0.25000000, 0.45312500 },
   { 0.11328125, 0.25000000, 0.45703125 },
   { 0.11328125, 0.25390625, 0.45703125 },
   { 0.11328125, 0.25390625, 0.46093750 },
   { 0.11328125, 0.25781250, 0.46093750 },
   { 0.11718750, 0.25781250, 0.46484375 },
   { 0.11718750, 0.25781250, 0.46484375 },
   { 0.11718750, 0.26171875, 0.46875000 },
   { 0.11718750, 0.26171875, 0.46875000 },
   { 0.11718750, 0.26562500, 0.47265625 },
   { 0.12109375, 0.26562500, 0.47265625 },
   { 0.12109375, 0.26562500, 0.47265625 },
   { 0.12109375, 0.26953125, 0.47656250 },
   { 0.12109375, 0.26953125, 0.47656250 },
   { 0.12109375, 0.27343750, 0.48046875 },
   { 0.12500000, 0.27343750, 0.48046875 },
   { 0.12500000, 0.27343750, 0.48437500 },
   { 0.12500000, 0.27734375, 0.48437500 },
   { 0.12500000, 0.27734375, 0.48828125 },
   { 0.12500000, 0.28125000, 0.48828125 },
   { 0.12500000, 0.28125000, 0.49218750 },
   { 0.12890625, 0.28125000, 0.49218750 },
   { 0.12890625, 0.28515625, 0.49609375 },
   { 0.12890625, 0.28515625, 0.49609375 },
   { 0.12890625, 0.28906250, 0.50000000 },
   { 0.12890625, 0.28906250, 0.50000000 },
   { 0.13281250, 0.28906250, 0.50390625 },
   { 0.13281250, 0.29296875, 0.50390625 },
   { 0.13281250, 0.29296875, 0.50781250 },
   { 0.13281250, 0.29687500, 0.50781250 },
   { 0.13281250, 0.29687500, 0.51171875 },
   { 0.13671875, 0.29687500, 0.51171875 },
   { 0.13671875, 0.30078125, 0.51171875 },
   { 0.13671875, 0.30078125, 0.51562500 },
   { 0.13671875, 0.30468750, 0.51562500 },
   { 0.13671875, 0.30468750, 0.51953125 },
   { 0.13671875, 0.30468750, 0.51953125 },
   { 0.14062500, 0.30859375, 0.52343750 },
   { 0.14062500, 0.30859375, 0.52343750 },
   { 0.14062500, 0.31250000, 0.52734375 },
   { 0.14062500, 0.31250000, 0.52734375 },
   { 0.14062500, 0.31250000, 0.53125000 },
   { 0.14453125, 0.31640625, 0.53125000 },
   { 0.14453125, 0.31640625, 0.53515625 },
   { 0.14453125, 0.32031250, 0.53515625 },
   { 0.14453125, 0.32031250, 0.53906250 },
   { 0.14453125, 0.32031250, 0.53906250 },
   { 0.14843750, 0.32421875, 0.54296875 },
   { 0.14843750, 0.32421875, 0.54296875 },
   { 0.14843750, 0.32812500, 0.54687500 },
   { 0.14843750, 0.32812500, 0.54687500 },
   { 0.14843750, 0.32812500, 0.55078125 },
   { 0.14843750, 0.33203125, 0.55078125 },
   { 0.15234375, 0.33203125, 0.55078125 },
   { 0.15234375, 0.33593750, 0.55468750 },
   { 0.15234375, 0.33593750, 0.55468750 },
   { 0.15234375, 0.33593750, 0.55859375 },
   { 0.15234375, 0.33984375, 0.55859375 },
   { 0.15625000, 0.33984375, 0.56250000 },
   { 0.15625000, 0.34375000, 0.56250000 },
   { 0.15625000, 0.34375000, 0.56640625 },
   { 0.15625000, 0.34375000, 0.56640625 },
   { 0.15625000, 0.34765625, 0.57031250 },
   { 0.16015625, 0.34765625, 0.57031250 },
   { 0.16015625, 0.35156250, 0.57421875 },
   { 0.16015625, 0.35156250, 0.57421875 },
   { 0.16015625, 0.35156250, 0.57812500 },
   { 0.16015625, 0.35546875, 0.57812500 },
   { 0.16015625, 0.35546875, 0.58203125 },
   { 0.16406250, 0.35937500, 0.58203125 },
   { 0.16406250, 0.35937500, 0.58593750 },
   { 0.16406250, 0.35937500, 0.58593750 },
   { 0.16406250, 0.36328125, 0.58984375 },
   { 0.16406250, 0.36328125, 0.58984375 },
   { 0.16796875, 0.36718750, 0.58984375 },
   { 0.16796875, 0.36718750, 0.59375000 },
   { 0.16796875, 0.36718750, 0.59375000 },
   { 0.16796875, 0.37109375, 0.59765625 },
   { 0.16796875, 0.37109375, 0.59765625 },
   { 0.17187500, 0.37500000, 0.60156250 },
   { 0.17187500, 0.37500000, 0.60156250 },
   { 0.17187500, 0.37500000, 0.60546875 },
   { 0.17187500, 0.37890625, 0.60546875 },
   { 0.17187500, 0.37890625, 0.60937500 },
   { 0.17187500, 0.38281250, 0.60937500 },
   { 0.17578125, 0.38281250, 0.61328125 },
   { 0.17578125, 0.38281250, 0.61328125 },
   { 0.17578125, 0.38671875, 0.61718750 },
   { 0.17578125, 0.39062500, 0.62109375 },
   { 0.17187500, 0.39843750, 0.62500000 },
   { 0.16796875, 0.41015625, 0.62890625 },
   { 0.16796875, 0.41796875, 0.63671875 },
   { 0.16406250, 0.42578125, 0.64062500 },
   { 0.16015625, 0.43750000, 0.64453125 },
   { 0.16015625, 0.44531250, 0.65234375 },
   { 0.15625000, 0.45312500, 0.65625000 },
   { 0.15234375, 0.46484375, 0.66406250 },
   { 0.14843750, 0.47265625, 0.66796875 },
   { 0.14843750, 0.48046875, 0.67187500 },
   { 0.14453125, 0.48828125, 0.67968750 },
   { 0.14062500, 0.50000000, 0.68359375 },
   { 0.14062500, 0.50781250, 0.69140625 },
   { 0.13671875, 0.51562500, 0.69531250 },
   { 0.13281250, 0.52734375, 0.69921875 },
   { 0.12890625, 0.53515625, 0.70703125 },
   { 0.12890625, 0.54296875, 0.71093750 },
   { 0.12500000, 0.55468750, 0.71875000 },
   { 0.12109375, 0.56250000, 0.72265625 },
   { 0.12109375, 0.57031250, 0.72656250 },
   { 0.11718750, 0.58203125, 0.73437500 },
   { 0.11328125, 0.58984375, 0.73828125 },
   { 0.10937500, 0.59765625, 0.74609375 },
   { 0.10937500, 0.60937500, 0.75000000 },
   { 0.10546875, 0.61718750, 0.75390625 },
   { 0.10156250, 0.62500000, 0.76171875 },
   { 0.10156250, 0.63281250, 0.76562500 },
   { 0.09765625, 0.64453125, 0.77343750 },
   { 0.09375000, 0.65234375, 0.77734375 },
   { 0.08984375, 0.66015625, 0.78125000 },
   { 0.08984375, 0.67187500, 0.78906250 },
   { 0.08593750, 0.67968750, 0.79296875 },
   { 0.08203125, 0.69140625, 0.80078125 },
   { 0.07812500, 0.69921875, 0.80468750 },
   { 0.07812500, 0.71093750, 0.81250000 },
   { 0.07421875, 0.72265625, 0.81640625 },
   { 0.07031250, 0.73046875, 0.82421875 },
   { 0.06640625, 0.74218750, 0.83203125 },
   { 0.06250000, 0.75000000, 0.83593750 },
   { 0.06250000, 0.76171875, 0.84375000 },
   { 0.05859375, 0.77343750, 0.84765625 },
   { 0.05468750, 0.78125000, 0.85546875 },
   { 0.05078125, 0.79296875, 0.85937500 },
   { 0.04687500, 0.80078125, 0.86718750 },
   { 0.04687500, 0.81250000, 0.87109375 },
   { 0.04296875, 0.82031250, 0.87890625 },
   { 0.03906250, 0.83203125, 0.88671875 },
   { 0.03515625, 0.84375000, 0.89062500 },
   { 0.03125000, 0.85156250, 0.89843750 },
   { 0.03125000, 0.86328125, 0.90234375 },
   { 0.02734375, 0.87109375, 0.91015625 },
   { 0.02343750, 0.88281250, 0.91406250 },
   { 0.01953125, 0.89453125, 0.92187500 },
   { 0.01562500, 0.90234375, 0.92578125 },
   { 0.01562500, 0.91406250, 0.93359375 },
   { 0.01171875, 0.92187500, 0.94140625 },
   { 0.00781250, 0.93359375, 0.94531250 },
   { 0.00390625, 0.94531250, 0.95312500 },
   { 0.00000000, 0.95312500, 0.95703125 },
   { 0.00000000, 0.96484375, 0.96484375 },
};

const int RGB_Palette_19_Size = 256; // gimp - PastelRainbow
double RGB_Palette_19[RGB_Palette_19_Size][3] =
{
   { 0.99609375, 0.74609375, 0.74609375 },
   { 0.99609375, 0.75000000, 0.74609375 },
   { 0.99609375, 0.75781250, 0.74609375 },
   { 0.99609375, 0.76171875, 0.74609375 },
   { 0.99609375, 0.76953125, 0.74609375 },
   { 0.99609375, 0.77343750, 0.74609375 },
   { 0.99609375, 0.78125000, 0.74609375 },
   { 0.99609375, 0.78515625, 0.74609375 },
   { 0.99609375, 0.79296875, 0.74609375 },
   { 0.99609375, 0.79687500, 0.74609375 },
   { 0.99609375, 0.80468750, 0.74609375 },
   { 0.99609375, 0.80859375, 0.74609375 },
   { 0.99609375, 0.81640625, 0.74609375 },
   { 0.99609375, 0.82031250, 0.74609375 },
   { 0.99609375, 0.82812500, 0.74609375 },
   { 0.99609375, 0.83203125, 0.74609375 },
   { 0.99609375, 0.83984375, 0.74609375 },
   { 0.99609375, 0.84375000, 0.74609375 },
   { 0.99609375, 0.85156250, 0.74609375 },
   { 0.99609375, 0.85546875, 0.74609375 },
   { 0.99609375, 0.86328125, 0.74609375 },
   { 0.99609375, 0.86718750, 0.74609375 },
   { 0.99609375, 0.87500000, 0.74609375 },
   { 0.99609375, 0.87890625, 0.74609375 },
   { 0.99609375, 0.88671875, 0.74609375 },
   { 0.99609375, 0.89062500, 0.74609375 },
   { 0.99609375, 0.89843750, 0.74609375 },
   { 0.99609375, 0.90234375, 0.74609375 },
   { 0.99609375, 0.91015625, 0.74609375 },
   { 0.99609375, 0.91406250, 0.74609375 },
   { 0.99609375, 0.92187500, 0.74609375 },
   { 0.99609375, 0.92578125, 0.74609375 },
   { 0.99609375, 0.93359375, 0.74609375 },
   { 0.99609375, 0.93750000, 0.74609375 },
   { 0.99609375, 0.94531250, 0.74609375 },
   { 0.99609375, 0.94921875, 0.74609375 },
   { 0.99609375, 0.95703125, 0.74609375 },
   { 0.99609375, 0.96093750, 0.74609375 },
   { 0.99609375, 0.96875000, 0.74609375 },
   { 0.99609375, 0.97265625, 0.74609375 },
   { 0.99609375, 0.98046875, 0.74609375 },
   { 0.99609375, 0.98437500, 0.74609375 },
   { 0.99609375, 0.99218750, 0.74609375 },
   { 0.99218750, 0.99609375, 0.74609375 },
   { 0.98437500, 0.99609375, 0.74609375 },
   { 0.98046875, 0.99609375, 0.74609375 },
   { 0.97265625, 0.99609375, 0.74609375 },
   { 0.96875000, 0.99609375, 0.74609375 },
   { 0.96093750, 0.99609375, 0.74609375 },
   { 0.95703125, 0.99609375, 0.74609375 },
   { 0.94921875, 0.99609375, 0.74609375 },
   { 0.94531250, 0.99609375, 0.74609375 },
   { 0.93750000, 0.99609375, 0.74609375 },
   { 0.93359375, 0.99609375, 0.74609375 },
   { 0.92578125, 0.99609375, 0.74609375 },
   { 0.92187500, 0.99609375, 0.74609375 },
   { 0.91406250, 0.99609375, 0.74609375 },
   { 0.91015625, 0.99609375, 0.74609375 },
   { 0.90234375, 0.99609375, 0.74609375 },
   { 0.89843750, 0.99609375, 0.74609375 },
   { 0.89062500, 0.99609375, 0.74609375 },
   { 0.88671875, 0.99609375, 0.74609375 },
   { 0.87890625, 0.99609375, 0.74609375 },
   { 0.87500000, 0.99609375, 0.74609375 },
   { 0.86718750, 0.99609375, 0.74609375 },
   { 0.86328125, 0.99609375, 0.74609375 },
   { 0.85546875, 0.99609375, 0.74609375 },
   { 0.85156250, 0.99609375, 0.74609375 },
   { 0.84375000, 0.99609375, 0.74609375 },
   { 0.83984375, 0.99609375, 0.74609375 },
   { 0.83203125, 0.99609375, 0.74609375 },
   { 0.82812500, 0.99609375, 0.74609375 },
   { 0.82031250, 0.99609375, 0.74609375 },
   { 0.81640625, 0.99609375, 0.74609375 },
   { 0.80859375, 0.99609375, 0.74609375 },
   { 0.80468750, 0.99609375, 0.74609375 },
   { 0.79687500, 0.99609375, 0.74609375 },
   { 0.79296875, 0.99609375, 0.74609375 },
   { 0.78515625, 0.99609375, 0.74609375 },
   { 0.78125000, 0.99609375, 0.74609375 },
   { 0.77343750, 0.99609375, 0.74609375 },
   { 0.76953125, 0.99609375, 0.74609375 },
   { 0.76171875, 0.99609375, 0.74609375 },
   { 0.75781250, 0.99609375, 0.74609375 },
   { 0.75000000, 0.99609375, 0.74609375 },
   { 0.74609375, 0.99609375, 0.74609375 },
   { 0.74609375, 0.99609375, 0.75000000 },
   { 0.74609375, 0.99609375, 0.75781250 },
   { 0.74609375, 0.99609375, 0.76171875 },
   { 0.74609375, 0.99609375, 0.76953125 },
   { 0.74609375, 0.99609375, 0.77343750 },
   { 0.74609375, 0.99609375, 0.78125000 },
   { 0.74609375, 0.99609375, 0.78515625 },
   { 0.74609375, 0.99609375, 0.79296875 },
   { 0.74609375, 0.99609375, 0.79687500 },
   { 0.74609375, 0.99609375, 0.80468750 },
   { 0.74609375, 0.99609375, 0.80859375 },
   { 0.74609375, 0.99609375, 0.81640625 },
   { 0.74609375, 0.99609375, 0.82031250 },
   { 0.74609375, 0.99609375, 0.82812500 },
   { 0.74609375, 0.99609375, 0.83203125 },
   { 0.74609375, 0.99609375, 0.83984375 },
   { 0.74609375, 0.99609375, 0.84375000 },
   { 0.74609375, 0.99609375, 0.85156250 },
   { 0.74609375, 0.99609375, 0.85546875 },
   { 0.74609375, 0.99609375, 0.86328125 },
   { 0.74609375, 0.99609375, 0.86718750 },
   { 0.74609375, 0.99609375, 0.87500000 },
   { 0.74609375, 0.99609375, 0.87890625 },
   { 0.74609375, 0.99609375, 0.88671875 },
   { 0.74609375, 0.99609375, 0.89062500 },
   { 0.74609375, 0.99609375, 0.89843750 },
   { 0.74609375, 0.99609375, 0.90234375 },
   { 0.74609375, 0.99609375, 0.91015625 },
   { 0.74609375, 0.99609375, 0.91406250 },
   { 0.74609375, 0.99609375, 0.92187500 },
   { 0.74609375, 0.99609375, 0.92578125 },
   { 0.74609375, 0.99609375, 0.93359375 },
   { 0.74609375, 0.99609375, 0.93750000 },
   { 0.74609375, 0.99609375, 0.94531250 },
   { 0.74609375, 0.99609375, 0.94921875 },
   { 0.74609375, 0.99609375, 0.95703125 },
   { 0.74609375, 0.99609375, 0.96093750 },
   { 0.74609375, 0.99609375, 0.96875000 },
   { 0.74609375, 0.99609375, 0.97265625 },
   { 0.74609375, 0.99609375, 0.98046875 },
   { 0.74609375, 0.99609375, 0.98437500 },
   { 0.74609375, 0.99609375, 0.99218750 },
   { 0.74609375, 0.99218750, 0.99609375 },
   { 0.74609375, 0.98437500, 0.99609375 },
   { 0.74609375, 0.98046875, 0.99609375 },
   { 0.74609375, 0.97265625, 0.99609375 },
   { 0.74609375, 0.96875000, 0.99609375 },
   { 0.74609375, 0.96093750, 0.99609375 },
   { 0.74609375, 0.95703125, 0.99609375 },
   { 0.74609375, 0.94921875, 0.99609375 },
   { 0.74609375, 0.94531250, 0.99609375 },
   { 0.74609375, 0.93750000, 0.99609375 },
   { 0.74609375, 0.93359375, 0.99609375 },
   { 0.74609375, 0.92578125, 0.99609375 },
   { 0.74609375, 0.92187500, 0.99609375 },
   { 0.74609375, 0.91406250, 0.99609375 },
   { 0.74609375, 0.91015625, 0.99609375 },
   { 0.74609375, 0.90234375, 0.99609375 },
   { 0.74609375, 0.89843750, 0.99609375 },
   { 0.74609375, 0.89062500, 0.99609375 },
   { 0.74609375, 0.88671875, 0.99609375 },
   { 0.74609375, 0.87890625, 0.99609375 },
   { 0.74609375, 0.87500000, 0.99609375 },
   { 0.74609375, 0.86718750, 0.99609375 },
   { 0.74609375, 0.86328125, 0.99609375 },
   { 0.74609375, 0.85546875, 0.99609375 },
   { 0.74609375, 0.85156250, 0.99609375 },
   { 0.74609375, 0.84375000, 0.99609375 },
   { 0.74609375, 0.83984375, 0.99609375 },
   { 0.74609375, 0.83203125, 0.99609375 },
   { 0.74609375, 0.82812500, 0.99609375 },
   { 0.74609375, 0.82031250, 0.99609375 },
   { 0.74609375, 0.81640625, 0.99609375 },
   { 0.74609375, 0.80859375, 0.99609375 },
   { 0.74609375, 0.80468750, 0.99609375 },
   { 0.74609375, 0.79687500, 0.99609375 },
   { 0.74609375, 0.79296875, 0.99609375 },
   { 0.74609375, 0.78515625, 0.99609375 },
   { 0.74609375, 0.78125000, 0.99609375 },
   { 0.74609375, 0.77343750, 0.99609375 },
   { 0.74609375, 0.76953125, 0.99609375 },
   { 0.74609375, 0.76171875, 0.99609375 },
   { 0.74609375, 0.75781250, 0.99609375 },
   { 0.74609375, 0.75000000, 0.99609375 },
   { 0.74609375, 0.74609375, 0.99609375 },
   { 0.75000000, 0.74609375, 0.99609375 },
   { 0.75781250, 0.74609375, 0.99609375 },
   { 0.76171875, 0.74609375, 0.99609375 },
   { 0.76953125, 0.74609375, 0.99609375 },
   { 0.77343750, 0.74609375, 0.99609375 },
   { 0.78125000, 0.74609375, 0.99609375 },
   { 0.78515625, 0.74609375, 0.99609375 },
   { 0.79296875, 0.74609375, 0.99609375 },
   { 0.79687500, 0.74609375, 0.99609375 },
   { 0.80468750, 0.74609375, 0.99609375 },
   { 0.80859375, 0.74609375, 0.99609375 },
   { 0.81640625, 0.74609375, 0.99609375 },
   { 0.82031250, 0.74609375, 0.99609375 },
   { 0.82812500, 0.74609375, 0.99609375 },
   { 0.83203125, 0.74609375, 0.99609375 },
   { 0.83984375, 0.74609375, 0.99609375 },
   { 0.84375000, 0.74609375, 0.99609375 },
   { 0.85156250, 0.74609375, 0.99609375 },
   { 0.85546875, 0.74609375, 0.99609375 },
   { 0.86328125, 0.74609375, 0.99609375 },
   { 0.86718750, 0.74609375, 0.99609375 },
   { 0.87500000, 0.74609375, 0.99609375 },
   { 0.87890625, 0.74609375, 0.99609375 },
   { 0.88671875, 0.74609375, 0.99609375 },
   { 0.89062500, 0.74609375, 0.99609375 },
   { 0.89843750, 0.74609375, 0.99609375 },
   { 0.90234375, 0.74609375, 0.99609375 },
   { 0.91015625, 0.74609375, 0.99609375 },
   { 0.91406250, 0.74609375, 0.99609375 },
   { 0.92187500, 0.74609375, 0.99609375 },
   { 0.92578125, 0.74609375, 0.99609375 },
   { 0.93359375, 0.74609375, 0.99609375 },
   { 0.93750000, 0.74609375, 0.99609375 },
   { 0.94531250, 0.74609375, 0.99609375 },
   { 0.94921875, 0.74609375, 0.99609375 },
   { 0.95703125, 0.74609375, 0.99609375 },
   { 0.96093750, 0.74609375, 0.99609375 },
   { 0.96875000, 0.74609375, 0.99609375 },
   { 0.97265625, 0.74609375, 0.99609375 },
   { 0.98046875, 0.74609375, 0.99609375 },
   { 0.98437500, 0.74609375, 0.99609375 },
   { 0.99218750, 0.74609375, 0.99609375 },
   { 0.99609375, 0.74609375, 0.99218750 },
   { 0.99609375, 0.74609375, 0.98437500 },
   { 0.99609375, 0.74609375, 0.98046875 },
   { 0.99609375, 0.74609375, 0.97265625 },
   { 0.99609375, 0.74609375, 0.96875000 },
   { 0.99609375, 0.74609375, 0.96093750 },
   { 0.99609375, 0.74609375, 0.95703125 },
   { 0.99609375, 0.74609375, 0.94921875 },
   { 0.99609375, 0.74609375, 0.94531250 },
   { 0.99609375, 0.74609375, 0.93750000 },
   { 0.99609375, 0.74609375, 0.93359375 },
   { 0.99609375, 0.74609375, 0.92578125 },
   { 0.99609375, 0.74609375, 0.92187500 },
   { 0.99609375, 0.74609375, 0.91406250 },
   { 0.99609375, 0.74609375, 0.91015625 },
   { 0.99609375, 0.74609375, 0.90234375 },
   { 0.99609375, 0.74609375, 0.89843750 },
   { 0.99609375, 0.74609375, 0.89062500 },
   { 0.99609375, 0.74609375, 0.88671875 },
   { 0.99609375, 0.74609375, 0.87890625 },
   { 0.99609375, 0.74609375, 0.87500000 },
   { 0.99609375, 0.74609375, 0.86718750 },
   { 0.99609375, 0.74609375, 0.86328125 },
   { 0.99609375, 0.74609375, 0.85546875 },
   { 0.99609375, 0.74609375, 0.85156250 },
   { 0.99609375, 0.74609375, 0.84375000 },
   { 0.99609375, 0.74609375, 0.83984375 },
   { 0.99609375, 0.74609375, 0.83203125 },
   { 0.99609375, 0.74609375, 0.82812500 },
   { 0.99609375, 0.74609375, 0.82031250 },
   { 0.99609375, 0.74609375, 0.81640625 },
   { 0.99609375, 0.74609375, 0.80859375 },
   { 0.99609375, 0.74609375, 0.80468750 },
   { 0.99609375, 0.74609375, 0.79687500 },
   { 0.99609375, 0.74609375, 0.79296875 },
   { 0.99609375, 0.74609375, 0.78515625 },
   { 0.99609375, 0.74609375, 0.78125000 },
   { 0.99609375, 0.74609375, 0.77343750 },
   { 0.99609375, 0.74609375, 0.76953125 },
   { 0.99609375, 0.74609375, 0.76171875 },
   { 0.99609375, 0.74609375, 0.75781250 },
   { 0.99609375, 0.74609375, 0.75000000 },
   { 0.99609375, 0.74609375, 0.74609375 },
};

const int RGB_Palette_20_Size = 256; // gimp - TropicalColors
double RGB_Palette_20[RGB_Palette_20_Size][3] =
{
   { 0.03515625, 0.15625000, 0.01171875 },
   { 0.03515625, 0.16015625, 0.01171875 },
   { 0.03125000, 0.16796875, 0.01171875 },
   { 0.03125000, 0.17187500, 0.01171875 },
   { 0.03125000, 0.17968750, 0.01171875 },
   { 0.03125000, 0.18359375, 0.01171875 },
   { 0.02734375, 0.18750000, 0.01171875 },
   { 0.02734375, 0.19531250, 0.00781250 },
   { 0.02734375, 0.19921875, 0.00781250 },
   { 0.02734375, 0.20312500, 0.00781250 },
   { 0.02343750, 0.21093750, 0.00781250 },
   { 0.02343750, 0.21484375, 0.00781250 },
   { 0.02343750, 0.21875000, 0.00781250 },
   { 0.01953125, 0.22656250, 0.00781250 },
   { 0.01953125, 0.23046875, 0.00390625 },
   { 0.01953125, 0.24218750, 0.00390625 },
   { 0.01562500, 0.25000000, 0.00390625 },
   { 0.01562500, 0.26171875, 0.00390625 },
   { 0.01171875, 0.26953125, 0.00000000 },
   { 0.01171875, 0.28125000, 0.00000000 },
   { 0.00781250, 0.28906250, 0.00000000 },
   { 0.00781250, 0.30078125, 0.00000000 },
   { 0.00781250, 0.30859375, 0.00000000 },
   { 0.01562500, 0.32031250, 0.00390625 },
   { 0.02343750, 0.32812500, 0.00390625 },
   { 0.02734375, 0.33984375, 0.00781250 },
   { 0.03515625, 0.34765625, 0.01171875 },
   { 0.04296875, 0.35937500, 0.01562500 },
   { 0.05078125, 0.36718750, 0.01953125 },
   { 0.05468750, 0.37890625, 0.01953125 },
   { 0.06250000, 0.38671875, 0.02343750 },
   { 0.07031250, 0.39843750, 0.02734375 },
   { 0.07812500, 0.40625000, 0.03125000 },
   { 0.08203125, 0.41796875, 0.03515625 },
   { 0.08984375, 0.42578125, 0.03515625 },
   { 0.09765625, 0.43750000, 0.03906250 },
   { 0.10546875, 0.44531250, 0.04296875 },
   { 0.10937500, 0.45703125, 0.04687500 },
   { 0.11718750, 0.46484375, 0.04687500 },
   { 0.12500000, 0.47265625, 0.05078125 },
   { 0.12890625, 0.48437500, 0.05468750 },
   { 0.13671875, 0.49218750, 0.05859375 },
   { 0.14453125, 0.50390625, 0.06250000 },
   { 0.15234375, 0.51171875, 0.06250000 },
   { 0.15625000, 0.51953125, 0.06640625 },
   { 0.16406250, 0.53125000, 0.07031250 },
   { 0.17187500, 0.53906250, 0.07421875 },
   { 0.17578125, 0.55078125, 0.07421875 },
   { 0.18359375, 0.55859375, 0.07812500 },
   { 0.19140625, 0.56640625, 0.08203125 },
   { 0.21484375, 0.57812500, 0.08593750 },
   { 0.25000000, 0.58593750, 0.08984375 },
   { 0.28515625, 0.59375000, 0.09765625 },
   { 0.32031250, 0.60156250, 0.10156250 },
   { 0.35546875, 0.60937500, 0.10546875 },
   { 0.39453125, 0.62109375, 0.11328125 },
   { 0.42968750, 0.62890625, 0.11718750 },
   { 0.46484375, 0.63671875, 0.12109375 },
   { 0.50000000, 0.64453125, 0.12890625 },
   { 0.53515625, 0.65234375, 0.13281250 },
   { 0.57031250, 0.66015625, 0.13671875 },
   { 0.60156250, 0.66796875, 0.14453125 },
   { 0.63671875, 0.67968750, 0.14843750 },
   { 0.66796875, 0.68750000, 0.15234375 },
   { 0.70312500, 0.69531250, 0.15625000 },
   { 0.73437500, 0.70312500, 0.16406250 },
   { 0.76953125, 0.71093750, 0.16796875 },
   { 0.80078125, 0.71875000, 0.17187500 },
   { 0.83593750, 0.72656250, 0.17578125 },
   { 0.86718750, 0.73437500, 0.18359375 },
   { 0.90234375, 0.74218750, 0.18750000 },
   { 0.91796875, 0.73828125, 0.18750000 },
   { 0.92187500, 0.71875000, 0.18750000 },
   { 0.92187500, 0.70312500, 0.18359375 },
   { 0.92187500, 0.68359375, 0.18359375 },
   { 0.92187500, 0.66406250, 0.17968750 },
   { 0.92578125, 0.64843750, 0.17968750 },
   { 0.92578125, 0.62890625, 0.17578125 },
   { 0.92578125, 0.61328125, 0.17578125 },
   { 0.92578125, 0.59375000, 0.17187500 },
   { 0.92968750, 0.57421875, 0.16796875 },
   { 0.92968750, 0.55859375, 0.16796875 },
   { 0.92968750, 0.53906250, 0.16406250 },
   { 0.93359375, 0.52343750, 0.16406250 },
   { 0.93359375, 0.50390625, 0.16015625 },
   { 0.93359375, 0.48437500, 0.16015625 },
   { 0.93359375, 0.46875000, 0.15625000 },
   { 0.93750000, 0.44921875, 0.15625000 },
   { 0.93750000, 0.43359375, 0.15234375 },
   { 0.93750000, 0.41406250, 0.15234375 },
   { 0.93750000, 0.39453125, 0.14843750 },
   { 0.94140625, 0.37890625, 0.14453125 },
   { 0.94140625, 0.35937500, 0.14453125 },
   { 0.94140625, 0.34375000, 0.14062500 },
   { 0.94531250, 0.32421875, 0.14062500 },
   { 0.94531250, 0.30468750, 0.13671875 },
   { 0.94531250, 0.28906250, 0.13671875 },
   { 0.94531250, 0.26953125, 0.13281250 },
   { 0.94921875, 0.25390625, 0.13281250 },
   { 0.94921875, 0.23828125, 0.12890625 },
   { 0.94140625, 0.23828125, 0.13281250 },
   { 0.93359375, 0.23828125, 0.13281250 },
   { 0.92578125, 0.24218750, 0.13671875 },
   { 0.92187500, 0.24218750, 0.13671875 },
   { 0.91406250, 0.24218750, 0.13671875 },
   { 0.90625000, 0.24609375, 0.14062500 },
   { 0.90234375, 0.24609375, 0.14062500 },
   { 0.89453125, 0.24609375, 0.14453125 },
   { 0.88671875, 0.25000000, 0.14453125 },
   { 0.87890625, 0.25000000, 0.14453125 },
   { 0.87500000, 0.25000000, 0.14843750 },
   { 0.86718750, 0.25390625, 0.14843750 },
   { 0.85937500, 0.25390625, 0.15234375 },
   { 0.85546875, 0.25390625, 0.15234375 },
   { 0.84765625, 0.25781250, 0.15625000 },
   { 0.83984375, 0.25781250, 0.15625000 },
   { 0.83203125, 0.25781250, 0.15625000 },
   { 0.82812500, 0.26171875, 0.16015625 },
   { 0.82031250, 0.26171875, 0.16015625 },
   { 0.81250000, 0.26171875, 0.16406250 },
   { 0.80859375, 0.26171875, 0.16406250 },
   { 0.80078125, 0.26562500, 0.16796875 },
   { 0.79296875, 0.26562500, 0.16796875 },
   { 0.78515625, 0.26562500, 0.16796875 },
   { 0.78125000, 0.26953125, 0.17187500 },
   { 0.77343750, 0.26953125, 0.17187500 },
   { 0.76562500, 0.26953125, 0.17578125 },
   { 0.75781250, 0.27343750, 0.17578125 },
   { 0.75390625, 0.27343750, 0.17578125 },
   { 0.74609375, 0.27343750, 0.17968750 },
   { 0.73828125, 0.27734375, 0.17968750 },
   { 0.72265625, 0.27734375, 0.18359375 },
   { 0.70703125, 0.28125000, 0.18750000 },
   { 0.68750000, 0.28515625, 0.19531250 },
   { 0.66796875, 0.28906250, 0.19921875 },
   { 0.64843750, 0.29296875, 0.20312500 },
   { 0.63281250, 0.29687500, 0.20703125 },
   { 0.61328125, 0.30078125, 0.21093750 },
   { 0.59375000, 0.30468750, 0.21484375 },
   { 0.57421875, 0.30859375, 0.22265625 },
   { 0.55859375, 0.30859375, 0.22656250 },
   { 0.53906250, 0.31250000, 0.23046875 },
   { 0.52734375, 0.31640625, 0.24218750 },
   { 0.52343750, 0.31640625, 0.26953125 },
   { 0.52343750, 0.31250000, 0.29687500 },
   { 0.51953125, 0.31250000, 0.32421875 },
   { 0.51562500, 0.31250000, 0.34765625 },
   { 0.51562500, 0.31250000, 0.37500000 },
   { 0.51171875, 0.31250000, 0.40234375 },
   { 0.51171875, 0.30859375, 0.42968750 },
   { 0.50781250, 0.30859375, 0.45703125 },
   { 0.50781250, 0.30859375, 0.48437500 },
   { 0.50390625, 0.30859375, 0.51171875 },
   { 0.50390625, 0.30859375, 0.53906250 },
   { 0.50000000, 0.30468750, 0.56250000 },
   { 0.50000000, 0.30468750, 0.58984375 },
   { 0.49609375, 0.30468750, 0.61718750 },
   { 0.49609375, 0.30468750, 0.64453125 },
   { 0.49218750, 0.30078125, 0.67187500 },
   { 0.49218750, 0.30078125, 0.69921875 },
   { 0.48828125, 0.30078125, 0.72656250 },
   { 0.48828125, 0.30078125, 0.75390625 },
   { 0.48437500, 0.30078125, 0.77734375 },
   { 0.48437500, 0.29687500, 0.80468750 },
   { 0.48046875, 0.29687500, 0.83203125 },
   { 0.48046875, 0.29687500, 0.85937500 },
   { 0.47656250, 0.29687500, 0.88671875 },
   { 0.47656250, 0.29687500, 0.91406250 },
   { 0.47265625, 0.29296875, 0.94140625 },
   { 0.47265625, 0.29296875, 0.96875000 },
   { 0.46875000, 0.29296875, 0.99218750 },
   { 0.47265625, 0.30468750, 0.99218750 },
   { 0.47656250, 0.32031250, 0.99218750 },
   { 0.47656250, 0.33203125, 0.99218750 },
   { 0.48046875, 0.34375000, 0.99218750 },
   { 0.48437500, 0.35546875, 0.99218750 },
   { 0.48828125, 0.37109375, 0.98828125 },
   { 0.49218750, 0.38281250, 0.98828125 },
   { 0.49218750, 0.39453125, 0.98828125 },
   { 0.49609375, 0.41015625, 0.98828125 },
   { 0.50000000, 0.42187500, 0.98828125 },
   { 0.50390625, 0.43359375, 0.98437500 },
   { 0.50781250, 0.44921875, 0.98437500 },
   { 0.51171875, 0.46093750, 0.98437500 },
   { 0.51171875, 0.47265625, 0.98437500 },
   { 0.51562500, 0.48828125, 0.98437500 },
   { 0.51953125, 0.50000000, 0.98046875 },
   { 0.52343750, 0.51171875, 0.98046875 },
   { 0.52734375, 0.52734375, 0.98046875 },
   { 0.52734375, 0.53906250, 0.98046875 },
   { 0.53125000, 0.55078125, 0.98046875 },
   { 0.53515625, 0.56250000, 0.97656250 },
   { 0.53906250, 0.57812500, 0.97656250 },
   { 0.54296875, 0.58984375, 0.97656250 },
   { 0.54296875, 0.60156250, 0.97656250 },
   { 0.54687500, 0.61718750, 0.97656250 },
   { 0.55078125, 0.62890625, 0.97265625 },
   { 0.55468750, 0.64062500, 0.97265625 },
   { 0.55859375, 0.66796875, 0.97265625 },
   { 0.56640625, 0.69140625, 0.96875000 },
   { 0.57421875, 0.71875000, 0.96875000 },
   { 0.57812500, 0.74218750, 0.96875000 },
   { 0.58593750, 0.76953125, 0.96484375 },
   { 0.58984375, 0.79687500, 0.96484375 },
   { 0.59765625, 0.82031250, 0.96093750 },
   { 0.60546875, 0.84765625, 0.96093750 },
   { 0.60937500, 0.87109375, 0.96093750 },
   { 0.61718750, 0.89843750, 0.95703125 },
   { 0.62109375, 0.92578125, 0.95703125 },
   { 0.62890625, 0.94921875, 0.95312500 },
   { 0.63671875, 0.97656250, 0.95312500 },
   { 0.63671875, 0.99218750, 0.94140625 },
   { 0.62500000, 0.98437500, 0.91015625 },
   { 0.61328125, 0.98046875, 0.87500000 },
   { 0.60156250, 0.97265625, 0.84375000 },
   { 0.58984375, 0.96875000, 0.80859375 },
   { 0.57812500, 0.96093750, 0.77734375 },
   { 0.56640625, 0.95312500, 0.74609375 },
   { 0.55468750, 0.94921875, 0.71093750 },
   { 0.54296875, 0.94140625, 0.67968750 },
   { 0.53515625, 0.93359375, 0.64453125 },
   { 0.51953125, 0.92968750, 0.60937500 },
   { 0.49609375, 0.91406250, 0.53906250 },
   { 0.47265625, 0.90234375, 0.46484375 },
   { 0.44531250, 0.88671875, 0.39453125 },
   { 0.42187500, 0.87500000, 0.32031250 },
   { 0.40625000, 0.86328125, 0.27343750 },
   { 0.40625000, 0.85937500, 0.26953125 },
   { 0.40234375, 0.85156250, 0.26562500 },
   { 0.40234375, 0.84375000, 0.26171875 },
   { 0.40234375, 0.83593750, 0.25390625 },
   { 0.40234375, 0.82812500, 0.24609375 },
   { 0.39843750, 0.81640625, 0.23828125 },
   { 0.39843750, 0.80468750, 0.23046875 },
   { 0.39843750, 0.79687500, 0.22265625 },
   { 0.39453125, 0.78515625, 0.21484375 },
   { 0.39453125, 0.77343750, 0.20703125 },
   { 0.39062500, 0.76171875, 0.19531250 },
   { 0.39062500, 0.75000000, 0.18750000 },
   { 0.39062500, 0.73437500, 0.17968750 },
   { 0.38671875, 0.72265625, 0.16796875 },
   { 0.38671875, 0.71093750, 0.16015625 },
   { 0.38281250, 0.69531250, 0.14843750 },
   { 0.38281250, 0.67968750, 0.13671875 },
   { 0.38281250, 0.66796875, 0.12500000 },
   { 0.37890625, 0.65234375, 0.11718750 },
   { 0.37890625, 0.63671875, 0.10546875 },
   { 0.37500000, 0.62500000, 0.09375000 },
   { 0.37500000, 0.60937500, 0.08203125 },
   { 0.37109375, 0.59375000, 0.07031250 },
   { 0.37109375, 0.57812500, 0.05859375 },
   { 0.36718750, 0.56250000, 0.04687500 },
   { 0.36718750, 0.54687500, 0.03515625 },
   { 0.36328125, 0.52734375, 0.02343750 },
   { 0.36328125, 0.51171875, 0.01171875 },
   { 0.35937500, 0.49609375, 0.00000000 },
};

const int RGB_Palette_21_Size = 256; // gimp - Wood2
double RGB_Palette_21[RGB_Palette_21_Size][3] =
{
   { 0.99609375, 0.69531250, 0.39843750 },
   { 0.98046875, 0.67578125, 0.36718750 },
   { 0.97656250, 0.66796875, 0.35937500 },
   { 0.97265625, 0.66015625, 0.35156250 },
   { 0.96875000, 0.65625000, 0.34375000 },
   { 0.96484375, 0.65234375, 0.33593750 },
   { 0.96093750, 0.64843750, 0.33203125 },
   { 0.96093750, 0.64453125, 0.32812500 },
   { 0.95703125, 0.64062500, 0.32421875 },
   { 0.95703125, 0.63671875, 0.32031250 },
   { 0.95312500, 0.63671875, 0.31640625 },
   { 0.95312500, 0.63281250, 0.31250000 },
   { 0.95312500, 0.62890625, 0.30859375 },
   { 0.94921875, 0.62890625, 0.30859375 },
   { 0.94921875, 0.62500000, 0.30468750 },
   { 0.94921875, 0.62500000, 0.30468750 },
   { 0.94531250, 0.62500000, 0.30078125 },
   { 0.94531250, 0.62109375, 0.29687500 },
   { 0.94531250, 0.62109375, 0.29687500 },
   { 0.94531250, 0.62109375, 0.29687500 },
   { 0.94140625, 0.61718750, 0.29296875 },
   { 0.94140625, 0.61718750, 0.29296875 },
   { 0.94140625, 0.61718750, 0.29296875 },
   { 0.94140625, 0.61718750, 0.28906250 },
   { 0.94140625, 0.61328125, 0.28906250 },
   { 0.94140625, 0.61328125, 0.28906250 },
   { 0.94140625, 0.61328125, 0.28906250 },
   { 0.94140625, 0.61328125, 0.28906250 },
   { 0.94140625, 0.61328125, 0.28515625 },
   { 0.93750000, 0.61328125, 0.28515625 },
   { 0.93750000, 0.61328125, 0.28515625 },
   { 0.93750000, 0.61328125, 0.28515625 },
   { 0.80468750, 0.52343750, 0.24218750 },
   { 0.82812500, 0.53515625, 0.24609375 },
   { 0.83984375, 0.54296875, 0.24609375 },
   { 0.85156250, 0.54687500, 0.24609375 },
   { 0.85937500, 0.55468750, 0.24609375 },
   { 0.86328125, 0.55468750, 0.25000000 },
   { 0.87109375, 0.55859375, 0.25000000 },
   { 0.87500000, 0.56250000, 0.25000000 },
   { 0.87890625, 0.56640625, 0.25000000 },
   { 0.88671875, 0.56640625, 0.25000000 },
   { 0.89062500, 0.57031250, 0.25000000 },
   { 0.89062500, 0.57031250, 0.25000000 },
   { 0.89453125, 0.57421875, 0.25000000 },
   { 0.89843750, 0.57421875, 0.25000000 },
   { 0.90234375, 0.57812500, 0.25390625 },
   { 0.90234375, 0.57812500, 0.25390625 },
   { 0.90625000, 0.57812500, 0.25390625 },
   { 0.91015625, 0.58203125, 0.25390625 },
   { 0.91015625, 0.58203125, 0.25390625 },
   { 0.91406250, 0.58203125, 0.25390625 },
   { 0.91406250, 0.58203125, 0.25390625 },
   { 0.91406250, 0.58593750, 0.25390625 },
   { 0.91796875, 0.58593750, 0.25390625 },
   { 0.91796875, 0.58593750, 0.25390625 },
   { 0.91796875, 0.58593750, 0.25390625 },
   { 0.92187500, 0.58593750, 0.25390625 },
   { 0.92187500, 0.58593750, 0.25390625 },
   { 0.92187500, 0.58593750, 0.25390625 },
   { 0.92187500, 0.58984375, 0.25390625 },
   { 0.92187500, 0.58984375, 0.25390625 },
   { 0.92187500, 0.58984375, 0.25390625 },
   { 0.92187500, 0.58984375, 0.25390625 },
   { 0.82812500, 0.52734375, 0.22656250 },
   { 0.84375000, 0.53515625, 0.23046875 },
   { 0.85156250, 0.54296875, 0.23046875 },
   { 0.85937500, 0.54687500, 0.23046875 },
   { 0.86718750, 0.55078125, 0.23046875 },
   { 0.87109375, 0.55078125, 0.23437500 },
   { 0.87500000, 0.55468750, 0.23437500 },
   { 0.87890625, 0.55859375, 0.23437500 },
   { 0.88281250, 0.55859375, 0.23437500 },
   { 0.88671875, 0.56250000, 0.23437500 },
   { 0.89062500, 0.56250000, 0.23437500 },
   { 0.89062500, 0.56640625, 0.23828125 },
   { 0.89453125, 0.56640625, 0.23828125 },
   { 0.89843750, 0.56640625, 0.23828125 },
   { 0.89843750, 0.57031250, 0.23828125 },
   { 0.90234375, 0.57031250, 0.23828125 },
   { 0.90234375, 0.57031250, 0.23828125 },
   { 0.90625000, 0.57031250, 0.23828125 },
   { 0.90625000, 0.57421875, 0.23828125 },
   { 0.91015625, 0.57421875, 0.23828125 },
   { 0.91015625, 0.57421875, 0.23828125 },
   { 0.91015625, 0.57421875, 0.23828125 },
   { 0.91015625, 0.57421875, 0.23828125 },
   { 0.91406250, 0.57812500, 0.23828125 },
   { 0.91406250, 0.57812500, 0.23828125 },
   { 0.91406250, 0.57812500, 0.23828125 },
   { 0.91406250, 0.57812500, 0.24218750 },
   { 0.91406250, 0.57812500, 0.24218750 },
   { 0.91406250, 0.57812500, 0.24218750 },
   { 0.91796875, 0.57812500, 0.24218750 },
   { 0.91796875, 0.57812500, 0.24218750 },
   { 0.91796875, 0.57812500, 0.24218750 },
   { 0.78906250, 0.49609375, 0.20703125 },
   { 0.80859375, 0.50781250, 0.21093750 },
   { 0.82031250, 0.51953125, 0.21484375 },
   { 0.83203125, 0.52343750, 0.21484375 },
   { 0.83984375, 0.53125000, 0.21875000 },
   { 0.84765625, 0.53515625, 0.21875000 },
   { 0.85546875, 0.53906250, 0.22265625 },
   { 0.85937500, 0.54296875, 0.22265625 },
   { 0.86718750, 0.54687500, 0.22656250 },
   { 0.87109375, 0.54687500, 0.22656250 },
   { 0.87500000, 0.55078125, 0.22656250 },
   { 0.87890625, 0.55468750, 0.22656250 },
   { 0.88281250, 0.55468750, 0.23046875 },
   { 0.88671875, 0.55859375, 0.23046875 },
   { 0.89062500, 0.55859375, 0.23046875 },
   { 0.89453125, 0.56250000, 0.23046875 },
   { 0.89453125, 0.56250000, 0.23046875 },
   { 0.89843750, 0.56640625, 0.23046875 },
   { 0.89843750, 0.56640625, 0.23437500 },
   { 0.90234375, 0.56640625, 0.23437500 },
   { 0.90625000, 0.57031250, 0.23437500 },
   { 0.90625000, 0.57031250, 0.23437500 },
   { 0.90625000, 0.57031250, 0.23437500 },
   { 0.91015625, 0.57031250, 0.23437500 },
   { 0.91015625, 0.57421875, 0.23437500 },
   { 0.91015625, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.91406250, 0.57421875, 0.23437500 },
   { 0.77343750, 0.48828125, 0.19921875 },
   { 0.77343750, 0.48828125, 0.19921875 },
   { 0.77343750, 0.48828125, 0.19921875 },
   { 0.77734375, 0.48828125, 0.19921875 },
   { 0.77734375, 0.48828125, 0.19921875 },
   { 0.77734375, 0.48828125, 0.19921875 },
   { 0.77734375, 0.48828125, 0.19921875 },
   { 0.77734375, 0.48828125, 0.19921875 },
   { 0.78125000, 0.49218750, 0.20312500 },
   { 0.78125000, 0.49218750, 0.20312500 },
   { 0.78125000, 0.49218750, 0.20312500 },
   { 0.78515625, 0.49218750, 0.20312500 },
   { 0.78515625, 0.49218750, 0.20312500 },
   { 0.78515625, 0.49609375, 0.20312500 },
   { 0.78906250, 0.49609375, 0.20312500 },
   { 0.78906250, 0.49609375, 0.20312500 },
   { 0.79296875, 0.50000000, 0.20312500 },
   { 0.79687500, 0.50000000, 0.20703125 },
   { 0.79687500, 0.50000000, 0.20703125 },
   { 0.80078125, 0.50390625, 0.20703125 },
   { 0.80468750, 0.50390625, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81640625, 0.51171875, 0.21093750 },
   { 0.82031250, 0.51562500, 0.21093750 },
   { 0.82421875, 0.51953125, 0.21093750 },
   { 0.82812500, 0.52343750, 0.21484375 },
   { 0.83593750, 0.52734375, 0.21484375 },
   { 0.84375000, 0.53125000, 0.21875000 },
   { 0.85156250, 0.53515625, 0.21875000 },
   { 0.86328125, 0.54296875, 0.22265625 },
   { 0.87890625, 0.55468750, 0.22656250 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80468750, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.20703125 },
   { 0.80859375, 0.50781250, 0.21093750 },
   { 0.80859375, 0.50781250, 0.21093750 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81250000, 0.51171875, 0.21093750 },
   { 0.81640625, 0.51171875, 0.21093750 },
   { 0.81640625, 0.51562500, 0.21093750 },
   { 0.81640625, 0.51562500, 0.21093750 },
   { 0.82031250, 0.51562500, 0.21093750 },
   { 0.82031250, 0.51562500, 0.21093750 },
   { 0.82421875, 0.51953125, 0.21093750 },
   { 0.82421875, 0.51953125, 0.21484375 },
   { 0.82812500, 0.51953125, 0.21484375 },
   { 0.83203125, 0.52343750, 0.21484375 },
   { 0.83203125, 0.52343750, 0.21484375 },
   { 0.83984375, 0.52734375, 0.21875000 },
   { 0.75390625, 0.47656250, 0.19531250 },
   { 0.75390625, 0.47656250, 0.19531250 },
   { 0.75390625, 0.47656250, 0.19531250 },
   { 0.75390625, 0.47656250, 0.19531250 },
   { 0.75390625, 0.47656250, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75390625, 0.47265625, 0.19531250 },
   { 0.75000000, 0.47265625, 0.19531250 },
   { 0.75000000, 0.47265625, 0.19531250 },
   { 0.75000000, 0.47265625, 0.19531250 },
   { 0.75000000, 0.47265625, 0.19531250 },
   { 0.75000000, 0.47265625, 0.19140625 },
   { 0.74609375, 0.46875000, 0.19140625 },
   { 0.74609375, 0.46875000, 0.19140625 },
   { 0.74609375, 0.46875000, 0.19140625 },
   { 0.74218750, 0.46875000, 0.19140625 },
   { 0.74218750, 0.46875000, 0.19140625 },
   { 0.74218750, 0.46484375, 0.19140625 },
   { 0.73828125, 0.46484375, 0.19140625 },
   { 0.73828125, 0.46484375, 0.19140625 },
   { 0.73437500, 0.46484375, 0.19140625 },
   { 0.73437500, 0.46093750, 0.18750000 },
   { 0.73046875, 0.46093750, 0.18750000 },
   { 0.73046875, 0.45703125, 0.18750000 },
   { 0.72656250, 0.45703125, 0.18750000 },
   { 0.72265625, 0.45312500, 0.18750000 },
   { 0.71875000, 0.45312500, 0.18359375 },
   { 0.70703125, 0.44531250, 0.18359375 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
   { 0.61718750, 0.38671875, 0.16015625 },
};

const int RGB_Palette_22_Size = 151; // Mars
double RGB_Palette_22[RGB_Palette_22_Size][3] =
{
   {0, 0, 0},
   {0, 0, 0},
   {0, 0, 0},
   {.00392156862745098039, 0, .00392156862745098039},
   {.01568627450980392156, .00784313725490196078, .01568627450980392156},
   {.02745098039215686274, .01568627450980392156, .02745098039215686274},
   {.03921568627450980392, .02745098039215686274, .03921568627450980392},
   {.05490196078431372549, .03137254901960784313, .05490196078431372549},
   {.08627450980392156862, .05490196078431372549, .09411764705882352941},
   {.13725490196078431372, .10588235294117647058, .16862745098039215686},
   {.19607843137254901960, .14901960784313725490, .24313725490196078431},
   {.25098039215686274509, .19607843137254901960, .31764705882352941176},
   {.30588235294117647058, .24313725490196078431, .39607843137254901960},
   {.32941176470588235294, .27058823529411764705, .45098039215686274509},
   {.32549019607843137254, .27843137254901960784, .48627450980392156862},
   {.32549019607843137254, .29019607843137254901, .52941176470588235294},
   {.31372549019607843137, .29411764705882352941, .56470588235294117647},
   {.30980392156862745098, .30196078431372549019, .60000000000000000000},
   {.30588235294117647058, .32156862745098039215, .63137254901960784313},
   {.29803921568627450980, .35294117647058823529, .65882352941176470588},
   {.29411764705882352941, .39215686274509803921, .68627450980392156862},
   {.28627450980392156862, .41960784313725490196, .70980392156862745098},
   {.27843137254901960784, .45098039215686274509, .72941176470588235294},
   {.26666666666666666666, .48627450980392156862, .75294117647058823529},
   {.25882352941176470588, .52549019607843137254, .78823529411764705882},
   {.24313725490196078431, .56078431372549019607, .80784313725490196078},
   {.23137254901960784313, .59215686274509803921, .83529411764705882352},
   {.22352941176470588235, .63137254901960784313, .85882352941176470588},
   {.21176470588235294117, .67058823529411764705, .83921568627450980392},
   {.21176470588235294117, .71764705882352941176, .77254901960784313725},
   {.21176470588235294117, .76078431372549019607, .70980392156862745098},
   {.21176470588235294117, .80784313725490196078, .64313725490196078431},
   {.21176470588235294117, .85098039215686274509, .57254901960784313725},
   {.21176470588235294117, .87058823529411764705, .51372549019607843137},
   {.21176470588235294117, .87450980392156862745, .45882352941176470588},
   {.21176470588235294117, .87058823529411764705, .40784313725490196078},
   {.21176470588235294117, .87450980392156862745, .34509803921568627450},
   {.21176470588235294117, .87058823529411764705, .29019607843137254901},
   {.23529411764705882352, .87058823529411764705, .25490196078431372549},
   {.27450980392156862745, .87450980392156862745, .24705882352941176470},
   {.31764705882352941176, .87058823529411764705, .23921568627450980392},
   {.36470588235294117647, .87450980392156862745, .22745098039215686274},
   {.40000000000000000000, .87058823529411764705, .21960784313725490196},
   {.46666666666666666666, .87058823529411764705, .19607843137254901960},
   {.56470588235294117647, .87450980392156862745, .16078431372549019607},
   {.64705882352941176470, .87058823529411764705, .12941176470588235294},
   {.73725490196078431372, .87450980392156862745, .09411764705882352941},
   {.82745098039215686274, .87058823529411764705, .05882352941176470588},
   {.87058823529411764705, .85490196078431372549, .04705882352941176470},
   {.87450980392156862745, .81176470588235294117, .05882352941176470588},
   {.87058823529411764705, .77647058823529411764, .07450980392156862745},
   {.87450980392156862745, .73725490196078431372, .08235294117647058823},
   {.87058823529411764705, .69803921568627450980, .09411764705882352941},
   {.87843137254901960784, .66666666666666666666, .11372549019607843137},
   {.89019607843137254901, .63137254901960784313, .13725490196078431372},
   {.90588235294117647058, .60392156862745098039, .16862745098039215686},
   {.91764705882352941176, .56862745098039215686, .18823529411764705882},
   {.92549019607843137254, .54117647058823529411, .21176470588235294117},
   {.93333333333333333333, .50196078431372549019, .22352941176470588235},
   {.93333333333333333333, .45490196078431372549, .21176470588235294117},
   {.94117647058823529411, .40784313725490196078, .20000000000000000000},
   {.93333333333333333333, .36470588235294117647, .18823529411764705882},
   {.93333333333333333333, .31764705882352941176, .17647058823529411764},
   {.93333333333333333333, .29803921568627450980, .19607843137254901960},
   {.93333333333333333333, .30980392156862745098, .23921568627450980392},
   {.94117647058823529411, .31764705882352941176, .27843137254901960784},
   {.93333333333333333333, .32941176470588235294, .32549019607843137254},
   {.93333333333333333333, .34117647058823529411, .37254901960784313725},
   {.92156862745098039215, .35294117647058823529, .40000000000000000000},
   {.89411764705882352941, .36078431372549019607, .41176470588235294117},
   {.87450980392156862745, .37254901960784313725, .43137254901960784313},
   {.84313725490196078431, .38039215686274509803, .44705882352941176470},
   {.82352941176470588235, .39607843137254901960, .46274509803921568627},
   {.80392156862745098039, .39607843137254901960, .45490196078431372549},
   {.78823529411764705882, .38823529411764705882, .43921568627450980392},
   {.77647058823529411764, .38431372549019607843, .41960784313725490196},
   {.76470588235294117647, .38039215686274509803, .40000000000000000000},
   {.74901960784313725490, .37254901960784313725, .37647058823529411764},
   {.72941176470588235294, .37254901960784313725, .36078431372549019607},
   {.70980392156862745098, .38431372549019607843, .35294117647058823529},
   {.68627450980392156862, .38823529411764705882, .34117647058823529411},
   {.65882352941176470588, .39607843137254901960, .32549019607843137254},
   {.63137254901960784313, .40000000000000000000, .30980392156862745098},
   {.61568627450980392156, .41176470588235294117, .30588235294117647058},
   {.60000000000000000000, .41960784313725490196, .30980392156862745098},
   {.59215686274509803921, .42745098039215686274, .31372549019607843137},
   {.57647058823529411764, .43921568627450980392, .30980392156862745098},
   {.56078431372549019607, .44705882352941176470, .30980392156862745098},
   {.54509803921568627450, .44705882352941176470, .30980392156862745098},
   {.53725490196078431372, .43529411764705882352, .30980392156862745098},
   {.52549019607843137254, .42352941176470588235, .31372549019607843137},
   {.50980392156862745098, .41176470588235294117, .30980392156862745098},
   {.50196078431372549019, .40784313725490196078, .30588235294117647058},
   {.49019607843137254901, .39607843137254901960, .30980392156862745098},
   {.47843137254901960784, .38823529411764705882, .31372549019607843137},
   {.47058823529411764705, .38823529411764705882, .32156862745098039215},
   {.45882352941176470588, .38431372549019607843, .32549019607843137254},
   {.44705882352941176470, .38039215686274509803, .32941176470588235294},
   {.44705882352941176470, .38039215686274509803, .34117647058823529411},
   {.45882352941176470588, .39215686274509803921, .35294117647058823529},
   {.47058823529411764705, .40000000000000000000, .36470588235294117647},
   {.47843137254901960784, .40784313725490196078, .37647058823529411764},
   {.49019607843137254901, .41568627450980392156, .39607843137254901960},
   {.49803921568627450980, .42745098039215686274, .40784313725490196078},
   {.50588235294117647058, .43921568627450980392, .41960784313725490196},
   {.52156862745098039215, .45098039215686274509, .43921568627450980392},
   {.52549019607843137254, .45882352941176470588, .45098039215686274509},
   {.53333333333333333333, .47058823529411764705, .47058823529411764705},
   {.54509803921568627450, .48627450980392156862, .48627450980392156862},
   {.55686274509803921568, .49803921568627450980, .49803921568627450980},
   {.56862745098039215686, .51764705882352941176, .51764705882352941176},
   {.57647058823529411764, .53333333333333333333, .53333333333333333333},
   {.58823529411764705882, .54509803921568627450, .54509803921568627450},
   {.59607843137254901960, .56078431372549019607, .56078431372549019607},
   {.60392156862745098039, .58039215686274509803, .58039215686274509803},
   {.61568627450980392156, .60000000000000000000, .60000000000000000000},
   {.62745098039215686274, .61568627450980392156, .61568627450980392156},
   {.63529411764705882352, .63529411764705882352, .63529411764705882352},
   {.64705882352941176470, .64705882352941176470, .64705882352941176470},
   {.65882352941176470588, .65882352941176470588, .65882352941176470588},
   {.66666666666666666666, .66666666666666666666, .66666666666666666666},
   {.67450980392156862745, .67450980392156862745, .67450980392156862745},
   {.68627450980392156862, .68627450980392156862, .68627450980392156862},
   {.69803921568627450980, .69803921568627450980, .69803921568627450980},
   {.70980392156862745098, .70980392156862745098, .70980392156862745098},
   {.71764705882352941176, .71764705882352941176, .71764705882352941176},
   {.73333333333333333333, .73333333333333333333, .73333333333333333333},
   {.73725490196078431372, .73725490196078431372, .73725490196078431372},
   {.74901960784313725490, .74901960784313725490, .74901960784313725490},
   {.76078431372549019607, .76078431372549019607, .76078431372549019607},
   {.76862745098039215686, .76862745098039215686, .76862745098039215686},
   {.77647058823529411764, .77647058823529411764, .77647058823529411764},
   {.78823529411764705882, .78823529411764705882, .78823529411764705882},
   {.80000000000000000000, .80000000000000000000, .80000000000000000000},
   {.80392156862745098039, .80392156862745098039, .80392156862745098039},
   {.81568627450980392156, .81568627450980392156, .81568627450980392156},
   {.82745098039215686274, .82745098039215686274, .82745098039215686274},
   {.83921568627450980392, .83921568627450980392, .83921568627450980392},
   {.84705882352941176470, .84705882352941176470, .84705882352941176470},
   {.85882352941176470588, .85882352941176470588, .85882352941176470588},
   {.86666666666666666666, .86666666666666666666, .86666666666666666666},
   {.87843137254901960784, .87843137254901960784, .87843137254901960784},
   {.89019607843137254901, .89019607843137254901, .89019607843137254901},
   {.90196078431372549019, .90196078431372549019, .90196078431372549019},
   {.90980392156862745098, .90980392156862745098, .90980392156862745098},
   {.92156862745098039215, .92156862745098039215, .92156862745098039215},
   {.93333333333333333333, .93333333333333333333, .93333333333333333333},
   {.94117647058823529411, .94117647058823529411, .94117647058823529411},
   {.94901960784313725490, .94901960784313725490, .94901960784313725490},
   {.94901960784313725490, .94901960784313725490, .94901960784313725490},
   {.94901960784313725490, .94901960784313725490, .94901960784313725490},
};

const int RGB_Palette_23_Size = 6*32+1; // rainbow
double RGB_Palette_23[RGB_Palette_23_Size][3];

const int RGB_Palette_24_Size = 31; // CMYK
double RGB_Palette_24[RGB_Palette_24_Size][3] =
{
   // 16 colors
   /*
     {0.300725, 0.680491, 0.901701}, {0.386403, 0.743518, 0.934237},
     {0.496414, 0.645794, 0.86504},  {0.604318, 0.51771,  0.780231},
     {0.699224, 0.432157, 0.70669},  {0.778582, 0.417821, 0.644854},
     {0.843122, 0.472052, 0.589251}, {0.893588, 0.572795, 0.538951},
     {0.928891, 0.68909,  0.500098}, {0.945344, 0.789625, 0.482689},
     {0.936608, 0.84884,  0.493779}, {0.894001, 0.850082, 0.529271},
     {0.806801, 0.785304, 0.566474}, {0.662204, 0.650797, 0.559579},
     {0.444557, 0.438462, 0.440244}, {0.133532, 0.122103, 0.125444}
   */
   // 31 colors
   {0.300725, 0.680491, 0.901701}, {0.343564, 0.712004, 0.917969},
   {0.386403, 0.743518, 0.934237}, {0.441409, 0.694656, 0.899639},
   {0.496414, 0.645794, 0.86504},  {0.550366, 0.581752, 0.822636},
   {0.604318, 0.51771,  0.780231}, {0.651771, 0.474934, 0.743461},
   {0.699224, 0.432157, 0.70669},  {0.738903, 0.424989, 0.675772},
   {0.778582, 0.417821, 0.644854}, {0.810852, 0.444937, 0.617053},
   {0.843122, 0.472052, 0.589251}, {0.868355, 0.522424, 0.564101},
   {0.893588, 0.572795, 0.538951}, {0.91124,  0.630943, 0.519525},
   {0.928891, 0.68909,  0.500098}, {0.937118, 0.739358, 0.491394},
   {0.945344, 0.789625, 0.482689}, {0.940976, 0.819233, 0.488234},
   {0.936608, 0.84884,  0.493779}, {0.915305, 0.849461, 0.511525},
   {0.894001, 0.850082, 0.529271}, {0.850401, 0.817693, 0.547873},
   {0.806801, 0.785304, 0.566474}, {0.734503, 0.71805,  0.563027},
   {0.662204, 0.650797, 0.559579}, {0.553381, 0.54463,  0.499912},
   {0.444557, 0.438462, 0.440244}, {0.289045, 0.280283, 0.282844},
   {0.133532, 0.122103, 0.125444}
};

const int RGB_Palette_25_Size = (4*16+1); // visit's calewhite
double RGB_Palette_25[RGB_Palette_25_Size][3];

const int Num_RGB_Palettes = 25;
const int RGB_Palettes_Sizes[Num_RGB_Palettes] =
{
   RGB_Palette_1_Size, RGB_Palette_2_Size, RGB_Palette_3_Size,
   RGB_Palette_4_Size, RGB_Palette_5_Size, RGB_Palette_6_Size,
   RGB_Palette_7_Size, RGB_Palette_8_Size, RGB_Palette_9_Size,
   RGB_Palette_10_Size, RGB_Palette_11_Size, RGB_Palette_12_Size,
   RGB_Palette_13_Size, RGB_Palette_14_Size, RGB_Palette_15_Size,
   RGB_Palette_16_Size, RGB_Palette_17_Size, RGB_Palette_18_Size,
   RGB_Palette_19_Size, RGB_Palette_20_Size, RGB_Palette_21_Size,
   RGB_Palette_22_Size, RGB_Palette_23_Size, RGB_Palette_24_Size,
   RGB_Palette_25_Size
};

double *RGB_Palettes[Num_RGB_Palettes] =
{
   *RGB_Palette_1, *RGB_Palette_2, *RGB_Palette_3, *RGB_Palette_4,
   *RGB_Palette_5, *RGB_Palette_6, *RGB_Palette_7, *RGB_Palette_8,
   *RGB_Palette_9, *RGB_Palette_10, *RGB_Palette_11, *RGB_Palette_12,
   *RGB_Palette_13, *RGB_Palette_14, *RGB_Palette_15, *RGB_Palette_16,
   *RGB_Palette_17, *RGB_Palette_18, *RGB_Palette_19, *RGB_Palette_20,
   *RGB_Palette_21, *RGB_Palette_22, *RGB_Palette_23, *RGB_Palette_24,
   *RGB_Palette_25
};

const char *RGB_Palettes_Names[Num_RGB_Palettes] =
{
   //  0123456789
   "5-color   ", "red       ", "jet-like  ", "golden    ", "bone      ",
   "hot       ", "pink      ", "cool      ", "summer    ", "hsv       ",
   "copper    ", "white     ", "vivid     ", "aluminum  ", "sunrise   ",
   "horizon   ", "hilite    ", "deep sea  ", "pastel    ", "tropical  ",
   "wood      ", "mars      ", "rainbow   ", "cmyk      ", "calewhite "
};

int Default_RGB_Palette = 2;
int RGB_Palette_Size = RGB_Palettes_Sizes[Default_RGB_Palette];
double *RGB_Palette = RGB_Palettes[Default_RGB_Palette];

double corr(double a, double x)
{
   return x / (1.0 + (a * a - 1.0) * (1.0 - x));
   //   return pow(x, a);
}

void Init_Visit_Calewhite_Palette()
{
   const int ns = 7;
   const double ts[ns] = { 0., 1./6., 2./6., 3./6., 4./6., 5./6., 1. };

   const double rs[ns] = { 1.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0 };
   const double gs[ns] = { 1.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0 };
   const double bs[ns] = { 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0 };
   const double rc[ns-1] = { 1.0, 1.0, 1.0, 1.0, 1.0, 1.0 };
   const double gc[ns-1] = { 1.0, 1.0, 1.0, 1.0, 1.0, 1.0 };
   const double bc[ns-1] = { 1.0, 1.0, 1.0, 1.0, 1.0, 1.0 };

   for (int i = 0; i < RGB_Palette_25_Size; i++)
   {
      double t = double(i) / (RGB_Palette_25_Size-1), r, g, b;
      int k;
      for (k = 1; k < ns; k++)
         if (t >= ts[k-1] && t <= ts[k])
         {
            break;
         }
      t = (t - ts[k-1]) / (ts[k] - ts[k-1]);
      r = (1.0 - t) * corr(rc[k-1], rs[k-1]) + t * corr(rc[k-1], rs[k]);
      g = (1.0 - t) * corr(gc[k-1], gs[k-1]) + t * corr(gc[k-1], gs[k]);
      b = (1.0 - t) * corr(bc[k-1], bs[k-1]) + t * corr(bc[k-1], bs[k]);
      RGB_Palette_25[i][0] = corr(1./rc[k-1], r);
      RGB_Palette_25[i][1] = corr(1./gc[k-1], g);
      RGB_Palette_25[i][2] = corr(1./bc[k-1], b);
   }
}

void Init_Palettes()
{
   // init rainbow palette
   for (int i = 0; i < RGB_Palette_23_Size; i++)
   {
      double t = double(i) / (RGB_Palette_23_Size-1), s, r, g, b;
      // t *= 3.0; // red to red
      t *= 2.5; // red to purple
      if (t < 1.0)
      {
         s = sin(t * M_PI);
         if (t < 0.5)
         {
            r = 1.0;
            g = s;
         }
         else
         {
            r = s;
            g = 1.0;
         }
         b = 0.0;
      }
      else if (t < 2.0)
      {
         s = sin((t - 1.0) * M_PI);
         if (t < 1.5)
         {
            g = 1.0;
            b = s;
         }
         else
         {
            g = s;
            b = 1.0;
         }
         r = 0.0;
      }
      else
      {
         s = sin((t - 2.0) * M_PI);
         if (t < 2.5)
         {
            r = s;
            b = 1.0;
         }
         else
         {
            r = 1.0;
            b = s;
         }
         g = 0.0;
      }
      RGB_Palette_23[i][0] = r;
      RGB_Palette_23[i][1] = g;
      RGB_Palette_23[i][2] = b;
   }

   // init vivid palette
   const int ns = 7;
   const double ts[ns] = { 0., 3./16., 4./16., 1./2., 12./16., 13./16., 1. };

   const double rs[ns] = { 0.0, 0.0, 0.0, 1.0, 0.9, 1.0, 0.5 };
   const double gs[ns] = { 0.0, 1.0, 0.9, 1.0, 0.0, 0.0, 0.0 };
   const double bs[ns] = { 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0 };
   const double rc[ns-1] = { 1.0, 1.0, 1.3, 1.0, 1.0, 1.2 };
   const double gc[ns-1] = { 1.2, 1.0, 1.0, 1.4, 1.0, 1.0 };
   const double bc[ns-1] = { 1.0, 1.0, 1.0, 1.0, 1.6, 1.0 };

   for (int i = 0; i < RGB_Palette_13_Size; i++)
   {
      double t = double(i) / (RGB_Palette_13_Size-1), r, g, b;
      int k;
      for (k = 1; k < ns; k++)
         if (t >= ts[k-1] && t <= ts[k])
         {
            break;
         }
      t = (t - ts[k-1]) / (ts[k] - ts[k-1]);
      r = (1.0 - t) * corr(rc[k-1], rs[k-1]) + t * corr(rc[k-1], rs[k]);
      g = (1.0 - t) * corr(gc[k-1], gs[k-1]) + t * corr(gc[k-1], gs[k]);
      b = (1.0 - t) * corr(bc[k-1], bs[k-1]) + t * corr(bc[k-1], bs[k]);
      RGB_Palette_13[i][0] = corr(1./rc[k-1], r);
      RGB_Palette_13[i][1] = corr(1./gc[k-1], g);
      RGB_Palette_13[i][2] = corr(1./bc[k-1], b);
   }

   Init_Visit_Calewhite_Palette();
}

void Set_Texture_Image();

void Set_Palette (int num)
{
   Default_RGB_Palette = num;
   RGB_Palette_Size = RGB_Palettes_Sizes[num];
   RGB_Palette = RGB_Palettes[num];

   Set_Texture_Image();
}

void Next_RGB_Palette()
{
   Set_Palette((Default_RGB_Palette + 1) % Num_RGB_Palettes);
}

int Select_New_RGB_Palette()
{
   const int buflen = 256;
   char buffer[buflen];
   int pal;
   cout << "Choose a palette:\n";
   for (pal = 0; pal < Num_RGB_Palettes; pal++)
   {
      cout << setw(4) << pal+1 << ") " << RGB_Palettes_Names[pal];
      if ((pal+1)%5 == 0)
      {
         cout << '\n';
      }
   }
   cout << "\n ---> [" << Default_RGB_Palette+1 << "] " << flush;

   cin.getline (buffer, buflen);
   cin.getline (buffer, buflen);

   if (buffer[0])
   {
      sscanf(buffer, "%i", &pal);
   }
   else
   {
      pal = Default_RGB_Palette+1;
   }

   if (pal < 1)
   {
      pal = 1;
   }
   else if (pal > Num_RGB_Palettes)
   {
      pal = Num_RGB_Palettes;
   }

   Set_Palette (pal-1);

   return pal-1;
}

#endif
