# [anaconda](https://github.com/devcontainers/images/tree/main/src/anaconda)

**Image version:** 0.203.3

**Source release/branch:** [v0.3.13](https://github.com/devcontainers/images/tree/v0.3.13/src/anaconda)

**Digest:** sha256:75f3940e4cc77e5de8a3fcf71f68febf6eeb3e50d2fea2fa2e0c038d3da5a7da

**Tags:**
```
mcr.microsoft.com/devcontainers/anaconda:0.203.3-3
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.9 | /opt/conda |
| [Jupyter Notebooks](https://jupyter.org/) | 6.5.2 | /opt/conda |
| [Jupyter Lab](https://jupyter.org/) | 3.5.3 | /opt/conda |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 46c70406dd0b26bbd61210873ad6c86d9e8ee5da | /home/vscode/.oh-my-zsh |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| joblib | 1.3.1 |
| cookiecutter | 2.2.3 |
| cryptography | 41.0.2 |
| mistune | 3.0.1 |
| numpy | 1.25.2 |
| certifi | 2023.7.22 |
| setuptools | 65.6.3 |
| future | 0.18.3 |
| wheel | 0.38.4 |
| nbconvert | 7.7.3 |
| py | 1.11.0 |
| requests | 2.31.0 |
| tornado | 6.3.2 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.41.0 | 
| [conda](https://github.com/conda/conda) | 23.3.1 | /opt/conda |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u7 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1+deb11u2 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u6 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u5 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u6 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

