# [miniconda](https://github.com/devcontainers/images/tree/main/src/miniconda)

**Image version:** 0.202.19

**Source release/branch:** [v0.2.48](https://github.com/devcontainers/images/tree/v0.2.48/src/miniconda)

**Digest:** sha256:b17d49f0249919cd9fab57883e38d7c19247c844a9a189f2b17a873cc9dbf906

**Tags:**
```
mcr.microsoft.com/devcontainers/miniconda:0.202.19-3
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.8 | /opt/conda |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 69b5737daf0448ad7e6686174638be74f86afdec | /home/vscode/.oh-my-zsh |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| certifi | 2022.12.7 |
| cryptography | 39.0.1 |
| pylint | 2.16.2 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 23.1.0 |
| yapf | 0.32.0 |
| mypy | 1.0.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.20.0 |
| pipx | 1.1.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.39.2 | 
| [conda](https://github.com/conda/conda) | 22.11.1 | /opt/conda |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u7 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1+deb11u2 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u4 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

