# [python](https://github.com/devcontainers/images/tree/main/src/python)

**Image version:** 0.203.12

**Source release/branch:** [v0.2.18](https://github.com/devcontainers/images/tree/v0.2.18/src/python)

**Image variations:**
- [3.10-bullseye](#variant-310-bullseye)
- [3.9-bullseye](#variant-39-bullseye)
- [3.8-bullseye](#variant-38-bullseye)
- [3.7-bullseye](#variant-37-bullseye)
- [3.6-bullseye](#variant-36-bullseye)
- [3.10-buster](#variant-310-buster)
- [3.9-buster](#variant-39-buster)
- [3.8-buster](#variant-38-buster)
- [3.7-buster](#variant-37-buster)
- [3.6-buster](#variant-36-buster)

## Variant: 3.10-bullseye

**Digest:** sha256:83c200dce43afd46e3eea6d627756b3f48f527cfa0b38e04c6d73c5d244a2392

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.203.12-3.10-bullseye
mcr.microsoft.com/devcontainers/python:0.203.12-3.10
mcr.microsoft.com/devcontainers/python:0.203.12-3
mcr.microsoft.com/devcontainers/python:0.203.12-3-bullseye
mcr.microsoft.com/devcontainers/python:0.203.12-bullseye
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.8 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 4e4961e60c6e4bb6a3bd30bc70576f00ea519930 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 3fea5493a431ac64470d4230d4b51438cf213bd1 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.4 |
| flake8 | 5.0.4 |
| autopep8 | 1.7.0 |
| black | 22.10.0 |
| yapf | 0.32.0 |
| mypy | 0.982 |
| pydocstyle | 6.1.1 |
| pycodestyle | 2.9.1 |
| bandit | 1.7.4 |
| virtualenv | 20.16.5 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u4 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u2 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u2 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u4 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u1 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.9-bullseye

**Digest:** sha256:bd5a4c7f84a4444209889715541b0b1afa76f86c8ea5e902a302f8a6eca8833d

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.203.12-3.9-bullseye
mcr.microsoft.com/devcontainers/python:0.203.12-3.9
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.9.15 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 4e4961e60c6e4bb6a3bd30bc70576f00ea519930 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 3fea5493a431ac64470d4230d4b51438cf213bd1 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.4 |
| flake8 | 5.0.4 |
| autopep8 | 1.7.0 |
| black | 22.10.0 |
| yapf | 0.32.0 |
| mypy | 0.982 |
| pydocstyle | 6.1.1 |
| pycodestyle | 2.9.1 |
| bandit | 1.7.4 |
| virtualenv | 20.16.5 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u4 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u2 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u2 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u4 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u1 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.8-bullseye

**Digest:** sha256:005a32190f03dacfa5dd6127e3c61c3161818a62a2dc08914faa134ca8966d77

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.203.12-3.8-bullseye
mcr.microsoft.com/devcontainers/python:0.203.12-3.8
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.8.15 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 4e4961e60c6e4bb6a3bd30bc70576f00ea519930 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 3fea5493a431ac64470d4230d4b51438cf213bd1 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.4 |
| flake8 | 5.0.4 |
| autopep8 | 1.7.0 |
| black | 22.10.0 |
| yapf | 0.32.0 |
| mypy | 0.982 |
| pydocstyle | 6.1.1 |
| pycodestyle | 2.9.1 |
| bandit | 1.7.4 |
| virtualenv | 20.16.5 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u4 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u2 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u2 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u4 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u1 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.7-bullseye

**Digest:** sha256:9d54959483cbd0f767e20defdc5e8654d03c3d50635acc3e2976b2bff7db3fde

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.203.12-3.7-bullseye
mcr.microsoft.com/devcontainers/python:0.203.12-3.7
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.7.15 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 4e4961e60c6e4bb6a3bd30bc70576f00ea519930 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 3fea5493a431ac64470d4230d4b51438cf213bd1 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.4 |
| flake8 | 5.0.4 |
| autopep8 | 1.7.0 |
| black | 22.10.0 |
| yapf | 0.32.0 |
| mypy | 0.982 |
| pydocstyle | 6.1.1 |
| pycodestyle | 2.9.1 |
| bandit | 1.7.4 |
| virtualenv | 20.16.5 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u4 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u2 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u2 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u4 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u1 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.6-bullseye

**Digest:** sha256:badcacf979c3ef8769537c5e7a8985cbe3fc7a880924b6402fd6327b16498c65

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.203.12-3.6-bullseye
mcr.microsoft.com/devcontainers/python:0.203.12-3.6
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.6.15 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 4e4961e60c6e4bb6a3bd30bc70576f00ea519930 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 3fea5493a431ac64470d4230d4b51438cf213bd1 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.13.9 |
| flake8 | 5.0.4 |
| autopep8 | 1.7.0 |
| black | 22.8.0 |
| yapf | 0.32.0 |
| mypy | 0.971 |
| pydocstyle | 6.1.1 |
| pycodestyle | 2.9.1 |
| bandit | 1.7.1 |
| virtualenv | 20.16.5 |
| pipx | 1.0.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u4 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u2 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u2 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u4 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u1 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.10-buster

**Digest:** sha256:3b377bfcd718fa8288fd9af59dcfbb5046cd79bd9d15b6244339830c3f239f51

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.203.12-3.10-buster
mcr.microsoft.com/devcontainers/python:0.203.12-3-buster
mcr.microsoft.com/devcontainers/python:0.203.12-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.8 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 4e4961e60c6e4bb6a3bd30bc70576f00ea519930 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 3fea5493a431ac64470d4230d4b51438cf213bd1 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.4 |
| flake8 | 5.0.4 |
| autopep8 | 1.7.0 |
| black | 22.10.0 |
| yapf | 0.32.0 |
| mypy | 0.982 |
| pydocstyle | 6.1.1 |
| pycodestyle | 2.9.1 |
| bandit | 1.7.4 |
| virtualenv | 20.16.5 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u4 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u4 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u4 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u3 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u2 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.9-buster

**Digest:** sha256:829c7c9a6b8f532512e84076058ab7ba07be60391a2120e8fac9cbc487063a1a

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.203.12-3.9-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.9.15 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 4e4961e60c6e4bb6a3bd30bc70576f00ea519930 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 3fea5493a431ac64470d4230d4b51438cf213bd1 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.4 |
| flake8 | 5.0.4 |
| autopep8 | 1.7.0 |
| black | 22.10.0 |
| yapf | 0.32.0 |
| mypy | 0.982 |
| pydocstyle | 6.1.1 |
| pycodestyle | 2.9.1 |
| bandit | 1.7.4 |
| virtualenv | 20.16.5 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u4 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u4 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u4 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u3 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u2 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.8-buster

**Digest:** sha256:4b9b53a38c4a4b1d5fef4cd4d9f9980fdf19f76f38ae7a71c57c3941a8466f89

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.203.12-3.8-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.8.15 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 4e4961e60c6e4bb6a3bd30bc70576f00ea519930 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 3fea5493a431ac64470d4230d4b51438cf213bd1 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.4 |
| flake8 | 5.0.4 |
| autopep8 | 1.7.0 |
| black | 22.10.0 |
| yapf | 0.32.0 |
| mypy | 0.982 |
| pydocstyle | 6.1.1 |
| pycodestyle | 2.9.1 |
| bandit | 1.7.4 |
| virtualenv | 20.16.5 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u4 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u4 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u4 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u3 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u2 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.7-buster

**Digest:** sha256:461c91dc2b533fc87d778b8b4d25ab9cef427e68d3cbc9b5d8fd0c45d0ae6279

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.203.12-3.7-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.7.15 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 4e4961e60c6e4bb6a3bd30bc70576f00ea519930 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 3fea5493a431ac64470d4230d4b51438cf213bd1 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.4 |
| flake8 | 5.0.4 |
| autopep8 | 1.7.0 |
| black | 22.10.0 |
| yapf | 0.32.0 |
| mypy | 0.982 |
| pydocstyle | 6.1.1 |
| pycodestyle | 2.9.1 |
| bandit | 1.7.4 |
| virtualenv | 20.16.5 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u4 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u4 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u4 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u3 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u2 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.6-buster

**Digest:** sha256:434575a7f3f2fe28dd73da457ffa7106d9669c336dc44c374121944cb6541587

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.203.12-3.6-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.6.15 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 4e4961e60c6e4bb6a3bd30bc70576f00ea519930 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 3fea5493a431ac64470d4230d4b51438cf213bd1 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.13.9 |
| flake8 | 5.0.4 |
| autopep8 | 1.7.0 |
| black | 22.8.0 |
| yapf | 0.32.0 |
| mypy | 0.971 |
| pydocstyle | 6.1.1 |
| pycodestyle | 2.9.1 |
| bandit | 1.7.1 |
| virtualenv | 20.16.5 |
| pipx | 1.0.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u4 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u4 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u4 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u3 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u2 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

