# [python](https://github.com/devcontainers/images/tree/main/src/python)

**Image version:** 0.204.4

**Source release/branch:** [v0.2.38](https://github.com/devcontainers/images/tree/v0.2.38/src/python)

**Image variations:**
- [3.11-bullseye](#variant-311-bullseye)
- [3.10-bullseye](#variant-310-bullseye)
- [3.9-bullseye](#variant-39-bullseye)
- [3.8-bullseye](#variant-38-bullseye)
- [3.7-bullseye](#variant-37-bullseye)
- [3.11-buster](#variant-311-buster)
- [3.10-buster](#variant-310-buster)
- [3.9-buster](#variant-39-buster)
- [3.8-buster](#variant-38-buster)
- [3.7-buster](#variant-37-buster)

## Variant: 3.11-bullseye

**Digest:** sha256:1aaa54bf036f6d49ec3afe4688eae0c2b75f7f0e4e7526af03753a1845edb5f0

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.4-3.11-bullseye
mcr.microsoft.com/devcontainers/python:0.204.4-3.11
mcr.microsoft.com/devcontainers/python:0.204.4-3
mcr.microsoft.com/devcontainers/python:0.204.4-3-bullseye
mcr.microsoft.com/devcontainers/python:0.204.4-bullseye
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.11.1 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 61dd3682e69aa990a8a3589c5c61ea2e1edf8312 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.10-bullseye

**Digest:** sha256:b3cadaf960d7f6d464890c53716df4bcc71b176abcb6ab12604e0cc78926a4db

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.4-3.10-bullseye
mcr.microsoft.com/devcontainers/python:0.204.4-3.10
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.9 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 61dd3682e69aa990a8a3589c5c61ea2e1edf8312 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.9-bullseye

**Digest:** sha256:38248677bea4503cdc7b4589e022daf3c3de5d76f160d530000665d6c044e481

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.4-3.9-bullseye
mcr.microsoft.com/devcontainers/python:0.204.4-3.9
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.9.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 61dd3682e69aa990a8a3589c5c61ea2e1edf8312 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.8-bullseye

**Digest:** sha256:619df220ed3f7c91e96785e8794c1b7ac7af8c27e50be16c8f08304153b45f83

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.4-3.8-bullseye
mcr.microsoft.com/devcontainers/python:0.204.4-3.8
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.8.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 61dd3682e69aa990a8a3589c5c61ea2e1edf8312 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.7-bullseye

**Digest:** sha256:e8dabc47928fbaca7605b7991b7cf63ca5f70e7186e0c6ee53d1d12520b3b24b

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.4-3.7-bullseye
mcr.microsoft.com/devcontainers/python:0.204.4-3.7
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.7.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 61dd3682e69aa990a8a3589c5c61ea2e1edf8312 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 5.0.4 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.11-buster

**Digest:** sha256:856bfbc964f073e4e354c5eaf7ef2e2d2c8a77a4ecb7979fed726571c5637550

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.4-3.11-buster
mcr.microsoft.com/devcontainers/python:0.204.4-3-buster
mcr.microsoft.com/devcontainers/python:0.204.4-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.11.1 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 61dd3682e69aa990a8a3589c5c61ea2e1edf8312 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u6 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u4 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u4 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.10-buster

**Digest:** sha256:701295f97aac5e3d4a950bc96aa4f0cc08fcc2a16d57b553fd8c506f928f0a73

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.4-3.10-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.9 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 61dd3682e69aa990a8a3589c5c61ea2e1edf8312 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u6 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u4 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u4 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.9-buster

**Digest:** sha256:a885fe233484d8e05a2225cfad0ea917b1466bcc5ea490585bd5473a6c7bdedf

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.4-3.9-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.9.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 61dd3682e69aa990a8a3589c5c61ea2e1edf8312 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u6 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u4 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u4 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.8-buster

**Digest:** sha256:7e448bbc933f6983f54080920640664e3620c3dfd52c7ed9664126a1089c5efb

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.4-3.8-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.8.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 61dd3682e69aa990a8a3589c5c61ea2e1edf8312 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u6 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u4 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u4 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.7-buster

**Digest:** sha256:c1ecaddc0ad35392f9b906680d90578ae7b1e1f534172d79ecb6cc2ee74f820d

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.4-3.7-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.7.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 61dd3682e69aa990a8a3589c5c61ea2e1edf8312 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 5.0.4 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u6 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u4 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u4 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

