# [python](https://github.com/devcontainers/images/tree/main/src/python)

**Image version:** 0.204.5

**Source release/branch:** [v0.2.40](https://github.com/devcontainers/images/tree/v0.2.40/src/python)

**Image variations:**
- [3.11-bullseye](#variant-311-bullseye)
- [3.10-bullseye](#variant-310-bullseye)
- [3.9-bullseye](#variant-39-bullseye)
- [3.8-bullseye](#variant-38-bullseye)
- [3.7-bullseye](#variant-37-bullseye)
- [3.11-buster](#variant-311-buster)
- [3.10-buster](#variant-310-buster)
- [3.9-buster](#variant-39-buster)
- [3.8-buster](#variant-38-buster)
- [3.7-buster](#variant-37-buster)

## Variant: 3.11-bullseye

**Digest:** sha256:1706e36a918d50122bb92c7f6702a80a1db8d09b94d0912bc69ba993ca011bbc

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.5-3.11-bullseye
mcr.microsoft.com/devcontainers/python:0.204.5-3.11
mcr.microsoft.com/devcontainers/python:0.204.5-3
mcr.microsoft.com/devcontainers/python:0.204.5-3-bullseye
mcr.microsoft.com/devcontainers/python:0.204.5-bullseye
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.11.1 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 7de55844b26394688221b1cd12ef4053b3c7f6c7 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.10-bullseye

**Digest:** sha256:cf041df2088399d42393b350c5f78dfadf3242e1fdecaeb9f3937796832b2bdc

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.5-3.10-bullseye
mcr.microsoft.com/devcontainers/python:0.204.5-3.10
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.9 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 7de55844b26394688221b1cd12ef4053b3c7f6c7 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.9-bullseye

**Digest:** sha256:b14384fa7a24c8c9bf1e1c64ac13f22d9739d99bf3d2302ccb2f5a41ccc1f9a3

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.5-3.9-bullseye
mcr.microsoft.com/devcontainers/python:0.204.5-3.9
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.9.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 7de55844b26394688221b1cd12ef4053b3c7f6c7 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.8-bullseye

**Digest:** sha256:3b815ddfaa8d9e1f6ae2d79ab3c7d926a0c6fbf46528f5da2c045f6bacb04ae5

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.5-3.8-bullseye
mcr.microsoft.com/devcontainers/python:0.204.5-3.8
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.8.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 7de55844b26394688221b1cd12ef4053b3c7f6c7 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.7-bullseye

**Digest:** sha256:fe237e15bdc65d9b22c97d32342889dc77356ef1ea8e874830b76010c43d2abe

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.5-3.7-bullseye
mcr.microsoft.com/devcontainers/python:0.204.5-3.7
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.7.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 7de55844b26394688221b1cd12ef4053b3c7f6c7 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 5.0.4 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u3 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u5 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u3 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u5 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.11-buster

**Digest:** sha256:b1011bcdb36500d10e9c405379a30291ce2a5420490b901c6870a841c2e2f008

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.5-3.11-buster
mcr.microsoft.com/devcontainers/python:0.204.5-3-buster
mcr.microsoft.com/devcontainers/python:0.204.5-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.11.1 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 7de55844b26394688221b1cd12ef4053b3c7f6c7 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u6 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u5 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u4 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.10-buster

**Digest:** sha256:fbcfcd7d989059edb8a78353c9ffeec58558582968f17c9c4ba09012095e94a6

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.5-3.10-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.9 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 7de55844b26394688221b1cd12ef4053b3c7f6c7 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u6 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u5 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u4 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.9-buster

**Digest:** sha256:3c7693f3df127cdcf88a5c91ebfe95bc0f486d717a21d159c708fc2a7e38e42b

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.5-3.9-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.9.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 7de55844b26394688221b1cd12ef4053b3c7f6c7 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u6 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u5 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u4 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.8-buster

**Digest:** sha256:e4ab2c7169f8daedca6a6c8ca309f006683103a14d4debf261c6030fc366f909

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.5-3.8-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.8.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 7de55844b26394688221b1cd12ef4053b3c7f6c7 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 6.0.0 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u6 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u5 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u4 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.7-buster

**Digest:** sha256:de9125eff1694b5252b9f978f59f0b460389d968ed3a54efc6e79e1bc222ed2d

**Tags:**
```
mcr.microsoft.com/devcontainers/python:0.204.5-3.7-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.7.16 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | 7de55844b26394688221b1cd12ef4053b3c7f6c7 | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | 0ccd099bff8e384043883c4ae01b589794b13d72 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| pylint | 2.15.10 |
| flake8 | 5.0.4 |
| autopep8 | 2.0.1 |
| black | 22.12.0 |
| yapf | 0.32.0 |
| mypy | 0.991 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.10.0 |
| bandit | 1.7.4 |
| virtualenv | 20.17.1 |
| pipx | 1.1.0 |

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u3 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u6 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u3 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u2 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u5 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u4 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

