# [python](https://github.com/devcontainers/images/tree/main/src/python)

**Image version:** dev

**Source release/branch:** [main](https://github.com/devcontainers/images/tree/main/src/python)

**Image variations:**
- [3.11-bookworm](#variant-311-bookworm)
- [3.10-bookworm](#variant-310-bookworm)
- [3.9-bookworm](#variant-39-bookworm)
- [3.8-bookworm](#variant-38-bookworm)
- [3.11-bullseye](#variant-311-bullseye)
- [3.10-bullseye](#variant-310-bullseye)
- [3.9-bullseye](#variant-39-bullseye)
- [3.8-bullseye](#variant-38-bullseye)
- [3.11-buster](#variant-311-buster)
- [3.10-buster](#variant-310-buster)
- [3.9-buster](#variant-39-buster)
- [3.8-buster](#variant-38-buster)

## Variant: 3.11-bookworm

**Digest:** sha256:1791a278f82e73507c0201f1dd8218f32c20257b4019390ba97e666b32d46622

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.11-bookworm
mcr.microsoft.com/devcontainers/python:dev-3.11
mcr.microsoft.com/devcontainers/python:dev-3
mcr.microsoft.com/devcontainers/python:dev-3-bookworm
mcr.microsoft.com/devcontainers/python:dev-bookworm
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 12 (bookworm)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.11.5 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.6.1 |
| apt-utils | 2.6.1 |
| ca-certificates | 20230311 |
| curl | 7.88.1-10+deb12u1 |
| dialog | 1.3-20230209-1 |
| git | 1:2.39.2-1.1 |
| gnupg2 | 2.2.40-1.1 |
| htop | 3.2.2-2 |
| iproute2 | 6.1.0-3 |
| jq | 1.6-2.1 |
| less | 590-2 |
| libc6 | 2.36-9+deb12u1 |
| libgssapi-krb5-2 | 1.20.1-2 |
| libicu72 | 72.1-3 |
| libkrb5-3 | 1.20.1-2 |
| liblttng-ust1 | 2.13.5-1 |
| libstdc++6 | 12.2.0-14 |
| locales | 2.36-9+deb12u1 |
| lsb-release | 12.0-1 |
| lsof | 4.95.0-1 |
| man-db | 2.11.2-2 |
| manpages | 6.03-2 |
| manpages-dev | 6.03-2 |
| nano | 7.2-1 |
| ncdu | 1.18-0.2 |
| net-tools | 2.10-0.1 |
| openssh-client | 1:9.2p1-2 |
| procps | 2:4.0.2-3 |
| psmisc | 23.6-1 |
| rsync | 3.2.7-1 |
| strace | 6.1-0.1 |
| sudo | 1.9.13p3-1+deb12u1 |
| unzip | 6.0-28 |
| vim-tiny | 2:9.0.1378-2 |
| wget | 1.21.3-1+b2 |
| yarn | 1.22.19-1 |
| zip | 3.0-13 |
| zlib1g | 1:1.2.13.dfsg-1 |
| zsh | 5.9-4+b2 |

## Variant: 3.10-bookworm

**Digest:** sha256:a8aae07d17d57b06d1937b3d68a9eb7834511fe3ad7df6e2d0f017d4841a570a

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.10-bookworm
mcr.microsoft.com/devcontainers/python:dev-3.10
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 12 (bookworm)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.13 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.6.1 |
| apt-utils | 2.6.1 |
| ca-certificates | 20230311 |
| curl | 7.88.1-10+deb12u1 |
| dialog | 1.3-20230209-1 |
| git | 1:2.39.2-1.1 |
| gnupg2 | 2.2.40-1.1 |
| htop | 3.2.2-2 |
| iproute2 | 6.1.0-3 |
| jq | 1.6-2.1 |
| less | 590-2 |
| libc6 | 2.36-9+deb12u1 |
| libgssapi-krb5-2 | 1.20.1-2 |
| libicu72 | 72.1-3 |
| libkrb5-3 | 1.20.1-2 |
| liblttng-ust1 | 2.13.5-1 |
| libstdc++6 | 12.2.0-14 |
| locales | 2.36-9+deb12u1 |
| lsb-release | 12.0-1 |
| lsof | 4.95.0-1 |
| man-db | 2.11.2-2 |
| manpages | 6.03-2 |
| manpages-dev | 6.03-2 |
| nano | 7.2-1 |
| ncdu | 1.18-0.2 |
| net-tools | 2.10-0.1 |
| openssh-client | 1:9.2p1-2 |
| procps | 2:4.0.2-3 |
| psmisc | 23.6-1 |
| rsync | 3.2.7-1 |
| strace | 6.1-0.1 |
| sudo | 1.9.13p3-1+deb12u1 |
| unzip | 6.0-28 |
| vim-tiny | 2:9.0.1378-2 |
| wget | 1.21.3-1+b2 |
| yarn | 1.22.19-1 |
| zip | 3.0-13 |
| zlib1g | 1:1.2.13.dfsg-1 |
| zsh | 5.9-4+b2 |

## Variant: 3.9-bookworm

**Digest:** sha256:a78a5a271cafa920daf3aca51639e702481fa23ec46ce252f463c6dc89aeb2ae

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.9-bookworm
mcr.microsoft.com/devcontainers/python:dev-3.9
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 12 (bookworm)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.9.18 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.6.1 |
| apt-utils | 2.6.1 |
| ca-certificates | 20230311 |
| curl | 7.88.1-10+deb12u1 |
| dialog | 1.3-20230209-1 |
| git | 1:2.39.2-1.1 |
| gnupg2 | 2.2.40-1.1 |
| htop | 3.2.2-2 |
| iproute2 | 6.1.0-3 |
| jq | 1.6-2.1 |
| less | 590-2 |
| libc6 | 2.36-9+deb12u1 |
| libgssapi-krb5-2 | 1.20.1-2 |
| libicu72 | 72.1-3 |
| libkrb5-3 | 1.20.1-2 |
| liblttng-ust1 | 2.13.5-1 |
| libstdc++6 | 12.2.0-14 |
| locales | 2.36-9+deb12u1 |
| lsb-release | 12.0-1 |
| lsof | 4.95.0-1 |
| man-db | 2.11.2-2 |
| manpages | 6.03-2 |
| manpages-dev | 6.03-2 |
| nano | 7.2-1 |
| ncdu | 1.18-0.2 |
| net-tools | 2.10-0.1 |
| openssh-client | 1:9.2p1-2 |
| procps | 2:4.0.2-3 |
| psmisc | 23.6-1 |
| rsync | 3.2.7-1 |
| strace | 6.1-0.1 |
| sudo | 1.9.13p3-1+deb12u1 |
| unzip | 6.0-28 |
| vim-tiny | 2:9.0.1378-2 |
| wget | 1.21.3-1+b2 |
| yarn | 1.22.19-1 |
| zip | 3.0-13 |
| zlib1g | 1:1.2.13.dfsg-1 |
| zsh | 5.9-4+b2 |

## Variant: 3.8-bookworm

**Digest:** sha256:843d4290cdf2336b9f5ae8262a5b4d683e875aca67caa52bfafde518a2826e52

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.8-bookworm
mcr.microsoft.com/devcontainers/python:dev-3.8
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 12 (bookworm)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.8.18 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.6.1 |
| apt-utils | 2.6.1 |
| ca-certificates | 20230311 |
| curl | 7.88.1-10+deb12u1 |
| dialog | 1.3-20230209-1 |
| git | 1:2.39.2-1.1 |
| gnupg2 | 2.2.40-1.1 |
| htop | 3.2.2-2 |
| iproute2 | 6.1.0-3 |
| jq | 1.6-2.1 |
| less | 590-2 |
| libc6 | 2.36-9+deb12u1 |
| libgssapi-krb5-2 | 1.20.1-2 |
| libicu72 | 72.1-3 |
| libkrb5-3 | 1.20.1-2 |
| liblttng-ust1 | 2.13.5-1 |
| libstdc++6 | 12.2.0-14 |
| locales | 2.36-9+deb12u1 |
| lsb-release | 12.0-1 |
| lsof | 4.95.0-1 |
| man-db | 2.11.2-2 |
| manpages | 6.03-2 |
| manpages-dev | 6.03-2 |
| nano | 7.2-1 |
| ncdu | 1.18-0.2 |
| net-tools | 2.10-0.1 |
| openssh-client | 1:9.2p1-2 |
| procps | 2:4.0.2-3 |
| psmisc | 23.6-1 |
| rsync | 3.2.7-1 |
| strace | 6.1-0.1 |
| sudo | 1.9.13p3-1+deb12u1 |
| unzip | 6.0-28 |
| vim-tiny | 2:9.0.1378-2 |
| wget | 1.21.3-1+b2 |
| yarn | 1.22.19-1 |
| zip | 3.0-13 |
| zlib1g | 1:1.2.13.dfsg-1 |
| zsh | 5.9-4+b2 |

## Variant: 3.11-bullseye

**Digest:** sha256:f58d59fe20f3b77037876f45e23ddc1b3c9eceae039b7ba0e3846d677def045f

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.11-bullseye
mcr.microsoft.com/devcontainers/python:dev-3-bullseye
mcr.microsoft.com/devcontainers/python:dev-bullseye
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.11.5 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u7 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1+deb11u2 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u6 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u5 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u6 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.10-bullseye

**Digest:** sha256:247e8fc9a558c82bb544ea4fe39d73cd5837bbe4f2c98028272c584224ed65a7

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.10-bullseye
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.13 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u7 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1+deb11u2 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u6 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u5 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u6 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.9-bullseye

**Digest:** sha256:6a15252256a402430868a09d09ff7f059a9c84f19a3c6d0a82595cfe490ee10a

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.9-bullseye
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.9.18 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u7 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1+deb11u2 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u6 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u5 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u6 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.8-bullseye

**Digest:** sha256:33a5ff56a8738a64a2f45375eda58018f2c04dd28ded924e33f69a55d8067162

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.8-bullseye
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 11 (bullseye)

**Architectures:** linux/amd64, linux/arm64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.8.18 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 2.2.4 |
| apt-utils | 2.2.4 |
| ca-certificates | 20210119 |
| curl | 7.74.0-1.3+deb11u7 |
| dialog | 1.3-20201126-1 |
| git | 1:2.30.2-1+deb11u2 |
| gnupg2 | 2.2.27-2+deb11u2 |
| htop | 3.0.5-7 |
| iproute2 | 5.10.0-4 |
| jq | 1.6-2.1 |
| less | 551-2 |
| libc6 | 2.31-13+deb11u6 |
| libgssapi-krb5-2 | 1.18.3-6+deb11u3 |
| libicu67 | 67.1-7 |
| libkrb5-3 | 1.18.3-6+deb11u3 |
| liblttng-ust0 | 2.12.1-1 |
| libssl1.1 | 1.1.1n-0+deb11u5 |
| libstdc++6 | 10.2.1-6 |
| locales | 2.31-13+deb11u6 |
| lsb-release | 11.1.0 |
| lsof | 4.93.2+dfsg-1.1 |
| man-db | 2.9.4-2 |
| manpages | 5.10-1 |
| manpages-dev | 5.10-1 |
| nano | 5.4-2+deb11u2 |
| ncdu | 1.15.1-1 |
| net-tools | 1.60+git20181103.0eebece-1 |
| openssh-client | 1:8.4p1-5+deb11u1 |
| procps | 2:3.3.17-5 |
| psmisc | 23.4-2 |
| rsync | 3.2.3-4+deb11u1 |
| strace | 5.10-1 |
| sudo | 1.9.5p2-3+deb11u1 |
| unzip | 6.0-26+deb11u1 |
| vim-tiny | 2:8.2.2434-3+deb11u1 |
| wget | 1.21-1+deb11u1 |
| yarn | 1.22.19-1 |
| zip | 3.0-12 |
| zlib1g | 1:1.2.11.dfsg-2+deb11u2 |
| zsh | 5.8-6+deb11u1 |

## Variant: 3.11-buster

**Digest:** sha256:2fabd2f361530057891ebdb0e7ebb00948148be1c4d98164be57e9d8a62e1f79

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.11-buster
mcr.microsoft.com/devcontainers/python:dev-3-buster
mcr.microsoft.com/devcontainers/python:dev-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.11.4 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u6 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u8 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u6 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u3 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u5 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u5 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.10-buster

**Digest:** sha256:7b9e21b92df209cc62bfdc837e09694264190c80ab08fdaf7b286358dc56ce5e

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.10-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.10.12 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u6 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u8 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u6 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u3 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u5 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u5 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.9-buster

**Digest:** sha256:b5d0e7b4e34ea749ced5269e55919f8712f4647abb875e93b38d467e83bc5bec

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.9-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.9.17 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u6 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u8 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u6 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u3 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u5 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u5 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

## Variant: 3.8-buster

**Digest:** sha256:11e5e6bdb3065307cb3284f3ce4186082fd2283fa5204e99a3bbb061936bbc2c

**Tags:**
```
mcr.microsoft.com/devcontainers/python:dev-3.8-buster
```
> *To keep up to date, we recommend using partial version numbers. Use the major version number to get all non-breaking changes (e.g. `0-`) or major and minor to only get fixes (e.g. `0.200-`).*

**Linux distribution:** Debian GNU/Linux 10 (buster)

**Architectures:** linux/amd64

**Available (non-root) user:** vscode

### Contents
**Languages and runtimes**

| Language / runtime | Version | Path |
|--------------------|---------|------|
| [Python](https://www.python.org/) | 3.8.17 | /usr/local |

**Tools installed using git**

| Tool | Commit | Path |
|------|--------|------|
| [Oh My Zsh!](https://github.com/ohmyzsh/ohmyzsh) | bf774211916c8a9d57b2b56c7846cd0b3d91baab | /home/vscode/.oh-my-zsh |
| [nvm](https://github.com/nvm-sh/nvm.git) | c92adb3c479d70bb29f4399a808c972ef41510e7 | /usr/local/share/nvm |

**Pip / pipx installed tools and packages**

| Tool / package | Version |
|----------------|---------|
| setuptools | 68.1.2 |
| pylint | 2.17.5 |
| flake8 | 6.1.0 |
| autopep8 | 2.0.4 |
| black | 23.7.0 |
| yapf | 0.40.1 |
| mypy | 1.5.1 |
| pydocstyle | 6.3.0 |
| pycodestyle | 2.11.0 |
| bandit | 1.7.5 |
| virtualenv | 20.24.3 |
| pipx | 1.2.0 |

**Other tools and utilities**

| Tool | Version | Path |
|------|---------|------|
| [git](https://github.com/git/git) | 2.42.0 | 

**Additional linux tools and packages**

| Tool / library | Version |
|----------------|---------|
| apt-transport-https | 1.8.2.3 |
| apt-utils | 1.8.2.3 |
| ca-certificates | 20200601~deb10u2 |
| curl | 7.64.0-4+deb10u6 |
| dialog | 1.3-20190211-1 |
| git | 1:2.20.1-2+deb10u8 |
| gnupg2 | 2.2.12-1+deb10u2 |
| htop | 2.2.0-1+b1 |
| iproute2 | 4.20.0-2+deb10u1 |
| jq | 1.5+dfsg-2+b1 |
| less | 487-0.1+b1 |
| libc6 | 2.28-10+deb10u2 |
| libgcc1 | 1:8.3.0-6 |
| libgssapi-krb5-2 | 1.17-3+deb10u5 |
| libicu63 | 63.1-6+deb10u3 |
| libkrb5-3 | 1.17-3+deb10u5 |
| liblttng-ust0 | 2.10.3-1 |
| libssl1.1 | 1.1.1n-0+deb10u6 |
| libstdc++6 | 8.3.0-6 |
| locales | 2.28-10+deb10u2 |
| lsb-release | 10.2019051400 |
| lsof | 4.91+dfsg-1 |
| man-db | 2.8.5-2 |
| manpages | 4.16-2 |
| manpages-dev | 4.16-2 |
| nano | 3.2-3 |
| ncdu | 1.13-1+b1 |
| net-tools | 1.60+git20180626.aebd88e-1 |
| openssh-client | 1:7.9p1-10+deb10u3 |
| procps | 2:3.3.15-2 |
| psmisc | 23.2-1+deb10u1 |
| rsync | 3.1.3-6 |
| strace | 4.26-0.2 |
| sudo | 1.8.27-1+deb10u5 |
| unzip | 6.0-23+deb10u3 |
| vim-tiny | 2:8.1.0875-5+deb10u5 |
| wget | 1.20.1-1.1 |
| yarn | 1.22.19-1 |
| zip | 3.0-11+b1 |
| zlib1g | 1:1.2.11.dfsg-1+deb10u2 |
| zsh | 5.7.1-1+deb10u1 |

