# Generated by Django 5.0.8 on 2025-04-05 12:00

import data.models
import django.db.models.deletion
import simple_history.models
import utils.fields
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("accounts", "0002_initial"),
        ("contenttypes", "0002_remove_content_type_name"),
        ("data", "0012_alter_project_content_type"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.DeleteModel(
            name="Analysis",
        ),
        migrations.CreateModel(
            name="Analysis",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("last_modified", models.DateTimeField(auto_now=True)),
                (
                    "is_published",
                    models.BooleanField(
                        default=True,
                        help_text="Indicator for whether a project record has been published.",
                    ),
                ),
                (
                    "published_date",
                    models.DateField(
                        help_text="The date the project record was published in Onyx.",
                        null=True,
                    ),
                ),
                (
                    "is_suppressed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicator for whether a project record has been hidden from users.",
                    ),
                ),
                (
                    "is_site_restricted",
                    models.BooleanField(
                        default=False,
                        help_text="Indicator for whether a project record has been hidden from users not within the record's site.",
                    ),
                ),
                (
                    "analysis_id",
                    utils.fields.UpperCharField(
                        default=data.models.generate_analysis_id,
                        help_text="Unique identifier for an analysis in Onyx.",
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "analysis_date",
                    models.DateField(
                        help_text="The date the analysis was carried out."
                    ),
                ),
                ("name", utils.fields.StrippedCharField(max_length=100, unique=True)),
                ("command_details", models.TextField(blank=True)),
                ("pipeline_details", models.TextField(blank=True)),
                ("experiment_details", models.JSONField(default=dict)),
                ("result", models.TextField(blank=True)),
                ("report", models.TextField(blank=True)),
                ("outputs", models.TextField(blank=True)),
                (
                    "identifiers",
                    models.ManyToManyField(
                        related_name="analyses", to="data.anonymiser"
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="data.project"
                    ),
                ),
                (
                    "site",
                    utils.fields.SiteField(
                        help_text="Site that uploaded the record.",
                        on_delete=django.db.models.deletion.PROTECT,
                        to="accounts.site",
                        to_field="code",
                    ),
                ),
                (
                    "upstream_analyses",
                    models.ManyToManyField(
                        related_name="downstream_analyses", to="data.analysis"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="HistoricalAnalysis",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                (
                    "uuid",
                    models.UUIDField(db_index=True, default=uuid.uuid4, editable=False),
                ),
                ("created", models.DateTimeField(blank=True, editable=False)),
                ("last_modified", models.DateTimeField(blank=True, editable=False)),
                (
                    "is_published",
                    models.BooleanField(
                        default=True,
                        help_text="Indicator for whether a project record has been published.",
                    ),
                ),
                (
                    "published_date",
                    models.DateField(
                        help_text="The date the project record was published in Onyx.",
                        null=True,
                    ),
                ),
                (
                    "is_suppressed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicator for whether a project record has been hidden from users.",
                    ),
                ),
                (
                    "is_site_restricted",
                    models.BooleanField(
                        default=False,
                        help_text="Indicator for whether a project record has been hidden from users not within the record's site.",
                    ),
                ),
                (
                    "analysis_id",
                    utils.fields.UpperCharField(
                        db_index=True,
                        default=data.models.generate_analysis_id,
                        help_text="Unique identifier for an analysis in Onyx.",
                        max_length=12,
                    ),
                ),
                (
                    "analysis_date",
                    models.DateField(
                        help_text="The date the analysis was carried out."
                    ),
                ),
                ("name", utils.fields.StrippedCharField(db_index=True, max_length=100)),
                ("command_details", models.TextField(blank=True)),
                ("pipeline_details", models.TextField(blank=True)),
                ("experiment_details", models.JSONField(default=dict)),
                ("result", models.TextField(blank=True)),
                ("report", models.TextField(blank=True)),
                ("outputs", models.TextField(blank=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="data.project",
                    ),
                ),
                (
                    "site",
                    utils.fields.SiteField(
                        blank=True,
                        db_constraint=False,
                        help_text="Site that uploaded the record.",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="accounts.site",
                        to_field="code",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical analysis",
                "verbose_name_plural": "historical analysiss",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.AddField(
            model_name="project",
            name="data_project",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="analysis_project",
                to="data.project",
            ),
        ),
        migrations.AddField(
            model_name="project",
            name="is_analysis_project",
            field=models.BooleanField(default=False),
        ),
        migrations.AddConstraint(
            model_name="project",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(("is_analysis_project", True), _negated=True),
                    ("data_project__isnull", False),
                    _connector="OR",
                ),
                name="data_project_is_anal_a9077c_cvr",
                violation_error_message="Each of data_project are required in order to set is_analysis_project to the value.",
            ),
        ),
        migrations.AlterField(
            model_name="project",
            name="data_project",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="analysis_project",
                to="data.project",
            ),
        ),
        migrations.RemoveConstraint(
            model_name="project",
            name="data_project_is_anal_a9077c_cvr",
        ),
        migrations.RemoveField(
            model_name="project",
            name="is_analysis_project",
        ),
        migrations.AlterField(
            model_name="analysis",
            name="name",
            field=utils.fields.StrippedCharField(
                help_text="Unique name for the analysis.", max_length=100
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="name",
            field=utils.fields.StrippedCharField(
                help_text="Unique name for the analysis.", max_length=100
            ),
        ),
        migrations.AddIndex(
            model_name="analysis",
            index=models.Index(
                fields=["project", "analysis_id", "analysis_date", "name"],
                name="data_analys_project_a30aa2_idx",
            ),
        ),
        migrations.AddConstraint(
            model_name="analysis",
            constraint=models.UniqueConstraint(
                fields=("project", "name"), name="data_analysis_project_8a0c8a_ut"
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="command_details",
            field=models.TextField(blank=True, help_text="Details of the command run."),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="experiment_details",
            field=models.JSONField(
                default=dict, help_text="Details of the experiment run."
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="identifiers",
            field=models.ManyToManyField(
                help_text="Key identifiers involved in the analysis.",
                related_name="analyses",
                to="data.anonymiser",
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="outputs",
            field=models.TextField(
                blank=True, help_text="Directory of outputs produced from the analysis."
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="pipeline_details",
            field=models.TextField(
                blank=True, help_text="Details of the pipeline run."
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="report",
            field=models.TextField(
                blank=True, help_text="Report produced from the analysis."
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="result",
            field=models.TextField(blank=True, help_text="The result of the analysis."),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="upstream_analyses",
            field=models.ManyToManyField(
                help_text="The analyses that this analysis depends on.",
                related_name="downstream_analyses",
                to="data.analysis",
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="command_details",
            field=models.TextField(blank=True, help_text="Details of the command run."),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="experiment_details",
            field=models.JSONField(
                default=dict, help_text="Details of the experiment run."
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="outputs",
            field=models.TextField(
                blank=True, help_text="Directory of outputs produced from the analysis."
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="pipeline_details",
            field=models.TextField(
                blank=True, help_text="Details of the pipeline run."
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="report",
            field=models.TextField(
                blank=True, help_text="Report produced from the analysis."
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="result",
            field=models.TextField(blank=True, help_text="The result of the analysis."),
        ),
        migrations.RemoveIndex(
            model_name="analysis",
            name="data_analys_project_a30aa2_idx",
        ),
        migrations.RemoveField(
            model_name="analysis",
            name="command_details",
        ),
        migrations.RemoveField(
            model_name="analysis",
            name="pipeline_details",
        ),
        migrations.RemoveField(
            model_name="historicalanalysis",
            name="command_details",
        ),
        migrations.RemoveField(
            model_name="historicalanalysis",
            name="pipeline_details",
        ),
        migrations.AddField(
            model_name="analysis",
            name="description",
            field=models.CharField(
                blank=True, help_text="Description of the analysis.", max_length=500
            ),
        ),
        migrations.AddField(
            model_name="analysis",
            name="pipeline_command",
            field=models.CharField(
                blank=True,
                help_text="Command used to run the pipeline for the analysis.",
                max_length=100,
            ),
        ),
        migrations.AddField(
            model_name="analysis",
            name="pipeline_name",
            field=models.CharField(
                default="default-pipeline-name",
                help_text="Name of the pipeline used for the analysis.",
                max_length=50,
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="analysis",
            name="pipeline_url",
            field=models.CharField(
                blank=True,
                help_text="URL to the pipeline used for the analysis.",
                max_length=100,
            ),
        ),
        migrations.AddField(
            model_name="analysis",
            name="pipeline_version",
            field=models.CharField(
                default="0.1.0",
                help_text="Version of the pipeline used for the analysis.",
                max_length=10,
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalanalysis",
            name="description",
            field=models.CharField(
                blank=True, help_text="Description of the analysis.", max_length=500
            ),
        ),
        migrations.AddField(
            model_name="historicalanalysis",
            name="pipeline_command",
            field=models.CharField(
                blank=True,
                help_text="Command used to run the pipeline for the analysis.",
                max_length=100,
            ),
        ),
        migrations.AddField(
            model_name="historicalanalysis",
            name="pipeline_name",
            field=models.CharField(
                default="default-pipeline-name",
                help_text="Name of the pipeline used for the analysis.",
                max_length=50,
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalanalysis",
            name="pipeline_url",
            field=models.CharField(
                blank=True,
                help_text="URL to the pipeline used for the analysis.",
                max_length=100,
            ),
        ),
        migrations.AddField(
            model_name="historicalanalysis",
            name="pipeline_version",
            field=models.CharField(
                default="0.1.0",
                help_text="Version of the pipeline used for the analysis.",
                max_length=10,
            ),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="analysis",
            name="experiment_details",
            field=models.JSONField(
                default=dict,
                help_text="Structured details of the experiment run, and/or outcomes.",
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="name",
            field=utils.fields.StrippedCharField(
                help_text="Name for the analysis, unique to the project.", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="outputs",
            field=models.CharField(
                blank=True,
                help_text="Directory of outputs produced from the analysis.",
                max_length=200,
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="report",
            field=models.CharField(
                blank=True,
                help_text="HTML report produced from the analysis.",
                max_length=200,
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="result",
            field=models.CharField(
                help_text="Key findings of the analysis.", max_length=100
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="experiment_details",
            field=models.JSONField(
                default=dict,
                help_text="Structured details of the experiment run, and/or outcomes.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="name",
            field=utils.fields.StrippedCharField(
                help_text="Name for the analysis, unique to the project.", max_length=50
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="outputs",
            field=models.CharField(
                blank=True,
                help_text="Directory of outputs produced from the analysis.",
                max_length=200,
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="report",
            field=models.CharField(
                blank=True,
                help_text="HTML report produced from the analysis.",
                max_length=200,
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="result",
            field=models.CharField(
                help_text="Key findings of the analysis.", max_length=100
            ),
        ),
        migrations.AddIndex(
            model_name="analysis",
            index=models.Index(
                fields=["project", "analysis_id", "analysis_date", "name", "result"],
                name="data_analys_project_b5c13b_idx",
            ),
        ),
        migrations.AddConstraint(
            model_name="analysis",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("report__isnull", False),
                    ("outputs__isnull", False),
                    _connector="OR",
                ),
                name="data_analysis_report__f3f0f8_ovg",
                violation_error_message="At least one of report, outputs is required.",
            ),
        ),
        migrations.RemoveField(
            model_name="analysis",
            name="experiment_details",
        ),
        migrations.RemoveField(
            model_name="historicalanalysis",
            name="experiment_details",
        ),
        migrations.AddField(
            model_name="analysis",
            name="methods",
            field=models.JSONField(
                default=dict,
                help_text="Structured details of the experiment run and its inputs.",
            ),
        ),
        migrations.AddField(
            model_name="historicalanalysis",
            name="methods",
            field=models.JSONField(
                default=dict,
                help_text="Structured details of the experiment run and its inputs.",
            ),
        ),
        migrations.AddField(
            model_name="analysis",
            name="result_metrics",
            field=models.JSONField(
                default=dict,
                help_text="Structured output metrics from the result of the analysis.",
            ),
        ),
        migrations.AddField(
            model_name="historicalanalysis",
            name="result_metrics",
            field=models.JSONField(
                default=dict,
                help_text="Structured output metrics from the result of the analysis.",
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="is_published",
            field=models.BooleanField(
                default=True,
                help_text="Indicator for whether an object has been published.",
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="is_site_restricted",
            field=models.BooleanField(
                default=False,
                help_text="Indicator for whether an object has been hidden from users not within the object's site.",
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="is_suppressed",
            field=models.BooleanField(
                default=False,
                help_text="Indicator for whether an object has been hidden from users.",
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="published_date",
            field=models.DateField(
                help_text="The date the object was published in Onyx.", null=True
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="site",
            field=utils.fields.SiteField(
                help_text="Site that uploaded the object.",
                on_delete=django.db.models.deletion.PROTECT,
                to="accounts.site",
                to_field="code",
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="is_published",
            field=models.BooleanField(
                default=True,
                help_text="Indicator for whether an object has been published.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="is_site_restricted",
            field=models.BooleanField(
                default=False,
                help_text="Indicator for whether an object has been hidden from users not within the object's site.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="is_suppressed",
            field=models.BooleanField(
                default=False,
                help_text="Indicator for whether an object has been hidden from users.",
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="published_date",
            field=models.DateField(
                help_text="The date the object was published in Onyx.", null=True
            ),
        ),
        migrations.AlterField(
            model_name="historicalanalysis",
            name="site",
            field=utils.fields.SiteField(
                blank=True,
                db_constraint=False,
                help_text="Site that uploaded the object.",
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="+",
                to="accounts.site",
                to_field="code",
            ),
        ),
        migrations.AlterField(
            model_name="analysis",
            name="identifiers",
            field=models.ManyToManyField(
                help_text="Key anonymised identifiers involved in the analysis. This does not include the CLIMB ID (for these, see the {project}_records field).",
                related_name="analyses",
                to="data.anonymiser",
            ),
        ),
        migrations.RemoveField(
            model_name="project",
            name="data_project",
        ),
    ]
