# Generated by Django 5.0.3 on 2024-03-12 11:36

import django.db.models.deletion
import simple_history.models
import utils.fields
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("accounts", "0001_initial"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="BaseTestModel",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("last_modified", models.DateTimeField(auto_now=True)),
                (
                    "climb_id",
                    utils.fields.UpperCharField(
                        help_text="Unique identifier for a project record in Onyx.",
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "is_published",
                    models.BooleanField(
                        default=True,
                        help_text="Indicator for whether a project record has been published.",
                    ),
                ),
                (
                    "published_date",
                    models.DateField(
                        help_text="The date the project record was published in Onyx.",
                        null=True,
                    ),
                ),
                (
                    "is_suppressed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicator for whether a project record has been hidden from users.",
                    ),
                ),
                (
                    "is_site_restricted",
                    models.BooleanField(
                        default=False,
                        help_text="Indicator for whether a project record has been hidden from users not within the record's site.",
                    ),
                ),
                ("sample_id", utils.fields.UpperCharField()),
                ("run_name", utils.fields.UpperCharField()),
                ("collection_month", utils.fields.YearMonthField(null=True)),
                ("received_month", utils.fields.YearMonthField(null=True)),
                ("char_max_length_20", models.CharField(max_length=20)),
                ("text_option_1", models.TextField(blank=True)),
                ("text_option_2", models.TextField(blank=True)),
                ("submission_date", models.DateField(null=True)),
                ("country", utils.fields.ChoiceField(blank=True, max_length=20)),
                ("region", utils.fields.ChoiceField(blank=True, max_length=20)),
                ("concern", models.BooleanField(null=True)),
                ("tests", models.IntegerField(null=True)),
                ("score", models.FloatField(null=True)),
                ("start", models.IntegerField()),
                ("end", models.IntegerField()),
                ("required_when_published", models.TextField(blank=True)),
                (
                    "site",
                    utils.fields.SiteField(
                        help_text="Site that uploaded the record.",
                        on_delete=django.db.models.deletion.PROTECT,
                        to="accounts.site",
                        to_field="code",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "default_permissions": [],
            },
        ),
        migrations.CreateModel(
            name="TestModel",
            fields=[
                (
                    "basetestmodel_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="testproject.basetestmodel",
                    ),
                ),
            ],
            options={
                "default_permissions": [],
            },
            bases=("testproject.basetestmodel",),
        ),
        migrations.CreateModel(
            name="HistoricalBaseTestModel",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                (
                    "uuid",
                    models.UUIDField(db_index=True, default=uuid.uuid4, editable=False),
                ),
                ("created", models.DateTimeField(blank=True, editable=False)),
                ("last_modified", models.DateTimeField(blank=True, editable=False)),
                (
                    "climb_id",
                    utils.fields.UpperCharField(
                        db_index=True,
                        help_text="Unique identifier for a project record in Onyx.",
                        max_length=12,
                    ),
                ),
                (
                    "is_published",
                    models.BooleanField(
                        default=True,
                        help_text="Indicator for whether a project record has been published.",
                    ),
                ),
                (
                    "published_date",
                    models.DateField(
                        help_text="The date the project record was published in Onyx.",
                        null=True,
                    ),
                ),
                (
                    "is_suppressed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicator for whether a project record has been hidden from users.",
                    ),
                ),
                (
                    "is_site_restricted",
                    models.BooleanField(
                        default=False,
                        help_text="Indicator for whether a project record has been hidden from users not within the record's site.",
                    ),
                ),
                ("sample_id", utils.fields.UpperCharField()),
                ("run_name", utils.fields.UpperCharField()),
                ("collection_month", utils.fields.YearMonthField(null=True)),
                ("received_month", utils.fields.YearMonthField(null=True)),
                ("char_max_length_20", models.CharField(max_length=20)),
                ("text_option_1", models.TextField(blank=True)),
                ("text_option_2", models.TextField(blank=True)),
                ("submission_date", models.DateField(null=True)),
                ("country", utils.fields.ChoiceField(blank=True, max_length=20)),
                ("region", utils.fields.ChoiceField(blank=True, max_length=20)),
                ("concern", models.BooleanField(null=True)),
                ("tests", models.IntegerField(null=True)),
                ("score", models.FloatField(null=True)),
                ("start", models.IntegerField()),
                ("end", models.IntegerField()),
                ("required_when_published", models.TextField(blank=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    utils.fields.SiteField(
                        blank=True,
                        db_constraint=False,
                        help_text="Site that uploaded the record.",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="accounts.site",
                        to_field="code",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical base test model",
                "verbose_name_plural": "historical base test models",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalTestModel",
            fields=[
                (
                    "basetestmodel_ptr",
                    models.ForeignKey(
                        auto_created=True,
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        parent_link=True,
                        related_name="+",
                        to="testproject.basetestmodel",
                    ),
                ),
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                (
                    "uuid",
                    models.UUIDField(db_index=True, default=uuid.uuid4, editable=False),
                ),
                ("created", models.DateTimeField(blank=True, editable=False)),
                ("last_modified", models.DateTimeField(blank=True, editable=False)),
                (
                    "climb_id",
                    utils.fields.UpperCharField(
                        db_index=True,
                        help_text="Unique identifier for a project record in Onyx.",
                        max_length=12,
                    ),
                ),
                (
                    "is_published",
                    models.BooleanField(
                        default=True,
                        help_text="Indicator for whether a project record has been published.",
                    ),
                ),
                (
                    "published_date",
                    models.DateField(
                        help_text="The date the project record was published in Onyx.",
                        null=True,
                    ),
                ),
                (
                    "is_suppressed",
                    models.BooleanField(
                        default=False,
                        help_text="Indicator for whether a project record has been hidden from users.",
                    ),
                ),
                (
                    "is_site_restricted",
                    models.BooleanField(
                        default=False,
                        help_text="Indicator for whether a project record has been hidden from users not within the record's site.",
                    ),
                ),
                ("sample_id", utils.fields.UpperCharField()),
                ("run_name", utils.fields.UpperCharField()),
                ("collection_month", utils.fields.YearMonthField(null=True)),
                ("received_month", utils.fields.YearMonthField(null=True)),
                ("char_max_length_20", models.CharField(max_length=20)),
                ("text_option_1", models.TextField(blank=True)),
                ("text_option_2", models.TextField(blank=True)),
                ("submission_date", models.DateField(null=True)),
                ("country", utils.fields.ChoiceField(blank=True, max_length=20)),
                ("region", utils.fields.ChoiceField(blank=True, max_length=20)),
                ("concern", models.BooleanField(null=True)),
                ("tests", models.IntegerField(null=True)),
                ("score", models.FloatField(null=True)),
                ("start", models.IntegerField()),
                ("end", models.IntegerField()),
                ("required_when_published", models.TextField(blank=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    utils.fields.SiteField(
                        blank=True,
                        db_constraint=False,
                        help_text="Site that uploaded the record.",
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="accounts.site",
                        to_field="code",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "historical test model",
                "verbose_name_plural": "historical test models",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="TestModelRecord",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "uuid",
                    models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("last_modified", models.DateTimeField(auto_now=True)),
                ("test_id", models.IntegerField()),
                ("test_pass", models.BooleanField()),
                ("test_start", utils.fields.YearMonthField()),
                ("test_end", utils.fields.YearMonthField()),
                ("score_a", models.FloatField(null=True)),
                ("score_b", models.FloatField(null=True)),
                ("score_c", models.FloatField(null=True)),
                ("test_result", models.TextField(blank=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "link",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="records",
                        to="testproject.testmodel",
                    ),
                ),
            ],
            options={
                "default_permissions": [],
            },
        ),
        migrations.CreateModel(
            name="HistoricalTestModelRecord",
            fields=[
                (
                    "id",
                    models.BigIntegerField(
                        auto_created=True, blank=True, db_index=True, verbose_name="ID"
                    ),
                ),
                (
                    "uuid",
                    models.UUIDField(db_index=True, default=uuid.uuid4, editable=False),
                ),
                ("created", models.DateTimeField(blank=True, editable=False)),
                ("last_modified", models.DateTimeField(blank=True, editable=False)),
                ("test_id", models.IntegerField()),
                ("test_pass", models.BooleanField()),
                ("test_start", utils.fields.YearMonthField()),
                ("test_end", utils.fields.YearMonthField()),
                ("score_a", models.FloatField(null=True)),
                ("score_b", models.FloatField(null=True)),
                ("score_c", models.FloatField(null=True)),
                ("test_result", models.TextField(blank=True)),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "link",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="testproject.testmodel",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical test model record",
                "verbose_name_plural": "historical test model records",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["created"], name="testproject_created_4cf37a_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["climb_id"], name="testproject_climb_i_3ebdce_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["is_published"], name="testproject_is_publ_bd1b2d_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["published_date"], name="testproject_publish_f18b97_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["is_suppressed"], name="testproject_is_supp_487401_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(fields=["site"], name="testproject_site_id_98b893_idx"),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["is_site_restricted"], name="testproject_is_site_9bbbf1_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["sample_id", "run_name"], name="testproject_sample__a4c10d_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["sample_id"], name="testproject_sample__7cacea_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["run_name"], name="testproject_run_nam_71a1f9_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["collection_month"], name="testproject_collect_340ba7_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="basetestmodel",
            index=models.Index(
                fields=["received_month"], name="testproject_receive_aa2cac_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="basetestmodel",
            constraint=models.UniqueConstraint(
                fields=("sample_id", "run_name"),
                name="testproject_basetestmodel_sample__401e0b_ut",
            ),
        ),
        migrations.AddConstraint(
            model_name="basetestmodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("collection_month__isnull", False),
                    ("received_month__isnull", False),
                    _connector="OR",
                ),
                name="testproject_basetestmodel_collect_a6369e_ovg",
                violation_error_message="At least one of collection_month, received_month is required.",
            ),
        ),
        migrations.AddConstraint(
            model_name="basetestmodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("text_option_1__isnull", False),
                    ("text_option_2__isnull", False),
                    _connector="OR",
                ),
                name="testproject_basetestmodel_text_op_d4965a_ovg",
                violation_error_message="At least one of text_option_1, text_option_2 is required.",
            ),
        ),
        migrations.AddConstraint(
            model_name="basetestmodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("collection_month__isnull", True),
                    ("received_month__isnull", True),
                    ("collection_month__lte", models.F("received_month")),
                    _connector="OR",
                ),
                name="testproject_basetestmodel_collect_c39c65_ord",
                violation_error_message="The collection_month must be less than or equal to received_month.",
            ),
        ),
        migrations.AddConstraint(
            model_name="basetestmodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("start__isnull", True),
                    ("end__isnull", True),
                    ("start__lte", models.F("end")),
                    _connector="OR",
                ),
                name="testproject_basetestmodel_start_e_d47778_ord",
                violation_error_message="The start must be less than or equal to end.",
            ),
        ),
        migrations.AddConstraint(
            model_name="basetestmodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(
                        ("collection_month__isnull", True),
                        ("collection_month__lte", models.F("last_modified")),
                        _connector="OR",
                    ),
                    models.Q(
                        ("received_month__isnull", True),
                        ("received_month__lte", models.F("last_modified")),
                        _connector="OR",
                    ),
                    models.Q(
                        ("submission_date__isnull", True),
                        ("submission_date__lte", models.F("last_modified")),
                        _connector="OR",
                    ),
                ),
                name="testproject_basetestmodel_collect_d74368_nf",
                violation_error_message="At least one of collection_month, received_month, submission_date is from the future.",
            ),
        ),
        migrations.AddConstraint(
            model_name="basetestmodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(("region__isnull", False), _negated=True),
                    ("country__isnull", False),
                    _connector="OR",
                ),
                name="testproject_basetestmodel_region__97e2cd_cr",
                violation_error_message="Each of country are required in order to set region.",
            ),
        ),
        migrations.AddConstraint(
            model_name="basetestmodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(("is_published", True), _negated=True),
                    ("published_date__isnull", False),
                    _connector="OR",
                ),
                name="testproject_basetestmodel_is_publ_f136db_cvr",
                violation_error_message="Each of published_date are required in order to set is_published to the value.",
            ),
        ),
        migrations.AddConstraint(
            model_name="basetestmodel",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(("is_published", True), _negated=True),
                    ("required_when_published__isnull", False),
                    _connector="OR",
                ),
                name="testproject_basetestmodel_is_publ_ad9782_cvr",
                violation_error_message="Each of required_when_published are required in order to set is_published to the value.",
            ),
        ),
        migrations.AddIndex(
            model_name="testmodelrecord",
            index=models.Index(
                fields=["created"], name="testproject_created_d106fb_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="testmodelrecord",
            index=models.Index(
                fields=["link", "test_id"], name="testproject_link_id_b0f35e_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="testmodelrecord",
            constraint=models.UniqueConstraint(
                fields=("link", "test_id"),
                name="testproject_testmodelrecord_link_te_d335bd_ut",
            ),
        ),
        migrations.AddConstraint(
            model_name="testmodelrecord",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("score_a__isnull", False),
                    ("score_b__isnull", False),
                    _connector="OR",
                ),
                name="testproject_testmodelrecord_score_a_469f82_ovg",
                violation_error_message="At least one of score_a, score_b is required.",
            ),
        ),
        migrations.AddConstraint(
            model_name="testmodelrecord",
            constraint=models.CheckConstraint(
                check=models.Q(
                    ("test_start__isnull", True),
                    ("test_end__isnull", True),
                    ("test_start__lte", models.F("test_end")),
                    _connector="OR",
                ),
                name="testproject_testmodelrecord_test_st_f445a4_ord",
                violation_error_message="The test_start must be less than or equal to test_end.",
            ),
        ),
        migrations.AddConstraint(
            model_name="testmodelrecord",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(("score_c__isnull", False), _negated=True),
                    models.Q(("score_a__isnull", False), ("score_b__isnull", False)),
                    _connector="OR",
                ),
                name="testproject_testmodelrecord_score_c_578323_cr",
                violation_error_message="Each of score_a, score_b are required in order to set score_c.",
            ),
        ),
        migrations.AddConstraint(
            model_name="testmodelrecord",
            constraint=models.CheckConstraint(
                check=models.Q(
                    models.Q(("test_pass", True), _negated=True),
                    ("test_result__isnull", False),
                    _connector="OR",
                ),
                name="testproject_testmodelrecord_test_pa_33f767_cvr",
                violation_error_message="Each of test_result are required in order to set test_pass to the value.",
            ),
        ),
    ]
