---
hide:
  - navigation
  # - toc
  - footer
---

# Onyx - API for Pathogen Metadata

## Introduction

This is the documentation for [Onyx](https://github.com/CLIMB-TRE/onyx), a database and API for managing sample metadata, their analyses, and other associated data.

As part of [CLIMB-TRE](https://climb-tre.github.io/), Onyx serves as the central metadata repository for the following projects:

- [mSCAPE](https://mscape.climb.ac.uk/) (Metagenomics Surveillance Collaboration and Analysis Programme)<br>
  A collaborative initiative led by UKHSA, involving a consortium of NHS and academic partners, to deliver a pilot surveillance network trialling the use of metagenomic data for public health surveillance and pathogen analysis.
- [PATH-SAFE](https://www.food.gov.uk/our-work/pathogen-surveillance-in-agriculture-food-and-environment-path-safe-programme) (Pathogen Surveillance in Agriculture, Food and Environment)<br>
  Led by the FSA, PATH-SAFE piloted the development of a national surveillance network to improve the detection and tracking of foodborne human pathogens and AMR within agriculture.
- [synthSCAPE](https://climb-tre.github.io/synthscape/) (Synthetic dataset for mSCAPE)
- [openMGS](https://climb-tre.github.io/openmgs/) (Open Meta-Genomic Surveillance)

## Contents

[CLI & Python API](https://climb-tre.github.io/onyx-client)<br>
Learn how to use the Onyx command-line interface and Python API.

[JupyterLab Extension](https://climb-tre.github.io/onyx-extension)<br>
Learn how to use the Onyx JupyterLab extension and graphical user interface.

[Types](fields/types.md)<br>
Learn about the different field types available in Onyx.

[Lookups](fields/lookups.md)<br>
Learn about the different field lookups available in Onyx.
