# Generated by Django 5.0.3 on 2024-03-12 11:36

import data.models
import django.db.models.deletion
import utils.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("accounts", "0001_initial"),
        ("auth", "0012_alter_user_first_name_max_length"),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="ClimbID",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "climb_id",
                    utils.fields.UpperCharField(
                        default=data.models.generate_climb_id,
                        max_length=12,
                        unique=True,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Project",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", utils.fields.LowerCharField(max_length=50, unique=True)),
                ("name", utils.fields.StrippedCharField(max_length=100, unique=True)),
                ("description", models.TextField(blank=True)),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Anonymiser",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("field", utils.fields.LowerCharField(max_length=100)),
                ("prefix", utils.fields.UpperCharField(max_length=5)),
                ("hash", models.TextField()),
                ("identifier", utils.fields.UpperCharField(max_length=20, unique=True)),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="accounts.site"
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="data.project"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ProjectGroup",
            fields=[
                (
                    "group",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to="auth.group",
                    ),
                ),
                ("scope", utils.fields.LowerCharField(max_length=50)),
                ("actions", models.TextField(blank=True)),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="data.project"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Choice",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("field", models.TextField()),
                ("choice", models.TextField()),
                ("is_active", models.BooleanField(default=True)),
                (
                    "constraints",
                    models.ManyToManyField(
                        related_name="reverse_constraints", to="data.choice"
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="data.project",
                        to_field="code",
                    ),
                ),
            ],
            options={
                "indexes": [
                    models.Index(
                        fields=["project", "field"],
                        name="data_choice_project_4cedd2_idx",
                    )
                ],
            },
        ),
        migrations.AddConstraint(
            model_name="choice",
            constraint=models.UniqueConstraint(
                fields=("project", "field", "choice"),
                name="data_choice_project_92f67f_ut",
            ),
        ),
        migrations.AddIndex(
            model_name="anonymiser",
            index=models.Index(
                fields=["project", "site", "field", "hash"],
                name="data_anonym_project_889b78_idx",
            ),
        ),
        migrations.AddConstraint(
            model_name="anonymiser",
            constraint=models.UniqueConstraint(
                fields=("project", "site", "field", "hash"),
                name="data_anonymiser_project_a26ba3_ut",
            ),
        ),
        migrations.AddConstraint(
            model_name="projectgroup",
            constraint=models.UniqueConstraint(
                fields=("project", "scope"), name="data_projectgroup_project_a535ad_ut"
            ),
        ),
    ]
