# Generated by Django 5.0.8 on 2024-09-12 17:34

import data.models
import django.db.models.deletion
import utils.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("data", "0009_alter_choice_constraints"),
    ]

    operations = [
        migrations.CreateModel(
            name="Analysis",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "analysis_id",
                    utils.fields.UpperCharField(
                        default=data.models.generate_analysis_id,
                        help_text="Unique identifier for a project analysis in Onyx.",
                        max_length=12,
                        unique=True,
                    ),
                ),
                (
                    "published_date",
                    models.DateField(
                        help_text="The date the project analysis was published in Onyx."
                    ),
                ),
                (
                    "analysis_date",
                    models.DateField(
                        help_text="The date the analysis was carried out."
                    ),
                ),
                ("name", utils.fields.StrippedCharField(max_length=100, unique=True)),
                ("command_details", models.TextField(blank=True)),
                ("pipeline_details", models.TextField(blank=True)),
                ("experiment_details", models.JSONField(default=dict)),
                ("result", models.TextField(blank=True)),
                ("report", models.TextField(blank=True)),
                ("outputs", models.TextField(blank=True)),
                (
                    "identifiers",
                    models.ManyToManyField(
                        related_name="analyses", to="data.anonymiser"
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="data.project"
                    ),
                ),
                (
                    "upstream_analyses",
                    models.ManyToManyField(
                        related_name="downstream_analyses", to="data.analysis"
                    ),
                ),
            ],
        ),
        migrations.DeleteModel(
            name="AnalysisID",
        ),
    ]
