Bug fixes and contributions are welcome!

If you're looking for ideas for where to get started, consider jumping in on any of these areas:

### Examples

To contribute examples, please follow the current style of the examples. Add your example's title and file name to `ExampleList.js` file for it to appear in the examples list on the index page. 

### Docs

There is always more work that can be done on documentation. Especially adding good examples to methods and members to make the docs more informative and useful for people coming from diverse musical and technical backgrounds. 

All of the docs are written in [jsdoc](http://usejsdoc.org/)-style comments in the source code. If you catch a mistake, please send a pull request. 

Along with this, It'd be great to integrate more visuals and references in the docs to help illustrate concepts. 

### Forum

If you are someone who is familiar with Tone.js, consider jumping in on [the forum](https://groups.google.com/forum/#!forum/tonejs) to answer some questions.

### Tutorials

I'd love to see more tutorials for newcomers to Tone.js to help them get up and running or solve a particular issue. If you make a tutorial, please send me a link.

### Tests 

Tone.js has an extensive [test suite](https://github.com/Tonejs/Tone.js/wiki/Testing) using Mocha and Chai. 

Along with more unit tests, I'd also be great to have more tests which run in the online context and generate music to help find bugs by ear that the automated tests might not illuminate. [Audiokit](http://audiokit.io/tests/), for example, has a great suite of aural tests.

You can also take a look at Tone.js' [code coverage](https://coveralls.io/github/Tonejs/Tone.js) to get an idea of where more tests might be helpful. 

### Synths/Effects

If you'd like to contribute a cool and expressive synth or effect, i'd love to hear it. Please send me an example that i can play with along with the PR. 