![build](https://github.com/CNES/aviso-fes/actions/workflows/ci.yaml/badge.svg)
[![platforms](https://anaconda.org/conda-forge/pyfes/badges/platforms.svg?service=github)](https://anaconda.org/conda-forge/pyfes)
[![latest-release-date](https://anaconda.org/conda-forge/pyfes/badges/latest_release_date.svg?service=github)](https://github.com/CNES/pangeo-pyfes/commits/master)
[![license](https://anaconda.org/conda-forge/pyfes/badges/license.svg?service=github)](https://opensource.org/licenses/BSD-3-Clause)
[![download](https://anaconda.org/conda-forge/pyfes/badges/downloads.svg?service=github)](https://anaconda.org/conda-forge/pyfes)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/CNES/aviso-fes/main?urlpath=lab/tree/notebooks/)

# DESCRIPTION

This package is the fully revised version of the FES2022 distribution. This
distribution includes the FES2022 tidal prediction software managed on this page
and the [FES2022 tides databases](data/fes2022/README.md) A full description of
the FES2022 tidal solution is given in the handbook
(https://www.aviso.altimetry.fr/fileadmin/documents/data/tools/hdbk_FES2022.pdf)
and in the paper (Lyard et al. 2024).

> This new code is under development and it is designed to handle the new finite
> element grids of FES2022. It will become official at the end of this year. For
> now, we do not provide support for this new version.

# CREDITS

When using FES2022, please mention: *FES2022 was produced by LEGOS, NOVELTIS and
CLS Ocean and Climate Division; the project was funded by CNES. It is
distributed by AVISO, with support from CNES (http://www.aviso.altimetry.fr/)*

# DOCUMENTATION

The documentation of the FES2022 software is available on the readthedocs
platform: https://cnes.github.io/aviso-fes/

# LEGACY C VERSION

The legacy C version of the FES software is available on his own branch:
https://github.com/CNES/aviso-fes/tree/legacy-c-version-archive

The reference version to compute the FES2022b tidal solution is
[2.9.7](https://github.com/CNES/aviso-fes/releases/tag/2.9.7).

> This version of the library will no longer be updated.

# BIBLIOGRAPHY

* Lyard, F. H., Carrere, L., Fouchet, E., Cancet, M., Greenberg, D.,
  Dibarboure, G. and Picot, N.: "FES2022 a step towards a SWOT-compliant tidal
  correction", in preparation, to be submitted to Ocean Sciences in 2024.

* Lyard, F. H., Allain, D. J., Cancet, M., Carrère, L., and Picot, N.: FES2014
  global ocean tide atlas: design and performance, Ocean Sci., 17, 615–649,
  https://doi.org/10.5194/os-17-615-2021, 2021.

* Carrere L., F. Lyard, M. Cancet, A. Guillot, N. Picot: *FES 2014, a new tidal
  model - Validation results and perspectives for improvements*, presentation to
  ESA Living Planet Conference, Prague 2016.

# CONTACT

[aviso@altimetry.fr](mailto:aviso@altimetry.fr)
