// Copyright (c) 2025 CNES
//
// All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
/// @file include/fes/detail/wave/name.hpp
/// @brief Wave names
#pragma once

namespace fes {
namespace detail {
namespace wave {
namespace name {

/// @brief 2MK3
constexpr const char* const k2MK3 = "2MK3";
/// @brief 2MK6
constexpr const char* const k2MK6 = "2MK6";
/// @brief 2MN2
constexpr const char* const k2MN2 = "2MN2";
/// @brief 2MN6
constexpr const char* const k2MN6 = "2MN6";
/// @brief 2MS2
constexpr const char* const k2MS2 = "2MS2";
/// @brief 2MS6
constexpr const char* const k2MS6 = "2MS6";
/// @brief 2N2
constexpr const char* const k2N2 = "2N2";
/// @brief 2Q1
constexpr const char* const k2Q1 = "2Q1";
/// @brief 2SM2
constexpr const char* const k2SM2 = "2SM2";
/// @brief 2SM6
constexpr const char* const k2SM6 = "2SM6";
/// @brief A5
constexpr const char* const kA5 = "A5";
/// @brief Chi1
constexpr const char* const kChi1 = "Chi1";
/// @brief Eps2
constexpr const char* const kEps2 = "Eps2";
/// @brief Eta2
constexpr const char* const kEta2 = "Eta2";
/// @brief J1
constexpr const char* const kJ1 = "J1";
/// @brief K1
constexpr const char* const kK1 = "K1";
/// @brief K2
constexpr const char* const kK2 = "K2";
/// @brief L2
constexpr const char* const kL2 = "L2";
/// @brief Lambda2
constexpr const char* const kLambda2 = "Lambda2";
/// @brief M0
constexpr const char* const kM0 = "M0";
/// @brief M11
constexpr const char* const kM11 = "M11";
/// @brief M12
constexpr const char* const kM12 = "M12";
/// @brief M13
constexpr const char* const kM13 = "M13";
/// @brief M2
constexpr const char* const kM2 = "M2";
/// @brief M3
constexpr const char* const kM3 = "M3";
/// @brief M4
constexpr const char* const kM4 = "M4";
/// @brief M6
constexpr const char* const kM6 = "M6";
/// @brief M8
constexpr const char* const kM8 = "M8";
/// @brief Mf
constexpr const char* const kMf = "Mf";
/// @brief Mf1
constexpr const char* const kMf1 = "Mf1";
/// @brief Mf2
constexpr const char* const kMf2 = "Mf2";
/// @brief MK3
constexpr const char* const kMK3 = "MK3";
/// @brief MK4
constexpr const char* const kMK4 = "MK4";
/// @brief MKS2
constexpr const char* const kMKS2 = "MKS2";
/// @brief Mm
constexpr const char* const kMm = "Mm";
/// @brief Mm1
constexpr const char* const kMm1 = "Mm1";
/// @brief Mm2
constexpr const char* const kMm2 = "Mm2";
/// @brief MN4
constexpr const char* const kMN4 = "MN4";
/// @brief MNS2
constexpr const char* const kMNS2 = "MNS2";
/// @brief MO3
constexpr const char* const kMO3 = "MO3";
/// @brief MP1
constexpr const char* const kMP1 = "MP1";
/// @brief MS4
constexpr const char* const kMS4 = "MS4";
/// @brief MSf
constexpr const char* const kMSf = "MSf";
/// @brief MSK6
constexpr const char* const kMSK6 = "MSK6";
/// @brief MSN2
constexpr const char* const kMSN2 = "MSN2";
/// @brief MSN6
constexpr const char* const kMSN6 = "MSN6";
/// @brief Msqm
constexpr const char* const kMsqm = "Msqm";
/// @brief Mtm
constexpr const char* const kMtm = "Mtm";
/// @brief Mu2
constexpr const char* const kMu2 = "Mu2";
/// @brief N2
constexpr const char* const kN2 = "N2";
/// @brief N4
constexpr const char* const kN4 = "N4";
/// @brief Nu2
constexpr const char* const kNu2 = "Nu2";
/// @brief O1
constexpr const char* const kO1 = "O1";
/// @brief OO1
constexpr const char* const kOO1 = "OO1";
/// @brief P1
constexpr const char* const kP1 = "P1";
/// @brief Phi1
constexpr const char* const kPhi1 = "Phi1";
/// @brief Pi1
constexpr const char* const kPi1 = "Pi1";
/// @brief Psi1
constexpr const char* const kPsi1 = "Psi1";
/// @brief Q1
constexpr const char* const kQ1 = "Q1";
/// @brief R2
constexpr const char* const kR2 = "R2";
/// @brief R4
constexpr const char* const kR4 = "R4";
/// @brief Rho1
constexpr const char* const kRho1 = "Rho1";
/// @brief S1
constexpr const char* const kS1 = "S1";
/// @brief S2
constexpr const char* const kS2 = "S2";
/// @brief S4
constexpr const char* const kS4 = "S4";
/// @brief S6
constexpr const char* const kS6 = "S6";
/// @brief Sa
constexpr const char* const kSa = "Sa";
/// @brief Sa1
constexpr const char* const kSa1 = "Sa1";
/// @brief Sigma1
constexpr const char* const kSigma1 = "Sigma1";
/// @brief SK4
constexpr const char* const kSK4 = "SK4";
/// @brief SN4
constexpr const char* const kSN4 = "SN4";
/// @brief Ssa
constexpr const char* const kSsa = "Ssa";
/// @brief Sta
constexpr const char* const kSta = "Sta";
/// @brief T2
constexpr const char* const kT2 = "T2";
/// @brief Theta1
constexpr const char* const kTheta1 = "Theta1";

}  // namespace name
}  // namespace wave
}  // namespace detail
}  // namespace fes
