/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.signin.zzb;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzmq;
import com.google.android.gms.internal.zzmt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleSignInAccount
implements SafeParcelable {
    public static final Parcelable.Creator<GoogleSignInAccount> CREATOR = new zzb();
    public static zzmq zzWO = zzmt.zzsc();
    final int versionCode;
    private String zzyv;
    private String zzWk;
    private String zzWP;
    private String zzWQ;
    private Uri zzWR;
    private String zzWS;
    private long zzWT;
    private String zzWU;
    List<Scope> zzVs;
    private static Comparator<Scope> zzWV = new Comparator<Scope>(){

        public int zza(Scope scope, Scope scope2) {
            return scope.zzpb().compareTo(scope2.zzpb());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Scope)object, (Scope)object2);
        }
    };

    @Nullable
    public static GoogleSignInAccount zzbH(@Nullable String string2) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(string2);
        Uri uri = null;
        String string3 = jSONObject.optString("photoUrl", null);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            uri = Uri.parse((String)string3);
        }
        long l = Long.parseLong(jSONObject.getString("expirationTime"));
        HashSet<Scope> hashSet = new HashSet<Scope>();
        JSONArray jSONArray = jSONObject.getJSONArray("grantedScopes");
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            hashSet.add(new Scope(jSONArray.getString(i)));
        }
        return GoogleSignInAccount.zza(jSONObject.optString("id"), jSONObject.optString("tokenId", null), jSONObject.optString("email", null), jSONObject.optString("displayName", null), uri, l, jSONObject.getString("obfuscatedIdentifier"), hashSet).zzbI(jSONObject.optString("serverAuthCode", null));
    }

    public static GoogleSignInAccount zza(@Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable Uri uri, @Nullable Long l, @NonNull String string6, @NonNull Set<Scope> set) {
        if (l == null) {
            l = zzWO.currentTimeMillis() / 1000L;
        }
        return new GoogleSignInAccount(2, string2, string3, string4, string5, uri, null, l, zzx.zzcM(string6), new ArrayList<Scope>((Collection)zzx.zzz(set)));
    }

    GoogleSignInAccount(int versionCode, String id, String idToken, String email, String displayName, Uri photoUrl, String serverAuthCode, long expirationTimeSecs, String obfuscatedIdentifier, List<Scope> grantedScopes) {
        this.versionCode = versionCode;
        this.zzyv = id;
        this.zzWk = idToken;
        this.zzWP = email;
        this.zzWQ = displayName;
        this.zzWR = photoUrl;
        this.zzWS = serverAuthCode;
        this.zzWT = expirationTimeSecs;
        this.zzWU = obfuscatedIdentifier;
        this.zzVs = grantedScopes;
    }

    @Nullable
    public String getId() {
        return this.zzyv;
    }

    @Nullable
    public String getIdToken() {
        return this.zzWk;
    }

    @Nullable
    public String getEmail() {
        return this.zzWP;
    }

    @Nullable
    public String getDisplayName() {
        return this.zzWQ;
    }

    @Nullable
    public Uri getPhotoUrl() {
        return this.zzWR;
    }

    public GoogleSignInAccount zzbI(String string2) {
        this.zzWS = string2;
        return this;
    }

    @Nullable
    public String getServerAuthCode() {
        return this.zzWS;
    }

    public long zzmK() {
        return this.zzWT;
    }

    public boolean zzb() {
        return zzWO.currentTimeMillis() / 1000L >= this.zzWT - 300L;
    }

    @NonNull
    public String zzmL() {
        return this.zzWU;
    }

    @NonNull
    public Set<Scope> getGrantedScopes() {
        return new HashSet<Scope>(this.zzVs);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GoogleSignInAccount)) {
            return false;
        }
        GoogleSignInAccount googleSignInAccount = (GoogleSignInAccount)obj;
        return googleSignInAccount.zzmI().equals(this.zzmI());
    }

    public String zzmI() {
        return this.zzmJ().toString();
    }

    public String zzmM() {
        JSONObject jSONObject = this.zzmJ();
        jSONObject.remove("serverAuthCode");
        return jSONObject.toString();
    }

    private JSONObject zzmJ() {
        JSONObject jSONObject = new JSONObject();
        try {
            if (this.getId() != null) {
                jSONObject.put("id", (Object)this.getId());
            }
            if (this.getIdToken() != null) {
                jSONObject.put("tokenId", (Object)this.getIdToken());
            }
            if (this.getEmail() != null) {
                jSONObject.put("email", (Object)this.getEmail());
            }
            if (this.getDisplayName() != null) {
                jSONObject.put("displayName", (Object)this.getDisplayName());
            }
            if (this.getPhotoUrl() != null) {
                jSONObject.put("photoUrl", (Object)this.getPhotoUrl().toString());
            }
            if (this.getServerAuthCode() != null) {
                jSONObject.put("serverAuthCode", (Object)this.getServerAuthCode());
            }
            jSONObject.put("expirationTime", this.zzWT);
            jSONObject.put("obfuscatedIdentifier", (Object)this.zzmL());
            JSONArray jSONArray = new JSONArray();
            Collections.sort(this.zzVs, zzWV);
            for (Scope scope : this.zzVs) {
                jSONArray.put((Object)scope.zzpb());
            }
            jSONObject.put("grantedScopes", (Object)jSONArray);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

