/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.api.internal.zzp;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.api.internal.zzv;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.internal.zzmf;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzro;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzj
extends GoogleApiClient
implements zzp.zza {
    private final Lock zzXG;
    private final zzk zzahL;
    private zzp zzahM = null;
    private final int zzagp;
    private final Context mContext;
    private final Looper zzagr;
    final Queue<zza.zza<?, ?>> zzahN = new LinkedList();
    private volatile boolean zzahO;
    private long zzahP = 120000L;
    private long zzahQ = 5000L;
    private final zza zzahR;
    private final com.google.android.gms.common.zzc zzags;
    zzc zzahS;
    final Map<Api.zzc<?>, Api.zzb> zzahT;
    Set<Scope> zzahU = new HashSet<Scope>();
    final zzf zzahz;
    final Map<Api<?>, Integer> zzahA;
    final Api.zza<? extends zzrn, zzro> zzagt;
    private final Set<zzq<?>> zzahV = Collections.newSetFromMap(new WeakHashMap());
    final Set<zze<?>> zzahW = Collections.newSetFromMap(new ConcurrentHashMap(16, 0.75f, 2));
    private com.google.android.gms.common.api.zza zzahX;
    private final ArrayList<com.google.android.gms.common.api.internal.zzc> zzahY;
    private Integer zzahZ = null;
    Set<zzx> zzaia = null;
    private final zzd zzaib = new zzd(){

        @Override
        public void zzc(zze<?> zze2) {
            zzj.this.zzahW.remove(zze2);
            if (zze2.zzpa() != null && zzj.this.zzahX != null) {
                zzj.this.zzahX.remove(zze2.zzpa());
            }
        }
    };
    private final zzk.zza zzaic = new zzk.zza(){

        @Override
        public boolean isConnected() {
            return zzj.this.isConnected();
        }

        @Override
        public Bundle zzoi() {
            return null;
        }
    };

    private static void zza(zze<?> zze2, com.google.android.gms.common.api.zza zza2, IBinder iBinder) {
        if (zze2.isReady()) {
            zzb zzb2 = new zzb(zze2, zza2, iBinder);
            zze2.zza(zzb2);
        } else if (iBinder != null && iBinder.isBinderAlive()) {
            zzb zzb3 = new zzb(zze2, zza2, iBinder);
            zze2.zza(zzb3);
            try {
                iBinder.linkToDeath((IBinder.DeathRecipient)zzb3, 0);
            }
            catch (RemoteException remoteException) {
                zze2.cancel();
                zza2.remove(zze2.zzpa());
            }
        } else {
            zze2.zza(null);
            zze2.cancel();
            zza2.remove(zze2.zzpa());
        }
    }

    public zzj(Context context, Lock lock, Looper looper, zzf zzf2, com.google.android.gms.common.zzc zzc2, Api.zza<? extends zzrn, zzro> zza2, Map<Api<?>, Integer> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zzb> map2, int n, int n2, ArrayList<com.google.android.gms.common.api.internal.zzc> arrayList) {
        this.mContext = context;
        this.zzXG = lock;
        this.zzahL = new zzk(looper, this.zzaic);
        this.zzagr = looper;
        this.zzahR = new zza(looper);
        this.zzags = zzc2;
        this.zzagp = n;
        if (this.zzagp >= 0) {
            this.zzahZ = n2;
        }
        this.zzahA = map;
        this.zzahT = map2;
        this.zzahY = arrayList;
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.zzahL.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.zzahL.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.zzahz = zzf2;
        this.zzagt = zza2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zzb, R extends Result, T extends zza.zza<R, A>> T zza(@NonNull T t) {
        com.google.android.gms.common.internal.zzx.zzb(t.zzoR() != null, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        com.google.android.gms.common.internal.zzx.zzb(this.zzahT.containsKey(t.zzoR()), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        this.zzXG.lock();
        try {
            if (this.zzahM == null) {
                this.zzahN.add(t);
                T t2 = t;
                return t2;
            }
            T t3 = this.zzahM.zza(t);
            return t3;
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A extends Api.zzb, T extends zza.zza<? extends Result, A>> T zzb(@NonNull T t) {
        com.google.android.gms.common.internal.zzx.zzb(t.zzoR() != null, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        this.zzXG.lock();
        try {
            if (this.zzahM == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.zzpB()) {
                Object object;
                this.zzahN.add(t);
                while (!this.zzahN.isEmpty()) {
                    object = this.zzahN.remove();
                    this.zzb((zze<A>)object);
                    object.zzw(Status.zzagE);
                }
                object = t;
                return (T)object;
            }
            T t2 = this.zzahM.zzb(t);
            return t2;
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <L> zzq<L> zzr(@NonNull L l) {
        com.google.android.gms.common.internal.zzx.zzb(l, (Object)"Listener must not be null");
        this.zzXG.lock();
        try {
            zzq<L> zzq2 = new zzq<L>(this.zzagr, l);
            this.zzahV.add(zzq2);
            zzq<L> zzq3 = zzq2;
            return zzq3;
        }
        finally {
            this.zzXG.unlock();
        }
    }

    @Override
    @NonNull
    public <C extends Api.zzb> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zzb zzb2 = this.zzahT.get(zzc2);
        com.google.android.gms.common.internal.zzx.zzb(zzb2, (Object)"Appropriate Api was not requested.");
        return (C)zzb2;
    }

    @Override
    public boolean zza(@NonNull Api<?> api) {
        return this.zzahT.containsKey(api.zzoR());
    }

    @Override
    public boolean hasConnectedApi(@NonNull Api<?> api) {
        Api.zzb zzb2 = this.zzahT.get(api.zzoR());
        return zzb2 != null && zzb2.isConnected();
    }

    @Override
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        this.zzXG.lock();
        try {
            if (!this.isConnected() && !this.zzpB()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.zzahT.containsKey(api.zzoR())) {
                ConnectionResult connectionResult = this.zzahM.getConnectionResult(api);
                if (connectionResult == null) {
                    if (this.zzpB()) {
                        ConnectionResult connectionResult2 = ConnectionResult.zzafB;
                        return connectionResult2;
                    }
                    Log.i((String)"GoogleApiClientImpl", (String)this.zzpH());
                    Log.wtf((String)"GoogleApiClientImpl", (String)(api.getName() + " requested in getConnectionResult" + " is not connected but is not present in the failed " + " connections map"), (Throwable)new Exception());
                    ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                    return connectionResult3;
                }
                ConnectionResult connectionResult4 = connectionResult;
                return connectionResult4;
            }
            throw new IllegalArgumentException(api.getName() + " was never registered with GoogleApiClient");
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.zzXG.lock();
        try {
            if (this.zzagp >= 0) {
                com.google.android.gms.common.internal.zzx.zza(this.zzahZ != null, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzahZ == null) {
                this.zzahZ = zzj.zza(this.zzahT.values(), false);
            } else if (this.zzahZ == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.zzahZ);
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(int signInMode) {
        this.zzXG.lock();
        try {
            com.google.android.gms.common.internal.zzx.zzb(signInMode == 3 || signInMode == 1 || signInMode == 2, (Object)("Illegal sign-in mode: " + signInMode));
            this.zzbB(signInMode);
            this.zzpC();
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect() {
        com.google.android.gms.common.internal.zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        this.zzXG.lock();
        try {
            if (this.zzagp >= 0) {
                com.google.android.gms.common.internal.zzx.zza(this.zzahZ != null, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.zzahZ == null) {
                this.zzahZ = zzj.zza(this.zzahT.values(), false);
            } else if (this.zzahZ == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbB(this.zzahZ);
            this.zzahL.zzqR();
            ConnectionResult connectionResult = this.zzahM.blockingConnect();
            return connectionResult;
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long timeout, @NonNull TimeUnit unit) {
        com.google.android.gms.common.internal.zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"blockingConnect must not be called on the UI thread");
        com.google.android.gms.common.internal.zzx.zzb(unit, (Object)"TimeUnit must not be null");
        this.zzXG.lock();
        try {
            if (this.zzahZ == null) {
                this.zzahZ = zzj.zza(this.zzahT.values(), false);
            } else if (this.zzahZ == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzbB(this.zzahZ);
            this.zzahL.zzqR();
            ConnectionResult connectionResult = this.zzahM.blockingConnect(timeout, unit);
            return connectionResult;
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzXG.lock();
        try {
            boolean bl = this.zzahM != null && !this.zzahM.disconnect();
            this.zzaa(bl);
            for (zzq<?> object : this.zzahV) {
                object.clear();
            }
            this.zzahV.clear();
            for (zze zze2 : this.zzahN) {
                zze2.zza(null);
                zze2.cancel();
            }
            this.zzahN.clear();
            if (this.zzahM == null) {
                return;
            }
            this.zzpF();
            this.zzahL.zzqQ();
        }
        finally {
            this.zzXG.unlock();
        }
    }

    void zzaa(boolean bl) {
        for (zze<?> zze2 : this.zzahW) {
            if (zze2.zzpa() == null) {
                if (bl) {
                    zze2.zzpg();
                    continue;
                }
                zze2.cancel();
                this.zzahW.remove(zze2);
                continue;
            }
            zze2.zzpe();
            IBinder iBinder = this.zza(zze2.zzoR()).zzoT();
            zzj.zza(zze2, this.zzahX, iBinder);
            this.zzahW.remove(zze2);
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        com.google.android.gms.common.internal.zzx.zza(this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        com.google.android.gms.common.internal.zzx.zza(this.zzahZ != 2, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        final zzv zzv2 = new zzv(this);
        if (this.zzahT.containsKey(zzmf.zzUI)) {
            this.zza(this, zzv2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle connectionHint) {
                    zzj.this.zza((GoogleApiClient)atomicReference.get(), zzv2, true);
                }

                @Override
                public void onConnectionSuspended(int cause) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(@NonNull ConnectionResult result) {
                    zzv2.zza(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzmf.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.zzahR).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzv2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzv zzv2, final boolean bl) {
        zzmf.zzamA.zzf(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzp(@NonNull Status status) {
                com.google.android.gms.auth.api.signin.internal.zzq.zzaf(zzj.this.mContext).zznr();
                if (status.isSuccess() && zzj.this.isConnected()) {
                    zzj.this.reconnect();
                }
                zzv2.zza(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            @Override
            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public void stopAutoManage(final @NonNull FragmentActivity lifecycleActivity) {
        if (this.zzagp >= 0) {
            zzw zzw2 = zzw.zza(lifecycleActivity);
            if (zzw2 == null) {
                Handler handler = new Handler(this.mContext.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (lifecycleActivity.isFinishing() || lifecycleActivity.getSupportFragmentManager().isDestroyed()) {
                            return;
                        }
                        zzw.zzb(lifecycleActivity).zzbD(zzj.this.zzagp);
                    }
                });
            } else {
                zzw2.zzbD(this.zzagp);
            }
        } else {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.zzahM != null && this.zzahM.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.zzahM != null && this.zzahM.isConnecting();
    }

    boolean zzpB() {
        return this.zzahO;
    }

    private void zzbB(int n) {
        if (this.zzahZ == null) {
            this.zzahZ = n;
        } else if (this.zzahZ != n) {
            throw new IllegalStateException("Cannot use sign-in mode: " + zzj.zzbC(n) + ". Mode was already set to " + zzj.zzbC(this.zzahZ));
        }
        if (this.zzahM != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zzb zzb2 : this.zzahT.values()) {
            if (zzb2.zzmE()) {
                bl = true;
            }
            if (!zzb2.zznb()) continue;
            bl2 = true;
        }
        switch (this.zzahZ) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                this.zzahM = new com.google.android.gms.common.api.internal.zzd(this.mContext, this, this.zzXG, this.zzagr, this.zzags, this.zzahT, this.zzahz, this.zzahA, this.zzagt, this.zzahY);
                return;
            }
        }
        this.zzahM = new zzl(this.mContext, this, this.zzXG, this.zzagr, this.zzags, this.zzahT, this.zzahz, this.zzahA, this.zzagt, this.zzahY, this);
    }

    private void zzpC() {
        this.zzahL.zzqR();
        this.zzahM.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resume() {
        this.zzXG.lock();
        try {
            if (this.zzpB()) {
                this.zzpC();
            }
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzpD() {
        this.zzXG.lock();
        try {
            boolean bl = this.zzpF();
            if (bl) {
                this.zzpC();
            }
        }
        finally {
            this.zzXG.unlock();
        }
    }

    void zzpE() {
        if (this.zzpB()) {
            return;
        }
        this.zzahO = true;
        if (this.zzahS == null) {
            this.zzahS = zzn.zza(this.mContext.getApplicationContext(), new zzc(this), this.zzags);
        }
        this.zzahR.sendMessageDelayed(this.zzahR.obtainMessage(1), this.zzahP);
        this.zzahR.sendMessageDelayed(this.zzahR.obtainMessage(2), this.zzahQ);
    }

    boolean zzpF() {
        if (!this.zzpB()) {
            return false;
        }
        this.zzahO = false;
        this.zzahR.removeMessages(2);
        this.zzahR.removeMessages(1);
        if (this.zzahS != null) {
            this.zzahS.unregister();
            this.zzahS = null;
        }
        return true;
    }

    <A extends Api.zzb> void zzb(zze<A> zze2) {
        this.zzahW.add(zze2);
        zze2.zza(this.zzaib);
    }

    @Override
    public void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks listener) {
        this.zzahL.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks listener) {
        return this.zzahL.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks listener) {
        this.zzahL.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzahL.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener listener) {
        return this.zzahL.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener listener) {
        this.zzahL.unregisterConnectionFailedListener(listener);
    }

    @Override
    public void zzi(Bundle bundle) {
        while (!this.zzahN.isEmpty()) {
            this.zzb(this.zzahN.remove());
        }
        this.zzahL.zzk(bundle);
    }

    @Override
    public void zzd(ConnectionResult connectionResult) {
        if (!this.zzags.zzd(this.mContext, connectionResult.getErrorCode())) {
            this.zzpF();
        }
        if (!this.zzpB()) {
            this.zzahL.zzk(connectionResult);
            this.zzahL.zzqQ();
        }
    }

    @Override
    public void zzc(int n, boolean bl) {
        if (n == 1 && !bl) {
            this.zzpE();
        }
        for (zze<?> zze2 : this.zzahW) {
            if (bl) {
                zze2.zzpe();
            }
            zze2.zzx(new Status(8, "The connection to Google Play services was lost"));
        }
        this.zzahW.clear();
        this.zzahL.zzbT(n);
        this.zzahL.zzqQ();
        if (n == 2) {
            this.zzpC();
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzagr;
    }

    @Override
    public boolean zza(zzu zzu2) {
        return this.zzahM != null && this.zzahM.zza(zzu2);
    }

    @Override
    public void zzoW() {
        if (this.zzahM != null) {
            this.zzahM.zzoW();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(zzx zzx2) {
        this.zzXG.lock();
        try {
            if (this.zzaia == null) {
                this.zzaia = new HashSet<zzx>();
            }
            this.zzaia.add(zzx2);
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzb(zzx zzx2) {
        this.zzXG.lock();
        try {
            if (this.zzaia == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.zzaia.remove(zzx2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzpG()) {
                this.zzahM.zzpj();
            }
        }
        finally {
            this.zzXG.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean zzpG() {
        this.zzXG.lock();
        try {
            if (this.zzaia == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !this.zzaia.isEmpty();
            return bl;
        }
        finally {
            this.zzXG.unlock();
        }
    }

    String zzpH() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.append(prefix).append("mContext=").println(this.mContext);
        writer.append(prefix).append("mResuming=").print(this.zzahO);
        writer.append(" mWorkQueue.size()=").print(this.zzahN.size());
        writer.append(" mUnconsumedRunners.size()=").println(this.zzahW.size());
        if (this.zzahM != null) {
            this.zzahM.dump(prefix, fd, writer, args);
        }
    }

    public int getSessionId() {
        return System.identityHashCode(this);
    }

    public static int zza(Iterable<Api.zzb> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zzb zzb2 : iterable) {
            if (zzb2.zzmE()) {
                bl2 = true;
            }
            if (!zzb2.zznb()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zzbC(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    zzj.this.zzpD();
                    break;
                }
                case 2: {
                    zzj.this.resume();
                    break;
                }
                default: {
                    Log.w((String)"GoogleApiClientImpl", (String)("Unknown message id: " + msg.what));
                }
            }
        }
    }

    static class zzc
    extends zzn {
        private WeakReference<zzj> zzail;

        zzc(zzj zzj2) {
            this.zzail = new WeakReference<zzj>(zzj2);
        }

        @Override
        public void zzpJ() {
            zzj zzj2 = (zzj)this.zzail.get();
            if (zzj2 == null) {
                return;
            }
            zzj2.resume();
        }
    }

    private static class zzb
    implements IBinder.DeathRecipient,
    zzd {
        private final WeakReference<zze<?>> zzaii;
        private final WeakReference<com.google.android.gms.common.api.zza> zzaij;
        private final WeakReference<IBinder> zzaik;

        private zzb(zze zze2, com.google.android.gms.common.api.zza zza2, IBinder iBinder) {
            this.zzaij = new WeakReference<com.google.android.gms.common.api.zza>(zza2);
            this.zzaii = new WeakReference<zze>(zze2);
            this.zzaik = new WeakReference<IBinder>(iBinder);
        }

        @Override
        public void zzc(zze<?> zze2) {
            this.zzpI();
        }

        public void binderDied() {
            this.zzpI();
        }

        private void zzpI() {
            zze zze2 = (zze)this.zzaii.get();
            com.google.android.gms.common.api.zza zza2 = (com.google.android.gms.common.api.zza)this.zzaij.get();
            if (zza2 != null && zze2 != null) {
                zza2.remove(zze2.zzpa());
            }
            IBinder iBinder = (IBinder)this.zzaik.get();
            if (this.zzaik != null) {
                iBinder.unlinkToDeath((IBinder.DeathRecipient)this, 0);
            }
        }
    }

    static interface zze<A extends Api.zzb> {
        public void cancel();

        public Api.zzc<A> zzoR();

        public void zzb(A var1) throws DeadObjectException;

        public void zzx(Status var1);

        public void zzw(Status var1);

        public void zza(zzd var1);

        public void zzpe();

        public Integer zzpa();

        public boolean isReady();

        public void zzpg();
    }

    static interface zzd {
        public void zzc(zze<?> var1);
    }
}

