/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.internal.zzn;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class zzw
extends Fragment
implements DialogInterface.OnCancelListener {
    private boolean mStarted;
    private boolean zzaiz;
    private int zzaiA = -1;
    private ConnectionResult zzaiB;
    private final Handler zzaiC = new Handler(Looper.getMainLooper());
    protected zzn zzaiD;
    private final SparseArray<zza> zzaiE = new SparseArray();

    @Nullable
    public static zzw zza(FragmentActivity fragmentActivity) {
        zzw zzw2;
        zzx.zzcD("Must be called from main thread of process");
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        try {
            zzw2 = (zzw)fragmentManager.findFragmentByTag("GmsSupportLifecycleFrag");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag GmsSupportLifecycleFrag is not a SupportLifecycleFragment", classCastException);
        }
        if (zzw2 == null || zzw2.isRemoving()) {
            return null;
        }
        return zzw2;
    }

    public static zzw zzb(FragmentActivity fragmentActivity) {
        zzw zzw2 = zzw.zza(fragmentActivity);
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        if (zzw2 == null) {
            zzw2 = zzw.zzpO();
            if (zzw2 == null) {
                Log.w((String)"GmsSupportLifecycleFrag", (String)"Unable to find connection error message resources (Did you include play-services-base and the proper proguard rules?); error dialogs may be unavailable.");
                zzw2 = new zzw();
            }
            fragmentManager.beginTransaction().add((Fragment)zzw2, "GmsSupportLifecycleFrag").commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return zzw2;
    }

    @Nullable
    private static zzw zzpO() {
        zzw zzw2;
        block6: {
            Class<?> clazz;
            block5: {
                clazz = null;
                zzw2 = null;
                try {
                    clazz = Class.forName("com.google.android.gms.common.api.internal.SupportLifecycleFragmentImpl");
                }
                catch (ClassNotFoundException | LinkageError | SecurityException throwable) {
                    if (!Log.isLoggable((String)"GmsSupportLifecycleFrag", (int)3)) break block5;
                    Log.d((String)"GmsSupportLifecycleFrag", (String)"Unable to find SupportLifecycleFragmentImpl class", (Throwable)throwable);
                }
            }
            if (clazz != null) {
                try {
                    zzw2 = (zzw)((Object)clazz.newInstance());
                }
                catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | RuntimeException throwable) {
                    if (!Log.isLoggable((String)"GmsSupportLifecycleFrag", (int)3)) break block6;
                    Log.d((String)"GmsSupportLifecycleFrag", (String)"Unable to instantiate SupportLifecycleFragmentImpl class", (Throwable)throwable);
                }
            }
        }
        return zzw2;
    }

    public void zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzx.zzb(googleApiClient, (Object)"GoogleApiClient instance cannot be null");
        zzx.zza(this.zzaiE.indexOfKey(n) < 0, (Object)("Already managing a GoogleApiClient with id " + n));
        zza zza2 = new zza(n, googleApiClient, onConnectionFailedListener);
        this.zzaiE.put(n, (Object)zza2);
        if (this.mStarted && !this.zzaiz) {
            googleApiClient.connect();
        }
    }

    public void zzbD(int n) {
        zza zza2 = (zza)this.zzaiE.get(n);
        this.zzaiE.remove(n);
        if (zza2 != null) {
            zza2.zzpR();
        }
    }

    public void onCancel(DialogInterface dialogInterface) {
        this.zza(this.zzaiA, new ConnectionResult(13, null));
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.zzaiz = savedInstanceState.getBoolean("resolving_error", false);
            this.zzaiA = savedInstanceState.getInt("failed_client_id", -1);
            if (this.zzaiA >= 0) {
                this.zzaiB = new ConnectionResult(savedInstanceState.getInt("failed_status"), (PendingIntent)savedInstanceState.getParcelable("failed_resolution"));
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("resolving_error", this.zzaiz);
        if (this.zzaiA >= 0) {
            outState.putInt("failed_client_id", this.zzaiA);
            outState.putInt("failed_status", this.zzaiB.getErrorCode());
            outState.putParcelable("failed_resolution", (Parcelable)this.zzaiB.getResolution());
        }
    }

    public void onStart() {
        super.onStart();
        this.mStarted = true;
        if (!this.zzaiz) {
            for (int i = 0; i < this.zzaiE.size(); ++i) {
                zza zza2 = (zza)this.zzaiE.valueAt(i);
                zza2.zzaiG.connect();
            }
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        boolean bl = false;
        switch (requestCode) {
            case 2: {
                if (this.zzpQ().isGooglePlayServicesAvailable((Context)this.getActivity()) != 0) break;
                bl = true;
                break;
            }
            case 1: {
                if (resultCode == -1) {
                    bl = true;
                    break;
                }
                if (resultCode != 0) break;
                this.zzaiB = new ConnectionResult(13, null);
            }
        }
        if (bl) {
            this.zzpP();
        } else {
            this.zza(this.zzaiA, this.zzaiB);
        }
    }

    public void onStop() {
        super.onStop();
        this.mStarted = false;
        for (int i = 0; i < this.zzaiE.size(); ++i) {
            zza zza2 = (zza)this.zzaiE.valueAt(i);
            zza2.zzaiG.disconnect();
        }
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        super.dump(prefix, fd, writer, args);
        for (int i = 0; i < this.zzaiE.size(); ++i) {
            zza zza2 = (zza)this.zzaiE.valueAt(i);
            zza2.dump(prefix, fd, writer, args);
        }
    }

    private void zza(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFrag", (String)"Unresolved error while connecting client. Stopping auto-manage.");
        zza zza2 = (zza)this.zzaiE.get(n);
        if (zza2 != null) {
            this.zzbD(n);
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = zza2.zzaiH;
            if (onConnectionFailedListener != null) {
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
        this.zzpP();
    }

    protected void zzpP() {
        this.zzaiz = false;
        this.zzaiA = -1;
        this.zzaiB = null;
        if (this.zzaiD != null) {
            this.zzaiD.unregister();
            this.zzaiD = null;
        }
        for (int i = 0; i < this.zzaiE.size(); ++i) {
            zza zza2 = (zza)this.zzaiE.valueAt(i);
            zza2.zzaiG.connect();
        }
    }

    private static String zzi(ConnectionResult connectionResult) {
        return connectionResult.getErrorMessage() + " (" + connectionResult.getErrorCode() + ": " + zze.getErrorString(connectionResult.getErrorCode()) + ')';
    }

    protected zzc zzpQ() {
        return zzc.zzoK();
    }

    protected void zzb(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFrag", (String)("Failed to connect due to user resolvable error " + zzw.zzi(connectionResult)));
        this.zza(n, connectionResult);
    }

    protected void zzc(int n, ConnectionResult connectionResult) {
        Log.w((String)"GmsSupportLifecycleFrag", (String)"Unable to connect, GooglePlayServices is updating.");
        this.zza(n, connectionResult);
    }

    private class zza
    implements GoogleApiClient.OnConnectionFailedListener {
        public final int zzaiF;
        public final GoogleApiClient zzaiG;
        public final GoogleApiClient.OnConnectionFailedListener zzaiH;

        public zza(int n, GoogleApiClient googleApiClient, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            this.zzaiF = n;
            this.zzaiG = googleApiClient;
            this.zzaiH = onConnectionFailedListener;
            googleApiClient.registerConnectionFailedListener(this);
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult result) {
            zzw.this.zzaiC.post((Runnable)new zzb(this.zzaiF, result));
        }

        public void zzpR() {
            this.zzaiG.unregisterConnectionFailedListener(this);
            this.zzaiG.disconnect();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.append(prefix).append("GoogleApiClient #").print(this.zzaiF);
            writer.println(":");
            this.zzaiG.dump(prefix + "  ", fd, writer, args);
        }
    }

    private class zzb
    implements Runnable {
        private final int zzaiJ;
        private final ConnectionResult zzaiK;

        public zzb(int n, ConnectionResult connectionResult) {
            this.zzaiJ = n;
            this.zzaiK = connectionResult;
        }

        @Override
        @MainThread
        public void run() {
            if (!zzw.this.mStarted || zzw.this.zzaiz) {
                return;
            }
            zzw.this.zzaiz = true;
            zzw.this.zzaiA = this.zzaiJ;
            zzw.this.zzaiB = this.zzaiK;
            if (this.zzaiK.hasResolution()) {
                try {
                    int n = zzw.this.getActivity().getSupportFragmentManager().getFragments().indexOf((Object)zzw.this);
                    int n2 = 1 + (1 + n << 16);
                    this.zzaiK.startResolutionForResult((Activity)zzw.this.getActivity(), n2);
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    zzw.this.zzpP();
                }
            } else if (zzw.this.zzpQ().isUserResolvableError(this.zzaiK.getErrorCode())) {
                zzw.this.zzb(this.zzaiJ, this.zzaiK);
            } else if (this.zzaiK.getErrorCode() == 18) {
                zzw.this.zzc(this.zzaiJ, this.zzaiK);
            } else {
                zzw.this.zza(this.zzaiJ, this.zzaiK);
            }
        }
    }
}

