/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.PowerManager;
import android.os.WorkSource;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzd;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzg;
import com.google.android.gms.common.stats.zzi;
import com.google.android.gms.internal.zzlz;
import com.google.android.gms.internal.zzne;
import com.google.android.gms.internal.zzni;
import com.google.android.gms.internal.zznj;

public class zzrp {
    private static String TAG = "WakeLock";
    private static String zzbhl = "*gcore*:";
    private static boolean DEBUG = false;
    private final PowerManager.WakeLock zzbhm;
    private WorkSource zzbhn;
    private final int zzbho;
    private final String zzanQ;
    private final String zzbhp;
    private final Context mContext;
    private boolean zzbhq = true;
    private int zzbhr;
    private int zzbhs;

    @SuppressLint(value={"UnwrappedWakeLock"})
    public zzrp(Context context, int n, String string, String string2, String string3) {
        zzx.zzh(string, "Wake lock name can NOT be empty");
        this.zzbho = n;
        this.zzbhp = string2;
        this.mContext = context.getApplicationContext();
        this.zzanQ = !zzni.zzcV(string3) && "com.google.android.gms" != string3 ? zzbhl + string : string;
        this.zzbhm = ((PowerManager)context.getSystemService("power")).newWakeLock(n, string);
        if (zznj.zzaA(this.mContext)) {
            String string4;
            if (zzni.zzcV(string3)) {
                if (zzd.zzakE && zzlz.isInitialized()) {
                    Log.e((String)TAG, (String)("callingPackage is not supposed to be empty for wakelock " + this.zzanQ + "!"), (Throwable)new IllegalArgumentException());
                    string4 = "com.google.android.gms";
                } else {
                    string4 = context.getPackageName();
                }
            } else {
                string4 = string3;
            }
            this.zzbhn = zznj.zzl(context, string4);
            this.zzc(this.zzbhn);
        }
    }

    public zzrp(Context context, int n, String string) {
        this(context, n, string, null, context == null ? null : context.getPackageName());
    }

    public void acquire(long timeout) {
        if (!zzne.zzsg() && this.zzbhq) {
            Log.wtf((String)TAG, (String)("Do not acquire with timeout on reference counted WakeLocks before ICS. wakelock: " + this.zzanQ));
        }
        this.zzj(null, timeout);
        this.zzbhm.acquire(timeout);
    }

    public void release() {
        this.zzfJ(null);
        this.zzbhm.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzj(String string, long l) {
        boolean bl = this.zzfK(string);
        String string2 = this.zzn(string, bl);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Acquire:\n mWakeLockName: " + this.zzanQ + "\n mSecondaryName: " + this.zzbhp + "\nmReferenceCounted: " + this.zzbhq + "\nreason: " + string + "\nmOpenEventCount" + this.zzbhs + "\nuseWithReason: " + bl + "\ntrackingName: " + string2 + "\ntimeout: " + l));
        }
        zzrp zzrp2 = this;
        synchronized (zzrp2) {
            if (this.zzbhq && (this.zzbhr++ == 0 || bl) || !this.zzbhq && this.zzbhs == 0) {
                zzi.zzrZ().zza(this.mContext, zzg.zza(this.zzbhm, string2), 7, this.zzanQ, string2, this.zzbho, zznj.zzb(this.zzbhn), l);
                ++this.zzbhs;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzfJ(String string) {
        boolean bl = this.zzfK(string);
        String string2 = this.zzn(string, bl);
        if (DEBUG) {
            Log.d((String)TAG, (String)("Release:\n mWakeLockName: " + this.zzanQ + "\n mSecondaryName: " + this.zzbhp + "\nmReferenceCounted: " + this.zzbhq + "\nreason: " + string + "\n mOpenEventCount" + this.zzbhs + "\nuseWithReason: " + bl + "\ntrackingName: " + string2));
        }
        zzrp zzrp2 = this;
        synchronized (zzrp2) {
            if (this.zzbhq && (--this.zzbhr == 0 || bl) || !this.zzbhq && this.zzbhs == 1) {
                zzi.zzrZ().zza(this.mContext, zzg.zza(this.zzbhm, string2), 8, this.zzanQ, string2, this.zzbho, zznj.zzb(this.zzbhn));
                --this.zzbhs;
            }
        }
    }

    private boolean zzfK(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && !string.equals(this.zzbhp);
    }

    private String zzn(String string, boolean bl) {
        return this.zzbhq ? (bl ? string : this.zzbhp) : this.zzbhp;
    }

    public void setReferenceCounted(boolean value) {
        this.zzbhm.setReferenceCounted(value);
        this.zzbhq = value;
    }

    public boolean isHeld() {
        return this.zzbhm.isHeld();
    }

    public void zzc(WorkSource workSource) {
        if (zznj.zzaA(this.mContext) && workSource != null) {
            if (this.zzbhn != null) {
                this.zzbhn.add(workSource);
            } else {
                this.zzbhn = workSource;
            }
            this.zzbhm.setWorkSource(this.zzbhn);
        }
    }
}

