/*
 * Decompiled with CFR 0.152.
 */
package locus.api.objects.extra;

import java.io.IOException;
import locus.api.objects.GeoData;
import locus.api.objects.extra.ExtraData;
import locus.api.objects.extra.Location;
import locus.api.objects.geocaching.GeocachingData;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;

public class Waypoint
extends GeoData {
    private static final String TAG = "Waypoint";
    private Location loc;
    public GeocachingData gcData;
    public static final String TAG_EXTRA_CALLBACK = "TAG_EXTRA_CALLBACK";
    public static final String TAG_EXTRA_ON_DISPLAY = "TAG_EXTRA_ON_DISPLAY";

    public Waypoint(String name, Location loc) {
        this.setName(name);
        this.loc = loc;
    }

    public Waypoint() {
        this("", new Location(""));
    }

    public Waypoint(DataReaderBigEndian dr) throws IOException {
        super(dr);
    }

    public Waypoint(byte[] data) throws IOException {
        super(data);
    }

    @Override
    protected int getVersion() {
        return 2;
    }

    @Override
    protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
        this.id = dr.readLong();
        this.name = dr.readString();
        this.loc = new Location(dr);
        this.readExtraData(dr);
        this.readStyles(dr);
        this.gcData = Waypoint.readGeocachingData(dr);
        if (version >= 1) {
            this.timeCreated = dr.readLong();
        }
        if (version >= 2) {
            this.setReadWriteMode(GeoData.ReadWriteMode.values()[dr.readInt()]);
        }
    }

    @Override
    protected void writeObject(DataWriterBigEndian dw) throws IOException {
        dw.writeLong(this.id);
        dw.writeString(this.name);
        this.loc.write(dw);
        this.writeExtraData(dw);
        this.writeStyles(dw);
        this.writeGeocachingData(dw);
        dw.writeLong(this.timeCreated);
        dw.writeInt(this.getReadWriteMode().ordinal());
    }

    @Override
    public void reset() {
        this.id = -1L;
        this.name = "";
        this.loc = null;
        this.extraData = null;
        this.styleNormal = null;
        this.styleHighlight = null;
        this.gcData = null;
        this.timeCreated = System.currentTimeMillis();
        this.setReadWriteMode(GeoData.ReadWriteMode.READ_WRITE);
    }

    public static GeocachingData readGeocachingData(DataReaderBigEndian dr) throws IOException {
        if (dr.readBoolean()) {
            return new GeocachingData(dr);
        }
        return null;
    }

    private void writeGeocachingData(DataWriterBigEndian dw) throws IOException {
        if (this.gcData != null) {
            dw.writeBoolean(true);
            this.gcData.write(dw);
        } else {
            dw.writeBoolean(false);
        }
    }

    public Location getLocation() {
        return this.loc;
    }

    public void setLocation(Location loc) {
        if (loc == null) {
            Logger.logW(TAG, "setLocation(null), unable to set invalid Location object");
            return;
        }
        this.loc = loc;
    }

    public String getExtraCallback() {
        if (this.extraData != null) {
            return this.extraData.getParameter(20);
        }
        return null;
    }

    public void setExtraCallback(String btnName, String packageName, String className, String returnDataName, String returnDataValue) {
        String callBack = ExtraData.generateCallbackString(btnName, packageName, className, returnDataName, returnDataValue);
        if (callBack.length() == 0) {
            return;
        }
        StringBuilder b = new StringBuilder();
        b.append(TAG_EXTRA_CALLBACK).append(";");
        b.append(callBack).append(";");
        this.addParameter(20, b.toString());
    }

    public void removeExtraCallback() {
        this.addParameter(20, "clear");
    }

    public String getExtraOnDisplay() {
        if (this.extraData != null) {
            return this.extraData.getParameter(21);
        }
        return null;
    }

    public void setExtraOnDisplay(String packageName, String className, String returnDataName, String returnDataValue) {
        StringBuilder sb = new StringBuilder();
        sb.append(TAG_EXTRA_ON_DISPLAY).append(";");
        sb.append(packageName).append(";");
        sb.append(className).append(";");
        sb.append(returnDataName).append(";");
        sb.append(returnDataValue).append(";");
        this.addParameter(21, sb.toString());
    }

    public void removeExtraOnDisplay() {
        this.addParameter(21, "clear");
    }

    public byte[] getGeocachingData() {
        try {
            DataWriterBigEndian dw = new DataWriterBigEndian();
            this.writeGeocachingData(dw);
            return dw.toByteArray();
        }
        catch (IOException e) {
            Logger.logE(TAG, "getGeocachingData()", e);
            return null;
        }
    }

    public void setGeocachingData(byte[] data) {
        try {
            this.gcData = Waypoint.readGeocachingData(new DataReaderBigEndian(data));
        }
        catch (Exception e) {
            Logger.logE(TAG, "setGeocachingData(" + data + ")", e);
            this.gcData = null;
        }
    }
}

