/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer;

import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.layer.Redrawer;
import org.mapsforge.map.model.DisplayModel;

public abstract class Layer {
    protected DisplayModel displayModel;
    private Redrawer assignedRedrawer;
    private boolean visible = true;

    public abstract void draw(BoundingBox var1, byte var2, Canvas var3, Point var4);

    public LatLong getPosition() {
        return null;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public void onDestroy() {
    }

    public boolean onLongPress(LatLong tapLatLong, Point layerXY, Point tapXY) {
        return false;
    }

    public boolean onTap(LatLong tapLatLong, Point layerXY, Point tapXY) {
        return false;
    }

    public final synchronized void requestRedraw() {
        if (this.assignedRedrawer != null) {
            this.assignedRedrawer.redrawLayers();
        }
    }

    public synchronized DisplayModel getDisplayModel() {
        return this.displayModel;
    }

    public synchronized void setDisplayModel(DisplayModel displayModel) {
        this.displayModel = displayModel;
    }

    public final void setVisible(boolean visible) {
        this.setVisible(visible, true);
    }

    public void setVisible(boolean visible, boolean redraw) {
        this.visible = visible;
        if (redraw) {
            this.requestRedraw();
        }
    }

    protected void onAdd() {
    }

    protected void onRemove() {
    }

    final synchronized void assign(Redrawer redrawer) {
        if (this.assignedRedrawer != null) {
            throw new IllegalStateException("layer already assigned");
        }
        this.assignedRedrawer = redrawer;
        this.onAdd();
    }

    final synchronized void unassign() {
        if (this.assignedRedrawer == null) {
            throw new IllegalStateException("layer is not assigned");
        }
        this.assignedRedrawer = null;
        this.onRemove();
    }
}

