/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer;

import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.layer.Layers;
import org.mapsforge.map.layer.Redrawer;
import org.mapsforge.map.model.MapViewPosition;
import org.mapsforge.map.util.MapPositionUtil;
import org.mapsforge.map.util.PausableThread;
import org.mapsforge.map.view.FrameBuffer;
import org.mapsforge.map.view.MapView;

public class LayerManager
extends PausableThread
implements Redrawer {
    private static final int MILLISECONDS_PER_FRAME = 30;
    private final Canvas drawingCanvas;
    private final Layers layers;
    private final MapView mapView;
    private final MapViewPosition mapViewPosition;
    private boolean redrawNeeded;

    public LayerManager(MapView mapView, MapViewPosition mapViewPosition, GraphicFactory graphicFactory) {
        this.mapView = mapView;
        this.mapViewPosition = mapViewPosition;
        this.drawingCanvas = graphicFactory.createCanvas();
        this.layers = new Layers(this, mapView.getModel().displayModel);
    }

    public Layers getLayers() {
        return this.layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redrawLayers() {
        this.redrawNeeded = true;
        LayerManager layerManager = this;
        synchronized (layerManager) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterRun() {
        Layers layers = this.layers;
        synchronized (layers) {
            for (Layer layer : this.layers) {
                layer.onDestroy();
            }
        }
        this.drawingCanvas.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWork() throws InterruptedException {
        long elapsedMilliseconds;
        long timeSleep;
        long startTime = System.nanoTime();
        this.redrawNeeded = false;
        FrameBuffer frameBuffer = this.mapView.getFrameBuffer();
        Bitmap bitmap = frameBuffer.getDrawingBitmap();
        if (bitmap != null) {
            this.drawingCanvas.setBitmap(bitmap);
            MapPosition mapPosition = this.mapViewPosition.getMapPosition();
            Dimension canvasDimension = this.drawingCanvas.getDimension();
            int tileSize = this.mapView.getModel().displayModel.getTileSize();
            BoundingBox boundingBox = MapPositionUtil.getBoundingBox(mapPosition, canvasDimension, tileSize);
            Point topLeftPoint = MapPositionUtil.getTopLeftPoint(mapPosition, canvasDimension, tileSize);
            Layers layers = this.layers;
            synchronized (layers) {
                for (Layer layer : this.layers) {
                    if (!layer.isVisible()) continue;
                    layer.draw(boundingBox, mapPosition.zoomLevel, this.drawingCanvas, topLeftPoint);
                }
            }
            if (!this.mapViewPosition.animationInProgress()) {
                frameBuffer.frameFinished(mapPosition);
                this.mapView.repaint();
            } else {
                this.redrawNeeded = true;
            }
        }
        if ((timeSleep = 30L - (elapsedMilliseconds = (System.nanoTime() - startTime) / 1000000L)) > 1L && !this.isInterrupted()) {
            LayerManager.sleep(timeSleep);
        }
    }

    @Override
    protected PausableThread.ThreadPriority getThreadPriority() {
        return PausableThread.ThreadPriority.NORMAL;
    }

    @Override
    protected boolean hasWork() {
        return this.redrawNeeded;
    }
}

