/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.cache;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.CorruptedInputStreamException;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.util.IOUtils;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.queue.Job;
import org.mapsforge.map.model.common.Observer;

public class TileStore
implements TileCache {
    private final File rootDirectory;
    private final GraphicFactory graphicFactory;
    private final String suffix;
    private static final Logger LOGGER = Logger.getLogger(TileStore.class.getName());

    public TileStore(File rootDirectory, String suffix, GraphicFactory graphicFactory) {
        this.rootDirectory = rootDirectory;
        this.graphicFactory = graphicFactory;
        this.suffix = suffix;
        if (this.rootDirectory == null || !this.rootDirectory.isDirectory() || !this.rootDirectory.canRead()) {
            throw new IllegalArgumentException("Root directory must be readable");
        }
    }

    @Override
    public synchronized boolean containsKey(Job key) {
        return this.findFile(key) != null;
    }

    @Override
    public synchronized void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public synchronized TileBitmap get(Job key) {
        TileBitmap tileBitmap;
        File file = this.findFile(key);
        if (file == null) {
            return null;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            tileBitmap = this.graphicFactory.createTileBitmap((InputStream)inputStream, key.tile.tileSize, key.hasAlpha);
        }
        catch (CorruptedInputStreamException e) {
            TileBitmap tileBitmap2 = null;
            IOUtils.closeQuietly((Closeable)inputStream);
            return tileBitmap2;
        }
        catch (IOException e2) {
            TileBitmap tileBitmap3 = null;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)inputStream);
            return tileBitmap3;
        }
        IOUtils.closeQuietly((Closeable)inputStream);
        return tileBitmap;
    }

    @Override
    public synchronized int getCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public synchronized int getCapacityFirstLevel() {
        return this.getCapacity();
    }

    @Override
    public TileBitmap getImmediately(Job key) {
        return this.get(key);
    }

    @Override
    public synchronized void purge() {
    }

    @Override
    public synchronized void put(Job key, TileBitmap bitmap) {
    }

    protected File findFile(Job key) {
        File l1 = new File(this.rootDirectory, Byte.toString(key.tile.zoomLevel));
        if (!l1.isDirectory() || !l1.canRead()) {
            LOGGER.info("Failed to find directory " + l1.getAbsolutePath());
            return null;
        }
        File l2 = new File(l1, Long.toString(key.tile.tileX));
        if (!l2.isDirectory() || !l2.canRead()) {
            LOGGER.info("Failed to find directory " + l2.getAbsolutePath());
            return null;
        }
        File l3 = new File(l2, Long.toString(key.tile.tileY) + this.suffix);
        if (!l3.isFile() || !l3.canRead()) {
            LOGGER.info("Failed to find file " + l3.getAbsolutePath());
            return null;
        }
        LOGGER.info("Found file " + l3.getAbsolutePath());
        return l3;
    }

    @Override
    public void setWorkingSet(Set<Job> key) {
    }

    @Override
    public void addObserver(Observer observer) {
    }

    @Override
    public void removeObserver(Observer observer) {
    }
}

