/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.download;

import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.TileLayer;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.download.DownloadJob;
import org.mapsforge.map.layer.download.TileDownloadThread;
import org.mapsforge.map.layer.download.tilesource.TileSource;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.MapViewPosition;
import org.mapsforge.map.model.common.Observer;

public class TileDownloadLayer
extends TileLayer<DownloadJob>
implements Observer {
    private static final int DOWNLOAD_THREADS_MAX = 8;
    private long cacheTimeToLive = 0L;
    private final GraphicFactory graphicFactory;
    private boolean started;
    private final TileCache tileCache;
    private TileDownloadThread[] tileDownloadThreads;
    private final TileSource tileSource;

    public TileDownloadLayer(TileCache tileCache, MapViewPosition mapViewPosition, TileSource tileSource, GraphicFactory graphicFactory) {
        super(tileCache, mapViewPosition, graphicFactory.createMatrix(), tileSource.hasAlpha());
        this.tileCache = tileCache;
        this.tileSource = tileSource;
        this.cacheTimeToLive = tileSource.getDefaultTimeToLive();
        this.graphicFactory = graphicFactory;
    }

    @Override
    public void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        if (zoomLevel < this.tileSource.getZoomLevelMin() || zoomLevel > this.tileSource.getZoomLevelMax()) {
            return;
        }
        super.draw(boundingBox, zoomLevel, canvas, topLeftPoint);
    }

    public long getCacheTimeToLive() {
        return this.cacheTimeToLive;
    }

    @Override
    public void onDestroy() {
        for (TileDownloadThread tileDownloadThread : this.tileDownloadThreads) {
            tileDownloadThread.interrupt();
        }
        super.onDestroy();
    }

    public void onPause() {
        for (TileDownloadThread tileDownloadThread : this.tileDownloadThreads) {
            tileDownloadThread.pause();
        }
    }

    public void onResume() {
        if (!this.started) {
            this.start();
        }
        for (TileDownloadThread tileDownloadThread : this.tileDownloadThreads) {
            tileDownloadThread.proceed();
        }
    }

    public void setCacheTimeToLive(long ttl) {
        this.cacheTimeToLive = ttl;
    }

    @Override
    public synchronized void setDisplayModel(DisplayModel displayModel) {
        block3: {
            block2: {
                super.setDisplayModel(displayModel);
                int numberOfDownloadThreads = Math.min(this.tileSource.getParallelRequestsLimit(), 8);
                if (this.displayModel == null) break block2;
                this.tileDownloadThreads = new TileDownloadThread[numberOfDownloadThreads];
                for (int i = 0; i < numberOfDownloadThreads; ++i) {
                    this.tileDownloadThreads[i] = new TileDownloadThread(this.tileCache, this.jobQueue, this, this.graphicFactory, this.displayModel);
                }
                break block3;
            }
            if (this.tileDownloadThreads == null) break block3;
            for (TileDownloadThread tileDownloadThread : this.tileDownloadThreads) {
                tileDownloadThread.interrupt();
            }
        }
    }

    public void start() {
        for (TileDownloadThread tileDownloadThread : this.tileDownloadThreads) {
            tileDownloadThread.start();
        }
        this.started = true;
    }

    @Override
    protected DownloadJob createJob(Tile tile) {
        return new DownloadJob(tile, this.tileSource);
    }

    @Override
    protected boolean isTileStale(Tile tile, TileBitmap bitmap) {
        if (bitmap.isExpired()) {
            return true;
        }
        return this.cacheTimeToLive != 0L && bitmap.getTimestamp() + this.cacheTimeToLive < System.currentTimeMillis();
    }

    @Override
    protected void onAdd() {
        if (this.tileCache != null) {
            this.tileCache.addObserver(this);
        }
        super.onAdd();
    }

    @Override
    protected void onRemove() {
        if (this.tileCache != null) {
            this.tileCache.removeObserver(this);
        }
        super.onRemove();
    }

    @Override
    public void onChange() {
        this.requestRedraw();
    }
}

